// Persistence of Vision Ray Tracer Include File
// File: Hero.inc
// Vers: 3
// Desc: Object converted to POVRay V2.2 by WCVT2POV V2.6b
//       A huge musclebound figure but sadly without hands, feet or facial
//       features
//       This definition converted from a 3D Studio format, downloaded from
//       3D Cafe
// Date: 25 July 1997
// Auth: Robert Grant (robert@proact.co.uk)

// If you don't declare HeroTexture before including this file then the 
// poor guy will be a simple flesh tone with no finish.

// The object has been scaled and rotated so it is standing with it's head
// in positive Y, it's feet in negative Y, facing positive Z.

// It should extend from +y to -y, +0.524471*x to -0.524471*x and 
// +0.233512*z to -0.233512*z


#ifdef(View_POV_Include_Stack)
#debug "Including Hero.inc\n"
#end
                                           
#ifndef(HeroTexture)
#declare HeroTexture = texture { pigment { color Flesh } }
#end

// This object has the following minimum and maximum values:
// xmin=-255.426586, xmax=255.426586
// ymin=-113.724642, ymax=113.724642
// zmin=-487.017840, zmax=487.017840

#declare HeroScale = 1 / 487.017840

#declare Hero = object {
	union {
		// _calf01
		union {
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 153.270274, -5.661339, -243.483752>,
				< 153.254151, -8.676543, -245.638654>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 153.254151, -8.676543, -245.638654>,
				< 153.224424, -11.096843, -249.228954>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 153.224424, -11.096843, -249.228954>,
				< 153.179258, -12.757394, -254.009753>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 153.179258, -12.757394, -254.009753>,
				< 153.117627, -13.544947, -259.654939>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 153.117627, -13.544947, -259.654939>,
				< 153.040692, -13.405859, -265.779853>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 153.040692, -13.405859, -265.779853>,
				< 152.952284, -12.349632, -271.966696>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 152.952284, -12.349632, -271.966696>,
				< 152.859226, -10.448233, -277.794003>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 152.859226, -10.448233, -277.794003>,
				< 152.770489, -7.831226, -282.864869>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 152.770489, -7.831226, -282.864869>,
				< 152.695999, -4.676954, -286.833912>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 152.695999, -4.676954, -286.833912>,
				< 152.644873, -1.200428, -289.430797>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 152.644873, -1.200428, -289.430797>,
				< 152.623683, 2.361502, -290.478885>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 152.623683, 2.361502, -290.478885>,
				< 152.635291, 5.766062, -289.906919>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 152.635291, 5.766062, -289.906919>,
				< 152.678117, 8.781245, -287.753522>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 152.678117, 8.781245, -287.753522>,
				< 152.746573, 11.201876, -284.165502>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 152.746573, 11.201876, -284.165502>,
				< 152.832136, 12.862407, -279.387176>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 152.832136, 12.862407, -279.387176>,
				< 152.924910, 13.649711, -273.743719>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 152.924910, 13.649711, -273.743719>,
				< 153.015509, 13.510624, -267.619789>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 153.015509, 13.510624, -267.619789>,
				< 153.096393, 12.454418, -261.432439>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 153.096393, 12.454418, -261.432439>,
				< 153.162763, 10.553018, -255.603552>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 153.162763, 10.553018, -255.603552>,
				< 153.212771, 7.935950, -250.530332>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 153.212771, 7.935950, -250.530332>,
				< 153.246865, 4.781698, -246.558949>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 153.246865, 4.781698, -246.558949>,
				< 153.266832, 1.305151, -243.960157>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 153.266832, 1.305151, -243.960157>,
				< 153.274328, -2.256759, -242.911220>
			}
			triangle {
				< 154.212862, 0.052361, -266.718119>,
				< 153.274328, -2.256759, -242.911220>,
				< 153.270274, -5.661339, -243.483752>
			}
			triangle {
				< 153.270274, -5.661339, -243.483752>,
				< 149.652198, -10.985685, -221.800163>,
				< 149.667010, -16.810564, -225.964338>
			}
			triangle {
				< 153.270274, -5.661339, -243.483752>,
				< 149.667010, -16.810564, -225.964338>,
				< 153.254151, -8.676543, -245.638654>
			}
			triangle {
				< 153.254151, -8.676543, -245.638654>,
				< 149.667010, -16.810564, -225.964338>,
				< 149.680883, -21.486253, -232.902184>
			}
			triangle {
				< 153.254151, -8.676543, -245.638654>,
				< 149.680883, -21.486253, -232.902184>,
				< 153.224424, -11.096843, -249.228954>
			}
			triangle {
				< 153.224424, -11.096843, -249.228954>,
				< 149.680883, -21.486253, -232.902184>,
				< 149.678439, -24.694147, -242.140085>
			}
			triangle {
				< 153.224424, -11.096843, -249.228954>,
				< 149.678439, -24.694147, -242.140085>,
				< 153.179258, -12.757394, -254.009753>
			}
			triangle {
				< 153.179258, -12.757394, -254.009753>,
				< 149.678439, -24.694147, -242.140085>,
				< 149.644792, -26.215602, -253.047824>
			}
			triangle {
				< 153.179258, -12.757394, -254.009753>,
				< 149.644792, -26.215602, -253.047824>,
				< 153.117627, -13.544947, -259.654939>
			}
			triangle {
				< 153.117627, -13.544947, -259.654939>,
				< 149.644792, -26.215602, -253.047824>,
				< 149.570569, -25.946915, -264.881223>
			}
			triangle {
				< 153.117627, -13.544947, -259.654939>,
				< 149.570569, -25.946915, -264.881223>,
				< 153.040692, -13.405859, -265.779853>
			}
			triangle {
				< 153.040692, -13.405859, -265.779853>,
				< 149.570569, -25.946915, -264.881223>,
				< 149.455786, -23.906428, -276.833624>
			}
			triangle {
				< 153.040692, -13.405859, -265.779853>,
				< 149.455786, -23.906428, -276.833624>,
				< 152.952284, -12.349632, -271.966696>
			}
			triangle {
				< 152.952284, -12.349632, -271.966696>,
				< 149.455786, -23.906428, -276.833624>,
				< 149.311036, -20.233216, -288.090557>
			}
			triangle {
				< 152.952284, -12.349632, -271.966696>,
				< 149.311036, -20.233216, -288.090557>,
				< 152.859226, -10.448233, -277.794003>
			}
			triangle {
				< 152.859226, -10.448233, -277.794003>,
				< 149.311036, -20.233216, -288.090557>,
				< 149.156198, -15.177570, -297.885388>
			}
			triangle {
				< 152.859226, -10.448233, -277.794003>,
				< 149.156198, -15.177570, -297.885388>,
				< 152.770489, -7.831226, -282.864869>
			}
			triangle {
				< 152.770489, -7.831226, -282.864869>,
				< 149.156198, -15.177570, -297.885388>,
				< 149.016201, -9.084005, -305.551350>
			}
			triangle {
				< 152.770489, -7.831226, -282.864869>,
				< 149.016201, -9.084005, -305.551350>,
				< 152.695999, -4.676954, -286.833912>
			}
			triangle {
				< 152.695999, -4.676954, -286.833912>,
				< 149.016201, -9.084005, -305.551350>,
				< 148.915693, -2.367835, -310.567021>
			}
			triangle {
				< 152.695999, -4.676954, -286.833912>,
				< 148.915693, -2.367835, -310.567021>,
				< 152.644873, -1.200428, -289.430797>
			}
			triangle {
				< 152.644873, -1.200428, -289.430797>,
				< 148.915693, -2.367835, -310.567021>,
				< 148.873121, 4.513294, -312.591225>
			}
			triangle {
				< 152.644873, -1.200428, -289.430797>,
				< 148.873121, 4.513294, -312.591225>,
				< 152.623683, 2.361502, -290.478885>
			}
			triangle {
				< 152.623683, 2.361502, -290.478885>,
				< 148.873121, 4.513294, -312.591225>,
				< 148.896486, 11.090697, -311.486393>
			}
			triangle {
				< 152.623683, 2.361502, -290.478885>,
				< 148.896486, 11.090697, -311.486393>,
				< 152.635291, 5.766062, -289.906919>
			}
			triangle {
				< 152.635291, 5.766062, -289.906919>,
				< 148.896486, 11.090697, -311.486393>,
				< 148.981422, 16.915422, -307.327569>
			}
			triangle {
				< 152.635291, 5.766062, -289.906919>,
				< 148.981422, 16.915422, -307.327569>,
				< 152.678117, 8.781245, -287.753522>
			}
			triangle {
				< 152.678117, 8.781245, -287.753522>,
				< 148.981422, 16.915422, -307.327569>,
				< 149.112120, 21.591000, -300.397664>
			}
			triangle {
				< 152.678117, 8.781245, -287.753522>,
				< 149.112120, 21.591000, -300.397664>,
				< 152.746573, 11.201876, -284.165502>
			}
			triangle {
				< 152.746573, 11.201876, -284.165502>,
				< 149.112120, 21.591000, -300.397664>,
				< 149.265289, 24.798874, -291.167974>
			}
			triangle {
				< 152.746573, 11.201876, -284.165502>,
				< 149.265289, 24.798874, -291.167974>,
				< 152.832136, 12.862407, -279.387176>
			}
			triangle {
				< 152.832136, 12.862407, -279.387176>,
				< 149.265289, 24.798874, -291.167974>,
				< 149.415419, 26.320400, -280.266643>
			}
			triangle {
				< 152.832136, 12.862407, -279.387176>,
				< 149.415419, 26.320400, -280.266643>,
				< 152.924910, 13.649711, -273.743719>
			}
			triangle {
				< 152.924910, 13.649711, -273.743719>,
				< 149.415419, 26.320400, -280.266643>,
				< 149.540633, 26.051663, -268.435955>
			}
			triangle {
				< 152.924910, 13.649711, -273.743719>,
				< 149.540633, 26.051663, -268.435955>,
				< 153.015509, 13.510624, -267.619789>
			}
			triangle {
				< 153.015509, 13.510624, -267.619789>,
				< 149.540633, 26.051663, -268.435955>,
				< 149.627298, 24.011249, -256.482035>
			}
			triangle {
				< 153.015509, 13.510624, -267.619789>,
				< 149.627298, 24.011249, -256.482035>,
				< 153.096393, 12.454418, -261.432439>
			}
			triangle {
				< 153.096393, 12.454418, -261.432439>,
				< 149.627298, 24.011249, -256.482035>,
				< 149.672315, 20.337993, -245.219618>
			}
			triangle {
				< 153.096393, 12.454418, -261.432439>,
				< 149.672315, 20.337993, -245.219618>,
				< 153.162763, 10.553018, -255.603552>
			}
			triangle {
				< 153.162763, 10.553018, -255.603552>,
				< 149.672315, 20.337993, -245.219618>,
				< 149.682581, 15.282313, -235.416964>
			}
			triangle {
				< 153.162763, 10.553018, -255.603552>,
				< 149.682581, 15.282313, -235.416964>,
				< 153.212771, 7.935950, -250.530332>
			}
			triangle {
				< 153.212771, 7.935950, -250.530332>,
				< 149.682581, 15.282313, -235.416964>,
				< 149.671853, 9.188759, -227.742746>
			}
			triangle {
				< 153.212771, 7.935950, -250.530332>,
				< 149.671853, 9.188759, -227.742746>,
				< 153.246865, 4.781698, -246.558949>
			}
			triangle {
				< 153.246865, 4.781698, -246.558949>,
				< 149.671853, 9.188759, -227.742746>,
				< 149.655893, 2.472578, -222.720787>
			}
			triangle {
				< 153.246865, 4.781698, -246.558949>,
				< 149.655893, 2.472578, -222.720787>,
				< 153.266832, 1.305151, -243.960157>
			}
			triangle {
				< 153.266832, 1.305151, -243.960157>,
				< 149.655893, 2.472578, -222.720787>,
				< 149.647459, -4.408550, -220.693797>
			}
			triangle {
				< 153.266832, 1.305151, -243.960157>,
				< 149.647459, -4.408550, -220.693797>,
				< 153.274328, -2.256759, -242.911220>
			}
			triangle {
				< 153.274328, -2.256759, -242.911220>,
				< 149.647459, -4.408550, -220.693797>,
				< 149.652198, -10.985685, -221.800163>
			}
			triangle {
				< 153.274328, -2.256759, -242.911220>,
				< 149.652198, -10.985685, -221.800163>,
				< 153.270274, -5.661339, -243.483752>
			}
			triangle {
				< 149.652198, -10.985685, -221.800163>,
				< 143.476650, -15.557774, -203.187048>,
				< 143.576011, -23.795418, -209.076747>
			}
			triangle {
				< 149.652198, -10.985685, -221.800163>,
				< 143.576011, -23.795418, -209.076747>,
				< 149.667010, -16.810564, -225.964338>
			}
			triangle {
				< 149.667010, -16.810564, -225.964338>,
				< 143.576011, -23.795418, -209.076747>,
				< 143.719986, -30.407872, -218.889296>
			}
			triangle {
				< 149.667010, -16.810564, -225.964338>,
				< 143.719986, -30.407872, -218.889296>,
				< 149.680883, -21.486253, -232.902184>
			}
			triangle {
				< 149.680883, -21.486253, -232.902184>,
				< 143.719986, -30.407872, -218.889296>,
				< 143.869847, -34.944490, -231.954813>
			}
			triangle {
				< 149.680883, -21.486253, -232.902184>,
				< 143.869847, -34.944490, -231.954813>,
				< 149.678439, -24.694147, -242.140085>
			}
			triangle {
				< 149.678439, -24.694147, -242.140085>,
				< 143.869847, -34.944490, -231.954813>,
				< 143.985212, -37.096132, -247.381747>
			}
			triangle {
				< 149.678439, -24.694147, -242.140085>,
				< 143.985212, -37.096132, -247.381747>,
				< 149.644792, -26.215602, -253.047824>
			}
			triangle {
				< 149.644792, -26.215602, -253.047824>,
				< 143.985212, -37.096132, -247.381747>,
				< 144.034997, -36.716163, -264.117628>
			}
			triangle {
				< 149.644792, -26.215602, -253.047824>,
				< 144.034997, -36.716163, -264.117628>,
				< 149.570569, -25.946915, -264.881223>
			}
			triangle {
				< 149.570569, -25.946915, -264.881223>,
				< 144.034997, -36.716163, -264.117628>,
				< 144.005582, -33.830505, -281.021148>
			}
			triangle {
				< 149.570569, -25.946915, -264.881223>,
				< 144.005582, -33.830505, -281.021148>,
				< 149.455786, -23.906428, -276.833624>
			}
			triangle {
				< 149.455786, -23.906428, -276.833624>,
				< 144.005582, -33.830505, -281.021148>,
				< 143.904671, -28.635785, -296.940446>
			}
			triangle {
				< 149.455786, -23.906428, -276.833624>,
				< 143.904671, -28.635785, -296.940446>,
				< 149.311036, -20.233216, -288.090557>
			}
			triangle {
				< 149.311036, -20.233216, -288.090557>,
				< 143.904671, -28.635785, -296.940446>,
				< 143.758997, -21.485999, -310.791403>
			}
			triangle {
				< 149.311036, -20.233216, -288.090557>,
				< 143.758997, -21.485999, -310.791403>,
				< 149.156198, -15.177570, -297.885388>
			}
			triangle {
				< 149.156198, -15.177570, -297.885388>,
				< 143.758997, -21.485999, -310.791403>,
				< 143.607467, -12.868408, -321.631521>
			}
			triangle {
				< 149.156198, -15.177570, -297.885388>,
				< 143.607467, -12.868408, -321.631521>,
				< 149.016201, -9.084005, -305.551350>
			}
			triangle {
				< 149.016201, -9.084005, -305.551350>,
				< 143.607467, -12.868408, -321.631521>,
				< 143.490463, -3.370315, -328.723669>
			}
			triangle {
				< 149.016201, -9.084005, -305.551350>,
				< 143.490463, -3.370315, -328.723669>,
				< 148.915693, -2.367835, -310.567021>
			}
			triangle {
				< 148.915693, -2.367835, -310.567021>,
				< 143.490463, -3.370315, -328.723669>,
				< 143.439248, 6.361050, -331.585824>
			}
			triangle {
				< 148.915693, -2.367835, -310.567021>,
				< 143.439248, 6.361050, -331.585824>,
				< 148.873121, 4.513294, -312.591225>
			}
			triangle {
				< 148.873121, 4.513294, -312.591225>,
				< 143.439248, 6.361050, -331.585824>,
				< 143.467486, 15.662808, -330.023676>
			}
			triangle {
				< 148.873121, 4.513294, -312.591225>,
				< 143.467486, 15.662808, -330.023676>,
				< 148.896486, 11.090697, -311.486393>
			}
			triangle {
				< 148.896486, 11.090697, -311.486393>,
				< 143.467486, 15.662808, -330.023676>,
				< 143.567666, 23.900162, -324.143142>
			}
			triangle {
				< 148.896486, 11.090697, -311.486393>,
				< 143.567666, 23.900162, -324.143142>,
				< 148.981422, 16.915422, -307.327569>
			}
			triangle {
				< 148.981422, 16.915422, -307.327569>,
				< 143.567666, 23.900162, -324.143142>,
				< 143.712997, 30.512607, -314.343929>
			}
			triangle {
				< 148.981422, 16.915422, -307.327569>,
				< 143.712997, 30.512607, -314.343929>,
				< 149.112120, 21.591000, -300.397664>
			}
			triangle {
				< 149.112120, 21.591000, -300.397664>,
				< 143.712997, 30.512607, -314.343929>,
				< 143.864721, 35.049222, -301.292330>
			}
			triangle {
				< 149.112120, 21.591000, -300.397664>,
				< 143.864721, 35.049222, -301.292330>,
				< 149.265289, 24.798874, -291.167974>
			}
			triangle {
				< 149.265289, 24.798874, -291.167974>,
				< 143.864721, 35.049222, -301.292330>,
				< 143.982351, 37.200890, -285.876095>
			}
			triangle {
				< 149.265289, 24.798874, -291.167974>,
				< 143.982351, 37.200890, -285.876095>,
				< 149.415419, 26.320400, -280.266643>
			}
			triangle {
				< 149.415419, 26.320400, -280.266643>,
				< 143.982351, 37.200890, -285.876095>,
				< 144.034639, 36.820933, -269.144922>
			}
			triangle {
				< 149.415419, 26.320400, -280.266643>,
				< 144.034639, 36.820933, -269.144922>,
				< 149.540633, 26.051663, -268.435955>
			}
			triangle {
				< 149.540633, 26.051663, -268.435955>,
				< 144.034639, 36.820933, -269.144922>,
				< 144.007742, 33.935282, -252.238780>
			}
			triangle {
				< 149.540633, 26.051663, -268.435955>,
				< 144.007742, 33.935282, -252.238780>,
				< 149.627298, 24.011249, -256.482035>
			}
			triangle {
				< 149.627298, 24.011249, -256.482035>,
				< 144.007742, 33.935282, -252.238780>,
				< 143.909156, 28.740544, -236.310333>
			}
			triangle {
				< 149.627298, 24.011249, -256.482035>,
				< 143.909156, 28.740544, -236.310333>,
				< 149.672315, 20.337993, -245.219618>
			}
			triangle {
				< 149.672315, 20.337993, -245.219618>,
				< 143.909156, 28.740544, -236.310333>,
				< 143.765494, 21.590753, -222.446010>
			}
			triangle {
				< 149.672315, 20.337993, -245.219618>,
				< 143.765494, 21.590753, -222.446010>,
				< 149.682581, 15.282313, -235.416964>
			}
			triangle {
				< 149.682581, 15.282313, -235.416964>,
				< 143.765494, 21.590753, -222.446010>,
				< 143.615499, 12.973183, -211.592019>
			}
			triangle {
				< 149.682581, 15.282313, -235.416964>,
				< 143.615499, 12.973183, -211.592019>,
				< 149.671853, 9.188759, -227.742746>
			}
			triangle {
				< 149.671853, 9.188759, -227.742746>,
				< 143.615499, 12.973183, -211.592019>,
				< 143.499464, 3.475058, -204.489112>
			}
			triangle {
				< 149.671853, 9.188759, -227.742746>,
				< 143.499464, 3.475058, -204.489112>,
				< 149.655893, 2.472578, -222.720787>
			}
			triangle {
				< 149.655893, 2.472578, -222.720787>,
				< 143.499464, 3.475058, -204.489112>,
				< 143.448621, -6.256306, -201.622248>
			}
			triangle {
				< 149.655893, 2.472578, -222.720787>,
				< 143.448621, -6.256306, -201.622248>,
				< 149.647459, -4.408550, -220.693797>
			}
			triangle {
				< 149.647459, -4.408550, -220.693797>,
				< 143.448621, -6.256306, -201.622248>,
				< 143.476650, -15.557774, -203.187048>
			}
			triangle {
				< 149.647459, -4.408550, -220.693797>,
				< 143.476650, -15.557774, -203.187048>,
				< 149.652198, -10.985685, -221.800163>
			}
			triangle {
				< 143.476650, -15.557774, -203.187048>,
				< 135.162145, -19.066079, -188.971877>,
				< 135.389805, -29.155092, -196.183965>
			}
			triangle {
				< 143.476650, -15.557774, -203.187048>,
				< 135.389805, -29.155092, -196.183965>,
				< 143.576011, -23.795418, -209.076747>
			}
			triangle {
				< 143.576011, -23.795418, -209.076747>,
				< 135.389805, -29.155092, -196.183965>,
				< 135.736793, -37.253633, -208.200023>
			}
			triangle {
				< 143.576011, -23.795418, -209.076747>,
				< 135.736793, -37.253633, -208.200023>,
				< 143.719986, -30.407872, -218.889296>
			}
			triangle {
				< 143.719986, -30.407872, -218.889296>,
				< 135.736793, -37.253633, -208.200023>,
				< 136.136010, -42.809840, -224.199951>
			}
			triangle {
				< 143.719986, -30.407872, -218.889296>,
				< 136.136010, -42.809840, -224.199951>,
				< 143.869847, -34.944490, -231.954813>
			}
			triangle {
				< 143.869847, -34.944490, -231.954813>,
				< 136.136010, -42.809840, -224.199951>,
				< 136.515081, -45.445066, -243.092075>
			}
			triangle {
				< 143.869847, -34.944490, -231.954813>,
				< 136.515081, -45.445066, -243.092075>,
				< 143.985212, -37.096132, -247.381747>
			}
			triangle {
				< 143.985212, -37.096132, -247.381747>,
				< 136.515081, -45.445066, -243.092075>,
				< 136.813194, -44.979680, -263.587654>
			}
			triangle {
				< 143.985212, -37.096132, -247.381747>,
				< 136.813194, -44.979680, -263.587654>,
				< 144.034997, -36.716163, -264.117628>
			}
			triangle {
				< 144.034997, -36.716163, -264.117628>,
				< 136.813194, -44.979680, -263.587654>,
				< 136.994764, -41.445494, -284.288824>
			}
			triangle {
				< 144.034997, -36.716163, -264.117628>,
				< 136.994764, -41.445494, -284.288824>,
				< 144.005582, -33.830505, -281.021148>
			}
			triangle {
				< 144.005582, -33.830505, -281.021148>,
				< 136.994764, -41.445494, -284.288824>,
				< 137.055919, -35.083283, -303.784847>
			}
			triangle {
				< 144.005582, -33.830505, -281.021148>,
				< 137.055919, -35.083283, -303.784847>,
				< 143.904671, -28.635785, -296.940446>
			}
			triangle {
				< 143.904671, -28.635785, -296.940446>,
				< 137.055919, -35.083283, -303.784847>,
				< 137.022391, -26.326643, -320.747793>
			}
			triangle {
				< 143.904671, -28.635785, -296.940446>,
				< 137.022391, -26.326643, -320.747793>,
				< 143.758997, -21.485999, -310.791403>
			}
			triangle {
				< 143.758997, -21.485999, -310.791403>,
				< 137.022391, -26.326643, -320.747793>,
				< 136.939779, -15.772281, -334.023386>
			}
			triangle {
				< 143.758997, -21.485999, -310.791403>,
				< 136.939779, -15.772281, -334.023386>,
				< 143.607467, -12.868408, -321.631521>
			}
			triangle {
				< 143.607467, -12.868408, -321.631521>,
				< 136.939779, -15.772281, -334.023386>,
				< 136.858970, -4.139540, -342.708856>
			}
			triangle {
				< 143.607467, -12.868408, -321.631521>,
				< 136.858970, -4.139540, -342.708856>,
				< 143.490463, -3.370315, -328.723669>
			}
			triangle {
				< 143.490463, -3.370315, -328.723669>,
				< 136.858970, -4.139540, -342.708856>,
				< 136.820361, 7.778910, -346.214056>
			}
			triangle {
				< 143.490463, -3.370315, -328.723669>,
				< 136.820361, 7.778910, -346.214056>,
				< 143.439248, 6.361050, -331.585824>
			}
			triangle {
				< 143.439248, 6.361050, -331.585824>,
				< 136.820361, 7.778910, -346.214056>,
				< 136.841863, 19.171095, -344.300836>
			}
			triangle {
				< 143.439248, 6.361050, -331.585824>,
				< 136.841863, 19.171095, -344.300836>,
				< 143.467486, 15.662808, -330.023676>
			}
			triangle {
				< 143.467486, 15.662808, -330.023676>,
				< 136.841863, 19.171095, -344.300836>,
				< 136.913598, 29.259806, -337.099195>
			}
			triangle {
				< 143.467486, 15.662808, -330.023676>,
				< 136.913598, 29.259806, -337.099195>,
				< 143.567666, 23.900162, -324.143142>
			}
			triangle {
				< 143.567666, 23.900162, -324.143142>,
				< 136.913598, 29.259806, -337.099195>,
				< 137.000769, 37.358362, -325.098455>
			}
			triangle {
				< 143.567666, 23.900162, -324.143142>,
				< 137.000769, 37.358362, -325.098455>,
				< 143.712997, 30.512607, -314.343929>
			}
			triangle {
				< 143.712997, 30.512607, -314.343929>,
				< 137.000769, 37.358362, -325.098455>,
				< 137.054056, 42.914622, -309.114486>
			}
			triangle {
				< 143.712997, 30.512607, -314.343929>,
				< 137.054056, 42.914622, -309.114486>,
				< 143.864721, 35.049222, -301.292330>
			}
			triangle {
				< 143.864721, 35.049222, -301.292330>,
				< 137.054056, 42.914622, -309.114486>,
				< 137.024701, 45.549814, -290.234476>
			}
			triangle {
				< 143.864721, 35.049222, -301.292330>,
				< 137.024701, 45.549814, -290.234476>,
				< 143.982351, 37.200890, -285.876095>
			}
			triangle {
				< 143.982351, 37.200890, -285.876095>,
				< 137.024701, 45.549814, -290.234476>,
				< 136.879727, 45.084488, -269.744337>
			}
			triangle {
				< 143.982351, 37.200890, -285.876095>,
				< 136.879727, 45.084488, -269.744337>,
				< 144.034639, 36.820933, -269.144922>
			}
			triangle {
				< 144.034639, 36.820933, -269.144922>,
				< 136.879727, 45.084488, -269.744337>,
				< 136.613712, 41.550290, -249.040231>
			}
			triangle {
				< 144.034639, 36.820933, -269.144922>,
				< 136.613712, 41.550290, -249.040231>,
				< 144.007742, 33.935282, -252.238780>
			}
			triangle {
				< 144.007742, 33.935282, -252.238780>,
				< 136.613712, 41.550290, -249.040231>,
				< 136.253148, 35.188049, -229.533672>
			}
			triangle {
				< 144.007742, 33.935282, -252.238780>,
				< 136.253148, 35.188049, -229.533672>,
				< 143.909156, 28.740544, -236.310333>
			}
			triangle {
				< 143.909156, 28.740544, -236.310333>,
				< 136.253148, 35.188049, -229.533672>,
				< 135.852575, 26.431413, -212.555438>
			}
			triangle {
				< 143.909156, 28.740544, -236.310333>,
				< 135.852575, 26.431413, -212.555438>,
				< 143.765494, 21.590753, -222.446010>
			}
			triangle {
				< 143.765494, 21.590753, -222.446010>,
				< 135.852575, 26.431413, -212.555438>,
				< 135.482609, 15.877081, -199.264005>
			}
			triangle {
				< 143.765494, 21.590753, -222.446010>,
				< 135.482609, 15.877081, -199.264005>,
				< 143.615499, 12.973183, -211.592019>
			}
			triangle {
				< 143.615499, 12.973183, -211.592019>,
				< 135.482609, 15.877081, -199.264005>,
				< 135.213703, 4.244289, -190.566361>
			}
			triangle {
				< 143.615499, 12.973183, -211.592019>,
				< 135.213703, 4.244289, -190.566361>,
				< 143.499464, 3.475058, -204.489112>
			}
			triangle {
				< 143.499464, 3.475058, -204.489112>,
				< 135.213703, 4.244289, -190.566361>,
				< 135.099187, -7.674146, -187.055737>
			}
			triangle {
				< 143.499464, 3.475058, -204.489112>,
				< 135.099187, -7.674146, -187.055737>,
				< 143.448621, -6.256306, -201.622248>
			}
			triangle {
				< 143.448621, -6.256306, -201.622248>,
				< 135.099187, -7.674146, -187.055737>,
				< 135.162145, -19.066079, -188.971877>
			}
			triangle {
				< 143.448621, -6.256306, -201.622248>,
				< 135.162145, -19.066079, -188.971877>,
				< 143.476650, -15.557774, -203.187048>
			}
			triangle {
				< 135.162145, -19.066079, -188.971877>,
				< 125.400200, -21.271497, -180.180609>,
				< 125.775352, -32.524299, -188.220784>
			}
			triangle {
				< 135.162145, -19.066079, -188.971877>,
				< 125.775352, -32.524299, -188.220784>,
				< 135.389805, -29.155092, -196.183965>
			}
			triangle {
				< 135.389805, -29.155092, -196.183965>,
				< 125.775352, -32.524299, -188.220784>,
				< 126.360148, -41.557051, -201.616988>
			}
			triangle {
				< 135.389805, -29.155092, -196.183965>,
				< 126.360148, -41.557051, -201.616988>,
				< 135.736793, -37.253633, -208.200023>
			}
			triangle {
				< 135.736793, -37.253633, -208.200023>,
				< 126.360148, -41.557051, -201.616988>,
				< 127.060741, -47.754228, -219.455585>
			}
			triangle {
				< 135.736793, -37.253633, -208.200023>,
				< 127.060741, -47.754228, -219.455585>,
				< 136.136010, -42.809840, -224.199951>
			}
			triangle {
				< 136.136010, -42.809840, -224.199951>,
				< 127.060741, -47.754228, -219.455585>,
				< 127.773076, -50.693382, -240.520164>
			}
			triangle {
				< 136.136010, -42.809840, -224.199951>,
				< 127.773076, -50.693382, -240.520164>,
				< 136.515081, -45.445066, -243.092075>
			}
			triangle {
				< 136.515081, -45.445066, -243.092075>,
				< 127.773076, -50.693382, -240.520164>,
				< 128.405154, -50.174378, -263.373852>
			}
			triangle {
				< 136.515081, -45.445066, -243.092075>,
				< 128.405154, -50.174378, -263.373852>,
				< 136.813194, -44.979680, -263.587654>
			}
			triangle {
				< 136.813194, -44.979680, -263.587654>,
				< 128.405154, -50.174378, -263.373852>,
				< 128.894910, -46.232454, -286.458343>
			}
			triangle {
				< 136.813194, -44.979680, -263.587654>,
				< 128.894910, -46.232454, -286.458343>,
				< 136.994764, -41.445494, -284.288824>
			}
			triangle {
				< 136.994764, -41.445494, -284.288824>,
				< 128.894910, -46.232454, -286.458343>,
				< 129.219443, -39.136354, -308.199912>
			}
			triangle {
				< 136.994764, -41.445494, -284.288824>,
				< 129.219443, -39.136354, -308.199912>,
				< 137.055919, -35.083283, -303.784847>
			}
			triangle {
				< 137.055919, -35.083283, -303.784847>,
				< 129.219443, -39.136354, -308.199912>,
				< 129.393891, -29.369581, -327.117443>
			}
			triangle {
				< 137.055919, -35.083283, -303.784847>,
				< 129.393891, -29.369581, -327.117443>,
				< 137.022391, -26.326643, -320.747793>
			}
			triangle {
				< 137.022391, -26.326643, -320.747793>,
				< 129.393891, -29.369581, -327.117443>,
				< 129.460365, -17.597739, -341.923237>
			}
			triangle {
				< 137.022391, -26.326643, -320.747793>,
				< 129.460365, -17.597739, -341.923237>,
				< 136.939779, -15.772281, -334.023386>
			}
			triangle {
				< 136.939779, -15.772281, -334.023386>,
				< 129.460365, -17.597739, -341.923237>,
				< 129.470542, -4.623104, -351.610065>
			}
			triangle {
				< 136.939779, -15.772281, -334.023386>,
				< 129.470542, -4.623104, -351.610065>,
				< 136.858970, -4.139540, -342.708856>
			}
			triangle {
				< 136.858970, -4.139540, -342.708856>,
				< 129.470542, -4.623104, -351.610065>,
				< 129.467189, 8.670211, -355.519384>
			}
			triangle {
				< 136.858970, -4.139540, -342.708856>,
				< 129.467189, 8.670211, -355.519384>,
				< 136.820361, 7.778910, -346.214056>
			}
			triangle {
				< 136.820361, 7.778910, -346.214056>,
				< 129.467189, 8.670211, -355.519384>,
				< 129.469559, 21.376509, -353.385568>
			}
			triangle {
				< 136.820361, 7.778910, -346.214056>,
				< 129.469559, 21.376509, -353.385568>,
				< 136.841863, 19.171095, -344.300836>
			}
			triangle {
				< 136.841863, 19.171095, -344.300836>,
				< 129.469559, 21.376509, -353.385568>,
				< 129.466966, 32.629080, -345.353693>
			}
			triangle {
				< 136.841863, 19.171095, -344.300836>,
				< 129.466966, 32.629080, -345.353693>,
				< 136.913598, 29.259806, -337.099195>
			}
			triangle {
				< 136.913598, 29.259806, -337.099195>,
				< 129.466966, 32.629080, -345.353693>,
				< 129.422456, 41.661862, -331.969619>
			}
			triangle {
				< 136.913598, 29.259806, -337.099195>,
				< 129.422456, 41.661862, -331.969619>,
				< 137.000769, 37.358362, -325.098455>
			}
			triangle {
				< 137.000769, 37.358362, -325.098455>,
				< 129.422456, 41.661862, -331.969619>,
				< 129.285067, 47.858968, -314.143568>
			}
			triangle {
				< 137.000769, 37.358362, -325.098455>,
				< 129.285067, 47.858968, -314.143568>,
				< 137.054056, 42.914622, -309.114486>
			}
			triangle {
				< 137.054056, 42.914622, -309.114486>,
				< 129.285067, 47.858968, -314.143568>,
				< 129.007936, 50.798237, -293.088704>
			}
			triangle {
				< 137.054056, 42.914622, -309.114486>,
				< 129.007936, 50.798237, -293.088704>,
				< 137.024701, 45.549814, -290.234476>
			}
			triangle {
				< 137.024701, 45.549814, -290.234476>,
				< 129.007936, 50.798237, -293.088704>,
				< 128.566444, 50.279174, -270.239294>
			}
			triangle {
				< 137.024701, 45.549814, -290.234476>,
				< 128.566444, 50.279174, -270.239294>,
				< 136.879727, 45.084488, -269.744337>
			}
			triangle {
				< 136.879727, 45.084488, -269.744337>,
				< 128.566444, 50.279174, -270.239294>,
				< 127.971619, 46.337266, -247.152448>
			}
			triangle {
				< 136.879727, 45.084488, -269.744337>,
				< 127.971619, 46.337266, -247.152448>,
				< 136.613712, 41.550290, -249.040231>
			}
			triangle {
				< 136.613712, 41.550290, -249.040231>,
				< 127.971619, 46.337266, -247.152448>,
				< 127.274439, 39.241146, -225.402519>
			}
			triangle {
				< 136.613712, 41.550290, -249.040231>,
				< 127.274439, 39.241146, -225.402519>,
				< 136.253148, 35.188049, -229.533672>
			}
			triangle {
				< 136.253148, 35.188049, -229.533672>,
				< 127.274439, 39.241146, -225.402519>,
				< 126.559705, 29.474370, -206.472918>
			}
			triangle {
				< 136.253148, 35.188049, -229.533672>,
				< 126.559705, 29.474370, -206.472918>,
				< 135.852575, 26.431413, -212.555438>
			}
			triangle {
				< 135.852575, 26.431413, -212.555438>,
				< 126.559705, 29.474370, -206.472918>,
				< 125.930056, 17.702518, -191.654548>
			}
			triangle {
				< 135.852575, 26.431413, -212.555438>,
				< 125.930056, 17.702518, -191.654548>,
				< 135.482609, 15.877081, -199.264005>
			}
			triangle {
				< 135.482609, 15.877081, -199.264005>,
				< 125.930056, 17.702518, -191.654548>,
				< 125.484705, 4.727847, -181.958035>
			}
			triangle {
				< 135.482609, 15.877081, -199.264005>,
				< 125.484705, 4.727847, -181.958035>,
				< 135.213703, 4.244289, -190.566361>
			}
			triangle {
				< 135.213703, 4.244289, -190.566361>,
				< 125.484705, 4.727847, -181.958035>,
				< 125.297472, -8.565446, -178.044468>
			}
			triangle {
				< 135.213703, 4.244289, -190.566361>,
				< 125.297472, -8.565446, -178.044468>,
				< 135.099187, -7.674146, -187.055737>
			}
			triangle {
				< 135.099187, -7.674146, -187.055737>,
				< 125.297472, -8.565446, -178.044468>,
				< 125.400200, -21.271497, -180.180609>
			}
			triangle {
				< 135.099187, -7.674146, -187.055737>,
				< 125.400200, -21.271497, -180.180609>,
				< 135.162145, -19.066079, -188.971877>
			}
			triangle {
				< 125.400200, -21.271497, -180.180609>,
				< 115.075193, -22.023708, -177.448034>,
				< 115.583576, -33.673480, -185.765669>
			}
			triangle {
				< 125.400200, -21.271497, -180.180609>,
				< 115.583576, -33.673480, -185.765669>,
				< 125.775352, -32.524299, -188.220784>
			}
			triangle {
				< 125.775352, -32.524299, -188.220784>,
				< 115.583576, -33.673480, -185.765669>,
				< 116.387449, -43.024871, -199.624658>
			}
			triangle {
				< 125.775352, -32.524299, -188.220784>,
				< 116.387449, -43.024871, -199.624658>,
				< 126.360148, -41.557051, -201.616988>
			}
			triangle {
				< 126.360148, -41.557051, -201.616988>,
				< 116.387449, -43.024871, -199.624658>,
				< 117.374152, -49.440637, -218.080729>
			}
			triangle {
				< 126.360148, -41.557051, -201.616988>,
				< 117.374152, -49.440637, -218.080729>,
				< 127.060741, -47.754228, -219.455585>
			}
			triangle {
				< 127.060741, -47.754228, -219.455585>,
				< 117.374152, -49.440637, -218.080729>,
				< 118.416131, -52.483518, -239.876062>
			}
			triangle {
				< 127.060741, -47.754228, -219.455585>,
				< 118.416131, -52.483518, -239.876062>,
				< 127.773076, -50.693382, -240.520164>
			}
			triangle {
				< 127.773076, -50.693382, -240.520164>,
				< 118.416131, -52.483518, -239.876062>,
				< 119.395755, -51.946193, -263.524622>
			}
			triangle {
				< 127.773076, -50.693382, -240.520164>,
				< 119.395755, -51.946193, -263.524622>,
				< 128.405154, -50.174378, -263.373852>
			}
			triangle {
				< 128.405154, -50.174378, -263.373852>,
				< 119.395755, -51.946193, -263.524622>,
				< 120.225862, -47.865234, -287.414044>
			}
			triangle {
				< 128.405154, -50.174378, -263.373852>,
				< 120.225862, -47.865234, -287.414044>,
				< 128.894910, -46.232454, -286.458343>
			}
			triangle {
				< 128.894910, -46.232454, -286.458343>,
				< 120.225862, -47.865234, -287.414044>,
				< 120.861173, -40.518790, -309.915632>
			}
			triangle {
				< 128.894910, -46.232454, -286.458343>,
				< 120.861173, -40.518790, -309.915632>,
				< 129.219443, -39.136354, -308.199912>
			}
			triangle {
				< 129.219443, -39.136354, -308.199912>,
				< 120.861173, -40.518790, -309.915632>,
				< 121.298321, -30.407481, -329.495847>
			}
			triangle {
				< 129.219443, -39.136354, -308.199912>,
				< 121.298321, -30.407481, -329.495847>,
				< 129.393891, -29.369581, -327.117443>
			}
			triangle {
				< 129.393891, -29.369581, -327.117443>,
				< 121.298321, -30.407481, -329.495847>,
				< 121.565312, -18.220367, -344.821185>
			}
			triangle {
				< 129.393891, -29.369581, -327.117443>,
				< 121.565312, -18.220367, -344.821185>,
				< 129.460365, -17.597739, -341.923237>
			}
			triangle {
				< 129.460365, -17.597739, -341.923237>,
				< 121.565312, -18.220367, -344.821185>,
				< 121.704325, -4.788010, -354.848325>
			}
			triangle {
				< 129.460365, -17.597739, -341.923237>,
				< 121.704325, -4.788010, -354.848325>,
				< 129.470542, -4.623104, -351.610065>
			}
			triangle {
				< 129.470542, -4.623104, -351.610065>,
				< 121.704325, -4.788010, -354.848325>,
				< 121.752433, 8.974205, -358.895123>
			}
			triangle {
				< 129.470542, -4.623104, -351.610065>,
				< 121.752433, 8.974205, -358.895123>,
				< 129.467189, 8.670211, -355.519384>
			}
			triangle {
				< 129.467189, 8.670211, -355.519384>,
				< 121.752433, 8.974205, -358.895123>,
				< 121.726722, 22.128722, -356.686324>
			}
			triangle {
				< 129.467189, 8.670211, -355.519384>,
				< 121.726722, 22.128722, -356.686324>,
				< 129.469559, 21.376509, -353.385568>
			}
			triangle {
				< 129.469559, 21.376509, -353.385568>,
				< 121.726722, 22.128722, -356.686324>,
				< 121.617779, 33.778209, -348.372161>
			}
			triangle {
				< 129.469559, 21.376509, -353.385568>,
				< 121.617779, 33.778209, -348.372161>,
				< 129.466966, 32.629080, -345.353693>
			}
			triangle {
				< 129.466966, 32.629080, -345.353693>,
				< 121.617779, 33.778209, -348.372161>,
				< 121.393077, 43.129630, -334.518194>
			}
			triangle {
				< 129.466966, 32.629080, -345.353693>,
				< 121.393077, 43.129630, -334.518194>,
				< 129.422456, 41.661862, -331.969619>
			}
			triangle {
				< 129.422456, 41.661862, -331.969619>,
				< 121.393077, 43.129630, -334.518194>,
				< 121.010110, 49.545396, -316.067278>
			}
			triangle {
				< 129.422456, 41.661862, -331.969619>,
				< 121.010110, 49.545396, -316.067278>,
				< 129.285067, 47.858968, -314.143568>
			}
			triangle {
				< 129.285067, 47.858968, -314.143568>,
				< 121.010110, 49.545396, -316.067278>,
				< 120.434672, 52.588314, -294.276029>
			}
			triangle {
				< 129.285067, 47.858968, -314.143568>,
				< 120.434672, 52.588314, -294.276029>,
				< 129.007936, 50.798237, -293.088704>
			}
			triangle {
				< 129.007936, 50.798237, -293.088704>,
				< 120.434672, 52.588314, -294.276029>,
				< 119.659357, 52.050963, -270.629287>
			}
			triangle {
				< 129.007936, 50.798237, -293.088704>,
				< 119.659357, 52.050963, -270.629287>,
				< 128.566444, 50.279174, -270.239294>
			}
			triangle {
				< 128.566444, 50.279174, -270.239294>,
				< 119.659357, 52.050963, -270.629287>,
				< 118.716583, 47.970023, -246.738851>
			}
			triangle {
				< 128.566444, 50.279174, -270.239294>,
				< 118.716583, 47.970023, -246.738851>,
				< 127.971619, 46.337266, -247.152448>
			}
			triangle {
				< 127.971619, 46.337266, -247.152448>,
				< 118.716583, 47.970023, -246.738851>,
				< 117.681853, 40.623628, -224.233776>
			}
			triangle {
				< 127.971619, 46.337266, -247.152448>,
				< 117.681853, 40.623628, -224.233776>,
				< 127.274439, 39.241146, -225.402519>
			}
			triangle {
				< 127.274439, 39.241146, -225.402519>,
				< 117.681853, 40.623628, -224.233776>,
				< 116.665520, 30.512253, -204.648495>
			}
			triangle {
				< 127.274439, 39.241146, -225.402519>,
				< 116.665520, 30.512253, -204.648495>,
				< 126.559705, 29.474370, -206.472918>
			}
			triangle {
				< 126.559705, 29.474370, -206.472918>,
				< 116.665520, 30.512253, -204.648495>,
				< 115.794778, 18.325167, -189.317912>
			}
			triangle {
				< 126.559705, 29.474370, -206.472918>,
				< 115.794778, 18.325167, -189.317912>,
				< 125.930056, 17.702518, -191.654548>
			}
			triangle {
				< 125.930056, 17.702518, -191.654548>,
				< 115.794778, 18.325167, -189.317912>,
				< 115.189232, 4.892774, -179.286778>
			}
			triangle {
				< 125.930056, 17.702518, -191.654548>,
				< 115.189232, 4.892774, -179.286778>,
				< 125.484705, 4.727847, -181.958035>
			}
			triangle {
				< 125.484705, 4.727847, -181.958035>,
				< 115.189232, 4.892774, -179.286778>,
				< 114.936851, -8.869440, -175.238177>
			}
			triangle {
				< 125.484705, 4.727847, -181.958035>,
				< 114.936851, -8.869440, -175.238177>,
				< 125.297472, -8.565446, -178.044468>
			}
			triangle {
				< 125.297472, -8.565446, -178.044468>,
				< 114.936851, -8.869440, -175.238177>,
				< 115.075193, -22.023708, -177.448034>
			}
			triangle {
				< 125.297472, -8.565446, -178.044468>,
				< 115.075193, -22.023708, -177.448034>,
				< 125.400200, -21.271497, -180.180609>
			}
			triangle {
				< 115.075193, -22.023708, -177.448034>,
				< 105.144583, -21.271497, -180.962682>,
				< 105.738305, -32.524299, -188.989505>
			}
			triangle {
				< 115.075193, -22.023708, -177.448034>,
				< 105.738305, -32.524299, -188.989505>,
				< 115.583576, -33.673480, -185.765669>
			}
			triangle {
				< 115.583576, -33.673480, -185.765669>,
				< 105.738305, -32.524299, -188.989505>,
				< 106.687285, -41.557051, -202.364564>
			}
			triangle {
				< 115.583576, -33.673480, -185.765669>,
				< 106.687285, -41.557051, -202.364564>,
				< 116.387449, -43.024871, -199.624658>
			}
			triangle {
				< 116.387449, -43.024871, -199.624658>,
				< 106.687285, -41.557051, -202.364564>,
				< 107.872829, -47.754228, -220.177040>
			}
			triangle {
				< 116.387449, -43.024871, -199.624658>,
				< 107.872829, -47.754228, -220.177040>,
				< 117.374152, -49.440637, -218.080729>
			}
			triangle {
				< 117.374152, -49.440637, -218.080729>,
				< 107.872829, -47.754228, -220.177040>,
				< 109.157875, -50.693404, -241.213992>
			}
			triangle {
				< 117.374152, -49.440637, -218.080729>,
				< 109.157875, -50.693404, -241.213992>,
				< 118.416131, -52.483518, -239.876062>
			}
			triangle {
				< 118.416131, -52.483518, -239.876062>,
				< 109.157875, -50.693404, -241.213992>,
				< 110.411346, -50.174382, -264.041513>
			}
			triangle {
				< 118.416131, -52.483518, -239.876062>,
				< 110.411346, -50.174382, -264.041513>,
				< 119.395755, -51.946193, -263.524622>
			}
			triangle {
				< 119.395755, -51.946193, -263.524622>,
				< 110.411346, -50.174382, -264.041513>,
				< 111.528836, -46.232473, -287.103683>
			}
			triangle {
				< 119.395755, -51.946193, -263.524622>,
				< 111.528836, -46.232473, -287.103683>,
				< 120.225862, -47.865234, -287.414044>
			}
			triangle {
				< 120.225862, -47.865234, -287.414044>,
				< 111.528836, -46.232473, -287.103683>,
				< 112.444632, -39.136335, -308.827937>
			}
			triangle {
				< 120.225862, -47.865234, -287.414044>,
				< 112.444632, -39.136335, -308.827937>,
				< 120.861173, -40.518790, -309.915632>
			}
			triangle {
				< 120.861173, -40.518790, -309.915632>,
				< 112.444632, -39.136335, -308.827937>,
				< 113.133609, -29.369589, -327.733368>
			}
			triangle {
				< 120.861173, -40.518790, -309.915632>,
				< 113.133609, -29.369589, -327.733368>,
				< 121.298321, -30.407481, -329.495847>
			}
			triangle {
				< 121.298321, -30.407481, -329.495847>,
				< 113.133609, -29.369589, -327.733368>,
				< 113.602780, -17.597729, -342.531592>
			}
			triangle {
				< 121.298321, -30.407481, -329.495847>,
				< 113.602780, -17.597729, -342.531592>,
				< 121.565312, -18.220367, -344.821185>
			}
			triangle {
				< 121.565312, -18.220367, -344.821185>,
				< 113.602780, -17.597729, -342.531592>,
				< 113.876447, -4.623057, -352.214366>
			}
			triangle {
				< 121.565312, -18.220367, -344.821185>,
				< 113.876447, -4.623057, -352.214366>,
				< 121.704325, -4.788010, -354.848325>
			}
			triangle {
				< 121.704325, -4.788010, -354.848325>,
				< 113.876447, -4.623057, -352.214366>,
				< 113.979429, 8.670211, -356.122285>
			}
			triangle {
				< 121.704325, -4.788010, -354.848325>,
				< 113.979429, 8.670211, -356.122285>,
				< 121.752433, 8.974205, -358.895123>
			}
			triangle {
				< 121.752433, 8.974205, -358.895123>,
				< 113.979429, 8.670211, -356.122285>,
				< 113.923751, 21.376489, -353.989244>
			}
			triangle {
				< 121.752433, 8.974205, -358.895123>,
				< 113.923751, 21.376489, -353.989244>,
				< 121.726722, 22.128722, -356.686324>
			}
			triangle {
				< 121.726722, 22.128722, -356.686324>,
				< 113.923751, 21.376489, -353.989244>,
				< 113.702700, 32.629069, -345.960528>
			}
			triangle {
				< 121.726722, 22.128722, -356.686324>,
				< 113.702700, 32.629069, -345.960528>,
				< 121.617779, 33.778209, -348.372161>
			}
			triangle {
				< 121.617779, 33.778209, -348.372161>,
				< 113.702700, 32.629069, -345.960528>,
				< 113.294132, 41.661799, -332.582802>
			}
			triangle {
				< 121.617779, 33.778209, -348.372161>,
				< 113.294132, 41.661799, -332.582802>,
				< 121.393077, 43.129630, -334.518194>
			}
			triangle {
				< 121.393077, 43.129630, -334.518194>,
				< 113.294132, 41.661799, -332.582802>,
				< 112.671912, 47.858980, -314.767450>
			}
			triangle {
				< 121.393077, 43.129630, -334.518194>,
				< 112.671912, 47.858980, -314.767450>,
				< 121.010110, 49.545396, -316.067278>
			}
			triangle {
				< 121.010110, 49.545396, -316.067278>,
				< 112.671912, 47.858980, -314.767450>,
				< 111.822166, 50.798189, -293.728381>
			}
			triangle {
				< 121.010110, 49.545396, -316.067278>,
				< 111.822166, 50.798189, -293.728381>,
				< 120.434672, 52.588314, -294.276029>
			}
			triangle {
				< 120.434672, 52.588314, -294.276029>,
				< 111.822166, 50.798189, -293.728381>,
				< 110.759318, 50.279163, -270.899862>
			}
			triangle {
				< 120.434672, 52.588314, -294.276029>,
				< 110.759318, 50.279163, -270.899862>,
				< 119.659357, 52.050963, -270.629287>
			}
			triangle {
				< 119.659357, 52.050963, -270.629287>,
				< 110.759318, 50.279163, -270.899862>,
				< 109.536707, 46.337254, -247.838259>
			}
			triangle {
				< 119.659357, 52.050963, -270.629287>,
				< 109.536707, 46.337254, -247.838259>,
				< 118.716583, 47.970023, -246.738851>
			}
			triangle {
				< 118.716583, 47.970023, -246.738851>,
				< 109.536707, 46.337254, -247.838259>,
				< 108.248211, 39.241139, -226.115853>
			}
			triangle {
				< 118.716583, 47.970023, -246.738851>,
				< 108.248211, 39.241139, -226.115853>,
				< 117.681853, 40.623628, -224.233776>
			}
			triangle {
				< 117.681853, 40.623628, -224.233776>,
				< 108.248211, 39.241139, -226.115853>,
				< 107.018836, 29.474370, -207.213074>
			}
			triangle {
				< 117.681853, 40.623628, -224.233776>,
				< 107.018836, 29.474370, -207.213074>,
				< 116.665520, 30.512253, -204.648495>
			}
			triangle {
				< 116.665520, 30.512253, -204.648495>,
				< 107.018836, 29.474370, -207.213074>,
				< 105.986334, 17.702511, -192.417726>
			}
			triangle {
				< 116.665520, 30.512253, -204.648495>,
				< 105.986334, 17.702511, -192.417726>,
				< 115.794778, 18.325167, -189.317912>
			}
			triangle {
				< 115.794778, 18.325167, -189.317912>,
				< 105.986334, 17.702511, -192.417726>,
				< 105.277397, 4.727847, -182.737112>
			}
			triangle {
				< 115.794778, 18.325167, -189.317912>,
				< 105.277397, 4.727847, -182.737112>,
				< 115.189232, 4.892774, -179.286778>
			}
			triangle {
				< 115.189232, 4.892774, -179.286778>,
				< 105.277397, 4.727847, -182.737112>,
				< 104.983792, -8.565426, -178.830177>
			}
			triangle {
				< 115.189232, 4.892774, -179.286778>,
				< 104.983792, -8.565426, -178.830177>,
				< 114.936851, -8.869440, -175.238177>
			}
			triangle {
				< 114.936851, -8.869440, -175.238177>,
				< 104.983792, -8.565426, -178.830177>,
				< 105.144583, -21.271497, -180.962682>
			}
			triangle {
				< 114.936851, -8.869440, -175.238177>,
				< 105.144583, -21.271497, -180.962682>,
				< 115.075193, -22.023708, -177.448034>
			}
			triangle {
				< 105.144583, -21.271497, -180.962682>,
				< 96.505180, -19.066079, -190.453365>,
				< 97.111367, -29.155079, -197.643220>
			}
			triangle {
				< 105.144583, -21.271497, -180.962682>,
				< 97.111367, -29.155079, -197.643220>,
				< 105.738305, -32.524299, -188.989505>
			}
			triangle {
				< 105.738305, -32.524299, -188.989505>,
				< 97.111367, -29.155079, -197.643220>,
				< 98.089062, -37.253641, -209.623873>
			}
			triangle {
				< 105.738305, -32.524299, -188.989505>,
				< 98.089062, -37.253641, -209.623873>,
				< 106.687285, -41.557051, -202.364564>
			}
			triangle {
				< 106.687285, -41.557051, -202.364564>,
				< 98.089062, -37.253641, -209.623873>,
				< 99.328227, -42.809844, -225.580022>
			}
			triangle {
				< 106.687285, -41.557051, -202.364564>,
				< 99.328227, -42.809844, -225.580022>,
				< 107.872829, -47.754228, -220.177040>
			}
			triangle {
				< 107.872829, -47.754228, -220.177040>,
				< 99.328227, -42.809844, -225.580022>,
				< 100.699157, -45.445066, -244.425416>
			}
			triangle {
				< 107.872829, -47.754228, -220.177040>,
				< 100.699157, -45.445066, -244.425416>,
				< 109.157875, -50.693404, -241.213992>
			}
			triangle {
				< 109.157875, -50.693404, -241.213992>,
				< 100.699157, -45.445066, -244.425416>,
				< 102.073476, -44.979699, -264.876157>
			}
			triangle {
				< 109.157875, -50.693404, -241.213992>,
				< 102.073476, -44.979699, -264.876157>,
				< 110.411346, -50.174382, -264.041513>
			}
			triangle {
				< 110.411346, -50.174382, -264.041513>,
				< 102.073476, -44.979699, -264.876157>,
				< 103.342243, -41.445494, -285.538346>
			}
			triangle {
				< 110.411346, -50.174382, -264.041513>,
				< 103.342243, -41.445494, -285.538346>,
				< 111.528836, -46.232473, -287.103683>
			}
			triangle {
				< 111.528836, -46.232473, -287.103683>,
				< 103.342243, -41.445494, -285.538346>,
				< 104.427420, -35.083290, -305.003524>
			}
			triangle {
				< 111.528836, -46.232473, -287.103683>,
				< 104.427420, -35.083290, -305.003524>,
				< 112.444632, -39.136335, -308.827937>
			}
			triangle {
				< 112.444632, -39.136335, -308.827937>,
				< 104.427420, -35.083290, -305.003524>,
				< 105.284974, -26.326643, -321.944177>
			}
			triangle {
				< 112.444632, -39.136335, -308.827937>,
				< 105.284974, -26.326643, -321.944177>,
				< 113.133609, -29.369589, -327.733368>
			}
			triangle {
				< 113.133609, -29.369589, -327.733368>,
				< 105.284974, -26.326643, -321.944177>,
				< 105.899855, -15.772281, -335.205287>
			}
			triangle {
				< 113.133609, -29.369589, -327.733368>,
				< 105.899855, -15.772281, -335.205287>,
				< 113.602780, -17.597729, -342.531592>
			}
			triangle {
				< 113.602780, -17.597729, -342.531592>,
				< 105.899855, -15.772281, -335.205287>,
				< 106.275402, -4.139524, -343.882650>
			}
			triangle {
				< 113.602780, -17.597729, -342.531592>,
				< 106.275402, -4.139524, -343.882650>,
				< 113.876447, -4.623057, -352.214366>
			}
			triangle {
				< 113.876447, -4.623057, -352.214366>,
				< 106.275402, -4.139524, -343.882650>,
				< 106.420994, 7.778910, -347.384900>
			}
			triangle {
				< 113.876447, -4.623057, -352.214366>,
				< 106.420994, 7.778910, -347.384900>,
				< 113.979429, 8.670211, -356.122285>
			}
			triangle {
				< 113.979429, 8.670211, -356.122285>,
				< 106.420994, 7.778910, -347.384900>,
				< 106.341943, 19.171104, -345.473289>
			}
			triangle {
				< 113.979429, 8.670211, -356.122285>,
				< 106.341943, 19.171104, -345.473289>,
				< 113.923751, 21.376489, -353.989244>
			}
			triangle {
				< 113.923751, 21.376489, -353.989244>,
				< 106.341943, 19.171104, -345.473289>,
				< 106.035277, 29.259879, -338.278085>
			}
			triangle {
				< 113.923751, 21.376489, -353.989244>,
				< 106.035277, 29.259879, -338.278085>,
				< 113.702700, 32.629069, -345.960528>
			}
			triangle {
				< 113.702700, 32.629069, -345.960528>,
				< 106.035277, 29.259879, -338.278085>,
				< 105.491921, 37.358392, -326.289773>
			}
			triangle {
				< 113.702700, 32.629069, -345.960528>,
				< 105.491921, 37.358392, -326.289773>,
				< 113.294132, 41.661799, -332.582802>
			}
			triangle {
				< 113.294132, 41.661799, -332.582802>,
				< 105.491921, 37.358392, -326.289773>,
				< 104.705527, 42.914599, -310.325623>
			}
			triangle {
				< 113.294132, 41.661799, -332.582802>,
				< 104.705527, 42.914599, -310.325623>,
				< 112.671912, 47.858980, -314.767450>
			}
			triangle {
				< 112.671912, 47.858980, -314.767450>,
				< 104.705527, 42.914599, -310.325623>,
				< 103.684440, 45.549825, -291.473985>
			}
			triangle {
				< 112.671912, 47.858980, -314.767450>,
				< 103.684440, 45.549825, -291.473985>,
				< 111.822166, 50.798189, -293.728381>
			}
			triangle {
				< 111.822166, 50.798189, -293.728381>,
				< 103.684440, 45.549825, -291.473985>,
				< 102.463350, 45.084525, -271.020621>
			}
			triangle {
				< 111.822166, 50.798189, -293.728381>,
				< 102.463350, 45.084525, -271.020621>,
				< 110.759318, 50.279163, -270.899862>
			}
			triangle {
				< 110.759318, 50.279163, -270.899862>,
				< 102.463350, 45.084525, -271.020621>,
				< 101.110108, 41.550308, -250.359833>
			}
			triangle {
				< 110.759318, 50.279163, -270.899862>,
				< 101.110108, 41.550308, -250.359833>,
				< 109.536707, 46.337254, -247.838259>
			}
			triangle {
				< 109.536707, 46.337254, -247.838259>,
				< 101.110108, 41.550308, -250.359833>,
				< 99.725366, 35.188060, -230.900049>
			}
			triangle {
				< 109.536707, 46.337254, -247.838259>,
				< 99.725366, 35.188060, -230.900049>,
				< 108.248211, 39.241139, -226.115853>
			}
			triangle {
				< 108.248211, 39.241139, -226.115853>,
				< 99.725366, 35.188060, -230.900049>,
				< 98.433487, 26.431404, -213.967040>
			}
			triangle {
				< 108.248211, 39.241139, -226.115853>,
				< 98.433487, 26.431404, -213.967040>,
				< 107.018836, 29.474370, -207.213074>
			}
			triangle {
				< 107.018836, 29.474370, -207.213074>,
				< 98.433487, 26.431404, -213.967040>,
				< 97.365834, 15.877062, -200.713977>
			}
			triangle {
				< 107.018836, 29.474370, -207.213074>,
				< 97.365834, 15.877062, -200.713977>,
				< 105.986334, 17.702511, -192.417726>
			}
			triangle {
				< 105.986334, 17.702511, -192.417726>,
				< 97.365834, 15.877062, -200.713977>,
				< 96.640415, 4.244289, -192.042753>
			}
			triangle {
				< 105.986334, 17.702511, -192.417726>,
				< 96.640415, 4.244289, -192.042753>,
				< 105.277397, 4.727847, -182.737112>
			}
			triangle {
				< 105.277397, 4.727847, -182.737112>,
				< 96.640415, 4.244289, -192.042753>,
				< 96.341655, -7.674146, -188.543260>
			}
			triangle {
				< 105.277397, 4.727847, -182.737112>,
				< 96.341655, -7.674146, -188.543260>,
				< 104.983792, -8.565426, -178.830177>
			}
			triangle {
				< 104.983792, -8.565426, -178.830177>,
				< 96.341655, -7.674146, -188.543260>,
				< 96.505180, -19.066079, -190.453365>
			}
			triangle {
				< 104.983792, -8.565426, -178.830177>,
				< 96.505180, -19.066079, -190.453365>,
				< 105.144583, -21.271497, -180.962682>
			}
			triangle {
				< 96.505180, -19.066079, -190.453365>,
				< 89.872286, -15.557796, -205.219701>,
				< 90.408705, -23.795392, -211.085439>
			}
			triangle {
				< 96.505180, -19.066079, -190.453365>,
				< 90.408705, -23.795392, -211.085439>,
				< 97.111367, -29.155079, -197.643220>
			}
			triangle {
				< 97.111367, -29.155079, -197.643220>,
				< 90.408705, -23.795392, -211.085439>,
				< 91.280870, -30.407846, -220.859557>
			}
			triangle {
				< 97.111367, -29.155079, -197.643220>,
				< 91.280870, -30.407846, -220.859557>,
				< 98.089062, -37.253641, -209.623873>
			}
			triangle {
				< 98.089062, -37.253641, -209.623873>,
				< 91.280870, -30.407846, -220.859557>,
				< 92.400469, -34.944475, -233.877122>
			}
			triangle {
				< 98.089062, -37.253641, -209.623873>,
				< 92.400469, -34.944475, -233.877122>,
				< 99.328227, -42.809844, -225.580022>
			}
			triangle {
				< 99.328227, -42.809844, -225.580022>,
				< 92.400469, -34.944475, -233.877122>,
				< 93.661025, -37.096143, -249.251887>
			}
			triangle {
				< 99.328227, -42.809844, -225.580022>,
				< 93.661025, -37.096143, -249.251887>,
				< 100.699157, -45.445066, -244.425416>
			}
			triangle {
				< 100.699157, -45.445066, -244.425416>,
				< 93.661025, -37.096143, -249.251887>,
				< 94.953381, -36.716186, -265.936852>
			}
			triangle {
				< 100.699157, -45.445066, -244.425416>,
				< 94.953381, -36.716186, -265.936852>,
				< 102.073476, -44.979699, -264.876157>
			}
			triangle {
				< 102.073476, -44.979699, -264.876157>,
				< 94.953381, -36.716186, -265.936852>,
				< 96.179172, -33.830523, -282.794982>
			}
			triangle {
				< 102.073476, -44.979699, -264.876157>,
				< 96.179172, -33.830523, -282.794982>,
				< 103.342243, -41.445494, -285.538346>
			}
			triangle {
				< 103.342243, -41.445494, -285.538346>,
				< 96.179172, -33.830523, -282.794982>,
				< 97.260602, -28.635785, -298.676968>
			}
			triangle {
				< 103.342243, -41.445494, -285.538346>,
				< 97.260602, -28.635785, -298.676968>,
				< 104.427420, -35.083290, -305.003524>
			}
			triangle {
				< 104.427420, -35.083290, -305.003524>,
				< 97.260602, -28.635785, -298.676968>,
				< 98.143838, -21.485996, -312.499791>
			}
			triangle {
				< 104.427420, -35.083290, -305.003524>,
				< 98.143838, -21.485996, -312.499791>,
				< 105.284974, -26.326643, -321.944177>
			}
			triangle {
				< 105.284974, -26.326643, -321.944177>,
				< 98.143838, -21.485996, -312.499791>,
				< 98.797634, -12.868392, -323.320627>
			}
			triangle {
				< 105.284974, -26.326643, -321.944177>,
				< 98.797634, -12.868392, -323.320627>,
				< 105.899855, -15.772281, -335.205287>
			}
			triangle {
				< 105.899855, -15.772281, -335.205287>,
				< 98.797634, -12.868392, -323.320627>,
				< 99.207565, -3.370294, -330.401540>
			}
			triangle {
				< 105.899855, -15.772281, -335.205287>,
				< 99.207565, -3.370294, -330.401540>,
				< 106.275402, -4.139524, -343.882650>
			}
			triangle {
				< 106.275402, -4.139524, -343.882650>,
				< 99.207565, -3.370294, -330.401540>,
				< 99.369012, 6.361070, -333.259523>
			}
			triangle {
				< 106.275402, -4.139524, -343.882650>,
				< 99.369012, 6.361070, -333.259523>,
				< 106.420994, 7.778910, -347.384900>
			}
			triangle {
				< 106.420994, 7.778910, -347.384900>,
				< 99.369012, 6.361070, -333.259523>,
				< 99.281169, 15.662808, -331.699550>
			}
			triangle {
				< 106.420994, 7.778910, -347.384900>,
				< 99.281169, 15.662808, -331.699550>,
				< 106.341943, 19.171104, -345.473289>
			}
			triangle {
				< 106.341943, 19.171104, -345.473289>,
				< 99.281169, 15.662808, -331.699550>,
				< 98.944396, 23.900174, -325.828165>
			}
			triangle {
				< 106.341943, 19.171104, -345.473289>,
				< 98.944396, 23.900174, -325.828165>,
				< 106.035277, 29.259879, -338.278085>
			}
			triangle {
				< 106.035277, 29.259879, -338.278085>,
				< 98.944396, 23.900174, -325.828165>,
				< 98.361731, 30.512627, -316.045702>
			}
			triangle {
				< 106.035277, 29.259879, -338.278085>,
				< 98.361731, 30.512627, -316.045702>,
				< 105.491921, 37.358392, -326.289773>
			}
			triangle {
				< 105.491921, 37.358392, -326.289773>,
				< 98.361731, 30.512627, -316.045702>,
				< 97.543888, 35.049245, -303.019553>
			}
			triangle {
				< 105.491921, 37.358392, -326.289773>,
				< 97.543888, 35.049245, -303.019553>,
				< 104.705527, 42.914599, -310.325623>
			}
			triangle {
				< 104.705527, 42.914599, -310.325623>,
				< 97.543888, 35.049245, -303.019553>,
				< 96.516505, 37.200902, -287.637949>
			}
			triangle {
				< 104.705527, 42.914599, -310.325623>,
				< 96.516505, 37.200902, -287.637949>,
				< 103.684440, 45.549825, -291.473985>
			}
			triangle {
				< 103.684440, 45.549825, -291.473985>,
				< 96.516505, 37.200902, -287.637949>,
				< 95.326297, 36.820944, -270.950139>
			}
			triangle {
				< 103.684440, 45.549825, -291.473985>,
				< 95.326297, 36.820944, -270.950139>,
				< 102.463350, 45.084525, -271.020621>
			}
			triangle {
				< 102.463350, 45.084525, -271.020621>,
				< 95.326297, 36.820944, -270.950139>,
				< 94.044156, 33.935271, -254.093587>
			}
			triangle {
				< 102.463350, 45.084525, -271.020621>,
				< 94.044156, 33.935271, -254.093587>,
				< 101.110108, 41.550308, -250.359833>
			}
			triangle {
				< 101.110108, 41.550308, -250.359833>,
				< 94.044156, 33.935271, -254.093587>,
				< 92.763104, 28.740544, -238.217413>
			}
			triangle {
				< 101.110108, 41.550308, -250.359833>,
				< 92.763104, 28.740544, -238.217413>,
				< 99.725366, 35.188060, -230.900049>
			}
			triangle {
				< 99.725366, 35.188060, -230.900049>,
				< 92.763104, 28.740544, -238.217413>,
				< 91.590375, 21.590764, -224.402860>
			}
			triangle {
				< 99.725366, 35.188060, -230.900049>,
				< 91.590375, 21.590764, -224.402860>,
				< 98.433487, 26.431404, -213.967040>
			}
			triangle {
				< 98.433487, 26.431404, -213.967040>,
				< 91.590375, 21.590764, -224.402860>,
				< 90.634815, 12.973193, -213.590637>
			}
			triangle {
				< 98.433487, 26.431404, -213.967040>,
				< 90.634815, 12.973193, -213.590637>,
				< 97.365834, 15.877062, -200.713977>
			}
			triangle {
				< 97.365834, 15.877062, -200.713977>,
				< 90.634815, 12.973193, -213.590637>,
				< 89.991711, 3.475058, -206.516460>
			}
			triangle {
				< 97.365834, 15.877062, -200.713977>,
				< 89.991711, 3.475058, -206.516460>,
				< 96.640415, 4.244289, -192.042753>
			}
			triangle {
				< 96.640415, 4.244289, -192.042753>,
				< 89.991711, 3.475058, -206.516460>,
				< 89.728147, -6.256306, -203.661457>
			}
			triangle {
				< 96.640415, 4.244289, -192.042753>,
				< 89.728147, -6.256306, -203.661457>,
				< 96.341655, -7.674146, -188.543260>
			}
			triangle {
				< 96.341655, -7.674146, -188.543260>,
				< 89.728147, -6.256306, -203.661457>,
				< 89.872286, -15.557796, -205.219701>
			}
			triangle {
				< 96.341655, -7.674146, -188.543260>,
				< 89.872286, -15.557796, -205.219701>,
				< 96.505180, -19.066079, -190.453365>
			}
			triangle {
				< 89.872286, -15.557796, -205.219701>,
				< 85.697420, -10.985685, -224.198341>,
				< 86.090669, -16.810538, -228.343695>
			}
			triangle {
				< 89.872286, -15.557796, -205.219701>,
				< 86.090669, -16.810538, -228.343695>,
				< 90.408705, -23.795392, -211.085439>
			}
			triangle {
				< 90.408705, -23.795392, -211.085439>,
				< 86.090669, -16.810538, -228.343695>,
				< 86.735114, -21.486253, -235.250950>
			}
			triangle {
				< 90.408705, -23.795392, -211.085439>,
				< 86.735114, -21.486253, -235.250950>,
				< 91.280870, -30.407846, -220.859557>
			}
			triangle {
				< 91.280870, -30.407846, -220.859557>,
				< 86.735114, -21.486253, -235.250950>,
				< 87.572418, -24.694147, -244.450182>
			}
			triangle {
				< 91.280870, -30.407846, -220.859557>,
				< 87.572418, -24.694147, -244.450182>,
				< 92.400469, -34.944475, -233.877122>
			}
			triangle {
				< 92.400469, -34.944475, -233.877122>,
				< 87.572418, -24.694147, -244.450182>,
				< 88.530391, -26.215589, -255.314946>
			}
			triangle {
				< 92.400469, -34.944475, -233.877122>,
				< 88.530391, -26.215589, -255.314946>,
				< 93.661025, -37.096143, -249.251887>
			}
			triangle {
				< 93.661025, -37.096143, -249.251887>,
				< 88.530391, -26.215589, -255.314946>,
				< 89.532144, -25.946936, -267.105252>
			}
			triangle {
				< 93.661025, -37.096143, -249.251887>,
				< 89.532144, -25.946936, -267.105252>,
				< 94.953381, -36.716186, -265.936852>
			}
			triangle {
				< 94.953381, -36.716186, -265.936852>,
				< 89.532144, -25.946936, -267.105252>,
				< 90.504296, -23.906447, -279.017806>
			}
			triangle {
				< 94.953381, -36.716186, -265.936852>,
				< 90.504296, -23.906447, -279.017806>,
				< 96.179172, -33.830523, -282.794982>
			}
			triangle {
				< 96.179172, -33.830523, -282.794982>,
				< 90.504296, -23.906447, -279.017806>,
				< 91.383398, -20.233216, -290.240526>
			}
			triangle {
				< 96.179172, -33.830523, -282.794982>,
				< 91.383398, -20.233216, -290.240526>,
				< 97.260602, -28.635785, -298.676968>
			}
			triangle {
				< 97.260602, -28.635785, -298.676968>,
				< 91.383398, -20.233216, -290.240526>,
				< 92.119530, -15.177554, -300.008267>
			}
			triangle {
				< 97.260602, -28.635785, -298.676968>,
				< 92.119530, -15.177554, -300.008267>,
				< 98.143838, -21.485996, -312.499791>
			}
			triangle {
				< 98.143838, -21.485996, -312.499791>,
				< 92.119530, -15.177554, -300.008267>,
				< 92.676960, -9.084015, -307.654738>
			}
			triangle {
				< 98.143838, -21.485996, -312.499791>,
				< 92.676960, -9.084015, -307.654738>,
				< 98.797634, -12.868392, -323.320627>
			}
			triangle {
				< 98.797634, -12.868392, -323.320627>,
				< 92.676960, -9.084015, -307.654738>,
				< 93.032770, -2.367835, -312.658399>
			}
			triangle {
				< 98.797634, -12.868392, -323.320627>,
				< 93.032770, -2.367835, -312.658399>,
				< 99.207565, -3.370294, -330.401540>
			}
			triangle {
				< 99.207565, -3.370294, -330.401540>,
				< 93.032770, -2.367835, -312.658399>,
				< 93.174383, 4.513294, -314.677924>
			}
			triangle {
				< 99.207565, -3.370294, -330.401540>,
				< 93.174383, 4.513294, -314.677924>,
				< 99.369012, 6.361070, -333.259523>
			}
			triangle {
				< 99.369012, 6.361070, -333.259523>,
				< 93.174383, 4.513294, -314.677924>,
				< 93.097247, 11.090707, -313.575596>
			}
			triangle {
				< 99.369012, 6.361070, -333.259523>,
				< 93.097247, 11.090707, -313.575596>,
				< 99.281169, 15.662808, -331.699550>
			}
			triangle {
				< 99.281169, 15.662808, -331.699550>,
				< 93.097247, 11.090707, -313.575596>,
				< 92.803769, 16.915597, -309.426516>
			}
			triangle {
				< 99.281169, 15.662808, -331.699550>,
				< 92.803769, 16.915597, -309.426516>,
				< 98.944396, 23.900174, -325.828165>
			}
			triangle {
				< 98.944396, 23.900174, -325.828165>,
				< 92.803769, 16.915597, -309.426516>,
				< 92.303999, 21.591011, -302.513868>
			}
			triangle {
				< 98.944396, 23.900174, -325.828165>,
				< 92.303999, 21.591011, -302.513868>,
				< 98.361731, 30.512627, -316.045702>
			}
			triangle {
				< 98.361731, 30.512627, -316.045702>,
				< 92.303999, 21.591011, -302.513868>,
				< 91.617554, 24.798915, -293.309182>
			}
			triangle {
				< 98.361731, 30.512627, -316.045702>,
				< 91.617554, 24.798915, -293.309182>,
				< 97.543888, 35.049245, -303.019553>
			}
			triangle {
				< 97.543888, 35.049245, -303.019553>,
				< 91.617554, 24.798915, -293.309182>,
				< 90.776131, 26.320359, -282.440037>
			}
			triangle {
				< 97.543888, 35.049245, -303.019553>,
				< 90.776131, 26.320359, -282.440037>,
				< 96.516505, 37.200902, -287.637949>
			}
			triangle {
				< 96.516505, 37.200902, -287.637949>,
				< 90.776131, 26.320359, -282.440037>,
				< 89.825414, 26.051685, -270.647734>
			}
			triangle {
				< 96.516505, 37.200902, -287.637949>,
				< 89.825414, 26.051685, -270.647734>,
				< 95.326297, 36.820944, -270.950139>
			}
			triangle {
				< 95.326297, 36.820944, -270.950139>,
				< 89.825414, 26.051685, -270.647734>,
				< 88.825129, 24.011187, -258.736283>
			}
			triangle {
				< 95.326297, 36.820944, -270.950139>,
				< 88.825129, 24.011187, -258.736283>,
				< 94.044156, 33.935271, -254.093587>
			}
			triangle {
				< 94.044156, 33.935271, -254.093587>,
				< 88.825129, 24.011187, -258.736283>,
				< 87.846227, 20.338004, -247.517288>
			}
			triangle {
				< 94.044156, 33.935271, -254.093587>,
				< 87.846227, 20.338004, -247.517288>,
				< 92.763104, 28.740544, -238.217413>
			}
			triangle {
				< 92.763104, 28.740544, -238.217413>,
				< 87.846227, 20.338004, -247.517288>,
				< 86.965427, 15.282324, -237.755001>
			}
			triangle {
				< 92.763104, 28.740544, -238.217413>,
				< 86.965427, 15.282324, -237.755001>,
				< 91.590375, 21.590764, -224.402860>
			}
			triangle {
				< 91.590375, 21.590764, -224.402860>,
				< 86.965427, 15.282324, -237.755001>,
				< 86.257152, 9.188759, -230.114132>
			}
			triangle {
				< 91.590375, 21.590764, -224.402860>,
				< 86.257152, 9.188759, -230.114132>,
				< 90.634815, 12.973193, -213.590637>
			}
			triangle {
				< 90.634815, 12.973193, -213.590637>,
				< 86.257152, 9.188759, -230.114132>,
				< 85.784771, 2.472578, -225.114778>
			}
			triangle {
				< 90.634815, 12.973193, -213.590637>,
				< 85.784771, 2.472578, -225.114778>,
				< 89.991711, 3.475058, -206.516460>
			}
			triangle {
				< 89.991711, 3.475058, -206.516460>,
				< 85.784771, 2.472578, -225.114778>,
				< 85.592099, -4.408550, -223.097101>
			}
			triangle {
				< 89.991711, 3.475058, -206.516460>,
				< 85.592099, -4.408550, -223.097101>,
				< 89.728147, -6.256306, -203.661457>
			}
			triangle {
				< 89.728147, -6.256306, -203.661457>,
				< 85.592099, -4.408550, -223.097101>,
				< 85.697420, -10.985685, -224.198341>
			}
			triangle {
				< 89.728147, -6.256306, -203.661457>,
				< 85.697420, -10.985685, -224.198341>,
				< 89.872286, -15.557796, -205.219701>
			}
			triangle {
				< 85.697420, -10.985685, -224.198341>,
				< 84.137939, -5.661360, -246.053070>,
				< 84.340304, -8.676543, -248.198301>
			}
			triangle {
				< 85.697420, -10.985685, -224.198341>,
				< 84.340304, -8.676543, -248.198301>,
				< 86.090669, -16.810538, -228.343695>
			}
			triangle {
				< 86.090669, -16.810538, -228.343695>,
				< 84.340304, -8.676543, -248.198301>,
				< 84.674634, -11.096864, -251.772910>
			}
			triangle {
				< 86.090669, -16.810538, -228.343695>,
				< 84.674634, -11.096864, -251.772910>,
				< 86.735114, -21.486253, -235.250950>
			}
			triangle {
				< 86.735114, -21.486253, -235.250950>,
				< 84.674634, -11.096864, -251.772910>,
				< 85.114218, -12.757394, -256.533265>
			}
			triangle {
				< 86.735114, -21.486253, -235.250950>,
				< 85.114218, -12.757394, -256.533265>,
				< 87.572418, -24.694147, -244.450182>
			}
			triangle {
				< 87.572418, -24.694147, -244.450182>,
				< 85.114218, -12.757394, -256.533265>,
				< 85.625060, -13.544947, -262.155235>
			}
			triangle {
				< 87.572418, -24.694147, -244.450182>,
				< 85.625060, -13.544947, -262.155235>,
				< 88.530391, -26.215589, -255.314946>
			}
			triangle {
				< 88.530391, -26.215589, -255.314946>,
				< 85.625060, -13.544947, -262.155235>,
				< 86.169265, -13.405880, -268.255860>
			}
			triangle {
				< 88.530391, -26.215589, -255.314946>,
				< 86.169265, -13.405880, -268.255860>,
				< 89.532144, -25.946936, -267.105252>
			}
			triangle {
				< 89.532144, -25.946936, -267.105252>,
				< 86.169265, -13.405880, -268.255860>,
				< 86.708367, -12.349653, -274.419367>
			}
			triangle {
				< 89.532144, -25.946936, -267.105252>,
				< 86.708367, -12.349653, -274.419367>,
				< 90.504296, -23.906447, -279.017806>
			}
			triangle {
				< 90.504296, -23.906447, -279.017806>,
				< 86.708367, -12.349653, -274.419367>,
				< 87.206379, -10.448254, -280.225664>
			}
			triangle {
				< 90.504296, -23.906447, -279.017806>,
				< 87.206379, -10.448254, -280.225664>,
				< 91.383398, -20.233216, -290.240526>
			}
			triangle {
				< 91.383398, -20.233216, -290.240526>,
				< 87.206379, -10.448254, -280.225664>,
				< 87.632030, -7.831226, -285.279006>
			}
			triangle {
				< 91.383398, -20.233216, -290.240526>,
				< 87.632030, -7.831226, -285.279006>,
				< 92.119530, -15.177554, -300.008267>
			}
			triangle {
				< 92.119530, -15.177554, -300.008267>,
				< 87.632030, -7.831226, -285.279006>,
				< 87.960184, -4.676975, -289.234817>
			}
			triangle {
				< 92.119530, -15.177554, -300.008267>,
				< 87.960184, -4.676975, -289.234817>,
				< 92.676960, -9.084015, -307.654738>
			}
			triangle {
				< 92.676960, -9.084015, -307.654738>,
				< 87.960184, -4.676975, -289.234817>,
				< 88.172525, -1.200407, -291.823357>
			}
			triangle {
				< 92.676960, -9.084015, -307.654738>,
				< 88.172525, -1.200407, -291.823357>,
				< 93.032770, -2.367835, -312.658399>
			}
			triangle {
				< 93.032770, -2.367835, -312.658399>,
				< 88.172525, -1.200407, -291.823357>,
				< 88.257678, 2.361523, -292.868137>
			}
			triangle {
				< 93.032770, -2.367835, -312.658399>,
				< 88.257678, 2.361523, -292.868137>,
				< 93.174383, 4.513294, -314.677924>
			}
			triangle {
				< 93.174383, 4.513294, -314.677924>,
				< 88.257678, 2.361523, -292.868137>,
				< 88.211238, 5.766083, -292.297959>
			}
			triangle {
				< 93.174383, 4.513294, -314.677924>,
				< 88.211238, 5.766083, -292.297959>,
				< 93.097247, 11.090707, -313.575596>
			}
			triangle {
				< 93.097247, 11.090707, -313.575596>,
				< 88.211238, 5.766083, -292.297959>,
				< 88.035591, 8.781265, -290.151477>
			}
			triangle {
				< 93.097247, 11.090707, -313.575596>,
				< 88.035591, 8.781265, -290.151477>,
				< 92.803769, 16.915597, -309.426516>
			}
			triangle {
				< 92.803769, 16.915597, -309.426516>,
				< 88.035591, 8.781265, -290.151477>,
				< 87.740064, 11.201908, -286.575317>
			}
			triangle {
				< 92.803769, 16.915597, -309.426516>,
				< 87.740064, 11.201908, -286.575317>,
				< 92.303999, 21.591011, -302.513868>
			}
			triangle {
				< 92.303999, 21.591011, -302.513868>,
				< 87.740064, 11.201908, -286.575317>,
				< 87.340876, 12.862418, -281.813234>
			}
			triangle {
				< 92.303999, 21.591011, -302.513868>,
				< 87.340876, 12.862418, -281.813234>,
				< 91.617554, 24.798915, -293.309182>
			}
			triangle {
				< 91.617554, 24.798915, -293.309182>,
				< 87.340876, 12.862418, -281.813234>,
				< 86.861245, 13.649682, -276.189893>
			}
			triangle {
				< 91.617554, 24.798915, -293.309182>,
				< 86.861245, 13.649682, -276.189893>,
				< 90.776131, 26.320359, -282.440037>
			}
			triangle {
				< 90.776131, 26.320359, -282.440037>,
				< 86.861245, 13.649682, -276.189893>,
				< 86.330727, 13.510675, -270.088732>
			}
			triangle {
				< 90.776131, 26.320359, -282.440037>,
				< 86.330727, 13.510675, -270.088732>,
				< 89.825414, 26.051685, -270.647734>
			}
			triangle {
				< 89.825414, 26.051685, -270.647734>,
				< 86.330727, 13.510675, -270.088732>,
				< 85.784085, 12.454438, -263.925552>
			}
			triangle {
				< 89.825414, 26.051685, -270.647734>,
				< 85.784085, 12.454438, -263.925552>,
				< 88.825129, 24.011187, -258.736283>
			}
			triangle {
				< 88.825129, 24.011187, -258.736283>,
				< 85.784085, 12.454438, -263.925552>,
				< 85.259326, 10.553028, -258.120388>
			}
			triangle {
				< 88.825129, 24.011187, -258.736283>,
				< 85.259326, 10.553028, -258.120388>,
				< 87.846227, 20.338004, -247.517288>
			}
			triangle {
				< 87.846227, 20.338004, -247.517288>,
				< 85.259326, 10.553028, -258.120388>,
				< 84.794916, 7.935970, -253.068686>
			}
			triangle {
				< 87.846227, 20.338004, -247.517288>,
				< 84.794916, 7.935970, -253.068686>,
				< 86.965427, 15.282324, -237.755001>
			}
			triangle {
				< 86.965427, 15.282324, -237.755001>,
				< 84.794916, 7.935970, -253.068686>,
				< 84.426373, 4.781719, -249.114588>
			}
			triangle {
				< 86.965427, 15.282324, -237.755001>,
				< 84.426373, 4.781719, -249.114588>,
				< 86.257152, 9.188759, -230.114132>
			}
			triangle {
				< 86.257152, 9.188759, -230.114132>,
				< 84.426373, 4.781719, -249.114588>,
				< 84.182814, 1.305172, -246.527359>
			}
			triangle {
				< 86.257152, 9.188759, -230.114132>,
				< 84.182814, 1.305172, -246.527359>,
				< 85.784771, 2.472578, -225.114778>
			}
			triangle {
				< 85.784771, 2.472578, -225.114778>,
				< 84.182814, 1.305172, -246.527359>,
				< 84.083945, -2.256759, -245.483086>
			}
			triangle {
				< 85.784771, 2.472578, -225.114778>,
				< 84.083945, -2.256759, -245.483086>,
				< 85.592099, -4.408550, -223.097101>
			}
			triangle {
				< 85.592099, -4.408550, -223.097101>,
				< 84.083945, -2.256759, -245.483086>,
				< 84.137939, -5.661360, -246.053070>
			}
			triangle {
				< 85.592099, -4.408550, -223.097101>,
				< 84.137939, -5.661360, -246.053070>,
				< 85.697420, -10.985685, -224.198341>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 84.083945, -2.256759, -245.483086>,
				< 84.182814, 1.305172, -246.527359>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 84.182814, 1.305172, -246.527359>,
				< 84.426373, 4.781719, -249.114588>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 84.426373, 4.781719, -249.114588>,
				< 84.794916, 7.935970, -253.068686>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 84.794916, 7.935970, -253.068686>,
				< 85.259326, 10.553028, -258.120388>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 85.259326, 10.553028, -258.120388>,
				< 85.784085, 12.454438, -263.925552>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 85.784085, 12.454438, -263.925552>,
				< 86.330727, 13.510675, -270.088732>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 86.330727, 13.510675, -270.088732>,
				< 86.861245, 13.649682, -276.189893>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 86.861245, 13.649682, -276.189893>,
				< 87.340876, 12.862418, -281.813234>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 87.340876, 12.862418, -281.813234>,
				< 87.740064, 11.201908, -286.575317>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 87.740064, 11.201908, -286.575317>,
				< 88.035591, 8.781265, -290.151477>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 88.035591, 8.781265, -290.151477>,
				< 88.211238, 5.766083, -292.297959>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 88.211238, 5.766083, -292.297959>,
				< 88.257678, 2.361523, -292.868137>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 88.257678, 2.361523, -292.868137>,
				< 88.172525, -1.200407, -291.823357>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 88.172525, -1.200407, -291.823357>,
				< 87.960184, -4.676975, -289.234817>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 87.960184, -4.676975, -289.234817>,
				< 87.632030, -7.831226, -285.279006>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 87.632030, -7.831226, -285.279006>,
				< 87.206379, -10.448254, -280.225664>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 87.206379, -10.448254, -280.225664>,
				< 86.708367, -12.349653, -274.419367>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 86.708367, -12.349653, -274.419367>,
				< 86.169265, -13.405880, -268.255860>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 86.169265, -13.405880, -268.255860>,
				< 85.625060, -13.544947, -262.155235>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 85.625060, -13.544947, -262.155235>,
				< 85.114218, -12.757394, -256.533265>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 85.114218, -12.757394, -256.533265>,
				< 84.674634, -11.096864, -251.772910>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 84.674634, -11.096864, -251.772910>,
				< 84.340304, -8.676543, -248.198301>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 84.340304, -8.676543, -248.198301>,
				< 84.137939, -5.661360, -246.053070>
			}
			triangle {
				< 85.081257, 0.052361, -269.277364>,
				< 84.137939, -5.661360, -246.053070>,
				< 84.083945, -2.256759, -245.483086>
			}
			
		}
		// _calf02
		union {
			triangle {
				< 47.250159, -8.676543, -251.237780>,
				< 46.897139, -5.661339, -249.111965>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 47.841173, -11.096843, -254.779249>,
				< 47.250159, -8.676543, -251.237780>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 48.633654, -12.757394, -259.494126>,
				< 47.841173, -11.096843, -254.779249>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 49.577646, -13.544947, -265.060186>,
				< 48.633654, -12.757394, -259.494126>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 50.611783, -13.405859, -271.097630>,
				< 49.577646, -13.544947, -265.060186>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 51.666934, -12.349632, -277.194500>,
				< 50.611783, -13.405859, -271.097630>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 52.670449, -10.448233, -282.935500>,
				< 51.666934, -12.349632, -277.194500>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 53.551376, -7.831226, -287.930042>,
				< 52.670449, -10.448233, -282.935500>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 54.245844, -4.676954, -291.838557>,
				< 53.551376, -7.831226, -287.930042>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 54.702591, -1.200428, -294.395506>,
				< 54.245844, -4.676954, -291.838557>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 54.887459, 2.361502, -295.427352>,
				< 54.702591, -1.200428, -294.395506>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 54.786526, 5.766062, -294.864237>,
				< 54.887459, 2.361502, -295.427352>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 54.407377, 8.781245, -292.744070>,
				< 54.786526, 5.766062, -294.864237>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 53.778455, 11.201576, -289.210916>,
				< 54.407377, 8.781245, -292.744070>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 52.946452, 12.862107, -284.504801>,
				< 53.778455, 11.201576, -289.210916>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 51.971961, 13.649659, -278.945357>,
				< 52.946452, 12.862107, -284.504801>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 50.924473, 13.510603, -272.910982>,
				< 51.971961, 13.649659, -278.945357>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 49.876694, 12.454365, -266.812474>,
				< 50.924473, 13.510603, -272.910982>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 48.899245, 10.552976, -261.065722>,
				< 49.876694, 12.454365, -266.812474>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 48.056245, 7.935950, -256.062776>,
				< 48.899245, 10.552976, -261.065722>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 47.401320, 4.781698, -252.145618>,
				< 48.056245, 7.935950, -256.062776>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 46.975069, 1.305151, -249.581948>,
				< 47.401320, 4.781698, -252.145618>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 46.803582, -2.256759, -248.547092>,
				< 46.975069, 1.305151, -249.581948>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 46.897139, -5.661339, -249.111965>,
				< 46.803582, -2.256759, -248.547092>,
				< 49.600832, 0.052361, -272.207737>
			}
			triangle {
				< 47.715399, -16.810564, -231.244594>,
				< 47.078609, -10.985685, -227.129385>,
				< 46.897139, -5.661339, -249.111965>
			}
			triangle {
				< 47.250159, -8.676543, -251.237780>,
				< 47.715399, -16.810564, -231.244594>,
				< 46.897139, -5.661339, -249.111965>
			}
			triangle {
				< 48.787005, -21.486277, -238.099173>,
				< 47.715399, -16.810564, -231.244594>,
				< 47.250159, -8.676543, -251.237780>
			}
			triangle {
				< 47.841173, -11.096843, -254.779249>,
				< 48.787005, -21.486277, -238.099173>,
				< 47.250159, -8.676543, -251.237780>
			}
			triangle {
				< 50.234560, -24.694173, -247.222960>,
				< 48.787005, -21.486277, -238.099173>,
				< 47.841173, -11.096843, -254.779249>
			}
			triangle {
				< 48.633654, -12.757394, -259.494126>,
				< 50.234560, -24.694173, -247.222960>,
				< 47.841173, -11.096843, -254.779249>
			}
			triangle {
				< 51.974118, -26.215615, -257.991105>,
				< 50.234560, -24.694173, -247.222960>,
				< 48.633654, -12.757394, -259.494126>
			}
			triangle {
				< 49.577646, -13.544947, -265.060186>,
				< 51.974118, -26.215615, -257.991105>,
				< 48.633654, -12.757394, -259.494126>
			}
			triangle {
				< 53.898599, -25.946941, -269.667238>,
				< 51.974118, -26.215615, -257.991105>,
				< 49.577646, -13.544947, -265.060186>
			}
			triangle {
				< 50.611783, -13.405859, -271.097630>,
				< 53.898599, -25.946941, -269.667238>,
				< 49.577646, -13.544947, -265.060186>
			}
			triangle {
				< 55.881761, -23.906453, -281.454533>,
				< 53.898599, -25.946941, -269.667238>,
				< 50.611783, -13.405859, -271.097630>
			}
			triangle {
				< 51.666934, -12.349632, -277.194500>,
				< 55.881761, -23.906453, -281.454533>,
				< 50.611783, -13.405859, -271.097630>
			}
			triangle {
				< 57.785705, -20.233240, -292.550206>,
				< 55.881761, -23.906453, -281.454533>,
				< 51.666934, -12.349632, -277.194500>
			}
			triangle {
				< 52.670449, -10.448233, -282.935500>,
				< 57.785705, -20.233240, -292.550206>,
				< 51.666934, -12.349632, -277.194500>
			}
			triangle {
				< 59.470896, -15.177570, -302.200198>,
				< 57.785705, -20.233240, -292.550206>,
				< 52.670449, -10.448233, -282.935500>
			}
			triangle {
				< 53.551376, -7.831226, -287.930042>,
				< 59.470896, -15.177570, -302.200198>,
				< 52.670449, -10.448233, -282.935500>
			}
			triangle {
				< 60.808402, -9.084015, -309.749931>,
				< 59.470896, -15.177570, -302.200198>,
				< 53.551376, -7.831226, -287.930042>
			}
			triangle {
				< 54.245844, -4.676954, -291.838557>,
				< 60.808402, -9.084015, -309.749931>,
				< 53.551376, -7.831226, -287.930042>
			}
			triangle {
				< 61.692290, -2.367835, -314.688116>,
				< 60.808402, -9.084015, -309.749931>,
				< 54.245844, -4.676954, -291.838557>
			}
			triangle {
				< 54.702591, -1.200428, -294.395506>,
				< 61.692290, -2.367835, -314.688116>,
				< 54.245844, -4.676954, -291.838557>
			}
			triangle {
				< 62.051006, 4.513294, -316.680759>,
				< 61.692290, -2.367835, -314.688116>,
				< 54.702591, -1.200428, -294.395506>
			}
			triangle {
				< 54.887459, 2.361502, -295.427352>,
				< 62.051006, 4.513294, -316.680759>,
				< 54.702591, -1.200428, -294.395506>
			}
			triangle {
				< 61.855085, 11.090397, -315.593153>,
				< 62.051006, 4.513294, -316.680759>,
				< 54.887459, 2.361502, -295.427352>
			}
			triangle {
				< 54.786526, 5.766062, -294.864237>,
				< 61.855085, 11.090397, -315.593153>,
				< 54.887459, 2.361502, -295.427352>
			}
			triangle {
				< 61.120614, 16.915286, -311.498821>,
				< 61.855085, 11.090397, -315.593153>,
				< 54.786526, 5.766062, -294.864237>
			}
			triangle {
				< 54.407377, 8.781245, -292.744070>,
				< 61.120614, 16.915286, -311.498821>,
				< 54.786526, 5.766062, -294.864237>
			}
			triangle {
				< 59.907451, 21.590991, -304.674715>,
				< 61.120614, 16.915286, -311.498821>,
				< 54.407377, 8.781245, -292.744070>
			}
			triangle {
				< 53.778455, 11.201576, -289.210916>,
				< 59.907451, 21.590991, -304.674715>,
				< 54.407377, 8.781245, -292.744070>
			}
			triangle {
				< 58.312304, 24.798874, -295.582622>,
				< 59.907451, 21.590991, -304.674715>,
				< 53.778455, 11.201576, -289.210916>
			}
			triangle {
				< 52.946452, 12.862107, -284.504801>,
				< 58.312304, 24.798874, -295.582622>,
				< 53.778455, 11.201576, -289.210916>
			}
			triangle {
				< 56.458689, 26.320336, -284.838974>,
				< 58.312304, 24.798874, -295.582622>,
				< 52.946452, 12.862107, -284.504801>
			}
			triangle {
				< 51.971961, 13.649659, -278.945357>,
				< 56.458689, 26.320336, -284.838974>,
				< 52.946452, 12.862107, -284.504801>
			}
			triangle {
				< 54.484289, 26.051663, -273.173541>,
				< 56.458689, 26.320336, -284.838974>,
				< 51.971961, 13.649659, -278.945357>
			}
			triangle {
				< 50.924473, 13.510603, -272.910982>,
				< 54.484289, 26.051663, -273.173541>,
				< 51.971961, 13.649659, -278.945357>
			}
			triangle {
				< 52.528664, 24.011187, -261.380315>,
				< 54.484289, 26.051663, -273.173541>,
				< 50.924473, 13.510603, -272.910982>
			}
			triangle {
				< 49.876694, 12.454365, -266.812474>,
				< 52.528664, 24.011187, -261.380315>,
				< 50.924473, 13.510603, -272.910982>
			}
			triangle {
				< 50.722361, 20.337975, -250.263602>,
				< 52.528664, 24.011187, -261.380315>,
				< 49.876694, 12.454365, -266.812474>
			}
			triangle {
				< 48.899245, 10.552976, -261.065722>,
				< 50.722361, 20.337975, -250.263602>,
				< 49.876694, 12.454365, -266.812474>
			}
			triangle {
				< 49.178746, 15.282313, -240.583241>,
				< 50.722361, 20.337975, -250.263602>,
				< 48.899245, 10.552976, -261.065722>
			}
			triangle {
				< 48.056245, 7.935950, -256.062776>,
				< 49.178746, 15.282313, -240.583241>,
				< 48.899245, 10.552976, -261.065722>
			}
			triangle {
				< 47.988832, 9.188759, -233.001858>,
				< 49.178746, 15.282313, -240.583241>,
				< 48.056245, 7.935950, -256.062776>
			}
			triangle {
				< 47.401320, 4.781698, -252.145618>,
				< 47.988832, 9.188759, -233.001858>,
				< 48.056245, 7.935950, -256.062776>
			}
			triangle {
				< 47.218982, 2.472578, -228.039220>,
				< 47.988832, 9.188759, -233.001858>,
				< 47.401320, 4.781698, -252.145618>
			}
			triangle {
				< 46.975069, 1.305151, -249.581948>,
				< 47.218982, 2.472578, -228.039220>,
				< 47.401320, 4.781698, -252.145618>
			}
			triangle {
				< 46.910223, -4.408550, -226.035878>,
				< 47.218982, 2.472578, -228.039220>,
				< 46.975069, 1.305151, -249.581948>
			}
			triangle {
				< 46.803582, -2.256759, -248.547092>,
				< 46.910223, -4.408550, -226.035878>,
				< 46.975069, 1.305151, -249.581948>
			}
			triangle {
				< 47.078609, -10.985685, -227.129385>,
				< 46.910223, -4.408550, -226.035878>,
				< 46.803582, -2.256759, -248.547092>
			}
			triangle {
				< 46.897139, -5.661339, -249.111965>,
				< 47.078609, -10.985685, -227.129385>,
				< 46.803582, -2.256759, -248.547092>
			}
			triangle {
				< 51.089562, -23.795418, -213.612095>,
				< 50.266381, -15.557774, -207.779363>,
				< 47.078609, -10.985685, -227.129385>
			}
			triangle {
				< 47.715399, -16.810564, -231.244594>,
				< 51.089562, -23.795418, -213.612095>,
				< 47.078609, -10.985685, -227.129385>
			}
			triangle {
				< 52.482396, -30.407872, -223.326296>,
				< 51.089562, -23.795418, -213.612095>,
				< 47.715399, -16.810564, -231.244594>
			}
			triangle {
				< 48.787005, -21.486277, -238.099173>,
				< 52.482396, -30.407872, -223.326296>,
				< 47.715399, -16.810564, -231.244594>
			}
			triangle {
				< 54.378308, -34.944497, -236.254439>,
				< 52.482396, -30.407872, -223.326296>,
				< 48.787005, -21.486277, -238.099173>
			}
			triangle {
				< 50.234560, -24.694173, -247.222960>,
				< 54.378308, -34.944497, -236.254439>,
				< 48.787005, -21.486277, -238.099173>
			}
			triangle {
				< 56.677654, -37.096146, -251.509488>,
				< 54.378308, -34.944497, -236.254439>,
				< 50.234560, -24.694173, -247.222960>
			}
			triangle {
				< 51.974118, -26.215615, -257.991105>,
				< 56.677654, -37.096146, -251.509488>,
				< 50.234560, -24.694173, -247.222960>
			}
			triangle {
				< 59.246588, -36.716208, -268.047094>,
				< 56.677654, -37.096146, -251.509488>,
				< 51.974118, -26.215615, -257.991105>
			}
			triangle {
				< 53.898599, -25.946941, -269.667238>,
				< 59.246588, -36.716208, -268.047094>,
				< 51.974118, -26.215615, -257.991105>
			}
			triangle {
				< 61.919931, -33.830531, -284.737885>,
				< 59.246588, -36.716208, -268.047094>,
				< 53.898599, -25.946941, -269.667238>
			}
			triangle {
				< 55.881761, -23.906453, -281.454533>,
				< 61.919931, -33.830531, -284.737885>,
				< 53.898599, -25.946941, -269.667238>
			}
			triangle {
				< 64.509958, -28.635811, -300.445378>,
				< 61.919931, -33.830531, -284.737885>,
				< 55.881761, -23.906453, -281.454533>
			}
			triangle {
				< 57.785705, -20.233240, -292.550206>,
				< 64.509958, -28.635811, -300.445378>,
				< 55.881761, -23.906453, -281.454533>
			}
			triangle {
				< 66.820592, -21.486029, -314.103067>,
				< 64.509958, -28.635811, -300.445378>,
				< 57.785705, -20.233240, -292.550206>
			}
			triangle {
				< 59.470896, -15.177570, -302.200198>,
				< 66.820592, -21.486029, -314.103067>,
				< 57.785705, -20.233240, -292.550206>
			}
			triangle {
				< 68.666048, -12.868429, -324.786007>,
				< 66.820592, -21.486029, -314.103067>,
				< 59.470896, -15.177570, -302.200198>
			}
			triangle {
				< 60.808402, -9.084015, -309.749931>,
				< 68.666048, -12.868429, -324.786007>,
				< 59.470896, -15.177570, -302.200198>
			}
			triangle {
				< 69.891073, -3.370315, -331.772506>,
				< 68.666048, -12.868429, -324.786007>,
				< 60.808402, -9.084015, -309.749931>
			}
			triangle {
				< 61.692290, -2.367835, -314.688116>,
				< 69.891073, -3.370315, -331.772506>,
				< 60.808402, -9.084015, -309.749931>
			}
			triangle {
				< 70.389412, 6.361050, -334.591478>,
				< 69.891073, -3.370315, -331.772506>,
				< 61.692290, -2.367835, -314.688116>
			}
			triangle {
				< 62.051006, 4.513294, -316.680759>,
				< 70.389412, 6.361050, -334.591478>,
				< 61.692290, -2.367835, -314.688116>
			}
			triangle {
				< 70.117138, 15.662508, -333.052903>,
				< 70.389412, 6.361050, -334.591478>,
				< 62.051006, 4.513294, -316.680759>
			}
			triangle {
				< 61.855085, 11.090397, -315.593153>,
				< 70.117138, 15.662508, -333.052903>,
				< 62.051006, 4.513294, -316.680759>
			}
			triangle {
				< 69.098279, 23.900121, -327.260464>,
				< 70.117138, 15.662508, -333.052903>,
				< 61.855085, 11.090397, -315.593153>
			}
			triangle {
				< 61.120614, 16.915286, -311.498821>,
				< 69.098279, 23.900121, -327.260464>,
				< 61.855085, 11.090397, -315.593153>
			}
			triangle {
				< 67.421786, 30.512584, -317.604661>,
				< 69.098279, 23.900121, -327.260464>,
				< 61.120614, 16.915286, -311.498821>
			}
			triangle {
				< 59.907451, 21.590991, -304.674715>,
				< 67.421786, 30.512584, -317.604661>,
				< 61.120614, 16.915286, -311.498821>
			}
			triangle {
				< 65.230206, 35.049222, -304.737449>,
				< 67.421786, 30.512584, -317.604661>,
				< 59.907451, 21.590991, -304.674715>
			}
			triangle {
				< 58.312304, 24.798874, -295.582622>,
				< 65.230206, 35.049222, -304.737449>,
				< 59.907451, 21.590991, -304.674715>
			}
			triangle {
				< 62.702373, 37.200890, -289.529383>,
				< 65.230206, 35.049222, -304.737449>,
				< 58.312304, 24.798874, -295.582622>
			}
			triangle {
				< 56.458689, 26.320336, -284.838974>,
				< 62.702373, 37.200890, -289.529383>,
				< 58.312304, 24.798874, -295.582622>
			}
			triangle {
				< 60.033396, 36.820922, -273.012429>,
				< 62.702373, 37.200890, -289.529383>,
				< 56.458689, 26.320336, -284.838974>
			}
			triangle {
				< 54.484289, 26.051663, -273.173541>,
				< 60.033396, 36.820922, -273.012429>,
				< 56.458689, 26.320336, -284.838974>
			}
			triangle {
				< 57.415228, 33.935264, -256.310225>,
				< 60.033396, 36.820922, -273.012429>,
				< 54.484289, 26.051663, -273.173541>
			}
			triangle {
				< 52.528664, 24.011187, -261.380315>,
				< 57.415228, 33.935264, -256.310225>,
				< 54.484289, 26.051663, -273.173541>
			}
			triangle {
				< 55.020832, 28.740544, -240.562439>,
				< 57.415228, 33.935264, -256.310225>,
				< 52.528664, 24.011187, -261.380315>
			}
			triangle {
				< 50.722361, 20.337975, -250.263602>,
				< 55.020832, 28.740544, -240.562439>,
				< 52.528664, 24.011187, -261.380315>
			}
			triangle {
				< 52.993845, 21.590753, -226.846397>,
				< 55.020832, 28.740544, -240.562439>,
				< 50.722361, 20.337975, -250.263602>
			}
			triangle {
				< 49.178746, 15.282313, -240.583241>,
				< 52.993845, 21.590753, -226.846397>,
				< 50.722361, 20.337975, -250.263602>
			}
			triangle {
				< 51.444057, 12.973183, -216.102555>,
				< 52.993845, 21.590753, -226.846397>,
				< 49.178746, 15.282313, -240.583241>
			}
			triangle {
				< 47.988832, 9.188759, -233.001858>,
				< 51.444057, 12.973183, -216.102555>,
				< 49.178746, 15.282313, -240.583241>
			}
			triangle {
				< 50.447520, 3.475058, -209.068954>,
				< 51.444057, 12.973183, -216.102555>,
				< 47.988832, 9.188759, -233.001858>
			}
			triangle {
				< 47.218982, 2.472578, -228.039220>,
				< 50.447520, 3.475058, -209.068954>,
				< 47.988832, 9.188759, -233.001858>
			}
			triangle {
				< 50.049257, -6.256306, -206.229433>,
				< 50.447520, 3.475058, -209.068954>,
				< 47.218982, 2.472578, -228.039220>
			}
			triangle {
				< 46.910223, -4.408550, -226.035878>,
				< 50.049257, -6.256306, -206.229433>,
				< 47.218982, 2.472578, -228.039220>
			}
			triangle {
				< 50.266381, -15.557774, -207.779363>,
				< 50.049257, -6.256306, -206.229433>,
				< 46.910223, -4.408550, -226.035878>
			}
			triangle {
				< 47.078609, -10.985685, -227.129385>,
				< 50.266381, -15.557774, -207.779363>,
				< 46.910223, -4.408550, -226.035878>
			}
			triangle {
				< 57.158127, -29.155085, -199.597463>,
				< 56.254759, -19.066082, -192.438528>,
				< 50.266381, -15.557774, -207.779363>
			}
			triangle {
				< 51.089562, -23.795418, -213.612095>,
				< 57.158127, -29.155085, -199.597463>,
				< 50.266381, -15.557774, -207.779363>
			}
			triangle {
				< 58.695141, -37.253663, -211.519808>,
				< 57.158127, -29.155085, -199.597463>,
				< 51.089562, -23.795418, -213.612095>
			}
			triangle {
				< 52.482396, -30.407872, -223.326296>,
				< 58.695141, -37.253663, -211.519808>,
				< 51.089562, -23.795418, -213.612095>
			}
			triangle {
				< 60.803764, -42.809870, -227.385193>,
				< 58.695141, -37.253663, -211.519808>,
				< 52.482396, -30.407872, -223.326296>
			}
			triangle {
				< 54.378308, -34.944497, -236.254439>,
				< 60.803764, -42.809870, -227.385193>,
				< 52.482396, -30.407872, -223.326296>
			}
			triangle {
				< 63.384794, -45.445092, -246.104032>,
				< 60.803764, -42.809870, -227.385193>,
				< 54.378308, -34.944497, -236.254439>
			}
			triangle {
				< 56.677654, -37.096146, -251.509488>,
				< 63.384794, -45.445092, -246.104032>,
				< 54.378308, -34.944497, -236.254439>
			}
			triangle {
				< 66.296577, -44.979751, -266.393900>,
				< 63.384794, -45.445092, -246.104032>,
				< 56.677654, -37.096146, -251.509488>
			}
			triangle {
				< 59.246588, -36.716208, -268.047094>,
				< 66.296577, -44.979751, -266.393900>,
				< 56.677654, -37.096146, -251.509488>
			}
			triangle {
				< 69.355607, -41.445546, -286.868602>,
				< 66.296577, -44.979751, -266.393900>,
				< 59.246588, -36.716208, -268.047094>
			}
			triangle {
				< 61.919931, -33.830531, -284.737885>,
				< 69.355607, -41.445546, -286.868602>,
				< 59.246588, -36.716208, -268.047094>
			}
			triangle {
				< 72.345078, -35.083316, -306.134164>,
				< 69.355607, -41.445546, -286.868602>,
				< 61.919931, -33.830531, -284.737885>
			}
			triangle {
				< 64.509958, -28.635811, -300.445378>,
				< 72.345078, -35.083316, -306.134164>,
				< 61.919931, -33.830531, -284.737885>
			}
			triangle {
				< 75.031817, -26.326669, -322.883010>,
				< 72.345078, -35.083316, -306.134164>,
				< 64.509958, -28.635811, -300.445378>
			}
			triangle {
				< 66.820592, -21.486029, -314.103067>,
				< 75.031817, -26.326669, -322.883010>,
				< 64.509958, -28.635811, -300.445378>
			}
			triangle {
				< 77.190168, -15.772309, -335.982263>,
				< 75.031817, -26.326669, -322.883010>,
				< 66.820592, -21.486029, -314.103067>
			}
			triangle {
				< 68.666048, -12.868429, -324.786007>,
				< 77.190168, -15.772309, -335.982263>,
				< 66.820592, -21.486029, -314.103067>
			}
			triangle {
				< 78.628689, -4.139545, -344.548166>,
				< 77.190168, -15.772309, -335.982263>,
				< 68.666048, -12.868429, -324.786007>
			}
			triangle {
				< 69.891073, -3.370315, -331.772506>,
				< 78.628689, -4.139545, -344.548166>,
				< 68.666048, -12.868429, -324.786007>
			}
			triangle {
				< 79.215154, 7.778910, -348.004133>,
				< 78.628689, -4.139545, -344.548166>,
				< 69.891073, -3.370315, -331.772506>
			}
			triangle {
				< 70.389412, 6.361050, -334.591478>,
				< 79.215154, 7.778910, -348.004133>,
				< 69.891073, -3.370315, -331.772506>
			}
			triangle {
				< 78.894638, 19.170795, -346.117854>,
				< 79.215154, 7.778910, -348.004133>,
				< 70.389412, 6.361050, -334.591478>
			}
			triangle {
				< 70.117138, 15.662508, -333.052903>,
				< 78.894638, 19.170795, -346.117854>,
				< 70.389412, 6.361050, -334.591478>
			}
			triangle {
				< 77.697210, 29.259806, -339.016080>,
				< 78.894638, 19.170795, -346.117854>,
				< 70.117138, 15.662508, -333.052903>
			}
			triangle {
				< 69.098279, 23.900121, -327.260464>,
				< 77.697210, 29.259806, -339.016080>,
				< 70.117138, 15.662508, -333.052903>
			}
			triangle {
				< 75.733759, 37.358362, -327.176780>,
				< 77.697210, 29.259806, -339.016080>,
				< 69.098279, 23.900121, -327.260464>
			}
			triangle {
				< 67.421786, 30.512584, -317.604661>,
				< 75.733759, 37.358362, -327.176780>,
				< 69.098279, 23.900121, -327.260464>
			}
			triangle {
				< 73.180646, 42.914588, -311.397910>,
				< 75.733759, 37.358362, -327.176780>,
				< 67.421786, 30.512584, -317.604661>
			}
			triangle {
				< 65.230206, 35.049222, -304.737449>,
				< 73.180646, 42.914588, -311.397910>,
				< 67.421786, 30.512584, -317.604661>
			}
			triangle {
				< 70.256144, 45.549814, -292.745739>,
				< 73.180646, 42.914588, -311.397910>,
				< 65.230206, 35.049222, -304.737449>
			}
			triangle {
				< 62.702373, 37.200890, -289.529383>,
				< 70.256144, 45.549814, -292.745739>,
				< 65.230206, 35.049222, -304.737449>
			}
			triangle {
				< 67.193963, 45.084488, -272.485226>,
				< 70.256144, 45.549814, -292.745739>,
				< 62.702373, 37.200890, -289.529383>
			}
			triangle {
				< 60.033396, 36.820922, -273.012429>,
				< 67.193963, 45.084488, -272.485226>,
				< 62.702373, 37.200890, -289.529383>
			}
			triangle {
				< 64.217865, 41.550290, -251.994371>,
				< 67.193963, 45.084488, -272.485226>,
				< 60.033396, 36.820922, -273.012429>
			}
			triangle {
				< 57.415228, 33.935264, -256.310225>,
				< 64.217865, 41.550290, -251.994371>,
				< 60.033396, 36.820922, -273.012429>
			}
			triangle {
				< 61.522458, 35.188049, -232.671559>,
				< 64.217865, 41.550290, -251.994371>,
				< 57.415228, 33.935264, -256.310225>
			}
			triangle {
				< 55.020832, 28.740544, -240.562439>,
				< 61.522458, 35.188049, -232.671559>,
				< 57.415228, 33.935264, -256.310225>
			}
			triangle {
				< 59.262134, 26.431413, -215.839744>,
				< 61.522458, 35.188049, -232.671559>,
				< 55.020832, 28.740544, -240.562439>
			}
			triangle {
				< 52.993845, 21.590753, -226.846397>,
				< 59.262134, 26.431413, -215.839744>,
				< 55.020832, 28.740544, -240.562439>
			}
			triangle {
				< 57.548296, 15.877062, -202.654049>,
				< 59.262134, 26.431413, -215.839744>,
				< 52.993845, 21.590753, -226.846397>
			}
			triangle {
				< 51.444057, 12.973183, -216.102555>,
				< 57.548296, 15.877062, -202.654049>,
				< 52.993845, 21.590753, -226.846397>
			}
			triangle {
				< 56.453269, 4.244309, -194.021463>,
				< 57.548296, 15.877062, -202.654049>,
				< 51.444057, 12.973183, -216.102555>
			}
			triangle {
				< 50.447520, 3.475058, -209.068954>,
				< 56.453269, 4.244309, -194.021463>,
				< 51.444057, 12.973183, -216.102555>
			}
			triangle {
				< 56.017201, -7.674146, -190.536126>,
				< 56.453269, 4.244309, -194.021463>,
				< 50.447520, 3.475058, -209.068954>
			}
			triangle {
				< 50.049257, -6.256306, -206.229433>,
				< 56.017201, -7.674146, -190.536126>,
				< 50.447520, 3.475058, -209.068954>
			}
			triangle {
				< 56.254759, -19.066082, -192.438528>,
				< 56.017201, -7.674146, -190.536126>,
				< 50.049257, -6.256306, -206.229433>
			}
			triangle {
				< 50.266381, -15.557774, -207.779363>,
				< 56.254759, -19.066082, -192.438528>,
				< 50.049257, -6.256306, -206.229433>
			}
			triangle {
				< 65.408468, -32.524325, -190.228269>,
				< 64.521238, -21.271497, -182.228342>,
				< 56.254759, -19.066082, -192.438528>
			}
			triangle {
				< 57.158127, -29.155085, -199.597463>,
				< 65.408468, -32.524325, -190.228269>,
				< 56.254759, -19.066082, -192.438528>
			}
			triangle {
				< 66.926509, -41.557077, -203.551024>,
				< 65.408468, -32.524325, -190.228269>,
				< 57.158127, -29.155085, -199.597463>
			}
			triangle {
				< 58.695141, -37.253663, -211.519808>,
				< 66.926509, -41.557077, -203.551024>,
				< 57.158127, -29.155085, -199.597463>
			}
			triangle {
				< 69.025137, -47.754232, -221.279591>,
				< 66.926509, -41.557077, -203.551024>,
				< 58.695141, -37.253663, -211.519808>
			}
			triangle {
				< 60.803764, -42.809870, -227.385193>,
				< 69.025137, -47.754232, -221.279591>,
				< 58.695141, -37.253663, -211.519808>
			}
			triangle {
				< 71.616821, -50.693456, -242.196217>,
				< 69.025137, -47.754232, -221.279591>,
				< 60.803764, -42.809870, -227.385193>
			}
			triangle {
				< 63.384794, -45.445092, -246.104032>,
				< 71.616821, -50.693456, -242.196217>,
				< 60.803764, -42.809870, -227.385193>
			}
			triangle {
				< 74.567638, -50.174430, -264.867425>,
				< 71.616821, -50.693456, -242.196217>,
				< 63.384794, -45.445092, -246.104032>
			}
			triangle {
				< 66.296577, -44.979751, -266.393900>,
				< 74.567638, -50.174430, -264.867425>,
				< 63.384794, -45.445092, -246.104032>
			}
			triangle {
				< 77.695161, -46.232544, -287.744313>,
				< 74.567638, -50.174430, -264.867425>,
				< 66.296577, -44.979751, -266.393900>
			}
			triangle {
				< 69.355607, -41.445546, -286.868602>,
				< 77.695161, -46.232544, -287.744313>,
				< 66.296577, -44.979751, -266.393900>
			}
			triangle {
				< 80.775768, -39.136406, -309.268922>,
				< 77.695161, -46.232544, -287.744313>,
				< 69.355607, -41.445546, -286.868602>
			}
			triangle {
				< 72.345078, -35.083316, -306.134164>,
				< 80.775768, -39.136406, -309.268922>,
				< 69.355607, -41.445546, -286.868602>
			}
			triangle {
				< 83.562814, -29.369617, -327.980846>,
				< 80.775768, -39.136406, -309.268922>,
				< 72.345078, -35.083316, -306.134164>
			}
			triangle {
				< 75.031817, -26.326669, -322.883010>,
				< 83.562814, -29.369617, -327.980846>,
				< 72.345078, -35.083316, -306.134164>
			}
			triangle {
				< 85.813299, -17.597765, -342.614710>,
				< 83.562814, -29.369617, -327.980846>,
				< 75.031817, -26.326669, -322.883010>
			}
			triangle {
				< 77.190168, -15.772309, -335.982263>,
				< 85.813299, -17.597765, -342.614710>,
				< 75.031817, -26.326669, -322.883010>
			}
			triangle {
				< 87.318614, -4.623104, -352.183938>,
				< 85.813299, -17.597765, -342.614710>,
				< 77.190168, -15.772309, -335.982263>
			}
			triangle {
				< 78.628689, -4.139545, -344.548166>,
				< 87.318614, -4.623104, -352.183938>,
				< 77.190168, -15.772309, -335.982263>
			}
			triangle {
				< 87.933496, 8.670211, -356.044590>,
				< 87.318614, -4.623104, -352.183938>,
				< 78.628689, -4.139545, -344.548166>
			}
			triangle {
				< 79.215154, 7.778910, -348.004133>,
				< 87.933496, 8.670211, -356.044590>,
				< 78.628689, -4.139545, -344.548166>
			}
			triangle {
				< 87.597355, 21.376209, -353.937417>,
				< 87.933496, 8.670211, -356.044590>,
				< 79.215154, 7.778910, -348.004133>
			}
			triangle {
				< 78.894638, 19.170795, -346.117854>,
				< 87.597355, 21.376209, -353.937417>,
				< 79.215154, 7.778910, -348.004133>
			}
			triangle {
				< 86.343423, 32.629024, -346.004009>,
				< 87.597355, 21.376209, -353.937417>,
				< 78.894638, 19.170795, -346.117854>
			}
			triangle {
				< 77.697210, 29.259806, -339.016080>,
				< 86.343423, 32.629024, -346.004009>,
				< 78.894638, 19.170795, -346.117854>
			}
			triangle {
				< 84.293664, 41.661792, -332.777768>,
				< 86.343423, 32.629024, -346.004009>,
				< 77.697210, 29.259806, -339.016080>
			}
			triangle {
				< 75.733759, 37.358362, -327.176780>,
				< 84.293664, 41.661792, -332.777768>,
				< 77.697210, 29.259806, -339.016080>
			}
			triangle {
				< 81.640728, 47.858968, -315.149695>,
				< 84.293664, 41.661792, -332.777768>,
				< 75.733759, 37.358362, -327.176780>
			}
			triangle {
				< 73.180646, 42.914588, -311.397910>,
				< 81.640728, 47.858968, -315.149695>,
				< 75.733759, 37.358362, -327.176780>
			}
			triangle {
				< 78.620747, 50.798189, -294.310689>,
				< 81.640728, 47.858968, -315.149695>,
				< 73.180646, 42.914588, -311.397910>
			}
			triangle {
				< 70.256144, 45.549814, -292.745739>,
				< 78.620747, 50.798189, -294.310689>,
				< 73.180646, 42.914588, -311.397910>
			}
			triangle {
				< 75.482354, 50.279163, -271.673590>,
				< 78.620747, 50.798189, -294.310689>,
				< 70.256144, 45.549814, -292.745739>
			}
			triangle {
				< 67.193963, 45.084488, -272.485226>,
				< 75.482354, 50.279163, -271.673590>,
				< 70.256144, 45.549814, -292.745739>
			}
			triangle {
				< 72.458245, 46.337266, -248.777911>,
				< 75.482354, 50.279163, -271.673590>,
				< 67.193963, 45.084488, -272.485226>
			}
			triangle {
				< 64.217865, 41.550290, -251.994371>,
				< 72.458245, 46.337266, -248.777911>,
				< 67.193963, 45.084488, -272.485226>
			}
			triangle {
				< 69.744393, 39.241146, -227.186680>,
				< 72.458245, 46.337266, -248.777911>,
				< 64.217865, 41.550290, -251.994371>
			}
			triangle {
				< 61.522458, 35.188049, -232.671559>,
				< 69.744393, 39.241146, -227.186680>,
				< 64.217865, 41.550290, -251.994371>
			}
			triangle {
				< 67.489058, 29.474370, -208.378375>,
				< 69.744393, 39.241146, -227.186680>,
				< 61.522458, 35.188049, -232.671559>
			}
			triangle {
				< 59.262134, 26.431413, -215.839744>,
				< 67.489058, 29.474370, -208.378375>,
				< 61.522458, 35.188049, -232.671559>
			}
			triangle {
				< 65.792851, 17.702518, -193.643942>,
				< 67.489058, 29.474370, -208.378375>,
				< 59.262134, 26.431413, -215.839744>
			}
			triangle {
				< 57.548296, 15.877062, -202.654049>,
				< 65.792851, 17.702518, -193.643942>,
				< 59.262134, 26.431413, -215.839744>
			}
			triangle {
				< 64.715840, 4.727847, -183.997154>,
				< 65.792851, 17.702518, -193.643942>,
				< 57.548296, 15.877062, -202.654049>
			}
			triangle {
				< 56.453269, 4.244309, -194.021463>,
				< 64.715840, 4.727847, -183.997154>,
				< 57.548296, 15.877062, -202.654049>
			}
			triangle {
				< 64.288549, -8.565426, -180.102423>,
				< 64.715840, 4.727847, -183.997154>,
				< 56.453269, 4.244309, -194.021463>
			}
			triangle {
				< 56.017201, -7.674146, -190.536126>,
				< 64.288549, -8.565426, -180.102423>,
				< 56.453269, 4.244309, -194.021463>
			}
			triangle {
				< 64.521238, -21.271497, -182.228342>,
				< 64.288549, -8.565426, -180.102423>,
				< 56.017201, -7.674146, -190.536126>
			}
			triangle {
				< 56.254759, -19.066082, -192.438528>,
				< 64.521238, -21.271497, -182.228342>,
				< 56.017201, -7.674146, -190.536126>
			}
			triangle {
				< 75.090721, -33.673491, -186.208993>,
				< 74.291676, -22.023708, -177.914247>,
				< 64.521238, -21.271497, -182.228342>
			}
			triangle {
				< 65.408468, -32.524325, -190.228269>,
				< 75.090721, -33.673491, -186.208993>,
				< 64.521238, -21.271497, -182.228342>
			}
			triangle {
				< 76.464772, -43.024894, -200.023085>,
				< 75.090721, -33.673491, -186.208993>,
				< 65.408468, -32.524325, -190.228269>
			}
			triangle {
				< 66.926509, -41.557077, -203.551024>,
				< 76.464772, -43.024894, -200.023085>,
				< 65.408468, -32.524325, -190.228269>
			}
			triangle {
				< 78.377388, -49.440663, -218.406320>,
				< 76.464772, -43.024894, -200.023085>,
				< 66.926509, -41.557077, -203.551024>
			}
			triangle {
				< 69.025137, -47.754232, -221.279591>,
				< 78.377388, -49.440663, -218.406320>,
				< 66.926509, -41.557077, -203.551024>
			}
			triangle {
				< 80.757797, -52.483570, -240.096286>,
				< 78.377388, -49.440663, -218.406320>,
				< 69.025137, -47.754232, -221.279591>
			}
			triangle {
				< 71.616821, -50.693456, -242.196217>,
				< 80.757797, -52.483570, -240.096286>,
				< 69.025137, -47.754232, -221.279591>
			}
			triangle {
				< 83.489709, -51.946245, -263.606876>,
				< 80.757797, -52.483570, -240.096286>,
				< 71.616821, -50.693456, -242.196217>
			}
			triangle {
				< 74.567638, -50.174430, -264.867425>,
				< 83.489709, -51.946245, -263.606876>,
				< 71.616821, -50.693456, -242.196217>
			}
			triangle {
				< 86.406961, -47.865290, -287.332058>,
				< 83.489709, -51.946245, -263.606876>,
				< 74.567638, -50.174430, -264.867425>
			}
			triangle {
				< 77.695161, -46.232544, -287.744313>,
				< 86.406961, -47.865290, -287.332058>,
				< 74.567638, -50.174430, -264.867425>
			}
			triangle {
				< 89.299515, -40.518843, -309.655994>,
				< 86.406961, -47.865290, -287.332058>,
				< 77.695161, -46.232544, -287.744313>
			}
			triangle {
				< 80.775768, -39.136406, -309.268922>,
				< 89.299515, -40.518843, -309.655994>,
				< 77.695161, -46.232544, -287.744313>
			}
			triangle {
				< 91.930807, -30.407520, -329.063535>,
				< 89.299515, -40.518843, -309.655994>,
				< 80.775768, -39.136406, -309.268922>
			}
			triangle {
				< 83.562814, -29.369617, -327.980846>,
				< 91.930807, -30.407520, -329.063535>,
				< 80.775768, -39.136406, -309.268922>
			}
			triangle {
				< 94.064504, -18.220393, -344.241977>,
				< 91.930807, -30.407520, -329.063535>,
				< 83.562814, -29.369617, -327.980846>
			}
			triangle {
				< 85.813299, -17.597765, -342.614710>,
				< 94.064504, -18.220393, -344.241977>,
				< 83.562814, -29.369617, -327.980846>
			}
			triangle {
				< 95.495827, -4.788030, -354.167432>,
				< 94.064504, -18.220393, -344.241977>,
				< 85.813299, -17.597765, -342.614710>
			}
			triangle {
				< 87.318614, -4.623104, -352.183938>,
				< 95.495827, -4.788030, -354.167432>,
				< 85.813299, -17.597765, -342.614710>
			}
			triangle {
				< 96.081369, 8.974205, -358.171880>,
				< 95.495827, -4.788030, -354.167432>,
				< 87.318614, -4.623104, -352.183938>
			}
			triangle {
				< 87.933496, 8.670211, -356.044590>,
				< 96.081369, 8.974205, -358.171880>,
				< 87.318614, -4.623104, -352.183938>
			}
			triangle {
				< 95.761210, 22.128420, -355.986267>,
				< 96.081369, 8.974205, -358.171880>,
				< 87.933496, 8.670211, -356.044590>
			}
			triangle {
				< 87.597355, 21.376209, -353.937417>,
				< 95.761210, 22.128420, -355.986267>,
				< 87.933496, 8.670211, -356.044590>
			}
			triangle {
				< 94.568186, 33.778209, -347.757399>,
				< 95.761210, 22.128420, -355.986267>,
				< 87.597355, 21.376209, -353.937417>
			}
			triangle {
				< 86.343423, 32.629024, -346.004009>,
				< 94.568186, 33.778209, -347.757399>,
				< 87.597355, 21.376209, -353.937417>
			}
			triangle {
				< 92.622876, 43.129630, -334.038943>,
				< 94.568186, 33.778209, -347.757399>,
				< 86.343423, 32.629024, -346.004009>
			}
			triangle {
				< 84.293664, 41.661792, -332.777768>,
				< 92.622876, 43.129630, -334.038943>,
				< 86.343423, 32.629024, -346.004009>
			}
			triangle {
				< 90.114750, 49.545385, -315.755218>,
				< 92.622876, 43.129630, -334.038943>,
				< 84.293664, 41.661792, -332.777768>
			}
			triangle {
				< 81.640728, 47.858968, -315.149695>,
				< 90.114750, 49.545385, -315.755218>,
				< 84.293664, 41.661792, -332.777768>
			}
			triangle {
				< 87.274186, 52.588314, -294.142246>,
				< 90.114750, 49.545385, -315.755218>,
				< 81.640728, 47.858968, -315.149695>
			}
			triangle {
				< 78.620747, 50.798189, -294.310689>,
				< 87.274186, 52.588314, -294.142246>,
				< 81.640728, 47.858968, -315.149695>
			}
			triangle {
				< 84.340759, 52.050963, -270.665318>,
				< 87.274186, 52.588314, -294.142246>,
				< 78.620747, 50.798189, -294.310689>
			}
			triangle {
				< 75.482354, 50.279163, -271.673590>,
				< 84.340759, 52.050963, -270.665318>,
				< 78.620747, 50.798189, -294.310689>
			}
			triangle {
				< 81.534617, 47.970023, -246.921539>,
				< 84.340759, 52.050963, -270.665318>,
				< 75.482354, 50.279163, -271.673590>
			}
			triangle {
				< 72.458245, 46.337266, -248.777911>,
				< 81.534617, 47.970023, -246.921539>,
				< 75.482354, 50.279163, -271.673590>
			}
			triangle {
				< 79.036064, 40.623575, -224.531710>,
				< 81.534617, 47.970023, -246.921539>,
				< 72.458245, 46.337266, -248.777911>
			}
			triangle {
				< 69.744393, 39.241146, -227.186680>,
				< 79.036064, 40.623575, -224.531710>,
				< 72.458245, 46.337266, -248.777911>
			}
			triangle {
				< 76.976031, 30.512253, -205.028564>,
				< 79.036064, 40.623575, -224.531710>,
				< 69.744393, 39.241146, -227.186680>
			}
			triangle {
				< 67.489058, 29.474370, -208.378375>,
				< 76.976031, 30.512253, -205.028564>,
				< 69.744393, 39.241146, -227.186680>
			}
			triangle {
				< 75.437821, 18.325157, -189.750597>,
				< 76.976031, 30.512253, -205.028564>,
				< 67.489058, 29.474370, -208.378375>
			}
			triangle {
				< 65.792851, 17.702518, -193.643942>,
				< 75.437821, 18.325157, -189.750597>,
				< 67.489058, 29.474370, -208.378375>
			}
			triangle {
				< 74.466661, 4.892774, -179.748178>,
				< 75.437821, 18.325157, -189.750597>,
				< 65.792851, 17.702518, -193.643942>
			}
			triangle {
				< 64.715840, 4.727847, -183.997154>,
				< 74.466661, 4.892774, -179.748178>,
				< 65.792851, 17.702518, -193.643942>
			}
			triangle {
				< 74.082628, -8.869440, -175.709948>,
				< 74.466661, 4.892774, -179.748178>,
				< 64.715840, 4.727847, -183.997154>
			}
			triangle {
				< 64.288549, -8.565426, -180.102423>,
				< 74.082628, -8.869440, -175.709948>,
				< 64.715840, 4.727847, -183.997154>
			}
			triangle {
				< 74.291676, -22.023708, -177.914247>,
				< 74.082628, -8.869440, -175.709948>,
				< 64.288549, -8.565426, -180.102423>
			}
			triangle {
				< 64.521238, -21.271497, -182.228342>,
				< 74.291676, -22.023708, -177.914247>,
				< 64.288549, -8.565426, -180.102423>
			}
			triangle {
				< 85.319102, -32.524303, -187.852994>,
				< 84.649831, -21.271497, -179.832086>,
				< 74.291676, -22.023708, -177.914247>
			}
			triangle {
				< 75.090721, -33.673491, -186.208993>,
				< 85.319102, -32.524303, -187.852994>,
				< 74.291676, -22.023708, -177.914247>
			}
			triangle {
				< 86.474128, -41.557077, -201.211765>,
				< 85.319102, -32.524303, -187.852994>,
				< 75.090721, -33.673491, -186.208993>
			}
			triangle {
				< 76.464772, -43.024894, -200.023085>,
				< 86.474128, -41.557077, -201.211765>,
				< 75.090721, -33.673491, -186.208993>
			}
			triangle {
				< 88.089682, -47.754232, -218.990445>,
				< 86.474128, -41.557077, -201.211765>,
				< 76.464772, -43.024894, -200.023085>
			}
			triangle {
				< 78.377388, -49.440663, -218.406320>,
				< 88.089682, -47.754232, -218.990445>,
				< 76.464772, -43.024894, -200.023085>
			}
			triangle {
				< 90.111375, -50.693456, -239.969417>,
				< 88.089682, -47.754232, -218.990445>,
				< 78.377388, -49.440663, -218.406320>
			}
			triangle {
				< 80.757797, -52.483570, -240.096286>,
				< 90.111375, -50.693456, -239.969417>,
				< 78.377388, -49.440663, -218.406320>
			}
			triangle {
				< 92.444368, -50.174430, -262.711942>,
				< 90.111375, -50.693456, -239.969417>,
				< 80.757797, -52.483570, -240.096286>
			}
			triangle {
				< 83.489709, -51.946245, -263.606876>,
				< 92.444368, -50.174430, -262.711942>,
				< 80.757797, -52.483570, -240.096286>
			}
			triangle {
				< 94.948374, -46.232544, -285.665035>,
				< 92.444368, -50.174430, -262.711942>,
				< 83.489709, -51.946245, -263.606876>
			}
			triangle {
				< 86.406961, -47.865290, -287.332058>,
				< 94.948374, -46.232544, -285.665035>,
				< 83.489709, -51.946245, -263.606876>
			}
			triangle {
				< 97.442292, -39.136406, -307.265103>,
				< 94.948374, -46.232544, -285.665035>,
				< 86.406961, -47.865290, -287.332058>
			}
			triangle {
				< 89.299515, -40.518843, -309.655994>,
				< 97.442292, -39.136406, -307.265103>,
				< 86.406961, -47.865290, -287.332058>
			}
			triangle {
				< 99.719286, -29.369617, -326.045513>,
				< 97.442292, -39.136406, -307.265103>,
				< 89.299515, -40.518843, -309.655994>
			}
			triangle {
				< 91.930807, -30.407520, -329.063535>,
				< 99.719286, -29.369617, -326.045513>,
				< 89.299515, -40.518843, -309.655994>
			}
			triangle {
				< 101.570822, -17.597765, -340.734929>,
				< 99.719286, -29.369617, -326.045513>,
				< 91.930807, -30.407520, -329.063535>
			}
			triangle {
				< 94.064504, -18.220393, -344.241977>,
				< 101.570822, -17.597765, -340.734929>,
				< 91.930807, -30.407520, -329.063535>
			}
			triangle {
				< 102.815248, -4.623083, -350.341350>,
				< 101.570822, -17.597765, -340.734929>,
				< 94.064504, -18.220393, -344.241977>
			}
			triangle {
				< 95.495827, -4.788030, -354.167432>,
				< 102.815248, -4.623083, -350.341350>,
				< 94.064504, -18.220393, -344.241977>
			}
			triangle {
				< 103.324898, 8.670211, -354.217261>,
				< 102.815248, -4.623083, -350.341350>,
				< 95.495827, -4.788030, -354.167432>
			}
			triangle {
				< 96.081369, 8.974205, -358.171880>,
				< 103.324898, 8.670211, -354.217261>,
				< 95.495827, -4.788030, -354.167432>
			}
			triangle {
				< 103.046186, 21.376209, -352.101743>,
				< 103.324898, 8.670211, -354.217261>,
				< 96.081369, 8.974205, -358.171880>
			}
			triangle {
				< 95.761210, 22.128420, -355.986267>,
				< 103.046186, 21.376209, -352.101743>,
				< 96.081369, 8.974205, -358.171880>
			}
			triangle {
				< 102.008544, 32.629035, -344.137281>,
				< 103.046186, 21.376209, -352.101743>,
				< 95.761210, 22.128420, -355.986267>
			}
			triangle {
				< 94.568186, 33.778209, -347.757399>,
				< 102.008544, 32.629035, -344.137281>,
				< 95.761210, 22.128420, -355.986267>
			}
			triangle {
				< 100.319318, 41.661792, -330.860376>,
				< 102.008544, 32.629035, -344.137281>,
				< 94.568186, 33.778209, -347.757399>
			}
			triangle {
				< 92.622876, 43.129630, -334.038943>,
				< 100.319318, 41.661792, -330.860376>,
				< 94.568186, 33.778209, -347.757399>
			}
			triangle {
				< 98.146945, 47.858968, -313.166976>,
				< 100.319318, 41.661792, -330.860376>,
				< 92.622876, 43.129630, -334.038943>
			}
			triangle {
				< 90.114750, 49.545385, -315.755218>,
				< 98.146945, 47.858968, -313.166976>,
				< 92.622876, 43.129630, -334.038943>
			}
			triangle {
				< 95.694996, 50.798189, -292.254001>,
				< 98.146945, 47.858968, -313.166976>,
				< 90.114750, 49.545385, -315.755218>
			}
			triangle {
				< 87.274186, 52.588314, -294.142246>,
				< 95.694996, 50.798189, -292.254001>,
				< 90.114750, 49.545385, -315.755218>
			}
			triangle {
				< 93.173578, 50.279163, -269.540340>,
				< 95.694996, 50.798189, -292.254001>,
				< 87.274186, 52.588314, -294.142246>
			}
			triangle {
				< 84.340759, 52.050963, -270.665318>,
				< 93.173578, 50.279163, -269.540340>,
				< 87.274186, 52.588314, -294.142246>
			}
			triangle {
				< 90.773486, 46.337266, -246.571407>,
				< 93.173578, 50.279163, -269.540340>,
				< 84.340759, 52.050963, -270.665318>
			}
			triangle {
				< 81.534617, 47.970023, -246.921539>,
				< 90.773486, 46.337266, -246.571407>,
				< 84.340759, 52.050963, -270.665318>
			}
			triangle {
				< 88.647962, 39.241146, -224.914819>,
				< 90.773486, 46.337266, -246.571407>,
				< 81.534617, 47.970023, -246.921539>
			}
			triangle {
				< 79.036064, 40.623575, -224.531710>,
				< 88.647962, 39.241146, -224.914819>,
				< 81.534617, 47.970023, -246.921539>
			}
			triangle {
				< 86.905137, 29.474370, -206.052497>,
				< 88.647962, 39.241146, -224.914819>,
				< 79.036064, 40.623575, -224.531710>
			}
			triangle {
				< 76.976031, 30.512253, -205.028564>,
				< 86.905137, 29.474370, -206.052497>,
				< 79.036064, 40.623575, -224.531710>
			}
			triangle {
				< 85.610405, 17.702518, -191.277832>,
				< 86.905137, 29.474370, -206.052497>,
				< 76.976031, 30.512253, -205.028564>
			}
			triangle {
				< 75.437821, 18.325157, -189.750597>,
				< 85.610405, 17.702518, -191.277832>,
				< 76.976031, 30.512253, -205.028564>
			}
			triangle {
				< 84.796228, 4.727847, -181.605488>,
				< 85.610405, 17.702518, -191.277832>,
				< 75.437821, 18.325157, -189.750597>
			}
			triangle {
				< 74.466661, 4.892774, -179.748178>,
				< 84.796228, 4.727847, -181.605488>,
				< 75.437821, 18.325157, -189.750597>
			}
			triangle {
				< 84.475048, -8.565426, -177.700624>,
				< 84.796228, 4.727847, -181.605488>,
				< 74.466661, 4.892774, -179.748178>
			}
			triangle {
				< 74.082628, -8.869440, -175.709948>,
				< 84.475048, -8.565426, -177.700624>,
				< 74.466661, 4.892774, -179.748178>
			}
			triangle {
				< 84.649831, -21.271497, -179.832086>,
				< 84.475048, -8.565426, -177.700624>,
				< 74.082628, -8.869440, -175.709948>
			}
			triangle {
				< 74.291676, -22.023708, -177.914247>,
				< 84.649831, -21.271497, -179.832086>,
				< 74.082628, -8.869440, -175.709948>
			}
			triangle {
				< 95.193572, -29.155085, -195.050567>,
				< 94.667546, -19.066082, -187.854439>,
				< 84.649831, -21.271497, -179.832086>
			}
			triangle {
				< 85.319102, -32.524303, -187.852994>,
				< 95.193572, -29.155085, -195.050567>,
				< 84.649831, -21.271497, -179.832086>
			}
			triangle {
				< 96.102111, -37.253663, -207.036719>,
				< 95.193572, -29.155085, -195.050567>,
				< 85.319102, -32.524303, -187.852994>
			}
			triangle {
				< 86.474128, -41.557077, -201.211765>,
				< 96.102111, -37.253663, -207.036719>,
				< 85.319102, -32.524303, -187.852994>
			}
			triangle {
				< 97.374305, -42.809870, -222.990215>,
				< 96.102111, -37.253663, -207.036719>,
				< 86.474128, -41.557077, -201.211765>
			}
			triangle {
				< 88.089682, -47.754232, -218.990445>,
				< 97.374305, -42.809870, -222.990215>,
				< 86.474128, -41.557077, -201.211765>
			}
			triangle {
				< 98.968349, -45.445092, -241.818056>,
				< 97.374305, -42.809870, -222.990215>,
				< 88.089682, -47.754232, -218.990445>
			}
			triangle {
				< 90.111375, -50.693456, -239.969417>,
				< 98.968349, -45.445092, -241.818056>,
				< 88.089682, -47.754232, -218.990445>
			}
			triangle {
				< 100.810148, -44.979751, -262.232006>,
				< 98.968349, -45.445092, -241.818056>,
				< 90.111375, -50.693456, -239.969417>
			}
			triangle {
				< 92.444368, -50.174430, -262.711942>,
				< 100.810148, -44.979751, -262.232006>,
				< 90.111375, -50.693456, -239.969417>
			}
			triangle {
				< 102.789305, -41.445546, -282.838285>,
				< 100.810148, -44.979751, -262.232006>,
				< 92.444368, -50.174430, -262.711942>
			}
			triangle {
				< 94.948374, -46.232544, -285.665035>,
				< 102.789305, -41.445546, -282.838285>,
				< 92.444368, -50.174430, -262.711942>
			}
			triangle {
				< 104.762532, -35.083316, -302.233547>,
				< 102.789305, -41.445546, -282.838285>,
				< 94.948374, -46.232544, -285.665035>
			}
			triangle {
				< 97.442292, -39.136406, -307.265103>,
				< 104.762532, -35.083316, -302.233547>,
				< 94.948374, -46.232544, -285.665035>
			}
			triangle {
				< 106.565647, -26.326669, -319.099814>,
				< 104.762532, -35.083316, -302.233547>,
				< 97.442292, -39.136406, -307.265103>
			}
			triangle {
				< 99.719286, -29.369617, -326.045513>,
				< 106.565647, -26.326669, -319.099814>,
				< 97.442292, -39.136406, -307.265103>
			}
			triangle {
				< 108.032823, -15.772309, -332.293838>,
				< 106.565647, -26.326669, -319.099814>,
				< 99.719286, -29.369617, -326.045513>
			}
			triangle {
				< 101.570822, -17.597765, -340.734929>,
				< 108.032823, -15.772309, -332.293838>,
				< 99.719286, -29.369617, -326.045513>
			}
			triangle {
				< 109.019347, -4.139524, -340.923101>,
				< 108.032823, -15.772309, -332.293838>,
				< 101.570822, -17.597765, -340.734929>
			}
			triangle {
				< 102.815248, -4.623083, -350.341350>,
				< 109.019347, -4.139524, -340.923101>,
				< 101.570822, -17.597765, -340.734929>
			}
			triangle {
				< 109.423444, 7.778910, -344.405055>,
				< 109.019347, -4.139524, -340.923101>,
				< 102.815248, -4.623083, -350.341350>
			}
			triangle {
				< 103.324898, 8.670211, -354.217261>,
				< 109.423444, 7.778910, -344.405055>,
				< 102.815248, -4.623083, -350.341350>
			}
			triangle {
				< 109.202445, 19.170804, -342.504621>,
				< 109.423444, 7.778910, -344.405055>,
				< 103.324898, 8.670211, -354.217261>
			}
			triangle {
				< 103.046186, 21.376209, -352.101743>,
				< 109.202445, 19.170804, -342.504621>,
				< 103.324898, 8.670211, -354.217261>
			}
			triangle {
				< 108.379781, 29.259818, -335.349977>,
				< 109.202445, 19.170804, -342.504621>,
				< 103.046186, 21.376209, -352.101743>
			}
			triangle {
				< 102.008544, 32.629035, -344.137281>,
				< 108.379781, 29.259818, -335.349977>,
				< 103.046186, 21.376209, -352.101743>
			}
			triangle {
				< 107.041031, 37.358373, -323.424250>,
				< 108.379781, 29.259818, -335.349977>,
				< 102.008544, 32.629035, -344.137281>
			}
			triangle {
				< 100.319318, 41.661792, -330.860376>,
				< 107.041031, 37.358373, -323.424250>,
				< 102.008544, 32.629035, -344.137281>
			}
			triangle {
				< 105.320379, 42.914599, -307.533652>,
				< 107.041031, 37.358373, -323.424250>,
				< 100.319318, 41.661792, -330.860376>
			}
			triangle {
				< 98.146945, 47.858968, -313.166976>,
				< 105.320379, 42.914599, -307.533652>,
				< 100.319318, 41.661792, -330.860376>
			}
			triangle {
				< 103.379846, 45.549825, -288.754374>,
				< 105.320379, 42.914599, -307.533652>,
				< 98.146945, 47.858968, -313.166976>
			}
			triangle {
				< 95.694996, 50.798189, -292.254001>,
				< 103.379846, 45.549825, -288.754374>,
				< 98.146945, 47.858968, -313.166976>
			}
			triangle {
				< 101.386279, 45.084488, -268.361777>,
				< 103.379846, 45.549825, -288.754374>,
				< 95.694996, 50.798189, -292.254001>
			}
			triangle {
				< 93.173578, 50.279163, -269.540340>,
				< 101.386279, 45.084488, -268.361777>,
				< 95.694996, 50.798189, -292.254001>
			}
			triangle {
				< 99.490792, 41.550301, -247.743711>,
				< 101.386279, 45.084488, -268.361777>,
				< 93.173578, 50.279163, -269.540340>
			}
			triangle {
				< 90.773486, 46.337266, -246.571407>,
				< 99.490792, 41.550301, -247.743711>,
				< 93.173578, 50.279163, -269.540340>
			}
			triangle {
				< 97.814284, 35.188071, -228.306890>,
				< 99.490792, 41.550301, -247.743711>,
				< 90.773486, 46.337266, -246.571407>
			}
			triangle {
				< 88.647962, 39.241146, -224.914819>,
				< 97.814284, 35.188071, -228.306890>,
				< 90.773486, 46.337266, -246.571407>
			}
			triangle {
				< 96.441366, 26.431413, -211.380258>,
				< 97.814284, 35.188071, -228.306890>,
				< 88.647962, 39.241146, -224.914819>
			}
			triangle {
				< 86.905137, 29.474370, -206.052497>,
				< 96.441366, 26.431413, -211.380258>,
				< 88.647962, 39.241146, -224.914819>
			}
			triangle {
				< 95.422618, 15.877062, -198.123381>,
				< 96.441366, 26.431413, -211.380258>,
				< 86.905137, 29.474370, -206.052497>
			}
			triangle {
				< 85.610405, 17.702518, -191.277832>,
				< 95.422618, 15.877062, -198.123381>,
				< 86.905137, 29.474370, -206.052497>
			}
			triangle {
				< 94.782621, 4.244289, -189.445406>,
				< 95.422618, 15.877062, -198.123381>,
				< 85.610405, 17.702518, -191.277832>
			}
			triangle {
				< 84.796228, 4.727847, -181.605488>,
				< 94.782621, 4.244289, -189.445406>,
				< 85.610405, 17.702518, -191.277832>
			}
			triangle {
				< 94.530262, -7.674146, -185.942277>,
				< 94.782621, 4.244289, -189.445406>,
				< 84.796228, 4.727847, -181.605488>
			}
			triangle {
				< 84.475048, -8.565426, -177.700624>,
				< 94.530262, -7.674146, -185.942277>,
				< 84.796228, 4.727847, -181.605488>
			}
			triangle {
				< 94.667546, -19.066082, -187.854439>,
				< 94.530262, -7.674146, -185.942277>,
				< 84.475048, -8.565426, -177.700624>
			}
			triangle {
				< 84.649831, -21.271497, -179.832086>,
				< 94.667546, -19.066082, -187.854439>,
				< 84.475048, -8.565426, -177.700624>
			}
			triangle {
				< 103.916556, -23.795418, -207.278743>,
				< 103.528768, -15.557774, -201.401383>,
				< 94.667546, -19.066082, -187.854439>
			}
			triangle {
				< 95.193572, -29.155085, -195.050567>,
				< 103.916556, -23.795418, -207.278743>,
				< 94.667546, -19.066082, -187.854439>
			}
			triangle {
				< 104.584143, -30.407872, -217.068970>,
				< 103.916556, -23.795418, -207.278743>,
				< 95.193572, -29.155085, -195.050567>
			}
			triangle {
				< 96.102111, -37.253663, -207.036719>,
				< 104.584143, -30.407872, -217.068970>,
				< 95.193572, -29.155085, -195.050567>
			}
			triangle {
				< 105.514720, -34.944497, -230.101451>,
				< 104.584143, -30.407872, -217.068970>,
				< 96.102111, -37.253663, -207.036719>
			}
			triangle {
				< 97.374305, -42.809870, -222.990215>,
				< 105.514720, -34.944497, -230.101451>,
				< 96.102111, -37.253663, -207.036719>
			}
			triangle {
				< 106.674820, -37.096165, -245.484069>,
				< 105.514720, -34.944497, -230.101451>,
				< 97.374305, -42.809870, -222.990215>
			}
			triangle {
				< 98.968349, -45.445092, -241.818056>,
				< 106.674820, -37.096165, -245.484069>,
				< 97.374305, -42.809870, -222.990215>
			}
			triangle {
				< 108.008541, -36.716208, -262.165815>,
				< 106.674820, -37.096165, -245.484069>,
				< 98.968349, -45.445092, -241.818056>
			}
			triangle {
				< 100.810148, -44.979751, -262.232006>,
				< 108.008541, -36.716208, -262.165815>,
				< 98.968349, -45.445092, -241.818056>
			}
			triangle {
				< 109.435014, -33.830546, -279.008150>,
				< 108.008541, -36.716208, -262.165815>,
				< 100.810148, -44.979751, -262.232006>
			}
			triangle {
				< 102.789305, -41.445546, -282.838285>,
				< 109.435014, -33.830546, -279.008150>,
				< 100.810148, -44.979751, -262.232006>
			}
			triangle {
				< 110.851400, -28.635811, -294.863790>,
				< 109.435014, -33.830546, -279.008150>,
				< 102.789305, -41.445546, -282.838285>
			}
			triangle {
				< 104.762532, -35.083316, -302.233547>,
				< 110.851400, -28.635811, -294.863790>,
				< 102.789305, -41.445546, -282.838285>
			}
			triangle {
				< 112.141423, -21.486029, -308.654577>,
				< 110.851400, -28.635811, -294.863790>,
				< 104.762532, -35.083316, -302.233547>
			}
			triangle {
				< 106.565647, -26.326669, -319.099814>,
				< 112.141423, -21.486029, -308.654577>,
				< 104.762532, -35.083316, -302.233547>
			}
			triangle {
				< 113.188438, -12.868429, -319.444448>,
				< 112.141423, -21.486029, -308.654577>,
				< 106.565647, -26.326669, -319.099814>
			}
			triangle {
				< 108.032823, -15.772309, -332.293838>,
				< 113.188438, -12.868429, -319.444448>,
				< 106.565647, -26.326669, -319.099814>
			}
			triangle {
				< 113.891266, -3.370294, -326.502353>,
				< 113.188438, -12.868429, -319.444448>,
				< 108.032823, -15.772309, -332.293838>
			}
			triangle {
				< 109.019347, -4.139524, -340.923101>,
				< 113.891266, -3.370294, -326.502353>,
				< 108.032823, -15.772309, -332.293838>
			}
			triangle {
				< 114.178881, 6.361070, -329.350352>,
				< 113.891266, -3.370294, -326.502353>,
				< 109.019347, -4.139524, -340.923101>
			}
			triangle {
				< 109.423444, 7.778910, -344.405055>,
				< 114.178881, 6.361070, -329.350352>,
				< 109.019347, -4.139524, -340.923101>
			}
			triangle {
				< 114.021622, 15.662508, -327.795863>,
				< 114.178881, 6.361070, -329.350352>,
				< 109.423444, 7.778910, -344.405055>
			}
			triangle {
				< 109.202445, 19.170804, -342.504621>,
				< 114.021622, 15.662508, -327.795863>,
				< 109.423444, 7.778910, -344.405055>
			}
			triangle {
				< 113.435738, 23.900162, -321.944058>,
				< 114.021622, 15.662508, -327.795863>,
				< 109.202445, 19.170804, -342.504621>
			}
			triangle {
				< 108.379781, 29.259818, -335.349977>,
				< 113.435738, 23.900162, -321.944058>,
				< 109.202445, 19.170804, -342.504621>
			}
			triangle {
				< 112.480916, 30.512607, -312.190950>,
				< 113.435738, 23.900162, -321.944058>,
				< 108.379781, 29.259818, -335.349977>
			}
			triangle {
				< 107.041031, 37.358373, -323.424250>,
				< 112.480916, 30.512607, -312.190950>,
				< 108.379781, 29.259818, -335.349977>
			}
			triangle {
				< 111.250952, 35.049245, -299.197197>,
				< 112.480916, 30.512607, -312.190950>,
				< 107.041031, 37.358373, -323.424250>
			}
			triangle {
				< 105.320379, 42.914599, -307.533652>,
				< 111.250952, 35.049245, -299.197197>,
				< 107.041031, 37.358373, -323.424250>
			}
			triangle {
				< 109.859467, 37.200902, -283.844262>,
				< 111.250952, 35.049245, -299.197197>,
				< 105.320379, 42.914599, -307.533652>
			}
			triangle {
				< 103.379846, 45.549825, -288.754374>,
				< 109.859467, 37.200902, -283.844262>,
				< 105.320379, 42.914599, -307.533652>
			}
			triangle {
				< 108.424440, 36.820944, -267.175704>,
				< 109.859467, 37.200902, -283.844262>,
				< 103.379846, 45.549825, -288.754374>
			}
			triangle {
				< 101.386279, 45.084488, -268.361777>,
				< 108.424440, 36.820944, -267.175704>,
				< 103.379846, 45.549825, -288.754374>
			}
			triangle {
				< 107.053868, 33.935282, -250.326067>,
				< 108.424440, 36.820944, -267.175704>,
				< 101.386279, 45.084488, -268.361777>
			}
			triangle {
				< 99.490792, 41.550301, -247.743711>,
				< 107.053868, 33.935282, -250.326067>,
				< 101.386279, 45.084488, -268.361777>
			}
			triangle {
				< 105.835527, 28.740553, -234.445006>,
				< 107.053868, 33.935282, -250.326067>,
				< 99.490792, 41.550301, -247.743711>
			}
			triangle {
				< 97.814284, 35.188071, -228.306890>,
				< 105.835527, 28.740553, -234.445006>,
				< 99.490792, 41.550301, -247.743711>
			}
			triangle {
				< 104.832716, 21.590773, -220.617071>,
				< 105.835527, 28.740553, -234.445006>,
				< 97.814284, 35.188071, -228.306890>
			}
			triangle {
				< 96.441366, 26.431413, -211.380258>,
				< 104.832716, 21.590773, -220.617071>,
				< 97.814284, 35.188071, -228.306890>
			}
			triangle {
				< 104.085103, 12.973183, -209.788501>,
				< 104.832716, 21.590773, -220.617071>,
				< 96.441366, 26.431413, -211.380258>
			}
			triangle {
				< 95.422618, 15.877062, -198.123381>,
				< 104.085103, 12.973183, -209.788501>,
				< 96.441366, 26.431413, -211.380258>
			}
			triangle {
				< 103.613652, 3.475058, -202.700794>,
				< 104.085103, 12.973183, -209.788501>,
				< 95.422618, 15.877062, -198.123381>
			}
			triangle {
				< 94.782621, 4.244289, -189.445406>,
				< 103.613652, 3.475058, -202.700794>,
				< 95.422618, 15.877062, -198.123381>
			}
			triangle {
				< 103.427343, -6.256306, -199.839771>,
				< 103.613652, 3.475058, -202.700794>,
				< 94.782621, 4.244289, -189.445406>
			}
			triangle {
				< 94.530262, -7.674146, -185.942277>,
				< 103.427343, -6.256306, -199.839771>,
				< 94.782621, 4.244289, -189.445406>
			}
			triangle {
				< 103.528768, -15.557774, -201.401383>,
				< 103.427343, -6.256306, -199.839771>,
				< 94.530262, -7.674146, -185.942277>
			}
			triangle {
				< 94.667546, -19.066082, -187.854439>,
				< 103.528768, -15.557774, -201.401383>,
				< 94.530262, -7.674146, -185.942277>
			}
			triangle {
				< 110.881217, -16.810564, -223.649070>,
				< 110.621177, -10.985663, -219.493225>,
				< 103.528768, -15.557774, -201.401383>
			}
			triangle {
				< 103.916556, -23.795418, -207.278743>,
				< 110.881217, -16.810564, -223.649070>,
				< 103.528768, -15.557774, -201.401383>
			}
			triangle {
				< 111.325234, -21.486277, -230.572104>,
				< 110.881217, -16.810564, -223.649070>,
				< 103.916556, -23.795418, -207.278743>
			}
			triangle {
				< 104.584143, -30.407872, -217.068970>,
				< 111.325234, -21.486277, -230.572104>,
				< 103.916556, -23.795418, -207.278743>
			}
			triangle {
				< 111.937322, -24.694173, -239.789039>,
				< 111.325234, -21.486277, -230.572104>,
				< 104.584143, -30.407872, -217.068970>
			}
			triangle {
				< 105.514720, -34.944497, -230.101451>,
				< 111.937322, -24.694173, -239.789039>,
				< 104.584143, -30.407872, -217.068970>
			}
			triangle {
				< 112.690777, -26.215615, -250.669956>,
				< 111.937322, -24.694173, -239.789039>,
				< 105.514720, -34.944497, -230.101451>
			}
			triangle {
				< 106.674820, -37.096165, -245.484069>,
				< 112.690777, -26.215615, -250.669956>,
				< 105.514720, -34.944497, -230.101451>
			}
			triangle {
				< 113.545783, -25.946941, -262.471765>,
				< 112.690777, -26.215615, -250.669956>,
				< 106.674820, -37.096165, -245.484069>
			}
			triangle {
				< 108.008541, -36.716208, -262.165815>,
				< 113.545783, -25.946941, -262.471765>,
				< 106.674820, -37.096165, -245.484069>
			}
			triangle {
				< 114.449158, -23.906475, -274.389714>,
				< 113.545783, -25.946941, -262.471765>,
				< 108.008541, -36.716208, -262.165815>
			}
			triangle {
				< 109.435014, -33.830546, -279.008150>,
				< 114.449158, -23.906475, -274.389714>,
				< 108.008541, -36.716208, -262.165815>
			}
			triangle {
				< 115.336500, -20.233240, -285.611808>,
				< 114.449158, -23.906475, -274.389714>,
				< 109.435014, -33.830546, -279.008150>
			}
			triangle {
				< 110.851400, -28.635811, -294.863790>,
				< 115.336500, -20.233240, -285.611808>,
				< 109.435014, -33.830546, -279.008150>
			}
			triangle {
				< 116.137445, -15.177570, -295.374393>,
				< 115.336500, -20.233240, -285.611808>,
				< 110.851400, -28.635811, -294.863790>
			}
			triangle {
				< 112.141423, -21.486029, -308.654577>,
				< 116.137445, -15.177570, -295.374393>,
				< 110.851400, -28.635811, -294.863790>
			}
			triangle {
				< 116.783097, -9.084015, -303.013980>,
				< 116.137445, -15.177570, -295.374393>,
				< 112.141423, -21.486029, -308.654577>
			}
			triangle {
				< 113.188438, -12.868429, -319.444448>,
				< 116.783097, -9.084015, -303.013980>,
				< 112.141423, -21.486029, -308.654577>
			}
			triangle {
				< 117.214382, -2.367835, -308.011651>,
				< 116.783097, -9.084015, -303.013980>,
				< 113.188438, -12.868429, -319.444448>
			}
			triangle {
				< 113.891266, -3.370294, -326.502353>,
				< 117.214382, -2.367835, -308.011651>,
				< 113.188438, -12.868429, -319.444448>
			}
			triangle {
				< 117.390446, 4.513294, -310.028523>,
				< 117.214382, -2.367835, -308.011651>,
				< 113.891266, -3.370294, -326.502353>
			}
			triangle {
				< 114.178881, 6.361070, -329.350352>,
				< 117.390446, 4.513294, -310.028523>,
				< 113.891266, -3.370294, -326.502353>
			}
			triangle {
				< 117.294192, 11.090406, -308.927625>,
				< 117.390446, 4.513294, -310.028523>,
				< 114.178881, 6.361070, -329.350352>
			}
			triangle {
				< 114.021622, 15.662508, -327.795863>,
				< 117.294192, 11.090406, -308.927625>,
				< 114.178881, 6.361070, -329.350352>
			}
			triangle {
				< 116.934985, 16.915297, -304.783762>,
				< 117.294192, 11.090406, -308.927625>,
				< 114.021622, 15.662508, -327.795863>
			}
			triangle {
				< 113.435738, 23.900162, -321.944058>,
				< 116.934985, 16.915297, -304.783762>,
				< 114.021622, 15.662508, -327.795863>
			}
			triangle {
				< 116.347194, 21.591011, -297.878027>,
				< 116.934985, 16.915297, -304.783762>,
				< 113.435738, 23.900162, -321.944058>
			}
			triangle {
				< 112.480916, 30.512607, -312.190950>,
				< 116.347194, 21.591011, -297.878027>,
				< 113.435738, 23.900162, -321.944058>
			}
			triangle {
				< 115.585253, 24.798896, -288.679302>,
				< 116.347194, 21.591011, -297.878027>,
				< 112.480916, 30.512607, -312.190950>
			}
			triangle {
				< 111.250952, 35.049245, -299.197197>,
				< 115.585253, 24.798896, -288.679302>,
				< 112.480916, 30.512607, -312.190950>
			}
			triangle {
				< 114.715986, 26.320359, -277.812332>,
				< 115.585253, 24.798896, -288.679302>,
				< 111.250952, 35.049245, -299.197197>
			}
			triangle {
				< 109.859467, 37.200902, -283.844262>,
				< 114.715986, 26.320359, -277.812332>,
				< 111.250952, 35.049245, -299.197197>
			}
			triangle {
				< 113.810271, 26.051685, -266.016483>,
				< 114.715986, 26.320359, -277.812332>,
				< 109.859467, 37.200902, -283.844262>
			}
			triangle {
				< 108.424440, 36.820944, -267.175704>,
				< 113.810271, 26.051685, -266.016483>,
				< 109.859467, 37.200902, -283.844262>
			}
			triangle {
				< 112.934880, 24.011198, -254.095227>,
				< 113.810271, 26.051685, -266.016483>,
				< 108.424440, 36.820944, -267.175704>
			}
			triangle {
				< 107.053868, 33.935282, -250.326067>,
				< 112.934880, 24.011198, -254.095227>,
				< 108.424440, 36.820944, -267.175704>
			}
			triangle {
				< 112.146676, 20.337984, -242.861196>,
				< 112.934880, 24.011198, -254.095227>,
				< 107.053868, 33.935282, -250.326067>
			}
			triangle {
				< 105.835527, 28.740553, -234.445006>,
				< 112.146676, 20.337984, -242.861196>,
				< 107.053868, 33.935282, -250.326067>
			}
			triangle {
				< 111.489497, 15.282324, -233.081311>,
				< 112.146676, 20.337984, -242.861196>,
				< 105.835527, 28.740553, -234.445006>
			}
			triangle {
				< 104.832716, 21.590773, -220.617071>,
				< 111.489497, 15.282324, -233.081311>,
				< 105.835527, 28.740553, -234.445006>
			}
			triangle {
				< 110.993721, 9.188780, -225.423723>,
				< 111.489497, 15.282324, -233.081311>,
				< 104.832716, 21.590773, -220.617071>
			}
			triangle {
				< 104.085103, 12.973183, -209.788501>,
				< 110.993721, 9.188780, -225.423723>,
				< 104.832716, 21.590773, -220.617071>
			}
			triangle {
				< 110.678241, 2.472578, -220.412031>,
				< 110.993721, 9.188780, -225.423723>,
				< 104.085103, 12.973183, -209.788501>
			}
			triangle {
				< 103.613652, 3.475058, -202.700794>,
				< 110.678241, 2.472578, -220.412031>,
				< 104.085103, 12.973183, -209.788501>
			}
			triangle {
				< 110.552900, -4.408529, -218.389049>,
				< 110.678241, 2.472578, -220.412031>,
				< 103.613652, 3.475058, -202.700794>
			}
			triangle {
				< 103.427343, -6.256306, -199.839771>,
				< 110.552900, -4.408529, -218.389049>,
				< 103.613652, 3.475058, -202.700794>
			}
			triangle {
				< 110.621177, -10.985663, -219.493225>,
				< 110.552900, -4.408529, -218.389049>,
				< 103.427343, -6.256306, -199.839771>
			}
			triangle {
				< 103.528768, -15.557774, -201.401383>,
				< 110.621177, -10.985663, -219.493225>,
				< 103.427343, -6.256306, -199.839771>
			}
			triangle {
				< 115.715981, -8.676522, -242.985412>,
				< 115.580283, -5.661339, -240.834907>,
				< 110.621177, -10.985663, -219.493225>
			}
			triangle {
				< 110.881217, -16.810564, -223.649070>,
				< 115.715981, -8.676522, -242.985412>,
				< 110.621177, -10.985663, -219.493225>
			}
			triangle {
				< 115.944967, -11.096864, -246.568292>,
				< 115.715981, -8.676522, -242.985412>,
				< 110.881217, -16.810564, -223.649070>
			}
			triangle {
				< 111.325234, -21.486277, -230.572104>,
				< 115.944967, -11.096864, -246.568292>,
				< 110.881217, -16.810564, -223.649070>
			}
			triangle {
				< 116.255485, -12.757394, -251.338780>,
				< 115.944967, -11.096864, -246.568292>,
				< 111.325234, -21.486277, -230.572104>
			}
			triangle {
				< 111.937322, -24.694173, -239.789039>,
				< 116.255485, -12.757394, -251.338780>,
				< 111.325234, -21.486277, -230.572104>
			}
			triangle {
				< 116.630405, -13.544947, -256.971478>,
				< 116.255485, -12.757394, -251.338780>,
				< 111.937322, -24.694173, -239.789039>
			}
			triangle {
				< 112.690777, -26.215615, -250.669956>,
				< 116.630405, -13.544947, -256.971478>,
				< 111.937322, -24.694173, -239.789039>
			}
			triangle {
				< 117.047258, -13.405880, -263.082147>,
				< 116.630405, -13.544947, -256.971478>,
				< 112.690777, -26.215615, -250.669956>
			}
			triangle {
				< 113.545783, -25.946941, -262.471765>,
				< 117.047258, -13.405880, -263.082147>,
				< 112.690777, -26.215615, -250.669956>
			}
			triangle {
				< 117.478974, -12.349653, -269.254088>,
				< 117.047258, -13.405880, -263.082147>,
				< 113.545783, -25.946941, -262.471765>
			}
			triangle {
				< 114.449158, -23.906475, -274.389714>,
				< 117.478974, -12.349653, -269.254088>,
				< 113.545783, -25.946941, -262.471765>
			}
			triangle {
				< 117.895395, -10.448254, -275.066793>,
				< 117.478974, -12.349653, -269.254088>,
				< 114.449158, -23.906475, -274.389714>
			}
			triangle {
				< 115.336500, -20.233240, -285.611808>,
				< 117.895395, -10.448254, -275.066793>,
				< 114.449158, -23.906475, -274.389714>
			}
			triangle {
				< 118.265532, -7.831226, -280.124545>,
				< 117.895395, -10.448254, -275.066793>,
				< 115.336500, -20.233240, -285.611808>
			}
			triangle {
				< 116.137445, -15.177570, -295.374393>,
				< 118.265532, -7.831226, -280.124545>,
				< 115.336500, -20.233240, -285.611808>
			}
			triangle {
				< 118.560232, -4.676975, -284.082949>,
				< 118.265532, -7.831226, -280.124545>,
				< 116.137445, -15.177570, -295.374393>
			}
			triangle {
				< 116.783097, -9.084015, -303.013980>,
				< 118.560232, -4.676975, -284.082949>,
				< 116.137445, -15.177570, -295.374393>
			}
			triangle {
				< 118.755467, -1.200407, -286.672890>,
				< 118.560232, -4.676975, -284.082949>,
				< 116.783097, -9.084015, -303.013980>
			}
			triangle {
				< 117.214382, -2.367835, -308.011651>,
				< 118.755467, -1.200407, -286.672890>,
				< 116.783097, -9.084015, -303.013980>
			}
			triangle {
				< 118.834786, 2.361523, -287.718087>,
				< 118.755467, -1.200407, -286.672890>,
				< 117.214382, -2.367835, -308.011651>
			}
			triangle {
				< 117.390446, 4.513294, -310.028523>,
				< 118.834786, 2.361523, -287.718087>,
				< 117.214382, -2.367835, -308.011651>
			}
			triangle {
				< 118.791446, 5.766104, -287.147671>,
				< 118.834786, 2.361523, -287.718087>,
				< 117.390446, 4.513294, -310.028523>
			}
			triangle {
				< 117.294192, 11.090406, -308.927625>,
				< 118.791446, 5.766104, -287.147671>,
				< 117.390446, 4.513294, -310.028523>
			}
			triangle {
				< 118.629158, 8.781287, -285.000116>,
				< 118.791446, 5.766104, -287.147671>,
				< 117.294192, 11.090406, -308.927625>
			}
			triangle {
				< 116.934985, 16.915297, -304.783762>,
				< 118.629158, 8.781287, -285.000116>,
				< 117.294192, 11.090406, -308.927625>
			}
			triangle {
				< 118.361622, 11.201607, -281.421751>,
				< 118.629158, 8.781287, -285.000116>,
				< 116.934985, 16.915297, -304.783762>
			}
			triangle {
				< 116.347194, 21.591011, -297.878027>,
				< 118.361622, 11.201607, -281.421751>,
				< 116.934985, 16.915297, -304.783762>
			}
			triangle {
				< 118.010916, 12.862117, -276.655883>,
				< 118.361622, 11.201607, -281.421751>,
				< 116.347194, 21.591011, -297.878027>
			}
			triangle {
				< 115.585253, 24.798896, -288.679302>,
				< 118.010916, 12.862117, -276.655883>,
				< 116.347194, 21.591011, -297.878027>
			}
			triangle {
				< 117.604956, 13.649682, -271.026731>,
				< 118.010916, 12.862117, -276.655883>,
				< 115.585253, 24.798896, -288.679302>
			}
			triangle {
				< 114.715986, 26.320359, -277.812332>,
				< 117.604956, 13.649682, -271.026731>,
				< 115.585253, 24.798896, -288.679302>
			}
			triangle {
				< 117.174529, 13.510624, -264.917701>,
				< 117.604956, 13.649682, -271.026731>,
				< 114.715986, 26.320359, -277.812332>
			}
			triangle {
				< 113.810271, 26.051685, -266.016483>,
				< 117.174529, 13.510624, -264.917701>,
				< 114.715986, 26.320359, -277.812332>
			}
			triangle {
				< 116.750307, 12.454386, -258.744895>,
				< 117.174529, 13.510624, -264.917701>,
				< 113.810271, 26.051685, -266.016483>
			}
			triangle {
				< 112.934880, 24.011198, -254.095227>,
				< 116.750307, 12.454386, -258.744895>,
				< 113.810271, 26.051685, -266.016483>
			}
			triangle {
				< 116.360448, 10.552987, -252.929091>,
				< 116.750307, 12.454386, -258.744895>,
				< 112.934880, 24.011198, -254.095227>
			}
			triangle {
				< 112.146676, 20.337984, -242.861196>,
				< 116.360448, 10.552987, -252.929091>,
				< 112.934880, 24.011198, -254.095227>
			}
			triangle {
				< 116.028853, 7.935991, -247.866914>,
				< 116.360448, 10.552987, -252.929091>,
				< 112.146676, 20.337984, -242.861196>
			}
			triangle {
				< 111.489497, 15.282324, -233.081311>,
				< 116.028853, 7.935991, -247.866914>,
				< 112.146676, 20.337984, -242.861196>
			}
			triangle {
				< 115.774326, 4.781719, -243.903831>,
				< 116.028853, 7.935991, -247.866914>,
				< 111.489497, 15.282324, -233.081311>
			}
			triangle {
				< 110.993721, 9.188780, -225.423723>,
				< 115.774326, 4.781719, -243.903831>,
				< 111.489497, 15.282324, -233.081311>
			}
			triangle {
				< 115.610190, 1.305172, -241.310388>,
				< 115.774326, 4.781719, -243.903831>,
				< 110.993721, 9.188780, -225.423723>
			}
			triangle {
				< 110.678241, 2.472578, -220.412031>,
				< 115.610190, 1.305172, -241.310388>,
				< 110.993721, 9.188780, -225.423723>
			}
			triangle {
				< 115.544431, -2.256759, -240.263537>,
				< 115.610190, 1.305172, -241.310388>,
				< 110.678241, 2.472578, -220.412031>
			}
			triangle {
				< 110.552900, -4.408529, -218.389049>,
				< 115.544431, -2.256759, -240.263537>,
				< 110.678241, 2.472578, -220.412031>
			}
			triangle {
				< 115.580283, -5.661339, -240.834907>,
				< 115.544431, -2.256759, -240.263537>,
				< 110.552900, -4.408529, -218.389049>
			}
			triangle {
				< 110.621177, -10.985663, -219.493225>,
				< 115.580283, -5.661339, -240.834907>,
				< 110.552900, -4.408529, -218.389049>
			}
			triangle {
				< 115.610190, 1.305172, -241.310388>,
				< 115.544431, -2.256759, -240.263537>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 115.774326, 4.781719, -243.903831>,
				< 115.610190, 1.305172, -241.310388>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 116.028853, 7.935991, -247.866914>,
				< 115.774326, 4.781719, -243.903831>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 116.360448, 10.552987, -252.929091>,
				< 116.028853, 7.935991, -247.866914>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 116.750307, 12.454386, -258.744895>,
				< 116.360448, 10.552987, -252.929091>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 117.174529, 13.510624, -264.917701>,
				< 116.750307, 12.454386, -258.744895>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 117.604956, 13.649682, -271.026731>,
				< 117.174529, 13.510624, -264.917701>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 118.010916, 12.862117, -276.655883>,
				< 117.604956, 13.649682, -271.026731>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 118.361622, 11.201607, -281.421751>,
				< 118.010916, 12.862117, -276.655883>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 118.629158, 8.781287, -285.000116>,
				< 118.361622, 11.201607, -281.421751>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 118.791446, 5.766104, -287.147671>,
				< 118.629158, 8.781287, -285.000116>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 118.834786, 2.361523, -287.718087>,
				< 118.791446, 5.766104, -287.147671>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 118.755467, -1.200407, -286.672890>,
				< 118.834786, 2.361523, -287.718087>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 118.560232, -4.676975, -284.082949>,
				< 118.755467, -1.200407, -286.672890>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 118.265532, -7.831226, -280.124545>,
				< 118.560232, -4.676975, -284.082949>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 117.895395, -10.448254, -275.066793>,
				< 118.265532, -7.831226, -280.124545>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 117.478974, -12.349653, -269.254088>,
				< 117.895395, -10.448254, -275.066793>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 117.047258, -13.405880, -263.082147>,
				< 117.478974, -12.349653, -269.254088>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 116.630405, -13.544947, -256.971478>,
				< 117.047258, -13.405880, -263.082147>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 116.255485, -12.757394, -251.338780>,
				< 116.630405, -13.544947, -256.971478>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 115.944967, -11.096864, -246.568292>,
				< 116.255485, -12.757394, -251.338780>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 115.715981, -8.676522, -242.985412>,
				< 115.944967, -11.096864, -246.568292>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 115.580283, -5.661339, -240.834907>,
				< 115.715981, -8.676522, -242.985412>,
				< 118.281685, 0.052382, -263.920844>
			}
			triangle {
				< 115.544431, -2.256759, -240.263537>,
				< 115.580283, -5.661339, -240.834907>,
				< 118.281685, 0.052382, -263.920844>
			}
			
		}
		// _Knee01
		union {
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 123.939425, -51.937379, -177.038953>,
				< 123.995602, -53.543873, -178.185955>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 123.995602, -53.543873, -178.185955>,
				< 124.087080, -54.833431, -180.096954>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.087080, -54.833431, -180.096954>,
				< 124.204636, -55.718150, -182.641909>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.204636, -55.718150, -182.641909>,
				< 124.337219, -56.137774, -185.647368>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.337219, -56.137774, -185.647368>,
				< 124.473453, -56.063656, -188.908607>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.473453, -56.063656, -188.908607>,
				< 124.603063, -55.500902, -192.203283>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.603063, -55.500902, -192.203283>,
				< 124.717675, -54.487843, -195.306823>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.717675, -54.487843, -195.306823>,
				< 124.811582, -53.093504, -198.007897>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.811582, -53.093504, -198.007897>,
				< 124.881312, -51.412910, -200.122207>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.881312, -51.412910, -200.122207>,
				< 124.925114, -49.560599, -201.505691>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.925114, -49.560599, -201.505691>,
				< 124.942400, -47.662817, -202.064112>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.942400, -47.662817, -202.064112>,
				< 124.932997, -45.848850, -201.759353>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.932997, -45.848850, -201.759353>,
				< 124.896981, -44.242356, -200.612113>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.896981, -44.242356, -200.612113>,
				< 124.834813, -42.952817, -198.700726>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.834813, -42.952817, -198.700726>,
				< 124.747783, -42.068083, -196.155444>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.747783, -42.068083, -196.155444>,
				< 124.638759, -41.648474, -193.149656>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.638759, -41.648474, -193.149656>,
				< 124.512851, -41.722558, -189.888388>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.512851, -41.722558, -189.888388>,
				< 124.377564, -42.285323, -186.593756>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.377564, -42.285323, -186.593756>,
				< 124.242753, -43.298390, -183.490396>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.242753, -43.298390, -183.490396>,
				< 124.119543, -44.692729, -180.789724>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.119543, -44.692729, -180.789724>,
				< 124.019325, -46.373323, -178.675815>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 124.019325, -46.373323, -178.675815>,
				< 123.951949, -48.225634, -177.292541>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 123.951949, -48.225634, -177.292541>,
				< 123.924308, -50.123431, -176.734239>
			}
			triangle {
				< 125.387087, -48.893128, -189.359903>,
				< 123.924308, -50.123431, -176.734239>,
				< 123.939425, -51.937379, -177.038953>
			}
			triangle {
				< 123.939425, -51.937379, -177.038953>,
				< 120.523557, -54.774199, -165.652096>,
				< 120.666802, -57.877686, -167.866588>
			}
			triangle {
				< 123.939425, -51.937379, -177.038953>,
				< 120.666802, -57.877686, -167.866588>,
				< 123.995602, -53.543873, -178.185955>
			}
			triangle {
				< 123.995602, -53.543873, -178.185955>,
				< 120.666802, -57.877686, -167.866588>,
				< 120.897315, -60.368914, -171.556547>
			}
			triangle {
				< 123.995602, -53.543873, -178.185955>,
				< 120.897315, -60.368914, -171.556547>,
				< 124.087080, -54.833431, -180.096954>
			}
			triangle {
				< 124.087080, -54.833431, -180.096954>,
				< 120.897315, -60.368914, -171.556547>,
				< 121.188462, -62.078081, -176.470682>
			}
			triangle {
				< 124.087080, -54.833431, -180.096954>,
				< 121.188462, -62.078081, -176.470682>,
				< 124.204636, -55.718150, -182.641909>
			}
			triangle {
				< 124.204636, -55.718150, -182.641909>,
				< 121.188462, -62.078081, -176.470682>,
				< 121.509045, -62.888697, -182.274386>
			}
			triangle {
				< 124.204636, -55.718150, -182.641909>,
				< 121.509045, -62.888697, -182.274386>,
				< 124.337219, -56.137774, -185.647368>
			}
			triangle {
				< 124.337219, -56.137774, -185.647368>,
				< 121.509045, -62.888697, -182.274386>,
				< 121.828392, -62.745556, -188.572079>
			}
			triangle {
				< 124.337219, -56.137774, -185.647368>,
				< 121.828392, -62.745556, -188.572079>,
				< 124.473453, -56.063656, -188.908607>
			}
			triangle {
				< 124.473453, -56.063656, -188.908607>,
				< 121.828392, -62.745556, -188.572079>,
				< 122.120917, -61.658375, -194.934785>
			}
			triangle {
				< 124.473453, -56.063656, -188.908607>,
				< 122.120917, -61.658375, -194.934785>,
				< 124.603063, -55.500902, -192.203283>
			}
			triangle {
				< 124.603063, -55.500902, -192.203283>,
				< 122.120917, -61.658375, -194.934785>,
				< 122.368805, -59.701305, -200.928718>
			}
			triangle {
				< 124.603063, -55.500902, -192.203283>,
				< 122.368805, -59.701305, -200.928718>,
				< 124.717675, -54.487843, -195.306823>
			}
			triangle {
				< 124.717675, -54.487843, -195.306823>,
				< 122.368805, -59.701305, -200.928718>,
				< 122.562692, -57.007626, -206.145301>
			}
			triangle {
				< 124.717675, -54.487843, -195.306823>,
				< 122.562692, -57.007626, -206.145301>,
				< 124.811582, -53.093504, -198.007897>
			}
			triangle {
				< 124.811582, -53.093504, -198.007897>,
				< 122.562692, -57.007626, -206.145301>,
				< 122.700252, -53.760972, -210.228875>
			}
			triangle {
				< 124.811582, -53.093504, -198.007897>,
				< 122.700252, -53.760972, -210.228875>,
				< 124.881312, -51.412910, -200.122207>
			}
			triangle {
				< 124.881312, -51.412910, -200.122207>,
				< 122.700252, -53.760972, -210.228875>,
				< 122.783571, -50.182603, -212.900996>
			}
			triangle {
				< 124.881312, -51.412910, -200.122207>,
				< 122.783571, -50.182603, -212.900996>,
				< 124.925114, -49.560599, -201.505691>
			}
			triangle {
				< 124.925114, -49.560599, -201.505691>,
				< 122.783571, -50.182603, -212.900996>,
				< 122.815676, -46.516322, -213.979498>
			}
			triangle {
				< 124.925114, -49.560599, -201.505691>,
				< 122.815676, -46.516322, -213.979498>,
				< 124.942400, -47.662817, -202.064112>
			}
			triangle {
				< 124.942400, -47.662817, -202.064112>,
				< 122.815676, -46.516322, -213.979498>,
				< 122.798271, -43.012053, -213.390857>
			}
			triangle {
				< 124.942400, -47.662817, -202.064112>,
				< 122.798271, -43.012053, -213.390857>,
				< 124.932997, -45.848850, -201.759353>
			}
			triangle {
				< 124.932997, -45.848850, -201.759353>,
				< 122.798271, -43.012053, -213.390857>,
				< 122.730382, -39.908547, -211.175174>
			}
			triangle {
				< 124.932997, -45.848850, -201.759353>,
				< 122.730382, -39.908547, -211.175174>,
				< 124.896981, -44.242356, -200.612113>
			}
			triangle {
				< 124.896981, -44.242356, -200.612113>,
				< 122.730382, -39.908547, -211.175174>,
				< 122.609161, -37.417337, -207.483515>
			}
			triangle {
				< 124.896981, -44.242356, -200.612113>,
				< 122.609161, -37.417337, -207.483515>,
				< 124.834813, -42.952817, -198.700726>
			}
			triangle {
				< 124.834813, -42.952817, -198.700726>,
				< 122.609161, -37.417337, -207.483515>,
				< 122.431904, -35.708182, -202.567622>
			}
			triangle {
				< 124.834813, -42.952817, -198.700726>,
				< 122.431904, -35.708182, -202.567622>,
				< 124.747783, -42.068083, -196.155444>
			}
			triangle {
				< 124.747783, -42.068083, -196.155444>,
				< 122.431904, -35.708182, -202.567622>,
				< 122.199349, -34.897543, -196.762562>
			}
			triangle {
				< 124.747783, -42.068083, -196.155444>,
				< 122.199349, -34.897543, -196.762562>,
				< 124.638759, -41.648474, -193.149656>
			}
			triangle {
				< 124.638759, -41.648474, -193.149656>,
				< 122.199349, -34.897543, -196.762562>,
				< 121.918514, -35.040669, -190.464213>
			}
			triangle {
				< 124.638759, -41.648474, -193.149656>,
				< 121.918514, -35.040669, -190.464213>,
				< 124.512851, -41.722558, -189.888388>
			}
			triangle {
				< 124.512851, -41.722558, -189.888388>,
				< 121.918514, -35.040669, -190.464213>,
				< 121.604778, -36.127869, -184.101909>
			}
			triangle {
				< 124.512851, -41.722558, -189.888388>,
				< 121.604778, -36.127869, -184.101909>,
				< 124.377564, -42.285323, -186.593756>
			}
			triangle {
				< 124.377564, -42.285323, -186.593756>,
				< 121.604778, -36.127869, -184.101909>,
				< 121.281520, -38.084932, -178.109109>
			}
			triangle {
				< 124.377564, -42.285323, -186.593756>,
				< 121.281520, -38.084932, -178.109109>,
				< 124.242753, -43.298390, -183.490396>
			}
			triangle {
				< 124.242753, -43.298390, -183.490396>,
				< 121.281520, -38.084932, -178.109109>,
				< 120.978355, -40.778581, -172.894180>
			}
			triangle {
				< 124.242753, -43.298390, -183.490396>,
				< 120.978355, -40.778581, -172.894180>,
				< 124.119543, -44.692729, -180.789724>
			}
			triangle {
				< 124.119543, -44.692729, -180.789724>,
				< 120.978355, -40.778581, -172.894180>,
				< 120.726854, -44.025242, -168.812454>
			}
			triangle {
				< 124.119543, -44.692729, -180.789724>,
				< 120.726854, -44.025242, -168.812454>,
				< 124.019325, -46.373323, -178.675815>
			}
			triangle {
				< 124.019325, -46.373323, -178.675815>,
				< 120.726854, -44.025242, -168.812454>,
				< 120.555542, -47.603626, -166.141659>
			}
			triangle {
				< 124.019325, -46.373323, -178.675815>,
				< 120.555542, -47.603626, -166.141659>,
				< 123.951949, -48.225634, -177.292541>
			}
			triangle {
				< 123.951949, -48.225634, -177.292541>,
				< 120.555542, -47.603626, -166.141659>,
				< 120.484903, -51.269889, -165.063784>
			}
			triangle {
				< 123.951949, -48.225634, -177.292541>,
				< 120.484903, -51.269889, -165.063784>,
				< 123.924308, -50.123431, -176.734239>
			}
			triangle {
				< 123.924308, -50.123431, -176.734239>,
				< 120.484903, -51.269889, -165.063784>,
				< 120.523557, -54.774199, -165.652096>
			}
			triangle {
				< 123.924308, -50.123431, -176.734239>,
				< 120.523557, -54.774199, -165.652096>,
				< 123.939425, -51.937379, -177.038953>
			}
			triangle {
				< 120.523557, -54.774199, -165.652096>,
				< 115.276687, -57.210214, -156.002864>,
				< 115.538426, -61.599217, -159.131765>
			}
			triangle {
				< 120.523557, -54.774199, -165.652096>,
				< 115.538426, -61.599217, -159.131765>,
				< 120.666802, -57.877686, -167.866588>
			}
			triangle {
				< 120.666802, -57.877686, -167.866588>,
				< 115.538426, -61.599217, -159.131765>,
				< 115.958169, -65.122329, -164.345607>
			}
			triangle {
				< 120.666802, -57.877686, -167.866588>,
				< 115.958169, -65.122329, -164.345607>,
				< 120.897315, -60.368914, -171.556547>
			}
			triangle {
				< 120.897315, -60.368914, -171.556547>,
				< 115.958169, -65.122329, -164.345607>,
				< 116.485544, -67.539461, -171.289548>
			}
			triangle {
				< 120.897315, -60.368914, -171.556547>,
				< 116.485544, -67.539461, -171.289548>,
				< 121.188462, -62.078081, -176.470682>
			}
			triangle {
				< 121.188462, -62.078081, -176.470682>,
				< 116.485544, -67.539461, -171.289548>,
				< 117.061853, -68.685859, -179.491177>
			}
			triangle {
				< 121.188462, -62.078081, -176.470682>,
				< 117.061853, -68.685859, -179.491177>,
				< 121.509045, -62.888697, -182.274386>
			}
			triangle {
				< 121.509045, -62.888697, -182.274386>,
				< 117.061853, -68.685859, -179.491177>,
				< 117.630176, -68.483420, -188.391626>
			}
			triangle {
				< 121.509045, -62.888697, -182.274386>,
				< 117.630176, -68.483420, -188.391626>,
				< 121.828392, -62.745556, -188.572079>
			}
			triangle {
				< 121.828392, -62.745556, -188.572079>,
				< 117.630176, -68.483420, -188.391626>,
				< 118.144125, -66.945933, -197.384506>
			}
			triangle {
				< 121.828392, -62.745556, -188.572079>,
				< 118.144125, -66.945933, -197.384506>,
				< 122.120917, -61.658375, -194.934785>
			}
			triangle {
				< 122.120917, -61.658375, -194.934785>,
				< 118.144125, -66.945933, -197.384506>,
				< 118.572921, -64.178176, -205.856800>
			}
			triangle {
				< 122.120917, -61.658375, -194.934785>,
				< 118.572921, -64.178176, -205.856800>,
				< 122.368805, -59.701305, -200.928718>
			}
			triangle {
				< 122.368805, -59.701305, -200.928718>,
				< 118.572921, -64.178176, -205.856800>,
				< 118.902408, -60.368776, -213.230684>
			}
			triangle {
				< 122.368805, -59.701305, -200.928718>,
				< 118.902408, -60.368776, -213.230684>,
				< 122.562692, -57.007626, -206.145301>
			}
			triangle {
				< 122.562692, -57.007626, -206.145301>,
				< 118.902408, -60.368776, -213.230684>,
				< 119.131923, -55.777323, -219.003201>
			}
			triangle {
				< 122.562692, -57.007626, -206.145301>,
				< 119.131923, -55.777323, -219.003201>,
				< 122.700252, -53.760972, -210.228875>
			}
			triangle {
				< 122.700252, -53.760972, -210.228875>,
				< 119.131923, -55.777323, -219.003201>,
				< 119.268633, -50.716724, -222.780541>
			}
			triangle {
				< 122.700252, -53.760972, -210.228875>,
				< 119.268633, -50.716724, -222.780541>,
				< 122.783571, -50.182603, -212.900996>
			}
			triangle {
				< 122.783571, -50.182603, -212.900996>,
				< 119.268633, -50.716724, -222.780541>,
				< 119.320810, -45.531835, -224.305212>
			}
			triangle {
				< 122.783571, -50.182603, -212.900996>,
				< 119.320810, -45.531835, -224.305212>,
				< 122.815676, -46.516322, -213.979498>
			}
			triangle {
				< 122.815676, -46.516322, -213.979498>,
				< 119.320810, -45.531835, -224.305212>,
				< 119.292550, -40.576018, -223.473042>
			}
			triangle {
				< 122.815676, -46.516322, -213.979498>,
				< 119.292550, -40.576018, -223.473042>,
				< 122.798271, -43.012053, -213.390857>
			}
			triangle {
				< 122.798271, -43.012053, -213.390857>,
				< 119.292550, -40.576018, -223.473042>,
				< 119.181551, -36.187042, -220.340848>
			}
			triangle {
				< 122.798271, -43.012053, -213.390857>,
				< 119.181551, -36.187042, -220.340848>,
				< 122.730382, -39.908547, -211.175174>
			}
			triangle {
				< 122.730382, -39.908547, -211.175174>,
				< 119.181551, -36.187042, -220.340848>,
				< 118.980356, -32.663912, -215.122297>
			}
			triangle {
				< 122.730382, -39.908547, -211.175174>,
				< 118.980356, -32.663912, -215.122297>,
				< 122.609161, -37.417337, -207.483515>
			}
			triangle {
				< 122.609161, -37.417337, -207.483515>,
				< 118.980356, -32.663912, -215.122297>,
				< 118.680812, -30.246785, -208.173439>
			}
			triangle {
				< 122.609161, -37.417337, -207.483515>,
				< 118.680812, -30.246785, -208.173439>,
				< 122.431904, -35.708182, -202.567622>
			}
			triangle {
				< 122.431904, -35.708182, -202.567622>,
				< 118.680812, -30.246785, -208.173439>,
				< 118.280582, -29.100388, -199.968055>
			}
			triangle {
				< 122.431904, -35.708182, -202.567622>,
				< 118.280582, -29.100388, -199.968055>,
				< 122.199349, -34.897543, -196.762562>
			}
			triangle {
				< 122.199349, -34.897543, -196.762562>,
				< 118.280582, -29.100388, -199.968055>,
				< 117.789343, -29.302806, -191.065818>
			}
			triangle {
				< 122.199349, -34.897543, -196.762562>,
				< 117.789343, -29.302806, -191.065818>,
				< 121.918514, -35.040669, -190.464213>
			}
			triangle {
				< 121.918514, -35.040669, -190.464213>,
				< 117.789343, -29.302806, -191.065818>,
				< 117.232881, -30.840317, -182.073876>
			}
			triangle {
				< 121.918514, -35.040669, -190.464213>,
				< 117.232881, -30.840317, -182.073876>,
				< 121.604778, -36.127869, -184.101909>
			}
			triangle {
				< 121.604778, -36.127869, -184.101909>,
				< 117.232881, -30.840317, -182.073876>,
				< 116.653368, -33.608045, -173.604861>
			}
			triangle {
				< 121.604778, -36.127869, -184.101909>,
				< 116.653368, -33.608045, -173.604861>,
				< 121.281520, -38.084932, -178.109109>
			}
			triangle {
				< 121.281520, -38.084932, -178.109109>,
				< 116.653368, -33.608045, -173.604861>,
				< 116.105318, -37.417460, -166.235745>
			}
			triangle {
				< 121.281520, -38.084932, -178.109109>,
				< 116.105318, -37.417460, -166.235745>,
				< 120.978355, -40.778581, -172.894180>
			}
			triangle {
				< 120.978355, -40.778581, -172.894180>,
				< 116.105318, -37.417460, -166.235745>,
				< 115.647949, -42.008888, -160.468146>
			}
			triangle {
				< 120.978355, -40.778581, -172.894180>,
				< 115.647949, -42.008888, -160.468146>,
				< 120.726854, -44.025242, -168.812454>
			}
			triangle {
				< 120.726854, -44.025242, -168.812454>,
				< 115.647949, -42.008888, -160.468146>,
				< 115.335196, -47.069505, -156.694546>
			}
			triangle {
				< 120.726854, -44.025242, -168.812454>,
				< 115.335196, -47.069505, -156.694546>,
				< 120.555542, -47.603626, -166.141659>
			}
			triangle {
				< 120.555542, -47.603626, -166.141659>,
				< 115.335196, -47.069505, -156.694546>,
				< 115.205944, -52.254375, -155.171648>
			}
			triangle {
				< 120.555542, -47.603626, -166.141659>,
				< 115.205944, -52.254375, -155.171648>,
				< 120.484903, -51.269889, -165.063784>
			}
			triangle {
				< 120.484903, -51.269889, -165.063784>,
				< 115.205944, -52.254375, -155.171648>,
				< 115.276687, -57.210214, -156.002864>
			}
			triangle {
				< 120.484903, -51.269889, -165.063784>,
				< 115.276687, -57.210214, -156.002864>,
				< 120.523557, -54.774199, -165.652096>
			}
			triangle {
				< 115.276687, -57.210214, -156.002864>,
				< 108.556472, -59.079438, -148.780242>,
				< 108.956859, -64.454854, -152.607352>
			}
			triangle {
				< 115.276687, -57.210214, -156.002864>,
				< 108.956859, -64.454854, -152.607352>,
				< 115.538426, -61.599217, -159.131765>
			}
			triangle {
				< 115.538426, -61.599217, -159.131765>,
				< 108.956859, -64.454854, -152.607352>,
				< 109.599605, -68.769768, -158.985049>
			}
			triangle {
				< 115.538426, -61.599217, -159.131765>,
				< 109.599605, -68.769768, -158.985049>,
				< 115.958169, -65.122329, -164.345607>
			}
			triangle {
				< 115.958169, -65.122329, -164.345607>,
				< 109.599605, -68.769768, -158.985049>,
				< 110.408098, -71.730092, -167.479798>
			}
			triangle {
				< 115.958169, -65.122329, -164.345607>,
				< 110.408098, -71.730092, -167.479798>,
				< 116.485544, -67.539461, -171.289548>
			}
			triangle {
				< 116.485544, -67.539461, -171.289548>,
				< 110.408098, -71.730092, -167.479798>,
				< 111.293077, -73.134184, -177.513912>
			}
			triangle {
				< 116.485544, -67.539461, -171.289548>,
				< 111.293077, -73.134184, -177.513912>,
				< 117.061853, -68.685859, -179.491177>
			}
			triangle {
				< 117.061853, -68.685859, -179.491177>,
				< 111.293077, -73.134184, -177.513912>,
				< 112.167925, -72.886236, -188.404173>
			}
			triangle {
				< 117.061853, -68.685859, -179.491177>,
				< 112.167925, -72.886236, -188.404173>,
				< 117.630176, -68.483420, -188.391626>
			}
			triangle {
				< 117.630176, -68.483420, -188.391626>,
				< 112.167925, -72.886236, -188.404173>,
				< 112.961411, -71.003221, -199.408635>
			}
			triangle {
				< 117.630176, -68.483420, -188.391626>,
				< 112.961411, -71.003221, -199.408635>,
				< 118.144125, -66.945933, -197.384506>
			}
			triangle {
				< 118.144125, -66.945933, -197.384506>,
				< 112.961411, -71.003221, -199.408635>,
				< 113.625847, -67.613423, -209.776908>
			}
			triangle {
				< 118.144125, -66.945933, -197.384506>,
				< 113.625847, -67.613423, -209.776908>,
				< 118.572921, -64.178176, -205.856800>
			}
			triangle {
				< 118.572921, -64.178176, -205.856800>,
				< 113.625847, -67.613423, -209.776908>,
				< 114.138551, -62.947869, -218.801633>
			}
			triangle {
				< 118.572921, -64.178176, -205.856800>,
				< 114.138551, -62.947869, -218.801633>,
				< 118.902408, -60.368776, -213.230684>
			}
			triangle {
				< 118.902408, -60.368776, -213.230684>,
				< 114.138551, -62.947869, -218.801633>,
				< 114.497334, -57.324514, -225.866869>
			}
			triangle {
				< 118.902408, -60.368776, -213.230684>,
				< 114.497334, -57.324514, -225.866869>,
				< 119.131923, -55.777323, -219.003201>
			}
			triangle {
				< 119.131923, -55.777323, -219.003201>,
				< 114.497334, -57.324514, -225.866869>,
				< 114.711843, -51.126555, -230.490312>
			}
			triangle {
				< 119.131923, -55.777323, -219.003201>,
				< 114.711843, -51.126555, -230.490312>,
				< 119.268633, -50.716724, -222.780541>
			}
			triangle {
				< 119.268633, -50.716724, -222.780541>,
				< 114.711843, -51.126555, -230.490312>,
				< 114.793934, -44.776414, -232.356429>
			}
			triangle {
				< 119.268633, -50.716724, -222.780541>,
				< 114.793934, -44.776414, -232.356429>,
				< 119.320810, -45.531835, -224.305212>
			}
			triangle {
				< 119.320810, -45.531835, -224.305212>,
				< 114.793934, -44.776414, -232.356429>,
				< 114.749439, -38.706813, -231.337905>
			}
			triangle {
				< 119.320810, -45.531835, -224.305212>,
				< 114.749439, -38.706813, -231.337905>,
				< 119.292550, -40.576018, -223.473042>
			}
			triangle {
				< 119.292550, -40.576018, -223.473042>,
				< 114.749439, -38.706813, -231.337905>,
				< 114.575140, -33.331402, -227.504075>
			}
			triangle {
				< 119.292550, -40.576018, -223.473042>,
				< 114.575140, -33.331402, -227.504075>,
				< 119.181551, -36.187042, -220.340848>
			}
			triangle {
				< 119.181551, -36.187042, -220.340848>,
				< 114.575140, -33.331402, -227.504075>,
				< 114.260249, -29.016471, -221.116781>
			}
			triangle {
				< 119.181551, -36.187042, -220.340848>,
				< 114.260249, -29.016471, -221.116781>,
				< 118.980356, -32.663912, -215.122297>
			}
			triangle {
				< 118.980356, -32.663912, -215.122297>,
				< 114.260249, -29.016471, -221.116781>,
				< 113.793507, -26.056115, -212.612092>
			}
			triangle {
				< 118.980356, -32.663912, -215.122297>,
				< 113.793507, -26.056115, -212.612092>,
				< 118.680812, -30.246785, -208.173439>
			}
			triangle {
				< 118.680812, -30.246785, -208.173439>,
				< 113.793507, -26.056115, -212.612092>,
				< 113.172561, -24.652064, -202.570155>
			}
			triangle {
				< 118.680812, -30.246785, -208.173439>,
				< 113.172561, -24.652064, -202.570155>,
				< 118.280582, -29.100388, -199.968055>
			}
			triangle {
				< 118.280582, -29.100388, -199.968055>,
				< 113.172561, -24.652064, -202.570155>,
				< 112.413369, -24.900012, -191.676497>
			}
			triangle {
				< 118.280582, -29.100388, -199.968055>,
				< 112.413369, -24.900012, -191.676497>,
				< 117.789343, -29.302806, -191.065818>
			}
			triangle {
				< 117.789343, -29.302806, -191.065818>,
				< 112.413369, -24.900012, -191.676497>,
				< 111.556098, -26.783027, -180.673972>
			}
			triangle {
				< 117.789343, -29.302806, -191.065818>,
				< 111.556098, -26.783027, -180.673972>,
				< 117.232881, -30.840317, -182.073876>
			}
			triangle {
				< 117.232881, -30.840317, -182.073876>,
				< 111.556098, -26.783027, -180.673972>,
				< 110.665590, -30.172803, -170.312241>
			}
			triangle {
				< 117.232881, -30.840317, -182.073876>,
				< 110.665590, -30.172803, -170.312241>,
				< 116.653368, -33.608045, -173.604861>
			}
			triangle {
				< 116.653368, -33.608045, -173.604861>,
				< 110.665590, -30.172803, -170.312241>,
				< 109.825037, -34.838375, -161.297217>
			}
			triangle {
				< 116.653368, -33.608045, -173.604861>,
				< 109.825037, -34.838375, -161.297217>,
				< 116.105318, -37.417460, -166.235745>
			}
			triangle {
				< 116.105318, -37.417460, -166.235745>,
				< 109.825037, -34.838375, -161.297217>,
				< 109.124541, -40.461708, -154.242009>
			}
			triangle {
				< 116.105318, -37.417460, -166.235745>,
				< 109.124541, -40.461708, -154.242009>,
				< 115.647949, -42.008888, -160.468146>
			}
			triangle {
				< 115.647949, -42.008888, -160.468146>,
				< 109.124541, -40.461708, -154.242009>,
				< 108.645909, -46.659652, -149.626255>
			}
			triangle {
				< 115.647949, -42.008888, -160.468146>,
				< 108.645909, -46.659652, -149.626255>,
				< 115.335196, -47.069505, -156.694546>
			}
			triangle {
				< 115.335196, -47.069505, -156.694546>,
				< 108.645909, -46.659652, -149.626255>,
				< 108.448230, -53.009816, -147.763535>
			}
			triangle {
				< 115.335196, -47.069505, -156.694546>,
				< 108.448230, -53.009816, -147.763535>,
				< 115.205944, -52.254375, -155.171648>
			}
			triangle {
				< 115.205944, -52.254375, -155.171648>,
				< 108.448230, -53.009816, -147.763535>,
				< 108.556472, -59.079438, -148.780242>
			}
			triangle {
				< 115.205944, -52.254375, -155.171648>,
				< 108.556472, -59.079438, -148.780242>,
				< 115.276687, -57.210214, -156.002864>
			}
			triangle {
				< 108.556472, -59.079438, -148.780242>,
				< 100.916855, -60.254466, -144.501835>,
				< 101.454720, -66.249989, -148.763478>
			}
			triangle {
				< 108.556472, -59.079438, -148.780242>,
				< 101.454720, -66.249989, -148.763478>,
				< 108.956859, -64.454854, -152.607352>
			}
			triangle {
				< 108.956859, -64.454854, -152.607352>,
				< 101.454720, -66.249989, -148.763478>,
				< 102.320559, -71.062639, -155.865684>
			}
			triangle {
				< 108.956859, -64.454854, -152.607352>,
				< 102.320559, -71.062639, -155.865684>,
				< 109.599605, -68.769768, -158.985049>
			}
			triangle {
				< 109.599605, -68.769768, -158.985049>,
				< 102.320559, -71.062639, -155.865684>,
				< 103.414588, -74.364483, -165.326178>
			}
			triangle {
				< 109.599605, -68.769768, -158.985049>,
				< 103.414588, -74.364483, -165.326178>,
				< 110.408098, -71.730092, -167.479798>
			}
			triangle {
				< 110.408098, -71.730092, -167.479798>,
				< 103.414588, -74.364483, -165.326178>,
				< 104.619801, -75.930506, -176.502243>
			}
			triangle {
				< 110.408098, -71.730092, -167.479798>,
				< 104.619801, -75.930506, -176.502243>,
				< 111.293077, -73.134184, -177.513912>
			}
			triangle {
				< 111.293077, -73.134184, -177.513912>,
				< 104.619801, -75.930506, -176.502243>,
				< 105.821237, -75.653963, -188.633353>
			}
			triangle {
				< 111.293077, -73.134184, -177.513912>,
				< 105.821237, -75.653963, -188.633353>,
				< 112.167925, -72.886236, -188.404173>
			}
			triangle {
				< 112.167925, -72.886236, -188.404173>,
				< 105.821237, -75.653963, -188.633353>,
				< 106.922686, -73.553726, -200.892970>
			}
			triangle {
				< 112.167925, -72.886236, -188.404173>,
				< 106.922686, -73.553726, -200.892970>,
				< 112.961411, -71.003221, -199.408635>
			}
			triangle {
				< 112.961411, -71.003221, -199.408635>,
				< 106.922686, -73.553726, -200.892970>,
				< 107.856944, -69.772914, -212.445050>
			}
			triangle {
				< 112.961411, -71.003221, -199.408635>,
				< 107.856944, -69.772914, -212.445050>,
				< 113.625847, -67.613423, -209.776908>
			}
			triangle {
				< 113.625847, -67.613423, -209.776908>,
				< 107.856944, -69.772914, -212.445050>,
				< 108.588479, -64.569145, -222.500995>
			}
			triangle {
				< 113.625847, -67.613423, -209.776908>,
				< 108.588479, -64.569145, -222.500995>,
				< 114.138551, -62.947869, -218.801633>
			}
			triangle {
				< 114.138551, -62.947869, -218.801633>,
				< 108.588479, -64.569145, -222.500995>,
				< 109.108180, -58.297101, -230.374083>
			}
			triangle {
				< 114.138551, -62.947869, -218.801633>,
				< 109.108180, -58.297101, -230.374083>,
				< 114.497334, -57.324514, -225.866869>
			}
			triangle {
				< 114.497334, -57.324514, -225.866869>,
				< 109.108180, -58.297101, -230.374083>,
				< 109.423093, -51.384214, -235.526562>
			}
			triangle {
				< 114.497334, -57.324514, -225.866869>,
				< 109.423093, -51.384214, -235.526562>,
				< 114.711843, -51.126555, -230.490312>
			}
			triangle {
				< 114.711843, -51.126555, -230.490312>,
				< 109.423093, -51.384214, -235.526562>,
				< 109.544560, -44.301532, -237.606227>
			}
			triangle {
				< 114.711843, -51.126555, -230.490312>,
				< 109.544560, -44.301532, -237.606227>,
				< 114.793934, -44.776414, -232.356429>
			}
			triangle {
				< 114.793934, -44.776414, -232.356429>,
				< 109.544560, -44.301532, -237.606227>,
				< 109.478660, -37.531767, -236.471027>
			}
			triangle {
				< 114.793934, -44.776414, -232.356429>,
				< 109.478660, -37.531767, -236.471027>,
				< 114.749439, -38.706813, -231.337905>
			}
			triangle {
				< 114.749439, -38.706813, -231.337905>,
				< 109.478660, -37.531767, -236.471027>,
				< 109.221973, -31.536259, -232.198596>
			}
			triangle {
				< 114.749439, -38.706813, -231.337905>,
				< 109.221973, -31.536259, -232.198596>,
				< 114.575140, -33.331402, -227.504075>
			}
			triangle {
				< 114.575140, -33.331402, -227.504075>,
				< 109.221973, -31.536259, -232.198596>,
				< 108.763903, -26.723607, -225.080863>
			}
			triangle {
				< 114.575140, -33.331402, -227.504075>,
				< 108.763903, -26.723607, -225.080863>,
				< 114.260249, -29.016471, -221.116781>
			}
			triangle {
				< 114.260249, -29.016471, -221.116781>,
				< 108.763903, -26.723607, -225.080863>,
				< 108.094938, -23.421763, -215.604052>
			}
			triangle {
				< 114.260249, -29.016471, -221.116781>,
				< 108.094938, -23.421763, -215.604052>,
				< 113.793507, -26.056115, -212.612092>
			}
			triangle {
				< 113.793507, -26.056115, -212.612092>,
				< 108.094938, -23.421763, -215.604052>,
				< 107.218176, -21.855723, -204.415351>
			}
			triangle {
				< 113.793507, -26.056115, -212.612092>,
				< 107.218176, -21.855723, -204.415351>,
				< 113.172561, -24.652064, -202.570155>
			}
			triangle {
				< 113.172561, -24.652064, -202.570155>,
				< 107.218176, -21.855723, -204.415351>,
				< 106.160581, -22.132283, -192.278773>
			}
			triangle {
				< 113.172561, -24.652064, -202.570155>,
				< 106.160581, -22.132283, -192.278773>,
				< 112.413369, -24.900012, -191.676497>
			}
			triangle {
				< 112.413369, -24.900012, -191.676497>,
				< 106.160581, -22.132283, -192.278773>,
				< 104.979835, -24.232497, -180.022091>
			}
			triangle {
				< 112.413369, -24.900012, -191.676497>,
				< 104.979835, -24.232497, -180.022091>,
				< 111.556098, -26.783027, -180.673972>
			}
			triangle {
				< 111.556098, -26.783027, -180.673972>,
				< 104.979835, -24.232497, -180.022091>,
				< 103.764355, -28.013332, -168.480828>
			}
			triangle {
				< 111.556098, -26.783027, -180.673972>,
				< 103.764355, -28.013332, -168.480828>,
				< 110.665590, -30.172803, -170.312241>
			}
			triangle {
				< 110.665590, -30.172803, -170.312241>,
				< 103.764355, -28.013332, -168.480828>,
				< 102.625027, -33.217058, -158.440620>
			}
			triangle {
				< 110.665590, -30.172803, -170.312241>,
				< 102.625027, -33.217058, -158.440620>,
				< 109.825037, -34.838375, -161.297217>
			}
			triangle {
				< 109.825037, -34.838375, -161.297217>,
				< 102.625027, -33.217058, -158.440620>,
				< 101.680264, -39.489120, -150.583684>
			}
			triangle {
				< 109.825037, -34.838375, -161.297217>,
				< 101.680264, -39.489120, -150.583684>,
				< 109.124541, -40.461708, -154.242009>
			}
			triangle {
				< 109.124541, -40.461708, -154.242009>,
				< 101.680264, -39.489120, -150.583684>,
				< 101.036921, -46.402019, -145.443901>
			}
			triangle {
				< 109.124541, -40.461708, -154.242009>,
				< 101.036921, -46.402019, -145.443901>,
				< 108.645909, -46.659652, -149.626255>
			}
			triangle {
				< 108.645909, -46.659652, -149.626255>,
				< 101.036921, -46.402019, -145.443901>,
				< 100.771613, -53.484682, -143.369719>
			}
			triangle {
				< 108.645909, -46.659652, -149.626255>,
				< 100.771613, -53.484682, -143.369719>,
				< 108.448230, -53.009816, -147.763535>
			}
			triangle {
				< 108.448230, -53.009816, -147.763535>,
				< 100.771613, -53.484682, -143.369719>,
				< 100.916855, -60.254466, -144.501835>
			}
			triangle {
				< 108.448230, -53.009816, -147.763535>,
				< 100.916855, -60.254466, -144.501835>,
				< 108.556472, -59.079438, -148.780242>
			}
			triangle {
				< 100.916855, -60.254466, -144.501835>,
				< 93.044817, -60.655273, -143.469334>,
				< 93.691960, -66.862255, -147.873044>
			}
			triangle {
				< 100.916855, -60.254466, -144.501835>,
				< 93.691960, -66.862255, -147.873044>,
				< 101.454720, -66.249989, -148.763478>
			}
			triangle {
				< 101.454720, -66.249989, -148.763478>,
				< 93.691960, -66.862255, -147.873044>,
				< 94.737649, -71.844697, -155.212492>
			}
			triangle {
				< 101.454720, -66.249989, -148.763478>,
				< 94.737649, -71.844697, -155.212492>,
				< 102.320559, -71.062639, -155.865684>
			}
			triangle {
				< 102.320559, -71.062639, -155.865684>,
				< 94.737649, -71.844697, -155.212492>,
				< 96.067041, -75.263008, -164.989784>
			}
			triangle {
				< 102.320559, -71.062639, -155.865684>,
				< 96.067041, -75.263008, -164.989784>,
				< 103.414588, -74.364483, -165.326178>
			}
			triangle {
				< 103.414588, -74.364483, -165.326178>,
				< 96.067041, -75.263008, -164.989784>,
				< 97.544029, -76.884270, -176.541209>
			}
			triangle {
				< 103.414588, -74.364483, -165.326178>,
				< 97.544029, -76.884270, -176.541209>,
				< 104.619801, -75.930506, -176.502243>
			}
			triangle {
				< 104.619801, -75.930506, -176.502243>,
				< 97.544029, -76.884270, -176.541209>,
				< 99.032655, -76.597996, -189.080939>
			}
			triangle {
				< 104.619801, -75.930506, -176.502243>,
				< 99.032655, -76.597996, -189.080939>,
				< 105.821237, -75.653963, -188.633353>
			}
			triangle {
				< 105.821237, -75.653963, -188.633353>,
				< 99.032655, -76.597996, -189.080939>,
				< 100.416273, -74.423656, -201.754883>
			}
			triangle {
				< 105.821237, -75.653963, -188.633353>,
				< 100.416273, -74.423656, -201.754883>,
				< 106.922686, -73.553726, -200.892970>
			}
			triangle {
				< 106.922686, -73.553726, -200.892970>,
				< 100.416273, -74.423656, -201.754883>,
				< 101.609007, -70.509456, -213.698551>
			}
			triangle {
				< 106.922686, -73.553726, -200.892970>,
				< 101.609007, -70.509456, -213.698551>,
				< 107.856944, -69.772914, -212.445050>
			}
			triangle {
				< 107.856944, -69.772914, -212.445050>,
				< 101.609007, -70.509456, -213.698551>,
				< 102.559604, -65.122150, -224.096224>
			}
			triangle {
				< 107.856944, -69.772914, -212.445050>,
				< 102.559604, -65.122150, -224.096224>,
				< 108.588479, -64.569145, -222.500995>
			}
			triangle {
				< 108.588479, -64.569145, -222.500995>,
				< 102.559604, -65.122150, -224.096224>,
				< 103.247009, -58.628842, -232.237607>
			}
			triangle {
				< 108.588479, -64.569145, -222.500995>,
				< 103.247009, -58.628842, -232.237607>,
				< 109.108180, -58.297101, -230.374083>
			}
			triangle {
				< 109.108180, -58.297101, -230.374083>,
				< 103.247009, -58.628842, -232.237607>,
				< 103.669830, -51.472083, -237.565815>
			}
			triangle {
				< 109.108180, -58.297101, -230.374083>,
				< 103.669830, -51.472083, -237.565815>,
				< 109.423093, -51.384214, -235.526562>
			}
			triangle {
				< 109.423093, -51.384214, -235.526562>,
				< 103.669830, -51.472083, -237.565815>,
				< 103.834465, -44.139560, -239.716440>
			}
			triangle {
				< 109.423093, -51.384214, -235.526562>,
				< 103.834465, -44.139560, -239.716440>,
				< 109.544560, -44.301532, -237.606227>
			}
			triangle {
				< 109.544560, -44.301532, -237.606227>,
				< 103.834465, -44.139560, -239.716440>,
				< 103.745021, -37.130993, -238.542631>
			}
			triangle {
				< 109.544560, -44.301532, -237.606227>,
				< 103.745021, -37.130993, -238.542631>,
				< 109.478660, -37.531767, -236.471027>
			}
			triangle {
				< 109.478660, -37.531767, -236.471027>,
				< 103.745021, -37.130993, -238.542631>,
				< 103.399180, -30.923963, -234.124333>
			}
			triangle {
				< 109.478660, -37.531767, -236.471027>,
				< 103.399180, -30.923963, -234.124333>,
				< 109.221973, -31.536259, -232.198596>
			}
			triangle {
				< 109.221973, -31.536259, -232.198596>,
				< 103.399180, -30.923963, -234.124333>,
				< 102.790363, -25.941549, -226.764038>
			}
			triangle {
				< 109.221973, -31.536259, -232.198596>,
				< 102.790363, -25.941549, -226.764038>,
				< 108.763903, -26.723607, -225.080863>
			}
			triangle {
				< 108.763903, -26.723607, -225.080863>,
				< 102.790363, -25.941549, -226.764038>,
				< 101.916373, -22.523215, -216.964796>
			}
			triangle {
				< 108.763903, -26.723607, -225.080863>,
				< 101.916373, -22.523215, -216.964796>,
				< 108.094938, -23.421763, -215.604052>
			}
			triangle {
				< 108.094938, -23.421763, -215.604052>,
				< 101.916373, -22.523215, -216.964796>,
				< 100.791350, -20.901935, -205.396563>
			}
			triangle {
				< 108.094938, -23.421763, -215.604052>,
				< 100.791350, -20.901935, -205.396563>,
				< 107.218176, -21.855723, -204.415351>
			}
			triangle {
				< 107.218176, -21.855723, -204.415351>,
				< 100.791350, -20.901935, -205.396563>,
				< 99.456757, -21.188250, -192.849413>
			}
			triangle {
				< 107.218176, -21.855723, -204.415351>,
				< 99.456757, -21.188250, -192.849413>,
				< 106.160581, -22.132283, -192.278773>
			}
			triangle {
				< 106.160581, -22.132283, -192.278773>,
				< 99.456757, -21.188250, -192.849413>,
				< 97.988196, -23.362588, -180.179536>
			}
			triangle {
				< 106.160581, -22.132283, -192.278773>,
				< 97.988196, -23.362588, -180.179536>,
				< 104.979835, -24.232497, -180.022091>
			}
			triangle {
				< 104.979835, -24.232497, -180.022091>,
				< 97.988196, -23.362588, -180.179536>,
				< 96.494302, -27.276771, -168.250352>
			}
			triangle {
				< 104.979835, -24.232497, -180.022091>,
				< 96.494302, -27.276771, -168.250352>,
				< 103.764355, -28.013332, -168.480828>
			}
			triangle {
				< 103.764355, -28.013332, -168.480828>,
				< 96.494302, -27.276771, -168.250352>,
				< 95.106713, -32.664072, -157.873496>
			}
			triangle {
				< 103.764355, -28.013332, -168.480828>,
				< 95.106713, -32.664072, -157.873496>,
				< 102.625027, -33.217058, -158.440620>
			}
			triangle {
				< 102.625027, -33.217058, -158.440620>,
				< 95.106713, -32.664072, -157.873496>,
				< 93.964003, -39.157376, -149.754032>
			}
			triangle {
				< 102.625027, -33.217058, -158.440620>,
				< 93.964003, -39.157376, -149.754032>,
				< 101.680264, -39.489120, -150.583684>
			}
			triangle {
				< 101.680264, -39.489120, -150.583684>,
				< 93.964003, -39.157376, -149.754032>,
				< 93.189143, -46.314158, -144.442797>
			}
			triangle {
				< 101.680264, -39.489120, -150.583684>,
				< 93.189143, -46.314158, -144.442797>,
				< 101.036921, -46.402019, -145.443901>
			}
			triangle {
				< 101.036921, -46.402019, -145.443901>,
				< 93.189143, -46.314158, -144.442797>,
				< 92.870407, -53.646665, -142.299443>
			}
			triangle {
				< 101.036921, -46.402019, -145.443901>,
				< 92.870407, -53.646665, -142.299443>,
				< 100.771613, -53.484682, -143.369719>
			}
			triangle {
				< 100.771613, -53.484682, -143.369719>,
				< 92.870407, -53.646665, -142.299443>,
				< 93.044817, -60.655273, -143.469334>
			}
			triangle {
				< 100.771613, -53.484682, -143.369719>,
				< 93.044817, -60.655273, -143.469334>,
				< 100.916855, -60.254466, -144.501835>
			}
			triangle {
				< 93.044817, -60.655273, -143.469334>,
				< 85.668333, -60.254484, -145.743817>,
				< 86.370647, -66.249989, -149.989396>
			}
			triangle {
				< 93.044817, -60.655273, -143.469334>,
				< 86.370647, -66.249989, -149.989396>,
				< 93.691960, -66.862255, -147.873044>
			}
			triangle {
				< 93.691960, -66.862255, -147.873044>,
				< 86.370647, -66.249989, -149.989396>,
				< 87.510496, -71.062632, -157.065511>
			}
			triangle {
				< 93.691960, -66.862255, -147.873044>,
				< 87.510496, -71.062632, -157.065511>,
				< 94.737649, -71.844697, -155.212492>
			}
			triangle {
				< 94.737649, -71.844697, -155.212492>,
				< 87.510496, -71.062632, -157.065511>,
				< 88.969231, -74.364483, -166.492432>
			}
			triangle {
				< 94.737649, -71.844697, -155.212492>,
				< 88.969231, -74.364483, -166.492432>,
				< 96.067041, -75.263008, -164.989784>
			}
			triangle {
				< 96.067041, -75.263008, -164.989784>,
				< 88.969231, -74.364483, -166.492432>,
				< 90.605415, -75.930506, -177.630439>
			}
			triangle {
				< 96.067041, -75.263008, -164.989784>,
				< 90.605415, -75.930506, -177.630439>,
				< 97.544029, -76.884270, -176.541209>
			}
			triangle {
				< 97.544029, -76.884270, -176.541209>,
				< 90.605415, -75.930506, -177.630439>,
				< 92.274599, -75.653963, -189.722210>
			}
			triangle {
				< 97.544029, -76.884270, -176.541209>,
				< 92.274599, -75.653963, -189.722210>,
				< 99.032655, -76.597996, -189.080939>
			}
			triangle {
				< 99.032655, -76.597996, -189.080939>,
				< 92.274599, -75.653963, -189.722210>,
				< 93.848623, -73.553726, -201.944396>
			}
			triangle {
				< 99.032655, -76.597996, -189.080939>,
				< 93.848623, -73.553726, -201.944396>,
				< 100.416273, -74.423656, -201.754883>
			}
			triangle {
				< 100.416273, -74.423656, -201.754883>,
				< 93.848623, -73.553726, -201.944396>,
				< 95.228165, -69.772914, -213.463143>
			}
			triangle {
				< 100.416273, -74.423656, -201.754883>,
				< 95.228165, -69.772914, -213.463143>,
				< 101.609007, -70.509456, -213.698551>
			}
			triangle {
				< 101.609007, -70.509456, -213.698551>,
				< 95.228165, -69.772914, -213.463143>,
				< 96.347310, -64.569145, -223.491669>
			}
			triangle {
				< 101.609007, -70.509456, -213.698551>,
				< 96.347310, -64.569145, -223.491669>,
				< 102.559604, -65.122150, -224.096224>
			}
			triangle {
				< 102.559604, -65.122150, -224.096224>,
				< 96.347310, -64.569145, -223.491669>,
				< 97.170390, -58.297098, -231.344357>
			}
			triangle {
				< 102.559604, -65.122150, -224.096224>,
				< 97.170390, -58.297098, -231.344357>,
				< 103.247009, -58.628842, -232.237607>
			}
			triangle {
				< 103.247009, -58.628842, -232.237607>,
				< 97.170390, -58.297098, -231.344357>,
				< 97.683847, -51.384214, -236.483917>
			}
			triangle {
				< 103.247009, -58.628842, -232.237607>,
				< 97.683847, -51.384214, -236.483917>,
				< 103.669830, -51.472083, -237.565815>
			}
			triangle {
				< 103.669830, -51.472083, -237.565815>,
				< 97.683847, -51.384214, -236.483917>,
				< 97.885445, -44.301528, -238.558516>
			}
			triangle {
				< 103.669830, -51.472083, -237.565815>,
				< 97.885445, -44.301528, -238.558516>,
				< 103.834465, -44.139560, -239.716440>
			}
			triangle {
				< 103.834465, -44.139560, -239.716440>,
				< 97.885445, -44.301528, -238.558516>,
				< 97.775817, -37.531771, -237.426102>
			}
			triangle {
				< 103.834465, -44.139560, -239.716440>,
				< 97.775817, -37.531771, -237.426102>,
				< 103.745021, -37.130993, -238.542631>
			}
			triangle {
				< 103.745021, -37.130993, -238.542631>,
				< 97.775817, -37.531771, -237.426102>,
				< 97.354546, -31.536277, -233.164266>
			}
			triangle {
				< 103.745021, -37.130993, -238.542631>,
				< 97.354546, -31.536277, -233.164266>,
				< 103.399180, -30.923963, -234.124333>
			}
			triangle {
				< 103.399180, -30.923963, -234.124333>,
				< 97.354546, -31.536277, -233.164266>,
				< 96.622154, -26.723629, -226.064786>
			}
			triangle {
				< 103.399180, -30.923963, -234.124333>,
				< 96.622154, -26.723629, -226.064786>,
				< 102.790363, -25.941549, -226.764038>
			}
			triangle {
				< 102.790363, -25.941549, -226.764038>,
				< 96.622154, -26.723629, -226.064786>,
				< 95.587932, -23.421781, -216.613352>
			}
			triangle {
				< 102.790363, -25.941549, -226.764038>,
				< 95.587932, -23.421781, -216.613352>,
				< 101.916373, -22.523215, -216.964796>
			}
			triangle {
				< 101.916373, -22.523215, -216.964796>,
				< 95.587932, -23.421781, -216.613352>,
				< 94.279908, -21.855719, -205.456391>
			}
			triangle {
				< 101.916373, -22.523215, -216.964796>,
				< 94.279908, -21.855719, -205.456391>,
				< 100.791350, -20.901935, -205.396563>
			}
			triangle {
				< 100.791350, -20.901935, -205.396563>,
				< 94.279908, -21.855719, -205.456391>,
				< 92.754468, -22.132283, -193.356290>
			}
			triangle {
				< 100.791350, -20.901935, -205.396563>,
				< 92.754468, -22.132283, -193.356290>,
				< 99.456757, -21.188250, -192.849413>
			}
			triangle {
				< 99.456757, -21.188250, -192.849413>,
				< 92.754468, -22.132283, -193.356290>,
				< 91.101289, -24.232520, -181.138739>
			}
			triangle {
				< 99.456757, -21.188250, -192.849413>,
				< 91.101289, -24.232520, -181.138739>,
				< 97.988196, -23.362588, -180.179536>
			}
			triangle {
				< 97.988196, -23.362588, -180.179536>,
				< 91.101289, -24.232520, -181.138739>,
				< 89.440756, -28.013352, -169.636130>
			}
			triangle {
				< 97.988196, -23.362588, -180.179536>,
				< 89.440756, -28.013352, -169.636130>,
				< 96.494302, -27.276771, -168.250352>
			}
			triangle {
				< 96.494302, -27.276771, -168.250352>,
				< 89.440756, -28.013352, -169.636130>,
				< 87.914258, -33.217076, -159.631133>
			}
			triangle {
				< 96.494302, -27.276771, -168.250352>,
				< 87.914258, -33.217076, -159.631133>,
				< 95.106713, -32.664072, -157.873496>
			}
			triangle {
				< 95.106713, -32.664072, -157.873496>,
				< 87.914258, -33.217076, -159.631133>,
				< 86.666510, -39.489109, -151.802972>
			}
			triangle {
				< 95.106713, -32.664072, -157.873496>,
				< 86.666510, -39.489109, -151.802972>,
				< 93.964003, -39.157376, -149.754032>
			}
			triangle {
				< 93.964003, -39.157376, -149.754032>,
				< 86.666510, -39.489109, -151.802972>,
				< 85.824855, -46.402015, -146.682292>
			}
			triangle {
				< 93.964003, -39.157376, -149.754032>,
				< 85.824855, -46.402015, -146.682292>,
				< 93.189143, -46.314158, -144.442797>
			}
			triangle {
				< 93.189143, -46.314158, -144.442797>,
				< 85.824855, -46.402015, -146.682292>,
				< 85.479453, -53.484682, -144.615978>
			}
			triangle {
				< 93.189143, -46.314158, -144.442797>,
				< 85.479453, -53.484682, -144.615978>,
				< 92.870407, -53.646665, -142.299443>
			}
			triangle {
				< 92.870407, -53.646665, -142.299443>,
				< 85.479453, -53.484682, -144.615978>,
				< 85.668333, -60.254484, -145.743817>
			}
			triangle {
				< 92.870407, -53.646665, -142.299443>,
				< 85.668333, -60.254484, -145.743817>,
				< 93.044817, -60.655273, -143.469334>
			}
			triangle {
				< 85.668333, -60.254484, -145.743817>,
				< 79.455011, -59.079438, -151.144683>,
				< 80.140114, -64.454854, -154.944524>
			}
			triangle {
				< 85.668333, -60.254484, -145.743817>,
				< 80.140114, -64.454854, -154.944524>,
				< 86.370647, -66.249989, -149.989396>
			}
			triangle {
				< 86.370647, -66.249989, -149.989396>,
				< 80.140114, -64.454854, -154.944524>,
				< 81.257291, -68.769768, -161.277711>
			}
			triangle {
				< 86.370647, -66.249989, -149.989396>,
				< 81.257291, -68.769768, -161.277711>,
				< 87.510496, -71.062632, -157.065511>
			}
			triangle {
				< 87.510496, -71.062632, -157.065511>,
				< 81.257291, -68.769768, -161.277711>,
				< 82.697697, -71.730122, -169.714943>
			}
			triangle {
				< 87.510496, -71.062632, -157.065511>,
				< 82.697697, -71.730122, -169.714943>,
				< 88.969231, -74.364483, -166.492432>
			}
			triangle {
				< 88.969231, -74.364483, -166.492432>,
				< 82.697697, -71.730122, -169.714943>,
				< 84.329210, -73.134184, -179.683715>
			}
			triangle {
				< 88.969231, -74.364483, -166.492432>,
				< 84.329210, -73.134184, -179.683715>,
				< 90.605415, -75.930506, -177.630439>
			}
			triangle {
				< 90.605415, -75.930506, -177.630439>,
				< 84.329210, -73.134184, -179.683715>,
				< 86.014085, -72.886236, -190.506235>
			}
			triangle {
				< 90.605415, -75.930506, -177.630439>,
				< 86.014085, -72.886236, -190.506235>,
				< 92.274599, -75.653963, -189.722210>
			}
			triangle {
				< 92.274599, -75.653963, -189.722210>,
				< 86.014085, -72.886236, -190.506235>,
				< 87.626092, -71.003221, -201.445594>
			}
			triangle {
				< 92.274599, -75.653963, -189.722210>,
				< 87.626092, -71.003221, -201.445594>,
				< 93.848623, -73.553726, -201.944396>
			}
			triangle {
				< 93.848623, -73.553726, -201.944396>,
				< 87.626092, -71.003221, -201.445594>,
				< 89.061648, -67.613423, -211.755708>
			}
			triangle {
				< 93.848623, -73.553726, -201.944396>,
				< 89.061648, -67.613423, -211.755708>,
				< 95.228165, -69.772914, -213.463143>
			}
			triangle {
				< 95.228165, -69.772914, -213.463143>,
				< 89.061648, -67.613423, -211.755708>,
				< 90.245597, -62.947869, -220.732182>
			}
			triangle {
				< 95.228165, -69.772914, -213.463143>,
				< 90.245597, -62.947869, -220.732182>,
				< 96.347310, -64.569145, -223.491669>
			}
			triangle {
				< 96.347310, -64.569145, -223.491669>,
				< 90.245597, -62.947869, -220.732182>,
				< 91.129817, -57.324495, -227.761298>
			}
			triangle {
				< 96.347310, -64.569145, -223.491669>,
				< 91.129817, -57.324495, -227.761298>,
				< 97.170390, -58.297098, -231.344357>
			}
			triangle {
				< 97.170390, -58.297098, -231.344357>,
				< 91.129817, -57.324495, -227.761298>,
				< 91.688268, -51.126555, -232.361853>
			}
			triangle {
				< 97.170390, -58.297098, -231.344357>,
				< 91.688268, -51.126555, -232.361853>,
				< 97.683847, -51.384214, -236.483917>
			}
			triangle {
				< 97.683847, -51.384214, -236.483917>,
				< 91.688268, -51.126555, -232.361853>,
				< 91.909088, -44.776414, -234.218866>
			}
			triangle {
				< 97.683847, -51.384214, -236.483917>,
				< 91.909088, -44.776414, -234.218866>,
				< 97.885445, -44.301528, -238.558516>
			}
			triangle {
				< 97.885445, -44.301528, -238.558516>,
				< 91.909088, -44.776414, -234.218866>,
				< 91.788821, -38.706813, -233.205259>
			}
			triangle {
				< 97.885445, -44.301528, -238.558516>,
				< 91.788821, -38.706813, -233.205259>,
				< 97.775817, -37.531771, -237.426102>
			}
			triangle {
				< 97.775817, -37.531771, -237.426102>,
				< 91.788821, -38.706813, -233.205259>,
				< 91.329440, -33.331402, -229.390278>
			}
			triangle {
				< 97.775817, -37.531771, -237.426102>,
				< 91.329440, -33.331402, -229.390278>,
				< 97.354546, -31.536277, -233.164266>
			}
			triangle {
				< 97.354546, -31.536277, -233.164266>,
				< 91.329440, -33.331402, -229.390278>,
				< 90.539508, -29.016471, -223.035321>
			}
			triangle {
				< 97.354546, -31.536277, -233.164266>,
				< 90.539508, -29.016471, -223.035321>,
				< 96.622154, -26.723629, -226.064786>
			}
			triangle {
				< 96.622154, -26.723629, -226.064786>,
				< 90.539508, -29.016471, -223.035321>,
				< 89.440152, -26.056113, -214.575410>
			}
			triangle {
				< 96.622154, -26.723629, -226.064786>,
				< 89.440152, -26.056113, -214.575410>,
				< 95.587932, -23.421781, -216.613352>
			}
			triangle {
				< 95.587932, -23.421781, -216.613352>,
				< 89.440152, -26.056113, -214.575410>,
				< 88.072360, -24.652084, -204.589069>
			}
			triangle {
				< 95.587932, -23.421781, -216.613352>,
				< 88.072360, -24.652084, -204.589069>,
				< 94.279908, -21.855719, -205.456391>
			}
			triangle {
				< 94.279908, -21.855719, -205.456391>,
				< 88.072360, -24.652084, -204.589069>,
				< 86.502865, -24.900012, -193.758816>
			}
			triangle {
				< 94.279908, -21.855719, -205.456391>,
				< 86.502865, -24.900012, -193.758816>,
				< 92.754468, -22.132283, -193.356290>
			}
			triangle {
				< 92.754468, -22.132283, -193.356290>,
				< 86.502865, -24.900012, -193.758816>,
				< 84.827214, -26.783006, -182.823658>
			}
			triangle {
				< 92.754468, -22.132283, -193.356290>,
				< 84.827214, -26.783006, -182.823658>,
				< 91.101289, -24.232520, -181.138739>
			}
			triangle {
				< 91.101289, -24.232520, -181.138739>,
				< 84.827214, -26.783006, -182.823658>,
				< 83.165921, -30.172823, -172.528580>
			}
			triangle {
				< 91.101289, -24.232520, -181.138739>,
				< 83.165921, -30.172823, -172.528580>,
				< 89.440756, -28.013352, -169.636130>
			}
			triangle {
				< 89.440756, -28.013352, -169.636130>,
				< 83.165921, -30.172823, -172.528580>,
				< 81.654750, -34.838371, -163.573921>
			}
			triangle {
				< 89.440756, -28.013352, -169.636130>,
				< 81.654750, -34.838371, -163.573921>,
				< 87.914258, -33.217076, -159.631133>
			}
			triangle {
				< 87.914258, -33.217076, -159.631133>,
				< 81.654750, -34.838371, -163.573921>,
				< 80.429390, -40.461712, -156.567678>
			}
			triangle {
				< 87.914258, -33.217076, -159.631133>,
				< 80.429390, -40.461712, -156.567678>,
				< 86.666510, -39.489109, -151.802972>
			}
			triangle {
				< 86.666510, -39.489109, -151.802972>,
				< 80.429390, -40.461712, -156.567678>,
				< 79.607449, -46.659656, -151.984617>
			}
			triangle {
				< 86.666510, -39.489109, -151.802972>,
				< 79.607449, -46.659656, -151.984617>,
				< 85.824855, -46.402015, -146.682292>
			}
			triangle {
				< 85.824855, -46.402015, -146.682292>,
				< 79.607449, -46.659656, -151.984617>,
				< 79.271093, -53.009816, -150.135234>
			}
			triangle {
				< 85.824855, -46.402015, -146.682292>,
				< 79.271093, -53.009816, -150.135234>,
				< 85.479453, -53.484682, -144.615978>
			}
			triangle {
				< 85.479453, -53.484682, -144.615978>,
				< 79.271093, -53.009816, -150.135234>,
				< 79.455011, -59.079438, -151.144683>
			}
			triangle {
				< 85.479453, -53.484682, -144.615978>,
				< 79.455011, -59.079438, -151.144683>,
				< 85.668333, -60.254484, -145.743817>
			}
			triangle {
				< 79.455011, -59.079438, -151.144683>,
				< 74.922048, -57.210214, -159.269974>,
				< 75.512558, -61.599217, -162.368268>
			}
			triangle {
				< 79.455011, -59.079438, -151.144683>,
				< 75.512558, -61.599217, -162.368268>,
				< 80.140114, -64.454854, -154.944524>
			}
			triangle {
				< 80.140114, -64.454854, -154.944524>,
				< 75.512558, -61.599217, -162.368268>,
				< 76.480068, -65.122329, -167.532012>
			}
			triangle {
				< 80.140114, -64.454854, -154.944524>,
				< 76.480068, -65.122329, -167.532012>,
				< 81.257291, -68.769768, -161.277711>
			}
			triangle {
				< 81.257291, -68.769768, -161.277711>,
				< 76.480068, -65.122329, -167.532012>,
				< 77.737145, -67.539461, -174.410984>
			}
			triangle {
				< 81.257291, -68.769768, -161.277711>,
				< 77.737145, -67.539461, -174.410984>,
				< 82.697697, -71.730122, -169.714943>
			}
			triangle {
				< 82.697697, -71.730122, -169.714943>,
				< 77.737145, -67.539461, -174.410984>,
				< 79.175279, -68.685859, -182.538033>
			}
			triangle {
				< 82.697697, -71.730122, -169.714943>,
				< 79.175279, -68.685859, -182.538033>,
				< 84.329210, -73.134184, -179.683715>
			}
			triangle {
				< 84.329210, -73.134184, -179.683715>,
				< 79.175279, -68.685859, -182.538033>,
				< 80.678955, -68.483435, -191.360801>
			}
			triangle {
				< 84.329210, -73.134184, -179.683715>,
				< 80.678955, -68.483435, -191.360801>,
				< 86.014085, -72.886236, -190.506235>
			}
			triangle {
				< 86.014085, -72.886236, -190.506235>,
				< 80.678955, -68.483435, -191.360801>,
				< 82.137913, -66.945948, -200.278372>
			}
			triangle {
				< 86.014085, -72.886236, -190.506235>,
				< 82.137913, -66.945948, -200.278372>,
				< 87.626092, -71.003221, -201.445594>
			}
			triangle {
				< 87.626092, -71.003221, -201.445594>,
				< 82.137913, -66.945948, -200.278372>,
				< 83.457015, -64.178176, -208.682582>
			}
			triangle {
				< 87.626092, -71.003221, -201.445594>,
				< 83.457015, -64.178176, -208.682582>,
				< 89.061648, -67.613423, -211.755708>
			}
			triangle {
				< 89.061648, -67.613423, -211.755708>,
				< 83.457015, -64.178176, -208.682582>,
				< 84.561504, -60.368769, -215.999484>
			}
			triangle {
				< 89.061648, -67.613423, -211.755708>,
				< 84.561504, -60.368769, -215.999484>,
				< 90.245597, -62.947869, -220.732182>
			}
			triangle {
				< 90.245597, -62.947869, -220.732182>,
				< 84.561504, -60.368769, -215.999484>,
				< 85.397571, -55.777323, -221.728906>
			}
			triangle {
				< 90.245597, -62.947869, -220.732182>,
				< 85.397571, -55.777323, -221.728906>,
				< 91.129817, -57.324495, -227.761298>
			}
			triangle {
				< 91.129817, -57.324495, -227.761298>,
				< 85.397571, -55.777323, -221.728906>,
				< 85.931286, -50.716724, -225.478828>
			}
			triangle {
				< 91.129817, -57.324495, -227.761298>,
				< 85.931286, -50.716724, -225.478828>,
				< 91.688268, -51.126555, -232.361853>
			}
			triangle {
				< 91.688268, -51.126555, -232.361853>,
				< 85.931286, -50.716724, -225.478828>,
				< 86.143650, -45.531832, -226.992562>
			}
			triangle {
				< 91.688268, -51.126555, -232.361853>,
				< 86.143650, -45.531832, -226.992562>,
				< 91.909088, -44.776414, -234.218866>
			}
			triangle {
				< 91.909088, -44.776414, -234.218866>,
				< 86.143650, -45.531832, -226.992562>,
				< 86.027957, -40.576037, -226.166368>
			}
			triangle {
				< 91.909088, -44.776414, -234.218866>,
				< 86.027957, -40.576037, -226.166368>,
				< 91.788821, -38.706813, -233.205259>
			}
			triangle {
				< 91.788821, -38.706813, -233.205259>,
				< 86.027957, -40.576037, -226.166368>,
				< 85.587837, -36.187012, -223.056808>
			}
			triangle {
				< 91.788821, -38.706813, -233.205259>,
				< 85.587837, -36.187012, -223.056808>,
				< 91.329440, -33.331402, -229.390278>
			}
			triangle {
				< 91.329440, -33.331402, -229.390278>,
				< 85.587837, -36.187012, -223.056808>,
				< 84.838256, -32.663889, -217.876881>
			}
			triangle {
				< 91.329440, -33.331402, -229.390278>,
				< 84.838256, -32.663889, -217.876881>,
				< 90.539508, -29.016471, -223.035321>
			}
			triangle {
				< 90.539508, -29.016471, -223.035321>,
				< 84.838256, -32.663889, -217.876881>,
				< 83.808437, -30.246777, -210.981041>
			}
			triangle {
				< 90.539508, -29.016471, -223.035321>,
				< 83.808437, -30.246777, -210.981041>,
				< 89.440152, -26.056113, -214.575410>
			}
			triangle {
				< 89.440152, -26.056113, -214.575410>,
				< 83.808437, -30.246777, -210.981041>,
				< 82.545824, -29.100372, -202.840805>
			}
			triangle {
				< 89.440152, -26.056113, -214.575410>,
				< 82.545824, -29.100372, -202.840805>,
				< 88.072360, -24.652084, -204.589069>
			}
			triangle {
				< 88.072360, -24.652084, -204.589069>,
				< 82.545824, -29.100372, -202.840805>,
				< 81.119098, -29.302830, -194.012389>
			}
			triangle {
				< 88.072360, -24.652084, -204.589069>,
				< 81.119098, -29.302830, -194.012389>,
				< 86.502865, -24.900012, -193.758816>
			}
			triangle {
				< 86.502865, -24.900012, -193.758816>,
				< 81.119098, -29.302830, -194.012389>,
				< 79.617716, -30.840317, -185.097903>
			}
			triangle {
				< 86.502865, -24.900012, -193.758816>,
				< 79.617716, -30.840317, -185.097903>,
				< 84.827214, -26.783006, -182.823658>
			}
			triangle {
				< 84.827214, -26.783006, -182.823658>,
				< 79.617716, -30.840317, -185.097903>,
				< 78.148261, -33.608072, -176.704928>
			}
			triangle {
				< 84.827214, -26.783006, -182.823658>,
				< 78.148261, -33.608072, -176.704928>,
				< 83.165921, -30.172823, -172.528580>
			}
			triangle {
				< 83.165921, -30.172823, -172.528580>,
				< 78.148261, -33.608072, -176.704928>,
				< 76.825887, -37.417468, -169.404224>
			}
			triangle {
				< 83.165921, -30.172823, -172.528580>,
				< 76.825887, -37.417468, -169.404224>,
				< 81.654750, -34.838371, -163.573921>
			}
			triangle {
				< 81.654750, -34.838371, -163.573921>,
				< 76.825887, -37.417468, -169.404224>,
				< 75.762413, -42.008914, -163.691744>
			}
			triangle {
				< 81.654750, -34.838371, -163.573921>,
				< 75.762413, -42.008914, -163.691744>,
				< 80.429390, -40.461712, -156.567678>
			}
			triangle {
				< 80.429390, -40.461712, -156.567678>,
				< 75.762413, -42.008914, -163.691744>,
				< 75.053141, -47.069509, -159.954861>
			}
			triangle {
				< 80.429390, -40.461712, -156.567678>,
				< 75.053141, -47.069509, -159.954861>,
				< 79.607449, -46.659656, -151.984617>
			}
			triangle {
				< 79.607449, -46.659656, -151.984617>,
				< 75.053141, -47.069509, -159.954861>,
				< 74.763931, -52.254375, -158.446953>
			}
			triangle {
				< 79.607449, -46.659656, -151.984617>,
				< 74.763931, -52.254375, -158.446953>,
				< 79.271093, -53.009816, -150.135234>
			}
			triangle {
				< 79.271093, -53.009816, -150.135234>,
				< 74.763931, -52.254375, -158.446953>,
				< 74.922048, -57.210214, -159.269974>
			}
			triangle {
				< 79.271093, -53.009816, -150.135234>,
				< 74.922048, -57.210214, -159.269974>,
				< 79.455011, -59.079438, -151.144683>
			}
			triangle {
				< 74.922048, -57.210214, -159.269974>,
				< 72.375886, -54.774199, -169.535771>,
				< 72.804004, -57.877686, -171.724871>
			}
			triangle {
				< 74.922048, -57.210214, -159.269974>,
				< 72.804004, -57.877686, -171.724871>,
				< 75.512558, -61.599217, -162.368268>
			}
			triangle {
				< 75.512558, -61.599217, -162.368268>,
				< 72.804004, -57.877686, -171.724871>,
				< 73.508911, -60.368914, -175.372764>
			}
			triangle {
				< 75.512558, -61.599217, -162.368268>,
				< 73.508911, -60.368914, -175.372764>,
				< 76.480068, -65.122329, -167.532012>
			}
			triangle {
				< 76.480068, -65.122329, -167.532012>,
				< 73.508911, -60.368914, -175.372764>,
				< 74.432105, -62.078081, -180.232123>
			}
			triangle {
				< 76.480068, -65.122329, -167.532012>,
				< 74.432105, -62.078081, -180.232123>,
				< 77.737145, -67.539461, -174.410984>
			}
			triangle {
				< 77.737145, -67.539461, -174.410984>,
				< 74.432105, -62.078081, -180.232123>,
				< 75.498894, -62.888697, -185.972497>
			}
			triangle {
				< 77.737145, -67.539461, -174.410984>,
				< 75.498894, -62.888697, -185.972497>,
				< 79.175279, -68.685859, -182.538033>
			}
			triangle {
				< 79.175279, -68.685859, -182.538033>,
				< 75.498894, -62.888697, -185.972497>,
				< 76.628208, -62.745571, -192.203403>
			}
			triangle {
				< 79.175279, -68.685859, -182.538033>,
				< 76.628208, -62.745571, -192.203403>,
				< 80.678955, -68.483435, -191.360801>
			}
			triangle {
				< 80.678955, -68.483435, -191.360801>,
				< 76.628208, -62.745571, -192.203403>,
				< 77.739052, -61.658397, -198.500514>
			}
			triangle {
				< 80.678955, -68.483435, -191.360801>,
				< 77.739052, -61.658397, -198.500514>,
				< 82.137913, -66.945948, -200.278372>
			}
			triangle {
				< 82.137913, -66.945948, -200.278372>,
				< 77.739052, -61.658397, -198.500514>,
				< 78.757845, -59.701305, -204.434529>
			}
			triangle {
				< 82.137913, -66.945948, -200.278372>,
				< 78.757845, -59.701305, -204.434529>,
				< 83.457015, -64.178176, -208.682582>
			}
			triangle {
				< 83.457015, -64.178176, -208.682582>,
				< 78.757845, -59.701305, -204.434529>,
				< 79.622850, -57.007622, -209.600389>
			}
			triangle {
				< 83.457015, -64.178176, -208.682582>,
				< 79.622850, -57.007622, -209.600389>,
				< 84.561504, -60.368769, -215.999484>
			}
			triangle {
				< 84.561504, -60.368769, -215.999484>,
				< 79.622850, -57.007622, -209.600389>,
				< 80.285542, -53.760972, -213.645130>
			}
			triangle {
				< 84.561504, -60.368769, -215.999484>,
				< 80.285542, -53.760972, -213.645130>,
				< 85.397571, -55.777323, -221.728906>
			}
			triangle {
				< 85.397571, -55.777323, -221.728906>,
				< 80.285542, -53.760972, -213.645130>,
				< 80.712602, -50.182603, -216.292322>
			}
			triangle {
				< 85.397571, -55.777323, -221.728906>,
				< 80.712602, -50.182603, -216.292322>,
				< 85.931286, -50.716724, -225.478828>
			}
			triangle {
				< 85.931286, -50.716724, -225.478828>,
				< 80.712602, -50.182603, -216.292322>,
				< 80.883406, -46.516344, -217.360809>
			}
			triangle {
				< 85.931286, -50.716724, -225.478828>,
				< 80.883406, -46.516344, -217.360809>,
				< 86.143650, -45.531832, -226.992562>
			}
			triangle {
				< 86.143650, -45.531832, -226.992562>,
				< 80.883406, -46.516344, -217.360809>,
				< 80.790214, -43.012053, -216.777578>
			}
			triangle {
				< 86.143650, -45.531832, -226.992562>,
				< 80.790214, -43.012053, -216.777578>,
				< 86.027957, -40.576037, -226.166368>
			}
			triangle {
				< 86.027957, -40.576037, -226.166368>,
				< 80.790214, -43.012053, -216.777578>,
				< 80.437385, -39.908547, -214.582518>
			}
			triangle {
				< 86.027957, -40.576037, -226.166368>,
				< 80.437385, -39.908547, -214.582518>,
				< 85.587837, -36.187012, -223.056808>
			}
			triangle {
				< 85.587837, -36.187012, -223.056808>,
				< 80.437385, -39.908547, -214.582518>,
				< 79.841442, -37.417334, -210.925728>
			}
			triangle {
				< 85.587837, -36.187012, -223.056808>,
				< 79.841442, -37.417334, -210.925728>,
				< 84.838256, -32.663889, -217.876881>
			}
			triangle {
				< 84.838256, -32.663889, -217.876881>,
				< 79.841442, -37.417334, -210.925728>,
				< 79.031877, -35.708182, -206.057340>
			}
			triangle {
				< 84.838256, -32.663889, -217.876881>,
				< 79.031877, -35.708182, -206.057340>,
				< 83.808437, -30.246777, -210.981041>
			}
			triangle {
				< 83.808437, -30.246777, -210.981041>,
				< 79.031877, -35.708182, -206.057340>,
				< 78.052692, -34.897521, -200.309873>
			}
			triangle {
				< 83.808437, -30.246777, -210.981041>,
				< 78.052692, -34.897521, -200.309873>,
				< 82.545824, -29.100372, -202.840805>
			}
			triangle {
				< 82.545824, -29.100372, -202.840805>,
				< 78.052692, -34.897521, -200.309873>,
				< 76.961704, -35.040691, -194.075823>
			}
			triangle {
				< 82.545824, -29.100372, -202.840805>,
				< 76.961704, -35.040691, -194.075823>,
				< 81.119098, -29.302830, -194.012389>
			}
			triangle {
				< 81.119098, -29.302830, -194.012389>,
				< 76.961704, -35.040691, -194.075823>,
				< 75.829662, -36.127869, -187.780410>
			}
			triangle {
				< 81.119098, -29.302830, -194.012389>,
				< 75.829662, -36.127869, -187.780410>,
				< 79.617716, -30.840317, -185.097903>
			}
			triangle {
				< 79.617716, -30.840317, -185.097903>,
				< 75.829662, -36.127869, -187.780410>,
				< 74.735768, -38.084954, -181.852490>
			}
			triangle {
				< 79.617716, -30.840317, -185.097903>,
				< 74.735768, -38.084954, -181.852490>,
				< 78.148261, -33.608072, -176.704928>
			}
			triangle {
				< 78.148261, -33.608072, -176.704928>,
				< 74.735768, -38.084954, -181.852490>,
				< 73.761925, -40.778603, -176.695362>
			}
			triangle {
				< 78.148261, -33.608072, -176.704928>,
				< 73.761925, -40.778603, -176.695362>,
				< 76.825887, -37.417468, -169.404224>
			}
			triangle {
				< 76.825887, -37.417468, -169.404224>,
				< 73.761925, -40.778603, -176.695362>,
				< 72.985679, -44.025235, -172.659725>
			}
			triangle {
				< 76.825887, -37.417468, -169.404224>,
				< 72.985679, -44.025235, -172.659725>,
				< 75.762413, -42.008914, -163.691744>
			}
			triangle {
				< 75.762413, -42.008914, -163.691744>,
				< 72.985679, -44.025235, -172.659725>,
				< 72.470792, -47.603626, -170.019746>
			}
			triangle {
				< 75.762413, -42.008914, -163.691744>,
				< 72.470792, -47.603626, -170.019746>,
				< 75.053141, -47.069509, -159.954861>
			}
			triangle {
				< 75.053141, -47.069509, -159.954861>,
				< 72.470792, -47.603626, -170.019746>,
				< 72.261669, -51.269889, -168.954283>
			}
			triangle {
				< 75.053141, -47.069509, -159.954861>,
				< 72.261669, -51.269889, -168.954283>,
				< 74.763931, -52.254375, -158.446953>
			}
			triangle {
				< 74.763931, -52.254375, -158.446953>,
				< 72.261669, -51.269889, -168.954283>,
				< 72.375886, -54.774199, -169.535771>
			}
			triangle {
				< 74.763931, -52.254375, -158.446953>,
				< 72.375886, -54.774199, -169.535771>,
				< 74.922048, -57.210214, -159.269974>
			}
			triangle {
				< 72.375886, -54.774199, -169.535771>,
				< 71.893133, -51.937401, -181.224734>,
				< 72.113879, -53.543873, -182.357669>
			}
			triangle {
				< 72.375886, -54.774199, -169.535771>,
				< 72.113879, -53.543873, -182.357669>,
				< 72.804004, -57.877686, -171.724871>
			}
			triangle {
				< 72.804004, -57.877686, -171.724871>,
				< 72.113879, -53.543873, -182.357669>,
				< 72.479323, -54.833431, -184.245512>
			}
			triangle {
				< 72.804004, -57.877686, -171.724871>,
				< 72.479323, -54.833431, -184.245512>,
				< 73.508911, -60.368914, -175.372764>
			}
			triangle {
				< 73.508911, -60.368914, -175.372764>,
				< 72.479323, -54.833431, -184.245512>,
				< 72.961785, -55.718169, -186.759830>
			}
			triangle {
				< 73.508911, -60.368914, -175.372764>,
				< 72.961785, -55.718169, -186.759830>,
				< 74.432105, -62.078081, -180.232123>
			}
			triangle {
				< 74.432105, -62.078081, -180.232123>,
				< 72.961785, -55.718169, -186.759830>,
				< 73.525175, -56.137774, -189.729542>
			}
			triangle {
				< 74.432105, -62.078081, -180.232123>,
				< 73.525175, -56.137774, -189.729542>,
				< 75.498894, -62.888697, -185.972497>
			}
			triangle {
				< 75.498894, -62.888697, -185.972497>,
				< 73.525175, -56.137774, -189.729542>,
				< 74.128963, -56.063678, -192.952543>
			}
			triangle {
				< 75.498894, -62.888697, -185.972497>,
				< 74.128963, -56.063678, -192.952543>,
				< 76.628208, -62.745571, -192.203403>
			}
			triangle {
				< 76.628208, -62.745571, -192.203403>,
				< 74.128963, -56.063678, -192.952543>,
				< 74.730963, -55.500925, -196.209222>
			}
			triangle {
				< 76.628208, -62.745571, -192.203403>,
				< 74.730963, -55.500925, -196.209222>,
				< 77.739052, -61.658397, -198.500514>
			}
			triangle {
				< 77.739052, -61.658397, -198.500514>,
				< 74.730963, -55.500925, -196.209222>,
				< 75.290613, -54.487847, -199.277535>
			}
			triangle {
				< 77.739052, -61.658397, -198.500514>,
				< 75.290613, -54.487847, -199.277535>,
				< 78.757845, -59.701305, -204.434529>
			}
			triangle {
				< 78.757845, -59.701305, -204.434529>,
				< 75.290613, -54.487847, -199.277535>,
				< 75.771943, -53.093500, -201.948285>
			}
			triangle {
				< 78.757845, -59.701305, -204.434529>,
				< 75.771943, -53.093500, -201.948285>,
				< 79.622850, -57.007622, -209.600389>
			}
			triangle {
				< 79.622850, -57.007622, -209.600389>,
				< 75.771943, -53.093500, -201.948285>,
				< 76.144747, -51.412910, -204.039142>
			}
			triangle {
				< 79.622850, -57.007622, -209.600389>,
				< 76.144747, -51.412910, -204.039142>,
				< 80.285542, -53.760972, -213.645130>
			}
			triangle {
				< 80.285542, -53.760972, -213.645130>,
				< 76.144747, -51.412910, -204.039142>,
				< 76.387003, -49.560599, -205.407441>
			}
			triangle {
				< 80.285542, -53.760972, -213.645130>,
				< 76.387003, -49.560599, -205.407441>,
				< 80.712602, -50.182603, -216.292322>
			}
			triangle {
				< 80.712602, -50.182603, -216.292322>,
				< 76.387003, -49.560599, -205.407441>,
				< 76.484397, -47.662798, -205.959737>
			}
			triangle {
				< 80.712602, -50.182603, -216.292322>,
				< 76.484397, -47.662798, -205.959737>,
				< 80.883406, -46.516344, -217.360809>
			}
			triangle {
				< 80.883406, -46.516344, -217.360809>,
				< 76.484397, -47.662798, -205.959737>,
				< 76.431192, -45.848850, -205.658302>
			}
			triangle {
				< 80.883406, -46.516344, -217.360809>,
				< 76.431192, -45.848850, -205.658302>,
				< 80.790214, -43.012053, -216.777578>
			}
			triangle {
				< 80.790214, -43.012053, -216.777578>,
				< 76.431192, -45.848850, -205.658302>,
				< 76.230794, -44.242356, -204.523712>
			}
			triangle {
				< 80.790214, -43.012053, -216.777578>,
				< 76.230794, -44.242356, -204.523712>,
				< 80.437385, -39.908547, -214.582518>
			}
			triangle {
				< 80.437385, -39.908547, -214.582518>,
				< 76.230794, -44.242356, -204.523712>,
				< 75.894542, -42.952798, -202.633381>
			}
			triangle {
				< 80.437385, -39.908547, -214.582518>,
				< 75.894542, -42.952798, -202.633381>,
				< 79.841442, -37.417334, -210.925728>
			}
			triangle {
				< 79.841442, -37.417334, -210.925728>,
				< 75.894542, -42.952798, -202.633381>,
				< 75.442493, -42.068079, -200.116545>
			}
			triangle {
				< 79.841442, -37.417334, -210.925728>,
				< 75.442493, -42.068079, -200.116545>,
				< 79.031877, -35.708182, -206.057340>
			}
			triangle {
				< 79.031877, -35.708182, -206.057340>,
				< 75.442493, -42.068079, -200.116545>,
				< 74.902378, -41.648474, -197.144836>
			}
			triangle {
				< 79.031877, -35.708182, -206.057340>,
				< 74.902378, -41.648474, -197.144836>,
				< 78.052692, -34.897521, -200.309873>
			}
			triangle {
				< 78.052692, -34.897521, -200.309873>,
				< 74.902378, -41.648474, -197.144836>,
				< 74.308857, -41.722555, -193.920970>
			}
			triangle {
				< 78.052692, -34.897521, -200.309873>,
				< 74.308857, -41.722555, -193.920970>,
				< 76.961704, -35.040691, -194.075823>
			}
			triangle {
				< 76.961704, -35.040691, -194.075823>,
				< 74.308857, -41.722555, -193.920970>,
				< 73.701344, -42.285327, -190.664783>
			}
			triangle {
				< 76.961704, -35.040691, -194.075823>,
				< 73.701344, -42.285327, -190.664783>,
				< 75.829662, -36.127869, -187.780410>
			}
			triangle {
				< 75.829662, -36.127869, -187.780410>,
				< 73.701344, -42.285327, -190.664783>,
				< 73.121496, -43.298386, -187.598184>
			}
			triangle {
				< 75.829662, -36.127869, -187.780410>,
				< 73.121496, -43.298386, -187.598184>,
				< 74.735768, -38.084954, -181.852490>
			}
			triangle {
				< 74.735768, -38.084954, -181.852490>,
				< 73.121496, -43.298386, -187.598184>,
				< 72.611146, -44.692729, -184.929907>
			}
			triangle {
				< 74.735768, -38.084954, -181.852490>,
				< 72.611146, -44.692729, -184.929907>,
				< 73.761925, -40.778603, -176.695362>
			}
			triangle {
				< 73.761925, -40.778603, -176.695362>,
				< 72.611146, -44.692729, -184.929907>,
				< 72.207682, -46.373319, -182.841599>
			}
			triangle {
				< 73.761925, -40.778603, -176.695362>,
				< 72.207682, -46.373319, -182.841599>,
				< 72.985679, -44.025235, -172.659725>
			}
			triangle {
				< 72.985679, -44.025235, -172.659725>,
				< 72.207682, -46.373319, -182.841599>,
				< 71.942039, -48.225634, -181.475222>
			}
			triangle {
				< 72.985679, -44.025235, -172.659725>,
				< 71.942039, -48.225634, -181.475222>,
				< 72.470792, -47.603626, -170.019746>
			}
			triangle {
				< 72.470792, -47.603626, -170.019746>,
				< 71.942039, -48.225634, -181.475222>,
				< 71.834356, -50.123431, -180.923805>
			}
			triangle {
				< 72.470792, -47.603626, -170.019746>,
				< 71.834356, -50.123431, -180.923805>,
				< 72.261669, -51.269889, -168.954283>
			}
			triangle {
				< 72.261669, -51.269889, -168.954283>,
				< 71.834356, -50.123431, -180.923805>,
				< 71.893133, -51.937401, -181.224734>
			}
			triangle {
				< 72.261669, -51.269889, -168.954283>,
				< 71.893133, -51.937401, -181.224734>,
				< 72.375886, -54.774199, -169.535771>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 71.834356, -50.123431, -180.923805>,
				< 71.942039, -48.225634, -181.475222>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 71.942039, -48.225634, -181.475222>,
				< 72.207682, -46.373319, -182.841599>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 72.207682, -46.373319, -182.841599>,
				< 72.611146, -44.692729, -184.929907>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 72.611146, -44.692729, -184.929907>,
				< 73.121496, -43.298386, -187.598184>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 73.121496, -43.298386, -187.598184>,
				< 73.701344, -42.285327, -190.664783>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 73.701344, -42.285327, -190.664783>,
				< 74.308857, -41.722555, -193.920970>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 74.308857, -41.722555, -193.920970>,
				< 74.902378, -41.648474, -197.144836>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 74.902378, -41.648474, -197.144836>,
				< 75.442493, -42.068079, -200.116545>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 75.442493, -42.068079, -200.116545>,
				< 75.894542, -42.952798, -202.633381>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 75.894542, -42.952798, -202.633381>,
				< 76.230794, -44.242356, -204.523712>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 76.230794, -44.242356, -204.523712>,
				< 76.431192, -45.848850, -205.658302>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 76.431192, -45.848850, -205.658302>,
				< 76.484397, -47.662798, -205.959737>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 76.484397, -47.662798, -205.959737>,
				< 76.387003, -49.560599, -205.407441>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 76.387003, -49.560599, -205.407441>,
				< 76.144747, -51.412910, -204.039142>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 76.144747, -51.412910, -204.039142>,
				< 75.771943, -53.093500, -201.948285>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 75.771943, -53.093500, -201.948285>,
				< 75.290613, -54.487847, -199.277535>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 75.290613, -54.487847, -199.277535>,
				< 74.730963, -55.500925, -196.209222>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 74.730963, -55.500925, -196.209222>,
				< 74.128963, -56.063678, -192.952543>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 74.128963, -56.063678, -192.952543>,
				< 73.525175, -56.137774, -189.729542>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 73.525175, -56.137774, -189.729542>,
				< 72.961785, -55.718169, -186.759830>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 72.961785, -55.718169, -186.759830>,
				< 72.479323, -54.833431, -184.245512>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 72.479323, -54.833431, -184.245512>,
				< 72.113879, -53.543873, -182.357669>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 72.113879, -53.543873, -182.357669>,
				< 71.893133, -51.937401, -181.224734>
			}
			triangle {
				< 73.341124, -48.893128, -193.540305>,
				< 71.893133, -51.937401, -181.224734>,
				< 71.834356, -50.123431, -180.923805>
			}
			
		}
		// _Thigh01
		union {
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 71.178891, -6.058832, -89.104541>,
				< 71.704380, -10.263721, -92.104152>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 70.211731, -2.713713, -83.748206>,
				< 71.178891, -6.058832, -89.104541>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 68.828762, -0.456394, -76.409273>,
				< 70.211731, -2.713713, -83.748206>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 67.080714, 0.559336, -67.598671>,
				< 68.828762, -0.456394, -76.409273>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 65.051280, 0.264265, -57.926089>,
				< 67.080714, 0.559336, -67.598671>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 62.860653, -1.321545, -48.056465>,
				< 65.051280, 0.264265, -57.926089>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 60.662277, -4.090001, -38.662925>,
				< 62.860653, -1.321545, -48.056465>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 58.631167, -7.852406, -30.379565>,
				< 60.662277, -4.090001, -38.662925>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 56.945048, -12.352386, -23.760466>,
				< 58.631167, -7.852406, -30.379565>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 55.761803, -17.283294, -19.244360>,
				< 56.945048, -12.352386, -23.760466>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 55.197291, -22.309048, -17.128572>,
				< 55.761803, -17.283294, -19.244360>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 55.308182, -27.087186, -17.551778>,
				< 55.197291, -22.309048, -17.128572>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 56.083001, -31.292070, -20.486215>,
				< 55.308182, -27.087186, -17.551778>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 57.444341, -34.637149, -25.739318>,
				< 56.083001, -31.292070, -20.486215>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 59.260752, -36.894470, -32.964587>,
				< 57.444341, -34.637149, -25.739318>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 61.365400, -37.910242, -41.681815>,
				< 59.260752, -36.894470, -32.964587>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 63.578904, -37.615169, -51.305972>,
				< 61.365400, -37.910242, -41.681815>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 65.731689, -36.029361, -61.185203>,
				< 63.578904, -37.615169, -51.305972>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 67.680672, -33.260901, -70.644043>,
				< 65.731689, -36.029361, -61.185203>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 69.317557, -29.498499, -79.030670>,
				< 67.680672, -33.260901, -70.644043>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 70.570305, -24.998518, -85.763350>,
				< 69.317557, -29.498499, -79.030670>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 71.397051, -20.067630, -90.372853>,
				< 70.570305, -24.998518, -85.763350>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 71.777612, -15.041877, -92.536986>,
				< 71.397051, -20.067630, -90.372853>
			}
			triangle {
				< 62.910631, -18.671570, -54.893430>,
				< 71.704380, -10.263721, -92.104152>,
				< 71.777612, -15.041877, -92.536986>
			}
			triangle {
				< 71.704380, -10.263721, -92.104152>,
				< 80.499105, 5.686622, -120.924734>,
				< 81.289366, -2.436613, -126.784191>
			}
			triangle {
				< 71.704380, -10.263721, -92.104152>,
				< 71.178891, -6.058832, -89.104541>,
				< 80.499105, 5.686622, -120.924734>
			}
			triangle {
				< 71.178891, -6.058832, -89.104541>,
				< 78.984141, 12.148828, -110.468253>,
				< 80.499105, 5.686622, -120.924734>
			}
			triangle {
				< 71.178891, -6.058832, -89.104541>,
				< 70.211731, -2.713713, -83.748206>,
				< 78.984141, 12.148828, -110.468253>
			}
			triangle {
				< 70.211731, -2.713713, -83.748206>,
				< 76.697603, 16.509656, -96.157514>,
				< 78.984141, 12.148828, -110.468253>
			}
			triangle {
				< 70.211731, -2.713713, -83.748206>,
				< 68.828762, -0.456394, -76.409273>,
				< 76.697603, 16.509656, -96.157514>
			}
			triangle {
				< 68.828762, -0.456394, -76.409273>,
				< 73.631614, 18.471884, -79.004876>,
				< 76.697603, 16.509656, -96.157514>
			}
			triangle {
				< 68.828762, -0.456394, -76.409273>,
				< 67.080714, 0.559336, -67.598671>,
				< 73.631614, 18.471884, -79.004876>
			}
			triangle {
				< 67.080714, 0.559336, -67.598671>,
				< 69.861472, 17.901825, -60.215436>,
				< 73.631614, 18.471884, -79.004876>
			}
			triangle {
				< 67.080714, 0.559336, -67.598671>,
				< 65.051280, 0.264265, -57.926089>,
				< 69.861472, 17.901825, -60.215436>
			}
			triangle {
				< 65.051280, 0.264265, -57.926089>,
				< 65.578051, 14.838277, -41.095044>,
				< 69.861472, 17.901825, -60.215436>
			}
			triangle {
				< 65.051280, 0.264265, -57.926089>,
				< 62.860653, -1.321545, -48.056465>,
				< 65.578051, 14.838277, -41.095044>
			}
			triangle {
				< 62.860653, -1.321545, -48.056465>,
				< 61.090324, 9.490062, -22.951256>,
				< 65.578051, 14.838277, -41.095044>
			}
			triangle {
				< 62.860653, -1.321545, -48.056465>,
				< 60.662277, -4.090001, -38.662925>,
				< 61.090324, 9.490062, -22.951256>
			}
			triangle {
				< 60.662277, -4.090001, -38.662925>,
				< 56.799002, 2.221668, -7.001474>,
				< 61.090324, 9.490062, -22.951256>
			}
			triangle {
				< 60.662277, -4.090001, -38.662925>,
				< 58.631167, -7.852406, -30.379565>,
				< 56.799002, 2.221668, -7.001474>
			}
			triangle {
				< 58.631167, -7.852406, -30.379565>,
				< 53.144049, -6.471646, 5.707351>,
				< 56.799002, 2.221668, -7.001474>
			}
			triangle {
				< 58.631167, -7.852406, -30.379565>,
				< 56.945048, -12.352386, -23.760466>,
				< 53.144049, -6.471646, 5.707351>
			}
			triangle {
				< 56.945048, -12.352386, -23.760466>,
				< 50.533995, -15.997380, 14.358388>,
				< 53.144049, -6.471646, 5.707351>
			}
			triangle {
				< 56.945048, -12.352386, -23.760466>,
				< 55.761803, -17.283294, -19.244360>,
				< 50.533995, -15.997380, 14.358388>
			}
			triangle {
				< 55.761803, -17.283294, -19.244360>,
				< 49.276780, -25.706425, 18.405532>,
				< 50.533995, -15.997380, 14.358388>
			}
			triangle {
				< 55.761803, -17.283294, -19.244360>,
				< 55.197291, -22.309048, -17.128572>,
				< 49.276780, -25.706425, 18.405532>
			}
			triangle {
				< 55.197291, -22.309048, -17.128572>,
				< 49.524829, -34.937106, 17.596198>,
				< 49.276780, -25.706425, 18.405532>
			}
			triangle {
				< 55.197291, -22.309048, -17.128572>,
				< 55.308182, -27.087186, -17.551778>,
				< 49.524829, -34.937106, 17.596198>
			}
			triangle {
				< 55.308182, -27.087186, -17.551778>,
				< 51.247660, -43.060321, 11.980842>,
				< 49.524829, -34.937106, 17.596198>
			}
			triangle {
				< 55.308182, -27.087186, -17.551778>,
				< 56.083001, -31.292070, -20.486215>,
				< 51.247660, -43.060321, 11.980842>
			}
			triangle {
				< 56.083001, -31.292070, -20.486215>,
				< 54.237105, -49.522545, 1.910991>,
				< 51.247660, -43.060321, 11.980842>
			}
			triangle {
				< 56.083001, -31.292070, -20.486215>,
				< 57.444341, -34.637149, -25.739318>,
				< 54.237105, -49.522545, 1.910991>
			}
			triangle {
				< 57.444341, -34.637149, -25.739318>,
				< 58.145434, -53.883377, -11.974205>,
				< 54.237105, -49.522545, 1.910991>
			}
			triangle {
				< 57.444341, -34.637149, -25.739318>,
				< 59.260752, -36.894470, -32.964587>,
				< 58.145434, -53.883377, -11.974205>
			}
			triangle {
				< 59.260752, -36.894470, -32.964587>,
				< 62.546037, -55.845603, -28.776303>,
				< 58.145434, -53.883377, -11.974205>
			}
			triangle {
				< 59.260752, -36.894470, -32.964587>,
				< 61.365400, -37.910242, -41.681815>,
				< 62.546037, -55.845603, -28.776303>
			}
			triangle {
				< 61.365400, -37.910242, -41.681815>,
				< 67.005165, -55.275545, -47.384210>,
				< 62.546037, -55.845603, -28.776303>
			}
			triangle {
				< 61.365400, -37.910242, -41.681815>,
				< 63.578904, -37.615169, -51.305972>,
				< 67.005165, -55.275545, -47.384210>
			}
			triangle {
				< 63.578904, -37.615169, -51.305972>,
				< 71.147487, -52.212019, -66.541076>,
				< 67.005165, -55.275545, -47.384210>
			}
			triangle {
				< 63.578904, -37.615169, -51.305972>,
				< 65.731689, -36.029361, -61.185203>,
				< 71.147487, -52.212019, -66.541076>
			}
			triangle {
				< 65.731689, -36.029361, -61.185203>,
				< 74.702084, -46.863802, -84.929444>,
				< 71.147487, -52.212019, -66.541076>
			}
			triangle {
				< 65.731689, -36.029361, -61.185203>,
				< 67.680672, -33.260901, -70.644043>,
				< 74.702084, -46.863802, -84.929444>
			}
			triangle {
				< 67.680672, -33.260901, -70.644043>,
				< 77.517807, -39.595388, -101.266384>,
				< 74.702084, -46.863802, -84.929444>
			}
			triangle {
				< 67.680672, -33.260901, -70.644043>,
				< 69.317557, -29.498499, -79.030670>,
				< 77.517807, -39.595388, -101.266384>
			}
			triangle {
				< 69.317557, -29.498499, -79.030670>,
				< 79.551235, -30.902075, -114.400737>,
				< 77.517807, -39.595388, -101.266384>
			}
			triangle {
				< 69.317557, -29.498499, -79.030670>,
				< 70.570305, -24.998518, -85.763350>,
				< 79.551235, -30.902075, -114.400737>
			}
			triangle {
				< 70.570305, -24.998518, -85.763350>,
				< 80.827668, -21.376340, -123.401813>,
				< 79.551235, -30.902075, -114.400737>
			}
			triangle {
				< 70.570305, -24.998518, -85.763350>,
				< 71.397051, -20.067630, -90.372853>,
				< 80.827668, -21.376340, -123.401813>
			}
			triangle {
				< 71.397051, -20.067630, -90.372853>,
				< 81.396639, -11.667295, -127.630040>,
				< 80.827668, -21.376340, -123.401813>
			}
			triangle {
				< 71.397051, -20.067630, -90.372853>,
				< 71.777612, -15.041877, -92.536986>,
				< 81.396639, -11.667295, -127.630040>
			}
			triangle {
				< 71.777612, -15.041877, -92.536986>,
				< 81.289366, -2.436613, -126.784191>,
				< 81.396639, -11.667295, -127.630040>
			}
			triangle {
				< 71.777612, -15.041877, -92.536986>,
				< 71.704380, -10.263721, -92.104152>,
				< 81.289366, -2.436613, -126.784191>
			}
			triangle {
				< 81.289366, -2.436613, -126.784191>,
				< 90.634190, 15.764277, -148.227945>,
				< 91.478035, 4.276318, -156.604275>
			}
			triangle {
				< 81.289366, -2.436613, -126.784191>,
				< 80.499105, 5.686622, -120.924734>,
				< 90.634190, 15.764277, -148.227945>
			}
			triangle {
				< 80.499105, 5.686622, -120.924734>,
				< 88.920966, 24.903221, -133.284628>,
				< 90.634190, 15.764277, -148.227945>
			}
			triangle {
				< 80.499105, 5.686622, -120.924734>,
				< 78.984141, 12.148828, -110.468253>,
				< 88.920966, 24.903221, -133.284628>
			}
			triangle {
				< 78.984141, 12.148828, -110.468253>,
				< 86.151347, 31.070357, -112.845719>,
				< 88.920966, 24.903221, -133.284628>
			}
			triangle {
				< 78.984141, 12.148828, -110.468253>,
				< 76.697603, 16.509656, -96.157514>,
				< 86.151347, 31.070357, -112.845719>
			}
			triangle {
				< 76.697603, 16.509656, -96.157514>,
				< 82.183376, 33.845399, -88.374890>,
				< 86.151347, 31.070357, -112.845719>
			}
			triangle {
				< 76.697603, 16.509656, -96.157514>,
				< 73.631614, 18.471884, -79.004876>,
				< 82.183376, 33.845399, -88.374890>
			}
			triangle {
				< 73.631614, 18.471884, -79.004876>,
				< 77.019945, 33.039220, -61.613690>,
				< 82.183376, 33.845399, -88.374890>
			}
			triangle {
				< 73.631614, 18.471884, -79.004876>,
				< 69.861472, 17.901825, -60.215436>,
				< 77.019945, 33.039220, -61.613690>
			}
			triangle {
				< 69.861472, 17.901825, -60.215436>,
				< 70.880949, 28.706724, -34.442175>,
				< 77.019945, 33.039220, -61.613690>
			}
			triangle {
				< 69.861472, 17.901825, -60.215436>,
				< 65.578051, 14.838277, -41.095044>,
				< 70.880949, 28.706724, -34.442175>
			}
			triangle {
				< 65.578051, 14.838277, -41.095044>,
				< 64.221762, 21.143198, -8.728982>,
				< 70.880949, 28.706724, -34.442175>
			}
			triangle {
				< 65.578051, 14.838277, -41.095044>,
				< 61.090324, 9.490062, -22.951256>,
				< 64.221762, 21.143198, -8.728982>
			}
			triangle {
				< 61.090324, 9.490062, -22.951256>,
				< 57.689372, 10.864114, 13.808287>,
				< 64.221762, 21.143198, -8.728982>
			}
			triangle {
				< 61.090324, 9.490062, -22.951256>,
				< 56.799002, 2.221668, -7.001474>,
				< 57.689372, 10.864114, 13.808287>
			}
			triangle {
				< 56.799002, 2.221668, -7.001474>,
				< 52.024588, -1.430075, 31.715166>,
				< 57.689372, 10.864114, 13.808287>
			}
			triangle {
				< 56.799002, 2.221668, -7.001474>,
				< 53.144049, -6.471646, 5.707351>,
				< 52.024588, -1.430075, 31.715166>
			}
			triangle {
				< 53.144049, -6.471646, 5.707351>,
				< 47.931813, -14.901525, 43.876100>,
				< 52.024588, -1.430075, 31.715166>
			}
			triangle {
				< 53.144049, -6.471646, 5.707351>,
				< 50.533995, -15.997380, 14.358388>,
				< 47.931813, -14.901525, 43.876100>
			}
			triangle {
				< 50.533995, -15.997380, 14.358388>,
				< 45.948140, -28.632188, 49.556881>,
				< 47.931813, -14.901525, 43.876100>
			}
			triangle {
				< 50.533995, -15.997380, 14.358388>,
				< 49.276780, -25.706425, 18.405532>,
				< 45.948140, -28.632188, 49.556881>
			}
			triangle {
				< 49.276780, -25.706425, 18.405532>,
				< 46.340995, -41.686278, 48.421089>,
				< 45.948140, -28.632188, 49.556881>
			}
			triangle {
				< 49.276780, -25.706425, 18.405532>,
				< 49.524829, -34.937106, 17.596198>,
				< 46.340995, -41.686278, 48.421089>
			}
			triangle {
				< 49.524829, -34.937106, 17.596198>,
				< 49.056552, -53.174272, 40.535931>,
				< 46.340995, -41.686278, 48.421089>
			}
			triangle {
				< 49.524829, -34.937106, 17.596198>,
				< 51.247660, -43.060321, 11.980842>,
				< 49.056552, -53.174272, 40.535931>
			}
			triangle {
				< 51.247660, -43.060321, 11.980842>,
				< 53.730298, -62.313236, 26.370466>,
				< 49.056552, -53.174272, 40.535931>
			}
			triangle {
				< 51.247660, -43.060321, 11.980842>,
				< 54.237105, -49.522545, 1.910991>,
				< 53.730298, -62.313236, 26.370466>
			}
			triangle {
				< 54.237105, -49.522545, 1.910991>,
				< 59.757043, -68.480372, 6.788464>,
				< 53.730298, -62.313236, 26.370466>
			}
			triangle {
				< 54.237105, -49.522545, 1.910991>,
				< 58.145434, -53.883377, -11.974205>,
				< 59.757043, -68.480372, 6.788464>
			}
			triangle {
				< 58.145434, -53.883377, -11.974205>,
				< 66.405833, -71.255371, -16.976234>,
				< 59.757043, -68.480372, 6.788464>
			}
			triangle {
				< 58.145434, -53.883377, -11.974205>,
				< 62.546037, -55.845603, -28.776303>,
				< 66.405833, -71.255371, -16.976234>
			}
			triangle {
				< 62.546037, -55.845603, -28.776303>,
				< 72.954148, -70.449181, -43.371908>,
				< 66.405833, -71.255371, -16.976234>
			}
			triangle {
				< 62.546037, -55.845603, -28.776303>,
				< 67.005165, -55.275545, -47.384210>,
				< 72.954148, -70.449181, -43.371908>
			}
			triangle {
				< 67.005165, -55.275545, -47.384210>,
				< 78.809500, -66.116698, -70.617050>,
				< 72.954148, -70.449181, -43.371908>
			}
			triangle {
				< 67.005165, -55.275545, -47.384210>,
				< 71.147487, -52.212019, -66.541076>,
				< 78.809500, -66.116698, -70.617050>
			}
			triangle {
				< 71.147487, -52.212019, -66.541076>,
				< 83.593227, -58.553211, -96.823223>,
				< 78.809500, -66.116698, -70.617050>
			}
			triangle {
				< 71.147487, -52.212019, -66.541076>,
				< 74.702084, -46.863802, -84.929444>,
				< 83.593227, -58.553211, -96.823223>
			}
			triangle {
				< 74.702084, -46.863802, -84.929444>,
				< 87.161966, -48.274089, -120.139845>,
				< 83.593227, -58.553211, -96.823223>
			}
			triangle {
				< 74.702084, -46.863802, -84.929444>,
				< 77.517807, -39.595388, -101.266384>,
				< 87.161966, -48.274089, -120.139845>
			}
			triangle {
				< 77.517807, -39.595388, -101.266384>,
				< 89.570299, -35.979919, -138.903320>,
				< 87.161966, -48.274089, -120.139845>
			}
			triangle {
				< 77.517807, -39.595388, -101.266384>,
				< 79.551235, -30.902075, -114.400737>,
				< 89.570299, -35.979919, -138.903320>
			}
			triangle {
				< 79.551235, -30.902075, -114.400737>,
				< 90.986051, -22.508493, -151.768565>,
				< 89.570299, -35.979919, -138.903320>
			}
			triangle {
				< 79.551235, -30.902075, -114.400737>,
				< 80.827668, -21.376340, -123.401813>,
				< 90.986051, -22.508493, -151.768565>
			}
			triangle {
				< 80.827668, -21.376340, -123.401813>,
				< 91.588102, -8.777827, -157.813221>,
				< 90.986051, -22.508493, -151.768565>
			}
			triangle {
				< 80.827668, -21.376340, -123.401813>,
				< 81.396639, -11.667295, -127.630040>,
				< 91.588102, -8.777827, -157.813221>
			}
			triangle {
				< 81.396639, -11.667295, -127.630040>,
				< 91.478035, 4.276318, -156.604275>,
				< 91.588102, -8.777827, -157.813221>
			}
			triangle {
				< 81.396639, -11.667295, -127.630040>,
				< 81.289366, -2.436613, -126.784191>,
				< 91.478035, 4.276318, -156.604275>
			}
			triangle {
				< 91.478035, 4.276318, -156.604275>,
				< 101.417892, 23.487441, -169.094443>,
				< 102.194346, 9.417583, -179.459855>
			}
			triangle {
				< 91.478035, 4.276318, -156.604275>,
				< 90.634190, 15.764277, -148.227945>,
				< 101.417892, 23.487441, -169.094443>
			}
			triangle {
				< 90.634190, 15.764277, -148.227945>,
				< 99.720687, 34.680344, -150.603607>,
				< 101.417892, 23.487441, -169.094443>
			}
			triangle {
				< 90.634190, 15.764277, -148.227945>,
				< 88.920966, 24.903221, -133.284628>,
				< 99.720687, 34.680344, -150.603607>
			}
			triangle {
				< 88.920966, 24.903221, -133.284628>,
				< 96.757971, 42.233504, -125.319242>,
				< 99.720687, 34.680344, -150.603607>
			}
			triangle {
				< 88.920966, 24.903221, -133.284628>,
				< 86.151347, 31.070357, -112.845719>,
				< 96.757971, 42.233504, -125.319242>
			}
			triangle {
				< 86.151347, 31.070357, -112.845719>,
				< 92.230640, 45.632165, -95.066421>,
				< 96.757971, 42.233504, -125.319242>
			}
			triangle {
				< 86.151347, 31.070357, -112.845719>,
				< 82.183376, 33.845399, -88.374890>,
				< 92.230640, 45.632165, -95.066421>
			}
			triangle {
				< 82.183376, 33.845399, -88.374890>,
				< 86.043604, 44.644799, -62.020477>,
				< 92.230640, 45.632165, -95.066421>
			}
			triangle {
				< 82.183376, 33.845399, -88.374890>,
				< 77.019945, 33.039220, -61.613690>,
				< 86.043604, 44.644799, -62.020477>
			}
			triangle {
				< 77.019945, 33.039220, -61.613690>,
				< 78.421161, 39.338611, -28.525310>,
				< 86.043604, 44.644799, -62.020477>
			}
			triangle {
				< 77.019945, 33.039220, -61.613690>,
				< 70.880949, 28.706724, -34.442175>,
				< 78.421161, 39.338611, -28.525310>
			}
			triangle {
				< 70.880949, 28.706724, -34.442175>,
				< 69.941610, 30.075228, 3.102704>,
				< 78.421161, 39.338611, -28.525310>
			}
			triangle {
				< 70.880949, 28.706724, -34.442175>,
				< 64.221762, 21.143198, -8.728982>,
				< 69.941610, 30.075228, 3.102704>
			}
			triangle {
				< 64.221762, 21.143198, -8.728982>,
				< 61.476968, 17.485978, 30.755850>,
				< 69.941610, 30.075228, 3.102704>
			}
			triangle {
				< 64.221762, 21.143198, -8.728982>,
				< 57.689372, 10.864114, 13.808287>,
				< 61.476968, 17.485978, 30.755850>
			}
			triangle {
				< 57.689372, 10.864114, 13.808287>,
				< 54.049946, 2.428727, 52.674279>,
				< 61.476968, 17.485978, 30.755850>
			}
			triangle {
				< 57.689372, 10.864114, 13.808287>,
				< 52.024588, -1.430075, 31.715166>,
				< 54.049946, 2.428727, 52.674279>
			}
			triangle {
				< 52.024588, -1.430075, 31.715166>,
				< 48.644315, -14.070411, 67.529477>,
				< 54.049946, 2.428727, 52.674279>
			}
			triangle {
				< 52.024588, -1.430075, 31.715166>,
				< 47.931813, -14.901525, 43.876100>,
				< 48.644315, -14.070411, 67.529477>
			}
			triangle {
				< 47.931813, -14.901525, 43.876100>,
				< 46.014391, -30.886896, 74.459732>,
				< 48.644315, -14.070411, 67.529477>
			}
			triangle {
				< 47.931813, -14.901525, 43.876100>,
				< 45.948140, -28.632188, 49.556881>,
				< 46.014391, -30.886896, 74.459732>
			}
			triangle {
				< 45.948140, -28.632188, 49.556881>,
				< 46.536438, -46.874866, 73.074482>,
				< 46.014391, -30.886896, 74.459732>
			}
			triangle {
				< 45.948140, -28.632188, 49.556881>,
				< 46.340995, -41.686278, 48.421089>,
				< 46.536438, -46.874866, 73.074482>
			}
			triangle {
				< 46.340995, -41.686278, 48.421089>,
				< 50.134663, -60.944755, 63.451432>,
				< 46.536438, -46.874866, 73.074482>
			}
			triangle {
				< 46.340995, -41.686278, 48.421089>,
				< 49.056552, -53.174272, 40.535931>,
				< 50.134663, -60.944755, 63.451432>
			}
			triangle {
				< 49.056552, -53.174272, 40.535931>,
				< 56.296207, -72.137587, 46.137083>,
				< 50.134663, -60.944755, 63.451432>
			}
			triangle {
				< 49.056552, -53.174272, 40.535931>,
				< 53.730298, -62.313236, 26.370466>,
				< 56.296207, -72.137587, 46.137083>
			}
			triangle {
				< 53.730298, -62.313236, 26.370466>,
				< 64.172037, -79.690799, 22.149595>,
				< 56.296207, -72.137587, 46.137083>
			}
			triangle {
				< 53.730298, -62.313236, 26.370466>,
				< 59.757043, -68.480372, 6.788464>,
				< 64.172037, -79.690799, 22.149595>
			}
			triangle {
				< 59.757043, -68.480372, 6.788464>,
				< 72.744332, -83.089456, -7.033710>,
				< 64.172037, -79.690799, 22.149595>
			}
			triangle {
				< 59.757043, -68.480372, 6.788464>,
				< 66.405833, -71.255371, -16.976234>,
				< 72.744332, -83.089456, -7.033710>
			}
			triangle {
				< 66.405833, -71.255371, -16.976234>,
				< 81.021190, -82.102090, -39.525904>,
				< 72.744332, -83.089456, -7.033710>
			}
			triangle {
				< 66.405833, -71.255371, -16.976234>,
				< 72.954148, -70.449181, -43.371908>,
				< 81.021190, -82.102090, -39.525904>
			}
			triangle {
				< 72.954148, -70.449181, -43.371908>,
				< 88.215798, -76.795906, -73.132649>,
				< 81.021190, -82.102090, -39.525904>
			}
			triangle {
				< 72.954148, -70.449181, -43.371908>,
				< 78.809500, -66.116698, -70.617050>,
				< 88.215798, -76.795906, -73.132649>
			}
			triangle {
				< 78.809500, -66.116698, -70.617050>,
				< 93.864985, -67.532510, -105.507411>,
				< 88.215798, -76.795906, -73.132649>
			}
			triangle {
				< 78.809500, -66.116698, -70.617050>,
				< 83.593227, -58.553211, -96.823223>,
				< 93.864985, -67.532510, -105.507411>
			}
			triangle {
				< 83.593227, -58.553211, -96.823223>,
				< 97.858340, -54.943249, -134.340778>,
				< 93.864985, -67.532510, -105.507411>
			}
			triangle {
				< 83.593227, -58.553211, -96.823223>,
				< 87.161966, -48.274089, -120.139845>,
				< 97.858340, -54.943249, -134.340778>
			}
			triangle {
				< 87.161966, -48.274089, -120.139845>,
				< 100.373812, -39.886028, -157.555237>,
				< 97.858340, -54.943249, -134.340778>
			}
			triangle {
				< 87.161966, -48.274089, -120.139845>,
				< 89.570299, -35.979919, -138.903320>,
				< 100.373812, -39.886028, -157.555237>
			}
			triangle {
				< 89.570299, -35.979919, -138.903320>,
				< 101.742998, -23.386933, -173.475623>,
				< 100.373812, -39.886028, -157.555237>
			}
			triangle {
				< 89.570299, -35.979919, -138.903320>,
				< 90.986051, -22.508493, -151.768565>,
				< 101.742998, -23.386933, -173.475623>
			}
			triangle {
				< 90.986051, -22.508493, -151.768565>,
				< 102.290124, -6.570403, -180.955887>,
				< 101.742998, -23.386933, -173.475623>
			}
			triangle {
				< 90.986051, -22.508493, -151.768565>,
				< 91.588102, -8.777827, -157.813221>,
				< 102.290124, -6.570403, -180.955887>
			}
			triangle {
				< 91.588102, -8.777827, -157.813221>,
				< 102.194346, 9.417583, -179.459855>,
				< 102.290124, -6.570403, -180.955887>
			}
			triangle {
				< 91.588102, -8.777827, -157.813221>,
				< 91.478035, 4.276318, -156.604275>,
				< 102.194346, 9.417583, -179.459855>
			}
			triangle {
				< 102.194346, 9.417583, -179.459855>,
				< 112.631314, 28.329769, -181.948379>,
				< 113.320053, 12.636859, -193.624020>
			}
			triangle {
				< 102.194346, 9.417583, -179.459855>,
				< 101.417892, 23.487441, -169.094443>,
				< 112.631314, 28.329769, -181.948379>
			}
			triangle {
				< 101.417892, 23.487441, -169.094443>,
				< 111.012481, 40.813815, -161.119193>,
				< 112.631314, 28.329769, -181.948379>
			}
			triangle {
				< 101.417892, 23.487441, -169.094443>,
				< 99.720687, 34.680344, -150.603607>,
				< 111.012481, 40.813815, -161.119193>
			}
			triangle {
				< 99.720687, 34.680344, -150.603607>,
				< 107.995227, 49.238268, -132.639840>,
				< 111.012481, 40.813815, -161.119193>
			}
			triangle {
				< 99.720687, 34.680344, -150.603607>,
				< 96.757971, 42.233504, -125.319242>,
				< 107.995227, 49.238268, -132.639840>
			}
			triangle {
				< 96.757971, 42.233504, -125.319242>,
				< 103.156164, 53.028997, -98.575719>,
				< 107.995227, 49.238268, -132.639840>
			}
			triangle {
				< 96.757971, 42.233504, -125.319242>,
				< 92.230640, 45.632165, -95.066421>,
				< 103.156164, 53.028997, -98.575719>
			}
			triangle {
				< 92.230640, 45.632165, -95.066421>,
				< 96.319295, 51.927716, -61.391909>,
				< 103.156164, 53.028997, -98.575719>
			}
			triangle {
				< 92.230640, 45.632165, -95.066421>,
				< 86.043604, 44.644799, -62.020477>,
				< 96.319295, 51.927716, -61.391909>
			}
			triangle {
				< 86.043604, 44.644799, -62.020477>,
				< 87.704681, 46.009410, -23.743531>,
				< 96.319295, 51.927716, -61.391909>
			}
			triangle {
				< 86.043604, 44.644799, -62.020477>,
				< 78.421161, 39.338611, -28.525310>,
				< 87.704681, 46.009410, -23.743531>
			}
			triangle {
				< 78.421161, 39.338611, -28.525310>,
				< 77.975757, 35.677489, 11.754901>,
				< 87.704681, 46.009410, -23.743531>
			}
			triangle {
				< 78.421161, 39.338611, -28.525310>,
				< 69.941610, 30.075228, 3.102704>,
				< 77.975757, 35.677489, 11.754901>
			}
			triangle {
				< 69.941610, 30.075228, 3.102704>,
				< 68.166003, 21.635979, 42.740703>,
				< 77.975757, 35.677489, 11.754901>
			}
			triangle {
				< 69.941610, 30.075228, 3.102704>,
				< 61.476968, 17.485978, 30.755850>,
				< 68.166003, 21.635979, 42.740703>
			}
			triangle {
				< 61.476968, 17.485978, 30.755850>,
				< 59.502404, 4.841822, 67.259997>,
				< 68.166003, 21.635979, 42.740703>
			}
			triangle {
				< 61.476968, 17.485978, 30.755850>,
				< 54.049946, 2.428727, 52.674279>,
				< 59.502404, 4.841822, 67.259997>
			}
			triangle {
				< 54.049946, 2.428727, 52.674279>,
				< 53.171646, -13.560559, 83.854824>,
				< 59.502404, 4.841822, 67.259997>
			}
			triangle {
				< 54.049946, 2.428727, 52.674279>,
				< 48.644315, -14.070411, 67.529477>,
				< 53.171646, -13.560559, 83.854824>
			}
			triangle {
				< 48.644315, -14.070411, 67.529477>,
				< 50.085388, -32.316975, 91.589630>,
				< 53.171646, -13.560559, 83.854824>
			}
			triangle {
				< 48.644315, -14.070411, 67.529477>,
				< 46.014391, -30.886896, 74.459732>,
				< 50.085388, -32.316975, 91.589630>
			}
			triangle {
				< 46.014391, -30.886896, 74.459732>,
				< 50.698884, -50.149243, 90.043783>,
				< 50.085388, -32.316975, 91.589630>
			}
			triangle {
				< 46.014391, -30.886896, 74.459732>,
				< 46.536438, -46.874866, 73.074482>,
				< 50.698884, -50.149243, 90.043783>
			}
			triangle {
				< 46.536438, -46.874866, 73.074482>,
				< 54.920394, -65.842107, 79.300828>,
				< 50.698884, -50.149243, 90.043783>
			}
			triangle {
				< 46.536438, -46.874866, 73.074482>,
				< 50.134663, -60.944755, 63.451432>,
				< 54.920394, -65.842107, 79.300828>
			}
			triangle {
				< 50.134663, -60.944755, 63.451432>,
				< 62.129099, -78.326121, 59.950750>,
				< 54.920394, -65.842107, 79.300828>
			}
			triangle {
				< 50.134663, -60.944755, 63.451432>,
				< 56.296207, -72.137587, 46.137083>,
				< 62.129099, -78.326121, 59.950750>
			}
			triangle {
				< 56.296207, -72.137587, 46.137083>,
				< 71.299829, -86.750619, 33.102669>,
				< 62.129099, -78.326121, 59.950750>
			}
			triangle {
				< 56.296207, -72.137587, 46.137083>,
				< 64.172037, -79.690799, 22.149595>,
				< 71.299829, -86.750619, 33.102669>
			}
			triangle {
				< 64.172037, -79.690799, 22.149595>,
				< 81.206150, -90.541333, 0.384062>,
				< 71.299829, -86.750619, 33.102669>
			}
			triangle {
				< 64.172037, -79.690799, 22.149595>,
				< 72.744332, -83.089456, -7.033710>,
				< 81.206150, -90.541333, 0.384062>
			}
			triangle {
				< 72.744332, -83.089456, -7.033710>,
				< 90.661459, -89.440033, -36.102831>,
				< 81.206150, -90.541333, 0.384062>
			}
			triangle {
				< 72.744332, -83.089456, -7.033710>,
				< 81.021190, -82.102090, -39.525904>,
				< 90.661459, -89.440033, -36.102831>
			}
			triangle {
				< 81.021190, -82.102090, -39.525904>,
				< 98.739952, -83.521768, -73.891565>,
				< 90.661459, -89.440033, -36.102831>
			}
			triangle {
				< 81.021190, -82.102090, -39.525904>,
				< 88.215798, -76.795906, -73.132649>,
				< 98.739952, -83.521768, -73.891565>
			}
			triangle {
				< 88.215798, -76.795906, -73.132649>,
				< 104.922801, -73.189855, -110.329822>,
				< 98.739952, -83.521768, -73.891565>
			}
			triangle {
				< 88.215798, -76.795906, -73.132649>,
				< 93.864985, -67.532510, -105.507411>,
				< 104.922801, -73.189855, -110.329822>
			}
			triangle {
				< 93.864985, -67.532510, -105.507411>,
				< 109.131664, -59.148323, -142.800435>,
				< 104.922801, -73.189855, -110.329822>
			}
			triangle {
				< 93.864985, -67.532510, -105.507411>,
				< 97.858340, -54.943249, -134.340778>,
				< 109.131664, -59.148323, -142.800435>
			}
			triangle {
				< 97.858340, -54.943249, -134.340778>,
				< 111.644201, -42.354155, -168.949649>,
				< 109.131664, -59.148323, -142.800435>
			}
			triangle {
				< 97.858340, -54.943249, -134.340778>,
				< 100.373812, -39.886028, -157.555237>,
				< 111.644201, -42.354155, -168.949649>
			}
			triangle {
				< 100.373812, -39.886028, -157.555237>,
				< 112.921081, -23.951842, -186.883107>,
				< 111.644201, -42.354155, -168.949649>
			}
			triangle {
				< 100.373812, -39.886028, -157.555237>,
				< 101.742998, -23.386933, -173.475623>,
				< 112.921081, -23.951842, -186.883107>
			}
			triangle {
				< 101.742998, -23.386933, -173.475623>,
				< 113.399923, -5.195436, -195.309073>,
				< 112.921081, -23.951842, -186.883107>
			}
			triangle {
				< 101.742998, -23.386933, -173.475623>,
				< 102.290124, -6.570403, -180.955887>,
				< 113.399923, -5.195436, -195.309073>
			}
			triangle {
				< 102.290124, -6.570403, -180.955887>,
				< 113.320053, 12.636859, -193.624020>,
				< 113.399923, -5.195436, -195.309073>
			}
			triangle {
				< 102.290124, -6.570403, -180.955887>,
				< 102.194346, 9.417583, -179.459855>,
				< 113.320053, 12.636859, -193.624020>
			}
			triangle {
				< 113.320053, 12.636859, -193.624020>,
				< 123.878986, 29.961221, -185.688734>,
				< 124.537557, 13.714759, -197.888106>
			}
			triangle {
				< 113.320053, 12.636859, -193.624020>,
				< 112.631314, 28.329769, -181.948379>,
				< 123.878986, 29.961221, -185.688734>
			}
			triangle {
				< 112.631314, 28.329769, -181.948379>,
				< 122.282915, 42.885657, -163.925320>,
				< 123.878986, 29.961221, -185.688734>
			}
			triangle {
				< 112.631314, 28.329769, -181.948379>,
				< 111.012481, 40.813815, -161.119193>,
				< 122.282915, 42.885657, -163.925320>
			}
			triangle {
				< 111.012481, 40.813815, -161.119193>,
				< 119.232409, 51.607314, -134.169757>,
				< 122.282915, 42.885657, -163.925320>
			}
			triangle {
				< 111.012481, 40.813815, -161.119193>,
				< 107.995227, 49.238268, -132.639840>,
				< 119.232409, 51.607314, -134.169757>
			}
			triangle {
				< 107.995227, 49.238268, -132.639840>,
				< 114.255533, 55.531770, -98.583043>,
				< 119.232409, 51.607314, -134.169757>
			}
			triangle {
				< 107.995227, 49.238268, -132.639840>,
				< 103.156164, 53.028997, -98.575719>,
				< 114.255533, 55.531770, -98.583043>
			}
			triangle {
				< 103.156164, 53.028997, -98.575719>,
				< 107.144922, 54.391619, -59.747241>,
				< 114.255533, 55.531770, -98.583043>
			}
			triangle {
				< 103.156164, 53.028997, -98.575719>,
				< 96.319295, 51.927716, -61.391909>,
				< 107.144922, 54.391619, -59.747241>
			}
			triangle {
				< 96.319295, 51.927716, -61.391909>,
				< 98.120451, 48.264597, -20.441972>,
				< 107.144922, 54.391619, -59.747241>
			}
			triangle {
				< 96.319295, 51.927716, -61.391909>,
				< 87.704681, 46.009410, -23.743531>,
				< 98.120451, 48.264597, -20.441972>
			}
			triangle {
				< 87.704681, 46.009410, -23.743531>,
				< 87.880537, 37.568122, 16.598979>,
				< 98.120451, 48.264597, -20.441972>
			}
			triangle {
				< 87.704681, 46.009410, -23.743531>,
				< 77.975757, 35.677489, 11.754901>,
				< 87.880537, 37.568122, 16.598979>
			}
			triangle {
				< 77.975757, 35.677489, 11.754901>,
				< 77.523902, 23.031285, 48.911277>,
				< 87.880537, 37.568122, 16.598979>
			}
			triangle {
				< 77.975757, 35.677489, 11.754901>,
				< 68.166003, 21.635979, 42.740703>,
				< 77.523902, 23.031285, 48.911277>
			}
			triangle {
				< 68.166003, 21.635979, 42.740703>,
				< 68.359673, 5.644655, 74.464433>,
				< 77.523902, 23.031285, 48.911277>
			}
			triangle {
				< 68.166003, 21.635979, 42.740703>,
				< 59.502404, 4.841822, 67.259997>,
				< 68.359673, 5.644655, 74.464433>
			}
			triangle {
				< 59.502404, 4.841822, 67.259997>,
				< 61.655268, -13.406832, 91.750003>,
				< 68.359673, 5.644655, 74.464433>
			}
			triangle {
				< 59.502404, 4.841822, 67.259997>,
				< 53.171646, -13.560559, 83.854824>,
				< 61.655268, -13.406832, 91.750003>
			}
			triangle {
				< 53.171646, -13.560559, 83.854824>,
				< 58.385041, -32.824878, 99.804007>,
				< 61.655268, -13.406832, 91.750003>
			}
			triangle {
				< 53.171646, -13.560559, 83.854824>,
				< 50.085388, -32.316975, 91.589630>,
				< 58.385041, -32.824878, 99.804007>
			}
			triangle {
				< 50.085388, -32.316975, 91.589630>,
				< 59.035406, -51.286187, 98.194450>,
				< 58.385041, -32.824878, 99.804007>
			}
			triangle {
				< 50.085388, -32.316975, 91.589630>,
				< 50.698884, -50.149243, 90.043783>,
				< 59.035406, -51.286187, 98.194450>
			}
			triangle {
				< 50.698884, -50.149243, 90.043783>,
				< 63.508287, -67.532673, 87.007150>,
				< 59.035406, -51.286187, 98.194450>
			}
			triangle {
				< 50.698884, -50.149243, 90.043783>,
				< 54.920394, -65.842107, 79.300828>,
				< 63.508287, -67.532673, 87.007150>
			}
			triangle {
				< 54.920394, -65.842107, 79.300828>,
				< 71.140490, -80.457106, 66.848420>,
				< 63.508287, -67.532673, 87.007150>
			}
			triangle {
				< 54.920394, -65.842107, 79.300828>,
				< 62.129099, -78.326121, 59.950750>,
				< 71.140490, -80.457106, 66.848420>
			}
			triangle {
				< 62.129099, -78.326121, 59.950750>,
				< 80.836222, -89.178726, 38.862668>,
				< 71.140490, -80.457106, 66.848420>
			}
			triangle {
				< 62.129099, -78.326121, 59.950750>,
				< 71.299829, -86.750619, 33.102669>,
				< 80.836222, -89.178726, 38.862668>
			}
			triangle {
				< 71.299829, -86.750619, 33.102669>,
				< 91.285817, -93.103223, 4.736361>,
				< 80.836222, -89.178726, 38.862668>
			}
			triangle {
				< 71.299829, -86.750619, 33.102669>,
				< 81.206150, -90.541333, 0.384062>,
				< 91.285817, -93.103223, 4.736361>
			}
			triangle {
				< 81.206150, -90.541333, 0.384062>,
				< 101.224452, -91.963038, -33.343095>,
				< 91.285817, -93.103223, 4.736361>
			}
			triangle {
				< 81.206150, -90.541333, 0.384062>,
				< 90.661459, -89.440033, -36.102831>,
				< 101.224452, -91.963038, -33.343095>
			}
			triangle {
				< 90.661459, -89.440033, -36.102831>,
				< 109.669901, -85.836023, -72.800890>,
				< 101.224452, -91.963038, -33.343095>
			}
			triangle {
				< 90.661459, -89.440033, -36.102831>,
				< 98.739952, -83.521768, -73.891565>,
				< 109.669901, -85.836023, -72.800890>
			}
			triangle {
				< 98.739952, -83.521768, -73.891565>,
				< 116.079874, -75.139582, -110.861830>,
				< 109.669901, -85.836023, -72.800890>
			}
			triangle {
				< 98.739952, -83.521768, -73.891565>,
				< 104.922801, -73.189855, -110.329822>,
				< 116.079874, -75.139582, -110.861830>
			}
			triangle {
				< 104.922801, -73.189855, -110.329822>,
				< 120.387599, -60.602747, -144.785360>,
				< 116.079874, -75.139582, -110.861830>
			}
			triangle {
				< 104.922801, -73.189855, -110.329822>,
				< 109.131664, -59.148323, -142.800435>,
				< 120.387599, -60.602747, -144.785360>
			}
			triangle {
				< 109.131664, -59.148323, -142.800435>,
				< 122.909479, -43.216169, -172.107056>,
				< 120.387599, -60.602747, -144.785360>
			}
			triangle {
				< 109.131664, -59.148323, -142.800435>,
				< 111.644201, -42.354155, -168.949649>,
				< 122.909479, -43.216169, -172.107056>
			}
			triangle {
				< 111.644201, -42.354155, -168.949649>,
				< 124.156795, -24.164677, -190.844789>,
				< 122.909479, -43.216169, -172.107056>
			}
			triangle {
				< 111.644201, -42.354155, -168.949649>,
				< 112.921081, -23.951842, -186.883107>,
				< 124.156795, -24.164677, -190.844789>
			}
			triangle {
				< 112.921081, -23.951842, -186.883107>,
				< 124.611765, -4.746571, -199.648634>,
				< 124.156795, -24.164677, -190.844789>
			}
			triangle {
				< 112.921081, -23.951842, -186.883107>,
				< 113.399923, -5.195436, -195.309073>,
				< 124.611765, -4.746571, -199.648634>
			}
			triangle {
				< 113.399923, -5.195436, -195.309073>,
				< 124.537557, 13.714759, -197.888106>,
				< 124.611765, -4.746571, -199.648634>
			}
			triangle {
				< 113.399923, -5.195436, -195.309073>,
				< 113.320053, 12.636859, -193.624020>,
				< 124.537557, 13.714759, -197.888106>
			}
			triangle {
				< 124.537557, 13.714759, -197.888106>,
				< 134.508893, 28.270660, -179.809272>,
				< 135.223925, 12.577792, -191.688225>
			}
			triangle {
				< 124.537557, 13.714759, -197.888106>,
				< 123.878986, 29.961221, -185.688734>,
				< 134.508893, 28.270660, -179.809272>
			}
			triangle {
				< 123.878986, 29.961221, -185.688734>,
				< 132.836893, 40.754702, -158.618927>,
				< 134.508893, 28.270660, -179.809272>
			}
			triangle {
				< 123.878986, 29.961221, -185.688734>,
				< 122.282915, 42.885657, -163.925320>,
				< 132.836893, 40.754702, -158.618927>
			}
			triangle {
				< 122.282915, 42.885657, -163.925320>,
				< 129.734054, 49.179178, -129.646882>,
				< 132.836893, 40.754702, -158.618927>
			}
			triangle {
				< 122.282915, 42.885657, -163.925320>,
				< 119.232409, 51.607314, -134.169757>,
				< 129.734054, 49.179178, -129.646882>
			}
			triangle {
				< 119.232409, 51.607314, -134.169757>,
				< 124.772899, 52.969906, -94.995610>,
				< 129.734054, 49.179178, -129.646882>
			}
			triangle {
				< 119.232409, 51.607314, -134.169757>,
				< 114.255533, 55.531770, -98.583043>,
				< 124.772899, 52.969906, -94.995610>
			}
			triangle {
				< 114.255533, 55.531770, -98.583043>,
				< 117.777877, 51.868629, -57.173960>,
				< 124.772899, 52.969906, -94.995610>
			}
			triangle {
				< 114.255533, 55.531770, -98.583043>,
				< 107.144922, 54.391619, -59.747241>,
				< 117.777877, 51.868629, -57.173960>
			}
			triangle {
				< 107.144922, 54.391619, -59.747241>,
				< 108.976215, 45.950342, -18.883346>,
				< 117.777877, 51.868629, -57.173960>
			}
			triangle {
				< 107.144922, 54.391619, -59.747241>,
				< 98.120451, 48.264597, -20.441972>,
				< 108.976215, 45.950342, -18.883346>
			}
			triangle {
				< 98.120451, 48.264597, -20.441972>,
				< 99.045582, 35.618454, 17.217154>,
				< 108.976215, 45.950342, -18.883346>
			}
			triangle {
				< 98.120451, 48.264597, -20.441972>,
				< 87.880537, 37.568122, 16.598979>,
				< 99.045582, 35.618454, 17.217154>
			}
			triangle {
				< 87.880537, 37.568122, 16.598979>,
				< 89.039080, 21.576867, 48.725337>,
				< 99.045582, 35.618454, 17.217154>
			}
			triangle {
				< 87.880537, 37.568122, 16.598979>,
				< 77.523902, 23.031285, 48.911277>,
				< 89.039080, 21.576867, 48.725337>
			}
			triangle {
				< 77.523902, 23.031285, 48.911277>,
				< 80.205888, 4.782692, 73.655859>,
				< 89.039080, 21.576867, 48.725337>
			}
			triangle {
				< 77.523902, 23.031285, 48.911277>,
				< 68.359673, 5.644655, 74.464433>,
				< 80.205888, 4.782692, 73.655859>
			}
			triangle {
				< 68.359673, 5.644655, 74.464433>,
				< 73.753208, -13.619667, 90.527818>,
				< 80.205888, 4.782692, 73.655859>
			}
			triangle {
				< 68.359673, 5.644655, 74.464433>,
				< 61.655268, -13.406832, 91.750003>,
				< 73.753208, -13.619667, 90.527818>
			}
			triangle {
				< 61.655268, -13.406832, 91.750003>,
				< 70.608109, -32.376043, 98.391406>,
				< 73.753208, -13.619667, 90.527818>
			}
			triangle {
				< 61.655268, -13.406832, 91.750003>,
				< 58.385041, -32.824878, 99.804007>,
				< 70.608109, -32.376043, 98.391406>
			}
			triangle {
				< 58.385041, -32.824878, 99.804007>,
				< 71.233451, -50.208334, 96.819878>,
				< 70.608109, -32.376043, 98.391406>
			}
			triangle {
				< 58.385041, -32.824878, 99.804007>,
				< 59.035406, -51.286187, 98.194450>,
				< 71.233451, -50.208334, 96.819878>
			}
			triangle {
				< 59.035406, -51.286187, 98.194450>,
				< 75.535849, -65.901212, 85.897878>,
				< 71.233451, -50.208334, 96.819878>
			}
			triangle {
				< 59.035406, -51.286187, 98.194450>,
				< 63.508287, -67.532673, 87.007150>,
				< 75.535849, -65.901212, 85.897878>
			}
			triangle {
				< 63.508287, -67.532673, 87.007150>,
				< 82.884431, -78.385249, 66.224284>,
				< 75.535849, -65.901212, 85.897878>
			}
			triangle {
				< 63.508287, -67.532673, 87.007150>,
				< 71.140490, -80.457106, 66.848420>,
				< 82.884431, -78.385249, 66.224284>
			}
			triangle {
				< 71.140490, -80.457106, 66.848420>,
				< 92.236169, -86.809695, 38.925152>,
				< 82.884431, -78.385249, 66.224284>
			}
			triangle {
				< 71.140490, -80.457106, 66.848420>,
				< 80.836222, -89.178726, 38.862668>,
				< 92.236169, -86.809695, 38.925152>
			}
			triangle {
				< 80.836222, -89.178726, 38.862668>,
				< 102.343291, -90.600416, 5.653748>,
				< 92.236169, -86.809695, 38.925152>
			}
			triangle {
				< 80.836222, -89.178726, 38.862668>,
				< 91.285817, -93.103223, 4.736361>,
				< 102.343291, -90.600416, 5.653748>
			}
			triangle {
				< 91.285817, -93.103223, 4.736361>,
				< 111.997403, -89.499138, -31.453144>,
				< 102.343291, -90.600416, 5.653748>
			}
			triangle {
				< 91.285817, -93.103223, 4.736361>,
				< 101.224452, -91.963038, -33.343095>,
				< 111.997403, -89.499138, -31.453144>
			}
			triangle {
				< 101.224452, -91.963038, -33.343095>,
				< 120.254636, -83.580866, -69.887899>,
				< 111.997403, -89.499138, -31.453144>
			}
			triangle {
				< 101.224452, -91.963038, -33.343095>,
				< 109.669901, -85.836023, -72.800890>,
				< 120.254636, -83.580866, -69.887899>
			}
			triangle {
				< 109.669901, -85.836023, -72.800890>,
				< 126.584113, -73.248945, -106.952280>,
				< 120.254636, -83.580866, -69.887899>
			}
			triangle {
				< 109.669901, -85.836023, -72.800890>,
				< 116.079874, -75.139582, -110.861830>,
				< 126.584113, -73.248945, -106.952280>
			}
			triangle {
				< 116.079874, -75.139582, -110.861830>,
				< 130.902752, -59.207413, -139.983177>,
				< 126.584113, -73.248945, -106.952280>
			}
			triangle {
				< 116.079874, -75.139582, -110.861830>,
				< 120.387599, -60.602747, -144.785360>,
				< 130.902752, -59.207413, -139.983177>
			}
			triangle {
				< 120.387599, -60.602747, -144.785360>,
				< 133.489534, -42.413227, -166.585222>,
				< 130.902752, -59.207413, -139.983177>
			}
			triangle {
				< 120.387599, -60.602747, -144.785360>,
				< 122.909479, -43.216169, -172.107056>,
				< 133.489534, -42.413227, -166.585222>
			}
			triangle {
				< 122.909479, -43.216169, -172.107056>,
				< 134.810090, -24.010956, -184.829861>,
				< 133.489534, -42.413227, -166.585222>
			}
			triangle {
				< 122.909479, -43.216169, -172.107056>,
				< 124.156795, -24.164677, -190.844789>,
				< 134.810090, -24.010956, -184.829861>
			}
			triangle {
				< 124.156795, -24.164677, -190.844789>,
				< 135.307357, -5.254520, -193.402410>,
				< 134.810090, -24.010956, -184.829861>
			}
			triangle {
				< 124.156795, -24.164677, -190.844789>,
				< 124.611765, -4.746571, -199.648634>,
				< 135.307357, -5.254520, -193.402410>
			}
			triangle {
				< 124.611765, -4.746571, -199.648634>,
				< 135.223925, 12.577792, -191.688225>,
				< 135.307357, -5.254520, -193.402410>
			}
			triangle {
				< 124.611765, -4.746571, -199.648634>,
				< 124.537557, 13.714759, -197.888106>,
				< 135.223925, 12.577792, -191.688225>
			}
			triangle {
				< 135.223925, 12.577792, -191.688225>,
				< 143.615052, 23.373296, -164.495006>,
				< 144.442365, 9.303438, -175.210655>
			}
			triangle {
				< 135.223925, 12.577792, -191.688225>,
				< 134.508893, 28.270660, -179.809272>,
				< 143.615052, 23.373296, -164.495006>
			}
			triangle {
				< 134.508893, 28.270660, -179.809272>,
				< 141.817465, 34.566179, -145.380303>,
				< 143.615052, 23.373296, -164.495006>
			}
			triangle {
				< 134.508893, 28.270660, -179.809272>,
				< 132.836893, 40.754702, -158.618927>,
				< 141.817465, 34.566179, -145.380303>
			}
			triangle {
				< 132.836893, 40.754702, -158.618927>,
				< 138.697445, 42.119324, -119.244941>,
				< 141.817465, 34.566179, -145.380303>
			}
			triangle {
				< 132.836893, 40.754702, -158.618927>,
				< 129.734054, 49.179178, -129.646882>,
				< 138.697445, 42.119324, -119.244941>
			}
			triangle {
				< 129.734054, 49.179178, -129.646882>,
				< 133.951247, 45.518037, -87.977789>,
				< 138.697445, 42.119324, -119.244941>
			}
			triangle {
				< 129.734054, 49.179178, -129.646882>,
				< 124.772899, 52.969906, -94.995610>,
				< 133.951247, 45.518037, -87.977789>
			}
			triangle {
				< 124.772899, 52.969906, -94.995610>,
				< 127.486572, 44.530649, -53.828467>,
				< 133.951247, 45.518037, -87.977789>
			}
			triangle {
				< 124.772899, 52.969906, -94.995610>,
				< 117.777877, 51.868629, -57.173960>,
				< 127.486572, 44.530649, -53.828467>
			}
			triangle {
				< 117.777877, 51.868629, -57.173960>,
				< 119.540848, 39.224431, -19.220445>,
				< 127.486572, 44.530649, -53.828467>
			}
			triangle {
				< 117.777877, 51.868629, -57.173960>,
				< 108.976215, 45.950342, -18.883346>,
				< 119.540848, 39.224431, -19.220445>
			}
			triangle {
				< 108.976215, 45.950342, -18.883346>,
				< 110.716708, 29.961066, 13.452761>,
				< 119.540848, 39.224431, -19.220445>
			}
			triangle {
				< 108.976215, 45.950342, -18.883346>,
				< 99.045582, 35.618454, 17.217154>,
				< 110.716708, 29.961066, 13.452761>
			}
			triangle {
				< 99.045582, 35.618454, 17.217154>,
				< 101.918712, 17.371848, 42.015012>,
				< 110.716708, 29.961066, 13.452761>
			}
			triangle {
				< 99.045582, 35.618454, 17.217154>,
				< 89.039080, 21.576867, 48.725337>,
				< 101.918712, 17.371848, 42.015012>
			}
			triangle {
				< 89.039080, 21.576867, 48.725337>,
				< 94.205730, 2.314567, 64.650625>,
				< 101.918712, 17.371848, 42.015012>
			}
			triangle {
				< 89.039080, 21.576867, 48.725337>,
				< 80.205888, 4.782692, 73.655859>,
				< 94.205730, 2.314567, 64.650625>
			}
			triangle {
				< 80.205888, 4.782692, 73.655859>,
				< 88.595234, -14.184530, 79.990037>,
				< 94.205730, 2.314567, 64.650625>
			}
			triangle {
				< 80.205888, 4.782692, 73.655859>,
				< 73.753208, -13.619667, 90.527818>,
				< 88.595234, -14.184530, 79.990037>
			}
			triangle {
				< 73.753208, -13.619667, 90.527818>,
				< 85.866593, -31.001080, 87.145679>,
				< 88.595234, -14.184530, 79.990037>
			}
			triangle {
				< 73.753208, -13.619667, 90.527818>,
				< 70.608109, -32.376043, 98.391406>,
				< 85.866593, -31.001080, 87.145679>
			}
			triangle {
				< 70.608109, -32.376043, 98.391406>,
				< 86.408533, -46.989061, 85.715353>,
				< 85.866593, -31.001080, 87.145679>
			}
			triangle {
				< 70.608109, -32.376043, 98.391406>,
				< 71.233451, -50.208334, 96.819878>,
				< 86.408533, -46.989061, 85.715353>
			}
			triangle {
				< 71.233451, -50.208334, 96.819878>,
				< 90.142727, -61.058890, 75.779147>,
				< 86.408533, -46.989061, 85.715353>
			}
			triangle {
				< 71.233451, -50.208334, 96.819878>,
				< 75.535849, -65.901212, 85.897878>,
				< 90.142727, -61.058890, 75.779147>
			}
			triangle {
				< 75.535849, -65.901212, 85.897878>,
				< 96.539214, -72.251804, 57.899807>,
				< 90.142727, -61.058890, 75.779147>
			}
			triangle {
				< 75.535849, -65.901212, 85.897878>,
				< 82.884431, -78.385249, 66.224284>,
				< 96.539214, -72.251804, 57.899807>
			}
			triangle {
				< 82.884431, -78.385249, 66.224284>,
				< 104.720689, -79.804942, 33.126317>,
				< 96.539214, -72.251804, 57.899807>
			}
			triangle {
				< 82.884431, -78.385249, 66.224284>,
				< 92.236169, -86.809695, 38.925152>,
				< 104.720689, -79.804942, 33.126317>
			}
			triangle {
				< 92.236169, -86.809695, 38.925152>,
				< 113.634042, -83.203621, 2.981938>,
				< 104.720689, -79.804942, 33.126317>
			}
			triangle {
				< 92.236169, -86.809695, 38.925152>,
				< 102.343291, -90.600416, 5.653748>,
				< 113.634042, -83.203621, 2.981938>
			}
			triangle {
				< 102.343291, -90.600416, 5.653748>,
				< 122.251727, -82.216233, -30.586045>,
				< 113.634042, -83.203621, 2.981938>
			}
			triangle {
				< 102.343291, -90.600416, 5.653748>,
				< 111.997403, -89.499138, -31.453144>,
				< 122.251727, -82.216233, -30.586045>
			}
			triangle {
				< 111.997403, -89.499138, -31.453144>,
				< 129.756659, -76.910064, -65.311186>,
				< 122.251727, -82.216233, -30.586045>
			}
			triangle {
				< 111.997403, -89.499138, -31.453144>,
				< 120.254636, -83.580866, -69.887899>,
				< 129.756659, -76.910064, -65.311186>
			}
			triangle {
				< 120.254636, -83.580866, -69.887899>,
				< 135.664940, -67.646690, -98.768555>,
				< 129.756659, -76.910064, -65.311186>
			}
			triangle {
				< 120.254636, -83.580866, -69.887899>,
				< 126.584113, -73.248945, -106.952280>,
				< 135.664940, -67.646690, -98.768555>
			}
			triangle {
				< 126.584113, -73.248945, -106.952280>,
				< 139.856607, -55.057410, -128.570020>,
				< 135.664940, -67.646690, -98.768555>
			}
			triangle {
				< 126.584113, -73.248945, -106.952280>,
				< 130.902752, -59.207413, -139.983177>,
				< 139.856607, -55.057410, -128.570020>
			}
			triangle {
				< 130.902752, -59.207413, -139.983177>,
				< 142.509788, -40.000170, -152.566493>,
				< 139.856607, -55.057410, -128.570020>
			}
			triangle {
				< 130.902752, -59.207413, -139.983177>,
				< 133.489534, -42.413227, -166.585222>,
				< 142.509788, -40.000170, -152.566493>
			}
			triangle {
				< 133.489534, -42.413227, -166.585222>,
				< 143.962145, -23.501098, -169.024050>,
				< 142.509788, -40.000170, -152.566493>
			}
			triangle {
				< 133.489534, -42.413227, -166.585222>,
				< 134.810090, -24.010956, -184.829861>,
				< 143.962145, -23.501098, -169.024050>
			}
			triangle {
				< 134.810090, -24.010956, -184.829861>,
				< 144.545197, -6.684575, -176.757351>,
				< 143.962145, -23.501098, -169.024050>
			}
			triangle {
				< 134.810090, -24.010956, -184.829861>,
				< 135.307357, -5.254520, -193.402410>,
				< 144.545197, -6.684575, -176.757351>
			}
			triangle {
				< 135.307357, -5.254520, -193.402410>,
				< 144.442365, 9.303438, -175.210655>,
				< 144.545197, -6.684575, -176.757351>
			}
			triangle {
				< 135.307357, -5.254520, -193.402410>,
				< 135.223925, 12.577792, -191.688225>,
				< 144.442365, 9.303438, -175.210655>
			}
			triangle {
				< 144.442365, 9.303438, -175.210655>,
				< 150.139511, 15.602870, -140.676603>,
				< 151.051804, 4.114863, -149.454907>
			}
			triangle {
				< 144.442365, 9.303438, -175.210655>,
				< 143.615052, 23.373296, -164.495006>,
				< 150.139511, 15.602870, -140.676603>
			}
			triangle {
				< 143.615052, 23.373296, -164.495006>,
				< 148.295209, 24.741784, -125.017002>,
				< 150.139511, 15.602870, -140.676603>
			}
			triangle {
				< 143.615052, 23.373296, -164.495006>,
				< 141.817465, 34.566179, -145.380303>,
				< 148.295209, 24.741784, -125.017002>
			}
			triangle {
				< 141.817465, 34.566179, -145.380303>,
				< 145.327449, 30.908972, -103.600621>,
				< 148.295209, 24.741784, -125.017002>
			}
			triangle {
				< 141.817465, 34.566179, -145.380303>,
				< 138.697445, 42.119324, -119.244941>,
				< 145.327449, 30.908972, -103.600621>
			}
			triangle {
				< 138.697445, 42.119324, -119.244941>,
				< 141.093254, 33.683982, -77.963017>,
				< 145.327449, 30.908972, -103.600621>
			}
			triangle {
				< 138.697445, 42.119324, -119.244941>,
				< 133.951247, 45.518037, -87.977789>,
				< 141.093254, 33.683982, -77.963017>
			}
			triangle {
				< 133.951247, 45.518037, -87.977789>,
				< 135.602370, 32.877773, -49.930327>,
				< 141.093254, 33.683982, -77.963017>
			}
			triangle {
				< 133.951247, 45.518037, -87.977789>,
				< 127.486572, 44.530649, -53.828467>,
				< 135.602370, 32.877773, -49.930327>
			}
			triangle {
				< 127.486572, 44.530649, -53.828467>,
				< 129.091427, 28.545285, -21.473231>,
				< 135.602370, 32.877773, -49.930327>
			}
			triangle {
				< 127.486572, 44.530649, -53.828467>,
				< 119.540848, 39.224431, -19.220445>,
				< 129.091427, 28.545285, -21.473231>
			}
			triangle {
				< 119.540848, 39.224431, -19.220445>,
				< 122.043014, 20.981759, 5.451389>,
				< 129.091427, 28.545285, -21.473231>
			}
			triangle {
				< 119.540848, 39.224431, -19.220445>,
				< 110.716708, 29.961066, 13.452761>,
				< 122.043014, 20.981759, 5.451389>
			}
			triangle {
				< 110.716708, 29.961066, 13.452761>,
				< 115.139380, 10.702665, 29.045941>,
				< 122.043014, 20.981759, 5.451389>
			}
			triangle {
				< 110.716708, 29.961066, 13.452761>,
				< 101.918712, 17.371848, 42.015012>,
				< 115.139380, 10.702665, 29.045941>
			}
			triangle {
				< 101.918712, 17.371848, 42.015012>,
				< 109.159075, -1.591544, 47.789667>,
				< 115.139380, 10.702665, 29.045941>
			}
			triangle {
				< 101.918712, 17.371848, 42.015012>,
				< 94.205730, 2.314567, 64.650625>,
				< 109.159075, -1.591544, 47.789667>
			}
			triangle {
				< 94.205730, 2.314567, 64.650625>,
				< 104.841538, -15.062994, 60.517453>,
				< 109.159075, -1.591544, 47.789667>
			}
			triangle {
				< 94.205730, 2.314567, 64.650625>,
				< 88.595234, -14.184530, 79.990037>,
				< 104.841538, -15.062994, 60.517453>
			}
			triangle {
				< 88.595234, -14.184530, 79.990037>,
				< 102.749914, -28.793614, 66.462375>,
				< 104.841538, -15.062994, 60.517453>
			}
			triangle {
				< 88.595234, -14.184530, 79.990037>,
				< 85.866593, -31.001080, 87.145679>,
				< 102.749914, -28.793614, 66.462375>
			}
			triangle {
				< 85.866593, -31.001080, 87.145679>,
				< 103.164487, -41.847743, 65.273769>,
				< 102.749914, -28.793614, 66.462375>
			}
			triangle {
				< 85.866593, -31.001080, 87.145679>,
				< 86.408533, -46.989061, 85.715353>,
				< 103.164487, -41.847743, 65.273769>
			}
			triangle {
				< 86.408533, -46.989061, 85.715353>,
				< 106.028840, -53.335730, 57.021588>,
				< 103.164487, -41.847743, 65.273769>
			}
			triangle {
				< 86.408533, -46.989061, 85.715353>,
				< 90.142727, -61.058890, 75.779147>,
				< 106.028840, -53.335730, 57.021588>
			}
			triangle {
				< 90.142727, -61.058890, 75.779147>,
				< 110.960819, -62.474687, 42.195465>,
				< 106.028840, -53.335730, 57.021588>
			}
			triangle {
				< 90.142727, -61.058890, 75.779147>,
				< 96.539214, -72.251804, 57.899807>,
				< 110.960819, -62.474687, 42.195465>
			}
			triangle {
				< 96.539214, -72.251804, 57.899807>,
				< 117.325746, -68.641819, 21.697175>,
				< 110.960819, -62.474687, 42.195465>
			}
			triangle {
				< 96.539214, -72.251804, 57.899807>,
				< 104.720689, -79.804942, 33.126317>,
				< 117.325746, -68.641819, 21.697175>
			}
			triangle {
				< 104.720689, -79.804942, 33.126317>,
				< 124.355942, -71.416840, -3.184017>,
				< 117.325746, -68.641819, 21.697175>
			}
			triangle {
				< 104.720689, -79.804942, 33.126317>,
				< 113.634042, -83.203621, 2.981938>,
				< 124.355942, -71.416840, -3.184017>
			}
			triangle {
				< 113.634042, -83.203621, 2.981938>,
				< 131.291106, -70.610635, -30.825010>,
				< 124.355942, -71.416840, -3.184017>
			}
			triangle {
				< 113.634042, -83.203621, 2.981938>,
				< 122.251727, -82.216233, -30.586045>,
				< 131.291106, -70.610635, -30.825010>
			}
			triangle {
				< 122.251727, -82.216233, -30.586045>,
				< 137.506366, -66.278167, -59.361029>,
				< 131.291106, -70.610635, -30.825010>
			}
			triangle {
				< 122.251727, -82.216233, -30.586045>,
				< 129.756659, -76.910064, -65.311186>,
				< 137.506366, -66.278167, -59.361029>
			}
			triangle {
				< 129.756659, -76.910064, -65.311186>,
				< 142.598584, -58.714662, -86.813830>,
				< 137.506366, -66.278167, -59.361029>
			}
			triangle {
				< 129.756659, -76.910064, -65.311186>,
				< 135.664940, -67.646690, -98.768555>,
				< 142.598584, -58.714662, -86.813830>
			}
			triangle {
				< 135.664940, -67.646690, -98.768555>,
				< 146.411285, -48.435558, -111.243531>,
				< 142.598584, -58.714662, -86.813830>
			}
			triangle {
				< 135.664940, -67.646690, -98.768555>,
				< 139.856607, -55.057410, -128.570020>,
				< 146.411285, -48.435558, -111.243531>
			}
			triangle {
				< 139.856607, -55.057410, -128.570020>,
				< 148.995221, -36.141347, -130.904883>,
				< 146.411285, -48.435558, -111.243531>
			}
			triangle {
				< 139.856607, -55.057410, -128.570020>,
				< 142.509788, -40.000170, -152.566493>,
				< 148.995221, -36.141347, -130.904883>
			}
			triangle {
				< 142.509788, -40.000170, -152.566493>,
				< 150.520757, -22.669917, -144.387230>,
				< 148.995221, -36.141347, -130.904883>
			}
			triangle {
				< 142.509788, -40.000170, -152.566493>,
				< 143.962145, -23.501098, -169.024050>,
				< 150.520757, -22.669917, -144.387230>
			}
			triangle {
				< 143.962145, -23.501098, -169.024050>,
				< 151.171431, -8.939254, -150.722012>,
				< 150.520757, -22.669917, -144.387230>
			}
			triangle {
				< 143.962145, -23.501098, -169.024050>,
				< 144.545197, -6.684575, -176.757351>,
				< 151.171431, -8.939254, -150.722012>
			}
			triangle {
				< 144.545197, -6.684575, -176.757351>,
				< 151.051804, 4.114863, -149.454907>,
				< 151.171431, -8.939254, -150.722012>
			}
			triangle {
				< 144.545197, -6.684575, -176.757351>,
				< 144.442365, 9.303438, -175.210655>,
				< 151.051804, 4.114863, -149.454907>
			}
			triangle {
				< 151.051804, 4.114863, -149.454907>,
				< 153.062060, 5.488900, -110.017858>,
				< 153.922364, -2.634314, -116.222508>
			}
			triangle {
				< 151.051804, 4.114863, -149.454907>,
				< 150.139511, 15.602870, -140.676603>,
				< 153.062060, 5.488900, -110.017858>
			}
			triangle {
				< 150.139511, 15.602870, -140.676603>,
				< 151.416615, 11.951127, -98.946393>,
				< 153.062060, 5.488900, -110.017858>
			}
			triangle {
				< 150.139511, 15.602870, -140.676603>,
				< 148.295209, 24.741784, -125.017002>,
				< 151.416615, 11.951127, -98.946393>
			}
			triangle {
				< 148.295209, 24.741784, -125.017002>,
				< 148.939997, 16.311936, -83.795205>,
				< 151.416615, 11.951127, -98.946393>
			}
			triangle {
				< 148.295209, 24.741784, -125.017002>,
				< 145.327449, 30.908972, -103.600621>,
				< 148.939997, 16.311936, -83.795205>
			}
			triangle {
				< 145.327449, 30.908972, -103.600621>,
				< 145.628273, 18.274205, -65.637484>,
				< 148.939997, 16.311936, -83.795205>
			}
			triangle {
				< 145.327449, 30.908972, -103.600621>,
				< 141.093254, 33.683982, -77.963017>,
				< 145.628273, 18.274205, -65.637484>
			}
			triangle {
				< 141.093254, 33.683982, -77.963017>,
				< 141.567007, 17.704103, -45.750283>,
				< 145.628273, 18.274205, -65.637484>
			}
			triangle {
				< 141.093254, 33.683982, -77.963017>,
				< 135.602370, 32.877773, -49.930327>,
				< 141.567007, 17.704103, -45.750283>
			}
			triangle {
				< 135.602370, 32.877773, -49.930327>,
				< 136.962935, 14.640598, -25.515635>,
				< 141.567007, 17.704103, -45.750283>
			}
			triangle {
				< 135.602370, 32.877773, -49.930327>,
				< 129.091427, 28.545285, -21.473231>,
				< 136.962935, 14.640598, -25.515635>
			}
			triangle {
				< 129.091427, 28.545285, -21.473231>,
				< 132.148057, 9.292361, -6.317937>,
				< 136.962935, 14.640598, -25.515635>
			}
			triangle {
				< 129.091427, 28.545285, -21.473231>,
				< 122.043014, 20.981759, 5.451389>,
				< 132.148057, 9.292361, -6.317937>
			}
			triangle {
				< 122.043014, 20.981759, 5.451389>,
				< 127.550825, 2.023926, 10.555776>,
				< 132.148057, 9.292361, -6.317937>
			}
			triangle {
				< 122.043014, 20.981759, 5.451389>,
				< 115.139380, 10.702665, 29.045941>,
				< 127.550825, 2.023926, 10.555776>
			}
			triangle {
				< 115.139380, 10.702665, 29.045941>,
				< 123.639479, -6.669389, 23.998780>,
				< 127.550825, 2.023926, 10.555776>
			}
			triangle {
				< 115.139380, 10.702665, 29.045941>,
				< 109.159075, -1.591544, 47.789667>,
				< 123.639479, -6.669389, 23.998780>
			}
			triangle {
				< 109.159075, -1.591544, 47.789667>,
				< 120.848462, -16.195100, 33.148635>,
				< 123.639479, -6.669389, 23.998780>
			}
			triangle {
				< 109.159075, -1.591544, 47.789667>,
				< 104.841538, -15.062994, 60.517453>,
				< 120.848462, -16.195100, 33.148635>
			}
			triangle {
				< 104.841538, -15.062994, 60.517453>,
				< 119.504787, -25.904167, 37.428845>,
				< 120.848462, -16.195100, 33.148635>
			}
			triangle {
				< 104.841538, -15.062994, 60.517453>,
				< 102.749914, -28.793614, 66.462375>,
				< 119.504787, -25.904167, 37.428845>
			}
			triangle {
				< 102.749914, -28.793614, 66.462375>,
				< 119.770221, -35.134807, 36.572926>,
				< 119.504787, -25.904167, 37.428845>
			}
			triangle {
				< 102.749914, -28.793614, 66.462375>,
				< 103.164487, -41.847743, 65.273769>,
				< 119.770221, -35.134807, 36.572926>
			}
			triangle {
				< 103.164487, -41.847743, 65.273769>,
				< 121.612318, -43.258041, 30.634072>,
				< 119.770221, -35.134807, 36.572926>
			}
			triangle {
				< 103.164487, -41.847743, 65.273769>,
				< 106.028840, -53.335730, 57.021588>,
				< 121.612318, -43.258041, 30.634072>
			}
			triangle {
				< 106.028840, -53.335730, 57.021588>,
				< 124.810308, -49.720269, 19.983187>,
				< 121.612318, -43.258041, 30.634072>
			}
			triangle {
				< 106.028840, -53.335730, 57.021588>,
				< 110.960819, -62.474687, 42.195465>,
				< 124.810308, -49.720269, 19.983187>
			}
			triangle {
				< 110.960819, -62.474687, 42.195465>,
				< 128.994554, -54.081101, 5.295137>,
				< 124.810308, -49.720269, 19.983187>
			}
			triangle {
				< 110.960819, -62.474687, 42.195465>,
				< 117.325746, -68.641819, 21.697175>,
				< 128.994554, -54.081101, 5.295137>
			}
			triangle {
				< 117.325746, -68.641819, 21.697175>,
				< 133.711293, -56.043327, -12.481014>,
				< 128.994554, -54.081101, 5.295137>
			}
			triangle {
				< 117.325746, -68.641819, 21.697175>,
				< 124.355942, -71.416840, -3.184017>,
				< 133.711293, -56.043327, -12.481014>
			}
			triangle {
				< 124.355942, -71.416840, -3.184017>,
				< 138.498202, -55.473268, -32.171030>,
				< 133.711293, -56.043327, -12.481014>
			}
			triangle {
				< 124.355942, -71.416840, -3.184017>,
				< 131.291106, -70.610635, -30.825010>,
				< 138.498202, -55.473268, -32.171030>
			}
			triangle {
				< 131.291106, -70.610635, -30.825010>,
				< 142.953664, -52.409738, -52.445367>,
				< 138.498202, -55.473268, -32.171030>
			}
			triangle {
				< 131.291106, -70.610635, -30.825010>,
				< 137.506366, -66.278167, -59.361029>,
				< 142.953664, -52.409738, -52.445367>
			}
			triangle {
				< 137.506366, -66.278167, -59.361029>,
				< 146.785736, -47.061507, -71.909338>,
				< 142.953664, -52.409738, -52.445367>
			}
			triangle {
				< 137.506366, -66.278167, -59.361029>,
				< 142.598584, -58.714662, -86.813830>,
				< 146.785736, -47.061507, -71.909338>
			}
			triangle {
				< 142.598584, -58.714662, -86.813830>,
				< 149.829581, -39.793115, -89.204162>,
				< 146.785736, -47.061507, -71.909338>
			}
			triangle {
				< 142.598584, -58.714662, -86.813830>,
				< 146.411285, -48.435558, -111.243531>,
				< 149.829581, -39.793115, -89.204162>
			}
			triangle {
				< 146.411285, -48.435558, -111.243531>,
				< 152.033493, -31.099817, -103.110276>,
				< 149.829581, -39.793115, -89.204162>
			}
			triangle {
				< 146.411285, -48.435558, -111.243531>,
				< 148.995221, -36.141347, -130.904883>,
				< 152.033493, -31.099817, -103.110276>
			}
			triangle {
				< 148.995221, -36.141347, -130.904883>,
				< 153.420508, -21.574071, -112.640955>,
				< 152.033493, -31.099817, -103.110276>
			}
			triangle {
				< 148.995221, -36.141347, -130.904883>,
				< 150.520757, -22.669917, -144.387230>,
				< 153.420508, -21.574071, -112.640955>
			}
			triangle {
				< 150.520757, -22.669917, -144.387230>,
				< 154.039443, -11.864997, -117.118157>,
				< 153.420508, -21.574071, -112.640955>
			}
			triangle {
				< 150.520757, -22.669917, -144.387230>,
				< 151.171431, -8.939254, -150.722012>,
				< 154.039443, -11.864997, -117.118157>
			}
			triangle {
				< 151.171431, -8.939254, -150.722012>,
				< 153.922364, -2.634314, -116.222508>,
				< 154.039443, -11.864997, -117.118157>
			}
			triangle {
				< 151.171431, -8.939254, -150.722012>,
				< 151.051804, 4.114863, -149.454907>,
				< 153.922364, -2.634314, -116.222508>
			}
			triangle {
				< 153.922364, -2.634314, -116.222508>,
				< 151.633322, -6.279308, -74.808367>,
				< 152.206331, -10.484237, -78.004666>
			}
			triangle {
				< 153.922364, -2.634314, -116.222508>,
				< 153.062060, 5.488900, -110.017858>,
				< 151.633322, -6.279308, -74.808367>
			}
			triangle {
				< 153.062060, 5.488900, -110.017858>,
				< 150.579512, -2.934230, -69.100864>,
				< 151.633322, -6.279308, -74.808367>
			}
			triangle {
				< 153.062060, 5.488900, -110.017858>,
				< 151.416615, 11.951127, -98.946393>,
				< 150.579512, -2.934230, -69.100864>
			}
			triangle {
				< 151.416615, 11.951127, -98.946393>,
				< 149.074480, -0.676911, -61.281309>,
				< 150.579512, -2.934230, -69.100864>
			}
			triangle {
				< 151.416615, 11.951127, -98.946393>,
				< 148.939997, 16.311936, -83.795205>,
				< 149.074480, -0.676911, -61.281309>
			}
			triangle {
				< 148.939997, 16.311936, -83.795205>,
				< 147.174716, 0.338820, -51.894251>,
				< 149.074480, -0.676911, -61.281309>
			}
			triangle {
				< 148.939997, 16.311936, -83.795205>,
				< 145.628273, 18.274205, -65.637484>,
				< 147.174716, 0.338820, -51.894251>
			}
			triangle {
				< 145.628273, 18.274205, -65.637484>,
				< 144.971997, 0.043749, -41.589890>,
				< 147.174716, 0.338820, -51.894251>
			}
			triangle {
				< 145.628273, 18.274205, -65.637484>,
				< 141.567007, 17.704103, -45.750283>,
				< 144.971997, 0.043749, -41.589890>
			}
			triangle {
				< 141.567007, 17.704103, -45.750283>,
				< 142.597318, -1.542062, -31.076727>,
				< 144.971997, 0.043749, -41.589890>
			}
			triangle {
				< 141.567007, 17.704103, -45.750283>,
				< 136.962935, 14.640598, -25.515635>,
				< 142.597318, -1.542062, -31.076727>
			}
			triangle {
				< 136.962935, 14.640598, -25.515635>,
				< 140.216947, -4.310497, -21.071389>,
				< 142.597318, -1.542062, -31.076727>
			}
			triangle {
				< 136.962935, 14.640598, -25.515635>,
				< 132.148057, 9.292361, -6.317937>,
				< 140.216947, -4.310497, -21.071389>
			}
			triangle {
				< 132.148057, 9.292361, -6.317937>,
				< 138.019755, -8.072923, -12.249441>,
				< 140.216947, -4.310497, -21.071389>
			}
			triangle {
				< 132.148057, 9.292361, -6.317937>,
				< 127.550825, 2.023926, 10.555776>,
				< 138.019755, -8.072923, -12.249441>
			}
			triangle {
				< 127.550825, 2.023926, 10.555776>,
				< 136.197120, -12.572902, -5.200406>,
				< 138.019755, -8.072923, -12.249441>
			}
			triangle {
				< 127.550825, 2.023926, 10.555776>,
				< 123.639479, -6.669389, 23.998780>,
				< 136.197120, -12.572902, -5.200406>
			}
			triangle {
				< 123.639479, -6.669389, 23.998780>,
				< 134.918869, -17.503811, -0.391359>,
				< 136.197120, -12.572902, -5.200406>
			}
			triangle {
				< 123.639479, -6.669389, 23.998780>,
				< 120.848462, -16.195100, 33.148635>,
				< 134.918869, -17.503811, -0.391359>
			}
			triangle {
				< 120.848462, -16.195100, 33.148635>,
				< 134.309277, -22.529565, 1.861612>,
				< 134.918869, -17.503811, -0.391359>
			}
			triangle {
				< 120.848462, -16.195100, 33.148635>,
				< 119.504787, -25.904167, 37.428845>,
				< 134.309277, -22.529565, 1.861612>
			}
			triangle {
				< 119.504787, -25.904167, 37.428845>,
				< 134.429097, -27.307743, 1.410993>,
				< 134.309277, -22.529565, 1.861612>
			}
			triangle {
				< 119.504787, -25.904167, 37.428845>,
				< 119.770221, -35.134807, 36.572926>,
				< 134.429097, -27.307743, 1.410993>
			}
			triangle {
				< 119.770221, -35.134807, 36.572926>,
				< 135.266185, -31.512611, -1.713713>,
				< 134.429097, -27.307743, 1.410993>
			}
			triangle {
				< 119.770221, -35.134807, 36.572926>,
				< 121.612318, -43.258041, 30.634072>,
				< 135.266185, -31.512611, -1.713713>
			}
			triangle {
				< 121.612318, -43.258041, 30.634072>,
				< 136.737540, -34.857728, -7.307746>,
				< 135.266185, -31.512611, -1.713713>
			}
			triangle {
				< 121.612318, -43.258041, 30.634072>,
				< 124.810308, -49.720269, 19.983187>,
				< 136.737540, -34.857728, -7.307746>
			}
			triangle {
				< 124.810308, -49.720269, 19.983187>,
				< 138.701677, -37.115049, -15.002473>,
				< 136.737540, -34.857728, -7.307746>
			}
			triangle {
				< 124.810308, -49.720269, 19.983187>,
				< 128.994554, -54.081101, 5.295137>,
				< 138.701677, -37.115049, -15.002473>
			}
			triangle {
				< 128.994554, -54.081101, 5.295137>,
				< 140.979096, -38.130779, -24.286738>,
				< 138.701677, -37.115049, -15.002473>
			}
			triangle {
				< 128.994554, -54.081101, 5.295137>,
				< 133.711293, -56.043327, -12.481014>,
				< 140.979096, -38.130779, -24.286738>
			}
			triangle {
				< 133.711293, -56.043327, -12.481014>,
				< 143.376857, -37.835710, -34.538016>,
				< 140.979096, -38.130779, -24.286738>
			}
			triangle {
				< 133.711293, -56.043327, -12.481014>,
				< 138.498202, -55.473268, -32.171030>,
				< 143.376857, -37.835710, -34.538016>
			}
			triangle {
				< 138.498202, -55.473268, -32.171030>,
				< 145.711616, -36.249895, -45.061924>,
				< 143.376857, -37.835710, -34.538016>
			}
			triangle {
				< 138.498202, -55.473268, -32.171030>,
				< 142.953664, -52.409738, -52.445367>,
				< 145.711616, -36.249895, -45.061924>
			}
			triangle {
				< 142.953664, -52.409738, -52.445367>,
				< 147.827849, -33.481482, -55.138897>,
				< 145.711616, -36.249895, -45.061924>
			}
			triangle {
				< 142.953664, -52.409738, -52.445367>,
				< 146.785736, -47.061507, -71.909338>,
				< 147.827849, -33.481482, -55.138897>
			}
			triangle {
				< 146.785736, -47.061507, -71.909338>,
				< 149.607494, -29.719036, -64.074382>,
				< 147.827849, -33.481482, -55.138897>
			}
			triangle {
				< 146.785736, -47.061507, -71.909338>,
				< 149.829581, -39.793115, -89.204162>,
				< 149.607494, -29.719036, -64.074382>
			}
			triangle {
				< 149.829581, -39.793115, -89.204162>,
				< 150.970981, -25.219055, -71.248218>,
				< 149.607494, -29.719036, -64.074382>
			}
			triangle {
				< 149.829581, -39.793115, -89.204162>,
				< 152.033493, -31.099817, -103.110276>,
				< 150.970981, -25.219055, -71.248218>
			}
			triangle {
				< 152.033493, -31.099817, -103.110276>,
				< 151.871622, -20.288145, -76.159917>,
				< 150.970981, -25.219055, -71.248218>
			}
			triangle {
				< 152.033493, -31.099817, -103.110276>,
				< 153.420508, -21.574071, -112.640955>,
				< 151.871622, -20.288145, -76.159917>
			}
			triangle {
				< 153.420508, -21.574071, -112.640955>,
				< 152.286246, -15.262392, -78.465872>,
				< 151.871622, -20.288145, -76.159917>
			}
			triangle {
				< 153.420508, -21.574071, -112.640955>,
				< 154.039443, -11.864997, -117.118157>,
				< 152.286246, -15.262392, -78.465872>
			}
			triangle {
				< 154.039443, -11.864997, -117.118157>,
				< 152.206331, -10.484237, -78.004666>,
				< 152.286246, -15.262392, -78.465872>
			}
			triangle {
				< 154.039443, -11.864997, -117.118157>,
				< 153.922364, -2.634314, -116.222508>,
				< 152.206331, -10.484237, -78.004666>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 151.871622, -20.288145, -76.159917>,
				< 152.286246, -15.262392, -78.465872>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 150.970981, -25.219055, -71.248218>,
				< 151.871622, -20.288145, -76.159917>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 149.607494, -29.719036, -64.074382>,
				< 150.970981, -25.219055, -71.248218>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 147.827849, -33.481482, -55.138897>,
				< 149.607494, -29.719036, -64.074382>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 145.711616, -36.249895, -45.061924>,
				< 147.827849, -33.481482, -55.138897>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 143.376857, -37.835710, -34.538016>,
				< 145.711616, -36.249895, -45.061924>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 140.979096, -38.130779, -24.286738>,
				< 143.376857, -37.835710, -34.538016>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 138.701677, -37.115049, -15.002473>,
				< 140.979096, -38.130779, -24.286738>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 136.737540, -34.857728, -7.307746>,
				< 138.701677, -37.115049, -15.002473>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 135.266185, -31.512611, -1.713713>,
				< 136.737540, -34.857728, -7.307746>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 134.429097, -27.307743, 1.410993>,
				< 135.266185, -31.512611, -1.713713>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 134.309277, -22.529565, 1.861612>,
				< 134.429097, -27.307743, 1.410993>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 134.918869, -17.503811, -0.391359>,
				< 134.309277, -22.529565, 1.861612>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 136.197120, -12.572902, -5.200406>,
				< 134.918869, -17.503811, -0.391359>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 138.019755, -8.072923, -12.249441>,
				< 136.197120, -12.572902, -5.200406>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 140.216947, -4.310497, -21.071389>,
				< 138.019755, -8.072923, -12.249441>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 142.597318, -1.542062, -31.076727>,
				< 140.216947, -4.310497, -21.071389>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 144.971997, 0.043749, -41.589890>,
				< 142.597318, -1.542062, -31.076727>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 147.174716, 0.338820, -51.894251>,
				< 144.971997, 0.043749, -41.589890>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 149.074480, -0.676911, -61.281309>,
				< 147.174716, 0.338820, -51.894251>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 150.579512, -2.934230, -69.100864>,
				< 149.074480, -0.676911, -61.281309>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 151.633322, -6.279308, -74.808367>,
				< 150.579512, -2.934230, -69.100864>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 152.206331, -10.484237, -78.004666>,
				< 151.633322, -6.279308, -74.808367>
			}
			triangle {
				< 145.587459, -18.899851, -37.757128>,
				< 152.286246, -15.262392, -78.465872>,
				< 152.206331, -10.484237, -78.004666>
			}
			
		}
		// _Thigh02
		union {
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 11.008939, -8.403812, -45.908671>,
				< 11.536059, -4.204017, -49.849730>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 10.901817, -12.852487, -44.020955>,
				< 11.008939, -8.403812, -45.908671>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 11.221981, -17.246939, -44.315238>,
				< 10.901817, -12.852487, -44.020955>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 11.947589, -21.287708, -46.771273>,
				< 11.221981, -17.246939, -44.315238>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 13.029240, -24.699429, -51.221874>,
				< 11.947589, -21.287708, -46.771273>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 14.393168, -27.249543, -57.363980>,
				< 13.029240, -24.699429, -51.221874>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 15.946431, -28.764257, -64.778440>,
				< 14.393168, -27.249543, -57.363980>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 17.583236, -29.140381, -72.960310>,
				< 15.946431, -28.764257, -64.778440>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 19.191965, -28.352331, -81.351861>,
				< 17.583236, -29.140381, -72.960310>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 20.663036, -26.453750, -89.381427>,
				< 19.191965, -28.352331, -81.351861>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 21.896178, -23.573970, -96.501730>,
				< 20.663036, -26.453750, -89.381427>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 22.807313, -19.909387, -102.227464>,
				< 21.896178, -23.573970, -96.501730>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 23.334431, -15.709590, -106.168479>,
				< 22.807313, -19.909387, -102.227464>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 23.441596, -11.260920, -108.056128>,
				< 23.334431, -15.709590, -106.168479>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 23.121411, -6.866406, -107.762009>,
				< 23.441596, -11.260920, -108.056128>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 22.395823, -2.825659, -105.305873>,
				< 23.121411, -6.866406, -107.762009>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 21.314193, 0.586024, -100.855328>,
				< 22.395823, -2.825659, -105.305873>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 19.950245, 3.136095, -94.713457>,
				< 21.314193, 0.586024, -100.855328>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 18.396959, 4.650850, -87.299041>,
				< 19.950245, 3.136095, -94.713457>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 16.760176, 5.026997, -79.117216>,
				< 18.396959, 4.650850, -87.299041>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 15.151425, 4.238926, -70.725575>,
				< 16.760176, 5.026997, -79.117216>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 13.680375, 2.340327, -62.696129>,
				< 15.151425, 4.238926, -70.725575>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 12.447214, -0.539334, -55.575788>,
				< 13.680375, 2.340327, -62.696129>
			}
			triangle {
				< 15.973657, -12.143836, -76.112591>,
				< 11.536059, -4.204017, -49.849730>,
				< 12.447214, -0.539334, -55.575788>
			}
			triangle {
				< 11.536059, -4.204017, -49.849730>,
				< 8.778618, -4.744346, -17.615648>,
				< 9.796894, 3.368987, -25.228988>
			}
			triangle {
				< 11.536059, -4.204017, -49.849730>,
				< 11.008939, -8.403812, -45.908671>,
				< 8.778618, -4.744346, -17.615648>
			}
			triangle {
				< 11.008939, -8.403812, -45.908671>,
				< 8.571662, -13.338551, -13.968792>,
				< 8.778618, -4.744346, -17.615648>
			}
			triangle {
				< 11.008939, -8.403812, -45.908671>,
				< 10.901817, -12.852487, -44.020955>,
				< 8.571662, -13.338551, -13.968792>
			}
			triangle {
				< 10.901817, -12.852487, -44.020955>,
				< 9.190148, -21.828035, -14.537133>,
				< 8.571662, -13.338551, -13.968792>
			}
			triangle {
				< 10.901817, -12.852487, -44.020955>,
				< 11.221981, -17.246939, -44.315238>,
				< 9.190148, -21.828035, -14.537133>
			}
			triangle {
				< 11.221981, -17.246939, -44.315238>,
				< 10.591922, -29.634168, -19.281957>,
				< 9.190148, -21.828035, -14.537133>
			}
			triangle {
				< 11.221981, -17.246939, -44.315238>,
				< 11.947589, -21.287708, -46.771273>,
				< 10.591922, -29.634168, -19.281957>
			}
			triangle {
				< 11.947589, -21.287708, -46.771273>,
				< 12.681478, -36.225010, -27.879825>,
				< 10.591922, -29.634168, -19.281957>
			}
			triangle {
				< 11.947589, -21.287708, -46.771273>,
				< 13.029240, -24.699429, -51.221874>,
				< 12.681478, -36.225010, -27.879825>
			}
			triangle {
				< 13.029240, -24.699429, -51.221874>,
				< 15.316414, -41.151494, -39.744928>,
				< 12.681478, -36.225010, -27.879825>
			}
			triangle {
				< 13.029240, -24.699429, -51.221874>,
				< 14.393168, -27.249543, -57.363980>,
				< 15.316414, -41.151494, -39.744928>
			}
			triangle {
				< 14.393168, -27.249543, -57.363980>,
				< 18.317103, -44.077694, -54.068528>,
				< 15.316414, -41.151494, -39.744928>
			}
			triangle {
				< 14.393168, -27.249543, -57.363980>,
				< 15.946431, -28.764257, -64.778440>,
				< 18.317103, -44.077694, -54.068528>
			}
			triangle {
				< 15.946431, -28.764257, -64.778440>,
				< 21.479160, -44.804346, -69.874935>,
				< 18.317103, -44.077694, -54.068528>
			}
			triangle {
				< 15.946431, -28.764257, -64.778440>,
				< 17.583236, -29.140381, -72.960310>,
				< 21.479160, -44.804346, -69.874935>
			}
			triangle {
				< 17.583236, -29.140381, -72.960310>,
				< 24.587013, -43.281890, -86.086296>,
				< 21.479160, -44.804346, -69.874935>
			}
			triangle {
				< 17.583236, -29.140381, -72.960310>,
				< 19.191965, -28.352331, -81.351861>,
				< 24.587013, -43.281890, -86.086296>
			}
			triangle {
				< 19.191965, -28.352331, -81.351861>,
				< 27.428886, -39.614104, -101.598099>,
				< 24.587013, -43.281890, -86.086296>
			}
			triangle {
				< 19.191965, -28.352331, -81.351861>,
				< 20.663036, -26.453750, -89.381427>,
				< 27.428886, -39.614104, -101.598099>
			}
			triangle {
				< 20.663036, -26.453750, -89.381427>,
				< 29.811090, -34.050897, -115.353405>,
				< 27.428886, -39.614104, -101.598099>
			}
			triangle {
				< 20.663036, -26.453750, -89.381427>,
				< 21.896178, -23.573970, -96.501730>,
				< 29.811090, -34.050897, -115.353405>
			}
			triangle {
				< 21.896178, -23.573970, -96.501730>,
				< 31.571306, -26.971364, -126.414761>,
				< 29.811090, -34.050897, -115.353405>
			}
			triangle {
				< 21.896178, -23.573970, -96.501730>,
				< 22.807313, -19.909387, -102.227464>,
				< 31.571306, -26.971364, -126.414761>
			}
			triangle {
				< 22.807313, -19.909387, -102.227464>,
				< 32.589607, -18.858088, -134.028152>,
				< 31.571306, -26.971364, -126.414761>
			}
			triangle {
				< 22.807313, -19.909387, -102.227464>,
				< 23.334431, -15.709590, -106.168479>,
				< 32.589607, -18.858088, -134.028152>
			}
			triangle {
				< 23.334431, -15.709590, -106.168479>,
				< 32.796562, -10.263803, -137.674958>,
				< 32.589607, -18.858088, -134.028152>
			}
			triangle {
				< 23.334431, -15.709590, -106.168479>,
				< 23.441596, -11.260920, -108.056128>,
				< 32.796562, -10.263803, -137.674958>
			}
			triangle {
				< 23.441596, -11.260920, -108.056128>,
				< 32.178137, -1.774359, -137.106597>,
				< 32.796562, -10.263803, -137.674958>
			}
			triangle {
				< 23.441596, -11.260920, -108.056128>,
				< 23.121411, -6.866406, -107.762009>,
				< 32.178137, -1.774359, -137.106597>
			}
			triangle {
				< 23.121411, -6.866406, -107.762009>,
				< 30.776344, 6.031817, -132.361859>,
				< 32.178137, -1.774359, -137.106597>
			}
			triangle {
				< 23.121411, -6.866406, -107.762009>,
				< 22.395823, -2.825659, -105.305873>,
				< 30.776344, 6.031817, -132.361859>
			}
			triangle {
				< 22.395823, -2.825659, -105.305873>,
				< 28.686788, 12.622584, -123.763964>,
				< 30.776344, 6.031817, -132.361859>
			}
			triangle {
				< 22.395823, -2.825659, -105.305873>,
				< 21.314193, 0.586024, -100.855328>,
				< 28.686788, 12.622584, -123.763964>
			}
			triangle {
				< 21.314193, 0.586024, -100.855328>,
				< 26.051873, 17.549073, -111.898929>,
				< 28.686788, 12.622584, -123.763964>
			}
			triangle {
				< 21.314193, 0.586024, -100.855328>,
				< 19.950245, 3.136095, -94.713457>,
				< 26.051873, 17.549073, -111.898929>
			}
			triangle {
				< 19.950245, 3.136095, -94.713457>,
				< 23.051161, 20.475343, -97.575352>,
				< 26.051873, 17.549073, -111.898929>
			}
			triangle {
				< 19.950245, 3.136095, -94.713457>,
				< 18.396959, 4.650850, -87.299041>,
				< 23.051161, 20.475343, -97.575352>
			}
			triangle {
				< 18.396959, 4.650850, -87.299041>,
				< 19.889105, 21.202013, -81.769168>,
				< 23.051161, 20.475343, -97.575352>
			}
			triangle {
				< 18.396959, 4.650850, -87.299041>,
				< 16.760176, 5.026997, -79.117216>,
				< 19.889105, 21.202013, -81.769168>
			}
			triangle {
				< 16.760176, 5.026997, -79.117216>,
				< 16.781272, 19.679509, -65.557860>,
				< 19.889105, 21.202013, -81.769168>
			}
			triangle {
				< 16.760176, 5.026997, -79.117216>,
				< 15.151425, 4.238926, -70.725575>,
				< 16.781272, 19.679509, -65.557860>
			}
			triangle {
				< 15.151425, 4.238926, -70.725575>,
				< 13.939360, 16.011549, -50.045669>,
				< 16.781272, 19.679509, -65.557860>
			}
			triangle {
				< 15.151425, 4.238926, -70.725575>,
				< 13.680375, 2.340327, -62.696129>,
				< 13.939360, 16.011549, -50.045669>
			}
			triangle {
				< 13.680375, 2.340327, -62.696129>,
				< 11.557136, 10.448344, -36.290411>,
				< 13.939360, 16.011549, -50.045669>
			}
			triangle {
				< 13.680375, 2.340327, -62.696129>,
				< 12.447214, -0.539334, -55.575788>,
				< 11.557136, 10.448344, -36.290411>
			}
			triangle {
				< 12.447214, -0.539334, -55.575788>,
				< 9.796894, 3.368987, -25.228988>,
				< 11.557136, 10.448344, -36.290411>
			}
			triangle {
				< 12.447214, -0.539334, -55.575788>,
				< 11.536059, -4.204017, -49.849730>,
				< 9.796894, 3.368987, -25.228988>
			}
			triangle {
				< 9.796894, 3.368987, -25.228988>,
				< 9.434660, -1.414821, 6.838878>,
				< 10.874737, 10.058930, -3.928217>
			}
			triangle {
				< 9.796894, 3.368987, -25.228988>,
				< 8.778618, -4.744346, -17.615648>,
				< 9.434660, -1.414821, 6.838878>
			}
			triangle {
				< 8.778618, -4.744346, -17.615648>,
				< 9.141991, -13.568923, 11.996225>,
				< 9.434660, -1.414821, 6.838878>
			}
			triangle {
				< 8.778618, -4.744346, -17.615648>,
				< 8.571662, -13.338551, -13.968792>,
				< 9.141991, -13.568923, 11.996225>
			}
			triangle {
				< 8.571662, -13.338551, -13.968792>,
				< 10.016666, -25.574852, 11.192420>,
				< 9.141991, -13.568923, 11.996225>
			}
			triangle {
				< 8.571662, -13.338551, -13.968792>,
				< 9.190148, -21.828035, -14.537133>,
				< 10.016666, -25.574852, 11.192420>
			}
			triangle {
				< 9.190148, -21.828035, -14.537133>,
				< 11.999080, -36.614407, 4.482304>,
				< 10.016666, -25.574852, 11.192420>
			}
			triangle {
				< 9.190148, -21.828035, -14.537133>,
				< 10.591922, -29.634168, -19.281957>,
				< 11.999080, -36.614407, 4.482304>
			}
			triangle {
				< 10.591922, -29.634168, -19.281957>,
				< 14.954159, -45.935303, -7.676957>,
				< 11.999080, -36.614407, 4.482304>
			}
			triangle {
				< 10.591922, -29.634168, -19.281957>,
				< 12.681478, -36.225010, -27.879825>,
				< 14.954159, -45.935303, -7.676957>
			}
			triangle {
				< 12.681478, -36.225010, -27.879825>,
				< 18.680498, -52.902397, -24.456695>,
				< 14.954159, -45.935303, -7.676957>
			}
			triangle {
				< 12.681478, -36.225010, -27.879825>,
				< 15.316414, -41.151494, -39.744928>,
				< 18.680498, -52.902397, -24.456695>
			}
			triangle {
				< 15.316414, -41.151494, -39.744928>,
				< 22.924142, -57.040762, -44.713352>,
				< 18.680498, -52.902397, -24.456695>
			}
			triangle {
				< 15.316414, -41.151494, -39.744928>,
				< 18.317103, -44.077694, -54.068528>,
				< 22.924142, -57.040762, -44.713352>
			}
			triangle {
				< 18.317103, -44.077694, -54.068528>,
				< 27.395966, -58.068305, -67.066871>,
				< 22.924142, -57.040762, -44.713352>
			}
			triangle {
				< 18.317103, -44.077694, -54.068528>,
				< 21.479160, -44.804346, -69.874935>,
				< 27.395966, -58.068305, -67.066871>
			}
			triangle {
				< 21.479160, -44.804346, -69.874935>,
				< 31.791121, -55.915270, -89.993149>,
				< 27.395966, -58.068305, -67.066871>
			}
			triangle {
				< 21.479160, -44.804346, -69.874935>,
				< 24.587013, -43.281890, -86.086296>,
				< 31.791121, -55.915270, -89.993149>
			}
			triangle {
				< 24.587013, -43.281890, -86.086296>,
				< 35.810091, -50.728153, -111.930236>,
				< 31.791121, -55.915270, -89.993149>
			}
			triangle {
				< 24.587013, -43.281890, -86.086296>,
				< 27.428886, -39.614104, -101.598099>,
				< 35.810091, -50.728153, -111.930236>
			}
			triangle {
				< 27.428886, -39.614104, -101.598099>,
				< 39.179143, -42.860527, -131.383106>,
				< 35.810091, -50.728153, -111.930236>
			}
			triangle {
				< 27.428886, -39.614104, -101.598099>,
				< 29.811090, -34.050897, -115.353405>,
				< 39.179143, -42.860527, -131.383106>
			}
			triangle {
				< 29.811090, -34.050897, -115.353405>,
				< 41.668467, -32.848604, -147.026181>,
				< 39.179143, -42.860527, -131.383106>
			}
			triangle {
				< 29.811090, -34.050897, -115.353405>,
				< 31.571306, -26.971364, -126.414761>,
				< 41.668467, -32.848604, -147.026181>
			}
			triangle {
				< 31.571306, -26.971364, -126.414761>,
				< 43.108609, -21.374639, -157.793298>,
				< 41.668467, -32.848604, -147.026181>
			}
			triangle {
				< 31.571306, -26.971364, -126.414761>,
				< 32.589607, -18.858088, -134.028152>,
				< 43.108609, -21.374639, -157.793298>
			}
			triangle {
				< 32.589607, -18.858088, -134.028152>,
				< 43.401275, -9.220578, -162.950620>,
				< 43.108609, -21.374639, -157.793298>
			}
			triangle {
				< 32.589607, -18.858088, -134.028152>,
				< 32.796562, -10.263803, -137.674958>,
				< 43.401275, -9.220578, -162.950620>
			}
			triangle {
				< 32.796562, -10.263803, -137.674958>,
				< 42.526603, 2.785351, -162.146524>,
				< 43.401275, -9.220578, -162.950620>
			}
			triangle {
				< 32.796562, -10.263803, -137.674958>,
				< 32.178137, -1.774359, -137.106597>,
				< 42.526603, 2.785351, -162.146524>
			}
			triangle {
				< 32.178137, -1.774359, -137.106597>,
				< 40.544167, 13.824851, -155.436575>,
				< 42.526603, 2.785351, -162.146524>
			}
			triangle {
				< 32.178137, -1.774359, -137.106597>,
				< 30.776344, 6.031817, -132.361859>,
				< 40.544167, 13.824851, -155.436575>
			}
			triangle {
				< 30.776344, 6.031817, -132.361859>,
				< 37.589088, 23.145808, -143.277302>,
				< 40.544167, 13.824851, -155.436575>
			}
			triangle {
				< 30.776344, 6.031817, -132.361859>,
				< 28.686788, 12.622584, -123.763964>,
				< 37.589088, 23.145808, -143.277302>
			}
			triangle {
				< 28.686788, 12.622584, -123.763964>,
				< 33.862725, 30.112723, -126.497701>,
				< 37.589088, 23.145808, -143.277302>
			}
			triangle {
				< 28.686788, 12.622584, -123.763964>,
				< 26.051873, 17.549073, -111.898929>,
				< 33.862725, 30.112723, -126.497701>
			}
			triangle {
				< 26.051873, 17.549073, -111.898929>,
				< 29.619103, 34.251161, -106.241025>,
				< 33.862725, 30.112723, -126.497701>
			}
			triangle {
				< 26.051873, 17.549073, -111.898929>,
				< 23.051161, 20.475343, -97.575352>,
				< 29.619103, 34.251161, -106.241025>
			}
			triangle {
				< 23.051161, 20.475343, -97.575352>,
				< 25.147300, 35.278857, -83.887875>,
				< 29.619103, 34.251161, -106.241025>
			}
			triangle {
				< 23.051161, 20.475343, -97.575352>,
				< 19.889105, 21.202013, -81.769168>,
				< 25.147300, 35.278857, -83.887875>
			}
			triangle {
				< 19.889105, 21.202013, -81.769168>,
				< 20.752145, 33.125795, -60.961559>,
				< 25.147300, 35.278857, -83.887875>
			}
			triangle {
				< 19.889105, 21.202013, -81.769168>,
				< 16.781272, 19.679509, -65.557860>,
				< 20.752145, 33.125795, -60.961559>
			}
			triangle {
				< 16.781272, 19.679509, -65.557860>,
				< 16.733116, 27.938580, -39.024163>,
				< 20.752145, 33.125795, -60.961559>
			}
			triangle {
				< 16.781272, 19.679509, -65.557860>,
				< 13.939360, 16.011549, -50.045669>,
				< 16.733116, 27.938580, -39.024163>
			}
			triangle {
				< 13.939360, 16.011549, -50.045669>,
				< 13.364105, 20.070966, -19.571250>,
				< 16.733116, 27.938580, -39.024163>
			}
			triangle {
				< 13.939360, 16.011549, -50.045669>,
				< 11.557136, 10.448344, -36.290411>,
				< 13.364105, 20.070966, -19.571250>
			}
			triangle {
				< 11.557136, 10.448344, -36.290411>,
				< 10.874737, 10.058930, -3.928217>,
				< 13.364105, 20.070966, -19.571250>
			}
			triangle {
				< 11.557136, 10.448344, -36.290411>,
				< 9.796894, 3.368987, -25.228988>,
				< 10.874737, 10.058930, -3.928217>
			}
			triangle {
				< 10.874737, 10.058930, -3.928217>,
				< 12.932387, 1.357795, 25.788171>,
				< 14.696127, 15.410352, 12.601336>
			}
			triangle {
				< 10.874737, 10.058930, -3.928217>,
				< 9.434660, -1.414821, 6.838878>,
				< 12.932387, 1.357795, 25.788171>
			}
			triangle {
				< 9.434660, -1.414821, 6.838878>,
				< 12.573943, -13.527846, 32.104623>,
				< 12.932387, 1.357795, 25.788171>
			}
			triangle {
				< 9.434660, -1.414821, 6.838878>,
				< 9.141991, -13.568923, 11.996225>,
				< 12.573943, -13.527846, 32.104623>
			}
			triangle {
				< 9.141991, -13.568923, 11.996225>,
				< 13.645200, -28.232044, 31.120215>,
				< 12.573943, -13.527846, 32.104623>
			}
			triangle {
				< 9.141991, -13.568923, 11.996225>,
				< 10.016666, -25.574852, 11.192420>,
				< 13.645200, -28.232044, 31.120215>
			}
			triangle {
				< 10.016666, -25.574852, 11.192420>,
				< 16.073162, -41.752730, 22.901952>,
				< 13.645200, -28.232044, 31.120215>
			}
			triangle {
				< 10.016666, -25.574852, 11.192420>,
				< 11.999080, -36.614407, 4.482304>,
				< 16.073162, -41.752730, 22.901952>
			}
			triangle {
				< 11.999080, -36.614407, 4.482304>,
				< 19.692378, -53.168483, 8.009991>,
				< 16.073162, -41.752730, 22.901952>
			}
			triangle {
				< 11.999080, -36.614407, 4.482304>,
				< 14.954159, -45.935303, -7.676957>,
				< 19.692378, -53.168483, 8.009991>
			}
			triangle {
				< 14.954159, -45.935303, -7.676957>,
				< 24.256188, -61.701462, -12.540932>,
				< 19.692378, -53.168483, 8.009991>
			}
			triangle {
				< 14.954159, -45.935303, -7.676957>,
				< 18.680498, -52.902397, -24.456695>,
				< 24.256188, -61.701462, -12.540932>
			}
			triangle {
				< 18.680498, -52.902397, -24.456695>,
				< 29.453577, -66.769853, -37.350137>,
				< 24.256188, -61.701462, -12.540932>
			}
			triangle {
				< 18.680498, -52.902397, -24.456695>,
				< 22.924142, -57.040762, -44.713352>,
				< 29.453577, -66.769853, -37.350137>
			}
			triangle {
				< 22.924142, -57.040762, -44.713352>,
				< 34.930404, -68.028234, -64.727426>,
				< 29.453577, -66.769853, -37.350137>
			}
			triangle {
				< 22.924142, -57.040762, -44.713352>,
				< 27.395966, -58.068305, -67.066871>,
				< 34.930404, -68.028234, -64.727426>
			}
			triangle {
				< 27.395966, -58.068305, -67.066871>,
				< 40.313281, -65.391384, -92.806220>,
				< 34.930404, -68.028234, -64.727426>
			}
			triangle {
				< 27.395966, -58.068305, -67.066871>,
				< 31.791121, -55.915270, -89.993149>,
				< 40.313281, -65.391384, -92.806220>
			}
			triangle {
				< 31.791121, -55.915270, -89.993149>,
				< 45.235638, -59.038445, -119.673595>,
				< 40.313281, -65.391384, -92.806220>
			}
			triangle {
				< 31.791121, -55.915270, -89.993149>,
				< 35.810091, -50.728153, -111.930236>,
				< 45.235638, -59.038445, -119.673595>
			}
			triangle {
				< 35.810091, -50.728153, -111.930236>,
				< 49.361747, -49.402736, -143.498451>,
				< 45.235638, -59.038445, -119.673595>
			}
			triangle {
				< 35.810091, -50.728153, -111.930236>,
				< 39.179143, -42.860527, -131.383106>,
				< 49.361747, -49.402736, -143.498451>
			}
			triangle {
				< 39.179143, -42.860527, -131.383106>,
				< 52.410614, -37.140552, -162.657082>,
				< 49.361747, -49.402736, -143.498451>
			}
			triangle {
				< 39.179143, -42.860527, -131.383106>,
				< 41.668467, -32.848604, -147.026181>,
				< 52.410614, -37.140552, -162.657082>
			}
			triangle {
				< 41.668467, -32.848604, -147.026181>,
				< 54.174375, -23.087885, -175.844058>,
				< 52.410614, -37.140552, -162.657082>
			}
			triangle {
				< 41.668467, -32.848604, -147.026181>,
				< 43.108609, -21.374639, -157.793298>,
				< 54.174375, -23.087885, -175.844058>
			}
			triangle {
				< 43.108609, -21.374639, -157.793298>,
				< 54.532841, -8.202238, -182.160467>,
				< 54.174375, -23.087885, -175.844058>
			}
			triangle {
				< 43.108609, -21.374639, -157.793298>,
				< 43.401275, -9.220578, -162.950620>,
				< 54.532841, -8.202238, -182.160467>
			}
			triangle {
				< 43.401275, -9.220578, -162.950620>,
				< 53.461522, 6.501918, -181.176141>,
				< 54.532841, -8.202238, -182.160467>
			}
			triangle {
				< 43.401275, -9.220578, -162.950620>,
				< 42.526603, 2.785351, -162.146524>,
				< 53.461522, 6.501918, -181.176141>
			}
			triangle {
				< 42.526603, 2.785351, -162.146524>,
				< 51.033605, 20.022603, -172.957748>,
				< 53.461522, 6.501918, -181.176141>
			}
			triangle {
				< 42.526603, 2.785351, -162.146524>,
				< 40.544167, 13.824851, -155.436575>,
				< 51.033605, 20.022603, -172.957748>
			}
			triangle {
				< 40.544167, 13.824851, -155.436575>,
				< 47.414385, 31.438306, -158.065885>,
				< 51.033605, 20.022603, -172.957748>
			}
			triangle {
				< 40.544167, 13.824851, -155.436575>,
				< 37.589088, 23.145808, -143.277302>,
				< 47.414385, 31.438306, -158.065885>
			}
			triangle {
				< 37.589088, 23.145808, -143.277302>,
				< 42.850599, 39.971195, -137.515008>,
				< 47.414385, 31.438306, -158.065885>
			}
			triangle {
				< 37.589088, 23.145808, -143.277302>,
				< 33.862725, 30.112723, -126.497701>,
				< 42.850599, 39.971195, -137.515008>
			}
			triangle {
				< 33.862725, 30.112723, -126.497701>,
				< 37.653189, 45.039684, -112.705842>,
				< 42.850599, 39.971195, -137.515008>
			}
			triangle {
				< 33.862725, 30.112723, -126.497701>,
				< 29.619103, 34.251161, -106.241025>,
				< 37.653189, 45.039684, -112.705842>
			}
			triangle {
				< 29.619103, 34.251161, -106.241025>,
				< 32.176357, 46.298061, -85.328862>,
				< 37.653189, 45.039684, -112.705842>
			}
			triangle {
				< 29.619103, 34.251161, -106.241025>,
				< 25.147300, 35.278857, -83.887875>,
				< 32.176357, 46.298061, -85.328862>
			}
			triangle {
				< 25.147300, 35.278857, -83.887875>,
				< 26.793402, 43.661296, -57.249941>,
				< 32.176357, 46.298061, -85.328862>
			}
			triangle {
				< 25.147300, 35.278857, -83.887875>,
				< 20.752145, 33.125795, -60.961559>,
				< 26.793402, 43.661296, -57.249941>
			}
			triangle {
				< 20.752145, 33.125795, -60.961559>,
				< 21.871125, 37.308261, -30.382300>,
				< 26.793402, 43.661296, -57.249941>
			}
			triangle {
				< 20.752145, 33.125795, -60.961559>,
				< 16.733116, 27.938580, -39.024163>,
				< 21.871125, 37.308261, -30.382300>
			}
			triangle {
				< 16.733116, 27.938580, -39.024163>,
				< 17.744973, 27.672485, -6.557480>,
				< 21.871125, 37.308261, -30.382300>
			}
			triangle {
				< 16.733116, 27.938580, -39.024163>,
				< 13.364105, 20.070966, -19.571250>,
				< 17.744973, 27.672485, -6.557480>
			}
			triangle {
				< 13.364105, 20.070966, -19.571250>,
				< 14.696127, 15.410352, 12.601336>,
				< 17.744973, 27.672485, -6.557480>
			}
			triangle {
				< 13.364105, 20.070966, -19.571250>,
				< 10.874737, 10.058930, -3.928217>,
				< 14.696127, 15.410352, 12.601336>
			}
			triangle {
				< 14.696127, 15.410352, 12.601336>,
				< 19.033415, 3.384634, 37.940972>,
				< 21.000633, 19.058157, 23.232860>
			}
			triangle {
				< 14.696127, 15.410352, 12.601336>,
				< 12.932387, 1.357795, 25.788171>,
				< 19.033415, 3.384634, 37.940972>
			}
			triangle {
				< 12.932387, 1.357795, 25.788171>,
				< 18.633625, -13.218200, 44.986073>,
				< 19.033415, 3.384634, 37.940972>
			}
			triangle {
				< 12.932387, 1.357795, 25.788171>,
				< 12.573943, -13.527846, 32.104623>,
				< 18.633625, -13.218200, 44.986073>
			}
			triangle {
				< 12.573943, -13.527846, 32.104623>,
				< 19.828442, -29.618582, 43.888047>,
				< 18.633625, -13.218200, 44.986073>
			}
			triangle {
				< 12.573943, -13.527846, 32.104623>,
				< 13.645200, -28.232044, 31.120215>,
				< 19.828442, -29.618582, 43.888047>
			}
			triangle {
				< 13.645200, -28.232044, 31.120215>,
				< 22.536485, -44.698909, 34.721773>,
				< 19.828442, -29.618582, 43.888047>
			}
			triangle {
				< 13.645200, -28.232044, 31.120215>,
				< 16.073162, -41.752730, 22.901952>,
				< 22.536485, -44.698909, 34.721773>
			}
			triangle {
				< 16.073162, -41.752730, 22.901952>,
				< 26.573217, -57.431526, 18.111911>,
				< 22.536485, -44.698909, 34.721773>
			}
			triangle {
				< 16.073162, -41.752730, 22.901952>,
				< 19.692378, -53.168483, 8.009991>,
				< 26.573217, -57.431526, 18.111911>
			}
			triangle {
				< 19.692378, -53.168483, 8.009991>,
				< 31.663481, -66.948816, -4.809600>,
				< 26.573217, -57.431526, 18.111911>
			}
			triangle {
				< 19.692378, -53.168483, 8.009991>,
				< 24.256188, -61.701462, -12.540932>,
				< 31.663481, -66.948816, -4.809600>
			}
			triangle {
				< 24.256188, -61.701462, -12.540932>,
				< 37.460431, -72.601996, -32.480653>,
				< 31.663481, -66.948816, -4.809600>
			}
			triangle {
				< 24.256188, -61.701462, -12.540932>,
				< 29.453577, -66.769853, -37.350137>,
				< 37.460431, -72.601996, -32.480653>
			}
			triangle {
				< 29.453577, -66.769853, -37.350137>,
				< 43.569040, -74.005455, -63.016005>,
				< 37.460431, -72.601996, -32.480653>
			}
			triangle {
				< 29.453577, -66.769853, -37.350137>,
				< 34.930404, -68.028234, -64.727426>,
				< 43.569040, -74.005455, -63.016005>
			}
			triangle {
				< 34.930404, -68.028234, -64.727426>,
				< 49.572885, -71.064495, -94.333962>,
				< 43.569040, -74.005455, -63.016005>
			}
			triangle {
				< 34.930404, -68.028234, -64.727426>,
				< 40.313281, -65.391384, -92.806220>,
				< 49.572885, -71.064495, -94.333962>
			}
			triangle {
				< 40.313281, -65.391384, -92.806220>,
				< 55.063024, -63.978881, -124.300480>,
				< 49.572885, -71.064495, -94.333962>
			}
			triangle {
				< 40.313281, -65.391384, -92.806220>,
				< 45.235638, -59.038445, -119.673595>,
				< 55.063024, -63.978881, -124.300480>
			}
			triangle {
				< 45.235638, -59.038445, -119.673595>,
				< 59.665155, -53.231288, -150.873706>,
				< 55.063024, -63.978881, -124.300480>
			}
			triangle {
				< 45.235638, -59.038445, -119.673595>,
				< 49.361747, -49.402736, -143.498451>,
				< 59.665155, -53.231288, -150.873706>
			}
			triangle {
				< 49.361747, -49.402736, -143.498451>,
				< 63.065700, -39.554767, -172.242373>,
				< 59.665155, -53.231288, -150.873706>
			}
			triangle {
				< 49.361747, -49.402736, -143.498451>,
				< 52.410614, -37.140552, -162.657082>,
				< 63.065700, -39.554767, -172.242373>
			}
			triangle {
				< 52.410614, -37.140552, -162.657082>,
				< 65.032899, -23.881027, -186.950505>,
				< 63.065700, -39.554767, -172.242373>
			}
			triangle {
				< 52.410614, -37.140552, -162.657082>,
				< 54.174375, -23.087885, -175.844058>,
				< 65.032899, -23.881027, -186.950505>
			}
			triangle {
				< 54.174375, -23.087885, -175.844058>,
				< 65.432690, -7.278185, -193.995744>,
				< 65.032899, -23.881027, -186.950505>
			}
			triangle {
				< 54.174375, -23.087885, -175.844058>,
				< 54.532841, -8.202238, -182.160467>,
				< 65.432690, -7.278185, -193.995744>
			}
			triangle {
				< 54.532841, -8.202238, -182.160467>,
				< 64.237870, 9.122196, -192.897692>,
				< 65.432690, -7.278185, -193.995744>
			}
			triangle {
				< 54.532841, -8.202238, -182.160467>,
				< 53.461522, 6.501918, -181.176141>,
				< 64.237870, 9.122196, -192.897692>
			}
			triangle {
				< 53.461522, 6.501918, -181.176141>,
				< 61.529849, 24.202423, -183.731034>,
				< 64.237870, 9.122196, -192.897692>
			}
			triangle {
				< 53.461522, 6.501918, -181.176141>,
				< 51.033605, 20.022603, -172.957748>,
				< 61.529849, 24.202423, -183.731034>
			}
			triangle {
				< 51.033605, 20.022603, -172.957748>,
				< 57.493117, 36.935095, -167.121693>,
				< 61.529849, 24.202423, -183.731034>
			}
			triangle {
				< 51.033605, 20.022603, -172.957748>,
				< 47.414385, 31.438306, -158.065885>,
				< 57.493117, 36.935095, -167.121693>
			}
			triangle {
				< 47.414385, 31.438306, -158.065885>,
				< 52.402850, 46.452191, -144.200027>,
				< 57.493117, 36.935095, -167.121693>
			}
			triangle {
				< 47.414385, 31.438306, -158.065885>,
				< 42.850599, 39.971195, -137.515008>,
				< 52.402850, 46.452191, -144.200027>
			}
			triangle {
				< 42.850599, 39.971195, -137.515008>,
				< 46.605900, 52.105282, -116.528973>,
				< 52.402850, 46.452191, -144.200027>
			}
			triangle {
				< 42.850599, 39.971195, -137.515008>,
				< 37.653189, 45.039684, -112.705842>,
				< 46.605900, 52.105282, -116.528973>
			}
			triangle {
				< 37.653189, 45.039684, -112.705842>,
				< 40.497314, 53.509116, -85.993990>,
				< 46.605900, 52.105282, -116.528973>
			}
			triangle {
				< 37.653189, 45.039684, -112.705842>,
				< 32.176357, 46.298061, -85.328862>,
				< 40.497314, 53.509116, -85.993990>
			}
			triangle {
				< 32.176357, 46.298061, -85.328862>,
				< 34.493409, 50.567899, -54.675687>,
				< 40.497314, 53.509116, -85.993990>
			}
			triangle {
				< 32.176357, 46.298061, -85.328862>,
				< 26.793402, 43.661296, -57.249941>,
				< 34.493409, 50.567899, -54.675687>
			}
			triangle {
				< 26.793402, 43.661296, -57.249941>,
				< 29.003287, 43.482188, -24.709076>,
				< 34.493409, 50.567899, -54.675687>
			}
			triangle {
				< 26.793402, 43.661296, -57.249941>,
				< 21.871125, 37.308261, -30.382300>,
				< 29.003287, 43.482188, -24.709076>
			}
			triangle {
				< 21.871125, 37.308261, -30.382300>,
				< 24.401177, 32.734841, 1.864076>,
				< 29.003287, 43.482188, -24.709076>
			}
			triangle {
				< 21.871125, 37.308261, -30.382300>,
				< 17.744973, 27.672485, -6.557480>,
				< 24.401177, 32.734841, 1.864076>
			}
			triangle {
				< 17.744973, 27.672485, -6.557480>,
				< 21.000633, 19.058157, 23.232860>,
				< 24.401177, 32.734841, 1.864076>
			}
			triangle {
				< 17.744973, 27.672485, -6.557480>,
				< 14.696127, 15.410352, 12.601336>,
				< 21.000633, 19.058157, 23.232860>
			}
			triangle {
				< 21.000633, 19.058157, 23.232860>,
				< 27.322013, 4.527471, 42.469006>,
				< 29.358607, 20.753965, 27.242076>
			}
			triangle {
				< 21.000633, 19.058157, 23.232860>,
				< 19.033415, 3.384634, 37.940972>,
				< 27.322013, 4.527471, 42.469006>
			}
			triangle {
				< 19.033415, 3.384634, 37.940972>,
				< 26.908079, -12.661017, 49.762640>,
				< 27.322013, 4.527471, 42.469006>
			}
			triangle {
				< 19.033415, 3.384634, 37.940972>,
				< 18.633625, -13.218200, 44.986073>,
				< 26.908079, -12.661017, 49.762640>
			}
			triangle {
				< 18.633625, -13.218200, 44.986073>,
				< 28.145073, -29.639969, 48.625935>,
				< 26.908079, -12.661017, 49.762640>
			}
			triangle {
				< 18.633625, -13.218200, 44.986073>,
				< 19.828442, -29.618582, 43.888047>,
				< 28.145073, -29.639969, 48.625935>
			}
			triangle {
				< 19.828442, -29.618582, 43.888047>,
				< 30.948661, -45.252241, 39.136309>,
				< 28.145073, -29.639969, 48.625935>
			}
			triangle {
				< 19.828442, -29.618582, 43.888047>,
				< 22.536485, -44.698909, 34.721773>,
				< 30.948661, -45.252241, 39.136309>
			}
			triangle {
				< 22.536485, -44.698909, 34.721773>,
				< 35.127774, -58.434151, 21.940487>,
				< 30.948661, -45.252241, 39.136309>
			}
			triangle {
				< 22.536485, -44.698909, 34.721773>,
				< 26.573217, -57.431526, 18.111911>,
				< 35.127774, -58.434151, 21.940487>
			}
			triangle {
				< 26.573217, -57.431526, 18.111911>,
				< 40.397603, -68.287067, -1.789572>,
				< 35.127774, -58.434151, 21.940487>
			}
			triangle {
				< 26.573217, -57.431526, 18.111911>,
				< 31.663481, -66.948816, -4.809600>,
				< 40.397603, -68.287067, -1.789572>
			}
			triangle {
				< 31.663481, -66.948816, -4.809600>,
				< 46.399068, -74.139610, -30.436875>,
				< 40.397603, -68.287067, -1.789572>
			}
			triangle {
				< 31.663481, -66.948816, -4.809600>,
				< 37.460431, -72.601996, -32.480653>,
				< 46.399068, -74.139610, -30.436875>
			}
			triangle {
				< 37.460431, -72.601996, -32.480653>,
				< 52.723140, -75.592615, -62.049337>,
				< 46.399068, -74.139610, -30.436875>
			}
			triangle {
				< 37.460431, -72.601996, -32.480653>,
				< 43.569040, -74.005455, -63.016005>,
				< 52.723140, -75.592615, -62.049337>
			}
			triangle {
				< 43.569040, -74.005455, -63.016005>,
				< 58.938846, -72.547704, -94.472006>,
				< 52.723140, -75.592615, -62.049337>
			}
			triangle {
				< 43.569040, -74.005455, -63.016005>,
				< 49.572885, -71.064495, -94.333962>,
				< 58.938846, -72.547704, -94.472006>
			}
			triangle {
				< 49.572885, -71.064495, -94.333962>,
				< 64.622588, -65.212287, -125.495717>,
				< 58.938846, -72.547704, -94.472006>
			}
			triangle {
				< 49.572885, -71.064495, -94.333962>,
				< 55.063024, -63.978881, -124.300480>,
				< 64.622588, -65.212287, -125.495717>
			}
			triangle {
				< 55.063024, -63.978881, -124.300480>,
				< 69.387056, -54.085661, -153.006390>,
				< 64.622588, -65.212287, -125.495717>
			}
			triangle {
				< 55.063024, -63.978881, -124.300480>,
				< 59.665155, -53.231288, -150.873706>,
				< 69.387056, -54.085661, -153.006390>
			}
			triangle {
				< 59.665155, -53.231288, -150.873706>,
				< 72.907560, -39.926626, -175.128743>,
				< 69.387056, -54.085661, -153.006390>
			}
			triangle {
				< 59.665155, -53.231288, -150.873706>,
				< 63.065700, -39.554767, -172.242373>,
				< 72.907560, -39.926626, -175.128743>
			}
			triangle {
				< 63.065700, -39.554767, -172.242373>,
				< 74.944183, -23.699928, -190.355718>,
				< 72.907560, -39.926626, -175.128743>
			}
			triangle {
				< 63.065700, -39.554767, -172.242373>,
				< 65.032899, -23.881027, -186.950505>,
				< 74.944183, -23.699928, -190.355718>
			}
			triangle {
				< 65.032899, -23.881027, -186.950505>,
				< 75.358070, -6.511502, -197.649390>,
				< 74.944183, -23.699928, -190.355718>
			}
			triangle {
				< 65.032899, -23.881027, -186.950505>,
				< 65.432690, -7.278185, -193.995744>,
				< 75.358070, -6.511502, -197.649390>
			}
			triangle {
				< 65.432690, -7.278185, -193.995744>,
				< 74.121095, 10.467169, -196.512252>,
				< 75.358070, -6.511502, -197.649390>
			}
			triangle {
				< 65.432690, -7.278185, -193.995744>,
				< 64.237870, 9.122196, -192.897692>,
				< 74.121095, 10.467169, -196.512252>
			}
			triangle {
				< 64.237870, 9.122196, -192.897692>,
				< 71.317524, 26.079789, -187.023312>,
				< 74.121095, 10.467169, -196.512252>
			}
			triangle {
				< 64.237870, 9.122196, -192.897692>,
				< 61.529849, 24.202423, -183.731034>,
				< 71.317524, 26.079789, -187.023312>
			}
			triangle {
				< 61.529849, 24.202423, -183.731034>,
				< 67.138411, 39.261483, -169.826940>,
				< 71.317524, 26.079789, -187.023312>
			}
			triangle {
				< 61.529849, 24.202423, -183.731034>,
				< 57.493117, 36.935095, -167.121693>,
				< 67.138411, 39.261483, -169.826940>
			}
			triangle {
				< 57.493117, 36.935095, -167.121693>,
				< 61.868563, 49.114387, -146.097243>,
				< 67.138411, 39.261483, -169.826940>
			}
			triangle {
				< 57.493117, 36.935095, -167.121693>,
				< 52.402850, 46.452191, -144.200027>,
				< 61.868563, 49.114387, -146.097243>
			}
			triangle {
				< 52.402850, 46.452191, -144.200027>,
				< 55.867143, 54.966833, -117.449999>,
				< 61.868563, 49.114387, -146.097243>
			}
			triangle {
				< 52.402850, 46.452191, -144.200027>,
				< 46.605900, 52.105282, -116.528973>,
				< 55.867143, 54.966833, -117.449999>
			}
			triangle {
				< 46.605900, 52.105282, -116.528973>,
				< 49.543049, 56.420244, -85.837804>,
				< 55.867143, 54.966833, -117.449999>
			}
			triangle {
				< 46.605900, 52.105282, -116.528973>,
				< 40.497314, 53.509116, -85.993990>,
				< 49.543049, 56.420244, -85.837804>
			}
			triangle {
				< 40.497314, 53.509116, -85.993990>,
				< 43.327365, 53.375214, -53.414866>,
				< 49.543049, 56.420244, -85.837804>
			}
			triangle {
				< 40.497314, 53.509116, -85.993990>,
				< 34.493409, 50.567899, -54.675687>,
				< 43.327365, 53.375214, -53.414866>
			}
			triangle {
				< 34.493409, 50.567899, -54.675687>,
				< 37.643600, 46.039555, -22.391073>,
				< 43.327365, 53.375214, -53.414866>
			}
			triangle {
				< 34.493409, 50.567899, -54.675687>,
				< 29.003287, 43.482188, -24.709076>,
				< 37.643600, 46.039555, -22.391073>
			}
			triangle {
				< 29.003287, 43.482188, -24.709076>,
				< 32.879129, 34.913082, 5.119444>,
				< 37.643600, 46.039555, -22.391073>
			}
			triangle {
				< 29.003287, 43.482188, -24.709076>,
				< 24.401177, 32.734841, 1.864076>,
				< 32.879129, 34.913082, 5.119444>
			}
			triangle {
				< 24.401177, 32.734841, 1.864076>,
				< 29.358607, 20.753965, 27.242076>,
				< 32.879129, 34.913082, 5.119444>
			}
			triangle {
				< 24.401177, 32.734841, 1.864076>,
				< 21.000633, 19.058157, 23.232860>,
				< 29.358607, 20.753965, 27.242076>
			}
			triangle {
				< 29.358607, 20.753965, 27.242076>,
				< 37.233293, 4.708510, 39.063781>,
				< 39.200488, 20.382131, 24.355713>
			}
			triangle {
				< 29.358607, 20.753965, 27.242076>,
				< 27.322013, 4.527471, 42.469006>,
				< 37.233293, 4.708510, 39.063781>
			}
			triangle {
				< 27.322013, 4.527471, 42.469006>,
				< 36.833480, -11.894334, 46.108905>,
				< 37.233293, 4.708510, 39.063781>
			}
			triangle {
				< 27.322013, 4.527471, 42.469006>,
				< 26.908079, -12.661017, 49.762640>,
				< 36.833480, -11.894334, 46.108905>
			}
			triangle {
				< 26.908079, -12.661017, 49.762640>,
				< 38.028300, -28.294673, 45.010857>,
				< 36.833480, -11.894334, 46.108905>
			}
			triangle {
				< 26.908079, -12.661017, 49.762640>,
				< 28.145073, -29.639969, 48.625935>,
				< 38.028300, -28.294673, 45.010857>
			}
			triangle {
				< 28.145073, -29.639969, 48.625935>,
				< 40.736362, -43.375000, 35.844628>,
				< 38.028300, -28.294673, 45.010857>
			}
			triangle {
				< 28.145073, -29.639969, 48.625935>,
				< 30.948661, -45.252241, 39.136309>,
				< 40.736362, -43.375000, 35.844628>
			}
			triangle {
				< 30.948661, -45.252241, 39.136309>,
				< 44.773072, -56.107722, 19.234722>,
				< 40.736362, -43.375000, 35.844628>
			}
			triangle {
				< 30.948661, -45.252241, 39.136309>,
				< 35.127774, -58.434151, 21.940487>,
				< 44.773072, -56.107722, 19.234722>
			}
			triangle {
				< 35.127774, -58.434151, 21.940487>,
				< 49.863338, -65.624908, -3.686789>,
				< 44.773072, -56.107722, 19.234722>
			}
			triangle {
				< 35.127774, -58.434151, 21.940487>,
				< 40.397603, -68.287067, -1.789572>,
				< 49.863338, -65.624908, -3.686789>
			}
			triangle {
				< 40.397603, -68.287067, -1.789572>,
				< 55.660311, -71.278028, -31.357847>,
				< 49.863338, -65.624908, -3.686789>
			}
			triangle {
				< 40.397603, -68.287067, -1.789572>,
				< 46.399068, -74.139610, -30.436875>,
				< 55.660311, -71.278028, -31.357847>
			}
			triangle {
				< 46.399068, -74.139610, -30.436875>,
				< 61.768875, -72.681651, -61.893195>,
				< 55.660311, -71.278028, -31.357847>
			}
			triangle {
				< 46.399068, -74.139610, -30.436875>,
				< 52.723140, -75.592615, -62.049337>,
				< 61.768875, -72.681651, -61.893195>
			}
			triangle {
				< 52.723140, -75.592615, -62.049337>,
				< 67.772798, -69.740385, -93.211189>,
				< 61.768875, -72.681651, -61.893195>
			}
			triangle {
				< 52.723140, -75.592615, -62.049337>,
				< 58.938846, -72.547704, -94.472006>,
				< 67.772798, -69.740385, -93.211189>
			}
			triangle {
				< 58.938846, -72.547704, -94.472006>,
				< 73.262878, -62.654704, -123.177715>,
				< 67.772798, -69.740385, -93.211189>
			}
			triangle {
				< 58.938846, -72.547704, -94.472006>,
				< 64.622588, -65.212287, -125.495717>,
				< 73.262878, -62.654704, -123.177715>
			}
			triangle {
				< 64.622588, -65.212287, -125.495717>,
				< 77.865019, -51.907379, -149.750933>,
				< 73.262878, -62.654704, -123.177715>
			}
			triangle {
				< 64.622588, -65.212287, -125.495717>,
				< 69.387056, -54.085661, -153.006390>,
				< 77.865019, -51.907379, -149.750933>
			}
			triangle {
				< 69.387056, -54.085661, -153.006390>,
				< 81.265531, -38.230859, -171.119407>,
				< 77.865019, -51.907379, -149.750933>
			}
			triangle {
				< 69.387056, -54.085661, -153.006390>,
				< 72.907560, -39.926626, -175.128743>,
				< 81.265531, -38.230859, -171.119407>
			}
			triangle {
				< 72.907560, -39.926626, -175.128743>,
				< 83.232731, -22.557100, -185.827449>,
				< 81.265531, -38.230859, -171.119407>
			}
			triangle {
				< 72.907560, -39.926626, -175.128743>,
				< 74.944183, -23.699928, -190.355718>,
				< 83.232731, -22.557100, -185.827449>
			}
			triangle {
				< 74.944183, -23.699928, -190.355718>,
				< 83.632521, -5.954278, -192.872718>,
				< 83.232731, -22.557100, -185.827449>
			}
			triangle {
				< 74.944183, -23.699928, -190.355718>,
				< 75.358070, -6.511502, -197.649390>,
				< 83.632521, -5.954278, -192.872718>
			}
			triangle {
				< 75.358070, -6.511502, -197.649390>,
				< 82.437724, 10.445834, -191.774502>,
				< 83.632521, -5.954278, -192.872718>
			}
			triangle {
				< 75.358070, -6.511502, -197.649390>,
				< 74.121095, 10.467169, -196.512252>,
				< 82.437724, 10.445834, -191.774502>
			}
			triangle {
				< 74.121095, 10.467169, -196.512252>,
				< 79.729684, 25.526438, -182.608590>,
				< 82.437724, 10.445834, -191.774502>
			}
			triangle {
				< 74.121095, 10.467169, -196.512252>,
				< 71.317524, 26.079789, -187.023312>,
				< 79.729684, 25.526438, -182.608590>
			}
			triangle {
				< 71.317524, 26.079789, -187.023312>,
				< 75.692974, 38.259000, -165.998727>,
				< 79.729684, 25.526438, -182.608590>
			}
			triangle {
				< 71.317524, 26.079789, -187.023312>,
				< 67.138411, 39.261483, -169.826940>,
				< 75.692974, 38.259000, -165.998727>
			}
			triangle {
				< 67.138411, 39.261483, -169.826940>,
				< 70.602730, 47.776099, -143.077388>,
				< 75.692974, 38.259000, -165.998727>
			}
			triangle {
				< 67.138411, 39.261483, -169.826940>,
				< 61.868563, 49.114387, -146.097243>,
				< 70.602730, 47.776099, -143.077388>
			}
			triangle {
				< 61.868563, 49.114387, -146.097243>,
				< 64.805754, 53.429261, -115.406156>,
				< 70.602730, 47.776099, -143.077388>
			}
			triangle {
				< 61.868563, 49.114387, -146.097243>,
				< 55.867143, 54.966833, -117.449999>,
				< 64.805754, 53.429261, -115.406156>
			}
			triangle {
				< 55.867143, 54.966833, -117.449999>,
				< 58.697190, 54.833118, -84.871180>,
				< 64.805754, 53.429261, -115.406156>
			}
			triangle {
				< 55.867143, 54.966833, -117.449999>,
				< 49.543049, 56.420244, -85.837804>,
				< 58.697190, 54.833118, -84.871180>
			}
			triangle {
				< 49.543049, 56.420244, -85.837804>,
				< 52.693263, 51.891848, -53.552900>,
				< 58.697190, 54.833118, -84.871180>
			}
			triangle {
				< 49.543049, 56.420244, -85.837804>,
				< 43.327365, 53.375214, -53.414866>,
				< 52.693263, 51.891848, -53.552900>
			}
			triangle {
				< 43.327365, 53.375214, -53.414866>,
				< 47.203165, 44.806093, -23.586286>,
				< 52.693263, 51.891848, -53.552900>
			}
			triangle {
				< 43.327365, 53.375214, -53.414866>,
				< 37.643600, 46.039555, -22.391073>,
				< 47.203165, 44.806093, -23.586286>
			}
			triangle {
				< 37.643600, 46.039555, -22.391073>,
				< 42.601034, 34.058738, 2.986887>,
				< 47.203165, 44.806093, -23.586286>
			}
			triangle {
				< 37.643600, 46.039555, -22.391073>,
				< 32.879129, 34.913082, 5.119444>,
				< 42.601034, 34.058738, 2.986887>
			}
			triangle {
				< 32.879129, 34.913082, 5.119444>,
				< 39.200488, 20.382131, 24.355713>,
				< 42.601034, 34.058738, 2.986887>
			}
			triangle {
				< 32.879129, 34.913082, 5.119444>,
				< 29.358607, 20.753965, 27.242076>,
				< 39.200488, 20.382131, 24.355713>
			}
			triangle {
				< 39.200488, 20.382131, 24.355713>,
				< 48.091795, 3.915382, 27.957290>,
				< 49.855534, 17.967928, 14.770415>
			}
			triangle {
				< 39.200488, 20.382131, 24.355713>,
				< 37.233293, 4.708510, 39.063781>,
				< 48.091795, 3.915382, 27.957290>
			}
			triangle {
				< 37.233293, 4.708510, 39.063781>,
				< 47.733348, -10.970239, 34.273785>,
				< 48.091795, 3.915382, 27.957290>
			}
			triangle {
				< 37.233293, 4.708510, 39.063781>,
				< 36.833480, -11.894334, 46.108905>,
				< 47.733348, -10.970239, 34.273785>
			}
			triangle {
				< 36.833480, -11.894334, 46.108905>,
				< 48.804607, -25.674475, 33.289317>,
				< 47.733348, -10.970239, 34.273785>
			}
			triangle {
				< 36.833480, -11.894334, 46.108905>,
				< 38.028300, -28.294673, 45.010857>,
				< 48.804607, -25.674475, 33.289317>
			}
			triangle {
				< 38.028300, -28.294673, 45.010857>,
				< 51.232569, -39.195124, 25.071053>,
				< 48.804607, -25.674475, 33.289317>
			}
			triangle {
				< 38.028300, -28.294673, 45.010857>,
				< 40.736362, -43.375000, 35.844628>,
				< 51.232569, -39.195124, 25.071053>
			}
			triangle {
				< 40.736362, -43.375000, 35.844628>,
				< 54.851785, -50.610829, 10.179070>,
				< 51.232569, -39.195124, 25.071053>
			}
			triangle {
				< 40.736362, -43.375000, 35.844628>,
				< 44.773072, -56.107722, 19.234722>,
				< 54.851785, -50.610829, 10.179070>
			}
			triangle {
				< 44.773072, -56.107722, 19.234722>,
				< 59.415612, -59.143852, -10.371831>,
				< 54.851785, -50.610829, 10.179070>
			}
			triangle {
				< 44.773072, -56.107722, 19.234722>,
				< 49.863338, -65.624908, -3.686789>,
				< 59.415612, -59.143852, -10.371831>
			}
			triangle {
				< 49.863338, -65.624908, -3.686789>,
				< 64.613029, -64.212263, -35.181016>,
				< 59.415612, -59.143852, -10.371831>
			}
			triangle {
				< 49.863338, -65.624908, -3.686789>,
				< 55.660311, -71.278028, -31.357847>,
				< 64.613029, -64.212263, -35.181016>
			}
			triangle {
				< 55.660311, -71.278028, -31.357847>,
				< 70.089810, -65.470628, -62.558323>,
				< 64.613029, -64.212263, -35.181016>
			}
			triangle {
				< 55.660311, -71.278028, -31.357847>,
				< 61.768875, -72.681651, -61.893195>,
				< 70.089810, -65.470628, -62.558323>
			}
			triangle {
				< 61.768875, -72.681651, -61.893195>,
				< 75.472765, -62.833622, -90.637118>,
				< 70.089810, -65.470628, -62.558323>
			}
			triangle {
				< 61.768875, -72.681651, -61.893195>,
				< 67.772798, -69.740385, -93.211189>,
				< 75.472765, -62.833622, -90.637118>
			}
			triangle {
				< 67.772798, -69.740385, -93.211189>,
				< 80.395065, -56.480836, -117.504574>,
				< 75.472765, -62.833622, -90.637118>
			}
			triangle {
				< 67.772798, -69.740385, -93.211189>,
				< 73.262878, -62.654704, -123.177715>,
				< 80.395065, -56.480836, -117.504574>
			}
			triangle {
				< 73.262878, -62.654704, -123.177715>,
				< 84.521197, -46.845060, -141.329348>,
				< 80.395065, -56.480836, -117.504574>
			}
			triangle {
				< 73.262878, -62.654704, -123.177715>,
				< 77.865019, -51.907379, -149.750933>,
				< 84.521197, -46.845060, -141.329348>
			}
			triangle {
				< 77.865019, -51.907379, -149.750933>,
				< 87.570041, -34.582943, -160.488069>,
				< 84.521197, -46.845060, -141.329348>
			}
			triangle {
				< 77.865019, -51.907379, -149.750933>,
				< 81.265531, -38.230859, -171.119407>,
				< 87.570041, -34.582943, -160.488069>
			}
			triangle {
				< 81.265531, -38.230859, -171.119407>,
				< 89.333802, -20.530296, -173.674956>,
				< 87.570041, -34.582943, -160.488069>
			}
			triangle {
				< 81.265531, -38.230859, -171.119407>,
				< 83.232731, -22.557100, -185.827449>,
				< 89.333802, -20.530296, -173.674956>
			}
			triangle {
				< 83.232731, -22.557100, -185.827449>,
				< 89.692250, -5.644631, -179.991409>,
				< 89.333802, -20.530296, -173.674956>
			}
			triangle {
				< 83.232731, -22.557100, -185.827449>,
				< 83.632521, -5.954278, -192.872718>,
				< 89.692250, -5.644631, -179.991409>
			}
			triangle {
				< 83.632521, -5.954278, -192.872718>,
				< 88.620946, 9.059505, -179.006994>,
				< 89.692250, -5.644631, -179.991409>
			}
			triangle {
				< 83.632521, -5.954278, -192.872718>,
				< 82.437724, 10.445834, -191.774502>,
				< 88.620946, 9.059505, -179.006994>
			}
			triangle {
				< 82.437724, 10.445834, -191.774502>,
				< 86.193010, 22.580074, -170.788571>,
				< 88.620946, 9.059505, -179.006994>
			}
			triangle {
				< 82.437724, 10.445834, -191.774502>,
				< 79.729684, 25.526438, -182.608590>,
				< 86.193010, 22.580074, -170.788571>
			}
			triangle {
				< 79.729684, 25.526438, -182.608590>,
				< 82.573831, 33.995923, -155.896783>,
				< 86.193010, 22.580074, -170.788571>
			}
			triangle {
				< 79.729684, 25.526438, -182.608590>,
				< 75.692974, 38.259000, -165.998727>,
				< 82.573831, 33.995923, -155.896783>
			}
			triangle {
				< 75.692974, 38.259000, -165.998727>,
				< 78.010008, 42.528775, -135.345951>,
				< 82.573831, 33.995923, -155.896783>
			}
			triangle {
				< 75.692974, 38.259000, -165.998727>,
				< 70.602730, 47.776099, -143.077388>,
				< 78.010008, 42.528775, -135.345951>
			}
			triangle {
				< 70.602730, 47.776099, -143.077388>,
				< 72.812617, 47.596958, -110.536739>,
				< 78.010008, 42.528775, -135.345951>
			}
			triangle {
				< 70.602730, 47.776099, -143.077388>,
				< 64.805754, 53.429261, -115.406156>,
				< 72.812617, 47.596958, -110.536739>
			}
			triangle {
				< 64.805754, 53.429261, -115.406156>,
				< 67.335784, 48.855875, -83.159767>,
				< 72.812617, 47.596958, -110.536739>
			}
			triangle {
				< 64.805754, 53.429261, -115.406156>,
				< 58.697190, 54.833118, -84.871180>,
				< 67.335784, 48.855875, -83.159767>
			}
			triangle {
				< 58.697190, 54.833118, -84.871180>,
				< 61.952826, 46.218716, -55.080470>,
				< 67.335784, 48.855875, -83.159767>
			}
			triangle {
				< 58.697190, 54.833118, -84.871180>,
				< 52.693263, 51.891848, -53.552900>,
				< 61.952826, 46.218716, -55.080470>
			}
			triangle {
				< 52.693263, 51.891848, -53.552900>,
				< 57.030533, 39.865877, -28.213158>,
				< 61.952826, 46.218716, -55.080470>
			}
			triangle {
				< 52.693263, 51.891848, -53.552900>,
				< 47.203165, 44.806093, -23.586286>,
				< 57.030533, 39.865877, -28.213158>
			}
			triangle {
				< 47.203165, 44.806093, -23.586286>,
				< 52.904382, 30.230062, -4.388380>,
				< 57.030533, 39.865877, -28.213158>
			}
			triangle {
				< 47.203165, 44.806093, -23.586286>,
				< 42.601034, 34.058738, 2.986887>,
				< 52.904382, 30.230062, -4.388380>
			}
			triangle {
				< 42.601034, 34.058738, 2.986887>,
				< 49.855534, 17.967928, 14.770415>,
				< 52.904382, 30.230062, -4.388380>
			}
			triangle {
				< 42.601034, 34.058738, 2.986887>,
				< 39.200488, 20.382131, 24.355713>,
				< 49.855534, 17.967928, 14.770415>
			}
			triangle {
				< 49.855534, 17.967928, 14.770415>,
				< 59.157580, 2.202181, 9.906483>,
				< 60.597681, 13.675975, -0.860591>
			}
			triangle {
				< 49.855534, 17.967928, 14.770415>,
				< 48.091795, 3.915382, 27.957290>,
				< 59.157580, 2.202181, 9.906483>
			}
			triangle {
				< 48.091795, 3.915382, 27.957290>,
				< 58.864892, -9.951962, 15.063850>,
				< 59.157580, 2.202181, 9.906483>
			}
			triangle {
				< 48.091795, 3.915382, 27.957290>,
				< 47.733348, -10.970239, 34.273785>,
				< 58.864892, -9.951962, 15.063850>
			}
			triangle {
				< 47.733348, -10.970239, 34.273785>,
				< 59.739590, -21.957891, 14.260066>,
				< 58.864892, -9.951962, 15.063850>
			}
			triangle {
				< 47.733348, -10.970239, 34.273785>,
				< 48.804607, -25.674475, 33.289317>,
				< 59.739590, -21.957891, 14.260066>
			}
			triangle {
				< 48.804607, -25.674475, 33.289317>,
				< 61.722022, -32.997448, 7.549889>,
				< 59.739590, -21.957891, 14.260066>
			}
			triangle {
				< 48.804607, -25.674475, 33.289317>,
				< 51.232569, -39.195124, 25.071053>,
				< 61.722022, -32.997448, 7.549889>
			}
			triangle {
				< 51.232569, -39.195124, 25.071053>,
				< 64.677104, -42.318344, -4.609373>,
				< 61.722022, -32.997448, 7.549889>
			}
			triangle {
				< 51.232569, -39.195124, 25.071053>,
				< 54.851785, -50.610829, 10.179070>,
				< 64.677104, -42.318344, -4.609373>
			}
			triangle {
				< 54.851785, -50.610829, 10.179070>,
				< 68.403438, -49.285389, -21.389112>,
				< 64.677104, -42.318344, -4.609373>
			}
			triangle {
				< 54.851785, -50.610829, 10.179070>,
				< 59.415612, -59.143852, -10.371831>,
				< 68.403438, -49.285389, -21.389112>
			}
			triangle {
				< 59.415612, -59.143852, -10.371831>,
				< 72.647110, -53.423718, -41.645788>,
				< 68.403438, -49.285389, -21.389112>
			}
			triangle {
				< 59.415612, -59.143852, -10.371831>,
				< 64.613029, -64.212263, -35.181016>,
				< 72.647110, -53.423718, -41.645788>
			}
			triangle {
				< 64.613029, -64.212263, -35.181016>,
				< 77.118888, -54.451305, -63.999310>,
				< 72.647110, -53.423718, -41.645788>
			}
			triangle {
				< 64.613029, -64.212263, -35.181016>,
				< 70.089810, -65.470628, -62.558323>,
				< 77.118888, -54.451305, -63.999310>
			}
			triangle {
				< 70.089810, -65.470628, -62.558323>,
				< 81.514068, -52.298266, -86.925581>,
				< 77.118888, -54.451305, -63.999310>
			}
			triangle {
				< 70.089810, -65.470628, -62.558323>,
				< 75.472765, -62.833622, -90.637118>,
				< 81.514068, -52.298266, -86.925581>
			}
			triangle {
				< 75.472765, -62.833622, -90.637118>,
				< 85.533090, -47.111191, -108.862668>,
				< 81.514068, -52.298266, -86.925581>
			}
			triangle {
				< 75.472765, -62.833622, -90.637118>,
				< 80.395065, -56.480836, -117.504574>,
				< 85.533090, -47.111191, -108.862668>
			}
			triangle {
				< 80.395065, -56.480836, -117.504574>,
				< 88.902064, -39.243545, -128.315553>,
				< 85.533090, -47.111191, -108.862668>
			}
			triangle {
				< 80.395065, -56.480836, -117.504574>,
				< 84.521197, -46.845060, -141.329348>,
				< 88.902064, -39.243545, -128.315553>
			}
			triangle {
				< 84.521197, -46.845060, -141.329348>,
				< 91.391459, -29.231615, -143.958583>,
				< 88.902064, -39.243545, -128.315553>
			}
			triangle {
				< 84.521197, -46.845060, -141.329348>,
				< 87.570041, -34.582943, -160.488069>,
				< 91.391459, -29.231615, -143.958583>
			}
			triangle {
				< 87.570041, -34.582943, -160.488069>,
				< 92.831567, -17.757637, -154.725730>,
				< 91.391459, -29.231615, -143.958583>
			}
			triangle {
				< 87.570041, -34.582943, -160.488069>,
				< 89.333802, -20.530296, -173.674956>,
				< 92.831567, -17.757637, -154.725730>
			}
			triangle {
				< 89.333802, -20.530296, -173.674956>,
				< 93.124196, -5.603576, -159.883022>,
				< 92.831567, -17.757637, -154.725730>
			}
			triangle {
				< 89.333802, -20.530296, -173.674956>,
				< 89.692250, -5.644631, -179.991409>,
				< 93.124196, -5.603576, -159.883022>
			}
			triangle {
				< 89.692250, -5.644631, -179.991409>,
				< 92.249542, 6.402354, -159.078956>,
				< 93.124196, -5.603576, -159.883022>
			}
			triangle {
				< 89.692250, -5.644631, -179.991409>,
				< 88.620946, 9.059505, -179.006994>,
				< 92.249542, 6.402354, -159.078956>
			}
			triangle {
				< 88.620946, 9.059505, -179.006994>,
				< 90.267107, 17.441941, -152.369052>,
				< 92.249542, 6.402354, -159.078956>
			}
			triangle {
				< 88.620946, 9.059505, -179.006994>,
				< 86.193010, 22.580074, -170.788571>,
				< 90.267107, 17.441941, -152.369052>
			}
			triangle {
				< 86.193010, 22.580074, -170.788571>,
				< 87.312005, 26.762748, -140.209898>,
				< 90.267107, 17.441941, -152.369052>
			}
			triangle {
				< 86.193010, 22.580074, -170.788571>,
				< 82.573831, 33.995923, -155.896783>,
				< 87.312005, 26.762748, -140.209898>
			}
			triangle {
				< 82.573831, 33.995923, -155.896783>,
				< 83.585709, 33.729777, -123.430088>,
				< 87.312005, 26.762748, -140.209898>
			}
			triangle {
				< 82.573831, 33.995923, -155.896783>,
				< 78.010008, 42.528775, -135.345951>,
				< 83.585709, 33.729777, -123.430088>
			}
			triangle {
				< 78.010008, 42.528775, -135.345951>,
				< 79.342030, 37.868187, -103.173412>,
				< 83.585709, 33.729777, -123.430088>
			}
			triangle {
				< 78.010008, 42.528775, -135.345951>,
				< 72.812617, 47.596958, -110.536739>,
				< 79.342030, 37.868187, -103.173412>
			}
			triangle {
				< 72.812617, 47.596958, -110.536739>,
				< 74.870244, 38.895600, -80.820352>,
				< 79.342030, 37.868187, -103.173412>
			}
			triangle {
				< 72.812617, 47.596958, -110.536739>,
				< 67.335784, 48.855875, -83.159767>,
				< 74.870244, 38.895600, -80.820352>
			}
			triangle {
				< 67.335784, 48.855875, -83.159767>,
				< 70.475064, 36.742765, -57.893954>,
				< 74.870244, 38.895600, -80.820352>
			}
			triangle {
				< 67.335784, 48.855875, -83.159767>,
				< 61.952826, 46.218716, -55.080470>,
				< 70.475064, 36.742765, -57.893954>
			}
			triangle {
				< 61.952826, 46.218716, -55.080470>,
				< 66.456035, 31.555586, -35.956539>,
				< 70.475064, 36.742765, -57.893954>
			}
			triangle {
				< 61.952826, 46.218716, -55.080470>,
				< 57.030533, 39.865877, -28.213158>,
				< 66.456035, 31.555586, -35.956539>
			}
			triangle {
				< 57.030533, 39.865877, -28.213158>,
				< 63.087046, 23.688009, -16.503584>,
				< 66.456035, 31.555586, -35.956539>
			}
			triangle {
				< 57.030533, 39.865877, -28.213158>,
				< 52.904382, 30.230062, -4.388380>,
				< 63.087046, 23.688009, -16.503584>
			}
			triangle {
				< 52.904382, 30.230062, -4.388380>,
				< 60.597681, 13.675975, -0.860591>,
				< 63.087046, 23.688009, -16.503584>
			}
			triangle {
				< 52.904382, 30.230062, -4.388380>,
				< 49.855534, 17.967928, 14.770415>,
				< 60.597681, 13.675975, -0.860591>
			}
			triangle {
				< 60.597681, 13.675975, -0.860591>,
				< 69.676504, -0.314428, -13.858565>,
				< 70.694819, 7.798889, -21.472007>
			}
			triangle {
				< 60.597681, 13.675975, -0.860591>,
				< 59.157580, 2.202181, 9.906483>,
				< 69.676504, -0.314428, -13.858565>
			}
			triangle {
				< 59.157580, 2.202181, 9.906483>,
				< 69.469564, -8.908675, -10.211790>,
				< 69.676504, -0.314428, -13.858565>
			}
			triangle {
				< 59.157580, 2.202181, 9.906483>,
				< 58.864892, -9.951962, 15.063850>,
				< 69.469564, -8.908675, -10.211790>
			}
			triangle {
				< 58.864892, -9.951962, 15.063850>,
				< 70.088051, -17.398119, -10.780111>,
				< 69.469564, -8.908675, -10.211790>
			}
			triangle {
				< 58.864892, -9.951962, 15.063850>,
				< 59.739590, -21.957891, 14.260066>,
				< 70.088051, -17.398119, -10.780111>
			}
			triangle {
				< 59.739590, -21.957891, 14.260066>,
				< 71.489848, -25.204336, -15.524914>,
				< 70.088051, -17.398119, -10.780111>
			}
			triangle {
				< 59.739590, -21.957891, 14.260066>,
				< 61.722022, -32.997448, 7.549889>,
				< 71.489848, -25.204336, -15.524914>
			}
			triangle {
				< 61.722022, -32.997448, 7.549889>,
				< 73.579401, -31.795215, -24.122866>,
				< 71.489848, -25.204336, -15.524914>
			}
			triangle {
				< 61.722022, -32.997448, 7.549889>,
				< 64.677104, -42.318344, -4.609373>,
				< 73.579401, -31.795215, -24.122866>
			}
			triangle {
				< 64.677104, -42.318344, -4.609373>,
				< 76.214291, -36.721572, -35.987906>,
				< 73.579401, -31.795215, -24.122866>
			}
			triangle {
				< 64.677104, -42.318344, -4.609373>,
				< 68.403438, -49.285389, -21.389112>,
				< 76.214291, -36.721572, -35.987906>
			}
			triangle {
				< 68.403438, -49.285389, -21.389112>,
				< 79.215050, -39.647840, -50.311524>,
				< 76.214291, -36.721572, -35.987906>
			}
			triangle {
				< 68.403438, -49.285389, -21.389112>,
				< 72.647110, -53.423718, -41.645788>,
				< 79.215050, -39.647840, -50.311524>
			}
			triangle {
				< 72.647110, -53.423718, -41.645788>,
				< 82.377084, -40.374514, -66.117935>,
				< 79.215050, -39.647840, -50.311524>
			}
			triangle {
				< 72.647110, -53.423718, -41.645788>,
				< 77.118888, -54.451305, -63.999310>,
				< 82.377084, -40.374514, -66.117935>
			}
			triangle {
				< 77.118888, -54.451305, -63.999310>,
				< 85.484937, -38.852040, -82.329370>,
				< 82.377084, -40.374514, -66.117935>
			}
			triangle {
				< 77.118888, -54.451305, -63.999310>,
				< 81.514068, -52.298266, -86.925581>,
				< 85.484937, -38.852040, -82.329370>
			}
			triangle {
				< 81.514068, -52.298266, -86.925581>,
				< 88.326812, -35.184223, -97.841188>,
				< 85.484937, -38.852040, -82.329370>
			}
			triangle {
				< 81.514068, -52.298266, -86.925581>,
				< 85.533090, -47.111191, -108.862668>,
				< 88.326812, -35.184223, -97.841188>
			}
			triangle {
				< 85.533090, -47.111191, -108.862668>,
				< 90.709053, -29.620979, -111.596443>,
				< 88.326812, -35.184223, -97.841188>
			}
			triangle {
				< 85.533090, -47.111191, -108.862668>,
				< 88.902064, -39.243545, -128.315553>,
				< 90.709053, -29.620979, -111.596443>
			}
			triangle {
				< 88.902064, -39.243545, -128.315553>,
				< 92.469297, -22.541488, -122.657761>,
				< 90.709053, -29.620979, -111.596443>
			}
			triangle {
				< 88.902064, -39.243545, -128.315553>,
				< 91.391459, -29.231615, -143.958583>,
				< 92.469297, -22.541488, -122.657761>
			}
			triangle {
				< 91.391459, -29.231615, -143.958583>,
				< 93.487553, -14.428173, -130.271181>,
				< 92.469297, -22.541488, -122.657761>
			}
			triangle {
				< 91.391459, -29.231615, -143.958583>,
				< 92.831567, -17.757637, -154.725730>,
				< 93.487553, -14.428173, -130.271181>
			}
			triangle {
				< 92.831567, -17.757637, -154.725730>,
				< 93.694523, -5.833906, -133.918002>,
				< 93.487553, -14.428173, -130.271181>
			}
			triangle {
				< 92.831567, -17.757637, -154.725730>,
				< 93.124196, -5.603576, -159.883022>,
				< 93.694523, -5.833906, -133.918002>
			}
			triangle {
				< 93.124196, -5.603576, -159.883022>,
				< 93.076043, 2.655559, -133.349553>,
				< 93.694523, -5.833906, -133.918002>
			}
			triangle {
				< 93.124196, -5.603576, -159.883022>,
				< 92.249542, 6.402354, -159.078956>,
				< 93.076043, 2.655559, -133.349553>
			}
			triangle {
				< 92.249542, 6.402354, -159.078956>,
				< 91.674268, 10.461506, -128.604859>,
				< 93.076043, 2.655559, -133.349553>
			}
			triangle {
				< 92.249542, 6.402354, -159.078956>,
				< 90.267107, 17.441941, -152.369052>,
				< 91.674268, 10.461506, -128.604859>
			}
			triangle {
				< 90.267107, 17.441941, -152.369052>,
				< 89.584708, 17.052492, -120.006926>,
				< 91.674268, 10.461506, -128.604859>
			}
			triangle {
				< 90.267107, 17.441941, -152.369052>,
				< 87.312005, 26.762748, -140.209898>,
				< 89.584708, 17.052492, -120.006926>
			}
			triangle {
				< 87.312005, 26.762748, -140.209898>,
				< 86.949795, 21.978868, -108.141929>,
				< 89.584708, 17.052492, -120.006926>
			}
			triangle {
				< 87.312005, 26.762748, -140.209898>,
				< 83.585709, 33.729777, -123.430088>,
				< 86.949795, 21.978868, -108.141929>
			}
			triangle {
				< 83.585709, 33.729777, -123.430088>,
				< 83.949082, 24.905045, -93.818262>,
				< 86.949795, 21.978868, -108.141929>
			}
			triangle {
				< 83.585709, 33.729777, -123.430088>,
				< 79.342030, 37.868187, -103.173412>,
				< 83.949082, 24.905045, -93.818262>
			}
			triangle {
				< 79.342030, 37.868187, -103.173412>,
				< 80.787033, 25.631929, -78.012168>,
				< 83.949082, 24.905045, -93.818262>
			}
			triangle {
				< 79.342030, 37.868187, -103.173412>,
				< 74.870244, 38.895600, -80.820352>,
				< 80.787033, 25.631929, -78.012168>
			}
			triangle {
				< 74.870244, 38.895600, -80.820352>,
				< 77.679195, 24.109405, -61.800856>,
				< 80.787033, 25.631929, -78.012168>
			}
			triangle {
				< 74.870244, 38.895600, -80.820352>,
				< 70.475064, 36.742765, -57.893954>,
				< 77.679195, 24.109405, -61.800856>
			}
			triangle {
				< 70.475064, 36.742765, -57.893954>,
				< 74.837282, 20.441493, -46.288583>,
				< 77.679195, 24.109405, -61.800856>
			}
			triangle {
				< 70.475064, 36.742765, -57.893954>,
				< 66.456035, 31.555586, -35.956539>,
				< 74.837282, 20.441493, -46.288583>
			}
			triangle {
				< 66.456035, 31.555586, -35.956539>,
				< 72.455063, 14.878262, -32.533366>,
				< 74.837282, 20.441493, -46.288583>
			}
			triangle {
				< 66.456035, 31.555586, -35.956539>,
				< 63.087046, 23.688009, -16.503584>,
				< 72.455063, 14.878262, -32.533366>
			}
			triangle {
				< 63.087046, 23.688009, -16.503584>,
				< 70.694819, 7.798889, -21.472007>,
				< 72.455063, 14.878262, -32.533366>
			}
			triangle {
				< 63.087046, 23.688009, -16.503584>,
				< 60.597681, 13.675975, -0.860591>,
				< 70.694819, 7.798889, -21.472007>
			}
			triangle {
				< 70.694819, 7.798889, -21.472007>,
				< 78.931712, -3.462902, -41.718256>,
				< 79.458833, 0.736851, -45.659292>
			}
			triangle {
				< 70.694819, 7.798889, -21.472007>,
				< 69.676504, -0.314428, -13.858565>,
				< 78.931712, -3.462902, -41.718256>
			}
			triangle {
				< 69.676504, -0.314428, -13.858565>,
				< 78.824595, -7.911620, -39.830536>,
				< 78.931712, -3.462902, -41.718256>
			}
			triangle {
				< 69.676504, -0.314428, -13.858565>,
				< 69.469564, -8.908675, -10.211790>,
				< 78.824595, -7.911620, -39.830536>
			}
			triangle {
				< 69.469564, -8.908675, -10.211790>,
				< 79.144739, -12.306071, -40.124740>,
				< 78.824595, -7.911620, -39.830536>
			}
			triangle {
				< 69.469564, -8.908675, -10.211790>,
				< 70.088051, -17.398119, -10.780111>,
				< 79.144739, -12.306071, -40.124740>
			}
			triangle {
				< 70.088051, -17.398119, -10.780111>,
				< 79.870366, -16.346840, -42.580880>,
				< 79.144739, -12.306071, -40.124740>
			}
			triangle {
				< 70.088051, -17.398119, -10.780111>,
				< 71.489848, -25.204336, -15.524914>,
				< 79.870366, -16.346840, -42.580880>
			}
			triangle {
				< 71.489848, -25.204336, -15.524914>,
				< 80.951996, -19.758478, -47.031458>,
				< 79.870366, -16.346840, -42.580880>
			}
			triangle {
				< 71.489848, -25.204336, -15.524914>,
				< 73.579401, -31.795215, -24.122866>,
				< 80.951996, -19.758478, -47.031458>
			}
			triangle {
				< 73.579401, -31.795215, -24.122866>,
				< 82.315944, -22.308674, -53.173274>,
				< 80.951996, -19.758478, -47.031458>
			}
			triangle {
				< 73.579401, -31.795215, -24.122866>,
				< 76.214291, -36.721572, -35.987906>,
				< 82.315944, -22.308674, -53.173274>
			}
			triangle {
				< 76.214291, -36.721572, -35.987906>,
				< 83.869234, -23.823386, -60.588062>,
				< 82.315944, -22.308674, -53.173274>
			}
			triangle {
				< 76.214291, -36.721572, -35.987906>,
				< 79.215050, -39.647840, -50.311524>,
				< 83.869234, -23.823386, -60.588062>
			}
			triangle {
				< 79.215050, -39.647840, -50.311524>,
				< 85.506015, -24.199517, -68.769887>,
				< 83.869234, -23.823386, -60.588062>
			}
			triangle {
				< 79.215050, -39.647840, -50.311524>,
				< 82.377084, -40.374514, -66.117935>,
				< 85.506015, -24.199517, -68.769887>
			}
			triangle {
				< 82.377084, -40.374514, -66.117935>,
				< 87.114789, -23.411443, -77.161491>,
				< 85.506015, -24.199517, -68.769887>
			}
			triangle {
				< 82.377084, -40.374514, -66.117935>,
				< 85.484937, -38.852040, -82.329370>,
				< 87.114789, -23.411443, -77.161491>
			}
			triangle {
				< 85.484937, -38.852040, -82.329370>,
				< 88.585816, -21.512842, -85.191011>,
				< 87.114789, -23.411443, -77.161491>
			}
			triangle {
				< 85.484937, -38.852040, -82.329370>,
				< 88.326812, -35.184223, -97.841188>,
				< 88.585816, -21.512842, -85.191011>
			}
			triangle {
				< 88.326812, -35.184223, -97.841188>,
				< 89.818954, -18.633099, -92.311315>,
				< 88.585816, -21.512842, -85.191011>
			}
			triangle {
				< 88.326812, -35.184223, -97.841188>,
				< 90.709053, -29.620979, -111.596443>,
				< 89.818954, -18.633099, -92.311315>
			}
			triangle {
				< 90.709053, -29.620979, -111.596443>,
				< 90.730153, -14.968460, -98.037049>,
				< 89.818954, -18.633099, -92.311315>
			}
			triangle {
				< 90.709053, -29.620979, -111.596443>,
				< 92.469297, -22.541488, -122.657761>,
				< 90.730153, -14.968460, -98.037049>
			}
			triangle {
				< 92.469297, -22.541488, -122.657761>,
				< 91.257244, -10.768728, -101.978064>,
				< 90.730153, -14.968460, -98.037049>
			}
			triangle {
				< 92.469297, -22.541488, -122.657761>,
				< 93.487553, -14.428173, -130.271181>,
				< 91.257244, -10.768728, -101.978064>
			}
			triangle {
				< 93.487553, -14.428173, -130.271181>,
				< 91.364391, -6.319991, -103.865884>,
				< 91.257244, -10.768728, -101.978064>
			}
			triangle {
				< 93.487553, -14.428173, -130.271181>,
				< 93.694523, -5.833906, -133.918002>,
				< 91.364391, -6.319991, -103.865884>
			}
			triangle {
				< 93.694523, -5.833906, -133.918002>,
				< 91.044225, -1.925497, -103.571638>,
				< 91.364391, -6.319991, -103.865884>
			}
			triangle {
				< 93.694523, -5.833906, -133.918002>,
				< 93.076043, 2.655559, -133.349553>,
				< 91.044225, -1.925497, -103.571638>
			}
			triangle {
				< 93.076043, 2.655559, -133.349553>,
				< 90.318598, 2.115271, -101.115458>,
				< 91.044225, -1.925497, -103.571638>
			}
			triangle {
				< 93.076043, 2.655559, -133.349553>,
				< 91.674268, 10.461506, -128.604859>,
				< 90.318598, 2.115271, -101.115458>
			}
			triangle {
				< 91.674268, 10.461506, -128.604859>,
				< 89.236975, 5.526995, -96.664958>,
				< 90.318598, 2.115271, -101.115458>
			}
			triangle {
				< 91.674268, 10.461506, -128.604859>,
				< 89.584708, 17.052492, -120.006926>,
				< 89.236975, 5.526995, -96.664958>
			}
			triangle {
				< 89.584708, 17.052492, -120.006926>,
				< 87.873042, 8.077024, -90.523086>,
				< 89.236975, 5.526995, -96.664958>
			}
			triangle {
				< 89.584708, 17.052492, -120.006926>,
				< 86.949795, 21.978868, -108.141929>,
				< 87.873042, 8.077024, -90.523086>
			}
			triangle {
				< 86.949795, 21.978868, -108.141929>,
				< 86.319752, 9.591780, -83.108701>,
				< 87.873042, 8.077024, -90.523086>
			}
			triangle {
				< 86.949795, 21.978868, -108.141929>,
				< 83.949082, 24.905045, -93.818262>,
				< 86.319752, 9.591780, -83.108701>
			}
			triangle {
				< 83.949082, 24.905045, -93.818262>,
				< 84.682956, 9.967637, -74.926801>,
				< 86.319752, 9.591780, -83.108701>
			}
			triangle {
				< 83.949082, 24.905045, -93.818262>,
				< 80.787033, 25.631929, -78.012168>,
				< 84.682956, 9.967637, -74.926801>
			}
			triangle {
				< 80.787033, 25.631929, -78.012168>,
				< 83.074205, 9.179835, -66.535160>,
				< 84.682956, 9.967637, -74.926801>
			}
			triangle {
				< 80.787033, 25.631929, -78.012168>,
				< 77.679195, 24.109405, -61.800856>,
				< 83.074205, 9.179835, -66.535160>
			}
			triangle {
				< 77.679195, 24.109405, -61.800856>,
				< 81.603132, 7.281273, -58.505628>,
				< 83.074205, 9.179835, -66.535160>
			}
			triangle {
				< 77.679195, 24.109405, -61.800856>,
				< 74.837282, 20.441493, -46.288583>,
				< 81.603132, 7.281273, -58.505628>
			}
			triangle {
				< 74.837282, 20.441493, -46.288583>,
				< 80.370016, 4.401534, -51.385082>,
				< 81.603132, 7.281273, -58.505628>
			}
			triangle {
				< 74.837282, 20.441493, -46.288583>,
				< 72.455063, 14.878262, -32.533366>,
				< 80.370016, 4.401534, -51.385082>
			}
			triangle {
				< 72.455063, 14.878262, -32.533366>,
				< 79.458833, 0.736851, -45.659292>,
				< 80.370016, 4.401534, -51.385082>
			}
			triangle {
				< 72.455063, 14.878262, -32.533366>,
				< 70.694819, 7.798889, -21.472007>,
				< 79.458833, 0.736851, -45.659292>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 81.603132, 7.281273, -58.505628>,
				< 80.370016, 4.401534, -51.385082>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 83.074205, 9.179835, -66.535160>,
				< 81.603132, 7.281273, -58.505628>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 84.682956, 9.967637, -74.926801>,
				< 83.074205, 9.179835, -66.535160>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 86.319752, 9.591780, -83.108701>,
				< 84.682956, 9.967637, -74.926801>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 87.873042, 8.077024, -90.523086>,
				< 86.319752, 9.591780, -83.108701>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 89.236975, 5.526995, -96.664958>,
				< 87.873042, 8.077024, -90.523086>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 90.318598, 2.115271, -101.115458>,
				< 89.236975, 5.526995, -96.664958>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 91.044225, -1.925497, -103.571638>,
				< 90.318598, 2.115271, -101.115458>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 91.364391, -6.319991, -103.865884>,
				< 91.044225, -1.925497, -103.571638>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 91.257244, -10.768728, -101.978064>,
				< 91.364391, -6.319991, -103.865884>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 90.730153, -14.968460, -98.037049>,
				< 91.257244, -10.768728, -101.978064>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 89.818954, -18.633099, -92.311315>,
				< 90.730153, -14.968460, -98.037049>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 88.585816, -21.512842, -85.191011>,
				< 89.818954, -18.633099, -92.311315>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 87.114789, -23.411443, -77.161491>,
				< 88.585816, -21.512842, -85.191011>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 85.506015, -24.199517, -68.769887>,
				< 87.114789, -23.411443, -77.161491>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 83.869234, -23.823386, -60.588062>,
				< 85.506015, -24.199517, -68.769887>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 82.315944, -22.308674, -53.173274>,
				< 83.869234, -23.823386, -60.588062>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 80.951996, -19.758478, -47.031458>,
				< 82.315944, -22.308674, -53.173274>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 79.870366, -16.346840, -42.580880>,
				< 80.951996, -19.758478, -47.031458>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 79.144739, -12.306071, -40.124740>,
				< 79.870366, -16.346840, -42.580880>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 78.824595, -7.911620, -39.830536>,
				< 79.144739, -12.306071, -40.124740>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 78.931712, -3.462902, -41.718256>,
				< 78.824595, -7.911620, -39.830536>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 79.458833, 0.736851, -45.659292>,
				< 78.931712, -3.462902, -41.718256>
			}
			triangle {
				< 86.292490, -7.028642, -71.774431>,
				< 80.370016, 4.401534, -51.385082>,
				< 79.458833, 0.736851, -45.659292>
			}
			
		}
		// _Thigh03
		union {
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 37.142590, -51.247198, -37.041668>,
				< 36.137439, -50.846703, -33.290364>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 38.143307, -50.729375, -40.776372>,
				< 37.142590, -51.247198, -37.041668>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 39.071381, -49.328588, -44.239979>,
				< 38.143307, -50.729375, -40.776372>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 39.863572, -47.140241, -47.196470>,
				< 39.071381, -49.328588, -44.239979>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 40.465888, -44.313483, -49.444325>,
				< 39.863572, -47.140241, -47.196470>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 40.837273, -41.040991, -50.830405>,
				< 40.465888, -44.313483, -49.444325>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 40.952444, -37.545729, -51.260214>,
				< 40.837273, -41.040991, -50.830405>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 40.803522, -34.065928, -50.704464>,
				< 40.952444, -37.545729, -51.260214>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 40.400688, -30.838698, -49.201056>,
				< 40.803522, -34.065928, -50.704464>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 39.771374, -28.084012, -46.852410>,
				< 40.400688, -30.838698, -49.201056>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 38.958479, -25.989549, -43.818597>,
				< 39.771374, -28.084012, -46.852410>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 38.017388, -24.698084, -40.306374>,
				< 38.958479, -25.989549, -43.818597>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 37.012216, -24.297589, -36.555085>,
				< 38.017388, -24.698084, -40.306374>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 36.011517, -24.815414, -32.820385>,
				< 37.012216, -24.297589, -36.555085>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 35.083424, -26.216215, -29.356778>,
				< 36.011517, -24.815414, -32.820385>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 34.291256, -28.404571, -26.400309>,
				< 35.083424, -26.216215, -29.356778>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 33.688918, -31.231284, -24.152432>,
				< 34.291256, -28.404571, -26.400309>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 33.317532, -34.503818, -22.766352>,
				< 33.688918, -31.231284, -24.152432>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 33.202361, -37.999060, -22.336518>,
				< 33.317532, -34.503818, -22.766352>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 33.351261, -41.478880, -22.892291>,
				< 33.202361, -37.999060, -22.336518>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 33.754095, -44.706091, -24.395680>,
				< 33.351261, -41.478880, -22.892291>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 34.383431, -47.460821, -26.744345>,
				< 33.754095, -44.706091, -24.395680>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 35.196345, -49.555238, -29.778162>,
				< 34.383431, -47.460821, -26.744345>
			}
			triangle {
				< 35.987254, -37.772395, -37.090469>,
				< 36.137439, -50.846703, -33.290364>,
				< 35.196345, -49.555238, -29.778162>
			}
			triangle {
				< 36.137439, -50.846703, -33.290364>,
				< 40.399510, -63.803725, -36.411941>,
				< 38.457699, -63.030072, -29.165018>
			}
			triangle {
				< 36.137439, -50.846703, -33.290364>,
				< 37.142590, -51.247198, -37.041668>,
				< 40.399510, -63.803725, -36.411941>
			}
			triangle {
				< 37.142590, -51.247198, -37.041668>,
				< 42.332754, -62.803380, -43.626856>,
				< 40.399510, -63.803725, -36.411941>
			}
			triangle {
				< 37.142590, -51.247198, -37.041668>,
				< 38.143307, -50.729375, -40.776372>,
				< 42.332754, -62.803380, -43.626856>
			}
			triangle {
				< 38.143307, -50.729375, -40.776372>,
				< 44.125643, -60.097225, -50.318029>,
				< 42.332754, -62.803380, -43.626856>
			}
			triangle {
				< 38.143307, -50.729375, -40.776372>,
				< 39.071381, -49.328588, -44.239979>,
				< 44.125643, -60.097225, -50.318029>
			}
			triangle {
				< 39.071381, -49.328588, -44.239979>,
				< 45.656048, -55.869676, -56.029532>,
				< 44.125643, -60.097225, -50.318029>
			}
			triangle {
				< 39.071381, -49.328588, -44.239979>,
				< 39.863572, -47.140241, -47.196470>,
				< 45.656048, -55.869676, -56.029532>
			}
			triangle {
				< 39.863572, -47.140241, -47.196470>,
				< 46.819624, -50.408818, -60.372040>,
				< 45.656048, -55.869676, -56.029532>
			}
			triangle {
				< 39.863572, -47.140241, -47.196470>,
				< 40.465888, -44.313483, -49.444325>,
				< 46.819624, -50.408818, -60.372040>
			}
			triangle {
				< 40.465888, -44.313483, -49.444325>,
				< 47.537118, -44.086818, -63.049749>,
				< 46.819624, -50.408818, -60.372040>
			}
			triangle {
				< 40.465888, -44.313483, -49.444325>,
				< 40.837273, -41.040991, -50.830405>,
				< 47.537118, -44.086818, -63.049749>
			}
			triangle {
				< 40.837273, -41.040991, -50.830405>,
				< 47.759604, -37.334487, -63.880138>,
				< 47.537118, -44.086818, -63.049749>
			}
			triangle {
				< 40.837273, -41.040991, -50.830405>,
				< 40.952444, -37.545729, -51.260214>,
				< 47.759604, -37.334487, -63.880138>
			}
			triangle {
				< 40.952444, -37.545729, -51.260214>,
				< 47.471918, -30.612033, -62.806480>,
				< 47.759604, -37.334487, -63.880138>
			}
			triangle {
				< 40.952444, -37.545729, -51.260214>,
				< 40.803522, -34.065928, -50.704464>,
				< 47.471918, -30.612033, -62.806480>
			}
			triangle {
				< 40.803522, -34.065928, -50.704464>,
				< 46.693705, -24.377508, -59.902102>,
				< 47.471918, -30.612033, -62.806480>
			}
			triangle {
				< 40.803522, -34.065928, -50.704464>,
				< 40.400688, -30.838698, -49.201056>,
				< 46.693705, -24.377508, -59.902102>
			}
			triangle {
				< 40.400688, -30.838698, -49.201056>,
				< 45.477953, -19.055832, -55.364896>,
				< 46.693705, -24.377508, -59.902102>
			}
			triangle {
				< 40.400688, -30.838698, -49.201056>,
				< 39.771374, -28.084012, -46.852410>,
				< 45.477953, -19.055832, -55.364896>
			}
			triangle {
				< 39.771374, -28.084012, -46.852410>,
				< 43.907549, -15.009682, -49.504012>,
				< 45.477953, -19.055832, -55.364896>
			}
			triangle {
				< 39.771374, -28.084012, -46.852410>,
				< 38.958479, -25.989549, -43.818597>,
				< 43.907549, -15.009682, -49.504012>
			}
			triangle {
				< 38.958479, -25.989549, -43.818597>,
				< 42.089481, -12.514745, -42.718910>,
				< 43.907549, -15.009682, -49.504012>
			}
			triangle {
				< 38.958479, -25.989549, -43.818597>,
				< 38.017388, -24.698084, -40.306374>,
				< 42.089481, -12.514745, -42.718910>
			}
			triangle {
				< 38.017388, -24.698084, -40.306374>,
				< 40.147670, -11.741084, -35.471987>,
				< 42.089481, -12.514745, -42.718910>
			}
			triangle {
				< 38.017388, -24.698084, -40.306374>,
				< 37.012216, -24.297589, -36.555085>,
				< 40.147670, -11.741084, -35.471987>
			}
			triangle {
				< 37.012216, -24.297589, -36.555085>,
				< 38.214449, -12.741432, -28.257092>,
				< 40.147670, -11.741084, -35.471987>
			}
			triangle {
				< 37.012216, -24.297589, -36.555085>,
				< 36.011517, -24.815414, -32.820385>,
				< 38.214449, -12.741432, -28.257092>
			}
			triangle {
				< 36.011517, -24.815414, -32.820385>,
				< 36.421537, -15.447589, -21.565881>,
				< 38.214449, -12.741432, -28.257092>
			}
			triangle {
				< 36.011517, -24.815414, -32.820385>,
				< 35.083424, -26.216215, -29.356778>,
				< 36.421537, -15.447589, -21.565881>
			}
			triangle {
				< 35.083424, -26.216215, -29.356778>,
				< 34.891147, -19.675126, -15.854394>,
				< 36.421537, -15.447589, -21.565881>
			}
			triangle {
				< 35.083424, -26.216215, -29.356778>,
				< 34.291256, -28.404571, -26.400309>,
				< 34.891147, -19.675126, -15.854394>
			}
			triangle {
				< 34.291256, -28.404571, -26.400309>,
				< 33.727553, -25.135972, -11.511846>,
				< 34.891147, -19.675126, -15.854394>
			}
			triangle {
				< 34.291256, -28.404571, -26.400309>,
				< 33.688918, -31.231284, -24.152432>,
				< 33.727553, -25.135972, -11.511846>
			}
			triangle {
				< 33.688918, -31.231284, -24.152432>,
				< 33.010062, -31.457972, -8.834157>,
				< 33.727553, -25.135972, -11.511846>
			}
			triangle {
				< 33.688918, -31.231284, -24.152432>,
				< 33.317532, -34.503818, -22.766352>,
				< 33.010062, -31.457972, -8.834157>
			}
			triangle {
				< 33.317532, -34.503818, -22.766352>,
				< 32.787576, -38.210280, -8.003829>,
				< 33.010062, -31.457972, -8.834157>
			}
			triangle {
				< 33.317532, -34.503818, -22.766352>,
				< 33.202361, -37.999060, -22.336518>,
				< 32.787576, -38.210280, -8.003829>
			}
			triangle {
				< 33.202361, -37.999060, -22.336518>,
				< 33.075258, -44.932757, -9.077447>,
				< 32.787576, -38.210280, -8.003829>
			}
			triangle {
				< 33.202361, -37.999060, -22.336518>,
				< 33.351261, -41.478880, -22.892291>,
				< 33.075258, -44.932757, -9.077447>
			}
			triangle {
				< 33.351261, -41.478880, -22.892291>,
				< 33.853475, -51.167283, -11.981823>,
				< 33.075258, -44.932757, -9.077447>
			}
			triangle {
				< 33.351261, -41.478880, -22.892291>,
				< 33.754095, -44.706091, -24.395680>,
				< 33.853475, -51.167283, -11.981823>
			}
			triangle {
				< 33.754095, -44.706091, -24.395680>,
				< 35.069220, -56.488968, -16.519051>,
				< 33.853475, -51.167283, -11.981823>
			}
			triangle {
				< 33.754095, -44.706091, -24.395680>,
				< 34.383431, -47.460821, -26.744345>,
				< 35.069220, -56.488968, -16.519051>
			}
			triangle {
				< 34.383431, -47.460821, -26.744345>,
				< 36.639631, -60.535129, -22.379914>,
				< 35.069220, -56.488968, -16.519051>
			}
			triangle {
				< 34.383431, -47.460821, -26.744345>,
				< 35.196345, -49.555238, -29.778162>,
				< 36.639631, -60.535129, -22.379914>
			}
			triangle {
				< 35.196345, -49.555238, -29.778162>,
				< 38.457699, -63.030072, -29.165018>,
				< 36.639631, -60.535129, -22.379914>
			}
			triangle {
				< 35.196345, -49.555238, -29.778162>,
				< 36.137439, -50.846703, -33.290364>,
				< 38.457699, -63.030072, -29.165018>
			}
			triangle {
				< 38.457699, -63.030072, -29.165018>,
				< 45.536067, -74.586250, -35.244264>,
				< 42.789932, -73.492140, -24.995575>
			}
			triangle {
				< 38.457699, -63.030072, -29.165018>,
				< 40.399510, -63.803725, -36.411941>,
				< 45.536067, -74.586250, -35.244264>
			}
			triangle {
				< 40.399510, -63.803725, -36.411941>,
				< 48.270077, -73.171563, -45.447700>,
				< 45.536067, -74.586250, -35.244264>
			}
			triangle {
				< 40.399510, -63.803725, -36.411941>,
				< 42.332754, -62.803380, -43.626856>,
				< 48.270077, -73.171563, -45.447700>
			}
			triangle {
				< 42.332754, -62.803380, -43.626856>,
				< 50.805610, -69.345050, -54.910429>,
				< 48.270077, -73.171563, -45.447700>
			}
			triangle {
				< 42.332754, -62.803380, -43.626856>,
				< 44.125643, -60.097225, -50.318029>,
				< 50.805610, -69.345050, -54.910429>
			}
			triangle {
				< 44.125643, -60.097225, -50.318029>,
				< 52.969929, -63.366383, -62.987715>,
				< 50.805610, -69.345050, -54.910429>
			}
			triangle {
				< 44.125643, -60.097225, -50.318029>,
				< 45.656048, -55.869676, -56.029532>,
				< 52.969929, -63.366383, -62.987715>
			}
			triangle {
				< 45.656048, -55.869676, -56.029532>,
				< 54.615531, -55.643011, -69.128975>,
				< 52.969929, -63.366383, -62.987715>
			}
			triangle {
				< 45.656048, -55.869676, -56.029532>,
				< 46.819624, -50.408818, -60.372040>,
				< 54.615531, -55.643011, -69.128975>
			}
			triangle {
				< 46.819624, -50.408818, -60.372040>,
				< 55.630207, -46.702333, -72.915792>,
				< 54.615531, -55.643011, -69.128975>
			}
			triangle {
				< 46.819624, -50.408818, -60.372040>,
				< 47.537118, -44.086818, -63.049749>,
				< 55.630207, -46.702333, -72.915792>
			}
			triangle {
				< 47.537118, -44.086818, -63.049749>,
				< 55.944864, -37.153125, -74.090071>,
				< 55.630207, -46.702333, -72.915792>
			}
			triangle {
				< 47.537118, -44.086818, -63.049749>,
				< 47.759604, -37.334487, -63.880138>,
				< 55.944864, -37.153125, -74.090071>
			}
			triangle {
				< 47.759604, -37.334487, -63.880138>,
				< 55.538032, -27.646106, -72.571777>,
				< 55.944864, -37.153125, -74.090071>
			}
			triangle {
				< 47.759604, -37.334487, -63.880138>,
				< 47.471918, -30.612033, -62.806480>,
				< 55.538032, -27.646106, -72.571777>
			}
			triangle {
				< 47.471918, -30.612033, -62.806480>,
				< 54.437459, -18.829163, -68.464339>,
				< 55.538032, -27.646106, -72.571777>
			}
			triangle {
				< 47.471918, -30.612033, -62.806480>,
				< 46.693705, -24.377508, -59.902102>,
				< 54.437459, -18.829163, -68.464339>
			}
			triangle {
				< 46.693705, -24.377508, -59.902102>,
				< 52.718088, -11.303198, -62.047768>,
				< 54.437459, -18.829163, -68.464339>
			}
			triangle {
				< 46.693705, -24.377508, -59.902102>,
				< 45.477953, -19.055832, -55.364896>,
				< 52.718088, -11.303198, -62.047768>
			}
			triangle {
				< 45.477953, -19.055832, -55.364896>,
				< 50.497163, -5.581050, -53.759232>,
				< 52.718088, -11.303198, -62.047768>
			}
			triangle {
				< 45.477953, -19.055832, -55.364896>,
				< 43.907549, -15.009682, -49.504012>,
				< 50.497163, -5.581050, -53.759232>
			}
			triangle {
				< 43.907549, -15.009682, -49.504012>,
				< 47.926039, -2.052702, -44.163663>,
				< 50.497163, -5.581050, -53.759232>
			}
			triangle {
				< 43.907549, -15.009682, -49.504012>,
				< 42.089481, -12.514745, -42.718910>,
				< 47.926039, -2.052702, -44.163663>
			}
			triangle {
				< 42.089481, -12.514745, -42.718910>,
				< 45.179900, -0.958586, -33.914976>,
				< 47.926039, -2.052702, -44.163663>
			}
			triangle {
				< 42.089481, -12.514745, -42.718910>,
				< 40.147670, -11.741084, -35.471987>,
				< 45.179900, -0.958586, -33.914976>
			}
			triangle {
				< 40.147670, -11.741084, -35.471987>,
				< 42.445920, -2.373259, -23.711542>,
				< 45.179900, -0.958586, -33.914976>
			}
			triangle {
				< 40.147670, -11.741084, -35.471987>,
				< 38.214449, -12.741432, -28.257092>,
				< 42.445920, -2.373259, -23.711542>
			}
			triangle {
				< 38.214449, -12.741432, -28.257092>,
				< 39.910357, -6.200322, -14.248771>,
				< 42.445920, -2.373259, -23.711542>
			}
			triangle {
				< 38.214449, -12.741432, -28.257092>,
				< 36.421537, -15.447589, -21.565881>,
				< 39.910357, -6.200322, -14.248771>
			}
			triangle {
				< 36.421537, -15.447589, -21.565881>,
				< 37.746064, -12.178971, -6.171519>,
				< 39.910357, -6.200322, -14.248771>
			}
			triangle {
				< 36.421537, -15.447589, -21.565881>,
				< 34.891147, -19.675126, -15.854394>,
				< 37.746064, -12.178971, -6.171519>
			}
			triangle {
				< 34.891147, -19.675126, -15.854394>,
				< 36.100481, -19.901766, -0.030201>,
				< 37.746064, -12.178971, -6.171519>
			}
			triangle {
				< 34.891147, -19.675126, -15.854394>,
				< 33.727553, -25.135972, -11.511846>,
				< 36.100481, -19.901766, -0.030201>
			}
			triangle {
				< 33.727553, -25.135972, -11.511846>,
				< 35.085827, -28.842457, 3.756614>,
				< 36.100481, -19.901766, -0.030201>
			}
			triangle {
				< 33.727553, -25.135972, -11.511846>,
				< 33.010062, -31.457972, -8.834157>,
				< 35.085827, -28.842457, 3.756614>
			}
			triangle {
				< 33.010062, -31.457972, -8.834157>,
				< 34.771170, -38.391668, 4.930874>,
				< 35.085827, -28.842457, 3.756614>
			}
			triangle {
				< 33.010062, -31.457972, -8.834157>,
				< 32.787576, -38.210280, -8.003829>,
				< 34.771170, -38.391668, 4.930874>
			}
			triangle {
				< 32.787576, -38.210280, -8.003829>,
				< 35.178002, -47.898684, 3.412578>,
				< 34.771170, -38.391668, 4.930874>
			}
			triangle {
				< 32.787576, -38.210280, -8.003829>,
				< 33.075258, -44.932757, -9.077447>,
				< 35.178002, -47.898684, 3.412578>
			}
			triangle {
				< 33.075258, -44.932757, -9.077447>,
				< 36.278576, -56.715634, -0.694856>,
				< 35.178002, -47.898684, 3.412578>
			}
			triangle {
				< 33.075258, -44.932757, -9.077447>,
				< 33.853475, -51.167283, -11.981823>,
				< 36.278576, -56.715634, -0.694856>
			}
			triangle {
				< 33.853475, -51.167283, -11.981823>,
				< 37.997905, -64.241640, -7.111453>,
				< 36.278576, -56.715634, -0.694856>
			}
			triangle {
				< 33.853475, -51.167283, -11.981823>,
				< 35.069220, -56.488968, -16.519051>,
				< 37.997905, -64.241640, -7.111453>
			}
			triangle {
				< 35.069220, -56.488968, -16.519051>,
				< 40.218808, -69.963790, -15.399986>,
				< 37.997905, -64.241640, -7.111453>
			}
			triangle {
				< 35.069220, -56.488968, -16.519051>,
				< 36.639631, -60.535129, -22.379914>,
				< 40.218808, -69.963790, -15.399986>
			}
			triangle {
				< 36.639631, -60.535129, -22.379914>,
				< 42.789932, -73.492140, -24.995575>,
				< 40.218808, -69.963790, -15.399986>
			}
			triangle {
				< 36.639631, -60.535129, -22.379914>,
				< 38.457699, -63.030072, -29.165018>,
				< 42.789932, -73.492140, -24.995575>
			}
			triangle {
				< 42.789932, -73.492140, -24.995575>,
				< 52.202210, -82.860492, -33.618186>,
				< 48.838895, -81.520505, -21.066129>
			}
			triangle {
				< 42.789932, -73.492140, -24.995575>,
				< 45.536067, -74.586250, -35.244264>,
				< 52.202210, -82.860492, -33.618186>
			}
			triangle {
				< 45.536067, -74.586250, -35.244264>,
				< 55.550706, -81.127875, -46.114776>,
				< 52.202210, -82.860492, -33.618186>
			}
			triangle {
				< 45.536067, -74.586250, -35.244264>,
				< 48.270077, -73.171563, -45.447700>,
				< 55.550706, -81.127875, -46.114776>
			}
			triangle {
				< 48.270077, -73.171563, -45.447700>,
				< 58.656115, -76.440692, -57.704225>,
				< 55.550706, -81.127875, -46.114776>
			}
			triangle {
				< 48.270077, -73.171563, -45.447700>,
				< 50.805610, -69.345050, -54.910429>,
				< 58.656115, -76.440692, -57.704225>
			}
			triangle {
				< 50.805610, -69.345050, -54.910429>,
				< 61.306827, -69.117807, -67.596808>,
				< 58.656115, -76.440692, -57.704225>
			}
			triangle {
				< 50.805610, -69.345050, -54.910429>,
				< 52.969929, -63.366383, -62.987715>,
				< 61.306827, -69.117807, -67.596808>
			}
			triangle {
				< 52.969929, -63.366383, -62.987715>,
				< 63.322224, -59.659895, -75.118355>,
				< 61.306827, -69.117807, -67.596808>
			}
			triangle {
				< 52.969929, -63.366383, -62.987715>,
				< 54.615531, -55.643011, -69.128975>,
				< 63.322224, -59.659895, -75.118355>
			}
			triangle {
				< 54.615531, -55.643011, -69.128975>,
				< 64.564951, -48.709281, -79.756215>,
				< 63.322224, -59.659895, -75.118355>
			}
			triangle {
				< 54.615531, -55.643011, -69.128975>,
				< 55.630207, -46.702333, -72.915792>,
				< 64.564951, -48.709281, -79.756215>
			}
			triangle {
				< 55.630207, -46.702333, -72.915792>,
				< 64.950287, -37.013948, -81.194386>,
				< 64.564951, -48.709281, -79.756215>
			}
			triangle {
				< 55.630207, -46.702333, -72.915792>,
				< 55.944864, -37.153125, -74.090071>,
				< 64.950287, -37.013948, -81.194386>
			}
			triangle {
				< 55.944864, -37.153125, -74.090071>,
				< 64.452030, -25.370251, -79.334848>,
				< 64.950287, -37.013948, -81.194386>
			}
			triangle {
				< 55.944864, -37.153125, -74.090071>,
				< 55.538032, -27.646106, -72.571777>,
				< 64.452030, -25.370251, -79.334848>
			}
			triangle {
				< 55.538032, -27.646106, -72.571777>,
				< 63.104108, -14.571776, -74.304275>,
				< 64.452030, -25.370251, -79.334848>
			}
			triangle {
				< 55.538032, -27.646106, -72.571777>,
				< 54.437459, -18.829163, -68.464339>,
				< 63.104108, -14.571776, -74.304275>
			}
			triangle {
				< 54.437459, -18.829163, -68.464339>,
				< 60.998380, -5.354384, -66.445634>,
				< 63.104108, -14.571776, -74.304275>
			}
			triangle {
				< 54.437459, -18.829163, -68.464339>,
				< 52.718088, -11.303198, -62.047768>,
				< 60.998380, -5.354384, -66.445634>
			}
			triangle {
				< 52.718088, -11.303198, -62.047768>,
				< 58.278352, 1.653783, -56.294333>,
				< 60.998380, -5.354384, -66.445634>
			}
			triangle {
				< 52.718088, -11.303198, -62.047768>,
				< 50.497163, -5.581050, -53.759232>,
				< 58.278352, 1.653783, -56.294333>
			}
			triangle {
				< 50.497163, -5.581050, -53.759232>,
				< 55.129383, 5.975130, -44.542193>,
				< 58.278352, 1.653783, -56.294333>
			}
			triangle {
				< 50.497163, -5.581050, -53.759232>,
				< 47.926039, -2.052702, -44.163663>,
				< 55.129383, 5.975130, -44.542193>
			}
			triangle {
				< 47.926039, -2.052702, -44.163663>,
				< 51.766001, 7.315144, -31.990141>,
				< 55.129383, 5.975130, -44.542193>
			}
			triangle {
				< 47.926039, -2.052702, -44.163663>,
				< 45.179900, -0.958586, -33.914976>,
				< 51.766001, 7.315144, -31.990141>
			}
			triangle {
				< 45.179900, -0.958586, -33.914976>,
				< 48.417550, 5.582523, -19.493571>,
				< 51.766001, 7.315144, -31.990141>
			}
			triangle {
				< 45.179900, -0.958586, -33.914976>,
				< 42.445920, -2.373259, -23.711542>,
				< 48.417550, 5.582523, -19.493571>
			}
			triangle {
				< 42.445920, -2.373259, -23.711542>,
				< 45.312155, 0.895339, -7.904078>,
				< 48.417550, 5.582523, -19.493571>
			}
			triangle {
				< 42.445920, -2.373259, -23.711542>,
				< 39.910357, -6.200322, -14.248771>,
				< 45.312155, 0.895339, -7.904078>
			}
			triangle {
				< 39.910357, -6.200322, -14.248771>,
				< 42.661447, -6.426936, 1.988548>,
				< 45.312155, 0.895339, -7.904078>
			}
			triangle {
				< 39.910357, -6.200322, -14.248771>,
				< 37.746064, -12.178971, -6.171519>,
				< 42.661447, -6.426936, 1.988548>
			}
			triangle {
				< 37.746064, -12.178971, -6.171519>,
				< 40.646050, -15.885474, 9.510046>,
				< 42.661447, -6.426936, 1.988548>
			}
			triangle {
				< 37.746064, -12.178971, -6.171519>,
				< 36.100481, -19.901766, -0.030201>,
				< 40.646050, -15.885474, 9.510046>
			}
			triangle {
				< 36.100481, -19.901766, -0.030201>,
				< 39.403323, -26.835468, 14.147934>,
				< 40.646050, -15.885474, 9.510046>
			}
			triangle {
				< 36.100481, -19.901766, -0.030201>,
				< 35.085827, -28.842457, 3.756614>,
				< 39.403323, -26.835468, 14.147934>
			}
			triangle {
				< 35.085827, -28.842457, 3.756614>,
				< 39.017960, -38.530838, 15.586168>,
				< 39.403323, -26.835468, 14.147934>
			}
			triangle {
				< 35.085827, -28.842457, 3.756614>,
				< 34.771170, -38.391668, 4.930874>,
				< 39.017960, -38.530838, 15.586168>
			}
			triangle {
				< 34.771170, -38.391668, 4.930874>,
				< 39.516222, -50.174512, 13.726569>,
				< 39.017960, -38.530838, 15.586168>
			}
			triangle {
				< 34.771170, -38.391668, 4.930874>,
				< 35.178002, -47.898684, 3.412578>,
				< 39.516222, -50.174512, 13.726569>
			}
			triangle {
				< 35.178002, -47.898684, 3.412578>,
				< 40.864144, -60.973015, 8.696033>,
				< 39.516222, -50.174512, 13.726569>
			}
			triangle {
				< 35.178002, -47.898684, 3.412578>,
				< 36.278576, -56.715634, -0.694856>,
				< 40.864144, -60.973015, 8.696033>
			}
			triangle {
				< 36.278576, -56.715634, -0.694856>,
				< 42.969890, -70.191011, 0.837311>,
				< 40.864144, -60.973015, 8.696033>
			}
			triangle {
				< 36.278576, -56.715634, -0.694856>,
				< 37.997905, -64.241640, -7.111453>,
				< 42.969890, -70.191011, 0.837311>
			}
			triangle {
				< 37.997905, -64.241640, -7.111453>,
				< 45.689922, -77.199176, -9.314010>,
				< 42.969890, -70.191011, 0.837311>
			}
			triangle {
				< 37.997905, -64.241640, -7.111453>,
				< 40.218808, -69.963790, -15.399986>,
				< 45.689922, -77.199176, -9.314010>
			}
			triangle {
				< 40.218808, -69.963790, -15.399986>,
				< 48.838895, -81.520505, -21.066129>,
				< 45.689922, -77.199176, -9.314010>
			}
			triangle {
				< 40.218808, -69.963790, -15.399986>,
				< 42.789932, -73.492140, -24.995575>,
				< 48.838895, -81.520505, -21.066129>
			}
			triangle {
				< 48.838895, -81.520505, -21.066129>,
				< 59.943706, -88.061661, -31.644531>,
				< 56.192398, -86.566485, -17.644510>
			}
			triangle {
				< 48.838895, -81.520505, -21.066129>,
				< 52.202210, -82.860492, -33.618186>,
				< 59.943706, -88.061661, -31.644531>
			}
			triangle {
				< 52.202210, -82.860492, -33.618186>,
				< 63.678406, -86.129114, -45.582622>,
				< 59.943706, -88.061661, -31.644531>
			}
			triangle {
				< 52.202210, -82.860492, -33.618186>,
				< 55.550706, -81.127875, -46.114776>,
				< 63.678406, -86.129114, -45.582622>
			}
			triangle {
				< 55.550706, -81.127875, -46.114776>,
				< 67.142040, -80.901235, -58.509026>,
				< 63.678406, -86.129114, -45.582622>
			}
			triangle {
				< 55.550706, -81.127875, -46.114776>,
				< 58.656115, -76.440692, -57.704225>,
				< 67.142040, -80.901235, -58.509026>
			}
			triangle {
				< 58.656115, -76.440692, -57.704225>,
				< 70.098512, -72.734252, -69.542728>,
				< 67.142040, -80.901235, -58.509026>
			}
			triangle {
				< 58.656115, -76.440692, -57.704225>,
				< 61.306827, -69.117807, -67.596808>,
				< 70.098512, -72.734252, -69.542728>
			}
			triangle {
				< 61.306827, -69.117807, -67.596808>,
				< 72.346382, -62.184114, -77.931963>,
				< 70.098512, -72.734252, -69.542728>
			}
			triangle {
				< 61.306827, -69.117807, -67.596808>,
				< 63.322224, -59.659895, -75.118355>,
				< 72.346382, -62.184114, -77.931963>
			}
			triangle {
				< 63.322224, -59.659895, -75.118355>,
				< 73.732466, -49.970947, -83.104812>,
				< 72.346382, -62.184114, -77.931963>
			}
			triangle {
				< 63.322224, -59.659895, -75.118355>,
				< 64.564951, -48.709281, -79.756215>,
				< 73.732466, -49.970947, -83.104812>
			}
			triangle {
				< 64.564951, -48.709281, -79.756215>,
				< 74.162252, -36.926437, -84.708862>,
				< 73.732466, -49.970947, -83.104812>
			}
			triangle {
				< 64.564951, -48.709281, -79.756215>,
				< 64.950287, -37.013948, -81.194386>,
				< 74.162252, -36.926437, -84.708862>
			}
			triangle {
				< 64.950287, -37.013948, -81.194386>,
				< 73.606543, -23.939621, -82.634836>,
				< 74.162252, -36.926437, -84.708862>
			}
			triangle {
				< 64.950287, -37.013948, -81.194386>,
				< 64.452030, -25.370251, -79.334848>,
				< 73.606543, -23.939621, -82.634836>
			}
			triangle {
				< 64.452030, -25.370251, -79.334848>,
				< 72.103135, -11.895441, -77.024013>,
				< 73.606543, -23.939621, -82.634836>
			}
			triangle {
				< 64.452030, -25.370251, -79.334848>,
				< 63.104108, -14.571776, -74.304275>,
				< 72.103135, -11.895441, -77.024013>
			}
			triangle {
				< 63.104108, -14.571776, -74.304275>,
				< 69.754474, -1.614795, -68.258755>,
				< 72.103135, -11.895441, -77.024013>
			}
			triangle {
				< 63.104108, -14.571776, -74.304275>,
				< 60.998380, -5.354384, -66.445634>,
				< 69.754474, -1.614795, -68.258755>
			}
			triangle {
				< 60.998380, -5.354384, -66.445634>,
				< 66.720672, 6.201847, -56.936484>,
				< 69.754474, -1.614795, -68.258755>
			}
			triangle {
				< 60.998380, -5.354384, -66.445634>,
				< 58.278352, 1.653783, -56.294333>,
				< 66.720672, 6.201847, -56.936484>
			}
			triangle {
				< 58.278352, 1.653783, -56.294333>,
				< 63.208476, 11.021380, -43.828677>,
				< 66.720672, 6.201847, -56.936484>
			}
			triangle {
				< 58.278352, 1.653783, -56.294333>,
				< 55.129383, 5.975130, -44.542193>,
				< 63.208476, 11.021380, -43.828677>
			}
			triangle {
				< 55.129383, 5.975130, -44.542193>,
				< 59.457187, 12.515981, -29.828679>,
				< 63.208476, 11.021380, -43.828677>
			}
			triangle {
				< 55.129383, 5.975130, -44.542193>,
				< 51.766001, 7.315144, -31.990141>,
				< 59.457187, 12.515981, -29.828679>
			}
			triangle {
				< 51.766001, 7.315144, -31.990141>,
				< 55.722464, 10.583494, -15.890542>,
				< 59.457187, 12.515981, -29.828679>
			}
			triangle {
				< 51.766001, 7.315144, -31.990141>,
				< 48.417550, 5.582523, -19.493571>,
				< 55.722464, 10.583494, -15.890542>
			}
			triangle {
				< 48.417550, 5.582523, -19.493571>,
				< 52.258771, 5.355857, -2.964163>,
				< 55.722464, 10.583494, -15.890542>
			}
			triangle {
				< 48.417550, 5.582523, -19.493571>,
				< 45.312155, 0.895339, -7.904078>,
				< 52.258771, 5.355857, -2.964163>
			}
			triangle {
				< 45.312155, 0.895339, -7.904078>,
				< 49.302284, -2.811093, 8.069618>,
				< 52.258771, 5.355857, -2.964163>
			}
			triangle {
				< 45.312155, 0.895339, -7.904078>,
				< 42.661447, -6.426936, 1.988548>,
				< 49.302284, -2.811093, 8.069618>
			}
			triangle {
				< 42.661447, -6.426936, 1.988548>,
				< 47.054406, -13.360683, 16.458793>,
				< 49.302284, -2.811093, 8.069618>
			}
			triangle {
				< 42.661447, -6.426936, 1.988548>,
				< 40.646050, -15.885474, 9.510046>,
				< 47.054406, -13.360683, 16.458793>
			}
			triangle {
				< 40.646050, -15.885474, 9.510046>,
				< 45.668345, -25.573857, 21.631708>,
				< 47.054406, -13.360683, 16.458793>
			}
			triangle {
				< 40.646050, -15.885474, 9.510046>,
				< 39.403323, -26.835468, 14.147934>,
				< 45.668345, -25.573857, 21.631708>
			}
			triangle {
				< 39.403323, -26.835468, 14.147934>,
				< 45.238513, -38.618315, 23.235740>,
				< 45.668345, -25.573857, 21.631708>
			}
			triangle {
				< 39.403323, -26.835468, 14.147934>,
				< 39.017960, -38.530838, 15.586168>,
				< 45.238513, -38.618315, 23.235740>
			}
			triangle {
				< 39.017960, -38.530838, 15.586168>,
				< 45.794249, -51.605146, 21.161711>,
				< 45.238513, -38.618315, 23.235740>
			}
			triangle {
				< 39.017960, -38.530838, 15.586168>,
				< 39.516222, -50.174512, 13.726569>,
				< 45.794249, -51.605146, 21.161711>
			}
			triangle {
				< 39.516222, -50.174512, 13.726569>,
				< 47.297679, -63.649900, 15.550867>,
				< 45.794249, -51.605146, 21.161711>
			}
			triangle {
				< 39.516222, -50.174512, 13.726569>,
				< 40.864144, -60.973015, 8.696033>,
				< 47.297679, -63.649900, 15.550867>
			}
			triangle {
				< 40.864144, -60.973015, 8.696033>,
				< 49.646303, -73.930599, 6.785627>,
				< 47.297679, -63.649900, 15.550867>
			}
			triangle {
				< 40.864144, -60.973015, 8.696033>,
				< 42.969890, -70.191011, 0.837311>,
				< 49.646303, -73.930599, 6.785627>
			}
			triangle {
				< 42.969890, -70.191011, 0.837311>,
				< 52.680116, -81.747189, -4.536723>,
				< 49.646303, -73.930599, 6.785627>
			}
			triangle {
				< 42.969890, -70.191011, 0.837311>,
				< 45.689922, -77.199176, -9.314010>,
				< 52.680116, -81.747189, -4.536723>
			}
			triangle {
				< 45.689922, -77.199176, -9.314010>,
				< 56.192398, -86.566485, -17.644510>,
				< 52.680116, -81.747189, -4.536723>
			}
			triangle {
				< 45.689922, -77.199176, -9.314010>,
				< 48.838895, -81.520505, -21.066129>,
				< 56.192398, -86.566485, -17.644510>
			}
			triangle {
				< 56.192398, -86.566485, -17.644510>,
				< 68.232842, -89.835644, -29.457768>,
				< 64.349212, -88.288322, -14.963902>
			}
			triangle {
				< 56.192398, -86.566485, -17.644510>,
				< 59.943706, -88.061661, -31.644531>,
				< 68.232842, -89.835644, -29.457768>
			}
			triangle {
				< 59.943706, -88.061661, -31.644531>,
				< 72.099298, -87.834969, -43.887582>,
				< 68.232842, -89.835644, -29.457768>
			}
			triangle {
				< 59.943706, -88.061661, -31.644531>,
				< 63.678406, -86.129114, -45.582622>,
				< 72.099298, -87.834969, -43.887582>
			}
			triangle {
				< 63.678406, -86.129114, -45.582622>,
				< 75.685106, -82.422607, -57.269942>,
				< 72.099298, -87.834969, -43.887582>
			}
			triangle {
				< 63.678406, -86.129114, -45.582622>,
				< 67.142040, -80.901235, -58.509026>,
				< 75.685106, -82.422607, -57.269942>
			}
			triangle {
				< 67.142040, -80.901235, -58.509026>,
				< 78.745902, -73.967531, -68.692952>,
				< 75.685106, -82.422607, -57.269942>
			}
			triangle {
				< 67.142040, -80.901235, -58.509026>,
				< 70.098512, -72.734252, -69.542728>,
				< 78.745902, -73.967531, -68.692952>
			}
			triangle {
				< 70.098512, -72.734252, -69.542728>,
				< 81.073053, -63.045263, -77.378005>,
				< 78.745902, -73.967531, -68.692952>
			}
			triangle {
				< 70.098512, -72.734252, -69.542728>,
				< 72.346382, -62.184114, -77.931963>,
				< 81.073053, -63.045263, -77.378005>
			}
			triangle {
				< 72.346382, -62.184114, -77.931963>,
				< 82.508035, -50.401241, -82.733385>,
				< 81.073053, -63.045263, -77.378005>
			}
			triangle {
				< 72.346382, -62.184114, -77.931963>,
				< 73.732466, -49.970947, -83.104812>,
				< 82.508035, -50.401241, -82.733385>
			}
			triangle {
				< 73.732466, -49.970947, -83.104812>,
				< 82.952999, -36.896601, -84.394038>,
				< 82.508035, -50.401241, -82.733385>
			}
			triangle {
				< 73.732466, -49.970947, -83.104812>,
				< 74.162252, -36.926437, -84.708862>,
				< 82.952999, -36.896601, -84.394038>
			}
			triangle {
				< 74.162252, -36.926437, -84.708862>,
				< 82.377642, -23.451652, -82.246803>,
				< 82.952999, -36.896601, -84.394038>
			}
			triangle {
				< 74.162252, -36.926437, -84.708862>,
				< 73.606543, -23.939621, -82.634836>,
				< 82.377642, -23.451652, -82.246803>
			}
			triangle {
				< 73.606543, -23.939621, -82.634836>,
				< 80.821209, -10.982588, -76.438092>,
				< 82.377642, -23.451652, -82.246803>
			}
			triangle {
				< 73.606543, -23.939621, -82.634836>,
				< 72.103135, -11.895441, -77.024013>,
				< 80.821209, -10.982588, -76.438092>
			}
			triangle {
				< 72.103135, -11.895441, -77.024013>,
				< 78.389734, -0.339293, -67.363642>,
				< 80.821209, -10.982588, -76.438092>
			}
			triangle {
				< 72.103135, -11.895441, -77.024013>,
				< 69.754474, -1.614795, -68.258755>,
				< 78.389734, -0.339293, -67.363642>
			}
			triangle {
				< 69.754474, -1.614795, -68.258755>,
				< 75.248912, 7.753031, -55.641957>,
				< 78.389734, -0.339293, -67.363642>
			}
			triangle {
				< 69.754474, -1.614795, -68.258755>,
				< 66.720672, 6.201847, -56.936484>,
				< 75.248912, 7.753031, -55.641957>
			}
			triangle {
				< 66.720672, 6.201847, -56.936484>,
				< 71.612790, 12.742873, -42.071730>,
				< 75.248912, 7.753031, -55.641957>
			}
			triangle {
				< 66.720672, 6.201847, -56.936484>,
				< 63.208476, 11.021380, -43.828677>,
				< 71.612790, 12.742873, -42.071730>
			}
			triangle {
				< 63.208476, 11.021380, -43.828677>,
				< 67.729153, 14.290196, -27.577840>,
				< 71.612790, 12.742873, -42.071730>
			}
			triangle {
				< 63.208476, 11.021380, -43.828677>,
				< 59.457187, 12.515981, -29.828679>,
				< 67.729153, 14.290196, -27.577840>
			}
			triangle {
				< 59.457187, 12.515981, -29.828679>,
				< 63.862719, 12.289252, -13.148051>,
				< 67.729153, 14.290196, -27.577840>
			}
			triangle {
				< 59.457187, 12.515981, -29.828679>,
				< 55.722464, 10.583494, -15.890542>,
				< 63.862719, 12.289252, -13.148051>
			}
			triangle {
				< 55.722464, 10.583494, -15.890542>,
				< 60.276892, 6.877310, 0.234332>,
				< 63.862719, 12.289252, -13.148051>
			}
			triangle {
				< 55.722464, 10.583494, -15.890542>,
				< 52.258771, 5.355857, -2.964163>,
				< 60.276892, 6.877310, 0.234332>
			}
			triangle {
				< 52.258771, 5.355857, -2.964163>,
				< 57.216119, -1.577787, 11.657324>,
				< 60.276892, 6.877310, 0.234332>
			}
			triangle {
				< 52.258771, 5.355857, -2.964163>,
				< 49.302284, -2.811093, 8.069618>,
				< 57.216119, -1.577787, 11.657324>
			}
			triangle {
				< 49.302284, -2.811093, 8.069618>,
				< 54.888945, -12.499548, 20.342439>,
				< 57.216119, -1.577787, 11.657324>
			}
			triangle {
				< 49.302284, -2.811093, 8.069618>,
				< 47.054406, -13.360683, 16.458793>,
				< 54.888945, -12.499548, 20.342439>
			}
			triangle {
				< 47.054406, -13.360683, 16.458793>,
				< 53.453900, -25.143528, 25.697798>,
				< 54.888945, -12.499548, 20.342439>
			}
			triangle {
				< 47.054406, -13.360683, 16.458793>,
				< 45.668345, -25.573857, 21.631708>,
				< 53.453900, -25.143528, 25.697798>
			}
			triangle {
				< 45.668345, -25.573857, 21.631708>,
				< 53.008936, -38.648169, 27.358556>,
				< 53.453900, -25.143528, 25.697798>
			}
			triangle {
				< 45.668345, -25.573857, 21.631708>,
				< 45.238513, -38.618315, 23.235740>,
				< 53.008936, -38.648169, 27.358556>
			}
			triangle {
				< 45.238513, -38.618315, 23.235740>,
				< 53.584274, -52.093130, 25.211278>,
				< 53.008936, -38.648169, 27.358556>
			}
			triangle {
				< 45.238513, -38.618315, 23.235740>,
				< 45.794249, -51.605146, 21.161711>,
				< 53.584274, -52.093130, 25.211278>
			}
			triangle {
				< 45.794249, -51.605146, 21.161711>,
				< 55.140786, -64.562775, 19.402485>,
				< 53.584274, -52.093130, 25.211278>
			}
			triangle {
				< 45.794249, -51.605146, 21.161711>,
				< 47.297679, -63.649900, 15.550867>,
				< 55.140786, -64.562775, 19.402485>
			}
			triangle {
				< 47.297679, -63.649900, 15.550867>,
				< 57.572268, -75.205542, 10.328033>,
				< 55.140786, -64.562775, 19.402485>
			}
			triangle {
				< 47.297679, -63.649900, 15.550867>,
				< 49.646303, -73.930599, 6.785627>,
				< 57.572268, -75.205542, 10.328033>
			}
			triangle {
				< 49.646303, -73.930599, 6.785627>,
				< 60.713120, -83.298489, -1.393735>,
				< 57.572268, -75.205542, 10.328033>
			}
			triangle {
				< 49.646303, -73.930599, 6.785627>,
				< 52.680116, -81.747189, -4.536723>,
				< 60.713120, -83.298489, -1.393735>
			}
			triangle {
				< 52.680116, -81.747189, -4.536723>,
				< 64.349212, -88.288322, -14.963902>,
				< 60.713120, -83.298489, -1.393735>
			}
			triangle {
				< 52.680116, -81.747189, -4.536723>,
				< 56.192398, -86.566485, -17.644510>,
				< 64.349212, -88.288322, -14.963902>
			}
			triangle {
				< 64.349212, -88.288322, -14.963902>,
				< 76.504849, -88.061102, -27.206972>,
				< 72.753541, -86.566508, -13.206974>
			}
			triangle {
				< 64.349212, -88.288322, -14.963902>,
				< 68.232842, -89.835644, -29.457768>,
				< 76.504849, -88.061102, -27.206972>
			}
			triangle {
				< 68.232842, -89.835644, -29.457768>,
				< 80.239557, -86.128600, -41.145090>,
				< 76.504849, -88.061102, -27.206972>
			}
			triangle {
				< 68.232842, -89.835644, -29.457768>,
				< 72.099298, -87.834969, -43.887582>,
				< 80.239557, -86.128600, -41.145090>
			}
			triangle {
				< 72.099298, -87.834969, -43.887582>,
				< 83.703160, -80.900669, -54.071467>,
				< 80.239557, -86.128600, -41.145090>
			}
			triangle {
				< 72.099298, -87.834969, -43.887582>,
				< 75.685106, -82.422607, -57.269942>,
				< 83.703160, -80.900669, -54.071467>
			}
			triangle {
				< 75.685106, -82.422607, -57.269942>,
				< 86.659655, -72.734252, -65.105230>,
				< 83.703160, -80.900669, -54.071467>
			}
			triangle {
				< 75.685106, -82.422607, -57.269942>,
				< 78.745902, -73.967531, -68.692952>,
				< 86.659655, -72.734252, -65.105230>
			}
			triangle {
				< 78.745902, -73.967531, -68.692952>,
				< 88.907525, -62.184107, -73.494427>,
				< 86.659655, -72.734252, -65.105230>
			}
			triangle {
				< 78.745902, -73.967531, -68.692952>,
				< 81.073053, -63.045263, -77.378005>,
				< 88.907525, -62.184107, -73.494427>
			}
			triangle {
				< 81.073053, -63.045263, -77.378005>,
				< 90.293609, -49.970955, -78.667238>,
				< 88.907525, -62.184107, -73.494427>
			}
			triangle {
				< 81.073053, -63.045263, -77.378005>,
				< 82.508035, -50.401241, -82.733385>,
				< 90.293609, -49.970955, -78.667238>
			}
			triangle {
				< 82.508035, -50.401241, -82.733385>,
				< 90.723418, -36.926456, -80.271326>,
				< 90.293609, -49.970955, -78.667238>
			}
			triangle {
				< 82.508035, -50.401241, -82.733385>,
				< 82.952999, -36.896601, -84.394038>,
				< 90.723418, -36.926456, -80.271326>
			}
			triangle {
				< 82.952999, -36.896601, -84.394038>,
				< 90.167694, -23.939595, -78.197300>,
				< 90.723418, -36.926456, -80.271326>
			}
			triangle {
				< 82.952999, -36.896601, -84.394038>,
				< 82.377642, -23.451652, -82.246803>,
				< 90.167694, -23.939595, -78.197300>
			}
			triangle {
				< 82.377642, -23.451652, -82.246803>,
				< 88.664278, -11.895494, -72.586522>,
				< 90.167694, -23.939595, -78.197300>
			}
			triangle {
				< 82.377642, -23.451652, -82.246803>,
				< 80.821209, -10.982588, -76.438092>,
				< 88.664278, -11.895494, -72.586522>
			}
			triangle {
				< 80.821209, -10.982588, -76.438092>,
				< 86.315617, -1.614743, -63.821219>,
				< 88.664278, -11.895494, -72.586522>
			}
			triangle {
				< 80.821209, -10.982588, -76.438092>,
				< 78.389734, -0.339293, -67.363642>,
				< 86.315617, -1.614743, -63.821219>
			}
			triangle {
				< 78.389734, -0.339293, -67.363642>,
				< 83.281815, 6.201847, -52.498884>,
				< 86.315617, -1.614743, -63.821219>
			}
			triangle {
				< 78.389734, -0.339293, -67.363642>,
				< 75.248912, 7.753031, -55.641957>,
				< 83.281815, 6.201847, -52.498884>
			}
			triangle {
				< 75.248912, 7.753031, -55.641957>,
				< 79.769604, 11.021380, -39.391119>,
				< 83.281815, 6.201847, -52.498884>
			}
			triangle {
				< 75.248912, 7.753031, -55.641957>,
				< 71.612790, 12.742873, -42.071730>,
				< 79.769604, 11.021380, -39.391119>
			}
			triangle {
				< 71.612790, 12.742873, -42.071730>,
				< 76.018319, 12.516269, -25.391100>,
				< 79.769604, 11.021380, -39.391119>
			}
			triangle {
				< 71.612790, 12.742873, -42.071730>,
				< 67.729153, 14.290196, -27.577840>,
				< 76.018319, 12.516269, -25.391100>
			}
			triangle {
				< 67.729153, 14.290196, -27.577840>,
				< 72.283603, 10.583783, -11.452965>,
				< 76.018319, 12.516269, -25.391100>
			}
			triangle {
				< 67.729153, 14.290196, -27.577840>,
				< 63.862719, 12.289252, -13.148051>,
				< 72.283603, 10.583783, -11.452965>
			}
			triangle {
				< 63.862719, 12.289252, -13.148051>,
				< 68.819985, 5.355909, 1.473415>,
				< 72.283603, 10.583783, -11.452965>
			}
			triangle {
				< 63.862719, 12.289252, -13.148051>,
				< 60.276892, 6.877310, 0.234332>,
				< 68.819985, 5.355909, 1.473415>
			}
			triangle {
				< 60.276892, 6.877310, 0.234332>,
				< 65.863490, -2.811145, 12.507175>,
				< 68.819985, 5.355909, 1.473415>
			}
			triangle {
				< 60.276892, 6.877310, 0.234332>,
				< 57.216119, -1.577787, 11.657324>,
				< 65.863490, -2.811145, 12.507175>
			}
			triangle {
				< 57.216119, -1.577787, 11.657324>,
				< 63.615642, -13.360683, 20.896329>,
				< 65.863490, -2.811145, 12.507175>
			}
			triangle {
				< 57.216119, -1.577787, 11.657324>,
				< 54.888945, -12.499548, 20.342439>,
				< 63.615642, -13.360683, 20.896329>
			}
			triangle {
				< 54.888945, -12.499548, 20.342439>,
				< 62.229559, -25.573857, 26.069183>,
				< 63.615642, -13.360683, 20.896329>
			}
			triangle {
				< 54.888945, -12.499548, 20.342439>,
				< 53.453900, -25.143528, 25.697798>,
				< 62.229559, -25.573857, 26.069183>
			}
			triangle {
				< 53.453900, -25.143528, 25.697798>,
				< 61.799742, -38.618315, 27.673297>,
				< 62.229559, -25.573857, 26.069183>
			}
			triangle {
				< 53.453900, -25.143528, 25.697798>,
				< 53.008936, -38.648169, 27.358556>,
				< 61.799742, -38.618315, 27.673297>
			}
			triangle {
				< 53.008936, -38.648169, 27.358556>,
				< 62.355474, -51.605169, 25.599351>,
				< 61.799742, -38.618315, 27.673297>
			}
			triangle {
				< 53.008936, -38.648169, 27.358556>,
				< 53.584274, -52.093130, 25.211278>,
				< 62.355474, -51.605169, 25.599351>
			}
			triangle {
				< 53.584274, -52.093130, 25.211278>,
				< 63.858889, -63.649900, 19.988425>,
				< 62.355474, -51.605169, 25.599351>
			}
			triangle {
				< 53.584274, -52.093130, 25.211278>,
				< 55.140786, -64.562775, 19.402485>,
				< 63.858889, -63.649900, 19.988425>
			}
			triangle {
				< 55.140786, -64.562775, 19.402485>,
				< 66.207528, -73.930047, 11.223164>,
				< 63.858889, -63.649900, 19.988425>
			}
			triangle {
				< 55.140786, -64.562775, 19.402485>,
				< 57.572268, -75.205542, 10.328033>,
				< 66.207528, -73.930047, 11.223164>
			}
			triangle {
				< 57.572268, -75.205542, 10.328033>,
				< 69.241330, -81.746675, -0.099186>,
				< 66.207528, -73.930047, 11.223164>
			}
			triangle {
				< 57.572268, -75.205542, 10.328033>,
				< 60.713120, -83.298489, -1.393735>,
				< 69.241330, -81.746675, -0.099186>
			}
			triangle {
				< 60.713120, -83.298489, -1.393735>,
				< 72.753541, -86.566508, -13.206974>,
				< 69.241330, -81.746675, -0.099186>
			}
			triangle {
				< 60.713120, -83.298489, -1.393735>,
				< 64.349212, -88.288322, -14.963902>,
				< 72.753541, -86.566508, -13.206974>
			}
			triangle {
				< 72.753541, -86.566508, -13.206974>,
				< 84.195957, -82.860582, -25.045492>,
				< 80.832638, -81.520565, -12.493458>
			}
			triangle {
				< 72.753541, -86.566508, -13.206974>,
				< 76.504849, -88.061102, -27.206972>,
				< 84.195957, -82.860582, -25.045492>
			}
			triangle {
				< 76.504849, -88.061102, -27.206972>,
				< 87.544389, -81.127919, -37.542082>,
				< 84.195957, -82.860582, -25.045492>
			}
			triangle {
				< 76.504849, -88.061102, -27.206972>,
				< 80.239557, -86.128600, -41.145090>,
				< 87.544389, -81.127919, -37.542082>
			}
			triangle {
				< 80.239557, -86.128600, -41.145090>,
				< 90.649799, -76.440156, -49.131576>,
				< 87.544389, -81.127919, -37.542082>
			}
			triangle {
				< 80.239557, -86.128600, -41.145090>,
				< 83.703160, -80.900669, -54.071467>,
				< 90.649799, -76.440156, -49.131576>
			}
			triangle {
				< 83.703160, -80.900669, -54.071467>,
				< 93.300514, -69.118388, -59.024177>,
				< 90.649799, -76.440156, -49.131576>
			}
			triangle {
				< 83.703160, -80.900669, -54.071467>,
				< 86.659655, -72.734252, -65.105230>,
				< 93.300514, -69.118388, -59.024177>
			}
			triangle {
				< 86.659655, -72.734252, -65.105230>,
				< 95.315881, -59.659895, -66.545673>,
				< 93.300514, -69.118388, -59.024177>
			}
			triangle {
				< 86.659655, -72.734252, -65.105230>,
				< 88.907525, -62.184107, -73.494427>,
				< 95.315881, -59.659895, -66.545673>
			}
			triangle {
				< 88.907525, -62.184107, -73.494427>,
				< 96.558608, -48.709303, -71.183547>,
				< 95.315881, -59.659895, -66.545673>
			}
			triangle {
				< 88.907525, -62.184107, -73.494427>,
				< 90.293609, -49.970955, -78.667238>,
				< 96.558608, -48.709303, -71.183547>
			}
			triangle {
				< 90.293609, -49.970955, -78.667238>,
				< 96.943974, -37.013970, -72.621718>,
				< 96.558608, -48.709303, -71.183547>
			}
			triangle {
				< 90.293609, -49.970955, -78.667238>,
				< 90.723418, -36.926456, -80.271326>,
				< 96.943974, -37.013970, -72.621718>
			}
			triangle {
				< 90.723418, -36.926456, -80.271326>,
				< 96.445717, -25.370298, -70.762180>,
				< 96.943974, -37.013970, -72.621718>
			}
			triangle {
				< 90.723418, -36.926456, -80.271326>,
				< 90.167694, -23.939595, -78.197300>,
				< 96.445717, -25.370298, -70.762180>
			}
			triangle {
				< 90.167694, -23.939595, -78.197300>,
				< 95.097795, -14.571796, -65.731600>,
				< 96.445717, -25.370298, -70.762180>
			}
			triangle {
				< 90.167694, -23.939595, -78.197300>,
				< 88.664278, -11.895494, -72.586522>,
				< 95.097795, -14.571796, -65.731600>
			}
			triangle {
				< 88.664278, -11.895494, -72.586522>,
				< 92.992067, -5.354384, -57.872962>,
				< 95.097795, -14.571796, -65.731600>
			}
			triangle {
				< 88.664278, -11.895494, -72.586522>,
				< 86.315617, -1.614743, -63.821219>,
				< 92.992067, -5.354384, -57.872962>
			}
			triangle {
				< 86.315617, -1.614743, -63.821219>,
				< 90.272017, 1.653855, -47.721621>,
				< 92.992067, -5.354384, -57.872962>
			}
			triangle {
				< 86.315617, -1.614743, -63.821219>,
				< 83.281815, 6.201847, -52.498884>,
				< 90.272017, 1.653855, -47.721621>
			}
			triangle {
				< 83.281815, 6.201847, -52.498884>,
				< 87.123051, 5.975181, -35.969499>,
				< 90.272017, 1.653855, -47.721621>
			}
			triangle {
				< 83.281815, 6.201847, -52.498884>,
				< 79.769604, 11.021380, -39.391119>,
				< 87.123051, 5.975181, -35.969499>
			}
			triangle {
				< 79.769604, 11.021380, -39.391119>,
				< 83.759725, 7.315175, -23.417424>,
				< 87.123051, 5.975181, -35.969499>
			}
			triangle {
				< 79.769604, 11.021380, -39.391119>,
				< 76.018319, 12.516269, -25.391100>,
				< 83.759725, 7.315175, -23.417424>
			}
			triangle {
				< 76.018319, 12.516269, -25.391100>,
				< 80.411293, 5.582574, -10.920877>,
				< 83.759725, 7.315175, -23.417424>
			}
			triangle {
				< 76.018319, 12.516269, -25.391100>,
				< 72.283603, 10.583783, -11.452965>,
				< 80.411293, 5.582574, -10.920877>
			}
			triangle {
				< 72.283603, 10.583783, -11.452965>,
				< 77.305891, 0.895339, 0.668636>,
				< 80.411293, 5.582574, -10.920877>
			}
			triangle {
				< 72.283603, 10.583783, -11.452965>,
				< 68.819985, 5.355909, 1.473415>,
				< 77.305891, 0.895339, 0.668636>
			}
			triangle {
				< 68.819985, 5.355909, 1.473415>,
				< 74.655175, -6.426968, 10.561262>,
				< 77.305891, 0.895339, 0.668636>
			}
			triangle {
				< 68.819985, 5.355909, 1.473415>,
				< 65.863490, -2.811145, 12.507175>,
				< 74.655175, -6.426968, 10.561262>
			}
			triangle {
				< 65.863490, -2.811145, 12.507175>,
				< 72.639793, -15.885429, 18.082740>,
				< 74.655175, -6.426968, 10.561262>
			}
			triangle {
				< 65.863490, -2.811145, 12.507175>,
				< 63.615642, -13.360683, 20.896329>,
				< 72.639793, -15.885429, 18.082740>
			}
			triangle {
				< 63.615642, -13.360683, 20.896329>,
				< 71.397066, -26.835488, 22.720711>,
				< 72.639793, -15.885429, 18.082740>
			}
			triangle {
				< 63.615642, -13.360683, 20.896329>,
				< 62.229559, -25.573857, 26.069183>,
				< 71.397066, -26.835488, 22.720711>
			}
			triangle {
				< 62.229559, -25.573857, 26.069183>,
				< 71.011715, -38.530860, 24.158780>,
				< 71.397066, -26.835488, 22.720711>
			}
			triangle {
				< 62.229559, -25.573857, 26.069183>,
				< 61.799742, -38.618315, 27.673297>,
				< 71.011715, -38.530860, 24.158780>
			}
			triangle {
				< 61.799742, -38.618315, 27.673297>,
				< 71.509972, -50.174534, 22.299264>,
				< 71.011715, -38.530860, 24.158780>
			}
			triangle {
				< 61.799742, -38.618315, 27.673297>,
				< 62.355474, -51.605169, 25.599351>,
				< 71.509972, -50.174534, 22.299264>
			}
			triangle {
				< 62.355474, -51.605169, 25.599351>,
				< 72.857894, -60.973037, 17.268727>,
				< 71.509972, -50.174534, 22.299264>
			}
			triangle {
				< 62.355474, -51.605169, 25.599351>,
				< 63.858889, -63.649900, 19.988425>,
				< 72.857894, -60.973037, 17.268727>
			}
			triangle {
				< 63.858889, -63.649900, 19.988425>,
				< 74.963622, -70.190467, 9.410005>,
				< 72.857894, -60.973037, 17.268727>
			}
			triangle {
				< 63.858889, -63.649900, 19.988425>,
				< 66.207528, -73.930047, 11.223164>,
				< 74.963622, -70.190467, 9.410005>
			}
			triangle {
				< 66.207528, -73.930047, 11.223164>,
				< 77.683665, -77.199213, -0.741337>,
				< 74.963622, -70.190467, 9.410005>
			}
			triangle {
				< 66.207528, -73.930047, 11.223164>,
				< 69.241330, -81.746675, -0.099186>,
				< 77.683665, -77.199213, -0.741337>
			}
			triangle {
				< 69.241330, -81.746675, -0.099186>,
				< 80.832638, -81.520565, -12.493458>,
				< 77.683665, -77.199213, -0.741337>
			}
			triangle {
				< 69.241330, -81.746675, -0.099186>,
				< 72.753541, -86.566508, -13.206974>,
				< 80.832638, -81.520565, -12.493458>
			}
			triangle {
				< 80.832638, -81.520565, -12.493458>,
				< 90.782039, -74.586846, -23.120677>,
				< 88.035896, -73.492713, -12.871944>
			}
			triangle {
				< 80.832638, -81.520565, -12.493458>,
				< 84.195957, -82.860582, -25.045492>,
				< 90.782039, -74.586846, -23.120677>
			}
			triangle {
				< 84.195957, -82.860582, -25.045492>,
				< 93.516037, -73.172159, -33.324089>,
				< 90.782039, -74.586846, -23.120677>
			}
			triangle {
				< 84.195957, -82.860582, -25.045492>,
				< 87.544389, -81.127919, -37.542082>,
				< 93.516037, -73.172159, -33.324089>
			}
			triangle {
				< 87.544389, -81.127919, -37.542082>,
				< 96.051581, -69.344535, -42.786859>,
				< 93.516037, -73.172159, -33.324089>
			}
			triangle {
				< 87.544389, -81.127919, -37.542082>,
				< 90.649799, -76.440156, -49.131576>,
				< 96.051581, -69.344535, -42.786859>
			}
			triangle {
				< 90.649799, -76.440156, -49.131576>,
				< 98.215871, -63.365839, -50.864112>,
				< 96.051581, -69.344535, -42.786859>
			}
			triangle {
				< 90.649799, -76.440156, -49.131576>,
				< 93.300514, -69.118388, -59.024177>,
				< 98.215871, -63.365839, -50.864112>
			}
			triangle {
				< 93.300514, -69.118388, -59.024177>,
				< 99.861436, -55.643592, -57.005432>,
				< 98.215871, -63.365839, -50.864112>
			}
			triangle {
				< 93.300514, -69.118388, -59.024177>,
				< 95.315881, -59.659895, -66.545673>,
				< 99.861436, -55.643592, -57.005432>
			}
			triangle {
				< 95.315881, -59.659895, -66.545673>,
				< 100.876108, -46.702355, -60.792208>,
				< 99.861436, -55.643592, -57.005432>
			}
			triangle {
				< 95.315881, -59.659895, -66.545673>,
				< 96.558608, -48.709303, -71.183547>,
				< 100.876108, -46.702355, -60.792208>
			}
			triangle {
				< 96.558608, -48.709303, -71.183547>,
				< 101.190746, -37.153143, -61.966527>,
				< 100.876108, -46.702355, -60.792208>
			}
			triangle {
				< 96.558608, -48.709303, -71.183547>,
				< 96.943974, -37.013970, -72.621718>,
				< 101.190746, -37.153143, -61.966527>
			}
			triangle {
				< 96.943974, -37.013970, -72.621718>,
				< 100.783914, -27.646126, -60.448192>,
				< 101.190746, -37.153143, -61.966527>
			}
			triangle {
				< 96.943974, -37.013970, -72.621718>,
				< 96.445717, -25.370298, -70.762180>,
				< 100.783914, -27.646126, -60.448192>
			}
			triangle {
				< 96.445717, -25.370298, -70.762180>,
				< 99.683344, -18.829182, -56.340795>,
				< 100.783914, -27.646126, -60.448192>
			}
			triangle {
				< 96.445717, -25.370298, -70.762180>,
				< 95.097795, -14.571796, -65.731600>,
				< 99.683344, -18.829182, -56.340795>
			}
			triangle {
				< 95.097795, -14.571796, -65.731600>,
				< 97.964011, -11.303218, -49.924199>,
				< 99.683344, -18.829182, -56.340795>
			}
			triangle {
				< 95.097795, -14.571796, -65.731600>,
				< 92.992067, -5.354384, -57.872962>,
				< 97.964011, -11.303218, -49.924199>
			}
			triangle {
				< 92.992067, -5.354384, -57.872962>,
				< 95.743135, -5.581071, -41.635625>,
				< 97.964011, -11.303218, -49.924199>
			}
			triangle {
				< 92.992067, -5.354384, -57.872962>,
				< 90.272017, 1.653855, -47.721621>,
				< 95.743135, -5.581071, -41.635625>
			}
			triangle {
				< 90.272017, 1.653855, -47.721621>,
				< 93.171999, -2.052722, -32.040056>,
				< 95.743135, -5.581071, -41.635625>
			}
			triangle {
				< 90.272017, 1.653855, -47.721621>,
				< 87.123051, 5.975181, -35.969499>,
				< 93.171999, -2.052722, -32.040056>
			}
			triangle {
				< 87.123051, 5.975181, -35.969499>,
				< 90.425871, -0.958586, -21.791367>,
				< 93.171999, -2.052722, -32.040056>
			}
			triangle {
				< 87.123051, 5.975181, -35.969499>,
				< 83.759725, 7.315175, -23.417424>,
				< 90.425871, -0.958586, -21.791367>
			}
			triangle {
				< 83.759725, 7.315175, -23.417424>,
				< 87.691888, -2.373280, -11.587934>,
				< 90.425871, -0.958586, -21.791367>
			}
			triangle {
				< 83.759725, 7.315175, -23.417424>,
				< 80.411293, 5.582574, -10.920877>,
				< 87.691888, -2.373280, -11.587934>
			}
			triangle {
				< 80.411293, 5.582574, -10.920877>,
				< 85.156329, -6.200271, -2.125161>,
				< 87.691888, -2.373280, -11.587934>
			}
			triangle {
				< 80.411293, 5.582574, -10.920877>,
				< 77.305891, 0.895339, 0.668636>,
				< 85.156329, -6.200271, -2.125161>
			}
			triangle {
				< 77.305891, 0.895339, 0.668636>,
				< 82.992025, -12.178971, 5.952111>,
				< 85.156329, -6.200271, -2.125161>
			}
			triangle {
				< 77.305891, 0.895339, 0.668636>,
				< 74.655175, -6.426968, 10.561262>,
				< 82.992025, -12.178971, 5.952111>
			}
			triangle {
				< 74.655175, -6.426968, 10.561262>,
				< 81.346467, -19.901793, 12.093429>,
				< 82.992025, -12.178971, 5.952111>
			}
			triangle {
				< 74.655175, -6.426968, 10.561262>,
				< 72.639793, -15.885429, 18.082740>,
				< 81.346467, -19.901793, 12.093429>
			}
			triangle {
				< 72.639793, -15.885429, 18.082740>,
				< 80.331795, -28.842475, 15.880266>,
				< 81.346467, -19.901793, 12.093429>
			}
			triangle {
				< 72.639793, -15.885429, 18.082740>,
				< 71.397066, -26.835488, 22.720711>,
				< 80.331795, -28.842475, 15.880266>
			}
			triangle {
				< 71.397066, -26.835488, 22.720711>,
				< 80.017135, -38.391687, 17.054504>,
				< 80.331795, -28.842475, 15.880266>
			}
			triangle {
				< 71.397066, -26.835488, 22.720711>,
				< 71.011715, -38.530860, 24.158780>,
				< 80.017135, -38.391687, 17.054504>
			}
			triangle {
				< 71.011715, -38.530860, 24.158780>,
				< 80.423966, -47.898706, 15.536189>,
				< 80.017135, -38.391687, 17.054504>
			}
			triangle {
				< 71.011715, -38.530860, 24.158780>,
				< 71.509972, -50.174534, 22.299264>,
				< 80.423966, -47.898706, 15.536189>
			}
			triangle {
				< 71.509972, -50.174534, 22.299264>,
				< 81.524536, -56.715656, 11.428773>,
				< 80.423966, -47.898706, 15.536189>
			}
			triangle {
				< 71.509972, -50.174534, 22.299264>,
				< 72.857894, -60.973037, 17.268727>,
				< 81.524536, -56.715656, 11.428773>
			}
			triangle {
				< 72.857894, -60.973037, 17.268727>,
				< 83.243869, -64.241633, 5.012178>,
				< 81.524536, -56.715656, 11.428773>
			}
			triangle {
				< 72.857894, -60.973037, 17.268727>,
				< 74.963622, -70.190467, 9.410005>,
				< 83.243869, -64.241633, 5.012178>
			}
			triangle {
				< 74.963622, -70.190467, 9.410005>,
				< 85.464776, -69.964364, -3.276377>,
				< 83.243869, -64.241633, 5.012178>
			}
			triangle {
				< 74.963622, -70.190467, 9.410005>,
				< 77.683665, -77.199213, -0.741337>,
				< 85.464776, -69.964364, -3.276377>
			}
			triangle {
				< 77.683665, -77.199213, -0.741337>,
				< 88.035896, -73.492713, -12.871944>,
				< 85.464776, -69.964364, -3.276377>
			}
			triangle {
				< 77.683665, -77.199213, -0.741337>,
				< 80.832638, -81.520565, -12.493458>,
				< 88.035896, -73.492713, -12.871944>
			}
			triangle {
				< 88.035896, -73.492713, -12.871944>,
				< 95.814250, -63.804306, -21.563623>,
				< 93.872458, -63.030668, -14.316699>
			}
			triangle {
				< 88.035896, -73.492713, -12.871944>,
				< 90.782039, -74.586846, -23.120677>,
				< 95.814250, -63.804306, -21.563623>
			}
			triangle {
				< 90.782039, -74.586846, -23.120677>,
				< 97.747490, -62.803984, -28.778540>,
				< 95.814250, -63.804306, -21.563623>
			}
			triangle {
				< 90.782039, -74.586846, -23.120677>,
				< 93.516037, -73.172159, -33.324089>,
				< 97.747490, -62.803984, -28.778540>
			}
			triangle {
				< 93.516037, -73.172159, -33.324089>,
				< 99.540405, -60.097825, -35.469729>,
				< 97.747490, -62.803984, -28.778540>
			}
			triangle {
				< 93.516037, -73.172159, -33.324089>,
				< 96.051581, -69.344535, -42.786859>,
				< 99.540405, -60.097825, -35.469729>
			}
			triangle {
				< 96.051581, -69.344535, -42.786859>,
				< 101.070791, -55.869717, -41.181214>,
				< 99.540405, -60.097825, -35.469729>
			}
			triangle {
				< 96.051581, -69.344535, -42.786859>,
				< 98.215871, -63.365839, -50.864112>,
				< 101.070791, -55.869717, -41.181214>
			}
			triangle {
				< 98.215871, -63.365839, -50.864112>,
				< 102.234364, -50.408848, -45.523785>,
				< 101.070791, -55.869717, -41.181214>
			}
			triangle {
				< 98.215871, -63.365839, -50.864112>,
				< 99.861436, -55.643592, -57.005432>,
				< 102.234364, -50.408848, -45.523785>
			}
			triangle {
				< 99.861436, -55.643592, -57.005432>,
				< 102.951862, -44.086836, -48.201453>,
				< 102.234364, -50.408848, -45.523785>
			}
			triangle {
				< 99.861436, -55.643592, -57.005432>,
				< 100.876108, -46.702355, -60.792208>,
				< 102.951862, -44.086836, -48.201453>
			}
			triangle {
				< 100.876108, -46.702355, -60.792208>,
				< 103.174336, -37.334509, -49.031798>,
				< 102.951862, -44.086836, -48.201453>
			}
			triangle {
				< 100.876108, -46.702355, -60.792208>,
				< 101.190746, -37.153143, -61.966527>,
				< 103.174336, -37.334509, -49.031798>
			}
			triangle {
				< 101.190746, -37.153143, -61.966527>,
				< 102.886662, -30.612053, -47.958203>,
				< 103.174336, -37.334509, -49.031798>
			}
			triangle {
				< 101.190746, -37.153143, -61.966527>,
				< 100.783914, -27.646126, -60.448192>,
				< 102.886662, -30.612053, -47.958203>
			}
			triangle {
				< 100.783914, -27.646126, -60.448192>,
				< 102.108441, -24.377527, -45.053806>,
				< 102.886662, -30.612053, -47.958203>
			}
			triangle {
				< 100.783914, -27.646126, -60.448192>,
				< 99.683344, -18.829182, -56.340795>,
				< 102.108441, -24.377527, -45.053806>
			}
			triangle {
				< 99.683344, -18.829182, -56.340795>,
				< 100.892693, -19.055828, -40.516559>,
				< 102.108441, -24.377527, -45.053806>
			}
			triangle {
				< 99.683344, -18.829182, -56.340795>,
				< 97.964011, -11.303218, -49.924199>,
				< 100.892693, -19.055828, -40.516559>
			}
			triangle {
				< 97.964011, -11.303218, -49.924199>,
				< 99.322267, -15.009682, -34.655698>,
				< 100.892693, -19.055828, -40.516559>
			}
			triangle {
				< 97.964011, -11.303218, -49.924199>,
				< 95.743135, -5.581071, -41.635625>,
				< 99.322267, -15.009682, -34.655698>
			}
			triangle {
				< 95.743135, -5.581071, -41.635625>,
				< 97.504221, -12.514766, -27.870592>,
				< 99.322267, -15.009682, -34.655698>
			}
			triangle {
				< 95.743135, -5.581071, -41.635625>,
				< 93.171999, -2.052722, -32.040056>,
				< 97.504221, -12.514766, -27.870592>
			}
			triangle {
				< 93.171999, -2.052722, -32.040056>,
				< 95.562406, -11.741105, -20.623669>,
				< 97.504221, -12.514766, -27.870592>
			}
			triangle {
				< 93.171999, -2.052722, -32.040056>,
				< 90.425871, -0.958586, -21.791367>,
				< 95.562406, -11.741105, -20.623669>
			}
			triangle {
				< 90.425871, -0.958586, -21.791367>,
				< 93.629166, -12.741432, -13.408753>,
				< 95.562406, -11.741105, -20.623669>
			}
			triangle {
				< 90.425871, -0.958586, -21.791367>,
				< 87.691888, -2.373280, -11.587934>,
				< 93.629166, -12.741432, -13.408753>
			}
			triangle {
				< 87.691888, -2.373280, -11.587934>,
				< 91.836274, -15.447589, -6.717562>,
				< 93.629166, -12.741432, -13.408753>
			}
			triangle {
				< 87.691888, -2.373280, -11.587934>,
				< 85.156329, -6.200271, -2.125161>,
				< 91.836274, -15.447589, -6.717562>
			}
			triangle {
				< 85.156329, -6.200271, -2.125161>,
				< 90.305887, -19.675126, -1.006056>,
				< 91.836274, -15.447589, -6.717562>
			}
			triangle {
				< 85.156329, -6.200271, -2.125161>,
				< 82.992025, -12.178971, 5.952111>,
				< 90.305887, -19.675126, -1.006056>
			}
			triangle {
				< 82.992025, -12.178971, 5.952111>,
				< 89.142308, -25.135946, 3.336471>,
				< 90.305887, -19.675126, -1.006056>
			}
			triangle {
				< 82.992025, -12.178971, 5.952111>,
				< 81.346467, -19.901793, 12.093429>,
				< 89.142308, -25.135946, 3.336471>
			}
			triangle {
				< 81.346467, -19.901793, 12.093429>,
				< 88.424817, -31.457990, 6.014161>,
				< 89.142308, -25.135946, 3.336471>
			}
			triangle {
				< 81.346467, -19.901793, 12.093429>,
				< 80.331795, -28.842475, 15.880266>,
				< 88.424817, -31.457990, 6.014161>
			}
			triangle {
				< 80.331795, -28.842475, 15.880266>,
				< 88.202320, -38.210303, 6.844530>,
				< 88.424817, -31.457990, 6.014161>
			}
			triangle {
				< 80.331795, -28.842475, 15.880266>,
				< 80.017135, -38.391687, 17.054504>,
				< 88.202320, -38.210303, 6.844530>
			}
			triangle {
				< 80.017135, -38.391687, 17.054504>,
				< 88.489994, -44.932798, 5.770891>,
				< 88.202320, -38.210303, 6.844530>
			}
			triangle {
				< 80.017135, -38.391687, 17.054504>,
				< 80.423966, -47.898706, 15.536189>,
				< 88.489994, -44.932798, 5.770891>
			}
			triangle {
				< 80.423966, -47.898706, 15.536189>,
				< 89.268230, -51.167317, 2.866535>,
				< 88.489994, -44.932798, 5.770891>
			}
			triangle {
				< 80.423966, -47.898706, 15.536189>,
				< 81.524536, -56.715656, 11.428773>,
				< 89.268230, -51.167317, 2.866535>
			}
			triangle {
				< 81.524536, -56.715656, 11.428773>,
				< 90.483963, -56.488987, -1.670732>,
				< 89.268230, -51.167317, 2.866535>
			}
			triangle {
				< 81.524536, -56.715656, 11.428773>,
				< 83.243869, -64.241633, 5.012178>,
				< 90.483963, -56.488987, -1.670732>
			}
			triangle {
				< 83.243869, -64.241633, 5.012178>,
				< 92.054389, -60.535729, -7.531596>,
				< 90.483963, -56.488987, -1.670732>
			}
			triangle {
				< 83.243869, -64.241633, 5.012178>,
				< 85.464776, -69.964364, -3.276377>,
				< 92.054389, -60.535729, -7.531596>
			}
			triangle {
				< 85.464776, -69.964364, -3.276377>,
				< 93.872458, -63.030668, -14.316699>,
				< 92.054389, -60.535729, -7.531596>
			}
			triangle {
				< 85.464776, -69.964364, -3.276377>,
				< 88.035896, -73.492713, -12.871944>,
				< 93.872458, -63.030668, -14.316699>
			}
			triangle {
				< 93.872458, -63.030668, -14.316699>,
				< 98.949715, -51.247243, -20.480502>,
				< 97.944550, -50.846744, -16.729215>
			}
			triangle {
				< 93.872458, -63.030668, -14.316699>,
				< 95.814250, -63.804306, -21.563623>,
				< 98.949715, -51.247243, -20.480502>
			}
			triangle {
				< 95.814250, -63.804306, -21.563623>,
				< 99.950418, -50.729420, -24.215227>,
				< 98.949715, -51.247243, -20.480502>
			}
			triangle {
				< 95.814250, -63.804306, -21.563623>,
				< 97.747490, -62.803984, -28.778540>,
				< 99.950418, -50.729420, -24.215227>
			}
			triangle {
				< 97.747490, -62.803984, -28.778540>,
				< 100.878492, -49.328629, -27.678855>,
				< 99.950418, -50.729420, -24.215227>
			}
			triangle {
				< 97.747490, -62.803984, -28.778540>,
				< 99.540405, -60.097825, -35.469729>,
				< 100.878492, -49.328629, -27.678855>
			}
			triangle {
				< 99.540405, -60.097825, -35.469729>,
				< 101.670697, -47.140259, -30.635322>,
				< 100.878492, -49.328629, -27.678855>
			}
			triangle {
				< 99.540405, -60.097825, -35.469729>,
				< 101.070791, -55.869717, -41.181214>,
				< 101.670697, -47.140259, -30.635322>
			}
			triangle {
				< 101.070791, -55.869717, -41.181214>,
				< 102.273002, -44.313524, -32.883201>,
				< 101.670697, -47.140259, -30.635322>
			}
			triangle {
				< 101.070791, -55.869717, -41.181214>,
				< 102.234364, -50.408848, -45.523785>,
				< 102.273002, -44.313524, -32.883201>
			}
			triangle {
				< 102.234364, -50.408848, -45.523785>,
				< 102.644406, -41.041013, -34.269258>,
				< 102.273002, -44.313524, -32.883201>
			}
			triangle {
				< 102.234364, -50.408848, -45.523785>,
				< 102.951862, -44.086836, -48.201453>,
				< 102.644406, -41.041013, -34.269258>
			}
			triangle {
				< 102.951862, -44.086836, -48.201453>,
				< 102.759555, -37.545748, -34.699071>,
				< 102.644406, -41.041013, -34.269258>
			}
			triangle {
				< 102.951862, -44.086836, -48.201453>,
				< 103.174336, -37.334509, -49.031798>,
				< 102.759555, -37.545748, -34.699071>
			}
			triangle {
				< 103.174336, -37.334509, -49.031798>,
				< 102.610655, -34.065928, -34.143340>,
				< 102.759555, -37.545748, -34.699071>
			}
			triangle {
				< 103.174336, -37.334509, -49.031798>,
				< 102.886662, -30.612053, -47.958203>,
				< 102.610655, -34.065928, -34.143340>
			}
			triangle {
				< 102.886662, -30.612053, -47.958203>,
				< 102.207802, -30.838698, -32.639928>,
				< 102.610655, -34.065928, -34.143340>
			}
			triangle {
				< 102.886662, -30.612053, -47.958203>,
				< 102.108441, -24.377527, -45.053806>,
				< 102.207802, -30.838698, -32.639928>
			}
			triangle {
				< 102.108441, -24.377527, -45.053806>,
				< 101.578481, -28.084012, -30.291287>,
				< 102.207802, -30.838698, -32.639928>
			}
			triangle {
				< 102.108441, -24.377527, -45.053806>,
				< 100.892693, -19.055828, -40.516559>,
				< 101.578481, -28.084012, -30.291287>
			}
			triangle {
				< 100.892693, -19.055828, -40.516559>,
				< 100.765571, -25.989523, -27.257469>,
				< 101.578481, -28.084012, -30.291287>
			}
			triangle {
				< 100.892693, -19.055828, -40.516559>,
				< 99.322267, -15.009682, -34.655698>,
				< 100.765571, -25.989523, -27.257469>
			}
			triangle {
				< 99.322267, -15.009682, -34.655698>,
				< 99.824496, -24.698060, -23.745228>,
				< 100.765571, -25.989523, -27.257469>
			}
			triangle {
				< 99.322267, -15.009682, -34.655698>,
				< 97.504221, -12.514766, -27.870592>,
				< 99.824496, -24.698060, -23.745228>
			}
			triangle {
				< 97.504221, -12.514766, -27.870592>,
				< 98.819330, -24.297565, -19.993961>,
				< 99.824496, -24.698060, -23.745228>
			}
			triangle {
				< 97.504221, -12.514766, -27.870592>,
				< 95.562406, -11.741105, -20.623669>,
				< 98.819330, -24.297565, -19.993961>
			}
			triangle {
				< 95.562406, -11.741105, -20.623669>,
				< 97.818628, -24.815388, -16.259236>,
				< 98.819330, -24.297565, -19.993961>
			}
			triangle {
				< 95.562406, -11.741105, -20.623669>,
				< 93.629166, -12.741432, -13.408753>,
				< 97.818628, -24.815388, -16.259236>
			}
			triangle {
				< 93.629166, -12.741432, -13.408753>,
				< 96.890561, -26.216237, -12.795630>,
				< 97.818628, -24.815388, -16.259236>
			}
			triangle {
				< 93.629166, -12.741432, -13.408753>,
				< 91.836274, -15.447589, -6.717562>,
				< 96.890561, -26.216237, -12.795630>
			}
			triangle {
				< 91.836274, -15.447589, -6.717562>,
				< 96.098371, -28.404571, -9.839142>,
				< 96.890561, -26.216237, -12.795630>
			}
			triangle {
				< 91.836274, -15.447589, -6.717562>,
				< 90.305887, -19.675126, -1.006056>,
				< 96.098371, -28.404571, -9.839142>
			}
			triangle {
				< 90.305887, -19.675126, -1.006056>,
				< 95.496051, -31.231306, -7.591223>,
				< 96.098371, -28.404571, -9.839142>
			}
			triangle {
				< 90.305887, -19.675126, -1.006056>,
				< 89.142308, -25.135946, 3.336471>,
				< 95.496051, -31.231306, -7.591223>
			}
			triangle {
				< 89.142308, -25.135946, 3.336471>,
				< 95.124647, -34.503836, -6.205183>,
				< 95.496051, -31.231306, -7.591223>
			}
			triangle {
				< 89.142308, -25.135946, 3.336471>,
				< 88.424817, -31.457990, 6.014161>,
				< 95.124647, -34.503836, -6.205183>
			}
			triangle {
				< 88.424817, -31.457990, 6.014161>,
				< 95.009491, -37.999082, -5.775372>,
				< 95.124647, -34.503836, -6.205183>
			}
			triangle {
				< 88.424817, -31.457990, 6.014161>,
				< 88.202320, -38.210303, 6.844530>,
				< 95.009491, -37.999082, -5.775372>
			}
			triangle {
				< 88.202320, -38.210303, 6.844530>,
				< 95.158391, -41.478898, -6.331104>,
				< 95.009491, -37.999082, -5.775372>
			}
			triangle {
				< 88.202320, -38.210303, 6.844530>,
				< 88.489994, -44.932798, 5.770891>,
				< 95.158391, -41.478898, -6.331104>
			}
			triangle {
				< 88.489994, -44.932798, 5.770891>,
				< 95.561221, -44.706132, -7.834555>,
				< 95.158391, -41.478898, -6.331104>
			}
			triangle {
				< 88.489994, -44.932798, 5.770891>,
				< 89.268230, -51.167317, 2.866535>,
				< 95.561221, -44.706132, -7.834555>
			}
			triangle {
				< 89.268230, -51.167317, 2.866535>,
				< 96.190542, -47.460839, -10.183157>,
				< 95.561221, -44.706132, -7.834555>
			}
			triangle {
				< 89.268230, -51.167317, 2.866535>,
				< 90.483963, -56.488987, -1.670732>,
				< 96.190542, -47.460839, -10.183157>
			}
			triangle {
				< 90.483963, -56.488987, -1.670732>,
				< 97.003460, -49.555283, -13.216973>,
				< 96.190542, -47.460839, -10.183157>
			}
			triangle {
				< 90.483963, -56.488987, -1.670732>,
				< 92.054389, -60.535729, -7.531596>,
				< 97.003460, -49.555283, -13.216973>
			}
			triangle {
				< 92.054389, -60.535729, -7.531596>,
				< 97.944550, -50.846744, -16.729215>,
				< 97.003460, -49.555283, -13.216973>
			}
			triangle {
				< 92.054389, -60.535729, -7.531596>,
				< 93.872458, -63.030668, -14.316699>,
				< 97.944550, -50.846744, -16.729215>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 96.190542, -47.460839, -10.183157>,
				< 97.003460, -49.555283, -13.216973>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 95.561221, -44.706132, -7.834555>,
				< 96.190542, -47.460839, -10.183157>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 95.158391, -41.478898, -6.331104>,
				< 95.561221, -44.706132, -7.834555>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 95.009491, -37.999082, -5.775372>,
				< 95.158391, -41.478898, -6.331104>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 95.124647, -34.503836, -6.205183>,
				< 95.009491, -37.999082, -5.775372>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 95.496051, -31.231306, -7.591223>,
				< 95.124647, -34.503836, -6.205183>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 96.098371, -28.404571, -9.839142>,
				< 95.496051, -31.231306, -7.591223>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 96.890561, -26.216237, -12.795630>,
				< 96.098371, -28.404571, -9.839142>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 97.818628, -24.815388, -16.259236>,
				< 96.890561, -26.216237, -12.795630>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 98.819330, -24.297565, -19.993961>,
				< 97.818628, -24.815388, -16.259236>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 99.824496, -24.698060, -23.745228>,
				< 98.819330, -24.297565, -19.993961>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 100.765571, -25.989523, -27.257469>,
				< 99.824496, -24.698060, -23.745228>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 101.578481, -28.084012, -30.291287>,
				< 100.765571, -25.989523, -27.257469>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 102.207802, -30.838698, -32.639928>,
				< 101.578481, -28.084012, -30.291287>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 102.610655, -34.065928, -34.143340>,
				< 102.207802, -30.838698, -32.639928>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 102.759555, -37.545748, -34.699071>,
				< 102.610655, -34.065928, -34.143340>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 102.644406, -41.041013, -34.269258>,
				< 102.759555, -37.545748, -34.699071>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 102.273002, -44.313524, -32.883201>,
				< 102.644406, -41.041013, -34.269258>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 101.670697, -47.140259, -30.635322>,
				< 102.273002, -44.313524, -32.883201>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 100.878492, -49.328629, -27.678855>,
				< 101.670697, -47.140259, -30.635322>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 99.950418, -50.729420, -24.215227>,
				< 100.878492, -49.328629, -27.678855>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 98.949715, -51.247243, -20.480502>,
				< 99.950418, -50.729420, -24.215227>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 97.944550, -50.846744, -16.729215>,
				< 98.949715, -51.247243, -20.480502>
			}
			triangle {
				< 99.974684, -37.772417, -19.945120>,
				< 97.003460, -49.555283, -13.216973>,
				< 97.944550, -50.846744, -16.729215>
			}
			
		}
		// _Bum01
		union {
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< 6.206062, 10.942695, 17.802015>,
				< 5.228924, 7.423239, 21.378377>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< 6.836432, 14.981237, 15.452359>,
				< 6.206062, 10.942695, 17.802015>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< 7.077073, 19.271787, 14.496607>,
				< 6.836432, 14.981237, 15.452359>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< 6.911566, 23.529565, 15.009152>,
				< 7.077073, 19.271787, 14.496607>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< 6.351217, 27.469141, 16.963946>,
				< 6.911566, 23.529565, 15.009152>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< 5.434202, 30.822625, 20.233847>,
				< 6.351217, 27.469141, 16.963946>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< 4.223007, 33.357624, 24.597762>,
				< 5.434202, 30.822625, 20.233847>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< 2.800177, 34.894109, 29.755274>,
				< 4.223007, 33.357624, 24.597762>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< 1.262689, 35.318736, 35.347734>,
				< 2.800177, 34.894109, 29.755274>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< -0.284695, 34.594718, 40.984768>,
				< 1.262689, 35.318736, 35.347734>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< -1.736531, 32.766756, 46.273295>,
				< -0.284695, 34.594718, 40.984768>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< -2.993855, 29.959049, 50.846834>,
				< -1.736531, 32.766756, 46.273295>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< -3.971014, 26.367078, 54.391932>,
				< -2.993855, 29.959049, 50.846834>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< -4.601363, 22.242997, 56.670249>,
				< -3.971014, 26.367078, 54.391932>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< -4.842004, 17.876545, 57.533596>,
				< -4.601363, 22.242997, 56.670249>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< -4.676518, 13.572839, 56.932420>,
				< -4.842004, 17.876545, 57.533596>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< -4.116169, 9.629875, 54.916527>,
				< -4.676518, 13.572839, 56.932420>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< -3.199154, 6.315998, 51.629402>,
				< -4.116169, 9.629875, 54.916527>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< -1.987959, 3.853255, 47.296688>,
				< -3.199154, 6.315998, 51.629402>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< -0.565129, 2.402309, 42.210519>,
				< -1.987959, 3.853255, 47.296688>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< 0.972359, 2.053615, 36.710460>,
				< -0.565129, 2.402309, 42.210519>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< 2.519764, 2.823550, 31.162038>,
				< 0.972359, 2.053615, 36.710460>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< 3.971579, 4.655156, 25.934609>,
				< 2.519764, 2.823550, 31.162038>
			}
			triangle {
				< -0.764942, 18.670900, 35.619739>,
				< 5.228924, 7.423239, 21.378377>,
				< 3.971579, 4.655156, 25.934609>
			}
			triangle {
				< 5.228924, 7.423239, 21.378377>,
				< 16.268687, 3.730067, 2.088609>,
				< 14.427267, -3.011905, 9.031083>
			}
			triangle {
				< 5.228924, 7.423239, 21.378377>,
				< 6.206062, 10.942695, 17.802015>,
				< 16.268687, 3.730067, 2.088609>
			}
			triangle {
				< 6.206062, 10.942695, 17.802015>,
				< 17.453732, 11.460457, -2.516774>,
				< 16.268687, 3.730067, 2.088609>
			}
			triangle {
				< 6.206062, 10.942695, 17.802015>,
				< 6.836432, 14.981237, 15.452359>,
				< 17.453732, 11.460457, -2.516774>
			}
			triangle {
				< 6.836432, 14.981237, 15.452359>,
				< 17.901598, 19.684147, -4.444777>,
				< 17.453732, 11.460457, -2.516774>
			}
			triangle {
				< 6.836432, 14.981237, 15.452359>,
				< 7.077073, 19.271787, 14.496607>,
				< 17.901598, 19.684147, -4.444777>
			}
			triangle {
				< 7.077073, 19.271787, 14.496607>,
				< 17.581766, 27.868891, -3.529751>,
				< 17.901598, 19.684147, -4.444777>
			}
			triangle {
				< 7.077073, 19.271787, 14.496607>,
				< 6.911566, 23.529565, 15.009152>,
				< 17.581766, 27.868891, -3.529751>
			}
			triangle {
				< 6.911566, 23.529565, 15.009152>,
				< 16.516058, 35.475172, 0.199156>,
				< 17.581766, 27.868891, -3.529751>
			}
			triangle {
				< 6.911566, 23.529565, 15.009152>,
				< 6.351217, 27.469141, 16.963946>,
				< 16.516058, 35.475172, 0.199156>
			}
			triangle {
				< 6.351217, 27.469141, 16.963946>,
				< 14.777078, 41.987233, 6.510908>,
				< 16.516058, 35.475172, 0.199156>
			}
			triangle {
				< 6.351217, 27.469141, 16.963946>,
				< 5.434202, 30.822625, 20.233847>,
				< 14.777078, 41.987233, 6.510908>
			}
			triangle {
				< 5.434202, 30.822625, 20.233847>,
				< 12.483343, 46.947315, 14.982050>,
				< 14.777078, 41.987233, 6.510908>
			}
			triangle {
				< 5.434202, 30.822625, 20.233847>,
				< 4.223007, 33.357624, 24.597762>,
				< 12.483343, 46.947315, 14.982050>
			}
			triangle {
				< 4.223007, 33.357624, 24.597762>,
				< 9.791180, 49.990192, 25.023764>,
				< 12.483343, 46.947315, 14.982050>
			}
			triangle {
				< 4.223007, 33.357624, 24.597762>,
				< 2.800177, 34.894109, 29.755274>,
				< 9.791180, 49.990192, 25.023764>
			}
			triangle {
				< 2.800177, 34.894109, 29.755274>,
				< 6.884030, 50.875444, 35.925038>,
				< 9.791180, 49.990192, 25.023764>
			}
			triangle {
				< 2.800177, 34.894109, 29.755274>,
				< 1.262689, 35.318736, 35.347734>,
				< 6.884030, 50.875444, 35.925038>
			}
			triangle {
				< 1.262689, 35.318736, 35.347734>,
				< 3.960026, 49.513016, 46.908155>,
				< 6.884030, 50.875444, 35.925038>
			}
			triangle {
				< 1.262689, 35.318736, 35.347734>,
				< -0.284695, 34.594718, 40.984768>,
				< 3.960026, 49.513016, 46.908155>
			}
			triangle {
				< -0.284695, 34.594718, 40.984768>,
				< 1.218424, 45.977816, 57.191342>,
				< 3.960026, 49.513016, 46.908155>
			}
			triangle {
				< -0.284695, 34.594718, 40.984768>,
				< -1.736531, 32.766756, 46.273295>,
				< 1.218424, 45.977816, 57.191342>
			}
			triangle {
				< -1.736531, 32.766756, 46.273295>,
				< -1.153925, 40.509652, 66.050768>,
				< 1.218424, 45.977816, 57.191342>
			}
			triangle {
				< -1.736531, 32.766756, 46.273295>,
				< -2.993855, 29.959049, 50.846834>,
				< -1.153925, 40.509652, 66.050768>
			}
			triangle {
				< -2.993855, 29.959049, 50.846834>,
				< -2.995366, 33.497106, 72.876446>,
				< -1.153925, 40.509652, 66.050768>
			}
			triangle {
				< -2.993855, 29.959049, 50.846834>,
				< -3.971014, 26.367078, 54.391932>,
				< -2.995366, 33.497106, 72.876446>
			}
			triangle {
				< -3.971014, 26.367078, 54.391932>,
				< -4.180392, 25.446489, 77.215061>,
				< -2.995366, 33.497106, 72.876446>
			}
			triangle {
				< -3.971014, 26.367078, 54.391932>,
				< -4.601363, 22.242997, 56.670249>,
				< -4.180392, 25.446489, 77.215061>
			}
			triangle {
				< -4.601363, 22.242997, 56.670249>,
				< -4.628257, 16.939189, 78.797884>,
				< -4.180392, 25.446489, 77.215061>
			}
			triangle {
				< -4.601363, 22.242997, 56.670249>,
				< -4.842004, 17.876545, 57.533596>,
				< -4.628257, 16.939189, 78.797884>
			}
			triangle {
				< -4.842004, 17.876545, 57.533596>,
				< -4.308445, 8.583399, 77.551678>,
				< -4.628257, 16.939189, 78.797884>
			}
			triangle {
				< -4.842004, 17.876545, 57.533596>,
				< -4.676518, 13.572839, 56.932420>,
				< -4.308445, 8.583399, 77.551678>
			}
			triangle {
				< -4.676518, 13.572839, 56.932420>,
				< -3.242736, 0.963993, 73.594414>,
				< -4.308445, 8.583399, 77.551678>
			}
			triangle {
				< -4.676518, 13.572839, 56.932420>,
				< -4.116169, 9.629875, 54.916527>,
				< -3.242736, 0.963993, 73.594414>
			}
			triangle {
				< -4.116169, 9.629875, 54.916527>,
				< -1.503758, -5.399519, 67.218274>,
				< -3.242736, 0.963993, 73.594414>
			}
			triangle {
				< -4.116169, 9.629875, 54.916527>,
				< -3.199154, 6.315998, 51.629402>,
				< -1.503758, -5.399519, 67.218274>
			}
			triangle {
				< -3.199154, 6.315998, 51.629402>,
				< 0.789979, -10.089094, 58.863923>,
				< -1.503758, -5.399519, 67.218274>
			}
			triangle {
				< -3.199154, 6.315998, 51.629402>,
				< -1.987959, 3.853255, 47.296688>,
				< 0.789979, -10.089094, 58.863923>
			}
			triangle {
				< -1.987959, 3.853255, 47.296688>,
				< 3.482141, -12.812052, 49.088936>,
				< 0.789979, -10.089094, 58.863923>
			}
			triangle {
				< -1.987959, 3.853255, 47.296688>,
				< -0.565129, 2.402309, 42.210519>,
				< 3.482141, -12.812052, 49.088936>
			}
			triangle {
				< -0.565129, 2.402309, 42.210519>,
				< 6.389291, -13.413581, 38.532875>,
				< 3.482141, -12.812052, 49.088936>
			}
			triangle {
				< -0.565129, 2.402309, 42.210519>,
				< 0.972359, 2.053615, 36.710460>,
				< 6.389291, -13.413581, 38.532875>
			}
			triangle {
				< 0.972359, 2.053615, 36.710460>,
				< 9.313294, -11.879779, 27.880935>,
				< 6.389291, -13.413581, 38.532875>
			}
			triangle {
				< 0.972359, 2.053615, 36.710460>,
				< 2.519764, 2.823550, 31.162038>,
				< 9.313294, -11.879779, 27.880935>
			}
			triangle {
				< 2.519764, 2.823550, 31.162038>,
				< 12.054897, -8.331452, 17.826136>,
				< 9.313294, -11.879779, 27.880935>
			}
			triangle {
				< 2.519764, 2.823550, 31.162038>,
				< 3.971579, 4.655156, 25.934609>,
				< 12.054897, -8.331452, 17.826136>
			}
			triangle {
				< 3.971579, 4.655156, 25.934609>,
				< 14.427267, -3.011905, 9.031083>,
				< 12.054897, -8.331452, 17.826136>
			}
			triangle {
				< 3.971579, 4.655156, 25.934609>,
				< 5.228924, 7.423239, 21.378377>,
				< 14.427267, -3.011905, 9.031083>
			}
			triangle {
				< 14.427267, -3.011905, 9.031083>,
				< 28.592069, -2.450049, -10.524418>,
				< 26.091976, -11.921229, -0.659763>
			}
			triangle {
				< 14.427267, -3.011905, 9.031083>,
				< 16.268687, 3.730067, 2.088609>,
				< 28.592069, -2.450049, -10.524418>
			}
			triangle {
				< 16.268687, 3.730067, 2.088609>,
				< 30.194255, 8.401557, -17.120164>,
				< 28.592069, -2.450049, -10.524418>
			}
			triangle {
				< 16.268687, 3.730067, 2.088609>,
				< 17.453732, 11.460457, -2.516774>,
				< 30.194255, 8.401557, -17.120164>
			}
			triangle {
				< 17.453732, 11.460457, -2.516774>,
				< 30.789366, 19.955667, -19.945038>,
				< 30.194255, 8.401557, -17.120164>
			}
			triangle {
				< 17.453732, 11.460457, -2.516774>,
				< 17.901598, 19.684147, -4.444777>,
				< 30.789366, 19.955667, -19.945038>
			}
			triangle {
				< 17.901598, 19.684147, -4.444777>,
				< 30.336862, 31.482682, -18.737653>,
				< 30.789366, 19.955667, -19.945038>
			}
			triangle {
				< 17.901598, 19.684147, -4.444777>,
				< 17.581766, 27.868891, -3.529751>,
				< 30.336862, 31.482682, -18.737653>
			}
			triangle {
				< 17.581766, 27.868891, -3.529751>,
				< 28.867492, 42.233992, -13.513908>,
				< 30.336862, 31.482682, -18.737653>
			}
			triangle {
				< 17.581766, 27.868891, -3.529751>,
				< 16.516058, 35.475172, 0.199156>,
				< 28.867492, 42.233992, -13.513908>
			}
			triangle {
				< 16.516058, 35.475172, 0.199156>,
				< 26.481478, 51.483247, -4.583224>,
				< 28.867492, 42.233992, -13.513908>
			}
			triangle {
				< 16.516058, 35.475172, 0.199156>,
				< 14.777078, 41.987233, 6.510908>,
				< 26.481478, 51.483247, -4.583224>
			}
			triangle {
				< 14.777078, 41.987233, 6.510908>,
				< 23.341389, 58.572602, 7.459413>,
				< 26.481478, 51.483247, -4.583224>
			}
			triangle {
				< 14.777078, 41.987233, 6.510908>,
				< 12.483343, 46.947315, 14.982050>,
				< 23.341389, 58.572602, 7.459413>
			}
			triangle {
				< 12.483343, 46.947315, 14.982050>,
				< 19.661259, 62.964097, 21.770341>,
				< 23.341389, 58.572602, 7.459413>
			}
			triangle {
				< 12.483343, 46.947315, 14.982050>,
				< 9.791180, 49.990192, 25.023764>,
				< 19.661259, 62.964097, 21.770341>
			}
			triangle {
				< 9.791180, 49.990192, 25.023764>,
				< 15.691837, 64.291239, 37.320539>,
				< 19.661259, 62.964097, 21.770341>
			}
			triangle {
				< 9.791180, 49.990192, 25.023764>,
				< 6.884030, 50.875444, 35.925038>,
				< 15.691837, 64.291239, 37.320539>
			}
			triangle {
				< 6.884030, 50.875444, 35.925038>,
				< 11.703614, 62.402867, 52.980531>,
				< 15.691837, 64.291239, 37.320539>
			}
			triangle {
				< 6.884030, 50.875444, 35.925038>,
				< 3.960026, 49.513016, 46.908155>,
				< 11.703614, 62.402867, 52.980531>
			}
			triangle {
				< 3.960026, 49.513016, 46.908155>,
				< 7.968415, 57.391014, 67.616008>,
				< 11.703614, 62.402867, 52.980531>
			}
			triangle {
				< 3.960026, 49.513016, 46.908155>,
				< 1.218424, 45.977816, 57.191342>,
				< 7.968415, 57.391014, 67.616008>
			}
			triangle {
				< 1.218424, 45.977816, 57.191342>,
				< 4.740790, 49.595367, 80.183432>,
				< 7.968415, 57.391014, 67.616008>
			}
			triangle {
				< 1.218424, 45.977816, 57.191342>,
				< -1.153925, 40.509652, 66.050768>,
				< 4.740790, 49.595367, 80.183432>
			}
			triangle {
				< -1.153925, 40.509652, 66.050768>,
				< 2.240676, 39.580319, 89.813717>,
				< 4.740790, 49.595367, 80.183432>
			}
			triangle {
				< -1.153925, 40.509652, 66.050768>,
				< -2.995366, 33.497106, 72.876446>,
				< 2.240676, 39.580319, 89.813717>
			}
			triangle {
				< -2.995366, 33.497106, 72.876446>,
				< 0.638489, 28.086582, 95.874831>,
				< 2.240676, 39.580319, 89.813717>
			}
			triangle {
				< -2.995366, 33.497106, 72.876446>,
				< -4.180392, 25.446489, 77.215061>,
				< 0.638489, 28.086582, 95.874831>
			}
			triangle {
				< -4.180392, 25.446489, 77.215061>,
				< 0.043378, 15.963914, 98.007821>,
				< 0.638489, 28.086582, 95.874831>
			}
			triangle {
				< -4.180392, 25.446489, 77.215061>,
				< -4.628257, 16.939189, 78.797884>,
				< 0.043378, 15.963914, 98.007821>
			}
			triangle {
				< -4.628257, 16.939189, 78.797884>,
				< 0.495839, 4.094848, 96.136875>,
				< 0.043378, 15.963914, 98.007821>
			}
			triangle {
				< -4.628257, 16.939189, 78.797884>,
				< -4.308445, 8.583399, 77.551678>,
				< 0.495839, 4.094848, 96.136875>
			}
			triangle {
				< -4.308445, 8.583399, 77.551678>,
				< 1.965191, -6.681210, 90.455502>,
				< 0.495839, 4.094848, 96.136875>
			}
			triangle {
				< -4.308445, 8.583399, 77.551678>,
				< -3.242736, 0.963993, 73.594414>,
				< 1.965191, -6.681210, 90.455502>
			}
			triangle {
				< -3.242736, 0.963993, 73.594414>,
				< 4.351226, -15.630974, 81.395887>,
				< 1.965191, -6.681210, 90.455502>
			}
			triangle {
				< -3.242736, 0.963993, 73.594414>,
				< -1.503758, -5.399519, 67.218274>,
				< 4.351226, -15.630974, 81.395887>
			}
			triangle {
				< -1.503758, -5.399519, 67.218274>,
				< 7.491377, -22.176765, 69.587514>,
				< 4.351226, -15.630974, 81.395887>
			}
			triangle {
				< -1.503758, -5.399519, 67.218274>,
				< 0.789979, -10.089094, 58.863923>,
				< 7.491377, -22.176765, 69.587514>
			}
			triangle {
				< 0.789979, -10.089094, 58.863923>,
				< 11.171484, -25.926149, 55.811349>,
				< 7.491377, -22.176765, 69.587514>
			}
			triangle {
				< 0.789979, -10.089094, 58.863923>,
				< 3.482141, -12.812052, 49.088936>,
				< 11.171484, -25.926149, 55.811349>
			}
			triangle {
				< 3.482141, -12.812052, 49.088936>,
				< 15.140929, -26.684616, 40.953010>,
				< 11.171484, -25.926149, 55.811349>
			}
			triangle {
				< 3.482141, -12.812052, 49.088936>,
				< 6.389291, -13.413581, 38.532875>,
				< 15.140929, -26.684616, 40.953010>
			}
			triangle {
				< 6.389291, -13.413581, 38.532875>,
				< 19.129151, -24.453582, 25.956701>,
				< 15.140929, -26.684616, 40.953010>
			}
			triangle {
				< 6.389291, -13.413581, 38.532875>,
				< 9.313294, -11.879779, 27.880935>,
				< 19.129151, -24.453582, 25.956701>
			}
			triangle {
				< 9.313294, -11.879779, 27.880935>,
				< 22.864331, -19.417042, 11.778793>,
				< 19.129151, -24.453582, 25.956701>
			}
			triangle {
				< 9.313294, -11.879779, 27.880935>,
				< 12.054897, -8.331452, 17.826136>,
				< 22.864331, -19.417042, 11.778793>
			}
			triangle {
				< 12.054897, -8.331452, 17.826136>,
				< 26.091976, -11.921229, -0.659763>,
				< 22.864331, -19.417042, 11.778793>
			}
			triangle {
				< 12.054897, -8.331452, 17.826136>,
				< 14.427267, -3.011905, 9.031083>,
				< 26.091976, -11.921229, -0.659763>
			}
			triangle {
				< 26.091976, -11.921229, -0.659763>,
				< 42.283230, -7.151203, -19.242970>,
				< 39.387360, -18.699562, -7.108844>
			}
			triangle {
				< 26.091976, -11.921229, -0.659763>,
				< 28.592069, -2.450049, -10.524418>,
				< 42.283230, -7.151203, -19.242970>
			}
			triangle {
				< 28.592069, -2.450049, -10.524418>,
				< 44.127896, 6.069808, -27.402790>,
				< 42.283230, -7.151203, -19.242970>
			}
			triangle {
				< 28.592069, -2.450049, -10.524418>,
				< 30.194255, 8.401557, -17.120164>,
				< 44.127896, 6.069808, -27.402790>
			}
			triangle {
				< 30.194255, 8.401557, -17.120164>,
				< 44.795681, 20.154485, -30.953415>,
				< 44.127896, 6.069808, -27.402790>
			}
			triangle {
				< 30.194255, 8.401557, -17.120164>,
				< 30.789366, 19.955667, -19.945038>,
				< 44.795681, 20.154485, -30.953415>
			}
			triangle {
				< 30.789366, 19.955667, -19.945038>,
				< 44.241045, 34.229815, -29.549818>,
				< 44.795681, 20.154485, -30.953415>
			}
			triangle {
				< 30.789366, 19.955667, -19.945038>,
				< 30.336862, 31.482682, -18.737653>,
				< 44.241045, 34.229815, -29.549818>
			}
			triangle {
				< 30.336862, 31.482682, -18.737653>,
				< 42.501796, 47.393151, -23.187404>,
				< 44.241045, 34.229815, -29.549818>
			}
			triangle {
				< 30.336862, 31.482682, -18.737653>,
				< 28.867492, 42.233992, -13.513908>,
				< 42.501796, 47.393151, -23.187404>
			}
			triangle {
				< 28.867492, 42.233992, -13.513908>,
				< 39.696489, 58.757924, -12.229629>,
				< 42.501796, 47.393151, -23.187404>
			}
			triangle {
				< 28.867492, 42.233992, -13.513908>,
				< 26.481478, 51.483247, -4.583224>,
				< 39.696489, 58.757924, -12.229629>
			}
			triangle {
				< 26.481478, 51.483247, -4.583224>,
				< 36.016256, 67.508757, 2.597551>,
				< 39.696489, 58.757924, -12.229629>
			}
			triangle {
				< 26.481478, 51.483247, -4.583224>,
				< 23.341389, 58.572602, 7.459413>,
				< 36.016256, 67.508757, 2.597551>
			}
			triangle {
				< 23.341389, 58.572602, 7.459413>,
				< 31.711932, 72.966389, 20.249190>,
				< 36.016256, 67.508757, 2.597551>
			}
			triangle {
				< 23.341389, 58.572602, 7.459413>,
				< 19.661259, 62.964097, 21.770341>,
				< 31.711932, 72.966389, 20.249190>
			}
			triangle {
				< 19.661259, 62.964097, 21.770341>,
				< 27.076816, 74.656546, 39.441567>,
				< 31.711932, 72.966389, 20.249190>
			}
			triangle {
				< 19.661259, 62.964097, 21.770341>,
				< 15.691837, 64.291239, 37.320539>,
				< 27.076816, 74.656546, 39.441567>
			}
			triangle {
				< 15.691837, 64.291239, 37.320539>,
				< 22.426838, 72.371259, 58.761373>,
				< 27.076816, 74.656546, 39.441567>
			}
			triangle {
				< 15.691837, 64.291239, 37.320539>,
				< 11.703614, 62.402867, 52.980531>,
				< 22.426838, 72.371259, 58.761373>
			}
			triangle {
				< 11.703614, 62.402867, 52.980531>,
				< 18.078845, 66.210561, 76.790757>,
				< 22.426838, 72.371259, 58.761373>
			}
			triangle {
				< 11.703614, 62.402867, 52.980531>,
				< 7.968415, 57.391014, 67.616008>,
				< 18.078845, 66.210561, 76.790757>
			}
			triangle {
				< 7.968415, 57.391014, 67.616008>,
				< 14.329172, 56.591962, 92.231579>,
				< 18.078845, 66.210561, 76.790757>
			}
			triangle {
				< 7.968415, 57.391014, 67.616008>,
				< 4.740790, 49.595367, 80.183432>,
				< 14.329172, 56.591962, 92.231579>
			}
			triangle {
				< 4.740790, 49.595367, 80.183432>,
				< 11.433305, 44.222254, 104.012847>,
				< 14.329172, 56.591962, 92.231579>
			}
			triangle {
				< 4.740790, 49.595367, 80.183432>,
				< 2.240676, 39.580319, 89.813717>,
				< 11.433305, 44.222254, 104.012847>
			}
			triangle {
				< 2.240676, 39.580319, 89.813717>,
				< 9.588655, 30.033726, 111.368217>,
				< 11.433305, 44.222254, 104.012847>
			}
			triangle {
				< 2.240676, 39.580319, 89.813717>,
				< 0.638489, 28.086582, 95.874831>,
				< 9.588655, 30.033726, 111.368217>
			}
			triangle {
				< 0.638489, 28.086582, 95.874831>,
				< 8.920853, 15.094157, 113.878392>,
				< 9.588655, 30.033726, 111.368217>
			}
			triangle {
				< 0.638489, 28.086582, 95.874831>,
				< 0.043378, 15.963914, 98.007821>,
				< 8.920853, 15.094157, 113.878392>
			}
			triangle {
				< 0.043378, 15.963914, 98.007821>,
				< 9.475468, 0.506148, 111.476749>,
				< 8.920853, 15.094157, 113.878392>
			}
			triangle {
				< 0.043378, 15.963914, 98.007821>,
				< 0.495839, 4.094848, 96.136875>,
				< 9.475468, 0.506148, 111.476749>
			}
			triangle {
				< 0.495839, 4.094848, 96.136875>,
				< 11.214693, -12.691266, 104.426324>,
				< 9.475468, 0.506148, 111.476749>
			}
			triangle {
				< 0.495839, 4.094848, 96.136875>,
				< 1.965191, -6.681210, 90.455502>,
				< 11.214693, -12.691266, 104.426324>
			}
			triangle {
				< 1.965191, -6.681210, 90.455502>,
				< 14.020002, -23.602268, 93.274929>,
				< 11.214693, -12.691266, 104.426324>
			}
			triangle {
				< 1.965191, -6.681210, 90.455502>,
				< 4.351226, -15.630974, 81.395887>,
				< 14.020002, -23.602268, 93.274929>
			}
			triangle {
				< 4.351226, -15.630974, 81.395887>,
				< 17.700234, -31.532567, 78.800336>,
				< 14.020002, -23.602268, 93.274929>
			}
			triangle {
				< 4.351226, -15.630974, 81.395887>,
				< 7.491377, -22.176765, 69.587514>,
				< 17.700234, -31.532567, 78.800336>
			}
			triangle {
				< 7.491377, -22.176765, 69.587514>,
				< 22.004563, -36.022536, 61.953187>,
				< 17.700234, -31.532567, 78.800336>
			}
			triangle {
				< 7.491377, -22.176765, 69.587514>,
				< 11.171484, -25.926149, 55.811349>,
				< 22.004563, -36.022536, 61.953187>
			}
			triangle {
				< 11.171484, -25.926149, 55.811349>,
				< 26.639676, -36.857262, 43.801587>,
				< 22.004563, -36.022536, 61.953187>
			}
			triangle {
				< 11.171484, -25.926149, 55.811349>,
				< 15.140929, -26.684616, 40.953010>,
				< 26.639676, -36.857262, 43.801587>
			}
			triangle {
				< 15.140929, -26.684616, 40.953010>,
				< 31.289656, -34.058247, 25.479993>,
				< 26.639676, -36.857262, 43.801587>
			}
			triangle {
				< 15.140929, -26.684616, 40.953010>,
				< 19.129151, -24.453582, 25.956701>,
				< 31.289656, -34.058247, 25.479993>
			}
			triangle {
				< 19.129151, -24.453582, 25.956701>,
				< 35.637669, -27.863465, 8.138581>,
				< 31.289656, -34.058247, 25.479993>
			}
			triangle {
				< 19.129151, -24.453582, 25.956701>,
				< 22.864331, -19.417042, 11.778793>,
				< 35.637669, -27.863465, 8.138581>
			}
			triangle {
				< 22.864331, -19.417042, 11.778793>,
				< 39.387360, -18.699562, -7.108844>,
				< 35.637669, -27.863465, 8.138581>
			}
			triangle {
				< 22.864331, -19.417042, 11.778793>,
				< 26.091976, -11.921229, -0.659763>,
				< 39.387360, -18.699562, -7.108844>
			}
			triangle {
				< 39.387360, -18.699562, -7.108844>,
				< 56.462273, -10.034053, -23.511523>,
				< 53.448148, -22.889936, -9.928128>
			}
			triangle {
				< 39.387360, -18.699562, -7.108844>,
				< 42.283230, -7.151203, -19.242970>,
				< 56.462273, -10.034053, -23.511523>
			}
			triangle {
				< 42.283230, -7.151203, -19.242970>,
				< 58.366966, 4.672920, -32.675833>,
				< 56.462273, -10.034053, -23.511523>
			}
			triangle {
				< 42.283230, -7.151203, -19.242970>,
				< 44.127896, 6.069808, -27.402790>,
				< 58.366966, 4.672920, -32.675833>
			}
			triangle {
				< 44.127896, 6.069808, -27.402790>,
				< 59.032425, 20.343347, -36.698006>,
				< 58.366966, 4.672920, -32.675833>
			}
			triangle {
				< 44.127896, 6.069808, -27.402790>,
				< 44.795681, 20.154485, -30.953415>,
				< 59.032425, 20.343347, -36.698006>
			}
			triangle {
				< 44.795681, 20.154485, -30.953415>,
				< 58.413323, 36.017645, -35.175592>,
				< 59.032425, 20.343347, -36.698006>
			}
			triangle {
				< 44.795681, 20.154485, -30.953415>,
				< 44.241045, 34.229815, -29.549818>,
				< 58.413323, 36.017645, -35.175592>
			}
			triangle {
				< 44.241045, 34.229815, -29.549818>,
				< 56.551818, 50.698839, -28.087195>,
				< 58.413323, 36.017645, -35.175592>
			}
			triangle {
				< 44.241045, 34.229815, -29.549818>,
				< 42.501796, 47.393151, -23.187404>,
				< 56.551818, 50.698839, -28.087195>
			}
			triangle {
				< 42.501796, 47.393151, -23.187404>,
				< 53.574771, 63.400157, -15.828121>,
				< 56.551818, 50.698839, -28.087195>
			}
			triangle {
				< 42.501796, 47.393151, -23.187404>,
				< 39.696489, 58.757924, -12.229629>,
				< 53.574771, 63.400157, -15.828121>
			}
			triangle {
				< 39.696489, 58.757924, -12.229629>,
				< 49.685098, 73.205143, 0.792238>,
				< 53.574771, 63.400157, -15.828121>
			}
			triangle {
				< 39.696489, 58.757924, -12.229629>,
				< 36.016256, 67.508757, 2.597551>,
				< 49.685098, 73.205143, 0.792238>
			}
			triangle {
				< 36.016256, 67.508757, 2.597551>,
				< 45.147810, 79.341665, 20.598380>,
				< 49.685098, 73.205143, 0.792238>
			}
			triangle {
				< 36.016256, 67.508757, 2.597551>,
				< 31.711932, 72.966389, 20.249190>,
				< 45.147810, 79.341665, 20.598380>
			}
			triangle {
				< 31.711932, 72.966389, 20.249190>,
				< 40.272180, 81.262477, 42.139545>,
				< 45.147810, 79.341665, 20.598380>
			}
			triangle {
				< 31.711932, 72.966389, 20.249190>,
				< 27.076816, 74.656546, 39.441567>,
				< 40.272180, 81.262477, 42.139545>
			}
			triangle {
				< 27.076816, 74.656546, 39.441567>,
				< 35.390425, 78.719944, 63.815907>,
				< 40.272180, 81.262477, 42.139545>
			}
			triangle {
				< 27.076816, 74.656546, 39.441567>,
				< 22.426838, 72.371259, 58.761373>,
				< 35.390425, 78.719944, 63.815907>
			}
			triangle {
				< 22.426838, 72.371259, 58.761373>,
				< 30.835269, 71.817286, 84.023803>,
				< 35.390425, 78.719944, 63.815907>
			}
			triangle {
				< 22.426838, 72.371259, 58.761373>,
				< 18.078845, 66.210561, 76.790757>,
				< 30.835269, 71.817286, 84.023803>
			}
			triangle {
				< 18.078845, 66.210561, 76.790757>,
				< 26.917107, 61.022617, 101.299465>,
				< 30.835269, 71.817286, 84.023803>
			}
			triangle {
				< 18.078845, 66.210561, 76.790757>,
				< 14.329172, 56.591962, 92.231579>,
				< 26.917107, 61.022617, 101.299465>
			}
			triangle {
				< 14.329172, 56.591962, 92.231579>,
				< 23.902979, 47.137138, 114.442073>,
				< 26.917107, 61.022617, 101.299465>
			}
			triangle {
				< 14.329172, 56.591962, 92.231579>,
				< 11.433305, 44.222254, 104.012847>,
				< 23.902979, 47.137138, 114.442073>
			}
			triangle {
				< 11.433305, 44.222254, 104.012847>,
				< 21.998288, 31.220065, 122.601941>,
				< 23.902979, 47.137138, 114.442073>
			}
			triangle {
				< 11.433305, 44.222254, 104.012847>,
				< 9.588655, 30.033726, 111.368217>,
				< 21.998288, 31.220065, 122.601941>
			}
			triangle {
				< 9.588655, 30.033726, 111.368217>,
				< 21.332804, 14.482938, 125.325516>,
				< 21.998288, 31.220065, 122.601941>
			}
			triangle {
				< 9.588655, 30.033726, 111.368217>,
				< 8.920853, 15.094157, 113.878392>,
				< 21.332804, 14.482938, 125.325516>
			}
			triangle {
				< 8.920853, 15.094157, 113.878392>,
				< 21.951932, -1.828582, 122.557826>,
				< 21.332804, 14.482938, 125.325516>
			}
			triangle {
				< 8.920853, 15.094157, 113.878392>,
				< 9.475468, 0.506148, 111.476749>,
				< 21.951932, -1.828582, 122.557826>
			}
			triangle {
				< 9.475468, 0.506148, 111.476749>,
				< 23.813436, -16.547889, 114.611223>,
				< 21.951932, -1.828582, 122.557826>
			}
			triangle {
				< 9.475468, 0.506148, 111.476749>,
				< 11.214693, -12.691266, 104.426324>,
				< 23.813436, -16.547889, 114.611223>
			}
			triangle {
				< 11.214693, -12.691266, 104.426324>,
				< 26.790462, -28.677834, 102.110974>,
				< 23.813436, -16.547889, 114.611223>
			}
			triangle {
				< 11.214693, -12.691266, 104.426324>,
				< 14.020002, -23.602268, 93.274929>,
				< 26.790462, -28.677834, 102.110974>
			}
			triangle {
				< 14.020002, -23.602268, 93.274929>,
				< 30.680154, -37.454400, 85.931085>,
				< 26.790462, -28.677834, 102.110974>
			}
			triangle {
				< 14.020002, -23.602268, 93.274929>,
				< 17.700234, -31.532567, 78.800336>,
				< 30.680154, -37.454400, 85.931085>
			}
			triangle {
				< 17.700234, -31.532567, 78.800336>,
				< 35.217419, -42.380624, 67.129292>,
				< 30.680154, -37.454400, 85.931085>
			}
			triangle {
				< 17.700234, -31.532567, 78.800336>,
				< 22.004563, -36.022536, 61.953187>,
				< 35.217419, -42.380624, 67.129292>
			}
			triangle {
				< 22.004563, -36.022536, 61.953187>,
				< 40.093053, -43.233689, 46.887226>,
				< 35.217419, -42.380624, 67.129292>
			}
			triangle {
				< 22.004563, -36.022536, 61.953187>,
				< 26.639676, -36.857262, 43.801587>,
				< 40.093053, -43.233689, 46.887226>
			}
			triangle {
				< 26.639676, -36.857262, 43.801587>,
				< 44.974808, -40.052444, 26.456367>,
				< 40.093053, -43.233689, 46.887226>
			}
			triangle {
				< 26.639676, -36.857262, 43.801587>,
				< 31.289656, -34.058247, 25.479993>,
				< 44.974808, -40.052444, 26.456367>
			}
			triangle {
				< 31.289656, -34.058247, 25.479993>,
				< 49.529966, -33.111788, 7.106619>,
				< 44.974808, -40.052444, 26.456367>
			}
			triangle {
				< 31.289656, -34.058247, 25.479993>,
				< 35.637669, -27.863465, 8.138581>,
				< 49.529966, -33.111788, 7.106619>
			}
			triangle {
				< 35.637669, -27.863465, 8.138581>,
				< 53.448148, -22.889936, -9.928128>,
				< 49.529966, -33.111788, 7.106619>
			}
			triangle {
				< 35.637669, -27.863465, 8.138581>,
				< 39.387360, -18.699562, -7.108844>,
				< 53.448148, -22.889936, -9.928128>
			}
			triangle {
				< 53.448148, -22.889936, -9.928128>,
				< 70.308045, -10.893479, -23.040511>,
				< 67.427322, -24.212651, -8.939063>
			}
			triangle {
				< 53.448148, -22.889936, -9.928128>,
				< 56.462273, -10.034053, -23.511523>,
				< 70.308045, -10.893479, -23.040511>
			}
			triangle {
				< 56.462273, -10.034053, -23.511523>,
				< 72.110236, 4.334330, -32.559868>,
				< 70.308045, -10.893479, -23.040511>
			}
			triangle {
				< 56.462273, -10.034053, -23.511523>,
				< 58.366966, 4.672920, -32.675833>,
				< 72.110236, 4.334330, -32.559868>
			}
			triangle {
				< 58.366966, 4.672920, -32.675833>,
				< 72.711043, 20.556482, -36.742747>,
				< 72.110236, 4.334330, -32.559868>
			}
			triangle {
				< 58.366966, 4.672920, -32.675833>,
				< 59.032425, 20.343347, -36.698006>,
				< 72.711043, 20.556482, -36.742747>
			}
			triangle {
				< 59.032425, 20.343347, -36.698006>,
				< 72.069526, 36.783893, -35.165712>,
				< 72.711043, 20.556482, -36.742747>
			}
			triangle {
				< 59.032425, 20.343347, -36.698006>,
				< 58.413323, 36.017645, -35.175592>,
				< 72.069526, 36.783893, -35.165712>
			}
			triangle {
				< 58.413323, 36.017645, -35.175592>,
				< 70.229419, 51.987406, -27.801940>,
				< 72.069526, 36.783893, -35.165712>
			}
			triangle {
				< 58.413323, 36.017645, -35.175592>,
				< 56.551818, 50.698839, -28.087195>,
				< 70.229419, 51.987406, -27.801940>
			}
			triangle {
				< 56.551818, 50.698839, -28.087195>,
				< 67.316093, 65.145552, -15.058746>,
				< 70.229419, 51.987406, -27.801940>
			}
			triangle {
				< 56.551818, 50.698839, -28.087195>,
				< 53.574771, 63.400157, -15.828121>,
				< 67.316093, 65.145552, -15.058746>
			}
			triangle {
				< 53.574771, 63.400157, -15.828121>,
				< 63.528121, 75.306579, 2.223578>,
				< 67.316093, 65.145552, -15.058746>
			}
			triangle {
				< 53.574771, 63.400157, -15.828121>,
				< 49.685098, 73.205143, 0.792238>,
				< 63.528121, 75.306579, 2.223578>
			}
			triangle {
				< 49.685098, 73.205143, 0.792238>,
				< 59.123628, 81.665643, 22.821061>,
				< 63.528121, 75.306579, 2.223578>
			}
			triangle {
				< 49.685098, 73.205143, 0.792238>,
				< 45.147810, 79.341665, 20.598380>,
				< 59.123628, 81.665643, 22.821061>
			}
			triangle {
				< 45.147810, 79.341665, 20.598380>,
				< 54.402798, 83.649985, 45.221336>,
				< 59.123628, 81.665643, 22.821061>
			}
			triangle {
				< 45.147810, 79.341665, 20.598380>,
				< 40.272180, 81.262477, 42.139545>,
				< 54.402798, 83.649985, 45.221336>
			}
			triangle {
				< 40.272180, 81.262477, 42.139545>,
				< 49.687292, 80.998272, 67.756020>,
				< 54.402798, 83.649985, 45.221336>
			}
			triangle {
				< 40.272180, 81.262477, 42.139545>,
				< 35.390425, 78.719944, 63.815907>,
				< 49.687292, 80.998272, 67.756020>
			}
			triangle {
				< 35.390425, 78.719944, 63.815907>,
				< 45.298513, 73.815979, 88.753313>,
				< 49.687292, 80.998272, 67.756020>
			}
			triangle {
				< 35.390425, 78.719944, 63.815907>,
				< 30.835269, 71.817286, 84.023803>,
				< 45.298513, 73.815979, 88.753313>
			}
			triangle {
				< 30.835269, 71.817286, 84.023803>,
				< 41.535527, 62.590711, 106.689051>,
				< 45.298513, 73.815979, 88.753313>
			}
			triangle {
				< 30.835269, 71.817286, 84.023803>,
				< 26.917107, 61.022617, 101.299465>,
				< 41.535527, 62.590711, 106.689051>
			}
			triangle {
				< 26.917107, 61.022617, 101.299465>,
				< 38.654797, 48.158884, 120.315753>,
				< 41.535527, 62.590711, 106.689051>
			}
			triangle {
				< 26.917107, 61.022617, 101.299465>,
				< 23.902979, 47.137138, 114.442073>,
				< 38.654797, 48.158884, 120.315753>
			}
			triangle {
				< 23.902979, 47.137138, 114.442073>,
				< 36.852632, 31.626474, 128.754675>,
				< 38.654797, 48.158884, 120.315753>
			}
			triangle {
				< 23.902979, 47.137138, 114.442073>,
				< 21.998288, 31.220065, 122.601941>,
				< 36.852632, 31.626474, 128.754675>
			}
			triangle {
				< 21.998288, 31.220065, 122.601941>,
				< 36.251828, 14.257049, 131.540731>,
				< 36.852632, 31.626474, 128.754675>
			}
			triangle {
				< 21.998288, 31.220065, 122.601941>,
				< 21.332804, 14.482938, 125.325516>,
				< 36.251828, 14.257049, 131.540731>
			}
			triangle {
				< 21.332804, 14.482938, 125.325516>,
				< 36.893334, -2.652756, 128.624693>,
				< 36.251828, 14.257049, 131.540731>
			}
			triangle {
				< 21.332804, 14.482938, 125.325516>,
				< 21.951932, -1.828582, 122.557826>,
				< 36.893334, -2.652756, 128.624693>
			}
			triangle {
				< 21.951932, -1.828582, 122.557826>,
				< 38.733449, -17.892186, 120.338298>,
				< 36.893334, -2.652756, 128.624693>
			}
			triangle {
				< 21.951932, -1.828582, 122.557826>,
				< 23.813436, -16.547889, 114.611223>,
				< 38.733449, -17.892186, 120.338298>
			}
			triangle {
				< 23.813436, -16.547889, 114.611223>,
				< 41.646749, -30.429857, 107.336313>,
				< 38.733449, -17.892186, 120.338298>
			}
			triangle {
				< 23.813436, -16.547889, 114.611223>,
				< 26.790462, -28.677834, 102.110974>,
				< 41.646749, -30.429857, 107.336313>
			}
			triangle {
				< 26.790462, -28.677834, 102.110974>,
				< 45.434725, -39.479669, 90.528332>,
				< 41.646749, -30.429857, 107.336313>
			}
			triangle {
				< 26.790462, -28.677834, 102.110974>,
				< 30.680154, -37.454400, 85.931085>,
				< 45.434725, -39.479669, 90.528332>
			}
			triangle {
				< 30.680154, -37.454400, 85.931085>,
				< 49.839217, -44.533968, 71.011357>,
				< 45.434725, -39.479669, 90.528332>
			}
			triangle {
				< 30.680154, -37.454400, 85.931085>,
				< 35.217419, -42.380624, 67.129292>,
				< 49.839217, -44.533968, 71.011357>
			}
			triangle {
				< 35.217419, -42.380624, 67.129292>,
				< 54.560065, -45.369700, 50.008371>,
				< 49.839217, -44.533968, 71.011357>
			}
			triangle {
				< 35.217419, -42.380624, 67.129292>,
				< 40.093053, -43.233689, 46.887226>,
				< 54.560065, -45.369700, 50.008371>
			}
			triangle {
				< 40.093053, -43.233689, 46.887226>,
				< 59.275553, -42.033903, 28.813001>,
				< 54.560065, -45.369700, 50.008371>
			}
			triangle {
				< 40.093053, -43.233689, 46.887226>,
				< 44.974808, -40.052444, 26.456367>,
				< 59.275553, -42.033903, 28.813001>
			}
			triangle {
				< 44.974808, -40.052444, 26.456367>,
				< 63.664332, -34.815919, 8.738207>,
				< 59.275553, -42.033903, 28.813001>
			}
			triangle {
				< 44.974808, -40.052444, 26.456367>,
				< 49.529966, -33.111788, 7.106619>,
				< 63.664332, -34.815919, 8.738207>
			}
			triangle {
				< 49.529966, -33.111788, 7.106619>,
				< 67.427322, -24.212651, -8.939063>,
				< 63.664332, -34.815919, 8.738207>
			}
			triangle {
				< 49.529966, -33.111788, 7.106619>,
				< 53.448148, -22.889936, -9.928128>,
				< 67.427322, -24.212651, -8.939063>
			}
			triangle {
				< 67.427322, -24.212651, -8.939063>,
				< 83.075278, -9.674303, -17.824985>,
				< 80.524214, -22.583144, -4.181196>
			}
			triangle {
				< 67.427322, -24.212651, -8.939063>,
				< 70.308045, -10.893479, -23.040511>,
				< 83.075278, -9.674303, -17.824985>
			}
			triangle {
				< 70.308045, -10.893479, -23.040511>,
				< 84.652126, 5.078239, -27.016021>,
				< 83.075278, -9.674303, -17.824985>
			}
			triangle {
				< 70.308045, -10.893479, -23.040511>,
				< 72.110236, 4.334330, -32.559868>,
				< 84.652126, 5.078239, -27.016021>
			}
			triangle {
				< 72.110236, 4.334330, -32.559868>,
				< 85.147299, 20.785041, -31.028818>,
				< 84.652126, 5.078239, -27.016021>
			}
			triangle {
				< 72.110236, 4.334330, -32.559868>,
				< 72.711043, 20.556482, -36.742747>,
				< 85.147299, 20.785041, -31.028818>
			}
			triangle {
				< 72.711043, 20.556482, -36.742747>,
				< 84.527098, 36.484856, -29.460482>,
				< 85.147299, 20.785041, -31.028818>
			}
			triangle {
				< 72.711043, 20.556482, -36.742747>,
				< 72.069526, 36.783893, -35.165712>,
				< 84.527098, 36.484856, -29.460482>
			}
			triangle {
				< 72.069526, 36.783893, -35.165712>,
				< 82.833804, 51.179044, -22.291984>,
				< 84.527098, 36.484856, -29.460482>
			}
			triangle {
				< 72.069526, 36.783893, -35.165712>,
				< 70.229419, 51.987406, -27.801940>,
				< 82.833804, 51.179044, -22.291984>
			}
			triangle {
				< 70.229419, 51.987406, -27.801940>,
				< 80.182768, 63.879170, -9.923593>,
				< 82.833804, 51.179044, -22.291984>
			}
			triangle {
				< 70.229419, 51.987406, -27.801940>,
				< 67.316093, 65.145552, -15.058746>,
				< 80.182768, 63.879170, -9.923593>
			}
			triangle {
				< 67.316093, 65.145552, -15.058746>,
				< 76.754645, 73.667400, 6.828029>,
				< 80.182768, 63.879170, -9.923593>
			}
			triangle {
				< 67.316093, 65.145552, -15.058746>,
				< 63.528121, 75.306579, 2.223578>,
				< 76.754645, 73.667400, 6.828029>
			}
			triangle {
				< 63.528121, 75.306579, 2.223578>,
				< 72.783090, 79.770967, 26.777919>,
				< 76.754645, 73.667400, 6.828029>
			}
			triangle {
				< 63.528121, 75.306579, 2.223578>,
				< 59.123628, 81.665643, 22.821061>,
				< 72.783090, 79.770967, 26.777919>
			}
			triangle {
				< 59.123628, 81.665643, 22.821061>,
				< 68.538763, 81.643358, 48.464797>,
				< 72.783090, 79.770967, 26.777919>
			}
			triangle {
				< 59.123628, 81.665643, 22.821061>,
				< 54.402798, 83.649985, 45.221336>,
				< 68.538763, 81.643358, 48.464797>
			}
			triangle {
				< 54.402798, 83.649985, 45.221336>,
				< 64.310886, 79.039223, 70.278049>,
				< 68.538763, 81.643358, 48.464797>
			}
			triangle {
				< 54.402798, 83.649985, 45.221336>,
				< 49.687292, 80.998272, 67.756020>,
				< 64.310886, 79.039223, 70.278049>
			}
			triangle {
				< 49.687292, 80.998272, 67.756020>,
				< 60.387574, 72.066084, 90.603672>,
				< 64.310886, 79.039223, 70.278049>
			}
			triangle {
				< 49.687292, 80.998272, 67.756020>,
				< 45.298513, 73.815979, 88.753313>,
				< 60.387574, 72.066084, 90.603672>
			}
			triangle {
				< 45.298513, 73.815979, 88.753313>,
				< 57.036225, 61.197832, 107.969418>,
				< 60.387574, 72.066084, 90.603672>
			}
			triangle {
				< 45.298513, 73.815979, 88.753313>,
				< 41.535527, 62.590711, 106.689051>,
				< 57.036225, 61.197832, 107.969418>
			}
			triangle {
				< 41.535527, 62.590711, 106.689051>,
				< 54.485202, 47.242321, 121.168196>,
				< 57.036225, 61.197832, 107.969418>
			}
			triangle {
				< 41.535527, 62.590711, 106.689051>,
				< 38.654797, 48.158884, 120.315753>,
				< 54.485202, 47.242321, 121.168196>
			}
			triangle {
				< 38.654797, 48.158884, 120.315753>,
				< 52.908354, 31.265430, 129.347295>,
				< 54.485202, 47.242321, 121.168196>
			}
			triangle {
				< 38.654797, 48.158884, 120.315753>,
				< 36.852632, 31.626474, 128.754675>,
				< 52.908354, 31.265430, 129.347295>
			}
			triangle {
				< 36.852632, 31.626474, 128.754675>,
				< 52.413180, 14.484232, 132.052258>,
				< 52.908354, 31.265430, 129.347295>
			}
			triangle {
				< 36.852632, 31.626474, 128.754675>,
				< 36.251828, 14.257049, 131.540731>,
				< 52.413180, 14.484232, 132.052258>
			}
			triangle {
				< 36.251828, 14.257049, 131.540731>,
				< 53.033363, -1.851916, 129.230455>,
				< 52.413180, 14.484232, 132.052258>
			}
			triangle {
				< 36.251828, 14.257049, 131.540731>,
				< 36.893334, -2.652756, 128.624693>,
				< 53.033363, -1.851916, 129.230455>
			}
			triangle {
				< 36.893334, -2.652756, 128.624693>,
				< 54.726690, -16.574988, 121.198647>,
				< 53.033363, -1.851916, 129.230455>
			}
			triangle {
				< 36.893334, -2.652756, 128.624693>,
				< 38.733449, -17.892186, 120.338298>,
				< 54.726690, -16.574988, 121.198647>
			}
			triangle {
				< 38.733449, -17.892186, 120.338298>,
				< 57.377737, -28.688557, 108.588584>,
				< 54.726690, -16.574988, 121.198647>
			}
			triangle {
				< 38.733449, -17.892186, 120.338298>,
				< 41.646749, -30.429857, 107.336313>,
				< 57.377737, -28.688557, 108.588584>
			}
			triangle {
				< 41.646749, -30.429857, 107.336313>,
				< 60.805812, -37.431356, 92.281595>,
				< 57.377737, -28.688557, 108.588584>
			}
			triangle {
				< 41.646749, -30.429857, 107.336313>,
				< 45.434725, -39.479669, 90.528332>,
				< 60.805812, -37.431356, 92.281595>
			}
			triangle {
				< 45.434725, -39.479669, 90.528332>,
				< 64.777367, -42.310417, 73.343664>,
				< 60.805812, -37.431356, 92.281595>
			}
			triangle {
				< 45.434725, -39.479669, 90.528332>,
				< 49.839217, -44.533968, 71.011357>,
				< 64.777367, -42.310417, 73.343664>
			}
			triangle {
				< 49.839217, -44.533968, 71.011357>,
				< 69.021717, -43.107249, 52.965004>,
				< 64.777367, -42.310417, 73.343664>
			}
			triangle {
				< 49.839217, -44.533968, 71.011357>,
				< 54.560065, -45.369700, 50.008371>,
				< 69.021717, -43.107249, 52.965004>
			}
			triangle {
				< 54.560065, -45.369700, 50.008371>,
				< 73.249586, -39.865319, 32.405511>,
				< 69.021717, -43.107249, 52.965004>
			}
			triangle {
				< 54.560065, -45.369700, 50.008371>,
				< 59.275553, -42.033903, 28.813001>,
				< 73.249586, -39.865319, 32.405511>
			}
			triangle {
				< 59.275553, -42.033903, 28.813001>,
				< 77.172905, -32.863449, 12.943094>,
				< 73.249586, -39.865319, 32.405511>
			}
			triangle {
				< 59.275553, -42.033903, 28.813001>,
				< 63.664332, -34.815919, 8.738207>,
				< 77.172905, -32.863449, 12.943094>
			}
			triangle {
				< 63.664332, -34.815919, 8.738207>,
				< 80.524214, -22.583144, -4.181196>,
				< 77.172905, -32.863449, 12.943094>
			}
			triangle {
				< 63.664332, -34.815919, 8.738207>,
				< 67.427322, -24.212651, -8.939063>,
				< 80.524214, -22.583144, -4.181196>
			}
			triangle {
				< 80.524214, -22.583144, -4.181196>,
				< 94.092064, -6.474752, -8.154637>,
				< 91.998346, -18.116387, 4.083755>
			}
			triangle {
				< 80.524214, -22.583144, -4.181196>,
				< 83.075278, -9.674303, -17.824985>,
				< 94.092064, -6.474752, -8.154637>
			}
			triangle {
				< 83.075278, -9.674303, -17.824985>,
				< 95.368952, 6.826389, -16.360149>,
				< 94.092064, -6.474752, -8.154637>
			}
			triangle {
				< 83.075278, -9.674303, -17.824985>,
				< 84.652126, 5.078239, -27.016021>,
				< 95.368952, 6.826389, -16.360149>
			}
			triangle {
				< 84.652126, 5.078239, -27.016021>,
				< 95.741779, 20.974822, -19.893693>,
				< 95.368952, 6.826389, -16.360149>
			}
			triangle {
				< 84.652126, 5.078239, -27.016021>,
				< 85.147299, 20.785041, -31.028818>,
				< 95.741779, 20.974822, -19.893693>
			}
			triangle {
				< 85.147299, 20.785041, -31.028818>,
				< 95.185287, 35.094406, -18.409787>,
				< 95.741779, 20.974822, -19.893693>
			}
			triangle {
				< 85.147299, 20.785041, -31.028818>,
				< 84.527098, 36.484856, -29.460482>,
				< 95.185287, 35.094406, -18.409787>
			}
			triangle {
				< 84.527098, 36.484856, -29.460482>,
				< 93.737222, 48.279542, -11.908160>,
				< 95.185287, 35.094406, -18.409787>
			}
			triangle {
				< 84.527098, 36.484856, -29.460482>,
				< 82.833804, 51.179044, -22.291984>,
				< 93.737222, 48.279542, -11.908160>
			}
			triangle {
				< 82.833804, 51.179044, -22.291984>,
				< 91.496669, 59.640974, -0.760964>,
				< 93.737222, 48.279542, -11.908160>
			}
			triangle {
				< 82.833804, 51.179044, -22.291984>,
				< 80.182768, 63.879170, -9.923593>,
				< 91.496669, 59.640974, -0.760964>
			}
			triangle {
				< 80.182768, 63.879170, -9.923593>,
				< 88.615939, 68.361245, 14.293171>,
				< 91.496669, 59.640974, -0.760964>
			}
			triangle {
				< 80.182768, 63.879170, -9.923593>,
				< 76.754645, 73.667400, 6.828029>,
				< 88.615939, 68.361245, 14.293171>
			}
			triangle {
				< 76.754645, 73.667400, 6.828029>,
				< 85.291438, 73.760524, 32.193154>,
				< 88.615939, 68.361245, 14.293171>
			}
			triangle {
				< 76.754645, 73.667400, 6.828029>,
				< 72.783090, 79.770967, 26.777919>,
				< 85.291438, 73.760524, 32.193154>
			}
			triangle {
				< 72.783090, 79.770967, 26.777919>,
				< 81.749797, 75.365990, 51.637225>,
				< 85.291438, 73.760524, 32.193154>
			}
			triangle {
				< 72.783090, 79.770967, 26.777919>,
				< 68.538763, 81.643358, 48.464797>,
				< 81.749797, 75.365990, 51.637225>
			}
			triangle {
				< 68.538763, 81.643358, 48.464797>,
				< 78.232303, 72.974131, 71.193270>,
				< 81.749797, 75.365990, 51.637225>
			}
			triangle {
				< 68.538763, 81.643358, 48.464797>,
				< 64.310886, 79.039223, 70.278049>,
				< 78.232303, 72.974131, 71.193270>
			}
			triangle {
				< 64.310886, 79.039223, 70.278049>,
				< 74.978694, 66.692241, 89.426145>,
				< 78.232303, 72.974131, 71.193270>
			}
			triangle {
				< 64.310886, 79.039223, 70.278049>,
				< 60.387574, 72.066084, 90.603672>,
				< 74.978694, 66.692241, 89.426145>
			}
			triangle {
				< 60.387574, 72.066084, 90.603672>,
				< 72.210789, 56.947704, 105.023026>,
				< 74.978694, 66.692241, 89.426145>
			}
			triangle {
				< 60.387574, 72.066084, 90.603672>,
				< 57.036225, 61.197832, 107.969418>,
				< 72.210789, 56.947704, 105.023026>
			}
			triangle {
				< 57.036225, 61.197832, 107.969418>,
				< 70.117079, 44.458270, 116.902187>,
				< 72.210789, 56.947704, 105.023026>
			}
			triangle {
				< 57.036225, 61.197832, 107.969418>,
				< 54.485202, 47.242321, 121.168196>,
				< 70.117079, 44.458270, 116.902187>
			}
			triangle {
				< 54.485202, 47.242321, 121.168196>,
				< 68.840168, 30.167423, 124.291278>,
				< 70.117079, 44.458270, 116.902187>
			}
			triangle {
				< 54.485202, 47.242321, 121.168196>,
				< 52.908354, 31.265430, 129.347295>,
				< 68.840168, 30.167423, 124.291278>
			}
			triangle {
				< 52.908354, 31.265430, 129.347295>,
				< 68.467356, 15.152148, 126.770020>,
				< 68.840168, 30.167423, 124.291278>
			}
			triangle {
				< 52.908354, 31.265430, 129.347295>,
				< 52.413180, 14.484232, 132.052258>,
				< 68.467356, 15.152148, 126.770020>
			}
			triangle {
				< 52.413180, 14.484232, 132.052258>,
				< 69.023833, 0.521283, 124.275401>,
				< 68.467356, 15.152148, 126.770020>
			}
			triangle {
				< 52.413180, 14.484232, 132.052258>,
				< 53.033363, -1.851916, 129.230455>,
				< 69.023833, 0.521283, 124.275401>
			}
			triangle {
				< 53.033363, -1.851916, 129.230455>,
				< 70.471816, -12.683580, 117.078029>,
				< 69.023833, 0.521283, 124.275401>
			}
			triangle {
				< 53.033363, -1.851916, 129.230455>,
				< 54.726690, -16.574988, 121.198647>,
				< 70.471816, -12.683580, 117.078029>
			}
			triangle {
				< 54.726690, -16.574988, 121.198647>,
				< 72.712533, -23.567673, 105.736323>,
				< 70.471816, -12.683580, 117.078029>
			}
			triangle {
				< 54.726690, -16.574988, 121.198647>,
				< 57.377737, -28.688557, 108.588584>,
				< 72.712533, -23.567673, 105.736323>
			}
			triangle {
				< 57.377737, -28.688557, 108.588584>,
				< 75.593248, -31.441048, 91.041148>,
				< 72.712533, -23.567673, 105.736323>
			}
			triangle {
				< 57.377737, -28.688557, 108.588584>,
				< 60.805812, -37.431356, 92.281595>,
				< 75.593248, -31.441048, 91.041148>
			}
			triangle {
				< 60.805812, -37.431356, 92.281595>,
				< 78.917697, -35.850514, 73.957495>,
				< 75.593248, -31.441048, 91.041148>
			}
			triangle {
				< 60.805812, -37.431356, 92.281595>,
				< 64.777367, -42.310417, 73.343664>,
				< 78.917697, -35.850514, 73.957495>
			}
			triangle {
				< 64.777367, -42.310417, 73.343664>,
				< 82.459338, -36.588497, 55.568513>,
				< 78.917697, -35.850514, 73.957495>
			}
			triangle {
				< 64.777367, -42.310417, 73.343664>,
				< 69.021717, -43.107249, 52.965004>,
				< 82.459338, -36.588497, 55.568513>
			}
			triangle {
				< 69.021717, -43.107249, 52.965004>,
				< 85.976817, -33.684302, 37.023399>,
				< 82.459338, -36.588497, 55.568513>
			}
			triangle {
				< 69.021717, -43.107249, 52.965004>,
				< 73.249586, -39.865319, 32.405511>,
				< 85.976817, -33.684302, 37.023399>
			}
			triangle {
				< 73.249586, -39.865319, 32.405511>,
				< 89.230426, -27.382700, 19.486336>,
				< 85.976817, -33.684302, 37.023399>
			}
			triangle {
				< 73.249586, -39.865319, 32.405511>,
				< 77.172905, -32.863449, 12.943094>,
				< 89.230426, -27.382700, 19.486336>
			}
			triangle {
				< 77.172905, -32.863449, 12.943094>,
				< 91.998346, -18.116387, 4.083755>,
				< 89.230426, -27.382700, 19.486336>
			}
			triangle {
				< 77.172905, -32.863449, 12.943094>,
				< 80.524214, -22.583144, -4.181196>,
				< 91.998346, -18.116387, 4.083755>
			}
			triangle {
				< 91.998346, -18.116387, 4.083755>,
				< 102.753036, -1.537300, 5.388470>,
				< 101.178966, -11.118768, 15.372897>
			}
			triangle {
				< 91.998346, -18.116387, 4.083755>,
				< 94.092064, -6.474752, -8.154637>,
				< 102.753036, -1.537300, 5.388470>
			}
			triangle {
				< 94.092064, -6.474752, -8.154637>,
				< 103.699513, 9.409193, -1.258912>,
				< 102.753036, -1.537300, 5.388470>
			}
			triangle {
				< 94.092064, -6.474752, -8.154637>,
				< 95.368952, 6.826389, -16.360149>,
				< 103.699513, 9.409193, -1.258912>
			}
			triangle {
				< 95.368952, 6.826389, -16.360149>,
				< 103.953838, 21.038303, -4.062398>,
				< 103.699513, 9.409193, -1.258912>
			}
			triangle {
				< 95.368952, 6.826389, -16.360149>,
				< 95.741779, 20.974822, -19.893693>,
				< 103.953838, 21.038303, -4.062398>
			}
			triangle {
				< 95.741779, 20.974822, -19.893693>,
				< 103.499219, 32.616481, -2.760975>,
				< 103.953838, 21.038303, -4.062398>
			}
			triangle {
				< 95.741779, 20.974822, -19.893693>,
				< 95.185287, 35.094406, -18.409787>,
				< 103.499219, 32.616481, -2.760975>
			}
			triangle {
				< 95.185287, 35.094406, -18.409787>,
				< 102.366187, 43.391656, 2.624383>,
				< 103.499219, 32.616481, -2.760975>
			}
			triangle {
				< 95.185287, 35.094406, -18.409787>,
				< 93.737222, 48.279542, -11.908160>,
				< 102.366187, 43.391656, 2.624383>
			}
			triangle {
				< 93.737222, 48.279542, -11.908160>,
				< 100.632302, 52.634690, 11.773990>,
				< 102.366187, 43.391656, 2.624383>
			}
			triangle {
				< 93.737222, 48.279542, -11.908160>,
				< 91.496669, 59.640974, -0.760964>,
				< 100.632302, 52.634690, 11.773990>
			}
			triangle {
				< 91.496669, 59.640974, -0.760964>,
				< 98.415352, 59.685953, 24.078034>,
				< 100.632302, 52.634690, 11.773990>
			}
			triangle {
				< 91.496669, 59.640974, -0.760964>,
				< 88.615939, 68.361245, 14.293171>,
				< 98.415352, 59.685953, 24.078034>
			}
			triangle {
				< 88.615939, 68.361245, 14.293171>,
				< 95.866673, 64.007640, 38.674489>,
				< 98.415352, 59.685953, 24.078034>
			}
			triangle {
				< 88.615939, 68.361245, 14.293171>,
				< 85.291438, 73.760524, 32.193154>,
				< 95.866673, 64.007640, 38.674489>
			}
			triangle {
				< 85.291438, 73.760524, 32.193154>,
				< 93.159750, 65.235652, 54.513775>,
				< 95.866673, 64.007640, 38.674489>
			}
			triangle {
				< 85.291438, 73.760524, 32.193154>,
				< 81.749797, 75.365990, 51.637225>,
				< 93.159750, 65.235652, 54.513775>
			}
			triangle {
				< 81.749797, 75.365990, 51.637225>,
				< 90.479285, 63.224316, 70.445277>,
				< 93.159750, 65.235652, 54.513775>
			}
			triangle {
				< 81.749797, 75.365990, 51.637225>,
				< 78.232303, 72.974131, 71.193270>,
				< 90.479285, 63.224316, 70.445277>
			}
			triangle {
				< 78.232303, 72.974131, 71.193270>,
				< 88.007800, 58.074169, 85.314855>,
				< 90.479285, 63.224316, 70.445277>
			}
			triangle {
				< 78.232303, 72.974131, 71.193270>,
				< 74.978694, 66.692241, 89.426145>,
				< 88.007800, 58.074169, 85.314855>
			}
			triangle {
				< 74.978694, 66.692241, 89.426145>,
				< 85.913859, 50.135698, 98.062441>,
				< 88.007800, 58.074169, 85.314855>
			}
			triangle {
				< 74.978694, 66.692241, 89.426145>,
				< 72.210789, 56.947704, 105.023026>,
				< 85.913859, 50.135698, 98.062441>
			}
			triangle {
				< 72.210789, 56.947704, 105.023026>,
				< 84.339932, 39.985389, 107.806474>,
				< 85.913859, 50.135698, 98.062441>
			}
			triangle {
				< 72.210789, 56.947704, 105.023026>,
				< 70.117079, 44.458270, 116.902187>,
				< 84.339932, 39.985389, 107.806474>
			}
			triangle {
				< 70.117079, 44.458270, 116.902187>,
				< 83.393477, 28.375877, 113.907956>,
				< 84.339932, 39.985389, 107.806474>
			}
			triangle {
				< 70.117079, 44.458270, 116.902187>,
				< 68.840168, 30.167423, 124.291278>,
				< 83.393477, 28.375877, 113.907956>
			}
			triangle {
				< 68.840168, 30.167423, 124.291278>,
				< 83.138920, 16.166925, 116.006188>,
				< 83.393477, 28.375877, 113.907956>
			}
			triangle {
				< 68.840168, 30.167423, 124.291278>,
				< 68.467356, 15.152148, 126.770020>,
				< 83.138920, 16.166925, 116.006188>
			}
			triangle {
				< 68.467356, 15.152148, 126.770020>,
				< 83.593622, 4.248036, 114.029244>,
				< 83.138920, 16.166925, 116.006188>
			}
			triangle {
				< 68.467356, 15.152148, 126.770020>,
				< 69.023833, 0.521283, 124.275401>,
				< 83.593622, 4.248036, 114.029244>
			}
			triangle {
				< 69.023833, 0.521283, 124.275401>,
				< 84.726453, -6.538349, 108.178854>,
				< 83.593622, 4.248036, 114.029244>
			}
			triangle {
				< 69.023833, 0.521283, 124.275401>,
				< 70.471816, -12.683580, 117.078029>,
				< 84.726453, -6.538349, 108.178854>
			}
			triangle {
				< 70.471816, -12.683580, 117.078029>,
				< 86.460687, -15.459742, 98.899491>,
				< 84.726453, -6.538349, 108.178854>
			}
			triangle {
				< 70.471816, -12.683580, 117.078029>,
				< 72.712533, -23.567673, 105.736323>,
				< 86.460687, -15.459742, 98.899491>
			}
			triangle {
				< 72.712533, -23.567673, 105.736323>,
				< 88.677488, -21.942560, 86.835720>,
				< 86.460687, -15.459742, 98.899491>
			}
			triangle {
				< 72.712533, -23.567673, 105.736323>,
				< 75.593248, -31.441048, 91.041148>,
				< 88.677488, -21.942560, 86.835720>
			}
			triangle {
				< 75.593248, -31.441048, 91.041148>,
				< 91.226198, -25.601203, 72.785199>,
				< 88.677488, -21.942560, 86.835720>
			}
			triangle {
				< 75.593248, -31.441048, 91.041148>,
				< 78.917697, -35.850514, 73.957495>,
				< 91.226198, -25.601203, 72.785199>
			}
			triangle {
				< 78.917697, -35.850514, 73.957495>,
				< 93.933038, -26.249176, 57.651214>,
				< 91.226198, -25.601203, 72.785199>
			}
			triangle {
				< 78.917697, -35.850514, 73.957495>,
				< 82.459338, -36.588497, 55.568513>,
				< 93.933038, -26.249176, 57.651214>
			}
			triangle {
				< 82.459338, -36.588497, 55.568513>,
				< 96.613437, -23.896499, 42.395446>,
				< 93.933038, -26.249176, 57.651214>
			}
			triangle {
				< 82.459338, -36.588497, 55.568513>,
				< 85.976817, -33.684302, 37.023399>,
				< 96.613437, -23.896499, 42.395446>
			}
			triangle {
				< 85.976817, -33.684302, 37.023399>,
				< 99.084944, -18.735196, 27.990790>,
				< 96.613437, -23.896499, 42.395446>
			}
			triangle {
				< 85.976817, -33.684302, 37.023399>,
				< 89.230426, -27.382700, 19.486336>,
				< 99.084944, -18.735196, 27.990790>
			}
			triangle {
				< 89.230426, -27.382700, 19.486336>,
				< 101.178966, -11.118768, 15.372897>,
				< 99.084944, -18.735196, 27.990790>
			}
			triangle {
				< 89.230426, -27.382700, 19.486336>,
				< 91.998346, -18.116387, 4.083755>,
				< 101.178966, -11.118768, 15.372897>
			}
			triangle {
				< 101.178966, -11.118768, 15.372897>,
				< 108.520612, 4.773375, 21.948311>,
				< 107.481398, -2.067194, 28.993828>
			}
			triangle {
				< 101.178966, -11.118768, 15.372897>,
				< 102.753036, -1.537300, 5.388470>,
				< 108.520612, 4.773375, 21.948311>
			}
			triangle {
				< 102.753036, -1.537300, 5.388470>,
				< 109.137908, 12.588547, 17.299699>,
				< 108.520612, 4.773375, 21.948311>
			}
			triangle {
				< 102.753036, -1.537300, 5.388470>,
				< 103.699513, 9.409193, -1.258912>,
				< 109.137908, 12.588547, 17.299699>
			}
			triangle {
				< 103.699513, 9.409193, -1.258912>,
				< 109.290853, 20.878684, 15.391862>,
				< 109.137908, 12.588547, 17.299699>
			}
			triangle {
				< 103.699513, 9.409193, -1.258912>,
				< 103.953838, 21.038303, -4.062398>,
				< 109.290853, 20.878684, 15.391862>
			}
			triangle {
				< 103.953838, 21.038303, -4.062398>,
				< 108.968988, 29.107757, 16.389828>,
				< 109.290853, 20.878684, 15.391862>
			}
			triangle {
				< 103.953838, 21.038303, -4.062398>,
				< 103.499219, 32.616481, -2.760975>,
				< 108.968988, 29.107757, 16.389828>
			}
			triangle {
				< 103.499219, 32.616481, -2.760975>,
				< 108.194768, 36.733177, 20.259706>,
				< 108.968988, 29.107757, 16.389828>
			}
			triangle {
				< 103.499219, 32.616481, -2.760975>,
				< 102.366187, 43.391656, 2.624383>,
				< 108.194768, 36.733177, 20.259706>
			}
			triangle {
				< 102.366187, 43.391656, 2.624383>,
				< 107.020408, 43.237124, 26.761230>,
				< 108.194768, 36.733177, 20.259706>
			}
			triangle {
				< 102.366187, 43.391656, 2.624383>,
				< 100.632302, 52.634690, 11.773990>,
				< 107.020408, 43.237124, 26.761230>
			}
			triangle {
				< 100.632302, 52.634690, 11.773990>,
				< 105.526105, 48.161119, 35.458025>,
				< 107.020408, 43.237124, 26.761230>
			}
			triangle {
				< 100.632302, 52.634690, 11.773990>,
				< 98.415352, 59.685953, 24.078034>,
				< 105.526105, 48.161119, 35.458025>
			}
			triangle {
				< 98.415352, 59.685953, 24.078034>,
				< 103.813797, 51.140752, 45.745697>,
				< 105.526105, 48.161119, 35.458025>
			}
			triangle {
				< 98.415352, 59.685953, 24.078034>,
				< 95.866673, 64.007640, 38.674489>,
				< 103.813797, 51.140752, 45.745697>
			}
			triangle {
				< 95.866673, 64.007640, 38.674489>,
				< 102.000058, 51.938646, 56.895565>,
				< 103.813797, 51.140752, 45.745697>
			}
			triangle {
				< 95.866673, 64.007640, 38.674489>,
				< 93.159750, 65.235652, 54.513775>,
				< 102.000058, 51.938646, 56.895565>
			}
			triangle {
				< 93.159750, 65.235652, 54.513775>,
				< 100.208573, 50.469898, 68.112239>,
				< 102.000058, 51.938646, 56.895565>
			}
			triangle {
				< 93.159750, 65.235652, 54.513775>,
				< 90.479285, 63.224316, 70.445277>,
				< 100.208573, 50.469898, 68.112239>
			}
			triangle {
				< 90.479285, 63.224316, 70.445277>,
				< 98.561421, 46.816744, 78.597352>,
				< 100.208573, 50.469898, 68.112239>
			}
			triangle {
				< 90.479285, 63.224316, 70.445277>,
				< 88.007800, 58.074169, 85.314855>,
				< 98.561421, 46.816744, 78.597352>
			}
			triangle {
				< 88.007800, 58.074169, 85.314855>,
				< 97.170904, 41.227840, 87.612711>,
				< 98.561421, 46.816744, 78.597352>
			}
			triangle {
				< 88.007800, 58.074169, 85.314855>,
				< 85.913859, 50.135698, 98.062441>,
				< 97.170904, 41.227840, 87.612711>
			}
			triangle {
				< 85.913859, 50.135698, 98.062441>,
				< 96.131556, 34.101453, 94.537750>,
				< 97.170904, 41.227840, 87.612711>
			}
			triangle {
				< 85.913859, 50.135698, 98.062441>,
				< 84.339932, 39.985389, 107.806474>,
				< 96.131556, 34.101453, 94.537750>
			}
			triangle {
				< 84.339932, 39.985389, 107.806474>,
				< 95.514335, 25.953248, 98.912768>,
				< 96.131556, 34.101453, 94.537750>
			}
			triangle {
				< 84.339932, 39.985389, 107.806474>,
				< 83.393477, 28.375877, 113.907956>,
				< 95.514335, 25.953248, 98.912768>
			}
			triangle {
				< 83.393477, 28.375877, 113.907956>,
				< 95.361389, 17.372573, 100.467257>,
				< 95.514335, 25.953248, 98.912768>
			}
			triangle {
				< 83.393477, 28.375877, 113.907956>,
				< 83.138920, 16.166925, 116.006188>,
				< 95.361389, 17.372573, 100.467257>
			}
			triangle {
				< 83.138920, 16.166925, 116.006188>,
				< 95.683068, 8.973273, 99.130690>,
				< 95.361389, 17.372573, 100.467257>
			}
			triangle {
				< 83.138920, 16.166925, 116.006188>,
				< 83.593622, 4.248036, 114.029244>,
				< 95.683068, 8.973273, 99.130690>
			}
			triangle {
				< 83.593622, 4.248036, 114.029244>,
				< 96.457474, 1.343044, 95.027924>,
				< 95.683068, 8.973273, 99.130690>
			}
			triangle {
				< 83.593622, 4.248036, 114.029244>,
				< 84.726453, -6.538349, 108.178854>,
				< 96.457474, 1.343044, 95.027924>
			}
			triangle {
				< 84.726453, -6.538349, 108.178854>,
				< 97.631887, -4.998796, 88.461511>,
				< 96.457474, 1.343044, 95.027924>
			}
			triangle {
				< 84.726453, -6.538349, 108.178854>,
				< 86.460687, -15.459742, 98.899491>,
				< 97.631887, -4.998796, 88.461511>
			}
			triangle {
				< 86.460687, -15.459742, 98.899491>,
				< 99.126153, -9.637005, 79.885155>,
				< 97.631887, -4.998796, 88.461511>
			}
			triangle {
				< 86.460687, -15.459742, 98.899491>,
				< 88.677488, -21.942560, 86.835720>,
				< 99.126153, -9.637005, 79.885155>
			}
			triangle {
				< 88.677488, -21.942560, 86.835720>,
				< 100.838490, -12.283959, 69.871165>,
				< 99.126153, -9.637005, 79.885155>
			}
			triangle {
				< 88.677488, -21.942560, 86.835720>,
				< 91.226198, -25.601203, 72.785199>,
				< 100.838490, -12.283959, 69.871165>
			}
			triangle {
				< 91.226198, -25.601203, 72.785199>,
				< 102.652162, -12.791178, 59.074689>,
				< 100.838490, -12.283959, 69.871165>
			}
			triangle {
				< 91.226198, -25.601203, 72.785199>,
				< 93.933038, -26.249176, 57.651214>,
				< 102.652162, -12.791178, 59.074689>
			}
			triangle {
				< 93.933038, -26.249176, 57.651214>,
				< 104.443692, -11.151853, 48.196539>,
				< 102.652162, -12.791178, 59.074689>
			}
			triangle {
				< 93.933038, -26.249176, 57.651214>,
				< 96.613437, -23.896499, 42.395446>,
				< 104.443692, -11.151853, 48.196539>
			}
			triangle {
				< 96.613437, -23.896499, 42.395446>,
				< 106.090829, -7.493852, 37.944369>,
				< 104.443692, -11.151853, 48.196539>
			}
			triangle {
				< 96.613437, -23.896499, 42.395446>,
				< 99.084944, -18.735196, 27.990790>,
				< 106.090829, -7.493852, 37.944369>
			}
			triangle {
				< 99.084944, -18.735196, 27.990790>,
				< 107.481398, -2.067194, 28.993828>,
				< 106.090829, -7.493852, 37.944369>
			}
			triangle {
				< 99.084944, -18.735196, 27.990790>,
				< 101.178966, -11.118768, 15.372897>,
				< 107.481398, -2.067194, 28.993828>
			}
			triangle {
				< 107.481398, -2.067194, 28.993828>,
				< 110.949226, 12.001852, 40.435288>,
				< 110.435136, 8.423421, 44.070657>
			}
			triangle {
				< 107.481398, -2.067194, 28.993828>,
				< 108.520612, 4.773375, 21.948311>,
				< 110.949226, 12.001852, 40.435288>
			}
			triangle {
				< 108.520612, 4.773375, 21.948311>,
				< 111.251801, 16.091108, 38.061611>,
				< 110.949226, 12.001852, 40.435288>
			}
			triangle {
				< 108.520612, 4.773375, 21.948311>,
				< 109.137908, 12.588547, 17.299699>,
				< 111.251801, 16.091108, 38.061611>
			}
			triangle {
				< 109.137908, 12.588547, 17.299699>,
				< 111.321926, 20.421028, 37.118636>,
				< 111.251801, 16.091108, 38.061611>
			}
			triangle {
				< 109.137908, 12.588547, 17.299699>,
				< 109.290853, 20.878684, 15.391862>,
				< 111.321926, 20.421028, 37.118636>
			}
			triangle {
				< 109.290853, 20.878684, 15.391862>,
				< 111.155525, 24.704352, 37.680104>,
				< 111.321926, 20.421028, 37.118636>
			}
			triangle {
				< 109.290853, 20.878684, 15.391862>,
				< 108.968988, 29.107757, 16.389828>,
				< 111.155525, 24.704352, 37.680104>
			}
			triangle {
				< 108.968988, 29.107757, 16.389828>,
				< 110.763371, 28.653920, 39.716948>,
				< 111.155525, 24.704352, 37.680104>
			}
			triangle {
				< 108.968988, 29.107757, 16.389828>,
				< 108.194768, 36.733177, 20.259706>,
				< 110.763371, 28.653920, 39.716948>
			}
			triangle {
				< 108.194768, 36.733177, 20.259706>,
				< 110.172220, 32.000870, 43.096475>,
				< 110.763371, 28.653920, 39.716948>
			}
			triangle {
				< 108.194768, 36.733177, 20.259706>,
				< 107.020408, 43.237124, 26.761230>,
				< 110.172220, 32.000870, 43.096475>
			}
			triangle {
				< 107.020408, 43.237124, 26.761230>,
				< 109.422654, 34.512911, 47.590222>,
				< 110.172220, 32.000870, 43.096475>
			}
			triangle {
				< 107.020408, 43.237124, 26.761230>,
				< 105.526105, 48.161119, 35.458025>,
				< 109.422654, 34.512911, 47.590222>
			}
			triangle {
				< 105.526105, 48.161119, 35.458025>,
				< 108.565658, 36.011077, 52.888732>,
				< 109.422654, 34.512911, 47.590222>
			}
			triangle {
				< 105.526105, 48.161119, 35.458025>,
				< 103.813797, 51.140752, 45.745697>,
				< 108.565658, 36.011077, 52.888732>
			}
			triangle {
				< 103.813797, 51.140752, 45.745697>,
				< 107.659370, 36.384258, 58.623634>,
				< 108.565658, 36.011077, 52.888732>
			}
			triangle {
				< 103.813797, 51.140752, 45.745697>,
				< 102.000058, 51.938646, 56.895565>,
				< 107.659370, 36.384258, 58.623634>
			}
			triangle {
				< 102.000058, 51.938646, 56.895565>,
				< 106.765836, 35.598982, 64.394519>,
				< 107.659370, 36.384258, 58.623634>
			}
			triangle {
				< 102.000058, 51.938646, 56.895565>,
				< 100.208573, 50.469898, 68.112239>,
				< 106.765836, 35.598982, 64.394519>
			}
			triangle {
				< 100.208573, 50.469898, 68.112239>,
				< 105.945863, 33.704091, 69.798991>,
				< 106.765836, 35.598982, 64.394519>
			}
			triangle {
				< 100.208573, 50.469898, 68.112239>,
				< 98.561421, 46.816744, 78.597352>,
				< 105.945863, 33.704091, 69.798991>
			}
			triangle {
				< 98.561421, 46.816744, 78.597352>,
				< 105.255410, 30.828631, 74.462466>,
				< 105.945863, 33.704091, 69.798991>
			}
			triangle {
				< 98.561421, 46.816744, 78.597352>,
				< 97.170904, 41.227840, 87.612711>,
				< 105.255410, 30.828631, 74.462466>
			}
			triangle {
				< 97.170904, 41.227840, 87.612711>,
				< 104.741305, 27.173096, 78.065507>,
				< 105.255410, 30.828631, 74.462466>
			}
			triangle {
				< 97.170904, 41.227840, 87.612711>,
				< 96.131556, 34.101453, 94.537750>,
				< 104.741305, 27.173096, 78.065507>
			}
			triangle {
				< 96.131556, 34.101453, 94.537750>,
				< 104.438826, 22.994472, 80.365792>,
				< 104.741305, 27.173096, 78.065507>
			}
			triangle {
				< 96.131556, 34.101453, 94.537750>,
				< 95.514335, 25.953248, 98.912768>,
				< 104.438826, 22.994472, 80.365792>
			}
			triangle {
				< 95.514335, 25.953248, 98.912768>,
				< 104.368336, 18.586574, 81.213884>,
				< 104.438826, 22.994472, 80.365792>
			}
			triangle {
				< 95.514335, 25.953248, 98.912768>,
				< 95.361389, 17.372573, 100.467257>,
				< 104.368336, 18.586574, 81.213884>
			}
			triangle {
				< 95.361389, 17.372573, 100.467257>,
				< 104.534931, 14.257546, 80.561571>,
				< 104.368336, 18.586574, 81.213884>
			}
			triangle {
				< 95.361389, 17.372573, 100.467257>,
				< 95.683068, 8.973273, 99.130690>,
				< 104.534931, 14.257546, 80.561571>
			}
			triangle {
				< 95.683068, 8.973273, 99.130690>,
				< 104.927294, 10.306829, 78.462325>,
				< 104.534931, 14.257546, 80.561571>
			}
			triangle {
				< 95.683068, 8.973273, 99.130690>,
				< 96.457474, 1.343044, 95.027924>,
				< 104.927294, 10.306829, 78.462325>
			}
			triangle {
				< 96.457474, 1.343044, 95.027924>,
				< 105.518304, 7.003800, 75.065359>,
				< 104.927294, 10.306829, 78.462325>
			}
			triangle {
				< 96.457474, 1.343044, 95.027924>,
				< 97.631887, -4.998796, 88.461511>,
				< 105.518304, 7.003800, 75.065359>
			}
			triangle {
				< 97.631887, -4.998796, 88.461511>,
				< 106.267780, 4.568594, 70.603974>,
				< 105.518304, 7.003800, 75.065359>
			}
			triangle {
				< 97.631887, -4.998796, 88.461511>,
				< 99.126153, -9.637005, 79.885155>,
				< 106.267780, 4.568594, 70.603974>
			}
			triangle {
				< 99.126153, -9.637005, 79.885155>,
				< 107.124940, 3.159801, 65.378860>,
				< 106.267780, 4.568594, 70.603974>
			}
			triangle {
				< 99.126153, -9.637005, 79.885155>,
				< 100.838490, -12.283959, 69.871165>,
				< 107.124940, 3.159801, 65.378860>
			}
			triangle {
				< 100.838490, -12.283959, 69.871165>,
				< 108.031169, 2.864606, 59.738826>,
				< 107.124940, 3.159801, 65.378860>
			}
			triangle {
				< 100.838490, -12.283959, 69.871165>,
				< 102.652162, -12.791178, 59.074689>,
				< 108.031169, 2.864606, 59.738826>
			}
			triangle {
				< 102.652162, -12.791178, 59.074689>,
				< 108.924724, 3.695575, 54.058786>,
				< 108.031169, 2.864606, 59.738826>
			}
			triangle {
				< 102.652162, -12.791178, 59.074689>,
				< 104.443692, -11.151853, 48.196539>,
				< 108.924724, 3.695575, 54.058786>
			}
			triangle {
				< 104.443692, -11.151853, 48.196539>,
				< 109.744541, 5.591632, 48.716825>,
				< 108.924724, 3.695575, 54.058786>
			}
			triangle {
				< 104.443692, -11.151853, 48.196539>,
				< 106.090829, -7.493852, 37.944369>,
				< 109.744541, 5.591632, 48.716825>
			}
			triangle {
				< 106.090829, -7.493852, 37.944369>,
				< 110.435136, 8.423421, 44.070657>,
				< 109.744541, 5.591632, 48.716825>
			}
			triangle {
				< 106.090829, -7.493852, 37.944369>,
				< 107.481398, -2.067194, 28.993828>,
				< 110.435136, 8.423421, 44.070657>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 108.924724, 3.695575, 54.058786>,
				< 109.744541, 5.591632, 48.716825>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 108.031169, 2.864606, 59.738826>,
				< 108.924724, 3.695575, 54.058786>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 107.124940, 3.159801, 65.378860>,
				< 108.031169, 2.864606, 59.738826>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 106.267780, 4.568594, 70.603974>,
				< 107.124940, 3.159801, 65.378860>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 105.518304, 7.003800, 75.065359>,
				< 106.267780, 4.568594, 70.603974>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 104.927294, 10.306829, 78.462325>,
				< 105.518304, 7.003800, 75.065359>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 104.534931, 14.257546, 80.561571>,
				< 104.927294, 10.306829, 78.462325>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 104.368336, 18.586574, 81.213884>,
				< 104.534931, 14.257546, 80.561571>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 104.438826, 22.994472, 80.365792>,
				< 104.368336, 18.586574, 81.213884>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 104.741305, 27.173096, 78.065507>,
				< 104.438826, 22.994472, 80.365792>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 105.255410, 30.828631, 74.462466>,
				< 104.741305, 27.173096, 78.065507>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 105.945863, 33.704091, 69.798991>,
				< 105.255410, 30.828631, 74.462466>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 106.765836, 35.598982, 64.394519>,
				< 105.945863, 33.704091, 69.798991>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 107.659370, 36.384258, 58.623634>,
				< 106.765836, 35.598982, 64.394519>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 108.565658, 36.011077, 52.888732>,
				< 107.659370, 36.384258, 58.623634>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 109.422654, 34.512911, 47.590222>,
				< 108.565658, 36.011077, 52.888732>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 110.172220, 32.000870, 43.096475>,
				< 109.422654, 34.512911, 47.590222>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 110.763371, 28.653920, 39.716948>,
				< 110.172220, 32.000870, 43.096475>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 111.155525, 24.704352, 37.680104>,
				< 110.763371, 28.653920, 39.716948>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 111.321926, 20.421028, 37.118636>,
				< 111.155525, 24.704352, 37.680104>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 111.251801, 16.091108, 38.061611>,
				< 111.321926, 20.421028, 37.118636>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 110.949226, 12.001852, 40.435288>,
				< 111.251801, 16.091108, 38.061611>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 110.435136, 8.423421, 44.070657>,
				< 110.949226, 12.001852, 40.435288>
			}
			triangle {
				< 109.727815, 19.641601, 59.589200>,
				< 109.744541, 5.591632, 48.716825>,
				< 110.435136, 8.423421, 44.070657>
			}
			
		}
		// _calf03
		union {
			triangle {
				< -141.009018, -8.676595, -245.638654>,
				< -141.025126, -5.661391, -243.483752>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.979290, -11.096894, -249.228954>,
				< -141.009018, -8.676595, -245.638654>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.934110, -12.757446, -254.009753>,
				< -140.979290, -11.096894, -249.228954>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.872493, -13.544999, -259.654939>,
				< -140.934110, -12.757446, -254.009753>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.795544, -13.405911, -265.779853>,
				< -140.872493, -13.544999, -259.654939>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.707150, -12.349684, -271.966696>,
				< -140.795544, -13.405911, -265.779853>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.614063, -10.448284, -277.794003>,
				< -140.707150, -12.349684, -271.966696>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.525341, -7.831277, -282.864869>,
				< -140.614063, -10.448284, -277.794003>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.450850, -4.677006, -286.833912>,
				< -140.525341, -7.831277, -282.864869>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.399724, -1.200480, -289.430797>,
				< -140.450850, -4.677006, -286.833912>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.378550, 2.361450, -290.478885>,
				< -140.399724, -1.200480, -289.430797>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.390158, 5.766010, -289.906919>,
				< -140.378550, 2.361450, -290.478885>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.432954, 8.781193, -287.753522>,
				< -140.390158, 5.766010, -289.906919>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.501425, 11.201245, -284.165502>,
				< -140.432954, 8.781193, -287.753522>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.586987, 12.861775, -279.387176>,
				< -140.501425, 11.201245, -284.165502>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.679792, 13.649329, -273.743719>,
				< -140.586987, 12.861775, -279.387176>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.770391, 13.510272, -267.619789>,
				< -140.679792, 13.649329, -273.743719>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.851244, 12.454034, -261.432439>,
				< -140.770391, 13.510272, -267.619789>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.917629, 10.552645, -255.603552>,
				< -140.851244, 12.454034, -261.432439>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -140.967622, 7.935897, -250.530332>,
				< -140.917629, 10.552645, -255.603552>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -141.001731, 4.781646, -246.558949>,
				< -140.967622, 7.935897, -250.530332>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -141.021669, 1.305099, -243.960157>,
				< -141.001731, 4.781646, -246.558949>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -141.029179, -2.256810, -242.911220>,
				< -141.021669, 1.305099, -243.960157>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -141.025126, -5.661391, -243.483752>,
				< -141.029179, -2.256810, -242.911220>,
				< -141.967699, 0.052310, -266.718119>
			}
			triangle {
				< -137.421861, -16.810596, -225.964338>,
				< -137.407064, -10.985736, -221.800163>,
				< -141.025126, -5.661391, -243.483752>
			}
			triangle {
				< -141.009018, -8.676595, -245.638654>,
				< -137.421861, -16.810596, -225.964338>,
				< -141.025126, -5.661391, -243.483752>
			}
			triangle {
				< -137.435719, -21.486305, -232.902184>,
				< -137.421861, -16.810596, -225.964338>,
				< -141.009018, -8.676595, -245.638654>
			}
			triangle {
				< -140.979290, -11.096894, -249.228954>,
				< -137.435719, -21.486305, -232.902184>,
				< -141.009018, -8.676595, -245.638654>
			}
			triangle {
				< -137.433290, -24.694208, -242.140085>,
				< -137.435719, -21.486305, -232.902184>,
				< -140.979290, -11.096894, -249.228954>
			}
			triangle {
				< -140.934110, -12.757446, -254.009753>,
				< -137.433290, -24.694208, -242.140085>,
				< -140.979290, -11.096894, -249.228954>
			}
			triangle {
				< -137.399644, -26.215641, -253.047824>,
				< -137.433290, -24.694208, -242.140085>,
				< -140.934110, -12.757446, -254.009753>
			}
			triangle {
				< -140.872493, -13.544999, -259.654939>,
				< -137.399644, -26.215641, -253.047824>,
				< -140.934110, -12.757446, -254.009753>
			}
			triangle {
				< -137.325421, -25.946975, -264.881223>,
				< -137.399644, -26.215641, -253.047824>,
				< -140.872493, -13.544999, -259.654939>
			}
			triangle {
				< -140.795544, -13.405911, -265.779853>,
				< -137.325421, -25.946975, -264.881223>,
				< -140.872493, -13.544999, -259.654939>
			}
			triangle {
				< -137.210637, -23.906481, -276.833624>,
				< -137.325421, -25.946975, -264.881223>,
				< -140.795544, -13.405911, -265.779853>
			}
			triangle {
				< -140.707150, -12.349684, -271.966696>,
				< -137.210637, -23.906481, -276.833624>,
				< -140.795544, -13.405911, -265.779853>
			}
			triangle {
				< -137.065887, -20.233279, -288.090557>,
				< -137.210637, -23.906481, -276.833624>,
				< -140.707150, -12.349684, -271.966696>
			}
			triangle {
				< -140.614063, -10.448284, -277.794003>,
				< -137.065887, -20.233279, -288.090557>,
				< -140.707150, -12.349684, -271.966696>
			}
			triangle {
				< -136.911049, -15.177622, -297.885388>,
				< -137.065887, -20.233279, -288.090557>,
				< -140.614063, -10.448284, -277.794003>
			}
			triangle {
				< -140.525341, -7.831277, -282.864869>,
				< -136.911049, -15.177622, -297.885388>,
				< -140.614063, -10.448284, -277.794003>
			}
			triangle {
				< -136.771038, -9.084067, -305.551350>,
				< -136.911049, -15.177622, -297.885388>,
				< -140.525341, -7.831277, -282.864869>
			}
			triangle {
				< -140.450850, -4.677006, -286.833912>,
				< -136.771038, -9.084067, -305.551350>,
				< -140.525341, -7.831277, -282.864869>
			}
			triangle {
				< -136.670530, -2.367886, -310.567021>,
				< -136.771038, -9.084067, -305.551350>,
				< -140.450850, -4.677006, -286.833912>
			}
			triangle {
				< -140.399724, -1.200480, -289.430797>,
				< -136.670530, -2.367886, -310.567021>,
				< -140.450850, -4.677006, -286.833912>
			}
			triangle {
				< -136.627972, 4.513242, -312.591136>,
				< -136.670530, -2.367886, -310.567021>,
				< -140.399724, -1.200480, -289.430797>
			}
			triangle {
				< -140.378550, 2.361450, -290.478885>,
				< -136.627972, 4.513242, -312.591136>,
				< -140.399724, -1.200480, -289.430797>
			}
			triangle {
				< -136.651337, 11.090064, -311.486095>,
				< -136.627972, 4.513242, -312.591136>,
				< -140.378550, 2.361450, -290.478885>
			}
			triangle {
				< -140.390158, 5.766010, -289.906919>,
				< -136.651337, 11.090064, -311.486095>,
				< -140.378550, 2.361450, -290.478885>
			}
			triangle {
				< -136.736274, 16.914956, -307.327569>,
				< -136.651337, 11.090064, -311.486095>,
				< -140.390158, 5.766010, -289.906919>
			}
			triangle {
				< -140.432954, 8.781193, -287.753522>,
				< -136.736274, 16.914956, -307.327569>,
				< -140.390158, 5.766010, -289.906919>
			}
			triangle {
				< -136.866972, 21.590659, -300.397664>,
				< -136.736274, 16.914956, -307.327569>,
				< -140.432954, 8.781193, -287.753522>
			}
			triangle {
				< -140.501425, 11.201245, -284.165502>,
				< -136.866972, 21.590659, -300.397664>,
				< -140.432954, 8.781193, -287.753522>
			}
			triangle {
				< -137.020141, 24.798533, -291.167974>,
				< -136.866972, 21.590659, -300.397664>,
				< -140.501425, 11.201245, -284.165502>
			}
			triangle {
				< -140.586987, 12.861775, -279.387176>,
				< -137.020141, 24.798533, -291.167974>,
				< -140.501425, 11.201245, -284.165502>
			}
			triangle {
				< -137.170255, 26.320007, -280.266643>,
				< -137.020141, 24.798533, -291.167974>,
				< -140.586987, 12.861775, -279.387176>
			}
			triangle {
				< -140.679792, 13.649329, -273.743719>,
				< -137.170255, 26.320007, -280.266643>,
				< -140.586987, 12.861775, -279.387176>
			}
			triangle {
				< -137.295470, 26.051322, -268.435955>,
				< -137.170255, 26.320007, -280.266643>,
				< -140.679792, 13.649329, -273.743719>
			}
			triangle {
				< -140.770391, 13.510272, -267.619789>,
				< -137.295470, 26.051322, -268.435955>,
				< -140.679792, 13.649329, -273.743719>
			}
			triangle {
				< -137.382150, 24.010856, -256.482035>,
				< -137.295470, 26.051322, -268.435955>,
				< -140.770391, 13.510272, -267.619789>
			}
			triangle {
				< -140.851244, 12.454034, -261.432439>,
				< -137.382150, 24.010856, -256.482035>,
				< -140.770391, 13.510272, -267.619789>
			}
			triangle {
				< -137.427166, 20.337641, -245.219618>,
				< -137.382150, 24.010856, -256.482035>,
				< -140.851244, 12.454034, -261.432439>
			}
			triangle {
				< -140.917629, 10.552645, -255.603552>,
				< -137.427166, 20.337641, -245.219618>,
				< -140.851244, 12.454034, -261.432439>
			}
			triangle {
				< -137.437418, 15.281972, -235.416964>,
				< -137.427166, 20.337641, -245.219618>,
				< -140.917629, 10.552645, -255.603552>
			}
			triangle {
				< -140.967622, 7.935897, -250.530332>,
				< -137.437418, 15.281972, -235.416964>,
				< -140.917629, 10.552645, -255.603552>
			}
			triangle {
				< -137.426689, 9.188707, -227.742746>,
				< -137.437418, 15.281972, -235.416964>,
				< -140.967622, 7.935897, -250.530332>
			}
			triangle {
				< -141.001731, 4.781646, -246.558949>,
				< -137.426689, 9.188707, -227.742746>,
				< -140.967622, 7.935897, -250.530332>
			}
			triangle {
				< -137.410745, 2.472526, -222.720787>,
				< -137.426689, 9.188707, -227.742746>,
				< -141.001731, 4.781646, -246.558949>
			}
			triangle {
				< -141.021669, 1.305099, -243.960157>,
				< -137.410745, 2.472526, -222.720787>,
				< -141.001731, 4.781646, -246.558949>
			}
			triangle {
				< -137.402296, -4.408602, -220.693797>,
				< -137.410745, 2.472526, -222.720787>,
				< -141.021669, 1.305099, -243.960157>
			}
			triangle {
				< -141.029179, -2.256810, -242.911220>,
				< -137.402296, -4.408602, -220.693797>,
				< -141.021669, 1.305099, -243.960157>
			}
			triangle {
				< -137.407064, -10.985736, -221.800163>,
				< -137.402296, -4.408602, -220.693797>,
				< -141.029179, -2.256810, -242.911220>
			}
			triangle {
				< -141.025126, -5.661391, -243.483752>,
				< -137.407064, -10.985736, -221.800163>,
				< -141.029179, -2.256810, -242.911220>
			}
			triangle {
				< -131.330892, -23.795463, -209.076747>,
				< -131.231502, -15.557826, -203.187048>,
				< -137.407064, -10.985736, -221.800163>
			}
			triangle {
				< -137.421861, -16.810596, -225.964338>,
				< -131.330892, -23.795463, -209.076747>,
				< -137.407064, -10.985736, -221.800163>
			}
			triangle {
				< -131.474838, -30.407904, -218.889296>,
				< -131.330892, -23.795463, -209.076747>,
				< -137.421861, -16.810596, -225.964338>
			}
			triangle {
				< -137.435719, -21.486305, -232.902184>,
				< -131.474838, -30.407904, -218.889296>,
				< -137.421861, -16.810596, -225.964338>
			}
			triangle {
				< -131.624669, -34.944523, -231.954813>,
				< -131.474838, -30.407904, -218.889296>,
				< -137.435719, -21.486305, -232.902184>
			}
			triangle {
				< -137.433290, -24.694208, -242.140085>,
				< -131.624669, -34.944523, -231.954813>,
				< -137.435719, -21.486305, -232.902184>
			}
			triangle {
				< -131.740063, -37.096206, -247.381747>,
				< -131.624669, -34.944523, -231.954813>,
				< -137.433290, -24.694208, -242.140085>
			}
			triangle {
				< -137.399644, -26.215641, -253.047824>,
				< -131.740063, -37.096206, -247.381747>,
				< -137.433290, -24.694208, -242.140085>
			}
			triangle {
				< -131.789848, -36.716212, -264.117628>,
				< -131.740063, -37.096206, -247.381747>,
				< -137.399644, -26.215641, -253.047824>
			}
			triangle {
				< -137.325421, -25.946975, -264.881223>,
				< -131.789848, -36.716212, -264.117628>,
				< -137.399644, -26.215641, -253.047824>
			}
			triangle {
				< -131.760433, -33.830553, -281.021148>,
				< -131.789848, -36.716212, -264.117628>,
				< -137.325421, -25.946975, -264.881223>
			}
			triangle {
				< -137.210637, -23.906481, -276.833624>,
				< -131.760433, -33.830553, -281.021148>,
				< -137.325421, -25.946975, -264.881223>
			}
			triangle {
				< -131.659493, -28.635835, -296.940446>,
				< -131.760433, -33.830553, -281.021148>,
				< -137.210637, -23.906481, -276.833624>
			}
			triangle {
				< -137.065887, -20.233279, -288.090557>,
				< -131.659493, -28.635835, -296.940446>,
				< -137.210637, -23.906481, -276.833624>
			}
			triangle {
				< -131.513849, -21.486055, -310.791403>,
				< -131.659493, -28.635835, -296.940446>,
				< -137.065887, -20.233279, -288.090557>
			}
			triangle {
				< -136.911049, -15.177622, -297.885388>,
				< -131.513849, -21.486055, -310.791403>,
				< -137.065887, -20.233279, -288.090557>
			}
			triangle {
				< -131.362319, -12.868481, -321.631253>,
				< -131.513849, -21.486055, -310.791403>,
				< -136.911049, -15.177622, -297.885388>
			}
			triangle {
				< -136.771038, -9.084067, -305.551350>,
				< -131.362319, -12.868481, -321.631253>,
				< -136.911049, -15.177622, -297.885388>
			}
			triangle {
				< -131.245300, -3.370366, -328.723371>,
				< -131.362319, -12.868481, -321.631253>,
				< -136.771038, -9.084067, -305.551350>
			}
			triangle {
				< -136.670530, -2.367886, -310.567021>,
				< -131.245300, -3.370366, -328.723371>,
				< -136.771038, -9.084067, -305.551350>
			}
			triangle {
				< -131.194085, 6.360997, -331.585586>,
				< -131.245300, -3.370366, -328.723371>,
				< -136.670530, -2.367886, -310.567021>
			}
			triangle {
				< -136.627972, 4.513242, -312.591136>,
				< -131.194085, 6.360997, -331.585586>,
				< -136.670530, -2.367886, -310.567021>
			}
			triangle {
				< -131.222337, 15.662177, -330.023408>,
				< -131.194085, 6.360997, -331.585586>,
				< -136.627972, 4.513242, -312.591136>
			}
			triangle {
				< -136.651337, 11.090064, -311.486095>,
				< -131.222337, 15.662177, -330.023408>,
				< -136.627972, 4.513242, -312.591136>
			}
			triangle {
				< -131.322503, 23.899790, -324.142873>,
				< -131.222337, 15.662177, -330.023408>,
				< -136.651337, 11.090064, -311.486095>
			}
			triangle {
				< -136.736274, 16.914956, -307.327569>,
				< -131.322503, 23.899790, -324.142873>,
				< -136.651337, 11.090064, -311.486095>
			}
			triangle {
				< -131.467849, 30.512307, -314.343929>,
				< -131.322503, 23.899790, -324.142873>,
				< -136.736274, 16.914956, -307.327569>
			}
			triangle {
				< -136.866972, 21.590659, -300.397664>,
				< -131.467849, 30.512307, -314.343929>,
				< -136.736274, 16.914956, -307.327569>
			}
			triangle {
				< -131.619558, 35.048913, -301.292330>,
				< -131.467849, 30.512307, -314.343929>,
				< -136.866972, 21.590659, -300.397664>
			}
			triangle {
				< -137.020141, 24.798533, -291.167974>,
				< -131.619558, 35.048913, -301.292330>,
				< -136.866972, 21.590659, -300.397664>
			}
			triangle {
				< -131.737202, 37.200600, -285.876095>,
				< -131.619558, 35.048913, -301.292330>,
				< -137.020141, 24.798533, -291.167974>
			}
			triangle {
				< -137.170255, 26.320007, -280.266643>,
				< -131.737202, 37.200600, -285.876095>,
				< -137.020141, 24.798533, -291.167974>
			}
			triangle {
				< -131.789476, 36.820620, -269.144922>,
				< -131.737202, 37.200600, -285.876095>,
				< -137.170255, 26.320007, -280.266643>
			}
			triangle {
				< -137.295470, 26.051322, -268.435955>,
				< -131.789476, 36.820620, -269.144922>,
				< -137.170255, 26.320007, -280.266643>
			}
			triangle {
				< -131.762594, 33.934984, -252.238780>,
				< -131.789476, 36.820620, -269.144922>,
				< -137.295470, 26.051322, -268.435955>
			}
			triangle {
				< -137.382150, 24.010856, -256.482035>,
				< -131.762594, 33.934984, -252.238780>,
				< -137.295470, 26.051322, -268.435955>
			}
			triangle {
				< -131.664008, 28.740212, -236.310333>,
				< -131.762594, 33.934984, -252.238780>,
				< -137.382150, 24.010856, -256.482035>
			}
			triangle {
				< -137.427166, 20.337641, -245.219618>,
				< -131.664008, 28.740212, -236.310333>,
				< -137.382150, 24.010856, -256.482035>
			}
			triangle {
				< -131.520376, 21.590412, -222.446010>,
				< -131.664008, 28.740212, -236.310333>,
				< -137.427166, 20.337641, -245.219618>
			}
			triangle {
				< -137.437418, 15.281972, -235.416964>,
				< -131.520376, 21.590412, -222.446010>,
				< -137.427166, 20.337641, -245.219618>
			}
			triangle {
				< -131.370351, 12.972842, -211.592019>,
				< -131.520376, 21.590412, -222.446010>,
				< -137.437418, 15.281972, -235.416964>
			}
			triangle {
				< -137.426689, 9.188707, -227.742746>,
				< -131.370351, 12.972842, -211.592019>,
				< -137.437418, 15.281972, -235.416964>
			}
			triangle {
				< -131.254330, 3.475006, -204.489112>,
				< -131.370351, 12.972842, -211.592019>,
				< -137.426689, 9.188707, -227.742746>
			}
			triangle {
				< -137.410745, 2.472526, -222.720787>,
				< -131.254330, 3.475006, -204.489112>,
				< -137.426689, 9.188707, -227.742746>
			}
			triangle {
				< -131.203488, -6.256357, -201.622248>,
				< -131.254330, 3.475006, -204.489112>,
				< -137.410745, 2.472526, -222.720787>
			}
			triangle {
				< -137.402296, -4.408602, -220.693797>,
				< -131.203488, -6.256357, -201.622248>,
				< -137.410745, 2.472526, -222.720787>
			}
			triangle {
				< -131.231502, -15.557826, -203.187048>,
				< -131.203488, -6.256357, -201.622248>,
				< -137.402296, -4.408602, -220.693797>
			}
			triangle {
				< -137.407064, -10.985736, -221.800163>,
				< -131.231502, -15.557826, -203.187048>,
				< -137.402296, -4.408602, -220.693797>
			}
			triangle {
				< -123.144656, -29.155130, -196.183965>,
				< -122.916989, -19.066114, -188.971877>,
				< -131.231502, -15.557826, -203.187048>
			}
			triangle {
				< -131.330892, -23.795463, -209.076747>,
				< -123.144656, -29.155130, -196.183965>,
				< -131.231502, -15.557826, -203.187048>
			}
			triangle {
				< -123.491637, -37.253689, -208.200023>,
				< -123.144656, -29.155130, -196.183965>,
				< -131.330892, -23.795463, -209.076747>
			}
			triangle {
				< -131.474838, -30.407904, -218.889296>,
				< -123.491637, -37.253689, -208.200023>,
				< -131.330892, -23.795463, -209.076747>
			}
			triangle {
				< -123.890869, -42.809892, -224.199951>,
				< -123.491637, -37.253689, -208.200023>,
				< -131.474838, -30.407904, -218.889296>
			}
			triangle {
				< -131.624669, -34.944523, -231.954813>,
				< -123.890869, -42.809892, -224.199951>,
				< -131.474838, -30.407904, -218.889296>
			}
			triangle {
				< -124.269918, -45.445122, -243.092075>,
				< -123.890869, -42.809892, -224.199951>,
				< -131.624669, -34.944523, -231.954813>
			}
			triangle {
				< -131.740063, -37.096206, -247.381747>,
				< -124.269918, -45.445122, -243.092075>,
				< -131.624669, -34.944523, -231.954813>
			}
			triangle {
				< -124.568023, -44.979770, -263.587654>,
				< -124.269918, -45.445122, -243.092075>,
				< -131.740063, -37.096206, -247.381747>
			}
			triangle {
				< -131.789848, -36.716212, -264.117628>,
				< -124.568023, -44.979770, -263.587654>,
				< -131.740063, -37.096206, -247.381747>
			}
			triangle {
				< -124.749623, -41.445587, -284.288824>,
				< -124.568023, -44.979770, -263.587654>,
				< -131.789848, -36.716212, -264.117628>
			}
			triangle {
				< -131.760433, -33.830553, -281.021148>,
				< -124.749623, -41.445587, -284.288824>,
				< -131.789848, -36.716212, -264.117628>
			}
			triangle {
				< -124.810755, -35.083335, -303.784847>,
				< -124.749623, -41.445587, -284.288824>,
				< -131.760433, -33.830553, -281.021148>
			}
			triangle {
				< -131.659493, -28.635835, -296.940446>,
				< -124.810755, -35.083335, -303.784847>,
				< -131.760433, -33.830553, -281.021148>
			}
			triangle {
				< -124.777213, -26.326695, -320.747763>,
				< -124.810755, -35.083335, -303.784847>,
				< -131.659493, -28.635835, -296.940446>
			}
			triangle {
				< -131.513849, -21.486055, -310.791403>,
				< -124.777213, -26.326695, -320.747763>,
				< -131.659493, -28.635835, -296.940446>
			}
			triangle {
				< -124.694623, -15.772339, -334.023118>,
				< -124.777213, -26.326695, -320.747763>,
				< -131.513849, -21.486055, -310.791403>
			}
			triangle {
				< -131.362319, -12.868481, -321.631253>,
				< -124.694623, -15.772339, -334.023118>,
				< -131.513849, -21.486055, -310.791403>
			}
			triangle {
				< -124.613807, -4.139597, -342.708558>,
				< -124.694623, -15.772339, -334.023118>,
				< -131.362319, -12.868481, -321.631253>
			}
			triangle {
				< -131.245300, -3.370366, -328.723371>,
				< -124.613807, -4.139597, -342.708558>,
				< -131.362319, -12.868481, -321.631253>
			}
			triangle {
				< -124.575213, 7.778858, -346.213669>,
				< -124.613807, -4.139597, -342.708558>,
				< -131.245300, -3.370366, -328.723371>
			}
			triangle {
				< -131.194085, 6.360997, -331.585586>,
				< -124.575213, 7.778858, -346.213669>,
				< -131.245300, -3.370366, -328.723371>
			}
			triangle {
				< -124.596715, 19.170472, -344.300658>,
				< -124.575213, 7.778858, -346.213669>,
				< -131.194085, 6.360997, -331.585586>
			}
			triangle {
				< -131.222337, 15.662177, -330.023408>,
				< -124.596715, 19.170472, -344.300658>,
				< -131.194085, 6.360997, -331.585586>
			}
			triangle {
				< -124.668449, 29.259527, -337.099195>,
				< -124.596715, 19.170472, -344.300658>,
				< -131.222337, 15.662177, -330.023408>
			}
			triangle {
				< -131.322503, 23.899790, -324.142873>,
				< -124.668449, 29.259527, -337.099195>,
				< -131.222337, 15.662177, -330.023408>
			}
			triangle {
				< -124.755606, 37.358072, -325.098455>,
				< -124.668449, 29.259527, -337.099195>,
				< -131.322503, 23.899790, -324.142873>
			}
			triangle {
				< -131.467849, 30.512307, -314.343929>,
				< -124.755606, 37.358072, -325.098455>,
				< -131.322503, 23.899790, -324.142873>
			}
			triangle {
				< -124.808922, 42.914245, -309.114456>,
				< -124.755606, 37.358072, -325.098455>,
				< -131.467849, 30.512307, -314.343929>
			}
			triangle {
				< -131.619558, 35.048913, -301.292330>,
				< -124.808922, 42.914245, -309.114456>,
				< -131.467849, 30.512307, -314.343929>
			}
			triangle {
				< -124.779567, 45.549497, -290.234476>,
				< -124.808922, 42.914245, -309.114456>,
				< -131.619558, 35.048913, -301.292330>
			}
			triangle {
				< -131.737202, 37.200600, -285.876095>,
				< -124.779567, 45.549497, -290.234476>,
				< -131.619558, 35.048913, -301.292330>
			}
			triangle {
				< -124.634601, 45.084205, -269.744337>,
				< -124.779567, 45.549497, -290.234476>,
				< -131.737202, 37.200600, -285.876095>
			}
			triangle {
				< -131.789476, 36.820620, -269.144922>,
				< -124.634601, 45.084205, -269.744337>,
				< -131.737202, 37.200600, -285.876095>
			}
			triangle {
				< -124.368556, 41.549969, -249.040231>,
				< -124.634601, 45.084205, -269.744337>,
				< -131.789476, 36.820620, -269.144922>
			}
			triangle {
				< -131.762594, 33.934984, -252.238780>,
				< -124.368556, 41.549969, -249.040231>,
				< -131.789476, 36.820620, -269.144922>
			}
			triangle {
				< -124.008015, 35.187732, -229.533672>,
				< -124.368556, 41.549969, -249.040231>,
				< -131.762594, 33.934984, -252.238780>
			}
			triangle {
				< -131.664008, 28.740212, -236.310333>,
				< -124.008015, 35.187732, -229.533672>,
				< -131.762594, 33.934984, -252.238780>
			}
			triangle {
				< -123.607419, 26.431073, -212.555438>,
				< -124.008015, 35.187732, -229.533672>,
				< -131.664008, 28.740212, -236.310333>
			}
			triangle {
				< -131.520376, 21.590412, -222.446010>,
				< -123.607419, 26.431073, -212.555438>,
				< -131.664008, 28.740212, -236.310333>
			}
			triangle {
				< -123.237461, 15.876731, -199.264005>,
				< -123.607419, 26.431073, -212.555438>,
				< -131.520376, 21.590412, -222.446010>
			}
			triangle {
				< -131.370351, 12.972842, -211.592019>,
				< -123.237461, 15.876731, -199.264005>,
				< -131.520376, 21.590412, -222.446010>
			}
			triangle {
				< -122.968554, 4.244237, -190.566361>,
				< -123.237461, 15.876731, -199.264005>,
				< -131.370351, 12.972842, -211.592019>
			}
			triangle {
				< -131.254330, 3.475006, -204.489112>,
				< -122.968554, 4.244237, -190.566361>,
				< -131.370351, 12.972842, -211.592019>
			}
			triangle {
				< -122.854032, -7.674198, -187.055737>,
				< -122.968554, 4.244237, -190.566361>,
				< -131.254330, 3.475006, -204.489112>
			}
			triangle {
				< -131.203488, -6.256357, -201.622248>,
				< -122.854032, -7.674198, -187.055737>,
				< -131.254330, 3.475006, -204.489112>
			}
			triangle {
				< -122.916989, -19.066114, -188.971877>,
				< -122.854032, -7.674198, -187.055737>,
				< -131.203488, -6.256357, -201.622248>
			}
			triangle {
				< -131.231502, -15.557826, -203.187048>,
				< -122.916989, -19.066114, -188.971877>,
				< -131.203488, -6.256357, -201.622248>
			}
			triangle {
				< -113.530211, -32.524351, -188.220784>,
				< -113.155052, -21.271529, -180.180654>,
				< -122.916989, -19.066114, -188.971877>
			}
			triangle {
				< -123.144656, -29.155130, -196.183965>,
				< -113.530211, -32.524351, -188.220784>,
				< -122.916989, -19.066114, -188.971877>
			}
			triangle {
				< -114.114992, -41.557107, -201.616988>,
				< -113.530211, -32.524351, -188.220784>,
				< -123.144656, -29.155130, -196.183965>
			}
			triangle {
				< -123.491637, -37.253689, -208.200023>,
				< -114.114992, -41.557107, -201.616988>,
				< -123.144656, -29.155130, -196.183965>
			}
			triangle {
				< -114.815585, -47.754280, -219.455585>,
				< -114.114992, -41.557107, -201.616988>,
				< -123.491637, -37.253689, -208.200023>
			}
			triangle {
				< -123.890869, -42.809892, -224.199951>,
				< -114.815585, -47.754280, -219.455585>,
				< -123.491637, -37.253689, -208.200023>
			}
			triangle {
				< -115.527906, -50.693441, -240.520164>,
				< -114.815585, -47.754280, -219.455585>,
				< -123.890869, -42.809892, -224.199951>
			}
			triangle {
				< -124.269918, -45.445122, -243.092075>,
				< -115.527906, -50.693441, -240.520164>,
				< -123.890869, -42.809892, -224.199951>
			}
			triangle {
				< -116.160005, -50.174430, -263.373852>,
				< -115.527906, -50.693441, -240.520164>,
				< -124.269918, -45.445122, -243.092075>
			}
			triangle {
				< -124.568023, -44.979770, -263.587654>,
				< -116.160005, -50.174430, -263.373852>,
				< -124.269918, -45.445122, -243.092075>
			}
			triangle {
				< -116.649747, -46.232503, -286.458343>,
				< -116.160005, -50.174430, -263.373852>,
				< -124.568023, -44.979770, -263.587654>
			}
			triangle {
				< -124.749623, -41.445587, -284.288824>,
				< -116.649747, -46.232503, -286.458343>,
				< -124.568023, -44.979770, -263.587654>
			}
			triangle {
				< -116.974279, -39.136406, -308.199912>,
				< -116.649747, -46.232503, -286.458343>,
				< -124.749623, -41.445587, -284.288824>
			}
			triangle {
				< -124.810755, -35.083335, -303.784847>,
				< -116.974279, -39.136406, -308.199912>,
				< -124.749623, -41.445587, -284.288824>
			}
			triangle {
				< -117.148742, -29.369630, -327.117443>,
				< -116.974279, -39.136406, -308.199912>,
				< -124.810755, -35.083335, -303.784847>
			}
			triangle {
				< -124.777213, -26.326695, -320.747763>,
				< -117.148742, -29.369630, -327.117443>,
				< -124.810755, -35.083335, -303.784847>
			}
			triangle {
				< -117.215209, -17.597798, -341.922879>,
				< -117.148742, -29.369630, -327.117443>,
				< -124.777213, -26.326695, -320.747763>
			}
			triangle {
				< -124.694623, -15.772339, -334.023118>,
				< -117.215209, -17.597798, -341.922879>,
				< -124.777213, -26.326695, -320.747763>
			}
			triangle {
				< -117.225386, -4.623156, -351.609826>,
				< -117.215209, -17.597798, -341.922879>,
				< -124.694623, -15.772339, -334.023118>
			}
			triangle {
				< -124.613807, -4.139597, -342.708558>,
				< -117.225386, -4.623156, -351.609826>,
				< -124.694623, -15.772339, -334.023118>
			}
			triangle {
				< -117.222033, 8.670159, -355.519027>,
				< -117.225386, -4.623156, -351.609826>,
				< -124.613807, -4.139597, -342.708558>
			}
			triangle {
				< -124.575213, 7.778858, -346.213669>,
				< -117.222033, 8.670159, -355.519027>,
				< -124.613807, -4.139597, -342.708558>
			}
			triangle {
				< -117.224410, 21.375887, -353.385389>,
				< -117.222033, 8.670159, -355.519027>,
				< -124.575213, 7.778858, -346.213669>
			}
			triangle {
				< -124.596715, 19.170472, -344.300658>,
				< -117.224410, 21.375887, -353.385389>,
				< -124.575213, 7.778858, -346.213669>
			}
			triangle {
				< -117.221840, 32.628756, -345.353693>,
				< -117.224410, 21.375887, -353.385389>,
				< -124.596715, 19.170472, -344.300658>
			}
			triangle {
				< -124.668449, 29.259527, -337.099195>,
				< -117.221840, 32.628756, -345.353693>,
				< -124.596715, 19.170472, -344.300658>
			}
			triangle {
				< -117.177315, 41.661460, -331.969529>,
				< -117.221840, 32.628756, -345.353693>,
				< -124.668449, 29.259527, -337.099195>
			}
			triangle {
				< -124.755606, 37.358072, -325.098455>,
				< -117.177315, 41.661460, -331.969529>,
				< -124.668449, 29.259527, -337.099195>
			}
			triangle {
				< -117.039926, 47.858678, -314.143568>,
				< -117.177315, 41.661460, -331.969529>,
				< -124.755606, 37.358072, -325.098455>
			}
			triangle {
				< -124.808922, 42.914245, -309.114456>,
				< -117.039926, 47.858678, -314.143568>,
				< -124.755606, 37.358072, -325.098455>
			}
			triangle {
				< -116.762780, 50.797857, -293.088704>,
				< -117.039926, 47.858678, -314.143568>,
				< -124.808922, 42.914245, -309.114456>
			}
			triangle {
				< -124.779567, 45.549497, -290.234476>,
				< -116.762780, 50.797857, -293.088704>,
				< -124.808922, 42.914245, -309.114456>
			}
			triangle {
				< -116.321281, 50.278883, -270.239294>,
				< -116.762780, 50.797857, -293.088704>,
				< -124.779567, 45.549497, -290.234476>
			}
			triangle {
				< -124.634601, 45.084205, -269.744337>,
				< -116.321281, 50.278883, -270.239294>,
				< -124.779567, 45.549497, -290.234476>
			}
			triangle {
				< -115.726456, 46.336871, -247.152448>,
				< -116.321281, 50.278883, -270.239294>,
				< -124.634601, 45.084205, -269.744337>
			}
			triangle {
				< -124.368556, 41.549969, -249.040231>,
				< -115.726456, 46.336871, -247.152448>,
				< -124.634601, 45.084205, -269.744337>
			}
			triangle {
				< -115.029298, 39.240755, -225.402519>,
				< -115.726456, 46.336871, -247.152448>,
				< -124.368556, 41.549969, -249.040231>
			}
			triangle {
				< -124.008015, 35.187732, -229.533672>,
				< -115.029298, 39.240755, -225.402519>,
				< -124.368556, 41.549969, -249.040231>
			}
			triangle {
				< -114.314556, 29.474029, -206.472918>,
				< -115.029298, 39.240755, -225.402519>,
				< -124.008015, 35.187732, -229.533672>
			}
			triangle {
				< -123.607419, 26.431073, -212.555438>,
				< -114.314556, 29.474029, -206.472918>,
				< -124.008015, 35.187732, -229.533672>
			}
			triangle {
				< -113.684908, 17.702177, -191.654548>,
				< -114.314556, 29.474029, -206.472918>,
				< -123.607419, 26.431073, -212.555438>
			}
			triangle {
				< -123.237461, 15.876731, -199.264005>,
				< -113.684908, 17.702177, -191.654548>,
				< -123.607419, 26.431073, -212.555438>
			}
			triangle {
				< -113.239549, 4.727796, -181.958035>,
				< -113.684908, 17.702177, -191.654548>,
				< -123.237461, 15.876731, -199.264005>
			}
			triangle {
				< -122.968554, 4.244237, -190.566361>,
				< -113.239549, 4.727796, -181.958035>,
				< -123.237461, 15.876731, -199.264005>
			}
			triangle {
				< -113.052323, -8.565499, -178.044468>,
				< -113.239549, 4.727796, -181.958035>,
				< -122.968554, 4.244237, -190.566361>
			}
			triangle {
				< -122.854032, -7.674198, -187.055737>,
				< -113.052323, -8.565499, -178.044468>,
				< -122.968554, 4.244237, -190.566361>
			}
			triangle {
				< -113.155052, -21.271529, -180.180654>,
				< -113.052323, -8.565499, -178.044468>,
				< -122.854032, -7.674198, -187.055737>
			}
			triangle {
				< -122.916989, -19.066114, -188.971877>,
				< -113.155052, -21.271529, -180.180654>,
				< -122.854032, -7.674198, -187.055737>
			}
			triangle {
				< -103.338435, -33.673529, -185.765669>,
				< -102.830045, -22.023752, -177.448064>,
				< -113.155052, -21.271529, -180.180654>
			}
			triangle {
				< -113.530211, -32.524351, -188.220784>,
				< -103.338435, -33.673529, -185.765669>,
				< -113.155052, -21.271529, -180.180654>
			}
			triangle {
				< -104.142286, -43.024920, -199.624658>,
				< -103.338435, -33.673529, -185.765669>,
				< -113.530211, -32.524351, -188.220784>
			}
			triangle {
				< -114.114992, -41.557107, -201.616988>,
				< -104.142286, -43.024920, -199.624658>,
				< -113.530211, -32.524351, -188.220784>
			}
			triangle {
				< -105.129004, -49.440689, -218.080729>,
				< -104.142286, -43.024920, -199.624658>,
				< -114.114992, -41.557107, -201.616988>
			}
			triangle {
				< -114.815585, -47.754280, -219.455585>,
				< -105.129004, -49.440689, -218.080729>,
				< -114.114992, -41.557107, -201.616988>
			}
			triangle {
				< -106.170975, -52.483570, -239.876062>,
				< -105.129004, -49.440689, -218.080729>,
				< -114.815585, -47.754280, -219.455585>
			}
			triangle {
				< -115.527906, -50.693441, -240.520164>,
				< -106.170975, -52.483570, -239.876062>,
				< -114.815585, -47.754280, -219.455585>
			}
			triangle {
				< -107.150599, -51.946245, -263.524622>,
				< -106.170975, -52.483570, -239.876062>,
				< -115.527906, -50.693441, -240.520164>
			}
			triangle {
				< -116.160005, -50.174430, -263.373852>,
				< -107.150599, -51.946245, -263.524622>,
				< -115.527906, -50.693441, -240.520164>
			}
			triangle {
				< -107.980706, -47.865294, -287.414044>,
				< -107.150599, -51.946245, -263.524622>,
				< -116.160005, -50.174430, -263.373852>
			}
			triangle {
				< -116.649747, -46.232503, -286.458343>,
				< -107.980706, -47.865294, -287.414044>,
				< -116.160005, -50.174430, -263.373852>
			}
			triangle {
				< -108.616032, -40.518843, -309.915632>,
				< -107.980706, -47.865294, -287.414044>,
				< -116.649747, -46.232503, -286.458343>
			}
			triangle {
				< -116.974279, -39.136406, -308.199912>,
				< -108.616032, -40.518843, -309.915632>,
				< -116.649747, -46.232503, -286.458343>
			}
			triangle {
				< -109.053142, -30.407537, -329.495758>,
				< -108.616032, -40.518843, -309.915632>,
				< -116.974279, -39.136406, -308.199912>
			}
			triangle {
				< -117.148742, -29.369630, -327.117443>,
				< -109.053142, -30.407537, -329.495758>,
				< -116.974279, -39.136406, -308.199912>
			}
			triangle {
				< -109.320164, -18.220423, -344.821066>,
				< -109.053142, -30.407537, -329.495758>,
				< -117.148742, -29.369630, -327.117443>
			}
			triangle {
				< -117.215209, -17.597798, -341.922879>,
				< -109.320164, -18.220423, -344.821066>,
				< -117.148742, -29.369630, -327.117443>
			}
			triangle {
				< -109.459154, -4.788077, -354.848057>,
				< -109.320164, -18.220423, -344.821066>,
				< -117.215209, -17.597798, -341.922879>
			}
			triangle {
				< -117.225386, -4.623156, -351.609826>,
				< -109.459154, -4.788077, -354.848057>,
				< -117.215209, -17.597798, -341.922879>
			}
			triangle {
				< -109.507278, 8.974154, -358.894706>,
				< -109.459154, -4.788077, -354.848057>,
				< -117.225386, -4.623156, -351.609826>
			}
			triangle {
				< -117.222033, 8.670159, -355.519027>,
				< -109.507278, 8.974154, -358.894706>,
				< -117.225386, -4.623156, -351.609826>
			}
			triangle {
				< -109.481581, 22.128101, -356.686085>,
				< -109.507278, 8.974154, -358.894706>,
				< -117.222033, 8.670159, -355.519027>
			}
			triangle {
				< -117.224410, 21.375887, -353.385389>,
				< -109.481581, 22.128101, -356.686085>,
				< -117.222033, 8.670159, -355.519027>
			}
			triangle {
				< -109.372631, 33.777934, -348.372161>,
				< -109.481581, 22.128101, -356.686085>,
				< -117.224410, 21.375887, -353.385389>
			}
			triangle {
				< -117.221840, 32.628756, -345.353693>,
				< -109.372631, 33.777934, -348.372161>,
				< -117.224410, 21.375887, -353.385389>
			}
			triangle {
				< -109.147929, 43.129340, -334.518164>,
				< -109.372631, 33.777934, -348.372161>,
				< -117.221840, 32.628756, -345.353693>
			}
			triangle {
				< -117.177315, 41.661460, -331.969529>,
				< -109.147929, 43.129340, -334.518164>,
				< -117.221840, 32.628756, -345.353693>
			}
			triangle {
				< -108.764969, 49.545068, -316.067249>,
				< -109.147929, 43.129340, -334.518164>,
				< -117.177315, 41.661460, -331.969529>
			}
			triangle {
				< -117.039926, 47.858678, -314.143568>,
				< -108.764969, 49.545068, -316.067249>,
				< -117.177315, 41.661460, -331.969529>
			}
			triangle {
				< -108.189531, 52.588027, -294.276029>,
				< -108.764969, 49.545068, -316.067249>,
				< -117.039926, 47.858678, -314.143568>
			}
			triangle {
				< -116.762780, 50.797857, -293.088704>,
				< -108.189531, 52.588027, -294.276029>,
				< -117.039926, 47.858678, -314.143568>
			}
			triangle {
				< -107.414223, 52.050624, -270.629287>,
				< -108.189531, 52.588027, -294.276029>,
				< -116.762780, 50.797857, -293.088704>
			}
			triangle {
				< -116.321281, 50.278883, -270.239294>,
				< -107.414223, 52.050624, -270.629287>,
				< -116.762780, 50.797857, -293.088704>
			}
			triangle {
				< -106.471449, 47.969732, -246.738851>,
				< -107.414223, 52.050624, -270.629287>,
				< -116.321281, 50.278883, -270.239294>
			}
			triangle {
				< -115.726456, 46.336871, -247.152448>,
				< -106.471449, 47.969732, -246.738851>,
				< -116.321281, 50.278883, -270.239294>
			}
			triangle {
				< -105.436690, 40.623296, -224.233776>,
				< -106.471449, 47.969732, -246.738851>,
				< -115.726456, 46.336871, -247.152448>
			}
			triangle {
				< -115.029298, 39.240755, -225.402519>,
				< -105.436690, 40.623296, -224.233776>,
				< -115.726456, 46.336871, -247.152448>
			}
			triangle {
				< -104.420371, 30.511966, -204.648495>,
				< -105.436690, 40.623296, -224.233776>,
				< -115.029298, 39.240755, -225.402519>
			}
			triangle {
				< -114.314556, 29.474029, -206.472918>,
				< -104.420371, 30.511966, -204.648495>,
				< -115.029298, 39.240755, -225.402519>
			}
			triangle {
				< -103.549622, 18.324826, -189.317912>,
				< -104.420371, 30.511966, -204.648495>,
				< -114.314556, 29.474029, -206.472918>
			}
			triangle {
				< -113.684908, 17.702177, -191.654548>,
				< -103.549622, 18.324826, -189.317912>,
				< -114.314556, 29.474029, -206.472918>
			}
			triangle {
				< -102.944098, 4.892681, -179.286778>,
				< -103.549622, 18.324826, -189.317912>,
				< -113.684908, 17.702177, -191.654548>
			}
			triangle {
				< -113.239549, 4.727796, -181.958035>,
				< -102.944098, 4.892681, -179.286778>,
				< -113.684908, 17.702177, -191.654548>
			}
			triangle {
				< -102.691695, -8.869492, -175.238222>,
				< -102.944098, 4.892681, -179.286778>,
				< -113.239549, 4.727796, -181.958035>
			}
			triangle {
				< -113.052323, -8.565499, -178.044468>,
				< -102.691695, -8.869492, -175.238222>,
				< -113.239549, 4.727796, -181.958035>
			}
			triangle {
				< -102.830045, -22.023752, -177.448064>,
				< -102.691695, -8.869492, -175.238222>,
				< -113.052323, -8.565499, -178.044468>
			}
			triangle {
				< -113.155052, -21.271529, -180.180654>,
				< -102.830045, -22.023752, -177.448064>,
				< -113.052323, -8.565499, -178.044468>
			}
			triangle {
				< -93.493156, -32.524351, -188.989505>,
				< -92.899427, -21.271538, -180.962682>,
				< -102.830045, -22.023752, -177.448064>
			}
			triangle {
				< -103.338435, -33.673529, -185.765669>,
				< -93.493156, -32.524351, -188.989505>,
				< -102.830045, -22.023752, -177.448064>
			}
			triangle {
				< -94.442114, -41.557107, -202.364564>,
				< -93.493156, -32.524351, -188.989505>,
				< -103.338435, -33.673529, -185.765669>
			}
			triangle {
				< -104.142286, -43.024920, -199.624658>,
				< -94.442114, -41.557107, -202.364564>,
				< -103.338435, -33.673529, -185.765669>
			}
			triangle {
				< -95.627658, -47.754280, -220.177040>,
				< -94.442114, -41.557107, -202.364564>,
				< -104.142286, -43.024920, -199.624658>
			}
			triangle {
				< -105.129004, -49.440689, -218.080729>,
				< -95.627658, -47.754280, -220.177040>,
				< -104.142286, -43.024920, -199.624658>
			}
			triangle {
				< -96.912704, -50.693456, -241.213992>,
				< -95.627658, -47.754280, -220.177040>,
				< -105.129004, -49.440689, -218.080729>
			}
			triangle {
				< -106.170975, -52.483570, -239.876062>,
				< -96.912704, -50.693456, -241.213992>,
				< -105.129004, -49.440689, -218.080729>
			}
			triangle {
				< -98.166183, -50.174434, -264.041513>,
				< -96.912704, -50.693456, -241.213992>,
				< -106.170975, -52.483570, -239.876062>
			}
			triangle {
				< -107.150599, -51.946245, -263.524622>,
				< -98.166183, -50.174434, -264.041513>,
				< -106.170975, -52.483570, -239.876062>
			}
			triangle {
				< -99.283665, -46.232525, -287.103683>,
				< -98.166183, -50.174434, -264.041513>,
				< -107.150599, -51.946245, -263.524622>
			}
			triangle {
				< -107.980706, -47.865294, -287.414044>,
				< -99.283665, -46.232525, -287.103683>,
				< -107.150599, -51.946245, -263.524622>
			}
			triangle {
				< -100.199468, -39.136384, -308.827937>,
				< -99.283665, -46.232525, -287.103683>,
				< -107.980706, -47.865294, -287.414044>
			}
			triangle {
				< -108.616032, -40.518843, -309.915632>,
				< -100.199468, -39.136384, -308.827937>,
				< -107.980706, -47.865294, -287.414044>
			}
			triangle {
				< -100.888453, -29.369630, -327.733368>,
				< -100.199468, -39.136384, -308.827937>,
				< -108.616032, -40.518843, -309.915632>
			}
			triangle {
				< -109.053142, -30.407537, -329.495758>,
				< -100.888453, -29.369630, -327.733368>,
				< -108.616032, -40.518843, -309.915632>
			}
			triangle {
				< -101.357624, -17.597795, -342.531413>,
				< -100.888453, -29.369630, -327.733368>,
				< -109.053142, -30.407537, -329.495758>
			}
			triangle {
				< -109.320164, -18.220423, -344.821066>,
				< -101.357624, -17.597795, -342.531413>,
				< -109.053142, -30.407537, -329.495758>
			}
			triangle {
				< -101.631284, -4.623135, -352.213949>,
				< -101.357624, -17.597795, -342.531413>,
				< -109.320164, -18.220423, -344.821066>
			}
			triangle {
				< -109.459154, -4.788077, -354.848057>,
				< -101.631284, -4.623135, -352.213949>,
				< -109.320164, -18.220423, -344.821066>
			}
			triangle {
				< -101.734266, 8.670159, -356.121957>,
				< -101.631284, -4.623135, -352.213949>,
				< -109.459154, -4.788077, -354.848057>
			}
			triangle {
				< -109.507278, 8.974154, -358.894706>,
				< -101.734266, 8.670159, -356.121957>,
				< -109.459154, -4.788077, -354.848057>
			}
			triangle {
				< -101.678602, 21.375887, -353.988975>,
				< -101.734266, 8.670159, -356.121957>,
				< -109.507278, 8.974154, -358.894706>
			}
			triangle {
				< -109.481581, 22.128101, -356.686085>,
				< -101.678602, 21.375887, -353.988975>,
				< -109.507278, 8.974154, -358.894706>
			}
			triangle {
				< -101.457559, 32.628756, -345.960498>,
				< -101.678602, 21.375887, -353.988975>,
				< -109.481581, 22.128101, -356.686085>
			}
			triangle {
				< -109.372631, 33.777934, -348.372161>,
				< -101.457559, 32.628756, -345.960498>,
				< -109.481581, 22.128101, -356.686085>
			}
			triangle {
				< -101.048991, 41.661520, -332.582802>,
				< -101.457559, 32.628756, -345.960498>,
				< -109.372631, 33.777934, -348.372161>
			}
			triangle {
				< -109.147929, 43.129340, -334.518164>,
				< -101.048991, 41.661520, -332.582802>,
				< -109.372631, 33.777934, -348.372161>
			}
			triangle {
				< -100.426763, 47.858696, -314.767450>,
				< -101.048991, 41.661520, -332.582802>,
				< -109.147929, 43.129340, -334.518164>
			}
			triangle {
				< -108.764969, 49.545068, -316.067249>,
				< -100.426763, 47.858696, -314.767450>,
				< -109.147929, 43.129340, -334.518164>
			}
			triangle {
				< -99.577010, 50.797813, -293.728381>,
				< -100.426763, 47.858696, -314.767450>,
				< -108.764969, 49.545068, -316.067249>
			}
			triangle {
				< -108.189531, 52.588027, -294.276029>,
				< -99.577010, 50.797813, -293.728381>,
				< -108.764969, 49.545068, -316.067249>
			}
			triangle {
				< -98.514155, 50.278779, -270.899862>,
				< -99.577010, 50.797813, -293.728381>,
				< -108.189531, 52.588027, -294.276029>
			}
			triangle {
				< -107.414223, 52.050624, -270.629287>,
				< -98.514155, 50.278779, -270.899862>,
				< -108.189531, 52.588027, -294.276029>
			}
			triangle {
				< -97.291566, 46.336871, -247.838259>,
				< -98.514155, 50.278779, -270.899862>,
				< -107.414223, 52.050624, -270.629287>
			}
			triangle {
				< -106.471449, 47.969732, -246.738851>,
				< -97.291566, 46.336871, -247.838259>,
				< -107.414223, 52.050624, -270.629287>
			}
			triangle {
				< -96.003056, 39.240755, -226.115853>,
				< -97.291566, 46.336871, -247.838259>,
				< -106.471449, 47.969732, -246.738851>
			}
			triangle {
				< -105.436690, 40.623296, -224.233776>,
				< -96.003056, 39.240755, -226.115853>,
				< -106.471449, 47.969732, -246.738851>
			}
			triangle {
				< -94.773687, 29.473988, -207.213074>,
				< -96.003056, 39.240755, -226.115853>,
				< -105.436690, 40.623296, -224.233776>
			}
			triangle {
				< -104.420371, 30.511966, -204.648495>,
				< -94.773687, 29.473988, -207.213074>,
				< -105.436690, 40.623296, -224.233776>
			}
			triangle {
				< -93.741193, 17.702177, -192.417726>,
				< -94.773687, 29.473988, -207.213074>,
				< -104.420371, 30.511966, -204.648495>
			}
			triangle {
				< -103.549622, 18.324826, -189.317912>,
				< -93.741193, 17.702177, -192.417726>,
				< -104.420371, 30.511966, -204.648495>
			}
			triangle {
				< -93.032256, 4.727796, -182.737112>,
				< -93.741193, 17.702177, -192.417726>,
				< -103.549622, 18.324826, -189.317912>
			}
			triangle {
				< -102.944098, 4.892681, -179.286778>,
				< -93.032256, 4.727796, -182.737112>,
				< -103.549622, 18.324826, -189.317912>
			}
			triangle {
				< -92.738643, -8.565478, -178.830147>,
				< -93.032256, 4.727796, -182.737112>,
				< -102.944098, 4.892681, -179.286778>
			}
			triangle {
				< -102.691695, -8.869492, -175.238222>,
				< -92.738643, -8.565478, -178.830147>,
				< -102.944098, 4.892681, -179.286778>
			}
			triangle {
				< -92.899427, -21.271538, -180.962682>,
				< -92.738643, -8.565478, -178.830147>,
				< -102.691695, -8.869492, -175.238222>
			}
			triangle {
				< -102.830045, -22.023752, -177.448064>,
				< -92.899427, -21.271538, -180.962682>,
				< -102.691695, -8.869492, -175.238222>
			}
			triangle {
				< -84.866211, -29.155135, -197.643220>,
				< -84.260017, -19.066116, -190.453365>,
				< -92.899427, -21.271538, -180.962682>
			}
			triangle {
				< -93.493156, -32.524351, -188.989505>,
				< -84.866211, -29.155135, -197.643220>,
				< -92.899427, -21.271538, -180.962682>
			}
			triangle {
				< -85.843906, -37.253696, -209.623873>,
				< -84.866211, -29.155135, -197.643220>,
				< -93.493156, -32.524351, -188.989505>
			}
			triangle {
				< -94.442114, -41.557107, -202.364564>,
				< -85.843906, -37.253696, -209.623873>,
				< -93.493156, -32.524351, -188.989505>
			}
			triangle {
				< -87.083064, -42.809892, -225.580022>,
				< -85.843906, -37.253696, -209.623873>,
				< -94.442114, -41.557107, -202.364564>
			}
			triangle {
				< -95.627658, -47.754280, -220.177040>,
				< -87.083064, -42.809892, -225.580022>,
				< -94.442114, -41.557107, -202.364564>
			}
			triangle {
				< -88.453986, -45.445118, -244.425416>,
				< -87.083064, -42.809892, -225.580022>,
				< -95.627658, -47.754280, -220.177040>
			}
			triangle {
				< -96.912704, -50.693456, -241.213992>,
				< -88.453986, -45.445118, -244.425416>,
				< -95.627658, -47.754280, -220.177040>
			}
			triangle {
				< -89.828305, -44.979766, -264.876157>,
				< -88.453986, -45.445118, -244.425416>,
				< -96.912704, -50.693456, -241.213992>
			}
			triangle {
				< -98.166183, -50.174434, -264.041513>,
				< -89.828305, -44.979766, -264.876157>,
				< -96.912704, -50.693456, -241.213992>
			}
			triangle {
				< -91.097079, -41.445546, -285.538346>,
				< -89.828305, -44.979766, -264.876157>,
				< -98.166183, -50.174434, -264.041513>
			}
			triangle {
				< -99.283665, -46.232525, -287.103683>,
				< -91.097079, -41.445546, -285.538346>,
				< -98.166183, -50.174434, -264.041513>
			}
			triangle {
				< -92.182249, -35.083346, -305.003524>,
				< -91.097079, -41.445546, -285.538346>,
				< -99.283665, -46.232525, -287.103683>
			}
			triangle {
				< -100.199468, -39.136384, -308.827937>,
				< -92.182249, -35.083346, -305.003524>,
				< -99.283665, -46.232525, -287.103683>
			}
			triangle {
				< -93.039811, -26.326697, -321.944028>,
				< -92.182249, -35.083346, -305.003524>,
				< -100.199468, -39.136384, -308.827937>
			}
			triangle {
				< -100.888453, -29.369630, -327.733368>,
				< -93.039811, -26.326697, -321.944028>,
				< -100.199468, -39.136384, -308.827937>
			}
			triangle {
				< -93.654700, -15.772350, -335.205078>,
				< -93.039811, -26.326697, -321.944028>,
				< -100.888453, -29.369630, -327.733368>
			}
			triangle {
				< -101.357624, -17.597795, -342.531413>,
				< -93.654700, -15.772350, -335.205078>,
				< -100.888453, -29.369630, -327.733368>
			}
			triangle {
				< -94.030254, -4.139576, -343.882382>,
				< -93.654700, -15.772350, -335.205078>,
				< -101.357624, -17.597795, -342.531413>
			}
			triangle {
				< -101.631284, -4.623135, -352.213949>,
				< -94.030254, -4.139576, -343.882382>,
				< -101.357624, -17.597795, -342.531413>
			}
			triangle {
				< -94.175823, 7.778858, -347.384602>,
				< -94.030254, -4.139576, -343.882382>,
				< -101.631284, -4.623135, -352.213949>
			}
			triangle {
				< -101.734266, 8.670159, -356.121957>,
				< -94.175823, 7.778858, -347.384602>,
				< -101.631284, -4.623135, -352.213949>
			}
			triangle {
				< -94.096802, 19.170484, -345.472962>,
				< -94.175823, 7.778858, -347.384602>,
				< -101.734266, 8.670159, -356.121957>
			}
			triangle {
				< -101.678602, 21.375887, -353.988975>,
				< -94.096802, 19.170484, -345.472962>,
				< -101.734266, 8.670159, -356.121957>
			}
			triangle {
				< -93.790129, 29.259548, -338.278085>,
				< -94.096802, 19.170484, -345.472962>,
				< -101.678602, 21.375887, -353.988975>
			}
			triangle {
				< -101.457559, 32.628756, -345.960498>,
				< -93.790129, 29.259548, -338.278085>,
				< -101.678602, 21.375887, -353.988975>
			}
			triangle {
				< -93.246780, 37.358012, -326.289713>,
				< -93.790129, 29.259548, -338.278085>,
				< -101.457559, 32.628756, -345.960498>
			}
			triangle {
				< -101.048991, 41.661520, -332.582802>,
				< -93.246780, 37.358012, -326.289713>,
				< -101.457559, 32.628756, -345.960498>
			}
			triangle {
				< -92.460386, 42.914219, -310.325623>,
				< -93.246780, 37.358012, -326.289713>,
				< -101.048991, 41.661520, -332.582802>
			}
			triangle {
				< -100.426763, 47.858696, -314.767450>,
				< -92.460386, 42.914219, -310.325623>,
				< -101.048991, 41.661520, -332.582802>
			}
			triangle {
				< -91.439299, 45.549527, -291.473985>,
				< -92.460386, 42.914219, -310.325623>,
				< -100.426763, 47.858696, -314.767450>
			}
			triangle {
				< -99.577010, 50.797813, -293.728381>,
				< -91.439299, 45.549527, -291.473985>,
				< -100.426763, 47.858696, -314.767450>
			}
			triangle {
				< -90.218201, 45.084111, -271.020621>,
				< -91.439299, 45.549527, -291.473985>,
				< -99.577010, 50.797813, -293.728381>
			}
			triangle {
				< -98.514155, 50.278779, -270.899862>,
				< -90.218201, 45.084111, -271.020621>,
				< -99.577010, 50.797813, -293.728381>
			}
			triangle {
				< -88.864952, 41.550007, -250.359833>,
				< -90.218201, 45.084111, -271.020621>,
				< -98.514155, 50.278779, -270.899862>
			}
			triangle {
				< -97.291566, 46.336871, -247.838259>,
				< -88.864952, 41.550007, -250.359833>,
				< -98.514155, 50.278779, -270.899862>
			}
			triangle {
				< -87.480232, 35.187740, -230.900049>,
				< -88.864952, 41.550007, -250.359833>,
				< -97.291566, 46.336871, -247.838259>
			}
			triangle {
				< -96.003056, 39.240755, -226.115853>,
				< -87.480232, 35.187740, -230.900049>,
				< -97.291566, 46.336871, -247.838259>
			}
			triangle {
				< -86.188339, 26.431073, -213.967040>,
				< -87.480232, 35.187740, -230.900049>,
				< -96.003056, 39.240755, -226.115853>
			}
			triangle {
				< -94.773687, 29.473988, -207.213074>,
				< -86.188339, 26.431073, -213.967040>,
				< -96.003056, 39.240755, -226.115853>
			}
			triangle {
				< -85.120685, 15.876731, -200.713977>,
				< -86.188339, 26.431073, -213.967040>,
				< -94.773687, 29.473988, -207.213074>
			}
			triangle {
				< -93.741193, 17.702177, -192.417726>,
				< -85.120685, 15.876731, -200.713977>,
				< -94.773687, 29.473988, -207.213074>
			}
			triangle {
				< -84.395275, 4.244216, -192.042753>,
				< -85.120685, 15.876731, -200.713977>,
				< -93.741193, 17.702177, -192.417726>
			}
			triangle {
				< -93.032256, 4.727796, -182.737112>,
				< -84.395275, 4.244216, -192.042753>,
				< -93.741193, 17.702177, -192.417726>
			}
			triangle {
				< -84.096499, -7.674198, -188.543260>,
				< -84.395275, 4.244216, -192.042753>,
				< -93.032256, 4.727796, -182.737112>
			}
			triangle {
				< -92.738643, -8.565478, -178.830147>,
				< -84.096499, -7.674198, -188.543260>,
				< -93.032256, 4.727796, -182.737112>
			}
			triangle {
				< -84.260017, -19.066116, -190.453365>,
				< -84.096499, -7.674198, -188.543260>,
				< -92.738643, -8.565478, -178.830147>
			}
			triangle {
				< -92.899427, -21.271538, -180.962682>,
				< -84.260017, -19.066116, -190.453365>,
				< -92.738643, -8.565478, -178.830147>
			}
			triangle {
				< -78.163557, -23.795445, -211.085439>,
				< -77.627145, -15.557848, -205.219701>,
				< -84.260017, -19.066116, -190.453365>
			}
			triangle {
				< -84.866211, -29.155135, -197.643220>,
				< -78.163557, -23.795445, -211.085439>,
				< -84.260017, -19.066116, -190.453365>
			}
			triangle {
				< -79.035714, -30.407900, -220.859557>,
				< -78.163557, -23.795445, -211.085439>,
				< -84.866211, -29.155135, -197.643220>
			}
			triangle {
				< -85.843906, -37.253696, -209.623873>,
				< -79.035714, -30.407900, -220.859557>,
				< -84.866211, -29.155135, -197.643220>
			}
			triangle {
				< -80.155320, -34.944523, -233.877122>,
				< -79.035714, -30.407900, -220.859557>,
				< -85.843906, -37.253696, -209.623873>
			}
			triangle {
				< -87.083064, -42.809892, -225.580022>,
				< -80.155320, -34.944523, -233.877122>,
				< -85.843906, -37.253696, -209.623873>
			}
			triangle {
				< -81.415877, -37.096191, -249.251887>,
				< -80.155320, -34.944523, -233.877122>,
				< -87.083064, -42.809892, -225.580022>
			}
			triangle {
				< -88.453986, -45.445118, -244.425416>,
				< -81.415877, -37.096191, -249.251887>,
				< -87.083064, -42.809892, -225.580022>
			}
			triangle {
				< -82.708217, -36.716234, -265.936852>,
				< -81.415877, -37.096191, -249.251887>,
				< -88.453986, -45.445118, -244.425416>
			}
			triangle {
				< -89.828305, -44.979766, -264.876157>,
				< -82.708217, -36.716234, -265.936852>,
				< -88.453986, -45.445118, -244.425416>
			}
			triangle {
				< -83.934024, -33.830583, -282.794982>,
				< -82.708217, -36.716234, -265.936852>,
				< -89.828305, -44.979766, -264.876157>
			}
			triangle {
				< -91.097079, -41.445546, -285.538346>,
				< -83.934024, -33.830583, -282.794982>,
				< -89.828305, -44.979766, -264.876157>
			}
			triangle {
				< -85.015438, -28.635835, -298.676968>,
				< -83.934024, -33.830583, -282.794982>,
				< -91.097079, -41.445546, -285.538346>
			}
			triangle {
				< -92.182249, -35.083346, -305.003524>,
				< -85.015438, -28.635835, -298.676968>,
				< -91.097079, -41.445546, -285.538346>
			}
			triangle {
				< -85.898675, -21.486059, -312.499642>,
				< -85.015438, -28.635835, -298.676968>,
				< -92.182249, -35.083346, -305.003524>
			}
			triangle {
				< -93.039811, -26.326697, -321.944028>,
				< -85.898675, -21.486059, -312.499642>,
				< -92.182249, -35.083346, -305.003524>
			}
			triangle {
				< -86.552463, -12.868475, -323.320270>,
				< -85.898675, -21.486059, -312.499642>,
				< -93.039811, -26.326697, -321.944028>
			}
			triangle {
				< -93.654700, -15.772350, -335.205078>,
				< -86.552463, -12.868475, -323.320270>,
				< -93.039811, -26.326697, -321.944028>
			}
			triangle {
				< -86.962394, -3.370346, -330.401123>,
				< -86.552463, -12.868475, -323.320270>,
				< -93.654700, -15.772350, -335.205078>
			}
			triangle {
				< -94.030254, -4.139576, -343.882382>,
				< -86.962394, -3.370346, -330.401123>,
				< -93.654700, -15.772350, -335.205078>
			}
			triangle {
				< -87.123871, 6.361018, -333.259284>,
				< -86.962394, -3.370346, -330.401123>,
				< -94.030254, -4.139576, -343.882382>
			}
			triangle {
				< -94.175823, 7.778858, -347.384602>,
				< -87.123871, 6.361018, -333.259284>,
				< -94.030254, -4.139576, -343.882382>
			}
			triangle {
				< -87.036021, 15.662188, -331.699282>,
				< -87.123871, 6.361018, -333.259284>,
				< -94.175823, 7.778858, -347.384602>
			}
			triangle {
				< -94.096802, 19.170484, -345.472962>,
				< -87.036021, 15.662188, -331.699282>,
				< -94.175823, 7.778858, -347.384602>
			}
			triangle {
				< -86.699255, 23.899842, -325.828046>,
				< -87.036021, 15.662188, -331.699282>,
				< -94.096802, 19.170484, -345.472962>
			}
			triangle {
				< -93.790129, 29.259548, -338.278085>,
				< -86.699255, 23.899842, -325.828046>,
				< -94.096802, 19.170484, -345.472962>
			}
			triangle {
				< -86.116575, 30.512337, -316.045702>,
				< -86.699255, 23.899842, -325.828046>,
				< -93.790129, 29.259548, -338.278085>
			}
			triangle {
				< -93.246780, 37.358012, -326.289713>,
				< -86.116575, 30.512337, -316.045702>,
				< -93.790129, 29.259548, -338.278085>
			}
			triangle {
				< -85.298739, 35.048913, -303.019553>,
				< -86.116575, 30.512337, -316.045702>,
				< -93.246780, 37.358012, -326.289713>
			}
			triangle {
				< -92.460386, 42.914219, -310.325623>,
				< -85.298739, 35.048913, -303.019553>,
				< -93.246780, 37.358012, -326.289713>
			}
			triangle {
				< -84.271349, 37.200559, -287.637949>,
				< -85.298739, 35.048913, -303.019553>,
				< -92.460386, 42.914219, -310.325623>
			}
			triangle {
				< -91.439299, 45.549527, -291.473985>,
				< -84.271349, 37.200559, -287.637949>,
				< -92.460386, 42.914219, -310.325623>
			}
			triangle {
				< -83.081156, 36.820568, -270.950139>,
				< -84.271349, 37.200559, -287.637949>,
				< -91.439299, 45.549527, -291.473985>
			}
			triangle {
				< -90.218201, 45.084111, -271.020621>,
				< -83.081156, 36.820568, -270.950139>,
				< -91.439299, 45.549527, -291.473985>
			}
			triangle {
				< -81.799001, 33.934984, -254.093587>,
				< -83.081156, 36.820568, -270.950139>,
				< -90.218201, 45.084111, -271.020621>
			}
			triangle {
				< -88.864952, 41.550007, -250.359833>,
				< -81.799001, 33.934984, -254.093587>,
				< -90.218201, 45.084111, -271.020621>
			}
			triangle {
				< -80.517955, 28.740181, -238.217413>,
				< -81.799001, 33.934984, -254.093587>,
				< -88.864952, 41.550007, -250.359833>
			}
			triangle {
				< -87.480232, 35.187740, -230.900049>,
				< -80.517955, 28.740181, -238.217413>,
				< -88.864952, 41.550007, -250.359833>
			}
			triangle {
				< -79.345211, 21.590430, -224.402860>,
				< -80.517955, 28.740181, -238.217413>,
				< -87.480232, 35.187740, -230.900049>
			}
			triangle {
				< -86.188339, 26.431073, -213.967040>,
				< -79.345211, 21.590430, -224.402860>,
				< -87.480232, 35.187740, -230.900049>
			}
			triangle {
				< -78.389674, 12.972862, -213.590637>,
				< -79.345211, 21.590430, -224.402860>,
				< -86.188339, 26.431073, -213.967040>
			}
			triangle {
				< -85.120685, 15.876731, -200.713977>,
				< -78.389674, 12.972862, -213.590637>,
				< -86.188339, 26.431073, -213.967040>
			}
			triangle {
				< -77.746555, 3.475006, -206.516460>,
				< -78.389674, 12.972862, -213.590637>,
				< -85.120685, 15.876731, -200.713977>
			}
			triangle {
				< -84.395275, 4.244216, -192.042753>,
				< -77.746555, 3.475006, -206.516460>,
				< -85.120685, 15.876731, -200.713977>
			}
			triangle {
				< -77.482998, -6.256357, -203.661457>,
				< -77.746555, 3.475006, -206.516460>,
				< -84.395275, 4.244216, -192.042753>
			}
			triangle {
				< -84.096499, -7.674198, -188.543260>,
				< -77.482998, -6.256357, -203.661457>,
				< -84.395275, 4.244216, -192.042753>
			}
			triangle {
				< -77.627145, -15.557848, -205.219701>,
				< -77.482998, -6.256357, -203.661457>,
				< -84.096499, -7.674198, -188.543260>
			}
			triangle {
				< -84.260017, -19.066116, -190.453365>,
				< -77.627145, -15.557848, -205.219701>,
				< -84.096499, -7.674198, -188.543260>
			}
			triangle {
				< -73.845521, -16.810602, -228.343695>,
				< -73.452272, -10.985736, -224.198341>,
				< -77.627145, -15.557848, -205.219701>
			}
			triangle {
				< -78.163557, -23.795445, -211.085439>,
				< -73.845521, -16.810602, -228.343695>,
				< -77.627145, -15.557848, -205.219701>
			}
			triangle {
				< -74.489973, -21.486307, -235.250950>,
				< -73.845521, -16.810602, -228.343695>,
				< -78.163557, -23.795445, -211.085439>
			}
			triangle {
				< -79.035714, -30.407900, -220.859557>,
				< -74.489973, -21.486307, -235.250950>,
				< -78.163557, -23.795445, -211.085439>
			}
			triangle {
				< -75.327277, -24.694197, -244.450182>,
				< -74.489973, -21.486307, -235.250950>,
				< -79.035714, -30.407900, -220.859557>
			}
			triangle {
				< -80.155320, -34.944523, -233.877122>,
				< -75.327277, -24.694197, -244.450182>,
				< -79.035714, -30.407900, -220.859557>
			}
			triangle {
				< -76.285228, -26.215641, -255.314946>,
				< -75.327277, -24.694197, -244.450182>,
				< -80.155320, -34.944523, -233.877122>
			}
			triangle {
				< -81.415877, -37.096191, -249.251887>,
				< -76.285228, -26.215641, -255.314946>,
				< -80.155320, -34.944523, -233.877122>
			}
			triangle {
				< -77.286988, -25.947001, -267.105252>,
				< -76.285228, -26.215641, -255.314946>,
				< -81.415877, -37.096191, -249.251887>
			}
			triangle {
				< -82.708217, -36.716234, -265.936852>,
				< -77.286988, -25.947001, -267.105252>,
				< -81.415877, -37.096191, -249.251887>
			}
			triangle {
				< -78.259133, -23.906499, -279.017806>,
				< -77.286988, -25.947001, -267.105252>,
				< -82.708217, -36.716234, -265.936852>
			}
			triangle {
				< -83.934024, -33.830583, -282.794982>,
				< -78.259133, -23.906499, -279.017806>,
				< -82.708217, -36.716234, -265.936852>
			}
			triangle {
				< -79.138242, -20.233266, -290.240526>,
				< -78.259133, -23.906499, -279.017806>,
				< -83.934024, -33.830583, -282.794982>
			}
			triangle {
				< -85.015438, -28.635835, -298.676968>,
				< -79.138242, -20.233266, -290.240526>,
				< -83.934024, -33.830583, -282.794982>
			}
			triangle {
				< -79.874367, -15.177622, -300.008267>,
				< -79.138242, -20.233266, -290.240526>,
				< -85.015438, -28.635835, -298.676968>
			}
			triangle {
				< -85.898675, -21.486059, -312.499642>,
				< -79.874367, -15.177622, -300.008267>,
				< -85.015438, -28.635835, -298.676968>
			}
			triangle {
				< -80.431797, -9.084067, -307.654738>,
				< -79.874367, -15.177622, -300.008267>,
				< -85.898675, -21.486059, -312.499642>
			}
			triangle {
				< -86.552463, -12.868475, -323.320270>,
				< -80.431797, -9.084067, -307.654738>,
				< -85.898675, -21.486059, -312.499642>
			}
			triangle {
				< -80.787614, -2.367886, -312.658340>,
				< -80.431797, -9.084067, -307.654738>,
				< -86.552463, -12.868475, -323.320270>
			}
			triangle {
				< -86.962394, -3.370346, -330.401123>,
				< -80.787614, -2.367886, -312.658340>,
				< -86.552463, -12.868475, -323.320270>
			}
			triangle {
				< -80.929227, 4.513242, -314.677656>,
				< -80.787614, -2.367886, -312.658340>,
				< -86.962394, -3.370346, -330.401123>
			}
			triangle {
				< -87.123871, 6.361018, -333.259284>,
				< -80.929227, 4.513242, -314.677656>,
				< -86.962394, -3.370346, -330.401123>
			}
			triangle {
				< -80.852084, 11.090086, -313.575417>,
				< -80.929227, 4.513242, -314.677656>,
				< -87.123871, 6.361018, -333.259284>
			}
			triangle {
				< -87.036021, 15.662188, -331.699282>,
				< -80.852084, 11.090086, -313.575417>,
				< -87.123871, 6.361018, -333.259284>
			}
			triangle {
				< -80.558620, 16.914977, -309.426427>,
				< -80.852084, 11.090086, -313.575417>,
				< -87.036021, 15.662188, -331.699282>
			}
			triangle {
				< -86.699255, 23.899842, -325.828046>,
				< -80.558620, 16.914977, -309.426427>,
				< -87.036021, 15.662188, -331.699282>
			}
			triangle {
				< -80.058858, 21.590680, -302.513868>,
				< -80.558620, 16.914977, -309.426427>,
				< -86.699255, 23.899842, -325.828046>
			}
			triangle {
				< -86.116575, 30.512337, -316.045702>,
				< -80.058858, 21.590680, -302.513868>,
				< -86.699255, 23.899842, -325.828046>
			}
			triangle {
				< -79.372413, 24.798574, -293.309182>,
				< -80.058858, 21.590680, -302.513868>,
				< -86.116575, 30.512337, -316.045702>
			}
			triangle {
				< -85.298739, 35.048913, -303.019553>,
				< -79.372413, 24.798574, -293.309182>,
				< -86.116575, 30.512337, -316.045702>
			}
			triangle {
				< -78.530990, 26.320027, -282.440037>,
				< -79.372413, 24.798574, -293.309182>,
				< -85.298739, 35.048913, -303.019553>
			}
			triangle {
				< -84.271349, 37.200559, -287.637949>,
				< -78.530990, 26.320027, -282.440037>,
				< -85.298739, 35.048913, -303.019553>
			}
			triangle {
				< -77.580273, 26.051354, -270.647734>,
				< -78.530990, 26.320027, -282.440037>,
				< -84.271349, 37.200559, -287.637949>
			}
			triangle {
				< -83.081156, 36.820568, -270.950139>,
				< -77.580273, 26.051354, -270.647734>,
				< -84.271349, 37.200559, -287.637949>
			}
			triangle {
				< -76.579981, 24.010856, -258.736283>,
				< -77.580273, 26.051354, -270.647734>,
				< -83.081156, 36.820568, -270.950139>
			}
			triangle {
				< -81.799001, 33.934984, -254.093587>,
				< -76.579981, 24.010856, -258.736283>,
				< -83.081156, 36.820568, -270.950139>
			}
			triangle {
				< -75.601086, 20.337652, -247.517288>,
				< -76.579981, 24.010856, -258.736283>,
				< -81.799001, 33.934984, -254.093587>
			}
			triangle {
				< -80.517955, 28.740181, -238.217413>,
				< -75.601086, 20.337652, -247.517288>,
				< -81.799001, 33.934984, -254.093587>
			}
			triangle {
				< -74.720271, 15.281993, -237.755001>,
				< -75.601086, 20.337652, -247.517288>,
				< -80.517955, 28.740181, -238.217413>
			}
			triangle {
				< -79.345211, 21.590430, -224.402860>,
				< -74.720271, 15.281993, -237.755001>,
				< -80.517955, 28.740181, -238.217413>
			}
			triangle {
				< -74.011989, 9.188707, -230.114132>,
				< -74.720271, 15.281993, -237.755001>,
				< -79.345211, 21.590430, -224.402860>
			}
			triangle {
				< -78.389674, 12.972862, -213.590637>,
				< -74.011989, 9.188707, -230.114132>,
				< -79.345211, 21.590430, -224.402860>
			}
			triangle {
				< -73.539607, 2.472526, -225.114778>,
				< -74.011989, 9.188707, -230.114132>,
				< -78.389674, 12.972862, -213.590637>
			}
			triangle {
				< -77.746555, 3.475006, -206.516460>,
				< -73.539607, 2.472526, -225.114778>,
				< -78.389674, 12.972862, -213.590637>
			}
			triangle {
				< -73.346958, -4.408602, -223.097101>,
				< -73.539607, 2.472526, -225.114778>,
				< -77.746555, 3.475006, -206.516460>
			}
			triangle {
				< -77.482998, -6.256357, -203.661457>,
				< -73.346958, -4.408602, -223.097101>,
				< -77.746555, 3.475006, -206.516460>
			}
			triangle {
				< -73.452272, -10.985736, -224.198341>,
				< -73.346958, -4.408602, -223.097101>,
				< -77.482998, -6.256357, -203.661457>
			}
			triangle {
				< -77.627145, -15.557848, -205.219701>,
				< -73.452272, -10.985736, -224.198341>,
				< -77.482998, -6.256357, -203.661457>
			}
			triangle {
				< -72.095156, -8.676595, -248.198301>,
				< -71.892798, -5.661412, -246.053070>,
				< -73.452272, -10.985736, -224.198341>
			}
			triangle {
				< -73.845521, -16.810602, -228.343695>,
				< -72.095156, -8.676595, -248.198301>,
				< -73.452272, -10.985736, -224.198341>
			}
			triangle {
				< -72.429478, -11.096915, -251.772910>,
				< -72.095156, -8.676595, -248.198301>,
				< -73.845521, -16.810602, -228.343695>
			}
			triangle {
				< -74.489973, -21.486307, -235.250950>,
				< -72.429478, -11.096915, -251.772910>,
				< -73.845521, -16.810602, -228.343695>
			}
			triangle {
				< -72.869048, -12.757446, -256.533265>,
				< -72.429478, -11.096915, -251.772910>,
				< -74.489973, -21.486307, -235.250950>
			}
			triangle {
				< -75.327277, -24.694197, -244.450182>,
				< -72.869048, -12.757446, -256.533265>,
				< -74.489973, -21.486307, -235.250950>
			}
			triangle {
				< -73.379911, -13.544999, -262.155235>,
				< -72.869048, -12.757446, -256.533265>,
				< -75.327277, -24.694197, -244.450182>
			}
			triangle {
				< -76.285228, -26.215641, -255.314946>,
				< -73.379911, -13.544999, -262.155235>,
				< -75.327277, -24.694197, -244.450182>
			}
			triangle {
				< -73.924109, -13.405931, -268.255860>,
				< -73.379911, -13.544999, -262.155235>,
				< -76.285228, -26.215641, -255.314946>
			}
			triangle {
				< -77.286988, -25.947001, -267.105252>,
				< -73.924109, -13.405931, -268.255860>,
				< -76.285228, -26.215641, -255.314946>
			}
			triangle {
				< -74.463218, -12.349705, -274.419367>,
				< -73.924109, -13.405931, -268.255860>,
				< -77.286988, -25.947001, -267.105252>
			}
			triangle {
				< -78.259133, -23.906499, -279.017806>,
				< -74.463218, -12.349705, -274.419367>,
				< -77.286988, -25.947001, -267.105252>
			}
			triangle {
				< -74.961230, -10.448306, -280.225664>,
				< -74.463218, -12.349705, -274.419367>,
				< -78.259133, -23.906499, -279.017806>
			}
			triangle {
				< -79.138242, -20.233266, -290.240526>,
				< -74.961230, -10.448306, -280.225664>,
				< -78.259133, -23.906499, -279.017806>
			}
			triangle {
				< -75.386882, -7.831277, -285.279006>,
				< -74.961230, -10.448306, -280.225664>,
				< -79.138242, -20.233266, -290.240526>
			}
			triangle {
				< -79.874367, -15.177622, -300.008267>,
				< -75.386882, -7.831277, -285.279006>,
				< -79.138242, -20.233266, -290.240526>
			}
			triangle {
				< -75.715035, -4.677027, -289.234817>,
				< -75.386882, -7.831277, -285.279006>,
				< -79.874367, -15.177622, -300.008267>
			}
			triangle {
				< -80.431797, -9.084067, -307.654738>,
				< -75.715035, -4.677027, -289.234817>,
				< -79.874367, -15.177622, -300.008267>
			}
			triangle {
				< -75.927377, -1.200459, -291.823357>,
				< -75.715035, -4.677027, -289.234817>,
				< -80.431797, -9.084067, -307.654738>
			}
			triangle {
				< -80.787614, -2.367886, -312.658340>,
				< -75.927377, -1.200459, -291.823357>,
				< -80.431797, -9.084067, -307.654738>
			}
			triangle {
				< -76.012537, 2.361471, -292.868137>,
				< -75.927377, -1.200459, -291.823357>,
				< -80.787614, -2.367886, -312.658340>
			}
			triangle {
				< -80.929227, 4.513242, -314.677656>,
				< -76.012537, 2.361471, -292.868137>,
				< -80.787614, -2.367886, -312.658340>
			}
			triangle {
				< -75.966090, 5.766031, -292.297959>,
				< -76.012537, 2.361471, -292.868137>,
				< -80.929227, 4.513242, -314.677656>
			}
			triangle {
				< -80.852084, 11.090086, -313.575417>,
				< -75.966090, 5.766031, -292.297959>,
				< -80.929227, 4.513242, -314.677656>
			}
			triangle {
				< -75.790435, 8.781214, -290.151477>,
				< -75.966090, 5.766031, -292.297959>,
				< -80.852084, 11.090086, -313.575417>
			}
			triangle {
				< -80.558620, 16.914977, -309.426427>,
				< -75.790435, 8.781214, -290.151477>,
				< -80.852084, 11.090086, -313.575417>
			}
			triangle {
				< -75.494915, 11.201287, -286.575317>,
				< -75.790435, 8.781214, -290.151477>,
				< -80.558620, 16.914977, -309.426427>
			}
			triangle {
				< -80.058858, 21.590680, -302.513868>,
				< -75.494915, 11.201287, -286.575317>,
				< -80.558620, 16.914977, -309.426427>
			}
			triangle {
				< -75.095721, 12.861797, -281.813234>,
				< -75.494915, 11.201287, -286.575317>,
				< -80.058858, 21.590680, -302.513868>
			}
			triangle {
				< -79.372413, 24.798574, -293.309182>,
				< -75.095721, 12.861797, -281.813234>,
				< -80.058858, 21.590680, -302.513868>
			}
			triangle {
				< -74.616097, 13.649349, -276.189893>,
				< -75.095721, 12.861797, -281.813234>,
				< -79.372413, 24.798574, -293.309182>
			}
			triangle {
				< -78.530990, 26.320027, -282.440037>,
				< -74.616097, 13.649349, -276.189893>,
				< -79.372413, 24.798574, -293.309182>
			}
			triangle {
				< -74.085563, 13.510303, -270.088732>,
				< -74.616097, 13.649349, -276.189893>,
				< -78.530990, 26.320027, -282.440037>
			}
			triangle {
				< -77.580273, 26.051354, -270.647734>,
				< -74.085563, 13.510303, -270.088732>,
				< -78.530990, 26.320027, -282.440037>
			}
			triangle {
				< -73.538937, 12.454065, -263.925552>,
				< -74.085563, 13.510303, -270.088732>,
				< -77.580273, 26.051354, -270.647734>
			}
			triangle {
				< -76.579981, 24.010856, -258.736283>,
				< -73.538937, 12.454065, -263.925552>,
				< -77.580273, 26.051354, -270.647734>
			}
			triangle {
				< -73.014177, 10.552656, -258.120388>,
				< -73.538937, 12.454065, -263.925552>,
				< -76.579981, 24.010856, -258.736283>
			}
			triangle {
				< -75.601086, 20.337652, -247.517288>,
				< -73.014177, 10.552656, -258.120388>,
				< -76.579981, 24.010856, -258.736283>
			}
			triangle {
				< -72.549775, 7.935918, -253.068686>,
				< -73.014177, 10.552656, -258.120388>,
				< -75.601086, 20.337652, -247.517288>
			}
			triangle {
				< -74.720271, 15.281993, -237.755001>,
				< -72.549775, 7.935918, -253.068686>,
				< -75.601086, 20.337652, -247.517288>
			}
			triangle {
				< -72.181217, 4.781667, -249.114588>,
				< -72.549775, 7.935918, -253.068686>,
				< -74.720271, 15.281993, -237.755001>
			}
			triangle {
				< -74.011989, 9.188707, -230.114132>,
				< -72.181217, 4.781667, -249.114588>,
				< -74.720271, 15.281993, -237.755001>
			}
			triangle {
				< -71.937665, 1.305120, -246.527359>,
				< -72.181217, 4.781667, -249.114588>,
				< -74.011989, 9.188707, -230.114132>
			}
			triangle {
				< -73.539607, 2.472526, -225.114778>,
				< -71.937665, 1.305120, -246.527359>,
				< -74.011989, 9.188707, -230.114132>
			}
			triangle {
				< -71.838804, -2.256810, -245.483086>,
				< -71.937665, 1.305120, -246.527359>,
				< -73.539607, 2.472526, -225.114778>
			}
			triangle {
				< -73.346958, -4.408602, -223.097101>,
				< -71.838804, -2.256810, -245.483086>,
				< -73.539607, 2.472526, -225.114778>
			}
			triangle {
				< -71.892798, -5.661412, -246.053070>,
				< -71.838804, -2.256810, -245.483086>,
				< -73.346958, -4.408602, -223.097101>
			}
			triangle {
				< -73.452272, -10.985736, -224.198341>,
				< -71.892798, -5.661412, -246.053070>,
				< -73.346958, -4.408602, -223.097101>
			}
			triangle {
				< -71.937665, 1.305120, -246.527359>,
				< -71.838804, -2.256810, -245.483086>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -72.181217, 4.781667, -249.114588>,
				< -71.937665, 1.305120, -246.527359>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -72.549775, 7.935918, -253.068686>,
				< -72.181217, 4.781667, -249.114588>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -73.014177, 10.552656, -258.120388>,
				< -72.549775, 7.935918, -253.068686>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -73.538937, 12.454065, -263.925552>,
				< -73.014177, 10.552656, -258.120388>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -74.085563, 13.510303, -270.088732>,
				< -73.538937, 12.454065, -263.925552>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -74.616097, 13.649349, -276.189893>,
				< -74.085563, 13.510303, -270.088732>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -75.095721, 12.861797, -281.813234>,
				< -74.616097, 13.649349, -276.189893>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -75.494915, 11.201287, -286.575317>,
				< -75.095721, 12.861797, -281.813234>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -75.790435, 8.781214, -290.151477>,
				< -75.494915, 11.201287, -286.575317>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -75.966090, 5.766031, -292.297959>,
				< -75.790435, 8.781214, -290.151477>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -76.012537, 2.361471, -292.868137>,
				< -75.966090, 5.766031, -292.297959>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -75.927377, -1.200459, -291.823357>,
				< -76.012537, 2.361471, -292.868137>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -75.715035, -4.677027, -289.234817>,
				< -75.927377, -1.200459, -291.823357>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -75.386882, -7.831277, -285.279006>,
				< -75.715035, -4.677027, -289.234817>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -74.961230, -10.448306, -280.225664>,
				< -75.386882, -7.831277, -285.279006>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -74.463218, -12.349705, -274.419367>,
				< -74.961230, -10.448306, -280.225664>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -73.924109, -13.405931, -268.255860>,
				< -74.463218, -12.349705, -274.419367>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -73.379911, -13.544999, -262.155235>,
				< -73.924109, -13.405931, -268.255860>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -72.869048, -12.757446, -256.533265>,
				< -73.379911, -13.544999, -262.155235>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -72.429478, -11.096915, -251.772910>,
				< -72.869048, -12.757446, -256.533265>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -72.095156, -8.676595, -248.198301>,
				< -72.429478, -11.096915, -251.772910>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -71.892798, -5.661412, -246.053070>,
				< -72.095156, -8.676595, -248.198301>,
				< -72.836101, 0.052310, -269.277364>
			}
			triangle {
				< -71.838804, -2.256810, -245.483086>,
				< -71.892798, -5.661412, -246.053070>,
				< -72.836101, 0.052310, -269.277364>
			}
			
		}
		// _calf04
		union {
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -34.651995, -5.661339, -249.111965>,
				< -35.005014, -8.676543, -251.237780>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -35.005014, -8.676543, -251.237780>,
				< -35.596028, -11.096843, -254.779249>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -35.596028, -11.096843, -254.779249>,
				< -36.388528, -12.757394, -259.494126>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -36.388528, -12.757394, -259.494126>,
				< -37.332498, -13.544947, -265.060186>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -37.332498, -13.544947, -265.060186>,
				< -38.366634, -13.405859, -271.097630>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -38.366634, -13.405859, -271.097630>,
				< -39.421786, -12.349632, -277.194500>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -39.421786, -12.349632, -277.194500>,
				< -40.425308, -10.448233, -282.935500>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -40.425308, -10.448233, -282.935500>,
				< -41.306220, -7.831226, -287.930042>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -41.306220, -7.831226, -287.930042>,
				< -42.000700, -4.676954, -291.838557>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -42.000700, -4.676954, -291.838557>,
				< -42.457432, -1.200428, -294.395506>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -42.457432, -1.200428, -294.395506>,
				< -42.642310, 2.361502, -295.427352>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -42.642310, 2.361502, -295.427352>,
				< -42.541377, 5.766062, -294.864237>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -42.541377, 5.766062, -294.864237>,
				< -42.162228, 8.781245, -292.744070>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -42.162228, 8.781245, -292.744070>,
				< -41.533317, 11.201576, -289.210916>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -41.533317, 11.201576, -289.210916>,
				< -40.701315, 12.862107, -284.504801>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -40.701315, 12.862107, -284.504801>,
				< -39.726812, 13.649659, -278.945357>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -39.726812, 13.649659, -278.945357>,
				< -38.679328, 13.510603, -272.910982>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -38.679328, 13.510603, -272.910982>,
				< -37.631545, 12.454365, -266.812474>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -37.631545, 12.454365, -266.812474>,
				< -36.654130, 10.552976, -261.065722>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -36.654130, 10.552976, -261.065722>,
				< -35.811119, 7.935950, -256.062776>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -35.811119, 7.935950, -256.062776>,
				< -35.156175, 4.781698, -252.145618>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -35.156175, 4.781698, -252.145618>,
				< -34.729920, 1.305151, -249.581948>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -34.729920, 1.305151, -249.581948>,
				< -34.558419, -2.256759, -248.547092>
			}
			triangle {
				< -37.355687, 0.052361, -272.207737>,
				< -34.558419, -2.256759, -248.547092>,
				< -34.651995, -5.661339, -249.111965>
			}
			triangle {
				< -34.651995, -5.661339, -249.111965>,
				< -34.833450, -10.985685, -227.129385>,
				< -35.470251, -16.810564, -231.244594>
			}
			triangle {
				< -34.651995, -5.661339, -249.111965>,
				< -35.470251, -16.810564, -231.244594>,
				< -35.005014, -8.676543, -251.237780>
			}
			triangle {
				< -35.005014, -8.676543, -251.237780>,
				< -35.470251, -16.810564, -231.244594>,
				< -36.541872, -21.486277, -238.099173>
			}
			triangle {
				< -35.005014, -8.676543, -251.237780>,
				< -36.541872, -21.486277, -238.099173>,
				< -35.596028, -11.096843, -254.779249>
			}
			triangle {
				< -35.596028, -11.096843, -254.779249>,
				< -36.541872, -21.486277, -238.099173>,
				< -37.989412, -24.694173, -247.222960>
			}
			triangle {
				< -35.596028, -11.096843, -254.779249>,
				< -37.989412, -24.694173, -247.222960>,
				< -36.388528, -12.757394, -259.494126>
			}
			triangle {
				< -36.388528, -12.757394, -259.494126>,
				< -37.989412, -24.694173, -247.222960>,
				< -39.728988, -26.215615, -257.991105>
			}
			triangle {
				< -36.388528, -12.757394, -259.494126>,
				< -39.728988, -26.215615, -257.991105>,
				< -37.332498, -13.544947, -265.060186>
			}
			triangle {
				< -37.332498, -13.544947, -265.060186>,
				< -39.728988, -26.215615, -257.991105>,
				< -41.653462, -25.946941, -269.667238>
			}
			triangle {
				< -37.332498, -13.544947, -265.060186>,
				< -41.653462, -25.946941, -269.667238>,
				< -38.366634, -13.405859, -271.097630>
			}
			triangle {
				< -38.366634, -13.405859, -271.097630>,
				< -41.653462, -25.946941, -269.667238>,
				< -43.636613, -23.906453, -281.454533>
			}
			triangle {
				< -38.366634, -13.405859, -271.097630>,
				< -43.636613, -23.906453, -281.454533>,
				< -39.421786, -12.349632, -277.194500>
			}
			triangle {
				< -39.421786, -12.349632, -277.194500>,
				< -43.636613, -23.906453, -281.454533>,
				< -45.540556, -20.233240, -292.550206>
			}
			triangle {
				< -39.421786, -12.349632, -277.194500>,
				< -45.540556, -20.233240, -292.550206>,
				< -40.425308, -10.448233, -282.935500>
			}
			triangle {
				< -40.425308, -10.448233, -282.935500>,
				< -45.540556, -20.233240, -292.550206>,
				< -47.225755, -15.177570, -302.200198>
			}
			triangle {
				< -40.425308, -10.448233, -282.935500>,
				< -47.225755, -15.177570, -302.200198>,
				< -41.306220, -7.831226, -287.930042>
			}
			triangle {
				< -41.306220, -7.831226, -287.930042>,
				< -47.225755, -15.177570, -302.200198>,
				< -48.563257, -9.084015, -309.749931>
			}
			triangle {
				< -41.306220, -7.831226, -287.930042>,
				< -48.563257, -9.084015, -309.749931>,
				< -42.000700, -4.676954, -291.838557>
			}
			triangle {
				< -42.000700, -4.676954, -291.838557>,
				< -48.563257, -9.084015, -309.749931>,
				< -49.447153, -2.367835, -314.688116>
			}
			triangle {
				< -42.000700, -4.676954, -291.838557>,
				< -49.447153, -2.367835, -314.688116>,
				< -42.457432, -1.200428, -294.395506>
			}
			triangle {
				< -42.457432, -1.200428, -294.395506>,
				< -49.447153, -2.367835, -314.688116>,
				< -49.805857, 4.513294, -316.680759>
			}
			triangle {
				< -42.457432, -1.200428, -294.395506>,
				< -49.805857, 4.513294, -316.680759>,
				< -42.642310, 2.361502, -295.427352>
			}
			triangle {
				< -42.642310, 2.361502, -295.427352>,
				< -49.805857, 4.513294, -316.680759>,
				< -49.609937, 11.090397, -315.593153>
			}
			triangle {
				< -42.642310, 2.361502, -295.427352>,
				< -49.609937, 11.090397, -315.593153>,
				< -42.541377, 5.766062, -294.864237>
			}
			triangle {
				< -42.541377, 5.766062, -294.864237>,
				< -49.609937, 11.090397, -315.593153>,
				< -48.875470, 16.915286, -311.498821>
			}
			triangle {
				< -42.541377, 5.766062, -294.864237>,
				< -48.875470, 16.915286, -311.498821>,
				< -42.162228, 8.781245, -292.744070>
			}
			triangle {
				< -42.162228, 8.781245, -292.744070>,
				< -48.875470, 16.915286, -311.498821>,
				< -47.662295, 21.590991, -304.674715>
			}
			triangle {
				< -42.162228, 8.781245, -292.744070>,
				< -47.662295, 21.590991, -304.674715>,
				< -41.533317, 11.201576, -289.210916>
			}
			triangle {
				< -41.533317, 11.201576, -289.210916>,
				< -47.662295, 21.590991, -304.674715>,
				< -46.067171, 24.798874, -295.582622>
			}
			triangle {
				< -41.533317, 11.201576, -289.210916>,
				< -46.067171, 24.798874, -295.582622>,
				< -40.701315, 12.862107, -284.504801>
			}
			triangle {
				< -40.701315, 12.862107, -284.504801>,
				< -46.067171, 24.798874, -295.582622>,
				< -44.213545, 26.320336, -284.838974>
			}
			triangle {
				< -40.701315, 12.862107, -284.504801>,
				< -44.213545, 26.320336, -284.838974>,
				< -39.726812, 13.649659, -278.945357>
			}
			triangle {
				< -39.726812, 13.649659, -278.945357>,
				< -44.213545, 26.320336, -284.838974>,
				< -42.239133, 26.051663, -273.173541>
			}
			triangle {
				< -39.726812, 13.649659, -278.945357>,
				< -42.239133, 26.051663, -273.173541>,
				< -38.679328, 13.510603, -272.910982>
			}
			triangle {
				< -38.679328, 13.510603, -272.910982>,
				< -42.239133, 26.051663, -273.173541>,
				< -40.283509, 24.011187, -261.380315>
			}
			triangle {
				< -38.679328, 13.510603, -272.910982>,
				< -40.283509, 24.011187, -261.380315>,
				< -37.631545, 12.454365, -266.812474>
			}
			triangle {
				< -37.631545, 12.454365, -266.812474>,
				< -40.283509, 24.011187, -261.380315>,
				< -38.477205, 20.337975, -250.263602>
			}
			triangle {
				< -37.631545, 12.454365, -266.812474>,
				< -38.477205, 20.337975, -250.263602>,
				< -36.654130, 10.552976, -261.065722>
			}
			triangle {
				< -36.654130, 10.552976, -261.065722>,
				< -38.477205, 20.337975, -250.263602>,
				< -36.933597, 15.282313, -240.583241>
			}
			triangle {
				< -36.654130, 10.552976, -261.065722>,
				< -36.933597, 15.282313, -240.583241>,
				< -35.811119, 7.935950, -256.062776>
			}
			triangle {
				< -35.811119, 7.935950, -256.062776>,
				< -36.933597, 15.282313, -240.583241>,
				< -35.743687, 9.188759, -233.001858>
			}
			triangle {
				< -35.811119, 7.935950, -256.062776>,
				< -35.743687, 9.188759, -233.001858>,
				< -35.156175, 4.781698, -252.145618>
			}
			triangle {
				< -35.156175, 4.781698, -252.145618>,
				< -35.743687, 9.188759, -233.001858>,
				< -34.973834, 2.472578, -228.039220>
			}
			triangle {
				< -35.156175, 4.781698, -252.145618>,
				< -34.973834, 2.472578, -228.039220>,
				< -34.729920, 1.305151, -249.581948>
			}
			triangle {
				< -34.729920, 1.305151, -249.581948>,
				< -34.973834, 2.472578, -228.039220>,
				< -34.665067, -4.408550, -226.035878>
			}
			triangle {
				< -34.729920, 1.305151, -249.581948>,
				< -34.665067, -4.408550, -226.035878>,
				< -34.558419, -2.256759, -248.547092>
			}
			triangle {
				< -34.558419, -2.256759, -248.547092>,
				< -34.665067, -4.408550, -226.035878>,
				< -34.833450, -10.985685, -227.129385>
			}
			triangle {
				< -34.558419, -2.256759, -248.547092>,
				< -34.833450, -10.985685, -227.129385>,
				< -34.651995, -5.661339, -249.111965>
			}
			triangle {
				< -34.833450, -10.985685, -227.129385>,
				< -38.021222, -15.557774, -207.779333>,
				< -38.844425, -23.795418, -213.612050>
			}
			triangle {
				< -34.833450, -10.985685, -227.129385>,
				< -38.844425, -23.795418, -213.612050>,
				< -35.470251, -16.810564, -231.244594>
			}
			triangle {
				< -35.470251, -16.810564, -231.244594>,
				< -38.844425, -23.795418, -213.612050>,
				< -40.237248, -30.407872, -223.326296>
			}
			triangle {
				< -35.470251, -16.810564, -231.244594>,
				< -40.237248, -30.407872, -223.326296>,
				< -36.541872, -21.486277, -238.099173>
			}
			triangle {
				< -36.541872, -21.486277, -238.099173>,
				< -40.237248, -30.407872, -223.326296>,
				< -42.133160, -34.944497, -236.254439>
			}
			triangle {
				< -36.541872, -21.486277, -238.099173>,
				< -42.133160, -34.944497, -236.254439>,
				< -37.989412, -24.694173, -247.222960>
			}
			triangle {
				< -37.989412, -24.694173, -247.222960>,
				< -42.133160, -34.944497, -236.254439>,
				< -44.432517, -37.096146, -251.509488>
			}
			triangle {
				< -37.989412, -24.694173, -247.222960>,
				< -44.432517, -37.096146, -251.509488>,
				< -39.728988, -26.215615, -257.991105>
			}
			triangle {
				< -39.728988, -26.215615, -257.991105>,
				< -44.432517, -37.096146, -251.509488>,
				< -47.001429, -36.716208, -268.047094>
			}
			triangle {
				< -39.728988, -26.215615, -257.991105>,
				< -47.001429, -36.716208, -268.047094>,
				< -41.653462, -25.946941, -269.667238>
			}
			triangle {
				< -41.653462, -25.946941, -269.667238>,
				< -47.001429, -36.716208, -268.047094>,
				< -49.674783, -33.830531, -284.737885>
			}
			triangle {
				< -41.653462, -25.946941, -269.667238>,
				< -49.674783, -33.830531, -284.737885>,
				< -43.636613, -23.906453, -281.454533>
			}
			triangle {
				< -43.636613, -23.906453, -281.454533>,
				< -49.674783, -33.830531, -284.737885>,
				< -52.264813, -28.635811, -300.445378>
			}
			triangle {
				< -43.636613, -23.906453, -281.454533>,
				< -52.264813, -28.635811, -300.445378>,
				< -45.540556, -20.233240, -292.550206>
			}
			triangle {
				< -45.540556, -20.233240, -292.550206>,
				< -52.264813, -28.635811, -300.445378>,
				< -54.575443, -21.486029, -314.103067>
			}
			triangle {
				< -45.540556, -20.233240, -292.550206>,
				< -54.575443, -21.486029, -314.103067>,
				< -47.225755, -15.177570, -302.200198>
			}
			triangle {
				< -47.225755, -15.177570, -302.200198>,
				< -54.575443, -21.486029, -314.103067>,
				< -56.420904, -12.868429, -324.786007>
			}
			triangle {
				< -47.225755, -15.177570, -302.200198>,
				< -56.420904, -12.868429, -324.786007>,
				< -48.563257, -9.084015, -309.749931>
			}
			triangle {
				< -48.563257, -9.084015, -309.749931>,
				< -56.420904, -12.868429, -324.786007>,
				< -57.645928, -3.370315, -331.772506>
			}
			triangle {
				< -48.563257, -9.084015, -309.749931>,
				< -57.645928, -3.370315, -331.772506>,
				< -49.447153, -2.367835, -314.688116>
			}
			triangle {
				< -49.447153, -2.367835, -314.688116>,
				< -57.645928, -3.370315, -331.772506>,
				< -58.144268, 6.361050, -334.591478>
			}
			triangle {
				< -49.447153, -2.367835, -314.688116>,
				< -58.144268, 6.361050, -334.591478>,
				< -49.805857, 4.513294, -316.680759>
			}
			triangle {
				< -49.805857, 4.513294, -316.680759>,
				< -58.144268, 6.361050, -334.591478>,
				< -57.871994, 15.662508, -333.052903>
			}
			triangle {
				< -49.805857, 4.513294, -316.680759>,
				< -57.871994, 15.662508, -333.052903>,
				< -49.609937, 11.090397, -315.593153>
			}
			triangle {
				< -49.609937, 11.090397, -315.593153>,
				< -57.871994, 15.662508, -333.052903>,
				< -56.853134, 23.900121, -327.260464>
			}
			triangle {
				< -49.609937, 11.090397, -315.593153>,
				< -56.853134, 23.900121, -327.260464>,
				< -48.875470, 16.915286, -311.498821>
			}
			triangle {
				< -48.875470, 16.915286, -311.498821>,
				< -56.853134, 23.900121, -327.260464>,
				< -55.176642, 30.512584, -317.604661>
			}
			triangle {
				< -48.875470, 16.915286, -311.498821>,
				< -55.176642, 30.512584, -317.604661>,
				< -47.662295, 21.590991, -304.674715>
			}
			triangle {
				< -47.662295, 21.590991, -304.674715>,
				< -55.176642, 30.512584, -317.604661>,
				< -52.985057, 35.049222, -304.737449>
			}
			triangle {
				< -47.662295, 21.590991, -304.674715>,
				< -52.985057, 35.049222, -304.737449>,
				< -46.067171, 24.798874, -295.582622>
			}
			triangle {
				< -46.067171, 24.798874, -295.582622>,
				< -52.985057, 35.049222, -304.737449>,
				< -50.457224, 37.200890, -289.529383>
			}
			triangle {
				< -46.067171, 24.798874, -295.582622>,
				< -50.457224, 37.200890, -289.529383>,
				< -44.213545, 26.320336, -284.838974>
			}
			triangle {
				< -44.213545, 26.320336, -284.838974>,
				< -50.457224, 37.200890, -289.529383>,
				< -47.788251, 36.820922, -273.012429>
			}
			triangle {
				< -44.213545, 26.320336, -284.838974>,
				< -47.788251, 36.820922, -273.012429>,
				< -42.239133, 26.051663, -273.173541>
			}
			triangle {
				< -42.239133, 26.051663, -273.173541>,
				< -47.788251, 36.820922, -273.012429>,
				< -45.170080, 33.935264, -256.310225>
			}
			triangle {
				< -42.239133, 26.051663, -273.173541>,
				< -45.170080, 33.935264, -256.310225>,
				< -40.283509, 24.011187, -261.380315>
			}
			triangle {
				< -40.283509, 24.011187, -261.380315>,
				< -45.170080, 33.935264, -256.310225>,
				< -42.775683, 28.740544, -240.562439>
			}
			triangle {
				< -40.283509, 24.011187, -261.380315>,
				< -42.775683, 28.740544, -240.562439>,
				< -38.477205, 20.337975, -250.263602>
			}
			triangle {
				< -38.477205, 20.337975, -250.263602>,
				< -42.775683, 28.740544, -240.562439>,
				< -40.748704, 21.590753, -226.846397>
			}
			triangle {
				< -38.477205, 20.337975, -250.263602>,
				< -40.748704, 21.590753, -226.846397>,
				< -36.933597, 15.282313, -240.583241>
			}
			triangle {
				< -36.933597, 15.282313, -240.583241>,
				< -40.748704, 21.590753, -226.846397>,
				< -39.198920, 12.973183, -216.102555>
			}
			triangle {
				< -36.933597, 15.282313, -240.583241>,
				< -39.198920, 12.973183, -216.102555>,
				< -35.743687, 9.188759, -233.001858>
			}
			triangle {
				< -35.743687, 9.188759, -233.001858>,
				< -39.198920, 12.973183, -216.102555>,
				< -38.202379, 3.475058, -209.068954>
			}
			triangle {
				< -35.743687, 9.188759, -233.001858>,
				< -38.202379, 3.475058, -209.068954>,
				< -34.973834, 2.472578, -228.039220>
			}
			triangle {
				< -34.973834, 2.472578, -228.039220>,
				< -38.202379, 3.475058, -209.068954>,
				< -37.804112, -6.256306, -206.229433>
			}
			triangle {
				< -34.973834, 2.472578, -228.039220>,
				< -37.804112, -6.256306, -206.229433>,
				< -34.665067, -4.408550, -226.035878>
			}
			triangle {
				< -34.665067, -4.408550, -226.035878>,
				< -37.804112, -6.256306, -206.229433>,
				< -38.021222, -15.557774, -207.779333>
			}
			triangle {
				< -34.665067, -4.408550, -226.035878>,
				< -38.021222, -15.557774, -207.779333>,
				< -34.833450, -10.985685, -227.129385>
			}
			triangle {
				< -38.021222, -15.557774, -207.779333>,
				< -44.009622, -19.066082, -192.438528>,
				< -44.912983, -29.155085, -199.597463>
			}
			triangle {
				< -38.021222, -15.557774, -207.779333>,
				< -44.912983, -29.155085, -199.597463>,
				< -38.844425, -23.795418, -213.612050>
			}
			triangle {
				< -38.844425, -23.795418, -213.612050>,
				< -44.912983, -29.155085, -199.597463>,
				< -46.449993, -37.253663, -211.519808>
			}
			triangle {
				< -38.844425, -23.795418, -213.612050>,
				< -46.449993, -37.253663, -211.519808>,
				< -40.237248, -30.407872, -223.326296>
			}
			triangle {
				< -40.237248, -30.407872, -223.326296>,
				< -46.449993, -37.253663, -211.519808>,
				< -48.558630, -42.809870, -227.385193>
			}
			triangle {
				< -40.237248, -30.407872, -223.326296>,
				< -48.558630, -42.809870, -227.385193>,
				< -42.133160, -34.944497, -236.254439>
			}
			triangle {
				< -42.133160, -34.944497, -236.254439>,
				< -48.558630, -42.809870, -227.385193>,
				< -51.139642, -45.445092, -246.104032>
			}
			triangle {
				< -42.133160, -34.944497, -236.254439>,
				< -51.139642, -45.445092, -246.104032>,
				< -44.432517, -37.096146, -251.509488>
			}
			triangle {
				< -44.432517, -37.096146, -251.509488>,
				< -51.139642, -45.445092, -246.104032>,
				< -54.051429, -44.979751, -266.393900>
			}
			triangle {
				< -44.432517, -37.096146, -251.509488>,
				< -54.051429, -44.979751, -266.393900>,
				< -47.001429, -36.716208, -268.047094>
			}
			triangle {
				< -47.001429, -36.716208, -268.047094>,
				< -54.051429, -44.979751, -266.393900>,
				< -57.110462, -41.445546, -286.868602>
			}
			triangle {
				< -47.001429, -36.716208, -268.047094>,
				< -57.110462, -41.445546, -286.868602>,
				< -49.674783, -33.830531, -284.737885>
			}
			triangle {
				< -49.674783, -33.830531, -284.737885>,
				< -57.110462, -41.445546, -286.868602>,
				< -60.099941, -35.083316, -306.134164>
			}
			triangle {
				< -49.674783, -33.830531, -284.737885>,
				< -60.099941, -35.083316, -306.134164>,
				< -52.264813, -28.635811, -300.445378>
			}
			triangle {
				< -52.264813, -28.635811, -300.445378>,
				< -60.099941, -35.083316, -306.134164>,
				< -62.786669, -26.326669, -322.883010>
			}
			triangle {
				< -52.264813, -28.635811, -300.445378>,
				< -62.786669, -26.326669, -322.883010>,
				< -54.575443, -21.486029, -314.103067>
			}
			triangle {
				< -54.575443, -21.486029, -314.103067>,
				< -62.786669, -26.326669, -322.883010>,
				< -64.945027, -15.772309, -335.982263>
			}
			triangle {
				< -54.575443, -21.486029, -314.103067>,
				< -64.945027, -15.772309, -335.982263>,
				< -56.420904, -12.868429, -324.786007>
			}
			triangle {
				< -56.420904, -12.868429, -324.786007>,
				< -64.945027, -15.772309, -335.982263>,
				< -66.383548, -4.139545, -344.548166>
			}
			triangle {
				< -56.420904, -12.868429, -324.786007>,
				< -66.383548, -4.139545, -344.548166>,
				< -57.645928, -3.370315, -331.772506>
			}
			triangle {
				< -57.645928, -3.370315, -331.772506>,
				< -66.383548, -4.139545, -344.548166>,
				< -66.970021, 7.778910, -348.004133>
			}
			triangle {
				< -57.645928, -3.370315, -331.772506>,
				< -66.970021, 7.778910, -348.004133>,
				< -58.144268, 6.361050, -334.591478>
			}
			triangle {
				< -58.144268, 6.361050, -334.591478>,
				< -66.970021, 7.778910, -348.004133>,
				< -66.649489, 19.170795, -346.117854>
			}
			triangle {
				< -58.144268, 6.361050, -334.591478>,
				< -66.649489, 19.170795, -346.117854>,
				< -57.871994, 15.662508, -333.052903>
			}
			triangle {
				< -57.871994, 15.662508, -333.052903>,
				< -66.649489, 19.170795, -346.117854>,
				< -65.452062, 29.259806, -339.016080>
			}
			triangle {
				< -57.871994, 15.662508, -333.052903>,
				< -65.452062, 29.259806, -339.016080>,
				< -56.853134, 23.900121, -327.260464>
			}
			triangle {
				< -56.853134, 23.900121, -327.260464>,
				< -65.452062, 29.259806, -339.016080>,
				< -63.488618, 37.358362, -327.176780>
			}
			triangle {
				< -56.853134, 23.900121, -327.260464>,
				< -63.488618, 37.358362, -327.176780>,
				< -55.176642, 30.512584, -317.604661>
			}
			triangle {
				< -55.176642, 30.512584, -317.604661>,
				< -63.488618, 37.358362, -327.176780>,
				< -60.935505, 42.914588, -311.397910>
			}
			triangle {
				< -55.176642, 30.512584, -317.604661>,
				< -60.935505, 42.914588, -311.397910>,
				< -52.985057, 35.049222, -304.737449>
			}
			triangle {
				< -52.985057, 35.049222, -304.737449>,
				< -60.935505, 42.914588, -311.397910>,
				< -58.010999, 45.549814, -292.745739>
			}
			triangle {
				< -52.985057, 35.049222, -304.737449>,
				< -58.010999, 45.549814, -292.745739>,
				< -50.457224, 37.200890, -289.529383>
			}
			triangle {
				< -50.457224, 37.200890, -289.529383>,
				< -58.010999, 45.549814, -292.745739>,
				< -54.948818, 45.084488, -272.485226>
			}
			triangle {
				< -50.457224, 37.200890, -289.529383>,
				< -54.948818, 45.084488, -272.485226>,
				< -47.788251, 36.820922, -273.012429>
			}
			triangle {
				< -47.788251, 36.820922, -273.012429>,
				< -54.948818, 45.084488, -272.485226>,
				< -51.972710, 41.550290, -251.994371>
			}
			triangle {
				< -47.788251, 36.820922, -273.012429>,
				< -51.972710, 41.550290, -251.994371>,
				< -45.170080, 33.935264, -256.310225>
			}
			triangle {
				< -45.170080, 33.935264, -256.310225>,
				< -51.972710, 41.550290, -251.994371>,
				< -49.277309, 35.188049, -232.671559>
			}
			triangle {
				< -45.170080, 33.935264, -256.310225>,
				< -49.277309, 35.188049, -232.671559>,
				< -42.775683, 28.740544, -240.562439>
			}
			triangle {
				< -42.775683, 28.740544, -240.562439>,
				< -49.277309, 35.188049, -232.671559>,
				< -47.016989, 26.431413, -215.839744>
			}
			triangle {
				< -42.775683, 28.740544, -240.562439>,
				< -47.016989, 26.431413, -215.839744>,
				< -40.748704, 21.590753, -226.846397>
			}
			triangle {
				< -40.748704, 21.590753, -226.846397>,
				< -47.016989, 26.431413, -215.839744>,
				< -45.303147, 15.877062, -202.654049>
			}
			triangle {
				< -40.748704, 21.590753, -226.846397>,
				< -45.303147, 15.877062, -202.654049>,
				< -39.198920, 12.973183, -216.102555>
			}
			triangle {
				< -39.198920, 12.973183, -216.102555>,
				< -45.303147, 15.877062, -202.654049>,
				< -44.208121, 4.244309, -194.021463>
			}
			triangle {
				< -39.198920, 12.973183, -216.102555>,
				< -44.208121, 4.244309, -194.021463>,
				< -38.202379, 3.475058, -209.068954>
			}
			triangle {
				< -38.202379, 3.475058, -209.068954>,
				< -44.208121, 4.244309, -194.021463>,
				< -43.772046, -7.674146, -190.536097>
			}
			triangle {
				< -38.202379, 3.475058, -209.068954>,
				< -43.772046, -7.674146, -190.536097>,
				< -37.804112, -6.256306, -206.229433>
			}
			triangle {
				< -37.804112, -6.256306, -206.229433>,
				< -43.772046, -7.674146, -190.536097>,
				< -44.009622, -19.066082, -192.438528>
			}
			triangle {
				< -37.804112, -6.256306, -206.229433>,
				< -44.009622, -19.066082, -192.438528>,
				< -38.021222, -15.557774, -207.779333>
			}
			triangle {
				< -44.009622, -19.066082, -192.438528>,
				< -52.276127, -21.271497, -182.227790>,
				< -53.163316, -32.524325, -190.228090>
			}
			triangle {
				< -44.009622, -19.066082, -192.438528>,
				< -53.163316, -32.524325, -190.228090>,
				< -44.912983, -29.155085, -199.597463>
			}
			triangle {
				< -44.912983, -29.155085, -199.597463>,
				< -53.163316, -32.524325, -190.228090>,
				< -54.681383, -41.557077, -203.550890>
			}
			triangle {
				< -44.912983, -29.155085, -199.597463>,
				< -54.681383, -41.557077, -203.550890>,
				< -46.449993, -37.253663, -211.519808>
			}
			triangle {
				< -46.449993, -37.253663, -211.519808>,
				< -54.681383, -41.557077, -203.550890>,
				< -56.779996, -47.754232, -221.279591>
			}
			triangle {
				< -46.449993, -37.253663, -211.519808>,
				< -56.779996, -47.754232, -221.279591>,
				< -48.558630, -42.809870, -227.385193>
			}
			triangle {
				< -48.558630, -42.809870, -227.385193>,
				< -56.779996, -47.754232, -221.279591>,
				< -59.371673, -50.693456, -242.196217>
			}
			triangle {
				< -48.558630, -42.809870, -227.385193>,
				< -59.371673, -50.693456, -242.196217>,
				< -51.139642, -45.445092, -246.104032>
			}
			triangle {
				< -51.139642, -45.445092, -246.104032>,
				< -59.371673, -50.693456, -242.196217>,
				< -62.322486, -50.174430, -264.867425>
			}
			triangle {
				< -51.139642, -45.445092, -246.104032>,
				< -62.322486, -50.174430, -264.867425>,
				< -54.051429, -44.979751, -266.393900>
			}
			triangle {
				< -54.051429, -44.979751, -266.393900>,
				< -62.322486, -50.174430, -264.867425>,
				< -65.449998, -46.232544, -287.744313>
			}
			triangle {
				< -54.051429, -44.979751, -266.393900>,
				< -65.449998, -46.232544, -287.744313>,
				< -57.110462, -41.445546, -286.868602>
			}
			triangle {
				< -57.110462, -41.445546, -286.868602>,
				< -65.449998, -46.232544, -287.744313>,
				< -68.530619, -39.136406, -309.268922>
			}
			triangle {
				< -57.110462, -41.445546, -286.868602>,
				< -68.530619, -39.136406, -309.268922>,
				< -60.099941, -35.083316, -306.134164>
			}
			triangle {
				< -60.099941, -35.083316, -306.134164>,
				< -68.530619, -39.136406, -309.268922>,
				< -71.317665, -29.369617, -327.980846>
			}
			triangle {
				< -60.099941, -35.083316, -306.134164>,
				< -71.317665, -29.369617, -327.980846>,
				< -62.786669, -26.326669, -322.883010>
			}
			triangle {
				< -62.786669, -26.326669, -322.883010>,
				< -71.317665, -29.369617, -327.980846>,
				< -73.568165, -17.597765, -342.614710>
			}
			triangle {
				< -62.786669, -26.326669, -322.883010>,
				< -73.568165, -17.597765, -342.614710>,
				< -64.945027, -15.772309, -335.982263>
			}
			triangle {
				< -64.945027, -15.772309, -335.982263>,
				< -73.568165, -17.597765, -342.614710>,
				< -75.073481, -4.623104, -352.183938>
			}
			triangle {
				< -64.945027, -15.772309, -335.982263>,
				< -75.073481, -4.623104, -352.183938>,
				< -66.383548, -4.139545, -344.548166>
			}
			triangle {
				< -66.383548, -4.139545, -344.548166>,
				< -75.073481, -4.623104, -352.183938>,
				< -75.688370, 8.670211, -356.044590>
			}
			triangle {
				< -66.383548, -4.139545, -344.548166>,
				< -75.688370, 8.670211, -356.044590>,
				< -66.970021, 7.778910, -348.004133>
			}
			triangle {
				< -66.970021, 7.778910, -348.004133>,
				< -75.688370, 8.670211, -356.044590>,
				< -75.352222, 21.376209, -353.937417>
			}
			triangle {
				< -66.970021, 7.778910, -348.004133>,
				< -75.352222, 21.376209, -353.937417>,
				< -66.649489, 19.170795, -346.117854>
			}
			triangle {
				< -66.649489, 19.170795, -346.117854>,
				< -75.352222, 21.376209, -353.937417>,
				< -74.098296, 32.629024, -346.004009>
			}
			triangle {
				< -66.649489, 19.170795, -346.117854>,
				< -74.098296, 32.629024, -346.004009>,
				< -65.452062, 29.259806, -339.016080>
			}
			triangle {
				< -65.452062, 29.259806, -339.016080>,
				< -74.098296, 32.629024, -346.004009>,
				< -72.048508, 41.661792, -332.777768>
			}
			triangle {
				< -65.452062, 29.259806, -339.016080>,
				< -72.048508, 41.661792, -332.777768>,
				< -63.488618, 37.358362, -327.176780>
			}
			triangle {
				< -63.488618, 37.358362, -327.176780>,
				< -72.048508, 41.661792, -332.777768>,
				< -69.395572, 47.858968, -315.149695>
			}
			triangle {
				< -63.488618, 37.358362, -327.176780>,
				< -69.395572, 47.858968, -315.149695>,
				< -60.935505, 42.914588, -311.397910>
			}
			triangle {
				< -60.935505, 42.914588, -311.397910>,
				< -69.395572, 47.858968, -315.149695>,
				< -66.375591, 50.798189, -294.310689>
			}
			triangle {
				< -60.935505, 42.914588, -311.397910>,
				< -66.375591, 50.798189, -294.310689>,
				< -58.010999, 45.549814, -292.745739>
			}
			triangle {
				< -58.010999, 45.549814, -292.745739>,
				< -66.375591, 50.798189, -294.310689>,
				< -63.237205, 50.279163, -271.673590>
			}
			triangle {
				< -58.010999, 45.549814, -292.745739>,
				< -63.237205, 50.279163, -271.673590>,
				< -54.948818, 45.084488, -272.485226>
			}
			triangle {
				< -54.948818, 45.084488, -272.485226>,
				< -63.237205, 50.279163, -271.673590>,
				< -60.213100, 46.337266, -248.777911>
			}
			triangle {
				< -54.948818, 45.084488, -272.485226>,
				< -60.213100, 46.337266, -248.777911>,
				< -51.972710, 41.550290, -251.994371>
			}
			triangle {
				< -51.972710, 41.550290, -251.994371>,
				< -60.213100, 46.337266, -248.777911>,
				< -57.499230, 39.241146, -227.186680>
			}
			triangle {
				< -51.972710, 41.550290, -251.994371>,
				< -57.499230, 39.241146, -227.186680>,
				< -49.277309, 35.188049, -232.671559>
			}
			triangle {
				< -49.277309, 35.188049, -232.671559>,
				< -57.499230, 39.241146, -227.186680>,
				< -55.243906, 29.474370, -208.378375>
			}
			triangle {
				< -49.277309, 35.188049, -232.671559>,
				< -55.243906, 29.474370, -208.378375>,
				< -47.016989, 26.431413, -215.839744>
			}
			triangle {
				< -47.016989, 26.431413, -215.839744>,
				< -55.243906, 29.474370, -208.378375>,
				< -53.547703, 17.702518, -193.643942>
			}
			triangle {
				< -47.016989, 26.431413, -215.839744>,
				< -53.547703, 17.702518, -193.643942>,
				< -45.303147, 15.877062, -202.654049>
			}
			triangle {
				< -45.303147, 15.877062, -202.654049>,
				< -53.547703, 17.702518, -193.643942>,
				< -52.470714, 4.727847, -183.997110>
			}
			triangle {
				< -45.303147, 15.877062, -202.654049>,
				< -52.470714, 4.727847, -183.997110>,
				< -44.208121, 4.244309, -194.021463>
			}
			triangle {
				< -44.208121, 4.244309, -194.021463>,
				< -52.470714, 4.727847, -183.997110>,
				< -52.043408, -8.565426, -180.102423>
			}
			triangle {
				< -44.208121, 4.244309, -194.021463>,
				< -52.043408, -8.565426, -180.102423>,
				< -43.772046, -7.674146, -190.536097>
			}
			triangle {
				< -43.772046, -7.674146, -190.536097>,
				< -52.043408, -8.565426, -180.102423>,
				< -52.276127, -21.271497, -182.227790>
			}
			triangle {
				< -43.772046, -7.674146, -190.536097>,
				< -52.276127, -21.271497, -182.227790>,
				< -44.009622, -19.066082, -192.438528>
			}
			triangle {
				< -52.276127, -21.271497, -182.227790>,
				< -62.046546, -22.023708, -177.914247>,
				< -62.845588, -33.673491, -186.208814>
			}
			triangle {
				< -52.276127, -21.271497, -182.227790>,
				< -62.845588, -33.673491, -186.208814>,
				< -53.163316, -32.524325, -190.228090>
			}
			triangle {
				< -53.163316, -32.524325, -190.228090>,
				< -62.845588, -33.673491, -186.208814>,
				< -64.219661, -43.024894, -200.022832>
			}
			triangle {
				< -53.163316, -32.524325, -190.228090>,
				< -64.219661, -43.024894, -200.022832>,
				< -54.681383, -41.557077, -203.550890>
			}
			triangle {
				< -54.681383, -41.557077, -203.550890>,
				< -64.219661, -43.024894, -200.022832>,
				< -66.132247, -49.440663, -218.406320>
			}
			triangle {
				< -54.681383, -41.557077, -203.550890>,
				< -66.132247, -49.440663, -218.406320>,
				< -56.779996, -47.754232, -221.279591>
			}
			triangle {
				< -56.779996, -47.754232, -221.279591>,
				< -66.132247, -49.440663, -218.406320>,
				< -68.512663, -52.483570, -240.096286>
			}
			triangle {
				< -56.779996, -47.754232, -221.279591>,
				< -68.512663, -52.483570, -240.096286>,
				< -59.371673, -50.693456, -242.196217>
			}
			triangle {
				< -59.371673, -50.693456, -242.196217>,
				< -68.512663, -52.483570, -240.096286>,
				< -71.244560, -51.946245, -263.606876>
			}
			triangle {
				< -59.371673, -50.693456, -242.196217>,
				< -71.244560, -51.946245, -263.606876>,
				< -62.322486, -50.174430, -264.867425>
			}
			triangle {
				< -62.322486, -50.174430, -264.867425>,
				< -71.244560, -51.946245, -263.606876>,
				< -74.161835, -47.865290, -287.332058>
			}
			triangle {
				< -62.322486, -50.174430, -264.867425>,
				< -74.161835, -47.865290, -287.332058>,
				< -65.449998, -46.232544, -287.744313>
			}
			triangle {
				< -65.449998, -46.232544, -287.744313>,
				< -74.161835, -47.865290, -287.332058>,
				< -77.054374, -40.518843, -309.655994>
			}
			triangle {
				< -65.449998, -46.232544, -287.744313>,
				< -77.054374, -40.518843, -309.655994>,
				< -68.530619, -39.136406, -309.268922>
			}
			triangle {
				< -68.530619, -39.136406, -309.268922>,
				< -77.054374, -40.518843, -309.655994>,
				< -79.685658, -30.407520, -329.063535>
			}
			triangle {
				< -68.530619, -39.136406, -309.268922>,
				< -79.685658, -30.407520, -329.063535>,
				< -71.317665, -29.369617, -327.980846>
			}
			triangle {
				< -71.317665, -29.369617, -327.980846>,
				< -79.685658, -30.407520, -329.063535>,
				< -81.819355, -18.220393, -344.241977>
			}
			triangle {
				< -71.317665, -29.369617, -327.980846>,
				< -81.819355, -18.220393, -344.241977>,
				< -73.568165, -17.597765, -342.614710>
			}
			triangle {
				< -73.568165, -17.597765, -342.614710>,
				< -81.819355, -18.220393, -344.241977>,
				< -83.250664, -4.788030, -354.167432>
			}
			triangle {
				< -73.568165, -17.597765, -342.614710>,
				< -83.250664, -4.788030, -354.167432>,
				< -75.073481, -4.623104, -352.183938>
			}
			triangle {
				< -75.073481, -4.623104, -352.183938>,
				< -83.250664, -4.788030, -354.167432>,
				< -83.836220, 8.974205, -358.171880>
			}
			triangle {
				< -75.073481, -4.623104, -352.183938>,
				< -83.836220, 8.974205, -358.171880>,
				< -75.688370, 8.670211, -356.044590>
			}
			triangle {
				< -75.688370, 8.670211, -356.044590>,
				< -83.836220, 8.974205, -358.171880>,
				< -83.516061, 22.128420, -355.986267>
			}
			triangle {
				< -75.688370, 8.670211, -356.044590>,
				< -83.516061, 22.128420, -355.986267>,
				< -75.352222, 21.376209, -353.937417>
			}
			triangle {
				< -75.352222, 21.376209, -353.937417>,
				< -83.516061, 22.128420, -355.986267>,
				< -82.323045, 33.778209, -347.757399>
			}
			triangle {
				< -75.352222, 21.376209, -353.937417>,
				< -82.323045, 33.778209, -347.757399>,
				< -74.098296, 32.629024, -346.004009>
			}
			triangle {
				< -74.098296, 32.629024, -346.004009>,
				< -82.323045, 33.778209, -347.757399>,
				< -80.377728, 43.129630, -334.038943>
			}
			triangle {
				< -74.098296, 32.629024, -346.004009>,
				< -80.377728, 43.129630, -334.038943>,
				< -72.048508, 41.661792, -332.777768>
			}
			triangle {
				< -72.048508, 41.661792, -332.777768>,
				< -80.377728, 43.129630, -334.038943>,
				< -77.869602, 49.545385, -315.755218>
			}
			triangle {
				< -72.048508, 41.661792, -332.777768>,
				< -77.869602, 49.545385, -315.755218>,
				< -69.395572, 47.858968, -315.149695>
			}
			triangle {
				< -69.395572, 47.858968, -315.149695>,
				< -77.869602, 49.545385, -315.755218>,
				< -75.029053, 52.588314, -294.142246>
			}
			triangle {
				< -69.395572, 47.858968, -315.149695>,
				< -75.029053, 52.588314, -294.142246>,
				< -66.375591, 50.798189, -294.310689>
			}
			triangle {
				< -66.375591, 50.798189, -294.310689>,
				< -75.029053, 52.588314, -294.142246>,
				< -72.095610, 52.050963, -270.665318>
			}
			triangle {
				< -66.375591, 50.798189, -294.310689>,
				< -72.095610, 52.050963, -270.665318>,
				< -63.237205, 50.279163, -271.673590>
			}
			triangle {
				< -63.237205, 50.279163, -271.673590>,
				< -72.095610, 52.050963, -270.665318>,
				< -69.289476, 47.970023, -246.921539>
			}
			triangle {
				< -63.237205, 50.279163, -271.673590>,
				< -69.289476, 47.970023, -246.921539>,
				< -60.213100, 46.337266, -248.777911>
			}
			triangle {
				< -60.213100, 46.337266, -248.777911>,
				< -69.289476, 47.970023, -246.921539>,
				< -66.790916, 40.623575, -224.531710>
			}
			triangle {
				< -60.213100, 46.337266, -248.777911>,
				< -66.790916, 40.623575, -224.531710>,
				< -57.499230, 39.241146, -227.186680>
			}
			triangle {
				< -57.499230, 39.241146, -227.186680>,
				< -66.790916, 40.623575, -224.531710>,
				< -64.730883, 30.512253, -205.028564>
			}
			triangle {
				< -57.499230, 39.241146, -227.186680>,
				< -64.730883, 30.512253, -205.028564>,
				< -55.243906, 29.474370, -208.378375>
			}
			triangle {
				< -55.243906, 29.474370, -208.378375>,
				< -64.730883, 30.512253, -205.028564>,
				< -63.192688, 18.325157, -189.750552>
			}
			triangle {
				< -55.243906, 29.474370, -208.378375>,
				< -63.192688, 18.325157, -189.750552>,
				< -53.547703, 17.702518, -193.643942>
			}
			triangle {
				< -53.547703, 17.702518, -193.643942>,
				< -63.192688, 18.325157, -189.750552>,
				< -62.221516, 4.892774, -179.748178>
			}
			triangle {
				< -53.547703, 17.702518, -193.643942>,
				< -62.221516, 4.892774, -179.748178>,
				< -52.470714, 4.727847, -183.997110>
			}
			triangle {
				< -52.470714, 4.727847, -183.997110>,
				< -62.221516, 4.892774, -179.748178>,
				< -61.837532, -8.869440, -175.708979>
			}
			triangle {
				< -52.470714, 4.727847, -183.997110>,
				< -61.837532, -8.869440, -175.708979>,
				< -52.043408, -8.565426, -180.102423>
			}
			triangle {
				< -52.043408, -8.565426, -180.102423>,
				< -61.837532, -8.869440, -175.708979>,
				< -62.046546, -22.023708, -177.914247>
			}
			triangle {
				< -52.043408, -8.565426, -180.102423>,
				< -62.046546, -22.023708, -177.914247>,
				< -52.276127, -21.271497, -182.227790>
			}
			triangle {
				< -62.046546, -22.023708, -177.914247>,
				< -72.404698, -21.271497, -179.831788>,
				< -73.073946, -32.524303, -187.852994>
			}
			triangle {
				< -62.046546, -22.023708, -177.914247>,
				< -73.073946, -32.524303, -187.852994>,
				< -62.845588, -33.673491, -186.208814>
			}
			triangle {
				< -62.845588, -33.673491, -186.208814>,
				< -73.073946, -32.524303, -187.852994>,
				< -74.228995, -41.557077, -201.211765>
			}
			triangle {
				< -62.845588, -33.673491, -186.208814>,
				< -74.228995, -41.557077, -201.211765>,
				< -64.219661, -43.024894, -200.022832>
			}
			triangle {
				< -64.219661, -43.024894, -200.022832>,
				< -74.228995, -41.557077, -201.211765>,
				< -75.844564, -47.754232, -218.990445>
			}
			triangle {
				< -64.219661, -43.024894, -200.022832>,
				< -75.844564, -47.754232, -218.990445>,
				< -66.132247, -49.440663, -218.406320>
			}
			triangle {
				< -66.132247, -49.440663, -218.406320>,
				< -75.844564, -47.754232, -218.990445>,
				< -77.866241, -50.693456, -239.969417>
			}
			triangle {
				< -66.132247, -49.440663, -218.406320>,
				< -77.866241, -50.693456, -239.969417>,
				< -68.512663, -52.483570, -240.096286>
			}
			triangle {
				< -68.512663, -52.483570, -240.096286>,
				< -77.866241, -50.693456, -239.969417>,
				< -80.199219, -50.174430, -262.711942>
			}
			triangle {
				< -68.512663, -52.483570, -240.096286>,
				< -80.199219, -50.174430, -262.711942>,
				< -71.244560, -51.946245, -263.606876>
			}
			triangle {
				< -71.244560, -51.946245, -263.606876>,
				< -80.199219, -50.174430, -262.711942>,
				< -82.703225, -46.232544, -285.665035>
			}
			triangle {
				< -71.244560, -51.946245, -263.606876>,
				< -82.703225, -46.232544, -285.665035>,
				< -74.161835, -47.865290, -287.332058>
			}
			triangle {
				< -74.161835, -47.865290, -287.332058>,
				< -82.703225, -46.232544, -285.665035>,
				< -85.197151, -39.136406, -307.265103>
			}
			triangle {
				< -74.161835, -47.865290, -287.332058>,
				< -85.197151, -39.136406, -307.265103>,
				< -77.054374, -40.518843, -309.655994>
			}
			triangle {
				< -77.054374, -40.518843, -309.655994>,
				< -85.197151, -39.136406, -307.265103>,
				< -87.474123, -29.369617, -326.045513>
			}
			triangle {
				< -77.054374, -40.518843, -309.655994>,
				< -87.474123, -29.369617, -326.045513>,
				< -79.685658, -30.407520, -329.063535>
			}
			triangle {
				< -79.685658, -30.407520, -329.063535>,
				< -87.474123, -29.369617, -326.045513>,
				< -89.325681, -17.597765, -340.734929>
			}
			triangle {
				< -79.685658, -30.407520, -329.063535>,
				< -89.325681, -17.597765, -340.734929>,
				< -81.819355, -18.220393, -344.241977>
			}
			triangle {
				< -81.819355, -18.220393, -344.241977>,
				< -89.325681, -17.597765, -340.734929>,
				< -90.570100, -4.623083, -350.341350>
			}
			triangle {
				< -81.819355, -18.220393, -344.241977>,
				< -90.570100, -4.623083, -350.341350>,
				< -83.250664, -4.788030, -354.167432>
			}
			triangle {
				< -83.250664, -4.788030, -354.167432>,
				< -90.570100, -4.623083, -350.341350>,
				< -91.079742, 8.670211, -354.217261>
			}
			triangle {
				< -83.250664, -4.788030, -354.167432>,
				< -91.079742, 8.670211, -354.217261>,
				< -83.836220, 8.974205, -358.171880>
			}
			triangle {
				< -83.836220, 8.974205, -358.171880>,
				< -91.079742, 8.670211, -354.217261>,
				< -90.801045, 21.376209, -352.101743>
			}
			triangle {
				< -83.836220, 8.974205, -358.171880>,
				< -90.801045, 21.376209, -352.101743>,
				< -83.516061, 22.128420, -355.986267>
			}
			triangle {
				< -83.516061, 22.128420, -355.986267>,
				< -90.801045, 21.376209, -352.101743>,
				< -89.763403, 32.629035, -344.137281>
			}
			triangle {
				< -83.516061, 22.128420, -355.986267>,
				< -89.763403, 32.629035, -344.137281>,
				< -82.323045, 33.778209, -347.757399>
			}
			triangle {
				< -82.323045, 33.778209, -347.757399>,
				< -89.763403, 32.629035, -344.137281>,
				< -88.074185, 41.661792, -330.860376>
			}
			triangle {
				< -82.323045, 33.778209, -347.757399>,
				< -88.074185, 41.661792, -330.860376>,
				< -80.377728, 43.129630, -334.038943>
			}
			triangle {
				< -80.377728, 43.129630, -334.038943>,
				< -88.074185, 41.661792, -330.860376>,
				< -85.901804, 47.858968, -313.166976>
			}
			triangle {
				< -80.377728, 43.129630, -334.038943>,
				< -85.901804, 47.858968, -313.166976>,
				< -77.869602, 49.545385, -315.755218>
			}
			triangle {
				< -77.869602, 49.545385, -315.755218>,
				< -85.901804, 47.858968, -313.166976>,
				< -83.449848, 50.798189, -292.254001>
			}
			triangle {
				< -77.869602, 49.545385, -315.755218>,
				< -83.449848, 50.798189, -292.254001>,
				< -75.029053, 52.588314, -294.142246>
			}
			triangle {
				< -75.029053, 52.588314, -294.142246>,
				< -83.449848, 50.798189, -292.254001>,
				< -80.928430, 50.279163, -269.540340>
			}
			triangle {
				< -75.029053, 52.588314, -294.142246>,
				< -80.928430, 50.279163, -269.540340>,
				< -72.095610, 52.050963, -270.665318>
			}
			triangle {
				< -72.095610, 52.050963, -270.665318>,
				< -80.928430, 50.279163, -269.540340>,
				< -78.528330, 46.337266, -246.571407>
			}
			triangle {
				< -72.095610, 52.050963, -270.665318>,
				< -78.528330, 46.337266, -246.571407>,
				< -69.289476, 47.970023, -246.921539>
			}
			triangle {
				< -69.289476, 47.970023, -246.921539>,
				< -78.528330, 46.337266, -246.571407>,
				< -76.402821, 39.241146, -224.914819>
			}
			triangle {
				< -69.289476, 47.970023, -246.921539>,
				< -76.402821, 39.241146, -224.914819>,
				< -66.790916, 40.623575, -224.531710>
			}
			triangle {
				< -66.790916, 40.623575, -224.531710>,
				< -76.402821, 39.241146, -224.914819>,
				< -74.660011, 29.474370, -206.052497>
			}
			triangle {
				< -66.790916, 40.623575, -224.531710>,
				< -74.660011, 29.474370, -206.052497>,
				< -64.730883, 30.512253, -205.028564>
			}
			triangle {
				< -64.730883, 30.512253, -205.028564>,
				< -74.660011, 29.474370, -206.052497>,
				< -73.365264, 17.702518, -191.277832>
			}
			triangle {
				< -64.730883, 30.512253, -205.028564>,
				< -73.365264, 17.702518, -191.277832>,
				< -63.192688, 18.325157, -189.750552>
			}
			triangle {
				< -63.192688, 18.325157, -189.750552>,
				< -73.365264, 17.702518, -191.277832>,
				< -72.551087, 4.727847, -181.605324>
			}
			triangle {
				< -63.192688, 18.325157, -189.750552>,
				< -72.551087, 4.727847, -181.605324>,
				< -62.221516, 4.892774, -179.748178>
			}
			triangle {
				< -62.221516, 4.892774, -179.748178>,
				< -72.551087, 4.727847, -181.605324>,
				< -72.229885, -8.565426, -177.700654>
			}
			triangle {
				< -62.221516, 4.892774, -179.748178>,
				< -72.229885, -8.565426, -177.700654>,
				< -61.837532, -8.869440, -175.708979>
			}
			triangle {
				< -61.837532, -8.869440, -175.708979>,
				< -72.229885, -8.565426, -177.700654>,
				< -72.404698, -21.271497, -179.831788>
			}
			triangle {
				< -61.837532, -8.869440, -175.708979>,
				< -72.404698, -21.271497, -179.831788>,
				< -62.046546, -22.023708, -177.914247>
			}
			triangle {
				< -72.404698, -21.271497, -179.831788>,
				< -82.422405, -19.066082, -187.854439>,
				< -82.948416, -29.155085, -195.050567>
			}
			triangle {
				< -72.404698, -21.271497, -179.831788>,
				< -82.948416, -29.155085, -195.050567>,
				< -73.073946, -32.524303, -187.852994>
			}
			triangle {
				< -73.073946, -32.524303, -187.852994>,
				< -82.948416, -29.155085, -195.050567>,
				< -83.856970, -37.253663, -207.036719>
			}
			triangle {
				< -73.073946, -32.524303, -187.852994>,
				< -83.856970, -37.253663, -207.036719>,
				< -74.228995, -41.557077, -201.211765>
			}
			triangle {
				< -74.228995, -41.557077, -201.211765>,
				< -83.856970, -37.253663, -207.036719>,
				< -85.129157, -42.809870, -222.990215>
			}
			triangle {
				< -74.228995, -41.557077, -201.211765>,
				< -85.129157, -42.809870, -222.990215>,
				< -75.844564, -47.754232, -218.990445>
			}
			triangle {
				< -75.844564, -47.754232, -218.990445>,
				< -85.129157, -42.809870, -222.990215>,
				< -86.723201, -45.445092, -241.818056>
			}
			triangle {
				< -75.844564, -47.754232, -218.990445>,
				< -86.723201, -45.445092, -241.818056>,
				< -77.866241, -50.693456, -239.969417>
			}
			triangle {
				< -77.866241, -50.693456, -239.969417>,
				< -86.723201, -45.445092, -241.818056>,
				< -88.564999, -44.979751, -262.232006>
			}
			triangle {
				< -77.866241, -50.693456, -239.969417>,
				< -88.564999, -44.979751, -262.232006>,
				< -80.199219, -50.174430, -262.711942>
			}
			triangle {
				< -80.199219, -50.174430, -262.711942>,
				< -88.564999, -44.979751, -262.232006>,
				< -90.544164, -41.445546, -282.838285>
			}
			triangle {
				< -80.199219, -50.174430, -262.711942>,
				< -90.544164, -41.445546, -282.838285>,
				< -82.703225, -46.232544, -285.665035>
			}
			triangle {
				< -82.703225, -46.232544, -285.665035>,
				< -90.544164, -41.445546, -282.838285>,
				< -92.517368, -35.083316, -302.233547>
			}
			triangle {
				< -82.703225, -46.232544, -285.665035>,
				< -92.517368, -35.083316, -302.233547>,
				< -85.197151, -39.136406, -307.265103>
			}
			triangle {
				< -85.197151, -39.136406, -307.265103>,
				< -92.517368, -35.083316, -302.233547>,
				< -94.320506, -26.326669, -319.099814>
			}
			triangle {
				< -85.197151, -39.136406, -307.265103>,
				< -94.320506, -26.326669, -319.099814>,
				< -87.474123, -29.369617, -326.045513>
			}
			triangle {
				< -87.474123, -29.369617, -326.045513>,
				< -94.320506, -26.326669, -319.099814>,
				< -95.787689, -15.772309, -332.293838>
			}
			triangle {
				< -87.474123, -29.369617, -326.045513>,
				< -95.787689, -15.772309, -332.293838>,
				< -89.325681, -17.597765, -340.734929>
			}
			triangle {
				< -89.325681, -17.597765, -340.734929>,
				< -95.787689, -15.772309, -332.293838>,
				< -96.774198, -4.139524, -340.923101>
			}
			triangle {
				< -89.325681, -17.597765, -340.734929>,
				< -96.774198, -4.139524, -340.923101>,
				< -90.570100, -4.623083, -350.341350>
			}
			triangle {
				< -90.570100, -4.623083, -350.341350>,
				< -96.774198, -4.139524, -340.923101>,
				< -97.178295, 7.778910, -344.405055>
			}
			triangle {
				< -90.570100, -4.623083, -350.341350>,
				< -97.178295, 7.778910, -344.405055>,
				< -91.079742, 8.670211, -354.217261>
			}
			triangle {
				< -91.079742, 8.670211, -354.217261>,
				< -97.178295, 7.778910, -344.405055>,
				< -96.957304, 19.170804, -342.504621>
			}
			triangle {
				< -91.079742, 8.670211, -354.217261>,
				< -96.957304, 19.170804, -342.504621>,
				< -90.801045, 21.376209, -352.101743>
			}
			triangle {
				< -90.801045, 21.376209, -352.101743>,
				< -96.957304, 19.170804, -342.504621>,
				< -96.134625, 29.259818, -335.349977>
			}
			triangle {
				< -90.801045, 21.376209, -352.101743>,
				< -96.134625, 29.259818, -335.349977>,
				< -89.763403, 32.629035, -344.137281>
			}
			triangle {
				< -89.763403, 32.629035, -344.137281>,
				< -96.134625, 29.259818, -335.349977>,
				< -94.795883, 37.358373, -323.424250>
			}
			triangle {
				< -89.763403, 32.629035, -344.137281>,
				< -94.795883, 37.358373, -323.424250>,
				< -88.074185, 41.661792, -330.860376>
			}
			triangle {
				< -88.074185, 41.661792, -330.860376>,
				< -94.795883, 37.358373, -323.424250>,
				< -93.075238, 42.914599, -307.533652>
			}
			triangle {
				< -88.074185, 41.661792, -330.860376>,
				< -93.075238, 42.914599, -307.533652>,
				< -85.901804, 47.858968, -313.166976>
			}
			triangle {
				< -85.901804, 47.858968, -313.166976>,
				< -93.075238, 42.914599, -307.533652>,
				< -91.134697, 45.549825, -288.754374>
			}
			triangle {
				< -85.901804, 47.858968, -313.166976>,
				< -91.134697, 45.549825, -288.754374>,
				< -83.449848, 50.798189, -292.254001>
			}
			triangle {
				< -83.449848, 50.798189, -292.254001>,
				< -91.134697, 45.549825, -288.754374>,
				< -89.141123, 45.084488, -268.361777>
			}
			triangle {
				< -83.449848, 50.798189, -292.254001>,
				< -89.141123, 45.084488, -268.361777>,
				< -80.928430, 50.279163, -269.540340>
			}
			triangle {
				< -80.928430, 50.279163, -269.540340>,
				< -89.141123, 45.084488, -268.361777>,
				< -87.245636, 41.550301, -247.743711>
			}
			triangle {
				< -80.928430, 50.279163, -269.540340>,
				< -87.245636, 41.550301, -247.743711>,
				< -78.528330, 46.337266, -246.571407>
			}
			triangle {
				< -78.528330, 46.337266, -246.571407>,
				< -87.245636, 41.550301, -247.743711>,
				< -85.569121, 35.188071, -228.306890>
			}
			triangle {
				< -78.528330, 46.337266, -246.571407>,
				< -85.569121, 35.188071, -228.306890>,
				< -76.402821, 39.241146, -224.914819>
			}
			triangle {
				< -76.402821, 39.241146, -224.914819>,
				< -85.569121, 35.188071, -228.306890>,
				< -84.196210, 26.431413, -211.380258>
			}
			triangle {
				< -76.402821, 39.241146, -224.914819>,
				< -84.196210, 26.431413, -211.380258>,
				< -74.660011, 29.474370, -206.052497>
			}
			triangle {
				< -74.660011, 29.474370, -206.052497>,
				< -84.196210, 26.431413, -211.380258>,
				< -83.177470, 15.877062, -198.123291>
			}
			triangle {
				< -74.660011, 29.474370, -206.052497>,
				< -83.177470, 15.877062, -198.123291>,
				< -73.365264, 17.702518, -191.277832>
			}
			triangle {
				< -73.365264, 17.702518, -191.277832>,
				< -83.177470, 15.877062, -198.123291>,
				< -82.537457, 4.244289, -189.445317>
			}
			triangle {
				< -73.365264, 17.702518, -191.277832>,
				< -82.537457, 4.244289, -189.445317>,
				< -72.551087, 4.727847, -181.605324>
			}
			triangle {
				< -72.551087, 4.727847, -181.605324>,
				< -82.537457, 4.244289, -189.445317>,
				< -82.285106, -7.674146, -185.942277>
			}
			triangle {
				< -72.551087, 4.727847, -181.605324>,
				< -82.285106, -7.674146, -185.942277>,
				< -72.229885, -8.565426, -177.700654>
			}
			triangle {
				< -72.229885, -8.565426, -177.700654>,
				< -82.285106, -7.674146, -185.942277>,
				< -82.422405, -19.066082, -187.854439>
			}
			triangle {
				< -72.229885, -8.565426, -177.700654>,
				< -82.422405, -19.066082, -187.854439>,
				< -72.404698, -21.271497, -179.831788>
			}
			triangle {
				< -82.422405, -19.066082, -187.854439>,
				< -91.283619, -15.557774, -201.401338>,
				< -91.671400, -23.795418, -207.278743>
			}
			triangle {
				< -82.422405, -19.066082, -187.854439>,
				< -91.671400, -23.795418, -207.278743>,
				< -82.948416, -29.155085, -195.050567>
			}
			triangle {
				< -82.948416, -29.155085, -195.050567>,
				< -91.671400, -23.795418, -207.278743>,
				< -92.338994, -30.407872, -217.068970>
			}
			triangle {
				< -82.948416, -29.155085, -195.050567>,
				< -92.338994, -30.407872, -217.068970>,
				< -83.856970, -37.253663, -207.036719>
			}
			triangle {
				< -83.856970, -37.253663, -207.036719>,
				< -92.338994, -30.407872, -217.068970>,
				< -93.269579, -34.944497, -230.101451>
			}
			triangle {
				< -83.856970, -37.253663, -207.036719>,
				< -93.269579, -34.944497, -230.101451>,
				< -85.129157, -42.809870, -222.990215>
			}
			triangle {
				< -85.129157, -42.809870, -222.990215>,
				< -93.269579, -34.944497, -230.101451>,
				< -94.429687, -37.096165, -245.484069>
			}
			triangle {
				< -85.129157, -42.809870, -222.990215>,
				< -94.429687, -37.096165, -245.484069>,
				< -86.723201, -45.445092, -241.818056>
			}
			triangle {
				< -86.723201, -45.445092, -241.818056>,
				< -94.429687, -37.096165, -245.484069>,
				< -95.763393, -36.716208, -262.165815>
			}
			triangle {
				< -86.723201, -45.445092, -241.818056>,
				< -95.763393, -36.716208, -262.165815>,
				< -88.564999, -44.979751, -262.232006>
			}
			triangle {
				< -88.564999, -44.979751, -262.232006>,
				< -95.763393, -36.716208, -262.165815>,
				< -97.189859, -33.830546, -279.008150>
			}
			triangle {
				< -88.564999, -44.979751, -262.232006>,
				< -97.189859, -33.830546, -279.008150>,
				< -90.544164, -41.445546, -282.838285>
			}
			triangle {
				< -90.544164, -41.445546, -282.838285>,
				< -97.189859, -33.830546, -279.008150>,
				< -98.606259, -28.635811, -294.863790>
			}
			triangle {
				< -90.544164, -41.445546, -282.838285>,
				< -98.606259, -28.635811, -294.863790>,
				< -92.517368, -35.083316, -302.233547>
			}
			triangle {
				< -92.517368, -35.083316, -302.233547>,
				< -98.606259, -28.635811, -294.863790>,
				< -99.896260, -21.486029, -308.654577>
			}
			triangle {
				< -92.517368, -35.083316, -302.233547>,
				< -99.896260, -21.486029, -308.654577>,
				< -94.320506, -26.326669, -319.099814>
			}
			triangle {
				< -94.320506, -26.326669, -319.099814>,
				< -99.896260, -21.486029, -308.654577>,
				< -100.943282, -12.868429, -319.444448>
			}
			triangle {
				< -94.320506, -26.326669, -319.099814>,
				< -100.943282, -12.868429, -319.444448>,
				< -95.787689, -15.772309, -332.293838>
			}
			triangle {
				< -95.787689, -15.772309, -332.293838>,
				< -100.943282, -12.868429, -319.444448>,
				< -101.646110, -3.370294, -326.502353>
			}
			triangle {
				< -95.787689, -15.772309, -332.293838>,
				< -101.646110, -3.370294, -326.502353>,
				< -96.774198, -4.139524, -340.923101>
			}
			triangle {
				< -96.774198, -4.139524, -340.923101>,
				< -101.646110, -3.370294, -326.502353>,
				< -101.933725, 6.361070, -329.350352>
			}
			triangle {
				< -96.774198, -4.139524, -340.923101>,
				< -101.933725, 6.361070, -329.350352>,
				< -97.178295, 7.778910, -344.405055>
			}
			triangle {
				< -97.178295, 7.778910, -344.405055>,
				< -101.933725, 6.361070, -329.350352>,
				< -101.776458, 15.662508, -327.795863>
			}
			triangle {
				< -97.178295, 7.778910, -344.405055>,
				< -101.776458, 15.662508, -327.795863>,
				< -96.957304, 19.170804, -342.504621>
			}
			triangle {
				< -96.957304, 19.170804, -342.504621>,
				< -101.776458, 15.662508, -327.795863>,
				< -101.190597, 23.900162, -321.944058>
			}
			triangle {
				< -96.957304, 19.170804, -342.504621>,
				< -101.190597, 23.900162, -321.944058>,
				< -96.134625, 29.259818, -335.349977>
			}
			triangle {
				< -96.134625, 29.259818, -335.349977>,
				< -101.190597, 23.900162, -321.944058>,
				< -100.235775, 30.512607, -312.190950>
			}
			triangle {
				< -96.134625, 29.259818, -335.349977>,
				< -100.235775, 30.512607, -312.190950>,
				< -94.795883, 37.358373, -323.424250>
			}
			triangle {
				< -94.795883, 37.358373, -323.424250>,
				< -100.235775, 30.512607, -312.190950>,
				< -99.005789, 35.049245, -299.197197>
			}
			triangle {
				< -94.795883, 37.358373, -323.424250>,
				< -99.005789, 35.049245, -299.197197>,
				< -93.075238, 42.914599, -307.533652>
			}
			triangle {
				< -93.075238, 42.914599, -307.533652>,
				< -99.005789, 35.049245, -299.197197>,
				< -97.614318, 37.200902, -283.844262>
			}
			triangle {
				< -93.075238, 42.914599, -307.533652>,
				< -97.614318, 37.200902, -283.844262>,
				< -91.134697, 45.549825, -288.754374>
			}
			triangle {
				< -91.134697, 45.549825, -288.754374>,
				< -97.614318, 37.200902, -283.844262>,
				< -96.179292, 36.820944, -267.175704>
			}
			triangle {
				< -91.134697, 45.549825, -288.754374>,
				< -96.179292, 36.820944, -267.175704>,
				< -89.141123, 45.084488, -268.361777>
			}
			triangle {
				< -89.141123, 45.084488, -268.361777>,
				< -96.179292, 36.820944, -267.175704>,
				< -94.808705, 33.935282, -250.326067>
			}
			triangle {
				< -89.141123, 45.084488, -268.361777>,
				< -94.808705, 33.935282, -250.326067>,
				< -87.245636, 41.550301, -247.743711>
			}
			triangle {
				< -87.245636, 41.550301, -247.743711>,
				< -94.808705, 33.935282, -250.326067>,
				< -93.590386, 28.740553, -234.445006>
			}
			triangle {
				< -87.245636, 41.550301, -247.743711>,
				< -93.590386, 28.740553, -234.445006>,
				< -85.569121, 35.188071, -228.306890>
			}
			triangle {
				< -85.569121, 35.188071, -228.306890>,
				< -93.590386, 28.740553, -234.445006>,
				< -92.587583, 21.590773, -220.617071>
			}
			triangle {
				< -85.569121, 35.188071, -228.306890>,
				< -92.587583, 21.590773, -220.617071>,
				< -84.196210, 26.431413, -211.380258>
			}
			triangle {
				< -84.196210, 26.431413, -211.380258>,
				< -92.587583, 21.590773, -220.617071>,
				< -91.839954, 12.973183, -209.788501>
			}
			triangle {
				< -84.196210, 26.431413, -211.380258>,
				< -91.839954, 12.973183, -209.788501>,
				< -83.177470, 15.877062, -198.123291>
			}
			triangle {
				< -83.177470, 15.877062, -198.123291>,
				< -91.839954, 12.973183, -209.788501>,
				< -91.368511, 3.475058, -202.700794>
			}
			triangle {
				< -83.177470, 15.877062, -198.123291>,
				< -91.368511, 3.475058, -202.700794>,
				< -82.537457, 4.244289, -189.445317>
			}
			triangle {
				< -82.537457, 4.244289, -189.445317>,
				< -91.368511, 3.475058, -202.700794>,
				< -91.182202, -6.256306, -199.839771>
			}
			triangle {
				< -82.537457, 4.244289, -189.445317>,
				< -91.182202, -6.256306, -199.839771>,
				< -82.285106, -7.674146, -185.942277>
			}
			triangle {
				< -82.285106, -7.674146, -185.942277>,
				< -91.182202, -6.256306, -199.839771>,
				< -91.283619, -15.557774, -201.401338>
			}
			triangle {
				< -82.285106, -7.674146, -185.942277>,
				< -91.283619, -15.557774, -201.401338>,
				< -82.422405, -19.066082, -187.854439>
			}
			triangle {
				< -91.283619, -15.557774, -201.401338>,
				< -98.376021, -10.985663, -219.493225>,
				< -98.636061, -16.810564, -223.649070>
			}
			triangle {
				< -91.283619, -15.557774, -201.401338>,
				< -98.636061, -16.810564, -223.649070>,
				< -91.671400, -23.795418, -207.278743>
			}
			triangle {
				< -91.671400, -23.795418, -207.278743>,
				< -98.636061, -16.810564, -223.649070>,
				< -99.080086, -21.486277, -230.572104>
			}
			triangle {
				< -91.671400, -23.795418, -207.278743>,
				< -99.080086, -21.486277, -230.572104>,
				< -92.338994, -30.407872, -217.068970>
			}
			triangle {
				< -92.338994, -30.407872, -217.068970>,
				< -99.080086, -21.486277, -230.572104>,
				< -99.692173, -24.694173, -239.789039>
			}
			triangle {
				< -92.338994, -30.407872, -217.068970>,
				< -99.692173, -24.694173, -239.789039>,
				< -93.269579, -34.944497, -230.101451>
			}
			triangle {
				< -93.269579, -34.944497, -230.101451>,
				< -99.692173, -24.694173, -239.789039>,
				< -100.445636, -26.215615, -250.669956>
			}
			triangle {
				< -93.269579, -34.944497, -230.101451>,
				< -100.445636, -26.215615, -250.669956>,
				< -94.429687, -37.096165, -245.484069>
			}
			triangle {
				< -94.429687, -37.096165, -245.484069>,
				< -100.445636, -26.215615, -250.669956>,
				< -101.300642, -25.946941, -262.471765>
			}
			triangle {
				< -94.429687, -37.096165, -245.484069>,
				< -101.300642, -25.946941, -262.471765>,
				< -95.763393, -36.716208, -262.165815>
			}
			triangle {
				< -95.763393, -36.716208, -262.165815>,
				< -101.300642, -25.946941, -262.471765>,
				< -102.204017, -23.906475, -274.389714>
			}
			triangle {
				< -95.763393, -36.716208, -262.165815>,
				< -102.204017, -23.906475, -274.389714>,
				< -97.189859, -33.830546, -279.008150>
			}
			triangle {
				< -97.189859, -33.830546, -279.008150>,
				< -102.204017, -23.906475, -274.389714>,
				< -103.091352, -20.233240, -285.611808>
			}
			triangle {
				< -97.189859, -33.830546, -279.008150>,
				< -103.091352, -20.233240, -285.611808>,
				< -98.606259, -28.635811, -294.863790>
			}
			triangle {
				< -98.606259, -28.635811, -294.863790>,
				< -103.091352, -20.233240, -285.611808>,
				< -103.892304, -15.177570, -295.374393>
			}
			triangle {
				< -98.606259, -28.635811, -294.863790>,
				< -103.892304, -15.177570, -295.374393>,
				< -99.896260, -21.486029, -308.654577>
			}
			triangle {
				< -99.896260, -21.486029, -308.654577>,
				< -103.892304, -15.177570, -295.374393>,
				< -104.537942, -9.084015, -303.013980>
			}
			triangle {
				< -99.896260, -21.486029, -308.654577>,
				< -104.537942, -9.084015, -303.013980>,
				< -100.943282, -12.868429, -319.444448>
			}
			triangle {
				< -100.943282, -12.868429, -319.444448>,
				< -104.537942, -9.084015, -303.013980>,
				< -104.969226, -2.367835, -308.011651>
			}
			triangle {
				< -100.943282, -12.868429, -319.444448>,
				< -104.969226, -2.367835, -308.011651>,
				< -101.646110, -3.370294, -326.502353>
			}
			triangle {
				< -101.646110, -3.370294, -326.502353>,
				< -104.969226, -2.367835, -308.011651>,
				< -105.145298, 4.513294, -310.028523>
			}
			triangle {
				< -101.646110, -3.370294, -326.502353>,
				< -105.145298, 4.513294, -310.028523>,
				< -101.933725, 6.361070, -329.350352>
			}
			triangle {
				< -101.933725, 6.361070, -329.350352>,
				< -105.145298, 4.513294, -310.028523>,
				< -105.049036, 11.090406, -308.927625>
			}
			triangle {
				< -101.933725, 6.361070, -329.350352>,
				< -105.049036, 11.090406, -308.927625>,
				< -101.776458, 15.662508, -327.795863>
			}
			triangle {
				< -101.776458, 15.662508, -327.795863>,
				< -105.049036, 11.090406, -308.927625>,
				< -104.689844, 16.915297, -304.783762>
			}
			triangle {
				< -101.776458, 15.662508, -327.795863>,
				< -104.689844, 16.915297, -304.783762>,
				< -101.190597, 23.900162, -321.944058>
			}
			triangle {
				< -101.190597, 23.900162, -321.944058>,
				< -104.689844, 16.915297, -304.783762>,
				< -104.102060, 21.591011, -297.878027>
			}
			triangle {
				< -101.190597, 23.900162, -321.944058>,
				< -104.102060, 21.591011, -297.878027>,
				< -100.235775, 30.512607, -312.190950>
			}
			triangle {
				< -100.235775, 30.512607, -312.190950>,
				< -104.102060, 21.591011, -297.878027>,
				< -103.340112, 24.798896, -288.679302>
			}
			triangle {
				< -100.235775, 30.512607, -312.190950>,
				< -103.340112, 24.798896, -288.679302>,
				< -99.005789, 35.049245, -299.197197>
			}
			triangle {
				< -99.005789, 35.049245, -299.197197>,
				< -103.340112, 24.798896, -288.679302>,
				< -102.470845, 26.320359, -277.812332>
			}
			triangle {
				< -99.005789, 35.049245, -299.197197>,
				< -102.470845, 26.320359, -277.812332>,
				< -97.614318, 37.200902, -283.844262>
			}
			triangle {
				< -97.614318, 37.200902, -283.844262>,
				< -102.470845, 26.320359, -277.812332>,
				< -101.565130, 26.051685, -266.016483>
			}
			triangle {
				< -97.614318, 37.200902, -283.844262>,
				< -101.565130, 26.051685, -266.016483>,
				< -96.179292, 36.820944, -267.175704>
			}
			triangle {
				< -96.179292, 36.820944, -267.175704>,
				< -101.565130, 26.051685, -266.016483>,
				< -100.689739, 24.011198, -254.095227>
			}
			triangle {
				< -96.179292, 36.820944, -267.175704>,
				< -100.689739, 24.011198, -254.095227>,
				< -94.808705, 33.935282, -250.326067>
			}
			triangle {
				< -94.808705, 33.935282, -250.326067>,
				< -100.689739, 24.011198, -254.095227>,
				< -99.901542, 20.337984, -242.861196>
			}
			triangle {
				< -94.808705, 33.935282, -250.326067>,
				< -99.901542, 20.337984, -242.861196>,
				< -93.590386, 28.740553, -234.445006>
			}
			triangle {
				< -93.590386, 28.740553, -234.445006>,
				< -99.901542, 20.337984, -242.861196>,
				< -99.244349, 15.282324, -233.081311>
			}
			triangle {
				< -93.590386, 28.740553, -234.445006>,
				< -99.244349, 15.282324, -233.081311>,
				< -92.587583, 21.590773, -220.617071>
			}
			triangle {
				< -92.587583, 21.590773, -220.617071>,
				< -99.244349, 15.282324, -233.081311>,
				< -98.748587, 9.188780, -225.423723>
			}
			triangle {
				< -92.587583, 21.590773, -220.617071>,
				< -98.748587, 9.188780, -225.423723>,
				< -91.839954, 12.973183, -209.788501>
			}
			triangle {
				< -91.839954, 12.973183, -209.788501>,
				< -98.748587, 9.188780, -225.423723>,
				< -98.433077, 2.472578, -220.412031>
			}
			triangle {
				< -91.839954, 12.973183, -209.788501>,
				< -98.433077, 2.472578, -220.412031>,
				< -91.368511, 3.475058, -202.700794>
			}
			triangle {
				< -91.368511, 3.475058, -202.700794>,
				< -98.433077, 2.472578, -220.412031>,
				< -98.307736, -4.408529, -218.389049>
			}
			triangle {
				< -91.368511, 3.475058, -202.700794>,
				< -98.307736, -4.408529, -218.389049>,
				< -91.182202, -6.256306, -199.839771>
			}
			triangle {
				< -91.182202, -6.256306, -199.839771>,
				< -98.307736, -4.408529, -218.389049>,
				< -98.376021, -10.985663, -219.493225>
			}
			triangle {
				< -91.182202, -6.256306, -199.839771>,
				< -98.376021, -10.985663, -219.493225>,
				< -91.283619, -15.557774, -201.401338>
			}
			triangle {
				< -98.376021, -10.985663, -219.493225>,
				< -103.335135, -5.661339, -240.834907>,
				< -103.470847, -8.676522, -242.985412>
			}
			triangle {
				< -98.376021, -10.985663, -219.493225>,
				< -103.470847, -8.676522, -242.985412>,
				< -98.636061, -16.810564, -223.649070>
			}
			triangle {
				< -98.636061, -16.810564, -223.649070>,
				< -103.470847, -8.676522, -242.985412>,
				< -103.699826, -11.096864, -246.568292>
			}
			triangle {
				< -98.636061, -16.810564, -223.649070>,
				< -103.699826, -11.096864, -246.568292>,
				< -99.080086, -21.486277, -230.572104>
			}
			triangle {
				< -99.080086, -21.486277, -230.572104>,
				< -103.699826, -11.096864, -246.568292>,
				< -104.010344, -12.757394, -251.338780>
			}
			triangle {
				< -99.080086, -21.486277, -230.572104>,
				< -104.010344, -12.757394, -251.338780>,
				< -99.692173, -24.694173, -239.789039>
			}
			triangle {
				< -99.692173, -24.694173, -239.789039>,
				< -104.010344, -12.757394, -251.338780>,
				< -104.385264, -13.544947, -256.971478>
			}
			triangle {
				< -99.692173, -24.694173, -239.789039>,
				< -104.385264, -13.544947, -256.971478>,
				< -100.445636, -26.215615, -250.669956>
			}
			triangle {
				< -100.445636, -26.215615, -250.669956>,
				< -104.385264, -13.544947, -256.971478>,
				< -104.802109, -13.405880, -263.082147>
			}
			triangle {
				< -100.445636, -26.215615, -250.669956>,
				< -104.802109, -13.405880, -263.082147>,
				< -101.300642, -25.946941, -262.471765>
			}
			triangle {
				< -101.300642, -25.946941, -262.471765>,
				< -104.802109, -13.405880, -263.082147>,
				< -105.233826, -12.349653, -269.254088>
			}
			triangle {
				< -101.300642, -25.946941, -262.471765>,
				< -105.233826, -12.349653, -269.254088>,
				< -102.204017, -23.906475, -274.389714>
			}
			triangle {
				< -102.204017, -23.906475, -274.389714>,
				< -105.233826, -12.349653, -269.254088>,
				< -105.650254, -10.448254, -275.066793>
			}
			triangle {
				< -102.204017, -23.906475, -274.389714>,
				< -105.650254, -10.448254, -275.066793>,
				< -103.091352, -20.233240, -285.611808>
			}
			triangle {
				< -103.091352, -20.233240, -285.611808>,
				< -105.650254, -10.448254, -275.066793>,
				< -106.020376, -7.831226, -280.124545>
			}
			triangle {
				< -103.091352, -20.233240, -285.611808>,
				< -106.020376, -7.831226, -280.124545>,
				< -103.892304, -15.177570, -295.374393>
			}
			triangle {
				< -103.892304, -15.177570, -295.374393>,
				< -106.020376, -7.831226, -280.124545>,
				< -106.315084, -4.676975, -284.082949>
			}
			triangle {
				< -103.892304, -15.177570, -295.374393>,
				< -106.315084, -4.676975, -284.082949>,
				< -104.537942, -9.084015, -303.013980>
			}
			triangle {
				< -104.537942, -9.084015, -303.013980>,
				< -106.315084, -4.676975, -284.082949>,
				< -106.510326, -1.200407, -286.672890>
			}
			triangle {
				< -104.537942, -9.084015, -303.013980>,
				< -106.510326, -1.200407, -286.672890>,
				< -104.969226, -2.367835, -308.011651>
			}
			triangle {
				< -104.969226, -2.367835, -308.011651>,
				< -106.510326, -1.200407, -286.672890>,
				< -106.589638, 2.361523, -287.718087>
			}
			triangle {
				< -104.969226, -2.367835, -308.011651>,
				< -106.589638, 2.361523, -287.718087>,
				< -105.145298, 4.513294, -310.028523>
			}
			triangle {
				< -105.145298, 4.513294, -310.028523>,
				< -106.589638, 2.361523, -287.718087>,
				< -106.546305, 5.766104, -287.147671>
			}
			triangle {
				< -105.145298, 4.513294, -310.028523>,
				< -106.546305, 5.766104, -287.147671>,
				< -105.049036, 11.090406, -308.927625>
			}
			triangle {
				< -105.049036, 11.090406, -308.927625>,
				< -106.546305, 5.766104, -287.147671>,
				< -106.384009, 8.781287, -285.000116>
			}
			triangle {
				< -105.049036, 11.090406, -308.927625>,
				< -106.384009, 8.781287, -285.000116>,
				< -104.689844, 16.915297, -304.783762>
			}
			triangle {
				< -104.689844, 16.915297, -304.783762>,
				< -106.384009, 8.781287, -285.000116>,
				< -106.116481, 11.201607, -281.421751>
			}
			triangle {
				< -104.689844, 16.915297, -304.783762>,
				< -106.116481, 11.201607, -281.421751>,
				< -104.102060, 21.591011, -297.878027>
			}
			triangle {
				< -104.102060, 21.591011, -297.878027>,
				< -106.116481, 11.201607, -281.421751>,
				< -105.765760, 12.862117, -276.655883>
			}
			triangle {
				< -104.102060, 21.591011, -297.878027>,
				< -105.765760, 12.862117, -276.655883>,
				< -103.340112, 24.798896, -288.679302>
			}
			triangle {
				< -103.340112, 24.798896, -288.679302>,
				< -105.765760, 12.862117, -276.655883>,
				< -105.359823, 13.649682, -271.026731>
			}
			triangle {
				< -103.340112, 24.798896, -288.679302>,
				< -105.359823, 13.649682, -271.026731>,
				< -102.470845, 26.320359, -277.812332>
			}
			triangle {
				< -102.470845, 26.320359, -277.812332>,
				< -105.359823, 13.649682, -271.026731>,
				< -104.929373, 13.510624, -264.917701>
			}
			triangle {
				< -102.470845, 26.320359, -277.812332>,
				< -104.929373, 13.510624, -264.917701>,
				< -101.565130, 26.051685, -266.016483>
			}
			triangle {
				< -101.565130, 26.051685, -266.016483>,
				< -104.929373, 13.510624, -264.917701>,
				< -104.505166, 12.454386, -258.744895>
			}
			triangle {
				< -101.565130, 26.051685, -266.016483>,
				< -104.505166, 12.454386, -258.744895>,
				< -100.689739, 24.011198, -254.095227>
			}
			triangle {
				< -100.689739, 24.011198, -254.095227>,
				< -104.505166, 12.454386, -258.744895>,
				< -104.115292, 10.552987, -252.929091>
			}
			triangle {
				< -100.689739, 24.011198, -254.095227>,
				< -104.115292, 10.552987, -252.929091>,
				< -99.901542, 20.337984, -242.861196>
			}
			triangle {
				< -99.901542, 20.337984, -242.861196>,
				< -104.115292, 10.552987, -252.929091>,
				< -103.783719, 7.935991, -247.866914>
			}
			triangle {
				< -99.901542, 20.337984, -242.861196>,
				< -103.783719, 7.935991, -247.866914>,
				< -99.244349, 15.282324, -233.081311>
			}
			triangle {
				< -99.244349, 15.282324, -233.081311>,
				< -103.783719, 7.935991, -247.866914>,
				< -103.529185, 4.781719, -243.903831>
			}
			triangle {
				< -99.244349, 15.282324, -233.081311>,
				< -103.529185, 4.781719, -243.903831>,
				< -98.748587, 9.188780, -225.423723>
			}
			triangle {
				< -98.748587, 9.188780, -225.423723>,
				< -103.529185, 4.781719, -243.903831>,
				< -103.365026, 1.305172, -241.310388>
			}
			triangle {
				< -98.748587, 9.188780, -225.423723>,
				< -103.365026, 1.305172, -241.310388>,
				< -98.433077, 2.472578, -220.412031>
			}
			triangle {
				< -98.433077, 2.472578, -220.412031>,
				< -103.365026, 1.305172, -241.310388>,
				< -103.299282, -2.256759, -240.263537>
			}
			triangle {
				< -98.433077, 2.472578, -220.412031>,
				< -103.299282, -2.256759, -240.263537>,
				< -98.307736, -4.408529, -218.389049>
			}
			triangle {
				< -98.307736, -4.408529, -218.389049>,
				< -103.299282, -2.256759, -240.263537>,
				< -103.335135, -5.661339, -240.834907>
			}
			triangle {
				< -98.307736, -4.408529, -218.389049>,
				< -103.335135, -5.661339, -240.834907>,
				< -98.376021, -10.985663, -219.493225>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -103.299282, -2.256759, -240.263537>,
				< -103.365026, 1.305172, -241.310388>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -103.365026, 1.305172, -241.310388>,
				< -103.529185, 4.781719, -243.903831>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -103.529185, 4.781719, -243.903831>,
				< -103.783719, 7.935991, -247.866914>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -103.783719, 7.935991, -247.866914>,
				< -104.115292, 10.552987, -252.929091>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -104.115292, 10.552987, -252.929091>,
				< -104.505166, 12.454386, -258.744895>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -104.505166, 12.454386, -258.744895>,
				< -104.929373, 13.510624, -264.917701>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -104.929373, 13.510624, -264.917701>,
				< -105.359823, 13.649682, -271.026731>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -105.359823, 13.649682, -271.026731>,
				< -105.765760, 12.862117, -276.655883>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -105.765760, 12.862117, -276.655883>,
				< -106.116481, 11.201607, -281.421751>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -106.116481, 11.201607, -281.421751>,
				< -106.384009, 8.781287, -285.000116>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -106.384009, 8.781287, -285.000116>,
				< -106.546305, 5.766104, -287.147671>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -106.546305, 5.766104, -287.147671>,
				< -106.589638, 2.361523, -287.718087>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -106.589638, 2.361523, -287.718087>,
				< -106.510326, -1.200407, -286.672890>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -106.510326, -1.200407, -286.672890>,
				< -106.315084, -4.676975, -284.082949>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -106.315084, -4.676975, -284.082949>,
				< -106.020376, -7.831226, -280.124545>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -106.020376, -7.831226, -280.124545>,
				< -105.650254, -10.448254, -275.066793>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -105.650254, -10.448254, -275.066793>,
				< -105.233826, -12.349653, -269.254088>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -105.233826, -12.349653, -269.254088>,
				< -104.802109, -13.405880, -263.082147>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -104.802109, -13.405880, -263.082147>,
				< -104.385264, -13.544947, -256.971478>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -104.385264, -13.544947, -256.971478>,
				< -104.010344, -12.757394, -251.338780>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -104.010344, -12.757394, -251.338780>,
				< -103.699826, -11.096864, -246.568292>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -103.699826, -11.096864, -246.568292>,
				< -103.470847, -8.676522, -242.985412>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -103.470847, -8.676522, -242.985412>,
				< -103.335135, -5.661339, -240.834907>
			}
			triangle {
				< -106.036529, 0.052382, -263.920844>,
				< -103.335135, -5.661339, -240.834907>,
				< -103.299282, -2.256759, -240.263537>
			}
			
		}
		// _Knee02
		union {
			triangle {
				< -111.750446, -53.543855, -178.185955>,
				< -111.694284, -51.937364, -177.038953>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -111.841917, -54.833416, -180.096954>,
				< -111.750446, -53.543855, -178.185955>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -111.959472, -55.718131, -182.641909>,
				< -111.841917, -54.833416, -180.096954>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.092055, -56.137756, -185.647368>,
				< -111.959472, -55.718131, -182.641909>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.228304, -56.063637, -188.908607>,
				< -112.092055, -56.137756, -185.647368>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.357885, -55.500884, -192.203283>,
				< -112.228304, -56.063637, -188.908607>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.472512, -54.487828, -195.306823>,
				< -112.357885, -55.500884, -192.203283>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.566426, -53.093486, -198.007897>,
				< -112.472512, -54.487828, -195.306823>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.636149, -51.412892, -200.122207>,
				< -112.566426, -53.093486, -198.007897>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.679958, -49.560580, -201.505691>,
				< -112.636149, -51.412892, -200.122207>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.697236, -47.662806, -202.064112>,
				< -112.679958, -49.560580, -201.505691>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.687849, -45.848839, -201.759353>,
				< -112.697236, -47.662806, -202.064112>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.651832, -44.242349, -200.612113>,
				< -112.687849, -45.848839, -201.759353>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.589672, -42.952806, -198.700726>,
				< -112.651832, -44.242349, -200.612113>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.502582, -42.068072, -196.155444>,
				< -112.589672, -42.952806, -198.700726>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.393610, -41.648466, -193.149656>,
				< -112.502582, -42.068072, -196.155444>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.267703, -41.722544, -189.888388>,
				< -112.393610, -41.648466, -193.149656>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -112.132400, -42.285319, -186.593756>,
				< -112.267703, -41.722544, -189.888388>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -111.997597, -43.298375, -183.490396>,
				< -112.132400, -42.285319, -186.593756>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -111.874402, -44.692717, -180.789724>,
				< -111.997597, -43.298375, -183.490396>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -111.774161, -46.373311, -178.675815>,
				< -111.874402, -44.692717, -180.789724>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -111.706793, -48.225619, -177.292541>,
				< -111.774161, -46.373311, -178.675815>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -111.679167, -50.123416, -176.734239>,
				< -111.706793, -48.225619, -177.292541>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -111.694284, -51.937364, -177.038953>,
				< -111.679167, -50.123416, -176.734239>,
				< -113.141894, -48.893113, -189.359903>
			}
			triangle {
				< -108.421654, -57.877664, -167.866632>,
				< -108.278409, -54.774180, -165.652096>,
				< -111.694284, -51.937364, -177.038953>
			}
			triangle {
				< -111.750446, -53.543855, -178.185955>,
				< -108.421654, -57.877664, -167.866632>,
				< -111.694284, -51.937364, -177.038953>
			}
			triangle {
				< -108.652152, -60.368892, -171.556547>,
				< -108.421654, -57.877664, -167.866632>,
				< -111.750446, -53.543855, -178.185955>
			}
			triangle {
				< -111.841917, -54.833416, -180.096954>,
				< -108.652152, -60.368892, -171.556547>,
				< -111.750446, -53.543855, -178.185955>
			}
			triangle {
				< -108.943284, -62.078051, -176.470682>,
				< -108.652152, -60.368892, -171.556547>,
				< -111.841917, -54.833416, -180.096954>
			}
			triangle {
				< -111.959472, -55.718131, -182.641909>,
				< -108.943284, -62.078051, -176.470682>,
				< -111.841917, -54.833416, -180.096954>
			}
			triangle {
				< -109.263882, -62.888674, -182.274386>,
				< -108.943284, -62.078051, -176.470682>,
				< -111.959472, -55.718131, -182.641909>
			}
			triangle {
				< -112.092055, -56.137756, -185.647368>,
				< -109.263882, -62.888674, -182.274386>,
				< -111.959472, -55.718131, -182.641909>
			}
			triangle {
				< -109.583236, -62.745534, -188.572079>,
				< -109.263882, -62.888674, -182.274386>,
				< -112.092055, -56.137756, -185.647368>
			}
			triangle {
				< -112.228304, -56.063637, -188.908607>,
				< -109.583236, -62.745534, -188.572079>,
				< -112.092055, -56.137756, -185.647368>
			}
			triangle {
				< -109.875768, -61.658356, -194.934785>,
				< -109.583236, -62.745534, -188.572079>,
				< -112.228304, -56.063637, -188.908607>
			}
			triangle {
				< -112.357885, -55.500884, -192.203283>,
				< -109.875768, -61.658356, -194.934785>,
				< -112.228304, -56.063637, -188.908607>
			}
			triangle {
				< -110.123642, -59.701283, -200.928718>,
				< -109.875768, -61.658356, -194.934785>,
				< -112.357885, -55.500884, -192.203283>
			}
			triangle {
				< -112.472512, -54.487828, -195.306823>,
				< -110.123642, -59.701283, -200.928718>,
				< -112.357885, -55.500884, -192.203283>
			}
			triangle {
				< -110.317528, -57.007611, -206.145301>,
				< -110.123642, -59.701283, -200.928718>,
				< -112.472512, -54.487828, -195.306823>
			}
			triangle {
				< -112.566426, -53.093486, -198.007897>,
				< -110.317528, -57.007611, -206.145301>,
				< -112.472512, -54.487828, -195.306823>
			}
			triangle {
				< -110.455111, -53.760957, -210.228875>,
				< -110.317528, -57.007611, -206.145301>,
				< -112.566426, -53.093486, -198.007897>
			}
			triangle {
				< -112.636149, -51.412892, -200.122207>,
				< -110.455111, -53.760957, -210.228875>,
				< -112.566426, -53.093486, -198.007897>
			}
			triangle {
				< -110.538423, -50.182588, -212.900996>,
				< -110.455111, -53.760957, -210.228875>,
				< -112.636149, -51.412892, -200.122207>
			}
			triangle {
				< -112.679958, -49.560580, -201.505691>,
				< -110.538423, -50.182588, -212.900996>,
				< -112.636149, -51.412892, -200.122207>
			}
			triangle {
				< -110.570520, -46.516310, -213.979498>,
				< -110.538423, -50.182588, -212.900996>,
				< -112.679958, -49.560580, -201.505691>
			}
			triangle {
				< -112.697236, -47.662806, -202.064112>,
				< -110.570520, -46.516310, -213.979498>,
				< -112.679958, -49.560580, -201.505691>
			}
			triangle {
				< -110.553108, -43.012045, -213.390857>,
				< -110.570520, -46.516310, -213.979498>,
				< -112.697236, -47.662806, -202.064112>
			}
			triangle {
				< -112.687849, -45.848839, -201.759353>,
				< -110.553108, -43.012045, -213.390857>,
				< -112.697236, -47.662806, -202.064112>
			}
			triangle {
				< -110.485226, -39.908536, -211.175174>,
				< -110.553108, -43.012045, -213.390857>,
				< -112.687849, -45.848839, -201.759353>
			}
			triangle {
				< -112.651832, -44.242349, -200.612113>,
				< -110.485226, -39.908536, -211.175174>,
				< -112.687849, -45.848839, -201.759353>
			}
			triangle {
				< -110.364020, -37.417326, -207.483515>,
				< -110.485226, -39.908536, -211.175174>,
				< -112.651832, -44.242349, -200.612113>
			}
			triangle {
				< -112.589672, -42.952806, -198.700726>,
				< -110.364020, -37.417326, -207.483515>,
				< -112.651832, -44.242349, -200.612113>
			}
			triangle {
				< -110.186763, -35.708159, -202.567622>,
				< -110.364020, -37.417326, -207.483515>,
				< -112.589672, -42.952806, -198.700726>
			}
			triangle {
				< -112.502582, -42.068072, -196.155444>,
				< -110.186763, -35.708159, -202.567622>,
				< -112.589672, -42.952806, -198.700726>
			}
			triangle {
				< -109.954201, -34.897525, -196.762562>,
				< -110.186763, -35.708159, -202.567622>,
				< -112.502582, -42.068072, -196.155444>
			}
			triangle {
				< -112.393610, -41.648466, -193.149656>,
				< -109.954201, -34.897525, -196.762562>,
				< -112.502582, -42.068072, -196.155444>
			}
			triangle {
				< -109.673381, -35.040673, -190.464213>,
				< -109.954201, -34.897525, -196.762562>,
				< -112.393610, -41.648466, -193.149656>
			}
			triangle {
				< -112.267703, -41.722544, -189.888388>,
				< -109.673381, -35.040673, -190.464213>,
				< -112.393610, -41.648466, -193.149656>
			}
			triangle {
				< -109.359637, -36.127850, -184.101909>,
				< -109.673381, -35.040673, -190.464213>,
				< -112.267703, -41.722544, -189.888388>
			}
			triangle {
				< -112.132400, -42.285319, -186.593756>,
				< -109.359637, -36.127850, -184.101909>,
				< -112.267703, -41.722544, -189.888388>
			}
			triangle {
				< -109.036371, -38.084920, -178.109109>,
				< -109.359637, -36.127850, -184.101909>,
				< -112.132400, -42.285319, -186.593756>
			}
			triangle {
				< -111.997597, -43.298375, -183.490396>,
				< -109.036371, -38.084920, -178.109109>,
				< -112.132400, -42.285319, -186.593756>
			}
			triangle {
				< -108.733192, -40.778577, -172.894180>,
				< -109.036371, -38.084920, -178.109109>,
				< -111.997597, -43.298375, -183.490396>
			}
			triangle {
				< -111.874402, -44.692717, -180.789724>,
				< -108.733192, -40.778577, -172.894180>,
				< -111.997597, -43.298375, -183.490396>
			}
			triangle {
				< -108.481705, -44.025227, -168.812454>,
				< -108.733192, -40.778577, -172.894180>,
				< -111.874402, -44.692717, -180.789724>
			}
			triangle {
				< -111.774161, -46.373311, -178.675815>,
				< -108.481705, -44.025227, -168.812454>,
				< -111.874402, -44.692717, -180.789724>
			}
			triangle {
				< -108.310394, -47.603615, -166.141704>,
				< -108.481705, -44.025227, -168.812454>,
				< -111.774161, -46.373311, -178.675815>
			}
			triangle {
				< -111.706793, -48.225619, -177.292541>,
				< -108.310394, -47.603615, -166.141704>,
				< -111.774161, -46.373311, -178.675815>
			}
			triangle {
				< -108.239755, -51.269870, -165.063784>,
				< -108.310394, -47.603615, -166.141704>,
				< -111.706793, -48.225619, -177.292541>
			}
			triangle {
				< -111.679167, -50.123416, -176.734239>,
				< -108.239755, -51.269870, -165.063784>,
				< -111.706793, -48.225619, -177.292541>
			}
			triangle {
				< -108.278409, -54.774180, -165.652096>,
				< -108.239755, -51.269870, -165.063784>,
				< -111.679167, -50.123416, -176.734239>
			}
			triangle {
				< -111.694284, -51.937364, -177.038953>,
				< -108.278409, -54.774180, -165.652096>,
				< -111.679167, -50.123416, -176.734239>
			}
			triangle {
				< -103.293277, -61.599206, -159.131765>,
				< -103.031538, -57.210196, -156.002909>,
				< -108.278409, -54.774180, -165.652096>
			}
			triangle {
				< -108.421654, -57.877664, -167.866632>,
				< -103.293277, -61.599206, -159.131765>,
				< -108.278409, -54.774180, -165.652096>
			}
			triangle {
				< -103.713028, -65.122306, -164.345607>,
				< -103.293277, -61.599206, -159.131765>,
				< -108.421654, -57.877664, -167.866632>
			}
			triangle {
				< -108.652152, -60.368892, -171.556547>,
				< -103.713028, -65.122306, -164.345607>,
				< -108.421654, -57.877664, -167.866632>
			}
			triangle {
				< -104.240395, -67.539446, -171.289548>,
				< -103.713028, -65.122306, -164.345607>,
				< -108.652152, -60.368892, -171.556547>
			}
			triangle {
				< -108.943284, -62.078051, -176.470682>,
				< -104.240395, -67.539446, -171.289548>,
				< -108.652152, -60.368892, -171.556547>
			}
			triangle {
				< -104.816698, -68.685837, -179.491177>,
				< -104.240395, -67.539446, -171.289548>,
				< -108.943284, -62.078051, -176.470682>
			}
			triangle {
				< -109.263882, -62.888674, -182.274386>,
				< -104.816698, -68.685837, -179.491177>,
				< -108.943284, -62.078051, -176.470682>
			}
			triangle {
				< -105.385020, -68.483397, -188.391626>,
				< -104.816698, -68.685837, -179.491177>,
				< -109.263882, -62.888674, -182.274386>
			}
			triangle {
				< -109.583236, -62.745534, -188.572079>,
				< -105.385020, -68.483397, -188.391626>,
				< -109.263882, -62.888674, -182.274386>
			}
			triangle {
				< -105.898954, -66.945903, -197.384506>,
				< -105.385020, -68.483397, -188.391626>,
				< -109.583236, -62.745534, -188.572079>
			}
			triangle {
				< -109.875768, -61.658356, -194.934785>,
				< -105.898954, -66.945903, -197.384506>,
				< -109.583236, -62.745534, -188.572079>
			}
			triangle {
				< -106.327765, -64.178154, -205.856800>,
				< -105.898954, -66.945903, -197.384506>,
				< -109.875768, -61.658356, -194.934785>
			}
			triangle {
				< -110.123642, -59.701283, -200.928718>,
				< -106.327765, -64.178154, -205.856800>,
				< -109.875768, -61.658356, -194.934785>
			}
			triangle {
				< -106.657244, -60.368754, -213.230684>,
				< -106.327765, -64.178154, -205.856800>,
				< -110.123642, -59.701283, -200.928718>
			}
			triangle {
				< -110.317528, -57.007611, -206.145301>,
				< -106.657244, -60.368754, -213.230684>,
				< -110.123642, -59.701283, -200.928718>
			}
			triangle {
				< -106.886767, -55.777304, -219.003201>,
				< -106.657244, -60.368754, -213.230684>,
				< -110.317528, -57.007611, -206.145301>
			}
			triangle {
				< -110.455111, -53.760957, -210.228875>,
				< -106.886767, -55.777304, -219.003201>,
				< -110.317528, -57.007611, -206.145301>
			}
			triangle {
				< -107.023470, -50.716706, -222.780541>,
				< -106.886767, -55.777304, -219.003201>,
				< -110.455111, -53.760957, -210.228875>
			}
			triangle {
				< -110.538423, -50.182588, -212.900996>,
				< -107.023470, -50.716706, -222.780541>,
				< -110.455111, -53.760957, -210.228875>
			}
			triangle {
				< -107.075647, -45.531824, -224.305212>,
				< -107.023470, -50.716706, -222.780541>,
				< -110.538423, -50.182588, -212.900996>
			}
			triangle {
				< -110.570520, -46.516310, -213.979498>,
				< -107.075647, -45.531824, -224.305212>,
				< -110.538423, -50.182588, -212.900996>
			}
			triangle {
				< -107.047394, -40.576007, -223.473042>,
				< -107.075647, -45.531824, -224.305212>,
				< -110.570520, -46.516310, -213.979498>
			}
			triangle {
				< -110.553108, -43.012045, -213.390857>,
				< -107.047394, -40.576007, -223.473042>,
				< -110.570520, -46.516310, -213.979498>
			}
			triangle {
				< -106.936410, -36.187019, -220.340848>,
				< -107.047394, -40.576007, -223.473042>,
				< -110.553108, -43.012045, -213.390857>
			}
			triangle {
				< -110.485226, -39.908536, -211.175174>,
				< -106.936410, -36.187019, -220.340848>,
				< -110.553108, -43.012045, -213.390857>
			}
			triangle {
				< -106.735215, -32.663889, -215.122297>,
				< -106.936410, -36.187019, -220.340848>,
				< -110.485226, -39.908536, -211.175174>
			}
			triangle {
				< -110.364020, -37.417326, -207.483515>,
				< -106.735215, -32.663889, -215.122297>,
				< -110.485226, -39.908536, -211.175174>
			}
			triangle {
				< -106.435664, -30.246777, -208.173439>,
				< -106.735215, -32.663889, -215.122297>,
				< -110.364020, -37.417326, -207.483515>
			}
			triangle {
				< -110.186763, -35.708159, -202.567622>,
				< -106.435664, -30.246777, -208.173439>,
				< -110.364020, -37.417326, -207.483515>
			}
			triangle {
				< -106.035434, -29.100370, -199.968055>,
				< -106.435664, -30.246777, -208.173439>,
				< -110.186763, -35.708159, -202.567622>
			}
			triangle {
				< -109.954201, -34.897525, -196.762562>,
				< -106.035434, -29.100370, -199.968055>,
				< -110.186763, -35.708159, -202.567622>
			}
			triangle {
				< -105.544209, -29.302811, -191.065818>,
				< -106.035434, -29.100370, -199.968055>,
				< -109.954201, -34.897525, -196.762562>
			}
			triangle {
				< -109.673381, -35.040673, -190.464213>,
				< -105.544209, -29.302811, -191.065818>,
				< -109.954201, -34.897525, -196.762562>
			}
			triangle {
				< -104.987733, -30.840296, -182.073876>,
				< -105.544209, -29.302811, -191.065818>,
				< -109.673381, -35.040673, -190.464213>
			}
			triangle {
				< -109.359637, -36.127850, -184.101909>,
				< -104.987733, -30.840296, -182.073876>,
				< -109.673381, -35.040673, -190.464213>
			}
			triangle {
				< -104.408205, -33.608049, -173.604861>,
				< -104.987733, -30.840296, -182.073876>,
				< -109.359637, -36.127850, -184.101909>
			}
			triangle {
				< -109.036371, -38.084920, -178.109109>,
				< -104.408205, -33.608049, -173.604861>,
				< -109.359637, -36.127850, -184.101909>
			}
			triangle {
				< -103.860170, -37.417453, -166.235745>,
				< -104.408205, -33.608049, -173.604861>,
				< -109.036371, -38.084920, -178.109109>
			}
			triangle {
				< -108.733192, -40.778577, -172.894180>,
				< -103.860170, -37.417453, -166.235745>,
				< -109.036371, -38.084920, -178.109109>
			}
			triangle {
				< -103.402808, -42.008877, -160.468146>,
				< -103.860170, -37.417453, -166.235745>,
				< -108.733192, -40.778577, -172.894180>
			}
			triangle {
				< -108.481705, -44.025227, -168.812454>,
				< -103.402808, -42.008877, -160.468146>,
				< -108.733192, -40.778577, -172.894180>
			}
			triangle {
				< -103.090040, -47.069497, -156.694591>,
				< -103.402808, -42.008877, -160.468146>,
				< -108.481705, -44.025227, -168.812454>
			}
			triangle {
				< -108.310394, -47.603615, -166.141704>,
				< -103.090040, -47.069497, -156.694591>,
				< -108.481705, -44.025227, -168.812454>
			}
			triangle {
				< -102.960788, -52.254360, -155.171692>,
				< -103.090040, -47.069497, -156.694591>,
				< -108.310394, -47.603615, -166.141704>
			}
			triangle {
				< -108.239755, -51.269870, -165.063784>,
				< -102.960788, -52.254360, -155.171692>,
				< -108.310394, -47.603615, -166.141704>
			}
			triangle {
				< -103.031538, -57.210196, -156.002909>,
				< -102.960788, -52.254360, -155.171692>,
				< -108.239755, -51.269870, -165.063784>
			}
			triangle {
				< -108.278409, -54.774180, -165.652096>,
				< -103.031538, -57.210196, -156.002909>,
				< -108.239755, -51.269870, -165.063784>
			}
			triangle {
				< -96.711710, -64.454839, -152.607352>,
				< -96.311308, -59.079420, -148.780242>,
				< -103.031538, -57.210196, -156.002909>
			}
			triangle {
				< -103.293277, -61.599206, -159.131765>,
				< -96.711710, -64.454839, -152.607352>,
				< -103.031538, -57.210196, -156.002909>
			}
			triangle {
				< -97.354457, -68.769753, -158.985093>,
				< -96.711710, -64.454839, -152.607352>,
				< -103.293277, -61.599206, -159.131765>
			}
			triangle {
				< -103.713028, -65.122306, -164.345607>,
				< -97.354457, -68.769753, -158.985093>,
				< -103.293277, -61.599206, -159.131765>
			}
			triangle {
				< -98.162927, -71.730085, -167.479798>,
				< -97.354457, -68.769753, -158.985093>,
				< -103.713028, -65.122306, -164.345607>
			}
			triangle {
				< -104.240395, -67.539446, -171.289548>,
				< -98.162927, -71.730085, -167.479798>,
				< -103.713028, -65.122306, -164.345607>
			}
			triangle {
				< -99.047929, -73.134147, -177.513912>,
				< -98.162927, -71.730085, -167.479798>,
				< -104.240395, -67.539446, -171.289548>
			}
			triangle {
				< -104.816698, -68.685837, -179.491177>,
				< -99.047929, -73.134147, -177.513912>,
				< -104.240395, -67.539446, -171.289548>
			}
			triangle {
				< -99.922761, -72.886206, -188.404173>,
				< -99.047929, -73.134147, -177.513912>,
				< -104.816698, -68.685837, -179.491177>
			}
			triangle {
				< -105.385020, -68.483397, -188.391626>,
				< -99.922761, -72.886206, -188.404173>,
				< -104.816698, -68.685837, -179.491177>
			}
			triangle {
				< -100.716248, -71.003199, -199.408635>,
				< -99.922761, -72.886206, -188.404173>,
				< -105.385020, -68.483397, -188.391626>
			}
			triangle {
				< -105.898954, -66.945903, -197.384506>,
				< -100.716248, -71.003199, -199.408635>,
				< -105.385020, -68.483397, -188.391626>
			}
			triangle {
				< -101.380676, -67.613393, -209.776908>,
				< -100.716248, -71.003199, -199.408635>,
				< -105.898954, -66.945903, -197.384506>
			}
			triangle {
				< -106.327765, -64.178154, -205.856800>,
				< -101.380676, -67.613393, -209.776908>,
				< -105.898954, -66.945903, -197.384506>
			}
			triangle {
				< -101.893410, -62.947847, -218.801633>,
				< -101.380676, -67.613393, -209.776908>,
				< -106.327765, -64.178154, -205.856800>
			}
			triangle {
				< -106.657244, -60.368754, -213.230684>,
				< -101.893410, -62.947847, -218.801633>,
				< -106.327765, -64.178154, -205.856800>
			}
			triangle {
				< -102.252170, -57.324503, -225.866869>,
				< -101.893410, -62.947847, -218.801633>,
				< -106.657244, -60.368754, -213.230684>
			}
			triangle {
				< -106.886767, -55.777304, -219.003201>,
				< -102.252170, -57.324503, -225.866869>,
				< -106.657244, -60.368754, -213.230684>
			}
			triangle {
				< -102.466702, -51.126540, -230.490312>,
				< -102.252170, -57.324503, -225.866869>,
				< -106.886767, -55.777304, -219.003201>
			}
			triangle {
				< -107.023470, -50.716706, -222.780541>,
				< -102.466702, -51.126540, -230.490312>,
				< -106.886767, -55.777304, -219.003201>
			}
			triangle {
				< -102.548786, -44.776402, -232.356429>,
				< -102.466702, -51.126540, -230.490312>,
				< -107.023470, -50.716706, -222.780541>
			}
			triangle {
				< -107.075647, -45.531824, -224.305212>,
				< -102.548786, -44.776402, -232.356429>,
				< -107.023470, -50.716706, -222.780541>
			}
			triangle {
				< -102.504306, -38.706802, -231.337905>,
				< -102.548786, -44.776402, -232.356429>,
				< -107.075647, -45.531824, -224.305212>
			}
			triangle {
				< -107.047394, -40.576007, -223.473042>,
				< -102.504306, -38.706802, -231.337905>,
				< -107.075647, -45.531824, -224.305212>
			}
			triangle {
				< -102.329992, -33.331383, -227.504075>,
				< -102.504306, -38.706802, -231.337905>,
				< -107.047394, -40.576007, -223.473042>
			}
			triangle {
				< -106.936410, -36.187019, -220.340848>,
				< -102.329992, -33.331383, -227.504075>,
				< -107.047394, -40.576007, -223.473042>
			}
			triangle {
				< -102.015115, -29.016476, -221.116781>,
				< -102.329992, -33.331383, -227.504075>,
				< -106.936410, -36.187019, -220.340848>
			}
			triangle {
				< -106.735215, -32.663889, -215.122297>,
				< -102.015115, -29.016476, -221.116781>,
				< -106.936410, -36.187019, -220.340848>
			}
			triangle {
				< -101.548359, -26.056120, -212.612092>,
				< -102.015115, -29.016476, -221.116781>,
				< -106.735215, -32.663889, -215.122297>
			}
			triangle {
				< -106.435664, -30.246777, -208.173439>,
				< -101.548359, -26.056120, -212.612092>,
				< -106.735215, -32.663889, -215.122297>
			}
			triangle {
				< -100.927398, -24.652073, -202.570155>,
				< -101.548359, -26.056120, -212.612092>,
				< -106.435664, -30.246777, -208.173439>
			}
			triangle {
				< -106.035434, -29.100370, -199.968055>,
				< -100.927398, -24.652073, -202.570155>,
				< -106.435664, -30.246777, -208.173439>
			}
			triangle {
				< -100.168213, -24.899993, -191.676497>,
				< -100.927398, -24.652073, -202.570155>,
				< -106.035434, -29.100370, -199.968055>
			}
			triangle {
				< -105.544209, -29.302811, -191.065818>,
				< -100.168213, -24.899993, -191.676497>,
				< -106.035434, -29.100370, -199.968055>
			}
			triangle {
				< -99.310957, -26.783032, -180.673972>,
				< -100.168213, -24.899993, -191.676497>,
				< -105.544209, -29.302811, -191.065818>
			}
			triangle {
				< -104.987733, -30.840296, -182.073876>,
				< -99.310957, -26.783032, -180.673972>,
				< -105.544209, -29.302811, -191.065818>
			}
			triangle {
				< -98.420441, -30.172806, -170.312241>,
				< -99.310957, -26.783032, -180.673972>,
				< -104.987733, -30.840296, -182.073876>
			}
			triangle {
				< -104.408205, -33.608049, -173.604861>,
				< -98.420441, -30.172806, -170.312241>,
				< -104.987733, -30.840296, -182.073876>
			}
			triangle {
				< -97.579874, -34.838352, -161.297262>,
				< -98.420441, -30.172806, -170.312241>,
				< -104.408205, -33.608049, -173.604861>
			}
			triangle {
				< -103.860170, -37.417453, -166.235745>,
				< -97.579874, -34.838352, -161.297262>,
				< -104.408205, -33.608049, -173.604861>
			}
			triangle {
				< -96.879385, -40.461700, -154.242009>,
				< -97.579874, -34.838352, -161.297262>,
				< -103.860170, -37.417453, -166.235745>
			}
			triangle {
				< -103.402808, -42.008877, -160.468146>,
				< -96.879385, -40.461700, -154.242009>,
				< -103.860170, -37.417453, -166.235745>
			}
			triangle {
				< -96.400775, -46.659641, -149.626374>,
				< -96.879385, -40.461700, -154.242009>,
				< -103.402808, -42.008877, -160.468146>
			}
			triangle {
				< -103.090040, -47.069497, -156.694591>,
				< -96.400775, -46.659641, -149.626374>,
				< -103.402808, -42.008877, -160.468146>
			}
			triangle {
				< -96.203066, -53.009801, -147.763655>,
				< -96.400775, -46.659641, -149.626374>,
				< -103.090040, -47.069497, -156.694591>
			}
			triangle {
				< -102.960788, -52.254360, -155.171692>,
				< -96.203066, -53.009801, -147.763655>,
				< -103.090040, -47.069497, -156.694591>
			}
			triangle {
				< -96.311308, -59.079420, -148.780242>,
				< -96.203066, -53.009801, -147.763655>,
				< -102.960788, -52.254360, -155.171692>
			}
			triangle {
				< -103.031538, -57.210196, -156.002909>,
				< -96.311308, -59.079420, -148.780242>,
				< -102.960788, -52.254360, -155.171692>
			}
			triangle {
				< -89.209571, -66.249974, -148.763597>,
				< -88.671707, -60.254447, -144.501969>,
				< -96.311308, -59.079420, -148.780242>
			}
			triangle {
				< -96.711710, -64.454839, -152.607352>,
				< -89.209571, -66.249974, -148.763597>,
				< -96.311308, -59.079420, -148.780242>
			}
			triangle {
				< -90.075403, -71.062617, -155.865729>,
				< -89.209571, -66.249974, -148.763597>,
				< -96.711710, -64.454839, -152.607352>
			}
			triangle {
				< -97.354457, -68.769753, -158.985093>,
				< -90.075403, -71.062617, -155.865729>,
				< -96.711710, -64.454839, -152.607352>
			}
			triangle {
				< -91.169439, -74.364454, -165.326223>,
				< -90.075403, -71.062617, -155.865729>,
				< -97.354457, -68.769753, -158.985093>
			}
			triangle {
				< -98.162927, -71.730085, -167.479798>,
				< -91.169439, -74.364454, -165.326223>,
				< -97.354457, -68.769753, -158.985093>
			}
			triangle {
				< -92.374630, -75.930476, -176.502243>,
				< -91.169439, -74.364454, -165.326223>,
				< -98.162927, -71.730085, -167.479798>
			}
			triangle {
				< -99.047929, -73.134147, -177.513912>,
				< -92.374630, -75.930476, -176.502243>,
				< -98.162927, -71.730085, -167.479798>
			}
			triangle {
				< -93.576089, -75.653940, -188.633353>,
				< -92.374630, -75.930476, -176.502243>,
				< -99.047929, -73.134147, -177.513912>
			}
			triangle {
				< -99.922761, -72.886206, -188.404173>,
				< -93.576089, -75.653940, -188.633353>,
				< -99.047929, -73.134147, -177.513912>
			}
			triangle {
				< -94.677530, -73.553704, -200.892970>,
				< -93.576089, -75.653940, -188.633353>,
				< -99.922761, -72.886206, -188.404173>
			}
			triangle {
				< -100.716248, -71.003199, -199.408635>,
				< -94.677530, -73.553704, -200.892970>,
				< -99.922761, -72.886206, -188.404173>
			}
			triangle {
				< -95.611788, -69.772892, -212.445050>,
				< -94.677530, -73.553704, -200.892970>,
				< -100.716248, -71.003199, -199.408635>
			}
			triangle {
				< -101.380676, -67.613393, -209.776908>,
				< -95.611788, -69.772892, -212.445050>,
				< -100.716248, -71.003199, -199.408635>
			}
			triangle {
				< -96.343316, -64.569131, -222.500995>,
				< -95.611788, -69.772892, -212.445050>,
				< -101.380676, -67.613393, -209.776908>
			}
			triangle {
				< -101.893410, -62.947847, -218.801633>,
				< -96.343316, -64.569131, -222.500995>,
				< -101.380676, -67.613393, -209.776908>
			}
			triangle {
				< -96.863031, -58.297083, -230.374083>,
				< -96.343316, -64.569131, -222.500995>,
				< -101.893410, -62.947847, -218.801633>
			}
			triangle {
				< -102.252170, -57.324503, -225.866869>,
				< -96.863031, -58.297083, -230.374083>,
				< -101.893410, -62.947847, -218.801633>
			}
			triangle {
				< -97.177938, -51.384199, -235.526562>,
				< -96.863031, -58.297083, -230.374083>,
				< -102.252170, -57.324503, -225.866869>
			}
			triangle {
				< -102.466702, -51.126540, -230.490312>,
				< -97.177938, -51.384199, -235.526562>,
				< -102.252170, -57.324503, -225.866869>
			}
			triangle {
				< -97.299412, -44.301517, -237.606227>,
				< -97.177938, -51.384199, -235.526562>,
				< -102.466702, -51.126540, -230.490312>
			}
			triangle {
				< -102.548786, -44.776402, -232.356429>,
				< -97.299412, -44.301517, -237.606227>,
				< -102.466702, -51.126540, -230.490312>
			}
			triangle {
				< -97.233504, -37.531760, -236.471027>,
				< -97.299412, -44.301517, -237.606227>,
				< -102.548786, -44.776402, -232.356429>
			}
			triangle {
				< -102.504306, -38.706802, -231.337905>,
				< -97.233504, -37.531760, -236.471027>,
				< -102.548786, -44.776402, -232.356429>
			}
			triangle {
				< -96.976824, -31.536255, -232.198596>,
				< -97.233504, -37.531760, -236.471027>,
				< -102.504306, -38.706802, -231.337905>
			}
			triangle {
				< -102.329992, -33.331383, -227.504075>,
				< -96.976824, -31.536255, -232.198596>,
				< -102.504306, -38.706802, -231.337905>
			}
			triangle {
				< -96.518755, -26.723618, -225.080863>,
				< -96.976824, -31.536255, -232.198596>,
				< -102.329992, -33.331383, -227.504075>
			}
			triangle {
				< -102.015115, -29.016476, -221.116781>,
				< -96.518755, -26.723618, -225.080863>,
				< -102.329992, -33.331383, -227.504075>
			}
			triangle {
				< -95.849790, -23.421761, -215.604052>,
				< -96.518755, -26.723618, -225.080863>,
				< -102.015115, -29.016476, -221.116781>
			}
			triangle {
				< -101.548359, -26.056120, -212.612092>,
				< -95.849790, -23.421761, -215.604052>,
				< -102.015115, -29.016476, -221.116781>
			}
			triangle {
				< -94.973020, -21.855736, -204.415351>,
				< -95.849790, -23.421761, -215.604052>,
				< -101.548359, -26.056120, -212.612092>
			}
			triangle {
				< -100.927398, -24.652073, -202.570155>,
				< -94.973020, -21.855736, -204.415351>,
				< -101.548359, -26.056120, -212.612092>
			}
			triangle {
				< -93.915433, -22.132266, -192.278773>,
				< -94.973020, -21.855736, -204.415351>,
				< -100.927398, -24.652073, -202.570155>
			}
			triangle {
				< -100.168213, -24.899993, -191.676497>,
				< -93.915433, -22.132266, -192.278773>,
				< -100.927398, -24.652073, -202.570155>
			}
			triangle {
				< -92.734694, -24.232525, -180.022091>,
				< -93.915433, -22.132266, -192.278773>,
				< -100.168213, -24.899993, -191.676497>
			}
			triangle {
				< -99.310957, -26.783032, -180.673972>,
				< -92.734694, -24.232525, -180.022091>,
				< -100.168213, -24.899993, -191.676497>
			}
			triangle {
				< -91.519199, -28.013341, -168.480828>,
				< -92.734694, -24.232525, -180.022091>,
				< -99.310957, -26.783032, -180.673972>
			}
			triangle {
				< -98.420441, -30.172806, -170.312241>,
				< -91.519199, -28.013341, -168.480828>,
				< -99.310957, -26.783032, -180.673972>
			}
			triangle {
				< -90.379886, -33.217054, -158.440664>,
				< -91.519199, -28.013341, -168.480828>,
				< -98.420441, -30.172806, -170.312241>
			}
			triangle {
				< -97.579874, -34.838352, -161.297262>,
				< -90.379886, -33.217054, -158.440664>,
				< -98.420441, -30.172806, -170.312241>
			}
			triangle {
				< -89.435108, -39.489098, -150.583833>,
				< -90.379886, -33.217054, -158.440664>,
				< -97.579874, -34.838352, -161.297262>
			}
			triangle {
				< -96.879385, -40.461700, -154.242009>,
				< -89.435108, -39.489098, -150.583833>,
				< -97.579874, -34.838352, -161.297262>
			}
			triangle {
				< -88.791765, -46.402004, -145.443946>,
				< -89.435108, -39.489098, -150.583833>,
				< -96.879385, -40.461700, -154.242009>
			}
			triangle {
				< -96.400775, -46.659641, -149.626374>,
				< -88.791765, -46.402004, -145.443946>,
				< -96.879385, -40.461700, -154.242009>
			}
			triangle {
				< -88.526480, -53.484667, -143.369764>,
				< -88.791765, -46.402004, -145.443946>,
				< -96.400775, -46.659641, -149.626374>
			}
			triangle {
				< -96.203066, -53.009801, -147.763655>,
				< -88.526480, -53.484667, -143.369764>,
				< -96.400775, -46.659641, -149.626374>
			}
			triangle {
				< -88.671707, -60.254447, -144.501969>,
				< -88.526480, -53.484667, -143.369764>,
				< -96.203066, -53.009801, -147.763655>
			}
			triangle {
				< -96.311308, -59.079420, -148.780242>,
				< -88.671707, -60.254447, -144.501969>,
				< -96.203066, -53.009801, -147.763655>
			}
			triangle {
				< -81.446789, -66.862240, -147.873089>,
				< -80.799654, -60.655251, -143.469378>,
				< -88.671707, -60.254447, -144.501969>
			}
			triangle {
				< -89.209571, -66.249974, -148.763597>,
				< -81.446789, -66.862240, -147.873089>,
				< -88.671707, -60.254447, -144.501969>
			}
			triangle {
				< -82.492493, -71.844675, -155.212492>,
				< -81.446789, -66.862240, -147.873089>,
				< -89.209571, -66.249974, -148.763597>
			}
			triangle {
				< -90.075403, -71.062617, -155.865729>,
				< -82.492493, -71.844675, -155.212492>,
				< -89.209571, -66.249974, -148.763597>
			}
			triangle {
				< -83.821870, -75.262986, -164.989784>,
				< -82.492493, -71.844675, -155.212492>,
				< -90.075403, -71.062617, -155.865729>
			}
			triangle {
				< -91.169439, -74.364454, -165.326223>,
				< -83.821870, -75.262986, -164.989784>,
				< -90.075403, -71.062617, -155.865729>
			}
			triangle {
				< -85.298814, -76.884247, -176.541209>,
				< -83.821870, -75.262986, -164.989784>,
				< -91.169439, -74.364454, -165.326223>
			}
			triangle {
				< -92.374630, -75.930476, -176.502243>,
				< -85.298814, -76.884247, -176.541209>,
				< -91.169439, -74.364454, -165.326223>
			}
			triangle {
				< -86.787507, -76.597974, -189.080939>,
				< -85.298814, -76.884247, -176.541209>,
				< -92.374630, -75.930476, -176.502243>
			}
			triangle {
				< -93.576089, -75.653940, -188.633353>,
				< -86.787507, -76.597974, -189.080939>,
				< -92.374630, -75.930476, -176.502243>
			}
			triangle {
				< -88.171124, -74.423634, -201.754883>,
				< -86.787507, -76.597974, -189.080939>,
				< -93.576089, -75.653940, -188.633353>
			}
			triangle {
				< -94.677530, -73.553704, -200.892970>,
				< -88.171124, -74.423634, -201.754883>,
				< -93.576089, -75.653940, -188.633353>
			}
			triangle {
				< -89.363843, -70.509426, -213.698551>,
				< -88.171124, -74.423634, -201.754883>,
				< -94.677530, -73.553704, -200.892970>
			}
			triangle {
				< -95.611788, -69.772892, -212.445050>,
				< -89.363843, -70.509426, -213.698551>,
				< -94.677530, -73.553704, -200.892970>
			}
			triangle {
				< -90.314433, -65.122128, -224.096224>,
				< -89.363843, -70.509426, -213.698551>,
				< -95.611788, -69.772892, -212.445050>
			}
			triangle {
				< -96.343316, -64.569131, -222.500995>,
				< -90.314433, -65.122128, -224.096224>,
				< -95.611788, -69.772892, -212.445050>
			}
			triangle {
				< -91.001838, -58.628824, -232.237607>,
				< -90.314433, -65.122128, -224.096224>,
				< -96.343316, -64.569131, -222.500995>
			}
			triangle {
				< -96.863031, -58.297083, -230.374083>,
				< -91.001838, -58.628824, -232.237607>,
				< -96.343316, -64.569131, -222.500995>
			}
			triangle {
				< -91.424674, -51.472064, -237.565815>,
				< -91.001838, -58.628824, -232.237607>,
				< -96.863031, -58.297083, -230.374083>
			}
			triangle {
				< -97.177938, -51.384199, -235.526562>,
				< -91.424674, -51.472064, -237.565815>,
				< -96.863031, -58.297083, -230.374083>
			}
			triangle {
				< -91.589309, -44.139553, -239.716440>,
				< -91.424674, -51.472064, -237.565815>,
				< -97.177938, -51.384199, -235.526562>
			}
			triangle {
				< -97.299412, -44.301517, -237.606227>,
				< -91.589309, -44.139553, -239.716440>,
				< -97.177938, -51.384199, -235.526562>
			}
			triangle {
				< -91.499858, -37.130971, -238.542631>,
				< -91.589309, -44.139553, -239.716440>,
				< -97.299412, -44.301517, -237.606227>
			}
			triangle {
				< -97.233504, -37.531760, -236.471027>,
				< -91.499858, -37.130971, -238.542631>,
				< -97.299412, -44.301517, -237.606227>
			}
			triangle {
				< -91.154024, -30.923963, -234.124333>,
				< -91.499858, -37.130971, -238.542631>,
				< -97.233504, -37.531760, -236.471027>
			}
			triangle {
				< -96.976824, -31.536255, -232.198596>,
				< -91.154024, -30.923963, -234.124333>,
				< -97.233504, -37.531760, -236.471027>
			}
			triangle {
				< -90.545207, -25.941540, -226.764038>,
				< -91.154024, -30.923963, -234.124333>,
				< -96.976824, -31.536255, -232.198596>
			}
			triangle {
				< -96.518755, -26.723618, -225.080863>,
				< -90.545207, -25.941540, -226.764038>,
				< -96.976824, -31.536255, -232.198596>
			}
			triangle {
				< -89.671239, -22.523215, -216.964796>,
				< -90.545207, -25.941540, -226.764038>,
				< -96.518755, -26.723618, -225.080863>
			}
			triangle {
				< -95.849790, -23.421761, -215.604052>,
				< -89.671239, -22.523215, -216.964796>,
				< -96.518755, -26.723618, -225.080863>
			}
			triangle {
				< -88.546202, -20.901935, -205.396563>,
				< -89.671239, -22.523215, -216.964796>,
				< -95.849790, -23.421761, -215.604052>
			}
			triangle {
				< -94.973020, -21.855736, -204.415351>,
				< -88.546202, -20.901935, -205.396563>,
				< -95.849790, -23.421761, -215.604052>
			}
			triangle {
				< -87.211609, -21.188250, -192.849413>,
				< -88.546202, -20.901935, -205.396563>,
				< -94.973020, -21.855736, -204.415351>
			}
			triangle {
				< -93.915433, -22.132266, -192.278773>,
				< -87.211609, -21.188250, -192.849413>,
				< -94.973020, -21.855736, -204.415351>
			}
			triangle {
				< -85.743032, -23.362590, -180.179536>,
				< -87.211609, -21.188250, -192.849413>,
				< -93.915433, -22.132266, -192.278773>
			}
			triangle {
				< -92.734694, -24.232525, -180.022091>,
				< -85.743032, -23.362590, -180.179536>,
				< -93.915433, -22.132266, -192.278773>
			}
			triangle {
				< -84.249012, -27.276771, -168.250352>,
				< -85.743032, -23.362590, -180.179536>,
				< -92.734694, -24.232525, -180.022091>
			}
			triangle {
				< -91.519199, -28.013341, -168.480828>,
				< -84.249012, -27.276771, -168.250352>,
				< -92.734694, -24.232525, -180.022091>
			}
			triangle {
				< -82.861520, -32.664075, -157.873541>,
				< -84.249012, -27.276771, -168.250352>,
				< -91.519199, -28.013341, -168.480828>
			}
			triangle {
				< -90.379886, -33.217054, -158.440664>,
				< -82.861520, -32.664075, -157.873541>,
				< -91.519199, -28.013341, -168.480828>
			}
			triangle {
				< -81.718713, -39.157368, -149.754077>,
				< -82.861520, -32.664075, -157.873541>,
				< -90.379886, -33.217054, -158.440664>
			}
			triangle {
				< -89.435108, -39.489098, -150.583833>,
				< -81.718713, -39.157368, -149.754077>,
				< -90.379886, -33.217054, -158.440664>
			}
			triangle {
				< -80.943979, -46.314139, -144.442841>,
				< -81.718713, -39.157368, -149.754077>,
				< -89.435108, -39.489098, -150.583833>
			}
			triangle {
				< -88.791765, -46.402004, -145.443946>,
				< -80.943979, -46.314139, -144.442841>,
				< -89.435108, -39.489098, -150.583833>
			}
			triangle {
				< -80.625251, -53.646650, -142.299443>,
				< -80.943979, -46.314139, -144.442841>,
				< -88.791765, -46.402004, -145.443946>
			}
			triangle {
				< -88.526480, -53.484667, -143.369764>,
				< -80.625251, -53.646650, -142.299443>,
				< -88.791765, -46.402004, -145.443946>
			}
			triangle {
				< -80.799654, -60.655251, -143.469378>,
				< -80.625251, -53.646650, -142.299443>,
				< -88.526480, -53.484667, -143.369764>
			}
			triangle {
				< -88.671707, -60.254447, -144.501969>,
				< -80.799654, -60.655251, -143.469378>,
				< -88.526480, -53.484667, -143.369764>
			}
			triangle {
				< -74.125417, -66.249967, -149.989471>,
				< -73.423162, -60.254466, -145.743817>,
				< -80.799654, -60.655251, -143.469378>
			}
			triangle {
				< -81.446789, -66.862240, -147.873089>,
				< -74.125417, -66.249967, -149.989471>,
				< -80.799654, -60.655251, -143.469378>
			}
			triangle {
				< -75.265206, -71.062617, -157.065600>,
				< -74.125417, -66.249967, -149.989471>,
				< -81.446789, -66.862240, -147.873089>
			}
			triangle {
				< -82.492493, -71.844675, -155.212492>,
				< -75.265206, -71.062617, -157.065600>,
				< -81.446789, -66.862240, -147.873089>
			}
			triangle {
				< -76.724060, -74.364461, -166.492432>,
				< -75.265206, -71.062617, -157.065600>,
				< -82.492493, -71.844675, -155.212492>
			}
			triangle {
				< -83.821870, -75.262986, -164.989784>,
				< -76.724060, -74.364461, -166.492432>,
				< -82.492493, -71.844675, -155.212492>
			}
			triangle {
				< -78.360230, -75.930476, -177.630439>,
				< -76.724060, -74.364461, -166.492432>,
				< -83.821870, -75.262986, -164.989784>
			}
			triangle {
				< -85.298814, -76.884247, -176.541209>,
				< -78.360230, -75.930476, -177.630439>,
				< -83.821870, -75.262986, -164.989784>
			}
			triangle {
				< -80.029398, -75.653940, -189.722210>,
				< -78.360230, -75.930476, -177.630439>,
				< -85.298814, -76.884247, -176.541209>
			}
			triangle {
				< -86.787507, -76.597974, -189.080939>,
				< -80.029398, -75.653940, -189.722210>,
				< -85.298814, -76.884247, -176.541209>
			}
			triangle {
				< -81.603467, -73.553696, -201.944396>,
				< -80.029398, -75.653940, -189.722210>,
				< -86.787507, -76.597974, -189.080939>
			}
			triangle {
				< -88.171124, -74.423634, -201.754883>,
				< -81.603467, -73.553696, -201.944396>,
				< -86.787507, -76.597974, -189.080939>
			}
			triangle {
				< -82.983017, -69.772892, -213.463143>,
				< -81.603467, -73.553696, -201.944396>,
				< -88.171124, -74.423634, -201.754883>
			}
			triangle {
				< -89.363843, -70.509426, -213.698551>,
				< -82.983017, -69.772892, -213.463143>,
				< -88.171124, -74.423634, -201.754883>
			}
			triangle {
				< -84.102131, -64.569131, -223.491669>,
				< -82.983017, -69.772892, -213.463143>,
				< -89.363843, -70.509426, -213.698551>
			}
			triangle {
				< -90.314433, -65.122128, -224.096224>,
				< -84.102131, -64.569131, -223.491669>,
				< -89.363843, -70.509426, -213.698551>
			}
			triangle {
				< -84.925234, -58.297083, -231.344357>,
				< -84.102131, -64.569131, -223.491669>,
				< -90.314433, -65.122128, -224.096224>
			}
			triangle {
				< -91.001838, -58.628824, -232.237607>,
				< -84.925234, -58.297083, -231.344357>,
				< -90.314433, -65.122128, -224.096224>
			}
			triangle {
				< -85.438713, -51.384199, -236.483917>,
				< -84.925234, -58.297083, -231.344357>,
				< -91.001838, -58.628824, -232.237607>
			}
			triangle {
				< -91.424674, -51.472064, -237.565815>,
				< -85.438713, -51.384199, -236.483917>,
				< -91.001838, -58.628824, -232.237607>
			}
			triangle {
				< -85.640289, -44.301517, -238.558516>,
				< -85.438713, -51.384199, -236.483917>,
				< -91.424674, -51.472064, -237.565815>
			}
			triangle {
				< -91.589309, -44.139553, -239.716440>,
				< -85.640289, -44.301517, -238.558516>,
				< -91.424674, -51.472064, -237.565815>
			}
			triangle {
				< -85.530661, -37.531760, -237.426102>,
				< -85.640289, -44.301517, -238.558516>,
				< -91.589309, -44.139553, -239.716440>
			}
			triangle {
				< -91.499858, -37.130971, -238.542631>,
				< -85.530661, -37.531760, -237.426102>,
				< -91.589309, -44.139553, -239.716440>
			}
			triangle {
				< -85.109353, -31.536255, -233.164266>,
				< -85.530661, -37.531760, -237.426102>,
				< -91.499858, -37.130971, -238.542631>
			}
			triangle {
				< -91.154024, -30.923963, -234.124333>,
				< -85.109353, -31.536255, -233.164266>,
				< -91.499858, -37.130971, -238.542631>
			}
			triangle {
				< -84.376991, -26.723610, -226.064786>,
				< -85.109353, -31.536255, -233.164266>,
				< -91.154024, -30.923963, -234.124333>
			}
			triangle {
				< -90.545207, -25.941540, -226.764038>,
				< -84.376991, -26.723610, -226.064786>,
				< -91.154024, -30.923963, -234.124333>
			}
			triangle {
				< -83.342776, -23.421761, -216.613352>,
				< -84.376991, -26.723610, -226.064786>,
				< -90.545207, -25.941540, -226.764038>
			}
			triangle {
				< -89.671239, -22.523215, -216.964796>,
				< -83.342776, -23.421761, -216.613352>,
				< -90.545207, -25.941540, -226.764038>
			}
			triangle {
				< -82.034752, -21.855723, -205.456391>,
				< -83.342776, -23.421761, -216.613352>,
				< -89.671239, -22.523215, -216.964796>
			}
			triangle {
				< -88.546202, -20.901935, -205.396563>,
				< -82.034752, -21.855723, -205.456391>,
				< -89.671239, -22.523215, -216.964796>
			}
			triangle {
				< -80.509298, -22.132285, -193.356290>,
				< -82.034752, -21.855723, -205.456391>,
				< -88.546202, -20.901935, -205.396563>
			}
			triangle {
				< -87.211609, -21.188250, -192.849413>,
				< -80.509298, -22.132285, -193.356290>,
				< -88.546202, -20.901935, -205.396563>
			}
			triangle {
				< -78.855999, -24.232520, -181.138739>,
				< -80.509298, -22.132285, -193.356290>,
				< -87.211609, -21.188250, -192.849413>
			}
			triangle {
				< -85.743032, -23.362590, -180.179536>,
				< -78.855999, -24.232520, -181.138739>,
				< -87.211609, -21.188250, -192.849413>
			}
			triangle {
				< -77.195466, -28.013332, -169.636130>,
				< -78.855999, -24.232520, -181.138739>,
				< -85.743032, -23.362590, -180.179536>
			}
			triangle {
				< -84.249012, -27.276771, -168.250352>,
				< -77.195466, -28.013332, -169.636130>,
				< -85.743032, -23.362590, -180.179536>
			}
			triangle {
				< -75.668976, -33.217054, -159.631133>,
				< -77.195466, -28.013332, -169.636130>,
				< -84.249012, -27.276771, -168.250352>
			}
			triangle {
				< -82.861520, -32.664075, -157.873541>,
				< -75.668976, -33.217054, -159.631133>,
				< -84.249012, -27.276771, -168.250352>
			}
			triangle {
				< -74.421205, -39.489098, -151.802972>,
				< -75.668976, -33.217054, -159.631133>,
				< -82.861520, -32.664075, -157.873541>
			}
			triangle {
				< -81.718713, -39.157368, -149.754077>,
				< -74.421205, -39.489098, -151.802972>,
				< -82.861520, -32.664075, -157.873541>
			}
			triangle {
				< -73.579580, -46.402004, -146.682456>,
				< -74.421205, -39.489098, -151.802972>,
				< -81.718713, -39.157368, -149.754077>
			}
			triangle {
				< -80.943979, -46.314139, -144.442841>,
				< -73.579580, -46.402004, -146.682456>,
				< -81.718713, -39.157368, -149.754077>
			}
			triangle {
				< -73.234290, -53.484667, -144.616127>,
				< -73.579580, -46.402004, -146.682456>,
				< -80.943979, -46.314139, -144.442841>
			}
			triangle {
				< -80.625251, -53.646650, -142.299443>,
				< -73.234290, -53.484667, -144.616127>,
				< -80.943979, -46.314139, -144.442841>
			}
			triangle {
				< -73.423162, -60.254466, -145.743817>,
				< -73.234290, -53.484667, -144.616127>,
				< -80.625251, -53.646650, -142.299443>
			}
			triangle {
				< -80.799654, -60.655251, -143.469378>,
				< -73.423162, -60.254466, -145.743817>,
				< -80.625251, -53.646650, -142.299443>
			}
			triangle {
				< -67.894951, -64.454831, -154.944524>,
				< -67.209795, -59.079416, -151.144713>,
				< -73.423162, -60.254466, -145.743817>
			}
			triangle {
				< -74.125417, -66.249967, -149.989471>,
				< -67.894951, -64.454831, -154.944524>,
				< -73.423162, -60.254466, -145.743817>
			}
			triangle {
				< -69.012128, -68.769753, -161.277756>,
				< -67.894951, -64.454831, -154.944524>,
				< -74.125417, -66.249967, -149.989471>
			}
			triangle {
				< -75.265206, -71.062617, -157.065600>,
				< -69.012128, -68.769753, -161.277756>,
				< -74.125417, -66.249967, -149.989471>
			}
			triangle {
				< -70.452556, -71.730107, -169.714943>,
				< -69.012128, -68.769753, -161.277756>,
				< -75.265206, -71.062617, -157.065600>
			}
			triangle {
				< -76.724060, -74.364461, -166.492432>,
				< -70.452556, -71.730107, -169.714943>,
				< -75.265206, -71.062617, -157.065600>
			}
			triangle {
				< -72.083980, -73.134154, -179.683715>,
				< -70.452556, -71.730107, -169.714943>,
				< -76.724060, -74.364461, -166.492432>
			}
			triangle {
				< -78.360230, -75.930476, -177.630439>,
				< -72.083980, -73.134154, -179.683715>,
				< -76.724060, -74.364461, -166.492432>
			}
			triangle {
				< -73.768876, -72.886206, -190.506235>,
				< -72.083980, -73.134154, -179.683715>,
				< -78.360230, -75.930476, -177.630439>
			}
			triangle {
				< -80.029398, -75.653940, -189.722210>,
				< -73.768876, -72.886206, -190.506235>,
				< -78.360230, -75.930476, -177.630439>
			}
			triangle {
				< -75.380877, -71.003199, -201.445594>,
				< -73.768876, -72.886206, -190.506235>,
				< -80.029398, -75.653940, -189.722210>
			}
			triangle {
				< -81.603467, -73.553696, -201.944396>,
				< -75.380877, -71.003199, -201.445594>,
				< -80.029398, -75.653940, -189.722210>
			}
			triangle {
				< -76.816492, -67.613393, -211.755708>,
				< -75.380877, -71.003199, -201.445594>,
				< -81.603467, -73.553696, -201.944396>
			}
			triangle {
				< -82.983017, -69.772892, -213.463143>,
				< -76.816492, -67.613393, -211.755708>,
				< -81.603467, -73.553696, -201.944396>
			}
			triangle {
				< -78.000419, -62.947847, -220.732182>,
				< -76.816492, -67.613393, -211.755708>,
				< -82.983017, -69.772892, -213.463143>
			}
			triangle {
				< -84.102131, -64.569131, -223.491669>,
				< -78.000419, -62.947847, -220.732182>,
				< -82.983017, -69.772892, -213.463143>
			}
			triangle {
				< -78.884646, -57.324480, -227.761298>,
				< -78.000419, -62.947847, -220.732182>,
				< -84.102131, -64.569131, -223.491669>
			}
			triangle {
				< -84.925234, -58.297083, -231.344357>,
				< -78.884646, -57.324480, -227.761298>,
				< -84.102131, -64.569131, -223.491669>
			}
			triangle {
				< -79.443052, -51.126540, -232.361853>,
				< -78.884646, -57.324480, -227.761298>,
				< -84.925234, -58.297083, -231.344357>
			}
			triangle {
				< -85.438713, -51.384199, -236.483917>,
				< -79.443052, -51.126540, -232.361853>,
				< -84.925234, -58.297083, -231.344357>
			}
			triangle {
				< -79.663880, -44.776410, -234.218866>,
				< -79.443052, -51.126540, -232.361853>,
				< -85.438713, -51.384199, -236.483917>
			}
			triangle {
				< -85.640289, -44.301517, -238.558516>,
				< -79.663880, -44.776410, -234.218866>,
				< -85.438713, -51.384199, -236.483917>
			}
			triangle {
				< -79.543673, -38.706809, -233.205259>,
				< -79.663880, -44.776410, -234.218866>,
				< -85.640289, -44.301517, -238.558516>
			}
			triangle {
				< -85.530661, -37.531760, -237.426102>,
				< -79.543673, -38.706809, -233.205259>,
				< -85.640289, -44.301517, -238.558516>
			}
			triangle {
				< -79.084225, -33.331383, -229.390278>,
				< -79.543673, -38.706809, -233.205259>,
				< -85.530661, -37.531760, -237.426102>
			}
			triangle {
				< -85.109353, -31.536255, -233.164266>,
				< -79.084225, -33.331383, -229.390278>,
				< -85.530661, -37.531760, -237.426102>
			}
			triangle {
				< -78.294292, -29.016482, -223.035321>,
				< -79.084225, -33.331383, -229.390278>,
				< -85.109353, -31.536255, -233.164266>
			}
			triangle {
				< -84.376991, -26.723610, -226.064786>,
				< -78.294292, -29.016482, -223.035321>,
				< -85.109353, -31.536255, -233.164266>
			}
			triangle {
				< -77.195019, -26.056118, -214.575410>,
				< -78.294292, -29.016482, -223.035321>,
				< -84.376991, -26.723610, -226.064786>
			}
			triangle {
				< -83.342776, -23.421761, -216.613352>,
				< -77.195019, -26.056118, -214.575410>,
				< -84.376991, -26.723610, -226.064786>
			}
			triangle {
				< -75.827181, -24.652068, -204.589069>,
				< -77.195019, -26.056118, -214.575410>,
				< -83.342776, -23.421761, -216.613352>
			}
			triangle {
				< -82.034752, -21.855723, -205.456391>,
				< -75.827181, -24.652068, -204.589069>,
				< -83.342776, -23.421761, -216.613352>
			}
			triangle {
				< -74.257731, -24.900006, -193.758816>,
				< -75.827181, -24.652068, -204.589069>,
				< -82.034752, -21.855723, -205.456391>
			}
			triangle {
				< -80.509298, -22.132285, -193.356290>,
				< -74.257731, -24.900006, -193.758816>,
				< -82.034752, -21.855723, -205.456391>
			}
			triangle {
				< -72.582066, -26.783008, -182.823658>,
				< -74.257731, -24.900006, -193.758816>,
				< -80.509298, -22.132285, -193.356290>
			}
			triangle {
				< -78.855999, -24.232520, -181.138739>,
				< -72.582066, -26.783008, -182.823658>,
				< -80.509298, -22.132285, -193.356290>
			}
			triangle {
				< -70.920743, -30.172806, -172.528580>,
				< -72.582066, -26.783008, -182.823658>,
				< -78.855999, -24.232520, -181.138739>
			}
			triangle {
				< -77.195466, -28.013332, -169.636130>,
				< -70.920743, -30.172806, -172.528580>,
				< -78.855999, -24.232520, -181.138739>
			}
			triangle {
				< -69.409579, -34.838352, -163.573921>,
				< -70.920743, -30.172806, -172.528580>,
				< -77.195466, -28.013332, -169.636130>
			}
			triangle {
				< -75.668976, -33.217054, -159.631133>,
				< -69.409579, -34.838352, -163.573921>,
				< -77.195466, -28.013332, -169.636130>
			}
			triangle {
				< -68.184197, -40.461700, -156.567678>,
				< -69.409579, -34.838352, -163.573921>,
				< -75.668976, -33.217054, -159.631133>
			}
			triangle {
				< -74.421205, -39.489098, -151.802972>,
				< -68.184197, -40.461700, -156.567678>,
				< -75.668976, -33.217054, -159.631133>
			}
			triangle {
				< -67.362204, -46.659641, -151.984751>,
				< -68.184197, -40.461700, -156.567678>,
				< -74.421205, -39.489098, -151.802972>
			}
			triangle {
				< -73.579580, -46.402004, -146.682456>,
				< -67.362204, -46.659641, -151.984751>,
				< -74.421205, -39.489098, -151.802972>
			}
			triangle {
				< -67.025922, -53.009801, -150.135234>,
				< -67.362204, -46.659641, -151.984751>,
				< -73.579580, -46.402004, -146.682456>
			}
			triangle {
				< -73.234290, -53.484667, -144.616127>,
				< -67.025922, -53.009801, -150.135234>,
				< -73.579580, -46.402004, -146.682456>
			}
			triangle {
				< -67.209795, -59.079416, -151.144713>,
				< -67.025922, -53.009801, -150.135234>,
				< -73.234290, -53.484667, -144.616127>
			}
			triangle {
				< -73.423162, -60.254466, -145.743817>,
				< -67.209795, -59.079416, -151.144713>,
				< -73.234290, -53.484667, -144.616127>
			}
			triangle {
				< -63.267268, -61.599199, -162.368312>,
				< -62.676765, -57.210196, -159.269974>,
				< -67.209795, -59.079416, -151.144713>
			}
			triangle {
				< -67.894951, -64.454831, -154.944524>,
				< -63.267268, -61.599199, -162.368312>,
				< -67.209795, -59.079416, -151.144713>
			}
			triangle {
				< -64.234905, -65.122306, -167.532012>,
				< -63.267268, -61.599199, -162.368312>,
				< -67.894951, -64.454831, -154.944524>
			}
			triangle {
				< -69.012128, -68.769753, -161.277756>,
				< -64.234905, -65.122306, -167.532012>,
				< -67.894951, -64.454831, -154.944524>
			}
			triangle {
				< -65.491974, -67.539446, -174.410984>,
				< -64.234905, -65.122306, -167.532012>,
				< -69.012128, -68.769753, -161.277756>
			}
			triangle {
				< -70.452556, -71.730107, -169.714943>,
				< -65.491974, -67.539446, -174.410984>,
				< -69.012128, -68.769753, -161.277756>
			}
			triangle {
				< -66.930108, -68.685837, -182.538033>,
				< -65.491974, -67.539446, -174.410984>,
				< -70.452556, -71.730107, -169.714943>
			}
			triangle {
				< -72.083980, -73.134154, -179.683715>,
				< -66.930108, -68.685837, -182.538033>,
				< -70.452556, -71.730107, -169.714943>
			}
			triangle {
				< -68.433747, -68.483412, -191.360801>,
				< -66.930108, -68.685837, -182.538033>,
				< -72.083980, -73.134154, -179.683715>
			}
			triangle {
				< -73.768876, -72.886206, -190.506235>,
				< -68.433747, -68.483412, -191.360801>,
				< -72.083980, -73.134154, -179.683715>
			}
			triangle {
				< -69.892719, -66.945918, -200.278372>,
				< -68.433747, -68.483412, -191.360801>,
				< -73.768876, -72.886206, -190.506235>
			}
			triangle {
				< -75.380877, -71.003199, -201.445594>,
				< -69.892719, -66.945918, -200.278372>,
				< -73.768876, -72.886206, -190.506235>
			}
			triangle {
				< -71.211852, -64.178154, -208.682582>,
				< -69.892719, -66.945918, -200.278372>,
				< -75.380877, -71.003199, -201.445594>
			}
			triangle {
				< -76.816492, -67.613393, -211.755708>,
				< -71.211852, -64.178154, -208.682582>,
				< -75.380877, -71.003199, -201.445594>
			}
			triangle {
				< -72.316274, -60.368754, -215.999484>,
				< -71.211852, -64.178154, -208.682582>,
				< -76.816492, -67.613393, -211.755708>
			}
			triangle {
				< -78.000419, -62.947847, -220.732182>,
				< -72.316274, -60.368754, -215.999484>,
				< -76.816492, -67.613393, -211.755708>
			}
			triangle {
				< -73.152401, -55.777304, -221.728906>,
				< -72.316274, -60.368754, -215.999484>,
				< -78.000419, -62.947847, -220.732182>
			}
			triangle {
				< -78.884646, -57.324480, -227.761298>,
				< -73.152401, -55.777304, -221.728906>,
				< -78.000419, -62.947847, -220.732182>
			}
			triangle {
				< -73.686101, -50.716706, -225.478828>,
				< -73.152401, -55.777304, -221.728906>,
				< -78.884646, -57.324480, -227.761298>
			}
			triangle {
				< -79.443052, -51.126540, -232.361853>,
				< -73.686101, -50.716706, -225.478828>,
				< -78.884646, -57.324480, -227.761298>
			}
			triangle {
				< -73.898502, -45.531821, -226.992562>,
				< -73.686101, -50.716706, -225.478828>,
				< -79.443052, -51.126540, -232.361853>
			}
			triangle {
				< -79.663880, -44.776410, -234.218866>,
				< -73.898502, -45.531821, -226.992562>,
				< -79.443052, -51.126540, -232.361853>
			}
			triangle {
				< -73.782794, -40.576030, -226.166368>,
				< -73.898502, -45.531821, -226.992562>,
				< -79.663880, -44.776410, -234.218866>
			}
			triangle {
				< -79.543673, -38.706809, -233.205259>,
				< -73.782794, -40.576030, -226.166368>,
				< -79.663880, -44.776410, -234.218866>
			}
			triangle {
				< -73.342621, -36.187001, -223.056808>,
				< -73.782794, -40.576030, -226.166368>,
				< -79.543673, -38.706809, -233.205259>
			}
			triangle {
				< -79.084225, -33.331383, -229.390278>,
				< -73.342621, -36.187001, -223.056808>,
				< -79.543673, -38.706809, -233.205259>
			}
			triangle {
				< -72.593026, -32.663889, -217.876881>,
				< -73.342621, -36.187001, -223.056808>,
				< -79.084225, -33.331383, -229.390278>
			}
			triangle {
				< -78.294292, -29.016482, -223.035321>,
				< -72.593026, -32.663889, -217.876881>,
				< -79.084225, -33.331383, -229.390278>
			}
			triangle {
				< -71.563214, -30.246777, -210.981041>,
				< -72.593026, -32.663889, -217.876881>,
				< -78.294292, -29.016482, -223.035321>
			}
			triangle {
				< -77.195019, -26.056118, -214.575410>,
				< -71.563214, -30.246777, -210.981041>,
				< -78.294292, -29.016482, -223.035321>
			}
			triangle {
				< -70.300668, -29.100366, -202.840805>,
				< -71.563214, -30.246777, -210.981041>,
				< -77.195019, -26.056118, -214.575410>
			}
			triangle {
				< -75.827181, -24.652068, -204.589069>,
				< -70.300668, -29.100366, -202.840805>,
				< -77.195019, -26.056118, -214.575410>
			}
			triangle {
				< -68.873949, -29.302808, -194.012389>,
				< -70.300668, -29.100366, -202.840805>,
				< -75.827181, -24.652068, -204.589069>
			}
			triangle {
				< -74.257731, -24.900006, -193.758816>,
				< -68.873949, -29.302808, -194.012389>,
				< -75.827181, -24.652068, -204.589069>
			}
			triangle {
				< -67.372531, -30.840296, -185.097903>,
				< -68.873949, -29.302808, -194.012389>,
				< -74.257731, -24.900006, -193.758816>
			}
			triangle {
				< -72.582066, -26.783008, -182.823658>,
				< -67.372531, -30.840296, -185.097903>,
				< -74.257731, -24.900006, -193.758816>
			}
			triangle {
				< -65.903053, -33.608049, -176.704928>,
				< -67.372531, -30.840296, -185.097903>,
				< -72.582066, -26.783008, -182.823658>
			}
			triangle {
				< -70.920743, -30.172806, -172.528580>,
				< -65.903053, -33.608049, -176.704928>,
				< -72.582066, -26.783008, -182.823658>
			}
			triangle {
				< -64.580657, -37.417453, -169.404224>,
				< -65.903053, -33.608049, -176.704928>,
				< -70.920743, -30.172806, -172.528580>
			}
			triangle {
				< -69.409579, -34.838352, -163.573921>,
				< -64.580657, -37.417453, -169.404224>,
				< -70.920743, -30.172806, -172.528580>
			}
			triangle {
				< -63.517220, -42.008899, -163.691744>,
				< -64.580657, -37.417453, -169.404224>,
				< -69.409579, -34.838352, -163.573921>
			}
			triangle {
				< -68.184197, -40.461700, -156.567678>,
				< -63.517220, -42.008899, -163.691744>,
				< -69.409579, -34.838352, -163.573921>
			}
			triangle {
				< -62.807932, -47.069497, -159.954906>,
				< -63.517220, -42.008899, -163.691744>,
				< -68.184197, -40.461700, -156.567678>
			}
			triangle {
				< -67.362204, -46.659641, -151.984751>,
				< -62.807932, -47.069497, -159.954906>,
				< -68.184197, -40.461700, -156.567678>
			}
			triangle {
				< -62.518634, -52.254360, -158.446997>,
				< -62.807932, -47.069497, -159.954906>,
				< -67.362204, -46.659641, -151.984751>
			}
			triangle {
				< -67.025922, -53.009801, -150.135234>,
				< -62.518634, -52.254360, -158.446997>,
				< -67.362204, -46.659641, -151.984751>
			}
			triangle {
				< -62.676765, -57.210196, -159.269974>,
				< -62.518634, -52.254360, -158.446997>,
				< -67.025922, -53.009801, -150.135234>
			}
			triangle {
				< -67.209795, -59.079416, -151.144713>,
				< -62.676765, -57.210196, -159.269974>,
				< -67.025922, -53.009801, -150.135234>
			}
			triangle {
				< -60.558718, -57.877667, -171.724871>,
				< -60.130697, -54.774184, -169.535771>,
				< -62.676765, -57.210196, -159.269974>
			}
			triangle {
				< -63.267268, -61.599199, -162.368312>,
				< -60.558718, -57.877667, -171.724871>,
				< -62.676765, -57.210196, -159.269974>
			}
			triangle {
				< -61.263710, -60.368899, -175.372764>,
				< -60.558718, -57.877667, -171.724871>,
				< -63.267268, -61.599199, -162.368312>
			}
			triangle {
				< -64.234905, -65.122306, -167.532012>,
				< -61.263710, -60.368899, -175.372764>,
				< -63.267268, -61.599199, -162.368312>
			}
			triangle {
				< -62.186819, -62.078059, -180.232123>,
				< -61.263710, -60.368899, -175.372764>,
				< -64.234905, -65.122306, -167.532012>
			}
			triangle {
				< -65.491974, -67.539446, -174.410984>,
				< -62.186819, -62.078059, -180.232123>,
				< -64.234905, -65.122306, -167.532012>
			}
			triangle {
				< -63.253745, -62.888674, -185.972497>,
				< -62.186819, -62.078059, -180.232123>,
				< -65.491974, -67.539446, -174.410984>
			}
			triangle {
				< -66.930108, -68.685837, -182.538033>,
				< -63.253745, -62.888674, -185.972497>,
				< -65.491974, -67.539446, -174.410984>
			}
			triangle {
				< -64.383052, -62.745549, -192.203403>,
				< -63.253745, -62.888674, -185.972497>,
				< -66.930108, -68.685837, -182.538033>
			}
			triangle {
				< -68.433747, -68.483412, -191.360801>,
				< -64.383052, -62.745549, -192.203403>,
				< -66.930108, -68.685837, -182.538033>
			}
			triangle {
				< -65.493882, -61.658375, -198.500514>,
				< -64.383052, -62.745549, -192.203403>,
				< -68.433747, -68.483412, -191.360801>
			}
			triangle {
				< -69.892719, -66.945918, -200.278372>,
				< -65.493882, -61.658375, -198.500514>,
				< -68.433747, -68.483412, -191.360801>
			}
			triangle {
				< -66.512704, -59.701283, -204.434529>,
				< -65.493882, -61.658375, -198.500514>,
				< -69.892719, -66.945918, -200.278372>
			}
			triangle {
				< -71.211852, -64.178154, -208.682582>,
				< -66.512704, -59.701283, -204.434529>,
				< -69.892719, -66.945918, -200.278372>
			}
			triangle {
				< -67.377582, -57.007611, -209.600389>,
				< -66.512704, -59.701283, -204.434529>,
				< -71.211852, -64.178154, -208.682582>
			}
			triangle {
				< -72.316274, -60.368754, -215.999484>,
				< -67.377582, -57.007611, -209.600389>,
				< -71.211852, -64.178154, -208.682582>
			}
			triangle {
				< -68.040393, -53.760957, -213.645130>,
				< -67.377582, -57.007611, -209.600389>,
				< -72.316274, -60.368754, -215.999484>
			}
			triangle {
				< -73.152401, -55.777304, -221.728906>,
				< -68.040393, -53.760957, -213.645130>,
				< -72.316274, -60.368754, -215.999484>
			}
			triangle {
				< -68.467386, -50.182588, -216.292322>,
				< -68.040393, -53.760957, -213.645130>,
				< -73.152401, -55.777304, -221.728906>
			}
			triangle {
				< -73.686101, -50.716706, -225.478828>,
				< -68.467386, -50.182588, -216.292322>,
				< -73.152401, -55.777304, -221.728906>
			}
			triangle {
				< -68.638220, -46.516333, -217.360809>,
				< -68.467386, -50.182588, -216.292322>,
				< -73.686101, -50.716706, -225.478828>
			}
			triangle {
				< -73.898502, -45.531821, -226.992562>,
				< -68.638220, -46.516333, -217.360809>,
				< -73.686101, -50.716706, -225.478828>
			}
			triangle {
				< -68.545073, -43.012045, -216.777578>,
				< -68.638220, -46.516333, -217.360809>,
				< -73.898502, -45.531821, -226.992562>
			}
			triangle {
				< -73.782794, -40.576030, -226.166368>,
				< -68.545073, -43.012045, -216.777578>,
				< -73.898502, -45.531821, -226.992562>
			}
			triangle {
				< -68.192206, -39.908540, -214.582518>,
				< -68.545073, -43.012045, -216.777578>,
				< -73.782794, -40.576030, -226.166368>
			}
			triangle {
				< -73.342621, -36.187001, -223.056808>,
				< -68.192206, -39.908540, -214.582518>,
				< -73.782794, -40.576030, -226.166368>
			}
			triangle {
				< -67.596145, -37.417326, -210.925728>,
				< -68.192206, -39.908540, -214.582518>,
				< -73.342621, -36.187001, -223.056808>
			}
			triangle {
				< -72.593026, -32.663889, -217.876881>,
				< -67.596145, -37.417326, -210.925728>,
				< -73.342621, -36.187001, -223.056808>
			}
			triangle {
				< -66.786595, -35.708159, -206.057340>,
				< -67.596145, -37.417326, -210.925728>,
				< -72.593026, -32.663889, -217.876881>
			}
			triangle {
				< -71.563214, -30.246777, -210.981041>,
				< -66.786595, -35.708159, -206.057340>,
				< -72.593026, -32.663889, -217.876881>
			}
			triangle {
				< -65.807395, -34.897525, -200.309873>,
				< -66.786595, -35.708159, -206.057340>,
				< -71.563214, -30.246777, -210.981041>
			}
			triangle {
				< -70.300668, -29.100366, -202.840805>,
				< -65.807395, -34.897525, -200.309873>,
				< -71.563214, -30.246777, -210.981041>
			}
			triangle {
				< -64.716555, -35.040673, -194.075823>,
				< -65.807395, -34.897525, -200.309873>,
				< -70.300668, -29.100366, -202.840805>
			}
			triangle {
				< -68.873949, -29.302808, -194.012389>,
				< -64.716555, -35.040673, -194.075823>,
				< -70.300668, -29.100366, -202.840805>
			}
			triangle {
				< -63.584514, -36.127850, -187.780410>,
				< -64.716555, -35.040673, -194.075823>,
				< -68.873949, -29.302808, -194.012389>
			}
			triangle {
				< -67.372531, -30.840296, -185.097903>,
				< -63.584514, -36.127850, -187.780410>,
				< -68.873949, -29.302808, -194.012389>
			}
			triangle {
				< -62.490560, -38.084954, -181.852490>,
				< -63.584514, -36.127850, -187.780410>,
				< -67.372531, -30.840296, -185.097903>
			}
			triangle {
				< -65.903053, -33.608049, -176.704928>,
				< -62.490560, -38.084954, -181.852490>,
				< -67.372531, -30.840296, -185.097903>
			}
			triangle {
				< -61.516777, -40.778592, -176.695362>,
				< -62.490560, -38.084954, -181.852490>,
				< -65.903053, -33.608049, -176.704928>
			}
			triangle {
				< -64.580657, -37.417453, -169.404224>,
				< -61.516777, -40.778592, -176.695362>,
				< -65.903053, -33.608049, -176.704928>
			}
			triangle {
				< -60.740385, -44.025227, -172.659725>,
				< -61.516777, -40.778592, -176.695362>,
				< -64.580657, -37.417453, -169.404224>
			}
			triangle {
				< -63.517220, -42.008899, -163.691744>,
				< -60.740385, -44.025227, -172.659725>,
				< -64.580657, -37.417453, -169.404224>
			}
			triangle {
				< -60.225647, -47.603618, -170.019746>,
				< -60.740385, -44.025227, -172.659725>,
				< -63.517220, -42.008899, -163.691744>
			}
			triangle {
				< -62.807932, -47.069497, -159.954906>,
				< -60.225647, -47.603618, -170.019746>,
				< -63.517220, -42.008899, -163.691744>
			}
			triangle {
				< -60.016390, -51.269870, -168.954283>,
				< -60.225647, -47.603618, -170.019746>,
				< -62.807932, -47.069497, -159.954906>
			}
			triangle {
				< -62.518634, -52.254360, -158.446997>,
				< -60.016390, -51.269870, -168.954283>,
				< -62.807932, -47.069497, -159.954906>
			}
			triangle {
				< -60.130697, -54.774184, -169.535771>,
				< -60.016390, -51.269870, -168.954283>,
				< -62.518634, -52.254360, -158.446997>
			}
			triangle {
				< -62.676765, -57.210196, -159.269974>,
				< -60.130697, -54.774184, -169.535771>,
				< -62.518634, -52.254360, -158.446997>
			}
			triangle {
				< -59.868608, -53.543855, -182.357669>,
				< -59.647966, -51.937386, -181.224734>,
				< -60.130697, -54.774184, -169.535771>
			}
			triangle {
				< -60.558718, -57.877667, -171.724871>,
				< -59.868608, -53.543855, -182.357669>,
				< -60.130697, -54.774184, -169.535771>
			}
			triangle {
				< -60.234051, -54.833416, -184.245512>,
				< -59.868608, -53.543855, -182.357669>,
				< -60.558718, -57.877667, -171.724871>
			}
			triangle {
				< -61.263710, -60.368899, -175.372764>,
				< -60.234051, -54.833416, -184.245512>,
				< -60.558718, -57.877667, -171.724871>
			}
			triangle {
				< -60.716495, -55.718154, -186.759830>,
				< -60.234051, -54.833416, -184.245512>,
				< -61.263710, -60.368899, -175.372764>
			}
			triangle {
				< -62.186819, -62.078059, -180.232123>,
				< -60.716495, -55.718154, -186.759830>,
				< -61.263710, -60.368899, -175.372764>
			}
			triangle {
				< -61.280001, -56.137756, -189.729542>,
				< -60.716495, -55.718154, -186.759830>,
				< -62.186819, -62.078059, -180.232123>
			}
			triangle {
				< -63.253745, -62.888674, -185.972497>,
				< -61.280001, -56.137756, -189.729542>,
				< -62.186819, -62.078059, -180.232123>
			}
			triangle {
				< -61.883818, -56.063659, -192.952543>,
				< -61.280001, -56.137756, -189.729542>,
				< -63.253745, -62.888674, -185.972497>
			}
			triangle {
				< -64.383052, -62.745549, -192.203403>,
				< -61.883818, -56.063659, -192.952543>,
				< -63.253745, -62.888674, -185.972497>
			}
			triangle {
				< -62.485822, -55.500906, -196.209222>,
				< -61.883818, -56.063659, -192.952543>,
				< -64.383052, -62.745549, -192.203403>
			}
			triangle {
				< -65.493882, -61.658375, -198.500514>,
				< -62.485822, -55.500906, -196.209222>,
				< -64.383052, -62.745549, -192.203403>
			}
			triangle {
				< -63.045464, -54.487828, -199.277535>,
				< -62.485822, -55.500906, -196.209222>,
				< -65.493882, -61.658375, -198.500514>
			}
			triangle {
				< -66.512704, -59.701283, -204.434529>,
				< -63.045464, -54.487828, -199.277535>,
				< -65.493882, -61.658375, -198.500514>
			}
			triangle {
				< -63.526712, -53.093486, -201.948285>,
				< -63.045464, -54.487828, -199.277535>,
				< -66.512704, -59.701283, -204.434529>
			}
			triangle {
				< -67.377582, -57.007611, -209.600389>,
				< -63.526712, -53.093486, -201.948285>,
				< -66.512704, -59.701283, -204.434529>
			}
			triangle {
				< -63.899606, -51.412895, -204.039142>,
				< -63.526712, -53.093486, -201.948285>,
				< -67.377582, -57.007611, -209.600389>
			}
			triangle {
				< -68.040393, -53.760957, -213.645130>,
				< -63.899606, -51.412895, -204.039142>,
				< -67.377582, -57.007611, -209.600389>
			}
			triangle {
				< -64.141810, -49.560580, -205.407441>,
				< -63.899606, -51.412895, -204.039142>,
				< -68.040393, -53.760957, -213.645130>
			}
			triangle {
				< -68.467386, -50.182588, -216.292322>,
				< -64.141810, -49.560580, -205.407441>,
				< -68.040393, -53.760957, -213.645130>
			}
			triangle {
				< -64.239159, -47.662787, -205.959737>,
				< -64.141810, -49.560580, -205.407441>,
				< -68.467386, -50.182588, -216.292322>
			}
			triangle {
				< -68.638220, -46.516333, -217.360809>,
				< -64.239159, -47.662787, -205.959737>,
				< -68.467386, -50.182588, -216.292322>
			}
			triangle {
				< -64.186044, -45.848839, -205.658302>,
				< -64.239159, -47.662787, -205.959737>,
				< -68.638220, -46.516333, -217.360809>
			}
			triangle {
				< -68.545073, -43.012045, -216.777578>,
				< -64.186044, -45.848839, -205.658302>,
				< -68.638220, -46.516333, -217.360809>
			}
			triangle {
				< -63.985541, -44.242349, -204.523712>,
				< -64.186044, -45.848839, -205.658302>,
				< -68.545073, -43.012045, -216.777578>
			}
			triangle {
				< -68.192206, -39.908540, -214.582518>,
				< -63.985541, -44.242349, -204.523712>,
				< -68.545073, -43.012045, -216.777578>
			}
			triangle {
				< -63.649274, -42.952791, -202.633381>,
				< -63.985541, -44.242349, -204.523712>,
				< -68.192206, -39.908540, -214.582518>
			}
			triangle {
				< -67.596145, -37.417326, -210.925728>,
				< -63.649274, -42.952791, -202.633381>,
				< -68.192206, -39.908540, -214.582518>
			}
			triangle {
				< -63.197248, -42.068072, -200.116545>,
				< -63.649274, -42.952791, -202.633381>,
				< -67.596145, -37.417326, -210.925728>
			}
			triangle {
				< -66.786595, -35.708159, -206.057340>,
				< -63.197248, -42.068072, -200.116545>,
				< -67.596145, -37.417326, -210.925728>
			}
			triangle {
				< -62.657237, -41.648466, -197.144836>,
				< -63.197248, -42.068072, -200.116545>,
				< -66.786595, -35.708159, -206.057340>
			}
			triangle {
				< -65.807395, -34.897525, -200.309873>,
				< -62.657237, -41.648466, -197.144836>,
				< -66.786595, -35.708159, -206.057340>
			}
			triangle {
				< -62.063698, -41.722544, -193.920970>,
				< -62.657237, -41.648466, -197.144836>,
				< -65.807395, -34.897525, -200.309873>
			}
			triangle {
				< -64.716555, -35.040673, -194.075823>,
				< -62.063698, -41.722544, -193.920970>,
				< -65.807395, -34.897525, -200.309873>
			}
			triangle {
				< -61.456058, -42.285319, -190.664783>,
				< -62.063698, -41.722544, -193.920970>,
				< -64.716555, -35.040673, -194.075823>
			}
			triangle {
				< -63.584514, -36.127850, -187.780410>,
				< -61.456058, -42.285319, -190.664783>,
				< -64.716555, -35.040673, -194.075823>
			}
			triangle {
				< -60.876239, -43.298375, -187.598184>,
				< -61.456058, -42.285319, -190.664783>,
				< -63.584514, -36.127850, -187.780410>
			}
			triangle {
				< -62.490560, -38.084954, -181.852490>,
				< -60.876239, -43.298375, -187.598184>,
				< -63.584514, -36.127850, -187.780410>
			}
			triangle {
				< -60.365848, -44.692717, -184.929907>,
				< -60.876239, -43.298375, -187.598184>,
				< -62.490560, -38.084954, -181.852490>
			}
			triangle {
				< -61.516777, -40.778592, -176.695362>,
				< -60.365848, -44.692717, -184.929907>,
				< -62.490560, -38.084954, -181.852490>
			}
			triangle {
				< -59.962541, -46.373311, -182.841599>,
				< -60.365848, -44.692717, -184.929907>,
				< -61.516777, -40.778592, -176.695362>
			}
			triangle {
				< -60.740385, -44.025227, -172.659725>,
				< -59.962541, -46.373311, -182.841599>,
				< -61.516777, -40.778592, -176.695362>
			}
			triangle {
				< -59.696827, -48.225619, -181.475222>,
				< -59.962541, -46.373311, -182.841599>,
				< -60.740385, -44.025227, -172.659725>
			}
			triangle {
				< -60.225647, -47.603618, -170.019746>,
				< -59.696827, -48.225619, -181.475222>,
				< -60.740385, -44.025227, -172.659725>
			}
			triangle {
				< -59.589166, -50.123416, -180.923805>,
				< -59.696827, -48.225619, -181.475222>,
				< -60.225647, -47.603618, -170.019746>
			}
			triangle {
				< -60.016390, -51.269870, -168.954283>,
				< -59.589166, -50.123416, -180.923805>,
				< -60.225647, -47.603618, -170.019746>
			}
			triangle {
				< -59.647966, -51.937386, -181.224734>,
				< -59.589166, -50.123416, -180.923805>,
				< -60.016390, -51.269870, -168.954283>
			}
			triangle {
				< -60.130697, -54.774184, -169.535771>,
				< -59.647966, -51.937386, -181.224734>,
				< -60.016390, -51.269870, -168.954283>
			}
			triangle {
				< -59.696827, -48.225619, -181.475222>,
				< -59.589166, -50.123416, -180.923805>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -59.962541, -46.373311, -182.841599>,
				< -59.696827, -48.225619, -181.475222>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -60.365848, -44.692717, -184.929907>,
				< -59.962541, -46.373311, -182.841599>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -60.876239, -43.298375, -187.598184>,
				< -60.365848, -44.692717, -184.929907>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -61.456058, -42.285319, -190.664783>,
				< -60.876239, -43.298375, -187.598184>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -62.063698, -41.722544, -193.920970>,
				< -61.456058, -42.285319, -190.664783>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -62.657237, -41.648466, -197.144836>,
				< -62.063698, -41.722544, -193.920970>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -63.197248, -42.068072, -200.116545>,
				< -62.657237, -41.648466, -197.144836>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -63.649274, -42.952791, -202.633381>,
				< -63.197248, -42.068072, -200.116545>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -63.985541, -44.242349, -204.523712>,
				< -63.649274, -42.952791, -202.633381>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -64.186044, -45.848839, -205.658302>,
				< -63.985541, -44.242349, -204.523712>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -64.239159, -47.662787, -205.959737>,
				< -64.186044, -45.848839, -205.658302>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -64.141810, -49.560580, -205.407441>,
				< -64.239159, -47.662787, -205.959737>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -63.899606, -51.412895, -204.039142>,
				< -64.141810, -49.560580, -205.407441>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -63.526712, -53.093486, -201.948285>,
				< -63.899606, -51.412895, -204.039142>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -63.045464, -54.487828, -199.277535>,
				< -63.526712, -53.093486, -201.948285>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -62.485822, -55.500906, -196.209222>,
				< -63.045464, -54.487828, -199.277535>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -61.883818, -56.063659, -192.952543>,
				< -62.485822, -55.500906, -196.209222>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -61.280001, -56.137756, -189.729542>,
				< -61.883818, -56.063659, -192.952543>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -60.716495, -55.718154, -186.759830>,
				< -61.280001, -56.137756, -189.729542>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -60.234051, -54.833416, -184.245512>,
				< -60.716495, -55.718154, -186.759830>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -59.868608, -53.543855, -182.357669>,
				< -60.234051, -54.833416, -184.245512>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -59.647966, -51.937386, -181.224734>,
				< -59.868608, -53.543855, -182.357669>,
				< -61.095826, -48.893113, -193.540305>
			}
			triangle {
				< -59.589166, -50.123416, -180.923805>,
				< -59.647966, -51.937386, -181.224734>,
				< -61.095826, -48.893113, -193.540305>
			}
			
		}
		// _Shin02
		union {
			triangle {
				< -95.272973, -41.474398, -196.473822>,
				< -94.069801, -44.182118, -197.015479>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -95.926851, -38.410384, -195.949942>,
				< -95.272973, -41.474398, -196.473822>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -95.986791, -35.199072, -195.480287>,
				< -95.926851, -38.410384, -195.949942>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -95.448695, -32.059770, -195.097476>,
				< -95.986791, -35.199072, -195.480287>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -94.349317, -29.207153, -194.827288>,
				< -95.448695, -32.059770, -195.097476>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -92.763737, -26.836233, -194.687158>,
				< -94.349317, -29.207153, -194.827288>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -90.800226, -25.109207, -194.685385>,
				< -92.763737, -26.836233, -194.687158>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -88.592798, -24.143865, -194.820777>,
				< -90.800226, -25.109207, -194.685385>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -86.291976, -24.005873, -195.083097>,
				< -88.592798, -24.143865, -194.820777>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -84.054574, -24.704130, -195.453867>,
				< -86.291976, -24.005873, -195.083097>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -82.032979, -26.190350, -195.908576>,
				< -84.054574, -24.704130, -195.453867>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -80.364808, -28.362561, -196.416646>,
				< -82.032979, -26.190350, -195.908576>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -79.163514, -31.072201, -196.945012>,
				< -80.364808, -28.362561, -196.416646>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -78.510761, -34.134440, -197.458908>,
				< -79.163514, -31.072201, -196.945012>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -78.450933, -37.340760, -197.924376>,
				< -78.510761, -34.134440, -197.458908>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -78.988075, -40.473171, -198.309973>,
				< -78.450933, -37.340760, -197.924376>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -80.085732, -43.318894, -198.589310>,
				< -78.988075, -40.473171, -198.309973>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -81.669211, -45.684677, -198.742300>,
				< -80.085732, -43.318894, -198.589310>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -83.630882, -47.409806, -198.757261>,
				< -81.669211, -45.684677, -198.742300>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -85.837170, -48.376925, -198.631957>,
				< -83.630882, -47.409806, -198.757261>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -88.137887, -48.519894, -198.373780>,
				< -85.837170, -48.376925, -198.631957>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -90.376243, -47.828533, -198.000073>,
				< -88.137887, -48.519894, -198.373780>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -92.399560, -46.349186, -197.536394>,
				< -90.376243, -47.828533, -198.000073>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -94.069801, -44.182118, -197.015479>,
				< -92.399560, -46.349186, -197.536394>,
				< -86.799882, -37.318338, -191.734299>
			}
			triangle {
				< -103.855573, -43.203965, -210.863024>,
				< -101.546027, -48.377253, -211.868778>,
				< -94.069801, -44.182118, -197.015479>
			}
			triangle {
				< -95.272973, -41.474398, -196.473822>,
				< -103.855573, -43.203965, -210.863024>,
				< -94.069801, -44.182118, -197.015479>
			}
			triangle {
				< -105.110839, -37.349269, -209.893838>,
				< -103.855573, -43.203965, -210.863024>,
				< -95.272973, -41.474398, -196.473822>
			}
			triangle {
				< -95.926851, -38.410384, -195.949942>,
				< -105.110839, -37.349269, -209.893838>,
				< -95.272973, -41.474398, -196.473822>
			}
			triangle {
				< -105.225913, -31.212714, -209.030986>,
				< -105.110839, -37.349269, -209.893838>,
				< -95.926851, -38.410384, -195.949942>
			}
			triangle {
				< -95.986791, -35.199072, -195.480287>,
				< -105.225913, -31.212714, -209.030986>,
				< -95.926851, -38.410384, -195.949942>
			}
			triangle {
				< -104.192890, -25.214231, -208.334938>,
				< -105.225913, -31.212714, -209.030986>,
				< -95.986791, -35.199072, -195.480287>
			}
			triangle {
				< -95.448695, -32.059770, -195.097476>,
				< -104.192890, -25.214231, -208.334938>,
				< -95.986791, -35.199072, -195.480287>
			}
			triangle {
				< -102.082521, -19.764984, -207.851857>,
				< -104.192890, -25.214231, -208.334938>,
				< -95.448695, -32.059770, -195.097476>
			}
			triangle {
				< -94.349317, -29.207153, -194.827288>,
				< -102.082521, -19.764984, -207.851857>,
				< -95.448695, -32.059770, -195.097476>
			}
			triangle {
				< -99.039212, -15.238894, -207.611293>,
				< -102.082521, -19.764984, -207.851857>,
				< -94.349317, -29.207153, -194.827288>
			}
			triangle {
				< -92.763737, -26.836233, -194.687158>,
				< -99.039212, -15.238894, -207.611293>,
				< -94.349317, -29.207153, -194.827288>
			}
			triangle {
				< -95.271043, -11.946238, -207.625151>,
				< -99.039212, -15.238894, -207.611293>,
				< -92.763737, -26.836233, -194.687158>
			}
			triangle {
				< -90.800226, -25.109207, -194.685385>,
				< -95.271043, -11.946238, -207.625151>,
				< -92.763737, -26.836233, -194.687158>
			}
			triangle {
				< -91.035493, -10.112230, -207.887277>,
				< -95.271043, -11.946238, -207.625151>,
				< -90.800226, -25.109207, -194.685385>
			}
			triangle {
				< -88.592798, -24.143865, -194.820777>,
				< -91.035493, -10.112230, -207.887277>,
				< -90.800226, -25.109207, -194.685385>
			}
			triangle {
				< -86.621635, -9.861300, -208.376169>,
				< -91.035493, -10.112230, -207.887277>,
				< -88.592798, -24.143865, -194.820777>
			}
			triangle {
				< -86.291976, -24.005873, -195.083097>,
				< -86.621635, -9.861300, -208.376169>,
				< -88.592798, -24.143865, -194.820777>
			}
			triangle {
				< -82.330301, -11.208685, -209.057033>,
				< -86.621635, -9.861300, -208.376169>,
				< -86.291976, -24.005873, -195.083097>
			}
			triangle {
				< -84.054574, -24.704130, -195.453867>,
				< -82.330301, -11.208685, -209.057033>,
				< -86.291976, -24.005873, -195.083097>
			}
			triangle {
				< -78.453660, -14.060142, -209.884614>,
				< -82.330301, -11.208685, -209.057033>,
				< -84.054574, -24.704130, -195.453867>
			}
			triangle {
				< -82.032979, -26.190350, -195.908576>,
				< -78.453660, -14.060142, -209.884614>,
				< -84.054574, -24.704130, -195.453867>
			}
			triangle {
				< -75.255267, -18.218715, -210.806191>,
				< -78.453660, -14.060142, -209.884614>,
				< -82.032979, -26.190350, -195.908576>
			}
			triangle {
				< -80.364808, -28.362561, -196.416646>,
				< -75.255267, -18.218715, -210.806191>,
				< -82.032979, -26.190350, -195.908576>
			}
			triangle {
				< -72.952345, -23.399189, -211.763442>,
				< -75.255267, -18.218715, -210.806191>,
				< -80.364808, -28.362561, -196.416646>
			}
			triangle {
				< -79.163514, -31.072201, -196.945012>,
				< -72.952345, -23.399189, -211.763442>,
				< -80.364808, -28.362561, -196.416646>
			}
			triangle {
				< -71.701124, -29.247755, -212.696105>,
				< -72.952345, -23.399189, -211.763442>,
				< -79.163514, -31.072201, -196.945012>
			}
			triangle {
				< -78.510761, -34.134440, -197.458908>,
				< -71.701124, -29.247755, -212.696105>,
				< -79.163514, -31.072201, -196.945012>
			}
			triangle {
				< -71.586452, -35.366546, -213.544264>,
				< -71.701124, -29.247755, -212.696105>,
				< -78.510761, -34.134440, -197.458908>
			}
			triangle {
				< -78.450933, -37.340760, -197.924376>,
				< -71.586452, -35.366546, -213.544264>,
				< -78.510761, -34.134440, -197.458908>
			}
			triangle {
				< -72.616100, -41.340362, -214.251474>,
				< -71.586452, -35.366546, -213.544264>,
				< -78.450933, -37.340760, -197.924376>
			}
			triangle {
				< -78.988075, -40.473171, -198.309973>,
				< -72.616100, -41.340362, -214.251474>,
				< -78.450933, -37.340760, -197.924376>
			}
			triangle {
				< -74.720234, -46.764631, -214.768231>,
				< -72.616100, -41.340362, -214.251474>,
				< -78.988075, -40.473171, -198.309973>
			}
			triangle {
				< -80.085732, -43.318894, -198.589310>,
				< -74.720234, -46.764631, -214.768231>,
				< -78.988075, -40.473171, -198.309973>
			}
			triangle {
				< -77.756159, -51.272191, -215.056106>,
				< -74.720234, -46.764631, -214.768231>,
				< -80.085732, -43.318894, -198.589310>
			}
			triangle {
				< -81.669211, -45.684677, -198.742300>,
				< -77.756159, -51.272191, -215.056106>,
				< -80.085732, -43.318894, -198.589310>
			}
			triangle {
				< -81.517711, -54.557662, -215.090722>,
				< -77.756159, -51.272191, -215.056106>,
				< -81.669211, -45.684677, -198.742300>
			}
			triangle {
				< -83.630882, -47.409806, -198.757261>,
				< -81.517711, -54.557662, -215.090722>,
				< -81.669211, -45.684677, -198.742300>
			}
			triangle {
				< -85.749246, -56.397799, -214.865088>,
				< -81.517711, -54.557662, -215.090722>,
				< -83.630882, -47.409806, -198.757261>
			}
			triangle {
				< -85.837170, -48.376925, -198.631957>,
				< -85.749246, -56.397799, -214.865088>,
				< -83.630882, -47.409806, -198.757261>
			}
			triangle {
				< -90.162747, -56.666512, -214.390844>,
				< -85.749246, -56.397799, -214.865088>,
				< -85.837170, -48.376925, -198.631957>
			}
			triangle {
				< -88.137887, -48.519894, -198.373780>,
				< -90.162747, -56.666512, -214.390844>,
				< -85.837170, -48.376925, -198.631957>
			}
			triangle {
				< -94.457448, -55.343766, -213.698924>,
				< -90.162747, -56.666512, -214.390844>,
				< -88.137887, -48.519894, -198.373780>
			}
			triangle {
				< -90.376243, -47.828533, -198.000073>,
				< -94.457448, -55.343766, -213.698924>,
				< -88.137887, -48.519894, -198.373780>
			}
			triangle {
				< -98.340288, -52.517235, -212.837592>,
				< -94.457448, -55.343766, -213.698924>,
				< -90.376243, -47.828533, -198.000073>
			}
			triangle {
				< -92.399560, -46.349186, -197.536394>,
				< -98.340288, -52.517235, -212.837592>,
				< -90.376243, -47.828533, -198.000073>
			}
			triangle {
				< -101.546027, -48.377253, -211.868778>,
				< -98.340288, -52.517235, -212.837592>,
				< -92.399560, -46.349186, -197.536394>
			}
			triangle {
				< -94.069801, -44.182118, -197.015479>,
				< -101.546027, -48.377253, -211.868778>,
				< -92.399560, -46.349186, -197.536394>
			}
			triangle {
				< -111.772574, -42.539950, -233.973414>,
				< -108.541787, -49.727742, -235.294312>,
				< -101.546027, -48.377253, -211.868778>
			}
			triangle {
				< -103.855573, -43.203965, -210.863024>,
				< -111.772574, -42.539950, -233.973414>,
				< -101.546027, -48.377253, -211.868778>
			}
			triangle {
				< -113.528609, -34.407392, -232.706666>,
				< -111.772574, -42.539950, -233.973414>,
				< -103.855573, -43.203965, -210.863024>
			}
			triangle {
				< -105.110839, -37.349269, -209.893838>,
				< -113.528609, -34.407392, -232.706666>,
				< -103.855573, -43.203965, -210.863024>
			}
			triangle {
				< -113.689594, -25.885208, -231.587529>,
				< -113.528609, -34.407392, -232.706666>,
				< -105.110839, -37.349269, -209.893838>
			}
			triangle {
				< -105.225913, -31.212714, -209.030986>,
				< -113.689594, -25.885208, -231.587529>,
				< -105.110839, -37.349269, -209.893838>
			}
			triangle {
				< -112.244472, -17.557248, -230.695203>,
				< -113.689594, -25.885208, -231.587529>,
				< -105.225913, -31.212714, -209.030986>
			}
			triangle {
				< -104.192890, -25.214231, -208.334938>,
				< -112.244472, -17.557248, -230.695203>,
				< -105.225913, -31.212714, -209.030986>
			}
			triangle {
				< -109.292261, -9.995606, -230.088368>,
				< -112.244472, -17.557248, -230.695203>,
				< -104.192890, -25.214231, -208.334938>
			}
			triangle {
				< -102.082521, -19.764984, -207.851857>,
				< -109.292261, -9.995606, -230.088368>,
				< -104.192890, -25.214231, -208.334938>
			}
			triangle {
				< -105.035253, -3.720272, -229.801625>,
				< -109.292261, -9.995606, -230.088368>,
				< -102.082521, -19.764984, -207.851857>
			}
			triangle {
				< -99.039212, -15.238894, -207.611293>,
				< -105.035253, -3.720272, -229.801625>,
				< -102.082521, -19.764984, -207.851857>
			}
			triangle {
				< -99.764839, 0.837316, -229.845062>,
				< -105.035253, -3.720272, -229.801625>,
				< -99.039212, -15.238894, -207.611293>
			}
			triangle {
				< -95.271043, -11.946238, -207.625151>,
				< -99.764839, 0.837316, -229.845062>,
				< -99.039212, -15.238894, -207.611293>
			}
			triangle {
				< -93.841359, 3.365131, -230.206087>,
				< -99.764839, 0.837316, -229.845062>,
				< -95.271043, -11.946238, -207.625151>
			}
			triangle {
				< -91.035493, -10.112230, -207.887277>,
				< -93.841359, 3.365131, -230.206087>,
				< -95.271043, -11.946238, -207.625151>
			}
			triangle {
				< -87.669343, 3.691651, -230.852887>,
				< -93.841359, 3.365131, -230.206087>,
				< -91.035493, -10.112230, -207.887277>
			}
			triangle {
				< -86.621635, -9.861300, -208.376169>,
				< -87.669343, 3.691651, -230.852887>,
				< -91.035493, -10.112230, -207.887277>
			}
			triangle {
				< -81.669532, 1.798073, -231.738791>,
				< -87.669343, 3.691651, -230.852887>,
				< -86.621635, -9.861300, -208.376169>
			}
			triangle {
				< -82.330301, -11.208685, -209.057033>,
				< -81.669532, 1.798073, -231.738791>,
				< -86.621635, -9.861300, -208.376169>
			}
			triangle {
				< -76.250270, -2.181893, -232.806012>,
				< -81.669532, 1.798073, -231.738791>,
				< -82.330301, -11.208685, -209.057033>
			}
			triangle {
				< -78.453660, -14.060142, -209.884614>,
				< -76.250270, -2.181893, -232.806012>,
				< -82.330301, -11.208685, -209.057033>
			}
			triangle {
				< -71.779728, -7.972136, -233.988687>,
				< -76.250270, -2.181893, -232.806012>,
				< -78.453660, -14.060142, -209.884614>
			}
			triangle {
				< -75.255267, -18.218715, -210.806191>,
				< -71.779728, -7.972136, -233.988687>,
				< -78.453660, -14.060142, -209.884614>
			}
			triangle {
				< -68.561167, -15.174361, -235.215798>,
				< -71.779728, -7.972136, -233.988687>,
				< -75.255267, -18.218715, -210.806191>
			}
			triangle {
				< -72.952345, -23.399189, -211.763442>,
				< -68.561167, -15.174361, -235.215798>,
				< -75.255267, -18.218715, -210.806191>
			}
			triangle {
				< -66.812560, -23.296352, -236.413062>,
				< -68.561167, -15.174361, -235.215798>,
				< -72.952345, -23.399189, -211.763442>
			}
			triangle {
				< -71.701124, -29.247755, -212.696105>,
				< -66.812560, -23.296352, -236.413062>,
				< -72.952345, -23.399189, -211.763442>
			}
			triangle {
				< -66.652305, -31.785734, -237.505600>,
				< -66.812560, -23.296352, -236.413062>,
				< -71.701124, -29.247755, -212.696105>
			}
			triangle {
				< -71.586452, -35.366546, -213.544264>,
				< -66.652305, -31.785734, -237.505600>,
				< -71.701124, -29.247755, -212.696105>
			}
			triangle {
				< -68.091229, -40.067475, -238.421336>,
				< -66.652305, -31.785734, -237.505600>,
				< -71.586452, -35.366546, -213.544264>
			}
			triangle {
				< -72.616100, -41.340362, -214.251474>,
				< -68.091229, -40.067475, -238.421336>,
				< -71.586452, -35.366546, -213.544264>
			}
			triangle {
				< -71.031958, -47.581892, -239.095256>,
				< -68.091229, -40.067475, -238.421336>,
				< -72.616100, -41.340362, -214.251474>
			}
			triangle {
				< -74.720234, -46.764631, -214.768231>,
				< -71.031958, -47.581892, -239.095256>,
				< -72.616100, -41.340362, -214.251474>
			}
			triangle {
				< -75.275309, -53.821620, -239.474878>,
				< -71.031958, -47.581892, -239.095256>,
				< -74.720234, -46.764631, -214.768231>
			}
			triangle {
				< -77.756159, -51.272191, -215.056106>,
				< -75.275309, -53.821620, -239.474878>,
				< -74.720234, -46.764631, -214.768231>
			}
			triangle {
				< -80.533564, -58.364827, -239.525259>,
				< -75.275309, -53.821620, -239.474878>,
				< -77.756159, -51.272191, -215.056106>
			}
			triangle {
				< -81.517711, -54.557662, -215.090722>,
				< -80.533564, -58.364827, -239.525259>,
				< -77.756159, -51.272191, -215.056106>
			}
			triangle {
				< -86.449578, -60.903158, -239.233911>,
				< -80.533564, -58.364827, -239.525259>,
				< -81.517711, -54.557662, -215.090722>
			}
			triangle {
				< -85.749246, -56.397799, -214.865088>,
				< -86.449578, -60.903158, -239.233911>,
				< -81.517711, -54.557662, -215.090722>
			}
			triangle {
				< -92.620917, -61.262511, -238.613635>,
				< -86.449578, -60.903158, -239.233911>,
				< -85.749246, -56.397799, -214.865088>
			}
			triangle {
				< -90.162747, -56.666512, -214.390844>,
				< -92.620917, -61.262511, -238.613635>,
				< -85.749246, -56.397799, -214.865088>
			}
			triangle {
				< -98.626934, -59.415091, -237.704322>,
				< -92.620917, -61.262511, -238.613635>,
				< -90.162747, -56.666512, -214.390844>
			}
			triangle {
				< -94.457448, -55.343766, -213.698924>,
				< -98.626934, -59.415091, -237.704322>,
				< -90.162747, -56.666512, -214.390844>
			}
			triangle {
				< -104.057662, -55.482272, -236.570001>,
				< -98.626934, -59.415091, -237.704322>,
				< -94.457448, -55.343766, -213.698924>
			}
			triangle {
				< -98.340288, -52.517235, -212.837592>,
				< -104.057662, -55.482272, -236.570001>,
				< -94.457448, -55.343766, -213.698924>
			}
			triangle {
				< -108.541787, -49.727742, -235.294312>,
				< -104.057662, -55.482272, -236.570001>,
				< -98.340288, -52.517235, -212.837592>
			}
			triangle {
				< -101.546027, -48.377253, -211.868778>,
				< -108.541787, -49.727742, -235.294312>,
				< -98.340288, -52.517235, -212.837592>
			}
			triangle {
				< -118.309975, -35.719384, -264.115572>,
				< -114.411518, -43.849200, -265.548140>,
				< -108.541787, -49.727742, -235.294312>
			}
			triangle {
				< -111.772574, -42.539950, -233.973414>,
				< -118.309975, -35.719384, -264.115572>,
				< -108.541787, -49.727742, -235.294312>
			}
			triangle {
				< -120.428964, -26.525447, -262.753218>,
				< -118.309975, -35.719384, -264.115572>,
				< -111.772574, -42.539950, -233.973414>
			}
			triangle {
				< -113.528609, -34.407392, -232.706666>,
				< -120.428964, -26.525447, -262.753218>,
				< -111.772574, -42.539950, -233.973414>
			}
			triangle {
				< -120.623201, -16.894886, -261.563927>,
				< -120.428964, -26.525447, -262.753218>,
				< -113.528609, -34.407392, -232.706666>
			}
			triangle {
				< -113.689594, -25.885208, -231.587529>,
				< -120.623201, -16.894886, -261.563927>,
				< -113.528609, -34.407392, -232.706666>
			}
			triangle {
				< -118.879408, -7.487832, -260.632873>,
				< -120.623201, -16.894886, -261.563927>,
				< -113.689594, -25.885208, -231.587529>
			}
			triangle {
				< -112.244472, -17.557248, -230.695203>,
				< -118.879408, -7.487832, -260.632873>,
				< -113.689594, -25.885208, -231.587529>
			}
			triangle {
				< -115.317084, 1.048791, -260.019869>,
				< -118.879408, -7.487832, -260.632873>,
				< -112.244472, -17.557248, -230.695203>
			}
			triangle {
				< -109.292261, -9.995606, -230.088368>,
				< -115.317084, 1.048791, -260.019869>,
				< -112.244472, -17.557248, -230.695203>
			}
			triangle {
				< -110.180408, 8.126972, -259.756565>,
				< -115.317084, 1.048791, -260.019869>,
				< -109.292261, -9.995606, -230.088368>
			}
			triangle {
				< -105.035253, -3.720272, -229.801625>,
				< -110.180408, 8.126972, -259.756565>,
				< -109.292261, -9.995606, -230.088368>
			}
			triangle {
				< -103.821129, 13.259051, -259.847134>,
				< -110.180408, 8.126972, -259.756565>,
				< -105.035253, -3.720272, -229.801625>
			}
			triangle {
				< -99.764839, 0.837316, -229.845062>,
				< -103.821129, 13.259051, -259.847134>,
				< -105.035253, -3.720272, -229.801625>
			}
			triangle {
				< -96.674226, 16.093561, -260.271102>,
				< -103.821129, 13.259051, -259.847134>,
				< -99.764839, 0.837316, -229.845062>
			}
			triangle {
				< -93.841359, 3.365131, -230.206087>,
				< -96.674226, 16.093561, -260.271102>,
				< -99.764839, 0.837316, -229.845062>
			}
			triangle {
				< -89.227825, 16.437778, -260.989726>,
				< -96.674226, 16.093561, -260.271102>,
				< -93.841359, 3.365131, -230.206087>
			}
			triangle {
				< -87.669343, 3.691651, -230.852887>,
				< -89.227825, 16.437778, -260.989726>,
				< -93.841359, 3.365131, -230.206087>
			}
			triangle {
				< -81.989683, 14.272576, -261.950552>,
				< -89.227825, 16.437778, -260.989726>,
				< -87.669343, 3.691651, -230.852887>
			}
			triangle {
				< -81.669532, 1.798073, -231.738791>,
				< -81.989683, 14.272576, -261.950552>,
				< -87.669343, 3.691651, -230.852887>
			}
			triangle {
				< -75.452372, 9.751882, -263.092458>,
				< -81.989683, 14.272576, -261.950552>,
				< -81.669532, 1.798073, -231.738791>
			}
			triangle {
				< -76.250270, -2.181893, -232.806012>,
				< -75.452372, 9.751882, -263.092458>,
				< -81.669532, 1.798073, -231.738791>
			}
			triangle {
				< -70.059843, 3.189842, -264.348060>,
				< -75.452372, 9.751882, -263.092458>,
				< -76.250270, -2.181893, -232.806012>
			}
			triangle {
				< -71.779728, -7.972136, -233.988687>,
				< -70.059843, 3.189842, -264.348060>,
				< -76.250270, -2.181893, -232.806012>
			}
			triangle {
				< -66.177666, -4.961073, -265.645683>,
				< -70.059843, 3.189842, -264.348060>,
				< -71.779728, -7.972136, -233.988687>
			}
			triangle {
				< -68.561167, -15.174361, -235.215798>,
				< -66.177666, -4.961073, -265.645683>,
				< -71.779728, -7.972136, -233.988687>
			}
			triangle {
				< -64.068660, -14.143330, -266.910315>,
				< -66.177666, -4.961073, -265.645683>,
				< -68.561167, -15.174361, -235.215798>
			}
			triangle {
				< -66.812560, -23.296352, -236.413062>,
				< -64.068660, -14.143330, -266.910315>,
				< -68.561167, -15.174361, -235.215798>
			}
			triangle {
				< -63.875370, -23.732526, -268.065274>,
				< -64.068660, -14.143330, -266.910315>,
				< -66.812560, -23.296352, -236.413062>
			}
			triangle {
				< -66.652305, -31.785734, -237.505600>,
				< -63.875370, -23.732526, -268.065274>,
				< -66.812560, -23.296352, -236.413062>
			}
			triangle {
				< -65.610886, -33.079602, -269.034624>,
				< -63.875370, -23.732526, -268.065274>,
				< -66.652305, -31.785734, -237.505600>
			}
			triangle {
				< -68.091229, -40.067475, -238.421336>,
				< -65.610886, -33.079602, -269.034624>,
				< -66.652305, -31.785734, -237.505600>
			}
			triangle {
				< -69.157861, -41.553743, -269.748360>,
				< -65.610886, -33.079602, -269.034624>,
				< -68.091229, -40.067475, -238.421336>
			}
			triangle {
				< -71.031958, -47.581892, -239.095256>,
				< -69.157861, -41.553743, -269.748360>,
				< -68.091229, -40.067475, -238.421336>
			}
			triangle {
				< -74.276313, -48.583735, -270.147622>,
				< -69.157861, -41.553743, -269.748360>,
				< -71.031958, -47.581892, -239.095256>
			}
			triangle {
				< -75.275309, -53.821620, -239.474878>,
				< -74.276313, -48.583735, -270.147622>,
				< -71.031958, -47.581892, -239.095256>
			}
			triangle {
				< -80.619305, -53.695038, -270.192176>,
				< -74.276313, -48.583735, -270.147622>,
				< -75.275309, -53.821620, -239.474878>
			}
			triangle {
				< -80.533564, -58.364827, -239.525259>,
				< -80.619305, -53.695038, -270.192176>,
				< -75.275309, -53.821620, -239.474878>
			}
			triangle {
				< -87.756276, -56.541152, -269.865870>,
				< -80.619305, -53.695038, -270.192176>,
				< -80.533564, -58.364827, -239.525259>
			}
			triangle {
				< -86.449578, -60.903158, -239.233911>,
				< -87.756276, -56.541152, -269.865870>,
				< -80.533564, -58.364827, -239.525259>
			}
			triangle {
				< -95.201746, -56.926738, -269.181550>,
				< -87.756276, -56.541152, -269.865870>,
				< -86.449578, -60.903158, -239.233911>
			}
			triangle {
				< -92.620917, -61.262511, -238.613635>,
				< -95.201746, -56.926738, -269.181550>,
				< -86.449578, -60.903158, -239.233911>
			}
			triangle {
				< -102.448188, -54.821450, -268.182278>,
				< -95.201746, -56.926738, -269.181550>,
				< -92.620917, -61.262511, -238.613635>
			}
			triangle {
				< -98.626934, -59.415091, -237.704322>,
				< -102.448188, -54.821450, -268.182278>,
				< -92.620917, -61.262511, -238.613635>
			}
			triangle {
				< -109.000847, -50.362896, -266.939700>,
				< -102.448188, -54.821450, -268.182278>,
				< -98.626934, -59.415091, -237.704322>
			}
			triangle {
				< -104.057662, -55.482272, -236.570001>,
				< -109.000847, -50.362896, -266.939700>,
				< -98.626934, -59.415091, -237.704322>
			}
			triangle {
				< -114.411518, -43.849200, -265.548140>,
				< -109.000847, -50.362896, -266.939700>,
				< -104.057662, -55.482272, -236.570001>
			}
			triangle {
				< -108.541787, -49.727742, -235.294312>,
				< -114.411518, -43.849200, -265.548140>,
				< -104.057662, -55.482272, -236.570001>
			}
			triangle {
				< -122.916490, -30.116098, -299.600184>,
				< -118.645959, -38.774546, -300.983161>,
				< -114.411518, -43.849200, -265.548140>
			}
			triangle {
				< -118.309975, -35.719384, -264.115572>,
				< -122.916490, -30.116098, -299.600184>,
				< -114.411518, -43.849200, -265.548140>
			}
			triangle {
				< -125.237688, -20.331858, -298.294127>,
				< -122.916490, -30.116098, -299.600184>,
				< -118.309975, -35.719384, -264.115572>
			}
			triangle {
				< -120.428964, -26.525447, -262.753218>,
				< -125.237688, -20.331858, -298.294127>,
				< -118.309975, -35.719384, -264.115572>
			}
			triangle {
				< -125.450462, -10.089270, -297.165751>,
				< -125.237688, -20.331858, -298.294127>,
				< -120.428964, -26.525447, -262.753218>
			}
			triangle {
				< -120.623201, -16.894886, -261.563927>,
				< -125.450462, -10.089270, -297.165751>,
				< -120.428964, -26.525447, -262.753218>
			}
			triangle {
				< -123.540267, -0.090371, -296.296269>,
				< -125.450462, -10.089270, -297.165751>,
				< -120.623201, -16.894886, -261.563927>
			}
			triangle {
				< -118.879408, -7.487832, -260.632873>,
				< -123.540267, -0.090371, -296.296269>,
				< -120.623201, -16.894886, -261.563927>
			}
			triangle {
				< -119.637989, 8.977114, -295.740068>,
				< -123.540267, -0.090371, -296.296269>,
				< -118.879408, -7.487832, -260.632873>
			}
			triangle {
				< -115.317084, 1.048791, -260.019869>,
				< -119.637989, 8.977114, -295.740068>,
				< -118.879408, -7.487832, -260.632873>
			}
			triangle {
				< -114.010967, 16.488137, -295.522898>,
				< -119.637989, 8.977114, -295.740068>,
				< -115.317084, 1.048791, -260.019869>
			}
			triangle {
				< -110.180408, 8.126972, -259.756565>,
				< -114.010967, 16.488137, -295.522898>,
				< -115.317084, 1.048791, -260.019869>
			}
			triangle {
				< -107.044466, 21.925420, -295.642614>,
				< -114.010967, 16.488137, -295.522898>,
				< -110.180408, 8.126972, -259.756565>
			}
			triangle {
				< -103.821129, 13.259051, -259.847134>,
				< -107.044466, 21.925420, -295.642614>,
				< -110.180408, 8.126972, -259.756565>
			}
			triangle {
				< -99.214964, 24.915127, -296.074361>,
				< -107.044466, 21.925420, -295.642614>,
				< -103.821129, 13.259051, -259.847134>
			}
			triangle {
				< -96.674226, 16.093561, -260.271102>,
				< -99.214964, 24.915127, -296.074361>,
				< -103.821129, 13.259051, -259.847134>
			}
			triangle {
				< -91.057241, 25.254412, -296.777189>,
				< -99.214964, 24.915127, -296.074361>,
				< -96.674226, 16.093561, -260.271102>
			}
			triangle {
				< -89.227825, 16.437778, -260.989726>,
				< -91.057241, 25.254412, -296.777189>,
				< -96.674226, 16.093561, -260.271102>
			}
			triangle {
				< -83.127536, 22.924250, -297.699392>,
				< -91.057241, 25.254412, -296.777189>,
				< -89.227825, 16.437778, -260.989726>
			}
			triangle {
				< -81.989683, 14.272576, -261.950552>,
				< -83.127536, 22.924250, -297.699392>,
				< -89.227825, 16.437778, -260.989726>
			}
			triangle {
				< -75.965531, 18.090490, -298.783839>,
				< -83.127536, 22.924250, -297.699392>,
				< -81.989683, 14.272576, -261.950552>
			}
			triangle {
				< -75.452372, 9.751882, -263.092458>,
				< -75.965531, 18.090490, -298.783839>,
				< -81.989683, 14.272576, -261.950552>
			}
			triangle {
				< -70.057712, 11.089744, -299.969614>,
				< -75.965531, 18.090490, -298.783839>,
				< -75.452372, 9.751882, -263.092458>
			}
			triangle {
				< -70.059843, 3.189842, -264.348060>,
				< -70.057712, 11.089744, -299.969614>,
				< -75.452372, 9.751882, -263.092458>
			}
			triangle {
				< -65.804608, 2.405249, -301.192671>,
				< -70.057712, 11.089744, -299.969614>,
				< -70.059843, 3.189842, -264.348060>
			}
			triangle {
				< -66.177666, -4.961073, -265.645683>,
				< -65.804608, 2.405249, -301.192671>,
				< -70.059843, 3.189842, -264.348060>
			}
			triangle {
				< -63.494042, -7.369096, -302.385718>,
				< -65.804608, 2.405249, -301.192671>,
				< -66.177666, -4.961073, -265.645683>
			}
			triangle {
				< -64.068660, -14.143330, -266.910315>,
				< -63.494042, -7.369096, -302.385718>,
				< -66.177666, -4.961073, -265.645683>
			}
			triangle {
				< -63.282289, -17.568206, -303.477973>,
				< -63.494042, -7.369096, -302.385718>,
				< -64.068660, -14.143330, -266.910315>
			}
			triangle {
				< -63.875370, -23.732526, -268.065274>,
				< -63.282289, -17.568206, -303.477973>,
				< -64.068660, -14.143330, -266.910315>
			}
			triangle {
				< -65.183632, -27.501656, -304.398298>,
				< -63.282289, -17.568206, -303.477973>,
				< -63.875370, -23.732526, -268.065274>
			}
			triangle {
				< -65.610886, -33.079602, -269.034624>,
				< -65.183632, -27.501656, -304.398298>,
				< -63.875370, -23.732526, -268.065274>
			}
			triangle {
				< -69.069535, -36.499400, -305.078268>,
				< -65.183632, -27.501656, -304.398298>,
				< -65.610886, -33.079602, -269.034624>
			}
			triangle {
				< -69.157861, -41.553743, -269.748360>,
				< -69.069535, -36.499400, -305.078268>,
				< -65.610886, -33.079602, -269.034624>
			}
			triangle {
				< -74.677095, -43.955162, -305.459291>,
				< -69.069535, -36.499400, -305.078268>,
				< -69.157861, -41.553743, -269.748360>
			}
			triangle {
				< -74.276313, -48.583735, -270.147622>,
				< -74.677095, -43.955162, -305.459291>,
				< -69.157861, -41.553743, -269.748360>
			}
			triangle {
				< -81.626192, -49.366109, -305.499643>,
				< -74.677095, -43.955162, -305.459291>,
				< -74.276313, -48.583735, -270.147622>
			}
			triangle {
				< -80.619305, -53.695038, -270.192176>,
				< -81.626192, -49.366109, -305.499643>,
				< -74.276313, -48.583735, -270.147622>
			}
			triangle {
				< -89.445099, -52.365769, -305.180967>,
				< -81.626192, -49.366109, -305.499643>,
				< -80.619305, -53.695038, -270.192176>
			}
			triangle {
				< -87.756276, -56.541152, -269.865870>,
				< -89.445099, -52.365769, -305.180967>,
				< -80.619305, -53.695038, -270.192176>
			}
			triangle {
				< -97.601831, -52.748457, -304.514289>,
				< -89.445099, -52.365769, -305.180967>,
				< -87.756276, -56.541152, -269.865870>
			}
			triangle {
				< -95.201746, -56.926738, -269.181550>,
				< -97.601831, -52.748457, -304.514289>,
				< -87.756276, -56.541152, -269.865870>
			}
			triangle {
				< -105.540432, -50.483722, -303.541213>,
				< -97.601831, -52.748457, -304.514289>,
				< -95.201746, -56.926738, -269.181550>
			}
			triangle {
				< -102.448188, -54.821450, -268.182278>,
				< -105.540432, -50.483722, -303.541213>,
				< -95.201746, -56.926738, -269.181550>
			}
			triangle {
				< -112.718791, -45.719668, -302.332789>,
				< -105.540432, -50.483722, -303.541213>,
				< -102.448188, -54.821450, -268.182278>
			}
			triangle {
				< -109.000847, -50.362896, -266.939700>,
				< -112.718791, -45.719668, -302.332789>,
				< -102.448188, -54.821450, -268.182278>
			}
			triangle {
				< -118.645959, -38.774546, -300.983161>,
				< -112.718791, -45.719668, -302.332789>,
				< -109.000847, -50.362896, -266.939700>
			}
			triangle {
				< -114.411518, -43.849200, -265.548140>,
				< -118.645959, -38.774546, -300.983161>,
				< -109.000847, -50.362896, -266.939700>
			}
			triangle {
				< -124.221876, -23.335982, -337.733656>,
				< -120.045558, -31.620499, -338.825852>,
				< -118.645959, -38.774546, -300.983161>
			}
			triangle {
				< -122.916490, -30.116098, -299.600184>,
				< -124.221876, -23.335982, -337.733656>,
				< -118.645959, -38.774546, -300.983161>
			}
			triangle {
				< -126.491770, -13.983496, -336.710483>,
				< -124.221876, -23.335982, -337.733656>,
				< -122.916490, -30.116098, -299.600184>
			}
			triangle {
				< -125.237688, -20.331858, -298.294127>,
				< -126.491770, -13.983496, -336.710483>,
				< -122.916490, -30.116098, -299.600184>
			}
			triangle {
				< -126.699850, -4.201243, -335.832715>,
				< -126.491770, -13.983496, -336.710483>,
				< -125.237688, -20.331858, -298.294127>
			}
			triangle {
				< -125.450462, -10.089270, -297.165751>,
				< -126.699850, -4.201243, -335.832715>,
				< -125.237688, -20.331858, -298.294127>
			}
			triangle {
				< -124.831863, 5.341033, -335.162938>,
				< -126.699850, -4.201243, -335.832715>,
				< -125.450462, -10.089270, -297.165751>
			}
			triangle {
				< -123.540267, -0.090371, -296.296269>,
				< -124.831863, 5.341033, -335.162938>,
				< -125.450462, -10.089270, -297.165751>
			}
			triangle {
				< -121.015720, 13.987857, -334.745079>,
				< -124.831863, 5.341033, -335.162938>,
				< -123.540267, -0.090371, -296.296269>
			}
			triangle {
				< -119.637989, 8.977114, -295.740068>,
				< -121.015720, 13.987857, -334.745079>,
				< -123.540267, -0.090371, -296.296269>
			}
			triangle {
				< -115.512609, 21.145087, -334.601849>,
				< -121.015720, 13.987857, -334.745079>,
				< -119.637989, 8.977114, -295.740068>
			}
			triangle {
				< -114.010967, 16.488137, -295.522898>,
				< -115.512609, 21.145087, -334.601849>,
				< -119.637989, 8.977114, -295.740068>
			}
			triangle {
				< -108.699061, 26.320172, -334.734350>,
				< -115.512609, 21.145087, -334.601849>,
				< -114.010967, 16.488137, -295.522898>
			}
			triangle {
				< -107.044466, 21.925420, -295.642614>,
				< -108.699061, 26.320172, -334.734350>,
				< -114.010967, 16.488137, -295.522898>
			}
			triangle {
				< -101.040885, 29.158244, -335.125118>,
				< -108.699061, 26.320172, -334.734350>,
				< -107.044466, 21.925420, -295.642614>
			}
			triangle {
				< -99.214964, 24.915127, -296.074361>,
				< -101.040885, 29.158244, -335.125118>,
				< -107.044466, 21.925420, -295.642614>
			}
			triangle {
				< -93.060993, 29.466443, -335.740834>,
				< -101.040885, 29.158244, -335.125118>,
				< -99.214964, 24.915127, -296.074361>
			}
			triangle {
				< -91.057241, 25.254412, -296.777189>,
				< -93.060993, 29.466443, -335.740834>,
				< -99.214964, 24.915127, -296.074361>
			}
			triangle {
				< -85.303508, 27.227558, -336.536914>,
				< -93.060993, 29.466443, -335.740834>,
				< -91.057241, 25.254412, -296.777189>
			}
			triangle {
				< -83.127536, 22.924250, -297.699392>,
				< -85.303508, 27.227558, -336.536914>,
				< -91.057241, 25.254412, -296.777189>
			}
			triangle {
				< -78.296602, 22.599991, -337.461472>,
				< -85.303508, 27.227558, -336.536914>,
				< -83.127536, 22.924250, -297.699392>
			}
			triangle {
				< -75.965531, 18.090490, -298.783839>,
				< -78.296602, 22.599991, -337.461472>,
				< -83.127536, 22.924250, -297.699392>
			}
			triangle {
				< -72.516322, 15.905017, -338.457614>,
				< -78.296602, 22.599991, -337.461472>,
				< -75.965531, 18.090490, -298.783839>
			}
			triangle {
				< -70.057712, 11.089744, -299.969614>,
				< -72.516322, 15.905017, -338.457614>,
				< -75.965531, 18.090490, -298.783839>
			}
			triangle {
				< -68.354838, 7.603807, -339.465767>,
				< -72.516322, 15.905017, -338.457614>,
				< -70.057712, 11.089744, -299.969614>
			}
			triangle {
				< -65.804608, 2.405249, -301.192671>,
				< -68.354838, 7.603807, -339.465767>,
				< -70.057712, 11.089744, -299.969614>
			}
			triangle {
				< -66.094004, -1.736740, -340.425670>,
				< -68.354838, 7.603807, -339.465767>,
				< -65.804608, 2.405249, -301.192671>
			}
			triangle {
				< -63.494042, -7.369096, -302.385718>,
				< -66.094004, -1.736740, -340.425670>,
				< -65.804608, 2.405249, -301.192671>
			}
			triangle {
				< -65.886796, -11.481416, -341.277927>,
				< -66.094004, -1.736740, -340.425670>,
				< -63.494042, -7.369096, -302.385718>
			}
			triangle {
				< -63.282289, -17.568206, -303.477973>,
				< -65.886796, -11.481416, -341.277927>,
				< -63.494042, -7.369096, -302.385718>
			}
			triangle {
				< -67.747250, -20.970488, -341.966748>,
				< -65.886796, -11.481416, -341.277927>,
				< -63.282289, -17.568206, -303.477973>
			}
			triangle {
				< -65.183632, -27.501656, -304.398298>,
				< -67.747250, -20.970488, -341.966748>,
				< -63.282289, -17.568206, -303.477973>
			}
			triangle {
				< -71.549468, -29.563053, -342.443019>,
				< -67.747250, -20.970488, -341.966748>,
				< -65.183632, -27.501656, -304.398298>
			}
			triangle {
				< -69.069535, -36.499400, -305.078268>,
				< -71.549468, -29.563053, -342.443019>,
				< -65.183632, -27.501656, -304.398298>
			}
			triangle {
				< -77.036001, -36.679003, -342.668563>,
				< -71.549468, -29.563053, -342.443019>,
				< -69.069535, -36.499400, -305.078268>
			}
			triangle {
				< -74.677095, -43.955162, -305.459291>,
				< -77.036001, -36.679003, -342.668563>,
				< -69.069535, -36.499400, -305.078268>
			}
			triangle {
				< -83.834760, -41.837160, -342.620045>,
				< -77.036001, -36.679003, -342.668563>,
				< -74.677095, -43.955162, -305.459291>
			}
			triangle {
				< -81.626192, -49.366109, -305.499643>,
				< -83.834760, -41.837160, -342.620045>,
				< -74.677095, -43.955162, -305.459291>
			}
			triangle {
				< -91.483913, -44.687044, -342.292577>,
				< -83.834760, -41.837160, -342.620045>,
				< -81.626192, -49.366109, -305.499643>
			}
			triangle {
				< -89.445099, -52.365769, -305.180967>,
				< -91.483913, -44.687044, -342.292577>,
				< -81.626192, -49.366109, -305.499643>
			}
			triangle {
				< -99.462941, -45.032840, -341.702521>,
				< -91.483913, -44.687044, -342.292577>,
				< -89.445099, -52.365769, -305.180967>
			}
			triangle {
				< -97.601831, -52.748457, -304.514289>,
				< -99.462941, -45.032840, -341.702521>,
				< -89.445099, -52.365769, -305.180967>
			}
			triangle {
				< -107.227959, -42.847157, -340.887249>,
				< -99.462941, -45.032840, -341.702521>,
				< -97.601831, -52.748457, -304.514289>
			}
			triangle {
				< -105.540432, -50.483722, -303.541213>,
				< -107.227959, -42.847157, -340.887249>,
				< -97.601831, -52.748457, -304.514289>
			}
			triangle {
				< -114.248827, -38.274094, -339.904189>,
				< -107.227959, -42.847157, -340.887249>,
				< -105.540432, -50.483722, -303.541213>
			}
			triangle {
				< -112.718791, -45.719668, -302.332789>,
				< -114.248827, -38.274094, -339.904189>,
				< -105.540432, -50.483722, -303.541213>
			}
			triangle {
				< -120.045558, -31.620499, -338.825852>,
				< -114.248827, -38.274094, -339.904189>,
				< -112.718791, -45.719668, -302.332789>
			}
			triangle {
				< -118.645959, -38.774546, -300.983161>,
				< -120.045558, -31.620499, -338.825852>,
				< -112.718791, -45.719668, -302.332789>
			}
			triangle {
				< -125.633374, -20.462872, -376.293123>,
				< -121.805176, -28.835643, -377.164274>,
				< -120.045558, -31.620499, -338.825852>
			}
			triangle {
				< -124.221876, -23.335982, -337.733656>,
				< -125.633374, -20.462872, -376.293123>,
				< -120.045558, -31.620499, -338.825852>
			}
			triangle {
				< -127.713963, -11.019763, -375.477970>,
				< -125.633374, -20.462872, -376.293123>,
				< -124.221876, -23.335982, -337.733656>
			}
			triangle {
				< -126.491770, -13.983496, -336.710483>,
				< -127.713963, -11.019763, -375.477970>,
				< -124.221876, -23.335982, -337.733656>
			}
			triangle {
				< -127.904668, -1.150242, -374.779820>,
				< -127.713963, -11.019763, -375.477970>,
				< -126.491770, -13.983496, -336.710483>
			}
			triangle {
				< -126.699850, -4.201243, -335.832715>,
				< -127.904668, -1.150242, -374.779820>,
				< -126.491770, -13.983496, -336.710483>
			}
			triangle {
				< -126.192510, 8.470667, -374.248326>,
				< -127.904668, -1.150242, -374.779820>,
				< -126.699850, -4.201243, -335.832715>
			}
			triangle {
				< -124.831863, 5.341033, -335.162938>,
				< -126.192510, 8.470667, -374.248326>,
				< -126.699850, -4.201243, -335.832715>
			}
			triangle {
				< -122.694500, 17.182760, -373.918146>,
				< -126.192510, 8.470667, -374.248326>,
				< -124.831863, 5.341033, -335.162938>
			}
			triangle {
				< -121.015720, 13.987857, -334.745079>,
				< -122.694500, 17.182760, -373.918146>,
				< -124.831863, 5.341033, -335.162938>
			}
			triangle {
				< -117.649853, 24.388101, -373.806149>,
				< -122.694500, 17.182760, -373.918146>,
				< -121.015720, 13.987857, -334.745079>
			}
			triangle {
				< -115.512609, 21.145087, -334.601849>,
				< -117.649853, 24.388101, -373.806149>,
				< -121.015720, 13.987857, -334.745079>
			}
			triangle {
				< -111.403331, 29.590914, -373.912901>,
				< -117.649853, 24.388101, -373.806149>,
				< -115.512609, 21.145087, -334.601849>
			}
			triangle {
				< -108.699061, 26.320172, -334.734350>,
				< -111.403331, 29.590914, -373.912901>,
				< -115.512609, 21.145087, -334.601849>
			}
			triangle {
				< -104.381740, 32.434151, -374.223202>,
				< -111.403331, 29.590914, -373.912901>,
				< -108.699061, 26.320172, -334.734350>
			}
			triangle {
				< -101.040885, 29.158244, -335.125118>,
				< -104.381740, 32.434151, -374.223202>,
				< -108.699061, 26.320172, -334.734350>
			}
			triangle {
				< -97.064324, 32.724354, -374.710768>,
				< -104.381740, 32.434151, -374.223202>,
				< -101.040885, 29.158244, -335.125118>
			}
			triangle {
				< -93.060993, 29.466443, -335.740834>,
				< -97.064324, 32.724354, -374.710768>,
				< -101.040885, 29.158244, -335.125118>
			}
			triangle {
				< -89.950025, 30.444678, -375.340015>,
				< -97.064324, 32.724354, -374.710768>,
				< -93.060993, 29.466443, -335.740834>
			}
			triangle {
				< -85.303508, 27.227558, -336.536914>,
				< -89.950025, 30.444678, -375.340015>,
				< -93.060993, 29.466443, -335.740834>
			}
			triangle {
				< -83.523236, 25.755454, -376.070648>,
				< -89.950025, 30.444678, -375.340015>,
				< -85.303508, 27.227558, -336.536914>
			}
			triangle {
				< -78.296602, 22.599991, -337.461472>,
				< -83.523236, 25.755454, -376.070648>,
				< -85.303508, 27.227558, -336.536914>
			}
			triangle {
				< -78.221038, 18.981954, -376.858234>,
				< -83.523236, 25.755454, -376.070648>,
				< -78.296602, 22.599991, -337.461472>
			}
			triangle {
				< -72.516322, 15.905017, -338.457614>,
				< -78.221038, 18.981954, -376.858234>,
				< -78.296602, 22.599991, -337.461472>
			}
			triangle {
				< -74.403450, 10.589892, -377.656609>,
				< -78.221038, 18.981954, -376.858234>,
				< -72.516322, 15.905017, -338.457614>
			}
			triangle {
				< -68.354838, 7.603807, -339.465767>,
				< -74.403450, 10.589892, -377.656609>,
				< -72.516322, 15.905017, -338.457614>
			}
			triangle {
				< -72.329305, 1.153640, -378.418595>,
				< -74.403450, 10.589892, -377.656609>,
				< -68.354838, 7.603807, -339.465767>
			}
			triangle {
				< -66.094004, -1.736740, -340.425670>,
				< -72.329305, 1.153640, -378.418595>,
				< -68.354838, 7.603807, -339.465767>
			}
			triangle {
				< -72.139218, -8.685425, -379.097342>,
				< -72.329305, 1.153640, -378.418595>,
				< -66.094004, -1.736740, -340.425670>
			}
			triangle {
				< -65.886796, -11.481416, -341.277927>,
				< -72.139218, -8.685425, -379.097342>,
				< -66.094004, -1.736740, -340.425670>
			}
			triangle {
				< -73.846042, -18.260090, -379.648268>,
				< -72.139218, -8.685425, -379.097342>,
				< -65.886796, -11.481416, -341.277927>
			}
			triangle {
				< -67.747250, -20.970488, -341.966748>,
				< -73.846042, -18.260090, -379.648268>,
				< -65.886796, -11.481416, -341.277927>
			}
			triangle {
				< -77.334106, -26.922924, -380.031586>,
				< -73.846042, -18.260090, -379.648268>,
				< -67.747250, -20.970488, -341.966748>
			}
			triangle {
				< -71.549468, -29.563053, -342.443019>,
				< -77.334106, -26.922924, -380.031586>,
				< -67.747250, -20.970488, -341.966748>
			}
			triangle {
				< -82.366951, -34.088459, -380.216241>,
				< -77.334106, -26.922924, -380.031586>,
				< -71.549468, -29.563053, -342.443019>
			}
			triangle {
				< -77.036001, -36.679003, -342.668563>,
				< -82.366951, -34.088459, -380.216241>,
				< -71.549468, -29.563053, -342.443019>
			}
			triangle {
				< -88.602901, -39.272100, -380.182266>,
				< -82.366951, -34.088459, -380.216241>,
				< -77.036001, -36.679003, -342.668563>
			}
			triangle {
				< -83.834760, -41.837160, -342.620045>,
				< -88.602901, -39.272100, -380.182266>,
				< -77.036001, -36.679003, -342.668563>
			}
			triangle {
				< -95.618084, -42.121839, -379.925162>,
				< -88.602901, -39.272100, -380.182266>,
				< -83.834760, -41.837160, -342.620045>
			}
			triangle {
				< -91.483913, -44.687044, -342.292577>,
				< -95.618084, -42.121839, -379.925162>,
				< -83.834760, -41.837160, -342.620045>
			}
			triangle {
				< -102.934882, -42.442467, -379.457146>,
				< -95.618084, -42.121839, -379.925162>,
				< -91.483913, -44.687044, -342.292577>
			}
			triangle {
				< -99.462941, -45.032840, -341.702521>,
				< -102.934882, -42.442467, -379.457146>,
				< -91.483913, -44.687044, -342.292577>
			}
			triangle {
				< -110.054612, -40.208988, -378.808290>,
				< -102.934882, -42.442467, -379.457146>,
				< -99.462941, -45.032840, -341.702521>
			}
			triangle {
				< -107.227959, -42.847157, -340.887249>,
				< -110.054612, -40.208988, -378.808290>,
				< -99.462941, -45.032840, -341.702521>
			}
			triangle {
				< -116.491295, -35.569403, -378.024489>,
				< -110.054612, -40.208988, -378.808290>,
				< -107.227959, -42.847157, -340.887249>
			}
			triangle {
				< -114.248827, -38.274094, -339.904189>,
				< -116.491295, -35.569403, -378.024489>,
				< -107.227959, -42.847157, -340.887249>
			}
			triangle {
				< -121.805176, -28.835643, -377.164274>,
				< -116.491295, -35.569403, -378.024489>,
				< -114.248827, -38.274094, -339.904189>
			}
			triangle {
				< -120.045558, -31.620499, -338.825852>,
				< -121.805176, -28.835643, -377.164274>,
				< -114.248827, -38.274094, -339.904189>
			}
			triangle {
				< -125.301942, -18.214691, -412.300348>,
				< -121.683136, -26.957417, -412.932634>,
				< -121.805176, -28.835643, -377.164274>
			}
			triangle {
				< -125.633374, -20.462872, -376.293123>,
				< -125.301942, -18.214691, -412.300348>,
				< -121.805176, -28.835643, -377.164274>
			}
			triangle {
				< -127.268657, -8.362569, -411.707461>,
				< -125.301942, -18.214691, -412.300348>,
				< -125.633374, -20.462872, -376.293123>
			}
			triangle {
				< -127.713963, -11.019763, -375.477970>,
				< -127.268657, -8.362569, -411.707461>,
				< -125.633374, -20.462872, -376.293123>
			}
			triangle {
				< -127.448931, 1.927612, -411.199152>,
				< -127.268657, -8.362569, -411.707461>,
				< -127.713963, -11.019763, -375.477970>
			}
			triangle {
				< -127.904668, -1.150242, -374.779820>,
				< -127.448931, 1.927612, -411.199152>,
				< -127.713963, -11.019763, -375.477970>
			}
			triangle {
				< -125.830516, 11.952561, -410.810918>,
				< -127.448931, 1.927612, -411.199152>,
				< -127.904668, -1.150242, -374.779820>
			}
			triangle {
				< -126.192510, 8.470667, -374.248326>,
				< -125.830516, 11.952561, -410.810918>,
				< -127.904668, -1.150242, -374.779820>
			}
			triangle {
				< -122.523814, 21.026179, -410.568327>,
				< -125.830516, 11.952561, -410.810918>,
				< -126.192510, 8.470667, -374.248326>
			}
			triangle {
				< -122.694500, 17.182760, -373.918146>,
				< -122.523814, 21.026179, -410.568327>,
				< -126.192510, 8.470667, -374.248326>
			}
			triangle {
				< -117.754802, 28.525533, -410.483301>,
				< -122.523814, 21.026179, -410.568327>,
				< -122.694500, 17.182760, -373.918146>
			}
			triangle {
				< -117.649853, 24.388101, -373.806149>,
				< -117.754802, 28.525533, -410.483301>,
				< -122.694500, 17.182760, -373.918146>
			}
			triangle {
				< -111.849062, 33.935551, -410.555989>,
				< -117.754802, 28.525533, -410.483301>,
				< -117.649853, 24.388101, -373.806149>
			}
			triangle {
				< -111.403331, 29.590914, -373.912901>,
				< -111.849062, 33.935551, -410.555989>,
				< -117.649853, 24.388101, -373.806149>
			}
			triangle {
				< -105.209768, 36.884978, -410.775959>,
				< -111.849062, 33.935551, -410.555989>,
				< -111.403331, 29.590914, -373.912901>
			}
			triangle {
				< -104.381740, 32.434151, -374.223202>,
				< -105.209768, 36.884978, -410.775959>,
				< -111.403331, 29.590914, -373.912901>
			}
			triangle {
				< -98.289862, 37.172683, -411.124259>,
				< -105.209768, 36.884978, -410.775959>,
				< -104.381740, 32.434151, -374.223202>
			}
			triangle {
				< -97.064324, 32.724354, -374.710768>,
				< -98.289862, 37.172683, -411.124259>,
				< -104.381740, 32.434151, -374.223202>
			}
			triangle {
				< -91.561131, 34.781262, -411.575794>,
				< -98.289862, 37.172683, -411.124259>,
				< -97.064324, 32.724354, -374.710768>
			}
			triangle {
				< -89.950025, 30.444678, -375.340015>,
				< -91.561131, 34.781262, -411.575794>,
				< -97.064324, 32.724354, -374.710768>
			}
			triangle {
				< -85.481919, 29.877879, -412.101507>,
				< -91.561131, 34.781262, -411.575794>,
				< -89.950025, 30.444678, -375.340015>
			}
			triangle {
				< -83.523236, 25.755454, -376.070648>,
				< -85.481919, 29.877879, -412.101507>,
				< -89.950025, 30.444678, -375.340015>
			}
			triangle {
				< -80.465846, 22.801440, -412.669957>,
				< -85.481919, 29.877879, -412.101507>,
				< -83.523236, 25.755454, -376.070648>
			}
			triangle {
				< -78.221038, 18.981954, -376.858234>,
				< -80.465846, 22.801440, -412.669957>,
				< -83.523236, 25.755454, -376.070648>
			}
			triangle {
				< -76.853916, 14.038266, -413.248330>,
				< -80.465846, 22.801440, -412.669957>,
				< -78.221038, 18.981954, -376.858234>
			}
			triangle {
				< -74.403450, 10.589892, -377.656609>,
				< -76.853916, 14.038266, -413.248330>,
				< -78.221038, 18.981954, -376.858234>
			}
			triangle {
				< -74.891396, 4.187861, -413.802207>,
				< -76.853916, 14.038266, -413.248330>,
				< -74.403450, 10.589892, -377.656609>
			}
			triangle {
				< -72.329305, 1.153640, -378.418595>,
				< -74.891396, 4.187861, -413.802207>,
				< -74.403450, 10.589892, -377.656609>
			}
			triangle {
				< -74.711531, -6.079433, -414.297789>,
				< -74.891396, 4.187861, -413.802207>,
				< -72.329305, 1.153640, -378.418595>
			}
			triangle {
				< -72.139218, -8.685425, -379.097342>,
				< -74.711531, -6.079433, -414.297789>,
				< -72.329305, 1.153640, -378.418595>
			}
			triangle {
				< -76.326504, -16.066432, -414.702237>,
				< -74.711531, -6.079433, -414.297789>,
				< -72.139218, -8.685425, -379.097342>
			}
			triangle {
				< -73.846042, -18.260090, -379.648268>,
				< -76.326504, -16.066432, -414.702237>,
				< -72.139218, -8.685425, -379.097342>
			}
			triangle {
				< -79.626702, -25.096681, -414.986461>,
				< -76.326504, -16.066432, -414.702237>,
				< -73.846042, -18.260090, -379.648268>
			}
			triangle {
				< -77.334106, -26.922924, -380.031586>,
				< -79.626702, -25.096681, -414.986461>,
				< -73.846042, -18.260090, -379.648268>
			}
			triangle {
				< -84.388070, -32.559175, -415.126771>,
				< -79.626702, -25.096681, -414.986461>,
				< -77.334106, -26.922924, -380.031586>
			}
			triangle {
				< -82.366951, -34.088459, -380.216241>,
				< -84.388070, -32.559175, -415.126771>,
				< -77.334106, -26.922924, -380.031586>
			}
			triangle {
				< -90.286933, -37.948668, -415.108353>,
				< -84.388070, -32.559175, -415.126771>,
				< -82.366951, -34.088459, -380.216241>
			}
			triangle {
				< -88.602901, -39.272100, -380.182266>,
				< -90.286933, -37.948668, -415.108353>,
				< -82.366951, -34.088459, -380.216241>
			}
			triangle {
				< -96.922070, -40.899538, -414.927006>,
				< -90.286933, -37.948668, -415.108353>,
				< -88.602901, -39.272100, -380.182266>
			}
			triangle {
				< -95.618084, -42.121839, -379.925162>,
				< -96.922070, -40.899538, -414.927006>,
				< -88.602901, -39.272100, -380.182266>
			}
			triangle {
				< -103.841588, -41.210100, -414.591759>,
				< -96.922070, -40.899538, -414.927006>,
				< -95.618084, -42.121839, -379.925162>
			}
			triangle {
				< -102.934882, -42.442467, -379.457146>,
				< -103.841588, -41.210100, -414.591759>,
				< -95.618084, -42.121839, -379.925162>
			}
			triangle {
				< -110.573821, -38.856924, -414.123684>,
				< -103.841588, -41.210100, -414.591759>,
				< -102.934882, -42.442467, -379.457146>
			}
			triangle {
				< -110.054612, -40.208988, -378.808290>,
				< -110.573821, -38.856924, -414.123684>,
				< -102.934882, -42.442467, -379.457146>
			}
			triangle {
				< -116.659500, -33.996869, -413.556486>,
				< -110.573821, -38.856924, -414.123684>,
				< -110.054612, -40.208988, -378.808290>
			}
			triangle {
				< -116.491295, -35.569403, -378.024489>,
				< -116.659500, -33.996869, -413.556486>,
				< -110.054612, -40.208988, -378.808290>
			}
			triangle {
				< -121.683136, -26.957417, -412.932634>,
				< -116.659500, -33.996869, -413.556486>,
				< -116.491295, -35.569403, -378.024489>
			}
			triangle {
				< -121.805176, -28.835643, -377.164274>,
				< -121.683136, -26.957417, -412.932634>,
				< -116.491295, -35.569403, -378.024489>
			}
			triangle {
				< -126.217321, -16.271809, -443.283468>,
				< -122.460142, -24.671378, -443.738192>,
				< -121.683136, -26.957417, -412.932634>
			}
			triangle {
				< -125.301942, -18.214691, -412.300348>,
				< -126.217321, -16.271809, -443.283468>,
				< -121.683136, -26.957417, -412.932634>
			}
			triangle {
				< -128.259137, -6.811728, -442.857653>,
				< -126.217321, -16.271809, -443.283468>,
				< -125.301942, -18.214691, -412.300348>
			}
			triangle {
				< -127.268657, -8.362569, -411.707461>,
				< -128.259137, -6.811728, -442.857653>,
				< -125.301942, -18.214691, -412.300348>
			}
			triangle {
				< -128.446311, 3.064760, -442.494154>,
				< -128.259137, -6.811728, -442.857653>,
				< -127.268657, -8.362569, -411.707461>
			}
			triangle {
				< -127.448931, 1.927612, -411.199152>,
				< -128.446311, 3.064760, -442.494154>,
				< -127.268657, -8.362569, -411.707461>
			}
			triangle {
				< -126.766041, 12.683189, -442.219049>,
				< -128.446311, 3.064760, -442.494154>,
				< -127.448931, 1.927612, -411.199152>
			}
			triangle {
				< -125.830516, 11.952561, -410.810918>,
				< -126.766041, 12.683189, -442.219049>,
				< -127.448931, 1.927612, -411.199152>
			}
			triangle {
				< -123.332992, 21.385878, -442.048281>,
				< -126.766041, 12.683189, -442.219049>,
				< -125.830516, 11.952561, -410.810918>
			}
			triangle {
				< -122.523814, 21.026179, -410.568327>,
				< -123.332992, 21.385878, -442.048281>,
				< -125.830516, 11.952561, -410.810918>
			}
			triangle {
				< -118.381388, 28.575711, -441.987336>,
				< -123.332992, 21.385878, -442.048281>,
				< -122.523814, 21.026179, -410.568327>
			}
			triangle {
				< -117.754802, 28.525533, -410.483301>,
				< -118.381388, 28.575711, -441.987336>,
				< -122.523814, 21.026179, -410.568327>
			}
			triangle {
				< -112.249106, 33.759113, -442.032903>,
				< -118.381388, 28.575711, -441.987336>,
				< -117.754802, 28.525533, -410.483301>
			}
			triangle {
				< -111.849062, 33.935551, -410.555989>,
				< -112.249106, 33.759113, -442.032903>,
				< -117.754802, 28.525533, -410.483301>
			}
			triangle {
				< -105.354428, 36.580425, -442.174345>,
				< -112.249106, 33.759113, -442.032903>,
				< -111.849062, 33.935551, -410.555989>
			}
			triangle {
				< -105.209768, 36.884978, -410.775959>,
				< -105.354428, 36.580425, -442.174345>,
				< -111.849062, 33.935551, -410.555989>
			}
			triangle {
				< -98.167591, 36.846679, -442.397594>,
				< -105.354428, 36.580425, -442.174345>,
				< -105.209768, 36.884978, -410.775959>
			}
			triangle {
				< -98.289862, 37.172683, -411.124259>,
				< -98.167591, 36.846679, -442.397594>,
				< -105.209768, 36.884978, -410.775959>
			}
			triangle {
				< -91.178462, 34.541056, -442.686379>,
				< -98.167591, 36.846679, -442.397594>,
				< -98.289862, 37.172683, -411.124259>
			}
			triangle {
				< -91.561131, 34.781262, -411.575794>,
				< -91.178462, 34.541056, -442.686379>,
				< -98.289862, 37.172683, -411.124259>
			}
			triangle {
				< -84.863216, 29.823760, -443.024099>,
				< -91.178462, 34.541056, -442.686379>,
				< -91.561131, 34.781262, -411.575794>
			}
			triangle {
				< -85.481919, 29.877879, -412.101507>,
				< -84.863216, 29.823760, -443.024099>,
				< -91.561131, 34.781262, -411.575794>
			}
			triangle {
				< -79.651833, 23.020053, -443.393975>,
				< -84.863216, 29.823760, -443.024099>,
				< -85.481919, 29.877879, -412.101507>
			}
			triangle {
				< -80.465846, 22.801440, -412.669957>,
				< -79.651833, 23.020053, -443.393975>,
				< -85.481919, 29.877879, -412.101507>
			}
			triangle {
				< -75.898953, 14.597363, -443.778634>,
				< -79.651833, 23.020053, -443.393975>,
				< -80.465846, 22.801440, -412.669957>
			}
			triangle {
				< -76.853916, 14.038266, -413.248330>,
				< -75.898953, 14.597363, -443.778634>,
				< -80.465846, 22.801440, -412.669957>
			}
			triangle {
				< -73.859714, 5.132178, -444.158643>,
				< -75.898953, 14.597363, -443.778634>,
				< -76.853916, 14.038266, -413.248330>
			}
			triangle {
				< -74.891396, 4.187861, -413.802207>,
				< -73.859714, 5.132178, -444.158643>,
				< -76.853916, 14.038266, -413.248330>
			}
			triangle {
				< -73.672809, -4.730557, -444.512695>,
				< -73.859714, 5.132178, -444.158643>,
				< -74.891396, 4.187861, -413.802207>
			}
			triangle {
				< -74.711531, -6.079433, -414.297789>,
				< -73.672809, -4.730557, -444.512695>,
				< -74.891396, 4.187861, -413.802207>
			}
			triangle {
				< -75.350940, -14.320059, -444.817305>,
				< -73.672809, -4.730557, -444.512695>,
				< -74.711531, -6.079433, -414.297789>
			}
			triangle {
				< -76.326504, -16.066432, -414.702237>,
				< -75.350940, -14.320059, -444.817305>,
				< -74.711531, -6.079433, -414.297789>
			}
			triangle {
				< -78.779995, -22.985863, -445.048511>,
				< -75.350940, -14.320059, -444.817305>,
				< -76.326504, -16.066432, -414.702237>
			}
			triangle {
				< -79.626702, -25.096681, -414.986461>,
				< -78.779995, -22.985863, -445.048511>,
				< -76.326504, -16.066432, -414.702237>
			}
			triangle {
				< -83.726823, -30.141002, -445.184648>,
				< -78.779995, -22.985863, -445.048511>,
				< -79.626702, -25.096681, -414.986461>
			}
			triangle {
				< -84.388070, -32.559175, -415.126771>,
				< -83.726823, -30.141002, -445.184648>,
				< -79.626702, -25.096681, -414.986461>
			}
			triangle {
				< -89.854844, -35.301309, -445.209235>,
				< -83.726823, -30.141002, -445.184648>,
				< -84.388070, -32.559175, -415.126771>
			}
			triangle {
				< -90.286933, -37.948668, -415.108353>,
				< -89.854844, -35.301309, -445.209235>,
				< -84.388070, -32.559175, -415.126771>
			}
			triangle {
				< -96.746922, -38.117137, -445.113599>,
				< -89.854844, -35.301309, -445.209235>,
				< -90.286933, -37.948668, -415.108353>
			}
			triangle {
				< -96.922070, -40.899538, -414.927006>,
				< -96.746922, -38.117137, -445.113599>,
				< -90.286933, -37.948668, -415.108353>
			}
			triangle {
				< -103.933536, -38.397111, -444.899619>,
				< -96.746922, -38.117137, -445.113599>,
				< -96.922070, -40.899538, -414.927006>
			}
			triangle {
				< -103.841588, -41.210100, -414.591759>,
				< -103.933536, -38.397111, -444.899619>,
				< -96.922070, -40.899538, -414.927006>
			}
			triangle {
				< -110.924833, -36.120702, -444.581419>,
				< -103.933536, -38.397111, -444.899619>,
				< -103.841588, -41.210100, -414.591759>
			}
			triangle {
				< -110.573821, -38.856924, -414.123684>,
				< -110.924833, -36.120702, -444.581419>,
				< -103.841588, -41.210100, -414.591759>
			}
			triangle {
				< -117.244087, -31.440258, -444.183290>,
				< -110.924833, -36.120702, -444.581419>,
				< -110.573821, -38.856924, -414.123684>
			}
			triangle {
				< -116.659500, -33.996869, -413.556486>,
				< -117.244087, -31.440258, -444.183290>,
				< -110.573821, -38.856924, -414.123684>
			}
			triangle {
				< -122.460142, -24.671378, -443.738192>,
				< -117.244087, -31.440258, -444.183290>,
				< -116.659500, -33.996869, -413.556486>
			}
			triangle {
				< -121.683136, -26.957417, -412.932634>,
				< -122.460142, -24.671378, -443.738192>,
				< -116.659500, -33.996869, -413.556486>
			}
			triangle {
				< -118.000962, -14.535420, -466.985494>,
				< -115.562931, -22.706132, -467.237324>,
				< -122.460142, -24.671378, -443.738192>
			}
			triangle {
				< -126.217321, -16.271809, -443.283468>,
				< -118.000962, -14.535420, -466.985494>,
				< -122.460142, -24.671378, -443.738192>
			}
			triangle {
				< -119.325906, -5.338297, -466.749281>,
				< -118.000962, -14.535420, -466.985494>,
				< -126.217321, -16.271809, -443.283468>
			}
			triangle {
				< -128.259137, -6.811728, -442.857653>,
				< -119.325906, -5.338297, -466.749281>,
				< -126.217321, -16.271809, -443.283468>
			}
			triangle {
				< -119.447328, 4.259154, -466.546565>,
				< -119.325906, -5.338297, -466.749281>,
				< -128.259137, -6.811728, -442.857653>
			}
			triangle {
				< -128.446311, 3.064760, -442.494154>,
				< -119.447328, 4.259154, -466.546565>,
				< -128.259137, -6.811728, -442.857653>
			}
			triangle {
				< -118.357033, 13.602279, -466.392040>,
				< -119.447328, 4.259154, -466.546565>,
				< -128.446311, 3.064760, -442.494154>
			}
			triangle {
				< -126.766041, 12.683189, -442.219049>,
				< -118.357033, 13.602279, -466.392040>,
				< -128.446311, 3.064760, -442.494154>
			}
			triangle {
				< -116.129339, 22.051971, -466.294646>,
				< -118.357033, 13.602279, -466.392040>,
				< -126.766041, 12.683189, -442.219049>
			}
			triangle {
				< -123.332992, 21.385878, -442.048281>,
				< -116.129339, 22.051971, -466.294646>,
				< -126.766041, 12.683189, -442.219049>
			}
			triangle {
				< -112.916142, 29.031215, -466.258019>,
				< -116.129339, 22.051971, -466.294646>,
				< -123.332992, 21.385878, -442.048281>
			}
			triangle {
				< -118.381388, 28.575711, -441.987336>,
				< -112.916142, 29.031215, -466.258019>,
				< -123.332992, 21.385878, -442.048281>
			}
			triangle {
				< -108.936578, 34.061193, -466.281146>,
				< -112.916142, 29.031215, -466.258019>,
				< -118.381388, 28.575711, -441.987336>
			}
			triangle {
				< -112.249106, 33.759113, -442.032903>,
				< -108.936578, 34.061193, -466.281146>,
				< -118.381388, 28.575711, -441.987336>
			}
			triangle {
				< -104.461946, 36.797445, -466.358811>,
				< -108.936578, 34.061193, -466.281146>,
				< -112.249106, 33.759113, -442.032903>
			}
			triangle {
				< -105.354428, 36.580425, -442.174345>,
				< -104.461946, 36.797445, -466.358811>,
				< -112.249106, 33.759113, -442.032903>
			}
			triangle {
				< -99.797338, 37.053011, -466.483355>,
				< -104.461946, 36.797445, -466.358811>,
				< -105.354428, 36.580425, -442.174345>
			}
			triangle {
				< -98.167591, 36.846679, -442.397594>,
				< -99.797338, 37.053011, -466.483355>,
				< -105.354428, 36.580425, -442.174345>
			}
			triangle {
				< -95.260642, 34.811117, -466.645926>,
				< -99.797338, 37.053011, -466.483355>,
				< -98.167591, 36.846679, -442.397594>
			}
			triangle {
				< -91.178462, 34.541056, -442.686379>,
				< -95.260642, 34.811117, -466.645926>,
				< -98.167591, 36.846679, -442.397594>
			}
			triangle {
				< -91.160983, 30.226469, -466.837466>,
				< -95.260642, 34.811117, -466.645926>,
				< -91.178462, 34.541056, -442.686379>
			}
			triangle {
				< -84.863216, 29.823760, -443.024099>,
				< -91.160983, 30.226469, -466.837466>,
				< -91.178462, 34.541056, -442.686379>
			}
			triangle {
				< -87.777644, 23.613777, -467.047423>,
				< -91.160983, 30.226469, -466.837466>,
				< -84.863216, 29.823760, -443.024099>
			}
			triangle {
				< -79.651833, 23.020053, -443.393975>,
				< -87.777644, 23.613777, -467.047423>,
				< -84.863216, 29.823760, -443.024099>
			}
			triangle {
				< -85.341036, 15.426857, -467.265308>,
				< -87.777644, 23.613777, -467.047423>,
				< -79.651833, 23.020053, -443.393975>
			}
			triangle {
				< -75.898953, 14.597363, -443.778634>,
				< -85.341036, 15.426857, -467.265308>,
				< -79.651833, 23.020053, -443.393975>
			}
			triangle {
				< -84.016971, 6.224367, -467.479885>,
				< -85.341036, 15.426857, -467.265308>,
				< -75.898953, 14.597363, -443.778634>
			}
			triangle {
				< -73.859714, 5.132178, -444.158643>,
				< -84.016971, 6.224367, -467.479885>,
				< -75.898953, 14.597363, -443.778634>
			}
			triangle {
				< -83.895609, -3.365744, -467.678398>,
				< -84.016971, 6.224367, -467.479885>,
				< -73.859714, 5.132178, -444.158643>
			}
			triangle {
				< -73.672809, -4.730557, -444.512695>,
				< -83.895609, -3.365744, -467.678398>,
				< -73.859714, 5.132178, -444.158643>
			}
			triangle {
				< -84.985197, -12.690645, -467.847824>,
				< -83.895609, -3.365744, -467.678398>,
				< -73.672809, -4.730557, -444.512695>
			}
			triangle {
				< -75.350940, -14.320059, -444.817305>,
				< -84.985197, -12.690645, -467.847824>,
				< -73.672809, -4.730557, -444.512695>
			}
			triangle {
				< -87.211601, -21.116881, -467.975050>,
				< -84.985197, -12.690645, -467.847824>,
				< -75.350940, -14.320059, -444.817305>
			}
			triangle {
				< -78.779995, -22.985863, -445.048511>,
				< -87.211601, -21.116881, -467.975050>,
				< -75.350940, -14.320059, -444.817305>
			}
			triangle {
				< -90.423234, -28.072443, -468.048424>,
				< -87.211601, -21.116881, -467.975050>,
				< -78.779995, -22.985863, -445.048511>
			}
			triangle {
				< -83.726823, -30.141002, -445.184648>,
				< -90.423234, -28.072443, -468.048424>,
				< -78.779995, -22.985863, -445.048511>
			}
			triangle {
				< -94.401434, -33.085722, -468.059003>,
				< -90.423234, -28.072443, -468.048424>,
				< -83.726823, -30.141002, -445.184648>
			}
			triangle {
				< -89.854844, -35.301309, -445.209235>,
				< -94.401434, -33.085722, -468.059003>,
				< -83.726823, -30.141002, -445.184648>
			}
			triangle {
				< -98.875202, -35.816610, -468.003422>,
				< -94.401434, -33.085722, -468.059003>,
				< -89.854844, -35.301309, -445.209235>
			}
			triangle {
				< -96.746922, -38.117137, -445.113599>,
				< -98.875202, -35.816610, -468.003422>,
				< -89.854844, -35.301309, -445.209235>
			}
			triangle {
				< -103.539750, -36.079485, -467.882603>,
				< -98.875202, -35.816610, -468.003422>,
				< -96.746922, -38.117137, -445.113599>
			}
			triangle {
				< -103.933536, -38.397111, -444.899619>,
				< -103.539750, -36.079485, -467.882603>,
				< -96.746922, -38.117137, -445.113599>
			}
			triangle {
				< -108.077168, -33.855751, -467.705160>,
				< -103.539750, -36.079485, -467.882603>,
				< -103.933536, -38.397111, -444.899619>
			}
			triangle {
				< -110.924833, -36.120702, -444.581419>,
				< -108.077168, -33.855751, -467.705160>,
				< -103.933536, -38.397111, -444.899619>
			}
			triangle {
				< -112.178117, -29.294999, -467.484027>,
				< -108.077168, -33.855751, -467.705160>,
				< -110.924833, -36.120702, -444.581419>
			}
			triangle {
				< -117.244087, -31.440258, -444.183290>,
				< -112.178117, -29.294999, -467.484027>,
				< -110.924833, -36.120702, -444.581419>
			}
			triangle {
				< -115.562931, -22.706132, -467.237324>,
				< -112.178117, -29.294999, -467.484027>,
				< -117.244087, -31.440258, -444.183290>
			}
			triangle {
				< -122.460142, -24.671378, -443.738192>,
				< -115.562931, -22.706132, -467.237324>,
				< -117.244087, -31.440258, -444.183290>
			}
			triangle {
				< -110.374518, -6.212828, -481.898278>,
				< -109.123357, -10.387260, -482.004941>,
				< -115.562931, -22.706132, -467.237324>
			}
			triangle {
				< -118.000962, -14.535420, -466.985494>,
				< -110.374518, -6.212828, -481.898278>,
				< -115.562931, -22.706132, -467.237324>
			}
			triangle {
				< -111.054420, -1.516141, -481.797576>,
				< -110.374518, -6.212828, -481.898278>,
				< -118.000962, -14.535420, -466.985494>
			}
			triangle {
				< -119.325906, -5.338297, -466.749281>,
				< -111.054420, -1.516141, -481.797576>,
				< -118.000962, -14.535420, -466.985494>
			}
			triangle {
				< -111.116745, 3.382916, -481.709898>,
				< -111.054420, -1.516141, -481.797576>,
				< -119.325906, -5.338297, -466.749281>
			}
			triangle {
				< -119.447328, 4.259154, -466.546565>,
				< -111.116745, 3.382916, -481.709898>,
				< -119.325906, -5.338297, -466.749281>
			}
			triangle {
				< -110.557228, 8.150425, -481.641233>,
				< -111.116745, 3.382916, -481.709898>,
				< -119.447328, 4.259154, -466.546565>
			}
			triangle {
				< -118.357033, 13.602279, -466.392040>,
				< -110.557228, 8.150425, -481.641233>,
				< -119.447328, 4.259154, -466.546565>
			}
			triangle {
				< -109.414019, 12.460898, -481.596410>,
				< -110.557228, 8.150425, -481.641233>,
				< -118.357033, 13.602279, -466.392040>
			}
			triangle {
				< -116.129339, 22.051971, -466.294646>,
				< -109.414019, 12.460898, -481.596410>,
				< -118.357033, 13.602279, -466.392040>
			}
			triangle {
				< -107.765026, 16.019598, -481.577128>,
				< -109.414019, 12.460898, -481.596410>,
				< -116.129339, 22.051971, -466.294646>
			}
			triangle {
				< -112.916142, 29.031215, -466.258019>,
				< -107.765026, 16.019598, -481.577128>,
				< -116.129339, 22.051971, -466.294646>
			}
			triangle {
				< -105.722696, 18.584244, -481.584072>,
				< -107.765026, 16.019598, -481.577128>,
				< -112.916142, 29.031215, -466.258019>
			}
			triangle {
				< -108.936578, 34.061193, -466.281146>,
				< -105.722696, 18.584244, -481.584072>,
				< -112.916142, 29.031215, -466.258019>
			}
			triangle {
				< -103.426196, 19.979171, -481.615633>,
				< -105.722696, 18.584244, -481.584072>,
				< -108.936578, 34.061193, -466.281146>
			}
			triangle {
				< -104.461946, 36.797445, -466.358811>,
				< -103.426196, 19.979171, -481.615633>,
				< -108.936578, 34.061193, -466.281146>
			}
			triangle {
				< -101.032041, 20.109139, -481.669128>,
				< -103.426196, 19.979171, -481.615633>,
				< -104.461946, 36.797445, -466.358811>
			}
			triangle {
				< -99.797338, 37.053011, -466.483355>,
				< -101.032041, 20.109139, -481.669128>,
				< -104.461946, 36.797445, -466.358811>
			}
			triangle {
				< -98.703429, 18.965418, -481.741190>,
				< -101.032041, 20.109139, -481.669128>,
				< -99.797338, 37.053011, -466.483355>
			}
			triangle {
				< -95.260642, 34.811117, -466.645926>,
				< -98.703429, 18.965418, -481.741190>,
				< -99.797338, 37.053011, -466.483355>
			}
			triangle {
				< -96.599035, 16.626317, -481.826842>,
				< -98.703429, 18.965418, -481.741190>,
				< -95.260642, 34.811117, -466.645926>
			}
			triangle {
				< -91.160983, 30.226469, -466.837466>,
				< -96.599035, 16.626317, -481.826842>,
				< -95.260642, 34.811117, -466.645926>
			}
			triangle {
				< -94.862230, 13.252540, -481.921077>,
				< -96.599035, 16.626317, -481.826842>,
				< -91.160983, 30.226469, -466.837466>
			}
			triangle {
				< -87.777644, 23.613777, -467.047423>,
				< -94.862230, 13.252540, -481.921077>,
				< -91.160983, 30.226469, -466.837466>
			}
			triangle {
				< -93.611360, 9.073490, -482.018799>,
				< -94.862230, 13.252540, -481.921077>,
				< -87.777644, 23.613777, -467.047423>
			}
			triangle {
				< -85.341036, 15.426857, -467.265308>,
				< -93.611360, 9.073490, -482.018799>,
				< -87.777644, 23.613777, -467.047423>
			}
			triangle {
				< -92.931606, 4.375132, -482.113957>,
				< -93.611360, 9.073490, -482.018799>,
				< -85.341036, 15.426857, -467.265308>
			}
			triangle {
				< -84.016971, 6.224367, -467.479885>,
				< -92.931606, 4.375132, -482.113957>,
				< -85.341036, 15.426857, -467.265308>
			}
			triangle {
				< -92.869312, -0.522382, -482.200742>,
				< -92.931606, 4.375132, -482.113957>,
				< -84.016971, 6.224367, -467.479885>
			}
			triangle {
				< -83.895609, -3.365744, -467.678398>,
				< -92.869312, -0.522382, -482.200742>,
				< -84.016971, 6.224367, -467.479885>
			}
			triangle {
				< -93.428679, -5.285316, -482.273191>,
				< -92.869312, -0.522382, -482.200742>,
				< -83.895609, -3.365744, -467.678398>
			}
			triangle {
				< -84.985197, -12.690645, -467.847824>,
				< -93.428679, -5.285316, -482.273191>,
				< -83.895609, -3.365744, -467.678398>
			}
			triangle {
				< -94.571643, -9.589666, -482.326180>,
				< -93.428679, -5.285316, -482.273191>,
				< -84.985197, -12.690645, -467.847824>
			}
			triangle {
				< -87.211601, -21.116881, -467.975050>,
				< -94.571643, -9.589666, -482.326180>,
				< -84.985197, -12.690645, -467.847824>
			}
			triangle {
				< -96.220315, -13.142692, -482.355088>,
				< -94.571643, -9.589666, -482.326180>,
				< -87.211601, -21.116881, -467.975050>
			}
			triangle {
				< -90.423234, -28.072443, -468.048424>,
				< -96.220315, -13.142692, -482.355088>,
				< -87.211601, -21.116881, -467.975050>
			}
			triangle {
				< -98.262407, -15.702853, -482.356995>,
				< -96.220315, -13.142692, -482.355088>,
				< -90.423234, -28.072443, -468.048424>
			}
			triangle {
				< -94.401434, -33.085722, -468.059003>,
				< -98.262407, -15.702853, -482.356995>,
				< -90.423234, -28.072443, -468.048424>
			}
			triangle {
				< -100.558743, -17.096054, -482.331157>,
				< -98.262407, -15.702853, -482.356995>,
				< -94.401434, -33.085722, -468.059003>
			}
			triangle {
				< -98.875202, -35.816610, -468.003422>,
				< -100.558743, -17.096054, -482.331157>,
				< -94.401434, -33.085722, -468.059003>
			}
			triangle {
				< -102.952868, -17.227566, -482.278317>,
				< -100.558743, -17.096054, -482.331157>,
				< -98.875202, -35.816610, -468.003422>
			}
			triangle {
				< -103.539750, -36.079485, -467.882603>,
				< -102.952868, -17.227566, -482.278317>,
				< -98.875202, -35.816610, -468.003422>
			}
			triangle {
				< -105.281629, -16.088208, -482.202530>,
				< -102.952868, -17.227566, -482.278317>,
				< -103.539750, -36.079485, -467.882603>
			}
			triangle {
				< -108.077168, -33.855751, -467.705160>,
				< -105.281629, -16.088208, -482.202530>,
				< -103.539750, -36.079485, -467.882603>
			}
			triangle {
				< -107.386269, -13.755299, -482.108891>,
				< -105.281629, -16.088208, -482.202530>,
				< -108.077168, -33.855751, -467.705160>
			}
			triangle {
				< -112.178117, -29.294999, -467.484027>,
				< -107.386269, -13.755299, -482.108891>,
				< -108.077168, -33.855751, -467.705160>
			}
			triangle {
				< -109.123357, -10.387260, -482.004941>,
				< -107.386269, -13.755299, -482.108891>,
				< -112.178117, -29.294999, -467.484027>
			}
			triangle {
				< -115.562931, -22.706132, -467.237324>,
				< -109.123357, -10.387260, -482.004941>,
				< -112.178117, -29.294999, -467.484027>
			}
			triangle {
				< -105.281629, -16.088208, -482.202530>,
				< -107.386269, -13.755299, -482.108891>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -102.952868, -17.227566, -482.278317>,
				< -105.281629, -16.088208, -482.202530>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -100.558743, -17.096054, -482.331157>,
				< -102.952868, -17.227566, -482.278317>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -98.262407, -15.702853, -482.356995>,
				< -100.558743, -17.096054, -482.331157>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -96.220315, -13.142692, -482.355088>,
				< -98.262407, -15.702853, -482.356995>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -94.571643, -9.589666, -482.326180>,
				< -96.220315, -13.142692, -482.355088>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -93.428679, -5.285316, -482.273191>,
				< -94.571643, -9.589666, -482.326180>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -92.869312, -0.522382, -482.200742>,
				< -93.428679, -5.285316, -482.273191>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -92.931606, 4.375132, -482.113957>,
				< -92.869312, -0.522382, -482.200742>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -93.611360, 9.073490, -482.018799>,
				< -92.931606, 4.375132, -482.113957>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -94.862230, 13.252540, -481.921077>,
				< -93.611360, 9.073490, -482.018799>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -96.599035, 16.626317, -481.826842>,
				< -94.862230, 13.252540, -481.921077>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -98.703429, 18.965418, -481.741190>,
				< -96.599035, 16.626317, -481.826842>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -101.032041, 20.109139, -481.669128>,
				< -98.703429, 18.965418, -481.741190>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -103.426196, 19.979171, -481.615633>,
				< -101.032041, 20.109139, -481.669128>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -105.722696, 18.584244, -481.584072>,
				< -103.426196, 19.979171, -481.615633>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -107.765026, 16.019598, -481.577128>,
				< -105.722696, 18.584244, -481.584072>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -109.414019, 12.460898, -481.596410>,
				< -107.765026, 16.019598, -481.577128>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -110.557228, 8.150425, -481.641233>,
				< -109.414019, 12.460898, -481.596410>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -111.116745, 3.382916, -481.709898>,
				< -110.557228, 8.150425, -481.641233>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -111.054420, -1.516141, -481.797576>,
				< -111.116745, 3.382916, -481.709898>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -110.374518, -6.212828, -481.898278>,
				< -111.054420, -1.516141, -481.797576>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -109.123357, -10.387260, -482.004941>,
				< -110.374518, -6.212828, -481.898278>,
				< -102.091886, 1.711878, -487.017840>
			}
			triangle {
				< -107.386269, -13.755299, -482.108891>,
				< -109.123357, -10.387260, -482.004941>,
				< -102.091886, 1.711878, -487.017840>
			}
			
		}
		// _Thigh04
		union {
			triangle {
				< -59.459228, -10.263721, -92.104152>,
				< -58.933746, -6.058832, -89.104541>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -58.933746, -6.058832, -89.104541>,
				< -57.966441, -2.713713, -83.748206>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -57.966441, -2.713713, -83.748206>,
				< -56.583609, -0.456394, -76.409273>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -56.583609, -0.456394, -76.409273>,
				< -54.835577, 0.559336, -67.598671>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -54.835577, 0.559336, -67.598671>,
				< -52.806135, 0.264265, -57.926089>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -52.806135, 0.264265, -57.926089>,
				< -50.615501, -1.321545, -48.056465>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -50.615501, -1.321545, -48.056465>,
				< -48.417140, -4.090001, -38.662925>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -48.417140, -4.090001, -38.662925>,
				< -46.386018, -7.852406, -30.379565>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -46.386018, -7.852406, -30.379565>,
				< -44.700000, -12.352386, -23.760466>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -44.700000, -12.352386, -23.760466>,
				< -43.516673, -17.283294, -19.244360>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -43.516673, -17.283294, -19.244360>,
				< -42.952143, -22.309048, -17.128572>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -42.952143, -22.309048, -17.128572>,
				< -43.062888, -27.087186, -17.551778>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -43.062888, -27.087186, -17.551778>,
				< -43.837707, -31.292070, -20.486215>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -43.837707, -31.292070, -20.486215>,
				< -45.199223, -34.637164, -25.739318>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -45.199223, -34.637164, -25.739318>,
				< -47.015600, -36.894489, -32.964587>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -47.015600, -36.894489, -32.964587>,
				< -49.120251, -37.910253, -41.681815>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -49.120251, -37.910253, -41.681815>,
				< -51.333781, -37.615184, -51.305972>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -51.333781, -37.615184, -51.305972>,
				< -53.486630, -36.029361, -61.185203>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -53.486630, -36.029361, -61.185203>,
				< -55.435676, -33.260901, -70.644043>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -55.435676, -33.260901, -70.644043>,
				< -57.072565, -29.498499, -79.030670>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -57.072565, -29.498499, -79.030670>,
				< -58.325097, -24.998546, -85.763350>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -58.325097, -24.998546, -85.763350>,
				< -59.151843, -20.067655, -90.372853>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -59.151843, -20.067655, -90.372853>,
				< -59.532315, -15.041877, -92.536986>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -59.532315, -15.041877, -92.536986>,
				< -59.459228, -10.263721, -92.104152>,
				< -50.665483, -18.671570, -54.893430>
			}
			triangle {
				< -69.044240, -2.436613, -126.784191>,
				< -68.253949, 5.686616, -120.924734>,
				< -59.459228, -10.263721, -92.104152>
			}
			triangle {
				< -68.253949, 5.686616, -120.924734>,
				< -58.933746, -6.058832, -89.104541>,
				< -59.459228, -10.263721, -92.104152>
			}
			triangle {
				< -68.253949, 5.686616, -120.924734>,
				< -66.739008, 12.148549, -110.468253>,
				< -58.933746, -6.058832, -89.104541>
			}
			triangle {
				< -66.739008, 12.148549, -110.468253>,
				< -57.966441, -2.713713, -83.748206>,
				< -58.933746, -6.058832, -89.104541>
			}
			triangle {
				< -66.739008, 12.148549, -110.468253>,
				< -64.452484, 16.509378, -96.157514>,
				< -57.966441, -2.713713, -83.748206>
			}
			triangle {
				< -64.452484, 16.509378, -96.157514>,
				< -56.583609, -0.456394, -76.409273>,
				< -57.966441, -2.713713, -83.748206>
			}
			triangle {
				< -64.452484, 16.509378, -96.157514>,
				< -61.386321, 18.471604, -79.004876>,
				< -56.583609, -0.456394, -76.409273>
			}
			triangle {
				< -61.386321, 18.471604, -79.004876>,
				< -54.835577, 0.559336, -67.598671>,
				< -56.583609, -0.456394, -76.409273>
			}
			triangle {
				< -61.386321, 18.471604, -79.004876>,
				< -57.616331, 17.901545, -60.215436>,
				< -54.835577, 0.559336, -67.598671>
			}
			triangle {
				< -57.616331, 17.901545, -60.215436>,
				< -52.806135, 0.264265, -57.926089>,
				< -54.835577, 0.559336, -67.598671>
			}
			triangle {
				< -57.616331, 17.901545, -60.215436>,
				< -53.332914, 14.837998, -41.095044>,
				< -52.806135, 0.264265, -57.926089>
			}
			triangle {
				< -53.332914, 14.837998, -41.095044>,
				< -50.615501, -1.321545, -48.056465>,
				< -52.806135, 0.264265, -57.926089>
			}
			triangle {
				< -53.332914, 14.837998, -41.095044>,
				< -48.845034, 9.490062, -22.951256>,
				< -50.615501, -1.321545, -48.056465>
			}
			triangle {
				< -48.845034, 9.490062, -22.951256>,
				< -48.417140, -4.090001, -38.662925>,
				< -50.615501, -1.321545, -48.056465>
			}
			triangle {
				< -48.845034, 9.490062, -22.951256>,
				< -44.553854, 2.221668, -7.001474>,
				< -48.417140, -4.090001, -38.662925>
			}
			triangle {
				< -44.553854, 2.221668, -7.001474>,
				< -46.386018, -7.852406, -30.379565>,
				< -48.417140, -4.090001, -38.662925>
			}
			triangle {
				< -44.553854, 2.221668, -7.001474>,
				< -40.899027, -6.471646, 5.707351>,
				< -46.386018, -7.852406, -30.379565>
			}
			triangle {
				< -40.899027, -6.471646, 5.707351>,
				< -44.700000, -12.352386, -23.760466>,
				< -46.386018, -7.852406, -30.379565>
			}
			triangle {
				< -40.899027, -6.471646, 5.707351>,
				< -38.288850, -15.997380, 14.358388>,
				< -44.700000, -12.352386, -23.760466>
			}
			triangle {
				< -38.288850, -15.997380, 14.358388>,
				< -43.516673, -17.283294, -19.244360>,
				< -44.700000, -12.352386, -23.760466>
			}
			triangle {
				< -38.288850, -15.997380, 14.358388>,
				< -37.031632, -25.706425, 18.405532>,
				< -43.516673, -17.283294, -19.244360>
			}
			triangle {
				< -37.031632, -25.706425, 18.405532>,
				< -42.952143, -22.309048, -17.128572>,
				< -43.516673, -17.283294, -19.244360>
			}
			triangle {
				< -37.031632, -25.706425, 18.405532>,
				< -37.279695, -34.937106, 17.596198>,
				< -42.952143, -22.309048, -17.128572>
			}
			triangle {
				< -37.279695, -34.937106, 17.596198>,
				< -43.062888, -27.087186, -17.551778>,
				< -42.952143, -22.309048, -17.128572>
			}
			triangle {
				< -37.279695, -34.937106, 17.596198>,
				< -39.002605, -43.060325, 11.980842>,
				< -43.062888, -27.087186, -17.551778>
			}
			triangle {
				< -39.002605, -43.060325, 11.980842>,
				< -43.837707, -31.292070, -20.486215>,
				< -43.062888, -27.087186, -17.551778>
			}
			triangle {
				< -39.002605, -43.060325, 11.980842>,
				< -41.991971, -49.522545, 1.910991>,
				< -43.837707, -31.292070, -20.486215>
			}
			triangle {
				< -41.991971, -49.522545, 1.910991>,
				< -45.199223, -34.637164, -25.739318>,
				< -43.837707, -31.292070, -20.486215>
			}
			triangle {
				< -41.991971, -49.522545, 1.910991>,
				< -45.900390, -53.883377, -11.974205>,
				< -45.199223, -34.637164, -25.739318>
			}
			triangle {
				< -45.900390, -53.883377, -11.974205>,
				< -47.015600, -36.894489, -32.964587>,
				< -45.199223, -34.637164, -25.739318>
			}
			triangle {
				< -45.900390, -53.883377, -11.974205>,
				< -50.300885, -55.845607, -28.776303>,
				< -47.015600, -36.894489, -32.964587>
			}
			triangle {
				< -50.300885, -55.845607, -28.776303>,
				< -49.120251, -37.910253, -41.681815>,
				< -47.015600, -36.894489, -32.964587>
			}
			triangle {
				< -50.300885, -55.845607, -28.776303>,
				< -54.759998, -55.275545, -47.384210>,
				< -49.120251, -37.910253, -41.681815>
			}
			triangle {
				< -54.759998, -55.275545, -47.384210>,
				< -51.333781, -37.615184, -51.305972>,
				< -49.120251, -37.910253, -41.681815>
			}
			triangle {
				< -54.759998, -55.275545, -47.384210>,
				< -58.902349, -52.212019, -66.541076>,
				< -51.333781, -37.615184, -51.305972>
			}
			triangle {
				< -58.902349, -52.212019, -66.541076>,
				< -53.486630, -36.029361, -61.185203>,
				< -51.333781, -37.615184, -51.305972>
			}
			triangle {
				< -58.902349, -52.212019, -66.541076>,
				< -62.456794, -46.863828, -84.929444>,
				< -53.486630, -36.029361, -61.185203>
			}
			triangle {
				< -62.456794, -46.863828, -84.929444>,
				< -55.435676, -33.260901, -70.644043>,
				< -53.486630, -36.029361, -61.185203>
			}
			triangle {
				< -62.456794, -46.863828, -84.929444>,
				< -65.272667, -39.595392, -101.266384>,
				< -55.435676, -33.260901, -70.644043>
			}
			triangle {
				< -65.272667, -39.595392, -101.266384>,
				< -57.072565, -29.498499, -79.030670>,
				< -55.435676, -33.260901, -70.644043>
			}
			triangle {
				< -65.272667, -39.595392, -101.266384>,
				< -67.305960, -30.902099, -114.400737>,
				< -57.072565, -29.498499, -79.030670>
			}
			triangle {
				< -67.305960, -30.902099, -114.400737>,
				< -58.325097, -24.998546, -85.763350>,
				< -57.072565, -29.498499, -79.030670>
			}
			triangle {
				< -67.305960, -30.902099, -114.400737>,
				< -68.582527, -21.376366, -123.401813>,
				< -58.325097, -24.998546, -85.763350>
			}
			triangle {
				< -68.582527, -21.376366, -123.401813>,
				< -59.151843, -20.067655, -90.372853>,
				< -58.325097, -24.998546, -85.763350>
			}
			triangle {
				< -68.582527, -21.376366, -123.401813>,
				< -69.151402, -11.667295, -127.630040>,
				< -59.151843, -20.067655, -90.372853>
			}
			triangle {
				< -69.151402, -11.667295, -127.630040>,
				< -59.532315, -15.041877, -92.536986>,
				< -59.151843, -20.067655, -90.372853>
			}
			triangle {
				< -69.151402, -11.667295, -127.630040>,
				< -69.044240, -2.436613, -126.784191>,
				< -59.532315, -15.041877, -92.536986>
			}
			triangle {
				< -69.044240, -2.436613, -126.784191>,
				< -59.459228, -10.263721, -92.104152>,
				< -59.532315, -15.041877, -92.536986>
			}
			triangle {
				< -79.232894, 4.276291, -156.604275>,
				< -78.389041, 15.764019, -148.227945>,
				< -69.044240, -2.436613, -126.784191>
			}
			triangle {
				< -78.389041, 15.764019, -148.227945>,
				< -68.253949, 5.686616, -120.924734>,
				< -69.044240, -2.436613, -126.784191>
			}
			triangle {
				< -78.389041, 15.764019, -148.227945>,
				< -76.675817, 24.902962, -133.284628>,
				< -68.253949, 5.686616, -120.924734>
			}
			triangle {
				< -76.675817, 24.902962, -133.284628>,
				< -66.739008, 12.148549, -110.468253>,
				< -68.253949, 5.686616, -120.924734>
			}
			triangle {
				< -76.675817, 24.902962, -133.284628>,
				< -73.906228, 31.070080, -112.845719>,
				< -66.739008, 12.148549, -110.468253>
			}
			triangle {
				< -73.906228, 31.070080, -112.845719>,
				< -64.452484, 16.509378, -96.157514>,
				< -66.739008, 12.148549, -110.468253>
			}
			triangle {
				< -73.906228, 31.070080, -112.845719>,
				< -69.938228, 33.845108, -88.374890>,
				< -64.452484, 16.509378, -96.157514>
			}
			triangle {
				< -69.938228, 33.845108, -88.374890>,
				< -61.386321, 18.471604, -79.004876>,
				< -64.452484, 16.509378, -96.157514>
			}
			triangle {
				< -69.938228, 33.845108, -88.374890>,
				< -64.774796, 33.038940, -61.613690>,
				< -61.386321, 18.471604, -79.004876>
			}
			triangle {
				< -64.774796, 33.038940, -61.613690>,
				< -57.616331, 17.901545, -60.215436>,
				< -61.386321, 18.471604, -79.004876>
			}
			triangle {
				< -64.774796, 33.038940, -61.613690>,
				< -58.635943, 28.706413, -34.442175>,
				< -57.616331, 17.901545, -60.215436>
			}
			triangle {
				< -58.635943, 28.706413, -34.442175>,
				< -53.332914, 14.837998, -41.095044>,
				< -57.616331, 17.901545, -60.215436>
			}
			triangle {
				< -58.635943, 28.706413, -34.442175>,
				< -51.976707, 21.142960, -8.728982>,
				< -53.332914, 14.837998, -41.095044>
			}
			triangle {
				< -51.976707, 21.142960, -8.728982>,
				< -48.845034, 9.490062, -22.951256>,
				< -53.332914, 14.837998, -41.095044>
			}
			triangle {
				< -51.976707, 21.142960, -8.728982>,
				< -45.444243, 10.863834, 13.808287>,
				< -48.845034, 9.490062, -22.951256>
			}
			triangle {
				< -45.444243, 10.863834, 13.808287>,
				< -44.553854, 2.221668, -7.001474>,
				< -48.845034, 9.490062, -22.951256>
			}
			triangle {
				< -45.444243, 10.863834, 13.808287>,
				< -39.779443, -1.430075, 31.715166>,
				< -44.553854, 2.221668, -7.001474>
			}
			triangle {
				< -39.779443, -1.430075, 31.715166>,
				< -40.899027, -6.471646, 5.707351>,
				< -44.553854, 2.221668, -7.001474>
			}
			triangle {
				< -39.779443, -1.430075, 31.715166>,
				< -35.686668, -14.901525, 43.876100>,
				< -40.899027, -6.471646, 5.707351>
			}
			triangle {
				< -35.686668, -14.901525, 43.876100>,
				< -38.288850, -15.997380, 14.358388>,
				< -40.899027, -6.471646, 5.707351>
			}
			triangle {
				< -35.686668, -14.901525, 43.876100>,
				< -33.702992, -28.632188, 49.556881>,
				< -38.288850, -15.997380, 14.358388>
			}
			triangle {
				< -33.702992, -28.632188, 49.556881>,
				< -37.031632, -25.706425, 18.405532>,
				< -38.288850, -15.997380, 14.358388>
			}
			triangle {
				< -33.702992, -28.632188, 49.556881>,
				< -34.095835, -41.686293, 48.421089>,
				< -37.031632, -25.706425, 18.405532>
			}
			triangle {
				< -34.095835, -41.686293, 48.421089>,
				< -37.279695, -34.937106, 17.596198>,
				< -37.031632, -25.706425, 18.405532>
			}
			triangle {
				< -34.095835, -41.686293, 48.421089>,
				< -36.811404, -53.174272, 40.535931>,
				< -37.279695, -34.937106, 17.596198>
			}
			triangle {
				< -36.811404, -53.174272, 40.535931>,
				< -39.002605, -43.060325, 11.980842>,
				< -37.279695, -34.937106, 17.596198>
			}
			triangle {
				< -36.811404, -53.174272, 40.535931>,
				< -41.485142, -62.313236, 26.370466>,
				< -39.002605, -43.060325, 11.980842>
			}
			triangle {
				< -41.485142, -62.313236, 26.370466>,
				< -41.991971, -49.522545, 1.910991>,
				< -39.002605, -43.060325, 11.980842>
			}
			triangle {
				< -41.485142, -62.313236, 26.370466>,
				< -47.511894, -68.480372, 6.788464>,
				< -41.991971, -49.522545, 1.910991>
			}
			triangle {
				< -47.511894, -68.480372, 6.788464>,
				< -45.900390, -53.883377, -11.974205>,
				< -41.991971, -49.522545, 1.910991>
			}
			triangle {
				< -47.511894, -68.480372, 6.788464>,
				< -54.160692, -71.255371, -16.976234>,
				< -45.900390, -53.883377, -11.974205>
			}
			triangle {
				< -54.160692, -71.255371, -16.976234>,
				< -50.300885, -55.845607, -28.776303>,
				< -45.900390, -53.883377, -11.974205>
			}
			triangle {
				< -54.160692, -71.255371, -16.976234>,
				< -60.708851, -70.449181, -43.371908>,
				< -50.300885, -55.845607, -28.776303>
			}
			triangle {
				< -60.708851, -70.449181, -43.371908>,
				< -54.759998, -55.275545, -47.384210>,
				< -50.300885, -55.845607, -28.776303>
			}
			triangle {
				< -60.708851, -70.449181, -43.371908>,
				< -66.564359, -66.116698, -70.617050>,
				< -54.759998, -55.275545, -47.384210>
			}
			triangle {
				< -66.564359, -66.116698, -70.617050>,
				< -58.902349, -52.212019, -66.541076>,
				< -54.759998, -55.275545, -47.384210>
			}
			triangle {
				< -66.564359, -66.116698, -70.617050>,
				< -71.348101, -58.553215, -96.823223>,
				< -58.902349, -52.212019, -66.541076>
			}
			triangle {
				< -71.348101, -58.553215, -96.823223>,
				< -62.456794, -46.863828, -84.929444>,
				< -58.902349, -52.212019, -66.541076>
			}
			triangle {
				< -71.348101, -58.553215, -96.823223>,
				< -74.916825, -48.274100, -120.139845>,
				< -62.456794, -46.863828, -84.929444>
			}
			triangle {
				< -74.916825, -48.274100, -120.139845>,
				< -65.272667, -39.595392, -101.266384>,
				< -62.456794, -46.863828, -84.929444>
			}
			triangle {
				< -74.916825, -48.274100, -120.139845>,
				< -77.325143, -35.979934, -138.903320>,
				< -65.272667, -39.595392, -101.266384>
			}
			triangle {
				< -77.325143, -35.979934, -138.903320>,
				< -67.305960, -30.902099, -114.400737>,
				< -65.272667, -39.595392, -101.266384>
			}
			triangle {
				< -77.325143, -35.979934, -138.903320>,
				< -78.740902, -22.508468, -151.768565>,
				< -67.305960, -30.902099, -114.400737>
			}
			triangle {
				< -78.740902, -22.508468, -151.768565>,
				< -68.582527, -21.376366, -123.401813>,
				< -67.305960, -30.902099, -114.400737>
			}
			triangle {
				< -78.740902, -22.508468, -151.768565>,
				< -79.342939, -8.777827, -157.813221>,
				< -68.582527, -21.376366, -123.401813>
			}
			triangle {
				< -79.342939, -8.777827, -157.813221>,
				< -69.151402, -11.667295, -127.630040>,
				< -68.582527, -21.376366, -123.401813>
			}
			triangle {
				< -79.342939, -8.777827, -157.813221>,
				< -79.232894, 4.276291, -156.604275>,
				< -69.151402, -11.667295, -127.630040>
			}
			triangle {
				< -79.232894, 4.276291, -156.604275>,
				< -69.044240, -2.436613, -126.784191>,
				< -69.151402, -11.667295, -127.630040>
			}
			triangle {
				< -89.949191, 9.417593, -179.459855>,
				< -89.172736, 23.487164, -169.094443>,
				< -79.232894, 4.276291, -156.604275>
			}
			triangle {
				< -89.172736, 23.487164, -169.094443>,
				< -78.389041, 15.764019, -148.227945>,
				< -79.232894, 4.276291, -156.604275>
			}
			triangle {
				< -89.172736, 23.487164, -169.094443>,
				< -87.475553, 34.680061, -150.603607>,
				< -78.389041, 15.764019, -148.227945>
			}
			triangle {
				< -87.475553, 34.680061, -150.603607>,
				< -76.675817, 24.902962, -133.284628>,
				< -78.389041, 15.764019, -148.227945>
			}
			triangle {
				< -87.475553, 34.680061, -150.603607>,
				< -84.512822, 42.233225, -125.319242>,
				< -76.675817, 24.902962, -133.284628>
			}
			triangle {
				< -84.512822, 42.233225, -125.319242>,
				< -73.906228, 31.070080, -112.845719>,
				< -76.675817, 24.902962, -133.284628>
			}
			triangle {
				< -84.512822, 42.233225, -125.319242>,
				< -79.985492, 45.631886, -95.066421>,
				< -73.906228, 31.070080, -112.845719>
			}
			triangle {
				< -79.985492, 45.631886, -95.066421>,
				< -69.938228, 33.845108, -88.374890>,
				< -73.906228, 31.070080, -112.845719>
			}
			triangle {
				< -79.985492, 45.631886, -95.066421>,
				< -73.798463, 44.644520, -62.020477>,
				< -69.938228, 33.845108, -88.374890>
			}
			triangle {
				< -73.798463, 44.644520, -62.020477>,
				< -64.774796, 33.038940, -61.613690>,
				< -69.938228, 33.845108, -88.374890>
			}
			triangle {
				< -73.798463, 44.644520, -62.020477>,
				< -66.176012, 39.338335, -28.525310>,
				< -64.774796, 33.038940, -61.613690>
			}
			triangle {
				< -66.176012, 39.338335, -28.525310>,
				< -58.635943, 28.706413, -34.442175>,
				< -64.774796, 33.038940, -61.613690>
			}
			triangle {
				< -66.176012, 39.338335, -28.525310>,
				< -57.696477, 30.075062, 3.102704>,
				< -58.635943, 28.706413, -34.442175>
			}
			triangle {
				< -57.696477, 30.075062, 3.102704>,
				< -51.976707, 21.142960, -8.728982>,
				< -58.635943, 28.706413, -34.442175>
			}
			triangle {
				< -57.696477, 30.075062, 3.102704>,
				< -49.231917, 17.485792, 30.755850>,
				< -51.976707, 21.142960, -8.728982>
			}
			triangle {
				< -49.231917, 17.485792, 30.755850>,
				< -45.444243, 10.863834, 13.808287>,
				< -51.976707, 21.142960, -8.728982>
			}
			triangle {
				< -49.231917, 17.485792, 30.755850>,
				< -41.804787, 2.428727, 52.674279>,
				< -45.444243, 10.863834, 13.808287>
			}
			triangle {
				< -41.804787, 2.428727, 52.674279>,
				< -39.779443, -1.430075, 31.715166>,
				< -45.444243, 10.863834, 13.808287>
			}
			triangle {
				< -41.804787, 2.428727, 52.674279>,
				< -36.399193, -14.070411, 67.529455>,
				< -39.779443, -1.430075, 31.715166>
			}
			triangle {
				< -36.399193, -14.070411, 67.529455>,
				< -35.686668, -14.901525, 43.876100>,
				< -39.779443, -1.430075, 31.715166>
			}
			triangle {
				< -36.399193, -14.070411, 67.529455>,
				< -33.769231, -30.886896, 74.459732>,
				< -35.686668, -14.901525, 43.876100>
			}
			triangle {
				< -33.769231, -30.886896, 74.459732>,
				< -33.702992, -28.632188, 49.556881>,
				< -35.686668, -14.901525, 43.876100>
			}
			triangle {
				< -33.769231, -30.886896, 74.459732>,
				< -34.291290, -46.874881, 73.074482>,
				< -33.702992, -28.632188, 49.556881>
			}
			triangle {
				< -34.291290, -46.874881, 73.074482>,
				< -34.095835, -41.686293, 48.421089>,
				< -33.702992, -28.632188, 49.556881>
			}
			triangle {
				< -34.291290, -46.874881, 73.074482>,
				< -37.889659, -60.944755, 63.451380>,
				< -34.095835, -41.686293, 48.421089>
			}
			triangle {
				< -37.889659, -60.944755, 63.451380>,
				< -36.811404, -53.174272, 40.535931>,
				< -34.095835, -41.686293, 48.421089>
			}
			triangle {
				< -37.889659, -60.944755, 63.451380>,
				< -44.050977, -72.137594, 46.137065>,
				< -36.811404, -53.174272, 40.535931>
			}
			triangle {
				< -44.050977, -72.137594, 46.137065>,
				< -41.485142, -62.313236, 26.370466>,
				< -36.811404, -53.174272, 40.535931>
			}
			triangle {
				< -44.050977, -72.137594, 46.137065>,
				< -51.927030, -79.690799, 22.149595>,
				< -41.485142, -62.313236, 26.370466>
			}
			triangle {
				< -51.927030, -79.690799, 22.149595>,
				< -47.511894, -68.480372, 6.788464>,
				< -41.485142, -62.313236, 26.370466>
			}
			triangle {
				< -51.927030, -79.690799, 22.149595>,
				< -60.499266, -83.089456, -7.033710>,
				< -47.511894, -68.480372, 6.788464>
			}
			triangle {
				< -60.499266, -83.089456, -7.033710>,
				< -54.160692, -71.255371, -16.976234>,
				< -47.511894, -68.480372, 6.788464>
			}
			triangle {
				< -60.499266, -83.089456, -7.033710>,
				< -68.776041, -82.102090, -39.525904>,
				< -54.160692, -71.255371, -16.976234>
			}
			triangle {
				< -68.776041, -82.102090, -39.525904>,
				< -60.708851, -70.449181, -43.371908>,
				< -54.160692, -71.255371, -16.976234>
			}
			triangle {
				< -68.776041, -82.102090, -39.525904>,
				< -75.970650, -76.795898, -73.132649>,
				< -60.708851, -70.449181, -43.371908>
			}
			triangle {
				< -75.970650, -76.795898, -73.132649>,
				< -66.564359, -66.116698, -70.617050>,
				< -60.708851, -70.449181, -43.371908>
			}
			triangle {
				< -75.970650, -76.795898, -73.132649>,
				< -81.619829, -67.532510, -105.507411>,
				< -66.564359, -66.116698, -70.617050>
			}
			triangle {
				< -81.619829, -67.532510, -105.507411>,
				< -71.348101, -58.553215, -96.823223>,
				< -66.564359, -66.116698, -70.617050>
			}
			triangle {
				< -81.619829, -67.532510, -105.507411>,
				< -85.613191, -54.943249, -134.340778>,
				< -71.348101, -58.553215, -96.823223>
			}
			triangle {
				< -85.613191, -54.943249, -134.340778>,
				< -74.916825, -48.274100, -120.139845>,
				< -71.348101, -58.553215, -96.823223>
			}
			triangle {
				< -85.613191, -54.943249, -134.340778>,
				< -88.128656, -39.886035, -157.555237>,
				< -74.916825, -48.274100, -120.139845>
			}
			triangle {
				< -88.128656, -39.886035, -157.555237>,
				< -77.325143, -35.979934, -138.903320>,
				< -74.916825, -48.274100, -120.139845>
			}
			triangle {
				< -88.128656, -39.886035, -157.555237>,
				< -89.497849, -23.386957, -173.475623>,
				< -77.325143, -35.979934, -138.903320>
			}
			triangle {
				< -89.497849, -23.386957, -173.475623>,
				< -78.740902, -22.508468, -151.768565>,
				< -77.325143, -35.979934, -138.903320>
			}
			triangle {
				< -89.497849, -23.386957, -173.475623>,
				< -90.044968, -6.570403, -180.955887>,
				< -78.740902, -22.508468, -151.768565>
			}
			triangle {
				< -90.044968, -6.570403, -180.955887>,
				< -79.342939, -8.777827, -157.813221>,
				< -78.740902, -22.508468, -151.768565>
			}
			triangle {
				< -90.044968, -6.570403, -180.955887>,
				< -89.949191, 9.417593, -179.459855>,
				< -79.342939, -8.777827, -157.813221>
			}
			triangle {
				< -89.949191, 9.417593, -179.459855>,
				< -79.232894, 4.276291, -156.604275>,
				< -79.342939, -8.777827, -157.813221>
			}
			triangle {
				< -101.074904, 12.636539, -193.624020>,
				< -100.386173, 28.329492, -181.948379>,
				< -89.949191, 9.417593, -179.459855>
			}
			triangle {
				< -100.386173, 28.329492, -181.948379>,
				< -89.172736, 23.487164, -169.094443>,
				< -89.949191, 9.417593, -179.459855>
			}
			triangle {
				< -100.386173, 28.329492, -181.948379>,
				< -98.767348, 40.813535, -161.119193>,
				< -89.172736, 23.487164, -169.094443>
			}
			triangle {
				< -98.767348, 40.813535, -161.119193>,
				< -87.475553, 34.680061, -150.603607>,
				< -89.172736, 23.487164, -169.094443>
			}
			triangle {
				< -98.767348, 40.813535, -161.119193>,
				< -95.750079, 49.237978, -132.639840>,
				< -87.475553, 34.680061, -150.603607>
			}
			triangle {
				< -95.750079, 49.237978, -132.639840>,
				< -84.512822, 42.233225, -125.319242>,
				< -87.475553, 34.680061, -150.603607>
			}
			triangle {
				< -95.750079, 49.237978, -132.639840>,
				< -90.911023, 53.028714, -98.575719>,
				< -84.512822, 42.233225, -125.319242>
			}
			triangle {
				< -90.911023, 53.028714, -98.575719>,
				< -79.985492, 45.631886, -95.066421>,
				< -84.512822, 42.233225, -125.319242>
			}
			triangle {
				< -90.911023, 53.028714, -98.575719>,
				< -84.074154, 51.927436, -61.391909>,
				< -79.985492, 45.631886, -95.066421>
			}
			triangle {
				< -84.074154, 51.927436, -61.391909>,
				< -73.798463, 44.644520, -62.020477>,
				< -79.985492, 45.631886, -95.066421>
			}
			triangle {
				< -84.074154, 51.927436, -61.391909>,
				< -75.459518, 46.009131, -23.743531>,
				< -73.798463, 44.644520, -62.020477>
			}
			triangle {
				< -75.459518, 46.009131, -23.743531>,
				< -66.176012, 39.338335, -28.525310>,
				< -73.798463, 44.644520, -62.020477>
			}
			triangle {
				< -75.459518, 46.009131, -23.743531>,
				< -65.730616, 35.677459, 11.754901>,
				< -66.176012, 39.338335, -28.525310>
			}
			triangle {
				< -65.730616, 35.677459, 11.754901>,
				< -57.696477, 30.075062, 3.102704>,
				< -66.176012, 39.338335, -28.525310>
			}
			triangle {
				< -65.730616, 35.677459, 11.754901>,
				< -55.920966, 21.635782, 42.740703>,
				< -57.696477, 30.075062, 3.102704>
			}
			triangle {
				< -55.920966, 21.635782, 42.740703>,
				< -49.231917, 17.485792, 30.755850>,
				< -57.696477, 30.075062, 3.102704>
			}
			triangle {
				< -55.920966, 21.635782, 42.740703>,
				< -47.257237, 4.841822, 67.259997>,
				< -49.231917, 17.485792, 30.755850>
			}
			triangle {
				< -47.257237, 4.841822, 67.259997>,
				< -41.804787, 2.428727, 52.674279>,
				< -49.231917, 17.485792, 30.755850>
			}
			triangle {
				< -47.257237, 4.841822, 67.259997>,
				< -40.926613, -13.560559, 83.854660>,
				< -41.804787, 2.428727, 52.674279>
			}
			triangle {
				< -40.926613, -13.560559, 83.854660>,
				< -36.399193, -14.070411, 67.529455>,
				< -41.804787, 2.428727, 52.674279>
			}
			triangle {
				< -40.926613, -13.560559, 83.854660>,
				< -37.840281, -32.316975, 91.589570>,
				< -36.399193, -14.070411, 67.529455>
			}
			triangle {
				< -37.840281, -32.316975, 91.589570>,
				< -33.769231, -30.886896, 74.459732>,
				< -36.399193, -14.070411, 67.529455>
			}
			triangle {
				< -37.840281, -32.316975, 91.589570>,
				< -38.453735, -50.149247, 90.043783>,
				< -33.769231, -30.886896, 74.459732>
			}
			triangle {
				< -38.453735, -50.149247, 90.043783>,
				< -34.291290, -46.874881, 73.074482>,
				< -33.769231, -30.886896, 74.459732>
			}
			triangle {
				< -38.453735, -50.149247, 90.043783>,
				< -42.675123, -65.842122, 79.300828>,
				< -34.291290, -46.874881, 73.074482>
			}
			triangle {
				< -42.675123, -65.842122, 79.300828>,
				< -37.889659, -60.944755, 63.451380>,
				< -34.291290, -46.874881, 73.074482>
			}
			triangle {
				< -42.675123, -65.842122, 79.300828>,
				< -49.883932, -78.326121, 59.950706>,
				< -37.889659, -60.944755, 63.451380>
			}
			triangle {
				< -49.883932, -78.326121, 59.950706>,
				< -44.050977, -72.137594, 46.137065>,
				< -37.889659, -60.944755, 63.451380>
			}
			triangle {
				< -49.883932, -78.326121, 59.950706>,
				< -59.054825, -86.750619, 33.102669>,
				< -44.050977, -72.137594, 46.137065>
			}
			triangle {
				< -59.054825, -86.750619, 33.102669>,
				< -51.927030, -79.690799, 22.149595>,
				< -44.050977, -72.137594, 46.137065>
			}
			triangle {
				< -59.054825, -86.750619, 33.102669>,
				< -68.961009, -90.541333, 0.384062>,
				< -51.927030, -79.690799, 22.149595>
			}
			triangle {
				< -68.961009, -90.541333, 0.384062>,
				< -60.499266, -83.089456, -7.033710>,
				< -51.927030, -79.690799, 22.149595>
			}
			triangle {
				< -68.961009, -90.541333, 0.384062>,
				< -78.416303, -89.440033, -36.102831>,
				< -60.499266, -83.089456, -7.033710>
			}
			triangle {
				< -78.416303, -89.440033, -36.102831>,
				< -68.776041, -82.102090, -39.525904>,
				< -60.499266, -83.089456, -7.033710>
			}
			triangle {
				< -78.416303, -89.440033, -36.102831>,
				< -86.494789, -83.521776, -73.891565>,
				< -68.776041, -82.102090, -39.525904>
			}
			triangle {
				< -86.494789, -83.521776, -73.891565>,
				< -75.970650, -76.795898, -73.132649>,
				< -68.776041, -82.102090, -39.525904>
			}
			triangle {
				< -86.494789, -83.521776, -73.891565>,
				< -92.677653, -73.189855, -110.329822>,
				< -75.970650, -76.795898, -73.132649>
			}
			triangle {
				< -92.677653, -73.189855, -110.329822>,
				< -81.619829, -67.532510, -105.507411>,
				< -75.970650, -76.795898, -73.132649>
			}
			triangle {
				< -92.677653, -73.189855, -110.329822>,
				< -96.886523, -59.148330, -142.800435>,
				< -81.619829, -67.532510, -105.507411>
			}
			triangle {
				< -96.886523, -59.148330, -142.800435>,
				< -85.613191, -54.943249, -134.340778>,
				< -81.619829, -67.532510, -105.507411>
			}
			triangle {
				< -96.886523, -59.148330, -142.800435>,
				< -99.399060, -42.354159, -168.949649>,
				< -85.613191, -54.943249, -134.340778>
			}
			triangle {
				< -99.399060, -42.354159, -168.949649>,
				< -88.128656, -39.886035, -157.555237>,
				< -85.613191, -54.943249, -134.340778>
			}
			triangle {
				< -99.399060, -42.354159, -168.949649>,
				< -100.675933, -23.951842, -186.883107>,
				< -88.128656, -39.886035, -157.555237>
			}
			triangle {
				< -100.675933, -23.951842, -186.883107>,
				< -89.497849, -23.386957, -173.475623>,
				< -88.128656, -39.886035, -157.555237>
			}
			triangle {
				< -100.675933, -23.951842, -186.883107>,
				< -101.154767, -5.195425, -195.309073>,
				< -89.497849, -23.386957, -173.475623>
			}
			triangle {
				< -101.154767, -5.195425, -195.309073>,
				< -90.044968, -6.570403, -180.955887>,
				< -89.497849, -23.386957, -173.475623>
			}
			triangle {
				< -101.154767, -5.195425, -195.309073>,
				< -101.074904, 12.636539, -193.624020>,
				< -90.044968, -6.570403, -180.955887>
			}
			triangle {
				< -101.074904, 12.636539, -193.624020>,
				< -89.949191, 9.417593, -179.459855>,
				< -90.044968, -6.570403, -180.955887>
			}
			triangle {
				< -112.292401, 13.714448, -197.888106>,
				< -111.633845, 29.960943, -185.688734>,
				< -101.074904, 12.636539, -193.624020>
			}
			triangle {
				< -111.633845, 29.960943, -185.688734>,
				< -100.386173, 28.329492, -181.948379>,
				< -101.074904, 12.636539, -193.624020>
			}
			triangle {
				< -111.633845, 29.960943, -185.688734>,
				< -110.037759, 42.885374, -163.925320>,
				< -100.386173, 28.329492, -181.948379>
			}
			triangle {
				< -110.037759, 42.885374, -163.925320>,
				< -98.767348, 40.813535, -161.119193>,
				< -100.386173, 28.329492, -181.948379>
			}
			triangle {
				< -110.037759, 42.885374, -163.925320>,
				< -106.987253, 51.607035, -134.169757>,
				< -98.767348, 40.813535, -161.119193>
			}
			triangle {
				< -106.987253, 51.607035, -134.169757>,
				< -95.750079, 49.237978, -132.639840>,
				< -98.767348, 40.813535, -161.119193>
			}
			triangle {
				< -106.987253, 51.607035, -134.169757>,
				< -102.010384, 55.531491, -98.583043>,
				< -95.750079, 49.237978, -132.639840>
			}
			triangle {
				< -102.010384, 55.531491, -98.583043>,
				< -90.911023, 53.028714, -98.575719>,
				< -95.750079, 49.237978, -132.639840>
			}
			triangle {
				< -102.010384, 55.531491, -98.583043>,
				< -94.899781, 54.391339, -59.747241>,
				< -90.911023, 53.028714, -98.575719>
			}
			triangle {
				< -94.899781, 54.391339, -59.747241>,
				< -84.074154, 51.927436, -61.391909>,
				< -90.911023, 53.028714, -98.575719>
			}
			triangle {
				< -94.899781, 54.391339, -59.747241>,
				< -85.875288, 48.264317, -20.441972>,
				< -84.074154, 51.927436, -61.391909>
			}
			triangle {
				< -85.875288, 48.264317, -20.441972>,
				< -75.459518, 46.009131, -23.743531>,
				< -84.074154, 51.927436, -61.391909>
			}
			triangle {
				< -85.875288, 48.264317, -20.441972>,
				< -75.635388, 37.567906, 16.598979>,
				< -75.459518, 46.009131, -23.743531>
			}
			triangle {
				< -75.635388, 37.567906, 16.598979>,
				< -65.730616, 35.677459, 11.754901>,
				< -75.459518, 46.009131, -23.743531>
			}
			triangle {
				< -75.635388, 37.567906, 16.598979>,
				< -65.278783, 23.031242, 48.911277>,
				< -65.730616, 35.677459, 11.754901>
			}
			triangle {
				< -65.278783, 23.031242, 48.911277>,
				< -55.920966, 21.635782, 42.740703>,
				< -65.730616, 35.677459, 11.754901>
			}
			triangle {
				< -65.278783, 23.031242, 48.911277>,
				< -56.114525, 5.644655, 74.464433>,
				< -55.920966, 21.635782, 42.740703>
			}
			triangle {
				< -56.114525, 5.644655, 74.464433>,
				< -47.257237, 4.841822, 67.259997>,
				< -55.920966, 21.635782, 42.740703>
			}
			triangle {
				< -56.114525, 5.644655, 74.464433>,
				< -49.410123, -13.406832, 91.750003>,
				< -47.257237, 4.841822, 67.259997>
			}
			triangle {
				< -49.410123, -13.406832, 91.750003>,
				< -40.926613, -13.560559, 83.854660>,
				< -47.257237, 4.841822, 67.259997>
			}
			triangle {
				< -49.410123, -13.406832, 91.750003>,
				< -46.139892, -32.824878, 99.803984>,
				< -40.926613, -13.560559, 83.854660>
			}
			triangle {
				< -46.139892, -32.824878, 99.803984>,
				< -37.840281, -32.316975, 91.589570>,
				< -40.926613, -13.560559, 83.854660>
			}
			triangle {
				< -46.139892, -32.824878, 99.803984>,
				< -46.790272, -51.286198, 98.194428>,
				< -37.840281, -32.316975, 91.589570>
			}
			triangle {
				< -46.790272, -51.286198, 98.194428>,
				< -38.453735, -50.149247, 90.043783>,
				< -37.840281, -32.316975, 91.589570>
			}
			triangle {
				< -46.790272, -51.286198, 98.194428>,
				< -51.263183, -67.532673, 87.007061>,
				< -38.453735, -50.149247, 90.043783>
			}
			triangle {
				< -51.263183, -67.532673, 87.007061>,
				< -42.675123, -65.842122, 79.300828>,
				< -38.453735, -50.149247, 90.043783>
			}
			triangle {
				< -51.263183, -67.532673, 87.007061>,
				< -58.895424, -80.457106, 66.848360>,
				< -42.675123, -65.842122, 79.300828>
			}
			triangle {
				< -58.895424, -80.457106, 66.848360>,
				< -49.883932, -78.326121, 59.950706>,
				< -42.675123, -65.842122, 79.300828>
			}
			triangle {
				< -58.895424, -80.457106, 66.848360>,
				< -68.591177, -89.178726, 38.862623>,
				< -49.883932, -78.326121, 59.950706>
			}
			triangle {
				< -68.591177, -89.178726, 38.862623>,
				< -59.054825, -86.750619, 33.102669>,
				< -49.883932, -78.326121, 59.950706>
			}
			triangle {
				< -68.591177, -89.178726, 38.862623>,
				< -79.040676, -93.103223, 4.736361>,
				< -59.054825, -86.750619, 33.102669>
			}
			triangle {
				< -79.040676, -93.103223, 4.736361>,
				< -68.961009, -90.541333, 0.384062>,
				< -59.054825, -86.750619, 33.102669>
			}
			triangle {
				< -79.040676, -93.103223, 4.736361>,
				< -88.979311, -91.963038, -33.343095>,
				< -68.961009, -90.541333, 0.384062>
			}
			triangle {
				< -88.979311, -91.963038, -33.343095>,
				< -78.416303, -89.440033, -36.102831>,
				< -68.961009, -90.541333, 0.384062>
			}
			triangle {
				< -88.979311, -91.963038, -33.343095>,
				< -97.424753, -85.836031, -72.800890>,
				< -78.416303, -89.440033, -36.102831>
			}
			triangle {
				< -97.424753, -85.836031, -72.800890>,
				< -86.494789, -83.521776, -73.891565>,
				< -78.416303, -89.440033, -36.102831>
			}
			triangle {
				< -97.424753, -85.836031, -72.800890>,
				< -103.834711, -75.139575, -110.861830>,
				< -86.494789, -83.521776, -73.891565>
			}
			triangle {
				< -103.834711, -75.139575, -110.861830>,
				< -92.677653, -73.189855, -110.329822>,
				< -86.494789, -83.521776, -73.891565>
			}
			triangle {
				< -103.834711, -75.139575, -110.861830>,
				< -108.142436, -60.602751, -144.785360>,
				< -92.677653, -73.189855, -110.329822>
			}
			triangle {
				< -108.142436, -60.602751, -144.785360>,
				< -96.886523, -59.148330, -142.800435>,
				< -92.677653, -73.189855, -110.329822>
			}
			triangle {
				< -108.142436, -60.602751, -144.785360>,
				< -110.664345, -43.216169, -172.107056>,
				< -96.886523, -59.148330, -142.800435>
			}
			triangle {
				< -110.664345, -43.216169, -172.107056>,
				< -99.399060, -42.354159, -168.949649>,
				< -96.886523, -59.148330, -142.800435>
			}
			triangle {
				< -110.664345, -43.216169, -172.107056>,
				< -111.911647, -24.164677, -190.844789>,
				< -99.399060, -42.354159, -168.949649>
			}
			triangle {
				< -111.911647, -24.164677, -190.844789>,
				< -100.675933, -23.951842, -186.883107>,
				< -99.399060, -42.354159, -168.949649>
			}
			triangle {
				< -111.911647, -24.164677, -190.844789>,
				< -112.366602, -4.746566, -199.648634>,
				< -100.675933, -23.951842, -186.883107>
			}
			triangle {
				< -112.366602, -4.746566, -199.648634>,
				< -101.154767, -5.195425, -195.309073>,
				< -100.675933, -23.951842, -186.883107>
			}
			triangle {
				< -112.366602, -4.746566, -199.648634>,
				< -112.292401, 13.714448, -197.888106>,
				< -101.154767, -5.195425, -195.309073>
			}
			triangle {
				< -112.292401, 13.714448, -197.888106>,
				< -101.074904, 12.636539, -193.624020>,
				< -101.154767, -5.195425, -195.309073>
			}
			triangle {
				< -122.978739, 12.577496, -191.688225>,
				< -122.263752, 28.270381, -179.809272>,
				< -112.292401, 13.714448, -197.888106>
			}
			triangle {
				< -122.263752, 28.270381, -179.809272>,
				< -111.633845, 29.960943, -185.688734>,
				< -112.292401, 13.714448, -197.888106>
			}
			triangle {
				< -122.263752, 28.270381, -179.809272>,
				< -120.591752, 40.754423, -158.618927>,
				< -111.633845, 29.960943, -185.688734>
			}
			triangle {
				< -120.591752, 40.754423, -158.618927>,
				< -110.037759, 42.885374, -163.925320>,
				< -111.633845, 29.960943, -185.688734>
			}
			triangle {
				< -120.591752, 40.754423, -158.618927>,
				< -117.488898, 49.178898, -129.646882>,
				< -110.037759, 42.885374, -163.925320>
			}
			triangle {
				< -117.488898, 49.178898, -129.646882>,
				< -106.987253, 51.607035, -134.169757>,
				< -110.037759, 42.885374, -163.925320>
			}
			triangle {
				< -117.488898, 49.178898, -129.646882>,
				< -112.527750, 52.969627, -94.995610>,
				< -106.987253, 51.607035, -134.169757>
			}
			triangle {
				< -112.527750, 52.969627, -94.995610>,
				< -102.010384, 55.531491, -98.583043>,
				< -106.987253, 51.607035, -134.169757>
			}
			triangle {
				< -112.527750, 52.969627, -94.995610>,
				< -105.532713, 51.868349, -57.173960>,
				< -102.010384, 55.531491, -98.583043>
			}
			triangle {
				< -105.532713, 51.868349, -57.173960>,
				< -94.899781, 54.391339, -59.747241>,
				< -102.010384, 55.531491, -98.583043>
			}
			triangle {
				< -105.532713, 51.868349, -57.173960>,
				< -96.731082, 45.950104, -18.883346>,
				< -94.899781, 54.391339, -59.747241>
			}
			triangle {
				< -96.731082, 45.950104, -18.883346>,
				< -85.875288, 48.264317, -20.441972>,
				< -94.899781, 54.391339, -59.747241>
			}
			triangle {
				< -96.731082, 45.950104, -18.883346>,
				< -86.800426, 35.618193, 17.217154>,
				< -85.875288, 48.264317, -20.441972>
			}
			triangle {
				< -86.800426, 35.618193, 17.217154>,
				< -75.635388, 37.567906, 16.598979>,
				< -85.875288, 48.264317, -20.441972>
			}
			triangle {
				< -86.800426, 35.618193, 17.217154>,
				< -76.793946, 21.576716, 48.725337>,
				< -75.635388, 37.567906, 16.598979>
			}
			triangle {
				< -76.793946, 21.576716, 48.725337>,
				< -65.278783, 23.031242, 48.911277>,
				< -75.635388, 37.567906, 16.598979>
			}
			triangle {
				< -76.793946, 21.576716, 48.725337>,
				< -67.960747, 4.782692, 73.655821>,
				< -65.278783, 23.031242, 48.911277>
			}
			triangle {
				< -67.960747, 4.782692, 73.655821>,
				< -56.114525, 5.644655, 74.464433>,
				< -65.278783, 23.031242, 48.911277>
			}
			triangle {
				< -67.960747, 4.782692, 73.655821>,
				< -61.508074, -13.619667, 90.527728>,
				< -56.114525, 5.644655, 74.464433>
			}
			triangle {
				< -61.508074, -13.619667, 90.527728>,
				< -49.410123, -13.406832, 91.750003>,
				< -56.114525, 5.644655, 74.464433>
			}
			triangle {
				< -61.508074, -13.619667, 90.527728>,
				< -58.363046, -32.376062, 98.391235>,
				< -49.410123, -13.406832, 91.750003>
			}
			triangle {
				< -58.363046, -32.376062, 98.391235>,
				< -46.139892, -32.824878, 99.803984>,
				< -49.410123, -13.406832, 91.750003>
			}
			triangle {
				< -58.363046, -32.376062, 98.391235>,
				< -58.988303, -50.208334, 96.819855>,
				< -46.139892, -32.824878, 99.803984>
			}
			triangle {
				< -58.988303, -50.208334, 96.819855>,
				< -46.790272, -51.286198, 98.194428>,
				< -46.139892, -32.824878, 99.803984>
			}
			triangle {
				< -58.988303, -50.208334, 96.819855>,
				< -63.290708, -65.901212, 85.897878>,
				< -46.790272, -51.286198, 98.194428>
			}
			triangle {
				< -63.290708, -65.901212, 85.897878>,
				< -51.263183, -67.532673, 87.007061>,
				< -46.790272, -51.286198, 98.194428>
			}
			triangle {
				< -63.290708, -65.901212, 85.897878>,
				< -70.639282, -78.385256, 66.224284>,
				< -51.263183, -67.532673, 87.007061>
			}
			triangle {
				< -70.639282, -78.385256, 66.224284>,
				< -58.895424, -80.457106, 66.848360>,
				< -51.263183, -67.532673, 87.007061>
			}
			triangle {
				< -70.639282, -78.385256, 66.224284>,
				< -79.991028, -86.809695, 38.925152>,
				< -58.895424, -80.457106, 66.848360>
			}
			triangle {
				< -79.991028, -86.809695, 38.925152>,
				< -68.591177, -89.178726, 38.862623>,
				< -58.895424, -80.457106, 66.848360>
			}
			triangle {
				< -79.991028, -86.809695, 38.925152>,
				< -90.098150, -90.600416, 5.653748>,
				< -68.591177, -89.178726, 38.862623>
			}
			triangle {
				< -90.098150, -90.600416, 5.653748>,
				< -79.040676, -93.103223, 4.736361>,
				< -68.591177, -89.178726, 38.862623>
			}
			triangle {
				< -90.098150, -90.600416, 5.653748>,
				< -99.752240, -89.499131, -31.453144>,
				< -79.040676, -93.103223, 4.736361>
			}
			triangle {
				< -99.752240, -89.499131, -31.453144>,
				< -88.979311, -91.963038, -33.343095>,
				< -79.040676, -93.103223, 4.736361>
			}
			triangle {
				< -99.752240, -89.499131, -31.453144>,
				< -108.009487, -83.580866, -69.887899>,
				< -88.979311, -91.963038, -33.343095>
			}
			triangle {
				< -108.009487, -83.580866, -69.887899>,
				< -97.424753, -85.836031, -72.800890>,
				< -88.979311, -91.963038, -33.343095>
			}
			triangle {
				< -108.009487, -83.580866, -69.887899>,
				< -114.338957, -73.248938, -106.952280>,
				< -97.424753, -85.836031, -72.800890>
			}
			triangle {
				< -114.338957, -73.248938, -106.952280>,
				< -103.834711, -75.139575, -110.861830>,
				< -97.424753, -85.836031, -72.800890>
			}
			triangle {
				< -114.338957, -73.248938, -106.952280>,
				< -118.657596, -59.207410, -139.983177>,
				< -103.834711, -75.139575, -110.861830>
			}
			triangle {
				< -118.657596, -59.207410, -139.983177>,
				< -108.142436, -60.602751, -144.785360>,
				< -103.834711, -75.139575, -110.861830>
			}
			triangle {
				< -118.657596, -59.207410, -139.983177>,
				< -121.244378, -42.413227, -166.585222>,
				< -108.142436, -60.602751, -144.785360>
			}
			triangle {
				< -121.244378, -42.413227, -166.585222>,
				< -110.664345, -43.216169, -172.107056>,
				< -108.142436, -60.602751, -144.785360>
			}
			triangle {
				< -121.244378, -42.413227, -166.585222>,
				< -122.564949, -24.010958, -184.829861>,
				< -110.664345, -43.216169, -172.107056>
			}
			triangle {
				< -122.564949, -24.010958, -184.829861>,
				< -111.911647, -24.164677, -190.844789>,
				< -110.664345, -43.216169, -172.107056>
			}
			triangle {
				< -122.564949, -24.010958, -184.829861>,
				< -123.062216, -5.254498, -193.402410>,
				< -111.911647, -24.164677, -190.844789>
			}
			triangle {
				< -123.062216, -5.254498, -193.402410>,
				< -112.366602, -4.746566, -199.648634>,
				< -111.911647, -24.164677, -190.844789>
			}
			triangle {
				< -123.062216, -5.254498, -193.402410>,
				< -122.978739, 12.577496, -191.688225>,
				< -112.366602, -4.746566, -199.648634>
			}
			triangle {
				< -122.978739, 12.577496, -191.688225>,
				< -112.292401, 13.714448, -197.888106>,
				< -112.366602, -4.746566, -199.648634>
			}
			triangle {
				< -132.197216, 9.303412, -175.210655>,
				< -131.369889, 23.372987, -164.495006>,
				< -122.978739, 12.577496, -191.688225>
			}
			triangle {
				< -131.369889, 23.372987, -164.495006>,
				< -122.263752, 28.270381, -179.809272>,
				< -122.978739, 12.577496, -191.688225>
			}
			triangle {
				< -131.369889, 23.372987, -164.495006>,
				< -129.572332, 34.565900, -145.380303>,
				< -122.263752, 28.270381, -179.809272>
			}
			triangle {
				< -129.572332, 34.565900, -145.380303>,
				< -120.591752, 40.754423, -158.618927>,
				< -122.263752, 28.270381, -179.809272>
			}
			triangle {
				< -129.572332, 34.565900, -145.380303>,
				< -126.452297, 42.119045, -119.244941>,
				< -120.591752, 40.754423, -158.618927>
			}
			triangle {
				< -126.452297, 42.119045, -119.244941>,
				< -117.488898, 49.178898, -129.646882>,
				< -120.591752, 40.754423, -158.618927>
			}
			triangle {
				< -126.452297, 42.119045, -119.244941>,
				< -121.706121, 45.517754, -87.977789>,
				< -117.488898, 49.178898, -129.646882>
			}
			triangle {
				< -121.706121, 45.517754, -87.977789>,
				< -112.527750, 52.969627, -94.995610>,
				< -117.488898, 49.178898, -129.646882>
			}
			triangle {
				< -121.706121, 45.517754, -87.977789>,
				< -115.241408, 44.530358, -53.828467>,
				< -112.527750, 52.969627, -94.995610>
			}
			triangle {
				< -115.241408, 44.530358, -53.828467>,
				< -105.532713, 51.868349, -57.173960>,
				< -112.527750, 52.969627, -94.995610>
			}
			triangle {
				< -115.241408, 44.530358, -53.828467>,
				< -107.295714, 39.224152, -19.220445>,
				< -105.532713, 51.868349, -57.173960>
			}
			triangle {
				< -107.295714, 39.224152, -19.220445>,
				< -96.731082, 45.950104, -18.883346>,
				< -105.532713, 51.868349, -57.173960>
			}
			triangle {
				< -107.295714, 39.224152, -19.220445>,
				< -98.471567, 29.960828, 13.452761>,
				< -96.731082, 45.950104, -18.883346>
			}
			triangle {
				< -98.471567, 29.960828, 13.452761>,
				< -86.800426, 35.618193, 17.217154>,
				< -96.731082, 45.950104, -18.883346>
			}
			triangle {
				< -98.471567, 29.960828, 13.452761>,
				< -89.673564, 17.371776, 42.015012>,
				< -86.800426, 35.618193, 17.217154>
			}
			triangle {
				< -89.673564, 17.371776, 42.015012>,
				< -76.793946, 21.576716, 48.725337>,
				< -86.800426, 35.618193, 17.217154>
			}
			triangle {
				< -89.673564, 17.371776, 42.015012>,
				< -81.960574, 2.314567, 64.650625>,
				< -76.793946, 21.576716, 48.725337>
			}
			triangle {
				< -81.960574, 2.314567, 64.650625>,
				< -67.960747, 4.782692, 73.655821>,
				< -76.793946, 21.576716, 48.725337>
			}
			triangle {
				< -81.960574, 2.314567, 64.650625>,
				< -76.350078, -14.184530, 79.990037>,
				< -67.960747, 4.782692, 73.655821>
			}
			triangle {
				< -76.350078, -14.184530, 79.990037>,
				< -61.508074, -13.619667, 90.527728>,
				< -67.960747, 4.782692, 73.655821>
			}
			triangle {
				< -76.350078, -14.184530, 79.990037>,
				< -73.621437, -31.001080, 87.145656>,
				< -61.508074, -13.619667, 90.527728>
			}
			triangle {
				< -73.621437, -31.001080, 87.145656>,
				< -58.363046, -32.376062, 98.391235>,
				< -61.508074, -13.619667, 90.527728>
			}
			triangle {
				< -73.621437, -31.001080, 87.145656>,
				< -74.163437, -46.989057, 85.715294>,
				< -58.363046, -32.376062, 98.391235>
			}
			triangle {
				< -74.163437, -46.989057, 85.715294>,
				< -58.988303, -50.208334, 96.819855>,
				< -58.363046, -32.376062, 98.391235>
			}
			triangle {
				< -74.163437, -46.989057, 85.715294>,
				< -77.897571, -61.058890, 75.779147>,
				< -58.988303, -50.208334, 96.819855>
			}
			triangle {
				< -77.897571, -61.058890, 75.779147>,
				< -63.290708, -65.901212, 85.897878>,
				< -58.988303, -50.208334, 96.819855>
			}
			triangle {
				< -77.897571, -61.058890, 75.779147>,
				< -84.294066, -72.251804, 57.899807>,
				< -63.290708, -65.901212, 85.897878>
			}
			triangle {
				< -84.294066, -72.251804, 57.899807>,
				< -70.639282, -78.385256, 66.224284>,
				< -63.290708, -65.901212, 85.897878>
			}
			triangle {
				< -84.294066, -72.251804, 57.899807>,
				< -92.475541, -79.804942, 33.126317>,
				< -70.639282, -78.385256, 66.224284>
			}
			triangle {
				< -92.475541, -79.804942, 33.126317>,
				< -79.991028, -86.809695, 38.925152>,
				< -70.639282, -78.385256, 66.224284>
			}
			triangle {
				< -92.475541, -79.804942, 33.126317>,
				< -101.388909, -83.203621, 2.981938>,
				< -79.991028, -86.809695, 38.925152>
			}
			triangle {
				< -101.388909, -83.203621, 2.981938>,
				< -90.098150, -90.600416, 5.653748>,
				< -79.991028, -86.809695, 38.925152>
			}
			triangle {
				< -101.388909, -83.203621, 2.981938>,
				< -110.006578, -82.216226, -30.586045>,
				< -90.098150, -90.600416, 5.653748>
			}
			triangle {
				< -110.006578, -82.216226, -30.586045>,
				< -99.752240, -89.499131, -31.453144>,
				< -90.098150, -90.600416, 5.653748>
			}
			triangle {
				< -110.006578, -82.216226, -30.586045>,
				< -117.511503, -76.910064, -65.311186>,
				< -99.752240, -89.499131, -31.453144>
			}
			triangle {
				< -117.511503, -76.910064, -65.311186>,
				< -108.009487, -83.580866, -69.887899>,
				< -99.752240, -89.499131, -31.453144>
			}
			triangle {
				< -117.511503, -76.910064, -65.311186>,
				< -123.419791, -67.646690, -98.768555>,
				< -108.009487, -83.580866, -69.887899>
			}
			triangle {
				< -123.419791, -67.646690, -98.768555>,
				< -114.338957, -73.248938, -106.952280>,
				< -108.009487, -83.580866, -69.887899>
			}
			triangle {
				< -123.419791, -67.646690, -98.768555>,
				< -127.611488, -55.057410, -128.570020>,
				< -114.338957, -73.248938, -106.952280>
			}
			triangle {
				< -127.611488, -55.057410, -128.570020>,
				< -118.657596, -59.207410, -139.983177>,
				< -114.338957, -73.248938, -106.952280>
			}
			triangle {
				< -127.611488, -55.057410, -128.570020>,
				< -130.264640, -40.000197, -152.566493>,
				< -118.657596, -59.207410, -139.983177>
			}
			triangle {
				< -130.264640, -40.000197, -152.566493>,
				< -121.244378, -42.413227, -166.585222>,
				< -118.657596, -59.207410, -139.983177>
			}
			triangle {
				< -130.264640, -40.000197, -152.566493>,
				< -131.717011, -23.501098, -169.024050>,
				< -121.244378, -42.413227, -166.585222>
			}
			triangle {
				< -131.717011, -23.501098, -169.024050>,
				< -122.564949, -24.010958, -184.829861>,
				< -121.244378, -42.413227, -166.585222>
			}
			triangle {
				< -131.717011, -23.501098, -169.024050>,
				< -132.300019, -6.684565, -176.757351>,
				< -122.564949, -24.010958, -184.829861>
			}
			triangle {
				< -132.300019, -6.684565, -176.757351>,
				< -123.062216, -5.254498, -193.402410>,
				< -122.564949, -24.010958, -184.829861>
			}
			triangle {
				< -132.300019, -6.684565, -176.757351>,
				< -132.197216, 9.303412, -175.210655>,
				< -123.062216, -5.254498, -193.402410>
			}
			triangle {
				< -132.197216, 9.303412, -175.210655>,
				< -122.978739, 12.577496, -191.688225>,
				< -123.062216, -5.254498, -193.402410>
			}
			triangle {
				< -138.806596, 4.114859, -149.454907>,
				< -137.894377, 15.602560, -140.676603>,
				< -132.197216, 9.303412, -175.210655>
			}
			triangle {
				< -137.894377, 15.602560, -140.676603>,
				< -131.369889, 23.372987, -164.495006>,
				< -132.197216, 9.303412, -175.210655>
			}
			triangle {
				< -137.894377, 15.602560, -140.676603>,
				< -136.050060, 24.741536, -125.017002>,
				< -131.369889, 23.372987, -164.495006>
			}
			triangle {
				< -136.050060, 24.741536, -125.017002>,
				< -129.572332, 34.565900, -145.380303>,
				< -131.369889, 23.372987, -164.495006>
			}
			triangle {
				< -136.050060, 24.741536, -125.017002>,
				< -133.082300, 30.908691, -103.600621>,
				< -129.572332, 34.565900, -145.380303>
			}
			triangle {
				< -133.082300, 30.908691, -103.600621>,
				< -126.452297, 42.119045, -119.244941>,
				< -129.572332, 34.565900, -145.380303>
			}
			triangle {
				< -133.082300, 30.908691, -103.600621>,
				< -128.848121, 33.683699, -77.963017>,
				< -126.452297, 42.119045, -119.244941>
			}
			triangle {
				< -128.848121, 33.683699, -77.963017>,
				< -121.706121, 45.517754, -87.977789>,
				< -126.452297, 42.119045, -119.244941>
			}
			triangle {
				< -128.848121, 33.683699, -77.963017>,
				< -123.357229, 32.877494, -49.930327>,
				< -121.706121, 45.517754, -87.977789>
			}
			triangle {
				< -123.357229, 32.877494, -49.930327>,
				< -115.241408, 44.530358, -53.828467>,
				< -121.706121, 45.517754, -87.977789>
			}
			triangle {
				< -123.357229, 32.877494, -49.930327>,
				< -116.846286, 28.545266, -21.473231>,
				< -115.241408, 44.530358, -53.828467>
			}
			triangle {
				< -116.846286, 28.545266, -21.473231>,
				< -107.295714, 39.224152, -19.220445>,
				< -115.241408, 44.530358, -53.828467>
			}
			triangle {
				< -116.846286, 28.545266, -21.473231>,
				< -109.797865, 20.981677, 5.451389>,
				< -107.295714, 39.224152, -19.220445>
			}
			triangle {
				< -109.797865, 20.981677, 5.451389>,
				< -98.471567, 29.960828, 13.452761>,
				< -107.295714, 39.224152, -19.220445>
			}
			triangle {
				< -109.797865, 20.981677, 5.451389>,
				< -102.894232, 10.702386, 29.045941>,
				< -98.471567, 29.960828, 13.452761>
			}
			triangle {
				< -102.894232, 10.702386, 29.045941>,
				< -89.673564, 17.371776, 42.015012>,
				< -98.471567, 29.960828, 13.452761>
			}
			triangle {
				< -102.894232, 10.702386, 29.045941>,
				< -96.913926, -1.591544, 47.789667>,
				< -89.673564, 17.371776, 42.015012>
			}
			triangle {
				< -96.913926, -1.591544, 47.789667>,
				< -81.960574, 2.314567, 64.650625>,
				< -89.673564, 17.371776, 42.015012>
			}
			triangle {
				< -96.913926, -1.591544, 47.789667>,
				< -92.596374, -15.062994, 60.517453>,
				< -81.960574, 2.314567, 64.650625>
			}
			triangle {
				< -92.596374, -15.062994, 60.517453>,
				< -76.350078, -14.184530, 79.990037>,
				< -81.960574, 2.314567, 64.650625>
			}
			triangle {
				< -92.596374, -15.062994, 60.517453>,
				< -90.504758, -28.793614, 66.462375>,
				< -76.350078, -14.184530, 79.990037>
			}
			triangle {
				< -90.504758, -28.793614, 66.462375>,
				< -73.621437, -31.001080, 87.145656>,
				< -76.350078, -14.184530, 79.990037>
			}
			triangle {
				< -90.504758, -28.793614, 66.462375>,
				< -90.919346, -41.847758, 65.273747>,
				< -73.621437, -31.001080, 87.145656>
			}
			triangle {
				< -90.919346, -41.847758, 65.273747>,
				< -74.163437, -46.989057, 85.715294>,
				< -73.621437, -31.001080, 87.145656>
			}
			triangle {
				< -90.919346, -41.847758, 65.273747>,
				< -93.783692, -53.335741, 57.021588>,
				< -74.163437, -46.989057, 85.715294>
			}
			triangle {
				< -93.783692, -53.335741, 57.021588>,
				< -77.897571, -61.058890, 75.779147>,
				< -74.163437, -46.989057, 85.715294>
			}
			triangle {
				< -93.783692, -53.335741, 57.021588>,
				< -98.715678, -62.474687, 42.195465>,
				< -77.897571, -61.058890, 75.779147>
			}
			triangle {
				< -98.715678, -62.474687, 42.195465>,
				< -84.294066, -72.251804, 57.899807>,
				< -77.897571, -61.058890, 75.779147>
			}
			triangle {
				< -98.715678, -62.474687, 42.195465>,
				< -105.080590, -68.641819, 21.697175>,
				< -84.294066, -72.251804, 57.899807>
			}
			triangle {
				< -105.080590, -68.641819, 21.697175>,
				< -92.475541, -79.804942, 33.126317>,
				< -84.294066, -72.251804, 57.899807>
			}
			triangle {
				< -105.080590, -68.641819, 21.697175>,
				< -112.110808, -71.416840, -3.184017>,
				< -92.475541, -79.804942, 33.126317>
			}
			triangle {
				< -112.110808, -71.416840, -3.184017>,
				< -101.388909, -83.203621, 2.981938>,
				< -92.475541, -79.804942, 33.126317>
			}
			triangle {
				< -112.110808, -71.416840, -3.184017>,
				< -119.045973, -70.610635, -30.825010>,
				< -101.388909, -83.203621, 2.981938>
			}
			triangle {
				< -119.045973, -70.610635, -30.825010>,
				< -110.006578, -82.216226, -30.586045>,
				< -101.388909, -83.203621, 2.981938>
			}
			triangle {
				< -119.045973, -70.610635, -30.825010>,
				< -125.261217, -66.278167, -59.361029>,
				< -110.006578, -82.216226, -30.586045>
			}
			triangle {
				< -125.261217, -66.278167, -59.361029>,
				< -117.511503, -76.910064, -65.311186>,
				< -110.006578, -82.216226, -30.586045>
			}
			triangle {
				< -125.261217, -66.278167, -59.361029>,
				< -130.353451, -58.714662, -86.813830>,
				< -117.511503, -76.910064, -65.311186>
			}
			triangle {
				< -130.353451, -58.714662, -86.813830>,
				< -123.419791, -67.646690, -98.768555>,
				< -117.511503, -76.910064, -65.311186>
			}
			triangle {
				< -130.353451, -58.714662, -86.813830>,
				< -134.166136, -48.435573, -111.243531>,
				< -123.419791, -67.646690, -98.768555>
			}
			triangle {
				< -134.166136, -48.435573, -111.243531>,
				< -127.611488, -55.057410, -128.570020>,
				< -123.419791, -67.646690, -98.768555>
			}
			triangle {
				< -134.166136, -48.435573, -111.243531>,
				< -136.750072, -36.141373, -130.904883>,
				< -127.611488, -55.057410, -128.570020>
			}
			triangle {
				< -136.750072, -36.141373, -130.904883>,
				< -130.264640, -40.000197, -152.566493>,
				< -127.611488, -55.057410, -128.570020>
			}
			triangle {
				< -136.750072, -36.141373, -130.904883>,
				< -138.275549, -22.669939, -144.387230>,
				< -130.264640, -40.000197, -152.566493>
			}
			triangle {
				< -138.275549, -22.669939, -144.387230>,
				< -131.717011, -23.501098, -169.024050>,
				< -130.264640, -40.000197, -152.566493>
			}
			triangle {
				< -138.275549, -22.669939, -144.387230>,
				< -138.926208, -8.939265, -150.722012>,
				< -131.717011, -23.501098, -169.024050>
			}
			triangle {
				< -138.926208, -8.939265, -150.722012>,
				< -132.300019, -6.684565, -176.757351>,
				< -131.717011, -23.501098, -169.024050>
			}
			triangle {
				< -138.926208, -8.939265, -150.722012>,
				< -138.806596, 4.114859, -149.454907>,
				< -132.300019, -6.684565, -176.757351>
			}
			triangle {
				< -138.806596, 4.114859, -149.454907>,
				< -132.197216, 9.303412, -175.210655>,
				< -132.300019, -6.684565, -176.757351>
			}
			triangle {
				< -141.677216, -2.634314, -116.222508>,
				< -140.816927, 5.488900, -110.017858>,
				< -138.806596, 4.114859, -149.454907>
			}
			triangle {
				< -140.816927, 5.488900, -110.017858>,
				< -137.894377, 15.602560, -140.676603>,
				< -138.806596, 4.114859, -149.454907>
			}
			triangle {
				< -140.816927, 5.488900, -110.017858>,
				< -139.171481, 11.950848, -98.946393>,
				< -137.894377, 15.602560, -140.676603>
			}
			triangle {
				< -139.171481, 11.950848, -98.946393>,
				< -136.050060, 24.741536, -125.017002>,
				< -137.894377, 15.602560, -140.676603>
			}
			triangle {
				< -139.171481, 11.950848, -98.946393>,
				< -136.694834, 16.311636, -83.795205>,
				< -136.050060, 24.741536, -125.017002>
			}
			triangle {
				< -136.694834, 16.311636, -83.795205>,
				< -133.082300, 30.908691, -103.600621>,
				< -136.050060, 24.741536, -125.017002>
			}
			triangle {
				< -136.694834, 16.311636, -83.795205>,
				< -133.383110, 18.273924, -65.637484>,
				< -133.082300, 30.908691, -103.600621>
			}
			triangle {
				< -133.383110, 18.273924, -65.637484>,
				< -128.848121, 33.683699, -77.963017>,
				< -133.082300, 30.908691, -103.600621>
			}
			triangle {
				< -133.383110, 18.273924, -65.637484>,
				< -129.321858, 17.703824, -45.750283>,
				< -128.848121, 33.683699, -77.963017>
			}
			triangle {
				< -129.321858, 17.703824, -45.750283>,
				< -123.357229, 32.877494, -49.930327>,
				< -128.848121, 33.683699, -77.963017>
			}
			triangle {
				< -129.321858, 17.703824, -45.750283>,
				< -124.717794, 14.640318, -25.515635>,
				< -123.357229, 32.877494, -49.930327>
			}
			triangle {
				< -124.717794, 14.640318, -25.515635>,
				< -116.846286, 28.545266, -21.473231>,
				< -123.357229, 32.877494, -49.930327>
			}
			triangle {
				< -124.717794, 14.640318, -25.515635>,
				< -119.902909, 9.292361, -6.317937>,
				< -116.846286, 28.545266, -21.473231>
			}
			triangle {
				< -119.902909, 9.292361, -6.317937>,
				< -109.797865, 20.981677, 5.451389>,
				< -116.846286, 28.545266, -21.473231>
			}
			triangle {
				< -119.902909, 9.292361, -6.317937>,
				< -115.305685, 2.023926, 10.555776>,
				< -109.797865, 20.981677, 5.451389>
			}
			triangle {
				< -115.305685, 2.023926, 10.555776>,
				< -102.894232, 10.702386, 29.045941>,
				< -109.797865, 20.981677, 5.451389>
			}
			triangle {
				< -115.305685, 2.023926, 10.555776>,
				< -111.394338, -6.669389, 23.998780>,
				< -102.894232, 10.702386, 29.045941>
			}
			triangle {
				< -111.394338, -6.669389, 23.998780>,
				< -96.913926, -1.591544, 47.789667>,
				< -102.894232, 10.702386, 29.045941>
			}
			triangle {
				< -111.394338, -6.669389, 23.998780>,
				< -108.603328, -16.195100, 33.148635>,
				< -96.913926, -1.591544, 47.789667>
			}
			triangle {
				< -108.603328, -16.195100, 33.148635>,
				< -92.596374, -15.062994, 60.517453>,
				< -96.913926, -1.591544, 47.789667>
			}
			triangle {
				< -108.603328, -16.195100, 33.148635>,
				< -107.259624, -25.904167, 37.428845>,
				< -92.596374, -15.062994, 60.517453>
			}
			triangle {
				< -107.259624, -25.904167, 37.428845>,
				< -90.504758, -28.793614, 66.462375>,
				< -92.596374, -15.062994, 60.517453>
			}
			triangle {
				< -107.259624, -25.904167, 37.428845>,
				< -107.525080, -35.134807, 36.572926>,
				< -90.504758, -28.793614, 66.462375>
			}
			triangle {
				< -107.525080, -35.134807, 36.572926>,
				< -90.919346, -41.847758, 65.273747>,
				< -90.504758, -28.793614, 66.462375>
			}
			triangle {
				< -107.525080, -35.134807, 36.572926>,
				< -109.367169, -43.258041, 30.634072>,
				< -90.919346, -41.847758, 65.273747>
			}
			triangle {
				< -109.367169, -43.258041, 30.634072>,
				< -93.783692, -53.335741, 57.021588>,
				< -90.919346, -41.847758, 65.273747>
			}
			triangle {
				< -109.367169, -43.258041, 30.634072>,
				< -112.565145, -49.720269, 19.983187>,
				< -93.783692, -53.335741, 57.021588>
			}
			triangle {
				< -112.565145, -49.720269, 19.983187>,
				< -98.715678, -62.474687, 42.195465>,
				< -93.783692, -53.335741, 57.021588>
			}
			triangle {
				< -112.565145, -49.720269, 19.983187>,
				< -116.749421, -54.081101, 5.295137>,
				< -98.715678, -62.474687, 42.195465>
			}
			triangle {
				< -116.749421, -54.081101, 5.295137>,
				< -105.080590, -68.641819, 21.697175>,
				< -98.715678, -62.474687, 42.195465>
			}
			triangle {
				< -116.749421, -54.081101, 5.295137>,
				< -121.466152, -56.043327, -12.481014>,
				< -105.080590, -68.641819, 21.697175>
			}
			triangle {
				< -121.466152, -56.043327, -12.481014>,
				< -112.110808, -71.416840, -3.184017>,
				< -105.080590, -68.641819, 21.697175>
			}
			triangle {
				< -121.466152, -56.043327, -12.481014>,
				< -126.253039, -55.473268, -32.171030>,
				< -112.110808, -71.416840, -3.184017>
			}
			triangle {
				< -126.253039, -55.473268, -32.171030>,
				< -119.045973, -70.610635, -30.825010>,
				< -112.110808, -71.416840, -3.184017>
			}
			triangle {
				< -126.253039, -55.473268, -32.171030>,
				< -130.708516, -52.409742, -52.445367>,
				< -119.045973, -70.610635, -30.825010>
			}
			triangle {
				< -130.708516, -52.409742, -52.445367>,
				< -125.261217, -66.278167, -59.361029>,
				< -119.045973, -70.610635, -30.825010>
			}
			triangle {
				< -130.708516, -52.409742, -52.445367>,
				< -134.540603, -47.061507, -71.909338>,
				< -125.261217, -66.278167, -59.361029>
			}
			triangle {
				< -134.540603, -47.061507, -71.909338>,
				< -130.353451, -58.714662, -86.813830>,
				< -125.261217, -66.278167, -59.361029>
			}
			triangle {
				< -134.540603, -47.061507, -71.909338>,
				< -137.584433, -39.793137, -89.204162>,
				< -130.353451, -58.714662, -86.813830>
			}
			triangle {
				< -137.584433, -39.793137, -89.204162>,
				< -134.166136, -48.435573, -111.243531>,
				< -130.353451, -58.714662, -86.813830>
			}
			triangle {
				< -137.584433, -39.793137, -89.204162>,
				< -139.788315, -31.099841, -103.110276>,
				< -134.166136, -48.435573, -111.243531>
			}
			triangle {
				< -139.788315, -31.099841, -103.110276>,
				< -136.750072, -36.141373, -130.904883>,
				< -134.166136, -48.435573, -111.243531>
			}
			triangle {
				< -139.788315, -31.099841, -103.110276>,
				< -141.175374, -21.574087, -112.640955>,
				< -136.750072, -36.141373, -130.904883>
			}
			triangle {
				< -141.175374, -21.574087, -112.640955>,
				< -138.275549, -22.669939, -144.387230>,
				< -136.750072, -36.141373, -130.904883>
			}
			triangle {
				< -141.175374, -21.574087, -112.640955>,
				< -141.794294, -11.864997, -117.118157>,
				< -138.275549, -22.669939, -144.387230>
			}
			triangle {
				< -141.794294, -11.864997, -117.118157>,
				< -138.926208, -8.939265, -150.722012>,
				< -138.275549, -22.669939, -144.387230>
			}
			triangle {
				< -141.794294, -11.864997, -117.118157>,
				< -141.677216, -2.634314, -116.222508>,
				< -138.926208, -8.939265, -150.722012>
			}
			triangle {
				< -141.677216, -2.634314, -116.222508>,
				< -138.806596, 4.114859, -149.454907>,
				< -138.926208, -8.939265, -150.722012>
			}
			triangle {
				< -139.961213, -10.484237, -78.004666>,
				< -139.388174, -6.279308, -74.808367>,
				< -141.677216, -2.634314, -116.222508>
			}
			triangle {
				< -139.388174, -6.279308, -74.808367>,
				< -140.816927, 5.488900, -110.017858>,
				< -141.677216, -2.634314, -116.222508>
			}
			triangle {
				< -139.388174, -6.279308, -74.808367>,
				< -138.334349, -2.934230, -69.100864>,
				< -140.816927, 5.488900, -110.017858>
			}
			triangle {
				< -138.334349, -2.934230, -69.100864>,
				< -139.171481, 11.950848, -98.946393>,
				< -140.816927, 5.488900, -110.017858>
			}
			triangle {
				< -138.334349, -2.934230, -69.100864>,
				< -136.829332, -0.676911, -61.281309>,
				< -139.171481, 11.950848, -98.946393>
			}
			triangle {
				< -136.829332, -0.676911, -61.281309>,
				< -136.694834, 16.311636, -83.795205>,
				< -139.171481, 11.950848, -98.946393>
			}
			triangle {
				< -136.829332, -0.676911, -61.281309>,
				< -134.929582, 0.338820, -51.894251>,
				< -136.694834, 16.311636, -83.795205>
			}
			triangle {
				< -134.929582, 0.338820, -51.894251>,
				< -133.383110, 18.273924, -65.637484>,
				< -136.694834, 16.311636, -83.795205>
			}
			triangle {
				< -134.929582, 0.338820, -51.894251>,
				< -132.726848, 0.043749, -41.589890>,
				< -133.383110, 18.273924, -65.637484>
			}
			triangle {
				< -132.726848, 0.043749, -41.589890>,
				< -129.321858, 17.703824, -45.750283>,
				< -133.383110, 18.273924, -65.637484>
			}
			triangle {
				< -132.726848, 0.043749, -41.589890>,
				< -130.352169, -1.542062, -31.076727>,
				< -129.321858, 17.703824, -45.750283>
			}
			triangle {
				< -130.352169, -1.542062, -31.076727>,
				< -124.717794, 14.640318, -25.515635>,
				< -129.321858, 17.703824, -45.750283>
			}
			triangle {
				< -130.352169, -1.542062, -31.076727>,
				< -127.971798, -4.310497, -21.071389>,
				< -124.717794, 14.640318, -25.515635>
			}
			triangle {
				< -127.971798, -4.310497, -21.071389>,
				< -119.902909, 9.292361, -6.317937>,
				< -124.717794, 14.640318, -25.515635>
			}
			triangle {
				< -127.971798, -4.310497, -21.071389>,
				< -125.774607, -8.072923, -12.249441>,
				< -119.902909, 9.292361, -6.317937>
			}
			triangle {
				< -125.774607, -8.072923, -12.249441>,
				< -115.305685, 2.023926, 10.555776>,
				< -119.902909, 9.292361, -6.317937>
			}
			triangle {
				< -125.774607, -8.072923, -12.249441>,
				< -123.951994, -12.572902, -5.200406>,
				< -115.305685, 2.023926, 10.555776>
			}
			triangle {
				< -123.951994, -12.572902, -5.200406>,
				< -111.394338, -6.669389, 23.998780>,
				< -115.305685, 2.023926, 10.555776>
			}
			triangle {
				< -123.951994, -12.572902, -5.200406>,
				< -122.673713, -17.503811, -0.391359>,
				< -111.394338, -6.669389, 23.998780>
			}
			triangle {
				< -122.673713, -17.503811, -0.391359>,
				< -108.603328, -16.195100, 33.148635>,
				< -111.394338, -6.669389, 23.998780>
			}
			triangle {
				< -122.673713, -17.503811, -0.391359>,
				< -122.064129, -22.529565, 1.861612>,
				< -108.603328, -16.195100, 33.148635>
			}
			triangle {
				< -122.064129, -22.529565, 1.861612>,
				< -107.259624, -25.904167, 37.428845>,
				< -108.603328, -16.195100, 33.148635>
			}
			triangle {
				< -122.064129, -22.529565, 1.861612>,
				< -122.183941, -27.307743, 1.410993>,
				< -107.259624, -25.904167, 37.428845>
			}
			triangle {
				< -122.183941, -27.307743, 1.410993>,
				< -107.525080, -35.134807, 36.572926>,
				< -107.259624, -25.904167, 37.428845>
			}
			triangle {
				< -122.183941, -27.307743, 1.410993>,
				< -123.021036, -31.512611, -1.713713>,
				< -107.525080, -35.134807, 36.572926>
			}
			triangle {
				< -123.021036, -31.512611, -1.713713>,
				< -109.367169, -43.258041, 30.634072>,
				< -107.525080, -35.134807, 36.572926>
			}
			triangle {
				< -123.021036, -31.512611, -1.713713>,
				< -124.492414, -34.857728, -7.307746>,
				< -109.367169, -43.258041, 30.634072>
			}
			triangle {
				< -124.492414, -34.857728, -7.307746>,
				< -112.565145, -49.720269, 19.983187>,
				< -109.367169, -43.258041, 30.634072>
			}
			triangle {
				< -124.492414, -34.857728, -7.307746>,
				< -126.456514, -37.115049, -15.002473>,
				< -112.565145, -49.720269, 19.983187>
			}
			triangle {
				< -126.456514, -37.115049, -15.002473>,
				< -116.749421, -54.081101, 5.295137>,
				< -112.565145, -49.720269, 19.983187>
			}
			triangle {
				< -126.456514, -37.115049, -15.002473>,
				< -128.733933, -38.130790, -24.286738>,
				< -116.749421, -54.081101, 5.295137>
			}
			triangle {
				< -128.733933, -38.130790, -24.286738>,
				< -121.466152, -56.043327, -12.481014>,
				< -116.749421, -54.081101, 5.295137>
			}
			triangle {
				< -128.733933, -38.130790, -24.286738>,
				< -131.131694, -37.835713, -34.538016>,
				< -121.466152, -56.043327, -12.481014>
			}
			triangle {
				< -131.131694, -37.835713, -34.538016>,
				< -126.253039, -55.473268, -32.171030>,
				< -121.466152, -56.043327, -12.481014>
			}
			triangle {
				< -131.131694, -37.835713, -34.538016>,
				< -133.466482, -36.249906, -45.061924>,
				< -126.253039, -55.473268, -32.171030>
			}
			triangle {
				< -133.466482, -36.249906, -45.061924>,
				< -130.708516, -52.409742, -52.445367>,
				< -126.253039, -55.473268, -32.171030>
			}
			triangle {
				< -133.466482, -36.249906, -45.061924>,
				< -135.582685, -33.481490, -55.138897>,
				< -130.708516, -52.409742, -52.445367>
			}
			triangle {
				< -135.582685, -33.481490, -55.138897>,
				< -134.540603, -47.061507, -71.909338>,
				< -130.708516, -52.409742, -52.445367>
			}
			triangle {
				< -135.582685, -33.481490, -55.138897>,
				< -137.362331, -29.719062, -64.074382>,
				< -134.540603, -47.061507, -71.909338>
			}
			triangle {
				< -137.362331, -29.719062, -64.074382>,
				< -137.584433, -39.793137, -89.204162>,
				< -134.540603, -47.061507, -71.909338>
			}
			triangle {
				< -137.362331, -29.719062, -64.074382>,
				< -138.725817, -25.219072, -71.248218>,
				< -137.584433, -39.793137, -89.204162>
			}
			triangle {
				< -138.725817, -25.219072, -71.248218>,
				< -139.788315, -31.099841, -103.110276>,
				< -137.584433, -39.793137, -89.204162>
			}
			triangle {
				< -138.725817, -25.219072, -71.248218>,
				< -139.626488, -20.288162, -76.159917>,
				< -139.788315, -31.099841, -103.110276>
			}
			triangle {
				< -139.626488, -20.288162, -76.159917>,
				< -141.175374, -21.574087, -112.640955>,
				< -139.788315, -31.099841, -103.110276>
			}
			triangle {
				< -139.626488, -20.288162, -76.159917>,
				< -140.041083, -15.262392, -78.465872>,
				< -141.175374, -21.574087, -112.640955>
			}
			triangle {
				< -140.041083, -15.262392, -78.465872>,
				< -141.794294, -11.864997, -117.118157>,
				< -141.175374, -21.574087, -112.640955>
			}
			triangle {
				< -140.041083, -15.262392, -78.465872>,
				< -139.961213, -10.484237, -78.004666>,
				< -141.794294, -11.864997, -117.118157>
			}
			triangle {
				< -139.961213, -10.484237, -78.004666>,
				< -141.677216, -2.634314, -116.222508>,
				< -141.794294, -11.864997, -117.118157>
			}
			triangle {
				< -140.041083, -15.262392, -78.465872>,
				< -139.626488, -20.288162, -76.159917>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -139.626488, -20.288162, -76.159917>,
				< -138.725817, -25.219072, -71.248218>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -138.725817, -25.219072, -71.248218>,
				< -137.362331, -29.719062, -64.074382>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -137.362331, -29.719062, -64.074382>,
				< -135.582685, -33.481490, -55.138897>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -135.582685, -33.481490, -55.138897>,
				< -133.466482, -36.249906, -45.061924>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -133.466482, -36.249906, -45.061924>,
				< -131.131694, -37.835713, -34.538016>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -131.131694, -37.835713, -34.538016>,
				< -128.733933, -38.130790, -24.286738>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -128.733933, -38.130790, -24.286738>,
				< -126.456514, -37.115049, -15.002473>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -126.456514, -37.115049, -15.002473>,
				< -124.492414, -34.857728, -7.307746>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -124.492414, -34.857728, -7.307746>,
				< -123.021036, -31.512611, -1.713713>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -123.021036, -31.512611, -1.713713>,
				< -122.183941, -27.307743, 1.410993>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -122.183941, -27.307743, 1.410993>,
				< -122.064129, -22.529565, 1.861612>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -122.064129, -22.529565, 1.861612>,
				< -122.673713, -17.503811, -0.391359>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -122.673713, -17.503811, -0.391359>,
				< -123.951994, -12.572902, -5.200406>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -123.951994, -12.572902, -5.200406>,
				< -125.774607, -8.072923, -12.249441>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -125.774607, -8.072923, -12.249441>,
				< -127.971798, -4.310497, -21.071389>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -127.971798, -4.310497, -21.071389>,
				< -130.352169, -1.542062, -31.076727>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -130.352169, -1.542062, -31.076727>,
				< -132.726848, 0.043749, -41.589890>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -132.726848, 0.043749, -41.589890>,
				< -134.929582, 0.338820, -51.894251>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -134.929582, 0.338820, -51.894251>,
				< -136.829332, -0.676911, -61.281309>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -136.829332, -0.676911, -61.281309>,
				< -138.334349, -2.934230, -69.100864>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -138.334349, -2.934230, -69.100864>,
				< -139.388174, -6.279308, -74.808367>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -139.388174, -6.279308, -74.808367>,
				< -139.961213, -10.484237, -78.004666>,
				< -133.342311, -18.899856, -37.757128>
			}
			triangle {
				< -139.961213, -10.484237, -78.004666>,
				< -140.041083, -15.262392, -78.465872>,
				< -133.342311, -18.899856, -37.757128>
			}
			
		}
		// _Thigh05
		union {
			triangle {
				< 0.709089, -4.204017, -49.850076>,
				< 1.236209, -8.403812, -45.909021>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< 1.236209, -8.403812, -45.909021>,
				< 1.343330, -12.852487, -44.021308>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< 1.343330, -12.852487, -44.021308>,
				< 1.023187, -17.246939, -44.315588>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< 1.023187, -17.246939, -44.315588>,
				< 0.297559, -21.287723, -46.771623>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< 0.297559, -21.287723, -46.771623>,
				< -0.784051, -24.699455, -51.222228>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -0.784051, -24.699455, -51.222228>,
				< -2.148020, -27.249567, -57.363980>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -2.148020, -27.249567, -57.363980>,
				< -3.701243, -28.764280, -64.778440>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -3.701243, -28.764280, -64.778440>,
				< -5.338110, -29.140407, -72.960310>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -5.338110, -29.140407, -72.960310>,
				< -6.946839, -28.352356, -81.351861>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -6.946839, -28.352356, -81.351861>,
				< -8.417847, -26.453774, -89.381427>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -8.417847, -26.453774, -89.381427>,
				< -9.651051, -23.573993, -96.501730>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -9.651051, -23.573993, -96.501730>,
				< -10.562206, -19.909415, -102.227464>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -10.562206, -19.909415, -102.227464>,
				< -11.089326, -15.709596, -106.168479>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -11.089326, -15.709596, -106.168479>,
				< -11.196448, -11.260920, -108.056128>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -11.196448, -11.260920, -108.056128>,
				< -10.876283, -6.866406, -107.762009>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -10.876283, -6.866406, -107.762009>,
				< -10.150676, -2.825659, -105.305873>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -10.150676, -2.825659, -105.305873>,
				< -9.069025, 0.586024, -100.855328>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -9.069025, 0.586024, -100.855328>,
				< -7.705097, 3.136095, -94.713457>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -7.705097, 3.136095, -94.713457>,
				< -6.151770, 4.650850, -87.299041>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -6.151770, 4.650850, -87.299041>,
				< -4.515028, 5.026997, -79.117216>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -4.515028, 5.026997, -79.117216>,
				< -2.906278, 4.238926, -70.725575>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -2.906278, 4.238926, -70.725575>,
				< -1.435228, 2.340322, -62.696129>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -1.435228, 2.340322, -62.696129>,
				< -0.202066, -0.539334, -55.575788>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< -0.202066, -0.539334, -55.575788>,
				< 0.709089, -4.204017, -49.850076>,
				< -3.728510, -12.143836, -76.112591>
			}
			triangle {
				< 2.448253, 3.368972, -25.229342>,
				< 3.466530, -4.744346, -17.616000>,
				< 0.709089, -4.204017, -49.850076>
			}
			triangle {
				< 3.466530, -4.744346, -17.616000>,
				< 1.236209, -8.403812, -45.909021>,
				< 0.709089, -4.204017, -49.850076>
			}
			triangle {
				< 3.466530, -4.744346, -17.616000>,
				< 3.673506, -13.338551, -13.969144>,
				< 1.236209, -8.403812, -45.909021>
			}
			triangle {
				< 3.673506, -13.338551, -13.969144>,
				< 1.343330, -12.852487, -44.021308>,
				< 1.236209, -8.403812, -45.909021>
			}
			triangle {
				< 3.673506, -13.338551, -13.969144>,
				< 3.055000, -21.828035, -14.537485>,
				< 1.343330, -12.852487, -44.021308>
			}
			triangle {
				< 3.055000, -21.828035, -14.537485>,
				< 1.023187, -17.246939, -44.315588>,
				< 1.343330, -12.852487, -44.021308>
			}
			triangle {
				< 3.055000, -21.828035, -14.537485>,
				< 1.653226, -29.634194, -19.282309>,
				< 1.023187, -17.246939, -44.315588>
			}
			triangle {
				< 1.653226, -29.634194, -19.282309>,
				< 0.297559, -21.287723, -46.771623>,
				< 1.023187, -17.246939, -44.315588>
			}
			triangle {
				< 1.653226, -29.634194, -19.282309>,
				< -0.436330, -36.225036, -27.880179>,
				< 0.297559, -21.287723, -46.771623>
			}
			triangle {
				< -0.436330, -36.225036, -27.880179>,
				< -0.784051, -24.699455, -51.222228>,
				< 0.297559, -21.287723, -46.771623>
			}
			triangle {
				< -0.436330, -36.225036, -27.880179>,
				< -3.071267, -41.151512, -39.745282>,
				< -0.784051, -24.699455, -51.222228>
			}
			triangle {
				< -3.071267, -41.151512, -39.745282>,
				< -2.148020, -27.249567, -57.363980>,
				< -0.784051, -24.699455, -51.222228>
			}
			triangle {
				< -3.071267, -41.151512, -39.745282>,
				< -6.071977, -44.077709, -54.068882>,
				< -2.148020, -27.249567, -57.363980>
			}
			triangle {
				< -6.071977, -44.077709, -54.068882>,
				< -3.701243, -28.764280, -64.778440>,
				< -2.148020, -27.249567, -57.363980>
			}
			triangle {
				< -6.071977, -44.077709, -54.068882>,
				< -9.234013, -44.804372, -69.874935>,
				< -3.701243, -28.764280, -64.778440>
			}
			triangle {
				< -9.234013, -44.804372, -69.874935>,
				< -5.338110, -29.140407, -72.960310>,
				< -3.701243, -28.764280, -64.778440>
			}
			triangle {
				< -9.234013, -44.804372, -69.874935>,
				< -12.341866, -43.281917, -86.086296>,
				< -5.338110, -29.140407, -72.960310>
			}
			triangle {
				< -12.341866, -43.281917, -86.086296>,
				< -6.946839, -28.352356, -81.351861>,
				< -5.338110, -29.140407, -72.960310>
			}
			triangle {
				< -12.341866, -43.281917, -86.086296>,
				< -15.183758, -39.614130, -101.598099>,
				< -6.946839, -28.352356, -81.351861>
			}
			triangle {
				< -15.183758, -39.614130, -101.598099>,
				< -8.417847, -26.453774, -89.381427>,
				< -6.946839, -28.352356, -81.351861>
			}
			triangle {
				< -15.183758, -39.614130, -101.598099>,
				< -17.565995, -34.050927, -115.353405>,
				< -8.417847, -26.453774, -89.381427>
			}
			triangle {
				< -17.565995, -34.050927, -115.353405>,
				< -9.651051, -23.573993, -96.501730>,
				< -8.417847, -26.453774, -89.381427>
			}
			triangle {
				< -17.565995, -34.050927, -115.353405>,
				< -19.326223, -26.971377, -126.414686>,
				< -9.651051, -23.573993, -96.501730>
			}
			triangle {
				< -19.326223, -26.971377, -126.414686>,
				< -10.562206, -19.909415, -102.227464>,
				< -9.651051, -23.573993, -96.501730>
			}
			triangle {
				< -19.326223, -26.971377, -126.414686>,
				< -20.344522, -18.858114, -134.028107>,
				< -10.562206, -19.909415, -102.227464>
			}
			triangle {
				< -20.344522, -18.858114, -134.028107>,
				< -11.089326, -15.709596, -106.168479>,
				< -10.562206, -19.909415, -102.227464>
			}
			triangle {
				< -20.344522, -18.858114, -134.028107>,
				< -20.551488, -10.263803, -137.674958>,
				< -11.089326, -15.709596, -106.168479>
			}
			triangle {
				< -20.551488, -10.263803, -137.674958>,
				< -11.196448, -11.260920, -108.056128>,
				< -11.089326, -15.709596, -106.168479>
			}
			triangle {
				< -20.551488, -10.263803, -137.674958>,
				< -19.932993, -1.774359, -137.106553>,
				< -11.196448, -11.260920, -108.056128>
			}
			triangle {
				< -19.932993, -1.774359, -137.106553>,
				< -10.876283, -6.866406, -107.762009>,
				< -11.196448, -11.260920, -108.056128>
			}
			triangle {
				< -19.932993, -1.774359, -137.106553>,
				< -18.531218, 6.031817, -132.361859>,
				< -10.876283, -6.866406, -107.762009>
			}
			triangle {
				< -18.531218, 6.031817, -132.361859>,
				< -10.150676, -2.825659, -105.305873>,
				< -10.876283, -6.866406, -107.762009>
			}
			triangle {
				< -18.531218, 6.031817, -132.361859>,
				< -16.441660, 12.622687, -123.763926>,
				< -10.150676, -2.825659, -105.305873>
			}
			triangle {
				< -16.441660, 12.622687, -123.763926>,
				< -9.069025, 0.586024, -100.855328>,
				< -10.150676, -2.825659, -105.305873>
			}
			triangle {
				< -16.441660, 12.622687, -123.763926>,
				< -13.806746, 17.549084, -111.898884>,
				< -9.069025, 0.586024, -100.855328>
			}
			triangle {
				< -13.806746, 17.549084, -111.898884>,
				< -7.705097, 3.136095, -94.713457>,
				< -9.069025, 0.586024, -100.855328>
			}
			triangle {
				< -13.806746, 17.549084, -111.898884>,
				< -10.806015, 20.475343, -97.575307>,
				< -7.705097, 3.136095, -94.713457>
			}
			triangle {
				< -10.806015, 20.475343, -97.575307>,
				< -6.151770, 4.650850, -87.299041>,
				< -7.705097, 3.136095, -94.713457>
			}
			triangle {
				< -10.806015, 20.475343, -97.575307>,
				< -7.643959, 21.202018, -81.769168>,
				< -6.151770, 4.650850, -87.299041>
			}
			triangle {
				< -7.643959, 21.202018, -81.769168>,
				< -4.515028, 5.026997, -79.117216>,
				< -6.151770, 4.650850, -87.299041>
			}
			triangle {
				< -7.643959, 21.202018, -81.769168>,
				< -4.536084, 19.679539, -65.557860>,
				< -4.515028, 5.026997, -79.117216>
			}
			triangle {
				< -4.536084, 19.679539, -65.557860>,
				< -2.906278, 4.238926, -70.725575>,
				< -4.515028, 5.026997, -79.117216>
			}
			triangle {
				< -4.536084, 19.679539, -65.557860>,
				< -1.694254, 16.011732, -50.046023>,
				< -2.906278, 4.238926, -70.725575>
			}
			triangle {
				< -1.694254, 16.011732, -50.046023>,
				< -1.435228, 2.340322, -62.696129>,
				< -2.906278, 4.238926, -70.725575>
			}
			triangle {
				< -1.694254, 16.011732, -50.046023>,
				< 0.687992, 10.448536, -36.290761>,
				< -1.435228, 2.340322, -62.696129>
			}
			triangle {
				< 0.687992, 10.448536, -36.290761>,
				< -0.202066, -0.539334, -55.575788>,
				< -1.435228, 2.340322, -62.696129>
			}
			triangle {
				< 0.687992, 10.448536, -36.290761>,
				< 2.448253, 3.368972, -25.229342>,
				< -0.202066, -0.539334, -55.575788>
			}
			triangle {
				< 2.448253, 3.368972, -25.229342>,
				< 0.709089, -4.204017, -49.850076>,
				< -0.202066, -0.539334, -55.575788>
			}
			triangle {
				< 1.370390, 10.059138, -3.928569>,
				< 2.810487, -1.414837, 6.838526>,
				< 2.448253, 3.368972, -25.229342>
			}
			triangle {
				< 2.810487, -1.414837, 6.838526>,
				< 3.466530, -4.744346, -17.616000>,
				< 2.448253, 3.368972, -25.229342>
			}
			triangle {
				< 2.810487, -1.414837, 6.838526>,
				< 3.103157, -13.568923, 11.995873>,
				< 3.466530, -4.744346, -17.616000>
			}
			triangle {
				< 3.103157, -13.568923, 11.995873>,
				< 3.673506, -13.338551, -13.969144>,
				< 3.466530, -4.744346, -17.616000>
			}
			triangle {
				< 3.103157, -13.568923, 11.995873>,
				< 2.228482, -25.574874, 11.192067>,
				< 3.673506, -13.338551, -13.969144>
			}
			triangle {
				< 2.228482, -25.574874, 11.192067>,
				< 3.055000, -21.828035, -14.537485>,
				< 3.673506, -13.338551, -13.969144>
			}
			triangle {
				< 2.228482, -25.574874, 11.192067>,
				< 0.246068, -36.614429, 4.481953>,
				< 3.055000, -21.828035, -14.537485>
			}
			triangle {
				< 0.246068, -36.614429, 4.481953>,
				< 1.653226, -29.634194, -19.282309>,
				< 3.055000, -21.828035, -14.537485>
			}
			triangle {
				< 0.246068, -36.614429, 4.481953>,
				< -2.709012, -45.935322, -7.677309>,
				< 1.653226, -29.634194, -19.282309>
			}
			triangle {
				< -2.709012, -45.935322, -7.677309>,
				< -0.436330, -36.225036, -27.880179>,
				< 1.653226, -29.634194, -19.282309>
			}
			triangle {
				< -2.709012, -45.935322, -7.677309>,
				< -6.435309, -52.902371, -24.457047>,
				< -0.436330, -36.225036, -27.880179>
			}
			triangle {
				< -6.435309, -52.902371, -24.457047>,
				< -3.071267, -41.151512, -39.745282>,
				< -0.436330, -36.225036, -27.880179>
			}
			triangle {
				< -6.435309, -52.902371, -24.457047>,
				< -10.679037, -57.040703, -44.713706>,
				< -3.071267, -41.151512, -39.745282>
			}
			triangle {
				< -10.679037, -57.040703, -44.713706>,
				< -6.071977, -44.077709, -54.068882>,
				< -3.071267, -41.151512, -39.745282>
			}
			triangle {
				< -10.679037, -57.040703, -44.713706>,
				< -15.150798, -58.068354, -67.066871>,
				< -6.071977, -44.077709, -54.068882>
			}
			triangle {
				< -15.150798, -58.068354, -67.066871>,
				< -9.234013, -44.804372, -69.874935>,
				< -6.071977, -44.077709, -54.068882>
			}
			triangle {
				< -15.150798, -58.068354, -67.066871>,
				< -19.545995, -55.915277, -89.993149>,
				< -9.234013, -44.804372, -69.874935>
			}
			triangle {
				< -19.545995, -55.915277, -89.993149>,
				< -12.341866, -43.281917, -86.086296>,
				< -9.234013, -44.804372, -69.874935>
			}
			triangle {
				< -19.545995, -55.915277, -89.993149>,
				< -23.565024, -50.728202, -111.930236>,
				< -12.341866, -43.281917, -86.086296>
			}
			triangle {
				< -23.565024, -50.728202, -111.930236>,
				< -15.183758, -39.614130, -101.598099>,
				< -12.341866, -43.281917, -86.086296>
			}
			triangle {
				< -23.565024, -50.728202, -111.930236>,
				< -26.933994, -42.860549, -131.383106>,
				< -15.183758, -39.614130, -101.598099>
			}
			triangle {
				< -26.933994, -42.860549, -131.383106>,
				< -17.565995, -34.050927, -115.353405>,
				< -15.183758, -39.614130, -101.598099>
			}
			triangle {
				< -26.933994, -42.860549, -131.383106>,
				< -29.423382, -32.848626, -147.026181>,
				< -17.565995, -34.050927, -115.353405>
			}
			triangle {
				< -29.423382, -32.848626, -147.026181>,
				< -19.326223, -26.971377, -126.414686>,
				< -17.565995, -34.050927, -115.353405>
			}
			triangle {
				< -29.423382, -32.848626, -147.026181>,
				< -30.863469, -21.374667, -157.793254>,
				< -19.326223, -26.971377, -126.414686>
			}
			triangle {
				< -30.863469, -21.374667, -157.793254>,
				< -20.344522, -18.858114, -134.028107>,
				< -19.326223, -26.971377, -126.414686>
			}
			triangle {
				< -30.863469, -21.374667, -157.793254>,
				< -31.156141, -9.220578, -162.950620>,
				< -20.344522, -18.858114, -134.028107>
			}
			triangle {
				< -31.156141, -9.220578, -162.950620>,
				< -20.551488, -10.263803, -137.674958>,
				< -20.344522, -18.858114, -134.028107>
			}
			triangle {
				< -31.156141, -9.220578, -162.950620>,
				< -30.281473, 2.785351, -162.146851>,
				< -20.551488, -10.263803, -137.674958>
			}
			triangle {
				< -30.281473, 2.785351, -162.146851>,
				< -19.932993, -1.774359, -137.106553>,
				< -20.551488, -10.263803, -137.674958>
			}
			triangle {
				< -30.281473, 2.785351, -162.146851>,
				< -28.299030, 13.824907, -155.436575>,
				< -19.932993, -1.774359, -137.106553>
			}
			triangle {
				< -28.299030, 13.824907, -155.436575>,
				< -18.531218, 6.031817, -132.361859>,
				< -19.932993, -1.774359, -137.106553>
			}
			triangle {
				< -28.299030, 13.824907, -155.436575>,
				< -25.343940, 23.145808, -143.277302>,
				< -18.531218, 6.031817, -132.361859>
			}
			triangle {
				< -25.343940, 23.145808, -143.277302>,
				< -16.441660, 12.622687, -123.763926>,
				< -18.531218, 6.031817, -132.361859>
			}
			triangle {
				< -25.343940, 23.145808, -143.277302>,
				< -21.617621, 30.112825, -126.497701>,
				< -16.441660, 12.622687, -123.763926>
			}
			triangle {
				< -21.617621, 30.112825, -126.497701>,
				< -13.806746, 17.549084, -111.898884>,
				< -16.441660, 12.622687, -123.763926>
			}
			triangle {
				< -21.617621, 30.112825, -126.497701>,
				< -17.373944, 34.251153, -106.241025>,
				< -13.806746, 17.549084, -111.898884>
			}
			triangle {
				< -17.373944, 34.251153, -106.241025>,
				< -10.806015, 20.475343, -97.575307>,
				< -13.806746, 17.549084, -111.898884>
			}
			triangle {
				< -17.373944, 34.251153, -106.241025>,
				< -12.902091, 35.278849, -83.887875>,
				< -10.806015, 20.475343, -97.575307>
			}
			triangle {
				< -12.902091, 35.278849, -83.887875>,
				< -7.643959, 21.202018, -81.769168>,
				< -10.806015, 20.475343, -97.575307>
			}
			triangle {
				< -12.902091, 35.278849, -83.887875>,
				< -8.506997, 33.125784, -60.961559>,
				< -7.643959, 21.202018, -81.769168>
			}
			triangle {
				< -8.506997, 33.125784, -60.961559>,
				< -4.536084, 19.679539, -65.557860>,
				< -7.643959, 21.202018, -81.769168>
			}
			triangle {
				< -8.506997, 33.125784, -60.961559>,
				< -4.487886, 27.938673, -39.024517>,
				< -4.536084, 19.679539, -65.557860>
			}
			triangle {
				< -4.487886, 27.938673, -39.024517>,
				< -1.694254, 16.011732, -50.046023>,
				< -4.536084, 19.679539, -65.557860>
			}
			triangle {
				< -4.487886, 27.938673, -39.024517>,
				< -1.118977, 20.071091, -19.571602>,
				< -1.694254, 16.011732, -50.046023>
			}
			triangle {
				< -1.118977, 20.071091, -19.571602>,
				< 0.687992, 10.448536, -36.290761>,
				< -1.694254, 16.011732, -50.046023>
			}
			triangle {
				< -1.118977, 20.071091, -19.571602>,
				< 1.370390, 10.059138, -3.928569>,
				< 0.687992, 10.448536, -36.290761>
			}
			triangle {
				< 1.370390, 10.059138, -3.928569>,
				< 2.448253, 3.368972, -25.229342>,
				< 0.687992, 10.448536, -36.290761>
			}
			triangle {
				< -2.450980, 15.410470, 12.600984>,
				< -0.687240, 1.357780, 25.787819>,
				< 1.370390, 10.059138, -3.928569>
			}
			triangle {
				< -0.687240, 1.357780, 25.787819>,
				< 2.810487, -1.414837, 6.838526>,
				< 1.370390, 10.059138, -3.928569>
			}
			triangle {
				< -0.687240, 1.357780, 25.787819>,
				< -0.328795, -13.527846, 32.104269>,
				< 2.810487, -1.414837, 6.838526>
			}
			triangle {
				< -0.328795, -13.527846, 32.104269>,
				< 3.103157, -13.568923, 11.995873>,
				< 2.810487, -1.414837, 6.838526>
			}
			triangle {
				< -0.328795, -13.527846, 32.104269>,
				< -1.400053, -28.232053, 31.119866>,
				< 3.103157, -13.568923, 11.995873>
			}
			triangle {
				< -1.400053, -28.232053, 31.119866>,
				< 2.228482, -25.574874, 11.192067>,
				< 3.103157, -13.568923, 11.995873>
			}
			triangle {
				< -1.400053, -28.232053, 31.119866>,
				< -3.828012, -41.752752, 22.901598>,
				< 2.228482, -25.574874, 11.192067>
			}
			triangle {
				< -3.828012, -41.752752, 22.901598>,
				< 0.246068, -36.614429, 4.481953>,
				< 2.228482, -25.574874, 11.192067>
			}
			triangle {
				< -3.828012, -41.752752, 22.901598>,
				< -7.447168, -53.168435, 8.009639>,
				< 0.246068, -36.614429, 4.481953>
			}
			triangle {
				< -7.447168, -53.168435, 8.009639>,
				< -2.709012, -45.935322, -7.677309>,
				< 0.246068, -36.614429, 4.481953>
			}
			triangle {
				< -7.447168, -53.168435, 8.009639>,
				< -12.011060, -61.701294, -12.541283>,
				< -2.709012, -45.935322, -7.677309>
			}
			triangle {
				< -12.011060, -61.701294, -12.541283>,
				< -6.435309, -52.902371, -24.457047>,
				< -2.709012, -45.935322, -7.677309>
			}
			triangle {
				< -12.011060, -61.701294, -12.541283>,
				< -17.208470, -66.769682, -37.350487>,
				< -6.435309, -52.902371, -24.457047>
			}
			triangle {
				< -17.208470, -66.769682, -37.350487>,
				< -10.679037, -57.040703, -44.713706>,
				< -6.435309, -52.902371, -24.457047>
			}
			triangle {
				< -17.208470, -66.769682, -37.350487>,
				< -22.685256, -68.028286, -64.727426>,
				< -10.679037, -57.040703, -44.713706>
			}
			triangle {
				< -22.685256, -68.028286, -64.727426>,
				< -15.150798, -58.068354, -67.066871>,
				< -10.679037, -57.040703, -44.713706>
			}
			triangle {
				< -22.685256, -68.028286, -64.727426>,
				< -28.068213, -65.391280, -92.806220>,
				< -15.150798, -58.068354, -67.066871>
			}
			triangle {
				< -28.068213, -65.391280, -92.806220>,
				< -19.545995, -55.915277, -89.993149>,
				< -15.150798, -58.068354, -67.066871>
			}
			triangle {
				< -28.068213, -65.391280, -92.806220>,
				< -32.990512, -59.038498, -119.673595>,
				< -19.545995, -55.915277, -89.993149>
			}
			triangle {
				< -32.990512, -59.038498, -119.673595>,
				< -23.565024, -50.728202, -111.930236>,
				< -19.545995, -55.915277, -89.993149>
			}
			triangle {
				< -32.990512, -59.038498, -119.673595>,
				< -37.116658, -49.402699, -143.498406>,
				< -23.565024, -50.728202, -111.930236>
			}
			triangle {
				< -37.116658, -49.402699, -143.498406>,
				< -26.933994, -42.860549, -131.383106>,
				< -23.565024, -50.728202, -111.930236>
			}
			triangle {
				< -37.116658, -49.402699, -143.498406>,
				< -40.165488, -37.140578, -162.657082>,
				< -26.933994, -42.860549, -131.383106>
			}
			triangle {
				< -40.165488, -37.140578, -162.657082>,
				< -29.423382, -32.848626, -147.026181>,
				< -26.933994, -42.860549, -131.383106>
			}
			triangle {
				< -40.165488, -37.140578, -162.657082>,
				< -41.929238, -23.087930, -175.844058>,
				< -29.423382, -32.848626, -147.026181>
			}
			triangle {
				< -41.929238, -23.087930, -175.844058>,
				< -30.863469, -21.374667, -157.793254>,
				< -29.423382, -32.848626, -147.026181>
			}
			triangle {
				< -41.929238, -23.087930, -175.844058>,
				< -42.287696, -8.202238, -182.160467>,
				< -30.863469, -21.374667, -157.793254>
			}
			triangle {
				< -42.287696, -8.202238, -182.160467>,
				< -31.156141, -9.220578, -162.950620>,
				< -30.863469, -21.374667, -157.793254>
			}
			triangle {
				< -42.287696, -8.202238, -182.160467>,
				< -41.216437, 6.501918, -181.176141>,
				< -31.156141, -9.220578, -162.950620>
			}
			triangle {
				< -41.216437, 6.501918, -181.176141>,
				< -30.281473, 2.785351, -162.146851>,
				< -31.156141, -9.220578, -162.950620>
			}
			triangle {
				< -41.216437, 6.501918, -181.176141>,
				< -38.788453, 20.022612, -172.957748>,
				< -30.281473, 2.785351, -162.146851>
			}
			triangle {
				< -38.788453, 20.022612, -172.957748>,
				< -28.299030, 13.824907, -155.436575>,
				< -30.281473, 2.785351, -162.146851>
			}
			triangle {
				< -38.788453, 20.022612, -172.957748>,
				< -35.169259, 31.438313, -158.065885>,
				< -28.299030, 13.824907, -155.436575>
			}
			triangle {
				< -35.169259, 31.438313, -158.065885>,
				< -25.343940, 23.145808, -143.277302>,
				< -28.299030, 13.824907, -155.436575>
			}
			triangle {
				< -35.169259, 31.438313, -158.065885>,
				< -30.605437, 39.971158, -137.514964>,
				< -25.343940, 23.145808, -143.277302>
			}
			triangle {
				< -30.605437, 39.971158, -137.514964>,
				< -21.617621, 30.112825, -126.497701>,
				< -25.343940, 23.145808, -143.277302>
			}
			triangle {
				< -30.605437, 39.971158, -137.514964>,
				< -25.408007, 45.039579, -112.705842>,
				< -21.617621, 30.112825, -126.497701>
			}
			triangle {
				< -25.408007, 45.039579, -112.705842>,
				< -17.373944, 34.251153, -106.241025>,
				< -21.617621, 30.112825, -126.497701>
			}
			triangle {
				< -25.408007, 45.039579, -112.705842>,
				< -19.931169, 46.298262, -85.328862>,
				< -17.373944, 34.251153, -106.241025>
			}
			triangle {
				< -19.931169, 46.298262, -85.328862>,
				< -12.902091, 35.278849, -83.887875>,
				< -17.373944, 34.251153, -106.241025>
			}
			triangle {
				< -19.931169, 46.298262, -85.328862>,
				< -14.548192, 43.661252, -57.249941>,
				< -12.902091, 35.278849, -83.887875>
			}
			triangle {
				< -14.548192, 43.661252, -57.249941>,
				< -8.506997, 33.125784, -60.961559>,
				< -12.902091, 35.278849, -83.887875>
			}
			triangle {
				< -14.548192, 43.661252, -57.249941>,
				< -9.625915, 37.308354, -30.382652>,
				< -8.506997, 33.125784, -60.961559>
			}
			triangle {
				< -9.625915, 37.308354, -30.382652>,
				< -4.487886, 27.938673, -39.024517>,
				< -8.506997, 33.125784, -60.961559>
			}
			triangle {
				< -9.625915, 37.308354, -30.382652>,
				< -5.499848, 27.672578, -6.557832>,
				< -4.487886, 27.938673, -39.024517>
			}
			triangle {
				< -5.499848, 27.672578, -6.557832>,
				< -1.118977, 20.071091, -19.571602>,
				< -4.487886, 27.938673, -39.024517>
			}
			triangle {
				< -5.499848, 27.672578, -6.557832>,
				< -2.450980, 15.410470, 12.600984>,
				< -1.118977, 20.071091, -19.571602>
			}
			triangle {
				< -2.450980, 15.410470, 12.600984>,
				< 1.370390, 10.059138, -3.928569>,
				< -1.118977, 20.071091, -19.571602>
			}
			triangle {
				< -8.755403, 19.058311, 23.232508>,
				< -6.788289, 3.384603, 37.940621>,
				< -2.450980, 15.410470, 12.600984>
			}
			triangle {
				< -6.788289, 3.384603, 37.940621>,
				< -0.687240, 1.357780, 25.787819>,
				< -2.450980, 15.410470, 12.600984>
			}
			triangle {
				< -6.788289, 3.384603, 37.940621>,
				< -6.388477, -13.218200, 44.985723>,
				< -0.687240, 1.357780, 25.787819>
			}
			triangle {
				< -6.388477, -13.218200, 44.985723>,
				< -0.328795, -13.527846, 32.104269>,
				< -0.687240, 1.357780, 25.787819>
			}
			triangle {
				< -6.388477, -13.218200, 44.985723>,
				< -7.583317, -29.618582, 43.887697>,
				< -0.328795, -13.527846, 32.104269>
			}
			triangle {
				< -7.583317, -29.618582, 43.887697>,
				< -1.400053, -28.232053, 31.119866>,
				< -0.328795, -13.527846, 32.104269>
			}
			triangle {
				< -7.583317, -29.618582, 43.887697>,
				< -10.291296, -44.698931, 34.721419>,
				< -1.400053, -28.232053, 31.119866>
			}
			triangle {
				< -10.291296, -44.698931, 34.721419>,
				< -3.828012, -41.752752, 22.901598>,
				< -1.400053, -28.232053, 31.119866>
			}
			triangle {
				< -10.291296, -44.698931, 34.721419>,
				< -14.328069, -57.431500, 18.111559>,
				< -3.828012, -41.752752, 22.901598>
			}
			triangle {
				< -14.328069, -57.431500, 18.111559>,
				< -7.447168, -53.168435, 8.009639>,
				< -3.828012, -41.752752, 22.901598>
			}
			triangle {
				< -14.328069, -57.431500, 18.111559>,
				< -19.418357, -66.948645, -4.809952>,
				< -7.447168, -53.168435, 8.009639>
			}
			triangle {
				< -19.418357, -66.948645, -4.809952>,
				< -12.011060, -61.701294, -12.541283>,
				< -7.447168, -53.168435, 8.009639>
			}
			triangle {
				< -19.418357, -66.948645, -4.809952>,
				< -25.215307, -72.601743, -32.481004>,
				< -12.011060, -61.701294, -12.541283>
			}
			triangle {
				< -25.215307, -72.601743, -32.481004>,
				< -17.208470, -66.769682, -37.350487>,
				< -12.011060, -61.701294, -12.541283>
			}
			triangle {
				< -25.215307, -72.601743, -32.481004>,
				< -31.323891, -74.005507, -63.016005>,
				< -17.208470, -66.769682, -37.350487>
			}
			triangle {
				< -31.323891, -74.005507, -63.016005>,
				< -22.685256, -68.028286, -64.727426>,
				< -17.208470, -66.769682, -37.350487>
			}
			triangle {
				< -31.323891, -74.005507, -63.016005>,
				< -37.327811, -71.064360, -94.333962>,
				< -22.685256, -68.028286, -64.727426>
			}
			triangle {
				< -37.327811, -71.064360, -94.333962>,
				< -28.068213, -65.391280, -92.806220>,
				< -22.685256, -68.028286, -64.727426>
			}
			triangle {
				< -37.327811, -71.064360, -94.333962>,
				< -42.817876, -63.978665, -124.300480>,
				< -28.068213, -65.391280, -92.806220>
			}
			triangle {
				< -42.817876, -63.978665, -124.300480>,
				< -32.990512, -59.038498, -119.673595>,
				< -28.068213, -65.391280, -92.806220>
			}
			triangle {
				< -42.817876, -63.978665, -124.300480>,
				< -47.420021, -53.231329, -150.873706>,
				< -32.990512, -59.038498, -119.673595>
			}
			triangle {
				< -47.420021, -53.231329, -150.873706>,
				< -37.116658, -49.402699, -143.498406>,
				< -32.990512, -59.038498, -119.673595>
			}
			triangle {
				< -47.420021, -53.231329, -150.873706>,
				< -50.820585, -39.554797, -172.242373>,
				< -37.116658, -49.402699, -143.498406>
			}
			triangle {
				< -50.820585, -39.554797, -172.242373>,
				< -40.165488, -37.140578, -162.657082>,
				< -37.116658, -49.402699, -143.498406>
			}
			triangle {
				< -50.820585, -39.554797, -172.242373>,
				< -52.787747, -23.881046, -186.950505>,
				< -40.165488, -37.140578, -162.657082>
			}
			triangle {
				< -52.787747, -23.881046, -186.950505>,
				< -41.929238, -23.087930, -175.844058>,
				< -40.165488, -37.140578, -162.657082>
			}
			triangle {
				< -52.787747, -23.881046, -186.950505>,
				< -53.187560, -7.278185, -193.995535>,
				< -41.929238, -23.087930, -175.844058>
			}
			triangle {
				< -53.187560, -7.278185, -193.995535>,
				< -42.287696, -8.202238, -182.160467>,
				< -41.929238, -23.087930, -175.844058>
			}
			triangle {
				< -53.187560, -7.278185, -193.995535>,
				< -51.992722, 9.122196, -192.897692>,
				< -42.287696, -8.202238, -182.160467>
			}
			triangle {
				< -51.992722, 9.122196, -192.897692>,
				< -41.216437, 6.501918, -181.176141>,
				< -42.287696, -8.202238, -182.160467>
			}
			triangle {
				< -51.992722, 9.122196, -192.897692>,
				< -49.284689, 24.202522, -183.731407>,
				< -41.216437, 6.501918, -181.176141>
			}
			triangle {
				< -49.284689, 24.202522, -183.731407>,
				< -38.788453, 20.022612, -172.957748>,
				< -41.216437, 6.501918, -181.176141>
			}
			triangle {
				< -49.284689, 24.202522, -183.731407>,
				< -45.247968, 36.935084, -167.121544>,
				< -38.788453, 20.022612, -172.957748>
			}
			triangle {
				< -45.247968, 36.935084, -167.121544>,
				< -35.169259, 31.438313, -158.065885>,
				< -38.788453, 20.022612, -172.957748>
			}
			triangle {
				< -45.247968, 36.935084, -167.121544>,
				< -40.157694, 46.452183, -144.200027>,
				< -35.169259, 31.438313, -158.065885>
			}
			triangle {
				< -40.157694, 46.452183, -144.200027>,
				< -30.605437, 39.971158, -137.514964>,
				< -35.169259, 31.438313, -158.065885>
			}
			triangle {
				< -40.157694, 46.452183, -144.200027>,
				< -34.360744, 52.105259, -116.528928>,
				< -30.605437, 39.971158, -137.514964>
			}
			triangle {
				< -34.360744, 52.105259, -116.528928>,
				< -25.408007, 45.039579, -112.705842>,
				< -30.605437, 39.971158, -137.514964>
			}
			triangle {
				< -34.360744, 52.105259, -116.528928>,
				< -28.252156, 53.509105, -85.993990>,
				< -25.408007, 45.039579, -112.705842>
			}
			triangle {
				< -28.252156, 53.509105, -85.993990>,
				< -19.931169, 46.298262, -85.328862>,
				< -25.408007, 45.039579, -112.705842>
			}
			triangle {
				< -28.252156, 53.509105, -85.993990>,
				< -22.248250, 50.567899, -54.676041>,
				< -19.931169, 46.298262, -85.328862>
			}
			triangle {
				< -22.248250, 50.567899, -54.676041>,
				< -14.548192, 43.661252, -57.249941>,
				< -19.931169, 46.298262, -85.328862>
			}
			triangle {
				< -22.248250, 50.567899, -54.676041>,
				< -16.758099, 43.482300, -24.709428>,
				< -14.548192, 43.661252, -57.249941>
			}
			triangle {
				< -16.758099, 43.482300, -24.709428>,
				< -9.625915, 37.308354, -30.382652>,
				< -14.548192, 43.661252, -57.249941>
			}
			triangle {
				< -16.758099, 43.482300, -24.709428>,
				< -12.155987, 32.734968, 1.863724>,
				< -9.625915, 37.308354, -30.382652>
			}
			triangle {
				< -12.155987, 32.734968, 1.863724>,
				< -5.499848, 27.672578, -6.557832>,
				< -9.625915, 37.308354, -30.382652>
			}
			triangle {
				< -12.155987, 32.734968, 1.863724>,
				< -8.755403, 19.058311, 23.232508>,
				< -5.499848, 27.672578, -6.557832>
			}
			triangle {
				< -8.755403, 19.058311, 23.232508>,
				< -2.450980, 15.410470, 12.600984>,
				< -5.499848, 27.672578, -6.557832>
			}
			triangle {
				< -17.113438, 20.754119, 27.241725>,
				< -15.076865, 4.527455, 42.468656>,
				< -8.755403, 19.058311, 23.232508>
			}
			triangle {
				< -15.076865, 4.527455, 42.468656>,
				< -6.788289, 3.384603, 37.940621>,
				< -8.755403, 19.058311, 23.232508>
			}
			triangle {
				< -15.076865, 4.527455, 42.468656>,
				< -14.662975, -12.661017, 49.762286>,
				< -6.788289, 3.384603, 37.940621>
			}
			triangle {
				< -14.662975, -12.661017, 49.762286>,
				< -6.388477, -13.218200, 44.985723>,
				< -6.788289, 3.384603, 37.940621>
			}
			triangle {
				< -14.662975, -12.661017, 49.762286>,
				< -15.899945, -29.639991, 48.625581>,
				< -6.388477, -13.218200, 44.985723>
			}
			triangle {
				< -15.899945, -29.639991, 48.625581>,
				< -7.583317, -29.618582, 43.887697>,
				< -6.388477, -13.218200, 44.985723>
			}
			triangle {
				< -15.899945, -29.639991, 48.625581>,
				< -18.703453, -45.252264, 39.135955>,
				< -7.583317, -29.618582, 43.887697>
			}
			triangle {
				< -18.703453, -45.252264, 39.135955>,
				< -10.291296, -44.698931, 34.721419>,
				< -7.583317, -29.618582, 43.887697>
			}
			triangle {
				< -18.703453, -45.252264, 39.135955>,
				< -22.882564, -58.434002, 21.940134>,
				< -10.291296, -44.698931, 34.721419>
			}
			triangle {
				< -22.882564, -58.434002, 21.940134>,
				< -14.328069, -57.431500, 18.111559>,
				< -10.291296, -44.698931, 34.721419>
			}
			triangle {
				< -22.882564, -58.434002, 21.940134>,
				< -28.152479, -68.286881, -1.789924>,
				< -14.328069, -57.431500, 18.111559>
			}
			triangle {
				< -28.152479, -68.286881, -1.789924>,
				< -19.418357, -66.948645, -4.809952>,
				< -14.328069, -57.431500, 18.111559>
			}
			triangle {
				< -28.152479, -68.286881, -1.789924>,
				< -34.153938, -74.139364, -30.437227>,
				< -19.418357, -66.948645, -4.809952>
			}
			triangle {
				< -34.153938, -74.139364, -30.437227>,
				< -25.215307, -72.601743, -32.481004>,
				< -19.418357, -66.948645, -4.809952>
			}
			triangle {
				< -34.153938, -74.139364, -30.437227>,
				< -40.477991, -75.592659, -62.049337>,
				< -25.215307, -72.601743, -32.481004>
			}
			triangle {
				< -40.477991, -75.592659, -62.049337>,
				< -31.323891, -74.005507, -63.016005>,
				< -25.215307, -72.601743, -32.481004>
			}
			triangle {
				< -40.477991, -75.592659, -62.049337>,
				< -46.693698, -72.547749, -94.472006>,
				< -31.323891, -74.005507, -63.016005>
			}
			triangle {
				< -46.693698, -72.547749, -94.472006>,
				< -37.327811, -71.064360, -94.333962>,
				< -31.323891, -74.005507, -63.016005>
			}
			triangle {
				< -46.693698, -72.547749, -94.472006>,
				< -52.377462, -65.212131, -125.495717>,
				< -37.327811, -71.064360, -94.333962>
			}
			triangle {
				< -52.377462, -65.212131, -125.495717>,
				< -42.817876, -63.978665, -124.300480>,
				< -37.327811, -71.064360, -94.333962>
			}
			triangle {
				< -52.377462, -65.212131, -125.495717>,
				< -57.141934, -54.085672, -153.006330>,
				< -42.817876, -63.978665, -124.300480>
			}
			triangle {
				< -57.141934, -54.085672, -153.006330>,
				< -47.420021, -53.231329, -150.873706>,
				< -42.817876, -63.978665, -124.300480>
			}
			triangle {
				< -57.141934, -54.085672, -153.006330>,
				< -60.662415, -39.926652, -175.128788>,
				< -47.420021, -53.231329, -150.873706>
			}
			triangle {
				< -60.662415, -39.926652, -175.128788>,
				< -50.820585, -39.554797, -172.242373>,
				< -47.420021, -53.231329, -150.873706>
			}
			triangle {
				< -60.662415, -39.926652, -175.128788>,
				< -62.699027, -23.699977, -190.355808>,
				< -50.820585, -39.554797, -172.242373>
			}
			triangle {
				< -62.699027, -23.699977, -190.355808>,
				< -52.787747, -23.881046, -186.950505>,
				< -50.820585, -39.554797, -172.242373>
			}
			triangle {
				< -62.699027, -23.699977, -190.355808>,
				< -63.112974, -6.511502, -197.649390>,
				< -52.787747, -23.881046, -186.950505>
			}
			triangle {
				< -63.112974, -6.511502, -197.649390>,
				< -53.187560, -7.278185, -193.995535>,
				< -52.787747, -23.881046, -186.950505>
			}
			triangle {
				< -63.112974, -6.511502, -197.649390>,
				< -61.875936, 10.467439, -196.512625>,
				< -53.187560, -7.278185, -193.995535>
			}
			triangle {
				< -61.875936, 10.467439, -196.512625>,
				< -51.992722, 9.122196, -192.897692>,
				< -53.187560, -7.278185, -193.995535>
			}
			triangle {
				< -61.875936, 10.467439, -196.512625>,
				< -59.072379, 26.079727, -187.023148>,
				< -51.992722, 9.122196, -192.897692>
			}
			triangle {
				< -59.072379, 26.079727, -187.023148>,
				< -49.284689, 24.202522, -183.731407>,
				< -51.992722, 9.122196, -192.897692>
			}
			triangle {
				< -59.072379, 26.079727, -187.023148>,
				< -54.893270, 39.261494, -169.827282>,
				< -49.284689, 24.202522, -183.731407>
			}
			triangle {
				< -54.893270, 39.261494, -169.827282>,
				< -45.247968, 36.935084, -167.121544>,
				< -49.284689, 24.202522, -183.731407>
			}
			triangle {
				< -54.893270, 39.261494, -169.827282>,
				< -49.623415, 49.114343, -146.097198>,
				< -45.247968, 36.935084, -167.121544>
			}
			triangle {
				< -49.623415, 49.114343, -146.097198>,
				< -40.157694, 46.452183, -144.200027>,
				< -45.247968, 36.935084, -167.121544>
			}
			triangle {
				< -49.623415, 49.114343, -146.097198>,
				< -43.621983, 54.966822, -117.449999>,
				< -40.157694, 46.452183, -144.200027>
			}
			triangle {
				< -43.621983, 54.966822, -117.449999>,
				< -34.360744, 52.105259, -116.528928>,
				< -40.157694, 46.452183, -144.200027>
			}
			triangle {
				< -43.621983, 54.966822, -117.449999>,
				< -37.297904, 56.420140, -85.837804>,
				< -34.360744, 52.105259, -116.528928>
			}
			triangle {
				< -37.297904, 56.420140, -85.837804>,
				< -28.252156, 53.509105, -85.993990>,
				< -34.360744, 52.105259, -116.528928>
			}
			triangle {
				< -37.297904, 56.420140, -85.837804>,
				< -31.082204, 53.375237, -53.415217>,
				< -28.252156, 53.509105, -85.993990>
			}
			triangle {
				< -31.082204, 53.375237, -53.415217>,
				< -22.248250, 50.567899, -54.676041>,
				< -28.252156, 53.509105, -85.993990>
			}
			triangle {
				< -31.082204, 53.375237, -53.415217>,
				< -25.398443, 46.039596, -22.391424>,
				< -22.248250, 50.567899, -54.676041>
			}
			triangle {
				< -25.398443, 46.039596, -22.391424>,
				< -16.758099, 43.482300, -24.709428>,
				< -22.248250, 50.567899, -54.676041>
			}
			triangle {
				< -25.398443, 46.039596, -22.391424>,
				< -20.633899, 34.913220, 5.119092>,
				< -16.758099, 43.482300, -24.709428>
			}
			triangle {
				< -20.633899, 34.913220, 5.119092>,
				< -12.155987, 32.734968, 1.863724>,
				< -16.758099, 43.482300, -24.709428>
			}
			triangle {
				< -20.633899, 34.913220, 5.119092>,
				< -17.113438, 20.754119, 27.241725>,
				< -12.155987, 32.734968, 1.863724>
			}
			triangle {
				< -17.113438, 20.754119, 27.241725>,
				< -8.755403, 19.058311, 23.232508>,
				< -12.155987, 32.734968, 1.863724>
			}
			triangle {
				< -26.955269, 20.382291, 24.355361>,
				< -24.988122, 4.708510, 39.063431>,
				< -17.113438, 20.754119, 27.241725>
			}
			triangle {
				< -24.988122, 4.708510, 39.063431>,
				< -15.076865, 4.527455, 42.468656>,
				< -17.113438, 20.754119, 27.241725>
			}
			triangle {
				< -24.988122, 4.708510, 39.063431>,
				< -24.588250, -11.894334, 46.108555>,
				< -15.076865, 4.527455, 42.468656>
			}
			triangle {
				< -24.588250, -11.894334, 46.108555>,
				< -14.662975, -12.661017, 49.762286>,
				< -15.076865, 4.527455, 42.468656>
			}
			triangle {
				< -24.588250, -11.894334, 46.108555>,
				< -25.783110, -28.294696, 45.010507>,
				< -14.662975, -12.661017, 49.762286>
			}
			triangle {
				< -25.783110, -28.294696, 45.010507>,
				< -15.899945, -29.639991, 48.625581>,
				< -14.662975, -12.661017, 49.762286>
			}
			triangle {
				< -25.783110, -28.294696, 45.010507>,
				< -28.491214, -43.375026, 35.844274>,
				< -15.899945, -29.639991, 48.625581>
			}
			triangle {
				< -28.491214, -43.375026, 35.844274>,
				< -18.703453, -45.252264, 39.135955>,
				< -15.899945, -29.639991, 48.625581>
			}
			triangle {
				< -28.491214, -43.375026, 35.844274>,
				< -32.527924, -56.107596, 19.234370>,
				< -18.703453, -45.252264, 39.135955>
			}
			triangle {
				< -32.527924, -56.107596, 19.234370>,
				< -22.882564, -58.434002, 21.940134>,
				< -18.703453, -45.252264, 39.135955>
			}
			triangle {
				< -32.527924, -56.107596, 19.234370>,
				< -37.618212, -65.624736, -3.687141>,
				< -22.882564, -58.434002, 21.940134>
			}
			triangle {
				< -37.618212, -65.624736, -3.687141>,
				< -28.152479, -68.286881, -1.789924>,
				< -22.882564, -58.434002, 21.940134>
			}
			triangle {
				< -37.618212, -65.624736, -3.687141>,
				< -43.415163, -71.277842, -31.358194>,
				< -28.152479, -68.286881, -1.789924>
			}
			triangle {
				< -43.415163, -71.277842, -31.358194>,
				< -34.153938, -74.139364, -30.437227>,
				< -28.152479, -68.286881, -1.789924>
			}
			triangle {
				< -43.415163, -71.277842, -31.358194>,
				< -49.523748, -72.681598, -61.893195>,
				< -34.153938, -74.139364, -30.437227>
			}
			triangle {
				< -49.523748, -72.681598, -61.893195>,
				< -40.477991, -75.592659, -62.049337>,
				< -34.153938, -74.139364, -30.437227>
			}
			triangle {
				< -49.523748, -72.681598, -61.893195>,
				< -55.527657, -69.740437, -93.211189>,
				< -40.477991, -75.592659, -62.049337>
			}
			triangle {
				< -55.527657, -69.740437, -93.211189>,
				< -46.693698, -72.547749, -94.472006>,
				< -40.477991, -75.592659, -62.049337>
			}
			triangle {
				< -55.527657, -69.740437, -93.211189>,
				< -61.017733, -62.654749, -123.177715>,
				< -46.693698, -72.547749, -94.472006>
			}
			triangle {
				< -61.017733, -62.654749, -123.177715>,
				< -52.377462, -65.212131, -125.495717>,
				< -46.693698, -72.547749, -94.472006>
			}
			triangle {
				< -61.017733, -62.654749, -123.177715>,
				< -65.619864, -51.907405, -149.750933>,
				< -52.377462, -65.212131, -125.495717>
			}
			triangle {
				< -65.619864, -51.907405, -149.750933>,
				< -57.141934, -54.085672, -153.006330>,
				< -52.377462, -65.212131, -125.495717>
			}
			triangle {
				< -65.619864, -51.907405, -149.750933>,
				< -69.020413, -38.230885, -171.119615>,
				< -57.141934, -54.085672, -153.006330>
			}
			triangle {
				< -69.020413, -38.230885, -171.119615>,
				< -60.662415, -39.926652, -175.128788>,
				< -57.141934, -54.085672, -153.006330>
			}
			triangle {
				< -69.020413, -38.230885, -171.119615>,
				< -70.987657, -22.557132, -185.827747>,
				< -60.662415, -39.926652, -175.128788>
			}
			triangle {
				< -70.987657, -22.557132, -185.827747>,
				< -62.699027, -23.699977, -190.355808>,
				< -60.662415, -39.926652, -175.128788>
			}
			triangle {
				< -70.987657, -22.557132, -185.827747>,
				< -71.387351, -5.954278, -192.872718>,
				< -62.699027, -23.699977, -190.355808>
			}
			triangle {
				< -71.387351, -5.954278, -192.872718>,
				< -63.112974, -6.511502, -197.649390>,
				< -62.699027, -23.699977, -190.355808>
			}
			triangle {
				< -71.387351, -5.954278, -192.872718>,
				< -70.192598, 10.446103, -191.774830>,
				< -63.112974, -6.511502, -197.649390>
			}
			triangle {
				< -70.192598, 10.446103, -191.774830>,
				< -61.875936, 10.467439, -196.512625>,
				< -63.112974, -6.511502, -197.649390>
			}
			triangle {
				< -70.192598, 10.446103, -191.774830>,
				< -67.484513, 25.526427, -182.608590>,
				< -61.875936, 10.467439, -196.512625>
			}
			triangle {
				< -67.484513, 25.526427, -182.608590>,
				< -59.072379, 26.079727, -187.023148>,
				< -61.875936, 10.467439, -196.512625>
			}
			triangle {
				< -67.484513, 25.526427, -182.608590>,
				< -63.447826, 38.258988, -165.998727>,
				< -59.072379, 26.079727, -187.023148>
			}
			triangle {
				< -63.447826, 38.258988, -165.998727>,
				< -54.893270, 39.261494, -169.827282>,
				< -59.072379, 26.079727, -187.023148>
			}
			triangle {
				< -63.447826, 38.258988, -165.998727>,
				< -58.357570, 47.776088, -143.077344>,
				< -54.893270, 39.261494, -169.827282>
			}
			triangle {
				< -58.357570, 47.776088, -143.077344>,
				< -49.623415, 49.114343, -146.097198>,
				< -54.893270, 39.261494, -169.827282>
			}
			triangle {
				< -58.357570, 47.776088, -143.077344>,
				< -52.560598, 53.429294, -115.406036>,
				< -49.623415, 49.114343, -146.097198>
			}
			triangle {
				< -52.560598, 53.429294, -115.406036>,
				< -43.621983, 54.966822, -117.449999>,
				< -49.623415, 49.114343, -146.097198>
			}
			triangle {
				< -52.560598, 53.429294, -115.406036>,
				< -46.452034, 54.833241, -84.871180>,
				< -43.621983, 54.966822, -117.449999>
			}
			triangle {
				< -46.452034, 54.833241, -84.871180>,
				< -37.297904, 56.420140, -85.837804>,
				< -43.621983, 54.966822, -117.449999>
			}
			triangle {
				< -46.452034, 54.833241, -84.871180>,
				< -40.448118, 51.891804, -53.553253>,
				< -37.297904, 56.420140, -85.837804>
			}
			triangle {
				< -40.448118, 51.891804, -53.553253>,
				< -31.082204, 53.375237, -53.415217>,
				< -37.297904, 56.420140, -85.837804>
			}
			triangle {
				< -40.448118, 51.891804, -53.553253>,
				< -34.958016, 44.806313, -23.586636>,
				< -31.082204, 53.375237, -53.415217>
			}
			triangle {
				< -34.958016, 44.806313, -23.586636>,
				< -25.398443, 46.039596, -22.391424>,
				< -31.082204, 53.375237, -53.415217>
			}
			triangle {
				< -34.958016, 44.806313, -23.586636>,
				< -30.355852, 34.058865, 2.986535>,
				< -25.398443, 46.039596, -22.391424>
			}
			triangle {
				< -30.355852, 34.058865, 2.986535>,
				< -20.633899, 34.913220, 5.119092>,
				< -25.398443, 46.039596, -22.391424>
			}
			triangle {
				< -30.355852, 34.058865, 2.986535>,
				< -26.955269, 20.382291, 24.355361>,
				< -20.633899, 34.913220, 5.119092>
			}
			triangle {
				< -26.955269, 20.382291, 24.355361>,
				< -17.113438, 20.754119, 27.241725>,
				< -20.633899, 34.913220, 5.119092>
			}
			triangle {
				< -37.610386, 17.968098, 14.770064>,
				< -35.846643, 3.915367, 27.956938>,
				< -26.955269, 20.382291, 24.355361>
			}
			triangle {
				< -35.846643, 3.915367, 27.956938>,
				< -24.988122, 4.708510, 39.063431>,
				< -26.955269, 20.382291, 24.355361>
			}
			triangle {
				< -35.846643, 3.915367, 27.956938>,
				< -35.488188, -10.970239, 34.273431>,
				< -24.988122, 4.708510, 39.063431>
			}
			triangle {
				< -35.488188, -10.970239, 34.273431>,
				< -24.588250, -11.894334, 46.108555>,
				< -24.988122, 4.708510, 39.063431>
			}
			triangle {
				< -35.488188, -10.970239, 34.273431>,
				< -36.559448, -25.674505, 33.288963>,
				< -24.588250, -11.894334, 46.108555>
			}
			triangle {
				< -36.559448, -25.674505, 33.288963>,
				< -25.783110, -28.294696, 45.010507>,
				< -24.588250, -11.894334, 46.108555>
			}
			triangle {
				< -36.559448, -25.674505, 33.288963>,
				< -38.987439, -39.195139, 25.070699>,
				< -25.783110, -28.294696, 45.010507>
			}
			triangle {
				< -38.987439, -39.195139, 25.070699>,
				< -28.491214, -43.375026, 35.844274>,
				< -25.783110, -28.294696, 45.010507>
			}
			triangle {
				< -38.987439, -39.195139, 25.070699>,
				< -42.606637, -50.610848, 10.178718>,
				< -28.491214, -43.375026, 35.844274>
			}
			triangle {
				< -42.606637, -50.610848, 10.178718>,
				< -32.527924, -56.107596, 19.234370>,
				< -28.491214, -43.375026, 35.844274>
			}
			triangle {
				< -42.606637, -50.610848, 10.178718>,
				< -47.170468, -59.143666, -10.372183>,
				< -32.527924, -56.107596, 19.234370>
			}
			triangle {
				< -47.170468, -59.143666, -10.372183>,
				< -37.618212, -65.624736, -3.687141>,
				< -32.527924, -56.107596, 19.234370>
			}
			triangle {
				< -47.170468, -59.143666, -10.372183>,
				< -52.367873, -64.212099, -35.181366>,
				< -37.618212, -65.624736, -3.687141>
			}
			triangle {
				< -52.367873, -64.212099, -35.181366>,
				< -43.415163, -71.277842, -31.358194>,
				< -37.618212, -65.624736, -3.687141>
			}
			triangle {
				< -52.367873, -64.212099, -35.181366>,
				< -57.844684, -65.470681, -62.558323>,
				< -43.415163, -71.277842, -31.358194>
			}
			triangle {
				< -57.844684, -65.470681, -62.558323>,
				< -49.523748, -72.681598, -61.893195>,
				< -43.415163, -71.277842, -31.358194>
			}
			triangle {
				< -57.844684, -65.470681, -62.558323>,
				< -63.227624, -62.833674, -90.637118>,
				< -49.523748, -72.681598, -61.893195>
			}
			triangle {
				< -63.227624, -62.833674, -90.637118>,
				< -55.527657, -69.740437, -93.211189>,
				< -49.523748, -72.681598, -61.893195>
			}
			triangle {
				< -63.227624, -62.833674, -90.637118>,
				< -68.149917, -56.480888, -117.504574>,
				< -55.527657, -69.740437, -93.211189>
			}
			triangle {
				< -68.149917, -56.480888, -117.504574>,
				< -61.017733, -62.654749, -123.177715>,
				< -55.527657, -69.740437, -93.211189>
			}
			triangle {
				< -68.149917, -56.480888, -117.504574>,
				< -72.276123, -46.845071, -141.329348>,
				< -61.017733, -62.654749, -123.177715>
			}
			triangle {
				< -72.276123, -46.845071, -141.329348>,
				< -65.619864, -51.907405, -149.750933>,
				< -61.017733, -62.654749, -123.177715>
			}
			triangle {
				< -72.276123, -46.845071, -141.329348>,
				< -75.324997, -34.582965, -160.488069>,
				< -65.619864, -51.907405, -149.750933>
			}
			triangle {
				< -75.324997, -34.582965, -160.488069>,
				< -69.020413, -38.230885, -171.119615>,
				< -65.619864, -51.907405, -149.750933>
			}
			triangle {
				< -75.324997, -34.582965, -160.488069>,
				< -77.088654, -20.530300, -173.674956>,
				< -69.020413, -38.230885, -171.119615>
			}
			triangle {
				< -77.088654, -20.530300, -173.674956>,
				< -70.987657, -22.557132, -185.827747>,
				< -69.020413, -38.230885, -171.119615>
			}
			triangle {
				< -77.088654, -20.530300, -173.674956>,
				< -77.447101, -5.644631, -179.991409>,
				< -70.987657, -22.557132, -185.827747>
			}
			triangle {
				< -77.447101, -5.644631, -179.991409>,
				< -71.387351, -5.954278, -192.872718>,
				< -70.987657, -22.557132, -185.827747>
			}
			triangle {
				< -77.447101, -5.644631, -179.991409>,
				< -76.375842, 9.059505, -179.006994>,
				< -71.387351, -5.954278, -192.872718>
			}
			triangle {
				< -76.375842, 9.059505, -179.006994>,
				< -70.192598, 10.446103, -191.774830>,
				< -71.387351, -5.954278, -192.872718>
			}
			triangle {
				< -76.375842, 9.059505, -179.006994>,
				< -73.947854, 22.580231, -170.788676>,
				< -70.192598, 10.446103, -191.774830>
			}
			triangle {
				< -73.947854, 22.580231, -170.788676>,
				< -67.484513, 25.526427, -182.608590>,
				< -70.192598, 10.446103, -191.774830>
			}
			triangle {
				< -73.947854, 22.580231, -170.788676>,
				< -70.328690, 33.995923, -155.896783>,
				< -67.484513, 25.526427, -182.608590>
			}
			triangle {
				< -70.328690, 33.995923, -155.896783>,
				< -63.447826, 38.258988, -165.998727>,
				< -67.484513, 25.526427, -182.608590>
			}
			triangle {
				< -70.328690, 33.995923, -155.896783>,
				< -65.764844, 42.528827, -135.345951>,
				< -63.447826, 38.258988, -165.998727>
			}
			triangle {
				< -65.764844, 42.528827, -135.345951>,
				< -58.357570, 47.776088, -143.077344>,
				< -63.447826, 38.258988, -165.998727>
			}
			triangle {
				< -65.764844, 42.528827, -135.345951>,
				< -60.567442, 47.597166, -110.536702>,
				< -58.357570, 47.776088, -143.077344>
			}
			triangle {
				< -60.567442, 47.597166, -110.536702>,
				< -52.560598, 53.429294, -115.406036>,
				< -58.357570, 47.776088, -143.077344>
			}
			triangle {
				< -60.567442, 47.597166, -110.536702>,
				< -55.090636, 48.855774, -83.159767>,
				< -52.560598, 53.429294, -115.406036>
			}
			triangle {
				< -55.090636, 48.855774, -83.159767>,
				< -46.452034, 54.833241, -84.871180>,
				< -52.560598, 53.429294, -115.406036>
			}
			triangle {
				< -55.090636, 48.855774, -83.159767>,
				< -49.707670, 46.218809, -55.080820>,
				< -46.452034, 54.833241, -84.871180>
			}
			triangle {
				< -49.707670, 46.218809, -55.080820>,
				< -40.448118, 51.891804, -53.553253>,
				< -46.452034, 54.833241, -84.871180>
			}
			triangle {
				< -49.707670, 46.218809, -55.080820>,
				< -44.785384, 39.865971, -28.213510>,
				< -40.448118, 51.891804, -53.553253>
			}
			triangle {
				< -44.785384, 39.865971, -28.213510>,
				< -34.958016, 44.806313, -23.586636>,
				< -40.448118, 51.891804, -53.553253>
			}
			triangle {
				< -44.785384, 39.865971, -28.213510>,
				< -40.659241, 30.230176, -4.388732>,
				< -34.958016, 44.806313, -23.586636>
			}
			triangle {
				< -40.659241, 30.230176, -4.388732>,
				< -30.355852, 34.058865, 2.986535>,
				< -34.958016, 44.806313, -23.586636>
			}
			triangle {
				< -40.659241, 30.230176, -4.388732>,
				< -37.610386, 17.968098, 14.770064>,
				< -30.355852, 34.058865, 2.986535>
			}
			triangle {
				< -37.610386, 17.968098, 14.770064>,
				< -26.955269, 20.382291, 24.355361>,
				< -30.355852, 34.058865, 2.986535>
			}
			triangle {
				< -48.352528, 13.676140, -0.860943>,
				< -46.912435, 2.202165, 9.906131>,
				< -37.610386, 17.968098, 14.770064>
			}
			triangle {
				< -46.912435, 2.202165, 9.906131>,
				< -35.846643, 3.915367, 27.956938>,
				< -37.610386, 17.968098, 14.770064>
			}
			triangle {
				< -46.912435, 2.202165, 9.906131>,
				< -46.619743, -9.951962, 15.063499>,
				< -35.846643, 3.915367, 27.956938>
			}
			triangle {
				< -46.619743, -9.951962, 15.063499>,
				< -35.488188, -10.970239, 34.273431>,
				< -35.846643, 3.915367, 27.956938>
			}
			triangle {
				< -46.619743, -9.951962, 15.063499>,
				< -47.494438, -21.957915, 14.259714>,
				< -35.488188, -10.970239, 34.273431>
			}
			triangle {
				< -47.494438, -21.957915, 14.259714>,
				< -36.559448, -25.674505, 33.288963>,
				< -35.488188, -10.970239, 34.273431>
			}
			triangle {
				< -47.494438, -21.957915, 14.259714>,
				< -49.476873, -32.997470, 7.549537>,
				< -36.559448, -25.674505, 33.288963>
			}
			triangle {
				< -49.476873, -32.997470, 7.549537>,
				< -38.987439, -39.195139, 25.070699>,
				< -36.559448, -25.674505, 33.288963>
			}
			triangle {
				< -49.476873, -32.997470, 7.549537>,
				< -52.431956, -42.318359, -4.609725>,
				< -38.987439, -39.195139, 25.070699>
			}
			triangle {
				< -52.431956, -42.318359, -4.609725>,
				< -42.606637, -50.610848, 10.178718>,
				< -38.987439, -39.195139, 25.070699>
			}
			triangle {
				< -52.431956, -42.318359, -4.609725>,
				< -56.158293, -49.285371, -21.389464>,
				< -42.606637, -50.610848, 10.178718>
			}
			triangle {
				< -56.158293, -49.285371, -21.389464>,
				< -47.170468, -59.143666, -10.372183>,
				< -42.606637, -50.610848, 10.178718>
			}
			triangle {
				< -56.158293, -49.285371, -21.389464>,
				< -60.401972, -53.423692, -41.646142>,
				< -47.170468, -59.143666, -10.372183>
			}
			triangle {
				< -60.401972, -53.423692, -41.646142>,
				< -52.367873, -64.212099, -35.181366>,
				< -47.170468, -59.143666, -10.372183>
			}
			triangle {
				< -60.401972, -53.423692, -41.646142>,
				< -64.873762, -54.451331, -63.999310>,
				< -52.367873, -64.212099, -35.181366>
			}
			triangle {
				< -64.873762, -54.451331, -63.999310>,
				< -57.844684, -65.470681, -62.558323>,
				< -52.367873, -64.212099, -35.181366>
			}
			triangle {
				< -64.873762, -54.451331, -63.999310>,
				< -69.268912, -52.298296, -86.925581>,
				< -57.844684, -65.470681, -62.558323>
			}
			triangle {
				< -69.268912, -52.298296, -86.925581>,
				< -63.227624, -62.833674, -90.637118>,
				< -57.844684, -65.470681, -62.558323>
			}
			triangle {
				< -69.268912, -52.298296, -86.925581>,
				< -73.287949, -47.111217, -108.862668>,
				< -63.227624, -62.833674, -90.637118>
			}
			triangle {
				< -73.287949, -47.111217, -108.862668>,
				< -68.149917, -56.480888, -117.504574>,
				< -63.227624, -62.833674, -90.637118>
			}
			triangle {
				< -73.287949, -47.111217, -108.862668>,
				< -76.657005, -39.243571, -128.315553>,
				< -68.149917, -56.480888, -117.504574>
			}
			triangle {
				< -76.657005, -39.243571, -128.315553>,
				< -72.276123, -46.845071, -141.329348>,
				< -68.149917, -56.480888, -117.504574>
			}
			triangle {
				< -76.657005, -39.243571, -128.315553>,
				< -79.146370, -29.231643, -143.958583>,
				< -72.276123, -46.845071, -141.329348>
			}
			triangle {
				< -79.146370, -29.231643, -143.958583>,
				< -75.324997, -34.582965, -160.488069>,
				< -72.276123, -46.845071, -141.329348>
			}
			triangle {
				< -79.146370, -29.231643, -143.958583>,
				< -80.586523, -17.757650, -154.725730>,
				< -75.324997, -34.582965, -160.488069>
			}
			triangle {
				< -80.586523, -17.757650, -154.725730>,
				< -77.088654, -20.530300, -173.674956>,
				< -75.324997, -34.582965, -160.488069>
			}
			triangle {
				< -80.586523, -17.757650, -154.725730>,
				< -80.879062, -5.603576, -159.883022>,
				< -77.088654, -20.530300, -173.674956>
			}
			triangle {
				< -80.879062, -5.603576, -159.883022>,
				< -77.447101, -5.644631, -179.991409>,
				< -77.088654, -20.530300, -173.674956>
			}
			triangle {
				< -80.879062, -5.603576, -159.883022>,
				< -80.004498, 6.402354, -159.079283>,
				< -77.447101, -5.644631, -179.991409>
			}
			triangle {
				< -80.004498, 6.402354, -159.079283>,
				< -76.375842, 9.059505, -179.006994>,
				< -77.447101, -5.644631, -179.991409>
			}
			triangle {
				< -80.004498, 6.402354, -159.079283>,
				< -78.021966, 17.441932, -152.369052>,
				< -76.375842, 9.059505, -179.006994>
			}
			triangle {
				< -78.021966, 17.441932, -152.369052>,
				< -73.947854, 22.580231, -170.788676>,
				< -76.375842, 9.059505, -179.006994>
			}
			triangle {
				< -78.021966, 17.441932, -152.369052>,
				< -75.066887, 26.762810, -140.209824>,
				< -73.947854, 22.580231, -170.788676>
			}
			triangle {
				< -75.066887, 26.762810, -140.209824>,
				< -70.328690, 33.995923, -155.896783>,
				< -73.947854, 22.580231, -170.788676>
			}
			triangle {
				< -75.066887, 26.762810, -140.209824>,
				< -71.340553, 33.729825, -123.430088>,
				< -70.328690, 33.995923, -155.896783>
			}
			triangle {
				< -71.340553, 33.729825, -123.430088>,
				< -65.764844, 42.528827, -135.345951>,
				< -70.328690, 33.995923, -155.896783>
			}
			triangle {
				< -71.340553, 33.729825, -123.430088>,
				< -67.096874, 37.868176, -103.173412>,
				< -65.764844, 42.528827, -135.345951>
			}
			triangle {
				< -67.096874, 37.868176, -103.173412>,
				< -60.567442, 47.597166, -110.536702>,
				< -65.764844, 42.528827, -135.345951>
			}
			triangle {
				< -67.096874, 37.868176, -103.173412>,
				< -62.625095, 38.895808, -80.820352>,
				< -60.567442, 47.597166, -110.536702>
			}
			triangle {
				< -62.625095, 38.895808, -80.820352>,
				< -55.090636, 48.855774, -83.159767>,
				< -60.567442, 47.597166, -110.536702>
			}
			triangle {
				< -62.625095, 38.895808, -80.820352>,
				< -58.229920, 36.742765, -57.893954>,
				< -55.090636, 48.855774, -83.159767>
			}
			triangle {
				< -58.229920, 36.742765, -57.893954>,
				< -49.707670, 46.218809, -55.080820>,
				< -55.090636, 48.855774, -83.159767>
			}
			triangle {
				< -58.229920, 36.742765, -57.893954>,
				< -54.210890, 31.555679, -35.956889>,
				< -49.707670, 46.218809, -55.080820>
			}
			triangle {
				< -54.210890, 31.555679, -35.956889>,
				< -44.785384, 39.865971, -28.213510>,
				< -49.707670, 46.218809, -55.080820>
			}
			triangle {
				< -54.210890, 31.555679, -35.956889>,
				< -50.841898, 23.688104, -16.503936>,
				< -44.785384, 39.865971, -28.213510>
			}
			triangle {
				< -50.841898, 23.688104, -16.503936>,
				< -40.659241, 30.230176, -4.388732>,
				< -44.785384, 39.865971, -28.213510>
			}
			triangle {
				< -50.841898, 23.688104, -16.503936>,
				< -48.352528, 13.676140, -0.860943>,
				< -40.659241, 30.230176, -4.388732>
			}
			triangle {
				< -48.352528, 13.676140, -0.860943>,
				< -37.610386, 17.968098, 14.770064>,
				< -40.659241, 30.230176, -4.388732>
			}
			triangle {
				< -58.449659, 7.798889, -21.472361>,
				< -57.431351, -0.314428, -13.858917>,
				< -48.352528, 13.676140, -0.860943>
			}
			triangle {
				< -57.431351, -0.314428, -13.858917>,
				< -46.912435, 2.202165, 9.906131>,
				< -48.352528, 13.676140, -0.860943>
			}
			triangle {
				< -57.431351, -0.314428, -13.858917>,
				< -57.224404, -8.908675, -10.212143>,
				< -46.912435, 2.202165, 9.906131>
			}
			triangle {
				< -57.224404, -8.908675, -10.212143>,
				< -46.619743, -9.951962, 15.063499>,
				< -46.912435, 2.202165, 9.906131>
			}
			triangle {
				< -57.224404, -8.908675, -10.212143>,
				< -57.842903, -17.398119, -10.780463>,
				< -46.619743, -9.951962, 15.063499>
			}
			triangle {
				< -57.842903, -17.398119, -10.780463>,
				< -47.494438, -21.957915, 14.259714>,
				< -46.619743, -9.951962, 15.063499>
			}
			triangle {
				< -57.842903, -17.398119, -10.780463>,
				< -59.244700, -25.204349, -15.525265>,
				< -47.494438, -21.957915, 14.259714>
			}
			triangle {
				< -59.244700, -25.204349, -15.525265>,
				< -49.476873, -32.997470, 7.549537>,
				< -47.494438, -21.957915, 14.259714>
			}
			triangle {
				< -59.244700, -25.204349, -15.525265>,
				< -61.334252, -31.795241, -24.123218>,
				< -49.476873, -32.997470, 7.549537>
			}
			triangle {
				< -61.334252, -31.795241, -24.123218>,
				< -52.431956, -42.318359, -4.609725>,
				< -49.476873, -32.997470, 7.549537>
			}
			triangle {
				< -61.334252, -31.795241, -24.123218>,
				< -63.969165, -36.721595, -35.988256>,
				< -52.431956, -42.318359, -4.609725>
			}
			triangle {
				< -63.969165, -36.721595, -35.988256>,
				< -56.158293, -49.285371, -21.389464>,
				< -52.431956, -42.318359, -4.609725>
			}
			triangle {
				< -63.969165, -36.721595, -35.988256>,
				< -66.969901, -39.647859, -50.311878>,
				< -56.158293, -49.285371, -21.389464>
			}
			triangle {
				< -66.969901, -39.647859, -50.311878>,
				< -60.401972, -53.423692, -41.646142>,
				< -56.158293, -49.285371, -21.389464>
			}
			triangle {
				< -66.969901, -39.647859, -50.311878>,
				< -70.131935, -40.374540, -66.117935>,
				< -60.401972, -53.423692, -41.646142>
			}
			triangle {
				< -70.131935, -40.374540, -66.117935>,
				< -64.873762, -54.451331, -63.999310>,
				< -60.401972, -53.423692, -41.646142>
			}
			triangle {
				< -70.131935, -40.374540, -66.117935>,
				< -73.239788, -38.852062, -82.329370>,
				< -64.873762, -54.451331, -63.999310>
			}
			triangle {
				< -73.239788, -38.852062, -82.329370>,
				< -69.268912, -52.298296, -86.925581>,
				< -64.873762, -54.451331, -63.999310>
			}
			triangle {
				< -73.239788, -38.852062, -82.329370>,
				< -76.081656, -35.184249, -97.841188>,
				< -69.268912, -52.298296, -86.925581>
			}
			triangle {
				< -76.081656, -35.184249, -97.841188>,
				< -73.287949, -47.111217, -108.862668>,
				< -69.268912, -52.298296, -86.925581>
			}
			triangle {
				< -76.081656, -35.184249, -97.841188>,
				< -78.463905, -29.620983, -111.596443>,
				< -73.287949, -47.111217, -108.862668>
			}
			triangle {
				< -78.463905, -29.620983, -111.596443>,
				< -76.657005, -39.243571, -128.315553>,
				< -73.287949, -47.111217, -108.862668>
			}
			triangle {
				< -78.463905, -29.620983, -111.596443>,
				< -80.224156, -22.541489, -122.657761>,
				< -76.657005, -39.243571, -128.315553>
			}
			triangle {
				< -80.224156, -22.541489, -122.657761>,
				< -79.146370, -29.231643, -143.958583>,
				< -76.657005, -39.243571, -128.315553>
			}
			triangle {
				< -80.224156, -22.541489, -122.657761>,
				< -81.242539, -14.428173, -130.271181>,
				< -79.146370, -29.231643, -143.958583>
			}
			triangle {
				< -81.242539, -14.428173, -130.271181>,
				< -80.586523, -17.757650, -154.725730>,
				< -79.146370, -29.231643, -143.958583>
			}
			triangle {
				< -81.242539, -14.428173, -130.271181>,
				< -81.449382, -5.833906, -133.918002>,
				< -80.586523, -17.757650, -154.725730>
			}
			triangle {
				< -81.449382, -5.833906, -133.918002>,
				< -80.879062, -5.603576, -159.883022>,
				< -80.586523, -17.757650, -154.725730>
			}
			triangle {
				< -81.449382, -5.833906, -133.918002>,
				< -80.830932, 2.655559, -133.349553>,
				< -80.879062, -5.603576, -159.883022>
			}
			triangle {
				< -80.830932, 2.655559, -133.349553>,
				< -80.004498, 6.402354, -159.079283>,
				< -80.879062, -5.603576, -159.883022>
			}
			triangle {
				< -80.830932, 2.655559, -133.349553>,
				< -79.429142, 10.461694, -128.604859>,
				< -80.004498, 6.402354, -159.079283>
			}
			triangle {
				< -79.429142, 10.461694, -128.604859>,
				< -78.021966, 17.441932, -152.369052>,
				< -80.004498, 6.402354, -159.079283>
			}
			triangle {
				< -79.429142, 10.461694, -128.604859>,
				< -77.339552, 17.052554, -120.006926>,
				< -78.021966, 17.441932, -152.369052>
			}
			triangle {
				< -77.339552, 17.052554, -120.006926>,
				< -75.066887, 26.762810, -140.209824>,
				< -78.021966, 17.441932, -152.369052>
			}
			triangle {
				< -77.339552, 17.052554, -120.006926>,
				< -74.704647, 21.979041, -108.141929>,
				< -75.066887, 26.762810, -140.209824>
			}
			triangle {
				< -74.704647, 21.979041, -108.141929>,
				< -71.340553, 33.729825, -123.430088>,
				< -75.066887, 26.762810, -140.209824>
			}
			triangle {
				< -74.704647, 21.979041, -108.141929>,
				< -71.703926, 24.905240, -93.818262>,
				< -71.340553, 33.729825, -123.430088>
			}
			triangle {
				< -71.703926, 24.905240, -93.818262>,
				< -67.096874, 37.868176, -103.173412>,
				< -71.340553, 33.729825, -123.430088>
			}
			triangle {
				< -71.703926, 24.905240, -93.818262>,
				< -68.541877, 25.631893, -78.012168>,
				< -67.096874, 37.868176, -103.173412>
			}
			triangle {
				< -68.541877, 25.631893, -78.012168>,
				< -62.625095, 38.895808, -80.820352>,
				< -67.096874, 37.868176, -103.173412>
			}
			triangle {
				< -68.541877, 25.631893, -78.012168>,
				< -65.434039, 24.109447, -61.800856>,
				< -62.625095, 38.895808, -80.820352>
			}
			triangle {
				< -65.434039, 24.109447, -61.800856>,
				< -58.229920, 36.742765, -57.893954>,
				< -62.625095, 38.895808, -80.820352>
			}
			triangle {
				< -65.434039, 24.109447, -61.800856>,
				< -62.592134, 20.441648, -46.288937>,
				< -58.229920, 36.742765, -57.893954>
			}
			triangle {
				< -62.592134, 20.441648, -46.288937>,
				< -54.210890, 31.555679, -35.956889>,
				< -58.229920, 36.742765, -57.893954>
			}
			triangle {
				< -62.592134, 20.441648, -46.288937>,
				< -60.209911, 14.878443, -32.533720>,
				< -54.210890, 31.555679, -35.956889>
			}
			triangle {
				< -60.209911, 14.878443, -32.533720>,
				< -50.841898, 23.688104, -16.503936>,
				< -54.210890, 31.555679, -35.956889>
			}
			triangle {
				< -60.209911, 14.878443, -32.533720>,
				< -58.449659, 7.798889, -21.472361>,
				< -50.841898, 23.688104, -16.503936>
			}
			triangle {
				< -58.449659, 7.798889, -21.472361>,
				< -48.352528, 13.676140, -0.860943>,
				< -50.841898, 23.688104, -16.503936>
			}
			triangle {
				< -67.213684, 0.736851, -45.659639>,
				< -66.686571, -3.462902, -41.718602>,
				< -58.449659, 7.798889, -21.472361>
			}
			triangle {
				< -66.686571, -3.462902, -41.718602>,
				< -57.431351, -0.314428, -13.858917>,
				< -58.449659, 7.798889, -21.472361>
			}
			triangle {
				< -66.686571, -3.462902, -41.718602>,
				< -66.579446, -7.911620, -39.830890>,
				< -57.431351, -0.314428, -13.858917>
			}
			triangle {
				< -66.579446, -7.911620, -39.830890>,
				< -57.224404, -8.908675, -10.212143>,
				< -57.431351, -0.314428, -13.858917>
			}
			triangle {
				< -66.579446, -7.911620, -39.830890>,
				< -66.899590, -12.306071, -40.125091>,
				< -57.224404, -8.908675, -10.212143>
			}
			triangle {
				< -66.899590, -12.306071, -40.125091>,
				< -57.842903, -17.398119, -10.780463>,
				< -57.224404, -8.908675, -10.212143>
			}
			triangle {
				< -66.899590, -12.306071, -40.125091>,
				< -67.625217, -16.346840, -42.581230>,
				< -57.842903, -17.398119, -10.780463>
			}
			triangle {
				< -67.625217, -16.346840, -42.581230>,
				< -59.244700, -25.204349, -15.525265>,
				< -57.842903, -17.398119, -10.780463>
			}
			triangle {
				< -67.625217, -16.346840, -42.581230>,
				< -68.706855, -19.758480, -47.031812>,
				< -59.244700, -25.204349, -15.525265>
			}
			triangle {
				< -68.706855, -19.758480, -47.031812>,
				< -61.334252, -31.795241, -24.123218>,
				< -59.244700, -25.204349, -15.525265>
			}
			triangle {
				< -68.706855, -19.758480, -47.031812>,
				< -70.070796, -22.308700, -53.173624>,
				< -61.334252, -31.795241, -24.123218>
			}
			triangle {
				< -70.070796, -22.308700, -53.173624>,
				< -63.969165, -36.721595, -35.988256>,
				< -61.334252, -31.795241, -24.123218>
			}
			triangle {
				< -70.070796, -22.308700, -53.173624>,
				< -71.624085, -23.823412, -60.588062>,
				< -63.969165, -36.721595, -35.988256>
			}
			triangle {
				< -71.624085, -23.823412, -60.588062>,
				< -66.969901, -39.647859, -50.311878>,
				< -63.969165, -36.721595, -35.988256>
			}
			triangle {
				< -71.624085, -23.823412, -60.588062>,
				< -73.260866, -24.199540, -68.769887>,
				< -66.969901, -39.647859, -50.311878>
			}
			triangle {
				< -73.260866, -24.199540, -68.769887>,
				< -70.131935, -40.374540, -66.117935>,
				< -66.969901, -39.647859, -50.311878>
			}
			triangle {
				< -73.260866, -24.199540, -68.769887>,
				< -74.869640, -23.411468, -77.161491>,
				< -70.131935, -40.374540, -66.117935>
			}
			triangle {
				< -74.869640, -23.411468, -77.161491>,
				< -73.239788, -38.852062, -82.329370>,
				< -70.131935, -40.374540, -66.117935>
			}
			triangle {
				< -74.869640, -23.411468, -77.161491>,
				< -76.340668, -21.512842, -85.191011>,
				< -73.239788, -38.852062, -82.329370>
			}
			triangle {
				< -76.340668, -21.512842, -85.191011>,
				< -76.081656, -35.184249, -97.841188>,
				< -73.239788, -38.852062, -82.329370>
			}
			triangle {
				< -76.340668, -21.512842, -85.191011>,
				< -77.573813, -18.633101, -92.311315>,
				< -76.081656, -35.184249, -97.841188>
			}
			triangle {
				< -77.573813, -18.633101, -92.311315>,
				< -78.463905, -29.620983, -111.596443>,
				< -76.081656, -35.184249, -97.841188>
			}
			triangle {
				< -77.573813, -18.633101, -92.311315>,
				< -78.485005, -14.968460, -98.037049>,
				< -78.463905, -29.620983, -111.596443>
			}
			triangle {
				< -78.485005, -14.968460, -98.037049>,
				< -80.224156, -22.541489, -122.657761>,
				< -78.463905, -29.620983, -111.596443>
			}
			triangle {
				< -78.485005, -14.968460, -98.037049>,
				< -79.012103, -10.768728, -101.978064>,
				< -80.224156, -22.541489, -122.657761>
			}
			triangle {
				< -79.012103, -10.768728, -101.978064>,
				< -81.242539, -14.428173, -130.271181>,
				< -80.224156, -22.541489, -122.657761>
			}
			triangle {
				< -79.012103, -10.768728, -101.978064>,
				< -79.119243, -6.319991, -103.865884>,
				< -81.242539, -14.428173, -130.271181>
			}
			triangle {
				< -79.119243, -6.319991, -103.865884>,
				< -81.449382, -5.833906, -133.918002>,
				< -81.242539, -14.428173, -130.271181>
			}
			triangle {
				< -79.119243, -6.319991, -103.865884>,
				< -78.799084, -1.925497, -103.571638>,
				< -81.449382, -5.833906, -133.918002>
			}
			triangle {
				< -78.799084, -1.925497, -103.571638>,
				< -80.830932, 2.655559, -133.349553>,
				< -81.449382, -5.833906, -133.918002>
			}
			triangle {
				< -78.799084, -1.925497, -103.571638>,
				< -78.073457, 2.115271, -101.115458>,
				< -80.830932, 2.655559, -133.349553>
			}
			triangle {
				< -78.073457, 2.115271, -101.115458>,
				< -79.429142, 10.461694, -128.604859>,
				< -80.830932, 2.655559, -133.349553>
			}
			triangle {
				< -78.073457, 2.115271, -101.115458>,
				< -76.991819, 5.526995, -96.664958>,
				< -79.429142, 10.461694, -128.604859>
			}
			triangle {
				< -76.991819, 5.526995, -96.664958>,
				< -77.339552, 17.052554, -120.006926>,
				< -79.429142, 10.461694, -128.604859>
			}
			triangle {
				< -76.991819, 5.526995, -96.664958>,
				< -75.627893, 8.077024, -90.523086>,
				< -77.339552, 17.052554, -120.006926>
			}
			triangle {
				< -75.627893, 8.077024, -90.523086>,
				< -74.704647, 21.979041, -108.141929>,
				< -77.339552, 17.052554, -120.006926>
			}
			triangle {
				< -75.627893, 8.077024, -90.523086>,
				< -74.074611, 9.591780, -83.108701>,
				< -74.704647, 21.979041, -108.141929>
			}
			triangle {
				< -74.074611, 9.591780, -83.108701>,
				< -71.703926, 24.905240, -93.818262>,
				< -74.704647, 21.979041, -108.141929>
			}
			triangle {
				< -74.074611, 9.591780, -83.108701>,
				< -72.437815, 9.967906, -74.926801>,
				< -71.703926, 24.905240, -93.818262>
			}
			triangle {
				< -72.437815, 9.967906, -74.926801>,
				< -68.541877, 25.631893, -78.012168>,
				< -71.703926, 24.905240, -93.818262>
			}
			triangle {
				< -72.437815, 9.967906, -74.926801>,
				< -70.829056, 9.179835, -66.535160>,
				< -68.541877, 25.631893, -78.012168>
			}
			triangle {
				< -70.829056, 9.179835, -66.535160>,
				< -65.434039, 24.109447, -61.800856>,
				< -68.541877, 25.631893, -78.012168>
			}
			triangle {
				< -70.829056, 9.179835, -66.535160>,
				< -69.357999, 7.281273, -58.505628>,
				< -65.434039, 24.109447, -61.800856>
			}
			triangle {
				< -69.357999, 7.281273, -58.505628>,
				< -62.592134, 20.441648, -46.288937>,
				< -65.434039, 24.109447, -61.800856>
			}
			triangle {
				< -69.357999, 7.281273, -58.505628>,
				< -68.124861, 4.401534, -51.385436>,
				< -62.592134, 20.441648, -46.288937>
			}
			triangle {
				< -68.124861, 4.401534, -51.38543