#declare View_POV_Include_Stack = 1
// ==== Standard POV-Ray Includes ====
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "woods.inc"

// ----------------------------------------
// Control Variables

//#declare Quick = 1
//#declare VeryQuick = 1


#declare IncludeWizard = 1
#declare IncludeCandles = 1
#declare IncludePentagram = 1
#declare IncludeDemon = 1
#declare IncludeFirePit = 1
#declare IncludeWalls = 1
#declare IncludeWallHanging = 1
#declare IncludeBook = 1
#declare IncludeFloor = 1
#declare IncludeScrapPaper = 1

#declare IncludeCandleLight = 1
#declare IncludeFireLight = 1
#declare IncludeBookLight = 1

//#declare Floodlighting = 1

#declare Camera=1

#declare FinalCamera=1
//#declare PlanView=1

#ifdef(FinalCamera)
#declare CameraPos = < 4.000, 1.3,-10.00>
#declare LookatPos = <-0.000, 0.1,-2.00>
#else
#ifdef(PlanView)
#declare CameraPos = < 0.000, 20.0,-0.00>
#declare LookatPos = <-0.000, 0.0,-0.00>
#else
#declare CameraPos = < 4.000, 1.3,-10.00>
#declare LookatPos = <-0.000, 0.1,-2.00>
#end
#end

// ----------------------------------------
// Camera and independant lighting

camera
{
  location CameraPos
	look_at  LookatPos
  angle 45
#ifdef(PlanView)
  orthographic
#end
}

#ifdef(Floodlighting)
light_source { <-10, 20, -10> color White }
light_source { < 10, 20, -10> color White }
#end

#ifdef (PlanView)
  sphere { CameraPos, 0.1 pigment { Red } }
#end

// ----------------------------------------
// Textures

#declare FloorStone = texture {
      pigment { color Gray }
      #ifndef(Quick)
        normal { granite 0.1 }
      #end
}
#declare Flagstones = texture
{
  pigment { Gray50 }
  #ifndef(Quick)
     normal { granite 0.1 }
  #end
}
#declare Grout = texture
{
  pigment { Gray75 }
  #ifndef(Quick)
     normal { bumps 0.2 }
  #end
}
#declare EntranceStone =
texture
{
  brick
  texture { Grout }
  texture { Flagstones }
  scale 0.075
}

#ifdef(Quick)
#declare WoodenPillar = texture { pigment { Brown } }
#declare WallPaper = texture { pigment { colour rgb <1.0,239/255,206/255> } }
#else
#declare WoodenPillar = texture { T_Wood1 rotate x*90 }
#declare WallPaper = texture {
  pigment {
    bozo
    colour_map {
      [1.0 colour rgb <1.0,239/255,206/255>]
      [0.5 colour rgb <1.0,247/255,206/255>]
      [0.0 colour rgb <1.0,239/255,198/255>]
    }
    scale 3.0
  }
  normal { bumps 0.1 scale 1.0}
}
#end


// ----------------------------------------
// A magic book on the floor

#ifdef(IncludeBook)
#include "BookPage.inc"

object
{
  WholeBook
  scale <0.25,0.25,0.35>
  rotate y*140
  translate y*-1.15
  translate z*-2.5
  translate x*2
}
#end

// ----------------------------------------
// Walls of the dungeon

#ifdef(IncludeWallHanging)
#declare WallHanging =
union
{
  // A pole to hang it from
  cylinder {
    <-0.2,1.09,0> <1.2,1.09,0> 0.04
#ifndef(Quick)
    texture { T_Wood1 rotate x*2 rotate y*90 }
#else
    texture { pigment { Brown } }
#end
  }
  union
  {
    box
    {
      // A thin wall hanging
      <-0.05,-0.05,0.005> <1.05,1.05,-0.005>
    }
    // A loop around the pole
    cylinder { <-0.05,1.09,0> <1.05,1.09,0> 0.05 }

    texture
    {
      pigment { color RichBlue }    //<1.0,1.0,204/244> }
#ifndef(Quick)
      normal { bumps 0.5 scale 0.25}
      finish { Shiny }
#end
    }
#ifndef(Quick)
    texture
    {
      pigment
      {
        image_map
        {
          gif "d:\images\calend.gif"
          once
        }
      }
      normal { bumps 0.5 scale 0.2}
    }
#end
  }

  translate <-0.5, -0.5, 0.0>
}

object {
  WallHanging
  scale 3.0
  rotate y*-90
  translate <0.1,1.5,2.0>
  rotate y*30
  translate x*-6.3
}
#end

#ifdef(IncludeWalls)

#declare RoomRadius  = 7.0
#declare RoomHeight = 5.5

#declare StepHeight = 0.5
#declare StepDepth = 1.5
#declare EntranceHeight = 4.0
#declare EntranceRadius = 1.2
#declare SurroundWidth = 0.3
#declare ArchHeight = EntranceHeight / 3
#declare NumberOfSteps = EntranceHeight / StepHeight
#declare EntranceDepth = NumberOfSteps * StepDepth

#declare VanillaWallSection =
union
{
  // Supporting pillar
  box
  {
    <-0.4,0,-0.4> <0.4,RoomHeight,0.4>
    texture { WoodenPillar }
  }
  // Skirting board
  box
  {
    <0.1,0,0> <-0.1,0.2,RoomRadius>
    texture { T_Wood1 rotate x*-2 /*rotate y*90*/ }
    rotate y*30
  }
  // Wall itself (made deep so entrance can be carved in it)
  box
  {
    <0,0,0> <-(EntranceDepth+0.1),RoomHeight,RoomRadius>
    texture { WallPaper }
    rotate y*30
  }
  translate x*-RoomRadius
}

#declare Entrance =
difference
{
union
{
  // The hallway
  box
  {
    <-EntranceRadius,0,0>
    <EntranceRadius,EntranceHeight-ArchHeight,EntranceDepth>
  }
  cylinder
  {
    <0,EntranceHeight-ArchHeight,0>
    <0,EntranceHeight-ArchHeight,EntranceDepth>
    EntranceRadius
  }
}
union
{
  // The steps
  #while (NumberOfSteps>0)
    box
    {
      <-EntranceRadius-0.1,NumberOfSteps * StepHeight,NumberOfSteps * StepDepth>
      < EntranceRadius+0.1,(NumberOfSteps - 1) * StepHeight - 0.1,EntranceDepth-0.1>
    }
    #declare NumberOfSteps=NumberOfSteps - 1
  #end
}
}

#declare EntranceSurround =
union
{
  box
  {
    <-EntranceRadius-SurroundWidth,0,-0.001>
    <EntranceRadius+SurroundWidth,EntranceHeight-ArchHeight-0.01,EntranceDepth>
    texture {
      gradient y
      texture_map {
          [0.9 Flagstones]
          [0.9 Grout ]
      }
    }
  }
  cylinder
  {
    <0,EntranceHeight-ArchHeight,0>
    <0,EntranceHeight-ArchHeight,EntranceDepth>
    EntranceRadius+SurroundWidth
    texture {
      radial
      frequency 12
      texture_map {
          [0.05 Grout ]
          [0.05 Flagstones]
          [0.95 Flagstones]
          [0.95 Grout ]
      }
      rotate x*90
      translate <0,EntranceHeight-ArchHeight,0>
    }
  }
}

#declare HexagonRoom =
union
{
  object { VanillaWallSection }


  // This wall has a door in it.
  difference
  {
    union
    {
      object { VanillaWallSection rotate y*60  }
      object {
        EntranceSurround
        translate z*(sqrt( 0.75*RoomRadius*RoomRadius )-0.145)
      }
    }
    object {
      Entrance
      texture { EntranceStone translate z*0.2}
      translate z*(sqrt( 0.75*RoomRadius*RoomRadius )-0.15)
    }
  }
  object { VanillaWallSection rotate y*120 }

// These two walls obstruct the camera
//  object { VanillaWallSection rotate y*180 }
//  object { VanillaWallSection rotate y*240 }

  object { VanillaWallSection rotate y*300 }
}

object
{
  HexagonRoom
  translate y*-1.21
  translate -z
}

#else
background { color rgb <1.0,239/255,206/255> }
#end // IncludeWalls

// ----------------------------------------
// The Wizard Figure.  Maybe give him a different habit
// Meg tells me this one is Franciscan.

// Declare this in case the appropriate include isn't loaded
// during debugging

#declare _face = texture {pigment {color Flesh}}

#ifdef(IncludeWizard)

#include "WizardPatch.inc"

#ifndef(Quick)
#include "beethead.inc"
#include "hand.inc"

#declare EldritchGlow = sphere { 0, 1
  pigment { color rgbt <1,1,1,1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence 0.85
    color_map {
      [ 0.0 color rgbt <0, 0, 2,  1.00> ]
//      [ 0.5 color rgbt <0, 0, 2,  0.35> ]
      [ 1.0 color rgbt <0, 2, 2, -1.00> ]
    }
    samples 10
    scale 0.5
  }
  hollow
  scale 1.5
}

#declare RightHandPower = /*union {*/
  object
  {
    EldritchGlow
    scale <0.30,1.0,0.1>
//    clipped_by { plane { -y, 0.01 hollow } }
  }
/*  object
  {
    EldritchGlow
    scale <0.20,0.40,0.1>
    clipped_by { plane { y, -0.01 hollow } }
  }
}
*/

#declare RopeKnot = union
{
  torus { 0.048, 0.024 rotate z*45 }
  torus { 0.048, 0.024 rotate z*-45 }
  rotate y*-56
}

#declare RopeTassel = union
{
  cylinder { 0, -y, 0.024 }
  torus { 0.030, 0.02 translate -y }
  cone {
    0.0,   0.024,
   -0.2*y, 0.034
    translate -y
  }
  rotate x*16
  rotate y*-56
}

#declare WizardsRope = union {
  torus {
    0.21, 0.024
    scale <1.0,1.0,0.75>
  }
  object { RopeKnot translate <0.15, 0.00,-0.10> }
  object { RopeTassel translate <0.175 0.00,-0.095> }
  object { RopeTassel translate <0.145, 0.00,-0.125> }
  texture
  {
    pigment { color <0.5, 0.5, 0.4> }
    finish { ambient 0.4 diffuse 0.9 }
  }
}

#declare FullWizard = union
{
  // The wizard's robe
  object
  {
    WizardRobe
    texture { _WizardsRobe }
    translate < 0.000, 0.140, 0.000>
  }

  // The wizard's face
  object {
    BeetHead
    rotate y*-45

    scale <0.4,0.5,0.4>
    translate y*0.8
    translate x*-0.02
    translate z*0.02
  }
  //the wizards neck
  cylinder
  {
    <0,-0.2,0>
    <0,0.25,0>
    0.075
    scale <1.1,0.4,1>

    texture { _face }

    translate y*0.8
    translate x*-0.02
    translate z*0.0425
  }
  // The wizards left hand
  object
  {
    LeftHand
    rotate z*10
    scale 0.175
    translate y*0.9
    translate x*0.95

    texture { _face }
  }
  // The wizards right hand
  object
  {
    RightHand
    rotate z*-10
    scale 0.175
    translate y*0.9
    translate x*-1.05

    texture { _face }
  }
  object
  {
    WizardsRope
    translate <-0.025, 0.140, 0.000>
  }

  // Fiery glow of power in each hand
  object
  {
    RightHandPower
    translate <-1.15,0.9,0>
  }
  object
  {
    RightHandPower
    rotate y*160
    translate < 1.05,0.9,0>
  }
}
#end  // Quick

#ifdef (Quick)
object { WizardRobe texture { _WizardsRobe } translate < 0.000, 0.140, 0.000> }
#else
object { FullWizard }
#end

#end  // IncludeWizard


// ----------------------------------------
// Pentagram of protection and candles

#ifdef(IncludePentagram)
#declare PentagramArm =
  box
  {
    <-0.015,0, 0.000>,
    < 0.015,1,-1.900>
    rotate y*18
    translate z
  }


#declare Pentagram = union {
  cylinder { 0, y, 1.03 open }
  cylinder { 0, y, 1.00 open }

  disc     { 0,-y, 1.03, 1.00 }
  disc     { y, y, 1.03, 1.00 }

  object { PentagramArm }
  object { PentagramArm rotate y*72 }
  object { PentagramArm rotate y*144 }
  object { PentagramArm rotate y*216 }
  object { PentagramArm rotate y*288 }
}

object {
  Pentagram
  scale <2.2,0.1,2.2>

#ifdef (Quick)
  pigment { P_Brass4 }
#else
  texture { T_Brass_4B }
#end
  translate y*-1.275
}
#end // IncludePentagram

#ifdef(IncludeCandles)
#include "Candle.inc"
union {
  object { Candle scale 0.05 translate z*2.2 }
  object { Candle scale 0.05 translate z*2.2 rotate y*72 }
  object { Candle scale 0.05 translate z*2.2 rotate y*144}
  object { Candle scale 0.05 translate z*2.2 rotate y*216 }
  object { Candle scale 0.05 translate z*2.2 rotate y*288 }
  translate y*-0.65
}
#end

#ifdef(IncludeCandleLight)

#declare CandleLight = light_source {
  0.1, color White/2
  fade_power 2
  fade_distance 2
  translate z*2.2
  translate y*-0.65
}

object { CandleLight }
object { CandleLight rotate y*72 }
object { CandleLight rotate y*144}
object { CandleLight rotate y*216}
object { CandleLight rotate y*288}

#end

#ifdef(IncludeBookLight)
light_source
{
  0.1, color White
  spotlight
  point_at <0,-0.6,2.0>
  radius 50
  falloff 80
  tightness 5

  translate z*2.2
  translate y*-0.6
  rotate y*144
}
#end

// ----------------------------------------
// Demonic thingy being summoned

#declare DemonPosition = <0.0, -1.2, -5.0>

#ifdef(IncludeDemon)
#ifdef(Quick)
#declare HeroTexture = texture { pigment { color rgbt<0,1,1,0.5> } finish { ambient 0.75 }}
#else
#declare HeroTexture = texture
{
  pigment
  {
    gradient y
    turbulence 1
    color_map
    {
      [0.00 color rgbt<0, 1, 1, 0.98>]
      [1.00 color rgbt<0, 1, 1, 0.4>]
    }
    //scale 2
    translate y*-1
  }
  finish {
    ambient 0.75
  }
}
#end


#ifdef(Quick)
#declare Hero = cylinder {
  // It should extend from +y to -y, +0.524471*x to -0.524471*x and
  // +0.233512*z to -0.233512*z
  -y, +y, 1.0
  scale <0.524471, 1.0, 0.233512>
  texture { HeroTexture }
}
#else
#include "objects\hero.inc"
#end

object
{
  Hero
  scale <1.5,1.0,1.0>
  scale 1.5

  translate DemonPosition
  translate y*2.2
}
#end



// ----------------------------------------
// Firepit, from whence the demon came

#ifdef(IncludeFirePit)
#declare FirePitHole = box {
  <-1.0, 0.1, -0.5>  <1.0, -0.5, 1.5> hollow
}

#declare FirePit = union {
  // The actual pit
  difference
  {
    box {
      <-1.34, 0.1, -0.84>  <1.34, -0.5, 1.84> hollow
      texture {
        brick
        texture { pigment { Gray25 } }
        texture { FloorStone }
        brick_size <0.39,0.39,0.39>
        mortar 0.05
        translate <-1.34,0.0,-1.01>
      }
    }
    object { FirePitHole scale <0.99,1.0,0.99> translate y*0.05 }
    texture { FloorStone }
  }

  #ifndef(Quick)
  // The glowing coals
  height_field
  {
    tga "d:\images\firepitmap.tga"

    #ifdef(Quick)
    texture { pigment { color Yellow } }
    #else
    texture
    {
      pigment {
        crackle
        turbulence 0.5
        colour_map {
            [0.010 colour rgb<0, 0, 0> ] // Black shadows between coals
            [0.015 colour rgb<1, 1, 0> ] // Yellow flames
            [0.020 colour rgb<1, 1, 0> ]
            [0.200 colour rgb<1,.5, 0> ] // Orange to...
            [0.700 colour rgb<1, 0, 0> ]
            [1.000 colour rgb<0.5, 0, 0> ] // ...Red glowing coals
        }
        scale 0.075
      }
      finish { ambient 0.7 }
    }
    #end
    scale     < 2.0, 0.90, 2.0>
    translate <-1.0, -0.75, -0.5>
  }
  // The flames (a boxed-in halo)
  box {
    // Make the typical nice fiery explosion
    <1.0,1.0,1.0> <-1.0,0.0,-1.0> hollow
    pigment { color rgbt < 1,1,1,1> }
    halo
    {
      emitting
      planar_mapping
      linear
      turbulence 1.5
      color_map {
        [0 colour rgbt<1,0,0, 1> ]
        [1 colour rgbt<1,1,0,-1> ]
      }
      samples 10
      scale 0.5
    }
    scale 1.01

    // Now make it sized and placed appropriately
    //scale 2.0
    translate <0.0,-0.20,0.5>
  }
  #end

}
#end

#ifdef(IncludeFireLight)
light_source
{
  0, color rgb <0.8,0.6,0.01>

  fade_power 1
  fade_distance 5

#ifndef(Quick)
  area_light 2*x, 2*z
  7, 7
#end

  //looks_like { sphere { 0,0.05 pigment { Red } finish { ambient 0.5 }} }

  translate <0.0, 0.3, 0.5>
  translate DemonPosition
}
#end

// ----------------------------------------
// Floor, with firebox

#ifdef(IncludeFloor)
union
{
  difference
  {
    plane
    {
      y, -1.2 clipped_by { sphere { 0, 8 } }

      #ifdef(Quick)
      texture { FloorStone }
      #else
      texture {
        crackle
        texture_map
        {
          [0.03 Grout ]
          [0.03 Flagstones ]
        }
        translate y
      }
      #end
    }
#ifdef(IncludeFirePit)
    object { FirePitHole translate DemonPosition }
  }
  object { FirePit translate DemonPosition }
#else
  }
#end
}
#end // IncludeFloor
//object {  AxisBars  translate y*-1.2 }

// ----------------------------------------
// Scattered piece of scrap paper

#ifdef(IncludeScrapPaper)

#ifdef(Quick)
#declare ScrapPaper = box
{
  <-0.5,0,0.5> <0.5,0.125,-0.25>
}
#else
#include "ScrapPaper.inc"
#end

#declare NoOfPiecesOfPaper = 10
#declare PaperRand = seed(11)

#while (NoOfPiecesOfPaper > 0)
  object
  {
    ScrapPaper
    scale 0.5

    // texture
    texture { WallPaper }

    // Random attitude
    rotate <rand(PaperRand) * 360,
            rand(PaperRand) * 360,
            rand(PaperRand) * 360>

    // Position in a random whirlwind around the wizard
    translate z * (rand(PaperRand) * 0.4 + 2.8)
    translate y * rand(PaperRand) * 1.0
    rotate y * rand(PaperRand) * 250

    // Rotate to the rear of the scene
    rotate y*-150

    // Lower into place
    translate y * -1.0
  }

  #declare NoOfPiecesOfPaper = NoOfPiecesOfPaper - 1
#end // while
#end // IncludeScrapPaper
