// Persistence of Vision Ray Tracer Scene Description File
// File: BookPage.inc
// Vers: 3
// Desc: A model of a magic tome
// Date: July 1997
// Auth: Ian Bosley

#ifdef(View_POV_Include_Stack)
#debug "Including BookPage.inc\n"
#end

#declare Flip_XAxis =
transform
{
    matrix <-1, 0, 0,
             0, 1, 0,
             0, 0, 1,
             0, 0, 0 >
}

#declare OneLeaf = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.0000, 2.0000> <0.1500, 0.1500, 2.0000> <0.2908, 0.4651, 2.0000> <0.5000, 0.5000, 2.0000>
		<0.0000, 0.0000, 1.4000> <0.1500, 0.1500, 1.4000> <0.2908, 0.4651, 1.4000> <0.5000, 0.5000, 1.4000>
		<0.0000, 0.0000, 0.6000> <0.1500, 0.1500, 0.6000> <0.2908, 0.4651, 0.6000> <0.5000, 0.5000, 0.6000>
		<0.0000, 0.0000, 0.0000> <0.1500, 0.1500, 0.0000> <0.2908, 0.4651, 0.0000> <0.5000, 0.5000, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.5000, 0.5000, 2.0000> <0.8050, 0.5508, 2.0000> <1.1968, 0.3106, 2.0000> <1.5000, 0.2500, 2.0000>
		<0.5000, 0.5000, 1.4000> <0.8050, 0.5508, 1.4000> <1.1968, 0.3106, 1.4000> <1.5000, 0.2500, 1.4000>
		<0.5000, 0.5000, 0.6000> <0.8050, 0.5508, 0.6000> <1.1968, 0.3106, 0.6000> <1.5000, 0.2500, 0.6000>
		<0.5000, 0.5000, 0.0000> <0.8050, 0.5508, 0.0000> <1.1968, 0.3106, 0.0000> <1.5000, 0.2500, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.5000, 0.2500, 2.0000> <1.9473, 0.1605, 2.0000> <2.5500, 0.0750, 2.0000> <3.0000, 0.0000, 2.0000>
		<1.5000, 0.2500, 1.4000> <1.9473, 0.1605, 1.4000> <2.5500, 0.0750, 1.4000> <3.0000, 0.0000, 1.4000>
		<1.5000, 0.2500, 0.6000> <1.9473, 0.1605, 0.6000> <2.5500, 0.0750, 0.6000> <3.0000, 0.0000, 0.6000>
		<1.5000, 0.2500, 0.0000> <1.9473, 0.1605, 0.0000> <2.5500, 0.0750, 0.0000> <3.0000, 0.0000, 0.0000>
	}
}

#declare HalfBook = union {
  // Flat pages
  box {
    <0,0,0>
    <3.3,-0.05,2.0>
    
    pigment { colour rgb <1.0,239/255,206/255> }
  }
  // Cover 
  box {
    <0.0,-0.05,-0.10>
    <3.4,-0.10, 2.1>
    //  Maroon  
    pigment { color red 0.556863 green 0.137255 blue 0.419608 }
  }
}

#declare WholeBook = union {
  object { HalfBook }
#ifndef(Quick)
  union 
  {
    // Open curved pages
    object { OneLeaf }
    object { OneLeaf scale <1.09,0.75,1.0> }
    object { OneLeaf scale <1.09,0.625,1.0> }
    object { OneLeaf scale <1.09,0.5625,1.0> }
    object { OneLeaf scale <1.09,0.5,1.0> }
    object { OneLeaf scale <1.09,0.4,1.0> }
    object { OneLeaf scale <1.09,0.3,1.0> }
    
    pigment {
      image_map {
        gif "d:\images\kell4bmp.gif"
        once
      }
      scale <3.3,2,1.0>
      rotate x*90
    }
  }
#end  
  
  object {
    HalfBook  // Flip the halves to make a whole
    transform Flip_XAxis 
  }
#ifndef(Quick)    
  union 
  {
    // Open curved pages
    object { OneLeaf }
    object { OneLeaf scale <1.09,0.75,1.0> }
    object { OneLeaf scale <1.09,0.625,1.0> }
    object { OneLeaf scale <1.09,0.5625,1.0> }
    object { OneLeaf scale <1.09,0.5,1.0> }
    object { OneLeaf scale <1.09,0.4,1.0> }
    object { OneLeaf scale <1.09,0.3,1.0> }
    
    transform Flip_XAxis 
    pigment {
      image_map {
        gif "d:\images\kell3bmp.gif"
        once
      }
      scale <3.3,2,1.0>
      rotate x*90
      translate x*-3.3
    }
  }
#end

 //Just in case pigment 
  pigment { colour rgb <1.0,239/255,206/255> }
}

#ifndef(Camera)
#declare Camera = 1

background { color rgb <0, 0.3, 0.5> }

camera {
	location <0.00, 4.50, -2.64>
	look_at <0.00, 0.25, 1.00>
}

light_source { < 0, 10, 20 > color rgb <1, 1, 1> }
light_source { < 20, 10, 0 > color rgb <1, 1, 1> }
light_source { < -20, 10, 20 > color rgb <1, 1, 1> }

object { WholeBook }
#end

