#include <stdio.h>
#include <math.h>

int main (void) {
  FILE *f;
  double theta = -M_PI/2, phi = 0, h, d, a, tmp1, tmp2;
  double x, y, z;
  int    i, j;

  f = fopen ("x.inc", "w");
  fprintf (f, "#declare Curl =\nunion {\n");
  for (i = 0; i < 6000; i++) {
    x = cos(phi)*cos(theta)*4;
    y = sin(theta)*4;
    z = sin(phi)*cos(theta)*4;
    fprintf (f, "  sphere { <%f, %f, %f>, 0.64\n", x, y, z);

/*    fprintf (f, "    translate (1-clock)*%f*y\n", h);*/
    fprintf (f, "    translate 10.1859163579*x\n");
    fprintf (f, "    rotate %f*z\n}\n", i*360.0/6000);

    h = 32.0*(i/3000.0 - 1);
    a = 2*M_PI*(1 - i/6000.0);
    tmp1 = (cos(a)+1) * 10.1859163579;
    tmp2 = sin(a) * 10.1859163579;
    d = sqrt (tmp1*tmp1 + tmp2*tmp2);
    a = 180 * atan2 (tmp2, tmp1) / M_PI;
    if (h < 0) {
      d = -d;
      a = -90 - a;
    }
    else
      a = 90 - a;
/*    fprintf (f, "    translate %f*y\n", d);
    fprintf (f, "    rotate %f*z\n  }\n", a);*/
    theta += 32*M_PI/6000;
    phi -= 4*M_PI/6000; 
  }
  fprintf (f, "  translate 10.1859163579*x\n}\n");
  fclose (f);
  return;
}
