
#include "colors.inc"
#include "glass.inc"
 camera {
    location <0, 3.5, -5.5>
        look_at <0, 0, 0>
  }


// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <0, 10, -6> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 200               // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 20               // intensity falloff radius (outer, in degrees)
}

sphere { <0, 0.5, 0>, 1
   pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      cubic
      color_map {
        [ 0 color rgbt <1, 1, 1, 0.7> ]
        [ 1 color rgbt <1, 1, 1, 0.5> ]
      }
      samples 10
    }
    hollow

// Move object or texture relative to current position
// example: translate -5.0*z
translate <0, 1.0, 0>  // <dX dY dZ>

   }


// create a sphere shape
sphere
{
  <0, 0.5, 0> // center of sphere <X Y Z>
  0.5       // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling
texture { T_Glass2 }
hollow

// Move object or texture relative to current position
// example: translate -5.0*z
translate <0, 1.0, 0>  // <dX dY dZ>
finish { phong 1 phong_size 50 reflection .35 }
}

blob {
    threshold .65

     sphere { <-.19,-.1,0>,.43, 1 scale <1.95,1.05,.5> }   //links oben
    sphere { <0.2,-.1,0>,.43, 1 scale <1.95,1.05,.5> } //versetzen
     sphere { <-.13,-.33,0>,.43, 1 scale <1.95,1.05,.5> } //links mitte 
    sphere { <0.1,-.33,0>,.43, 1 scale <1.95,1.05,.5> } //rechts mitte
    sphere { <-0.1,-.9,0.05>,.43, 1 scale <1.1, 0.9,.6> } //mitte
 
        sphere { <-0.3, 0.55, 0>,.43, 1 scale <3,1.5,.8> rotate <0, 0, 100> } // nicht verndern
        sphere { <-0.19, -0.4, -0.25>,.43, 1 scale <4.2,2.5,.8> rotate <0, 10, 50>}
        sphere { <0.3,-.9,0.05>,.43, 1 scale <1.3, 0.9,.6> }
        sphere { <0.6,-0.87,0>,.43, 1 scale <1,0.6,.5> }
        sphere { <0.6,-0.8,1>,2, 1 scale <0.7,1,.2> rotate <0, 0, -20> }
         
    cylinder { <0.7,-.9,-0.07>, <1.1,-0.3,-.4>, .3, 1 } //daumen
    sphere { <1.1,-0.3,-.4>, 0.3, -1 }
    cylinder { <1.1,-0.3,-.4>, <1.05,0,-.55>, .3, 1 }

    cylinder { <0.6,-0.1,0.07>, <0.8,0.4,-.07>, .28, 1 }   //zeigefinger
   
    cylinder { <0.8,0.4,-0.07>, <0.8,0.55,-.3>, .28, 1 }   
   sphere { <0.8,0.4,-0.07>, 0.27, -1 }
    cylinder { <0.8,0.55,-.3>, <0.8,0.55,-.5>, .28, 1 }   
    sphere { <0.8,0.55,-.3>, 0.27, -1 }
    
    
    cylinder { <0.2,-0.1,0.07>, <0.26,0.65,-.01>, .4, 1 }  //mittelfinger
    cylinder { <0.26,0.65,-.01>, <0.26,0.85,-.45>, .28, 1 }
    sphere { <0.26,0.65,-.01>, 0.29, -1 }
    cylinder { <0.26,0.85,-.45>, <0.26,0.85,-.65>, .28, 1 }
    sphere { <0.26,0.85,-.45>, 0.27, -1 }

    cylinder { <-0.15,-0.1,0.02>, <-0.35,0.55,-.07>, .32, 1 }   //ringfinger
  
    cylinder { <-0.35,0.55,-.07>, <-0.35,0.7,-.3>, .28, 1 }   
   sphere { <-0.35,0.55,-.07>, 0.27, -1 }
    cylinder { <-0.35,0.7,-.3>, <-0.35,0.73,-.5>, .28, 1 }   
    sphere { <-0.35,0.7,-.3>, 0.27, -1 }
    
    cylinder { <-0.6,-0.15,-0.1>, <-0.8,0.4,-.13>, .32, 1 }   //kleiner finger
    cylinder { <-0.8,0.4,-.13>, <-0.8,0.45,-.35>, .28, 1 } 
    sphere { <-0.8,0.4,-.13>, 0.27, -1 }
    cylinder { <-0.8,0.45,-.35>, <-0.8,0.38,-.55>, .28, 1 }
    sphere { <-0.8,0.45,-.35>, 0.27, -1 }
    
    
    pigment { Flesh }
  
// Move object or texture relative to current position
// example: translate -5.0*z
translate <0, 0, 0>  // <dX dY dZ>

// rotate shape or texture around <0 0 0>, relative to current orientation
// example: rotate 30*x
rotate <60, 80, -35> // <dX  dY  dZ> (in degrees)
  }


// Capped Cylinder, closed [or open ended]
// cylinder { <END1>, <END2>, RADIUS [open] }
//  END1 = coord of one end of cylinder
//  END2 = coord of other end
// RADIUS = size of cylinder
// open = if present, cylinder is hollow, else capped
cylinder 
{
  <0, 1, 0>,  3*x,  1
open
texture {
pigment { color Blue
}
normal { 
waves 0.01
}
}

// Move object or texture relative to current position
// example: translate -5.0*z
translate <-4.9,-0.5, 0>  // <dX dY dZ>

}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -4.0 // distance from the origin in the direction of the surface normal
texture {
pigment {

// texture pigment/normal pattern
granite // create a granite-like texture
// color_map {...} // optional color map
}
}
}




