#include "shapes.inc"
#include "colors.inc"
#include "arena.inc"
#include "mage1.inc"
#include "spect.pov"
#include "metals.inc"
#include "stones.inc"
#include "woods.inc"
#include "victim2.inc"



global_settings {
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//camera {  //  Boff
//  location  <0, 6, 10>
//  look_at   <0, 6, 20> }

//camera { // top
//  location < 1.5, 4, -1>
//  look_at <1.5, 0, -1> }

//camera { // top mage
//  location <-3.9, 10, -2.3>
//  look_at <-3.9, 0, -2.3> }

//camera { // adv
//  location < 5, 2, -10 >
//  look_at < 5, 2, 10 > }

camera { //final
  location < -9.5, 7.7, -18.7>
  sky <0,1,0>
  up <0,1,0>
  right <1.33333, 0,0>
  look_at <-1, 3, 0> }

//camera { // top rail
//  location <-9.5, 9, -18>
//  look_at <-9.5, 0, -18> }

//camera { // torch
//  location < -9, 2, 6>
//  look_at < -9, 2, 9> }




// ******** SKY

background { Black }


plane { y, 500
  hollow
  texture { cloudes scale 1000 }
  no_shadow
}


sky_sphere { // adapted from starfield.inc, shipped with POV
        pigment {
        granite
        color_map {
            [ 0.000  0.280 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.280  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.470  0.474 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
            [ 0.474  0.690 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.690  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.880  0.884 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
            [ 0.884  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]

        }
    turbulence 1
    sine_wave
    scale .5
       }
}


plane { // plane
  y,0
  hollow
  texture { t1 }
}


box { // Tatami
  <-1, -1, -1>, <1, 1, 1>
  texture { t3 }
  scale <8.5, .3, 8.5>
  translate  -.28*y
}


box { // tatami_right
  <-1, -1, -1>, <1, 1, 1>
  texture { t2 }
  scale <1, .3, 10>
  translate  <9, -.29, 0>
}


box { // tatami_left
  <-1, -1, -1>, <1, 1, 1>
  texture { t2 }
  scale <1, .3, 10>
  translate  <-9, -.29, 0>
}


box { // Tatami_back
  <-1, -1, -1>, <1, 1, 1>
  texture { t2 }
  scale <10, .3, 1>
  translate  <0, -.29, 9>
}


box { // Tatami_front
  <-1, -1, -1>, <1, 1, 1>
  texture { t2 }
  scale <10, .3, 1>
  translate  <0, -.29, -9>
}


// Carpet
box {
  <-1, 0, -1>, <1, 1, 1>
  pigment { Firebrick } normal { bumps .5 frequency 7 scale .6  } finish { ambient .5 diffuse .4 crand .1 }
  scale <1.2, .001, 15>
  translate <0, 0, 26>
}


// *******Walls

#declare Wall =
  box { <-1, -1, -1>, <1, 1, 1>
  rotate 90*x
  scale <20, 3, 1.3>
  }

difference {
  object { Wall texture { wall_col } scale <1, 1, 5> translate <0, 3, 25> }
  cylinder { <0, -1, 0>, <0, 1, 0>, 1
    texture { wall_col }
    scale <3, 8, 5>
    rotate -90*x
    translate <0, 0, 24>
  }
}


object { Wall texture { wall_col } rotate 90*y translate <20, 3, 0> }
object { Wall texture { wall_col } rotate -90*y translate <-20, 3, 0> }
object { Wall texture { wall_col } translate <0, 3, -20> }



// ** gate
difference {
  cylinder {
    <0, -1, 0>, <0, 1, 0>, 1
  }

  cylinder {
    <0, -1.001, 0>, <0, 1.001, 0>, .85
  }

scale <3.5, 1, 5.5>
rotate -90*x
translate <0, 0, 19>
texture { T_Grnt1 scale 1.3 }
}



// grid

torus { .85, .05
  scale <3.5, 1, 5.5>
  rotate 90*x
  translate 19*z
  texture { T_Silver_1A }
}


#declare counter = -2.25

#while ( counter<3 )
  cylinder { <0, .3, 0>, <0, 5, 0>, .05
      texture { T_Silver_1A }
      translate <counter, 0, 19.2>
  }
  #declare counter = counter + .75
#end

cylinder { <0, .3, 0>, <0, 5, 0>, .05
    texture { T_Silver_1A }
    translate <-.1, 0, 19.2>
}

cylinder {
  <-3, 1.5, 19.2>, <3, 1.5, 19.2>, .05
    texture { T_Silver_1A }
}

cylinder {
  <-3, 3, 19.2>, <3, 3, 19.2>, .05
    texture { T_Silver_1A }
}

difference {
  box {
    <0, 0, 0>, <.5, .5, .1>
    translate <.025, 1.525, 19.15>
  }

  cylinder {
    <0, 0, 0>, <0, 0, .5>, .07
    translate <.275, 1.85, 19.14>
  }

  box {
    <0, 0, 0>, <.05, .12, .5>
    translate <.25, 1.66, 19.14>
  }
  texture { T_Silver_1A }
}


// rear wall

box { <0, 0, 0>, <1, 1, 1>
  pigment { Black }
  scale <10, 3, 1>
  translate <-5, 0, 32>
}


// *********Seats

#declare Spects =  object { bl translate <-5, 1.35, 1> }



#declare Ring = union {
  cylinder {
    <0, 0, 0>, <0, 1, 0>, 1
    scale <.03, .2, .03>
    translate <0, 1, 0>
  }

  torus { .1, .02
    rotate <90, 90, 0>
    scale <2.5, 1, 1>
    translate <0, 1.3, 0>
  }

  cylinder {
    <0, 0, 0>, <0, 1, 0>, 1
    scale <.085, .015, .085>
    translate <0, 1, 0>
  }
scale <.5, 1, 1>
texture { T_Copper_3A }
}

#declare Rail = union {
  cylinder {
    <0, -1, 0>, <0, 1, 0>, 1
    texture { T_Silver_2C }
    rotate 90*z
    scale <9.5, .09, .09>
    translate 1.3*y
  }

  sphere {
    <0, 0, 0>, 1
    texture { T_Brass_4D }
    scale .15
    translate <-9.5, 1.3, 0>
  }

  sphere {
    <0, 0, 0>, 1
    texture { T_Brass_4D }
    scale <.075, .15, .15>
    translate <9.5, 1.3, 0>
  }
}


#declare Rail_ent = union {
  object { Ring translate -9*x }
  object { Ring translate -4.5*x }
  object { Ring }
  object { Ring translate 4.5*x }
  object { Ring translate 9*x }
  object { Rail }
}

#declare Rail_ent2 = union {
  object { Ring translate -9*x }
  object { Ring translate -4.5*x }
  object { Ring }
  object { Ring translate 4.5*x }
  object { Ring translate 9*x }
}


#declare Seats = union {
  box { //bench1
    <-1, -1, -1>, <1, 1, 1>
    texture { T_Wood10 }
    scale <10, .05, 1>
    translate <0, 1, 3>
  }

  box { //front2
    <-1, -1, -1>, <1, 1, 1>
    scale <10, 1.5, .1>
    translate <0, 1.5, 4>
  }

  box { //floor
    <-1, -1, -1>, <1, 1, 1>
    texture { T_Wood1 }
    scale <15, .05, 2.5>
    translate <0, 0, 2.5>
  }

  box { // corner
    <-1, -1, -1>, <1, 1, 1>
    pigment { Yellow }
    scale <3, 1, .01>
    translate <13, -1, .01 >
  }

  box { // corner
    <-1, -1, -1>, <1, 1, 1>
    pigment { Yellow }
    scale <3, 1, .01>
    translate <-13, -1, .01 >
  }

}

#declare Seat_rows = union {
  box { //front
    <-1, -1, -1>, <1, 1, 1>
    texture { T_Wood1 rotate 90*y }
    scale <10, .5, .1>
    translate <0, .5, 0>
  }

  object { Seats texture { T_Wood1 scale .6*y rotate 90*y } }
  object { Seats translate <0, 2, 4> texture { T_Wood1 scale .6 rotate 90*y translate 1*x } }
  object { Seats translate <0, 4, 8> texture { T_Wood1 scale .6*y rotate 90*y translate -1*x } }
  object { Rail_ent }
  object { Rail_ent translate <0, 2, 4> }
  object {Rail_ent translate <0, 4, 8> }
}

#declare Seat_rows2 = union {
  box { //front
    <-1, -1, -1>, <1, 1, 1>
    texture { T_Wood1 rotate 90*y }
    scale <10, .5, .1>
    translate <0, .5, 0>
  }

  object { Seats texture { T_Wood1 scale .6*y rotate 90*y } }
  object { Seats translate <0, 2, 4> texture { T_Wood1 scale .6 rotate 90*y translate 1*x } }
  object { Seats translate <0, 4, 8> texture { T_Wood1 scale .6*y rotate 90*y translate -1*x } }
  object { Rail_ent2 }
  object { Rail_ent2 translate <0, 2, 4> }
  object {Rail_ent2 translate <0, 4, 8> }
}


object { Seat_rows scale <1.9, .8, .8> translate <0, 6, 18> }
object { Seat_rows scale <1.9, .8, .8> rotate 90*y translate <18, 6, 0> }
object { Seat_rows scale <1.9, .8, .8> rotate -90*y translate <-18, 6, 0> }
object { Seat_rows2 scale <1.9, .8, .8> rotate 180*y translate <0, 6, -18> }




#declare R1 = seed(0)
#declare R2 = seed(1)
#declare R3 = seed(2)
#declare R4 = seed(3)


#declare gear =    normal {
     wrinkles 1.0000
     turbulence 0.600
     omega 2.000
     lambda 0.500
   }


//Rear
//Row1
object { Spects scale .55 translate <5, 6.3, 18.8> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 translate <7.5, 6.3, 18.8> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 translate <12, 6.3, 18.8> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 translate <-1, 6.3, 18.8> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2}}
object { Spects scale .55 translate <-7, 6.3, 18.8> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 translate <-14, 6.3, 18.8> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2}}
object { Spects scale .55 translate <-11.5, 6.3, 18.8> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2} }


//Row2
object { Spects scale .55 translate <-5, 7.9, 22> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2}  }
object { Spects scale .55 translate <-14, 7.9, 22> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 translate <-12, 7.9, 22> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 translate <.5, 7.9, 22> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 translate <2.5, 7.9, 22> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2} }
//object { Spects scale .55 translate <5, 7.9, 22> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2} }


//Row3
//object { Spects scale .55 translate <9, 9.5, 25.2> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 translate <-3, 9.5, 25.2> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 translate <-6, 9.5, 25.2> pigment { color rgb <rand(R2), rand (R2), rand(R2)> } normal { gear } finish { ambient .2 diffuse .2} }


//Right
//Row1
object { Spects scale .55 rotate 90*y translate <18.8, 6.3, 5> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate 90*y translate <18.8, 6.3, 7> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate 90*y translate <18.8, 6.3, 13> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate 90*y translate <18.8, 6.3, 2.5> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate 90*y translate <18.8, 6.3, -3> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate 90*y translate <18.8, 6.3, -10> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate 90*y translate <18.8, 6.3, -12> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }


//Row2
object { Spects scale .55 rotate 90*y translate <22, 7.9, -7> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate 90*y translate <22, 7.9, -11> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate 90*y translate <22, 7.9, 0> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate 90*y translate <22, 7.9, 8> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate 90*y translate <22, 7.9, 11.5> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }


//Row3
object { Spects scale .55 rotate 90*y translate <25.2, 9.5, 14> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate 90*y translate <25.2, 9.5, 8> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate 90*y translate <25.2, 9.5, 5> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }



//Front
// Row1
object { Spects scale .55 rotate -180*y translate <-10, 6.3, -18.8> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <-6, 6.3, -18.8> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <-3.5, 6.3, -18.8> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <0, 6.3, -18.8> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <3, 6.3, -18.8> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <5, 6.3, -18.8> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }


//Row2
object { Spects scale .55 rotate -180*y translate <0, 7.9, -22> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <3, 7.9, -22> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <-3, 7.9, -22> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <6, 7.9, -22> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <-6, 7.9, -22> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <9, 7.9, -22> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <-9, 7.9, -22> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <11, 7.9, -22> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }


//Row3
object { Spects scale .55 rotate -180*y translate <-5, 9.5, -25.2> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <-1, 9.5, -25.2> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
object { Spects scale .55 rotate -180*y translate <3, 9.5, -25.2> pigment { color rgb <rand(R1), rand (R2), rand(R3)> } normal { gear } finish { ambient .2 diffuse .2} }
//object { Spects scale .55 rotate -90*y translate <-25.2, 9.5, -2> }



// ********** SCORE BOARD

// Panel Defenition

#declare Panel_frontt = difference {
  box {
    <-1, -1, -1>, <1, 1, 1>
    texture { Panel_front }
    scale <5, 2, .1>
    translate  -.6*z
  }
  box { // Panel_Front2
    <-1, -1, -1>, <1, 1, 1>
    texture { Panel_front }
    scale <4.7, 1.7, .101>
    translate  -.6*z
  }
  scale <1, 1, 1.001>
}


#declare Bars = union {
  box { // Bar_horizontal
    <-1, -1, -1>, <1, 1, 1>
    scale <4, .08016, .08>
    translate  <.99, 0, -.45>
  }
  box { // Bar_vertical
    <-1, -1, -1>, <1, 1, 1>
    scale <.1, 1.99, .08>
    translate  <3, 0, -.45>
  }
  texture { boff }
}

#declare Panel_back =
union {
  box { //Panel back
    <-1, -1, -1>, <1, 1, 1>
    pigment { Gray50 } finish { ambient .3 phong .2 }
    scale <5, 2, .5>
  }
  box {
    <-1, -1, -1>, <1, 1, 1>
    texture { Panel_body scale .1 }
    scale <4.9999, 1.9999, .50001>
  }
  sphere { // Point_1_1
    <0, 0, 0>, 1
    texture { boff }
    scale .25
    translate  <3.5, .9, -.4>
  }
  sphere { // Point_1_2
    <0, 0, 0>, 1
    texture { Boff_orange }
    scale .25
    translate  <4.3, .9, -.4>
  }
  sphere { // Point_2_1
    <0, 0, 0>, 1
    texture { boff }
    scale .25
    translate  <3.5, -.9, -.4>
  }
  sphere { // Point_2_2
    <0, 0, 0>, 1
    texture { Boff_Black }
    scale .25
    translate  <4.3, -.9, -.4>
  }

  box { // Glass_front
    <-1, -1, -1>, <1, 1, 1>
    texture { Glass4 }
    scale <4.9, 1.9, .02>
    translate  -.68*z
   }

}

// TEXT
#declare inscr =
union {
text {
ttf "ariblk.ttf"
"PORTALKEEPER" .01,0
no_shadow
pigment { White } finish { ambient .3 diffuse .3 phong .2 }
scale .8
translate <-4.3, .58, -.501>
}

// vs.

text {
ttf "ariblk.ttf"
"vs." 0.01, 0
no_shadow
pigment { LightSteelBlue } finish { ambient .6 diffuse .4 phong .2 }
scale .8
translate <-4.5, -.19, -.501>
}

text {
ttf "ariblk.ttf"
"OBERIAS" 0.01, 0
no_shadow
pigment { White } finish { ambient .3 diffuse .3 phong .2 }
scale .8
translate <-4.3, -1.1, -.501>
}
}

#declare Panelll =
union {
object { Panel_frontt }
object { Bars }
object { Panel_back }
object { inscr }
}

#declare screw =
cylinder { <0, 0, 0>, <0, -.2, 0>, .1
pigment { White }
}

#declare Panellll = union {
  object { Panelll translate -5*z}
  object { Panelll rotate -90*y translate <5, 0, 0> }
  object { Panelll rotate 90*y translate <-5, 0, 0> }
  object { Panelll rotate 180*y translate <0, 0, 5> }
  box { <-5, 2, -5>, <5, 2.01, 5> pigment { Red } }
  box { <-5, -2, -5>, <5, -2.01, 5> pigment { Red } }
  torus { .3, .1 pigment { Black } finish { phong .3 ambient .5 } rotate <90, -45, 0> translate <-4.6, 2, -4.6> }
  torus { .3, .1 pigment { Black } finish { phong .3 ambient .5 } rotate <90, 45, 0> translate <4.6, 2, -4.6> }
  torus { .3, .1 pigment { Black } finish { phong .3 ambient .5 } rotate <90, 45, 0> translate <-4.6, 2, 4.6> }
  torus { .3, .1 pigment { Black } finish { phong .3 ambient .5 } rotate <90, -45, 0> translate <4.6, 2, 4.6> }
  torus { .3, .1 texture { T_Gold_2C } rotate <10, 0, -10> translate <-4.82, 2.3, -4.82> }
  torus { .3, .1 texture { T_Gold_2C } rotate <10, 0, 10> translate <4.82, 2.3, -4.82> }
  torus { .3, .1 texture { T_Gold_2C } rotate <-10, 0, -10> translate <-4.85, 2.3, 4.85> }
  torus { .3, .1 texture { T_Gold_2C } rotate <-10, 0, 10> translate <4.85, 2.3, 4.85> }
  torus { .15, .05 texture { Rope } rotate <90, -45, 0> translate <-5, 2.4, -5> }
  torus { .15, .05 texture { Rope } rotate <90, 45, 0> translate <5, 2.4, -5> }
  torus { .15, .05 texture { Rope } rotate <90, 45, 0> translate <-5, 2.4, 5> }
  torus { .15, .05 texture { Rope } rotate <90, -45, 0> translate <5, 2.4, 5> }
}


#declare poles =
cylinder { //pole rear right
  <0, 8, 0>, <0, 18, 0>, .35
  pigment { White } //finish { ambient .5 phong .4 }
}

object { poles translate <23, 0, 23> } light_source { <23, 19, 23>, Gray75 }
object { poles translate <-23, 0, 23> } light_source { <-23, 19, 23>, Gray20 }
object { poles translate <23, 0, -23> } light_source { <23, 19, -23>, Gray20 }
object { poles translate <-23, 0, -23> } light_source { <-23, 19, -23>, Gray20 }


object { Panellll scale .7 translate <0, 9, 0>}



 light_source { <-4, 8, -15>, color rgb <1, 1, 1>
    spotlight
    point_at < 0, 9, -4.5>
    radius 4
    falloff 15
    tightness 2
  }


 light_source { <-15, 8, -4>, color rgb <1, 1, 1>
    spotlight
    point_at < -4.5, 9, 0>
    radius 3
    falloff 10
    tightness 8
  }



//Ropes
cylinder { <-23, 18, -23>, <-3.55, 10.7, -3.55>, .08 texture { Rope } }
cylinder { <-23, 18, 23>, <-3.55, 10.7, 3.55>, .08 texture { Rope } }
cylinder { <23, 18, -23>, <3.55, 10.7, -3.55>, .08 texture { Rope } }
cylinder { <23, 18, 23>, <3.55, 10.7, 3.55>, .08 texture { Rope } }





// ***** Publ Panneau


#declare tria = union { //staenner
cylinder { // Right_vert_front_bar
  <0, 1, 0>, <0, 0, 0>, 1
  scale <.1, 1.7, .1>
  rotate <25, 0, 0>
  translate  <-1.7, 0, 0>
}


cylinder { // Right_vert_rear_bar
  <0, 1, 0>, <0, 0, 0>, 1
  scale <.1, 1.7, .1>
  rotate <-15, 0, 0>
  translate  <-1.7, 0, 1.2>
}


cylinder { // Right_low_bar
  <0, 1, 0>, <0, 0, 0>, 1
  scale <.1, 1.3, .1>
  rotate 90.0*x
  translate  -1.7*x
}

sphere { <0, 0, 0>, .2
  pigment { Black } finish { specular .3 }
  translate <-1.7, 0, 0>
}

sphere { <0, 0, 0>, .2
  pigment { Black } finish { specular .3 }
  translate < -1.7, 1.5, .8>
}

sphere { <0, 0, 0>, .2
  pigment { Black }
  translate <-1.7, 0, 1.2>
}
pigment { White } finish { specular .3 }
}


#declare Pub_pan = union {
cylinder { // Top_bar
  <0, 1, 0>, <0, 0, 0>, 1
  scale <.1, 3.4, .1>
  rotate <180, -180, 90>
  translate  <-1.7, 1.5, .8>
}


cylinder { // Lower_bar
  <0, 1, 0>, <0, 0, 0>, 1
  scale <.1, 3.4, .1>
  rotate <180, -180, 90>
  translate  -1.7*x
}


object { tria }
object { tria translate 3.4*x }

//box { // Grad1
//  <-1, -1, -1>, <1, 1, 1>
//  texture { Pub2 }
//  scale <1.8, 1.1, .06>
//  rotate 25*x
//  translate  <0, .9, .18>
//}

box { // Grad2
  <-1, -1, -1>, <1, 1, 1>
  scale <1.8, 1.1, .06>
  rotate 25*x
  translate  <0, .9, .2>
}
translate <0, .5, 0>
pigment { White } finish { specular .3 }
}


#declare pub_pan1 =
box { // Grad1
  <-1, -1, -1>, <1, 1, 1>
  texture { Pub1 }
  scale <1.8, 1.1, .06>
  rotate 25*x
  translate  <0, 1.4, .18>
}

#declare pub_pan2 =
box { // Grad1
  <-1, -1, -1>, <1, 1, 1>
  texture { Pub2 }
  scale <1.8, 1.1, .06>
  rotate 25*x
  translate  <0, 1.4, .18>
}

#declare pub_pan3 =
box { // Grad1
  <-1, -1, -1>, <1, 1, 1>
  texture { Pub3 }
  scale <1.8, 1.1, .06>
  rotate 25*x
  translate  <0, 1.4, .18>
}

#declare pub_pan4 =
box { // Grad1
  <-1, -1, -1>, <1, 1, 1>
  texture { Pub4 }
  scale <1.8, 1.1, .06>
  rotate 25*x
  translate  <0, 1.4, .18>
}

//rear
union { object { Pub_pan } object { pub_pan1 } translate <-8, -.33, 12> }
union { object { Pub_pan } object { pub_pan3 } translate <-4, -.33, 12> }
union { object { Pub_pan } object { pub_pan2 } translate <4, -.33, 12> }
union { object { Pub_pan } object { pub_pan4 } translate <8, -.33, 12> }

//right
//object { Pub_pan rotate <0, 90, 0> translate <12, 0, -8> }
union { object { Pub_pan } object { pub_pan3 } rotate <0, 90, 0> translate <12, -.33, -2.7> }
union { object { Pub_pan } object { pub_pan2 } rotate <0, 90, 0> translate <12, -.33, 2.7> }
union { object { Pub_pan } object { pub_pan4 } rotate <0, 90, 0> translate <12, -.33, 8> }

//left
union { object { Pub_pan } object { pub_pan4 } rotate <0, -90, 0> translate <-12, -.33, -8> }
union { object { Pub_pan } object { pub_pan4 } rotate <0, -90, 0> translate <-12, -.33, -2.7> }
union { object { Pub_pan } object { pub_pan1 } rotate <0, -90, 0> translate <-12, -.33, 2.7> }
union { object { Pub_pan } object { pub_pan2 } rotate <0, -90, 0> translate <-12, -.33, 8> }

//front
//object { Pub_pan rotate <0, 180, 0> translate <-8, 0, -12> }
//object { Pub_pan rotate <0, 180, 0> translate <-2.7, 0, -12> }
union { object { Pub_pan } object { pub_pan4 } rotate <0, 180, 0> translate <2.7, -.33, -12> }
//object { Pub_pan rotate <0, 180, 0> translate <8, 0, -12> }





// *******Torch
// Declare Torch components

#declare tiges =
  cylinder {
    <0, 1, 0>, <0, 0, 0>, 1
    texture { T_Copper_4C }
    scale <.4, 1.3, .4>
      }

#declare deg = 0
#declare irghd = union {
#while ( deg < 360 )
 object { tiges
 translate vrotate ( x, y*deg) }
 #declare deg = deg + 45
 #end
}

#declare tige_ring =
  torus {
    1.1, .1  rotate -y*90
    texture { t2 }
    scale <.06, .17, .06>
    }

#declare base =
  cylinder {
    <0, 1, 0>, <0, 0, 0>, 1
    texture { T_Silver_4B }
    scale <.2, .02, .2>
    translate  1.3*y
  }


#declare sides =
  box { // torch_side24
    <-1, -1, -1>, <1, 1, 1>
    texture { T_Silver_3C }
    scale <.2, .2, .1>
    rotate -10*z
  }

#declare deg = 0
#declare cdrn = union {
#while ( deg < 360 )
 object { sides hollow
 rotate y*deg
 translate vrotate ( x, y*deg) }
 #declare deg = deg + 45
 #end
}

#declare rock =
  difference {
    sphere { <0, 0, 0>, .2
    texture { Rock_tex scale .3 }
    }

    box { <-.3, -.3, -.3>, <.3, 0, .3>
    pigment { White }
    }
    hollow
  }

#declare torch_flame =
cone {
  <0, 0, 0>, 1
  <0, 2, 0>, .05
  hollow
  pigment { Clear }
  halo {
   emitting
     spherical_mapping
      linear
      turbulence 1.1
      scale <.5, .8, .5>
      color_map {

       //[ 0.000  color rgbt<0.86, 0.86, 0.44, 1> ]
       //[ 0.313  color rgbt<0.530, 0.120, 0.470, 0> ]
       //[ 0.691  color rgbt<0.557, 0.137, 0.137, -1> ]
       //[ 1.000  color rgbt<0.86, 0.86, 0.44, 1> ]

       [ 0.0 color rgbt <1, 0, 0, 1> ]
       [ 0.5 color rgbt <1, 1, 0, -1> ]
       [ 1.0 color rgbt <1, 0, 0, 1> ]
       ////[ 0.000  color rgbt<0.720, 0.450, 0.200, 1> ]

       //[ 0.313  color rgbt<0.530, 0.120, 0.470, 0> ]
       //[ 0.691  color rgbt<0.557, 0.137, 0.137, -1> ]
       //[ 1.000  color rgbt<0.590, 0.410, 0.310, 1> ]
      }
      frequency 3
      samples 30
    }
  }



#declare torch =
union {
  object { cdrn scale <.2, 1, .2> translate 1.3*y }
  object { tige_ring translate 1.0*y }
  object { tige_ring translate .1*y }
  object { tige_ring translate .5*y }
  object { base }
  object { irghd scale <.043, 1, .043> }
  object { rock scale .75 translate 1.3*y }
  object { torch_flame scale <.3, .5, .3> translate 1.4*y }
  //light_source { <0, 3, 0>, White fade_distance 5 fade_power .5 }

scale 1.3
}


// Draw Torch

object { torch translate < 9, 0, 9> }
//object { torch translate < 9, 0, -9> }
object { torch translate < -9, 0, 9> }
object { torch translate < -9, 0, -9> }




/*
// Force Field Cage

box {
 < -1, 0, -1 >,
 < 1, 1, 1>
 texture { Force_Field
   scale .2 }
 scale < 10, 7, 10>
 no_shadow
}
*/



// *** MAGE ***


#declare right_hand =
sphere { < 0, 0, 0 >, 1
  pigment { Flesh }
  scale <.15, .1, .12 >
  rotate -40*y
  translate <-.43, .9, -2.05>
}

#declare staff_top =
superellipsoid {
  <2.0, 2.0>
  scale <.2, .13, .33>
  rotate < -5, -17, 0 >
  translate <-.03, .68, -3.65>
  texture {stafftopcol}
}


#declare staff =
cylinder {
  <0,1,0>, <0,0,0>, 1
  scale < 0.05, 3.5, 0.05>
  rotate < -95, -15, 0>
  translate < -1, 1, 0 >
  texture { staffcol }
}

#declare arm =
blob {
threshold .2
// left upper arm
sphere { <0, 0, 0>, 1, 1.5
  pigment { Flesh } finish { ambient .5 diffuse .3 }
  scale <.72, .2, .16>
  rotate 17*z
  translate <.94, .99, -.58>
}

// left lower arm
sphere { <0, 0, 0>, 1, 1
  pigment { Flesh } finish { ambient .5 diffuse .3 }
  scale <.5, .12, .12>
  rotate  70*z
  translate <1.54, 1.42, -.58>
}
}

#declare hand = // from POVray Manual, modified from right to left hand
 blob {
    threshold .65

    sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
    sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
    sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel

    cylinder { <-.65,-.28,0>, <-.65,.28, .05>, .26, 1 }    //lower pinky
    cylinder { <-.65,.28, .05>, <-.65, .68, .2>, .26, 1 }  //upper pinky

    cylinder { <-.3,-.28,0>, <-.3,.44, .05>, .26, 1 }      //lower ring
    cylinder { <-.3,.44, .05>, <-.3, .9, .2>, .26, 1 }     //upper ring

    cylinder { <.05,-.28,0>, <.05, .49, .05>, .26, 1 }     //lower middle
    cylinder { <.05,.49, .05>, <.05, .95, .2>, .26, 1 }    //upper middle

    cylinder { <.4,-.4,0>, <.4, .512, .05>, .26, 1 }      //lower index
    cylinder { <.4,.512, .05>, <.4, .85, .2>, .26, 1 }    //upper index

    cylinder { <.41, -.95,0>, <.85, -.68, .05>, .25, 1 }  //lower thumb
    cylinder { <.85,-.68, .05>, <1.2, -.4, .2>, .25, 1 }  //upper thumb

    sphere { <-.65,.28, .05>, .26, -1 } //counteract pinky knuckle bulge
    sphere { <-.65,-.28,0>, .26, -1 }   //counteract pinky palm bulge

    sphere { <-.3,.44, .05>, .26, -1 }  //counteract ring knuckle bulge
    sphere { <-.3,-.28,0>, .26, -1 }    //counteract ring palm bulge

    sphere { <.05,.49, .05>, .26, -1 }  //counteract middle knuckle bulge
    sphere { <.05,-.28,0>, .26, -1 }    //counteract middle palm bulge

    sphere { <.4,.512, .05>, .26, -1 }  //counteract index knuckle bulge
    sphere { <.4,-.4,0>, .26, -1 }      //counteract index palm bulge

    sphere { <.85,-.68, .05>, .25, -1 } //counteract thumb knuckle bulge
    sphere { <.41,-.7,0>, .25, -.89 }   //counteract thumb heel bulge
    pigment { Flesh } finish { ambient .5 diffuse .3 }
  }

// ***Pouch

#declare pouch = union {

//Pouch
superellipsoid {
  <.1, 1>
  pigment { Red } finish { ambient .3 }
  scale <1, 1, .5>
}

// lid
difference {
  superellipsoid {
    <.1, 1>
    scale <1, 1, .5>
  }
  box {
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1, 1>
    rotate -45*z
    translate  <-.69, -.78, 0>
  }
  box {
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1, 1>
    rotate 45*z
    translate  <.73, -.75, 0>
  }
    pigment { MediumBlue } finish { ambient .5 }
    scale <1, 1.2, 1>
}

//knob
sphere {
  <0, 0, 0>,1
  pigment { Gold } finish { ambient .7 diffuse .4 reflection .15 specular .2 metallic}
  scale .08
  translate  <0, .2, -.58>
}
rotate 45*y
}

// ***Belt
#declare belt = union {
  torus { .524, .04 pigment { Firebrick } finish { ambient .5 } scale <.9, 1, .77> translate <.08, -.15, -.59> }
  torus { .05, .035 pigment { Firebrick } finish { ambient .5 } rotate -40*z translate <0, -.15, -1> }
  torus { .05, .035 pigment { Firebrick } finish { ambient .5 } rotate 40*z translate <0, -.15, -1.05> }

  object { pouch scale .15 translate <-.4, -.2, -.8> }
}


  #declare mage_un =
    union {
      object { mage texture { robe } }
      object { right_hand }
      object { arm }
      object { staff }
      object { staff_top }
      object { hand scale .16 rotate -110*y translate < 1.6, 1.89, -.6> no_shadow }
      object { belt }
    }



// mage translate
object {mage_un
  rotate -40*y
  translate <-6.5, 2, 2.5>
}

// aura mage
object { mage
    no_shadow
    texture { auracol scale 1.3 }
    scale <1.5, 1.2, 1.5>
    rotate -40*y
    translate <-6.7, 2, 2.5>
  }

// ** energy beam to mage
cone {
  <-4.8, 4.15, 3.25>, .008
  <-3, 50, 11>, .15
  no_shadow
  texture { beam scale .05}
}


// ** Front beam

difference {
  sphere { 0, 1 hollow no_shadow texture { circle rotate -10*z} }
  sphere { 0, .99 hollow no_shadow pigment { color rgbf <1, 1, 1, 1> } }
  box { <0, -1, -1>, <1, 1, 1> hollow no_shadow pigment { color rgbf <1, 1, 1, 1> } }
scale <1, 2, 2 >
rotate 35*y
translate <-.8, 2, -2.3>
no_shadow
}



// ** Beam from mage

cone {
  <-3.7, 2.65, -.55>, .01
  <-1.65, 2.3, -2>, .07
  no_shadow
 texture { beam scale .05 rotate 90*z}
}





// boom vict

#declare expl = difference {
  sphere { 0, 2.2 hollow }
  sphere { 0, 1 hollow }

    pigment { Clear }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.2
      color_map {
        [ 0 color rgbt <0, 0, 1, 1> ]
        [ .5 color rgbt <1, 0, 0, 0> ]
        [ 1 color rgbt <1, 1, 0, -1> ]
      }
      samples 30
      scale 1.5
    }
//scale 1.2
finish { reflection 0 ambient 0 diffuse 0 brilliance 0 }
}


object { expl
  no_shadow
  scale 2
  rotate y*190
  translate <3.2, 1.5, -4.5>
}




// ****** adversary


object { vict2
  no_shadow
  texture { vic22 rotate z*0 scale <.2, .8, .1> }
  scale <1, 1, -1>
  rotate -115*y
  scale 1.2
  translate <3.2, 1.35, -4.7>
}


// **broken staff

#declare Light =
texture {
  pigment
  {
    gradient y
    turbulence .5
    color_map
    {
      [0.00 color rgbf<0.976, 0.298, 0.188, 0.8>]
      [0.47 color rgbf<0.988, 0.486, 0.478, 0.8>]
      [0.50 color rgbf<0.988, 0.988, 0.988, 1>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1>]
    }
  }
  finish {
    ambient .8
    diffuse 0
    brilliance 8
  }
  scale .8
}
texture {
  pigment
  {
    gradient y
    turbulence .03
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 1.000, 0.2>]
      [0.50 color rgbf<1.000, 1.000, 1.000, 0.8>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1>]
    }
  }
  finish {
    ambient 1.0
    diffuse 0.0
    brilliance 10.0
  }
}



#declare light =
  cone {
    <0, 0, 0>, .05
    <0, .85, 0>, .001
    texture { Light scale .85  }
}



#declare br_staff_top =
  superellipsoid {
    <2.0, 2.0>
    scale <.2, .13, .33>
    rotate 90*x
    translate < 0, 2.75, 0>
    pigment { Black } finish { specular .2 ambient .3 }
  }


#declare br_staff1 =
  cylinder {
    <0, 1.5, 0>, <0, 2.5, 0>, .05
    hollow
    texture { Cherry_Wood1 scale .5 }
  }

#declare br_staff2 =
  union {
    cylinder {
      <0, 0, 0>, <0, 1.5, 0>, .05
      texture { Cherry_Wood1 scale .5 }
    }

    object { light translate 1.5*y }
    object { light rotate 180*x }

    rotate 20*z
    translate -.5*x
}


#declare br_staff3 =
  union {
    cylinder {
      <0, -1, 0>, <0, 0, 0>, .05
      texture { Cherry_Wood1 scale .5 }
    }

    object { light }

  rotate -40*z
  translate <.4, -.1, 0>
}




#declare broken_staff =
  union {
    object { br_staff1 }
    object { br_staff_top }
    object { br_staff2 }
    object { br_staff3 }
    object { light rotate 180*x translate 1.5*y }

  }


object { broken_staff
  rotate 90*x
  rotate 15*y
  translate <1.5, .1, -6>
}




// *** Signature

#declare Rail2 = difference {
  cylinder {
    <-1, 0, 0>, <1, 0, 0>, .9
    texture { T_Silver_2C }
    scale <19, 0, 0>
  }

union {
   box { // ritz1
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .3>
    rotate 45*z
    translate  <-2.99, 1.019, 0.016>
  }
  box { // ritz2
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .3>
    rotate 45*z
    rotate 80*y
    // rotate <0, 80, 45>
    translate  <-2.737, 0.9235, 0.358>
  }

  box { // ritz3
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .3>
   rotate 45*z
   rotate -90*y

    //rotate <0, -90, 45>
    translate  <-2.6, 0.999, -0.2319>
  }



  box { // ritz4
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .2>
    rotate 45*z
    rotate -30*y
    //rotate <0., -30, 45>
    translate  <-2.336467, 1.003998, -0.008718>
  }

  box { // ritz5
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .2>
    rotate 45*z
    rotate 45*y
    //rotate <0.0, 45.0, 45.0>
    translate  <-1.60161, 0.972125, -0.229016>
  }
  box { // ritz6
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .2>
    rotate 45*z
    rotate -45*y
    //rotate <.0, -45, 45>
    translate  <-1.545083, 0.972125, -0.247858>
  }
  box { // ritz7
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .3>
    rotate 45*z
    rotate 35*y
    //rotate <0, 35, 45>
    translate  <-0.756421, 0.991004, 0.210173>
  }
  box { // ritz8
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .3>
    rotate 45*z
    rotate 90*y
    //rotate <0, 90, 45>
    translate  <-0.678329, 0.988061, -0.056527>
  }
  box { // ritz9
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .3>
    rotate 45*z
    rotate 35*y
    //rotate <0, 35, 45>
    translate  <-0.508747, 0.972125, -0.32904>
  }
  box { // ritz10
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .15>
    rotate 45*z
    rotate -50*y
    //rotate <0, -50, 45>
    translate  <-0.772541, 0.860569, -0.468156>
  }
  box { // ritz11
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .15>
    rotate 45*z
    rotate -50*y
    //rotate <0, -50, 45>
    translate  <-0.433377, 0.876506, 0.414534>
  }

  box { // ritz12
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .15>
    rotate 45*z
    rotate -80*y
    //rotate <0, -80, 45>
    translate  <-2.581419, 1.003998, 0.010124>
  }

  box { // ritz13
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .2>
    rotate 45*z
    rotate 45*y
    //rotate <0, 45, 45>
    translate  <0.489904, 0.972125, -0.229016>
  }
  box { // ritz14
    <-1, -1, -1>, <1, 1, 1>
    scale <.13, .13, .2>
    rotate 45*z
    rotate -45*y
    //rotate <0, -45, 45>
    translate  <0.471062, 0.972125, -0.247858>
  }
  texture { T_Silver_2C }

  scale <.09, 1, 1>
  translate -8.85*x


}
rotate -30*x

}

object { Rail2 scale < 1, .083, .083> translate <0, 7.045, -18> }

