//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 3 lights, 32 textures and 161 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 08/28/1997    (28.08.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <0.066, -0.746, 0.339>
  direction <0.0,     0.0,  0.9196>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-0.021, -0.084, 0.212>
}

// *******  L I G H T S *******
light_source {   // Light002
  <3.017, -2.989, 3.005>
  color rgb <0.207, 0.103, 0.103>
}

light_source {   // Light001
  <-2.928, -3.018, 2.978>
  color rgb <0.105, 0.105, 0.205>
}

light_source {   // Light2
  <0.556, 0.467, 0.563>
  color rgb <1.626, 1.329, 1.145>
}


// ********  TEXTURES  *******
//

#include "magic2.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******





union { // Wand
  cylinder { // BlackStick
    <0,0,1>, <0,0,0>, 1
    texture {
      WandBlack
    }
    scale <0.01, 0.01, 0.6>
  }
  cylinder { // Whiteknob1
    <0,0,1>, <0,0,0>, 1
    texture {
      WandWhite
    }
    scale <0.01, 0.01, 0.02>
    translate  -0.02*z
  }
  cylinder { // Whiteknob2
    <0,0,1>, <0,0,0>, 1
    texture {
      WandWhite
    }
    scale <0.01, 0.01, 0.02>
    translate  0.6*z
  }
  scale <1.5, 1.5, 2.0>
  rotate <-90.0, 0.0, 40.77747>
  translate  <0.163861, -0.298805, 0.015>
}


#declare BzPtch001 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.224734, -2.000000, 0.000000>, <-2.224734, -2.000000, 0.021487>, <-1.224734, -2.000000, 0.021487>, <-0.224734, -2.000000, 0.945409>,
      <-3.224734, -1.000000, 0.000000>, <-2.224734, -1.000000, 0.021487>, <-1.224734, -1.000000, 0.021487>, <-0.224734, -1.000000, 0.945409>,
      <-3.224734, 0.000000, 0.000000>, <-2.224734, 0.000000, 0.021487>, <-1.224734, 0.000000, 0.021487>, <-0.224734, 0.000000, 0.945409>,
      <-3.224734, 1.000000, 0.000000>, <-2.224734, 1.000000, 0.021487>, <-1.224734, 1.000000, 0.021487>, <-0.224734, 1.000000, 0.945409>
    }
  }
  texture {
    FrontBookCover
  translate <2.987682, 3.005792, 0.000000>
  }
  translate  <0.07602, 0.5, 0.14999>
}
#declare BzPtch2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.224734, -2.000000, 0.000000>, <-2.224734, -2.000000, 0.021487>, <-1.201901, -2.000000, -0.024180>, <-0.224734, -2.000000, 0.945409>,
      <-3.224734, -1.000000, 0.000000>, <-2.224734, -1.000000, 0.021487>, <-1.201901, -1.000000, -0.024180>, <-0.224734, -1.000000, 0.945409>,
      <-3.224734, 0.000000, 0.000000>, <-2.224734, 0.000000, 0.021487>, <-1.201901, 0.000000, -0.024180>, <-0.224734, 0.000000, 0.945409>,
      <-3.224734, 1.000000, 0.000000>, <-2.224734, 1.000000, 0.021487>, <-1.201901, 1.000000, -0.024180>, <-0.224734, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.080431, 0.5, 0.1471>
}
#declare BzPtch3 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.065307, 0.5, 0.143579>
}
#declare BzPtch4 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.072869, 0.5, 0.1361>
}
#declare BzPtch5 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.082869, 0.5, 0.1261>
}
#declare BzPtch6 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.092869, 0.5, 0.1161>
}
#declare BzPtch7 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.102869, 0.5, 0.1061>
}
#declare BzPtch8 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.112869, 0.5, 0.0961>
}
#declare BzPtch9 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.122869, 0.5, 0.0861>
}
#declare BzPtch10 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.132869, 0.5, 0.0761>
}
#declare BzPtch11 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.142869, 0.5, 0.0661>
}
#declare BzPtch12 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.152869, 0.5, 0.0561>
}
#declare BzPtch13 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.162869, 0.5, 0.0461>
}
#declare BzPtch14 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-0.852489, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-0.852489, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-0.852489, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-0.852489, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.172869, 0.5, 0.0361>
}
#declare BzPtch15 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-0.536395, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-0.536395, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-0.536395, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-0.536395, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.182869, 0.5, 0.0261>
}
#declare BzPtch16 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-0.215635, -2.000000, -0.136077>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-0.215635, -1.000000, -0.136077>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-0.215635, 0.000000, -0.136077>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-0.215635, 1.000000, -0.136077>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  translate  <0.192869, 0.5, 0.0161>
}
#declare BzPtch24 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  rotate 180.0*z
  translate  <-0.112869, -0.5, 0.0961>
}
#declare BzPtch25 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  rotate 180.0*z
  translate  <-0.122869, -0.5, 0.0861>
}
#declare BzPtch26 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  rotate 180.0*z
  translate  <-0.132869, -0.5, 0.0761>
}
#declare BzPtch27 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  rotate 180.0*z
  translate  <-0.142869, -0.5, 0.0661>
}
#declare BzPtch28 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  rotate 180.0*z
  translate  <-0.152869, -0.5, 0.0561>
}
#declare BzPtch29 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-1.201901, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-1.201901, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-1.201901, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-1.201901, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  rotate 180.0*z
  translate  <-0.162869, -0.5, 0.0461>
}
#declare BzPtch30 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-2.224734, -2.000000, -0.012763>, <-0.852489, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-2.224734, -1.000000, -0.012763>, <-0.852489, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-2.224734, 0.000000, -0.012763>, <-0.852489, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-2.224734, 1.000000, -0.012763>, <-0.852489, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  rotate 180.0*z
  translate  <-0.172869, -0.5, 0.0361>
}
#declare BzPtch31 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-0.924241, -2.000000, -0.012763>, <-0.288682, -2.000000, -0.058430>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-0.924241, -1.000000, -0.012763>, <-0.288682, -1.000000, -0.058430>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-0.924241, 0.000000, -0.012763>, <-0.288682, 0.000000, -0.058430>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-0.924241, 1.000000, -0.012763>, <-0.288682, 1.000000, -0.058430>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  rotate 180.0*z
  translate  <-0.182869, -0.5, 0.0261>
}
#declare BzPtch32 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.201901, -2.000000, -0.011417>, <-0.378127, -2.000000, -0.012763>, <0.019838, -2.000000, -0.222830>, <-0.201901, -2.000000, 0.945409>,
      <-3.201901, -1.000000, -0.011417>, <-0.378127, -1.000000, -0.012763>, <0.019838, -1.000000, -0.222830>, <-0.201901, -1.000000, 0.945409>,
      <-3.201901, 0.000000, -0.011417>, <-0.378127, 0.000000, -0.012763>, <0.019838, 0.000000, -0.222830>, <-0.201901, 0.000000, 0.945409>,
      <-3.201901, 1.000000, -0.011417>, <-0.378127, 1.000000, -0.012763>, <0.019838, 1.000000, -0.222830>, <-0.201901, 1.000000, 0.945409>
    }
  }
  texture {
    paper
  }
  rotate 180.0*z
  translate  <-0.192869, -0.5, 0.0161>
}
#declare Spine = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.164055, -2.000000, 0.098023>, <-0.088002, -2.000000, 0.013741>, <0.000000, -2.000000, -0.072395>, <0.059998, -2.000000, 0.049174>,
      <-0.164055, -1.000000, 0.098023>, <-0.088002, -1.000000, 0.013741>, <0.000000, -1.000000, -0.072395>, <0.059998, -1.000000, 0.049174>,
      <-0.164055, 0.000000, 0.098023>, <-0.088002, 0.000000, 0.013741>, <0.000000, 0.000000, -0.072395>, <0.059998, 0.000000, 0.049174>,
      <-0.164055, 1.000000, 0.098023>, <-0.088002, 1.000000, 0.013741>, <0.000000, 1.000000, -0.072395>, <0.059998, 1.000000, 0.049174>
    }
  }
  texture {
    paper
  }
  translate  <0.023605, 0.5, 1.0>
}
union { // OpenBook
  object { BzPtch001 }
  object { BzPtch2 }
  object { BzPtch3 }
  object { BzPtch4 }
  object { BzPtch5 }
  object { BzPtch6 }
  object { BzPtch7 }
  object { BzPtch8 }
  object { BzPtch9 }
  object { BzPtch10 }
  object { BzPtch11 }
  object { BzPtch12 }
  object { BzPtch13 }
  object { BzPtch14 }
  object { BzPtch15 }
  object { BzPtch16 }
  object { BzPtch24 }
  object { BzPtch25 }
  object { BzPtch26 }
  object { BzPtch27 }
  object { BzPtch28 }
  object { BzPtch29 }
  object { BzPtch30 }
  object { BzPtch31 }
  object { BzPtch32 }
  object { Spine }
  scale 0.1
  rotate 45.437202*z
  translate  <0.375028, -0.016466, 0.0>
}


#declare LightOuterBody = intersection {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 1.1, 1.248>
    rotate -45.0*z
    translate  1.248*z
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 1.1, 1.248>
    translate  1.248*z
  }
  texture {
    LightBlackBody
  }
}
#declare LightBody = difference {
  object { LightOuterBody }
  cylinder { // lighthole
    <0,0,1>, <0,0,0>, 1
    texture {
      Inner_lining
    }
    scale <0.99, 0.99, 2.5>
    translate  0.01*z
  }
}
#declare Holes = union {
  cylinder { // SmallHole1
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate -90.0*y
    translate  0.5*z
  }
  cylinder { // SmallHole2
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -30.0>
    translate  0.5*z
  }
  cylinder { // SmallHole3
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -60.0>
    translate  0.5*z
  }
  cylinder { // SmallHole4
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -90.0>
    translate  0.5*z
  }
  cylinder { // SmallHole5
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -120.0>
    translate  0.5*z
  }
  cylinder { // SmallHole6
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -150.0>
    translate  0.5*z
  }
  cylinder { // SmallHole7
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -180.0>
    translate  0.5*z
  }
  cylinder { // SmallHole8
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -210.0>
    translate  0.5*z
  }
  cylinder { // SmallHole9
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -240.0>
    translate  0.5*z
  }
  cylinder { // SmallHole10
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -270.0>
    translate  0.5*z
  }
  cylinder { // SmallHole11
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -300.0>
    translate  0.5*z
  }
  cylinder { // SmallHole12
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -330.0>
    translate  0.5*z
  }
  cylinder { // SmallHole13
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -15.0>
    translate  0.75*z
  }
  cylinder { // SmallHole14
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -45.0>
    translate  0.75*z
  }
  cylinder { // SmallHole15
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -75.0>
    translate  0.75*z
  }
  cylinder { // SmallHole16
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -105.0>
    translate  0.75*z
  }
  cylinder { // SmallHole17
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -135.0>
    translate  0.75*z
  }
  cylinder { // SmallHole18
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -165.0>
    translate  0.75*z
  }
  cylinder { // SmallHole19
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -195.0>
    translate  0.75*z
  }
  cylinder { // SmallHole20
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -225.0>
    translate  0.75*z
  }
  cylinder { // SmallHole21
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -255.0>
    translate  0.75*z
  }
  cylinder { // SmallHole22
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -285.0>
    translate  0.75*z
  }
  cylinder { // SmallHole23
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -315.0>
    translate  0.75*z
  }
  cylinder { // SmallHole24
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -345.0>
    translate  0.75*z
  }
  cylinder { // SmallHole25
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate -90.0*y
    translate  1.0*z
  }
  cylinder { // SmallHole26
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -30.0>
    translate  1.0*z
  }
  cylinder { // SmallHole27
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -60.0>
    translate  1.0*z
  }
  cylinder { // SmallHole28
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -90.0>
    translate  1.0*z
  }
  cylinder { // SmallHole29
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -120.0>
    translate  1.0*z
  }
  cylinder { // SmallHole30
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -150.0>
    translate  1.0*z
  }
  cylinder { // SmallHole31
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -180.0>
    translate  1.0*z
  }
  cylinder { // SmallHole32
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -210.0>
    translate  1.0*z
  }
  cylinder { // SmallHole33
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -240.0>
    translate  1.0*z
  }
  cylinder { // SmallHole34
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -270.0>
    translate  1.0*z
  }
  cylinder { // SmallHole35
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -300.0>
    translate  1.0*z
  }
  cylinder { // SmallHole36
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 1.3>
    rotate <0.0, -90.0, -330.0>
    translate  1.0*z
  }
  texture {
    Inner_lining
  }
}
#declare LampWithHoles = difference {
  object { LightBody }
  object { Holes }
  rotate 90.0*x
  translate  1.25*y
}
#declare TraSwp001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, 0.7>,
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 0.7>,
  <0.741365, 1.0>,
  <-0.720946, 1.0>,
  <-1.0, 0.7>
  rotate -x*90
  scale <1.0, 1.0, 0.05>
  translate  <0.0, 1.0, -0.025>
}
#declare LightFlap1 = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    rotate <-90.0, 0.0, -90.0>
    translate  -0.5*x
  }
  object { TraSwp001 }
  texture {
    LightBlackBody
  }
  rotate 154.029724*x
  translate  <0.0, -1.25, 1.1>
}
#declare TraSwp2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, 0.7>,
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 0.7>,
  <0.741365, 1.0>,
  <-0.720946, 1.0>,
  <-1.0, 0.7>
  rotate -x*90
  scale <1.0, 1.0, 0.05>
  translate  <0.0, 1.0, -0.025>
}
#declare LightFlap2 = union {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    rotate <-90.0, 0.0, -90.0>
    translate  -0.5*x
  }
  object { TraSwp2 }
  texture {
    LightBlackBody
  }
  rotate -160.910599*x
  translate  <0.0, -1.25, -1.1>
}
#declare TraSwp3 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, 0.7>,
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 0.7>,
  <0.741365, 1.0>,
  <-0.720946, 1.0>,
  <-1.0, 0.7>
  rotate -x*90
  scale <1.0, 1.0, 0.05>
  translate  <0.0, 1.0, -0.025>
}
#declare LightFlap3 = union {
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    rotate <-90.0, 0.0, -90.0>
    translate  -0.5*x
  }
  object { TraSwp3 }
  texture {
    LightBlackBody
  }
  rotate <-160.910599, 90.0, 0.0>
  translate  <-1.1, -1.25, 0.0>
}
#declare TraSwp4 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, 0.7>,
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 0.7>,
  <0.741365, 1.0>,
  <-0.720946, 1.0>,
  <-1.0, 0.7>
  rotate -x*90
  scale <1.0, 1.0, 0.05>
  translate  <0.0, 1.0, -0.025>
}
#declare LightFlap4 = union {
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 1.0>
    rotate <-90.0, 0.0, -90.0>
    translate  -0.5*x
  }
  object { TraSwp4 }
  texture {
    LightBlackBody
  }
  rotate <160.220963, 90.0, 0.0>
  translate  <1.1, -1.25, 0.0>
}
//
// Include file contains 'RotSwp001'
//
#include "magic2.in1"
#declare RotSwp001 = object {
  RotSwp001_Raw
  texture {
    LightBlackBody
  }
  rotate 90.0*x
  translate  <0.0, 1.75, 0.0>
}
//
// Include file contains 'RotSwp2'
//
#include "magic2.in2"
#declare RotSwp2 = object {
  RotSwp2_Raw
  texture {
    LightBlackBody
  }
  scale <0.7, 0.7, 1.0>
  rotate 90.0*x
  translate  <0.0, 1.95, 0.0>
}
#declare LampHead = union {
  object { LampWithHoles }
  object { LightFlap1 }
  object { LightFlap2 }
  object { LightFlap3 }
  object { LightFlap4 }
  object { RotSwp001 }
  object { RotSwp2 }
  cylinder { // Switch
    <0,0,1>, <0,0,0>, 1
    texture {
      LightBlackBody
    }
    scale <0.05, 0.05, 0.25>
    rotate 90.0*x
    translate  <0.0, 1.9, 0.0>
  }
  sphere { // knob
    <0,0,0>,1
    texture {
      LightBlackBody
    }
    scale <0.05, 0.05, 0.025>
    rotate 90.0*x
    translate  <0.0, 1.898755, 0.0>
  }
  rotate <27.445482, -1.678348, -0.086796>
  translate  1.5*z
}
#declare Pin1 = union {
  cylinder { // RotPin
    <0,0,1>, <0,0,0>, 1
    texture {
      LightBlackBody
    }
    scale 0.05
  }
  sphere { // PinHead
    <0,0,0>,1
    texture {
      LightBlackBody
    }
    scale <0.1, 0.1, 0.02>
    translate  0.05*z
  }
  translate  -0.01*z
}
#declare Pin2 = union {
  cylinder { // RotPin1
    <0,0,1>, <0,0,0>, 1
    texture {
      LightBlackBody
    }
    scale <0.05, 0.05, 0.15>
    translate  -0.1*z
  }
  sphere { // PinHead1
    <0,0,0>,1
    texture {
      LightBlackBody
    }
    scale <0.1, 0.1, 0.02>
    translate  0.05*z
  }
  rotate -90.0*y
  translate  <-1.2, 0.0, 1.49>
}
#declare Pin3 = union {
  cylinder { // RotPin2
    <0,0,1>, <0,0,0>, 1
    texture {
      LightBlackBody
    }
    scale <0.05, 0.05, 0.15>
    translate  -0.1*z
  }
  sphere { // PinHead2
    <0,0,0>,1
    texture {
      LightBlackBody
    }
    scale <0.1, 0.1, 0.02>
    translate  0.05*z
  }
  rotate 90.0*y
  translate  <1.2, 0.0, 1.49>
}
#declare HeadMHolder = union {
  box { // HolderBase
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.2, 0.01>
    translate  0.01*z
  }
  box { // HolderRight
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.2, 0.8>
    translate  <1.2, 0.0, 0.8>
  }
  box { // HolderLeft
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.2, 0.8>
    translate  <-1.2, 0.0, 0.8>
  }
  object { LampHead }
  object { Pin1 }
  object { Pin2 }
  object { Pin3 }
  texture {
    LightBlackBody
  }
  rotate -54.161026*z
  translate  4.01*z
}
//
// Include file contains 'StandBase'
//
#include "magic2.in3"
#declare StandBase = object {
  StandBase_Raw
  texture {
    LightBlackBody
  }
}
union { // Lamp
  object { HeadMHolder }
  cylinder { // Pole
    <0,0,1>, <0,0,0>, 1
    texture {
      LightBlackBody
    }
    scale <0.15, 0.15, 4.0>
  }
  object { StandBase }
  scale 0.1
  translate  <0.538425, 0.454173, 0.0>
}


#declare peg1 = difference {
  cylinder { // pegcore1
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.01, 0.14>
    rotate -90.0*x
    translate  <-0.1, -0.05, 0.03>
  }
  box { // slit1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.008656, 0.007076>
    translate  <-0.1, -0.027, 0.037>
  }
  texture {
    BlackPeg
  }
  rotate -180.0*z
}
#declare peg2 = difference {
  cylinder { // pegcore2
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.01, 0.14>
    rotate -90.0*x
    translate  <0.1, -0.05, 0.03>
  }
  box { // slit2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackPeg
    }
    scale <0.01, 0.008656, 0.007076>
    translate  <0.1, -0.027, 0.037>
  }
  texture {
    BlackPeg
  }
  rotate -180.0*z
}
union { // PhotoFrame
  box { // FrameBack
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Granite
    }
    scale <0.15, 0.01, 0.12>
    translate  <0.0, 0.01, 0.12>
  }
  box { // GlassCover
    <-1, -1, -1>, <1, 1, 1>
    texture {
      PhotoGlass
    }
    scale <0.15, 0.005, 0.1>
    translate  <0.0, 0.03, 0.13>
  }
  box { // Photo
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Photograph
    }
    scale <0.12, 0.001, 0.09>
    translate  <0.0, 0.022, 0.12>
  }
  object { peg1 }
  object { peg2 }
  rotate <12.528808, 0.0, -134.81398>
  translate  <-0.391069, -0.045599, 0.0>
}


#declare SolidHat = union {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    texture {
      BlackSatin
    }
    hollow
    scale <1.0, 1.0, 1.75>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <1.7, 1.75, 0.1>
    translate  1.75*z
  }
  cylinder { // WhiteTrim
    <0,0,1>, <0,0,0>, 1
    texture {
      WhiteSatin
    }
    hollow
    scale <1.01, 1.01, 0.4>
    translate  1.4*z
  }
}
#declare Rim = difference {
  object { SolidHat }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    scale <0.95, 0.95, 1.7>
    translate  0.16*z
  }
  texture {
    BlackSatin
  }
}
union { // HatHalo
  object { Rim }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Transparent
    }
    halo {
      emitting
      spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0.0 color rgbt <1, 0, 0,  1> ]
        [ 0.4 color rgbt <1, 0.7, 0.3, -1> ]
        [ 0.6 color rgbt <0.2, .5, 1, -1> ]
        [ 1.0 color rgbt <1, 1, 0,  1> ]
      }
      frequency 2
      samples 20
      scale .5
      translate 0.2*z
      //translate -0.2*x
    }
    hollow
    scale <4.0, 4.0, 8.0>
  }
  scale 0.15
  translate  <-0.172523, 0.483074, 0.0>
}


#declare CardBox = difference {
  box { // OuterCardBox
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Back_of_Card
    }
    scale <0.051, 0.081, 0.015>
    translate  0.015*z
  }
  box { // CardBoxHole
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cardboard
    }
    scale <0.0508, 0.081, 0.0148>
    translate  <0.0, -0.0001, 0.015>
  }
}
// Include contains 'flap2'
#include "magic2.in4"

#declare flap2 = object {
  flap2_Raw
  texture {
    Back_of_Card
  }
  scale <0.051, 0.01, 0.0001>
  translate  <0.0, 0.01, -0.0002>
}
// Include contains 'flap3'
#include "magic2.in5"

#declare flap3 = object {
  flap3_Raw
  texture {
    Cardboard
  }
  scale <0.051, 0.01, 0.0001>
  translate  <0.0, 0.01, -0.0001>
}
#declare InnerFlap = union {
  object { flap2 }
  object { flap3 }
  rotate 50.866802*x
  translate  0.029603*z
}
#declare TopFlap = union {
  box { // Flap1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Back_of_Card
    }
    scale <0.051, 0.000025, 0.0148>
    translate  <0.0, 0.000025, 0.0148>
  }
  box { // Flap2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cardboard
    }
    scale <0.051, 0.000025, 0.0148>
    translate  <0.0, 0.000075, 0.0148>
  }
  object { InnerFlap }
  rotate 65.543755*x
  translate  -0.081007*y
}
#declare Box = union {
  object { CardBox }
  object { TopFlap }
}
// Include contains 'CardBack2'
#include "magic2.in6"

#declare CardBack2 = object {
  CardBack2_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  0.001*z
}
// Include contains 'CardBack3'
#include "magic2.in7"

#declare CardBack3 = object {
  CardBack3_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  0.002*z
}
// Include contains 'CardBack4'
#include "magic2.in8"

#declare CardBack4 = object {
  CardBack4_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.00273, 0.003>
}
// Include contains 'CardBack5'
#include "magic2.in9"

#declare CardBack5 = object {
  CardBack5_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.004514, 0.004>
}
// Include contains 'CardBack6'
#include "magic2.i10"

#declare CardBack6 = object {
  CardBack6_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.00294, 0.005>
}
// Include contains 'CardBack7'
#include "magic2.i11"

#declare CardBack7 = object {
  CardBack7_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.004934, 0.006>
}
// Include contains 'CardBack8'
#include "magic2.i12"

#declare CardBack8 = object {
  CardBack8_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.006824, 0.007>
}
// Include contains 'CardBack9'
#include "magic2.i13"

#declare CardBack9 = object {
  CardBack9_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.005249, 0.008>
}
// Include contains 'CardBack10'
#include "magic2.i14"

#declare CardBack10 = object {
  CardBack10_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.003465, 0.009>
}
// Include contains 'CardBack11'
#include "magic2.i15"

#declare CardBack11 = object {
  CardBack11_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.007664, 0.01>
}
// Include contains 'CardBack12'
#include "magic2.i16"

#declare CardBack12 = object {
  CardBack12_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.005039, 0.011>
}
// Include contains 'CardBack13'
#include "magic2.i17"

#declare CardBack13 = object {
  CardBack13_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.008819, 0.012>
}
// Include contains 'CardBack14'
#include "magic2.i18"

#declare CardBack14 = object {
  CardBack14_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.006719, 0.013>
}
// Include contains 'CardBack15'
#include "magic2.i19"

#declare CardBack15 = object {
  CardBack15_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.010079, 0.014>
}
// Include contains 'CardBack16'
#include "magic2.i20"

#declare CardBack16 = object {
  CardBack16_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, 0.00084, 0.015>
}
// Include contains 'CardBack17'
#include "magic2.i21"

#declare CardBack17 = object {
  CardBack17_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.003255, 0.016>
}
// Include contains 'CardBack18'
#include "magic2.i22"

#declare CardBack18 = object {
  CardBack18_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.005354, 0.017>
}
// Include contains 'CardBack19'
#include "magic2.i23"

#declare CardBack19 = object {
  CardBack19_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.008714, 0.018>
}
// Include contains 'CardBack20'
#include "magic2.i24"

#declare CardBack20 = object {
  CardBack20_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.013858, 0.019>
}
// Include contains 'CardBack21'
#include "magic2.i25"

#declare CardBack21 = object {
  CardBack21_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.006824, 0.02>
}
// Include contains 'CardBack22'
#include "magic2.i26"

#declare CardBack22 = object {
  CardBack22_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  translate  <0.0, -0.010814, 0.021>
}
#declare PackOfCards = union {
  object { Box }
  object { CardBack2 }
  object { CardBack3 }
  object { CardBack4 }
  object { CardBack5 }
  object { CardBack6 }
  object { CardBack7 }
  object { CardBack8 }
  object { CardBack9 }
  object { CardBack10 }
  object { CardBack11 }
  object { CardBack12 }
  object { CardBack13 }
  object { CardBack14 }
  object { CardBack15 }
  object { CardBack16 }
  object { CardBack17 }
  object { CardBack18 }
  object { CardBack19 }
  object { CardBack20 }
  object { CardBack21 }
  object { CardBack22 }
  rotate 28.081848*z
}
// Include contains 'CardBack1'
#include "magic2.i27"

#declare CardBack1 = object {
  CardBack1_Raw
  texture {
    Back_of_Card
  }
  scale <0.05, 0.08, 0.001>
  rotate <0.319189, 0.148327, 143.368805>
  translate  <-0.153355, 0.068745, 0.001>
}
// Include contains 'AceOfSpade'
#include "magic2.i28"

#declare AceOfSpade = object {
  AceOfSpade_Raw
  texture {
    Ace_of_Spade
  }
  scale <0.05, 0.08, 0.001>
  rotate 56.930172*z
  translate  <-0.194179, -0.022845, 0.0>
}
union { // cards
  object { PackOfCards }
  object { CardBack1 }
  object { AceOfSpade }
  rotate 97.379616*z
  translate  <-0.181249, -0.114676, 0.0>
}


#declare Calendar = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>,
      <-2.000000, -0.986857, 0.157720>, <-1.000000, -0.986857, 0.157720>, <0.000000, -0.986857, 0.157720>, <1.000000, -0.986857, 0.157720>,
      <-2.000000, 0.696598, 0.302297>, <-1.000000, 0.696598, 0.302297>, <0.000000, 0.696598, 0.302297>, <1.000000, 0.696598, 0.302297>,
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    August
  }
  scale 0.3
  rotate 90.0*x
  translate  <-0.407927, 1.066018, 0.864035>
}
union { // WallAndTable
  box { // Wall
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WallPaper
    }
    scale <5.0, 0.1, 4.0>
    translate  1.168631*y
  }
  box { // TableTop
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood5
    }
    scale <3.0, 2.0, 0.1>
    translate  <0.0, -0.975669, -0.1>
  }
  object { Calendar }
}


// Include contains 'ManYen'
#include "magic2.i29"

object {
  ManYen_Raw
  texture {
    ManSatsu
    scale <1.004929, 0.957126, 0.996803>
    rotate <0.0, 0.0, 22.332588>
  translate <-0.069545, -0.533760, 1.000169>
  }
  scale 0.14
  rotate <90.0, 0.0, 24.585102>
  translate  <0.078032, 0.25061, 0.140947>
}


// Include contains 'BlueTrim'
#include "magic2.i30"

#declare BlueTrim = object {
  BlueTrim_Raw
  texture {
    BlueClockTrim
  }
  scale <0.101, 0.101, 0.005>
  translate  0.1*y
}
#declare casing = difference {
  superellipsoid { // FrontCasing
    <0.1, 0.1>
    texture {
      casiocase
      scale <1.989521, 1.979622, 1.0>
  translate <-1.007640, -0.988262, 0.000000>
    }
    scale <0.1, 0.1, 0.0025>
  }
  superellipsoid { // ClockHole
    <0.1, 0.7>
    texture {
      BlackPlastic
    }
    scale <0.06, 0.025, 0.004>
    translate  <0.0, 0.025, 0.002827>
  }
  cylinder { // BellHoleBig
    <0,0,1>, <0,0,0>, 1
    texture {
      BlackPlastic
    }
    scale <0.025, 0.025, 0.0032>
    translate  <-0.05, -0.05, -0.000107>
  }
  cylinder { // BellHoleSmall
    <0,0,1>, <0,0,0>, 1
    texture {
      BlackPlastic
    }
    scale <0.005, 0.005, 0.01>
    translate  <-0.05, -0.05, -0.005>
  }
  box { // CrossGroove
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackPlastic
    }
    scale <0.105, 0.002, 0.002>
    translate  <0.0, -0.05, 0.001799>
  }
  superellipsoid { // SwitchHole
    <0.5, 0.0001>
    texture {
      BlackPlastic
    }
    scale <0.025, 0.007, 0.0025>
    translate  <0.041794, -0.032013, 0.001213>
  }
  translate  <0.0, 0.1, 0.007>
}
// Include contains 'ClockBack'
#include "magic2.i31"

#declare ClockBack = object {
  ClockBack_Raw
  texture {
    BlackPlastic
  }
  scale <0.103943, 0.093429, 0.2>
  rotate <90.0, -68.814369, -90.0>
  translate  <0.098307, 0.124509, -0.062982>
}
union { // Clock
  cylinder { // Switch1
    <0,0,1>, <0,0,0>, 1
    texture {
      BlackPlastic
    }
    scale <0.008, 0.006, 0.005>
    translate  <0.026677, 0.067987, 0.007>
  }
  cylinder { // Button3
    <0,0,1>, <0,0,0>, 1
    texture {
      BlueClockTrim
    }
    scale <0.002, 0.002, 0.005>
    translate  <0.036994, 0.172, 0.005596>
  }
  cylinder { // Button2
    <0,0,1>, <0,0,0>, 1
    texture {
      BlueClockTrim
    }
    scale <0.007, 0.007, 0.005>
    translate  <0.053, 0.172, 0.005596>
  }
  cylinder { // Button1
    <0,0,1>, <0,0,0>, 1
    texture {
      BlueClockTrim
    }
    scale <0.007, 0.007, 0.005>
    translate  <0.02, 0.172, 0.005596>
  }
  object { BlueTrim }
  box { // BellCross8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackPlastic
    }
    scale <0.025, 0.001, 0.001>
    translate  <-0.05, 0.03013, 0.007771>
  }
  box { // BellCross7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackPlastic
    }
    scale <0.025, 0.001, 0.001>
    translate  <-0.05, 0.03613, 0.007771>
  }
  box { // BellCross6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackPlastic
    }
    scale <0.025, 0.001, 0.001>
    translate  <-0.05, 0.04213, 0.007771>
  }
  box { // BellCross5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackPlastic
    }
    scale <0.025, 0.001, 0.001>
    translate  <-0.05, 0.04813, 0.007771>
  }
  box { // BellCross4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackPlastic
    }
    scale <0.025, 0.001, 0.001>
    translate  <-0.05, 0.05413, 0.007771>
  }
  box { // BellCross3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackPlastic
    }
    scale <0.025, 0.001, 0.001>
    translate  <-0.05, 0.06013, 0.007771>
  }
  box { // BellCross2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackPlastic
    }
    scale <0.025, 0.001, 0.001>
    translate  <-0.05, 0.06613, 0.007771>
  }
  box { // BellCross1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackPlastic
    }
    scale <0.025, 0.001, 0.001>
    translate  <-0.05, 0.07213, 0.007771>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LCD
      scale <2.00181, 1.971905, 1.0>
  translate <-1.002578, -0.993212, 0.000000>
    }
    scale <0.05, 0.018, 0.003>
    translate  <0.0, 0.125, 0.009658>
  }
  object { casing }
  object { ClockBack }
  rotate <68.814369, 0.0, -2.97643>
  translate  <0.120289, 0.348839, 0.0>
}


plane { // Plane001
  z,0
  texture {
    Texture01
  }
  translate  -3.30452*z
}


