
// Persistence of Vision Ray Tracer Scene Description File
// File: magic.pov
// Vers: 3
// Desc: Software Development Lab
// Date: 7/27/97
// Auth: Ray Benjamin


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// ==== Additional Includes ====
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"

#declare Inch = 1/12;

#declare Atmosphere_On = 0;
#declare All_Lights = 1;
#declare Composition_Lights = 1;
#declare Detail_On = 1;
#declare ShowShelves = 1;
#declare Simple = 0;
#declare Ceiling_On = 1;
#declare Wall_Texture_On = 1;
#declare Engraving_On = 1;
#declare Candle_Agate = 0;
#declare Smoke_On = 1;
#declare Bits_On = 1;

camera
{
  location  <0.0 , 0.0 , 0.0>
  look_at   <0.0 , 0.0 , 1.0>
//  rotate <90,0,0> translate <0,15,0> // overhead
  rotate <0,24,0>   translate <-1.3,.85,-3>  // Close in Camera
//  rotate <12,10,0>   translate <-1,5,-10> // Scene camera position
//  rotate <0,10,0>   translate <-1,5,-20> // distant Scene camera position
//  rotate <0,0,0> translate <0,2,2> // look at candle
}

#if (Simple = 0)
global_settings {
    radiosity {
        distance_maximum 11
        }
    }
#end

#if (Atmosphere_On = 1)
    atmosphere {
        type 4          // s/b 4
        samples 70
        distance 100000
        scattering 0.05
        aa_level 4
        aa_threshold 0.1
        jitter 0.2
      }
#end

#if (Composition_Lights)

    // create a regular point light source
    light_source
        {
        0*x // light's position (translated below)
        color White  // light's color
        fade_distance 9
        fade_power 2
        translate <0, 7, -9>
//        atmospheric_attenuation on
        }


light_source { // low level light
    0*x
    color White * .5
    fade_distance 5
    fade_power 2
    translate <-1,1,-9>
//    shadowless
    atmospheric_attenuation on
    }
#end


#if (All_Lights = 1)

    // Lightning
    light_source
        {
        0*x                     // light's position (translated below)
        color rgb <1,1,1.2>*1       // light's color
        spotlight               // this kind of light source
        translate <10, 70, 100> // <x y z> position of light
        point_at <0, 0, 0>      // direction of spotlight
        radius 5                // hotspot (inner, in degrees)
        tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
        falloff 8               // intensity falloff radius (outer, in degrees)
        atmospheric_attenuation on
        }
#end

sky_sphere {
    S_Cloud4
    }

// Smoke!
#declare Smoke_Halo = halo
         {
           dust
           dust_type 4
           poly
           exponent 6
           cylindrical_mapping
           max_value 1
           colour_map
           {
             [ 0 color rgbt <1,1,1,1> ]
             [ .2 color rgbt <1,1,1,.5>]
             [ 1 color rgbt <1,1,1,-1> ]
           }
           samples 30
           aa_level 5
           aa_threshold 0.1
           jitter 0.8
           frequency 2
           turbulence 4
//           octaves 3
//           lambda 4
           omega .2
           translate <0,1,0>
           scale 1
         }

#declare Smoke_Texture = texture {
   pigment {Clear}
   halo {Smoke_Halo}
   }

#declare Smoke = union {
//   sphere {<0,0,0>, 1
   cone {<0,0,0>, .15, <0,2.7,0> 1.4
         hollow
         texture {Smoke_Texture }
         no_shadow
         }
//   scale <2.7,7,2.7>
   }

#include "candle.inc"

#declare Wall = union {

    #if (Wall_Texture_On = 1)
    difference {
        height_field {
            tga "stonefloor.tga"
            smooth
            texture {T_Grnt1 scale .25} // or T_Grnt1 or 9?
            translate <-.5, -.26, -.5>
            scale <20, .5, 19.5>
            }
         box {<0,-1,0>, <3,1,4.1> pigment {Clear} no_shadow hollow translate <-3,0,3.5>} // hole
         }
     #end
     difference {
         box {<-10,-.5,-10>, <10,-.05,10> pigment {Gray70}}
         box {<0,-1,0>, <3,1,4.1> pigment {Clear} no_shadow hollow translate <-3,0,3.5>} // hole
         }

     rotate <-90,0,0>
     }

#declare T_Stone_Floor = texture {
    crackle
    texture_map {
        [0 pigment {Black} finish { roughness 2 diffuse .2}]
        [0.05 pigment {Gray50*1.2} finish { roughness 2 diffuse .2}]
        [1.0 pigment {White*1.2} finish { roughness 2 diffuse .2}]
        }
     scale 2
     }

#declare Floor = union {
    #if (Wall_Texture_On = 1)
    height_field {
        tga "stonefloor.tga"
        smooth
        texture {T_Grnt1 scale .25} // or T_Grnt1 or 9?
        translate <-.5, -.26, -.5>
        scale <20, .5, 20>
        }
    #end
    box {<-10,-1,-10>, <10,-.05,10> pigment {White}}
    }

// plane {y,0 texture {T_Stone_Floor}} // Ground

#declare R1 = seed(1)
#declare True = 1
#declare False = 0
#declare NumBooks=20
#declare RowLength = 3

#if (ShowShelves = 1)
    #declare Book_Shelf = box {<.01,0,0>, <RowLength+.1-.01,.15,.9> texture {T_Wood2}}

    #declare Book_Shelves = union {
        box { <0,.5,.8>, <RowLength+.22,4,.9> texture {T_Wood1}}
        box { <0,0,0>, <.1,4,.9> texture {T_Wood3}}
        box { <RowLength+.01,0,0>, <RowLength+.11,4,.9> texture {T_Wood3}}
        object { Book_Shelf translate <0,.5,0> }
        object { Book_Shelf translate <0,1.5,0> }
        object { Book_Shelf translate <0,2.5,0> }
        object { Book_Shelf translate <0,3.5,0> }

        #declare shelf_count = 0
        #declare num_shelves = 4
        #while (shelf_count < num_shelves)

           #declare StackStyle=0
           #declare Y_pos = (.5 + 1*shelf_count)
           object { #include "Books.inc" translate <.1,Y_pos, .1>}

           #declare shelf_count = shelf_count + 1
        #end
}
#end

#declare Book_Stack = union {
         #declare NumBooks=5
         #declare RowLength = .95
         #declare StackStyle=2 // messy stack
         #include "Books.inc"
         }


#declare Magic_Circle = union {
    difference {
        cylinder {<0,-1,0>, <0,.01,0>, 4
            texture {T_Silver_1C}
            finish {ambient .5}
            }
        cylinder {<0,-1.1,0>, <0,.11,0>, 3.5
            texture {T_Silver_1C}
            finish {ambient .5}
            }
        }
    }

#declare Width = .25
#declare Length = 8

#declare PentaBar1 = difference {
    box {<0,0,0>, <Length-.5,.25,1> texture {T_Silver_1C} finish {ambient .5}}
#if (Engraving_On = 1)
    text { ttf "timrom.ttf" "copyright 1997, Ray Benjamin, all rights reserved" 0.15, 0
      texture {T_Silver_1C}
      finish { ambient .5 }
      scale .20
      translate <1,.05,-.02>
      }
#end
  rotate <90,0,0>
  translate <0,0,-Width>
  rotate <0,-90,0>
  translate <-.25,0,-Length/2>
  }

#declare PentaBar2 = difference {
    box {<0,0,0>, <Length-.5,.25,1> texture {T_Silver_1C} finish {ambient .5}}
#if (Engraving_On = 1)
    text { ttf "fonts\Gaeil1.ttf" "MAGICSOFT" 0.15, 0
      texture {T_Silver_1C}
      finish { ambient .5 }
      scale .15
      translate <3,.05,-.02>
      }
#end
  rotate <90,0,0>
  translate <0,0,-Width>
  rotate <0,-90,0>
  translate <-.25,0,-Length/2>
  }

#declare Pentagram = union {
    union {
        object {PentaBar1 rotate <0,-18,0> translate <5.25,0,-Length/2+.5>}
        object {PentaBar2 rotate <0,18,0> translate <3,0,-Length/2+.5>}
        rotate <0,0,0>
        translate <0,0,Length/2>
        }
    object {PentaBar2 rotate <0,90,0> translate <4.2,0,Length/8+2*Inch>}
    object {PentaBar2 rotate <0,55,0> translate <5,0,Length/8+4*Inch - 2.2>}
    object {PentaBar2 rotate <0,180-55,0> translate <3.6,0,Length/8+4*Inch -2.7>}
    rotate <0,0,0>
    translate <-Length/2,0,0>
    }


// Room Walls & Windows

#declare WindowBox = union {
    box {<0,0,0>, <3.5,.5,1> texture {T_Wood3 rotate <90,0,90> scale 1}}
    box {<0,.51,0>,<.5,4,1> texture {T_Wood3 rotate <90,0,0> scale 1}}
    box {<3,.51,0>,<3.5,4,1> texture {T_Wood3 rotate <90,0,0> scale 1}}
    box {<0,4.01,0>,<3.5,4.5,1> texture {T_Wood3 rotate <90,0,90> scale 1}}
    }

#declare Beam = box {<0,0,0>, <.5,.7,20> texture {T_Wood3} rotate <0,180,0>}
#declare RoofPlank = box {<0,0,0>, <1.97,.1,20> texture {T_Wood3} rotate <0,90,0>}

object {Floor}

#declare WindowWall = union {
    object {Wall}
    object {WindowBox translate <-3,3.5,-.5>}
    }


object {WindowWall translate <0,0,10>}
object {WindowWall rotate <0,90,0> translate <9.5,0,0>}
object {WindowWall rotate <0,-90,0> translate <-10,0,0>}
object {WindowWall rotate <0,180,0> translate <-10,0,-10>}

// Ceiling
#declare Ceiling = union {
    union {
        object {Beam translate <0,0,0>}
        object {Beam translate <4,0,0>}
        object {Beam translate <8,0,0>}
        object {Beam translate <10,0,0>}
        object {Beam translate <-4,0,0>}
        object {Beam translate <-8,0,0>}
        object {Beam translate <-10,0,0>}
        object {RoofPlank translate <-10,.7,0>}
        object {RoofPlank translate <-10,.7,-2>}
        object {RoofPlank translate <-10,.7,-4>}
        object {RoofPlank translate <-10,.7,-6>}
        object {RoofPlank translate <-10,.7,-8>}
        object {RoofPlank translate <-10,.7,-10>}
        object {RoofPlank translate <-10,.7,-12>}
        object {RoofPlank translate <-10,.7,-14>}
        object {RoofPlank translate <-10,.7,-16>}
        object {RoofPlank translate <-10,.7,-18>}
        object {RoofPlank translate <-10,.7,-20>}
        rotate <15,0,0>
        }
    object {Beam translate <9.9,.5,0>}
    }
#include "magicbox.inc"

#if (Ceiling_On)
    object {Ceiling translate <0,8.5,12>}
#end
object {Pentagram translate <0,0,0>}
object {Candle translate <0,0,3.75>}
object {Candle translate <0,0,3.75> rotate <0,72,0>}
object {Candle translate <0,0,3.75> rotate <0,-72,0>}
object {Candle translate <0,0,3.75> rotate <0,144,0>}
object {Candle translate <0,0,3.75> rotate <0,-144,0>}
object {Magic_Circle translate <0,0,0>}

object {MagicSoft translate <-5*Inch,-.02,-5.*Inch>}
object {GUI rotate <90,180,0> translate <1.8,0.05,-.8>}
object {TCPIP rotate <90,0,0> translate <-1,0.05,-1>}

#if (ShowShelves = 1)
    object {Book_Shelves translate <5.5,0,8>}
    object {Book_Stack translate <5,0,5>}
#end



/*
// Debug Camera

camera
{
  location  <0.0 , 0.0 , 0.0>
  look_at   <0.0 , 0.0 , 1.0>
  rotate <0,0,0> translate <0,1,-5> rotate <0,10,0> // look at candle
}

object {Candle}
*/
