// candle.inc
//

// Smoke!
#declare Smoke_Halo = halo
         {
           dust
           dust_type 4
           poly
           exponent 6
           cylindrical_mapping
           max_value .8
           colour_map
           {
             [ 0 color rgbt <1,1,1,1> ]
             [ .2 color rgbt <1,1,1,.5>]
             [ 1 color rgbt <1,1,1,-1> ]
           }
           samples 100
           aa_level 5
           aa_threshold 0.1
           jitter 0.8
           frequency 2
           turbulence 4
           octaves 3
           lambda 4
           omega .2
           translate <0,1,0>
           scale 1
         }

#declare Smoke_Texture = texture {
   pigment {Clear}
   halo {Smoke_Halo}
   }

#declare Smoke = union {
   sphere {<0,0,0>, 1
//   cone {<0,0,0>, .15, <0,2.7,0> 1.4
         hollow
         texture {Smoke_Texture }
         no_shadow
         }
   scale <.75,1,.25>
   }

#declare Smoke_0 = object {			// smoke
    blob {
	    threshold 0.7
		component 1.0, 0.07, <0, -0.035, 0>
		component 1.0, 0.09, <-0.0625, 0.035, 0>
		component 1.0, 0.09, <0, 0.07, -0.0625>
		component 1.0, 0.1, <0.0625, 0.105, 0>
		component 1.0, 0.1, <0, 0.14, 0.0625>
		component 1.0, 0.1, <-0.0625, 0.175, 0>
		component 1.0, 0.1, <0, 0.21, -0.0625>
		component 1.0, 0.1, <0.0625, 0.245, 0>
		component 1.0, 0.1, <0, 0.28, 0.0625>
		}
    texture {
		pigment {
			marble
			color_map {
				[0.0 0.4 color rgbf <1, 1, 1, 1> color rgbf <0.9, 0.9, 0.9, 0.65>]
				[0.4 1.0 color rgbf <1, 1, 1, 0.7> color rgbf <1, 1, 1, 1>]
				}
			turbulence 0.8
			}
		finish { phong 0.2}
		}
	scale <0.3*2, 1.6*4, 0.5*2>
    translate <0,.05,0>
//	rotate -z*17
	}

#declare Smoke_1 = object {                    			// smoke
	blob {
		threshold 0.7
		sphere {<0, -0.035, 0>, 1.0, 0.07}
		sphere {<-0.0625, 0.035, 0>, 1.0, 0.09}
		sphere {<0, 0.07, -0.0625>, 1.0, 0.09 }
		sphere {<0.0625, 0.105, 0>, 1.0, 0.1}
		sphere {<0, 0.14, 0.0625>, 1.0, 0.1}
		sphere {<-0.0625, 0.175, 0>, 1.0, 0.1 }
		sphere {<0, 0.21, -0.0625>, 1.0, 0.1 }
		sphere {<0.0625, 0.245, 0>, 1.0, 0.1 }
		sphere {<0, 0.28, 0.0625>, 1.0, 0.1 }
        sphere {<-0.0725,.28,0>, 1.0, 0.1 }

/*
        #declare R1 = seed(1)
        #declare PI = 3.141527
        #declare Count = -PI/2
        #declare Increment = PI/32
        #declare Max = 40
        #while (Count < Max)
            #declare Angle = rand(R1)*PI - PI/2
            #debug concat ("Angle is ", str(Angle,5,2))
            #debug " "
            #debug concat ("Cos is ",str(cos(Angle),5,2))
            #debug " "
            #debug concat ("Sin is ",str( sin(Angle),5,2))
            #debug "\n"
            sphere {<sin(Angle)*2,cos(Angle)*2,0>, 1.0, 0.13}
            #declare Count = Count + 1
        #end
        translate <-2,0,0>
*/
    }
    hollow
//    texture {Smoke_Texture}
	texture {
		pigment {
			marble
			color_map {
		    	[0.0 0.4 color rgbf <1, 1, 1, 1> color rgbf <0.9, 0.9, 0.9, 0.65>]
			    [0.4 1.0 color rgbf <1, 1, 1, 0.7> color rgbf <1, 1, 1, 1>]
			    }
			turbulence 0.8
		    }
		finish { phong 0.2}
	    }

	translate <0, 0.07, 0>
	scale <0.3*4, 1.6*4, 0.5*4>
	rotate <0,0,0>
    }

#declare Flame_Halo = halo
         {
           glowing
           dust_type 2
           poly
           exponent 2
           planar_mapping
           max_value 1
           colour_map
           {
             [ .0 color rgbt <1,1,1,1> ] // clear
             [ .24 color rgbt <1,1,1,1>] // clear
             [ .25 color rgbf <1,0,0,.1>*2 ] // red
             [ .3 color rgbf <1,0,0, .1>*2 ] // red
             [ .4 color rgbf <1,.5,.1, .2>*2] // orange
             [ .45 color rgbf <1,.5,.1, .4>*2] // orange
             [ .75 color rgbf <1,1,0, .1>*3 ] // yellow
             [ .89 color rgbf <1,1,1, .8>*3 ] // white
             [ .99 color rgbf <0,0,1,.1> ] // blue
           }
           samples 100
           aa_level 5
           aa_threshold 0.1
           jitter 0.8
           frequency 1
           turbulence 3.5
         }
#declare Candle_Flame_Halo = halo
         {
           glowing
           dust_type 2
           poly
           exponent 2
           planar_mapping
           max_value 1.0
           colour_map
           {
             [ .0 color rgbt <1,1,0,0.8> ]
             [ .05 color rgbt <1,1,1,1> ]
             [ .2 color rgbt <1,0,0, .4> ]
             [ .21 color rgbt <1,1,1,1> ]
             [ .3 color rgbt <1,.5,.1, .3> ]
             [ .31 color rgbt <1,1,1,1> ]
             [ .7 color rgbt <1,1,0, .1> ]
             [ .71 color rgbt <1,1,1,1> ]
             [ .8 color rgbt <1,1,1, .1> ]
           }
           samples 10
           aa_level 5
           aa_threshold 0.1
           jitter 0.8
           frequency .7
           turbulence .3
         }


#declare Candle_Flame_Halo2 = halo
         {
           emitting
           dust_type 2
           poly
           exponent 2
           spherical_mapping
           max_value 1.0
           colour_map
           {
             [ .0 color rgbt <1,1,0,0.8> ]
             [ .05 color rgbt <1,1,1,1> ]
             [ .2 color rgbt <1,0,0, .4> ]
             [ .21 color rgbt <1,1,1,1> ]
             [ .3 color rgbt <1,.5,.1, .3> ]
             [ .31 color rgbt <1,1,1,1> ]
             [ .7 color rgbt <1,1,0, .1> ]
           }
           samples 10
           aa_level 5
           aa_threshold 0.1
           jitter 0.8
           frequency .7
           turbulence .3
           scale .3
         }

#declare Candle_Flame_Texture = texture {
   pigment {Clear}
   halo {Candle_Flame_Halo}
   halo {Candle_Flame_Halo2}
   }

#declare Candle_Flame = union {
   sphere { 0, 1
         hollow
         texture {Candle_Flame_Texture }
         no_shadow
         }
   scale <.5,2,.3>
   scale .1
   }

#declare Flame_Offset = .06 // .07
#declare Candle = union {
    difference {
        cylinder {<0,0,0>, <0,.5,0> .15 pigment {rgbft<1,1,1,.1,.05>} finish {ambient .5}}
        sphere {<0,.5,0>, .14 pigment {rgbft<1,1,1,.1,.1>} finish {ambient .7}}
        }
   cylinder {<0,.5-.14,0>, <0,.53,0> .007 pigment {Brown}}
   object {Candle_Flame finish {ambient 1} translate <0,.5+Flame_Offset,0>}
   light_source {
      <0,.5+Flame_Offset,0>
      White*.35 + Yellow*.15
      fade_distance 3
      fade_power 2
      atmospheric_attenuation on
      }
/*
   sphere {<0,.5+Flame_Offset,0>, .02
        pigment {
            agate
            agate_turb .25
            color_map
                {
                [ .0 color rgbt <1,1,0,0.9> ]
                [ .05 color rgbt <1,1,1,1> ]
                [ .2 color rgbt <1,0,0, .5> ]
                [ .21 color rgbt <1,1,1,1> ]
                [ .3 color rgbt <1,.5,.1, .4> ]
                [ .31 color rgbt <1,1,1,1> ]
                [ .7 color rgbt <1,1,0, .2> ]
                [ .71 color rgbt <1,1,1,1> ]
                [ .8 color rgbt <1,1,1, .2> ]
                }
            scale <.005,4,.007>
            }
        finish {ambient 1}
        hollow
        }
*/
    object {Smoke_0 translate <0,.75,0>}
   }
