#include "colors.inc"
#include "textures.inc"
#include "chars.inc"

//camera {location <0,10,-50> look_at <0,10,0>}
camera {location <0,4,-10> look_at <0,4,0>}
light_source {<80,80,-80> color White}
global_settings { ambient_light color White }



////////////////////////////////////////////////////////// New Textures

#declare Gold_Ref= texture {pigment{color BrightGold} finish{Metal}}
#declare Silver_Ref= texture {pigment{color Silver} finish{Metal}}
#declare Shrine_Tex1= texture {pigment{White_Marble } finish{phong 0.1}}
#declare Shrine_Tex2= texture {pigment{granite } finish{phong 0.1}}
#declare HighShine= finish{
            metallic
            ambient 0.1
            diffuse 0.8
            brilliance 6.0
            reflection 0.4
            phong 0.8
            phong_size 120
}
#declare BrightShine= finish{
            metallic
            ambient 1
            diffuse 0
            brilliance 6.0
            reflection 0.4
            phong 0.8
            phong_size 120
}


#declare PillarStageOne = union {
   cylinder {<0,0.5,0>,<0,8.5,0>,.1 translate <1,0,0>}
   sphere {<0,0.5,0>,.1 translate <1,0,0>}
   sphere {<0,8.5,0>,.1 translate <1,0,0>}
}

#declare PillarStageTwo=union{
   object{PillarStageOne rotate<0,30,0>}
   object{PillarStageOne rotate<0,60,0>}
   object{PillarStageOne rotate<0,90,0>}
   object{PillarStageOne rotate<0,120,0>}
   object{PillarStageOne rotate<0,150,0>}
   object{PillarStageOne rotate<0,180,0>}
   object{PillarStageOne rotate<0,210,0>}
   object{PillarStageOne rotate<0,240,0>}
   object{PillarStageOne rotate<0,270,0>}
   object{PillarStageOne rotate<0,300,0>}
   object{PillarStageOne rotate<0,330,0>}
   object{PillarStageOne rotate<0,360,0>}
}

#declare PillarStageThree = difference{
   cylinder{<0,0,0>,<0,10,0>,1 }
   object{PillarStageTwo translate<0,.5,0>}
}

#declare PillarStageFour = union{
   object{PillarStageThree}
   torus{1,0.5 translate<0,0,0>}
   torus{1,0.5 translate<0,10,0>}
}


#declare Pillar = object{
   PillarStageFour
   bounded_by { box {<-2,0,-2>,<2,11,2>} }
   clipped_by { bounded_by }
}

/////////////////////////////////////////////////////////////////////////

#declare ArchStageOne = union{
   object{ Pillar translate<-5,0,0> }
   object{ Pillar translate<5,0,0> }
}

#declare ArchStageTwo= object {
   object { ArchStageOne }
}

/////////////////////////////////////////////////////////////////////////

#declare CircleStageOne = object{
   object {Pillar translate <-20,0,0>}
}

#declare CircleStageTwo = union{
   object{CircleStageOne rotate<0,30,0>}
   object{CircleStageOne rotate<0,60,0> no_shadow }
   object{CircleStageOne rotate<0,90,0> no_shadow }
   object{CircleStageOne rotate<0,120,0>}
   object{CircleStageOne rotate<0,150,0>}
   object{CircleStageOne rotate<0,180,0>}
   object{CircleStageOne rotate<0,210,0>}
   object{CircleStageOne rotate<0,240,0>}
   object{CircleStageOne rotate<0,270,0>}
   object{CircleStageOne rotate<0,300,0>}
   object{CircleStageOne rotate<0,330,0>}
   object{CircleStageOne rotate<0,360,0>}
}

#declare PillarCircle = object{
   object{CircleStageTwo rotate<0,15,0>}
}

/////////////////////////////////////////////////////////////////////////

#declare DomeStageOne = difference{
   sphere { <0,10,0>,21 }
   sphere { <0,10,0>,19 }
   box { <-21,-21,-21>,<21,10.5,21> }
   box { <-21,13,-21>,<21,21,21> }
   bounded_by { box { <-21,10,-21>,<21,14,21> } }
   clipped_by { bounded_by }
}

#declare DomeStageTwo = difference{
   sphere { <0,10,0>,20 }
   sphere { <0,10,0>,18 }
   box { <-21,-21,-21>,<21,13,21> }
   box { <-21,15,-21>,<21,21,21> }
   bounded_by { box { <-21,12,-21>,<21,16,21> } }
   clipped_by { bounded_by }
}

#declare DomeStageThree = difference{
   sphere { <0,10,0>,19 }
   sphere { <0,10,0>,17 }
   box { <-21,-21,-21>,<21,15,21> }
   box { <-21,17,-21>,<21,21,21> }
   bounded_by { box { <-21,14,-21>,<21,18,21> } }
   clipped_by { bounded_by }
}

#declare DomeStageFour = union {
   object { DomeStageOne texture { Shrine_Tex1 scale<4,4,4> rotate<0,0,80> } }
   object { DomeStageTwo texture { Shrine_Tex1 scale<4,4,4> rotate<0,0,80> rotate<0,45,0>} }
   object { DomeStageThree texture { Shrine_Tex1 scale<4,4,4> rotate<0,0,80> rotate<0,-45,0>} }
}

#declare DomeStageFive = object {
   cylinder { <0,5,-25>,<0,5,25>,7.25 }
}

#declare DomeStageSix = union {
   object { DomeStageFive rotate<0,30,0> }
   object { DomeStageFive rotate<0,60,0> }
   object { DomeStageFive rotate<0,90,0> }
   object { DomeStageFive rotate<0,120,0> }
   object { DomeStageFive rotate<0,150,0> }
   object { DomeStageFive rotate<0,180,0> }
}

#declare Runic_A=union{
   cylinder{<-1.5,0,0>,<-1.5,5,0>,0.5}
   cylinder{<-1.5,4.5,0>,<1.5,3.5,0>,0.5}
   cylinder{<-1.5,3,0>,<1.5,2,0>,0.5}
}

#declare Runic_V=union{
   cylinder{<-1.5,0,0>,<-1.5,5,0>,0.5}
   cylinder{<-1.5,4.5,0>,<1.5,3.5,0>,0.5}
   cylinder{<1,3.5,0>,<1,0,0>,0.5}
}

#declare Runic_L=union{
   cylinder{<-1.5,0,0>,<-1.5,5,0>,0.5}
   cylinder{<-1.5,4.5,0>,<1.5,3.5,0>,0.5}
}

#declare Runic_N=union{
   cylinder{<0,0,0>,<0,5,0>,0.5}
   cylinder{<-1.5,4,0>,<1.5,2,0>,0.5}
}

#declare Runic_O=union{
   cylinder{<-1.5,0,0>,<1.5,2.5,0>,0.5}
   cylinder{<-1.5,2.5,0>,<1.5,0,0>,0.5}
   cylinder{<-1.5,2.5,0>,<0,4.5,0>,0.5}
   cylinder{<1.5,2.5,0>,<0,4.5,0>,0.5}
}

#declare DomeStageSeven = difference {
   object { DomeStageFour }
   object { DomeStageSix }
}

#declare Dome = union {
   object {DomeStageSeven}
   object {Runic_A scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,-25,0> texture{Bronze_Metal}}
   object {Runic_V scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,-15,0> texture{Bronze_Metal}}
   object {Runic_A scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,-5,0> texture{Bronze_Metal}}
   object {Runic_L scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,5,0> texture{Bronze_Metal}}
   object {Runic_O scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,15,0> texture{Bronze_Metal}}
   object {Runic_N scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,25,0> texture{Bronze_Metal}}

   object {Runic_A scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,-85,0> texture{Bronze_Metal}}
   object {Runic_V scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,-75,0> texture{Bronze_Metal}}
   object {Runic_A scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,-65,0> texture{Bronze_Metal}}
   object {Runic_L scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,-55,0> texture{Bronze_Metal}}
   object {Runic_O scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,-45,0> texture{Bronze_Metal}}
   object {Runic_N scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,-35,0> texture{Bronze_Metal}}

   object {Runic_A scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,35,0> texture{Bronze_Metal}}
   object {Runic_V scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,45,0> texture{Bronze_Metal}}
   object {Runic_A scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,55,0> texture{Bronze_Metal}}
   object {Runic_L scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,65,0> texture{Bronze_Metal}}
   object {Runic_O scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,75,0> texture{Bronze_Metal}}
   object {Runic_N scale<0.3,0.3,0.3> translate<0,10,19.7> rotate<-9.9,85,0> texture{Bronze_Metal}}
}
/////////////////////////////////////////////////////////////////////////

#declare FloorStageOne = union {
   cylinder { <0,0,0>,<0,.5,0>,25 }
   cylinder { <0,.5,0>,<0,1,0>,24 }
   cylinder { <0,1,0>,<0,1.5,0>,23 }
   cylinder { <0,1.5,0>,<0,2,0>,22 }
}

#declare Floor = object{
   object { FloorStageOne }
}

/////////////////////////////////////////////////////////////////////////

#declare Shrine = union {
   object { PillarCircle translate<0,2,0> texture { Shrine_Tex1 scale<4,4,4>} }
   object { Dome translate<0,2,0> }
   object { Floor texture { Shrine_Tex1 scale<4,4,4>} }
}

/////////////////////////////////////////////////////////////////////////

#declare EnchantedRingsStageOne = union{
   disc {<0,0,0>,<0,1,0>,3.5,3.2 rotate<30,30,0> translate<0,2,0>}
   disc {<0,0,0>,<0,1,0>,3.5,3.2 rotate<-30,30,0> translate<0,4,0>}
}

#declare EnchantedRings = union{
   object {EnchantedRingsStageOne rotate<0,120,0>}
   object {EnchantedRingsStageOne rotate<0,240,0>}
   object {EnchantedRingsStageOne rotate<0,360,0>}
}
////////////////////////////////////////////////////////////// Anvil

#declare anvil_phase_one=merge{
   box{<-1.5,0,-1.5>,<1.5,2,1.5>}
   sphere {<1.5,2,0>,.8}
   cone {<-1.5,2,0>,.8,<-3.5,2,0>,.25}
   sphere {<-3.5,2,0>,.25}
}

#declare anvil=difference{
   object {anvil_phase_one}
   cylinder{<-1.5,.75,-1.5>,<1.5,.75,-1.5>,.5}
   cylinder{<1.5,.75,-1.5>,<1.5,.75,1.5>,.5}
   cylinder{<1.5,.75,1.5>,<-1.5,.75,1.5>,.5}
   cylinder{<-1.5,.75,1.5>,<-1.5,.75,-1.5>,.5}
   box {<-4,2,-2>,<3,4,2>}
}

///////////////////////////////////////////////////////////// Sword

#declare sword_cut_one=union{
   box{<0.5,0.03,2>,<-0.5,0.4,-2> rotate <0.01,0,-10>}
   box{<0.5,0.03,2>,<-0.5,0.4,-2> rotate <0.01,0,10>}
   box{<0.5,-0.4,2>,<-0.5,-0.03,-2> rotate <-0.01,0,-10>}
   box{<0.5,-0.4,2>,<-0.5,-0.03,-2> rotate <-0.01,0,10>}
   box{<0.5,0.03,2>,<-0.5,0.4,-2> rotate <5,0,-10> translate z*1.25}
   box{<0.5,0.03,2>,<-0.5,0.4,-2> rotate <5,0,10> translate z*1.25}
   box{<0.5,-0.4,2>,<-0.5,-0.03,-2> rotate <-5,0,-10> translate z*1.25}
   box{<0.5,-0.4,2>,<-0.5,-0.03,-2> rotate <-5,0,10> translate z*1.25}
}

#declare sword_phase_one=difference{
   box{<0.4,-0.3,1.9>,<-0.4,0.3,-1.8>}
   object {sword_cut_one}
}

#declare sword_hilt_one=difference{
   box{<-0.75,0,-0.3>,<0.75,0.1,0.3>}
   box{<-0.8,0.1,-0.4>,<0.8,0.3,0.4> rotate z*10}
   box{<-0.8,0.1,-0.4>,<0.8,0.3,0.4> rotate z*-10}
}

#declare sword_hilt_cut_one=union{
   box{<-0.8,0.1,-0.4>,<0.8,0.3,0.4> rotate <90,10,0>}
   box{<-0.8,0.1,-0.4>,<0.8,0.3,0.4> rotate <90,-10,0>}
   box{<-0.8,0.1,-0.4>,<0.8,0.3,0.4> rotate <-90,10,0>}
   box{<-0.8,0.1,-0.4>,<0.8,0.3,0.4> rotate <-90,-10,0>}
}

#declare sword_hilt_two=difference{
   object {sword_hilt_one}
   object {sword_hilt_cut_one}
}

#declare sword_phase_two=union{
   object {sword_hilt_two
      texture {Gold_Ref}
      translate y*1.45
      scale <1.4,1,1>
   }
   object {sword_phase_one
      texture {Silver_Ref}
      rotate x*90
      scale <1,1.1,1.1>
      translate <0,-0.5,0>
   }
   sphere {<-0.7,1.46,0>,.1 texture {Gold_Ref}}
   sphere {<0.7,1.46,0>,.1 texture {Gold_Ref}}
}

#declare grip=union{
   cone {<0,1.55,0>,0.125,<0,1.7,0>,0.12}
   cylinder {<0,1.7,0>,<0,2.4,0>,0.12}
   cone {<0,2.4,0>,0.12,<0,2.6,0>,0.10}
}

#declare pommel=union{
   cone {<0,2.6,0>,0.10,<0,3,0>,0}
   cylinder {<0,3,0.05>,<0,3,-0.05>,0.14}
   sphere {<0,3,0>,.12 pigment{Jade} finish {phong 1}}
}

#declare sword=union{
   light_source {<0,1.45,-1> color White }
   object {sword_phase_two}
   object {grip pigment {DMFDarkOak}}
   object {pommel texture {Gold_Ref}}
   sphere { 0, 2
      pigment { color rgbt <1, 1, 1, 1> }
      halo {
         emitting
         spherical_mapping
         linear
         color_map {
           [ 0 color rgbt <1, 1, 1, 1.0> ]
           [ 0.5 color rgbt <0, 0, 0, 0.0> ]
         }
         samples 10
      }
      hollow
      translate <0,0.8,0>
      scale <2,2,0.01>
   }
   no_shadow
}
/////////////////////////////////////////////////////////////////////////
#declare Sky=object{
   sphere {<0,0,0>,9000
      texture {
         Starfield
         rotate<0,-45,0>
         scale<100,100,100>
      }
      clipped_by { box { <-10000,-10000,0>,<10000,10000,10000> } }
   }
}
/////////////////////////////////////////////////////////////////////////
#declare LandStageOne=object{
   height_field {
     gif "c:\images\mine1.gif"
     hierarchy
     //smooth
     //[ water_level FLOAT ]
     translate <-0.5,-0.5,-0.5>
     rotate<0,180,0>
     translate <0,0,1>
     scale<250,50,200>
     pigment { Brown }
   }
}

#declare LandStageTwo=object{
   height_field {
      gif "c:\images\mine1.gif"
      hierarchy
      //smooth
      water_level 0.0
      translate <-0.5,-0.5,-0.5>
      rotate<0,180,0>
      translate <0,0,1>
      scale<250,50,200>
      pigment {
         gradient y
         color_map {
            [0.15 color DarkBrown ]
            [0.9  color White]
         }
         scale<1,40,1>
         translate<0,-9,0>
      }
   }
}

#declare Land=union{
   object { LandStageOne }
   object { LandStageTwo translate<0,0.0000001,0>}
}

/////////////////////////////////////////////////////////////////////////

#declare Scene=union{
   object { Land }
   object { Sky  }
   object { Shrine pigment { granite scale<.50,.50,.50> } }
   object { EnchantedRings translate<0,2,0> texture { Lightening2 } }
   object { anvil translate<0,2,0> texture { pigment{ Black } finish { HighShine } } }
   object { sword translate<0,5,0> finish{Luminous} }
}

/////////////////////////////////////////////////////////////////////////

object {Scene}








