
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: MALE BODY
// Date: 26.08.1997
// Auth: NB

// #declare SIDE = 1 // 1=left, -1=right, don't even try other values

#declare HR_02 = .65
#declare HS_02 = 3
#declare HD_02 = HS_02*pow((1-pow(HR_02,2)),2)
#declare LB_01 = 11.2
#declare LAX_01 = 7
#declare LAX_02 = 2
#declare LAZ_01 = 2
#declare LB_02 = 11

//#declare ZCENT = 3.05

#declare ZARM01 = -1.4
#declare YARM01 = 11.05
#declare XARM01 = 0
// #declare AAX_01 = 2
// #declare AAZ_01 = 5
#declare AB_01 = 7
#declare AB_02 = 6
// #declare AAZ_02 = 20
// #declare AAY_02 = 15

// #declare LJX_01 = 10
// #declare LJZ_01 = -30
// #declare LJZ_02 = 40
// #declare LJZ_03 = 20

difference{

blob{ threshold HD_02
//leg
   cylinder{<0,0,0><0,LB_01*-1,0>,1,HS_02
      scale <1.3/HR_02,1,1.2/HR_02>
      rotate x*(LAX_01*SIDE)*-1
      rotate y*0*SIDE
      rotate z*LAZ_01
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   cylinder{<0,0,0><0,LB_02*-1,0>,1.2,HS_02
      rotate x*(LAX_02*SIDE)*-1
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02 scale <1.1/HR_02,1.6/HR_02,1.1/HR_02> // ankle
      translate x*.2
      rotate <5*SIDE,0*SIDE,15>
      rotate z*LJZ_02/2
      translate x*-.5
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02 scale <1.7/HR_02,5.2/HR_02,1.7/HR_02>
      rotate <(LAX_01*SIDE)*-1.2,0*SIDE,LAZ_01*4>
      translate <-0.4,LB_01/-2.3,0.8*SIDE>
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02 scale <1.7/HR_02,4.5/HR_02,1.7/HR_02> //-
      rotate <0*SIDE,0*SIDE,-5>
      translate <0,LB_01/-2,1.3*SIDE>
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02*.8 scale <1.6/HR_02,2.9/HR_02,1.7/HR_02> //-
      rotate <0*SIDE,0*SIDE,8>
      translate <.5,LB_02/-2.9,0*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02*.9
      scale <.8/HR_02,2.3/HR_02,.8/HR_02> //-
      rotate <(LAX_02*SIDE)*-1,0*SIDE,-4>
      translate <0.5,LB_02/-1.6,0*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

//*
   sphere{0,1,HS_02
      scale <1.5/HR_02,2.0/HR_02,1.9/HR_02>*1.05
      rotate <5*SIDE,-5*SIDE,28>
      translate <.5,0,1.3*SIDE>
   rotate z*LJZ_01/2
   }

   sphere{0,1,HS_02
      scale <.9/HR_02,1.1/HR_02,1/HR_02>
      translate y*-1
      rotate <5*SIDE,-5*SIDE,28>
      translate <.5,0,1.3*SIDE>
   rotate z*LJZ_01/1.4
   }
//*
   sphere{0,1,HS_02 scale <.6/HR_02,.5/HR_02,.5/HR_02>*1.1
      rotate z*-80
      translate x*.1
      rotate y*-10*SIDE
      translate <0,LB_02*cos(radians(LAX_02))*-1,LB_02*sin(radians(LAX_02))*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02 scale <2.4/HR_02,1/HR_02,.8/HR_02>*1.2
      rotate z*30
      translate <-1.85,-.7,0>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1,LB_02*sin(radians(LAX_02))*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,-3 scale <5/HR_02,.7/HR_02,5/HR_02>*1.2
      rotate y*-10*SIDE
      //translate y*-.4
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.15,(LB_02*sin(radians(LAX_02))*SIDE)*1.15>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02
      scale <.8/HR_02,.3/HR_02,.95/HR_02>*1.1
      rotate y*-15*SIDE
      translate <-2.1*1.4,0,.2*SIDE>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.05,LB_02*sin(radians(LAX_02))*1.05*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02
      scale <.55/HR_02,.2/HR_02,.32/HR_02>*1.1
      rotate y*-5*SIDE
      translate <-3.1*1.3,0,.9*SIDE>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.05,LB_02*sin(radians(LAX_02))*1.05*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02
      scale <.6/HR_02,.2/HR_02,.2/HR_02>*1.1
      translate <-3.1*1.3,0,.37*SIDE>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.05,LB_02*sin(radians(LAX_02))*1.05*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02
      scale <.55/HR_02,.18/HR_02,.18/HR_02>*1.1
      translate <-3.0*1.3,0,.05*SIDE>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.05,LB_02*sin(radians(LAX_02))*1.05*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02
      scale <.55/HR_02,.18/HR_02,.18/HR_02>*1.1
      translate <-2.85*1.3,0,-.28*SIDE>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.05,LB_02*sin(radians(LAX_02))*1.05*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}

   sphere{0,1,HS_02
      scale <.53/HR_02,.17/HR_02,.17/HR_02>*1.1
      rotate y*3*SIDE
      translate <-2.7*1.3,0,-.59*SIDE>
      rotate y*-10*SIDE
   rotate z*LJZ_03
      translate <0,LB_02*cos(radians(LAX_02))*-1.05,LB_02*sin(radians(LAX_02))*1.05*SIDE>
   rotate z*LJZ_02
      translate <LB_01*cos(radians(LAX_01))*sin(radians(LAZ_01))*SIDE,
                 (LB_01*cos(radians(LAX_01))*cos(radians(LAZ_01))*SIDE)*-1,
                 LB_01*sin(radians(LAX_01))>*SIDE
   rotate z*LJZ_01 rotate x*LJX_01*SIDE}
//

cylinder{<0,0,0><0,LB_01,0>,1,HS_02
     translate z*ZCENT
     rotate z*-5
     rotate z*BOW_ANG}

sphere{0,1,HS_02
     scale <1.3/HR_02,2.6/HR_02,1.5/HR_02>*.95
     translate <-.5,.6,ZCENT>
     rotate z*10
     rotate z*BOW_ANG}

sphere{0,1,HS_02
     scale <1.5/HR_02,1.8/HR_02,1.4/HR_02>*.95
     translate <-.8,.1,ZCENT>
     rotate z*10
     rotate z*BOW_ANG}
//
sphere{0,1,HS_02
     scale <2.4/HR_02,2.5/HR_02,3/HR_02>
     translate <-.28,1.4,ZCENT>
     rotate z*10
     rotate z*BOW_ANG}

sphere{0,1,HS_02
     scale <1.5/HR_02,1.2/HR_02,1/HR_02>
     translate <-1.2,-2.0,ZCENT>
     rotate z*-10}


sphere{0,1,-5
     scale <.3/HR_02,.22/HR_02,.17/HR_02>
     rotate z*-5
     translate <-2.7,1.9,ZCENT>
     rotate z*BOW_ANG}

cylinder{<0,0,0><0,10,0>,1,HS_02
     scale <1.3/HR_02,1,2.65/HR_02>
     translate <-.7,2,ZCENT>
     rotate z*-5
     rotate z*BOW_ANG}

cylinder{<0,0,0><0,.6,0>,1,HS_02
     scale <2.5/HR_02,3.2/HR_02,2.65/HR_02>
     rotate <-15*SIDE,0*SIDE,-12>
     translate <-.8,6.4,ZCENT/1.6>
     rotate z*BOW_ANG}

cylinder{<0,0,0><0,.4,0>,1,HS_02
     scale <1.3/HR_02,3.4/HR_02,2.45/HR_02>
     rotate <15*SIDE,0*SIDE,-12>
     translate <-.6,7.5,(3.05+(3.05-3.05/1.6))*SIDE>
     rotate z*BOW_ANG}

sphere{0,1,-.6
     scale <.5/HR_02,.8/HR_02,2/HR_02>
     rotate <0*SIDE,0*SIDE,0>
     translate <-3.5,4,ZCENT>
     rotate z*BOW_ANG}

sphere{0,1,HS_02*.5
     scale <1.6/HR_02,1.55/HR_02,2/HR_02>
     rotate <-5*SIDE,-5*SIDE,-30>
     translate <-1.9,9,ZCENT/2.2>
     rotate z*BOW_ANG}


cylinder{<0,0,-1.25*SIDE><0,0,0>,1,HS_02
     scale <.65/HR_02,.5/HR_02,1/HR_02>
     rotate <5*SIDE,-15*SIDE,0>
     translate <-1.4,11.83,2.05*SIDE>
     rotate z*BOW_ANG}

sphere{0,1,HS_02
     scale <2/HR_02,2.8*1.2/HR_02,3.5/HR_02>
     rotate <0*SIDE,0*SIDE,-20>
     translate <-.6,10.3,ZCENT>
     rotate z*BOW_ANG}
//////
cylinder{<0,0,-.7*SIDE><0,0,0>,1,HS_02*.8
     scale <.55/HR_02,1.6/HR_02,.7/HR_02>
     rotate y*22*SIDE
     rotate x*-20*SIDE
     translate <1.65,9.5,.85*SIDE>
     rotate z*BOW_ANG}

// neck
cylinder{<0,.6,0><0,0,0>,1,HS_02
     scale <.8*1.2/HR_02,1/HR_02,.8*1.2/HR_02>*1.4
     rotate z*7
     translate <.3,13,ZCENT>
     rotate z*BOW_ANG}

sphere{0,1,HS_02
     scale <1/HR_02,1/HR_02,2.5/HR_02>*1.2
     rotate x*-5*SIDE
     translate <.4,12.5,ZCENT>
     rotate z*BOW_ANG}

// ARM: internal part

   sphere{0,1,HS_02
          scale <1.5/HR_02,1.4/HR_02,1.8/HR_02>*1.3
          rotate x*-10*SIDE
          translate <XARM01,YARM01,ZARM01*SIDE>
          rotate z*BOW_ANG}

   cylinder{<0,0,0><0,AB_01/-2,0>,1.2,HS_02
          scale <1.4,1,1.3>
          rotate <AAX_01*SIDE,0*SIDE,AAZ_01*-1>
          translate <XARM01,YARM01-.3,(ZARM01-1.3)*SIDE>
          rotate z*BOW_ANG}

sturm
translate y*10
translate z*ZCENT*-1
}
box{<-10,30,5*SIDE><10,-3,0.0000001*SIDE>}
texture{SK_TEX}
}

// ARM: external part

blob{ threshold HD_02
   cylinder{<0,0,0><0,AB_01*-1,0>,1.2,HS_02
          scale <1.35,1,1.15>
          rotate <AAX_01*SIDE,0*SIDE,AAZ_01*-1>
          translate <XARM01,YARM01-.31,(ZARM01-1.2)*SIDE>}

   sphere{0,1,HS_02
          scale <1.2*1.32/HR_02,AB_01/1.8*HR_02*1.2,1.1/HR_02>
          rotate z*2
          translate <-.2,(AB_01/2-.1)*-1,0>
          rotate <AAX_01*SIDE,0*SIDE,AAZ_01*-1>
          translate <XARM01,YARM01-.31,(ZARM01-1.2)*SIDE>}


   sphere{0,1,HS_02*.95
          scale <.65/HR_02,.6/HR_02,.7/HR_02>
          translate x*.2
          translate <AB_01*cos(radians(AAX_01))*sin(radians(AAZ_01*-1)),
                     AB_01*cos(radians(AAX_01))*cos(radians(AAZ_01*-1))*-1-.4,
                     AB_01*sin(radians(AAX_01))*-1*SIDE>
          translate <XARM01,YARM01-.3,(ZARM01-1.2)*SIDE>}

   cylinder{<0,0,0><0,AB_02*-1,0>,1,HS_02
          scale <1.1,1,.9>
          rotate y*AAY_02*-1*SIDE
          rotate z*AAZ_02*-1
          translate <AB_01*cos(radians(AAX_01))*sin(radians(AAZ_01*-1)),
                     AB_01*cos(radians(AAX_01))*cos(radians(AAZ_01*-1))*-1-.4,
                     AB_01*sin(radians(AAX_01))*-1*SIDE>
          translate <XARM01,YARM01-.3,(ZARM01-1.2)*SIDE>}

   sphere{0,1,HS_02
          scale <1.25/HR_02,AB_02/1.1*HR_02,1/HR_02>
          rotate y*AAY_02*-1*SIDE
          translate y*AB_02/-2.1
          rotate z*AAZ_02*-1
          translate <AB_01*cos(radians(AAX_01))*sin(radians(AAZ_01*-1)),
                     AB_01*cos(radians(AAX_01))*cos(radians(AAZ_01*-1))*-1-.4,
                     AB_01*sin(radians(AAX_01))*-1*SIDE>
          translate <XARM01,YARM01-.3,(ZARM01-1.2)*SIDE>}
sturm
rotate z*BOW_ANG
translate y*10
translate z*ZCENT*-1
texture{SK_TEX}
}

#include "h01.inc"
object{HAND
    rotate z*90
    scale 1/(2*1.2999999999)*H_R01

    translate y*AB_02*-1.1
    rotate y*AAY_02*-1*SIDE
    rotate z*AAZ_02*-1
    translate <AB_01*cos(radians(AAX_01))*sin(radians(AAZ_01*-1)),
               AB_01*cos(radians(AAX_01))*cos(radians(AAZ_01*-1))*-1-.4,
               AB_01*sin(radians(AAX_01))*-1*SIDE>
    translate <XARM01,YARM01-.3,(ZARM01-1.2)*SIDE>
    rotate z*BOW_ANG
    translate y*10
    translate z*ZCENT*-1
texture{SK_TEX}
}

