
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: Clip Chair (c) N.B. 1997
// Date: 26.08.1997
// Auth: N.B.


#declare CL_TEX =
texture{
   finish{
      ambient <0.7,0.8,1>*.3
      reflection 0.2
      metallic
      specular 0.8
   }
   pigment{
      color rgb <0.7,0.8,1>}
}

#declare T_T01=0.5
#declare T_R01=20
#declare T_H01=28
#declare T_H02=T_H01+6+4
#declare DIST01=5

#declare SIDE01=
union{
cylinder {<0,0,0><0,0,-16>,T_T01 translate <-1,0,-10>}

difference{
    torus{2,T_T01}
    box {<-5,2,0><5,-2,5>}
translate <1,0,-26>}

cylinder {<0,0,0><0,0,-20>,T_T01 translate <3,0,-6>}

difference{
    torus{3,T_T01}
    box {<-5,2,0><5,-2,-5>}
translate z*-6.5}

cylinder {<0,0,0><0,0,T_H01*-1>,T_T01 translate <-3,0,-6>}

difference{
    torus{4,T_T01}
    box {<-5,2,0><5,-2,5>}
    box {<0,2,5><5,-2,-5>}
translate <1,0,(T_H01+6)*-1>}

cylinder {<0,0,0><DIST01-1,0,0>,T_T01 translate <1,0,T_H02*-1>}
}

#declare S_H02=30
#declare S_T01=6
#declare S_H01=S_H02-S_T01-3
#declare T_F01=
union{
   object{SIDE01 translate y*T_R01*-1}
   object{SIDE01 translate y*T_R01}
   difference{
      torus{T_R01,T_T01}
      box{<T_R01*-1.2,2,T_R01*1.2*-1><0,-2,T_R01*1.2>}
   rotate x*90
   translate <DIST01,0,T_H02*-1>}
}

#declare T_A01=30
#declare T_R02=T_R01*.5
#declare T_F02=
union{
   cylinder {<0,0,0><0,0,T_H02+T_T01-S_H01>,T_T01
      translate <T_R01,0,T_H02*-1> rotate z*T_A01 translate x*DIST01}
   cylinder {<0,0,0><0,0,T_H02+T_T01-S_H01>,T_T01
      translate <T_R01,0,T_H02*-1> rotate z*T_A01*-1 translate x*DIST01}

   cylinder {<0,0,(S_H01-T_T01)*-1><0,0,(S_H02-S_T01)*-1>,T_T01
   translate x*(T_R02/cos(radians(T_A01))-T_R02*tan(radians(T_A01))+DIST01)}

   difference{
      torus{T_R02*tan(radians(T_A01)),T_T01 translate x*T_R02/cos(radians(T_A01))}
      box{<T_R02,2,T_R02*1.2*-1><T_R01*1.2,-2,T_R02*1.2> rotate y*T_A01}
      box{<T_R02,2,T_R02*1.2*-1><T_R01*1.2,-2,T_R02*1.2> rotate y*T_A01*-1}
   rotate x*90
   translate <DIST01,0,(S_H01-T_T01)*-1>}
   union{
      difference{
         torus{4,T_T01}
         box {<-5,2,0><5,-2,5>}
         box {<0,2,5><-5,-2,-5>}
         translate <T_R01+1,0,4>}
      cylinder {<T_R02,0,0><T_R01+1,0,0>,T_T01}
      cylinder {<0,0,0><0,0,S_H01-T_T01-4>,T_T01 translate <T_R01+1+4,0,4>}
         translate <0,0,(S_H01-T_T01)*-1> rotate z*T_A01 translate x*DIST01}
   union{
      difference{
         torus{4,T_T01}
         box {<-5,2,0><5,-2,5>}
         box {<0,2,5><-5,-2,-5>}
         translate <T_R01+1,0,4>}
      cylinder {<T_R02,0,0><T_R01+1,0,0>,T_T01}
      cylinder {<0,0,0><0,0,S_H01-T_T01-4>,T_T01 translate <T_R01+1+4,0,4>}
         translate <0,0,(S_H01-T_T01)*-1> rotate z*T_A01*-1 translate x*DIST01}
}

#declare FRAME01=
union{
   object{T_F01}
   object{T_F02}
rotate x*90
}

#declare SS001=2
#declare SL001=T_R01-T_T01-SS001

#declare SEAT01=
union{
   difference{
      torus{SL001,SS001}
      box{<SL001*-1.2,SS001*-1.2,SL001*-1.2><0,SS001*1.2,SL001*1.2>}
      rotate x*90
      translate <DIST01,0,(S_H02-SS001)*-1>}
    difference{
      torus{SL001,SS001}
      box{<SL001*-1.2,SS001*-1.2,SL001*-1.2><0,SS001*1.2,SL001*1.2>}
      rotate x*90
      translate <DIST01,0,(S_H02-S_T01+SS001)*-1>}
    difference{
       union{
          cylinder {<0,0,(S_H02-SS001)*-1><0,0,(S_H02-S_T01+SS001)*-1>,SL001+SS001}
          cylinder {<0,0,S_H02*-1><0,0,(S_H02-S_T01)*-1>,SL001}
       }
      box{<SL001*-1.5,SL001*-1.5,S_H02*-1.5><0,SL001*1.5,(S_H02-S_T01)*-.5>}
      translate <DIST01,0,0>}

   box{<-5+SS001,SL001+SS001,(S_H02-SS001)*-1><DIST01,(SL001+SS001)*-1,(S_H02-S_T01+SS001)*-1>}
   box{<-5+SS001,SL001,S_H02*-1><DIST01,SL001*-1,(S_H02-S_T01)*-1>}
   cylinder {<-5+SS001,SL001,(S_H02-SS001)*-1><-5+SS001,SL001*-1,(S_H02-SS001)*-1>,SS001}
   cylinder {<-5+SS001,SL001,(S_H02-S_T01+SS001)*-1><-5+SS001,SL001*-1,(S_H02-S_T01+SS001)*-1>,SS001}
   sphere{<-5+SS001,SL001,(S_H02-SS001)*-1>,SS001}
   sphere{<-5+SS001,SL001*-1,(S_H02-SS001)*-1>,SS001}
   sphere{<-5+SS001,SL001,(S_H02-S_T01+SS001)*-1>,SS001}
   sphere{<-5+SS001,SL001*-1,(S_H02-S_T01+SS001)*-1>,SS001}
   cylinder{<-5+SS001,SL001,(S_H02-SS001)*-1><-5+SS001,SL001,(S_H02-S_T01+SS001)*-1>,SS001}
   cylinder{<-5+SS001,SL001*-1,(S_H02-SS001)*-1><-5+SS001,SL001*-1,(S_H02-S_T01+SS001)*-1>,SS001}
   cylinder{<-5+SS001,SL001*-1,(S_H02-SS001)*-1><DIST01,SL001*-1,(S_H02-SS001)*-1>,SS001}
   cylinder{<-5+SS001,SL001*-1,(S_H02-S_T01+SS001)*-1><DIST01,SL001*-1,(S_H02-S_T01+SS001)*-1>,SS001}
   cylinder{<-5+SS001,SL001,(S_H02-SS001)*-1><DIST01,SL001,(S_H02-SS001)*-1>,SS001}
   cylinder{<-5+SS001,SL001,(S_H02-S_T01+SS001)*-1><DIST01,SL001,(S_H02-S_T01+SS001)*-1>,SS001}
   box{<-5,SL001,(S_H02-SS001)*-1><0,SL001*-1,(S_H02-S_T01+SS001)*-1>}
rotate x*90}

#declare CL001=
union{
   object {FRAME01}
   object {SEAT01}
translate y*-3}
