
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: Map
// Date: 26.08.1997
// Auth: N.B.


#declare MPEN01=1

#declare MAP_TEX =
texture{
   finish{
      diffuse .8
      ambient <0.7,0.8,1>*.4
      reflection .05
      phong .7
      phong_size 40
   }
   normal {bumps .05 scale .2}
   pigment{color rgb <0.7,0.8,1>*.9}
}

#declare PAP_TEX =
texture{
   finish{
      diffuse .9
      ambient .3
      phong .6
      phong_size 10
   }
   normal {bumps .05 scale 2}
   pigment{color rgb <1,1,1>}
}

#declare MAP_ANG01=-2
#declare MAP_TH01=-7
#declare PAP_TH01=.1
#declare PAP_NO01= 45
#declare PAP_RA01=seed(123)

#declare TXT01=
union{
   text{ttf "crystal.ttf","POV-",-.002,0}
   text{ttf "crystal.ttf","Ray",-.002,0 translate y*-1}
scale 2.4
texture{PAP_TEX pigment {color rgb <.2,.2,.2>}}}

#declare MAP01=
union{
   difference{
      box{<0,-.15,0><28,.15,32>}
      cylinder{<0,-1,0><0,1,0>.5 translate <2,0,12>}
      cylinder{<0,-1,0><0,1,0>.5 translate <5,0,12>}
      box{<0,-1,-.5><3,1,.5> translate <2,0,12>}
      cylinder{<0,-1,0><0,1,0>.5 translate <2,0,32-12>}
      cylinder{<0,-1,0><0,1,0>.5 translate <5,0,32-12>}
      box{<0,-1,-.5><3,1,.5> translate <2,0,32-12>}
      rotate z*MAP_ANG01
      }
   cylinder{<0,0,0><0,0,32>.15}
   box{<0,-.15,0><28,.15,32> translate y*MAP_TH01}
   cylinder{<0,0,0><0,0,32>.15 translate y*MAP_TH01}
   difference{
      box{<-.15,0,0><.15,MAP_TH01,32>}
      cylinder{<-1,0,0><1,0,0>1.4 translate <0,MAP_TH01/2,9>}
   }
   #declare AAA=
   union{
      difference{
         torus{.5,.2}
         box{<0,-1,-1><1,1,1>}
      translate <2,0,12>
      }
      difference{
         torus{.5,.2}
         box{<0,-1,-1><1,1,1>}
      rotate y*180
      translate <5,0,12>
      }
      cylinder{<0,0,0><3,0,0>.2 translate <2,0,11.5>}
      cylinder{<0,0,0><3,0,0>.2 translate <2,0,12.5>}
      texture{T_Chrome_3C}
      }
    #declare BBB=
   union{
      difference{
         torus{4.7/2,.21}
         box{<-5,-1,-5><5,1,0>}
      }
      cylinder{<0,0,0><0,0,(MAP_TH01*-1-4.7/2)*-1>.21 translate x*4.7/2}
      cylinder{<0,0,0><0,0,(MAP_TH01*-1-4.7/2)*-1>.21 translate x*4.7/-2}
      translate <4.7/2+1,0,(MAP_TH01*-1-4.7/2)>
      rotate x*-90
      translate y*MAP_TH01
      texture{T_Chrome_3C}
      }
   object {AAA rotate z*MAP_ANG01}
   object {AAA translate z*(32-24) rotate z*MAP_ANG01}
   object {BBB translate z*12}
   object {BBB translate z*(32-12)}
   torus{1.4,.2 rotate z*90 translate <0,MAP_TH01/2,9> texture{T_Chrome_3C}}
   union{
      box{<-.001,(MAP_TH01+1.5)*-1/-2,0><0,(MAP_TH01+1.5)*-1/2,-11.5>
         translate <-.15,MAP_TH01/2,32-4.5> texture{PAP_TEX}}
      object{TXT01 rotate z*90 rotate y*90 translate <-.15,-5.5,25>}
   }

   //pen01:
   #if (MPEN01=1)
      #declare PEN_ERR01=1
      #declare PEN_PIG01= pigment{color rgb <1,.6,.1>}
      #declare PEN_PIG02= pigment{color rgb <.2,.2,.2>}
      #declare PEN_RAD01=0.8/2
      #declare PEN_WID01=12
      #include "m_pen01.inc"
      object{PEN01 rotate y*35 translate <2,0,-3.5> rotate z*MAP_ANG01}
   #else
   #end

   //mug:
   #include "m_cup01"
   object{CUP01 rotate y*-7 translate <11,0,19>}

   union{
   #while (PAP_NO01>=0)
      box{<0,0,29.7/-2><21,PAP_TH01,29.7/2>
         rotate y*4*(0.5-rand(PAP_RA01))
         translate <4,MAP_TH01+PAP_NO01*PAP_TH01,32/2>}
      #declare PAP_NO01=PAP_NO01-1
   #end
   texture{PAP_TEX}
   }
   translate <28/-2,MAP_TH01*-1+.15,32/-2>
   rotate y*-70
texture{MAP_TEX}
}

// object{MAP01}
