
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: 1. Picture and 2. Garbage basket
// Date: 26.08.1997
// Auth: N.B.



#declare ART_TEX =
texture{
   finish {
      ambient 0.25
      diffuse 0.9
      phong .5
      phong_size 20
    }
   pigment{ color rgb <1,1,1>}
}

// picture on the wall

#declare POV_ART=
union{
   box{<-25,-25,0><25,25,-.1>
      texture{ART_TEX
         pigment{
            image_map {
               gif "pov_art.gif"
               once
            }
            scale <64,48,1> translate <-32,-24,0>
         }
      }
   }
   difference{
      box{<-30,-30,-.1><30,30,-.4>}
      box{<-24,-24,0><24,24,-.5>}
      texture{ART_TEX}
   }
   difference{
      box{<-30.5,-30.5,0><30.5,30.5,-.8>}
      box{<-29.5,-29.5,.1><29.5,29.5,-.9>}
      texture{T_Chrome_4D}
   }
}

#declare GARB_TEX01=
texture{
   finish {
      ambient 0.2
      diffuse 0.9
      phong .9
      phong_size 100
    }
   pigment{ color rgb <.8,.8,.8>}
}

#declare GARB_TEX02=
texture{
   finish{
      diffuse .8
      ambient .2
      phong .7
      phong_size 10
   }
   normal{bumps 15 scale 3}
   pigment{color rgb <1,1,1>}
}

//garbage basket

#declare GARB=
union{
   difference{
      cone{<0,0,0>11.5,<0,35,0>14.5
         texture{GARB_TEX01
            pigment{
               image_map {
                  gif "hatch01.gif"
                  map_type 0
                  filter   0, 1
                  transmit   0, 1
               }
               scale 1.5
            }
         }
      }
      cone{<0,-.1,0>11.5-.1,<0,35.1,0>14.5-.1
      texture{GARB_TEX01 pigment{ color rgbt <1,1,1,1>}}
      }
   }
   torus{14.5,.3 translate y*35}
   torus{11.5,.3}
   cylinder{<0,0,0><0,.3,0>11.5}
   superellipsoid{<.7 .8> translate y*1 scale 4 texture{GARB_TEX02} translate <1,.3,-2>}
   sphere{0,4 texture{GARB_TEX02} translate <-5,8,-5>}
   box{<0,0,-6><.3,7,6> texture{GARB_TEX02} rotate <12,34,65> translate <7,9,-2>}
   box{<0,0,-12><.3,8,5> texture{GARB_TEX02} rotate <34,12,23> translate <-2,7,3>}
texture{GARB_TEX01}
translate y*.5
}

