
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: Pencil : w/wo eraser; single/double sided
// Date: 26.08.1997
// Auth: N.B.


/*
background {color rgb <.9,.95,1>}

light_source{<90,140,-110>*2.1
   color rgb <1,1,1>
   spotlight
   point_at <50,90,-90>
   radius 30
   falloff 60
   tightness 3
}

camera{
location <60,70,-120>*.3
//location <0,150,0>*10
//location <0,0,-150>*3
   angle 30
   look_at <0,0,0>
}
#include "metals.inc"

#declare PEN_ERR01=1 //w/wo eraser
#declare PEN_PIG01=
pigment{color rgb <1,.6,.1>}
#declare PEN_PIG02=
pigment{color rgb <.2,.2,.2>}
*/

#declare PEN_TEX01 =
texture{
   finish{
      diffuse .9
      ambient .2
      phong 1
      phong_size 100
   }
   pigment{PEN_PIG01}
}
#declare PEN_TEX02 =
texture{
   finish{
      diffuse .9
      ambient <1,.9,.8>*.2
      phong 1
      phong_size 10
   }
   pigment{color rgb <1,.9,.8>}
}

// #declare PEN_RAD01=0.8/2
// #declare PEN_WID01=12
#declare PEN01=
union{
   difference{
      prism {
         linear_sweep
         linear_spline
         0,PEN_WID01,6,
         <(PEN_RAD01*cos(0)),(PEN_RAD01*sin(0))>,
         <(PEN_RAD01*cos(pi/3)),(PEN_RAD01*sin(pi/3))>,
         <(PEN_RAD01*cos(pi*2/3)),(PEN_RAD01*sin(pi*2/3))>,
         <(PEN_RAD01*cos(pi)),(PEN_RAD01*sin(pi))>,
         <(PEN_RAD01*cos(pi*4/3)),(PEN_RAD01*sin(pi*4/3))>,
         <(PEN_RAD01*cos(pi*5/3)),(PEN_RAD01*sin(pi*5/3))>
      }
      cylinder{<0,0,0><0,PEN_WID01-.01,0>.1}
      difference{
         cylinder{<0,-.1,0><0,2.5,0>PEN_RAD01*1.2}
         cone{<0,0,0>0,<0,2.6,0>PEN_RAD01*1.1}
      translate y*-.05
      texture{PEN_TEX02}
      }
   }
   difference{
      cylinder{<0,0,0><0,PEN_WID01-.01,0>.1}
      difference{
         cylinder{<0,-.1,0><0,2.5,0>PEN_RAD01*1.2}
         cone{<0,0,0>0,<0,2.6,0>PEN_RAD01*1.1}
      translate y*-.05
      }
   texture{PEN_TEX01 pigment{PEN_PIG02}}
   }
   #if(PEN_ERR01=1)
      cylinder{<0,0,0><0,1.5,0>PEN_RAD01*.9 translate y*PEN_WID01 texture{T_Brass_3D}}
      cylinder{<0,-.15,0><0,.15,0>PEN_RAD01*.92 translate y*(PEN_WID01+1.5/2) texture{T_Brass_3D}}
      cylinder{<0,0,0><0,.3,0>PEN_RAD01*.85 translate y*(PEN_WID01+1.5)
         texture{PEN_TEX02 pigment{color rgb <1,.7,.8>}}
      }
      sphere{0,PEN_RAD01*.85 scale <1,.7,1> translate y*(PEN_WID01+1.5+.3)
         texture{PEN_TEX02 pigment{color rgb <1,.7,.8>}}
      }
   #else
   #end
texture{PEN_TEX01}
rotate x*90
translate y*PEN_RAD01
}

// box{<-100,0,-100><100,-10,100> texture{PEN_TEX02}}
