
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: a #while loop tentacle-like object
// Date: 26.08.1997
// Auth: N.B.

/*
background {color rgb <.4,.45,.5>*.4}

camera{
// location <65,400,0>
location <60,70,-120>*2.5
//location <60,70,-120>
//location <0,0,-250>
   angle 45
   look_at <65,45,0>
//look_at <0,0,0>
}

light_source{<90,140,-110>*2.1
   color rgb <1,1,1>
   spotlight
   point_at <50,90,-90>
   radius 15
   falloff 40
   tightness 5
   fade_distance 300
   fade_power 1
}

*/

#declare MON_TEX =
texture{
   finish{
      ambient <0.8,0.9,1>*.3
      metallic
      brilliance 2
      diffuse 0.5
      specular 0.80
      roughness 1/100
      caustics .6
      reflection 0.6
   }
// normal {bumps .5 scale .1}
   pigment{
      color rgbf <0.8,0.9,1,.5>*1.1}
}


#declare XX1=0
#declare YY1=0
#declare ZZ1=0
#declare R01=4.5
#declare R02=10
#declare XXX=5.2
#declare NW01=10
#declare NS01=50
#declare TL01=10
#declare dX=2*pi/NS01
#declare MM0=0
//#declare MM1=.1
//#declare dM1=(MM0-MM1)/NS01
#declare KOUNT0=NS01*NW01
#declare KOUNT1=KOUNT0

#declare FFF01=
union{
//blob{threshold .6
#while (KOUNT1>0)
   #declare YY1=sin(XX1)*MM0
   #declare ZZ1=cos(XX1)*MM0
//   sphere{0,R01 translate <XX1,YY1,ZZ1> rotate z*XX1*5 rotate y*XX1*3 texture{TEX}}
   #declare XX2=(XX1+dX)
   #declare R01=R01*.994
   #declare R02=R02*.994
   #declare XXX=XXX*.9982
   #declare MM0=R02*sin(XX2/(NW01/2))*4
//   #declare MM0=sin(XX2/(NW01*2))*4
//   #declare MM0=log(XX2)*2
   #declare YY2=sin(XX2)*MM0
   #declare ZZ2=cos(XX2)*MM0
   sphere{0,R01 translate <XX2*XXX,YY2,ZZ2>
   rotate z*XX2*1
   rotate y*XX1*-.85
   rotate x*XX1*-.5
   texture{MON_TEX}}
//   cylinder{<XX1,YY1,ZZ1><XX2,YY2,ZZ2>,R01 texture{TEX}}
   #declare XX1=XX2
   #declare KOUNT1=KOUNT1-1
#end
}

#declare XX1=0
#declare YY1=0
#declare ZZ1=0
#declare R01=3
#declare R02=5
#declare XXX=5
#declare NW01=5
#declare NS01=50
#declare TL01=10
#declare dX=2*pi/NS01
#declare MM0=0
//#declare MM1=.1
//#declare dM1=(MM0-MM1)/NS01
#declare KOUNT0=NS01*NW01
#declare KOUNT1=KOUNT0

#declare FFF02=
union{
//blob{threshold .6
#while (KOUNT1>0)
   #declare YY1=sin(XX1)*MM0
   #declare ZZ1=cos(XX1)*MM0
//   sphere{0,R01 translate <XX1,YY1,ZZ1> rotate z*XX1*5 rotate y*XX1*3 texture{TEX}}
   #declare XX2=(XX1+dX)
   #declare R01=R01*.994
   #declare R02=R02*.994
   #declare XXX=XXX*.999
   #declare MM0=R02*sin(XX2/(NW01/2))*4
//   #declare MM0=sin(XX2/(NW01*2))*4
//   #declare MM0=log(XX2)*2
   #declare YY2=sin(XX2)*MM0
   #declare ZZ2=cos(XX2)*MM0
   sphere{0,R01 translate <XX2*XXX,YY2,ZZ2>
 //  rotate z*XX2*4
  rotate y*XX1*-4
   texture{MON_TEX}}
//   cylinder{<XX1,YY1,ZZ1><XX2,YY2,ZZ2>,R01 texture{TEX}}
   #declare XX1=XX2
   #declare KOUNT1=KOUNT1-1
#end
}
#declare MONSTER=
union{
//sphere{0,5 translate x*-5 texture{TEX}}
//box{<-1,-10,-10><1,10,10> texture{TEX}}
object{FFF01 rotate y*180 rotate z*193}
object{FFF02 rotate x*-90 rotate y*170 rotate z*185}
rotate z*5 rotate y*15
translate <55,130,-70>
}
/*
#declare KOUNT2=6
#declare ANG00=360/KOUNT2
#while (KOUNT2>=0)
    object{FFF01 rotate z*ANG00*KOUNT2}
   #declare KOUNT2=KOUNT2-1
#end


box{<-1000,-1000,100><1000,1000,101>
texture{TEX normal {wood .6 scale 3 turbulence .1} pigment{color rgb <.9,.95,1>}
   finish{ ambient <1,0.8,.6>*.2}}
}



#declare PC_TEX01 =
texture{
   finish{
      ambient <1,0.97,.92>*.3
      diffuse .7
      phong .8
      phong_size 20
   }
   pigment{color rgb <1,1,1>}
}

#declare LED_TEX01 =
texture{
   pigment{color rgb <1.7,2,.1>}
}

#declare LED_TEX02 =
texture{
   pigment{color rgb <.8,.8,.8>}
}

#declare LED_TEX03 =
texture{
   pigment{color rgb <2,1.7,.1>}
}

#include "m_pomp01.inc"
object{POMP00 rotate y*-90 translate <20,92.5,-70>}

#include "m_cl001.inc"
object {CL001 scale 1.5 rotate y*-22 translate <150,0,-60> texture{CL_TEX} normal {bumps 0.03 scale 10}}


#declare T_HI01=90
#include "m_keyb01.inc"
object {KEYB00 rotate y*-90 scale .1 translate <70+16,T_HI01-13,-70>}

#include "m_kello01.inc"
object{CLOCK01 rotate y*210 translate <23,92,-129>}
object{LAMP01 rotate y*184 translate <-LAMP_R01,92.5,-89>}

object{MONSTER}

*/
