
#include "colors.inc"
#include "glass.inc"
#include "stones.inc"
#include "textures.inc"
#include "golds.inc"

#include "golem2.inc"
#include "room.inc"
#include "latice.inc"

background { color Gray50 }

#declare camera_location = <-30, 20, -100>
#declare camera_look_at = <0, 30, 0>

light_source { <-30, 20, -100> color White }

light_source { <0, 20, 0> color rgb <0.8, 0.8, 1.0> fade_distance 10 fade_power 2 }
light_source { <-2, 14, 10> color rgb <0.8, 0.8, 1.0> fade_distance 10 fade_power 2 }
light_source { <4, 10, -5> color rgb <0.8, 0.8, 1.0> fade_distance 10 fade_power 2 }
light_source { <0, 37.5, 0> color rgb <0.8, 0.8, 1.0> fade_distance 10 fade_power 2 }

#declare Chain =
union {
    torus {
        1.1
        0.2
        scale <0.75, 1, 1>
        rotate <20, 0, 0>
        translate <-0.5, 0, -1.8>
    }
#declare Count = 0
#while (Count < 13)
    torus {
        1.1
        0.2
        scale <0.75, 1, 1>
        rotate <0, 0, 40 * Count>
        translate <0, 0, 1.8 * Count>
    }
#declare Count = Count + 1
#end
    rotate<-90, 0, 0>
    rotate<27, 0, 0>
    translate<0, 15, -27>
    texture {
        T_Gold_5A
    }
}

#declare InlayTex =
texture {
    T_Gold_5A
}

#declare Engraver =
text {
    ttf
    "quenya.ttf",
    "eFjRq~C522Y1T",
    1,           // the extrusion depth
    0            // offset
    texture {
        T_Gold_5A
    }
    scale 3.25
    translate <0, 1.25, 0>
}

#declare Engraver2 =
text {
    ttf
    "quenya.ttf",
    "~N781Y6tzYt%3",
    1,           // the extrusion depth
    0            // offset
    texture {
        T_Gold_5A
    }
    scale 3.25
    translate <0, 1.25, 0>
}

#declare BaseBottom =
box {
    <-46, 0, -46>
    <46, 1, 46>
}

#declare BaseRimFancy =
difference {
    box {
        <-45, 0, -45>
        <45, 4, 45>
    }
    cylinder {
        <-50, 4, -45>
        <50, 4, -45>
        4
    }
    cylinder {
        <-50, 4, 45>
        <50, 4, 45>
        4
    }
    cylinder {
        <-45, 4, -50>
        <-45, 4, 50>
        4
    }
    cylinder {
        <45, 4, -50>
        <45, 4, 50>
        4
    }
}

#declare LetteredRim =
union {
    difference {
        box {
            <-40, 0, -40>
            <40, 5, 40>
        }
        box {
            <0, 0, 0>
            <40, 40, 100>
            rotate<0, 0, 63.43>
            translate<-50, -20, -50>
        }
        box {
            <0, 0, 0>
            <-40, 40, 100>
            rotate<0, 0, -63.43>
            translate<50, -20, -50>
        }
        box {
            <0, 0, 0>
            <100, 40, 40>
            rotate<-63.43, 0, 0>
            translate<-50, -20, -50>
        }
        box {
            <0, 0, 0>
            <100, 40, -40>
            rotate<63.43, 0, 0>
            translate<-50, -20, 50>
        }
    }

    object {
        Engraver
        rotate<26.57, 0, 0>
        translate<-37, 0.5, -40>
    }
    object {
        Engraver2
        rotate<26.57, 0, 0>
        translate<17, 0.5, -40>
    }
    object {
        Engraver
        rotate<26.57, 0, 0>
        translate<-37, 0.5, -40>
        rotate<0, 90, 0>
    }
    object {
        Engraver2
        rotate<26.57, 0, 0>
        translate<17, 0.5, -40>
        rotate<0, 90, 0>
    }
    object {
        Engraver
        rotate<26.57, 0, 0>
        translate<-37, 0.5, -40>
        rotate<0, 180, 0>
    }
    object {
        Engraver2
        rotate<26.57, 0, 0>
        translate<17, 0.5, -40>
        rotate<0, 180, 0>
    }
    object {
        Engraver
        rotate<26.57, 0, 0>
        translate<-37, 0.5, -40>
        rotate<0, 270, 0>
    }
    object {
        Engraver2
        rotate<26.57, 0, 0>
        translate<17, 0.5, -40>
        rotate<0, 270, 0>
    }
}

#declare Plate =
union {
    object {
        BaseBottom
    }
    object {
        BaseRimFancy
        translate <0, 1, 0>
    }
    object {
        LetteredRim
        translate <0, 5, 0>
    }
}

#declare Base =
union {
    union {
        object {
            Plate
        }
        object {
            Plate
            rotate <0, 45, 0>
        }
        texture {
            T_Stone17
            scale 10
        }
    }

    object {
        Golem
        rotate<0, 0, 0>
        translate <2, 10, -30>
        texture {
            T_Gold_5A
        }
    }

    object {
        Golem
        rotate<0, 90, 0>
        translate <-30, 10, 2>
        texture {
            T_Gold_5A
        }
    }

    object {
        Golem
        rotate<0, 180, 0>
        translate <-2, 10, 30>
        texture {
            T_Gold_5A
        }
    }

    object {
        Golem
        rotate<0, -90, 0>
        translate <30, 10, -2>
        texture {
            T_Gold_5A
        }
    }

    object {
        difference {
            sphere {
                <0, 50, 0>
                20
            }
            sphere {
                <0, 50, 0>
                19
            }
        }
        texture {
            T_Glass3
        }
    }

    object {
        Latice
        scale 20
        translate<0, 50, 0>
    }

    object {
        Chain
        scale 1.33333
    }

    object {
        Chain
        scale 1.33333
        rotate <0, 90, 0>
    }

    object {
        Chain
        scale 1.33333
        rotate <0, 180, 0>
    }

    object {
        Chain
        scale 1.33333
        rotate <0, 270, 0>
    }
}

object {
    Room
    scale 5
}

object {
    Base
    scale <0.75, 0.75, 0.75>
}

#declare CrystalMagic =
texture {
    pigment { color rgbt <0, 0, 1, 1> }
    halo {
        emitting
        cylindrical_mapping
    	linear
        turbulence 1.5
		color_map {
			[ 0 color rgbt <0, 0, 1, 1> ]
			[ 0.8 color rgbt <0.35, 0.35, 1, -0.33> ]
			[ 1 color rgbt <0.5, 0.5, 1, -0.66> ]
		}
        frequency 2
		samples 20
        scale 0.5
	}
}

cylinder {
    <0, 0, 0>
    <0, 1, 0>
    1
    texture {
        CrystalMagic
    }
    hollow
    scale <25, 50, 25>
    translate <0, 7.5, 0>
}

#declare effect_rotate = 22
#declare effect_scale = 0.6
#declare effect_colour = <0, 0, 1>
#declare effect_location = <0, 20, 0>
#declare effect_type = "Star" #include "Lens.inc"

#declare effect_rotate = 42
#declare effect_scale = 0.3
#declare effect_colour = <0, 0, 1>
#declare effect_location = <-2, 14, 10>
#declare effect_type = "Star" #include "Lens.inc"

#declare effect_rotate = 73
#declare effect_scale = 0.45
#declare effect_colour = <0, 0, 1>
#declare effect_location = <4, 10, -5>
#declare effect_type = "Star" #include "Lens.inc"

#declare effect_rotate = 5
#declare effect_scale = 1
#declare effect_colour = <0, 0, 1>
#declare effect_location = <0, 37.5, 0>
#declare effect_type = "Star" #include "Lens.inc"
