
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//------------------------------------------------------------------->
// PHYSICS.POV                 The Magic of Physisc
// IRTC entry, topic MAGIC
// By Peter Huyghe, 1997
// Email: phuyghe@leplae.be
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//------------------------------------------------------------------->

#version 3.0

global_settings {
  assumed_gamma 2.2
//  ambient_light color <.4,.4,.4>
}

//These are from colors.inc:
#declare White   = rgb 1
#declare Silver  = color red 0.90 green 0.91 blue 0.98
#declare Brown   = color red 0.647059 green 0.164706 blue 0.164706
#declare Red     = rgb <1, 0, 0>
#declare Green   = rgb <0, 1, 0>
#declare Viens   = rgb 0
#declare NoViens = color red 0.90 green 0.91 blue 0.98

//Declare FAST to use colors instead of textures:
//#declare FAST = 1

camera {
  location   <8, 11, -22>
  up         y
  right      x*1.33
  direction  z
  look_at    <4, 10, 0>
}

#ifdef (FAST)
  #debug "FAST mode\r\n"
  #debug "Most textures will be replaced by colors\r\n"
#end

#ifdef (FAST)
 light_source { < -50, 50, -50 > color White }
 light_source { <  50, 50, -50 > color White }
#else
 light_source {
   < 10, 30, -15 >
   color <0.9,0.9,0.9> //White
   area_light x*3, y*3, 30, 30
   adaptive 2
   jitter
 }
 light_source {
   < -50, 30, -15 >
   color <0.9,0.9,0.9> //White
   area_light x*3, y*3, 30, 30
   adaptive 2
   jitter
 }
 #debug "\r\nThere is an area light in use; "
 #debug "rendering will be very slow !\r\n"
#end
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//------------------------------------------------------------------->
#declare Ball_Texture = texture {
    pigment { color rgb < 0.900, 0.700, 0.350 > }
    finish {
        reflection < 0.600, 0.600, 0.600 >
        brilliance 2.5
        phong 0.80
        phong_size 15.00
        metallic
    }
}

#declare Gray_Texture1 = texture {
    pigment { color rgb < 0.300, 0.300, 0.300 > }
    finish {
        ambient < 0.100, 0.100, 0.100 >
        diffuse 0.7
        brilliance 6.0
        reflection < 0.600, 0.600, 0.600 >
        phong 0.8
        phong_size 120
    }
}

#declare Gray_Texture2 = texture {
    finish {
        ambient < 0.100, 0.100, 0.100 >
        diffuse 0.7
        phong 1.0
        phong_size 70.0
        reflection < 0.300, 0.300, 0.300 >
    }
    pigment { color rgb < 0.400, 0.400, 0.400 > }
}

#declare Gray_Texture3 = texture {
    pigment { color rgb < 0.978, 0.980, 1.000 > }
    finish {
        specular 1
        roughness 0.001
        reflection < 0.061, 0.061, 0.061 >
        roughness 0.003
    }
    normal { bumps 0.7 }
    scale < 2.000, 2.000, 2.000 >
}

#declare Voet_Texture = texture {
    pigment {
        wood
        color_map {
            [ 0.00 rgb < 0.890, 0.600, 0.300 > ]
            [ 0.10 rgb < 0.890, 0.600, 0.300 > ]
            [ 0.90 rgb < 0.600, 0.400, 0.200 > ]
            [ 1.00 rgb < 0.600, 0.400, 0.200 > ]
        }
        rotate < 2.000, 90.000, 1.000 >
        scale < 0.200, 0.200, 1.100 >
        turbulence < 0.090, 0.090, 0.090 >
        octaves 3
    }
    finish {
        ambient < 0.300, 0.300, 0.300 >
        diffuse .50
        reflection < 0.000, 0.000, 0.000 >
        specular .10
        roughness 0.002
        phong .40
        phong_size 16
    }
}

#declare Rope_Texture = texture {
    pigment { color rgb < 0.850, 0.100, 0.100 > }
    finish {
        ambient < 0.300, 0.300, 0.300 >
        diffuse 0.60
        phong 0.30
        phong_size 2
        brilliance 2
    }
    normal {
        bumps .5
        scale < 0.050, 0.050, 0.300 >
    }
}

#declare Wall_Texture = texture {
  pigment {
    granite
    turbulence 0.0
    color_map {
      [0.0, 0.3 color Viens color NoViens]
      [0.3, 0.4 color NoViens color NoViens]
      [0.4, 0.6 color NoViens color NoViens]
      [0.6, 1.0 color NoViens color NoViens]
    }
  }
  finish {
    crand 0.02
  }
}
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//ground plane
plane {
  <0,1,0>,0
  pigment {
    checker color <.1,.1,.1>, color <.9,.9,.9>
    scale <4,4,4>
  }
  finish { reflection < 0.200, 0.200, 0.200 > }
}

//back plane
plane {
  <0,0,1>,44
  texture { Wall_Texture scale 9}
}
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//------------------------------------------------------------------->

#declare PILAAR = union {
  cylinder { <0,0,0>,<0,60,0>,5 }
  torus { 5,1 translate <0,12,0> }
  torus { 5,1 translate <0,14,0> }
  torus { 5,1 translate <0,16,0> }
  torus { 5,3 translate <0,-1.5,0> }
}

union {
  //horizontal
  cylinder { <-100,12,44>,<100,12,44>,1 }
  cylinder { <-100,14,44>,<100,14,44>,1 }
  cylinder { <-100,16,44>,<100,16,44>,1 }
  //vertical
  object { PILAAR
    translate <-40,0,44>
  }
  object { PILAAR
    translate <35,0,44>
  }
  texture { Wall_Texture scale 9}
}

#declare POLE = union {
  sphere { <0,-1,0>,2  }
  cylinder { <0,0,0>,<0,10,0>,.75 }
  sphere { <0,10,0>,.75  }
  cylinder { <0,9,0>,<0,9,-2>,0.2 }
  cylinder { <0,010,-2>,<0,9,-2>,0.2 }
  sphere { <0,9,-2>,0.2  }
  sphere { <0,10,-2>,0.2  }

#ifndef (FAST)
  texture { Gray_Texture1 }
#else
  pigment { color Silver }
#end
}

object { POLE  translate <-36,0,0> }
object { POLE  translate <36,0,0> }
object { POLE  translate <-12,0,0> }
object { POLE  translate <12,0,0> }

#include "rope.inc"         //this declares the ROPE object

object { ROPE
  translate <0,0,-1.25>
#ifndef (FAST)
  texture { Rope_Texture }
#else
  pigment { color Brown }
#end
}

#declare EXITSIGN = union {
    box { <-2.5,0,-2.5>,<2.5,.3,2.5>
#ifndef (FAST)
      texture { Gray_Texture3 }
#else
      pigment { color Silver }
#end
    }
    polygon { 5, <0,0,0>,<1,0,0>,<1,0,1>,<0,0,1>,<0,0,0>
      pigment { color White }
      pigment {
        image_map {
          gif "exitsign.gif"
          once
        }
        rotate <90,0,0>
        quick_color Red
      }
      translate <-0.5,0,-0.5>
      scale <5,5,5>
      translate <0,0.301,0>
    }
}

#declare MESSAGE = union {
  union {
    cylinder { <0,0,0>,  <0,12,0>,.3 }
    box { <-2,0,-2>,<2,.3,2> }
#ifndef (FAST)
    texture { Gray_Texture3 }
#else
    pigment { color Silver }
#end
  }
  union {
    box { <-2.5,0,-2.5>,<2.5,.3,2.5>
#ifndef (FAST)
      texture { Gray_Texture3 }
#else
      pigment { color Silver }
#end
    }
    polygon { 5, <0,0,0>,<1,0,0>,<1,0,1>,<0,0,1>,<0,0,0>
      pigment { color White }
      pigment {
        image_map {
          gif "sign.gif"
          once
        }
        rotate <90,0,0>
        quick_color Red
      }
      translate <-0.5,0,-0.5>
      scale <5,5,5>
      translate <0,0.31,0>
    }
    rotate <-50,0,0>
    translate <0,12,0>
  }
}

object { MESSAGE
  rotate <0,15,0>
  translate <5,0,2>
}

/*object { EXITSIGN
  rotate <-90,0,0>
  translate <30,30,44>
}*/

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//------------------------------------------------------------------->

#declare VOET = union {
  box { <-20,0,-10>,<20,2,10> }
  sphere { <-20,0,-10>,2 }
  sphere { <20,0,-10>,2 }
  sphere { <-20,0,10>,2 }
  sphere { <20,0,10>,2 }
  cylinder { <-20,0,-10>,<-20,0,10>,2 }
  cylinder { <-20,0,10>,<20,0,10>,2 }
  cylinder { <20,0,10>,<20,0,-10>,2 }
  cylinder { <20,0,-10>,<-20,0,-10>,2 }
#ifndef (FAST)
  texture { Voet_Texture scale <.5,.5,.5> }
#else
  pigment { color Green }
#end
}

#declare TOTHEIGHT = 26  //was 22
#declare TSSHEIGHT = 20  //was 15
#declare BALK = union {
  //bovenste balk
  sphere { <-15,TOTHEIGHT,0>,1 }
  sphere { <15,TOTHEIGHT,0>,1 }
  cylinder { <-15,TOTHEIGHT,0>,<15,TOTHEIGHT,0>,1 }
  //vier poten
  cylinder { <-19,0,-9>,<-17,TSSHEIGHT,-7>,0.75 }
  cylinder { <19,0,-9>,<17,TSSHEIGHT,-7>,0.75 }
  cylinder { <19,0,9>,<17,TSSHEIGHT,7>,0.75 }
  cylinder { <-19,0,9>,<-17,TSSHEIGHT,7>,0.75 }
  //vier midden balken
  cylinder { <-15,TOTHEIGHT,0>,<-17,TSSHEIGHT,-7>,0.75 }
  cylinder { <15,TOTHEIGHT,0>,<17,TSSHEIGHT,-7>,0.75 }
  cylinder { <15,TOTHEIGHT,0>,<17,TSSHEIGHT,7>,0.75 }
  cylinder { <-15,TOTHEIGHT,0>,<-17,TSSHEIGHT,7>,0.75 }
  //vier bollen in midden
  sphere { <-17,TSSHEIGHT,-7>, 0.75 }
  sphere { <17,TSSHEIGHT,7>, 0.75 }
  sphere { <17,TSSHEIGHT,-7>, 0.75 }
  sphere { <-17,TSSHEIGHT,7>, 0.75 }
  ////////////
#ifndef (FAST)
  texture { Gray_Texture2 }
#else
  pigment { color Silver }
#end
}

#declare BAL = union {
  sphere { <0,-19,0>,3
#ifndef (FAST)
    texture { Ball_Texture }
#else
    pigment { color Silver }
#end
  }
//  cylinder { <0,-15,0>,<0,0,0>,.1
  cylinder { <0,-19,0>,<0,0,0>,.1
#ifndef (FAST)
    texture { Gray_Texture2 }
#else
    pigment { color Red }
#end
    no_shadow
  }
}

union {
  object { BALK }
  object { VOET }
  object { BAL rotate <0,0,-30> translate <-12,25,0> }  //25 was 21
  object { BAL translate <-6,25,0> }
  object { BAL translate <0,25,0> }
  object { BAL translate <6,25,0> }
  object { BAL translate <12,25,0> }
  translate <0,-1,20>
}

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//------------------------------------------------------------------->
