// Persistence of Vision Ray Tracer Scene Description File
// File: Books.inc
// Vers: 3.01 Watcom Win32
// Desc: A file for the creation of rows or stacks of books
// Date: April 18, 1997
// Auth: Sonya Roberts
// Note: Creates simple books shapes that are meant to be
//       seen from a distance, not closeup; the books are
//       only minimally detailed.

#ifndef (True)      #declare True  = 1          #end
#ifndef (False)     #declare False = 0          #end
#ifndef (RowLength)	#declare RowLength=2		#end	// How long a row of books to create (X-Axis)
#ifndef (RowHeight)	#declare RowHeight=.75		#end	// How tall a row of books to create (Y-Axis)
#ifndef (RowDepth)	#declare RowDepth=.5		#end	// How deep a row of books to create (Z-Axis)
#ifndef (NumBooks)	#declare NumBooks=10		#end	// Approximate number of books in the row
#ifndef (VariThick)	#declare VariThick=.1		#end	// Decimal Percentage by which thickness of books are to vary.
#ifndef (VariHeight)	#declare VariHeight=.05		#end	// Decimal Percenatge by which height of books are to vary.
#ifndef (VariDepth)	#declare VariDepth=.05		#end	// Decimal Percentage by which depth of books are to vary.
#ifndef (BookSeed)	#declare BookSeed=seed(1)	#end	// Seed value to use for random numbers
#ifndef (VariColours)	#declare VariColours=True	#end	// If true, colours of bindings are random; otherwise uses a supplied texture
#ifndef (VariAlign)	#declare VariAlign=.1		#end	// Decimal Percentage of RowDepth by which spines of books are to misaligned
#ifndef (StackStyle)	#declare StackStyle=0		#end	// 0=Shelved (Bottom Edges Even), 1=Nicely Stacked, 2=Messily Stacked
#ifndef (FillerColour)	#declare FillerColour=1		#end	// 0=Plain White, 1=Gray Gradient
#ifndef (ExactLength)	#declare ExactLength=True	#end	// 0=NumBooks More Important Than RowLength, 1=Vice Versa
#ifndef (Titles)	#declare Titles=False		#end	// 0=Plain Covers, 1=Titles on Spines
#ifndef (TitleFont) #declare TitleFont="c:\Windows\fonts\ashley__.ttf" #end

#if (VariColours=False)
	#declare Bindings=rgb <.35+(rand(BookSeed)*.5),.35+(rand(BookSeed)*.5),.35+(rand(BookSeed)*.5)>
#end

#declare TSeed=seed(1000+int(rand(BookSeed)*1000))

#declare X1=1
#declare LengthSoFar=0
#declare SmallestRemainder=RowLength-((LengthSoFar/NumBooks)*(1+VariThick))
#declare StandardWidth=RowLength/NumBooks
union {
	#while (LengthSoFar<SmallestRemainder)
		#declare BookWidth=StandardWidth+(StandardWidth*((rand(BookSeed)*(VariThick*2))-VariThick))
		#declare BookHeight=RowHeight-(RowHeight*(rand(BookSeed)*VariHeight))
		#declare BookDepth=RowDepth-(RowDepth*(rand(BookSeed)*VariDepth))

		union {
			difference {
				union {
					cylinder {<0,0,0>,<0,BookHeight,0>,BookWidth/2	scale <1,1,.25>}
					box {<-BookWidth/2,0,0>,<BookWidth/2,BookHeight,BookDepth>}
				}
				union {
					cylinder {<0,0,0>,<0,BookHeight,0>,BookWidth/2	scale <1,1,.25>}
					box {<-BookWidth/2,0,0>,<BookWidth/2,BookHeight,BookDepth>}
					scale <.9,1.1,1>
					translate <0,-BookHeight*.05,BookDepth*.1>
				}
				#if (VariColours=True)
					#declare Bindings=rgb <.35+(rand(BookSeed)*.5),.35+(rand(BookSeed)*.5),.35+(rand(BookSeed)*.5)>
				#end
				pigment {color Bindings}
			}
			#if (Titles=True)
				#include "titles.inc"

				#declare TextColor=int(rand(BookSeed)*3.9)
				text {
					ttf "c:\Windows\fonts\ashley__.ttf"
					BookTitle
					.1,0
					translate <0,0,0>
					scale <BookHeight/8,BookHeight/8,1>
					rotate z*-90
					translate <0,BookHeight*.8,-BookWidth/8>
					#switch (TextColor)
						case (0)
							pigment {color Bindings*2}
						#break
						case (1)
							pigment {color White-Bindings}
						#break
						case (2)	pigment {color Black}	#break
						case (3)	pigment {color White}	#break
					#end
				}
			#end
			box {
				<-(BookWidth/2),BookHeight*.025,0>,<BookWidth/2,BookHeight-(BookHeight*.025),BookDepth*.975>
				scale <.9,1,1>
				#switch (FillerColour)
					#case (0)	// Default Plain White
						pigment {White}
						finish {ambient .3}
					#break }

					#case (1)	// Gray Gradient
						texture {
							pigment {
								gradient x
								turbulence 0.01
								color_map {
									[0.00 color rgb<1.000, 1.000, 1.000>]
									[0.05 color rgb<0.753, 0.753, 0.753>]
									[0.05 color rgb<0.918, 0.918, 0.918>]
									[0.09 color rgb<0.718, 0.718, 0.718>]
									[0.15 color rgb<0.816, 0.816, 0.816>]
									[0.21 color rgb<0.918, 0.918, 0.918>]
									[0.25 color rgb<0.784, 0.784, 0.784>]
									[0.28 color rgb<0.980, 0.980, 0.980>]
									[0.36 color rgb<0.710, 0.710, 0.710>]
									[0.42 color rgb<0.867, 0.867, 0.867>]
									[0.47 color rgb<0.933, 0.933, 0.933>]
									[0.59 color rgb<0.675, 0.675, 0.675>]
									[0.68 color rgb<1.000, 1.000, 1.000>]
									[0.75 color rgb<0.776, 0.776, 0.776>]
									[0.84 color rgb<0.878, 0.878, 0.878>]
									[0.92 color rgb<1.000, 1.000, 1.000>]
									[0.95 color rgb<0.784, 0.784, 0.784>]
									[1.00 color rgb<1.000, 1.000, 1.000>]
								}
							}
							finish {
								ambient 0.5
								brilliance 1.5
							}
							scale <BookWidth,1,1>
							translate <rand(BookSeed)*RowLength,0,0>
						}
					#break
				#end
			}

			#switch (StackStyle)
				#case (0)	// Shelved (Bottom Edges Level, runs in the positive X direction)
					translate <LengthSoFar+(BookWidth/2),0,-(rand(BookSeed)*(BookDepth*VariAlign))>
				#break

				#case (1)	// Nicely Stacked (Varies slightly back and forth, and is vertical)
					rotate z*90
					translate <BookHeight/2,0,-BookDepth/2>
					translate <rand(BookSeed)*(BookHeight/10),LengthSoFar+(BookWidth/2),rand(BookSeed)*(BookDepth/10)>
					rotate y*((rand(BookSeed)*20)-10)
				#break

				#case (2)	// Messily Stacked (Piled Up Any Which Way, also vertical)
					rotate z*90
					translate <BookHeight/2,LengthSoFar+(BookWidth/2),-BookDepth/2>
					rotate y*(rand(BookSeed)*360)
				#break
			#end
		}
		#declare X1=X1+1
		#declare LengthSoFar=LengthSoFar+BookWidth
	#end

	#if (LengthSoFar<RowLength & ExactLength=True)
		#declare BookWidth=RowLength-LengthSoFar
		#declare BookHeight=RowHeight-(RowHeight*(rand(BookSeed)*VariHeight))
		#declare BookDepth=RowDepth-(RowDepth*(rand(BookSeed)*VariDepth))

		union {
			difference {
				union {
					cylinder {<0,0,0>,<0,BookHeight,0>,BookWidth/2	scale <1,1,.25>}
					box {<-BookWidth/2,0,0>,<BookWidth/2,BookHeight,BookDepth>}
				}
				union {
					cylinder {<0,0,0>,<0,BookHeight,0>,BookWidth/2	scale <1,1,.25>}
					box {<-BookWidth/2,0,0>,<BookWidth/2,BookHeight,BookDepth>}
					scale <.9,1.1,1>
					translate <0,-BookHeight*.05,BookDepth*.1>
				}
				#if (VariColours=True)
					#declare Bindings=rgb <.35+(rand(BookSeed)*.5),.35+(rand(BookSeed)*.5),.35+(rand(BookSeed)*.5)>
				#end
				pigment {color Bindings}
			}
			#if (Titles=True)
				#include "titles.inc"

				#declare TextColor=int(rand(BookSeed)*3.9)
				text {
					ttf "c:\Windows\fonts\ashley__.ttf"
					BookTitle
					.1,0
					translate <0,0,0>
					scale <BookHeight/8,BookHeight/8,1>
					rotate z*-90
					translate <0,BookHeight*.8,-BookWidth/8>
					#switch (TextColor)
						case (0)
							pigment {color Bindings*2}
						#break
						case (1)
							pigment {color (White-Bindings)}
						#break
						case (2)	pigment {color Black}	#break
						case (3)	pigment {color White}	#break
					#end
				}
			#end
			box {
				<-(BookWidth/2),BookHeight*.025,0>,<BookWidth/2,BookHeight-(BookHeight*.025),BookDepth*.975>
				scale <.9,1,1>
				#switch (FillerColour)
					#case (0)	// Default Plain White
						pigment {color White}
						finish {ambient .3}
					#break

					#case (1)	// Gray Gradient
						texture {
							pigment {
								gradient x
								turbulence 0.01
								color_map {
									[0.00 color rgb<1.000, 1.000, 1.000>]
									[0.05 color rgb<0.753, 0.753, 0.753>]
									[0.05 color rgb<0.918, 0.918, 0.918>]
									[0.09 color rgb<0.718, 0.718, 0.718>]
									[0.15 color rgb<0.816, 0.816, 0.816>]
									[0.21 color rgb<0.918, 0.918, 0.918>]
									[0.25 color rgb<0.784, 0.784, 0.784>]
									[0.28 color rgb<0.980, 0.980, 0.980>]
									[0.36 color rgb<0.710, 0.710, 0.710>]
									[0.42 color rgb<0.867, 0.867, 0.867>]
									[0.47 color rgb<0.933, 0.933, 0.933>]
									[0.59 color rgb<0.675, 0.675, 0.675>]
									[0.68 color rgb<1.000, 1.000, 1.000>]
									[0.75 color rgb<0.776, 0.776, 0.776>]
									[0.84 color rgb<0.878, 0.878, 0.878>]
									[0.92 color rgb<1.000, 1.000, 1.000>]
									[0.95 color rgb<0.784, 0.784, 0.784>]
									[1.00 color rgb<1.000, 1.000, 1.000>]
								}
							}
							finish {
								ambient 0.5
								brilliance 1.5
							}
							scale <BookWidth,1,1>
							translate <rand(BookSeed)*RowLength,0,0>
						}
					#break
				#end
			}

			#switch (StackStyle)
				#case (0)	// Shelved (Bottom Edges Level, runs in the positive X direction)
					translate <LengthSoFar+(BookWidth/2),0,-(rand(BookSeed)*(BookDepth*VariAlign))>
				#break

				#case (1)	// Nicely Stacked (Varies slightly back and forth, and is vertical)
					rotate z*90
					translate <BookHeight/2,0,-BookDepth/2>
					translate <rand(BookSeed)*(BookHeight/10),LengthSoFar+(BookWidth/2),rand(BookSeed)*(BookDepth/10)>
					rotate y*((rand(BookSeed)*20)-10)
				#break

				#case (2)	// Messily Stacked (Piled Up Any Which Way, also vertical)
					rotate z*90
					translate <BookHeight/2,LengthSoFar+(BookWidth/2),-BookDepth/2>
					rotate y*(rand(BookSeed)*360)
				#break
			#end
		}
		#declare LengthSoFar=LengthSoFar+BookWidth
	#end
}
