/*
 POV-Ray Include File
 Name:   web.inc
 Date:   August 2, 1997
 Author: Raul Beltran   (espiritudelvino@hotmail.com)

 This file will create a White spider web ...
 It's very simple to use, here's a little example:

object{ #declare Arms     = 30
        #declare Rings    = 6
        #decalre Spider   = 1
        #declare Centered = 0
        #include "web.inc"
        #end
        scale .5
        rotate<-45,-45,0>
        }

 This will create a web with 30 arms and 6 rings (doh!)
 with a Thickness of .007 (default value)
 and a little spider placed randomly somewhere on the web.
 The Arms will finish 3 units after the last ring, (default value)
 but this can be changed in the "Extension" variable.
 I suggest not to use the spider and/or the web
 for close-ups because the spider sucks!
 and so does the web...
 I will improve the details in the future.
*/

#ifndef (True)		#declare True      = 1	      #end
#ifndef (False)		#declare False     = 0	      #end
#ifndef (Arms)	    #declare Arms      = 15	      #end
#ifndef (Rings)	    #declare Rings     = 5	      #end
#ifndef (Spider)    #declare Spider    = True     #end
#ifndef (Centered)  #declare Centered  = False    #end
#ifndef (Thickness)	#declare Thickness = .007     #end
#ifndef (Extension)	#declare Extension = 3        #end

#debug "\nWeaving...\n"
#debug concat("Web with ",str(Arms,0,0)," arms, ",str(Rings,0,0)," rings and a thickness of ",str(Thickness,0,4),"\tCool...\n")

#declare spidy =
union{
   union {
      sphere { 0*x, .1 scale<1,.3,1> }
      object { pata rotate  45*y }
      object { pata rotate  15*y }
      object { pata rotate -15*y }
      object { pata rotate -45*y }
      pigment{ DarkSlateGray }
      }
   union {
      sphere { 0*x, .02 translate<-.05,.03,-.08> }
      sphere { 0*x, .02 translate<0.05,.03,-.08> }
      pigment { Red }
      finish { ambient 1 diffuse 0 reflection 1 refraction 1 }
      }
      no_shadow
  }


// Web...
union{
union{
   #declare Count = 0
   #declare Incremento = 0
   #while (Count < Arms)
      #declare Incremento = Count*(360/Arms)
      cylinder{ 0*y, (Extension+(.2*Rings))*y, Thickness rotate Incremento*z }
      #declare Count = Count+1
   #end

   #declare Count = 0
   #declare Incremento = 0
   #while (Count < Rings)
      #declare Incremento = Incremento+.2
      torus{ Incremento, Thickness rotate 90*x }
      #declare Count = Count+1
   #end

   pigment{ White filter .9 }
}

// Spider
#if (Spider)
   #if (Centered)
      object{ spidy rotate -90*x translate -.015*z}
   #else
      #declare transx = rand(seed(Incremento))
      #declare transy = rand(seed(Incremento))
      object{ spidy rotate 90*x translate <transx,transy,-.015>}
   #end
#else
#end
}
