// Persistence of Vision Ray Tracer Scene Description File
// File: book.inc
// Vers: 3
// Desc: HOW TO ESCAPE FROM A SAFE by Harry Houdini (a totally imaginary book)
// Date: 8/24/1997
// Auth: Steve Sloan II

// Uses three image maps:
//        Name            Dimensions   TC                Description
// recess/bk_front.gif    312 x  514   11    Harry Houdini book cover (HOW TO ESCAPE A SAFE)
// recess/bk_spine.gif    120 x 1335    1    The book's spine
// recess/meltorme.gif    223 x  326   18    Harry's favorite singer, on his bookmark

#declare book_color = color Gray90

#declare book_width = 7.3
#declare book_height = 8.9
#declare book_thickness = 1 //was 0.4
#declare cover_thickness = 0.01

#declare bookmark_width = 1.5
#declare bookmark_length = 6

#declare front_cover =
union {
    box {
        <0, -cover_thickness, -book_height/2>,
        <book_width, 0, book_height/2>
        pigment {
            image_map {
                gif "recess/bk_front.gif"
                map_type 0
                interpolate 2
                transmit 11 1.0
                once
            }
            rotate 90*x
            translate <-0.5, 0, -0.5>
            scale <312/514, 1, 1>
            scale book_height*0.9
            translate book_width*x/2
        }
        translate 0.0001*y
    }
    box {
        <0, -cover_thickness, -book_height/2>,
        <book_width, 0, book_height/2>
        pigment { color book_color }
    }
}

#declare back_cover =
box {
    <0, 0, -book_height/2>,
    <book_width, cover_thickness, book_height/2>
    pigment { color book_color }
}

#declare spine =
union {
    box {
        <0, -book_thickness/2, -book_height/2>,
        <cover_thickness, book_thickness/2, book_height/2>
        pigment { color book_color }
    }
    box {
        <0, -book_thickness/2, -book_height/2>,
        <cover_thickness, book_thickness/2, book_height/2>
        pigment {
            image_map {
                gif "recess/bk_spine.gif"
                map_type 0
                interpolate 2
                transmit 1 1.0
                once
            }
            rotate 90*x
            rotate 90*z
            translate <0, -0.5, -0.5>
            scale <1, 120/1335, 1>
            scale book_height
        }
        translate -0.0001*x
    }
}

#declare pages =
box {
    <cover_thickness, -book_thickness/2 + cover_thickness, -book_height/2>,
    <book_width, book_thickness/2 - cover_thickness, book_height/2>
    pigment {
        gradient y
        color_map {
            [0.0 White]
            [0.5 White]
            [0.5 Black]
            [1.0 Black]
        }
        frequency 10
    }
}

#declare bookmark =
union {
    box {
        <-bookmark_width/2, -cover_thickness/2, -bookmark_length/2>,
        <bookmark_width/2, cover_thickness/2, bookmark_length/2>
        pigment { color Green }
    }
    box {
        <-bookmark_width/2, -cover_thickness/2, -bookmark_length/2>,
        <bookmark_width/2, cover_thickness/2, bookmark_length/2>
        pigment {
            image_map {
                gif "recess/meltorme.gif"
                map_type 0
                interpolate 2
                transmit 18 1.0
                once
            }
            rotate 90*x
            translate <-0.5, 0, -0.5>
            scale <1, 1, 326/223>
            scale bookmark_width*0.95
            translate <0, 0, (bookmark_length - bookmark_width*326/223)/2 >
        }
        translate 0.0001*y
    }
    translate <bookmark_width/2 + cover_thickness, 0, 0.4*book_height>
}

#declare book =
union {
    object { front_cover translate book_thickness*y/2 }
    object { back_cover translate -book_thickness*y/2 }
    object { spine }
    object { pages }
    object { bookmark }
    translate book_thickness*y/2
}

