// Persistence of Vision Ray Tracer Scene Description File
// File: cards.inc
// Vers: 3
// Desc: A Playing card
// Date: 8/13/1997
// Auth: Steve Sloan II

#version 3

#include "colors.inc"

global_settings {
    assumed_gamma 1.0
}

// Checking Parameters
// ----------------------------------------
// Check the denomination of the card (1...10, j, k, q, a)
#ifndef (denomination)
    #declare denomination = "8"
#end

// Check the suit of the card (heart, club, spade, diamond)
#ifndef (suit)
    #declare suit = "heart"
#end

// Check the image on the back of the card
#ifndef (back_label)
    #declare back_label = "recess/meltorme.gif"
#end

// Create the card
// ----------------------------------------
#declare card_thickness = 0.7/56
#declare card_height = 3.45
#declare card_width = 2.5
#declare card_radius = 0.15

#declare card_shape =
union {
    box {
        <-card_width/2 + card_radius, -card_height / 2, 0>,
        <card_width/2 - card_radius, card_height/2, card_thickness>
    }
    box {
        <-card_width/2, -card_height/2 + card_radius, 0>,
        <card_width/2, card_height/2 - card_radius, card_thickness>
    }
    cylinder {
        0*z, card_thickness*z, card_radius
        translate <-card_width/2 + card_radius, -card_height/2 + card_radius, 0>
    }
    cylinder {
        0*z, card_thickness*z, card_radius
        translate <card_width/2 - card_radius, card_height/2 - card_radius, 0>
    }
    cylinder {
        0*z, card_thickness*z, card_radius
        translate <-card_width/2 + card_radius, card_height/2 - card_radius, 0>
    }
    cylinder {
        0*z, card_thickness*z, card_radius
        translate <card_width/2 - card_radius, -card_height/2 + card_radius, 0>
    }
}

#declare label_shape = box { <-1, -1, 0>, <1, 1, card_thickness> }

// Suits
#if (strcmp(suit, "heart"))
      #declare color_file = "r"
  #end
#if (strcmp(suit, "club"))
      #declare color_file = "b"
  #end
#if (strcmp(suit, "spade"))
      #declare color_file = "b"
  #end
#if (strcmp(suit, "diamond"))
      #declare color_file = "r"
  #end

// Denominations
#if (strcmp(denomination, "1"))
      #declare den_file = "01"
      #declare num_of_suits = 1
  #end
#if (strcmp(denomination, "2"))
      #declare den_file = "02"
      #declare num_of_suits = 2
  #end
#if (strcmp(denomination, "3"))
      #declare den_file = "03"
      #declare num_of_suits = 3
  #end
#if (strcmp(denomination, "4"))
      #declare den_file = "04"
      #declare num_of_suits = 4
  #end
#if (strcmp(denomination, "5"))
      #declare den_file = "05"
      #declare num_of_suits = 5
  #end
#if (strcmp(denomination, "6"))
      #declare den_file = "06"
      #declare num_of_suits = 6
  #end
#if (strcmp(denomination, "7"))
      #declare den_file = "07"
      #declare num_of_suits = 7
  #end
#if (strcmp(denomination, "8"))
      #declare den_file = "08"
      #declare num_of_suits = 8
  #end
#if (strcmp(denomination, "9"))
      #declare den_file = "09"
      #declare num_of_suits = 9
  #end
#if (strcmp(denomination, "10"))
      #declare den_file = "10"
      #declare num_of_suits = 10
  #end
#if (strcmp(denomination, "j"))
      #declare den_file = "jack"
      #declare num_of_suits = 1
  #end
#if (strcmp(denomination, "q"))
      #declare den_file = "queen"
      #declare num_of_suits = 1
  #end
#if (strcmp(denomination, "k"))
      #declare den_file = "king"
      #declare num_of_suits = 1
  #end
#if (strcmp(denomination, "a"))
      #declare den_file = "ace"
      #declare num_of_suits = 1
  #end

// Set the transparent color
#if (strcmp(color_file, "b"))
      #declare trans_color = 1
  #else
      #declare trans_color = 15
  #end

#render concat("Your card is a ", den_file, " of ", suit, "s, and its color is '",
    color_file, "'.\n")

#declare suit_label =
object {
    label_shape
    pigment {
        image_map {
            gif concat("recess/", color_file, suit, ".gif")
            map_type 0
            interpolate 2
            once
            transmit trans_color 1.0
        }

        translate <-0.5, -0.5, 0>
    }
    rotate 180*y
}

#declare den_label =
object {
    label_shape
    pigment {
        image_map {
            gif concat("recess/", color_file, den_file, ".gif")
            map_type 0
            interpolate 2
            once
            transmit trans_color 1.0
        }

        translate <-0.5, -0.5, 0>
    }
    rotate 180*y
}

#declare center_suits =
union {
    // Cards with 3, 5, 9, J, Q, K, A have centered suit labels
    #if(strcmp(denomination, "3") | strcmp(denomination, "5") | strcmp(denomination, "9") |
            strcmp(denomination, "j") | strcmp(denomination, "q") |
            strcmp(denomination, "k") | strcmp(denomination, "a") )
        object { suit_label scale <0.65, 0.65, 1> }
      #end
    // Cards with 8, 10 have two suit labels above and below the center
    #if(strcmp(denomination, "8"))
        object { suit_label scale <0.65, 0.65, 1>  translate 0.5*y}
//        object { suit_label scale <0.65, 0.65, 1>  translate 0.5*y rotate 180*z}
      #end
    // Cards with 8, 10 have two suit labels above and below the center
    #if(strcmp(denomination, "10") )
        object { suit_label scale <0.65, 0.65, 1>  translate 0.7*y}
        object { suit_label scale <0.65, 0.65, 1>  translate 0.7*y rotate 180*z}
      #end
}

#declare labelling =
union {
//    object { suit_label scale <0.65, 0.65, 1>}
//    object { den_label scale <0.65, 0.65, 1>}
    object { center_suits }
    translate 11*card_thickness*z/10
}

#declare card =
union {
    object { card_shape pigment { color White } }
    object {
        label_shape
        pigment {
            image_map {
                gif back_label
                map_type 0
                interpolate 2
                once
            }

            translate <-0.5, -0.5, 0>
            scale <2.1, 3.15, 1> // GIF dimensions 223, 286
        }
        translate card_thickness*z/10
        rotate 180*y
    }
    object { labelling }
}

