// objects.inc - misc. objects for romagic1.

#declare GroundFire1 = sphere
{
   0,1
   pigment { color rgbt <1,1,1,1> }
   halo
   {
      emitting
      spherical_mapping
      linear
      turbulence 0.3
      color_map
      {
         [ 0   color rgbt <1, 0, 0,  1.0> ]
         [ 0.7 color rgbt <1, 1, 0, -1.5> ]
         [ 0.8 color rgbt <1, 1, 1, -2.0> ]
         [ 1   color rgbt <1, 1, 1, -2.5> ]
      }
      samples 10
   }
   hollow
   scale <0.1,0.75,0.1>*2
}

#declare GroundFire2 = sphere
{
   0,1
   pigment { color rgbt <1,1,1,1> }
   halo
   {
      emitting
      spherical_mapping
      linear
      turbulence 0.2
      color_map
      {
         [ 0   color rgbt <0.2, 0, 1,  1.0> ]
         [ 0.7 color rgbt <1, 1, 0, -1.5> ]
//         [ 0.7 color rgbt <0.4, 0.4, 0, -1.5> ]
         [ 0.8 color rgbt <0.5, 1, 1, -2.0> ]
         [ 1   color rgbt <1, 1, 1, -2.5> ]
      }
      samples 10
   }
   hollow
   scale <1,0.1,1>*2
}

#declare TarBlob = sphere
{
   0,1
   texture
   {
      pigment { color rgb <0,0,0> }
      finish
      {
         reflection 0.1
         specular 0.5
      }
   }
   scale <1,0.05,1>*2
}

#declare BlankPlate = box { -1*<1,0.01,1>,<1,0.01,1> }

#declare BallLightningForm = merge
{
   object { BlankPlate }
   object { BlankPlate rotate  45*x }
   object { BlankPlate rotate  90*x }
   object { BlankPlate rotate 135*x }
   object { BlankPlate rotate  45*z }
   object { BlankPlate rotate  90*z }
   object { BlankPlate rotate 135*z }
   clipped_by { sphere {0,1} }
   bounded_by { clipped_by }
   rotate 30
   no_shadow
}

#declare EyeSpy = union
{
   difference
   {
      sphere { 0,0.1 texture { T_Gold_5E } }
      sphere { 0,0.09 texture { T_Chrome_5E } translate 0.02*x }
   }
   sphere { 0,0.03 texture {T_Ruby_Glass} }
   scale 4
}

#declare EyeSpyCrowd = union
{
   #declare I = 0
   #while (I<EyeSpyCount)
      object
      {
         EyeSpy
         // Throw in some random rotation (folks looking at different points):
         rotate (rand(ES_R3)*10-5)*y
         // Move up to the focal point:
         translate 1*y
         // Move out to the edge:
         translate -1*(AmpInnerRadius+AmpStepWidth*(1+rand(ES_R1)*3))*x
         // Move up again, but rotate the view vector down:
         rotate -1*(5+rand(ES_R2)*10)*z
         // Finally, move around to the correct position:
         rotate I*(360/EyeSpyCount)*y
      }
      #declare I = I + 1
   #end
}
