
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date: 12/08/97 - ??/??/97
// Auth: Anonymous


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


// ==== Additional Includes ====
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"

global_settings { max_trace_level 50 }

camera
{
  location  <-15.0 , 0.0 , 10.0>
  look_at   <0.0 , 0.0 , 20.0>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <0, 18, 0>
}

// create a sphere shape
sphere
{
  <0, 18, 0> // center of sphere <X Y Z>
  2       // radius of sphere
  pigment
  {
    red 1 green 1 blue 0.9 filter 0.9
  }
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling
}

polygon
{
  4,
  <-30,-20>,
  <30,-20>,
  <30,20>,
  <-30,20>
  pigment
  {
    image_map
    {
      tga "imap1.tga"
    }
    scale <10,10,1>
  }
  normal
  {
    bump_map
    {
      tga "hmap1.tga"
    }
    scale <10,10,1>
  }
  translate z*20
}

polygon
{
  4,
  <-20,-20>,
  <20,-20>,
  <20,20>,
  <-20,20>
  pigment
  {
    image_map
    {
      tga "imap1.tga"
    }
    scale <10,10,1>
  }
  normal
  {
    bump_map
    {
      tga "hmap1.tga"
    }
    scale <10,10,1>
  }
  translate z*30
  rotate y*90
}

polygon
{
  4,
  <-30,-20>,
  <30,-20>,
  <30,20>,
  <-30,20>
  pigment
  {
    image_map
    {
      tga "imap1.tga"
    }
    scale <10,10,1>
  }
  normal
  {
    bump_map
    {
      tga "hmap1.tga"
    }
    scale <10,10,1>
  }
  translate z*20
  rotate y*180
}

polygon
{
  4,
  <-20,-20>,
  <20,-20>,
  <20,20>,
  <-20,20>
  pigment
  {
    image_map
    {
      tga "imap1.tga"
    }
    scale <10,10,1>
  }
  normal
  {
    bump_map
    {
      tga "hmap1.tga"
    }
    scale <10,10,1>
  }
  translate z*30
  rotate y*270
}

polygon
{
  4,
  <-30,-20>,
  <30,-20>,
  <30,20>,
  <-30,20>
  pigment
  {
    image_map
    {
      tga "imap2.tga"
    }
    scale <10,10,1>
  }
  normal
  {
    bump_map
    {
      tga "hmap2.tga"
    }
    scale <10,10,1>
  }
  translate z*-20
  rotate x*90
}

polygon
{
  4,
  <-30,-20>,
  <30,-20>,
  <30,20>,
  <-30,20>
  pigment
  {
    hexagon White,Black,Grey
    rotate x*90
    scale <5,5,5>
  }
  translate z*-20
  rotate x*270
}

#declare frame0_0=cylinder{<-2,0,-4.5>,<-2,0,4.5>,0.5 open}
#declare frame0_1=prism{linear_sweep 0,0.5,3,<-2.5,-4.5>,<2,0>,<-2.5,4.5>}
#declare frame1_0=cylinder{<-2.5,0,-4>,<2.5,0,-4>,0.5 open}
#declare frame1_1=prism{linear_sweep 0,0.5,3,<-2.5,-4.5>,<0,-2>,<2.5,-4.5>}
#declare frame2_0=cylinder{<2,0,-4.5>,<2,0,4.5>,0.5 open}
#declare frame2_1=prism{linear_sweep 0,0.5,3,<2.5,-4.5>,<-2,0>,<2.5,4.5>}
#declare frame3_0=cylinder{<-2.5,0,4>,<2.5,0,4>,0.5 open}
#declare frame3_1=prism{linear_sweep 0,0.5,3,<-2.5,4.5>,<0,2>,<2.5,4.5>}
#declare frame0=intersection{object{frame0_0} object{frame0_1}}
#declare frame1=intersection{object{frame1_0} object{frame1_1}}
#declare frame2=intersection{object{frame2_0} object{frame2_1}}
#declare frame3=intersection{object{frame3_0} object{frame3_1}}
#declare frame=union{object{frame0} object{frame1} object{frame2} object{frame3}}
#declare mirror=polygon{4,<-2,-4>,<2,-4>,<2,4>,<-2,4> finish{diffuse 0 ambient 0 reflection 1 specular 0.3 roughness 0.2}}
#declare mirrorframe=union{object{frame} object{mirror rotate x*90 translate y*0.25} }

object
{
  mirrorframe
  rotate <270,0,0>
  translate <0,0,20>
  texture
  {
    T_Wood8
  }
}

object
{
  mirrorframe
  rotate <270,90,0>
  translate <30,0,0>
  texture
  {
    T_Wood8
  }
}

object
{
  mirrorframe
  rotate <270,180,0>
  translate <0,0,-20>
  texture
  {
    T_Wood8
  }
}

object
{
  mirrorframe
  rotate <270,270,0>
  translate <-30,0,0>
  texture
  {
    T_Wood8
  }
}
