//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 24 textures and 84 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 08/13/1997    (13.08.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <1.000, -8.000, 4.200>
  direction <0.0,     0.0,  4.2915>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-0.201, 0.777, 2.854>
}

// *******  L I G H T S *******
light_source {   // Light002
  <32.198, -1.091, 3.263>
  color rgb <0.60, 0.60, 0.60>
}

light_source {   // Light001
  <-1.00, -10.000, 6.000>
  color rgb <0.5, 0.5, 0.5>
}


// ********  TEXTURES  *******
//

#include "slstorm.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

#declare BoltsMade1 = intersection {
  cylinder { // BigBolts1
    <0,0,1>, <0,0,0>, 1
    texture {
      Lightning2
    }
    scale 2.0
    translate  <8.955954, 3.956099, 0.3>
  }
  box { // Bolts2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Lightning2
    }
    scale <0.35, 0.35, 0.7>
    rotate -45.0*z
    translate  <8.964916, 3.950928, 1.194776>
  }
  scale <1.17, 1.17, 1.2>
  rotate -22.5*z
  translate  <-2.278227, 15.730373, -0.231145>
}
//
// Include file contains 'Wind_Bottle1'
//
#include "slstorm.in1"
#declare Wind_Bottle1 = object {
  Wind_Bottle1_Raw
  texture {
    MyGlassLght
  }
  scale 0.6
  translate  <15.891056, 5.938563, -0.493221>
}
#declare Done_LghtBot = union {
  object { Wind_Bottle1 }
  cone { // CorkTop5
    <0,0,0>, 0.68, <0,0,1>, 1.1
    texture {
      CorkWhite
    }
    scale <0.215902, 0.2, 0.193378>
    rotate <0.0, 0.0, 0.0>
    translate  <15.89011, 5.92539, -0.05005>
  }
  scale <1.0, 1.0, 2.0>
  rotate -69.640694*z
  translate  <-1.909539, 28.818611, 2.431807>
}
#declare BoltsMade2 = intersection {
  cylinder { // BigBolts2
    <0,0,1>, <0,0,0>, 1
    texture {
      Lightning2
    }
    scale 2.0
    translate  <8.955954, 3.956099, 0.3>
  }
  box { // Bolts3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Lightning2
    }
    scale <0.35, 0.35, 0.7>
    rotate -45.0*z
    translate  <9.226162, 4.10395, 1.194776>
  }
  scale <1.17, 1.17, 1.2>
  rotate -30.359306*z
  translate  <-12.217262, 11.169744, -0.231145>
}
#declare BoltCut = intersection {
  object { BoltsMade2 }
  box { // BoltDif
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Lightning2
    }
    scale <0.4095, 0.234, 0.9>
    rotate -75.359306*z
    translate  <-0.651829, 9.830067, 1.186984>
  }
  rotate -69.640694*z
  translate  <0.283023, 11.824311, 0.0>
}
#declare Lning_Bottle = union {
  object { BoltsMade1 }
  object { Done_LghtBot }
  object { BoltCut }
  hollow
  rotate 69.640694*z
  translate  <10.952966, -4.3712, 0.0>
}
//
// Include file contains 'Rain_Bottle'
//
#include "slstorm.in2"
#declare Rain_Bottle = object {
  Rain_Bottle_Raw
  texture {
    MyGlassRain1
  }
  scale 0.6
  translate  <15.891056, 5.938563, -0.493221>
}
//
// Include file contains 'WaterNBot'
//
#include "slstorm.in3"
#declare WaterNBot = object {
  WaterNBot_Raw
  texture {
    Water
  }
  scale 0.55
  translate  <15.891056, 5.938563, -0.493221>
}
#declare Done_RainBot = union {
  object { Rain_Bottle }
  cone { // CorkTop1
    <0,0,0>, 0.68, <0,0,1>, 1.1
    texture {
      CorkBlue
    }
    scale <0.215902, 0.2, 0.193378>
    rotate <0.0, 0.0, 0.0>
    translate  <15.89011, 5.92539, -0.05005>
  }
  object { WaterNBot }
  scale <1.0, 1.0, 2.0>
  translate  <-6.956017, -1.947435, 2.55822>
}
// The following include file contains the definition for Drop1
#include "slstorm.in4"
#declare Drop1 = object {
  Drop1_Raw
  texture {
    Water
  }
  scale <0.06, 0.04875, 0.010763>
  rotate <-90.0, 45.0, -60.0>
  translate  <9.314213, 4.387682, 1.650153>
}
// The following include file contains the definition for Drop3
#include "slstorm.in5"
#declare Drop3 = object {
  Drop3_Raw
  texture {
    Water
  }
  scale <0.03, 0.03, 0.005212>
  rotate <-90.0, 45.0, -135.0>
  translate  <9.369966, 3.837521, 1.39>
}
// The following include file contains the definition for Drop4
#include "slstorm.in6"
#declare Drop4 = object {
  Drop4_Raw
  texture {
    Water
  }
  scale <0.096242, 0.096242, 0.01435>
  rotate <-90.0, 45.0, -135.0>
  translate  <9.051766, 3.530819, 1.363233>
}
// The following include file contains the definition for Drop5
#include "slstorm.in7"
#declare Drop5 = object {
  Drop5_Raw
  texture {
    Water
  }
  scale <0.02, 0.02, 0.005>
  rotate <-90.0, 45.0, 1.772719>
  translate  <8.934184, 4.50786, 1.989309>
}
// The following include file contains the definition for Drop6
#include "slstorm.in8"
#declare Drop6 = object {
  Drop6_Raw
  texture {
    Water
  }
  scale <0.03, 0.03, 0.01>
  rotate <-90.0, 45.0, 43.0>
  translate  <8.444995, 4.041453, 1.836503>
}
// The following include file contains the definition for Drop7
#include "slstorm.in9"
#declare Drop7 = object {
  Drop7_Raw
  texture {
    Water
  }
  scale <0.03, 0.03, 0.02>
  rotate <-90.0, 45.0, 135.0>
  translate  <8.558933, 3.846085, 1.7>
}
// The following include file contains the definition for Drop8
#include "slstorm.i10"
#declare Drop8 = object {
  Drop8_Raw
  texture {
    Water
  }
  scale <0.02, 0.01, 0.01>
  rotate <-90.0, 45.0, 43.0>
  translate  <8.494343, 3.989102, 1.7>
}
// The following include file contains the definition for Drop9
#include "slstorm.i11"
#declare Drop9 = object {
  Drop9_Raw
  texture {
    Water
  }
  scale 0.01
  rotate <-90.0, 45.0, 43.0>
  translate  <8.861575, 4.484712, 1.65>
}
// The following include file contains the definition for Drop10
#include "slstorm.i12"
#declare Drop10 = object {
  Drop10_Raw
  texture {
    Water
  }
  scale <0.02, 0.02, 0.01>
  rotate <-90.0, 45.0, 43.0>
  translate  <8.717182, 4.406647, 1.6>
}
// The following include file contains the definition for Drop11
#include "slstorm.i13"
#declare Drop11 = object {
  Drop11_Raw
  texture {
    Water
  }
  scale <0.02, 0.02, 0.01>
  rotate <-90.0, 45.0, -36.811005>
  translate  <9.101349, 4.459765, 1.852499>
}
// The following include file contains the definition for Drop12
#include "slstorm.i14"
#declare Drop12 = object {
  Drop12_Raw
  texture {
    Water
  }
  scale <0.02, 0.02, 0.01>
  rotate <-90.0, 45.0, 156.076874>
  translate  <8.892978, 3.509225, 1.568032>
}
// The following include file contains the definition for Drop13
#include "slstorm.i15"
#declare Drop13 = object {
  Drop13_Raw
  texture {
    Water
  }
  scale <0.02, 0.02, 0.01>
  rotate <-90.0, 45.0, -47.450588>
  translate  <9.315961, 4.382518, 1.951649>
}
// The following include file contains the definition for Drop14
#include "slstorm.i16"
#declare Drop14 = object {
  Drop14_Raw
  texture {
    Water
  }
  scale <0.03, 0.023, 0.01>
  rotate <-86.758125, 30.447689, -157.044754>
  translate  <9.274406, 3.625576, 1.772566>
}
// The following include file contains the definition for Drop15
#include "slstorm.i17"
#declare Drop15 = object {
  Drop15_Raw
  texture {
    Water
  }
  scale <0.02, 0.02, 0.01>
  rotate <-90.0, 45.0, -47.450588>
  translate  <9.317041, 4.382518, 1.884113>
}
// The following include file contains the definition for Drop16
#include "slstorm.i18"
#declare Drop16 = object {
  Drop16_Raw
  texture {
    Water
  }
  scale <0.02, 0.02, 0.01>
  rotate <-90.996803, 46.260948, -48.163166>
  translate  <9.325677, 4.382518, 1.812861>
}
// The following include file contains the definition for Drop17
#include "slstorm.i19"
#declare Drop17 = object {
  Drop17_Raw
  texture {
    Water
  }
  scale <0.02, 0.02, 0.01>
  rotate <-90.996803, 46.260948, -48.163166>
  translate  <9.326773, 4.382518, 1.764895>
}
#declare Rain = union {
  object { Done_RainBot }
  object { Drop1 }
  object { Drop3 }
  object { Drop4 }
  object { Drop5 }
  object { Drop6 }
  object { Drop7 }
  object { Drop8 }
  object { Drop9 }
  object { Drop10 }
  object { Drop11 }
  object { Drop12 }
  object { Drop13 }
  object { Drop14 }
  object { Drop15 }
  object { Drop16 }
  object { Drop17 }
  translate  <-12.305656, 6.108582, -0.126413>
}
//
// Include file contains 'Wind_Bottle'
//
#include "slstorm.i20"
#declare Wind_Bottle = object {
  Wind_Bottle_Raw
  texture {
    MyGlassLght
  }
  scale 0.6
  translate  <15.891056, 5.938563, -0.493221>
}
#declare Done_WindBot = union {
  object { Wind_Bottle }
  cone { // CorkTop3
    <0,0,0>, 0.68, <0,0,1>, 1.1
    texture {
      CorkGrey
    }
    scale <0.215902, 0.2, 0.193378>
    rotate <0.0, 0.0, 0.0>
    translate  <15.89011, 5.92539, -0.05005>
  }
  scale <1.0, 1.0, 2.0>
  rotate 69.640694*z
  translate  <0.416112, -19.697594, 2.431807>
}
//
// Include file contains 'Tornado'
//
#include "slstorm.i21"
#declare Tornado = object {
  Tornado_Raw
  texture {
    CloudTexture
  }
  scale 0.68
  rotate <180.0, 0.0, -110.359306>
  translate  <0.39169, -2.74725, 2.730283>
}
#declare WindCloud = union {
  object { Done_WindBot }
  cylinder { // Clouds
    <0,0,1>, <0,0,0>, 1
    texture {
      CloudTexture
    }
    scale <0.45, 0.45, 0.4>
    translate  <0.390528, -2.747818, 1.396356>
  }
  sphere { // Cloud3
    <0,0,0>,1
    texture {
      CloudTexture
    }
    scale <0.45, 0.45, 0.1>
    rotate <0.0, 0.0, 104.640694>
    translate  <0.381384, -2.746195, 0.395113>
  }
  cylinder { // Clouds1
    <0,0,1>, <0,0,0>, 1
    texture {
      CloudTexture
    }
    scale <0.45, 0.45, 0.4>
    rotate -24.0*z
    translate  <0.390528, -2.747818, 0.993109>
  }
  cylinder { // Clouds2
    <0,0,1>, <0,0,0>, 1
    texture {
      CloudTexture
    }
    scale <0.45, 0.45, 0.4>
    rotate -55.0*z
    translate  <0.390528, -2.747818, 0.590956>
  }
  cylinder { // Clouds3
    <0,0,1>, <0,0,0>, 1
    texture {
      CloudTexture
    }
    scale <0.45, 0.45, 0.4>
    rotate -90.0*z
    translate  <0.390528, -2.747818, 0.381521>
  }
  object { Tornado }
  hollow
  rotate -69.640694*z
  translate  <0.332082, 11.761972, 0.0>
}
//
// Include file contains 'Thdr_Bot3'
//
#include "slstorm.i22"
#declare Thdr_Bot3 = object {
  Thdr_Bot3_Raw
  texture {
    TransGlass
  }
  scale 0.6
  translate  <15.891056, 5.938563, -0.493221>
}
//
// Include file contains 'Thdr_Bot4'
//
#include "slstorm.i23"
#declare Thdr_Bot4 = object {
  Thdr_Bot4_Raw
  texture {
    TransGlass
  }
  scale 0.6
  translate  <15.867298, 5.93437, -0.48389>
}
#declare Done_ThdrBot3 = union {
  object { Thdr_Bot3 }
  cone { // CorkTop9
    <0,0,0>, 0.68, <0,0,1>, 1.1
    texture {
      TransCork
    }
    scale <0.215902, 0.2, 0.193378>
    rotate <0.0, 0.0, 0.0>
    translate  <15.89011, 5.92539, -0.05005>
  }
  object { Thdr_Bot4 }
  scale <1.0, 1.0, 2.0>
  rotate <-3.0, -8.0, -7.0>
  translate  <-16.01363, 6.248518, 0.214106>
}
//
// Include file contains 'Thdr_Bot2'
//
#include "slstorm.i24"
#declare Thdr_Bot2 = object {
  Thdr_Bot2_Raw
  texture {
    TransGlass
  }
  scale 0.6
  translate  <15.891056, 5.938563, -0.493221>
}
#declare Done_ThdrBot2 = union {
  object { Thdr_Bot2 }
  cone { // CorkTop8
    <0,0,0>, 0.68, <0,0,1>, 1.1
    texture {
      TransCork
    }
    scale <0.215902, 0.2, 0.193378>
    rotate <0.0, 0.0, 0.0>
    translate  <15.89011, 5.92539, -0.05005>
  }
  scale <1.0, 1.0, 2.0>
  rotate <-3.0, -8.0, -7.0>
  translate  <-15.984111, 6.233153, 0.214106>
}
//
// Include file contains 'Thdr_Bot1'
//
#include "slstorm.i25"
#declare Thdr_Bot1 = object {
  Thdr_Bot1_Raw
  texture {
    TransGlass
  }
  scale 0.6
  translate  <15.891056, 5.938563, -0.493221>
}
#declare Done_ThdrBot1 = union {
  object { Thdr_Bot1 }
  cone { // CorkTop7
    <0,0,0>, 0.68, <0,0,1>, 1.1
    texture {
      TransCork
    }
    scale <0.215902, 0.2, 0.193378>
    rotate <0.0, 0.0, 0.0>
    translate  <15.89011, 5.92539, -0.05005>
  }
  scale <1.0, 1.0, 2.0>
  rotate <-3.0, -8.0, -7.0>
  translate  <-15.984111, 6.256201, 0.2602>
}
//
// Include file contains 'Thdr_Bot'
//
#include "slstorm.i26"
#declare Thdr_Bot = object {
  Thdr_Bot_Raw
  texture {
    TransGlass
  }
  scale 0.6
  translate  <15.891056, 5.938563, -0.493221>
}
#declare Done_ThdrBot = union {
  object { Thdr_Bot }
  cone { // CorkTop6
    <0,0,0>, 0.68, <0,0,1>, 1.1
    texture {
      TransCork
    }
    scale <0.215902, 0.2, 0.193378>
    rotate <0.0, 0.0, 0.0>
    translate  <15.89011, 5.92539, -0.05005>
  }
  scale <1.0, 1.0, 2.0>
  rotate <-3.0, -8.0, -7.0>
  translate  <-15.984111, 6.271566, 0.237153>
}
//
// Include file contains 'Thdr_Bot5'
//
#include "slstorm.i27"
#declare Thdr_Bot5 = object {
  Thdr_Bot5_Raw
  texture {
    TransGlass
  }
  scale 0.6
  translate  <15.891056, 5.938563, -0.493221>
}
#declare Done_ThdrBot4 = union {
  object { Thdr_Bot5 }
  cone { // CorkTop10
    <0,0,0>, 0.68, <0,0,1>, 1.1
    texture {
      TransCork
    }
    scale <0.215902, 0.2, 0.193378>
    rotate <0.0, 0.0, 0.0>
    translate  <15.89011, 5.92539, -0.05005>
  }
  scale <1.0, 1.0, 2.0>
  rotate <-3.0, -8.0, -7.0>
  translate  <-15.955144, 6.446121, 0.275351>
}
#declare All_Thunder = union {
  object { Done_ThdrBot3 }
  object { Done_ThdrBot2 }
  object { Done_ThdrBot1 }
  object { Done_ThdrBot }
  object { Done_ThdrBot4 }
  translate  0.5*z
}
union { // All_bots
  object { Lning_Bottle }
  object { Rain }
  object { WindCloud }
  object { All_Thunder }
  translate  -0.5*z
}


#declare CutBolt = intersection {
  box { // Out_Bolt1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Lightning4
    }
    scale <2.65, 2.65, 3.180001>
    rotate 10.0*y
    translate  <-4.806978, 66.47857, -1.969349>
  }
  box { // Out_Bolt
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Lightning4
    }
    scale <2.65, 2.65, 3.180001>
    rotate 10.0*y
    translate  <-5.690556, 64.11, -1.338222>
  }
}
difference { // OutBoltDone
  object { CutBolt }
  box { // Out_Bolt2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BLack
    }
    scale <1.0, 5.0, 1.2>
    translate  <-3.166047, 66.47857, -3.484055>
  }
  rotate 15.0*y
  translate  <0.651464, 0.0, -1.681687>
}






#declare WinBrick9 = blob {
  threshold 0.6
  component 1.0, 0.355493, <0.0, 0.312236, 0.025316>
  component 1.0, 0.366003, <0.0, 0.278481, 0.14346>
  component 1.0, 0.384525, <0.0, 0.042194, -0.042194>
  component 1.0, 0.433935, <0.0, 0.092827, 0.109705>
  texture {
    Grey_Rock
  }
  scale <0.5, 1.0, 1.0>
  rotate <29.322979, 0.0, -90.0>
  translate  <0.427392, 13.4, 3.026993>
}

#declare WinBrick8 = blob {
  threshold 0.6
  component 1.0, 0.355493, <0.0, 0.312236, 0.025316>
  component 1.0, 0.366003, <0.0, 0.278481, 0.14346>
  component 1.0, 0.384525, <0.0, 0.042194, -0.042194>
  component 1.0, 0.433935, <0.0, 0.092827, 0.109705>
  texture {
    Grey_Rock
  }
  scale <0.35, 0.7, 0.7>
  rotate -90.0*z
  translate  <-0.8, 13.4, 3.246282>
}

#declare WinBrick7 = blob {
  threshold 0.6
  component 1.0, 0.355493, <0.0, 0.312236, 0.025316>
  component 1.0, 0.366003, <0.0, 0.278481, 0.14346>
  component 1.0, 0.384525, <0.0, 0.042194, -0.042194>
  component 1.0, 0.433935, <0.0, 0.092827, 0.109705>
  texture {
    Grey_Rock
  }
  scale <0.45, 0.97, 0.97>
  rotate <-26.05028, 0.0, -90.0>
  translate  <0.702731, 13.4, 1.422307>
}

#declare WinBrick2 = blob {
  threshold 0.6
  component 1.0, 0.355493, <0.0, 0.312236, 0.025316>
  component 1.0, 0.366003, <0.0, 0.278481, 0.14346>
  component 1.0, 0.384525, <0.0, 0.042194, -0.042194>
  component 1.0, 0.433935, <0.0, 0.092827, 0.109705>
  texture {
    Grey_Rock
  }
  scale <0.5, 1.0, 1.0>
  rotate 90.0*z
  translate  <-0.5, 13.4, 2.05>
}

#declare WinBrick3 = blob {
  threshold 0.6
  component 1.0, 0.355493, <0.0, 0.312236, 0.025316>
  component 1.0, 0.366003, <0.0, 0.278481, 0.14346>
  component 1.0, 0.384525, <0.0, 0.042194, -0.042194>
  component 1.0, 0.433935, <0.0, 0.092827, 0.109705>
  texture {
    Grey_Rock
  }
  scale <0.5, 1.0, 1.0>
  rotate <180.0, 0.0, -90.0>
  translate  <-0.45, 13.4, 2.8>
}

#declare WinBrick4 = blob {
  threshold 0.6
  component 1.0, 0.355493, <0.0, 0.312236, 0.025316>
  component 1.0, 0.366003, <0.0, 0.278481, 0.14346>
  component 1.0, 0.384525, <0.0, 0.042194, -0.042194>
  component 1.0, 0.433935, <0.0, 0.092827, 0.109705>
  texture {
    Grey_Rock
  }
  scale <0.5, 1.0, 1.0>
  rotate <74.579674, 0.0, -90.0>
  translate  <-0.045393, 13.4, 2.954707>
}

#declare WinBrick5 = blob {
  threshold 0.6
  component 1.0, 0.355493, <0.0, 0.312236, 0.025316>
  component 1.0, 0.366003, <0.0, 0.278481, 0.14346>
  component 1.0, 0.384525, <0.0, 0.042194, -0.042194>
  component 1.0, 0.433935, <0.0, 0.092827, 0.109705>
  texture {
    Grey_Rock
  }
  scale <0.5, 1.0, 1.0>
  rotate -90.0*z
  translate  <0.773009, 13.4, 2.647478>
}

#declare WinBrick6 = blob {
  threshold 0.6
  component 1.0, 0.355493, <0.0, 0.312236, 0.025316>
  component 1.0, 0.366003, <0.0, 0.278481, 0.14346>
  component 1.0, 0.384525, <0.0, 0.042194, -0.042194>
  component 1.0, 0.433935, <0.0, 0.092827, 0.109705>
  texture {
    Grey_Rock
  }
  scale <0.5, 1.0, 1.0>
  rotate <95.0, 0.0, -90.0>
  translate  <0.977693, 13.4, 1.896359>
}

#declare Brick2 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate <-90.0, -5.0, -180.0>
  translate  <-4.9, 13.85, 2.45>
}

#declare Brick3 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate -90.0*x
  translate  <-4.4, 13.75, 1.0>
}

#declare Brick4 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate <90.0, 0.0, 0.0>
  translate  <-3.9, 13.75, 3.5>
}

#declare Brick5 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate <90.0, 0.0, 0.0>
  translate  <2.867503, 13.75, 1.590526>
}

#declare Brick6 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate <-90.0, 5.0, 0.0>
  translate  <0.5, 13.7, 0.55>
}

#declare Brick1 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate <-90.0, 10.0, 0.0>
  translate  <2.824207, 13.75, 0.28894>
}

#declare Wall1 = union {
  object { Brick2 }
  object { Brick3 }
  object { Brick4 }
  object { Brick5 }
  object { Brick6 }
  object { Brick1 }
  texture {
    Grey_Rock
  }
}
#declare Brick8 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate -90.0*x
  translate  <-8.3, 13.75, -0.65>
}

#declare Brick12 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate -90.0*x
  translate  <-3.8, 13.75, 4.7>
}

#declare Brick13 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate -90.0*x
  translate  <-3.927484, 13.75, 3.287936>
}

#declare Wall2 = union {
  object { Brick8 }
  object { Brick12 }
  object { Brick13 }
  texture {
    Grey_Rock
  }
  translate  6.8*x
}
#declare Brick15 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate <90.0, 0.0, 0.0>
  translate  <-1.3, 13.75, -0.85>
}

#declare Brick16 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate <90.0, 0.0, 0.0>
  translate  <-1.25, 13.75, 0.6>
}

#declare Brick18 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate <-90.0, 5.0, 0.0>
  translate  <-3.45, 13.75, -3.25>
}

#declare Wall3 = union {
  object { Brick15 }
  object { Brick16 }
  object { Brick18 }
  texture {
    Grey_Rock
  }
  translate  <-0.4, 0.0, 2.75>
}
#declare Brick21 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate <90.0, 0.0, 0.0>
  translate  <3.2, 13.75, 1.55>
}

#declare Brick22 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate <-90.0, 5.0, 0.0>
  translate  <0.7, 13.75, -1.7>
}

#declare Brick23 = blob {
  threshold 0.5
  component 1.0, 0.667911, <-0.160338, 0.396624, 0.0>
  component 1.0, 0.648254, <-0.109705, -0.227848, 0.0>
  component 1.0, 0.682523, <0.329114, -0.21097, 0.0>
  component 1.0, 0.666672, <0.295359, 0.464135, 0.0>
  component 1.0, 0.599307, <-0.700422, 0.413502, 0.0>
  component 1.0, 0.605721, <-0.481013, -0.177215, 0.0>
  component 1.0, 0.642155, <-1.32489, -0.075949, 0.0>
  component 1.0, 0.642155, <-1.173, 0.447257, 0.0>
  component 1.0, 0.727372, <-0.953587, -0.092827, 0.0>
  rotate <90.0, 10.0, 0.0>
  translate  <0.4, 13.75, 3.2>
}

#declare Wall4 = union {
  object { Brick21 }
  object { Brick22 }
  object { Brick23 }
  texture {
    Grey_Rock
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.3, 0.0, 2.35>
}
#declare WallDone = difference {
  box { // Wall
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 0.25, 7.0>
    translate  <0.05, 13.867354, 0.0>
  }
  box { // Windowcut
    <-1, -1, -1>, <1, 1, 1>
    scale <0.771244, 0.5, 1.0>
    translate  <-0.015782, 13.8, 1.3>
  }
  texture {
    Grey
  }
  translate  <0.15, 0.0, 0.7>
}
#declare WinBrick1 = blob {
  threshold 0.6
  component 1.0, 0.355493, <0.0, 0.312236, 0.025316>
  component 1.0, 0.366003, <0.0, 0.278481, 0.14346>
  component 1.0, 0.384525, <0.0, 0.042194, -0.042194>
  component 1.0, 0.433935, <0.0, 0.092827, 0.109705>
  texture {
    Grey_Rock
  }
  scale <0.5, 1.0, 1.0>
  rotate -90.0*z
  translate  <-0.84021, 13.4, 1.415432>
}

#declare Dark_Sun1 = union {
  sphere { // inner1
    <0,0,0>,1
    texture {
      Shiny_Black
    }
    scale <0.1, 0.9, 0.9>
    translate  <0.0, 0.085606, 0.05012>
  }
  cylinder { // outer1
    <0,0,1>, <0,0,0>, 1
    texture {
      Shiny_Gold
    }
    scale <1.0, 1.0, 0.1>
    rotate <-180.0, -90.0, 0.0>
  }
  scale 0.65
  rotate 90.0*z
  translate  <-2.925181, 13.277075, 2.65>
}
union { // AllWall
  object { WinBrick9 }
  object { WinBrick8 }
  object { WinBrick7 }
  object { WinBrick2 }
  object { WinBrick3 }
  object { WinBrick4 }
  object { WinBrick5 }
  object { WinBrick6 }
  object { Wall1 }
  object { Wall2 }
  object { Wall3 }
  object { Wall4 }
  object { WallDone }
  object { WinBrick1 }
  object { Dark_Sun1 }
  rotate 2.0*z
}


#declare S = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.796048, 0.827066>,
  <1.874436, 0.827066>,
  <2.002762, 0.989691>,
  <-1.203952, 0.991502>,
  <0.291832, -1.001309>,
  <-1.232212, -1.001046>,
  <-1.232212, -1.195709>,
  <0.55527, -1.193236>,
  <0.55527, -1.007308>,
  <-0.796048, 0.827066>
  rotate -x*90
  texture {
    Shiny_Green1
  }
}
#declare L = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <0.570468, -0.994428>,
  <2.002762, 0.990662>,
  <2.2229, 0.992573>,
  <0.787993, -1.000238>,
  <2.192197, -0.999975>,
  <2.192197, -1.195699>,
  <0.569425, -1.193236>,
  <0.570468, -0.994428>
  rotate -x*90
  texture {
    Shiny_Red1
  }
}
// Include contains 'String'
#include "slstorm.i28"

#declare String = object {
  String_Raw
  texture {
    CorkWhite1
  }
  scale <2.5, 2.5, 0.35>
  rotate 0.0*y
  translate  <-1.726371, 3.575866, 0.047518>
}
union { // Signature
  object { S }
  object { L }
  object { String }
  torus { // Eyelet
    1.9, 0.1  rotate -x*90
    texture {
      Shiny_Gold1
    }
    scale <0.25, 0.1, 0.1>
    rotate -90.0*y
    translate  <0.63495, 1.135658, 0.523304>
  }
  scale <0.15, 0.15, 0.06>
  rotate 30.091795*z
  translate  <0.284437, 8.674149, -0.252458>
}


merge { // TableJoin
  cylinder { // ShelfBody
    <0,0,1>, <0,0,0>, 1
    scale <1.5, 1.5, 1.0>
    translate  -0.5*z
  }
  torus { // ShelfLip
    1.5, 0.5  rotate -x*90
  }
  texture {
    Oak
  }
  scale <1.7, 1.7, 0.5>
  translate  <-1.198713, 10.139933, -0.5>
}


