#include "cable.inc"

#declare ShipTexture =
texture
{ pigment //{ color <.3,.6,1> }
  { bozo
    color_map
    { [0 color <.3,.6,1>]
      [.9 color <.3,.6,1>]
      [1 color <.6,.5,.7>]
    }
    turbulence .5
    scale 6
  }
  normal { bumps .2 scale .4 }
  finish { specular .4 roughness .04 crand .08 }
}

#declare ShipChrome =
texture
{ pigment { color <.5,.6,.7> }
  finish { phong 1 phong_size 50 metallic reflection .8 }
}

#declare ShipBody=
union
{ difference // 1
  { box { <-35,0,-25><35,1,50> }
    box { <0,-1,0><30,2,30> rotate y*45 translate <15,0,-25> }
    box { <0,-1,0><-30,2,30> rotate -y*45 translate <-15,0,-25> }
    box { <-15,-1,-15><15,2,15> }
  }
  cylinder { y*2.5,y*4,30 pigment { color 0 } }
  union // 2
  { box { <0,0,-15><15,1,15> }
    difference
    { cylinder { <15,0,-15><15,0,15>,1 }
      box { <15,-2,-16><17,2,16> }
    }
    rotate -z*105
    translate -x*15
  }
  union // 2'
  { box { <0,0,-15><-15,1,15> }
    difference
    { cylinder { <-15,0,-15><-15,0,15>,1 }
      box { <-15,-2,-16><-17,2,16> }
    }
    rotate z*105
    translate x*15
  }
  // 3
  cylinder { z*50,z*15,1 }
  cylinder { -z*25,-z*15,1 }
  sphere { -z*25,1 }
  difference // 4
  { box { <-25,0,0><25,1,-22.36> rotate x*26.565 }
    box { <0,-1,1><-15,11,-24> rotate y*26.565 translate -x*15 }
    box { <0,-1,1><15,11,-24> rotate -y*26.565 translate x*15 }
    translate -z*25
  }
  // 5
  cylinder { -z*25,<0,10,-45>,1 }
  sphere { <0,10,-45>,1 }
  difference // 6
  { box { -x*10,<60,1,-23.5> rotate <25.2,-45,0> }
    box { <0,-1,1><-15,11,-24> rotate -y*26.565 }
    box { <20,-1,20><70,12,60> }
    translate <15,0,-25>
  }
  difference // 6'
  { box { x*10,<-60,1,-23.5> rotate <25.2,45,0> }
    box { <0,-1,1><15,11,-24> rotate y*26.565 }
    box { <-20,-1,20><-70,12,60> }
    translate <-15,0,-25>
  }
  // 7
  box { 0,<31,1,55> rotate z*18 translate <35,0,-5> }
  box { 0,<-31,1,55> rotate -z*18 translate <-35,0,-5> }
  difference // 8
  { union
    { box { <-30,0,0><30,20.64,1> }
      sphere { <-17,8,3>,7 }
      sphere { <17,8,3>,7 }
      rotate -x*20
    }
    box { <0,0,2>,<10,21,-10> rotate -y*45 translate x*25 }
    box { <0,0,2>,<-10,21,-10> rotate y*45 translate -x*25 }
    translate <0,10,-45>
  }
  // 9
  cylinder { <0,10,-45><0,20,-48.42>,1 }
  difference // 10
  { box { 0,<56.6,21,1> rotate <-27.5,-45,0> }
    box { <0,0,2>,<-10,11,-10> rotate -y*45 }
    translate <25,10,-45>
  }
  difference // 10'
  { box { 0,<-56.6,21,1> rotate <-27.5,45,0> }
    box { <0,0,2>,<10,11,-10> rotate y*45 }
    translate <-25,10,-45>
  }
}

#declare Ship =
union
{ intersection // 1
  { box { 0,<50,5,50> }
    box { <0,-.1,0>,<42.43,5.1,42.43> rotate y*45 translate <-5,0,25> }
  }
  union // 2
  { box { <10,5,15><15,10,35> }
    box { <10,10,20><15,15,30> }
    cylinder { <10,10,20><15,10,20>,5 }
    cylinder { <10,10,30><15,10,30>,5 }
  }
  union
  { sphere { <12.5,15,20>,.5 }
    sphere { <37.5,15,20>,.5 }
    pigment { color <1,0,0> }
    finish { ambient <1,0,0> }
  }
  union // 3
  { box { <35,5,15><40,10,35> }
    box { <35,10,20><40,15,30> }
    cylinder { <35,10,20><40,10,20>,5 }
    cylinder { <35,10,30><40,10,30>,5 }
  }
  cylinder // 4
  { <8,10,25><42,10,25>,2.5
    texture { ShipChrome }
  }
  // 5
  box { <9,4,14><16,6,36> }
  box { <34,4,14><41,6,36> }
  // 6
  sphere { <5,5,21>,1.25 }
  sphere { <5,5,29>,1.25 }
  sphere { <45,5,21>,1.25 }
  sphere { <45,5,29>,1.25 }
  // 7
  box { <20,5,7.5><22.5,7.5,10> }
  box { <27.5,5,7.5><30,7.5,10> }
  box { <20,5,40><22.5,7.5,42.5> }
  box { <27.5,5,40><30,7.5,42.5> }
  cylinder { <19.8,6.25,8.75><30.2,6.25,8.75>,.75 texture { ShipChrome } }
  cylinder { <19.8,6.25,41.25><30.2,6.25,41.25>,.75 texture { ShipChrome } }
  // 8
  cylinder { <17.5,10,25><32.5,10,25>,5 }

  union
  { cylinder { 0,y*15,2.5 texture { ShipChrome } } // 9
    cylinder { y*15,y*24,5 } // 10
    box { <-5,24,-5><5,35,5> } // 11
    // 12
    cylinder { y*35,y*90,10 }
    cylinder { <0,45,-10><0,90,-20>,1 }
    sphere { <0,45,-10>,1.5 }
    #declare Ang=0
    #while (Ang<2*pi)
      sphere { <sin(Ang)*10,36,cos(Ang)*10>,.5 }
      #declare Ang=Ang+pi/8
    #end
    // 13
    box { <-5,25,-5><-2.5,35,-7.5> }
    box { <-5,27.5,-7.5><-2.5,32.5,-10> }
    cylinder { <-5,27.5,-7.5><-2.5,27.5,-7.5>,2.5 }
    cylinder { <-5,32.5,-7.5><-2.5,32.5,-7.5>,2.5 }
    box { <5,25,-5><2.5,35,-7.5> }
    box { <5,27.5,-7.5><2.5,32.5,-10> }
    cylinder { <5,27.5,-7.5><2.5,27.5,-7.5>,2.5 }
    cylinder { <5,32.5,-7.5><2.5,32.5,-7.5>,2.5 }
    cylinder { <-5.3,30,-7.5><5.3,30,-7.5>,1.25 texture { ShipChrome } }
    // 14
    box { <-5,25,5><-2.5,35,7.5> }
    box { <-5,27.5,7.5><-2.5,32.5,10> }
    cylinder { <-5,27.5,7.5><-2.5,27.5,7.5>,2.5 }
    cylinder { <-5,32.5,7.5><-2.5,32.5,7.5>,2.5 }
    box { <5,25,5><2.5,35,7.5> }
    box { <5,27.5,7.5><2.5,32.5,10> }
    cylinder { <5,27.5,7.5><2.5,27.5,7.5>,2.5 }
    cylinder { <5,32.5,7.5><2.5,32.5,7.5>,2.5 }
    cylinder { <-5.3,30,7.5><5.3,30,7.5>,1.25 texture { ShipChrome } }
    union
    { object { Cable1 }
      object { Cable2 }
      cylinder { <-7.5,35,2><-7.5,33,2>,.7 }
      cylinder { <7.5,35,2><7.5,33,2>,.7 }
      pigment { color <.3,.2,.1> }
      finish { specular .5 roughness .05 }
    }
    object { ShipBody scale 1.1 translate y*65 }

    rotate x*20
    translate <25,10,25>
  }

  union // 15
  { cylinder { 0,y*30,1.25 texture { ShipChrome } }
    sphere { 0,1.5 }
    union
    { cylinder { y*15,y*35,2.5 }
      sphere { y*35,2.5 }
      translate y*5
    }

    rotate x*30
    translate <25,6.25,8.74>
  }
  union // 16
  { cylinder { 0,y*30,1.25 texture { ShipChrome } }
    sphere { 0,1.5 }
    union
    { cylinder { y*15,y*35,2.5 }
      sphere { y*35,2.5 }
      translate -y*5
    }

    rotate x*2
    translate <25,6.25,41.25>
  }

  texture { ShipTexture }
}
