#include "colors.inc"
#include "spacedog.inc"
#include "sorcerer.inc"
#include "ship.inc"

//-----------------------------------------------------------------------------
// Textures
//-----------------------------------------------------------------------------
#declare Ground=
texture
{ pigment
  { bozo
    color_map
    { [0.0 color <.6,.4,.1>]
      [0.4 color <.8,.5,.2>]
      [0.8 color <1,.6,.3>]
      [1.0 color <1,.8,.4>]
    }
  }
  finish { crand .2 }
  normal { bumps .5 scale 3 }
}

//-----------------------------------------------------------------------------
// General elements
//-----------------------------------------------------------------------------

global_settings
{ max_trace_level 8
  ambient_light <1,1,1>*2
}

background { color <0,0,.3> }

fog
{ fog_type 1
  distance 600
  colour <.25,.3,.4>*.5
}

camera
{ location <0,7,-80>
  look_at 0
  angle 45
}

light_source
{ <100,100,-150>
  color <1,1,1>
  spotlight
  point_at <-15,55,-50>
  radius 20
  falloff 30
  area_light <15,0,15>,<0,15,0>,10,10
  adaptive 1
  jitter
}
light_source
{ <-150,30,-100>
  color <0,.3,1>
  shadowless
}

//-----------------------------------------------------------------------------
// Objects
//-----------------------------------------------------------------------------

// --- Sorcerer ---
object
{ Sorcerer
  rotate <-90,180,0>
  scale 4
  rotate y*20
  translate <35,0,40>
}

// fire
union
{ sphere
  { 0,1 hollow

    pigment { color rgbt<0,0,0,1> }
    halo
    { emitting
      constant
      spherical_mapping
      cubic
      colour_map
      { [0 rgbt <.6,.6,.4,1> ]
        [.3 rgbt <1,.2,0,.9> ]
        [.5 rgbt <1,.5,.1,.7> ]
        [.7 rgbt <1,1,0,.4> ]
        [1 rgbt <1,1,1,0> ]
      }
      turbulence .5 lambda 3.5
    }
    scale <3,5,3>*10
  }
  light_source
  { 0 color <1,.4,0>
    fade_distance 20 fade_power 2
  }

  translate <45,10,80>
}

// --- Spacedog ---
object
{ Dog
  scale .1
  rotate -y*50
  translate <-12,5,5>
}

// --- Ground ---
plane
{ y,-18.5
  texture { Ground }
}

height_field
{ gif "plasma.gif"
  smooth
  translate <-1,-.2,-.5>
  rotate <0,90,0>
  scale <400,200,600>
  translate <50,0,80>
  texture { Ground }
}

// --- Ship ---
sphere
{ 0,1.05 hollow
  pigment { color rgbt <0,0,0,1> }
  halo
  { attenuating //dust dust_type 1
    spherical_mapping
    linear
    turbulence .5
    colour_map
    { [0 color rgbt <.5,1,1,1>]
      [1 color rgbt <1,1,1,.5>]
    }
    samples 5
    jitter .5
  }
  scale <30,10,22>
  translate <-40,-10,25>
}
object
{ Ship
  scale .4
  rotate -y*80
  translate <-20,-18.5,-5>
}
light_source
{ <-40,0,25> color <1,1,1>
  spotlight point_at <-30,-20,50>
  radius 10 falloff 15
}
light_source
{ <-40,0,25> color <.6,1,1>
  spotlight point_at <-40,-20,180>
  radius 10 falloff 14
}

