#declare LeftArmAngle=-10
#declare LeftLowerArmAngle=-10
#declare RightArmAngle=10
#declare RightLowerArmAngle=40
#declare HeadAngle=-20

//=============================================================================
// Dog head
//=============================================================================

#declare Head =
union
{
// Head
  union
  { difference
    { intersection
      { sphere { <0,0,0>,34 scale < 1, 2.8/3.4, 2.5/3.4 > }
        sphere { <-50,-50,0>,71+27 }
        sphere { <-20,10,0>,20+25 }
      }
      sphere { <50,10,-25>,35 }
      sphere { <50,10,25>,35 }
    }
    intersection
    { torus { 100,20 rotate <90,0,0> translate <-20,-100,0> }
      sphere { <-70,-10,0>,120 }
      superellipsoid
      { <.5,.5> scale <40,20,20> translate <40,0,0> rotate <0,0,-10>
      }
      union
      { sphere { <28,-15,0>,24 }
        box { <0,-50,-50><30,50,50> }
      }
    }
    intersection
    { torus { 75,75-28 inverse }
      cylinder { <0,20,0><0,-20,0>,32 }
      scale <1,1,.7>
      rotate <0,0,-15>
      translate <-2.5,-30,0>
    }
    sphere { <12,-12.5,-10>,15 }
    sphere { <12,-12.5,10>,15 }
// Eyebrows
    cylinder { <16,18,-15><23,13,-2>,1.7 }
    sphere { <16,18,-15>,1.7 }
    sphere { <23,13,-2>,1.7 }
    cylinder { <16,18,15><23,13,2>,1.7 }
    sphere { <16,18,15>,1.7 }
    sphere { <23,13,2>,1.7 }
// Ears
    difference
    { cone { <-5,10,-14>,10,<-5,44,-30>,0 }
      cone { <-4,10,-15>,9.5,<-5,45,-30>,0 }
    }
    difference
    { cone { <-5,10,14>,10,<-5,44,30>,0 }
      cone { <-4,10,15>,9.5,<-5,45,30>,0 }
    }

    texture
    { pigment { color rgb <.8,.6,.4> }
      normal { bumps .3 }
      scale .1
    }
  }
// Nose
  sphere
  { <0,0,0>,6
    scale <.8,.5,1>
    rotate <0,0,-30>
    translate <45,-1,0>

    texture
    { pigment { color Black }
      finish { phong .9 phong_size 150 }
    }
  }
// Eyes
  union
  { sphere { <12,18,-10>,8 }
    sphere { <12,18,10>,8 }
    sphere { <17,18,-10>,3.2 pigment { color Black } }
    sphere { <17,18,10>,3.2 pigment { color Black } }
    sphere { <13.1,18,-10>,7 pigment { color Brown } }
    sphere { <13.1,18,10>,7 pigment { color Brown } }

    scale <1,.7,1>
    texture
    { pigment { color White }
      finish { phong .9 phong_size 150 }
    }
  }
}

//=============================================================================
// Weapon
//=============================================================================
#declare Weapon=
union
{ difference
  { box { <-10,0,-15><100,20,15> }
    box { <0,0,-16><-30,15,16> rotate <0,0,63.4> translate y*20 }
    box { <0,-1,0>,<-15,21,-6> rotate <0,22,0> translate -z*15 }
    box { <0,-1,0>,<-15,21,6> rotate <0,-22,0> translate z*15 }
  }
  difference
  { box { <20,5,-17><80,15,17> }
    box { <25,9,-18><75,11,18> }
  }
  box { <2,20,-12><90,22,12> }
  union
  { sphere { <5,14,-15>,1 }
    sphere { <10,14,-15>,1 }
    sphere { <15,14,-15>,1 }
    sphere { <5,14,15>,1 }
    sphere { <10,14,15>,1 }
    sphere { <15,14,15>,1 }
    sphere { <45,40,0>,1 }
    pigment { color <.8,0,0> }
    finish { ambient <.8,0,0> }
  }
  cylinder { <33,20,0><33,35,0>,3 }
  cylinder { <67,20,0><67,35,0>,3 }
  union
  { cylinder { <10,35,0><25,35,0>,6 }
    cylinder { <20,35,0><80,35,0>,5 }
    difference
    { cone { <75,35,0>,6,<90,35,0>,7 }
      cylinder { <91,35,0><85,35,0>,4 }
    }
    cylinder { <50,40,0><70,40,0>,1 }
    sphere { <50,40,0>,1 }
    sphere { <70,40,0>,1 }
    difference
    { cylinder { <110,10,0><160,10,0>,7 }
      cylinder { <110,10,0><161,10,0>,3 }
    }
    cylinder { <115,17,0><155,17,0>,1 }
    sphere { <115,17,0>,1 }
    sphere { <155,17,0>,1 }

    pigment { color <.2,.2,.2> }
    finish { specular .9 roughness .08 }
  }
  cylinder
  { 0,x,1
    pigment
    { gradient x
      color_map
      { [0 color rgbt <1,0,0,.85>]
        [1 color rgbt <1,0,0,1>]
      }

    }
    finish { ambient <1,0,0> }
    no_shadow
    scale <300,1,1>
    translate <85,35,0>
  }
  difference
  { sphere { <-40,0,0>,105 }
    sphere { <-120,0,0>,180 }
    plane { -y,0 }
    box { <0,20,0>,<20,-60,-50> rotate <-16.5,0,0> translate <50,0,-15> }
    box { <0,20,0>,<20,-60,50> rotate <16.5,0,0> translate <50,0,15> }
    translate -x*10
  }
  cylinder { <100,10,0><110,10,0>,5 }

  pigment { color <0,.2,.4> }
  finish { specular .9 roughness .05 }
  normal { bumps .1 }
}

//=============================================================================
// Dog hands
//=============================================================================
#declare RightHand =
union
{ object { Weapon scale 2 rotate <0,180,-90> translate <50,-40,-7> }

  union
  { sphere { <0,0,0>,35 }
    cone { <0,0,0>,35<0,35,0>,30 }
    scale <1,1,.5>
  }
// Thumb
  sphere
  { <0,0,0>,25 scale <18/25,1,.7> rotate <-30,0,-45> translate <25,-17,-13>
  }
  sphere { <40,-3,-20>,14 }
  cylinder { <43,0,-20><23,20,-30>,10 }
  sphere { <23,20,-30>,10 }
  cylinder { <23,20,-30><5,10,-30>,9.5 }
  sphere { <5,10,-30>,9.5 }
// finger 1
  sphere { <30,35,5>,9 }
  cylinder { <30,35,5><24,0,1>,9 }
  cylinder { <30,35,5><30,35,-15>,8 }
  sphere { <30,35,-15>,8.5 }
  cylinder { <30,35,-15><30,15,-15>,8 }
  sphere { <30,15,-15>,8 }
// finger 2
  sphere { <14,38,8>,10 }
  cylinder { <14,38,8><10,0,6>,10 }
  cylinder { <14,38,8><14,38,-16>,9 }
  sphere { <14,38,-16>,9.5 }
  cylinder { <14,38,-16><14,13,-16>,9 }
  sphere { <14,13,-16>,9 }
// finger 3
  sphere { <-5,36,8>,10 }
  cylinder { <-5,36,8><-2,0,7>,10 }
  cylinder { <-5,36,8><-5,36,-16>,9 }
  sphere { <-5,36,-16>,9.5 }
  cylinder { <-5,36,-16><-5,14,-16>,9 }
  sphere { <-5,14,-16>,9 }
// finger 4
  sphere { <-22,35,5>,9 }
  cylinder { <-22,35,5><-15,0,5>,9 }
  cylinder { <-22,35,5><-22,35,-14>,8 }
  sphere { <-22,35,-14>,8.5 }
  cylinder { <-22,35,-14><-22,16,-14>,8 }
  sphere { <-22,16,-14>,8 }

  texture
  { pigment { color Black }
    finish { specular 0.5 roughness 0.06 }
    normal { bumps .1 }
  }
}

#declare LeftHand =
union
{ union
  { sphere { <0,0,0>,35 }
    cone { <0,0,0>,35<0,35,0>,30 }
    scale <1,1,.5>
  }
// Thumb
  sphere
  { <0,0,0>,25 scale <18/25,1,.7> rotate <-30,0,45> translate <-25,-17,-13>
  }
  sphere { <-40,-3,-20>,14 }
  cylinder { <-43,0,-20><-23,20,-30>,10 }
  sphere { <-23,20,-30>,10 }
  cylinder { <-23,20,-30><-5,10,-30>,9.5 }
  sphere { <-5,10,-30>,9.5 }
// finger 1
  sphere { <-30,35,5>,9 }
  cylinder { <-30,35,5><-24,0,1>,9 }
  cylinder { <-30,35,5><-30,35,-15>,8 }
  sphere { <-30,35,-15>,8.5 }
  cylinder { <-30,35,-15><-30,15,-15>,8 }
  sphere { <-30,15,-15>,8 }
// finger 2
  sphere { <-14,38,8>,10 }
  cylinder { <-14,38,8><-10,0,6>,10 }
  cylinder { <-14,38,8><-14,38,-16>,9 }
  sphere { <-14,38,-16>,9.5 }
  cylinder { <-14,38,-16><-14,13,-16>,9 }
  sphere { <-14,13,-16>,9 }
// finger 3
  sphere { <5,36,8>,10 }
  cylinder { <5,36,8><2,0,7>,10 }
  cylinder { <5,36,8><5,36,-16>,9 }
  sphere { <5,36,-16>,9.5 }
  cylinder { <5,36,-16><5,14,-16>,9 }
  sphere { <5,14,16>,9 }
// finger 4
  sphere { <22,35,5>,9 }
  cylinder { <22,35,5><15,0,5>,9 }
  cylinder { <22,35,5><22,35,-14>,8 }
  sphere { <22,35,-14>,8.5 }
  cylinder { <22,35,-14><22,16,-14>,8 }
  sphere { <22,16,-14>,8 }

  texture
  { pigment { color Black }
    finish { specular 0.5 roughness 0.06 }
    normal { bumps .1 }
  }
}

//=============================================================================
// Dog body
//=============================================================================
#declare DogColor=
texture
{ pigment { color rgb <.4,.1,.1> }//CornflowerBlue }
  finish { specular 0.1 roughness 0.05 }
  normal { bumps .2 scale .6 }
}

#declare Body =
union
{
// Upper body
  // breast
  union
  { sphere { <-15,30,0>,40 }
    sphere { <15,30,0>,40 }
    scale <1,1,.9>
    clipped_by { plane { <0,0,1>,-10 } }
  }
  // Back
  sphere { <0,30,10>,50 scale <1,1,.8> }
  // Waist
  cone
  { <0,30,10>,45,<0,-20,10>,35 scale <.9,1,.8>
    texture { DogColor }
  }
  // Hip
  sphere { <0,-40,10>,42 scale <1,.7,.8> }
// Legs
// Right leg
  // Buttock
  sphere { <-20,-35,15>,30 }
  // Upper leg
  sphere
  { <0,0,0>,30
    scale <.8,2,1>
    rotate <0,0,-10>
    translate <-32,-80,10>
    texture { DogColor }
  }
  // Knee
  sphere { <-40,-120,0>,25 }
  // Lower leg
  union
  { sphere { <-40,-100,10>,20 scale <1,1.5,1> }
    cone { <-40,-120,0>,20,<-40,-180,5>,15 }
    texture { DogColor }
  }
//  Right boot
  union
  { cone { <-40,-180,5>,20,<-40,-220,5>,15 }
    union
    { sphere { <-40,-220,10>,15 }
      cylinder { <-40,-220,10><-50,-227,-20>,15 }
      sphere { <-50,-227,-20>,15 }
      clipped_by { plane { <0,-1,0>,235 } }
    }
    cylinder { <-40,-235,10><-40,-228,10>,15 }
    box
    { <-15,0,0><15,7,-30>
      rotate <0,23,0>
      translate <-40,-235,10>
    }
    cylinder { <-50,-235,-20><-50,-228,-20>,15 }
    pigment { color Black }
    finish { specular 0.3 roughness 0.15 }
  }

//  Left leg
  // Buttock
  sphere { <20,-35,15>,30 }
  // Upper leg
  sphere
  { <0,0,0>,30
    scale <.8,2,1>
    rotate <0,0,10>
    translate <32,-80,10>
    texture { DogColor }
  }
  // Knee
  sphere { <40,-120,0>,25 }
  // Lower leg
  union
  { sphere { <40,-100,10>,20 scale <1,1.5,1> }
    cone { <40,-120,0>,20,<40,-180,5>,15 }
    texture { DogColor }
  }
//  Left boot
  union
  { cone { <40,-180,5>,20,<40,-220,5>,15 }
    union
    { sphere { <40,-220,10>,15 }
      cylinder { <40,-220,10><50,-227,-20>,15 }
      sphere { <50,-227,-20>,15 }
      clipped_by { plane { <0,-1,0>,235 } }
    }
    cylinder { <40,-235,10><40,-228,10>,15 }
    box
    { <-15,0,0><15,7,-30>
      rotate <0,-23,0>
      translate <40,-235,10>
    }
    cylinder { <50,-235,-20><50,-228,-20>,15 }
    pigment { color Black }
    finish { specular 0.3 roughness 0.15 }
  }
  // Shoulders
  difference
  { union
    { cylinder { <-60,40,0><0,52,5>,25 }
      cylinder { <60,40,0><0,52,5>,25 }
    }
    plane { y,33 }
  }

// Right arm
  union
  { // Shoulder
    difference
    { sphere { 0,30 }
      plane { y,33-40 }
    }
    // Upper arm
    union
    { sphere
      { 0,20 scale <.9,1.5,1> rotate <0,0,-5> translate <-72,15,5>-<-60,40,0>
      }
      sphere { <-67,15,-2>-<-60,40,0>,18 }
      texture { DogColor }
    }
    union
    { // Elbow
      sphere { 0,17 }
      // Lower arm
      cone { <0,2,0>,15,<5,-20,-40>,10 texture { DogColor } }
      object
      { RightHand scale .42 rotate <-90,0,100> rotate <-20,-10,0>
        translate <0,-25,-50>
      }
      rotate x*RightLowerArmAngle // ***** Rotate lower right arm *****
      translate <-75,-10,10>-<-60,40,0>
    }
    rotate x*RightArmAngle // ***** Rotate right arm *****
    translate <-60,40,0>
  }

// Left arm
  union
  { // Shoulder
    difference
    { sphere { 0,30 }
      plane { y,33-40 }
    }
    // Upper arm
    union
    { sphere
      { 0,20 scale <.9,1.5,1> rotate <0,0,5> translate <72,15,5>-<60,40,0>
      }
      sphere { <67,15,-2>-<60,40,0>,18 }
      texture { DogColor }
    }
    union
    { // Elbow
      sphere { 0,17 }
      // Lower arm
      cone { <0,2,0>,15,<-5,-20,-40>,10 texture { DogColor } }
      object
      { LeftHand scale .42 rotate <-90,0,-130> rotate <-30,30,0>
        translate <0,-25,-50>
      }
      rotate x*LeftLowerArmAngle // ***** Rotate lower left arm *****
      translate <75,-10,10>-<60,40,0>
    }
    rotate x*LeftArmAngle // ***** Rotate left arm *****
    translate <60,40,0>
  }


  texture
  { pigment { color Black }
    finish { specular 0.5 roughness 0.06 }
    normal { bumps .1 }
  }
}

//=============================================================================
// Dog
//=============================================================================
#declare Dog =
union
{ object { Head rotate y*(90+HeadAngle) translate <0,100,0> }
  object { Body }
}
