/*
 Statue.pov
 by Alan Grover
 (c) 1997
*/

#include "colors.inc"

light_source { //spotlight on statue
	< 0, 99, 0 >
	color White
//	area_light <5, 0, 0>, <0, 0, 5>, 5, 5
//	adaptive 1
//	jitter
	spotlight
	point_at < 0, 0, 0 >
	radius 50
	falloff 50
	fade_power 3
	fade_distance 130
	rotate < 0, 0, 20 >
	rotate < -5, 0, 0 >
	translate < 0, 100, 0 >
}


//	main view
camera {
	location < -99, 35, 0 >
	up < 0, 1.33, 0 >
	right < 1, 0, 0 >
	look_at < 0, 55, 5 >
	angle 50
	rotate < 0, -30 , 0 >
}	//

/*	close view
camera {
	location < -40, 30, 0 >
	up < 0, 1.33, 0 >
	right < 1, 0, 0 >
	look_at < 0, 25, 0 >
	angle 50
	rotate < 0, -30 , 0 >
}	*/

//The pedestal
union {
	torus {
		(15-5/2), (5/2)
		translate < 0, 25 - 5/2, 0 >
	}
	cylinder {
		< 0, 25, 0 >
		< 0, 25 - 5/2, 0 >
		15 - 5/2
	}
	cylinder {
		< 0, 25 - 5/2, 0 >,
		< 0, 15, 0 >, 15
	}
	cylinder {
		< 0, 15 - 5/2, 0 >,
		< 0, -40, 0 >,
		30
	}
	cylinder {
		< 0, 15, 0>,
		< 0, 0, 0 >,
		30 - 5/2
	}
	torus {
		(30 - 5/2), 5/2
		translate < 0, 15 - 5/2, 0 >
	}
	texture {
		pigment {
			bozo
			color_map {
				[0	rgb <.5,.3,.2>]
				[.2 rgb <.3,.1,.5>]
				[.3 rgb <.4,.5,.3>]
				[.5 rgb <.2,.3,.4>]
				[.6 rgb <.1,.2,.1>]
				[.7 rgb <.4,.3,.2>]
				[.9 rgb <.3,.4,.1>]
				[1	rgb <.5,.3,.2>]
			}
		}
		finish {
			specular .7
			roughness .3
		}
		normal {
			wrinkles
		}
	}
}







light_source {
	< -85, -3, 0 >
	color Gray20
//	area_light <1, 0, 0>, <0, 0, 1>, 3, 3
//	adaptive 1
//	jitter
}

light_source {
	< -85, -3, 0 >
	color Gray20
//	area_light <1, 0, 0>, <0, 0, 1>, 3, 3
//	adaptive 1
//	jitter
	rotate < 0, 90, 0>
}

light_source {
	< -85, -3, 0 >
	color Gray20
//	area_light <1, 0, 0>, <0, 0, 1>, 3, 3
//	adaptive 1
//	jitter
	rotate < 0, 180, 0 >
}

light_source {
	< -85, -3, 0 >
	color Gray20
//	area_light <1, 0, 0>, <0, 0, 1>, 3, 3
//	adaptive 1
//	jitter
	rotate < 0, -90, 0 >
}





// the water
plane {
	< 0, 1, 0 >,
	-1
	texture {
		pigment { rgbf < .2, .3, 1, .5 > }
		finish {
			reflection .2
			refraction on
			caustics .1
			ior 1.33
		}
		normal {
			bumps .3
		}
	}
}



cylinder {	// outer cylinder beyond columns
	< 0, 0, 0 >,
	< 0, 100, 0 >,
	130
	open
	hollow
	pigment { image_map  { tga "lights.tga" map_type 2 } scale 50 }// ratio 816.81:50
	finish {
		ambient 1
	}
/*	pigment { Gray }
	finish {
		specular .7
		roughness .5
	}
	normal { wrinkles 1 } */
}

difference {
	cylinder {
		< 0, -0.01, 0 >,
		< 0, -100, 0 >,
		200
	}
	cylinder {
		< 0, 0, 0 >,
		< 0, -100, 0 >,
		100
	}
	texture {
		pigment { Grey }
		finish {
			specular .7
			roughness .5
		}
	}
}



difference {
	sphere {
		< 0, 100, 0 >
		100
		inverse

	}
	plane { < 0, 1, 0>, 100 }
    pigment { Gray }
	finish {
		specular .7
		roughness .5
	}
	hollow
}


#declare StairPillarTexture = texture {
  pigment {
    bozo
	color_map {
		[0	rgb <.5,.3,.2>]
		[.2 rgb <.3,.1,.5>]
		[.3 rgb <.4,.5,.3>]
		[.5 rgb <.2,.3,.4>]
		[.6 rgb <.1,.2,.1>]
		[.7 rgb <.4,.3,.2>]
		[.9 rgb <.3,.4,.1>]
		[1	rgb <.5,.3,.2>]
	}
  }
  finish {
	specular .7
	roughness .3
  }
}


#declare StairTexture = texture {
  pigment {
    bozo
	color_map {
		[0	rgb <.5,.3,.2>]
		[.2 rgb <.3,.1,.5>]
		[.3 rgb <.4,.5,.3>]
		[.5 rgb <.2,.3,.4>]
		[.6 rgb <.1,.2,.1>]
		[.7 rgb <.4,.3,.2>]
		[.9 rgb <.3,.4,.1>]
		[1	rgb <.5,.3,.2>]
	}
  }
  finish {
	specular .7
	roughness .3
  }
}

#declare PillarBase = -40
#declare Stair1 = < -45, 0, -10 >
#declare Stair2 = < -30, 15, 10 >
#declare StairstepHeight = 1
#declare StairstepSeperation = .5

#include "stairway1.inc"


object { Staircase }
object { Staircase	rotate < 0, 180, 0 > }
object { Staircase	rotate < 0, 90, 0 > }
object { Staircase	rotate < 0, -90, 0 > }


#declare Top = 50
#declare Bottom = 0
#declare InnerRadius = 100
#declare NumberOfColumns = 25
#declare TopTexture = texture {
	pigment { Gray20 }
	finish {
		specular .7
		roughness .5
        ambient .4
	}
}
#declare OuterArchTexture = texture {
	pigment { Gray20 }
	finish {
		specular .7
		roughness .5
        ambient .4
	}
}
#declare InnerArchTexture =	texture {
	pigment { Gray20 }
	finish {
		specular .7
		roughness .5
        ambient .4
	}
}
#declare ColumnTexture = texture {
	pigment { Gray20 }
	finish {
		specular .7
		roughness .5
        ambient .4
	}
}
#declare CapitalTexture = texture {
	pigment { Gray50 }
	finish {
		specular .7
		roughness .5
        ambient .4
	}
}

#include "circol.inc"

object { CircularColumns }
object { CircularColumns translate < 0, 50, 0> }

#declare GoldWireGlass = texture {
	agate
	agate_turb .8
	texture_map {
		[ 0
			pigment { rgb < 1, .8, 0 > }
			finish {
				roughness .0005
				specular 1
				metallic
				reflection .5
			}
			normal {
				agate
				agate_turb .8
				slope_map {
					[ 0 <0,3> ]
					[ 0.05 <1,0> ]
					[ 0.1 <0,-3> ]
					[ 0.1 <0,0> ]
					[ 1 <0,0> ]
				}
			}
		]
		[ 0.1
			pigment { rgb < 1, .8, 0 > }
			finish {
				roughness .0005
				specular 1
				metallic
				reflection .5
			}
			normal {
				agate
				agate_turb .8
				slope_map {
					[ 0 <0,3> ]
					[ 0.05 <1,0> ]
					[ 0.1 <0,-3> ]
					[ 0.1 <0,0> ]
					[ 1 <0,0> ]
				}
			}
		]
		[ 0.1
			pigment { rgbf < 1, 1, 1, .6 > }
			finish {
				roughness .005
				specular 1
				ior 1.5
				refraction on
				reflection .3
				caustics 1
			}
		]
		[ 1
			pigment { rgbf < 1, 1, 1, .6 > }
			finish {
				roughness .005
				specular 1
				ior 1.5
				refraction on
				reflection .3
				caustics 1
			}
		]
	}
}

#include "statue2.inc"
object {
	Statue
	scale ( 5 / 0.932213 )
	texture { GoldWireGlass }
//	texture { StairTexture finish { specular 1 roughness .0001 }	}
	scale ( 45 / 5 )
	rotate < 0, 90, 0 >

	translate < 0, 45 + 25, 0 >
}

