
// That flying beastie. Note that t determines position of wings and
// needs to be set to a value before this file is called.
define body
object {
   object { bezier 1, 1, 4, 4, // Bdy, Cnt, Frnt, U
      <-0.8, 0.4, 0.2>, <-0.3, 0.7, 0>, <0.3, 0.7, 0>, <0.8, 0.4, 0.2>,
      <-1.2, 0.6, 2>, <-0.3, 1, 2>, <0.3, 1, 2>, <1.2, 0.6, 2>,
      <-1.3, 0.7, 4>, <-0.3, 1.1, 4>, <0.3, 1.1, 4>, <1.3, 0.7, 4>,
      <-1.3, 0.7, 6>, <-0.3, 1.1, 6>, <0.3, 1.1, 6>, <1.3, 0.7, 6>
      }
 + object { bezier 1, 1, 4, 4, // Bdy, Cnt, Bck, U
      <-1.3, 0.7, 6>, <-0.3, 1.1, 6>, <0.3, 1.1, 6>, <1.3, 0.7, 6>,
      <-1.2, 0.7, 8>, <-0.3, 1.1, 8>, <0.3, 1.1, 8>, <1.2, 0.7, 8>,
      <-1, 0.6, 10>, <-0.2, 0.9, 10>, <0.2, 0.9, 10>, <1, 0.6, 10>,
      <-0.1, 0, 13.5>, <0, 0.1, 13.5>, <0, 0.1, 13.5>, <0.1, 0, 13.5>
      }
 + object { bezier 1, 1, 4, 4, // Bdy, Cnt, Frnt, L
      <-0.8, -0.4, 0.2>, <-0.3, -0.7, 0>, <0.3, -0.7, 0>, <0.8, -0.4, 0.2>,
      <-1.2, -0.6, 2>, <-0.3, -1, 2>, <0.3, -1, 2>, <1.2, -0.6, 2>,
      <-1.3, -0.7, 4>, <-0.3, -1.1, 4>, <0.3, -1.1, 4>, <1.3, -0.7, 4>,
      <-1.3, -0.7, 6>, <-0.3, -1.1, 6>, <0.3, -1.1, 6>, <1.3, -0.7, 6>
      }
 + object { bezier 1, 1, 4, 4, // Bdy, Cnt, Bck, L
      <-1.3, -0.7, 6>, <-0.3, -1.1, 6>, <0.3, -1.1, 6>, <1.3, -0.7, 6>,
      <-1.2, -0.7, 8>, <-0.3, -1.1, 8>, <0.3, -1.1, 8>, <1.2, -0.7, 8>,
      <-1, -0.6, 10>, <-0.2, -0.9, 10>, <0.2, -0.9, 10>, <1, -0.6, 10>,
      <-0.1, 0, 13.5>, <0, -0.1, 13.5>, <0, -0.1, 13.5>, <0.1, 0, 13.5>
      }
 + object {
      cone <0, 0, 12.5>, 0.15, <0, -0.5, 23>, 0.05 // Tail
      }
   }

define wing
object {
   object { bezier 1, 1, 4, 4, // Bdy, Lt, Frnt, U
      <-0.8, 0.4, 0.2>, <-1.0, 0.33, 0.3>, <-1.1, 0.2, 0.4>, <-1.1, 0, 0.5>,
      <-1.2, 0.6, 2>, <-1.3, 0.5, 2>, <-1.4, 0.3, 2>, <-1.5, 0, 2>,
      <-1.3, 0.7, 4>, <-1.5, 0.5, 4>, <-1.7, 0.4, 4>, <-2, 0.2, 4>,
      <-1.3, 0.7, 6>, <-1.5, 0.5, 6>, <-1.7, 0.4, 6>, <-2, 0.2, 6>
      }
 + object { bezier 1, 1, 4, 4, // Bdy, Lt, Frnt, L
      <-0.8, -0.4, 0.2>, <-1.0, -0.33, 0.3>, <-1.1, -0.2, 0.4>, <-1.1, 0, 0.5>,
      <-1.2, -0.6, 2>, <-1.3, -0.5, 2>, <-1.4, -0.3, 2>, <-1.5, 0, 2>,
      <-1.3, -0.7, 4>, <-1.5, -0.5, 4>, <-1.7, -0.4, 4>, <-2, -0.2, 4>,
      <-1.3, -0.7, 6>, <-1.5, -0.5, 6>, <-1.7, -0.4, 6>, <-2, -0.2, 6>
      }
 + object { bezier 1, 1, 4, 4, // Bdy, Lt, Bck, U
      <-1.3, 0.7, 6>, <-1.5, 0.5, 6>, <-1.7, 0.4, 6>, <-2, 0.2, 6>,
      <-1.2, 0.7, 8>, <-1.5, 0.5, 8>, <-1.7, 0.4, 8>, <-2, 0.2, 8>,
      <-1, 0.6, 10>, <-1.4, 0.4, 10>, <-1.7, 0.2, 10>, <-2, 0.1, 10>,
      <-0.1, 0, 13.5>, <-1, 0, 12>, <-1.5, 0, 11.5>, <-2, 0, 11.3>
      }
 + object { bezier 1, 1, 4, 4, // Bdy, Lt, Bck, L
      <-1.3, -0.7, 6>, <-1.5, -0.5, 6>, <-1.7, -0.4, 6>, <-2, -0.2, 6>,
      <-1.2, -0.7, 8>, <-1.5, -0.5, 8>, <-1.7, -0.4, 8>, <-2, -0.2, 8>,
      <-1, -0.6, 10>, <-1.4, -0.4, 10>, <-1.7, -0.2, 10>, <-2, 0, 10>,
      <-0.1, 0, 13.5>, <-1, 0, 12>, <-1.5, 0, 11.5>, <-2, 0, 11.3>
      }
 + object { bezier 1, 1, 4, 4, // Lt Wng, I, Frnt, U
      <-1.5, 0, 2>, <-1.5, 0.1, 2.5>, <-1.5, 0.2, 4>, <-1.5, 0.2, 6>,
      <-2, 0, 2.7>, <-2, 0.1, 3>, <-2, 0.2, 5>, <-2, 0.2, 7>,
      <-3, sin(t)*0.3, 3.2>, <-3, 0.1+sin(t)*0.3, 3.5>, <-3, 0.2+sin(t-0.06)*0.3, 5>, <-3, 0.15+sin(t-0.18)*0.3, 7>,
      <-4, sin(t)*0.74, 3.7>, <-4, 0.05+sin(t)*0.74, 4>, <-4, 0.1+sin(t-0.06)*0.3, 5>, <-4, 0.05+sin(t-0.12)*0.74, 7>
      }
 + object { bezier 1, 1, 4, 4, // Lt Wng, I, Bck, U
      <-1.5, 0.2, 6>, <-1.5, 0.2, 8>, <-2, 0.1, 10>, <-2, 0, 11.4>,
      <-2, 0.2, 7>, <-2.2, 0.1+sin(t-0.3)*0.04, 9>, <-2.3, sin(t-0.39)*0.06, 10.5>, <-2.4, -0.1+sin(t-0.456)*0.09, 11,6>,
      <-3, 0.15+sin(t-0.18)*0.3, 7>, <-3, 0.05+sin(t-0.3)*0.3, 9>, <-3, -0.05+sin(t-0.39)*0.3, 10.5>, <-3, -0.15+sin(t-0.47)*0.3, 11.8>,
      <-4, 0.05+sin(t-0.18)*0.74, 7>, <-4, -0.05+sin(t-0.3)*0.74, 9>, <-4, -0.2+sin(t-0.39)*0.74, 10.5>, <-4, -0.4+sin(t-0.51)*0.74, 12.5>
      }
 + object { bezier 1, 1, 4, 4, // Lt Wng, O
      <-3.95, sin(t)*0.74, 3.7>, <-3.95, 0.1+sin(t-0.06)*0.74, 5>, <-3.95, -0.05+sin(t-0.3)*0.74, 9>, <-3.95, -0.4+sin(t-0.51)*0.74, 12.5>,
      <-5.5, -0.1+sin(t-0.03)*1.53, 4.5>, <-5.5, sin(t-0.09)*1.53, 5.5>, <-5.5, -0.2+sin(t-0.36)*1.53, 10>, <-5.5, -0.7+sin(t-0.57)*1.53, 13.5>,
      <-7, -0.4+sin(t-0.18)*2.43, 7>, <-7, -0.2+sin(t-0.36)*2.43, 10>, <-7, -0.5+sin(t-0.54)*2.43, 13>, <-7, -1+sin(t-0.66)*2.43, 15>,
      <-8, -0.8+sin(t-0.36)*3.08, 10>, <-8.5, -1+sin(t-0.48)*3.42, 12>, <-9, -1.2+sin(t-0.6)*3.76, 14>, <-9, -1.5+sin(t-0.9)*3.76, 19>
      }
 + object { bezier 1, 1, 4, 4, // Lt Wng, I, Frnt, L
      <-1, 0, 2>, <-1, -0.2, 2.5>, <-1, -0.4, 4>, <-1, -0.3, 6>,
      <-2, 0, 2.7>, <-2, -0.1, 3>, <-2, -0.2, 5>, <-2, -0.2, 7>,
      <-3, sin(t)*0.3, 3.2>, <-3, sin(t)*0.3, 3.5>, <-3, -0.1+sin(t-0.06)*0.3, 5>, <-3, -0.1+sin(t-0.18)*0.3, 7>,
      <-4, sin(t)*0.74, 3.7>, <-4, 0.05+sin(t)*0.74, 4>, <-4, sin(t-0.06)*0.74, 5>, <-4, 0.05+sin(t-0.18)*0.74, 7>
      }
 + object { bezier 1, 1, 4, 4, // Lt Wng, I, Bck, L
      <-2, -0.3, 6>, <-2, -0.2, 8>, <-1.5, -0.1, 10>, <-2, 0, 11.4>,
      <-2, -0.1, 7>, <-2.2, -0.1+sin(t-0.3)*0.04, 9>, <-2.3, -0.15+sin(t-0.39)*0.06, 10.5>, <-2.4, -0.15+sin(t-0.456)*0.09, 11,6>,
      <-3, sin(t-0.18)*0.3, 7>, <-3, sin(t-0.3)*0.3, 9>, <-3, -0.15+sin(t-0.39)*0.3, 10.5>, <-3, -0.2+sin(t-0.468)*0.3, 11.8>,
      <-4, 0.05+sin(t-0.18)*0.74, 7>, <-4, -0.05+sin(t-0.3)*0.74, 9>, <-4, -0.2+sin(t-0.39)*0.74, 10.5>, <-4, -0.4+sin(t-0.51)*0.74, 12.5>
      }
   }

define mouth
object {
   object { bezier 1, 1, 4, 4, // Mou, Cnt, U
      <-0.8, 0.4, 0.2>, <-0.3, 0.7, 0>, <0.3, 0.7, 0>, <0.8, 0.4, 0.2>,
      <-0.6, 0.3, 1>, <-0.3, 0.5, 1>, <0.3, 0.5, 1>, <0.6, 0.3, 1>,
      <-0.4, 0.2, 2>, <-0.2, 0.3, 2>, <0.2, 0.3, 2>, <0.4, 0.2, 2>,
      <-0.1, 0., 3>, <-0.05, 0.1, 3>, <0.05, 0.1, 3>, <0.1, 0., 3>
      }
 + object { bezier 1, 1, 4, 4, // Mou, Cnt, L
      <-0.8, -0.4, 0.2>, <-0.3, -0.7, 0>, <0.3, -0.7, 0>, <0.8, -0.4, 0.2>,
      <-0.6, -0.3, 1>, <-0.3, -0.5, 1>, <0.3, -0.5, 1>, <0.6, -0.3, 1>,
      <-0.4, -0.2, 2>, <-0.2, -0.3, 2>, <0.2, -0.3, 2>, <0.4, -0.2, 2>,
      <-0.1, 0., 3>, <-0.05, -0.1, 3>, <0.05, -0.1, 3>, <0.1, 0., 3>
      }
 + object { bezier 1, 1, 4, 4, // Mou, Lt
      <-0.8, 0.4, 0.2>, <-1.1, 0, 0.6>, <-1.1, 0, 0.6>, <-0.8, -0.4, 0.2>,
      <-0.6, 0.3, 1>, <-0.8, 0.1, 1.5>, <-0.8, -0.1, 1.5>, <-0.6, -0.3, 1>,
      <-0.4, 0.2, 2>, <-0.5, 0, 2>, <-0.5, 0, 2>, <-0.4, -0.2, 2>,
      <-0.1, 0, 3>, <-0.1, 0, 3>, <-0.1, 0, 3>, <-0.1, 0, 3>
      }
 + object { bezier 1, 1, 4, 4, // Mou, Rt
      <0.8, 0.4, 0.2>, <1.1, 0, 0.6>, <1.1, 0, 0.6>, <0.8, -0.4, 0.2>,
      <0.6, 0.3, 1>, <0.8, 0.1, 1.5>, <0.8, -0.1, 1.5>, <0.6, -0.3, 1>,
      <0.4, 0.2, 2>, <0.5, 0, 2>, <0.5, 0, 2>, <0.4, -0.2, 2>,
      <0.1, 0, 3>, <0.1, 0, 3>, <0.1, 0, 3>, <0.1, 0, 3>
      }
   shiny_red
   }

define hellspawn
object {
     body
   + wing
   + wing { scale <-1, 1, 1> }
   + mouth
   texture { shiny { color <0.3, 0, 0.6> } }
   }

// A clock to remind us that time keeps running out.

// set the clock
define hours 2 // [0..12]
define minutes 48 // [0..59]

define long_angle minutes * 6
define short_angle hours * (360/13) + minutes * 360/(13*60)
// First the textures

define rope_fn 0.6*|(ramp(u*28 + v)) -0.5|^0.3
define rope_fn2 0.6*|(ramp(v*11 + u)) -0.5|^0.3
define rope_fn3 0.6*|(ramp(u*13 + v)) -0.5|^0.3

define rope_tex
texture {
   special surface {
      color <0.95, 0.7, 0.3>
      ambient 0.1
      diffuse 0.2 + rope_fn
      }
   }

define rope_tex2
texture {
   special surface {
      color <0.95, 0.7, 0.3>
      ambient 0.1
      diffuse 0.2 + rope_fn2
      }
   }

define rope_tex3
texture {
   special surface {
      color <0.95, 0.7, 0.3>
      ambient 0.1
      diffuse 0.2 + rope_fn3
      }
   }

define axe_color
texture {
   surface {
      color darkslategrey
      ambient 0.1
      diffuse 0.6
      specular white, 0.1
      microfacet Phong 17
      }
   }

static define gold
texture {
   metallic {
      color <0.95, 0.7, 0.3>
      }
   }

static define wood_map2 color_map(
   [0.000, 0.177, <1.000, 0.460, 0.025>, 0.000, <0.635, 0.349, 0.161>, 0.000]
   [0.177, 0.301, <0.635, 0.349, 0.161>, 0.000, <0.514, 0.314, 0.129>, 0.000]
   [0.301, 0.354, <0.514, 0.314, 0.129>, 0.000, <0.635, 0.309, 0.161>, 0.000]
   [0.354, 0.451, <0.635, 0.309, 0.161>, 0.000, <0.431, 0.137, 0.141>, 0.000]
   [0.451, 0.558, <0.431, 0.137, 0.141>, 0.000, <0.635, 0.319, 0.161>, 0.000]
   [0.558, 0.646, <0.635, 0.319, 0.161>, 0.000, <0.467, 0.050, 0.020>, 0.000]
   [0.646, 0.743, <0.467, 0.050, 0.020>, 0.000, <0.635, 0.349, 0.161>, 0.000]
   [0.743, 0.858, <0.635, 0.349, 0.161>, 0.000, <0.576, 0.376, 0.145>, 0.000]
   [0.858, 0.982, <0.576, 0.376, 0.145>, 0.000, <1.000, 0.460, 0.025>, 0.000]
   [0.982, 1.000, <1.000, 0.460, 0.025>, 0.000, <1.000, 0.460, 0.025>, 0.000])

static define noisy_wood_fn1
   sawtooth(|<x+0.5*dnoise(P,3)[0], y+0.5*dnoise(P,3)[1], 0>|)

static define brightness
   1-|wood_map2[noisy_wood_fn1]|/sqrt(3)

static define shiny_wood
texture {
   special shiny {
      color wood_map2[noisy_wood_fn1]
      ambient 0.2
      diffuse 0.5 + 0.4 * brightness
      specular white, 0.3
      microfacet Cook  10 * brightness
      }
   scale <0.3, 0.3, 0.3>
   }

// The numbers and hands for the watchface
define I
object {
     object {
      box <-0.1, 0, -0.1>, <0.1, 1, 0>
      }
   + object {
      box <-0.14, 0, -0.1>, <0.14, 0.04, 0> }
   + object {
      box <-0.14, 1, -0.1>, <0.14, 0.96, 0> }
   translate <0, 6.5, 0>
   gold
   }

define V
object {
     object {
      box <-0.1, 0, -0.1>, <0.1, 1, 0>
      shear 0, 0, 0.4, 0, 0, 0
      }
   + object {
      box <-0.1, 0, -0.1>, <0.1, 1, 0>
      shear 0, 0, -0.4, 0, 0, 0
      }
   + object {
      box <-0.17, 0, -0.1>, <0.17, 0.04, 0> }
   + object {
      box <-0.55, 1, -0.1>, <-0.23, 0.96, 0> }
   + object {
      box <0.23, 1, -0.1>, <0.55, 0.96, 0> }
   translate <0, 6.5, 0>
   gold
   }

define X
object {
     object {
      box <-0.1, 0, -0.1>, <0.1, 1, 0>
      shear 0, 0, 0.6, 0, 0, 0
      translate <-0.3, 0, 0>
      }
   + object {
      box <-0.1, 0, -0.1>, <0.1, 1, 0>
      shear 0, 0, -0.6, 0, 0, 0
      translate <0.3, 0, 0>
      }
   + object {
      box <-0.44, 1, -0.1>, <-0.12, 0.96, 0> }
   + object {
      box <0.12, 1, -0.1>, <0.44, 0.96, 0> }
   + object {
      box <-0.44, 0, -0.1>, <-0.12, 0.04, 0> }
   + object {
      box <0.12, 0, -0.1>, <0.44, 0.04, 0> }
   translate <0, 6.5, 0>
   gold
   }

define II
object {
     I { translate <-0.14, 0, 0> }
   + I { translate < 0.14, 0, 0> }
   }

define III
object {
     I { translate <-0.28, 0, 0> }
   + I
   + I { translate < 0.28, 0, 0> }
   }

define IV
object {
     I { translate <-0.34, 0, 0> }
   + V { translate < 0.35, 0, 0> }
   }

define VI
object {
     I { translate < 0.34, 0, 0> }
   + V { translate <-0.35, 0, 0> }
   }

define VII
object {
     I { translate < 0.48, 0, 0> }
   + I { translate < 0.20, 0, 0> }
   + V { translate <-0.49, 0, 0> }
   }

define VIII
object {
     I { translate < 0.62, 0, 0> }
   + I { translate < 0.34, 0, 0> }
   + I { translate < 0.06, 0, 0> }
   + V { translate <-0.63, 0, 0> }
   }

define IX
object {
     I { translate <-0.29, 0, 0> }
   + X { translate < 0.29, 0, 0> }
   }

define XI
object {
     I { translate < 0.29, 0, 0> }
   + X { translate <-0.29, 0, 0> }
   }

define XII
object {
     I { translate < 0.43, 0, 0> }
   + I { translate < 0.15, 0, 0> }
   + X { translate <-0.43, 0, 0> }
   }

define XIII
object {
     I { translate < 0.57, 0, 0> }
   + I { translate < 0.29, 0, 0> }
   + I { translate < 0.01, 0, 0> }
   + X { translate <-0.57, 0, 0> }
   }

define dot
object {
   sphere <0, 6, 0>, 0.1
   scale <1, 1, 0.5>
   gold
   }

define minute_hand
object {
   polygon 12,
      <0, 8, 0>, <0.5, 7, 0>, <0.2, 7.2, 0>, <0.2, -0.5, 0>,
      <0.5, -0.8, 0>, <0.5, -2.5, 0>, <0, -2, 0>, <-0.5, -2.5, 0>,
      <-0.5, -0.8, 0>, <-0.2, -0.5, 0>, <-0.2, 7.2, 0>, <-0.5, 7, 0>
   gold
   scale <0.8, 0.8, 0.8>
   }

define hour_hand
object {
     object {
      polygon 3,
         <0, 6, 0>, <0.7, -1.8, 0>, <0, -1, -0.1> }
   + object {
      polygon 3,
         <0, 6, 0>, <-0.7, -1.8, 0>, <0, -1, -0.05> }
   gold
   scale <0.8, 0.8, 0.8>
   }

define watchface
object {
     object { disc <0, 0, 0>, <0, 0, 1>, 8 matte_black }
   + I { rotate <0, 0, 28> }
   + II { rotate <0, 0, 55> }
   + III { rotate <0, 0, 83> }
   + IV { rotate <0, 0, 111> }
   + V { rotate <0, 0, 138> }
   + VI { rotate <0, 0, 166> }
   + VII { rotate <0, 0, 194> }
   + VIII { rotate <0, 0, 222> }
   + IX { rotate <0, 0, 249> }
   + X { rotate <0, 0, 277> }
   + XI { rotate <0, 0, 305> }
   + XII { rotate <0, 0, 332> }
   + XIII
   + minute_hand { translate <0, 0, -0.15> rotate <0, 0, long_angle> }
   + hour_hand { translate <0, 0, -0.05> rotate <0, 0, short_angle> }
   + dot
   + dot { rotate <0, 0, 6> }
   + dot { rotate <0, 0, 12> }
   + dot { rotate <0, 0, 18> }
   + dot { rotate <0, 0, 24> }
   + dot { rotate <0, 0, 30> }
   + dot { rotate <0, 0, 36> }
   + dot { rotate <0, 0, 42> }
   + dot { rotate <0, 0, 48> }
   + dot { rotate <0, 0, 54> }
   + dot { rotate <0, 0, 60> }
   + dot { rotate <0, 0, 66> }
   + dot { rotate <0, 0, 72> }
   + dot { rotate <0, 0, 78> }
   + dot { rotate <0, 0, 84> }
   + dot { rotate <0, 0, 90> }
   + dot { rotate <0, 0, 96> }
   + dot { rotate <0, 0, 102> }
   + dot { rotate <0, 0, 108> }
   + dot { rotate <0, 0, 114> }
   + dot { rotate <0, 0, 120> }
   + dot { rotate <0, 0, 126> }
   + dot { rotate <0, 0, 132> }
   + dot { rotate <0, 0, 138> }
   + dot { rotate <0, 0, 144> }
   + dot { rotate <0, 0, 150> }
   + dot { rotate <0, 0, 156> }
   + dot { rotate <0, 0, 162> }
   + dot { rotate <0, 0, 168> }
   + dot { rotate <0, 0, 174> }
   + dot { rotate <0, 0, 180> }
   + dot { rotate <0, 0, 186> }
   + dot { rotate <0, 0, 192> }
   + dot { rotate <0, 0, 198> }
   + dot { rotate <0, 0, 204> }
   + dot { rotate <0, 0, 210> }
   + dot { rotate <0, 0, 216> }
   + dot { rotate <0, 0, 222> }
   + dot { rotate <0, 0, 228> }
   + dot { rotate <0, 0, 234> }
   + dot { rotate <0, 0, 240> }
   + dot { rotate <0, 0, 246> }
   + dot { rotate <0, 0, 252> }
   + dot { rotate <0, 0, 258> }
   + dot { rotate <0, 0, 264> }
   + dot { rotate <0, 0, 270> }
   + dot { rotate <0, 0, 276> }
   + dot { rotate <0, 0, 282> }
   + dot { rotate <0, 0, 288> }
   + dot { rotate <0, 0, 294> }
   + dot { rotate <0, 0, 300> }
   + dot { rotate <0, 0, 306> }
   + dot { rotate <0, 0, 312> }
   + dot { rotate <0, 0, 318> }
   + dot { rotate <0, 0, 324> }
   + dot { rotate <0, 0, 330> }
   + dot { rotate <0, 0, 336> }
   + dot { rotate <0, 0, 342> }
   + dot { rotate <0, 0, 348> }
   + dot { rotate <0, 0, 354> }
   }

// the pendulum, which is, of course, inspired by Poe's the Pit and the Pendulum.
define half_axe
object {
   ( object { sphere <0, 0, 10>, 12 silver }
   * object { sphere <0, 0, 12.2>, 14 axe_color })
   * object { box <-10, -10, -10>, <10, 10, 0> }
   }

define axe
object {
   ( half_axe
   + half_axe { rotate <180, 0, 0> })
   - object { cylinder <0, 10, -10>, <0, 10, 10>, 7 axe_color }
   - object { cylinder <0, -10, -10>, <0, -10, 10>, 7 axe_color }
   scale <1, 1.2, 0.6>
   }

define pendulum
object {
     object {
      cylinder <0, 0, 0>, <0, -30, 0>, 0.4
      shiny_wood { rotate <90, 0, 0> }
      }
   + axe { translate <0, -30, 0> }
   + object { sphere <0, 0, 0>, 0.6
      scale <1, 0.8, 1>
      translate <0, -34, 0> }
   + (object { torus 0.4, 0.2, <0, -34.5, 0>, <0, 1, 0> }
   & object { cylinder <0, -30, 0>, <0, -35, 0>, 0.4 })
   + object { cone <0, -34.7, 0>, 0.4, <0, -35.5, 0>, 0.1 }
   + object { sphere <0, -35.5, 0>, 0.1 }
   axe_color
   scale <0.5, 0.5, 0.5>
   }

// the weights
define weight
object {
     object {
      polygon 4, <-2, 0, -0.5>, <2, 0, -0.5>, <2, -2, -0.5>, <-2, -3, -0.5>
      }
   + object {
      polygon 4, <-2, 0, 0.5>, <2, 0, 0.5>, <2, -2, 0.5>, <-2, -3, 0.5>
      }
   + object {
      polygon 4, <-2, 0, -0.5>, <2, 0, -0.5>, <2, 0, 0.5>, <-2, 0, 0.5>
      }
   + object {
      polygon 5, <-2, 0, -0.5>, <-2, 0, 0.5>,
         <-2, -3, 0.5>, <-2, -4, 0>, <-2, -3, -0.5>
      }
   + object {
      polygon 5, <2, 0, -0.5>, <2, 0, 0.5>,
         <2, -2, 0.5>, <2, -3, 0>, <2, -2, -0.5>
      }
   + object {
      polygon 4, <-2, -3, -0.5>, <2, -2, -0.5>, <2, -3, 0>, <-2, -4, 0>
      silver
      }
   + object {
      polygon 4, <-2, -3, 0.5>, <2, -2, 0.5>, <2, -3, 0>, <-2, -4, 0>
      silver
      }
   + object {
      torus 0.5, 0.15, <0, 0, 0>, <0, 0, 1>
      scale <0.8, 1, 1>
      }
   axe_color
   }

// chain taken from chain.pi by Alexander Enzmann,
// included with the standard Polyray distribution
define link
object {
     (  object { torus 0.5, 0.2, <-0.5, 0, 0>, <0, 1, 0> }
      - object { disc <-0.5, 0, 0>, <-1, 0, 0>, 1 })
   + object { cylinder <-0.5, 0,-0.5>, <0.5, 0,-0.5>, 0.2 }
   + object { cylinder <-0.5, 0, 0.5>, <0.5, 0, 0.5>, 0.2 }
   + (  object { torus 0.5, 0.2, < 0.5, 0, 0>, <0, 1, 0> }
     - object { disc <0.5, 0, 0>, <1, 0, 0>, 1 })
   }

define half_link
object {
     (  object { torus 0.5, 0.2, <1, 0, 0>, <0, 0, 1> }
      - object { disc <1, 0, 0>, <-1, 0, 0>, 1 })
   + object { cylinder <1, -0.5, 0>, <1.5, -0.5, 0>, 0.2 }
   + object { cylinder <1,  0.5, 0>, <1.5,  0.5, 0>, 0.2 }
   }

// 1 and 2 half links of a chain, built to be put into a gridded object
define grid_link
object {
     half_link { rotate <0, 180, 0> } // Half link on the left
   + link                             // Full link
   + half_link                        // Half link on the right
   }

define start_link
object {
     link
   + half_link
   }

define chain
object {
     start_link
   + grid_link { translate <3, 0, 0> }
   + grid_link { translate <6, 0, 0> }
   + grid_link { translate <9, 0, 0> }
   + grid_link { translate <12, 0, 0> }
   + grid_link { translate <15, 0, 0> }
   + grid_link { translate <18, 0, 0> }
   + grid_link { translate <21, 0, 0> }
   + grid_link { translate <24, 0, 0> }
   + grid_link { translate <27, 0, 0> }
   + grid_link { translate <30, 0, 0> }
   gold
   scale <0.5, 0.5, 0.5>
   rotate <0, 0, 90>
   }

define guide
object {
     object { box <-2.3, 0, -0.7>, <-1.8, 50, 0.7> }
   - object { box <-2, -1, -0.5>, <0, 51, 0.5> }
   shiny_wood { rotate <90, 0, 0> }
   }

define guillotin
object {
     guide
   + guide { rotate <0, 180, 0> }
   + weight { translate <0, 33, 0> }
   + chain { translate <0, 33.75, 0> }
   }

define spear
object {
     object {
      cylinder <0, -1, 0>, <0, 79, 0>, 0.7
      shiny_wood { rotate <-90, 0, 0> } }
   + object {
      cone <0, 79, 0>, 1.5, <0, 82.5, 0>, 0 }
   + object {
      cone <0, 79, 0>, 1.5, <0, 78.5, 0>, 0 }
   axe_color
   }

define leg
object {
   sphere <0, 0, 0>, 2
   scale <1, 0.75, 1>
   }

// adornment over the watchface
define ring
object {
   torus 2.2, 0.8, <0, 0, 0>, <0, 1, 0>
   rotate <0, 0, -10>
   }

define noose
object {
     object {
      torus 6, 1, <0, 0, 0>, <0, 0, 1>
      uv_bounds 0.09, 0.91, 0, 1
      rotate <0, 0, 90>
      translate <0, -1.75, 0>
      rope_tex
      }
   + object {
      torus 6, 1, <-7, 8, 0>, <0, 0, 1>
      uv_bounds 0.85, 1, 0, 1
      rope_tex
      }
   + object {
      torus 6, 1, <7, 8, 0>, <0, 0, 1>
      uv_bounds 0.5, 0.65, 0, 1
      rope_tex
      }
   + ring { translate <0, 7, 0> }
   + ring { translate <0, 8.6, 0> }
   + ring { translate <0, 10.2, 0> }
   + ring { translate <0, 11.8, 0> }
   + ring { translate <0, 13.4, 0> }
   + ring { translate <0, 15, 0> }
   + object {
      cylinder <-0.3, 14, 0>, <-0.3, 26, 0>, 1.1
      rope_tex2
      }
   rope_tex3
   scale <0.8, 1, 0.3> * 0.2
   }

// the wooden parts of the clock
define cutter
object {
   box <-3, -3, -3>, <3, 0, 3>
   rotate <0, 45, 0>
   }

define shelf
object {
     (object { cylinder <-3, 0, -1.1>, <3, 0, -1.1>, 0.4 }
   + object { box <-3, -0.6, -1.1>, <3, 0, 0> })
   * cutter { translate <0, 0, 0.5 - sqrt(18)> }
   + (object { cylinder <-3, 0, 1.1>, <3, 0, 1.1>, 0.4 }
   + object { box <-3, -0.6, 1.1>, <3, 0, 0> })
   * cutter { translate <0, 0, -0.5 + sqrt(18)> }
   + (object { cylinder <-1.6, 0, -2>, <-1.6, 0, 2>, 0.4 }
   + object { box <-1.6, -0.6, -2>, <0, 0, 2> })
   * cutter { translate <-0.5 - sqrt(18), 0, 0> }
   + (object { cylinder <1.6, 0, -2>, <1.6, 0, 2>, 0.4 }
   + object { box <1.6, -0.6, -2>, <0, 0, 2> })
   * cutter { translate <0.5 + sqrt(18), 0, 0> }
   scale <1.3, 1.3, 1.3>
   translate <0, 76.5, 0>
   }

define top
object {
     object { box <-10, 66, 0.01>, <10, 76, 0.5> }
      - (object { sphere <-9, 76, 0>, 8 }
       + object { sphere <9, 76, 0>, 8 })
// Left side
   + object {
      cylinder <-9, 76, -0.2>, <-9, 76, 0.1>, 8.1
      uv_bounds 0.73, 1, 0, 1 }
   + object {
      torus 8.1, 0.2, <-9, 76, -0.4>, <0, 0, 1>
      uv_bounds 0.73, 1, 0.75, 1 }
   + object {
      cylinder <-9, 76, -0.4>, <-9, 76, 0.1>, 7.5
      uv_bounds 0.73, 1, 0, 1 }
   + object {
      disc <-9, 76, -0.4>, <0, 0, -1>, 7.5, 7.9
      uv_bounds 0.25, 0.52, 0, 1 }
   + object {
      cylinder <-9, 76, -0.3>, <-9, 76, 0.5>, 7.4
      uv_bounds 0.73, 1, 0, 1 }
   + object {
      disc <-9, 76, -0.3>, <0, 0, -1>, 7.4, 7.5
      uv_bounds 0.25, 0.52, 0, 1 }
   + object {
      torus 7.7, 0.1, <-9, 76, -0.4>, <0, 0, 1>
      uv_bounds 0.73, 1, 0, 1 }
// Right side
   + object {
      cylinder <9, 76, 0.1>, <9, 76, -0.2>, 8.1
      uv_bounds 0.23, 0.5, 0, 1 }
   + object {
      torus 8.1, 0.2, <9, 76, -0.4>, <0, 0, 1>
      uv_bounds 0.5, 0.77, 0.75, 1 }
   + object {
      cylinder <9, 76, 0.1>, <9, 76, -0.4>, 7.5
      uv_bounds 0.23, 0.5, 0, 1 }
   + object {
      disc <9, 76, -0.4>, <0, 0, -1>, 7.5, 7.9
      uv_bounds 0.48, 0.75, 0, 1 }
   + object {
      cylinder <9, 76, 0.5>, <9, 76, -0.3>, 7.4
      uv_bounds 0.23, 0.5, 0, 1 }
   + object {
      disc <9, 76, -0.3>, <0, 0, -1>, 7.4, 7.5
      uv_bounds 0.48, 0.75, 0, 1 }
   + object {
      torus 7.7, 0.1, <9, 76, -0.4>, <0, 0, 1>
      uv_bounds 0.5, 0.77, 0, 1 }
   + shelf
   + noose { translate <0, 71, 0> }
   }

define wooden_parts
object {
     object { box <-10, 50, 0.01>, <10, 67, 15> }
   + object { box <-10, 0, 0.5>, <-9.5, 50, 15> }
   + object { box <10, 0, 0.5>, <9.5, 50, 15> }
   + object { box <-10, 0, 0.5>, <10, 0.5, 15> }
   + object { box <-10, 0, 9.5>, <10, 50, 15> }
   + top
   + leg { translate <-7, -1.5, 2.5> }
   + leg { translate <7, -1.5, 2.5> }
   + leg { translate <-7, -1.5, 12.5> }
   + leg { translate <7, -1.5, 12.5> }
   shiny_wood { rotate <90, 0, 0> }
   }

define clock
object {
     pendulum { rotate <0, 0, 5> translate <0, 50, 9> }
   + watchface { translate <0, 60, 0> }
   + guillotin { translate <-6, 0, 4> }
   + guillotin { rotate <0, 180, 0> translate <6, 0, 5> }
   + spear { translate <-10, 0, 0> }
   + spear { translate <10, 0, 0> }
   + wooden_parts
   }

// The spacecraft

define solar_panel
object {
   box <0.8, -0.05, -0.5>, <4, 0.05, 0.5>
texture { reflective { color <0.1, 0, 0.4> } }
   }

define solar_array
object {
     object { solar_panel rotate <0, 135, 0> }
   + object { solar_panel rotate <0,  45, 0> }
   + object { solar_panel rotate <0,-135, 0> }
   + object { solar_panel rotate <0, -45, 0> }
   + object { cylinder <-0.9, 0, 0>, <0.9, 0, 0>, 0.06 matte_white rotate <0, 45, 0> }
   + object { cylinder <0, 0, -0.9>, <0, 0, 0.9>, 0.06 matte_white rotate <0, 45, 0> }
   + object { cylinder <0, -1, 0>, <0, 0, 0>, 0.2 matte_white }
   + object { cone <0, 0, 0>, 0.2, <0, 0.1, 0>, 0.1 matte_white }
   + object { disc <0, 0.1, 0>, <0, 1, 0>, 0.1 matte_white }
   }

define body_cyl
object {
     object { cylinder <0, 0, 0>, <4, 0, 0>, 1 }
   - object { cylinder <1.5, 0, -1.1>, <1.5, 0, 1.1>, 0.3 }
   - object { cylinder <2.7, 0, -1.1>, <2.7, 0, 1.1>, 0.3 }
   matte_white
   }

define airlock
object {
     object { cylinder <4, 0, 0>, <6, 0, 0>, 0.5 }
   + object { sphere <5, 0, 0>, 0.8 }
   + object { disc <5.9, 0, 0>, <1, 0, 0>, 0.5 }
   matte_white
   }

define main_body
object {
     object { body_cyl }
   + object { cylinder <0, 0, 0>, <4, 0, 0>, 0.99 glass }
   + object { parabola <-0.3, 0, 0>, <0, 0, 0>, 1 matte_white }
   + object { disc <4, 0, 0>, <1, 0, 0>, 1 matte_white }
   + object { airlock }
   }

define antenna
object {
     object { parabola <-0.6, 1.1, 0>, <-0.6, 1.5, 0>, 1.5 matte_white }
   + object { box <-0.7, 1, -0.1>, <0.1, 1.1, 0.1> matte_white }
   + object { cylinder <-0.6, 1.11, 0.3>, <-0.6, 2, 0>, 0.03 matte_white }
   + object { cone <-0.6, 2, 0>, 0, <-0.6, 1.85, 0>, 0.06 shiny_blue }
   }

define spacecraft
object {
     object { main_body }
   + object { antenna rotate <45, 0, 0> }
   + object { solar_array translate <3, 1.7, 0> }
   }

// Spiff in his spacecraft
define reflective_glass
texture {
   surface {
      color white
      ambient 0
      diffuse 0.1
      specular 0.3
      microfacet Cook 4
      reflection 0.8
      }
   }

define glass2
texture {
   surface {
      ambient 0
      diffuse 0
      specular 0.3
      microfacet Phong 6
      reflection white, 0.5
      transmission white, 0.9, 1.1
      }
   }

define matte_springgreen
texture { matte { color MediumSpringGreen } }

define leather
texture {
   surface {
      color <0.5, 0.2, 0.1>
      ambient 0.2
      diffuse 0.5
      specular 0.3
      microfacet Phong 30
      }
   }

// Spiff's spacecraft with Spiff inside
define seat
object {
     object {
      box <-0.4, 0, -0.15>, <0.4, 0.7, 0.15> }
   + object {
      cylinder <-0.4, 0.7, 0>, <0.4, 0.7, 0>, 0.15 }
   + object {
      disc <-0.4, 0.7, 0>, <1, 0, 0>, 0.15 }
   + object {
      disc <0.4, 0.7, 0>, <1, 0, 0>, 0.15 }
   + object {
      sphere <-0.2, 0.6, -0.25>, 0.2
      matte_springgreen }
   + object {
      sphere <0.2, 0.6, -0.25>, 0.2
      matte_springgreen }
   leather
   rotate <-15, 0, 0>
   translate <0, 0.2, -0.5>
   }

define hair
object {
     object { cone <-0.4, 0.45, -0.45>, 0.1, <-0.3, 0.7, -0.45>, 0 }
   + object { cone <-0.5, 0.45, -0.2>, 0.14, <-0.4, 0.75, -0.2>, 0 }
   + object { cone <-0.5, 0.45, 0.1>, 0.16, <-0.4, 0.75, 0.1>, 0.01 }
   + object { cone <-0.4, 0.45, 0.4>, 0.09, <-0.3, 0.71, 0.4>, 0 }

   + object { cone <-0.2, 0.45, -0.50>, 0.11, <-0.1, 0.75, -0.55>, 0 }
   + object { cone <-0.3, 0.5, -0.1>, 0.16, <-0.2, 0.8, -0.1>, 0 }
   + object { cone <-0.3, 0.5, 0.2>, 0.15, <-0.2, 0.8, 0.2>, 0 }
   + object { cone <-0.2, 0.45, 0.5>, 0.12, <-0.1, 0.75, 0.5>, 0 }

   + object { cone <0.05, 0.45, -0.45>, 0.11, <0.15, 0.75, -0.5>, 0 }
   + object { cone <0, 0.5, -0.2>, 0.13, <0.1, 0.8, -0.2>, 0 }
   + object { cone <0, 0.5, 0.1>, 0.14, <0.1, 0.8, 0.1>, 0 }
   + object { cone <0.05, 0.45, 0.45>, 0.1, <0.15, 0.75, 0.5>, 0 }

   + object { cone <0.25, 0.45, -0.4>, 0.1, <0.35, 0.7, -0.45>, 0 }
   + object { cone <0.2, 0.5, -0.2>, 0.14, <0.3, 0.75, -0.2>, 0 }
   + object { cone <0.2, 0.5, 0.1>, 0.16, <0.3, 0.75, 0.1>, 0.01 }
   + object { cone <0.25, 0.45, 0.4>, 0.09, <0.35, 0.69, 0.4>, 0 }

   + object { cone <0.3, 0.4, -0.3>, 0.08, <0.45, 0.67, -0.3>, 0 }
   + object { cone <0.4, 0.4, 0>, 0.15, <0.6, 0.7, 0>, 0.03 }
   + object { cone <0.3, 0.4, 0.3>, 0.09, <0.45, 0.66, 0.3>, 0 }
   matte_yellow
   }

define head
object {
     object { sphere <-0.1, 0, 0>, 0.7 scale <1, 1.2, 1>
      texture { matte { color <0.9, 0.5, 0.2> } } }
   * object { sphere <-0.1, -0.7, 0>, 1.3
      matte_yellow }
   + object { sphere <-0.8, -0.2, 0>, 0.1 } // nose
   + object { sphere <0, 0, 0>, 0.2 // ear
      scale <1, 1, 0.4>
      rotate <-10, 20, 0>
      translate <-0.1, 0, -0.75> }
   + object { sphere <0, 0, 0>, 0.2 // ear
      scale <1, 1, 0.4>
      rotate <10, -20, 0>
      translate <-0.1, 0, 0.75> }
   texture { matte { color <0.9, 0.5, 0.2> } }
   }

define goggles
object {
     object {
      box <-0.85, -0.1, -0.6>, <-0.8, 0.4, 0.6>
      matte_black }
   + object {
      box <-0.851, 0, -0.5>, <-0.799, 0.1, 0.5>
      matte_white }
   + object {
      cylinder <-0.8, 0.1, -0.58>, <-0.1, 0.1, -0.7>, 0.02
      matte_black }
   + object {
      cylinder <-0.8, 0.1, 0.58>, <-0.1, 0.1, 0.7>, 0.02
      matte_black }
   }

define body
object {
   parabola <0, -0.6, 0>, <0, -2, 0>, 0.7
   scale <1, 1, 1.5>
   texture { matte { color skyblue } }
   }

define Spiff
object {
     hair
   + head
   + goggles
   + body
   rotate <0, 90, 0>
   translate <0, 1.5, 0>
   scale <0.6, 0.6, 0.6>
   }

define Spiffs_craft
object {
     object {  // hull
         sphere <0, 0, 0>, 1
         shiny_red
         scale <3, 1, 3> }
   - (object {
         cylinder <0, 0, 0>, <0, 2, 0>, 1.5
         matte_black
         }
   + object { // headlights
         cylinder <-0.7, 0.4, 1.8>, <-0.7, 0.4, 3>, 0.2
         silver
         }
   + object {
         cylinder <0.7, 0.4, 1.8>, <0.7, 0.4, 3>, 0.2
         silver
         })
   + object { // glass for the headlights
         sphere <0, 0, 0>, 0.99
         uv_bounds 0.5, 1, 0.5, 0.7
         scale <3, 1, 3>
         reflective_glass
         }
   + object {  // the cockpit
         sphere <0, 0, 1>, 1
         scale <1.5, 1, 1.5>
         uv_bounds 0, 1, 0.5, 1
         rotate <0, 0, 0> // this statement is for opening the cockpit
         translate <0, 0.8, -1.5>
         glass2
         }
   + object { // dashboard
         cone <0, 0.6, 0>, 1, <0, 0.85, 0>, 1.5
         texture {
            special matte {
               color planar_imagemap (image ("dash.gif"), <u, 0, v>)
               }
            }
         rotate <0, 80, 0>
         }
   + seat
   + object { // steering-wheel
         torus 0.2, 0.05, <0, 0, 0>, <0, 0, 1>
         rotate <10, 0, 0>
         translate <0, 0.8, 0.9>
         matte_black
         }
   + object {  // Tail-fin
         polygon 3, <-1, 1.5, -2.5>, <-1, 0, -2.5>, <-1, 0, -1>
         shiny_red
         }
   + object {  // Tail-fin
         polygon 3, <1, 1.5, -2.5>, <1, 0, -2.5>, <1, 0, -1>
         shiny_red
         }
   + Spiff
      }

// Castle on a rock
define transparent
texture {
   surface {
      transmission 1, 1
      }
   }

define green_glass
texture {
   surface {
      color <0.6, 1, 0.8>
      ambient 0
      diffuse 0.1
      specular 0.2
      reflection 0.1
      transmission 0.7, 1.1
      }
   }

define gold
texture {
   surface {
      color <1, 0.9, 0.3>
      ambient 0.5
      diffuse 0.5
      specular white, 0.5
      microfacet Phong 5
      }
   }

define window_arch
object {
     object {
      cylinder <0, 2, -0.1>, <0, 2, 0.05>, 1
      uv_bounds 0, 0.5, 0, 1 }
   + object {
      cylinder <0, 2, -0.1>, <0, 2, 0.05>, 0.9
      uv_bounds 0, 0.5, 0, 1 }
   + object {
      disc <0, 2, 0.05>, <0, 0, 1>, 0.9, 1
      uv_bounds 0.25, 0.75, 0, 1 }
   + object {
      disc <0, 2, -0.1>, <0, 0, 1>, 0.9, 1
      uv_bounds 0.25, 0.75, 0, 1 }
   shiny_wood
   }

define arch_window_glass
object {
     object {
      disc <0, 2, 0>, <0, 0, 1>, 1
      uv_bounds 0.25, 0.75, 0, 1 }
   + object {
      polygon 4, <-1, 0, 0>, <1, 0, 0>, <1, 2, 0>, <-1, 2, 0> }
   green_glass
   }

define arch_window_frame
object {
     object {
      box <-1, 0, -0.1>, <-0.9, 2, 0.05> }
   + object {
      box <1, 0, -0.1>, <0.9, 2, 0.05> }
   + object {
      box <-0.05, 0, -0.1>, <0.05, 2.9, 0.05> }
   + object {
      box <-1, 0, -0.12>, <1, 0.025, 0.07> }
   + object {
      box <-1, 0.95, -0.1>, <1, 1.05, 0.05> }
   + object {
      box <-1, 1.95, -0.1>, <1, 2.05, 0.05> }
   shiny_wood
      }

define arch_window
object {
     window_arch
   + arch_window_glass
   + arch_window_frame
   scale <0.7, 0.7, 0.7>
   }

define arch_window_shape // To cut holes in the walls for the door
object {
     object {
      box <-1, 0, -1>, <1, 2, 2> }
   + object {
      cylinder <0, 2, -1>, <0, 2, 2>, 1
      uv_bounds 0, 0.5, 0, 1 }
   + object {
      disc <0, 2, -1>, <0, 0, 2>, 1
      uv_bounds 0.25, 0.75, 0, 1 }
/*   + object {
      disc <0, 2, 2>, <0, 0, 2>, 1
      uv_bounds 0.25, 0.75, 0, 1 }*/
   shiny_wood
      }


define tower
object {
     object {
      cylinder <0, -1, 0>, <0, 10, 0>, 1.5 }
   + object {
      cone <0, 10, 0>, 1.5, <0, 10.5, 0>, 2 }
   + object {
      cylinder <0, 10.5, 0>, <0, 13, 0>, 2 }
   + arch_window { scale <0.6, 0.6, 0.6> translate <0, 11, -2.05> }
   + arch_window { scale <0.6, 0.6, 0.6> translate <0, 11, -2.05> rotate <0, 90, 0> }
   + arch_window { scale <0.6, 0.6, 0.6> translate <0, 11, -2.05> rotate <0, 180, 0> }
   + arch_window { scale <0.6, 0.6, 0.6> translate <0, 11, -2.05> rotate <0, 270, 0> }
   + object {
      cone <0, 12.7, 0>, 2.3, <0, 15, 0>, 0
      shiny_red }
   gold
   }

define rot2 sqrt(2)

define front_tower
object {
     object {
      box <-2.5, -5, -0.5>, <2.5, 13, 2.5> }
   - arch_window_shape
   + object {
      box <-2, 0, -0.2>, <2, 4, 0.9>
      shiny_wood { rotate <0, 0, 90> } }
   + object {
      box <-2.5, 12.5, -1>, <2.5, 15, 3> }
   + object {
      box <-2.5, -rot2, -rot2>, <2.5, rot2, rot2>
      rotate <45, 0, 0>
      translate <0, 14.99, 1> }
   + object {
      polygon 4, <-2.8, 14.7, -1.3>, <2.8, 14.7, -1.3>,
                <2.8, 17, 1>, <-2.8, 17, 1>
      shiny_red }
   + arch_window { translate <0, 9.5, -0.6> }
   + arch_window { scale <0.6, 0.6, 0.6> translate <-1.5, 13, -1.1> }
   + arch_window { scale <0.6, 0.6, 0.6> translate <1.5, 13, -1.1> }
   gold
   }

define front_wall
object {
     object {
      box <-10, -5, 0.5>, <10, 6, 1.5> }
   + object {
      box <-10, 5, -0.5>, <10, 7.9, 2.5> }
   + object {
      polygon 4, <-10, 7.7, -0.8>, <10, 7.7, -0.8>,
                 <10, 9.5, 1>, <-10, 9.5, 1>
      shiny_red }
   + object {
      polygon 4, <-10, 7.7, 2.8>, <10, 7.7, 2.8>,
                 <10, 9.5, 1>, <-10, 9.5, 1>
      shiny_red }
    + arch_window { translate <-5, 1, 0.4> }
    + arch_window { translate <5, 1, 0.4> }
    + arch_window { scale <0.6, 0.6, 0.6> translate <-5, 6, -0.6> }
    + arch_window { scale <0.6, 0.6, 0.6> translate <5, 6, -0.6> }
    + arch_window { scale <0.6, 0.6, 0.6> translate <0, 6, -0.6> }
   gold
   }

define back_wall
object {
     object {
      box <-10, -5, 0.5>, <10, 6, 1.5> }
   + object {
      box <-10, 5, -0.5>, <10, 7.9, 2.5> }
   + object {
      polygon 4, <-10, 7.7, -0.8>, <10, 7.7, -0.8>,
                 <10, 9.5, 1>, <-10, 9.5, 1>
      shiny_red }
   + object {
      polygon 4, <-10, 7.7, 2.8>, <10, 7.7, 2.8>,
                 <10, 9.5, 1>, <-10, 9.5, 1>
      shiny_red }
    + arch_window { translate <0, 1, 0.4> }
    + arch_window { translate <-5, 1, 0.4> }
    + arch_window { translate <5, 1, 0.4> }
    + arch_window { scale <0.6, 0.6, 0.6> translate <-5, 6, -0.6> }
    + arch_window { scale <0.6, 0.6, 0.6> translate <5, 6, -0.6> }
    + arch_window { scale <0.6, 0.6, 0.6> translate <0, 6, -0.6> }
   gold
   translate <0, 0, 9>
   }

define castle
object {
      tower { translate <-10, 0, 0> }
    + tower { translate < 10, 0, 0> }
    + tower { translate <-10, 0, 10> }
    + tower { translate < 10, 0, 10> }
    + front_wall
    + front_tower
    + object { box <-10, -5, 1>, <-9, 6, 10> gold }
    + object { box <10, -5, 1>, <9, 6, 10> gold }
    + back_wall
    }

define castle_on_rock
object {
     object {
         object {
            height_field "fract004.gif"
            translate <-0.5, 112, -0.5>
            scale <100, 0.03, 100>
            rotate <0, 90, 0>
            Stone5
            }
       & object {
            box <-50, 0, -50>, <50, 256, 50>
            transparent
            }
      translate <0, 0, 0>
      }
   + object {
         object {
            height_field "fract004.gif"
            scale <1, -1, 1>
            translate <-0.5, -112, -0.5>
            scale <100, 0.2, 100>
            rotate <0, 90, 0>
            Stone5
            }
       & object {
            box <-50, 0, -50>, <50, -256, 50>
            transparent
            }
      translate <0, 0, 0>
      }
   + castle
   }
