// Persistence of Vision Ray Tracer Scene Description File
// File: lake.inc
// Vers: 3.0
// Desc: The lake and The Source
// Date: 31-08-97
// Auth: Samuel Ward

// The lake
#declare Lake = union {
#declare Rad = 13
cylinder { <37,-15,12>,<37,-9.5,12>,Rad
//  pigment {color Red}
   texture{
     pigment{ color SlateBlue  }
     finish{ F_MetalC } //was Metal
     normal {
       bozo
       turbulence 0.5
       lambda 2
       normal_map {
         [0.4 dents .15 scale 0.1]
         [0.6 agate turbulence 1]
         [1.0 dents .15 scale 0.1]
       }
     }
   }
}

torus { (Rad-0.5),1.25
  //pigment {color Red}
  texture {T_Stone16}
translate <37,-10.5,12>
}
}

// A single claw
#declare s_claw = blob {
   threshold 0.600000
   component 1.000000, 0.451137, <-0.465430, 0.000000, -0.549618>
   component 1.000000, 0.454768, <0.541730, 0.000000, -0.549618>
   component 1.000000, 0.489768, <0.038150, 0.000000, -0.595420>
   component 1.000000, 0.446689, <0.953750, 0.000000, -0.290076>
   component 1.000000, 0.432540, <1.213169, 0.000000, 0.091603>
   component 1.000000, 0.451137, <-0.938490, 0.000000, -0.442748>

   texture {
      Chrome_Metal
      finish { ambient 0.3 diffuse 0.7 phong 1.0 phong_size 90 }
   }
scale .8
}

//The actual Source
#declare Ball =
sphere{ 0, 1
  texture{
    pigment{ rgbt 1 }
    halo{
      emitting
      linear
      samples 25
      turbulence 0.15
      lambda 2.5
      omega 0.6
      scale 0.85
      frequency 1
      color_map{
        [0.0 SlateBlue transmit 1]
        [0.5 color (White*2+SlateBlue)/3 transmit 0.5]
        [0.7 color (White*2+SlateBlue)/3 transmit 0]
        [0.8 color (White*2+SlateBlue)/3 transmit -0.5]
        [1.0 color (White*2+SlateBlue)/3 transmit -2.35]
      }
    }
  }
 hollow
  scale 10
  translate <0,0,0>
}

//The combined claw
#declare Claw = union {
object {s_claw translate z*-.1 rotate x*120}
object {s_claw translate z*-.1 rotate x*240}
object {s_claw translate z*-.1 rotate x*360}
//pigment {color Red}
}