// Persistence of Vision Ray Tracer Scene Description File
// File: SWMagic.pov
// Vers: 3.0
// Desc: Entry for IRTC: Subject Magic
// Title: The Source.
// Date: 31-08-97
// Auth: Samuel Ward
#version 3

//#declare View_POV_Include_Stack = 1 // for debug

#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "metals.inc"
#include "stones.inc"
#include "marble.inc"
#include "woods.inc"
#include "textur-f.inc"
//#declare Tree1 = sphere { 0,1 pigment {color Red}} // For testing
//#declare Shrub_Tree = sphere { 0,1 pigment {color Red}} // For testing
#include "objects.inc"
#include "enviro.inc"
#include "lake.inc"
#include "tree-f.inc"
#include "objects.inc"
#include "temple.inc"
/*
// Global settings
global_settings {
  radiosity {
    count            100
    distance_maximum 45
    nearest_count    6
  }
}*/

// The radiosity settings
#include "consts.inc"
#declare Rad_Quality = Radiosity_Final
#include "rad_def.inc"

camera{
  location <42,4.5,-100> //x was ;16,10,-75;42,10,-75
  look_at <26,3,-20> //x was 0 ;16,5,-20;26,5,-20
  angle 30
}

light_source{ <100,100,-100> Gray60 shadowless}
object {Lake}
object {Claw scale 5 rotate z*-90 translate <37,-5,12>}
light_source{ <36.9,-5,12> Gray25 looks_like {Ball} fade_distance 38 fade_power 5}
//light_source{ <36.9,-5,12> Gray25 fade_distance 38 fade_power 5}
object {Ground}
object {Mountains}
object {Wall}
object {Arch translate x*20}
object {Door
    translate x*20
    translate z*60
}
object {Temple translate y*5 translate z*-10}
object {Roof translate y*-.1}

object {Tree1 translate <27,-10,50>}
object {Tree1 rotate y*180 translate <13,-10,50>}