// SNAILS WORLD  - Schneckenwelt
// POV 3 / Windows NT / by U. Hausstaedtler, 1997

#version 3

#include "colors.inc"		// it is assumeing, that this
#include "textures.inc"		// include files are available
#include "golds.inc"       	// the special gold is used for the snail an can changed easily

global_settings {   assumed_gamma 1.0 }

// -------- general settings -------------------

camera
{
  location  <0, 1.5, -4>    //0,1.5,-4
  direction 1.65*z
  right     4/3*x
  look_at   <0.11, 0.0,  0.0>
}

sky_sphere { pigment  {  gradient y  color_map { [0.0 color blue 0.8] [1.0 color rgb 1] }   } }

light_source {0*x  color red 1.0  green 1.0  blue 1.0   translate <-20, 20, -20> }
light_source {0*x  color red 1.0  green 1.0  blue 0.2   translate <-.5, -.4, 10> }
light_source {0*x  color red 0.4  green 0.8  blue 0.8   translate <1, 5, -20> }


// --------- object definitions -----------------

#declare Cobalt_Glass=       //by John Tougas
		texture  {pigment { color red .071 green .039 blue .639 filter 0.90 }
                          finish  { Glossy  ambient 0   diffuse 0  refraction 1    ior 1.6 }    }


julia_fractal { <-0.08321,1.2,-0.053,-0.0025>  quaternion  sqr max_iteration 4  precision 12

                texture {  Cobalt_Glass  finish { phong 0.6 phong_size 65 }

      } rotate -120*z rotate -10*x }


#declare WHITE_NEON = texture {  T_Gold_2A  
			finish { ambient 0.1 diffuse 0.6 phong 0.9  
				 phong_size 100  reflection 0.2 specular 0.2 }  }     }

#declare BLACK_MATTE = texture {   
			finish { ambient 0.3 diffuse 0.7 phong 0.95  phong_size 55  }
			pigment { color Sienna } }

#declare BEIGE_MATTE = texture {   
			finish { ambient 0.6  diffuse 0.3  phong 0.9 phong_size 40  }
			pigment { color Black } }


#declare schnecke= object { #include "snail.inc" }

object { schnecke  translate <0,200,0> scale 0.005 rotate <-90,200,0> translate -.5*y
                   rotate <-85,0,-20> rotate <-5,10,0> translate <.58,-0.11,-1.41> }

object { schnecke  translate <0,200,0> scale 0.005 rotate <-90,175,0> translate -.5*y
                   rotate <-18,0,-10> translate <-0.92,.925,-0.3> } 

object { schnecke  translate <0,200,0> scale 0.005 rotate <-90,270,0> translate -.5*y
                   rotate 20*z translate <.53,.96,.3> } //<.53,.92,.3>

// end of file
