/*
Excalibur         By:Juha Leppl aka Jide
7.29.1997
*/

#include "colors.inc"
#include "sword.inc"

global_settings
{
  max_trace_level 30
}

#declare camera_location = <3,7,-10>
#declare camera_look_at = <0,6.5,0>
#declare effect_location = <-900,1200,5500>
#declare effect_type = "Sun"
#declare options_only = true #include "lens.inc"
#declare source_colour = <1.2,1.2,1.2>
#declare effect_colour = <0.8,0.8,0.8>
#declare effect_scale = 1.1
#declare effect_brightness = 1.1
#declare effect_intensity = 1.3
#declare glow_type = 1
#declare rays_type = 5
#declare spots_type = 0
#declare rays_intensity = 2
#declare effect_always_on_top = false
#include "lnsefcts.inc"


fog
{
  fog_type   2
  distance   125
  color      rgbt <0.86,0.84,0.75,0.4>
  fog_offset 0.05
  fog_alt    5
  turbulence 1
  omega 0.4
  lambda 1.3
}


camera {
  location camera_location
  look_at camera_look_at
}

light_source {
  <-200,1600,2000>
  color rgb 0.4
  fade_power 1
  fade_distance 1800
}

light_source {
  effect_location
  color rgb 1
}

light_source {
  <3,7,-3>
  color rgb <0.23.23,0.1>
  fade_power 1
  fade_distance 5
  area_light
  <2,0,0>,<0,0,2>
  3,3
  adaptive 1
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb <0.55,0.57,0.2>] [0.85 color rgb <0.35,0.38,0.5>] }
  }
}

// The base of this sky_sphere is Sonya Robert's, but I changed it to fit my needs.
// I hope she doesn't mind.
object {
	sphere {<0,0,0>,5000}
	hollow
	texture {
		pigment {
			bozo
			turbulence 0.485
			octaves 4
			lambda 3.0
			color_map {
				[0.4 color rgbf 1 ]
        [0.5 color rgbf <0.6,0.5,0.2,0.55>]
        [0.75 color rgbf <0.65,0.62,0.3,0.4>]
        [0.8 color rgbf <0.75,0.75,0.4,0.55>]
        [0.9 color rgbf <0.65,0.6,0.35,0.4>]
      }
		}
		finish {
			ambient 1.0
			diffuse 0.0
		}    
    rotate <20,90,120>
    scale <3000, 1550, 1000>
    translate <-3600,-1550,200>
  }
  no_shadow
}

plane {
  y,-10
  pigment { color rgb <0.7,0.5,0.4> }
}

plane {
  y,-0.2
  texture {
    pigment {
      color rgbf <0.85, 0.85, 1, 0.6>
    }
    normal { bumps 0.2 turbulence 0.3}
    finish {
      reflection 0.45
      refraction 1 ior 1.33
      phong 1 phong_size 50
    }
    scale 2
  }
}

height_field {
  tga "shore.tga"
  smooth
  pigment {
    granite
    turbulence 0.8
    omega 0.3
    color_map {
      [0 color rgb <0.6,0.45,0.4>]
      [1 color rgb <0.6,0.55,0.5>]
    }
    scale <0.03,0.15,0.0115>
  }
  normal { dents 0.15 scale <0.0025,0.01,0.001>}
  scale <20,4,52>
  translate <-10,0,-8>
}

height_field {
  tga "island.tga"
  scale <300,500,200>
  translate <-500,-100,400>
  pigment { granite color_map { [0 color Gray25] [1 color Gray35] } }
}

union {
  difference {
    cylinder { <0,0,0>,<0,10,0>,1 }
    #declare Window=
      union {
        cylinder { <-1.01,0,0.5>,<1.01,0,0.5>,0.35 }
        box { <-1.01,-0.5,0.85>,<1.01,0,0.15> }
      }
    object { Window translate <0,8.3,0> }
    object { Window rotate y*90 translate <0,8.3,0>}
    cylinder { <0,8.1,0>,<0,9,0>,0.9 }
    pigment { Gray40 }
    normal { bumps 1 }
  }
  cone { <0,10,0>,1.22,<0,12.5,0>,0.01 pigment { Brown } }
  box {<-0.03,12.3,-0.1>,<0.03,13.5,0.1> pigment { Black } }
  box {<-0.07,13.15,-0.1>,<0.07,13.2,0.1> pigment { Black } }
  scale <8,6,8>
  translate <-250,90,400>
}


object {
  #declare LeafShape = 6
  #declare LeafTexture = 2 
  #declare BarkTexture = 0
  #declare SD1 = seed(19)
  #declare BaseLen = 1
  #declare MinSplits = 5
  #declare IncXDeg = 1.15
  #include "trees.inc"
  translate <9,3,10>
}

object {
  #declare SD1 = seed(18)
  #declare IncXDeg = 0.8
  #declare MinSplits = 4
  #declare LeafShape = 6
  #declare LeafTexture = 2
  #declare BaseLen = 1.2
  #include "trees.inc"
  translate <-19.5,1,6.1>
}

union {
  box {
    <-1,0,-1>,<1,6,1>
    pigment {
      granite
      turbulence 1
      omega 0.4
      color_map {
        [0 color rgb <0.5,0.5,0.55>]
        [1 color rgb 0.4 ]
      }
    }
  }
  object { Sword scale <0.165,0.12,0.165> rotate x*180  translate <0,4.25,0>}
  translate 0 rotate y*8 
  translate <1,0.4,-3.2>
}
