// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "skies.inc"

#declare Chariots = on
#declare Stadium = on
#declare Wall_high = on
#declare Rider = on
#declare Env = on

camera {
	location <0,3,0>
	look_at  <0,3,30>
}

light_source {<10,20,-10> color White}
light_source {<0,3,0> color Gray30 shadowless fade_distance 20}

background {<.5,.55,.75>}

#include "13chariot.inc"

#if (Chariots = on)
#declare Chariot1 =
union {
object {Chariot translate <9,0,0>}

#declare Horn = on
#declare Sdist = 8
#declare Srot = -8
#declare Srot2 = 10
#declare Srot3 = 30

#declare Horse_Base = <1,1,1>
#declare T_Translate = <0,0,0>
#declare Neck_angle = 20
#declare Left_front_upper_angle = -40
#declare Left_front_lower_angle = 5
#declare Left_front_hoof_angle = 20
#declare Right_front_upper_angle = -60
#declare Right_front_lower_angle = 10
#declare Right_front_hoof_angle = 40

#declare Left_rear_upper_angle = 15
#declare Left_rear_lower_angle = 10
#declare Left_rear_hoof_angle = 20
#declare Right_rear_upper_angle = 20
#declare Right_rear_lower_angle = 10
#declare Right_rear_hoof_angle = 40

#include "13horse.inc"
object {Horse_13 translate <0,0,1.7>}

#declare Horn = on
#declare Sdist = 7.25
#declare Srot = 10
#declare Srot2 = 5
#declare Srot3 = 15

#declare Horse_Base = <1.5,1.5,1.5>
#declare T_Translate = <1,1,1>
#declare Neck_angle = 0
#declare Left_front_upper_angle = 20
#declare Left_front_lower_angle = 15
#declare Left_front_hoof_angle = 20
#declare Right_front_upper_angle = 10
#declare Right_front_lower_angle = 15
#declare Right_front_hoof_angle = 40

#declare Left_rear_upper_angle = 45
#declare Left_rear_lower_angle = 5
#declare Left_rear_hoof_angle = 20
#declare Right_rear_upper_angle = 30
#declare Right_rear_lower_angle = 5
#declare Right_rear_hoof_angle = 40
#declare Tail_pivot = -10
#include "13horse.inc"
object {Horse_13 translate <0,0,4.2>}

#declare Horn = on
#declare Sdist = 7.25
#declare Srot = 6.5
#declare Srot2 = -5
#declare Srot3 = -15

#declare Horse_Base = <1,1,1>
#declare T_Translate = <10,10,10>
#declare Neck_angle = 0
#declare Left_front_upper_angle = -20
#declare Left_front_lower_angle = 25
#declare Left_front_hoof_angle = 20
#declare Right_front_upper_angle = -40
#declare Right_front_lower_angle = 30
#declare Right_front_hoof_angle = 40

#declare Left_rear_upper_angle = -5
#declare Left_rear_lower_angle = 5
#declare Left_rear_hoof_angle = 20
#declare Right_rear_upper_angle = -10
#declare Right_rear_lower_angle = 10
#declare Right_rear_hoof_angle = 40
#declare Tail_pivot = 10
#include "13horse.inc"
object {Horse_13 translate <0,0,-1.7>}

#declare Horn = on
#declare Sdist = 8
#declare Srot = -20
#declare Srot2 = -10
#declare Srot3 = -30

#declare Horse_Base = <1.6,1.6,1.6>
#declare T_Translate = <5,5,5>
#declare Neck_angle = 30
#declare Left_front_upper_angle = -40
#declare Left_front_lower_angle = 5
#declare Left_front_hoof_angle = 20
#declare Right_front_upper_angle = -60
#declare Right_front_lower_angle = 10
#declare Right_front_hoof_angle = 40

#declare Left_rear_upper_angle = 35
#declare Left_rear_lower_angle = 5
#declare Left_rear_hoof_angle = 20
#declare Right_rear_upper_angle = 20
#declare Right_rear_lower_angle = 10
#declare Right_rear_hoof_angle = 40
#declare Tail_pivot = 0
#include "13horse.inc"
object {Horse_13 translate <0,0,-4.2>}

#if (Rider = on)
#include "Gladiator.inc"
object {Gladiator scale 9 translate <8,1.5,0> pigment{White}}
#end

}
#if (Env = on)
#declare Chariot2 =
union {

object {Chariot translate <9,0,0>}

#declare Horse_Base = <.3,.3,.3>
#declare T_Translate = <10,10,7>
#declare Neck_angle = 15
#declare Left_front_upper_angle = -20
#declare Left_front_lower_angle = 5
#declare Left_front_hoof_angle = 10
#declare Right_front_upper_angle = -30
#declare Right_front_lower_angle = 10
#declare Right_front_hoof_angle = 20
#include "13horse.inc"
object {Horse_13 translate <0,0,1.7>}

#declare Horse_Base = <.1,.1,.1>
#declare T_Translate = <5,5,5>
#declare Neck_angle = 25
#declare Left_front_upper_angle = -50
#declare Left_front_lower_angle = 10
#declare Left_front_hoof_angle = 20
#declare Right_front_upper_angle = -70
#declare Right_front_lower_angle = 5
#declare Right_front_hoof_angle = 40
#include "13horse.inc"
object {Horse_13 translate <0,0,4.2>}

#declare Horse_Base = <.5,.5,.5>
#declare T_Translate = <10,20,10>
#declare Neck_angle = 0
#declare Left_front_upper_angle = 10
#declare Left_front_lower_angle = 10
#declare Left_front_hoof_angle = 0
#declare Right_front_upper_angle = 20
#declare Right_front_lower_angle = 20
#declare Right_front_hoof_angle = 0
#include "13horse.inc"
object {Horse_13 translate <0,0,-1.7>}

#declare Horse_Base = <.2,.2,.2>
#declare T_Translate = <0,0,0>
#declare Neck_angle = 30
#declare Left_front_upper_angle = -40
#declare Left_front_lower_angle = 5
#declare Left_front_hoof_angle = 20
#declare Right_front_upper_angle = -60
#declare Right_front_lower_angle = 10
#declare Right_front_hoof_angle = 40
#include "13horse.inc"
object {Horse_13 translate <0,0,-4.2>}

}

object {Chariot2 translate <5.91,0.00,11.88>}
#end
object {Chariot1 translate <-7.23,0.00,21.28>}
#end
#if (Env = on)
object {Wheel2 rotate <90,0,5> translate <-2.5,0.25,6>}

#if (Stadium = on)
#include "blocks.inc"
object {Wall translate <0,0,27>}

#declare Ground = height_field {tga "sand.tga"
texture{
  pigment
  {
    bozo
    color_map
    {
      [0.00 color rgb<0.961, 0.882, 0.667>]
      [0.23 color rgb<0.898, 0.835, 0.635>]
      [0.50 color rgb<0.890, 0.733, 0.514>]
      [0.71 color rgb<0.945, 0.776, 0.584>]
      [1.00 color rgb<0.886, 0.788, 0.565>]
    }
	scale .25
	turbulence 0.5
  }
}
	finish {crand 0.2}
	translate <-0.5,0,-0.5>
}

object {Ground scale <40,0.5,20> translate <0,0,15>}
#end

sky_sphere {S_Cloud2}
#end
