#include "Harness.inc"

#ifndef (Horse_Base)
#declare Horse_Base = <1,1,1>
#end

#ifndef (T_Translate)
#declare T_Translate = <0,0,0>
#end

#include "T_Horse1.inc"

#ifndef (Neck_angle)
#declare Neck_angle = 0						// must be +ve
#end
#ifndef (Head_angle)
#declare Head_angle = 0
#end
#ifndef (Right_rear_upper_angle)
#declare Right_rear_upper_angle = 0
#end
#ifndef (Right_rear_lower_angle)
#declare Right_rear_lower_angle = 0			// must be -ve
#end
#ifndef (Right_front_upper_angle)
#declare Right_front_upper_angle = 0
#end
#ifndef (Right_front_lower_angle)
#declare Right_front_lower_angle = 0		// must be +ve
#end
#ifndef (Left_rear_upper_angle)
#declare Left_rear_upper_angle = 0
#end
#ifndef (Left_rear_lower_angle)
#declare Left_rear_lower_angle = 0			// must be -ve
#end
#ifndef (Left_front_upper_angle)
#declare Left_front_upper_angle = 0
#end
#ifndef (Left_front_lower_angle)
#declare Left_front_lower_angle = 0			// must be +ve
#end
#ifndef (Right_front_hoof_angle)
#declare Right_front_hoof_angle = 0
#end
#ifndef (Left_front_hoof_angle)
#declare Left_front_hoof_angle = 0
#end
#ifndef (Right_rear_hoof_angle)
#declare Right_rear_hoof_angle = 0
#end
#ifndef (Left_rear_hoof_angle)
#declare Left_rear_hoof_angle = 0
#end
#ifndef (Tail_pivot)
#declare Tail_pivot = 0
#end


#declare Horse_body =
union {
blob {
threshold 0.5
	sphere {<0,0,0>,1.7,1 scale <1.5,1,1> translate <0.6,2.9,0>}
	sphere {<0,3.6,0>,1,1}
	sphere {<2.5,3,0>,1.4,1}
	sphere {<-0.52,2.66,-0.5>,0.5,1}
	sphere {<-0.52,2.66,0.5>,0.5,1}
}
object {Body_Harness}
}

#declare Hoof =
difference {
	cone {<0,0,0>,0.115,<0,-0.27,0>,0.285 texture{T_Horse3}normal{gradient y .25 scale .04 turbulence .2}}
	box {<0.1,10,10><10,-10,-10> texture{T_Horse3}normal{gradient y .25 scale .04 turbulence .2}}
}

#declare Horse_rear_leg_lower =
blob{
threshold 0.5
	cylinder {<0,0,0><-0.31,-0.87,0>,0.2,1}
	sphere {<-0.34,-0.9,0>,0.24,1}
	sphere {<0,0,0>,0.34,1}
	sphere {<-0.16,-0.80,0>,0.22,1}
}

#declare Horse_rear_leg =
blob {
threshold 0.5
	sphere {<0,0,0>,1,1 scale <1,1.5,1>}
	cylinder {<-0.39,-0.14,0><0.23,-1.65,0>,0.25,1}
	cylinder {<0.21,-0.3,0><0.1,-1.22,0>,0.2,1}
	sphere {<0,0,0>,0.32,1 scale <1,1.5,1> translate <0.03,-0.73,0>}
	sphere {<0.23,-1.65,0>,0.34,1}
}

#declare Horse_rear_leg_right =
union {
object {Horse_rear_leg}
object {Horse_rear_leg_lower texture{T_Horse2} rotate <0,0,Right_rear_lower_angle> translate <0.23,-1.65,0>}
object {Hoof rotate <0,0,Right_rear_hoof_angle> translate <-0.34,-0.9,0> rotate <0,0,Right_rear_lower_angle> translate <0.23,-1.65,0>}
}

#declare Horse_rear_leg_left =
union {
object {Horse_rear_leg scale<1,1,-1>}
object {Horse_rear_leg_lower texture{T_Horse2} scale<1,1,-1> rotate <0,0,Left_rear_lower_angle> translate <0.23,-1.65,0>}
object {Hoof rotate <0,0,Left_rear_hoof_angle> translate <-0.34,-0.9,0> rotate <0,0,Left_rear_lower_angle> translate <0.23,-1.65,0>}
}

#declare Horse_front_leg_lower =
blob{
threshold 0.5
	sphere {<0,0,0>,0.34,1}
	cylinder {<0,0,0><0.07,-0.87,0>,0.2,1}
	sphere {<0.06,-0.89,0>,0.24,1}
	sphere {<0.24,-0.80,0>,0.22,1}
}

#declare Horse_front_leg =
blob {
threshold 0.5
	cylinder {<0,0,0><-0.07,-1.64,0>,0.25,1}
	cylinder {<-0.35,0.17,0><0,-1.4,0>,0.2,1}
	sphere {<0,0,0>,0.75,1}
	sphere {<-0.07,-1.64,0>,0.34,1}
	sphere {<0,0,0>,0.32,1 scale <1,2,1> translate <-0.45,0.27,0>}
}

#declare Horse_front_leg_right =
union {
object {Horse_front_leg}
object {Horse_front_leg_lower texture{T_Horse2} rotate <0,0,Right_front_lower_angle> translate <-0.07,-1.64,0>}
object {Hoof rotate <0,0,Right_front_hoof_angle> translate <0.06,-0.89,0> rotate <0,0,Right_front_lower_angle> translate <-0.07,-1.64,0>}
}

#declare Horse_front_leg_left =
union {
object {Horse_front_leg scale<1,1,-1>}
object {Horse_front_leg_lower texture{T_Horse2} scale<1,1,-1> rotate <0,0,Left_front_lower_angle> translate <-0.07,-1.64,0>}
object {Hoof rotate <0,0,Left_front_hoof_angle> translate <0.06,-0.89,0> rotate <0,0,Left_front_lower_angle> translate <-0.07,-1.64,0>}
}

#declare Horse_ear =
difference {
	sphere {<0,0,0>,0.34 scale <.5,1.2,.5>}
	sphere {<0,0,0>,0.32 scale <.5,1.2,.5>}
	box {<0,10,10><-10,-10,-10>}
}

#declare Head_main =
blob {
threshold 0.5
cylinder {<-0.19,0.35,0><-0.05,0.55,0.1>,0.10 ,1}
cylinder {<-0.10,0.30,0><0.03,0.50,0.1>,0.10 ,1}
cylinder {<-0.02,0.25,0><0.11,0.44,0.1>,0.10 ,1}
cylinder {<0.07,0.20,0><0.20,0.39,0.1>,0.10 ,1}
cylinder {<0.16,0.15,0><0.28,0.33,0.1>,0.10 ,1}

cylinder {<-0.05,0.55,0.1><0.03,0.56,0>,0.10 ,1}
cylinder {<0.03,0.50,0.1><0.14,0.50,0>,0.10 ,1}
cylinder {<0.11,0.44,0.1><0.24,0.45,0>,0.10 ,1}
cylinder {<0.20,0.39,0.1><0.39,0.40,0>,0.10 ,1}
cylinder {<0.28,0.33,0.1><0.49,0.34,0>,0.10 ,1}
}

#declare Horse_head =
union {
blob {
threshold 0.5
	sphere {<0,0,0>,0.6,1}
	sphere {<-0.28,0.23,0>,0.6,1}
	cylinder {<0.08,0.12,0><-0.45,0.41,0>,0.3,1 texture{T_Horse2}}
	cylinder {<-0.40,0.46,0><-1.27,0.07,0>,0.4,1 texture{T_Horse2}}
	sphere {<-0.24,0.29,0>0.44,1 texture{T_Horse2}}
	cylinder {<-0.63,-0.15,0><-1.33,-0.03,0>,0.5,1 texture{T_Horse2}}
	sphere {<-1.50,-0.03,0>,0.48,1 texture{T_Horse4}}
	sphere {<-1.49,-0.27,0>,0.32,1 scale <1,0.8,1.2> texture{T_Horse4}}

	sphere {<-0.56,-0.12,0>,0.62,1 scale <1,1,0.5> translate <0,0,-0.3>}
	sphere {<-0.56,-0.12,0>,0.62,1 scale <1,1,0.5> translate <0,0,0.3>}
	sphere {<-1.56,0.09,-0.2>,0.24,1 texture{T_Horse4}}
	sphere {<0,0,0>,0.15,-0.75 texture{T_Horse4} scale <1,0.75,1> translate <-1.62,0.09,-0.2>}
	sphere {<-1.56,0.09,0.2>,0.24,1 texture{T_Horse4}}
	sphere {<0,0,0>,0.15,-0.75 texture{T_Horse4} scale <1,0.75,1> translate <-1.62,0.09,0.2>}

	sphere {<-0.63,0.31,-0.2>,0.2,1}
	sphere {<-0.63,0.31,0.2>,0.2,1}

}

sphere {<0,0,0>,0.175
texture{pigment{
	wood
	color_map {
		[0.0 rgb <0,0,0>]
		[0.1 rgb <.3,.2,0>]
		[0.4 rgb <.3,.2,.0>]
		[0.5 rgb <0,0,0>]
		[0.55 rgb <1,1,0.8>]
		[1.0 rgb <1,1,0.8>]
	}
	scale .35
	rotate <10,25,0>
}}
finish{phong 1} scale <1,0.8,1> translate <-0.65,0.27,-0.2>}
sphere {<0,0,0>,0.175
texture{pigment{
	wood
	color_map {
		[0.0 rgb <0,0,0>]
		[0.1 rgb <.3,.2,0>]
		[0.4 rgb <.3,.2,.0>]
		[0.5 rgb <0,0,0>]
		[0.55 rgb <1,1,0.8>]
		[1.0 rgb <1,1,0.8>]
	}
	scale .35
	rotate <10,25,0>
}}
finish{phong 1} scale <1,0.8,1> translate <-0.65,0.27,0.2>}


object {Horse_ear translate <-0.42,0.52,-0.2>}
object {Horse_ear translate <-0.42,0.52,0.2>}
object {Head_main texture{T_Horse5}}
object {Head_Harness}
}

#declare Neck_main =
blob {
threshold 0.5
cylinder {<-0.99,1.63,0><-0.86,1.82,0.1>,0.10 ,1}
cylinder {<-0.93,1.55,0><-0.80,1.75,0.1>,0.10 ,1}
cylinder {<-0.87,1.47,0><-0.74,1.67,0.1>,0.10 ,1}
cylinder {<-0.81,1.39,0><-0.68,1.59,0.1>,0.10 ,1}
cylinder {<-0.74,1.32,0><-0.61,1.51,0.1>,0.10 ,1}
cylinder {<-0.68,1.24,0><-0.55,1.43,0.1>,0.10 ,1}
cylinder {<-0.62,1.16,0><-0.49,1.35,0.1>,0.10 ,1}
cylinder {<-0.56,1.08,0><-0.43,1.28,0.1>,0.10 ,1}
cylinder {<-0.50,1.00,0><-0.37,1.20,0.1>,0.10 ,1}
cylinder {<-0.43,0.92,0><-0.30,1.12,0.1>,0.10 ,1}
cylinder {<-0.37,0.84,0><-0.24,1.04,0.1>,0.10 ,1}
cylinder {<-0.31,0.77,0><-0.18,0.96,0.1>,0.10 ,1}
cylinder {<-0.25,0.69,0><-0.12,0.88,0.1>,0.10 ,1}
cylinder {<-0.19,0.61,0><-0.06,0.80,0.1>,0.10 ,1}

cylinder {<-0.86,1.82,0.1><-0.60,1.84,0>,0.10 ,1}
cylinder {<-0.80,1.75,0.1><-0.54,1.76,0>,0.10 ,1}
cylinder {<-0.74,1.67,0.1><-0.47,1.68,0>,0.10 ,1}
cylinder {<-0.68,1.59,0.1><-0.41,1.60,0>,0.10 ,1}
cylinder {<-0.61,1.51,0.1><-0.35,1.52,0>,0.10 ,1}
cylinder {<-0.55,1.43,0.1><-0.29,1.45,0>,0.10 ,1}
cylinder {<-0.49,1.35,0.1><-0.22,1.37,0>,0.10 ,1}
cylinder {<-0.43,1.28,0.1><-0.16,1.29,0>,0.10 ,1}
cylinder {<-0.37,1.20,0.1><-0.10,1.21,0>,0.10 ,1}
cylinder {<-0.30,1.12,0.1><-0.04,1.13,0>,0.10 ,1}
cylinder {<-0.24,1.04,0.1><0.02,1.05,0>,0.10 ,1}
cylinder {<-0.18,0.96,0.1><0.09,0.98,0>,0.10 ,1}
cylinder {<-0.12,0.88,0.1><0.15,0.90,0>,0.10 ,1}
cylinder {<-0.06,0.80,0.1><0.21,0.82,0>,0.10 ,1}

cylinder {<-0.47,1.68,0><-0.35,1.71,0.1>,0.10 ,1}
cylinder {<-0.41,1.60,0><-0.21,1.65,0.1>,0.10 ,1}
cylinder {<-0.35,1.52,0><-0.09,1.59,0.1>,0.10 ,1}
cylinder {<-0.29,1.45,0><-0.02,1.51,0.1>,0.10 ,1}
cylinder {<-0.22,1.37,0><0.04,1.44,0.1>,0.10 ,1}
cylinder {<-0.16,1.29,0><0.10,1.36,0.1>,0.10 ,1}
cylinder {<-0.10,1.21,0><0.16,1.28,0.1>,0.10 ,1}
cylinder {<-0.04,1.13,0><0.22,1.20,0.1>,0.10 ,1}
cylinder {<0.02,1.05,0><0.29,1.12,0.1>,0.10 ,1}
cylinder {<0.09,0.98,0><0.35,1.04,0.1>,0.10 ,1}
cylinder {<0.15,0.90,0><0.41,0.97,0.1>,0.10 ,1}
cylinder {<0.21,0.82,0><0.47,0.89,0.1>,0.10 ,1}

cylinder {<0.04,1.44,0.1><0.25,1.43,0>,0.10 ,1}
cylinder {<0.10,1.36,0.1><0.44,1.36,0>,0.10 ,1}
cylinder {<0.16,1.28,0.1><0.64,1.28,0>,0.10 ,1}
cylinder {<0.22,1.20,0.1><0.77,1.20,0>,0.10 ,1}
cylinder {<0.29,1.12,0.1><0.74,1.12,0>,0.10 ,1}
cylinder {<0.35,1.04,0.1><0.71,1.04,0>,0.10 ,1}
cylinder {<0.41,0.97,0.1><0.67,0.96,0>,0.10 ,1}
cylinder {<0.47,0.89,0.1><0.63,0.89,0>,0.10 ,1}
}

#declare Horse_neck =
union {
blob {
threshold 0.5
	sphere {<0,0,0>,1,1}
	cylinder {<0,0,0><-1.22,1.55,0>,0.8,1}
	cylinder {<-0.79,-0.71,0><-1.23,1.08,0>,0.4,1}
	cylinder {<-0.9,0.8,-0.2><-0.46,-0.47,-0.4>,0.25,1}
	cylinder {<-0.9,0.8,0.2><-0.46,-0.47,0.4>,0.25,1}
	sphere {<-0.6,-0.4,-0.3>,0.8,1}
	sphere {<-0.6,-0.4,0.3>,0.8,1}
}
object {Horse_head rotate <0,0,Head_angle> translate <-1.22,1.55,0>}
object {Neck_main texture{T_Horse5}}
}

#declare Horse_tail =
blob {
threshold 0.5
	cylinder {<0,0,0><0.38,0.25,0>,0.15,1}
	sphere {<0.38,0.23,0>,0.34,1}
	sphere {<0.62,0.15,0>,0.58,1}
	sphere {<1.36,-0.31,0>,0.58,1}
	sphere {<2.01,-0.26,0>,0.58,1}
	cylinder {<0.62,0.15,0><1.18,-0.42,0>,0.47,1}
	cylinder {<0.90,0.14,0><1.99,-0.12,0>,0.47,1}
}

#declare Horse_13 =
union {
	object{Horse_body texture{T_Horse1}}
	object{Horse_rear_leg_right  rotate <0,0,Right_rear_upper_angle> translate <2.6,2.7,-0.5> texture{T_Horse1}}
	object{Horse_rear_leg_left   rotate <0,0,Left_rear_upper_angle> translate <2.6,2.7,0.5> texture{T_Horse1}}
	object{Horse_front_leg_right rotate <0,0,Right_front_upper_angle> translate <-0.52,2.66,-0.5> texture{T_Horse1}}
	object{Horse_front_leg_left  rotate <0,0,Left_front_upper_angle> translate <-0.52,2.66,0.5> texture{T_Horse1}}
	object{Horse_neck rotate <0,0,Neck_angle> translate <0,3.6,0> texture{T_Horse1}}
	object{Horse_tail rotate <0,0,Tail_pivot> translate <2.84,3.59,0> texture{T_Horse5}}
}


