#declare T_Iron =
texture { pigment {
	bozo
	color_map {
		[0.0 rgb <.5,.5,.5>]
		[0.4 rgb <.6,.6,.6>]
		[0.6 rgb <.4,.4,.4>]
		[0.8 rgb <.6,.6,.6>]
		[1.0 rgb <.7,.7,.7>]
	}
	scale .2
}
	finish {phong 1 metallic}
	normal {dents 1 scale .025}
}

#declare T_Spike =
texture { pigment {
	rgb <.75,.75,.75>
}
	finish {phong 1 metallic reflection 0.75}
}

#declare T_Wheel2 =
texture {
  pigment
  {
    wood
    turbulence 0.02
    color_map
    {
      [0.00 color rgb<0.808, 0.671, 0.251>]
      [0.22 color rgb<0.808, 0.667, 0.251>]
      [0.22 color rgb<0.808, 0.667, 0.251>]
      [0.34 color rgb<0.600, 0.345, 0.039>]
      [0.34 color rgb<0.600, 0.345, 0.039>]
      [0.39 color rgb<0.808, 0.671, 0.251>]
      [0.39 color rgb<0.808, 0.671, 0.251>]
      [0.71 color rgb<0.808, 0.671, 0.251>]
      [0.71 color rgb<0.808, 0.671, 0.251>]
      [0.82 color rgb<0.529, 0.294, 0.024>]
      [0.82 color rgb<0.529, 0.294, 0.024>]
      [1.00 color rgb<0.808, 0.671, 0.251>]
    }
    scale <0.05, 0.05, 0.05>
	rotate <90,0,0>
  }
}
texture {
  pigment
  {
    wood
    turbulence 0.01
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.12 color rgbf<0.702, 0.412, 0.118, 0.608>]
      [0.12 color rgbf<0.702, 0.412, 0.118, 0.608>]
      [0.23 color rgbf<0.702, 0.467, 0.118, 0.608>]
      [0.23 color rgbf<0.702, 0.467, 0.118, 0.608>]
      [0.50 color rgbf<1.000, 1.000, 1.000, 0.608>]
      [0.50 color rgbf<1.000, 1.000, 1.000, 0.627>]
      [0.70 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.70 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.83 color rgbf<0.702, 0.467, 0.118, 0.608>]
      [0.83 color rgbf<0.702, 0.467, 0.118, 0.608>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }
    translate <10.0, 0.0, 0.0>
    scale <0.25, 0.25, 0.25>
	rotate <90,0,0>
  }
  finish {phong 1}
}

#declare T_Wheel1 =
texture {
  pigment
  {
    wood
    turbulence 0.02
    color_map
    {
      [0.00 color rgb<0.608, 0.471, 0.051>]
      [0.22 color rgb<0.608, 0.467, 0.051>]
      [0.22 color rgb<0.608, 0.467, 0.051>]
      [0.34 color rgb<0.600, 0.145, 0.0>]
      [0.34 color rgb<0.400, 0.145, 0.0>]
      [0.39 color rgb<0.608, 0.471, 0.051>]
      [0.39 color rgb<0.608, 0.471, 0.051>]
      [0.71 color rgb<0.608, 0.471, 0.051>]
      [0.71 color rgb<0.608, 0.471, 0.051>]
      [0.82 color rgb<0.329, 0.094, 0.0>]
      [0.82 color rgb<0.329, 0.094, 0.0>]
      [1.00 color rgb<0.608, 0.471, 0.051>]
    }
    scale <0.05, 0.05, 0.05>
	rotate <25,0,25>
  }
}
texture {
  pigment
  {
    wood
    turbulence 0.01
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.12 color rgbf<0.702, 0.412, 0.118, 0.608>]
      [0.12 color rgbf<0.702, 0.412, 0.118, 0.608>]
      [0.23 color rgbf<0.702, 0.467, 0.118, 0.608>]
      [0.23 color rgbf<0.702, 0.467, 0.118, 0.608>]
      [0.50 color rgbf<1.000, 1.000, 1.000, 0.608>]
      [0.50 color rgbf<1.000, 1.000, 1.000, 0.627>]
      [0.70 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.70 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.83 color rgbf<0.702, 0.467, 0.118, 0.608>]
      [0.83 color rgbf<0.702, 0.467, 0.118, 0.608>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }
    translate <10.0, 0.0, 0.0>
    scale <0.15, 0.15, 0.15>
	rotate <45,0,0>
  }
  finish {phong 1}
}


#declare Spoke1 =
union {
	cylinder {<-0.32,0,0><-0.55,0,0>,0.1 texture{T_Wheel1}}
	cylinder {<-0.55,0,0><-1.05,0,0>,0.05 }
	cylinder {<-1.05,0,0><-1.28,0,0>,0.1 texture{T_Wheel1}}
}

#declare Spoke2 =
union {
	cylinder {<-0.32,0,0><-0.55,0,0>,0.1 texture{T_Wheel1}}
	cylinder {<-0.55,0,0><-1.05,0,0>,0.05 }
	cylinder {<-0.6,0,0><-0.8,0,0>,0.1 texture{T_Wheel1}}
	cylinder {<-1.05,0,0><-1.28,0,0>,0.1 texture{T_Wheel1}}
}

#declare Angle_spike =
cone {<0,0,0>,0.15,<0,0.5,-0.5>,0.01}

#declare Spikes =
union {
	cone {<0,0,0>,0.15,<0,0,-0.75>,0.01}
	#declare Count = 0
	#while (Count < 5)
		object {Angle_spike rotate <0,0,((350 / 5) * Count)>}
		#declare Count = (Count + 1)
	#end
	sphere {<0,0,0>,0.3 texture{T_Wheel1}}
}

#declare Wheel_base =
union {
difference {
	cylinder {<0,0,0.15><0,0,-0.15>,1.3 texture{T_Iron}}
	cylinder {<0,0,1><0,0,-1>,1.28 texture{T_Iron}}
}
difference {
	cylinder {<0,0,0.13><0,0,-0.13>,1.28}
	cylinder {<0,0,1><0,0,-1>,1.18}
}
cylinder {<0,0,0.13><0,0,-0.13>,0.42}
difference {
	cylinder {<0,0,0.15><0,0,-0.15>,0.32 texture{T_Iron}}
	cylinder {<0,0,1><0,0,-1>,0.3 texture{T_Iron}}
}
cylinder {<0,0,0.15><0,0,-0.15>,0.3}
}

#declare Wheel1 =
union {
	object {Wheel_base texture{T_Wheel2}}
	#declare Count = 0
	#while (Count < 13)
		object {Spoke1 rotate <0,0,((360 / 13) * Count)> texture{T_Wheel2}}
		#declare Count = (Count + 1)
	#end
	object {Spikes texture{T_Spike}}
}

#declare Wheel2 =
union {
	object {Wheel_base texture{T_Wheel2}}
	#declare Count = 0
	#while (Count < 13)
		object {Spoke2 rotate <0,0,((360 / 13) * Count)> texture{T_Wheel2}}
		#declare Count = (Count + 1)
	#end
	text { ttf "trihy.ttf", "13", 1, 0 pigment{color <0.75,0.67,0.39>} finish {phong 1} scale .5 translate<-0.25,-0.2,-0.16> finish{ambient .3}}
}
