#include "T_Block.inc"

#declare Mortar = pigment{color <1.00,0.89,0.73>}

#declare Top_tile = box {<0.1,0,1><0.9,0.5,-0.15> pigment{color <0.93,0.80,0.50>}}

#declare Icosahedron = 
 intersection 
  {plane {-z, 1 rotate <52.6625,    0, 0>}
   plane {-z, 1 rotate <52.6625,  -72, 0>}
   plane {-z, 1 rotate <52.6625, -144, 0>}
   plane {-z, 1 rotate <52.6625, -216, 0>}
   plane {-z, 1 rotate <52.6625, -288, 0>}
   
   plane {-z, 1 rotate <10.8125,    0, 0>}
   plane {-z, 1 rotate <10.8125,  -72, 0>}
   plane {-z, 1 rotate <10.8125, -144, 0>}
   plane {-z, 1 rotate <10.8125, -216, 0>}
   plane {-z, 1 rotate <10.8125, -288, 0>}
   
   plane {-z, 1 rotate <-52.6625,  -36, 0>}
   plane {-z, 1 rotate <-52.6625, -108, 0>}
   plane {-z, 1 rotate <-52.6625, -180, 0>}
   plane {-z, 1 rotate <-52.6625, -252, 0>}
   plane {-z, 1 rotate <-52.6625, -324, 0>}
   
   plane {-z, 1 rotate <-10.8125,  -36, 0>}
   plane {-z, 1 rotate <-10.8125, -108, 0>}
   plane {-z, 1 rotate <-10.8125, -180, 0>}
   plane {-z, 1 rotate <-10.8125, -252, 0>}
   plane {-z, 1 rotate <-10.8125, -324, 0>}
  }

#declare Proto_block1 =
union {
	box {<0,0,0><1,1,1> pigment{Mortar}}
	box {<0.05,0.05,-0.1><.95,.95,0>}
}

#declare Proto_block2 =
union {
	box {<0,0,0><2,1,1> pigment{Mortar}}
	box {<0.05,0.05,-0.1><1.95,.95,0>}
}

#declare Proto_block3 =
union {
	box {<0,0,0><1,2,1> pigment{Mortar}}
	box {<0.05,0.05,-0.1><.95,1.95,0>}
}

#declare M_Tile = box {<0.025,0.025,-0.1><0.175,0.175,0>}
#declare G1 = pigment{color <0.00,0.54,0.92>}
#declare G2 = pigment{color <0.38,0.22,0.92>}
#declare M1 = pigment{color <0.89,0.91,0.86>}
#declare M2 = pigment{color <0.89,1.00,0.86>}

#declare Block13 =
union {
	box {<0,0,0><1,1,1> pigment{Mortar}}
	object {M_Tile pigment{G1} finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.2,0,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.4,0,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.6,0,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.8,0,0>finish {phong 0.5}}

	object {M_Tile pigment{M1} translate <0,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.2,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.4,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.6,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.8,0.2,0>finish {phong 0.5}}

	object {M_Tile pigment{M1} translate <0,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.2,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.4,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.6,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.8,0.4,0>finish {phong 0.5}}

	object {M_Tile pigment{M1} translate <0,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.2,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.4,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.6,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.8,0.6,0>finish {phong 0.5}}

	object {M_Tile pigment{G2} translate <0,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.2,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.4,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.6,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.8,0.8,0>finish {phong 0.5}}
}

#declare Block14 =
union {
	box {<0,0,0><1,1,1> texture{T_Block1}}
	object {M_Tile pigment{M2} finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.2,0,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.4,0,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.6,0,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.8,0,0>finish {phong 0.5}}

	object {M_Tile pigment{M1} translate <0,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.2,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.4,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.6,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.8,0.2,0>finish {phong 0.5}}

	object {M_Tile pigment{G1} translate <0,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.2,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.4,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.6,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.8,0.4,0>finish {phong 0.5}}

	object {M_Tile pigment{M1} translate <0,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.2,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.4,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.6,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.8,0.6,0>finish {phong 0.5}}

	object {M_Tile pigment{M2} translate <0,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.2,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.4,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.6,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.8,0.8,0>finish {phong 0.5}}
}

#declare Block15 =
union {
	box {<0,0,0><1,1,1> texture{T_Block2}}
	object {M_Tile pigment{G2} finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.2,0,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.4,0,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.6,0,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.8,0,0>finish {phong 0.5}}

	object {M_Tile pigment{G1} translate <0,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.2,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.4,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.6,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.8,0.2,0>finish {phong 0.5}}

	object {M_Tile pigment{G1} translate <0,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.2,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.4,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.6,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.8,0.4,0>finish {phong 0.5}}

	object {M_Tile pigment{G1} translate <0,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.2,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.4,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.6,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.8,0.6,0>finish {phong 0.5}}

	object {M_Tile pigment{G2} translate <0,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.2,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.4,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.6,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.8,0.8,0>finish {phong 0.5}}
}

#declare Block16 =
union {
	box {<0,0,0><1,1,1> texture{T_Block4}}
	object {M_Tile pigment{M2} finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.2,0,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.4,0,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.6,0,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.8,0,0>finish {phong 0.5}}

	object {M_Tile pigment{M1} translate <0,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.2,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.4,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.6,0.2,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.8,0.2,0>finish {phong 0.5}}

	object {M_Tile pigment{M1} translate <0,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.2,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.4,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{G1} translate <0.6,0.4,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.8,0.4,0>finish {phong 0.5}}

	object {M_Tile pigment{M1} translate <0,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.2,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.4,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{G2} translate <0.6,0.6,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.8,0.6,0>finish {phong 0.5}}

	object {M_Tile pigment{M2} translate <0,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.2,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{M2} translate <0.4,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.6,0.8,0>finish {phong 0.5}}
	object {M_Tile pigment{M1} translate <0.8,0.8,0>finish {phong 0.5}}
}

#declare Wall_rand = seed(13)

#declare Wall =
union {

#declare Count = 0
#while (Count < 40)
	#declare Btype = (rand(Wall_rand) * 4)
	#if (Btype < 1)
		object {Proto_block3 translate <(-20 + Count),0,0> texture{T_Block1}}
		#else
		#if (Btype < 2)
			object {Proto_block3 translate <(-20 + Count),0,0> texture{T_Block2}}
			#else
			#if (Btype < 3)
				object {Proto_block3 translate <(-20 + Count),0,0> texture{T_Block3}}
				#else
				object {Proto_block3 translate <(-20 + Count),0,0> texture{T_Block4}}
			#end
		#end
	#end
	#declare Count = (Count + 1)
#end

#declare Count = 0
#while (Count < 40)
	#declare Btype = (rand(Wall_rand) * 4)
	#if (Btype < 1)
		object {Proto_block3 translate <(-20 + Count),8,0> texture{T_Block1}}
		#else
		#if (Btype < 2)
			object {Proto_block3 translate <(-20 + Count),8,0> texture{T_Block2}}
			#else
			#if (Btype < 3)
				object {Proto_block3 translate <(-20 + Count),8,0> texture{T_Block3}}
				#else
				object {Proto_block3 translate <(-20 + Count),8,0> texture{T_Block4}}
			#end
		#end
	#end
	object {Top_tile translate <(-20 + Count),10,0>}
	#declare Count = (Count + 1)
#end

#declare Count = 0
#while (Count < 40)
	#declare Btype = (rand(Wall_rand) * 4)
	#if (Btype < 1)
		object {Proto_block2 translate <(-20 + (Count * 2)),2,0> texture{T_Block1}}
		#else
		#if (Btype < 2)
			object {Proto_block2 translate <(-20 + (Count * 2)),2,0> texture{T_Block2}}
			#else
			#if (Btype < 3)
				object {Proto_block2 translate <(-20 + (Count * 2)),2,0> texture{T_Block3}}
				#else
				object {Proto_block2 translate <(-20 + (Count * 2)),2,0> texture{T_Block4}}
			#end
		#end
	#end
	#declare Count = (Count + 1)
#end

#declare Count = 0
#while (Count < 40)
	#declare Btype = (rand(Wall_rand) * 4)
	#if (Btype < 1)
		object {Proto_block2 translate <(-21 + (Count * 2)),3,0> texture{T_Block1}}
		#else
		#if (Btype < 2)
			object {Proto_block2 translate <(-21 + (Count * 2)),3,0> texture{T_Block2}}
			#else
			#if (Btype < 3)
				object {Proto_block2 translate <(-21 + (Count * 2)),3,0> texture{T_Block3}}
				#else
				object {Proto_block2 translate <(-21 + (Count * 2)),3,0> texture{T_Block4}}
			#end
		#end
	#end
	#declare Count = (Count + 1)
#end

#declare Count = 0
#while (Count < 40)
	#declare Btype = (rand(Wall_rand) * 4)
	#if (Btype < 1)
		object {Proto_block1 translate <(-20 + Count),4,0> texture{T_Block1}}
		#else
		#if (Btype < 2)
			object {Proto_block1 translate <(-20 + Count),4,0> texture{T_Block2}}
			#else
			#if (Btype < 3)
				object {Proto_block1 translate <(-20 + Count),4,0> texture{T_Block3}}
				#else
				object {Proto_block1 translate <(-20 + Count),4,0> texture{T_Block4}}
			#end
		#end
	#end
	#declare Count = (Count + 1)
#end

#declare Count = 0
#while (Count < 40)
	#declare Btype = (rand(Wall_rand) * 4)
	#if (Btype < 1)
		object {Proto_block2 translate <(-20 + (Count * 2)),5,0> texture{T_Block1}}
		#else
		#if (Btype < 2)
			object {Proto_block2 translate <(-20 + (Count * 2)),5,0> texture{T_Block2}}
			#else
			#if (Btype < 3)
				object {Proto_block2 translate <(-20 + (Count * 2)),5,0> texture{T_Block3}}
				#else
				object {Proto_block2 translate <(-20 + (Count * 2)),5,0> texture{T_Block4}}
			#end
		#end
	#end
	#declare Count = (Count + 1)
#end

#declare Count = 0
#while (Count < 40)
	#declare Btype = (rand(Wall_rand) * 4)
	#if (Btype < 1)
		object {Proto_block2 translate <(-21 + (Count * 2)),6,0> texture{T_Block1}}
		#else
		#if (Btype < 2)
			object {Proto_block2 translate <(-21 + (Count * 2)),6,0> texture{T_Block2}}
			#else
			#if (Btype < 3)
				object {Proto_block2 translate <(-21 + (Count * 2)),6,0> texture{T_Block3}}
				#else
				object {Proto_block2 translate <(-21 + (Count * 2)),6,0> texture{T_Block4}}
			#end
		#end
	#end
	#declare Count = (Count + 1)
#end

#declare Count = 0
#while (Count < 40)
	#declare Btype = (rand(Wall_rand) * 4)
	#if (Btype < 1)
		object {Block13 translate <(-20 + Count),7,0>}
		#else
		#if (Btype < 2)
			object {Block14 translate <(-20 + Count),7,0>}
			#else
			#if (Btype < 3)
				object {Block15 translate <(-20 + Count),7,0>}
				#else
				object {Block16 translate <(-20 + Count),7,0>}
			#end
		#end
	#end
	#declare Count = (Count + 1)
#end

#if (Wall_high = on)
#declare column_flute_alt = on
#include "13_col2.inc"

#declare Column1 =
union {
	object {column_composite scale 4}
	sphere {<0,13,0>,1}
}

#declare Column2 =
union {
	object {column_composite scale 4}
	object {Icosahedron translate <0,13,0>}
}

object {Column1 texture{T_Block1} finish {phong 0.5}}
object {Column2 translate <5,0,0> texture{T_Block1} finish {phong 0.5}}
object {Column1 translate <10,0,0> texture{T_Block1} finish {phong 0.5}}
object {Column2 translate <15,0,0> texture{T_Block1} finish {phong 0.5}}
object {Column2 translate <-5,0,0> texture{T_Block1} finish {phong 0.5}}
object {Column1 translate <-10,0,0> texture{T_Block1} finish {phong 0.5}}
object {Column2 translate <-15,0,0> texture{T_Block1} finish {phong 0.5}}

box {<-30,10.5,2><30,10.75,-0.2> texture{T_Block1}}
box {<-30,10.75,2><30,11,-0.25> texture{T_Block4}}
#end
}
