/*
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

camera {
	location <0,1,0>
	look_at  <0,0.5,0>
}

light_source {<0,2,0> color White}
background {rgb <1,1,1>}
*/

#declare Helmet =
union {
difference {
	sphere {<0,-0.01,0>,0.03 scale <1,1.5,1> pigment{color <1.00,0.83,0.43>}finish{phong 1 reflection 0.5 metallic}}
	box {<1,-0.025,1><-1,-1,-1> pigment{color <1.00,0.83,0.43>}finish{phong 1 reflection 0.5 metallic}}
	cylinder {<0,-0.01,-1><0,-0.01,0>,0.02 pigment{color <1.00,0.83,0.43>}finish{phong 1 reflection 0.5 metallic}}
}
#difference {
	sphere {<0,0.01,0>,0.035 scale <1,1.24,1> pigment{color <1.00,0.83,0.43>}finish{phong 1 reflection 0.5 metallic}}
	box {<1,-0.01,1><-1,-1,-1> pigment{color <1.00,0.83,0.43>}finish{phong 1 reflection 0.5 metallic}}
	cylinder {<0,0,-1><0,0,0>,0.02 pigment{color <1.00,0.83,0.43>}finish{phong 1 reflection 0.5 metallic}}
}
difference {
	cylinder {<-0.008,0.01,0><0.008,0.01,0>,0.04 scale <1,1.24,1> pigment{color <1.00,0.83,0.43>}finish{phong 1 reflection 0.5 metallic}}
	box {<-1,0,1><1,-1,-1> rotate <45,0,0> translate <0,0.01,0> pigment{color <1.00,0.83,0.43>}finish{phong 1 reflection 0.5 metallic}}
}
difference {
	cylinder {<-0.005,0.01,0><0.005,0.01,0>,0.06 scale <1,1.24,1> pigment{Red}finish{phong 1}}
	box {<-1,0,1><1,-1,-1> rotate <47,0,0> translate <0,0.01,0> pigment{Red}finish{phong 1}}
	box {<-1,0,1><1,-1,-1> translate <0,0.01,0> pigment{Red}finish{phong 1}}
}
}

#declare Gladiator =
union {

#include "Flesh.inc"
object {Fleshs pigment{Flesh}}

object {Helmet rotate <0,30,0> translate <0.02,0.64,-0.023>}

#include "Clothing.inc"
object {Clothing pigment{Red}finish{crand .1}}

#include "Armor.inc"
object {Armor pigment{color <1.00,0.83,0.43>}finish{phong 1 reflection 0.5 metallic}}

#include "Skirt.inc"
object{Skirt pigment{Red} scale .15 translate <0,0.4,0> finish{crand .1}}

#include "Cloak2.inc"
object {Cloak pigment{Red} finish{crand .1}}

#include "Whip.inc"
object {Whip translate <0.2,0.5,-0.17>}
}

//object {Gladiator}
