// ---------------------------------------------------------- //
// --  POV Ray -- the ART of 3D painting                   -- //
// ---------------------------------------------------------- //
// --  Submission to the Internet Ray Tracing competition  -- //
// --  for September/October 1997 - Art and Entertainment  -- //
// --  by Dominique Jacquel                                -- //
// --  Email me at D.Jacquel@ed.ac.uk                      -- //
// --  Visit http://www.mech.ed.ac.uk/~dom/                -- //
// ---------------------------------------------------------- //

// This is the main file that includes all objects into the scene
// and affect individual textures to them.

// include the standard colors and textures
// ----------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "woods.inc"
#include "glass.inc"
#include "finish.inc"

// include all the objects generated with sPatch
// ---------------------------------------------

// put a switch for each object: comment to activate an object
// -----------------------------------------------------------
#declare air_brush_off = 1
#declare brushes_off = 1
#declare brush_pot_off = 1
//#declare paint_tube_off = 1
#declare metal_cans_off = 1
#declare paper_sheet_off = 1
#declare falcon_off = 1
#declare polaroid_shots_off = 1
#declare paper_clips_off = 1
#declare wooden_flooring_off = 1

// these create the air brush
// --------------------------
#ifndef (air_brush_off)
  #include "air_brush_container.inc"
  #include "air_brush_cap.inc"
  #include "air_brush_cap_pipes.inc"
  #include "air_brush_handle.inc"
  #include "air_brush_metal_bits.inc"
  #include "air_brush_paint.inc"
  #include "air_brush_trigger.inc"
  #include "air_brush_tube.inc"
  #include "co2_bottle.inc"
#end

// these create the paint brushes
// ------------------------------
#ifndef (brushes_off)
  #include "brush_one_metal.inc"
  #include "brush_one_tip.inc"
  #include "brush_one_wood.inc"
  #include "brush_two_metal.inc"
  #include "brush_two_tip.inc"
  #include "brush_two_wood.inc"
  #include "brush_three_metal.inc"
  #include "brush_three_tip.inc"
  #include "brush_three_wood.inc"
  #include "pen_body.inc"
  #include "pen_tip.inc"
  #include "pen_ink_full.inc"
  #include "pen_ink_empty.inc"
#end

// these create the small cans
// ---------------------------
#ifndef (metal_cans_off)
  #include "open_can_body.inc"
  #include "open_can_cap.inc"
  #include "closed_can_body.inc"
  #include "closed_can_cap.inc"
#end

// these create the paint tube
// ---------------------------
#ifndef (paint_tube_off)
  #include "paint_tube_body.inc"
  #include "paint_tube_tip.inc"
  #include "paint_tube_cap.inc"
  #include "paint_worm.inc"
#end

// finally the other objects
// -------------------------
#ifndef (paper_sheet_off)
  #include "paper_sheet.inc"
#end
#ifndef (brush_pot_off)
  #include "brush_pot.inc"
#end
#ifndef (falcon_off)
  #include "falcon_wires.inc"
  #include "falcon_poly.inc"
#end
#ifndef (paper_clips_off)
  #include "paper_clips.inc"
#end

// declaring all the textures
// --------------------------
#declare default_texture = texture {
	pigment { rgb < 0.4196, 0.7882, 0.4275 > }
	finish { phong 0.9 }
}

#declare air_brush_container_glass = texture { T_Glass4 }
#declare air_brush_cap_metal = texture { T_Chrome_2D }
#declare air_brush_cap_pipes_metal = texture { T_Silver_3B }
#declare air_brush_handle_plastic = texture { pigment { color rgb <0.2, 0.2, 0.35> } finish { Phong_Glossy } }
#declare air_brush_metal_bits_metal = texture { T_Chrome_2D }
#declare air_brush_trigger_metal = texture { T_Chrome_2D }
#declare air_brush_tube_plastic = texture { pigment { color rgb <0.1, 0.1, 0.1> } finish { Dull } }
#declare air_brush_paint_color = texture { pigment { color rgbf <0.8, 0.9, 0.3, 0.4> } finish { ambient 0.8 diffuse 0.8 } }
#declare co2_bottle_metal = texture { T_Copper_1C pigment { color rgb <0.5,0.7,1>} }
#declare brush_metal = texture { T_Chrome_2D }
#declare brush_tip = texture { pigment { color rgb <0.55, 0.38, 0.21> } finish { Dull }}
#declare brush_wood = texture { T_Wood14 }
#declare pen_body_plastic = texture { T_Glass3 }
#declare pen_tip_metal = texture { T_Chrome_1D }
#declare pen_ink_empty_plastic = texture { pigment { color rgbf <0.95, 0.95, 0.95, 0.50> } finish { Phong_Glossy } }
#declare pen_ink_full_plastic = texture { pigment { color rgb <0, 0, 0.3> } finish { Phong_Glossy } }
#declare open_can_body_metal = texture { T_Silver_3B }
#declare open_can_cap_metal = texture { T_Brass_1B }
#declare closed_can_body_metal = texture { T_Silver_3B }
#declare closed_can_cap_metal = texture { T_Copper_4C }
#declare paint_tube_body_metal =
  texture { pigment { color rgb <1.0, 0, 0> } finish { Phong_Glossy metallic } }
  texture { pigment { image_map { gif "pov-ray.gif" filter 164, 1 map_type 0 once }} rotate <90,180,0> scale <1,1,0.5> translate <0.4,0,0.7> finish { Phong_Glossy metallic } }
  texture { pigment { image_map { gif "pigment.gif" filter 130, 1 map_type 0 once }} rotate <90,180,0> scale <0.9,1,0.25> translate <0.35,0,0.9> finish { Phong_Glossy metallic } }
  texture { pigment { image_map { gif "bar_code.gif" map_type 0 once }} rotate <90,180,0> scale <0.6,1,0.3> translate <0.2,0,1.25> finish { Phong_Glossy metallic } }
#declare paint_tube_tip_metal = texture { T_Chrome_3C }
#declare paint_tube_cap_plastic = texture { pigment { color rgb <0.1, 0.1, 0.1> } finish { Glossy ambient 0.7 diffuse 0.7 } }
#declare paint_worm_whatever = texture { pigment { radial frequency 25 rotate y*90 } finish { Glossy } normal { bumps 1 scale 0.1} }
#declare brush_pot_glass = texture { T_Glass3 }
#declare paper_sheet_content = texture { pigment { image_map { tga "paper_sheet_map.tga" } rotate <90,-70,0> scale <1.6, 1, 1.2> translate <-2.95, 0, -2.55>} finish { ambient 0.7 diffuse 0.5 } }
#declare polaroid_1_content = texture { pigment { image_map { gif "polaroid_1.gif" } rotate <90,-90,0> translate <0.5,0,0.5>} finish { Phong_Glossy ambient 0.5 diffuse 0.5 } scale 1.6}
#declare polaroid_2_content = texture { pigment { image_map { gif "polaroid_2.gif" } rotate <90,-90,0> translate <0.5,0,0.5>} finish { Phong_Glossy ambient 0.5 diffuse 0.5 } scale 1.6}
#declare paper_clips_metal = texture { T_Chrome_2E }
#declare wooden_floor = texture { T_Wood7 finish { reflection 0.5 } normal { dents 0.5 scale <0.01, 0.1, 0.1>} scale 2 rotate y*85 translate z*0.2 }

// textures generated with phillipe mazan's editor
// -----------------------------------------------
#declare wall_texture =
texture {
    pigment {
        granite
        color_map {
            [ 0.000 rgb <0.95,0.95,0.95> ]
            [ 0.363 rgb <0.85,0.85,0.85> ]
            [ 0.630 rgb <0.90,0.85,0.90> ]
            [ 1.000 rgb <0.95,0.95,0.95> ]
        }
    }
    normal {
        granite
        scale 10
    }
    finish {
        //ambient 0.5
        //diffuse 0.560
        ambient 0
        diffuse 0
        crand 0.0600
    }
}

#declare falcon_poly_paint =
texture {
    pigment {
        gradient x*0 + y*0 + z*1
        color_map {
            [ 0.000 rgbf <1.000,1.000,1.000,0.8> ]
            [ 0.157 rgbf <1.000,1.000,1.000,0.8> ]
            [ 0.234 rgbf <0.737,0.737,0.737,0.10> ]
            [ 0.329 rgb <0.592,0.592,0.671> ]
            [ 0.418 rgb <0.620,0.624,0.671> ]
            [ 0.451 rgbf <0.737,0.737,0.737,0.10> ]
            [ 0.623 rgbf <1.000,1.000,1.000,0.8> ]
            [ 1.000 rgbf <1.000,1.000,1.000,0.8> ]
        }
        turbulence 0.25
    }
    finish {
        reflection <0.050, 0.050, 0.050 >
        brilliance 0.400
        crand 0.0500
        phong 0.090
        phong_size 9.000
    }
}

// setting camera and lightning first
// ----------------------------------
background { color rgb <0, 0, 0> }

camera {
	//location <2.18, 5.12, -7.77>
    //location <5.5 ,3 ,-5 >
    location <3, 9, 0>
	//look_at <-1.86, 1.03, 0.32>
    //look_at <-1.86, 1.03, 0>
    look_at <-1.9, 0, 0.75>
    angle 40
    //angle 70
}

light_source {
  <0, 10, 0>
  color rgb <1,1,1>

// only turn the area light on for final rendering
// -----------------------------------------------
//  area_light x*0.5, z*0.5, 4, 4
//  adaptive 1
//  jitter

  spotlight
  point_at <-2, 0, 0.75>
  radius 20
  falloff 23
}

// putting all these objects into the scene
// ----------------------------------------

// the scene level union
// ----------------------
union {

// the air brush
// -------------
#ifndef (air_brush_off)
union {
  object {
    air_brush_container
    texture { air_brush_container_glass }
  }
  object {
    air_brush_cap
    texture { air_brush_cap_metal }
  }
  object {
    air_brush_cap_pipes
    texture { air_brush_cap_pipes_metal }
  }
  object {
    air_brush_handle
    texture { air_brush_handle_plastic }
  }
  object {
    air_brush_metal_bits
    texture { air_brush_metal_bits_metal }
  }
  object {
    air_brush_paint
    texture { air_brush_paint_color }
  }
  object {
    air_brush_trigger
    texture { air_brush_trigger_metal }
  }
  object {
    air_brush_tube
    texture { air_brush_tube_plastic }
  }
  object {
    co2_bottle
    texture { co2_bottle_metal }
  }
  // add transforms for AIR_BRUSH here
}
#end

// the paint tube
// --------------
#ifndef (paint_tube_off)
union {
  object {
    paint_tube_body
    texture { paint_tube_body_metal  rotate <0,-5,0> }
  }
  object {
    paint_tube_tip
    texture { paint_tube_tip_metal }
  }
  object {
    paint_tube_cap
    texture { paint_tube_cap_plastic }
  }
  object {
    paint_worm
    texture { paint_worm_whatever }
  }
  // add tranforms for PAINT_TUBE here
}
#end

// the brushes
// -----------
#ifndef (brushes_off)
union {
union {
  object {
    brush_one_tip
    texture { brush_tip }
  }
  object {
    brush_one_metal
    texture { brush_metal }
  }
  object {
    brush_one_wood
    texture { brush_wood }
  }
  // add transforms for BRUSH_ONE here
}
union {
  object {
    brush_two_tip
    texture { brush_tip }
  }
  object {
    brush_two_metal
    texture { brush_metal }
  }
  object {
    brush_two_wood
    texture { brush_wood scale 2 }
  }
  // add transforms for BRUSH_TWO here
}
union {
  object {
    brush_three_tip
    texture { brush_tip }
  }
  object {
    brush_three_metal
    texture { brush_metal }
  }
  object {
    brush_three_wood
    texture { brush_wood scale 4 }
  }
  // add transforms for BRUSH_THREE here
}
union {
  object {
    pen_tip
    texture { pen_tip_metal }
  }
  object {
    pen_body
    texture { pen_body_plastic }
  }
  object {
    pen_ink_full
    texture { pen_ink_full_plastic }
  }
  object {
    pen_ink_empty
    texture { pen_ink_empty_plastic }
  }
  // add transforms for BRUSH_TWO here
}
// add tranforms for ALL_BRUSHES here
}
#end

// the metal cans
// --------------
#ifndef (metal_cans_off)
union {
union {
  object {
    open_can_body
    texture { open_can_body_metal }
  }
  object {
    open_can_cap
    texture { open_can_cap_metal }
  }
  // add transforms for OPENED_CAN here
}
union {
  object {
    closed_can_body
    texture { closed_can_body_metal }
  }
  object {
    closed_can_cap
    texture { closed_can_cap_metal }
  }
  // add transforms for CLOSED_CAN here
}
// add tranforms for ALL_CANS here
}
#end

// the brush pot
// -------------
#ifndef (brush_pot_off)
object {
  brush_pot
  texture { brush_pot_glass }
  // add transforms for BRUSH_POT here
}
#end

// the paper sheet
// ---------------
#ifndef (paper_sheet_off)
object {
  paper_sheet
  texture { paper_sheet_content }
  // add transforms for PAPER_SHEET here
}
#end

// add the millenium falcon model
// ------------------------------
#ifndef (falcon_off)
union {
  object {
    falcon_wires
    scale 0.3
    rotate <90, 0, 180>
    // add transforms for FALCON_WIRES here
  }
  object {
    falcon_poly
    scale 0.3
    rotate <90, 0, 180>
    texture { falcon_poly_paint scale 3 rotate y*40 translate -0.5}
    // add transforms for FALCON_WIRES here
  }
  // add transform for the FALCON here
  translate <-3.5, 0.5, 0.5>
}
#end

// add the polaroid shots
// ----------------------
#ifndef (polaroid_shots_off)
// the bottom photo
union {
superellipsoid
{
  <0.05, 0.05>
  scale <0.5,0.025,0.5>  // set the proportion right
  scale 1.5              // set the size
  texture { polaroid_2_content } // place the bitmap
  rotate y*-25
  translate <0,-0.34,3>
}
// the top photo
superellipsoid
{
  <0.05, 0.05>
  scale <0.5,0.025,0.5>  // set the proportion right
  scale 1.5              // set the size
  texture { polaroid_1_content } // place the bitmap
  rotate y*0
  translate <0.1,-0.28,3.1>
}
// add transfroms to POLAROID_SHOTS here
translate <-0.75,0,0>
}
#end

// add the paper clips
// -------------------
#ifndef (paper_clips_off)
object {
  paper_clips
  texture { paper_clips_metal }
}
#end

// the wooden flooring
// -------------------
#ifndef (wooden_flooring_off)
plane { y, -0.35 texture { wooden_floor scale <0.5,0.5,1> rotate x*20 }}
#end

// add GLOBAL tranforms here
}
