//Scene file for POVRAY ver. 3.02
//Uses Chris Colefax's bend utilty as of June 1997
//Based on HRGiger's work for the movie 'Alien'

#include "colors.inc"

#declare backcolor = 
        texture {
        pigment { color 0.4*Wheat}
        finish {
        ambient 0.25
        phong.7
        phong_size 20
        }
        normal {
        dents 0.5
        }
        }

camera {
       location <5, 7, -25>
       look_at <0, 4, 0>
       }

light_source { <10, 30, -20> color rgb <1, 0.99, 0.97> 
        spotlight
        radius 40
        falloff 100
        tightness 5
        point_at <-5, 6, -1>
        }

background {color 0.25*Wheat}

#declare platform = union {
cylinder {<0, -5, 0>, <0, -.1, 0>, 16  //base platform
          pigment {color 0.2*Wheat} }

cylinder {<0, 0, 0>, <0, 2, 0>, 5  //small platform
}

torus {4.5, .4 //rim around small platform
      translate 2*y }

//nine circles from center out

torus {7, .25  }

             torus {9.25, .4 }
             torus {9.75 .4 }
             torus {10.25, .4}



torus {11, .4  }

torus {14, .4  }


      torus {15.25, .4 }
      torus {15.75, .4 }
      torus {16, .4 }

cylinder {<-16, 0, -1>, <16, 0, -1>, .3}

cylinder {<-16, 0, 1>, <16, 0, 1>, .3 }

      texture {backcolor}
      }


#declare tube = cylinder {<-16, 0, 0>, <16, 0, 0>, .8 //tube
         
         }

#declare ring = torus {.8, .1
      rotate 90*z
      translate -16*x
      }

#declare pipe = union { //puts rings on pipe
         object{tube}
         object {ring}
         object {ring translate .25*x}
         object {ring translate .5*x}
         object {ring translate .75*x}
         object {ring translate 1*x}
         object {ring translate 1.25*x}
         object {ring translate 1.5*x}
         object {ring translate 1.75*x}
         object {ring translate 2*x}
         object {ring translate 2.25*x}
         object {ring translate 2.5*x}
         object {ring translate 2.75*x}
         object {ring translate 3*x}
         object {ring translate 3.25*x}
         object {ring translate 3.5*x}
         object {ring translate 3.75*x}
         object {ring translate 4*x}
         object {ring translate 4.25*x}
         object {ring translate 4.5*x}
         object {ring translate 4.75*x}
         object {ring translate 5*x}
         object {ring translate 5.25*x}
         object {ring translate 5.5*x}
         object {ring translate 5.75*x}
         object {ring translate 6*x}
         object {ring translate 6.25*x}
         object {ring translate 6.5*x}
         object {ring translate 6.75*x}
         object {ring translate 7*x}
         object {ring translate 7.25*x}
         object {ring translate 7.5*x}
         object {ring translate 7.75*x}
         object {ring translate 8*x}
         object {ring translate 8.25*x}
         object {ring translate 8.5*x}
         object {ring translate 8.75*x}
         object {ring translate 9*x}
         object {ring translate 9.25*x}
         object {ring translate 9.5*x}
         object {ring translate 9.75*x}
         object {ring translate 10*x}
         object {ring translate 10.25*x}
         object {ring translate 10.5*x}
         object {ring translate 10.75*x}
         object {ring translate 11*x}
         object {ring translate 11.25*x}
         object {ring translate 11.5*x}
         object {ring translate 11.75*x}
         object {ring translate 20.5*x}
         object {ring translate 20.75*x}
         object {ring translate 21*x}
         object {ring translate 21.25*x}
         object {ring translate 21.5*x}
         object {ring translate 21.75*x}
         object {ring translate 22*x}
         object {ring translate 22.25*x}
         object {ring translate 22.5*x}
         object {ring translate 22.75*x}
         object {ring translate 23*x}
         object {ring translate 23.25*x}
         object {ring translate 23.5*x}
         object {ring translate 23.75*x}
         object {ring translate 24*x}
         object {ring translate 24.25*x}
         object {ring translate 24.5*x}
         object {ring translate 24.75*x}
         object {ring translate 25*x}
         object {ring translate 25.25*x}
         object {ring translate 25.5*x}
         object {ring translate 25.75*x}
         object {ring translate 26*x}
         object {ring translate 26.25*x}
         object {ring translate 26.5*x}
         object {ring translate 25.75*x}
         object {ring translate 27*x}
         object {ring translate 27.25*x}
         object {ring translate 27.5*x}
         object {ring translate 27.75*x}
         object {ring translate 28*x}
         object {ring translate 28.25*x}
         object {ring translate 28.5*x}
         object {ring translate 28.75*x}
         object {ring translate 29*x}
         object {ring translate 29.25*x}
         object {ring translate 29.5*x}
         object {ring translate 29.75*x}
         object {ring translate 30*x}
         object {ring translate 30.25*x}
         object {ring translate 30.5*x}
         object {ring translate 30.75*x}
         object {ring translate 31*x}
         object {ring translate 31.25*x}
         object {ring translate 31.5*x}
         object {ring translate 31.75*x}
         object {ring translate 32*x}
         
         }

difference {
           object {platform}
           object {pipe}
           texture {backcolor}
           }

#declare raised = union {
object {pipe rotate -10*z translate 2.1*y
       clipped_by { plane {<-1, 0, 0>, -4 } }  }
object {pipe rotate 10*z translate 2.1*y
       clipped_by{ plane {<1, 0, 0>, 4 }  } }
prism {
      linear_sweep
      linear_spline
      -.8,
      .8,
      4,
      <14, -.75>, <5, -.75>, <5, .75>, <14, -.75>
      rotate -90*x translate .75*y
      }
prism {
      linear_sweep
      linear_spline
      -.8,
      .8,
      4,
      <-14, -.75>, <-5, -.75>, <-5, .75>, <-14, -.75>
      rotate -90*x translate .75*y
     }
     
     }


#declare twopipe = union {
         cylinder {<-16, 0, .3>, <16, 0, .3>, .3 }
         cylinder {<-16, 0, -.3>, <16, 0, -.3>, .3 }
         
         }

#declare threepipe = union {  //between pipes
         cylinder {<-16, 0, 0>, <16, 0, 0>, .3 }
         cylinder {<-16, 0, .8>, <16, 0, .8>, .3 }
         cylinder {<-16, 0, -.8>, <16, 0, -.8>, .3 }
         
         }

#declare smallpipe = cylinder {<-16, 0, 0>, <16, 0, 0>, .3
                              
                              }

#declare gear = box {    //the rectangles around small platform
                    <-.1, 0, -5.5>, <.1, 2, 5.5>
                    
                    }

#declare base = union {
object {threepipe rotate -22.5*y }
object {smallpipe rotate -60.35*y }
object {smallpipe rotate -78.75*y }
object {threepipe rotate 22.5*y }
object {twopipe rotate -110.75*y }
object {gear }
object {gear rotate -5*y}
object {gear rotate -10*y}
object {gear rotate -15*y}
object {gear rotate -20*y}
object {gear rotate -25*y}
object {gear rotate -30*y}
object {gear rotate -35*y}
object {gear rotate -40*y}
object {gear rotate -45*y}
object {gear rotate -50*y}
object {gear rotate -55*y}
object {gear rotate -60*y}
object {gear rotate -65*y}
object {gear rotate -70*y}
object {gear rotate -75*y}
object {gear rotate -80*y}
object {gear rotate -85*y}
object {gear rotate -90*y}
object {gear rotate -95*y}
object {gear rotate -100*y}
object {gear rotate -105*y}
object {gear rotate -110*y}
object {gear rotate -115*y}
object {gear rotate -120*y}
object {gear rotate -125*y}
object {gear rotate -130*y}
object {gear rotate -135*y}
object {gear rotate -140*y}
object {gear rotate -145*y}
object {gear rotate -150*y}
object {gear rotate -155*y}
object {gear rotate -160*y}
object {gear rotate -165*y}
object {gear rotate -170*y}
object {gear rotate -175*y}
object {pipe rotate -90*y scale <.5, .5, 1> }
object {raised rotate -45*y}
object {raised rotate -135*y} }

object {base
texture {backcolor}
}



#declare ship = //background begins here

torus {
      44,
      8
      rotate 90*z
      translate <-11, 44, 0>
      hollow
      }

#declare step1 = union {  //semi-torus with ridge
difference {
         object {ship}
         cylinder {<-25, 44, 0>, <2, 44, 0>, 51 }
         }
         torus {51, .5 rotate 90*z translate <-15.5, 44, 0>}
         torus {51, .5 rotate 90*z translate <-17.5, 44, 0> }
         }

#declare step3 =   //makes 1 ring on object
         torus {51.9, 1 scale <.25, .8, 1> }


#declare step4 = union {  //fills ship with rings and moves to position
         object {step3}
         object {step3 rotate 2.5*x}
         object {step3 rotate 5*x}
         object {step3 rotate 7.5*x}
         object {step3 rotate 10*x}
         object {step3 rotate 12.5*x}
         object {step3 rotate 15*x}
         object {step3 rotate 17.5*x}
         object {step3 rotate 20*x}
         object {step3 rotate 22.5*x}
         object {step3 rotate 25*x}
         object {step3 rotate 27.5*x}
         object {step3 rotate 30*x}
         object {step3 rotate 32.5*x}
         object {step3 rotate 35*x}
         object {step3 rotate 37.5*x}
         object {step3 rotate 40*x}
         object {step3 rotate 42.5*x}
         object {step3 rotate 45*x}
         object {step3 rotate 47.5*x}
         object {step3 rotate 50*x}
         object {step3 rotate 52.5*x}
         object {step3 rotate 55*x}
         object {step3 rotate 57.5*x}
         object {step3 rotate 60*x}
         object {step3 rotate 62.5*x}
         object {step3 rotate 65*x}
         object {step3 rotate 67.5*x}
         object {step3 rotate 70*x}
         object {step3 rotate 72.5}
         object {step3 rotate 75*x}
         object {step3 rotate 77.5*x}
         object {step3 rotate 80*x}
         object {step3 rotate 82.5*x}
         object {step3 rotate 85*x}
         object {step3 rotate 87.5*x}
         object {step3 rotate 90*x}
         object {step3 rotate 92.5*x}
         object {step3 rotate 95*x}
         object {step3 rotate 97.5*x}
         object {step3 rotate 100*x}
         object {step3 rotate 102.5*x}
         object {step3 rotate 105*x}
         object {step3 rotate 107.5*x}
         object {step3 rotate 110*x}
         object {step3 rotate 112.5*x}
         object {step3 rotate 115*x}
         object {step3 rotate 117.5*x}
         object {step3 rotate 120*x}
         object {step3 rotate 122.5*x}
         object {step3 rotate 125*x}
         object {step3 rotate 127.5*x}
         object {step3 rotate 130*x}
         object {step3 rotate 132.5*x}
         object {step3 rotate 135*x}
         object {step3 rotate 137.5*x}
         object {step3 rotate 140*x}
         object {step3 rotate 142.5*x}
         object {step3 rotate 145*x}
         object {step3 rotate 147.5*x}
         object {step3 rotate 150*x}
         object {step3 rotate 152.5*x}
         object {step3 rotate 155*x}
         object {step3 rotate 157.5*x}
         object {step3 rotate 160*x}
         object {step3 rotate 162.5*x}
         object {step3 rotate 165*x}
         object {step3 rotate 167.5*x}
         object {step3 rotate 170*x}
         object {step3 rotate 172.5*x}
         object {step3 rotate 175*x}
         object {step3 rotate 177.5*x}
         translate <-11, 44, 0>}

#declare step5 = difference { //cuts out center
         object {step4}
         cylinder {<100, 44, 0>, <-100, 44, 0>, 50.5 }
         }

#declare step6 = union {  //makes half-torus with ridge and rings
         object {step1}
         object {step5 } }

#declare step8 = union {

object {step6 }
object {step6  translate 11*x}
object {step6  translate -11*x}
object {step6  translate 22*x}
object {step6  translate 33*x}
object {step6 translate 44*x}
object {step6 translate 55*x}
object {step6 translate -22*x}
object {step6 translate -33*x}
object {step6 translate -44*x}
texture {backcolor}
}

object {step8 scale 2}


fog {  
    distance 100
    color rgbt<0.65, 0.7, 0.8, .7 >
    fog_type 2
    fog_offset 10
    fog_alt 1
    turbulence .6
    turb_depth 1
    }

//start building alien

#declare a = difference {
         cylinder {<0, 2, 0>, <0, 3.75, 0>, 4.5 }
         cylinder {<-6, 4, -5>, <6, 4, -5>, 2 scale <1, 1, .5>} //side
         cylinder {<-6, 4, 5>, <6, 4, 5>, 2 scale <1, 1, .5>} //side
         cylinder {<9, 5, -5.5>, <9, 5, 5.5>, 8 } //front
         cylinder {<-9, 5, -5.5>, <-9, 5, 5.5>, 8 } //back
         box {<-.25, 3, -4.5>, <.25, 4, 4.5> }
         }

 object {a texture {backcolor} }




//start alien

#declare aliencolor =
        texture {
        pigment {color 0.4*Wheat}
        finish {
        ambient 0.25
        phong .5
        phong_size 25
        }
        normal {
        crackle
        }
        }
        
#declare a = union {  //alien chair
difference {
         cylinder {<0, 2, 0>, <0, 3.75, 0>, 4.5 }
         cylinder {<-6, 4, -5>, <6, 4, -5>, 2 scale <1, 1, .5>} //side
         cylinder {<-6, 4, 5>, <6, 4, 5>, 2 scale <1, 1, .5>} //side
         cylinder {<9, 5, -5.5>, <9, 5, 5.5>, 8 } //front
         cylinder {<-9, 5, -5.5>, <-9, 5, 5.5>, 8 } //back
         //box {<-.25, 3, -4.5>, <.25, 4, 4.5> }
         cylinder {<0, 3.6, -5>, <0, 3.6, -3.25>, .35}
         }
         difference {
         cylinder {<0, 3.6, -4.5>, <0, 3.6, -3.75>, .27} //make circle bttom of belt
         cylinder {<0, 3.6, -4.6>, <0, 3.6, -4.4>, .24 }
         }
         }

 object {a texture {aliencolor} }



#declare fronttube = difference {

         cylinder {<0, 3.5, 0>, <9, 3.5, 0>, 2 scale <1, .75, 1> }

         //cylinder {<8.23, 4, 0>, <8.26, 4, 0>, 2.5 }
         //cylinder {<8.48, 4, 0>, <8.51, 4, 0>, 2.5 }
         //cylinder {<8.73, 4, 0>, <8.76, 4, 0>, 2.5 }
         cylinder {<6.5, 3.5, -2.5>, <8, 3.5, -2.5>, .8 }//take piece out of tube
         cylinder {<6.7, 3.5, -2.5>, <6.8, 3.5, -2.5>, .9}//5 more pieces
         cylinder {<7, 3.5, -2.5>, <7.1, 3.5, -2.5>, .9}
         cylinder {<7.3, 3.5, -2.5>, <7.4, 3.5, -2.5>, .9}
         cylinder {<7.6, 3.5, -2.5>, <7.7, 3.5, -2.5>, .9}
         cylinder {<7.9, 3.5, -2.5>, <8, 3.5, -2.5>, .9}
         cylinder {<6, 4, 0>, <6.17, 4, 0>, 2.5 } //slice along z axis

         }

#declare rounds =
         cylinder {<-.15, 3.5, 0>, <.15, 3.5, 0>, 2.3 scale <1, .75, 1> }

#declare pipes =
         cone {<8.35, 4, 0>, .35, <.5, 4, 0>, .2 }

#declare fronttube1 = union {

     object {fronttube  }
     object {rounds translate <8.35, 0, 0> }
     object {rounds translate <8.70, 0, 0> }
     clipped_by {plane {y, 2.4 inverse} }

     }

 union {
       object {fronttube1}
       object {pipes}
       object {pipes translate <0, -1.5, -1.8> }
       texture {aliencolor}
       }

#declare belt = union {
         cylinder {<-.2, 3.5, 0>, <-.13, 3.5, 0>, 4.4 scale <1, .8, 1>}
         cylinder {<.13, 3.5, 0>, <.2, 3.5, 0>, 4.4 scale <1, .8, 1>}
         cylinder {<-.14, 3.5, 0>, <.14, 3.5, 0>, 4.25 scale <1, .8, 1> }
         }

 union {
object {belt rotate .7*z translate .5*x}
object {belt rotate -.7*z translate -.5*x}
 texture {aliencolor}
     }

#declare sidebars = union {
         blob {
         threshold .3
              cylinder {<1, 5, -2.5>, <-2.5, 5, -2.5>, .5, 1 }
              cylinder {<-2.5, 5, -2.5>, <-3.5, 4, -2.5>, .5, 1}
              cylinder {<-3.5, 4, -2.5>, <-4.3, 3.8, -2.2>, .5, 1}  //top bar
              sphere {<-2.5, 5, -2.5>, .5, -1}
              sphere {<-3.5, 4, -2.5>, .5, -1} }
         blob {
         threshold .3
              cylinder {<3, 4.5, -2.7>, <-2.2, 4.5, -2.7>, .26, 1 }
              cylinder {<-2.2, 4.5, -2.7>, <-3.2, 3.8, -2.7>, .26, 1}
              cylinder {<-3.2, 3.8, -2.7>, <-4, 3.7, -2.5>, .25, 1}//middle
              sphere {<-2.2, 4.5, -2.7>, .26, -1 }
              sphere {<-3.2, 3.8, -2.7>, .25, -1 }
              }
         blob {
         threshold .3
              cylinder {<3, 4.15, -2.75>, <-2.1, 4.15, -2.75>, .15, 1}//bottom
              cylinder {<-2.1, 4.15, -2.75>, <-3, 3.6, -2.75>, .15, 1}
              cylinder {<-2.9, 3.7, -2.75>, <-3.8, 3.4, -2.75>, .14, 1}
              sphere {<-2.1, 4.15, -2.75>, .15, -1}
              sphere {<-2.9, 3.6, -2.75>, .14, -1}
              } }

#declare tire = union { //looks like a tire
         
         cylinder {<0, 8, -2.7>, <0, 8, -2>, 3.05 }
         
         difference {
         cylinder {<0, 8, -2.7>, <0, 8, -2>, 3.4 }
         cylinder {<0, 8, -2.9>, <0, 8, -1.8>, 3.1 }
         }
         difference {
         cylinder {<0, 8, -2.5>, <0, 8, -2.1>, 4.3 }
         cylinder {<0, 8, -2.8>, <0, 8, -1.9>, 3.3 }
         }
         difference {
         cylinder {<0, 8, -2.7>, <0, 8, -2.1>, 4.5 }
         cylinder {<0, 8, -2.8>, <0, 8, -2>, 4.2 }
         }
         }

#declare tirepart =
         box {<-4.5, -.05, -2.6>, <4.5, .05, -2.2> }

#declare tireridges = union {
         object {tire}
         object {tirepart rotate -25*z translate 8*y}
         object {tirepart rotate -35*z translate 8*y}
         object {tirepart rotate -45*z translate 8*y}
         object {tirepart rotate -55*z translate 8*y}
         }

#declare backbottom = union {
         sphere {<0, 0, 0>, 1.5 scale <1, .5, 1>
         rotate -5*z translate <-4, 3.2, -1.4>}
         sphere {<0, 0, 0>, 1.5 scale <1.4, .5, 1.6>
         rotate -5*z translate <-5, 3.5, 0>}
         }

union {
object {sidebars}
object {backbottom}
difference {
object {tireridges}
box {<-1, 6.3, -3>, <4.6, 13, 0> }
box {<-4.6, 1, -3.1>, <0, 14, 1> }
cylinder {<0, 8, -2.8>, <0, 8, -1.9>, 2.8}
}
difference {
cylinder {<1, 5.5, -2>, <-3, 5.5, -2>, .25}
sphere {<-3, 6, -2>, .5}
}
box {<-3.5, 2.9, -2.3>, <1.5, 4.5, 2.3> } //filler
texture {aliencolor}
}

#declare frontventring =

         torus {.6, .09 scale <1, 1, .75> }

#declare ventrings = union {

         object {frontventring scale <1, 1, .75>rotate -90*z
         translate <2.1, 3.25, -3> }
         object {frontventring scale <1, 1, .75> rotate -90*z
         translate <2.3, 3.25, -3> }
         object {frontventring scale <1, 1, .75> rotate -90*z
         translate <2.5, 3.25, -3>}
         object {frontventring scale <.99, 1, .75> rotate -90*z
         translate <2.7, 3.25, -3> }
         object {frontventring scale <.98, 1, .74> rotate -90*z
         translate <2.9, 3.25, -3> }
         object {frontventring scale <.97, 1, .73> rotate -90*z
         translate <3.1, 3.25, -3> }
         object {frontventring scale <.96, 1, .72> rotate -90*z
         translate <3.3, 3.25, -3> }
         object {frontventring scale <.95, 1, .71> rotate -90*z
         translate <3.5, 3.25, -3> }
         object {frontventring scale <.94, 1, .70> rotate -90*z
         translate <3.7, 3.25, -3> }
         object {frontventring scale <.93, 1, .69> rotate -90*z
         translate <3.9, 3.25, -3> }
         object {frontventring scale <.92, 1, .68> rotate -90*z
         translate <4.1, 3.25, -3> }
         object {frontventring scale <.91, 1, .67> rotate -90*z
         translate <4.3, 3.25, -3> }
         object {frontventring scale <.90, 1, .66> rotate -90*z
         translate <4.5, 3.25, -3> }
         object {frontventring scale <.89, 1, .65> rotate -90*z
         translate <4.7, 3.25, -3> }
         object {frontventring scale <.88, 1, .64> rotate -90*z
         translate <4.9, 3.25, -3> }
         object {frontventring scale <.87, 1, .63> rotate -90*z
         translate <5.1, 3.25, -3> }
         object {frontventring scale <.86, 1, .62> rotate -90*z
         translate <5.3, 3.25, -3> }
         object {frontventring scale <.85, 1, .61> rotate -90*z
         translate <5.5, 3.25, -3> }
         object {frontventring scale <.84, 1, .60> rotate -90*z
         translate <5.7, 3.25, -3> }
         object {frontventring scale <.83, 1, .59> rotate -90*z
         translate <5.9, 3.25, -3> }
         object {frontventring scale <.82, 1, .58> rotate -90*z
         translate <6.1, 3.25, -3> }
         object {frontventring scale <.81, 1, .57> rotate -90*z
         translate <6.3, 3.25, -3> }
         object {frontventring scale <.80, 1, .56> rotate -90*z
         translate <6.5, 3.25, -3> }
         object {frontventring scale <.79, 1, .55> rotate -90*z
         translate <6.7, 3.25, -3> }
         object {frontventring scale <.78, 1, .54> rotate -90*z
         translate <6.9, 3.25, -3> }
         object {frontventring scale <.77, 1, .53> rotate -90*z
         translate <7.1, 3.25, -3> }
         object {frontventring scale <.76, 1, .52> rotate -90*z
         translate <7.3, 3.25, -3> }
         object {frontventring scale <.75, 1, .51> rotate -90*z
         translate <7.5, 3.25, -3> }
         object {frontventring scale <.74, 1, .50> rotate -90*z
         translate <7.7, 3.25, -3> }
         object {frontventring scale <.73, 1, .49> rotate -90*z
         translate <7.9, 3.25, -3> }
         }

#declare halfventrings = difference {
         object {ventrings}
         box {<0, 3.25, -5>, <9, 5, 1>}
         }

#declare frontvent = union {
         cone {<0, 3.25, -3>, .7, <8, 3.25, -3>, .4
         scale <1, 1, .75> translate <1, 0, 0>}
         cone {<.1, 3.25, -3.511>, .125, <8.4, 3.25, -3.086>, .1 }
         }

#declare thefrontvent =
 union {
       object {frontvent}
       object {halfventrings}
       texture {aliencolor}
       }

#declare bend_object = object {thefrontvent rotate -5*z}
#declare object_axis1 = <6, 3.25, -3>
#declare object_axis2 = <8, 3.25, -3>
#declare bend_angle = 20
#declare bend_direction = y
#declare bend_start = 0
#declare bend_finish = 1
#declare bend_smoothness = 120

#include "Bend.inc"

//begin alien pilot

#declare armring =
         torus {.5, .1 rotate 43*z}

#declare arm = union {

         blob {
         threshold .6
              cylinder {<-2.4, 6.6, -3>, <1.5, 6.4, -3>, .8, 1} //forearm
              cylinder {<-2, 6.1, -3.3>, <1.4, 6.3, -3>, .2, 1}
              cylinder {<-2.2, 6.3, -3.4>, <1.4, 6.2, -3>, .22, 1}
              sphere {<-2.3, 6.6, -3.3>, .6, 1}

              cylinder {<-3.5, 9.5, -2.3>, <-2, 6.8, -3>, .6, 1}
              cylinder {<-4.3, 9, -2.3>, <-2.3, 6, -3>, .7, 1}
              sphere {<-4, 9.2, -2.5>, .8, 1} //upperarm

              cylinder {<2, 6.75, -3.2>, <2.4, 6.65, -3.5>, .2, 1}
              cylinder {<2.4, 6.65, -3.5>, <2.7, 6.7, -3.5>, .2, 1}
              //index finger
              cylinder {<2, 6.55, -3.3>, <2.5, 6.45, -3.6>, .2, 1}
              cylinder {<2.5, 6.45, -3.6>, <2.8, 6.5, -3.6>, .2, 1}
              //middle finger
              cylinder {<1.9, 6.35, -3.3>, <2.45, 6.25, -3.6>, .2, 1}
              cylinder {<2.45, 6.25, -3.6>, <2.85, 6.3, -3.6>, .2, 1}
              //ring finger
              cylinder {<1.8, 6.15, -3.3>, <2.4, 6.05, -3.6>, .2, 1}
              cylinder {<2.4, 6.05, -3.6>, <2.7, 6.1, -3.6>, .2, 1}
              //pinky
              cylinder {<1.9, 6.75, -3.2>, <2.3, 6.8, -3.1>, .2, 1}
              cylinder {<2.3, 6.8, -3.1>, <2.5, 6.75, -3.1>, .2, 1}
              sphere {<1.8, 6.7, -3.3>, .2, 1}
              //thumb
              sphere {<1.9, 6.55, -3.3>, .25, .6}
              sphere {<1.8, 6.5, -3.3>, .3, .6}
              //hand
              }

              object {armring translate <-3.9, 9, -2.2>}
              object {armring translate <-3.7, 8.75, -2.3>}
              object {armring translate <-3.5, 8.5, -2.35>}
              object {armring translate <-3.3, 8.2, -2.44>}
              object {armring translate <-3.1, 7.9, -2.52>}
              object {armring translate <-2.9, 7.65, -2.6>}
              object {armring translate <-2.7, 7.4, -2.72>}
              object {armring translate <-2.5, 7.15, -2.8>}
              object {armring translate <-2.3, 6.9, -2.87>}
              }

#declare hosepart =
         torus {.18, .05 rotate 90*z}

#declare airhose = union {
         cylinder {<-3.75, 0, 0>, <3.75, 0, 0>, .15}
         object {hosepart translate <-3.7, 0, 0> }
         object {hosepart translate <-3.5, 0, 0> }
         object {hosepart translate <-3.3, 0, 0>}
         object {hosepart translate <-3.1, 0, 0>}
         object {hosepart translate <-2.9, 0, 0>}
         object {hosepart translate <-2.7, 0, 0>}
         object {hosepart translate <-2.5, 0, 0>}
         object {hosepart translate <-2.3, 0, 0>}
         object {hosepart translate <-2.1, 0, 0>}
         object {hosepart translate <-1.9, 0, 0>}
         object {hosepart translate <-1.7, 0, 0>}
         object {hosepart translate <-1.5, 0, 0>}
         object {hosepart translate <-1.3, 0, 0>}
         object {hosepart translate <-1.1, 0, 0>}
         object {hosepart translate <-.9, 0, 0>}
         object {hosepart translate <-.7, 0, 0>}
         object {hosepart translate <-.5, 0, 0>}
         object {hosepart translate <-.3, 0, 0>}
         sphere {<1, 0, 0>, .8 scale <1, .5, .5>}
         pigment {color Wheat}
         finish {crand 0.1}
         }


union {
object {arm}

object {airhose rotate -48*z translate <-1.9, 9.5, 0>}

object {airhose rotate -55*z translate <-2.3, 9.5, 0>}

pigment {color Wheat}
finish {crand 0.1}
 }

#declare rib = torus {1.25, .15}

#declare rightribs = union {

        object {rib scale .9 rotate <-5, 0, 46> translate <-3.4, 9.2, -.7>}
        object {rib rotate <-5, 0, 46> translate <-3, 8.8, -.7>}
        object {rib rotate <-5, 0, 46> translate <-2.5, 8.4, -.7>}
        object {rib rotate <-5, 0, 46> translate <-2, 8, -.7>}
        object {rib scale .9 rotate <-5, 0, 46> translate <-1.5, 7.5, -.7>}
        object {rib scale .8 rotate <-5, 0, 46> translate <-1, 7, -.7>}
        }

#declare leftribs= union {

        object {rib scale .9 rotate <5, 0, 46> translate <-3.4, 9.2, .7>}
        object {rib rotate <5, 0, 46> translate <-3, 8.8, .7>}
        object {rib rotate <5, 0, 46> translate <-2.5, 8.4, .7>}
        object {rib rotate <5, 0, 46> translate <-2, 8, .7>}
        object {rib scale .9 rotate <5, 0, 46> translate <-1.5, 7.5, .7>}
        object {rib scale .8 rotate <5, 0, 46> translate <-1, 7, .7>}
        }

#declare body = union {
        object {rightribs}
        object {leftribs}
        blob {
        threshold .65
        sphere {<-5, 10, 0>, 1.3, 1 scale <1, 1, 3>}//neck

        sphere {<-4, 9.6, 0>, 1.3, 1 scale <1, 1, 2>}
        sphere {<-3.5, 9.25, 0>, 1.4, 1 scale <1, 1, 2>}
        sphere {<-3, 8.8, 0>, 1.5, 1 scale <1, 1, 2>}
        sphere {<-2.5, 8.4, 0>, 1.5, 1 scale <1, 1, 2>}
        sphere {<-2, 8, 0>, 1.5, 1 scale <1, 1, 2>}
        sphere {<-1.5, 7.5, 0>, 1.5, 1 scale <1, 1, 2>}
        sphere {<-1, 7, 0>, 1.5, 1 scale <1, 1, 2>}
        sphere {<0, 6.5, 0>, 1.2, 1 scale <1, 1, 2>}
        sphere {<.8, 6.3, 0>, 1.1, 1 scale <1.3, 1, 1.9>}//body

        sphere {<-5.3, 12, 0>, 2, 1 pigment {color Wheat}
                finish {crand 0.1} normal {crackle 1}}//head
        sphere {<-5.1, 12, 0>, 2, 1 pigment {color Wheat}
                finish {crand 0.1} normal {crackle 1}}//head
        sphere {<-4.5, 11.4, 0>, 1, 1}//face
        sphere {<-6, 10, 0>, 1.3, 1 scale <1, 1, 2>}//neck
        sphere {<-4.5, 9.7, -2>, 1, 1}//shoulder

        cylinder {<-4.5, 5.5, 0>, <3, 5.5, 0>, 2, 1 scale <1, 1, 2>}//new

        //Back
        sphere {<-6.5, 9, -1>, 2, 1}
        sphere {<-6.5, 8, -1>, 2, 1}
        sphere {<-6, 7, -1>, 2, 1}
        sphere {<-5.5, 6, -1>, 2, 1}
        sphere {<-5, 5.5, -1>, 2, 1}
        sphere {<-4, 5, -1>, 2, 1}
        cylinder {<-7, 10, -.5>, <-7, 10, .5>, 1.9, 1}

        }

        cylinder {<-1.5, 9, -1.6>, <-1.5, 9, 1.6>, 6.5
                clipped_by { plane {y, 10 } }
                clipped_by { plane {x, -4.5} }
                pigment {
                radial
                color_map {
                [0 color 0.1*Wheat]
                [.5 color 0.5*Wheat]
                }
                frequency 10
                }
                }

        cylinder {<-1, 8.5, -1.4>, <-1, 8.5, 1.4>, 7.5
                clipped_by {plane {y, 10} }
                clipped_by {plane {x, -4.5} }
                }

        //cylinder {<-7, 10, -1.6>, <-7, 10, 1.6>, 1.5}

              pigment { color Wheat}
              finish {crand 0.1}
        }

difference {

        object {body}
        sphere {<-4.2, 11.6, -1>, .4}
        sphere {<-4.2, 11.5, -.4>, .2}
        pigment {color Wheat}
        finish {crand 0.1}
        }

//alien periscope


#declare bar1 =  cylinder {<3.25, 3.5, -2.8>, <4.5, 8.5, -2.8>, .2
        scale <1, 1, .5>}
#declare bar2 =  cylinder {<4.75, 4, -2.8>, <6.25, 9.5, -2.8>, .2
        scale <1, 1, .5>}
#declare bar3 =  cylinder {<6.5, 5.5, -2.8>, <8, 10.5, -2.8>, .2
        scale <1, 1, .5>}

#declare striped =
        texture {
        pigment {
        gradient y
        color_map {
        [0 color 0.2*Wheat]
        [0.5 color 0.6*Wheat]
        }
        scale .1
        }
        finish {
        ambient .3
        phong .7
        phong_size 40
        }
        }

#declare striped2 =
        texture {
        pigment {
        gradient x
        color_map {
        [0 color 0.2*Wheat]
        [0.5 color 0.6*Wheat]
        }
        scale .4
        rotate -31*z
        }
        finish {
        ambient 0.25
        phong 1
        phong_size 30
        }
        }

#declare square =
        box {<-.5, -.5, -2.6>, <.5, .5, -2.4> rotate 31*z}

#declare scope1 =
        box {<-15, -.25, -2.6>, <15, .25, -2> rotate 31*z}

#declare scope2 =
        box {<-12, -.5, -1.8>, <12, .5, -2> rotate 31*z}

#declare scope3 =
        cylinder {<-12, 0, -1.6>, <12, 0, -1.6>, .8 rotate 31*z
        pigment {
        gradient x
        color_map {
        [0 color 0.1*Wheat]
        [.5 color 0.7*Wheat]
        }
        scale .3
        }
        finish {
        ambient 0.2
        phong .65
        phong_size 30
        }
        }

//#declare scope4 =
   //     cylinder {<-11, 0, 0>, <11, 0, 0>, 2 rotate 31*z}

#declare scopetop =
        cylinder {<-11, 0, 0>, <11, 0, 0>, 1 rotate 31*z}

#declare scope = union {
        object {square translate <4.5, 8.5, 0>}
        object {square translate <6.25, 9.5, 0>}
        object {square translate <8, 10.5, 0>}
        cylinder {<4.5, 8.5, -2.7>, <4.5, 8.5, -2.3>, .5}
        cylinder {<6.25, 9.5, -2.7>, <6.25, 9.5, -2.3>, .5}
        cylinder {<8, 10.5, -2.7>, <8, 10.5, -2.3>, .5}
        object {scope1 translate <11, 12, 0> }
        object {scope2 translate <11, 12.2, 0> texture {striped}}
        object {scope2 translate <14, 16, 0>}
        object {scope3 translate <14.5, 15.3, 0>}
        //object {scope4 translate <12.75, 16.6>}
        object {scopetop translate <12, 16, 0>}
        difference{
        cylinder {<4.5, 10, -1>, <4.5, 10, 1>, 2}
        cylinder {<4.5, 10, -.5>, <4.5, 10, -1.5>, 1.3}
        }
        texture {aliencolor}
        }

union {
        blob { //bars on side
        threshold .7
        cylinder {<3.25, 3.5, -2.8>, <4.5, 8.5, -2.6>, .4, 1}
        cylinder {<3.5, 4.75, -2.8>, <4.75, 4.3, -2.8>, .4, 1}//crossbar
        cylinder {<4.75, 4.3, -2.8>, <6.25, 9.5, -2.6>, .4, 1}
        sphere {<4.75, 4.3, -2.8>, .4, -1}
        sphere {<3.5, 4.75, -2.8>, .4, -1}
        cylinder {<5.5, 6.25, -2.8>, <6.75, 5.75, -2.8>, .4, 1}//crossbar
        cylinder {<6.5, 5.75, -2.8>, <8, 10.5, -2.6>, .4, 1}
        sphere {<6.5, 5.75, -2.8>, .4, -1}
        sphere {<5.5, 6.25, -2.8>, .4, -1}

        cylinder {<4.5, 8.5, -2.6>, <3.65, 10.5, -1.7>, .4, 1}
        cylinder {<6.25, 9.5, -2.6>, <5.2, 11.5, -1.7>, .4, 1}
        cylinder {<8, 10.5, -2.6>, <7, 12.5, -1.7>, .4, 1}//left top

        cylinder {<4.5, 8.5, -2.6>, <4, 11, -1.7>, .4, 1}
        cylinder {<6.25, 9.5, -2.6>, <5.65, 12, -1.7>, .4, 1}
        cylinder {<8, 10.5, -2.6>, <7.45, 13, -1.7>, .4, 1}//right top

        cylinder {<4.5, 8.5, -2.6>, <3.825, 10.75, -1.7>, .4, 1}
        cylinder {<6.25, 9.5, -2.6>, <5.425, 11.75, -1.7>, .4, 1}
        cylinder {<8, 10.5, -2.6>, <7.225, 12.75, -1.7>, .4, 1}//middle top

        cylinder {<3.65, 10, -1.7>, <4, 11, -1.7>, .3, 1}
        cylinder {<5.2, 11, -1.7>, <5.65, 12, -1.7>, .3, 1}
        cylinder {<7, 12, -1.7>, <7.45, 13, -1.7>, .3, 1}//in between

        cylinder {<-11, 0, 0>, <11, 0, 0>, 5.2, 1 rotate 31*z //top
                translate <12.75, 16.6, 0> }
        cylinder {<-11, 0, 0>, <11, 0, 0>, .35, 1 rotate 31*z
                translate <12.5, 16.9, -1.9> }
        cylinder {<-11, 0, 0>, <11, 0, 0>, .35, 1 rotate 31*z
                translate <12.6, 16.7, -1.9> }
        cylinder {<-11, 0, 0>, <11, 0, 0>, .35, 1 rotate 31*z
                translate <12.7, 16.5, -1.9> }

        cylinder {<3.2, 11.4, -1.85>, <1.4, 11.4, -1.4>, .4, 1//front of scope
                texture {striped2}}
        cylinder {<3.2, 11.4, -1.85>, <1, 10.6, -1.5>, .4, 1}
        sphere {<2.2, 10.7, 0>, 2.2, 1 scale <1, .75, 1>
                translate <-1, 3, 0> texture {striped2}}

       /* cylinder {<2.5, 10.5, -1>, <1.4, 9.8, -1.5>, .3, 1}//knobs
        cylinder {<2.5, 10.5, -1>, <2, 9.5, -1.5>, .3, 1}
        cylinder {<2.5, 10.5, -1>, <3, 9, -1.5>, .3, 1}*/

        sphere {<4.5, 8.5, -2.6>, .4, -1.5}
        sphere {<6.25, 9.5, -2.6>, .4, -1.5}
        sphere {<8, 10.5, -2.6>, .4, -1.5}
        }
        blob { //bottom front
            threshold .65
            cylinder {<4.5, 8, 0>, <7.5, 8, 0>, 2, 1}
            cylinder {<4.5, 6.5, 0>, <7.5, 8, 0>, 2, 1}
            cylinder {<6, 4.5, 0>, <7.5, 8, 0>, 2, 1}
            cylinder {<2, 4, 0>, <7.5, 4, 0>, 2, 1 }
            sphere {<0, 0, 0>, 2, 1.5
                scale <.15, 1, 1> translate <8.5, 8, 0>}
            sphere {<8.5, 8, 0>, 2, -1}
            sphere {<7.5, 9.25, 0>, 1, 1}
            cylinder {<2, 5.5, 0>, <4.5, 7, 0>, 2, 1}
            }

        torus {2, .25 rotate -59*z translate <3.2, 11, 0>}

        torus {2, .2 rotate -59*z translate <4.8, 12, 0>}
        object {bar1 translate .15*x texture {striped}}
        object {bar1 translate -.15*x texture {striped}}
        object {bar2 translate .15*x texture {striped}}
        object {bar2 translate -.15*x texture {striped}}
        object {bar3 translate .15*x texture {striped}}
        object {bar3 translate -.15*x texture {striped}}
        object {scope}
        texture {aliencolor}
        }


        
