
#ifndef (ABCDE)
#include "defaults.inc"
//      light_source{ <-10, 100, -100> color Yellow}
#end
//============================================================
#include "dancer2.pov"
#declare RoofTex =
texture {
	pigment{ gradient y
		color_map{
			[0.0, 0.4 color Gray  color Mica]
			[0.4, 0.8 color White color Mica]
			[0.8, 1.0 color Gray  color Mica]
		}
    }
   normal { gradient x
            normal_map {
               [0.3  bumps scale 2]
               [0.3  dents]
               [0.6  dents scale 2]
               [0.9  marble turbulence 1]
            }
   }
scale <5, 1, 1>
}

#declare WallTex =
texture {
	pigment{ gradient y
		color_map{
			[0.0, 0.4 color Gray  color Mica]
			[0.4, 0.8 color White color Mica]
			[0.8, 1.0 color Gray  color White ]
		}
    }
   normal { gradient y
            normal_map {
               [0.3  bumps scale 2]
               [0.3  dents]
               [0.6  dents scale 2]
               [0.9  marble turbulence 1]
            }
   }
scale <5, 1, 1>
}
#declare FloorTex =
texture { pigment { color Gray }
finish { ambient 0.1 diffuse 0.5 phong 0.1 phong_size 10}
   normal { gradient z
            normal_map {
               [0.3  bumps scale 2]
               [0.3  dents]
               [0.6  dents scale 2]
               [0.9  marble turbulence 1]
            }
   }
scale 2
}
#declare Bx = box { <-1, -1, -1>  < 1,  1,  1>  }


#declare Pyramid2 = intersection {
   plane { < 1, 0,  0>, 1  rotate <  0, 0,  40>}
   plane { <-1, 0,  0>, 1  rotate <  0, 0, -40>}
   plane { < 0, 0,  1>, 1  rotate <-40, 0,   0>}
   plane { < 0, 0, -1>, 1  rotate < 40, 0,   0>}
   plane { <0, -1, 0>, 0 }
   translate <0 ,-1, 0>
}



#declare Walk =
union {

box { <-.5, -.5, -.5>  < 1,  1,  1>  scale < 10, 1.2, .3 > texture { FloorTex }}
#declare X=-4 #while ( X<= 10 )
     superellipsoid { <0.5,  .1> scale .4 translate <X,-.15,.23> texture { pigment { color Yellow * .5}}}
     superellipsoid { <0.5,  .1> scale .4 translate <X,.75,.23>  texture { pigment { color Yellow * .5}}}
#declare X = X + .9 #end
scale 2
}

#declare WalkWay =
union {
  object { Walk rotate < 90, 120, 0 > translate < -75, -32, 55 >}
  object { Walk rotate < 90, 130, 0 > translate < -60, -32, 75 >}
  object { Walk rotate < 90, 120, 0 > translate < -45, -32, 98 >}
}

#declare Wall =
union {
#declare Ws = < 2, .5, .05 >
#declare Rn = < 4, 0, 0 >
#declare Y = 0 #while (Y <= 5)
  object { Bx  scale Ws rotate Rn translate < 0, Y * .5, 0> }
#declare Y = Y + 1 #end
texture { WallTex }
rotate < -90, -90, -90 >
scale < .55, 2, .4 >
translate < .955, 10, 0 >
}


#declare Building =
union {
#declare Bpos = < -25,-32,75>
union {//Floor
   object { Bx translate < 0, 0, 0 > }
   object { Bx translate < 0, 2, 0 > }
   object { Bx translate < 0, 4, 0 > }
 texture { FloorTex }
}

//object { Bx translate < 0, 6, 0 >  texture { pigment { color White}}}
    union {
      // OuterPosts
      #declare Ds = < .05, 20, .1>
      object { Bx translate < 19, .2,  8 > scale  Ds  }
      object { Bx translate < 19, .2, -8 > scale  Ds  }
      object { Bx translate <-19, .2,  8 > scale  Ds  }
      object { Bx translate <-19, .2, -8 > scale  Ds  }
      // DoorPosts
      object { Bx translate < -5, .2, -8 > scale  Ds  }
      object { Bx translate <  5, .2, -8 > scale  Ds  }
      texture { pigment { color Brown}}
    }
object { Wall }
object { Wall rotate < 0, 180, 0 > translate < 0, 0, 0 >}
object { Wall scale < 1, 1, .4> rotate < 0, 90, 0 > translate < .6, 0, .2 >}
object { Wall scale < 1, 1, .4> rotate < 0, 90, 0 > translate < -.6, 0, .2 >}
object { Wall scale < 1, 1, 2> rotate < 0, -90, 0 > translate < -.65, 0, -.1 >}
scale < 30, 1, 15 >
rotate < 0, 120, 0 >
translate Bpos
}

#declare Rf1 =
difference {
  object { Pyramid2 }
  object { Bx  scale < 2, 1, 2 > translate < 0, .2, 0>}
scale < 26, 7, 13 >
}

#declare Rf2 =
union {
#declare S = 1
#declare Y = 0
#declare CNT = 0 #while ( CNT <= 13 )
object { Rf1 scale < S, 1, S >  translate < 0, Y, 0 >  texture { RoofTex}}
#declare Y = Y + 1.2 - (.05 * CNT )
#declare S = S - .1 + (.01 * CNT )
#declare CNT = CNT + 1 #end
}

#declare Rf3 =
difference {
  object { Rf2 }
  sphere { < 0, -12, 0> 11 pigment { color White} scale < 1.2, .5, 1.2>}
}


#declare Roof =
    object { Rf3
rotate < 0, 120, 0 >
translate < -25, 0,75>
}


#declare Scene =
union {
    light_source{ < -26, -7, 61> color Thistle }
  object { WalkWay translate < -20, .75, -40>}
  object { Building }
  object { Roof }
  object { Dancer2 rotate < 0, -20, 0 > translate < -26, -17, 66>}
}


//object { Wall }
//object { Roof rotate <90,0,0> translate < -100, 50, 50>}
object { Scene }
