
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#declare ABCDE = 0

global_settings {
  adc_bailout 5/255
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
    radiosity {
        count 800                // Ensure that we get good, accurate samples
        error_bound 0.2          // And calculate lots of them.  (more important than count)
        gray_threshold 0.5
        distance_maximum 0       // Scene-dependant!
        low_error_factor 0.7     // force many extra samples to be calculated...
        nearest_count 9          // so we can average them together for smoothness
        minimum_reuse 0.01       // get quite tightly into corners
        brightness 3.3           // doesn't really matter.  Not used in final output.
        recursion_limit 1        // Try this = 2, but drop the count to maybe 300
   }
}

#default {
  finish {  ambient .1
            diffuse 0.3
            reflection 0.00
            phong 0.0
         }
}
#declare Mn = <-75,40,200>
#declare Moon =
union {
  sphere { Mn 6 hollow
         texture { pigment {color Silver filter .5}
         finish { ambient 0.8 diffuse 1 }
         normal {bumps 2 scale .5}
         }}
//  light_source{  Mn color Silver }
  light_source{  < Mn.x + 100, Mn.y + 1000, Mn.z + 400> color Silver }
}

//light_source{ <15, 1000, 200> color White }
camera{ location <15.0 , 6.0 ,-10> look_at <4.0 , 2.0 , 0.0>}


object { Moon }
