
#ifndef (ABCDE)
#include "defaults.inc"
light_source{ <-5, 50, -20> color White }
#declare Local = 1
#end
//============================================================
#include "metals.inc"
#include "woods.inc"

#declare CupTex = texture {T_Copper_5E}

#declare hollowsphere =
difference {
  sphere { <0,0,0>,1  }
  sphere { <0,0,0>,1 scale 0.95 }
}

#declare cup =
difference {
  object { hollowsphere }
  box { <-1, -1, -1>, <1, 1, 1> translate <0,1.5,0> }
  texture {CupTex}
}

#declare teacup = union {
  object { cup }
  cylinder { <0,0,0>, <0,1,0>, 1.4
    scale <0.5, 0.15, 0.5>
    translate <0, -.89,0>
  }
  torus { // handle
    1.825, 0.175  rotate -x*90
    scale <0.175, 0.25, 0.25>
    translate  <1.253959, 0.0, -0.135042>  }
  texture {CupTex}
  translate <0,5.8,0>
}

#declare saucer =
union {
difference {
  object { hollowsphere scale <1,.1,1>}
  box { <-1, -1, -1>, <1, 1, 1> translate <0,1.0,0> }
}
  cylinder {<0,0,0>, <0,1,0>, 1.2 scale <0.5, 0.05, 0.5>
        translate <0,-.12,0> texture {T_Brass_5E}}
texture {CupTex}
  scale <1.1,1.1,1.1>
  translate <0,5,0>
}

#declare Spoon =
union {
  object { cup scale < .25, .1, .75> rotate < 0, 90, 0> translate < -.5, 0, 0 >}
  box { <-1, -1, -1>, <1, 1, 1> scale < 1, .04, .15 > translate < 1, -.01, 0> }
texture {CupTex}
}

#declare Fork =
difference {
object { Spoon }
  box { <-1, -1, -1>, <1, 1, 1> scale < .75, .15, .03 > translate < -1, .05, .1> }
  box { <-1, -1, -1>, <1, 1, 1> scale < .75, .15, .03 > translate < -1, .05, -.0> }
  box { <-1, -1, -1>, <1, 1, 1> scale < .75, .15, .03 > translate < -1, .05, -.1> }
  box { <-1, -1, -1>, <1, 1, 1> translate < -2, 0, 0> }
  scale < 1.05, 1, 1 >
texture {CupTex}
}

#declare Knife =
union {
  box { <-1, -1, -1>, <1, 1, 1> scale < .75, .02, .11 > translate < -.8, 0, 0> }
  box { <-1, -1, -1>, <1, 1, 1> scale < 1, .04, .15 > translate < .9, -.01, 0> }
texture {CupTex}
}

#declare plate =
union {
  object {saucer scale <.5,.5,.5> translate <0,.01,0> }
  object { Fork rotate <0, 1, 0 > scale < .25, .2, .2 > translate < -.1, 2.5, -.65 > }
  object { Spoon rotate <0, 1, 0 > scale < .25, .2, .2 > translate < -.1, 2.5, .65 > }
  object { Knife rotate <0, 1, 0 > scale < .25, .2, .2 > translate < -.08, 2.5,  .8 > }
}

#declare CupandSaucer =
union {
  object { teacup }
  object { saucer }
scale <.25,.25,.25>
}


//object { Knife rotate <0, 1, 0 > scale < .2, .2, .2 > translate < 2.2, 2.5, 4.35 > }
//object { Spoon rotate <0, 1, 0 > scale < .2, .2, .2 > translate < 2.2, 2.5, 4.35 > }

#declare Setting =
union {
  object { plate rotate < -90, 50, -90 > translate < -.5, -.7, .95 >}
  object { CupandSaucer rotate < -90, 50, -90 >  translate < 0, .8, 1.1 >}
  text { ttf "timrom.ttf" " ONLY " 1, 0 pigment {Red * 8} scale <.3, .3, .1> translate < -.9, 1.6, -1 >}
  text { ttf "timrom.ttf" "$19.95" 1, 0 pigment {Red * 8} scale <.3, .3, .1> translate < -.9, 1.2, -1 >}
  object { Cube translate < -.4, 1.7, -.4 > scale < 1, .8, 1> }

}
#declare TVTex = texture {T_Wood2}
#include "tv.inc"
#declare TV1 =
union {
  object { TV }
  object { Setting scale .9  rotate < 0, 0, 0 >translate < .35, -1, .45 >}
}


#ifdef (Local)
  object { TV1 scale 4 rotate < 0, 0, 0 >translate < 0, 2, 0 >}
#end





