
#ifndef (ABCDE)
#include "defaults.inc"
#declare Local = 1
#end
//============================================================
#declare dFinish = finish { ambient 0.1 diffuse .3 phong .5 }
#declare ShoeTex = texture { pigment { color White } finish { dFinish }}

#declare SkinTex = texture { pigment { color Flesh }
   normal{ bumps .35 scale .1 }
   finish { ambient 0.2 diffuse .4 phong .2 }
   }
#declare PantsTex = texture {
  pigment { bozo turbulence 3
              color_map
                        {
                          [  0.1  DarkPurple ]
                          [  0.2  RichBlue ]
                          [  0.3  NeonBlue ]
                          [  0.4  NewMidnightBlue ]
                          [  0.5  Med_Purple ]
                          [  0.6  Very_Light_Purple ]
                          [  0.7  Light_Purple ]
                          [  0.8  MediumAquamarine ]
                          [  0.9  DarkOrchid ]
                          [  1.00  MediumBlue ]
                        }
scale .2
           }
finish { dFinish }
}
#declare TopTex =
texture {
  pigment { bozo turbulence 3
              color_map
                        {
                          [  0.1  LightBlue ]
                          [  0.2  RichBlue ]
                          [  0.3  NeonBlue ]
                          [  0.4  SummerSky ]
                          [  0.5  Med_Purple ]
                          [  0.6  Very_Light_Purple ]
                          [  0.7  Light_Purple ]
                          [  0.8  MediumAquamarine ]
                          [  0.9  DarkOrchid ]
                          [  1.00  MediumBlue ]
                        }
scale .3
           }
finish { dFinish }
}

#declare HairTex =
texture {
  pigment { gradient x turbulence 2
              color_map
                        {
                          [  0.1  Wheat ]
                          [  0.2  Gold ]
                          [  0.3  BrightGold ]
                          [  0.4  Yellow ]
                          [  0.5  Wheat ]
                          [  0.6  BrightGold ]
                          [  0.7  OldGold ]
                          [  0.8  BrightGold ]
                          [  0.9  NewTan ]
                          [  1.00  Yellow ]
                        }
scale <.1, 2, 1 >
           }
finish { dFinish }
	normal{ waves frequency 5 scale .4 }
}
#declare LTex =
texture {
  pigment { gradient y
                color_map
                        {
                          [  0.1  Scarlet ]
                          [  0.2  Red]
                          [  0.3  Mica]
                          [  0.4  MidnightBlue]
                          [  0.5  VeryDarkBrown]
                          [  0.6  Red]
                          [  0.7  VioletRed ]
                          [  0.8  MidnightBlue]
                          [  0.9  Red]
                          [  1.00  BakersChoc ]
                        }
scale .1
           }
finish { ambient 0.4 diffuse .5 phong 1}
normal { bumps -.5 scale .1    }
}

#declare Hooker2 =
union {
//hips
union {
   sphere { < .25, 0, 0> 0.5 }
   sphere { <-.25, 0, 0> 0.5 }
   sphere { <0, 0, .1> 0.4 scale < 1, 1.2, 1> pigment {Red}}
   texture {PantsTex }
   }
// Straight leg
cone { <-.25, 0, 0>,  0.5,  <0, -1.5, 0>, .2 texture {PantsTex }}
cone { <-.01, -1.5, 0>,  0.2,  <.2, -2.4, 0>, .1 }
cone { <.2, -2.4, -.1>,  0.1,  <.2, -2.6, .2>, .08 texture {ShoeTex }}

// Bent leg
cone { < .25, 0, 0>,  0.5,  <0, -1.5, .5>, .2 texture {PantsTex }}
cone { <.01, -1.4, .5>,  0.2,  <-.2, -2.5, .5>, .1 }
cone { <-.2, -2.5, .4>,  0.1,  <-.2, -2.7, .7>, .08 texture {ShoeTex }}
// Torso
cone { < 0, 0, .1>,  0.3,  <0, 1.25, 0>, .81 scale < 1, 1, .5> }
union {
   superellipsoid { <0.4,  1.0> scale <.5, .4, .6 > translate < -.3, 1.25, 0>}
   superellipsoid { <0.4,  1.0> scale <.5, .4, .6 > translate <  .3, 1.25, 0>}
   superellipsoid { <0.5,  1.0> scale <.5, .35, .3 > translate <  0, 1.25, -.2>}
   texture {TopTex }
}

// Arm1
cone { <-.6, 1.45, -.1>,  0.17,  <-1.7, 1.2, .3>, .1 }
cone { <-1.72, 1.22, .3>,  0.11,  <-.1, .3, -.4>, .07 }
cone { <-1.92, 1.2, .29>,  0.03,  <-1.65, 1.2, .29>, .125 }

// Arm2
cone { <.6, 1.45, -.1>,  0.17,  <1.7, 1.1, .4>, .1 }
cone { <1.72, 1.1, .4>,  0.11,  <.1, .3, -.4>, .07 }
cone { <1.92, 1.09, .35>,  0.03,  <1.67, 1.09, .35>, .135 }

texture { SkinTex }
scale < 1.75, 3, 1.75 >
}

#declare Head2 =
blob
{
  threshold 0.6
  sphere { <  -.2, .2, -.71>,  .25, -2.5  scale <1.5, .7, 1>} //eye
  sphere { <   .2, .2, -.71>,  .25, -2.5  scale <1.5, .7, 1>} //eye

  sphere { <  0, .1, -.4>,  .3, 3.8 scale <2., .9, .9>} //brows
  sphere { <  0, -.1, -.39>,  .3, 3.8 scale <1.65, .9, .9>} //brows
  sphere { <  0, -.3, -.39>,  .3, 2.8 scale <1.2, .9, .9>} //brows

  sphere { <   0, -.01, -.71>,  .2, .7 scale <.7, 1.4, .8>} //Nose

  sphere { <   -.31, -.1, -.65>,  .2, .7 scale <.8, .6, .7>}
  sphere { <    .31, -.1, -.65>,  .2, .7 scale <.8, .6, .7>}

  sphere { <  0, -.6, -.5>,  .1, -3.8 scale <1.7, .4, 1> pigment { color rgb <.94,0,.32> }} //Mouth

  sphere { <  0, 0, -.1>,  .2, .6 scale <6.6, 4.5, 1.5>} //Back

  sphere { <   .05, -.03, -.2>,  .1, .6 scale <3, 4.5, 1.7>} //Back
  sphere { <   -.05, -.03, -.2>,  .1, .6 scale <3, 4.5, 1.7>} //Back

  translate < 0, 0, .5 >
  scale 5
}

#declare Ha1 =
union {
#declare X = 0
#declare Y = 0
#declare CNT = 40 #while ( CNT <= 55 )
  #declare X = ( ( 0.85 * X ) + (0.07 * Y + 0.0 ))
  #declare Y = (  (-0.04 * X ) + (0.85 * Y + 1 ))
    sphere { <   X, Y, 0 >,  .05}
  #declare Y = Y + 1 - (.040 * CNT )
  #declare X = X - .01 + (.009 * CNT )
  #declare CNT = CNT + .5 #end
}

#declare X = 0
#declare Y = 170
#declare Z = 0
#declare X2seed    = seed(100)

#declare Ha2 =
union {
#while (Y <= 370 )
  object { Ha1  rotate < rand(X2seed), Y, 0 > translate < 0, rand(X2seed)*2, 0 >}
#declare Y = Y + .5 #end
translate < 0, -1.7, .6 >
}

#declare Ha3 =
union {
#declare X = 0
#declare Y = 0
#declare CNT = 40 #while ( CNT <= 47 )
  #declare X = ( ( 0.85 * X ) + (0.07 * Y + 0.0 ))
  #declare Y = (  (-0.04 * X ) + (0.85 * Y + 1 ))
    sphere { <   X, Y, 0 >,  .05}
  #declare Y = Y + 1 - (.039 * CNT )
  #declare X = X - .01 + (.012 * CNT )
  #declare CNT = CNT + .5 #end
}

#declare X = 0
#declare Y = -20
#declare Z = 0
#declare X4seed    = seed(1000)

#declare Ha4 =
union {
#while (Y <= 110 )
  object { Ha3 rotate < rand(X4seed)*3, Y, 0 > translate < 0, rand(X4seed)*2, 0 > }
#declare Y = Y + .5 #end
translate < -1, -1, 2. >
}

#declare Eye =
union {
  sphere { <0, 0, 0> 0.6 pigment { color White } }
  sphere { <0, 0, 0> 0.3 pigment { color SkyBlue } scale < 1, 1,2.2>}
scale < 1, .7, .4 >
}


#declare Ahead =
union {
  object { Ha2 texture { HairTex } translate < 0, 0, -.3 >}
  object { Ha4 texture { HairTex } translate < 0, 0, -.3 >}
  object { Head2 texture {SkinTex}  }
  object { Eye translate < -.8, .5, .05> }
  object { Eye translate < .8, .5, .05> }
  rotate < 20, 2, 0>
}

#declare PhoneNumber =
union {
  text { ttf "timrom.ttf" "1-900" 1, 0 translate < 1.6, 1, 0 > }
  text { ttf "timrom.ttf" "XXX-XXXX" 1, 0   }
  translate < .3, -2, -.5 >
  scale <1.3, 1.3, .3>
texture {LTex }
}

#declare  Hooker3 =
union {
  object { Hooker2 rotate < 0, 180, 0> }
  object { Ahead  scale .35 translate < 0, 5.8, -.1 >}
  object { PhoneNumber translate < -4, 0, -1>}
  object { Cube translate < 0, 0, 0 > scale < 4, 8, 3> }
}

#include "tv.inc"
#declare  Hooker4 =
  union { object { TV scale < 4, 12, 7> translate < 0, -4, 3>}
  object { Hooker3 scale .9 translate < 0, 0, .5>}
  light_source{ <.6, 5.0, -4.5>  color White shadowless}

//sphere { <0, 0, 0> .2 pigment {color White} translate <.8, 4.5, -4.5> }

}

#ifdef (Local)
// object { Hooker4 scale 1  rotate < 0, 0, 0> translate < 0, 3, 10>}
 object { Hooker4 scale 1  rotate < -10, -25, 30> translate < -19, .5, 22>}
#end
