
#ifndef (ABCDE)
#include "defaults.inc"
#declare Local = 1
#end

//============================================================
#include "cmaps.inc"

#declare OJTex =
texture { pigment {
        wood turbulence <1, 1, 0 >
        color_map {
            [0.00, 0.25 color Orange color Orange]
            [0.25, 0.75 color Scarlet color Gold]
            [0.75, 1.00 color Orange color Orange]
        }
        scale .5
    }
    finish { ambient .8 diffuse 0}
    normal { bumps -0.5 scale <1, 0.001, 0.001>    }
}
#declare OJ =
union {
text { ttf "timrom.ttf" "OJ" 1, .2*x texture {OJTex } translate < -.6, .4, 0 >
       scale < 1, 1, .1>}
  object { Cube    }
}


#declare Glob =  julia_fractal {   <-0.053,0.0,-0.83,-0.025>
    quaternion sqr max_iteration 18 precision 25 texture { Rusty_Iron } scale 2  }

#declare InfoTex =
texture {
   pigment { gradient <1, 1, 0 >
             color_map {M_G4}
             scale .5
   }
finish { ambient .8 diffuse .4}
normal { bumps -0.5 scale <1, 0.001, 0.001>    }
}

#declare Info =
union {
  union {
    text { ttf "timrom.ttf" "  Info" 1, .2*x  translate < -.5, .5, 0 >}
    text { ttf "timrom.ttf" "Mercials" 1, .2*x  translate < -.8, -.5, 0 >}
    translate < -1.6, .9, 0 >
    scale <.45, .45, .1>
    texture {InfoTex }
  }
  object { Cube }
}
#declare GameTex =
texture {
   pigment { bozo turbulence <1, 1, 0 >
             color_map {M_Flowers1  }
             scale .2
             translate < 10,0,0>
   }
finish { ambient .8 diffuse .4}
}
#declare Game =
union {
  union {
    text { ttf "timrom.ttf" "  Game" 1, .2*x  translate < -.6, .5, 0 >}
    text { ttf "timrom.ttf" "  Shows" 1, .2*x  translate < -.8, -.5, 0 >}
    translate < -2., 1, 0 >
    scale <.45,.45, .2>
    texture {GameTex }
  }
  object { Cube }
}

#declare TalkTex =
texture {
   pigment { gradient y
        color_map {
            [0.00, 0.25 color Aquamarine color CadetBlue ]
            [0.25, 0.75 color LightSteelBlue color RichBlue ]
            [0.75, 1.00 color Silver color Quartz ]
        }
  }
finish { ambient .8 diffuse .4}
}
#declare Talk =
union {
  union {
    text { ttf "timrom.ttf" "  Talk" 1, .2*x  translate < -.6, .5, 0 >}
    text { ttf "timrom.ttf" "  Shows" 1, .2*x  translate < -1.2, -.5, 0 >}
    translate < -1.2, 1, 0 >
    scale <.45,.45, .2>
    texture {TalkTex }
  }
  object { Cube }
}

#declare ShockTex =
texture {
   pigment { gradient x
             color_map {M_Blend2  }
             scale .8
             translate < 10,18,0>
   }
finish { ambient .8 diffuse .4}
}
#declare Shock =
union {
  union {
    text { ttf "timrom.ttf" "Shock" 1, .2*x  translate < -.6, .5, 0 >}
    text { ttf "timrom.ttf" "TV" 1, .2*x  translate < .2, -.5, 0 >}
    translate < -1.1, .4, 0 >
    scale <.55,.55, .1>
    texture {ShockTex }
  }
  object { Cube }
}

#declare SoapTex =
texture { pigment {
        gradient y
        color_map {
            [0.00, 0.25 color Scarlet color Orange]
            [0.25, 0.75 color Scarlet color Gold]
            [0.75, 1.00 color Orange color Scarlet ]
        }
        scale .4
    }
    finish { ambient .8 diffuse 0}
    normal { bumps -0.5 scale <1, 0.001, 0.001>    }
}
#declare Soaps =
union {
text { ttf "timrom.ttf" "Soap" 1, .2*x texture {SoapTex } translate < -1.3, .5, 0 >
       scale < .6, .65, .1>}
  object { Cube    }
}

#declare SitTex =
texture {
   pigment { gradient x
        color_map {
            [0.00, 0.25 color Orchid color SteelBlue ]
            [0.25, 0.75 color Yellow  color RichBlue ]
            [0.75, 1.00 color DarkPurple color NewMidnightBlue ]
        }scale .1
  }
finish { ambient .9 diffuse .5}
}
#declare SitCom =
union {
  union {
    text { ttf "timrom.ttf" "Sit" 1, .2*x  translate < -.5, .5, 0 >}
    text { ttf "timrom.ttf" "Coms" 1, .2*x  translate < -1.2, -.5, 0 >}
    translate < 0, 1, 0 >
    scale <.45,.45, .2>
    texture {SitTex }
  }
  object { Cube }
}

#include "tv.inc"
#declare TV2 = union {  object { TV }  object { OJ scale .9 }}

#include "tv.inc"
#declare TV3 = union { object { TV }  object { Info scale .9  }}

#include "tv.inc"
#declare TV4 = union { object { TV }  object { Game scale .95  }}

#include "tv.inc"
#declare TV5 = union {  object { TV }  object { Talk scale .9 }}

#include "tv.inc"
#declare TV6 = union {  object { TV }  object { Shock scale .9 }}

#include "tv.inc"
#declare TV7 = union {  object { TV }  object { Soaps scale .9 }}

#include "tv.inc"
#declare TV10 = union {  object { TV }  object { SitCom scale .9 }}

#include "tv.inc"
#declare TV8 = object { TV }
#declare DTV = seed(169)

#declare DeadTVs =
union {
#declare X = -150 #while ( X <= 150)
#include "tv.inc"
union {
  object { TV }
  object { Cube scale .95 }
  rotate < rand(DTV )*360, rand(DTV )*360,0>
  translate < X, -4.5, rand(DTV )*75 + 75>
}
#declare X = X + 10 #end
}
#ifdef (Local)
//  object { TV2 scale 4 rotate < 0, 0, 0> translate < 0, 4, 0 >}
//  object { Glob }
//  object { TV3 rotate < 0, 0, 0> scale 3 translate < 0, 5, 0 >}
//  object { TV4 rotate < 0, 0, 0> scale 3 translate < -3, 7, 0 >}
//  object { TV5 rotate < 0, 0, 0> scale 3 translate < 3, 7, 0 >}
//  object { TV6 rotate < 0, 0, 0> scale 3 translate < 3, 7, 0 >}
//  object { TV7 rotate < 0, 0, 0> scale 3 translate < 3, 7, 0 >}
  object { TV10 rotate < 0, 0, 0> scale 3 translate < 3, 7, 0 >}
//  object { DeadTVs }
#end
