#include "statue.inc"

//A nice dark background
background { color rgb <0.13,0.14,0.19> }

camera {
  location <10.6,16,-8>
  look_at <-1.5,4,20>
}

// Some light
light_source {
  <300,2000,5000>
  color rgb .5
  spotlight
  point_at <0,0,8>
  radius 30
  falloff 5
}

// This is a texture for the NICE checkered floor
#declare T1=
pigment {
  marble
  turbulence 1.18
  omega 0.65
  color_map {
    [0 color rgb <0.5,0.8,0.78>]
    [1 color rgb <0.32,0.61,0.59>]
  }
}

// Another (look above)
#declare T2=
pigment {
  marble
  turbulence 1.2
  omega 0.7
  color_map {
    [0 color rgb <0.4,0.6,0.62>]
    [1 color rgb <0.2,0.42,0.39>]
  }
}

// The actual Floortexture
#declare Mrblfloor=
texture {
  pigment {
    brick
    pigment { color rgb 0.8 },
    pigment {
      checker
      pigment { T1 },pigment { T2 }
      scale 2
      translate <0,0,1>
    }
  brick_size <2,0.5,2>
  mortar 0.05
  }
  normal {
    brick 1
    brick_size <2,1,2>
    mortar 0.05
  }
  finish {
    ambient 0.25 diffuse 0.55
    reflection 0.23
    brilliance 1.5
    specular 0.3 roughness 0.1
  }
}

// Here comes the floor
intersection {
  plane {
    y,0
    texture { Mrblfloor }
  }
  box {
    <-20,-1,-30>,<20,1,50>
    pigment { color rgb 0.3 }
  }
}

// A bumped texture for the walls
#declare WallT=
texture {
  pigment {
    granite
    turbulence 0.5
    color_map {
      [0 color rgb <0.9,0.9,0.9>]
      [1 color rgb <0.8,0.77,0.75>]
    }
  }
  normal {
    bumps 0.1
    turbulence 0.7
    scale 0.4
  }
  finish {
    ambient 0.1 diffuse 0.6
  }
}

#declare Dwood=
texture {
  pigment {
    wood
    turbulence 0.05
    frequency 2
    color_map {
      [0 color rgb <0.7,0.5,0.2>]
      [1 color rgb <0.65,0.5,0.27>]
    }
  }
}

#declare Door =
difference {
  union {
    difference {
      difference {
        cylinder { <0,5,-0.1>,<0,5,1.1>,2.25 }
        box { <-2.26,5,-0.15>,<2.26,2.45,1.15> }
      }
      cylinder { <0,5,-0.15>,<0,5,1.15>,2 }
    }
    box { <-2.25,0.01,-0.1>,<-2,5,1.1> }
    box { <-0.25,0.01,-0.1>,<-0.01,7.05,1.1> }
    box { <-2,0.01,-0.1>,<-0.25,0.2,1.1> }
    box { <2.25,0.01,-0.1>,<2,5,1.1> }
    box { <0.25,0.01,-0.1>,<0.01,7.05,1.1> }
    box { <2,0.01,-0.1>,<0.25,0.2,1.1>}
    box { <2,0.2,0.2>,<-2,7.25,0.8> }
  }
  box { <0.01,0,-0.11>,<-0.01,7.26,1.11> }
  texture {Dwood}
}

// The actual walls
union {
  box {
    <-20,0,-30>,<20,20,-31>
  }
  box {
    <-20,0,-30>,<-21,20,50>
  }
  difference {
    box {
      <20,0,50>,<-20,20,51>
    }
    cylinder {
      <0,15,52>,<0,15,49>,3.6
    }
  }
  object { Door translate <0,0,49.5>}
  box {
    <20,0,50>,<21,20,-30>
  }
  box {
    <21,20,-31>,<-21,21,51>
  }
  hollow
  texture { WallT }
}

// A crappy glasstexture
#declare YGlass=
texture {
  pigment { color rgbt 1 }
  finish {
    ambient 0.1 diffuse 0.6
    reflection 0.05
    specular 0.1 roughness 0.1
    refraction 1 ior 1.5
  }
}

// A buildingblock for the window
#declare WBox=
box { <-3.6,-0.17,0>,<3.6,0.17,0.5> }

// Another 1
#declare Circ1=
difference {
  cylinder { <0,0,0>,<0,0,0.5>,1.25 }
  cylinder { <0,0,-1>,<0,0,1>,1.1 }
}

// The window itself
union {
  difference {
    union {
      object { WBox }
      object { WBox rotate z*37.5 }
      object { WBox rotate z*90 }
      object { WBox rotate -z*37.5 }
      cylinder { <0,0,0>,<0,0,0.5>,1 }
      object { Circ1 scale <1,0.8,1> translate <-2.3,0,0>}
      object { Circ1 scale <1,0.8,1> translate <2.3,0,0>}
      object { Circ1 scale <0.8,1,1> translate <0,2.3,0>}
      object { Circ1 scale <0.8,1,1> translate <0,-2.3,0>}
      object { Circ1 translate <1,1,0>}
      object { Circ1 translate <-1,1,0>}
      object { Circ1 translate <1,-1,0>}
      object { Circ1 translate <-1,-1,0>}
    }
    cylinder { <0,0,-1>,<0,0,1>,0.7 }
    cylinder { <0,0,-1>,<0,0,1>,3.6 inverse}
  }
  difference {
    cylinder { <0,0,-0.2>,<0,0,0.7>,3.8 }
    cylinder { <0,0,-1>,<0,0,1>,3.6 }
  }
  pigment { color rgb 0.6 }
  translate <0,15,50>
}

cylinder {
  <0,15,50.1>,<0,15,50.4>,3.6
  texture {YGlass}
}


// A texture .... duh
#declare LStone=
texture {
  pigment {
    granite
    turbulence 0.7
    omega 0.9
    color_map {
      [0 color rgb <0.8,0.8,0.8>]
      [0.3 color rgb <0.77,0.77,0.77>]
      [0.74 color rgb <0.85,0.85,0.88>]
      [1 color rgb <0.9,0.9,0.9>]
    }
  }
  normal {
    crackle 0.05
    turbulence 0.2
    scale 0.6
  }
  finish {
    ambient 0.25 diffuse 0.5
    specular 0.15 roughness 0.1
  }
}


// A column
#declare Pilar=
difference {
  union {
    box { <-0.8,0,-0.8>,<0.8,0.75,0.8> }
    difference {
      cylinder { <0,0,0>,<0,9,0>,0.55 }
      #declare Con=12
      #declare Count=0
      #while (Count<Con)
      union {
        cylinder { <0,0.8,-0.55>,<0,8.2,-0.55>,0.05 }
        sphere { <0,0.8,-0.55>,0.07 }
        sphere { <0,8.2,-0.55>,0.07 }
        rotate <0,(360/Con)*Count,0>
      }
      #declare Count=Count+1
      #end
    }
    box { <-0.8,9,-0.8>,<0.8,8.5,0.8> }
    difference {
      sphere { <0,0.75,0>,0.7 }
      plane { y,0.75 }
    }
    difference {
      sphere { <0,8.5,0>,0.7 }
      plane { y,8.5 inverse }
    }
  }
  cylinder { <-0.8,0,-0.8>,<-0.8,9,-0.8>,0.25 }
  cylinder { <-0.8,0,0.8>,<-0.8,9,0.8>,0.25 }
  cylinder { <0.8,0,0.8>,<0.8,9,0.8>,0.25 }
  cylinder { <0.8,0,-0.8>,<0.8,9,-0.8>,0.25 }
  texture { LStone }
}

// This places the columns
#declare Row=1
#while (Row<(60/5))
  object { Pilar translate <-10,0,-30+(5*Row)>}
  object { Pilar translate <10,0,-30+(5*Row)>}
  #declare Row=Row+1
#end

// The balconys
union {
  box { <-20,9,-30>,<-8.5,9.35,30> }
  box { <20,9,-30>,<8.5,9.35,30> }
  box { <-20,9.35,-30>,<-8.4,9.5,30.1> }
  box { <20,9.35,-30>,<8.4,9.5,30.1> }
  box { <-20,9,30.1>,<20,9.35,50> }
  box { <-20,9.35,30>,<20,9.5,50> }
  texture { WallT }
}

// Part of the balcony
#declare SP=
union {
  box { <-0.2,0,-0.2>,<0.2,0.2,0.2> }
  box { <-0.2,2,-0.2>,<0.2,2.2,0.2> }
  lathe {
    quadratic_spline
    7,
    <0,0.2>,<0.1,0.2>,<0.2,0.8>,
    <0.15,1>,<0.2,1.3>,<0.15,1.6>,
    <0.0,1.9>
  }
  texture { LStone }
}

// Another part of the balcony
#declare Row=1
#while (Row<30)
  object { SP translate <-8.65,9.5,-30+(2*Row)>}
  object { SP translate <8.65,9.5,-30+(2*Row)>}
  #declare Row=Row+1
#end
#declare X=1
#while (X<9)
  object { SP translate <-7.2+(2*X),9.5,30.25>}
  #declare X=X+1
#end

// Do i have to tell u what it is??????????
// Well OK, it's a wood texture --== ObVIoUsLY ==-- :)
#declare KWood=
texture {
  pigment {
    wood
    turbulence 0.07
    color_map {
      [0 color rgb <0.7,0.44,0.27>]
      [1 color rgb <0.5,0.3,0.18>]
    }
  }
  finish {
    ambient 0.18 diffuse 0.6
    reflection 0.12
    phong 0.2 phong_size 10
    specular 0.8 roughness 0.1
  }
  rotate <95,90,0>
  scale 0.3
}

// Still a part of the balcony
#declare Kaid=
union {
  box { <-0.15,-0.1,-30>,<0.15,0.07,30> }
  cylinder {
    <0,0,-30>,<0,0,30>,0.17
    scale <1,0.55,1>
  }
  cylinder {
    <-0.15,-0.08,-30>,<-0.15,-0.08,30>,0.1
    scale <1.2,1,1>
  }
  cylinder {
    <0.15,-0.08,-30>,<0.15,-0.08,30>,0.1
    scale <1.2,1,1>
  }
  texture {KWood}
}
object { Kaid translate <-8.65,11.73,0> }
object { Kaid translate <8.65,11.73,0> }

// This falls in to the category balcony
union {
  cylinder {
    <-8.65,0,0>,<8.65,0,0>,0.1
    scale <1,0.55,1>
  }
  box { <-8.65,-0.1,-0.15>,<8.65,0.07,0.15> }
  cylinder {
    <-8.65,-0.08,-0.15>,<8.65,-0.08,-0.15>,0.1
    scale <1,1,1.2>
  }
  cylinder {
    <-8.65,-0.08,0.15>,<8.65,-0.08,0.15>,0.1
    scale <1,1,1.2>
  }
  texture { KWood}
  translate <0,11.73,30.25>
}

// The stonepilars near the window (or something)
difference {
  box { <-8.4,0,30>,<-9.65,20,31.25> }
  cylinder { <-8.4,0,30>,<-8.4,20,30>,0.1 }
  cylinder { <-8.4,0,31.25>,<-8.4,20,31.25>,0.1 }
  cylinder { <-9.65,0,30>,<-9.65,20,30>,0.1 }
  cylinder { <-9.65,0,31.25>,<-9.65,20,31.25>,0.1 }
  #declare r=0.08
  #declare Y=0
  #while (Y<20)
  cylinder { <-8.4,Y,30>,<-9.65,Y,30>,r }
  cylinder { <-8.4,Y,30>,<-8.4,Y,31.25>,r }
  cylinder { <-8.4,Y,31.25>,<-9.65,Y,31.25>,r }
  cylinder { <-9.65,Y,30>,<-9.65,Y,31.25>,r }
  #declare Y=Y+2
  #end
  texture { LStone }
}
difference {
  box{ <8.4,0,30>,<9.65,20,31.25> }
  cylinder { <8.4,0,30>,<8.4,20,30>,0.1 }
  cylinder { <8.4,0,31.25>,<8.4,20,31.25>,0.1 }
  cylinder { <9.65,0,30>,<9.65,20,30>,0.1 }
  cylinder { <9.65,0,31.25>,<9.65,20,31.25>,0.1 }
  #declare Y=0
  #while (Y<20)
  cylinder { <8.4,Y,30>,<9.65,Y,30>,r }
  cylinder { <8.4,Y,30>,<8.4,Y,31.25>,r }
  cylinder { <8.4,Y,31.25>,<9.65,Y,31.25>,r }
  cylinder { <9.65,Y,30>,<9.65,Y,31.25>,r }
  #declare Y=Y+2
  #end
  texture { LStone }
}


// Some snow... mmmmm, it looks good.What?!?!?!?! you don't like it ?!?!?!
#declare Snow=texture{pigment{color rgb 1.5} finish { ambient 0.8 diffuse 0.1 }}
#declare Xs=seed(02)
#declare Ys=seed(11)
#declare Zs=seed(1981)
#declare SN=0
#while (SN<400)
  sphere { <-15+(rand(Xs)*30),18-(rand(Ys)*12),80-(rand(Zs)*28)>,0.02+(rand(Zs)*.07) texture {Snow}}
  #declare SN=SN+1
#end

// Now some candles .. . . . .  .  .   .   .   .   .    .     .
#declare Holder =
union {
  intersection {
    torus { 0.67,0.03 rotate x*90 translate <0,0.7,0>}
    box { <0,0,0.1>,<0.7,0.7,-0.1>}
  }
  difference {
    sphere { <0,0,0>,0.09 scale <1,0.65,1> }
    box { <-0.1,0,-0.1>,<0.1,0.1,0.1> }
    translate <0.67,0.76,0>
  }
  cylinder { <0.67,0.76,0>,<0.67,0.77,0>,0.15 }
}

#declare Fire=
texture {
  pigment { color rgbt <1,1,1,1> }
  halo {
    spherical_mapping
    linear
    samples 10
    aa_level 2
    aa_threshold 0.2
    turbulence <0.1,0.1,0.1>
    omega 0.2
    color_map {
      [0 color rgbt <1,.5,0,1>]
      [0.05 color rgbt <1,1,.4,0.2>]
      [0.3 color rgbt <1,1,1,-1>]
      [0.7 color rgbt <1.2,1.2,1,-1>]
      [0.8 color rgbt <0.2,0.3,1,0.3>]
      [1 color rgbt <0,0,0,1>]
    }
  }
  finish { ambient 0.4 }
  scale <0.35,0.8,0.35>
  translate <0,-0.3,0>
}


#declare Flame=
sphere {
  <0,0,0>,0.5
  texture { Fire }
  hollow
  scale <0.5,1,0.5>
}

#declare CS1=seed(81)
#declare C_Rad=0.07
#declare C_Scale=1

#declare BWhite=
texture {
  pigment { color rgb <1,1,1> }
  finish {
    ambient 0.4 diffuse 0.45
    phong 0.5 phong_size 30
  }
}

#declare CHrt=
texture {
  pigment { color rgb <.3,.3,.3> }
  finish {
    ambient 0.1 diffuse 0.6
  }
}

#declare CS=seed(81)
#declare Loop=0
#while (Loop<21)
union {
  difference {
    cylinder { <0,0,0>,<0,0,-0.075>,0.6 scale <0.65,1,1> }
    torus { 0.47,0.07 rotate x*90 scale <0.65,1,0.2> translate <0,0,-0.075> }
  }
  cylinder { <0,-0.1,-0.075>,<0,-0.1,-0.5>,0.08 }
  sphere { <0,-0.1,-0.6>,0.13 }
  union {
    object { Holder rotate y*40 }
    object { Holder rotate y*90 }
    object { Holder rotate y*140 }
    #declare Cand=0
    #while (Cand<3)
      #declare Len=rand(CS)
      union {
        cylinder {<0,0,0>,<0,0.4+(Len*0.6),0>,0.075 texture {BWhite}}
        cylinder {<0,0.4+(Len*0.6),0>,<0,0.4+(Len*0.8),0>,0.01 texture {CHrt}}
        object { Flame scale 0.2+rand(CS)*0.2 translate <0,0.4+(Len*0.8)+0.1,0> }
        light_source {
          <0,0.4+(Len*0.9)+0.15,0>
          color rgb <0.3,0.25,0.1>
          fade_power 1
          fade_distance 2
        }
        translate <0.67,0.75,0>
        rotate <0,40+(50*Cand),0>
      }
      #declare Cand=Cand+1
    #end
    translate <0,-0.15,-0.6>
  }
  pigment { color rgb <.8,.8,0.6> }
  finish {
    ambient 0.17 diffuse 0.5
    reflection 0.35
    specular 0.7 roughness 0.05
    brilliance 1.5
    metallic
  }
  #switch (Loop)
    #range (0,4)
      rotate <0,-90,0>
      translate <-20,14,-20+(15*Loop)>
    #break
    #range (5,8)
      rotate <0,-90,0>
      translate <-20,4.5,-20+(15*(Loop-4))>
    #break
    #range (9,12)
      rotate <0,90,0>
      translate <20,14,-20+(15*(Loop-8))>
    #break
    #range (13,16)
      rotate <0,90,0>
      translate <20,4.5,-20+(15*(Loop-12))>
    #break
    #range (17,18)
      translate <-9.025+(18.05*(Loop-17)),6,30>
    #break
    #range (19,20)
      translate <-9.025+(18.05*(Loop-19)),15,30>
    #break
  #end
}
#declare Loop=Loop+1
#end


// A broken statue 
object { Statue scale 1.2 translate <0,0,15>}


