
// Glenn's "Cinema" POV-Ray Scene File
// created 4-Oct-97 for the Sep/Oct 1997 Internet Ray Tracing Competition
// at http://www.irtc.org
// last update 27-Oct-97
// copyright 1997 Glenn McCarter gmccarter@hotmail.com

// A cinema showing a feature film.

// NOTE: these files have many embedded tabs.
// To best viewing, use the POV-Ray for Windows editor,
// and set Editor | Tabs | Real Tabs, with tab size 2.

#include "colors.inc"
#include "shapes.inc"
//#include "shapes2.inc"
#include "textures.inc"
#include "GIncludeRH.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
/*   // Focal Blur section: uncomment to enable focal blur
  blur_samples 6
  aperture .05    //lower value = wider range in focus
  focal_point <0,0,0>
	confidence .995
	variance 1/128
*/   // end focal blur
//  location  <-18*Feet, 1.5*Feet, 3>
//  look_at   <0, 0, 4.0*Feet>
//  angle 50
//  location  <-23*Feet, 1.5*Feet, 2*Feet> // almost straight-on view
//  look_at   <0, 2, 4.0*Feet>
//  angle 40
//  look_at   <0, 0, 1.0*Feet> // test exit sign
//  location  <-14*Feet, 7*Feet, 0*Feet> // too angled view
//  look_at   <0, 18, 3.5*Feet>
//  angle 50
//  location  <-16*Feet, 3*Feet, 0*Feet> // slight angled view, from below
//  look_at   <0, 8, 3.8*Feet>
//  angle 52
  location  <-18*Feet, 3*Feet, 3*Feet> // slight angled view, centered (render)
//  look_at   <0, 8, 3.8*Feet>
  look_at   <0, 7, 3.8*Feet> // a bit more to the right
  angle 50
//  location  <-38*Feet, 5*Feet, 7*Feet> // further back
//  look_at   <0, 8, 3.8*Feet>
//  angle 25
}

camera {
    Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare ScreenTex =
	texture {
		pigment { color rgb<0.4,0.4,0.4> }
		normal { bumps 0.2 scale .1 }
		finish { ambient .01 specular .7 roughness .1 }
	}
#declare SatinRed =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.0  color rgb<0.60,0.04,0.01> ]
				[ 0.5  color rgb<0.80,0.10,0.06> ]
				[ 1.0  color rgb<0.60,0.04,0.02> ]
			}
			scale <1,1,1.2>
		}
		normal { bumps 0.1 scale 4 }
		finish { ambient .01 specular .13 roughness .012 }
	}

#declare StageTex =
	texture {
		pigment { color rgb<.07,.08,.03> }
		normal { bumps 0.1 scale .5 }
		finish { ambient .01 specular .2 roughness .02 }
	}

#declare ExitSignRed =
	texture {
		pigment { color rgb<.9,.12,.01> }
		finish { ambient .8 }
	}
#declare ExitSignBoxTex =
	texture {
		pigment { color rgb<.24,.25,.25> }
		finish { ambient .01 specular .3 roughness .02 }
	}


//===============================================
//             Lighting
//===============================================

#declare ProjectorLoc = <-40*Feet, 0, 10*Feet>
#declare ProjectionLight =
  light_source {
    ProjectorLoc
    colour rgb <1.13,1.09,1.00>*19 // larger multiplier increases
//    colour rgb <1.13,1.09,1.00>*6 // larger multiplier increases
//    colour rgb <1.13,1.09,1.00>*1.3 // larger multiplier increases
//    colour rgb <1.13,1.09,1.00>*.7 // larger multiplier increases
		// image brightness, but also "washes out" image -- loses contrast
    spotlight
    point_at <0, 0, 5*Feet>
    radius 16    // degrees fully lit (*2)
    falloff 24   // degrees no lighting (*2)
    tightness 1
		fade_distance 36*Feet
//		fade_distance 8*Feet
		fade_power 1
		atmosphere on
		atmospheric_attenuation off
  }
#declare ScreenLight = // illuminates the screen
  light_source {
    ProjectorLoc+<0,0,10>
    colour rgb <1.13,1.09,1.00>*13 // larger multiplier increases
//    colour rgb <1.13,1.09,1.00>*6 // larger multiplier increases
//    colour rgb <1.13,1.09,1.00>*1.3 // larger multiplier increases
//    colour rgb <1.13,1.09,1.00>*.7 // larger multiplier increases
		// image brightness, but also "washes out" image -- loses contrast
		fade_distance 36*Feet
//		fade_distance .8*Feet
		fade_power 1
		atmosphere off
		atmospheric_attenuation off
  }
#declare ProjectionMask =
	difference {
		box {
			<0,-8,-8>,<.01,8,8>
			texture { pigment { color rgb<0,0,0> } }
		}
		box { // hole cutout
			<-.5,-.5,-.5>,<.5,.5,.5>
			texture { pigment { color rgbf<1,1,1,1> } }
			scale <1,5,2.5>
		}
	} // end difference
#declare SepiaFilter =
	box {
		<0,-10,-10>,<.01,10,10>
//		texture { pigment { color rgbf<1.0,0.6,0.0,0.98> } } // too deep rich
		texture { pigment { color rgbf<1.06,1.04,1.00,0.96> } } // very slight tint
//		texture { pigment { color rgbf<1.2,1.1,1.0,1.0> } } // slight tint
//		texture { pigment { color rgbf<0.8,0.8,0.7,1.30> } } // deeper
//		texture {	pigment { color rgbf<1.4,1.4,1.2,1.0> } } // too bright, more yellowish
	}

#declare StrayLight =
  light_source {
    ProjectorLoc+<0,0,-12>
//    colour rgb <1.0,1.0,1.0>*.36 // dim
    colour rgb <1.0,1.0,1.0>*0.6 // bright
    spotlight
    point_at <0, 0, 5*Feet>
    radius 16    // degrees fully lit (*2)
    falloff 24   // degrees no lighting (*2)
    tightness 1
		fade_distance 36*Feet
		fade_power 1
		atmosphere off
  }
#declare StrayLightMask = // prevents stray light from washing out the screen
	box {
		<0,-.8,-.5>,<.01,.8,.5>
		texture { pigment { color rgb<0,0,0> } }
	}

// Test Lights
//object { StdBulb100Watt translate <-28*Feet,48,8*Feet> } // illum near scene


//===============================================
//             Environment
//===============================================

background { color rgb <0.03, 0.01, 0.01> }

atmosphere {
	type 1
		samples 120
		distance 300
		scattering 0.0005 // very little
//		scattering 0.001 // ok
//		scattering 0.05 // much too severe
	}



//===============================================
//             Variables
//===============================================


//===============================================
//             Objects
//===============================================

#declare BlankScreen =
	box {
		<0,0,0>,<1,16*Feet,10*Feet>
		texture { ScreenTex }
		translate <0,-8*Feet,0>
	}

#declare ScreenWithMovie =
	box {
		<0,0,0>,<1,16*Feet,10*Feet>
		texture { ScreenTex }
		texture {
		  pigment {
					image_map { // XY plane, from 0 to 1
					tga "Color13.tga" // movie frame
					once
					}
			}
			scale <16.4*Feet,8.65*Feet,1> rotate <90,0,-90> translate <0,16.2*Feet,0.0*Feet>
//			scale <10.4*Feet,5.65*Feet,1> rotate <90,0,-90> translate <0,12.2*Feet,1.0*Feet> // small test
			finish { ambient .004 }
		}
		translate <0,-8*Feet,0>
	}

#declare FilmWidth = 1.6
#declare FilmHeight = 1.0
#declare Film =
	box {
		<0,0,0>,<.001,FilmWidth,FilmHeight>
		texture { pigment { color rgbt<1,1,1,1> } } // make it clear
		texture {
		  pigment {
					image_map { // XY plane, from 0 to 1
//					png "13maskR.png" // movie frame mask negative
					png "13transp.png" // movie frame mask negative
					once
					}
			}
			scale <FilmWidth,FilmHeight,1> rotate <90,0,-90> translate <0,FilmWidth,0>
			finish { ambient .004 }
		}
		translate <0,-FilmWidth/2,-FilmHeight/2> // center frame
	}

#declare BackWall =
	union {
		box {
			<0,-2*Feet,0>,<1,20*Feet,12*Feet>
			texture { StageTex }
			texture {
			  pigment {
						image_map { // XY plane, from 0 to 1
						tga "Color11.tga" // movie frame
						once
						}
				}
				scale <16.6*Feet,8.7*Feet,1> rotate <90,0,-90> translate <0,16.3*Feet,0.0*Feet>
				finish { ambient .4 }
			}
		}
		box { // dims the image
			<-.1,-2*Feet,0>,<.1,20*Feet,12*Feet>
			texture { pigment { color rgbf<.13,.13,.13,1.0> } }
//			texture { pigment { color rgbf<.53,.53,.53,1.0> } }
		}
		translate <0,-8*Feet,0>
	} // end union

#declare CurtainMain =
	#include "CURTAIN3.POV"
	object { CurtainSurf
		scale <4,12,6>
		rotate <90,0,90>
		texture { SatinRed }
	}
#declare CurtainHem =
	object { CurtainSurf
		scale <4,12,6>
		rotate <90,0,90>
		texture { SatinRed }
		clipped_by { box { <-6,-5*Feet,-28>,<6,5*Feet,-20> } }
	}
#declare UpperCurtain = // origin at top edge
	union {

		object { CurtainMain translate <0,0*Feet,0> }
		object { CurtainMain translate <0,-5.93*Feet,0> }
		object { CurtainMain translate <0,6.0*Feet,0> }
/*
		object { CurtainHem translate <-0.4,0*Feet,-.4> }
		object { CurtainHem translate <-0.4,-5.93*Feet,-.4> }
		object { CurtainHem translate <-0.4,6.0*Feet,-.4> }
*/
//	rotate <0,180,0> // put hem at bottom
	}

#declare ExitSign =
	union {
		box {
			<0,0,0>,<5,16,12>
			texture { ExitSignBoxTex }
			translate <0,-8,0>
		}
		text {
			// NOTE: in RH reference system, the FRONT FACE
			// of text is extruded into +Z
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"EXIT",
			0.4,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { ExitSignRed }
			scale <5,8,1>
			rotate <90,0,0> // upright into +Z
			rotate <0,0,-90> // along YZ plane
			translate <0.2,5,3.0>
		}
		text {
			// NOTE: in RH reference system, the FRONT FACE
			// of text is extruded into +Z
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"COPYRIGHT 1997",
			0.4,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { ExitSignRed }
			scale <1.5,1.5,1>
			rotate <90,0,0> // upright into +Z
			rotate <0,0,-90> // along YZ plane
			translate <0.2,6,0.8>
		}
		text {
			// NOTE: in RH reference system, the FRONT FACE
			// of text is extruded into +Z
			ttf "c:\Windows\Fonts\ARIAL.TTF",
			"GLENN MCCARTER",
			0.4,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { ExitSignRed }
			scale <1.4,1.5,1>
			rotate <90,0,0> // upright into +Z
			rotate <0,0,-90> // along YZ plane
			translate <0.2,6,9.8>
		}
		scale .8 // make it a little smaller
	} // end union

#declare SlotGroup =
	union {
		#declare SlotCount = 0
		#while ( SlotCount < 13 )
			box {
				<-1,0,0>,<9,3.3*Feet,0.8>
				translate <0,0,3*Feet+SlotCount*1.8>
			}
			#declare SlotCount = SlotCount + 1
		#end
		texture { StageTex }
	} // end union
#declare AirConditioner = // origin at center ground front face
	difference {
		box { // main
			<0,0,0>,<2*Feet,8*Feet,5.2*Feet>
			texture { StageTex }
		}
		object { SlotGroup translate <0,0.4*Feet,0> }
		object { SlotGroup translate <0,4.3*Feet,0> }
		translate <0,-3*Feet,0>
	} // end union

#declare TestBox =
		#declare Roundness = .4 // range 0 to .5, larger = more rounded
		object { RoundedBox
			scale <1*Feet,3*Feet,9>
			texture { pigment {color rgb<.8,.8,.6> } }
		}

#declare Stage = // origin at top center front edge
	union {
		box { // main
			<0,0,-6*Feet>,<3*Feet,18*Feet,-.5>
			texture { StageTex }
			translate <0,-9*Feet,0>
		}
		cylinder { // front edge
			<0,0,0>,<0,18*Feet,0>,2
			texture { StageTex }
			translate <0,-9*Feet,-2>
		}
		object { ExitSign translate <-4,-5.5*Feet,-13> }
		object { AirConditioner translate <-1*Feet,6*Feet,-6*Feet> }

	} // end union

//===============================================
//             Object Transformations
//===============================================




//===============================================
//             Object Placement
//===============================================


object { ProjectionLight } // shines thru the film
object {
	ProjectionMask // restricts ProjectionLight to shine only on screen
		translate <1*Feet,0,0> // move in front of lightsource
		rotate <0,8,0> // point at screen
		translate ProjectorLoc // attach to projector
}
object { Film // makes light beams in the atmosphere
	scale <1,1.02,0.86>
	translate <4,0,0> // move away from lightsource
	rotate <0,8.1,0> // point at screen
	translate ProjectorLoc // attach to projector
}
object { SepiaFilter // tints the image a little bit
	translate ProjectorLoc+<6,0,0>
}
object { ScreenLight } // illuminates the screen
object {
	ProjectionMask // restricts ScreennLight to shine only on screen
		translate <1*Feet,0,0> // move in front of lightsource
		rotate <0,9.2,0> // point at screen
		translate ProjectorLoc+<0,0,10> // attach to projector
}

object { StrayLight } // illuminates the curtains
object {
	StrayLightMask // prevents stray light from washing out the screen
		scale <1,1.2,1>
		translate <4.5,0,0> // move away from lightsource
		rotate <0,6.85,0> // point at screen
		translate ProjectorLoc+<0,0,-12> // attach to StrayLight
}

object { ScreenWithMovie }
object { UpperCurtain translate <-6,0,10.65*Feet> }
object { Stage translate <-2*Feet,0,0> }
object { BackWall translate <6,0,0> }

// TEST OBJECTS - DO NOT RENDER
//object { TestSphere scale 29 translate <0,10,0> }
//object { TestBox rotate <12,12,12> translate <-4*Feet,0,2*Feet> }
//object { TestBox scale 10 rotate <2,2,2> translate <-8*Feet,2*Feet,2*Feet> }
//object { BlankScreen }
//object { Film scale 10 translate <-15*Feet, 2*Feet, 3*Feet> } // camera location test
//object { UpperCurtain rotate <0,60,0> translate <-8,0,8*Feet> } // test

