
// Glenn's City Buildings POV-Ray Object File
// This file does not render.  #include "CityBuildings.inc" in another .pov file
// first concept 19-Sep-97  last update 20-Oct-97
// copyright 1997 Glenn McCarter

// A collection of old building fronts from a small city
// Intended scale is English system (inches)
// origin at ground level, at LH edge of building face.  Building extends into +Y
// Uses RH coord system

//===============================================
//             Textures
//===============================================

#declare Grey10 =
	texture {
		pigment { color rgb<.1,.1,.1> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey20 =
	texture {
		pigment { color rgb<.2,.2,.2> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey30 =
	texture {
		pigment { color rgb<.3,.3,.3> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey40 =
	texture {
		pigment { color rgb<.420,.416,.425> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey50 =
	texture {
		pigment { color rgb<.5,.5,.5> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey80 =
	texture {
		pigment { color rgb<.83,.83,.80> }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare Grey90 =
	texture {
		pigment { color rgb<.92,.92,.90> }
		finish { ambient .02 specular .8 roughness .005 }
	}
#declare GreyStucco =
	texture {
		pigment { color rgb<.205,.208,.200> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .3 roughness .08 }
	}
#declare GreyBricks1 = // small size
	texture {
		pigment {
			brick color rgb<.060,.056,.067>, color rgb<.426,.422,.409> //mortar,brick
				brick_size <8,8,2.2>   // size of brick
				mortar 0.46       // width of mortar
//				rotate x*90
			}
		finish { ambient .02 specular .3 roughness .08 }
	}
#declare GreyTin20 =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0  color rgb<0.24,0.34,0.21> ]
				[ 0.5  color rgb<0.55,0.54,0.55> ]
				[ 1.0  color rgb<0.48,0.44,0.49> ]
			}
			scale <.09,.09,.52>
		}
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .95 roughness .005 metallic brilliance 3 }
	}
#declare GreyBricks2 = // large size, brighter
	texture {
		pigment {
			brick color rgb<.34,.34,.34>, color rgb<.62,.60,.60> //mortar,brick
				brick_size <22,22,10>   // size of brick
				mortar 1.2       // width of mortar
//				rotate x*90
			}
		finish { ambient .02 specular .3 roughness .08 }
	}
#declare GreyStone20 =
	texture {
		pigment { granite
			color_map {
				[ 0.0  color rgb<0.078,0.070,0.065> ]
				[ 0.5  color rgb<0.156,0.18,0.158> ]
				[ 0.8  color rgb<0.235,0.246,0.250> ]
				[ 1.0  color rgb<0.156,0.158,0.151> ]
			}
		}
		normal { bumps 0.3 }
		finish { ambient .02 specular .7 roughness .095 }
	}
#declare GreyStone30 =
	texture {
		pigment { granite
			color_map {
				[ 0.0  color rgb<0.12,0.13,0.10> ]
				[ 0.5  color rgb<0.25,0.24,0.25> ]
				[ 1.0  color rgb<0.380,0.384,0.379> ]
			}
		}
		normal { bumps 0.2 }
		finish { ambient .02 specular .6 roughness .095 }
	}
#declare GreyStone40 =
	texture {
		pigment { granite
			color_map {
				[ 0.0  color rgb<0.21,0.23,0.20> ]
				[ 0.5  color rgb<0.35,0.38,0.36> ]
				[ 1.0  color rgb<0.51,0.53,0.52> ]
			}
		}
		normal { bumps 0.2 }
		finish { ambient .02 specular .44 roughness .095 }
	}
#declare GreyStone50 =
	texture {
		pigment { granite
			color_map {
				[ 0.0  color rgb<0.32,0.33,0.34> ]
				[ 0.5  color rgb<0.45,0.44,0.45> ]
				[ 1.0  color rgb<0.58,0.59,0.62> ]
			}
		}
		normal { bumps 0.34 }
		finish { ambient .02 specular .34 roughness .095 }
	}
#declare JustGlass =
	texture {
		pigment { color rgbf<1,1,1,.9> }
		finish { ambient .02 reflection .4 }
	}

#switch ( Wet )
#case (1) // make the textures wet
	#declare BumpySideWalkTex = // wet
		texture {
			pigment { color rgb<.156,.152,.143> }
			normal { bumps 0.4 scale 1.3/9 } // final size will be 9...
			finish { ambient .02 reflection .6 }
		}
	#declare ShinySideWalkTex = // wet
		texture {
			pigment { color rgb<.156,.152,.143> }
			normal { bumps 0.08 scale 4/9 } // final size will be 9...
			finish { ambient .02 reflection .6 }
		}
	#declare SideWalkTex = // wet
		texture {
			bozo
			texture_map {
				[ 0.00 BumpySideWalkTex ]
				[ 0.70 BumpySideWalkTex ]
				[ 0.80 ShinySideWalkTex ]
				[ 1.00 ShinySideWalkTex ]
			}
			scale 9
		}
	#declare BumpyCurbTex = // wet
		texture {
			pigment { color rgb<.213,.213,.206> }
			normal { bumps 0.4 scale 1.3/9 }
			finish { ambient .02 reflection .6 }
		}
	#declare ShinyCurbTex = // wet
		texture {
			pigment { color rgb<.213,.213,.206> }
			normal { bumps 0.08 scale 4/9 }
			finish { ambient .02 reflection .6 }
		}
	#declare CurbTex = // wet
		texture {
			bozo
			texture_map {
				[ 0.00 BumpyCurbTex ]
				[ 0.70 BumpyCurbTex ]
				[ 0.80 ShinyCurbTex ]
				[ 1.00 ShinyCurbTex ]
			}
			scale 9
		}
	#declare BumpyBlackTopTex = // wet
		texture {
			pigment { color rgb<.10,.10,.10> }
			normal { bumps 0.4 scale 0.3/9 }
			finish { ambient .02 reflection .6 }
		}
	#declare ShinyBlackTopTex = // wet
		texture {
			pigment { color rgb<.10,.10,.10> }
			normal { bumps 0.06 scale 1.6/9 }
			finish { ambient .02 reflection .6 }
		}
	#declare BlackTopTex = // wet
		texture {
			bozo
			texture_map {
				[ 0.00 BumpyBlackTopTex ]
				[ 0.70 BumpyBlackTopTex ]
				[ 0.80 ShinyBlackTopTex ]
				[ 1.00 ShinyBlackTopTex ]
			}
			scale 9
		}
	#declare GratingTex =
		texture {
			pigment { color rgb<.2,.2,.2> }
			normal { bumps 0.2 scale 1 }
			finish { ambient .02 specular .8 roughness .005 reflection .4 }
		}
#break
#else
	#declare SideWalkTex = // dry
		texture {
			pigment { color rgb<.53,.52,.50> }
			finish { ambient .02 }
		}
	#declare CurbTex = // dry
		texture {
			pigment { color rgb<.64,.64,.62> }
			finish { ambient .02 }
		}
	#declare BlackTopTex = // dry
		texture {
			pigment { color rgb<.107,.106,.108> }
			normal { bumps 0.4 scale 0.3 }
			finish { ambient .02 }
		}
#declare GratingTex =
	texture {
		pigment { color rgb<.2,.2,.2> }
		normal { bumps 0.2 scale 1 }
		finish { ambient .02 specular .8 roughness .005 }
	}
#end

#declare RustyIron =
	texture {
		pigment {
			agate
			color_map {
				[0.00 color rgb<.20,.13,.28> ] // iron
				[0.45 color rgb<.26,.18,.08> ] // light rust
				[0.50 color rgb<.09,.03,.01> ] // dark rust
				[0.55 color rgb<.26,.18,.08> ] // light rust
				[1.00 color rgb<.20,.13,.28> ] // iron
			}
			scale .3
		}
		finish { specular .1 roughness .14 }
	}

#declare GreyRust =
	texture {
		pigment {
			agate
			color_map {
				[0.00 color rgb<.20,.19,.21> ] // iron
				[0.45 color rgb<.16,.13,.11> ] // light rust
				[0.50 color rgb<.04,.03,.04> ] // dark rust
				[0.55 color rgb<.16,.13,.11> ] // light rust
				[1.00 color rgb<.20,.19,.21> ] // iron
			}
			scale .3
		}
		finish { ambient .02 specular .1 roughness .14 }
	}

//===============================================
//             Objects
//===============================================

#declare GlassDoor =
	union {
		difference {
			box { // frame outer
				<0,0,0>,<3.5*Feet,1.5,7*Feet>
				texture { Grey80 }
			}
			box { // frame inner
				<2,-1,5>,<3.5*Feet-2,6,7*Feet-4>
				texture { Grey80 }
			}
		} // end difference
		box { // cross bar
			<0,0,0>,<3.4*Feet,1,3>
			texture { Grey80 }
			translate <1.5,-.4,36>
		}
		box { // window glass
			<.5,.7,.5>,<3.5*Feet-.5,.9,7*Feet-.5>
			texture { JustGlass }
		}
	} // end union

#declare SideWalkPaving = // blacktop underlying
	box {
		<0,0,-1>,<100*Feet,18*Feet,-0.13>
		texture { BlackTopTex }
	}
#declare SideWalkBlock =
//	#declare Roundness = .3 // range 0 to .5, larger = more rounded
//	object { RoundedBox
		box { <0,-.5,-1>,<1,.5,0>
		scale <3*Feet,5*Feet,6>
		texture { SideWalkTex }
		translate <0,0,0>
	}
#declare SideWalkS = // simple version
	union {
		object { SideWalkPaving translate <0,-9.8*Feet,0> }
		#declare BlockCount = 0
		#while (BlockCount < 29 )
			object { SideWalkBlock translate <BlockCount*3.15*Feet,-4.5*Feet,0> }
		#declare BlockCount = BlockCount+1
		#end
		box { // curb
			<0,0,-5>,<88*Feet,-6,.4>
			texture { CurbTex }
			translate <0,-9.5*Feet,0>
		}
 		#declare Roundness = .3 // range 0 to .5, larger = more rounded
		object { RoundedBox // end square
			scale <12*Feet,46*Feet,6>
			texture { CurbTex }
			translate <-12*Feet/2-1,46*Feet/2-8.2*Feet,-3>
		}
	} // end union
#declare RS = seed(50495)
#declare SideWalk = // complex version
	union {
		object { SideWalkPaving translate <0,-9.8*Feet,0> }
		#declare BlockCount = 0
		#while (BlockCount < 29 )
			object { SideWalkBlock
				rotate <0,0,-0.5+rand(RS)*1> // randomize rotation
				translate <-0.3+rand(RS)*.6,-0.3+rand(RS)*.6,rand(RS)*.4> // randomize pos
				translate <BlockCount*3.15*Feet,-4.5*Feet,0> // position along walkway
			}
		#declare BlockCount = BlockCount+1
		#end
		box { // curb
			<0,0,-5>,<88*Feet,-6,.4>
			texture { CurbTex }
			translate <0,-9.5*Feet,0>
		}
 		#declare Roundness = .3 // range 0 to .5, larger = more rounded
		object { RoundedBox // end square
			scale <12*Feet,46*Feet,6>
			texture { CurbTex }
			translate <-12*Feet/2-1,46*Feet/2,-3.1>
			rotate z*-20
			translate <0,-9.5*Feet,0>
		}
	} // end union

#declare DownSpoutBracket =
	union {
		cylinder { // bracket ring
			<0,0,0>,<0,0,2>,3.3
			texture { Grey50 }
		}
		difference {
			box { // bracket extension
				<-3.3,0,0>,<3.3,8,2>
				texture { Grey50 }
			}
			box { // bracket hole
				<-3.0,-1,-1>,<3.0,9,3>
				texture { Grey50 }
			}
		} // end difference
		box { // bracket base
			<-4.6,5,0>,<4.6,8,2>
			texture { Grey50 }
		}
		sphere { // screw
			<0,0,0>,.2
			scale <1,.4,1>
			translate <-4,5,0>
			texture { GreyRust }
		}
		sphere { // screw
			<0,0,0>,.2
			scale <1,.4,1>
			translate <4,5,0>
			texture { GreyRust }
		}
	} // end union
#declare DownSpout =
	union {
		object { DownSpoutBracket translate <0,0,6*Feet> }
		object { DownSpoutBracket translate <0,0,14*Feet> }
		cylinder { // main spout
			<0,0,-6>,<0,0,24*Feet>,2.7
			texture { GreyRust }
		}
		cylinder { // bottom collector
			<0,0,-6>,<0,0,24>,3.7
			texture { GreyStone20 }
		}
		cylinder { // bottom collector top ring
			<0,0,23>,<0,0,24>,4.3
			texture { GreyStone30 }
		}
		cone { // bottom collector top ring
			<0,0,24>,4.3,<0,0,24.7>,3.9
			texture { GreyStone30 }
		}
	}

#declare Grating =
	difference {
		box { // main
			<0,0,-2>,<2*Feet,9,0>
			texture { GratingTex }
		}
		#declare SlotCount = 0
		#while ( SlotCount < 4 )
			box {
				<1,0,-3>,<11.5,1,1>
				texture { Grey10 }
				translate <0,SlotCount*2+1,0>
			}
			box {
				<12.5,0,-3>,<23,1,1>
				texture { Grey10 }
				translate <0,SlotCount*2+1,0>
			}
			#declare SlotCount = SlotCount + 1
		#end
	} // end difference
#declare GratingSteam =
	sphere { 0, 1
		texture {
			pigment { color rgbt <1, 1, 1, 1> }
			halo {
				attenuating
				spherical_mapping
				linear
				colour_map {
					[ 0.0 color rgbt <.8, .8, .8, 1.0> ] // transparent
					[ 0.3 color rgbt <.8, .8, .8, 1.0> ] // transparent
					[ 1.0 color rgbt <.8, .8, .8, 0.3> ] // saturated
				}
				turbulence <.3,.3,1>
				samples 10
				aa_level 5
				aa_threshold 0.1
				jitter 0.8
			}
				scale .6
		}
		hollow
		scale 1
	}

#declare GratingWithSteam =
	union {
		object { Grating }
		object { GratingSteam scale <12,12,24> rotate <38,10,0> translate <14,4.5,2>}
	}

#declare VentVane =
	union {
		box {
			<0,0,0>,<24,2,.1>
		}
		cylinder {
			<0,0,.05>,<24,0,.05>,.05
		}
	}
#declare Vent =
	union {
		difference {
			box { // outer
				<-1.5,-.3,0>,<25.5,1,10>
			}
			box { // inner
				<0,-1,1.5>,<24,3,9.5>
			}
		} // end difference
		object { VentVane rotate <65,0,0> translate <0,.2,2> }
		object { VentVane rotate <65,0,0> translate <0,.2,4> }
		object { VentVane rotate <65,0,0> translate <0,.2,6> }
		object { VentVane rotate <65,0,0> translate <0,.2,8> }
		object { VentVane rotate <65,0,0> translate <0,.2,10> }
		texture { Grey50 }
	} // end union

#declare GoodsInWindow =
	union {
		box { // lower shelf
			<0,0,-1>,<8*Feet,12,0>
			texture { Grey90 }
			translate <0,0,30>
		}
		box { // upper shelf
			<0,0,-1>,<8*Feet,12,0>
			texture { Grey90 }
			translate <0,0,48>
		}
		box {
			<0,0,0>,<14,6,5>
			texture { Grey30 }
			rotate z*8
			translate <6,2,30>
		}
		cylinder {
			<0,0,0>,<0,0,6>,2.3
			texture { Grey20 }
			translate <18,5,30>
		}
		cylinder {
			<0,0,0>,<0,0,8>,3.3
			texture { Grey40 }
			translate <28,7,30>
		}
		box {
			<0,0,0>,<8,6,3>
			texture { GreyStucco }
			rotate <15,0,0>
			translate <42,2,30>
		}
		cylinder {
			<0,0,0>,<0,0,4.5>,4.7
			texture { Grey80 }
			translate <22,6,48>
		}
		cylinder {
			<0,0,0>,<0,0,6>,2.7
			texture { Grey30 }
			translate <44,6,48>
		}
		box {
			<0,0,0>,<16,6,2.2>
			texture { Grey10 }
			rotate <5,0,0>
			translate <5*Feet,6,48>
		}
		box {
			<0,0,0>,<10,8,3>
			texture { Grey30 }
			rotate z*18
			translate <6.3*Feet,6,48>
		}
	}

//===============================================
//          Store 1
//          Corner store
//===============================================

#declare StoreS1 = // simple version
	union {
		difference {
			box { // outer shell
				<0,0,0>,<22*Feet,32*Feet,38*Feet>
				texture { GreyStucco }
			}
			box { // inner shell
				<8,8,8>,<22*Feet-8,32*Feet-8,38*Feet-8>
				texture { Grey80 }
			}
			box { // doorway
				<0,-1,0>,<3*Feet,12,7*Feet>
				texture { Grey20 }
				translate <2*Feet,0,0>
			}
			#declare Width=8*Feet
			#declare Height=5*Feet
			box { // picture window cutout
				<0,-1,0>,<Width,40,Height>
				texture { Grey50 }
				translate <8*Feet,0,2*Feet>
			}
			#declare RowCount = 0
			#while ( RowCount < 3 )
				#declare ColCount = 0
				#while ( ColCount < 4 )
					box { // window cutouts
						<0,0,0>,<26,20,50>
						texture { GreyBricks1 }
						translate <16+ColCount*4.8*Feet,-.1,12*Feet+RowCount*8.5*Feet>
					}
					#declare ColCount = ColCount + 1
				#end
			#declare RowCount = RowCount + 1
			#end
		} // end difference
		box { // all upper windows
			<0,0,0>,<21*Feet,31.8*Feet,27*Feet>
			texture { JustGlass }
			translate <6,1,10*Feet>
		}
		box { // doorway lintel
			<0,0,0>,<42,20,6>
			texture { GreyStone40 }
			translate <2*Feet-3,-.5,6.9*Feet>
		}
		object { DownSpout rotate <0,0,-90> translate <-5,2*Feet,0> }
		object { GlassDoor translate <2*Feet,8,0> }
		#include "Windows.inc"
		object { BasicWindow translate <8*Feet,-1,2*Feet> }
		box { // sign in window
			<0,0,0>,<10,.1,20>
			texture { Grey80 }
			translate <8.5*Feet,5,5*Feet>
		}
		object { GoodsInWindow translate <8*Feet,6,0> }
		superellipsoid { // elec box in front
			<0.1,0.1>
			scale <9,4,15>
			texture { Grey50 }
			translate <20*Feet,-15,12>
		}
		superellipsoid { // elec box around corner
			<0.3,0.3>
			scale <12,5,22>
			texture { Grey10 }
			translate <-8,3*Feet,16>
		}
	}

//----------- Store1 (complex version) -------------------
#declare Store1 =
	union {
		difference {
			box { // outer shell
				<0,0,0>,<22*Feet,32*Feet,38*Feet>
				texture { GreyStucco }
			}
			box { // inner shell
				<8,8,8>,<22*Feet-8,32*Feet-8,38*Feet-8>
				texture { Grey80 }
			}
			box { // doorway
				<0,-1,0>,<3*Feet,12,7*Feet>
				texture { Grey20 }
				translate <2*Feet,0,0>
			}
			#declare Width=8*Feet // for Windows.inc
			#declare Height=5*Feet // for Windows.inc
			box { // picture window cutout
				<0,-1,0>,<Width,40,Height>
				texture { Grey50 }
				translate <8*Feet,0,2*Feet>
			}
			#declare RowCount = 0
			#while ( RowCount < 3 )
				#declare ColCount = 0
				#while ( ColCount < 4 )
					box { // window cutouts
						<0,0,0>,<26,20,50>
						texture { GreyBricks1 }
						translate <16+ColCount*4.8*Feet,-.1,12*Feet+RowCount*8.5*Feet>
					}
					#declare ColCount = ColCount + 1
				#end
			#declare RowCount = RowCount + 1
			#end
		} // end difference
		box { // all upper windows
			<0,0,0>,<21*Feet,31.8*Feet,27*Feet>
			texture { JustGlass }
			translate <6,1,10*Feet>
		}
		object { DownSpout rotate <0,0,-90> translate <-7,2*Feet,0> }
		object { GlassDoor translate <2*Feet,8,0> }
		#include "Windows.inc"
		object { BasicWindow translate <8*Feet,-1,2*Feet> }
		box { // slime under window
			<0,0,0>,<Width,1,12>
			texture {
				pigment {
					bozo
					color_map {
						[ 0.00  color rgbt<.20,.20,.20,1> ]
						[ 0.31  color rgbt<.2,.20,.20,1> ]
						[ 0.50  color rgb<0.10,0.08,0.08> ]
						[ 0.69  color rgbt<.2,.2,.2,1> ]
						[ 1.00  color rgbt<.20,.20,.20,1> ]
					}
				}
				normal { bumps .2 scale 1 }
				finish { ambient .02 specular .2 roughness .02 }
				scale <2,2,8>
			}
			translate <8*Feet,-.1,12>
		}
		#declare Roundedness = .3
		object { RoundedBox // front step
			translate <.5,.5,.5> // origin at corner
			scale <3.6*Feet,36,6>
			texture { GreyStone30 }
			translate <1.8*Feet,-14,-2>
		}
		difference {
			box { // lower blocks main
				<0,0,0>,<17*Feet,2,14>
				texture { GreyStone50 }
				translate <5*Feet,-1.6,0>
			}
			box { // hole for vent
				<-.5,-3,0>,<24.5,5,9.8>
				translate <18*Feet,0,3>
				texture { GreyStone50 }
			}
		} // end difference
		object { Vent translate <18*Feet,-1.65,2> }
		box { // lower blocks slanted top edge
			<0,0,0>,<17*Feet,2,2>
			texture { GreyStone50 }
			rotate <-50,0,0>
			translate <5*Feet,-1.6,14>
		}
		box { // coping1
			<-2,0,0>,<22*Feet+2,4,4>
			texture { GreyStone50 }
			translate <0,-1.8,10*Feet>
		}
		box { // coping2
			<-2,0,2>,<22*Feet+2,4,9>
			texture { GreyStone50 }
			translate <0,-0.8,10*Feet>
		}
		#declare Width = 4.5*Feet
		#include "Windows.inc"
		object { Awning translate <1.0*Feet,-2.4*Feet,7.2*Feet> }
		box { // awning mount
			<0,0,0>,<4.8*Feet,4,14>
			texture { Grey40 }
			translate <1*Feet-1,-0.6,7*Feet>
		}
		box { // sign in window
			<0,0,0>,<10,.1,20>
			texture { Grey80 }
			translate <9*Feet,5,5*Feet>
		}
		object { GoodsInWindow translate <8*Feet,6,0> }
	} // end union

//===============================================
//          Store 2
//          Center store with lotsa glass
//===============================================

#declare StoreS2 = // simple version
	union {
		difference {
			box { // outer shell
				<0,0,0>,<21*Feet,36*Feet,38*Feet>
				texture { Grey40 }
			}
			box { // inner shell
				<8,8,2*Feet>,<21*Feet-8,36*Feet-8,38*Feet-8>
				texture { Grey80 }
			}
			box { // doorway
				<0,-1,0>,<5*Feet,5*Feet,7*Feet>
				texture { Grey40 }
				translate <8.0*Feet,0,0>
			}
			#declare Width=6*Feet
			#declare Height=5.0*Feet
			box { // picture window cutout LH
				<0,-1,0>,<Width,40,Height>
				texture { Grey50 }
				translate <1.7*Feet,0,2*Feet>
			}
			box { // picture window cutout RH
				<0,-1,0>,<Width,40,Height>
				texture { Grey50 }
				translate <13.3*Feet,0,2*Feet>
			}
			#declare RowCount = 0
			#while ( RowCount < 3 )
				#declare ColCount = 0
				#while ( ColCount < 3 )
					box { // window cutouts
						<0,0,0>,<44,20,46>
						texture { GreyBricks1 }
						translate <36+ColCount*5.2*Feet,-.1,13.6*Feet+RowCount*10.3*Feet>
					}
					#declare ColCount = ColCount + 1
				#end
			#declare RowCount = RowCount + 1
			#end
		} // end difference
		box { // all upper windows
			<0,0,0>,<20*Feet,35.8*Feet,27*Feet>
			texture { JustGlass }
			translate <6,1,10*Feet>
		}
		box { // floor divider
			<-1,0,0>,<21*Feet+1,5,4>
			texture { GreyStone40 }
			translate <0,-1,10*Feet>
		}
		object { GlassDoor translate <11.5*Feet-3.5/2*Feet,4.5*Feet,0> }
		#include "Windows.inc"
		object { BasicWindow translate <1.7*Feet,0,2*Feet> } // LH
		object { BasicWindow translate <13.3*Feet,0,2*Feet> } // RH
		object { BasicWindow rotate z*90 translate <8*Feet,4,2*Feet> } // doorway LH
		object { BasicWindow rotate z*90 translate <13*Feet,4,2*Feet> } // doorway RH
	}

//----------- Store2 (complex version) -------------------
#declare Store2 =
	union {
		difference {
			box { // outer shell
				<0,0,0>,<21*Feet,36*Feet,38*Feet>
				texture { Grey40 }
			}
			box { // inner shell
				<8,8,2*Feet>,<21*Feet-8,36*Feet-8,38*Feet-8>
				texture { Grey80 }
			}
			box { // doorway
				<0,-1,0>,<5*Feet,5*Feet,7*Feet>
				texture { Grey40 }
				translate <8.0*Feet,0,0>
			}
			#declare Width=6*Feet
			#declare Height=5.0*Feet
			box { // picture window cutout LH
				<0,-1,0>,<Width,40,Height>
				texture { Grey50 }
				translate <1.7*Feet,0,2*Feet>
			}
			box { // picture window cutout RH
				<0,-1,0>,<Width,40,Height>
				texture { Grey50 }
				translate <13.3*Feet,0,2*Feet>
			}
			#declare RowCount = 0
			#while ( RowCount < 3 )
				#declare ColCount = 0
				#while ( ColCount < 3 )
					box { // window cutouts
						<0,0,0>,<44,20,46>
						texture { GreyBricks1 }
						translate <36+ColCount*5.2*Feet,-.1,13.6*Feet+RowCount*10.3*Feet>
					}
					#declare ColCount = ColCount + 1
				#end
			#declare RowCount = RowCount + 1
			#end
		} // end difference
		box { // all upper windows
			<0,0,0>,<20*Feet,35.8*Feet,27*Feet>
			texture { JustGlass }
			translate <6,1,10*Feet>
		}
		box { // coping
			<-1,0,0>,<21*Feet+1,5,4>
			texture { GreyStone40 }
			translate <0,-1,10*Feet>
		}
		object { GlassDoor translate <11.5*Feet-3.5/2*Feet,4.5*Feet,0> }
		#include "Windows.inc"
		object { BasicWindow translate <1.7*Feet,0,2*Feet> } // LH
		object { BasicWindow translate <13.3*Feet,0,2*Feet> } // RH
		object { BasicWindow rotate z*90 translate <8*Feet,4,2*Feet> } // doorway LH
		object { BasicWindow rotate z*90 translate <13*Feet,4,2*Feet> } // doorway RH
		#declare Width = 8*Feet
		#include "Windows.inc"
		object { Awning translate <6.5*Feet,-4*Feet,7.2*Feet> }
	} // end union

//===============================================
//             Residence 1
//===============================================

#declare ResidenceS1 = // simple version
	union {
		difference {
			box { // outer shell
				<0,0,0>,<18*Feet,36*Feet,42*Feet>
				texture { GreyStone20 }
			}
			box { // inner shell
				<8,8,8>,<18*Feet-8,36*Feet-8,42*Feet-8>
				texture { GreyStone20 }
			}
			box { // doorway
				<0,-1,0>,<3*Feet,12,7*Feet>
				texture { GreyStone20 }
				translate <7.5*Feet,0,0>
			}
			#declare Width=3.5*Feet
			#declare Height=4.4*Feet
			box { // LH window cutout
				<0,-1,0>,<Width,40,Height>
				texture { GreyStone20 }
				translate <2*Feet,0,3*Feet>
			}
			box { // RH window cutout
				<0,-1,0>,<Width,40,Height>
				texture { GreyStone20 }
				translate <13.5*Feet,0,3*Feet>
			}
			#declare RowCount = 0
			#while ( RowCount < 3 )
				#declare ColCount = 0
				#while ( ColCount < 3 )
					box { // window cutouts
						<0,0,0>,<30,20,48>
						texture { GreyStone20 }
						translate <30+ColCount*5*Feet,-.1,13*Feet+RowCount*10*Feet>
					}
					#declare ColCount = ColCount + 1
				#end
			#declare RowCount = RowCount + 1
			#end
		} // end difference
		box { // all upper windows
			<0,0,0>,<17*Feet,35.8*Feet,31*Feet>
			texture { JustGlass }
			translate <6,1,10*Feet>
		}
		#include "Windows.inc"
		object { BasicWindow translate <2*Feet,0,3*Feet> } // lower window LH
		object { BasicWindow translate <13.5*Feet,0,3*Feet> } // lower window RH
		box { // doorway lintel
			<0,0,0>,<42,20,6>
			texture { GreyStone50 }
			translate <7.5*Feet-3,-.5,6.9*Feet>
		}
		box { // cornice
			<-1,0,0>,<18*Feet+1,20,6>
			texture { GreyStone50 }
			translate <0,-1.5,9.6*Feet>
		}
	}

//----------- Residence1 (complex version) -------------------
#declare Residence1 = // complex version
	union {
		difference {
			box { // outer shell
				<0,0,0>,<18*Feet,36*Feet,42*Feet>
				texture { GreyBricks1 }
			}
			box { // inner shell
				<8,8,8>,<18*Feet-8,36*Feet-8,42*Feet-8>
				texture { GreyBricks1 }
			}
			box { // doorway
				<0,-1,0>,<3*Feet,12,7*Feet>
				texture { GreyBricks1 }
				translate <7.5*Feet,0,0>
			}
			#declare Width=3.5*Feet
			#declare Height=4.4*Feet
			box { // LH window cutout
				<0,-1,0>,<Width,40,Height>
				texture { GreyBricks1 }
				translate <2*Feet,0,3*Feet>
			}
			box { // RH window cutout
				<0,-1,0>,<Width,40,Height>
				texture { GreyBricks1 }
				translate <13.5*Feet,0,3*Feet>
			}
		} // end difference
		#include "Windows.inc"
		object { BasicWindow translate <2*Feet,.2,3*Feet> } // LH
		object { BasicWindow translate <13.5*Feet,.2,3*Feet> } // RH
		box { // windowsill LH
			<0,0,0>,<Width,8,1>
			texture { Grey50 }
			translate <2*Feet,-1.2,3*Feet>
		}
		difference {
			#declare Roundedness = .4
			object { RoundedBox // front step
				translate <.5,.5,.5> // center corner on origin
				scale <2.95*Feet,36,7> // scale it up
				texture { GreyStone50 }
//				texture { TestWhite }
				translate <7.55*Feet,-8,-1>
			}
			height_field { // creates broken section
				png "Dent1HF.png"
				rotate x*90 // set up for RH coordinate system
				translate <-.5,.5,0> //center on origin
				scale <20,20,8> // scale it up
				rotate y*-180
				translate <37,0,7.5>
				translate <7.55*Feet,-8,-1>
				texture { GreyStone50 }
			}
		} // end difference
		box { // doormat
			<0,0,0>,<2*Feet,30,.7>
			texture { Grey10 }
			rotate <0,0,-1.5>
			translate <7.55*Feet+6,-3,5.9>
		}
		box { // slime at base of bricks
			<0,0,0>,<7.6*Feet,1,8>
			texture {
				pigment {
					gradient z
					color_map {
						[ 0.0  color rgbt<.10,.10,.10,.2> ]
						[ 1.0  color rgbt<0.10,.09,.09,1> ]
					}
					turbulence .15
					scale <1,1,8>
				}
				normal { bumps .2 scale 1 }
				finish { ambient .02 specular .2 roughness .02 }
			}
			translate <0,-.1,0>
		}
		box { // upper doorway block
			<0,0,0>,<4.0*Feet,36,5>
			texture { GreyStone20 scale <2,2,6> }
			translate <7.0*Feet,-6,6.9*Feet>
		}
		box { // upper doorway roof
			<-.5,-.5,4.95>,<4.0*Feet+.5,36,5.25>
			texture { GreyTin20 scale <2,2,6> }
			translate <7.0*Feet,-6,6.9*Feet>
		}
		box { // upper doorway tin plating
			<-.15,-.15,4.05>,<4.0*Feet+.15,36,5.0>
			texture { GreyTin20 scale <2,2,6> }
			translate <7.0*Feet,-6,6.9*Feet>
		}
		box { // coping
			<-2,0,0>,<22*Feet+2,4,7>
			texture { GreyStone30 }
			translate <0,-0.8,11*Feet>
		}
		object { DownSpout translate <4,-5.25,0> }
	}

//===============================================
//             Bar 1
//===============================================

#declare BarS1 = // simple version
	union {
		difference {
			box { // outer shell
				<0,0,0>,<28*Feet,48*Feet,23*Feet>
				texture { GreyBricks2 }
			}
			box { // inner shell
				<8,8,8>,<28*Feet-8,48*Feet-8,23*Feet-8>
				texture { GreyBricks2 }
			}
			box { // doorway
				<0,-1,0>,<3*Feet,12,7*Feet>
				texture { GreyBricks2 }
				translate <7.5*Feet,0,0>
			}
			#declare Width=3.5*Feet
			#declare Height=4.4*Feet
			box { // LH window cutout
				<0,-1,0>,<Width,40,Height>
				texture { GreyBricks2 }
				translate <2*Feet,0,3*Feet>
			}
			#declare Width=8.0*Feet
			#declare Height=4.4*Feet
			box { // RH window cutout
				<0,-1,0>,<Width,40,Height>
				texture { GreyBricks2 }
				translate <13.5*Feet,0,3*Feet>
			}
		} // end difference
		#declare Width=3.5*Feet
		#declare Height=4.4*Feet
		#include "Windows.inc"
		object { BasicWindow translate <2*Feet,-.4,3*Feet> } // LH
		#declare Width=8.0*Feet
		#declare Height=4.4*Feet
		#include "Windows.inc"
		object { BasicWindow translate <13.5*Feet,-.4,3*Feet> } // RH
		box { // window divider
			<-1.6,0,-1>,<1.6,4,Height+1>
			texture { Grey20 }
			translate <13.5*Feet+Width/2,1,3*Feet>
		}
		box { // door
			<0,0,0>,<3*Feet,4,7*Feet>
			texture { Grey20 }
			translate <7.5*Feet,6,0>
		}
		box { // cornice
			<-2,0,0>,<28*Feet+2,24,9>
			translate <0,-2,22.7*Feet>
			texture { Grey50 }
		}
	} // end union

//===============================================
//             Building Groups
//===============================================

//--------- Simple Buildings ------------------
#declare BlockOBuildingsS1 = // along x-axis
	union {
		object { SideWalkS }
		object { StoreS1 translate <0,6,0> }
		object { ResidenceS1 translate <23*Feet,12,0> }
		object { BarS1 translate <44*Feet,3*Feet,0> }
		object { StoreS2 translate <74*Feet,1*Feet,0> }
	} // end union

#declare BlockOBuildingsS2 = // along x-axis
	union {
		object { SideWalkS }
		object { ResidenceS1 translate <0*Feet,6,0> }
		object { ResidenceS1 translate <19*Feet,18,0> }
		object { StoreS1 translate <41*Feet,3*Feet,0> }
		object { StoreS2 translate <64*Feet,1*Feet,0> }
	} // end union

//--------- Mixed Complexity Buildings ------------------
#declare BlockOBuildingsM1 = // along x-axis
	union {
		object { SideWalkS }
		object { StoreS1 translate <0,6,0> }
		object { ResidenceS1 translate <23*Feet,12,0> }
		object { BarS1 translate <44*Feet,3*Feet,0> }
		object { Store2 translate <74*Feet,1*Feet,0> }
	} // end union

#declare BlockOBuildingsM2 = // along x-axis
	union {
		object { SideWalkS }
		object { ResidenceS1 translate <0*Feet,6,0> }
		object { ResidenceS1 translate <19*Feet,18,0> }
		object { StoreS1 translate <41*Feet,3*Feet,0> }
		object { Store2 translate <64*Feet,1*Feet,0> }
	} // end union

//--------- Highly Complex Buildings ------------------
#declare BlockOBuildings1 = // along x-axis
	union {
		object { SideWalk }
		object { Store1 translate <0,6,0> }
		object { Residence1 translate <23*Feet,12,0> }
		object { BarS1 translate <44*Feet,3*Feet,0> }
		object { StoreS2 translate <74*Feet,1*Feet,0> }
	} // end union

