
// Glenn's Rain POV-Ray Object File
// This file does not render.  #include "Rain.inc" in another .pov file
// first concept 20-Sep-97  last update 17-Oct-97
// copyright 1997 Glenn McCarter

// Rain, drips, and various puddles
// Intended scale is English system (inches)
// Uses RH coord system

// Basic Objects: RainDrop, Drip, Rain

// To use Rain, include the following in your file:
/*
#declare RS = seed(12345) // pick a random seed number
#declare NumDrops = 1000 // total number of raindrops
#declare WhiteRain = 0 // 0 for clear, 1 for white (for quick rendering)
#declare RainScale = 1 // elongation of the drops
#declare RainXAngle = 10 // tilt of the rain
#declare RainYAngle = 0
#declare RainX = 10*Feet // raindrops go in this box
#declare RainY = 10*Feet //
#declare RainZ = 10*Feet //
#include "Rain.inc"
object { Rain }
*/

//================================================================
//      Comment-Out this section -- only used for test renders!
//================================================================

/*
//#include "GRuler.inc"
#include "Colors.inc"
#include "Textures.inc"
#include "GIncludeRH.inc"
#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//	location  <-28, -0, 0> // front view
//  look_at   <0.000, 0.000, 0.000>
//  location  <-0, -12, 0> // side view
//  look_at   <0, 0, 0>
//  location  <-1, -1, 28> // top view
//  look_at   <0.000, 0.000, 4.000>
//  location  <-15, -12, 4> // 3/4 view
//  look_at   <0.000, 0.000, 2.000>
  location  <-15, -12, 8> // 3/4 view, higher up
  look_at   <0.000, 0.000, 0.000>
	angle 40
}
camera { Render_Cam }
sky_sphere {
	pigment {
		gradient z
		color_map {
			[0 color rgb<.62,.62,.8> ]
			[1 color rgb<.1,.1,.9> ]
		}
	}
}
plane { // ground
	z,
	-5
	texture { pigment {color rgb<.7,.65,.26>} }
}

object {StdBulb60Watt translate <-40,80,70> }
object {StdBulb100Watt translate <-100,-60,80> }
//object {StdBulb50Watt translate <-40,80,-70> }
*/

//===============================================
//             Variables
//===============================================

#ifndef ( RS )
#declare RS = seed(32167)
#end
#ifndef ( NumDrops )
	#declare NumDrops = 2000 // Total number of raindrops
#end
#ifndef ( WhiteRain )
	#declare WhiteRain = 0 // 0 for clear, 1 for white (for quicker rendering)
#end
#ifndef ( RainScale )
	#declare RainScale = 2 // elongation of each drop
#end
#ifndef ( RainXAngle )
	#declare RainXAngle = 20 // X-angle of rain
#end
#ifndef ( RainYAngle )
	#declare RainYAngle = 10 // Y-angle of rain
#end
#ifndef ( RainX )
	#declare RainX = 20*Feet // X-size of rainy area
#end
#ifndef ( RainY )
	#declare RainY = 20*Feet // Z-size of rainy area
#end
#ifndef ( RainZ )
	#declare RainZ = 20*Feet // Z-size of rainy area
#end

//===============================================
//             Textures
//===============================================

#switch ( WhiteRain )
#case (1) // make the raindrops white
	#declare Water =
		texture {
			pigment { color rgb<1.5,1.5,1.5> }
			normal { bumps .5 scale <.4,.4,.6> }
			finish { ambient .3 }
		}
#break
#else
	#declare Water =
		texture {
			pigment { color rgbf<1,1,1,.93> }
//			pigment { color rgb<1,1,.1> } // test
			normal { bumps .5 scale <.4,.4,.7> }
//			finish { ambient .02 refraction 1 ior 1.33 } // test with no reflection
//			finish { ambient .02 refraction 1 ior 1.33 reflection .08 }
			finish { ambient .02 specular .9 roughness .002 refraction 1 ior 1.33 reflection .08 } // added specular
		}
#end

#declare BWhite =
	texture {
		pigment { color rgb<1.3,1.3,1.3> }
		normal { bumps .5 scale <.4,.4,.6> }
		finish { ambient .1 }
	}

#declare SimpleWater =
	texture {
		pigment { color rgbf<1,1,1,.9> }
		normal { bumps .5 scale <.4,.4,.7> }
		finish { ambient .02 reflection .4 }
	}

#declare IORWater =
	texture {
		pigment { color rgbf<1,1,1,.7> }
		normal { bumps .5 scale <.4,.4,.6> }
		finish { ambient .02 refraction 1 ior 1.33 reflection .4 }
	}


//===============================================
//             Objects
//===============================================

#declare BT  = 1.01 // Blob Threshold
#declare BRF = 1.0  // Blob Radius Factor
#declare BSF = 1.0  // Blob Strength Factor
#declare BNSF = -0.4 // Negative Strength Factor ( divisor )

#declare RoundDrop =
	sphere {
		<0,0,0>,.1
		texture { Water }
//		texture { SkinTex } // test
	}

#declare RainDrop =
	blob {
		threshold BT
			sphere { // main body
				<0,0,0>,
				BRF*2.0,BSF*1.08
				scale <1,1,2>
				translate <0,0,0>
			}
			cylinder { // upper pull
				<0,0,0>,<0,0,4>
				BRF*1.0, BSF*1.00
				scale <1.0,1.0,1.0>
				translate <0,0,0>
			}
//		texture { IORWater }
//		texture { BWhite }
		texture { Water }
		scale .14
		translate <0,0,0>
	}

#declare Drip =
	blob {
		threshold BT
			sphere { // main body
				<0,0,0>,
				BRF*2.0,BSF*1.08
				scale <1,1,2>
				translate <0,0,0>
			}
			cylinder { // upper pull
				<0,0,0>,<0,0,4>
				BRF*1.0, BSF*1.00
				scale <1.0,1.0,1.0>
				translate <0,0,0>
			}
			sphere { // center squeeze
				<0,0,0>,
				BRF*1.8,BNSF*1.08
				scale <1,1,1>
				translate <0,0,1.3>
			}
		texture { Water }
		scale .14
		translate <0,0,0>
	}
#declare PullingDrip = // double ended
	blob {
		threshold BT
			sphere { // lower body
				<0,0,0>,
				BRF*1.6,BSF*1.6
				scale <1,1,1.2>
				translate <0,0,0>
			}
			sphere { // upper body
				<0,0,0>,
				BRF*1.6,BSF*1.3
				scale <1,1,1.0>
				translate <0,0,2>
			}
//		texture { SkinTex } // test
		texture { Water }
//		scale .14
		scale <.15,.15,.17>
		translate <0,0,-.5>
	}

#declare AboutToDrip = // just ready to separate
	blob {
		threshold BT
			sphere { // lower body
				<0,0,0>,
				BRF*1.6,BSF*1.6
				scale <1,1,1.0>
				translate <0,0,0>
			}
			sphere { // upper body
				<0,0,0>,
				BRF*1.6,BSF*1.3
				scale <1,1,1.0>
				translate <0,0,2>
			}
//		texture { SkinTex } // test
		texture { Water }
//		scale .14
		scale <.2,.2,.3>
		translate <0,0,-.5>
	}


#declare Puddle6 =
	blob {
		threshold BT
			sphere { // main
				<0,0,0>,
				BRF*9.0,BSF*2.0
				scale <1,1,1>
				translate <0,0,0>
			}
			sphere { // big ext -Y
				<0,0,0>,
				BRF*3.0,BSF*2.0
				scale <1,1,1>
				translate <-1,-4,0>
			}
			sphere { // little -y
				<0,0,0>,
				BRF*4.0,BSF*1.0
				scale <1,1,1>
				translate <-4,-7,0>
			}
			sphere { // ext -x
				<0,0,0>,
				BRF*3.0,BSF*0.3
				scale <1,1,1>
				translate <-5,1,0>
			}
//		texture { SkinTex } // test
		texture { Water }
		scale <1,1,.08>
		translate <0,0,0>
	}


//===============================================
//             Rain
//===============================================

#declare RainShower =
	union {
		#declare DropCount = 1
		#while ( DropCount < NumDrops )
			object { RainDrop
				scale <1,1,rand(RS)*RainScale+RainScale/2>
				rotate <RainXAngle,RainYAngle,0>
				translate <rand(RS)*RainX,rand(RS)*RainY,rand(RS)*RainZ>
			}
			#declare DropCount = DropCount + 1
		#end
	}

#declare RainBlock = // for testing
	box {
		<0,0,0>,<RainX,RainY,RainZ>
		texture { pigment { color rgb<.5,.4,1.0> } finish { ambient .3 } }
	}

/*
object { Rain translate <-3*Feet,-3*Feet,0> }
//object { Drip scale 4 translate <1.8,-1,0> } // dripping
//object { RainDrop scale 4 translate <0.6,-1,0> } // raining
//object { RainDrop scale 4 translate <-2.6,-1,0> } // raining
//object { RainDrop scale <1,1,2> translate <-1.2,-1,-1> } // pouring
//object { RainDrop scale <1,1,4> translate <-1.9,-1,-2> } // sleeting
box { <0,0,0>,<2*Feet,3*Feet,4*Feet>translate <18*Feet,-4*Feet,0>
texture {pigment { color rgb<1,.3,.1> } } }
cylinder { <0,0,0>,<0,0,8*Feet>,1*Feet translate <19*Feet,3*Feet,0>
texture {pigment { color rgb<.1,.3,1> } } }
*/

//===============================================
//             TrashCanDrips
//===============================================

#declare RS = seed(31387)
#declare TrashCanDrips =
	union {
	#declare RimDripCount = 0
	#declare RDC = RimDripCount
	#while ( RDC < 12 )
		object { RoundDrop // under rim
			scale <1,1,rand(RS)+.7>
			translate <-TRad-.20,0,rand(RS)*.5+47.5-.2>
			rotate <0,0,rand(RS)*200-60> }
		object { AboutToDrip // under rim
			scale <1,1,rand(RS)+.5>
			translate <-TRad-.10,0,48-.2>
			rotate <0,0,rand(RS)*200-60> }
		object { PullingDrip // under rim
			scale <1,1,rand(RS)+.5>
			translate <-TRad-.20,0,48-.2>
			rotate <0,0,rand(RS)*200-60> }
		#declare RDC = RDC + 1
	#end
	#declare WallDripCount = 0
	#declare WDC = WallDripCount
	#while ( WDC < 100 )
		object { RainDrop // on outer wall
			scale <1,1,rand(RS)/2+.75>
			rotate <0,12,0> // put tail against wall
			translate <-TRad-.2,0,rand(RS)*20+27> // translate to wall
			rotate <0,0,rand(RS)*150-50> } // distribute around
		#declare WDC = WDC + 1
	#end
	#declare InnerWallDripCount = 0
	#declare IWDC = InnerWallDripCount
	#while ( IWDC < 100 )
		object { RainDrop // on inner wall
			scale <1,1,rand(RS)/2+.75>
			translate <-TRad+.4,0,rand(RS)*7+40.5>
			rotate <0,0,rand(RS)*160-240> }
		#declare IWDC = IWDC + 1
	#end
	} // end union

